/*
 * Decompiled with CFR 0.152.
 */
package com.android.dx.io;

import com.android.dex.ClassDef;
import com.android.dex.Dex;
import com.android.dex.FieldId;
import com.android.dex.MethodId;
import com.android.dex.ProtoId;
import com.android.dex.TableOfContents;
import java.io.File;
import java.io.IOException;

public final class DexIndexPrinter {
    private final Dex dex;
    private final TableOfContents tableOfContents;

    public DexIndexPrinter(File file) throws IOException {
        this.dex = new Dex(file);
        this.tableOfContents = this.dex.getTableOfContents();
    }

    private void printMap() {
        for (TableOfContents.Section section : this.tableOfContents.sections) {
            if (section.off == -1) continue;
            System.out.println("section " + Integer.toHexString(section.type) + " off=" + Integer.toHexString(section.off) + " size=" + Integer.toHexString(section.size) + " byteCount=" + Integer.toHexString(section.byteCount));
        }
    }

    private void printStrings() throws IOException {
        int n = 0;
        for (String string : this.dex.strings()) {
            System.out.println("string " + n + ": " + string);
            ++n;
        }
    }

    private void printTypeIds() throws IOException {
        int n = 0;
        for (Integer n2 : this.dex.typeIds()) {
            System.out.println("type " + n + ": " + this.dex.strings().get(n2));
            ++n;
        }
    }

    private void printProtoIds() throws IOException {
        int n = 0;
        for (ProtoId protoId : this.dex.protoIds()) {
            System.out.println("proto " + n + ": " + protoId);
            ++n;
        }
    }

    private void printFieldIds() throws IOException {
        int n = 0;
        for (FieldId fieldId : this.dex.fieldIds()) {
            System.out.println("field " + n + ": " + fieldId);
            ++n;
        }
    }

    private void printMethodIds() throws IOException {
        int n = 0;
        for (MethodId methodId : this.dex.methodIds()) {
            System.out.println("methodId " + n + ": " + methodId);
            ++n;
        }
    }

    private void printTypeLists() throws IOException {
        if (this.tableOfContents.typeLists.off == -1) {
            System.out.println("No type lists");
            return;
        }
        Dex.Section section = this.dex.open(this.tableOfContents.typeLists.off);
        for (int i = 0; i < this.tableOfContents.typeLists.size; ++i) {
            int n = section.readInt();
            System.out.print("Type list i=" + i + ", size=" + n + ", elements=");
            for (int j = 0; j < n; ++j) {
                System.out.print(" " + this.dex.typeNames().get(section.readShort()));
            }
            if (n % 2 == 1) {
                section.readShort();
            }
            System.out.println();
        }
    }

    private void printClassDefs() {
        int n = 0;
        for (ClassDef classDef : this.dex.classDefs()) {
            System.out.println("class def " + n + ": " + classDef);
            ++n;
        }
    }

    public static void main(String[] stringArray) throws IOException {
        DexIndexPrinter dexIndexPrinter = new DexIndexPrinter(new File(stringArray[0]));
        dexIndexPrinter.printMap();
        dexIndexPrinter.printStrings();
        dexIndexPrinter.printTypeIds();
        dexIndexPrinter.printProtoIds();
        dexIndexPrinter.printFieldIds();
        dexIndexPrinter.printMethodIds();
        dexIndexPrinter.printTypeLists();
        dexIndexPrinter.printClassDefs();
    }
}

