/*
 * Decompiled with CFR 0.152.
 */
package com.android.dx.dex.file;

import com.android.dx.dex.file.DexFile;
import com.android.dx.dex.file.IndexedItem;
import com.android.dx.dex.file.ItemType;
import com.android.dx.dex.file.MixedItemSection;
import com.android.dx.dex.file.StringDataItem;
import com.android.dx.rop.cst.CstString;
import com.android.dx.util.AnnotatedOutput;
import com.android.dx.util.Hex;

public final class StringIdItem
extends IndexedItem
implements Comparable {
    private final CstString value;
    private StringDataItem data;

    public StringIdItem(CstString cstString) {
        if (cstString == null) {
            throw new NullPointerException("value == null");
        }
        this.value = cstString;
        this.data = null;
    }

    public boolean equals(Object object) {
        if (!(object instanceof StringIdItem)) {
            return false;
        }
        StringIdItem stringIdItem = (StringIdItem)object;
        return this.value.equals(stringIdItem.value);
    }

    public int hashCode() {
        return this.value.hashCode();
    }

    public int compareTo(Object object) {
        StringIdItem stringIdItem = (StringIdItem)object;
        return this.value.compareTo(stringIdItem.value);
    }

    @Override
    public ItemType itemType() {
        return ItemType.TYPE_STRING_ID_ITEM;
    }

    @Override
    public int writeSize() {
        return 4;
    }

    @Override
    public void addContents(DexFile dexFile) {
        if (this.data == null) {
            MixedItemSection mixedItemSection = dexFile.getStringData();
            this.data = new StringDataItem(this.value);
            mixedItemSection.add(this.data);
        }
    }

    @Override
    public void writeTo(DexFile dexFile, AnnotatedOutput annotatedOutput) {
        int n = this.data.getAbsoluteOffset();
        if (annotatedOutput.annotates()) {
            annotatedOutput.annotate(0, this.indexString() + ' ' + this.value.toQuoted(100));
            annotatedOutput.annotate(4, "  string_data_off: " + Hex.u4(n));
        }
        annotatedOutput.writeInt(n);
    }

    public CstString getValue() {
        return this.value;
    }

    public StringDataItem getData() {
        return this.data;
    }
}

