/*
 * Decompiled with CFR 0.152.
 */
package com.android.dx.dex.file;

import com.android.dx.dex.file.DexFile;
import com.android.dx.dex.file.IndexedItem;
import com.android.dx.dex.file.Item;
import com.android.dx.dex.file.ProtoIdItem;
import com.android.dx.dex.file.UniformItemSection;
import com.android.dx.rop.cst.Constant;
import com.android.dx.rop.type.Prototype;
import com.android.dx.util.AnnotatedOutput;
import com.android.dx.util.Hex;
import java.util.Collection;
import java.util.TreeMap;

public final class ProtoIdsSection
extends UniformItemSection {
    private final TreeMap<Prototype, ProtoIdItem> protoIds = new TreeMap();

    public ProtoIdsSection(DexFile dexFile) {
        super("proto_ids", dexFile, 4);
    }

    @Override
    public Collection<? extends Item> items() {
        return this.protoIds.values();
    }

    @Override
    public IndexedItem get(Constant constant) {
        throw new UnsupportedOperationException("unsupported");
    }

    public void writeHeaderPart(AnnotatedOutput annotatedOutput) {
        int n;
        this.throwIfNotPrepared();
        int n2 = this.protoIds.size();
        int n3 = n = n2 == 0 ? 0 : this.getFileOffset();
        if (n2 > 65536) {
            throw new UnsupportedOperationException("too many proto ids");
        }
        if (annotatedOutput.annotates()) {
            annotatedOutput.annotate(4, "proto_ids_size:  " + Hex.u4(n2));
            annotatedOutput.annotate(4, "proto_ids_off:   " + Hex.u4(n));
        }
        annotatedOutput.writeInt(n2);
        annotatedOutput.writeInt(n);
    }

    public ProtoIdItem intern(Prototype prototype) {
        if (prototype == null) {
            throw new NullPointerException("prototype == null");
        }
        this.throwIfPrepared();
        ProtoIdItem protoIdItem = this.protoIds.get(prototype);
        if (protoIdItem == null) {
            protoIdItem = new ProtoIdItem(prototype);
            this.protoIds.put(prototype, protoIdItem);
        }
        return protoIdItem;
    }

    public int indexOf(Prototype prototype) {
        if (prototype == null) {
            throw new NullPointerException("prototype == null");
        }
        this.throwIfNotPrepared();
        ProtoIdItem protoIdItem = this.protoIds.get(prototype);
        if (protoIdItem == null) {
            throw new IllegalArgumentException("not found");
        }
        return protoIdItem.getIndex();
    }

    @Override
    protected void orderItems() {
        int n = 0;
        for (Item item : this.items()) {
            ((ProtoIdItem)item).setIndex(n);
            ++n;
        }
    }
}

