/*
 * Decompiled with CFR 0.152.
 */
package com.android.dx.dex.file;

import com.android.dex.util.ExceptionWithContext;
import com.android.dx.dex.file.DexFile;
import com.android.dx.dex.file.Item;
import com.android.dx.dex.file.ItemType;
import com.android.dx.dex.file.OffsettedItem;
import com.android.dx.dex.file.Section;
import com.android.dx.util.AnnotatedOutput;
import com.android.dx.util.Hex;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.TreeMap;

public final class MixedItemSection
extends Section {
    private static final Comparator<OffsettedItem> TYPE_SORTER = new Comparator<OffsettedItem>(){

        @Override
        public int compare(OffsettedItem offsettedItem, OffsettedItem offsettedItem2) {
            ItemType itemType = offsettedItem.itemType();
            ItemType itemType2 = offsettedItem2.itemType();
            return itemType.compareTo(itemType2);
        }
    };
    private final ArrayList<OffsettedItem> items = new ArrayList(100);
    private final HashMap<OffsettedItem, OffsettedItem> interns = new HashMap(100);
    private final SortType sort;
    private int writeSize;

    public MixedItemSection(String string, DexFile dexFile, int n, SortType sortType) {
        super(string, dexFile, n);
        this.sort = sortType;
        this.writeSize = -1;
    }

    @Override
    public Collection<? extends Item> items() {
        return this.items;
    }

    @Override
    public int writeSize() {
        this.throwIfNotPrepared();
        return this.writeSize;
    }

    @Override
    public int getAbsoluteItemOffset(Item item) {
        OffsettedItem offsettedItem = (OffsettedItem)item;
        return offsettedItem.getAbsoluteOffset();
    }

    public int size() {
        return this.items.size();
    }

    public void writeHeaderPart(AnnotatedOutput annotatedOutput) {
        this.throwIfNotPrepared();
        if (this.writeSize == -1) {
            throw new RuntimeException("write size not yet set");
        }
        int n = this.writeSize;
        int n2 = n == 0 ? 0 : this.getFileOffset();
        String string = this.getName();
        if (string == null) {
            string = "<unnamed>";
        }
        int n3 = 15 - string.length();
        char[] cArray = new char[n3];
        Arrays.fill(cArray, ' ');
        String string2 = new String(cArray);
        if (annotatedOutput.annotates()) {
            annotatedOutput.annotate(4, string + "_size:" + string2 + Hex.u4(n));
            annotatedOutput.annotate(4, string + "_off: " + string2 + Hex.u4(n2));
        }
        annotatedOutput.writeInt(n);
        annotatedOutput.writeInt(n2);
    }

    public void add(OffsettedItem offsettedItem) {
        this.throwIfPrepared();
        try {
            if (offsettedItem.getAlignment() > this.getAlignment()) {
                throw new IllegalArgumentException("incompatible item alignment");
            }
        }
        catch (NullPointerException nullPointerException) {
            throw new NullPointerException("item == null");
        }
        this.items.add(offsettedItem);
    }

    public <T extends OffsettedItem> T intern(T t) {
        this.throwIfPrepared();
        OffsettedItem offsettedItem = this.interns.get(t);
        if (offsettedItem != null) {
            return (T)offsettedItem;
        }
        this.add(t);
        this.interns.put(t, t);
        return t;
    }

    public <T extends OffsettedItem> T get(T t) {
        this.throwIfNotPrepared();
        OffsettedItem offsettedItem = this.interns.get(t);
        if (offsettedItem != null) {
            return (T)offsettedItem;
        }
        throw new NoSuchElementException(t.toString());
    }

    public void writeIndexAnnotation(AnnotatedOutput annotatedOutput, ItemType itemType, String string) {
        String string2;
        this.throwIfNotPrepared();
        TreeMap<String, OffsettedItem> treeMap = new TreeMap<String, OffsettedItem>();
        for (OffsettedItem object : this.items) {
            if (object.itemType() != itemType) continue;
            string2 = object.toHuman();
            treeMap.put(string2, object);
        }
        if (treeMap.size() == 0) {
            return;
        }
        annotatedOutput.annotate(0, string);
        for (Map.Entry entry : treeMap.entrySet()) {
            string2 = (String)entry.getKey();
            OffsettedItem offsettedItem = (OffsettedItem)entry.getValue();
            annotatedOutput.annotate(0, offsettedItem.offsetString() + ' ' + string2 + '\n');
        }
    }

    @Override
    protected void prepare0() {
        int n;
        DexFile dexFile = this.getFile();
        int n2 = 0;
        while (n2 < (n = this.items.size())) {
            while (n2 < n) {
                OffsettedItem offsettedItem = this.items.get(n2);
                offsettedItem.addContents(dexFile);
                ++n2;
            }
        }
    }

    public void placeItems() {
        this.throwIfNotPrepared();
        switch (this.sort) {
            case INSTANCE: {
                Collections.sort(this.items);
                break;
            }
            case TYPE: {
                Collections.sort(this.items, TYPE_SORTER);
            }
        }
        int n = this.items.size();
        int n2 = 0;
        for (int i = 0; i < n; ++i) {
            OffsettedItem offsettedItem = this.items.get(i);
            try {
                int n3 = offsettedItem.place(this, n2);
                if (n3 < n2) {
                    throw new RuntimeException("bogus place() result for " + offsettedItem);
                }
                n2 = n3 + offsettedItem.writeSize();
                continue;
            }
            catch (RuntimeException runtimeException) {
                throw ExceptionWithContext.withContext(runtimeException, "...while placing " + offsettedItem);
            }
        }
        this.writeSize = n2;
    }

    @Override
    protected void writeTo0(AnnotatedOutput annotatedOutput) {
        boolean bl = annotatedOutput.annotates();
        boolean bl2 = true;
        DexFile dexFile = this.getFile();
        int n = 0;
        for (OffsettedItem offsettedItem : this.items) {
            int n2;
            int n3;
            if (bl) {
                if (bl2) {
                    bl2 = false;
                } else {
                    annotatedOutput.annotate(0, "\n");
                }
            }
            if (n != (n3 = n + (n2 = offsettedItem.getAlignment() - 1) & ~n2)) {
                annotatedOutput.writeZeroes(n3 - n);
                n = n3;
            }
            offsettedItem.writeTo(dexFile, annotatedOutput);
            n += offsettedItem.writeSize();
        }
        if (n != this.writeSize) {
            throw new RuntimeException("output size mismatch");
        }
    }

    static enum SortType {
        NONE,
        TYPE,
        INSTANCE;

    }
}

