/*
 * Decompiled with CFR 0.152.
 */
package com.android.dx.dex.file;

import com.android.dx.dex.file.DexFile;
import com.android.dx.dex.file.Item;
import com.android.dx.dex.file.ItemType;
import com.android.dx.dex.file.MixedItemSection;
import com.android.dx.dex.file.OffsettedItem;
import com.android.dx.dex.file.Section;
import com.android.dx.dex.file.UniformListItem;
import com.android.dx.util.AnnotatedOutput;
import com.android.dx.util.Hex;
import java.util.ArrayList;

public final class MapItem
extends OffsettedItem {
    private static final int ALIGNMENT = 4;
    private static final int WRITE_SIZE = 12;
    private final ItemType type;
    private final Section section;
    private final Item firstItem;
    private final Item lastItem;
    private final int itemCount;

    public static void addMap(Section[] sectionArray, MixedItemSection mixedItemSection) {
        if (sectionArray == null) {
            throw new NullPointerException("sections == null");
        }
        if (mixedItemSection.items().size() != 0) {
            throw new IllegalArgumentException("mapSection.items().size() != 0");
        }
        ArrayList<MapItem> arrayList = new ArrayList<MapItem>(50);
        for (Section section : sectionArray) {
            ItemType itemType = null;
            Item item = null;
            Item item2 = null;
            int n = 0;
            for (Item item3 : section.items()) {
                ItemType itemType2 = item3.itemType();
                if (itemType2 != itemType) {
                    if (n != 0) {
                        arrayList.add(new MapItem(itemType, section, item, item2, n));
                    }
                    itemType = itemType2;
                    item = item3;
                    n = 0;
                }
                item2 = item3;
                ++n;
            }
            if (n != 0) {
                arrayList.add(new MapItem(itemType, section, item, item2, n));
                continue;
            }
            if (section != mixedItemSection) continue;
            arrayList.add(new MapItem(mixedItemSection));
        }
        mixedItemSection.add(new UniformListItem(ItemType.TYPE_MAP_LIST, arrayList));
    }

    private MapItem(ItemType itemType, Section section, Item item, Item item2, int n) {
        super(4, 12);
        if (itemType == null) {
            throw new NullPointerException("type == null");
        }
        if (section == null) {
            throw new NullPointerException("section == null");
        }
        if (item == null) {
            throw new NullPointerException("firstItem == null");
        }
        if (item2 == null) {
            throw new NullPointerException("lastItem == null");
        }
        if (n <= 0) {
            throw new IllegalArgumentException("itemCount <= 0");
        }
        this.type = itemType;
        this.section = section;
        this.firstItem = item;
        this.lastItem = item2;
        this.itemCount = n;
    }

    private MapItem(Section section) {
        super(4, 12);
        if (section == null) {
            throw new NullPointerException("section == null");
        }
        this.type = ItemType.TYPE_MAP_LIST;
        this.section = section;
        this.firstItem = null;
        this.lastItem = null;
        this.itemCount = 1;
    }

    @Override
    public ItemType itemType() {
        return ItemType.TYPE_MAP_ITEM;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer(100);
        stringBuffer.append(this.getClass().getName());
        stringBuffer.append('{');
        stringBuffer.append(this.section.toString());
        stringBuffer.append(' ');
        stringBuffer.append(this.type.toHuman());
        stringBuffer.append('}');
        return stringBuffer.toString();
    }

    @Override
    public void addContents(DexFile dexFile) {
    }

    @Override
    public final String toHuman() {
        return this.toString();
    }

    @Override
    protected void writeTo0(DexFile dexFile, AnnotatedOutput annotatedOutput) {
        int n = this.type.getMapValue();
        int n2 = this.firstItem == null ? this.section.getFileOffset() : this.section.getAbsoluteItemOffset(this.firstItem);
        if (annotatedOutput.annotates()) {
            annotatedOutput.annotate(0, this.offsetString() + ' ' + this.type.getTypeName() + " map");
            annotatedOutput.annotate(2, "  type:   " + Hex.u2(n) + " // " + this.type.toString());
            annotatedOutput.annotate(2, "  unused: 0");
            annotatedOutput.annotate(4, "  size:   " + Hex.u4(this.itemCount));
            annotatedOutput.annotate(4, "  offset: " + Hex.u4(n2));
        }
        annotatedOutput.writeShort(n);
        annotatedOutput.writeShort(0);
        annotatedOutput.writeInt(this.itemCount);
        annotatedOutput.writeInt(n2);
    }
}

