/*
 * Decompiled with CFR 0.152.
 */
package com.android.dx.dex.code;

import com.android.dx.dex.code.CodeAddress;
import com.android.dx.dex.code.DalvInsn;
import com.android.dx.dex.code.DalvInsnList;
import com.android.dx.rop.code.SourcePosition;
import com.android.dx.util.FixedSizeList;

public final class PositionList
extends FixedSizeList {
    public static final PositionList EMPTY = new PositionList(0);
    public static final int NONE = 1;
    public static final int LINES = 2;
    public static final int IMPORTANT = 3;

    public static PositionList make(DalvInsnList dalvInsnList, int n) {
        SourcePosition sourcePosition;
        switch (n) {
            case 1: {
                return EMPTY;
            }
            case 2: 
            case 3: {
                break;
            }
            default: {
                throw new IllegalArgumentException("bogus howMuch");
            }
        }
        SourcePosition sourcePosition2 = sourcePosition = SourcePosition.NO_INFO;
        int n2 = dalvInsnList.size();
        Entry[] entryArray = new Entry[n2];
        boolean bl = false;
        int n3 = 0;
        for (int i = 0; i < n2; ++i) {
            DalvInsn dalvInsn = dalvInsnList.get(i);
            if (dalvInsn instanceof CodeAddress) {
                bl = true;
                continue;
            }
            SourcePosition sourcePosition3 = dalvInsn.getPosition();
            if (sourcePosition3.equals(sourcePosition) || sourcePosition3.sameLine(sourcePosition2) || n == 3 && !bl) continue;
            sourcePosition2 = sourcePosition3;
            entryArray[n3] = new Entry(dalvInsn.getAddress(), sourcePosition3);
            ++n3;
            bl = false;
        }
        PositionList positionList = new PositionList(n3);
        for (int i = 0; i < n3; ++i) {
            positionList.set(i, entryArray[i]);
        }
        positionList.setImmutable();
        return positionList;
    }

    public PositionList(int n) {
        super(n);
    }

    public Entry get(int n) {
        return (Entry)this.get0(n);
    }

    public void set(int n, Entry entry) {
        this.set0(n, entry);
    }

    public static class Entry {
        private final int address;
        private final SourcePosition position;

        public Entry(int n, SourcePosition sourcePosition) {
            if (n < 0) {
                throw new IllegalArgumentException("address < 0");
            }
            if (sourcePosition == null) {
                throw new NullPointerException("position == null");
            }
            this.address = n;
            this.position = sourcePosition;
        }

        public int getAddress() {
            return this.address;
        }

        public SourcePosition getPosition() {
            return this.position;
        }
    }
}

