/*
 * Decompiled with CFR 0.152.
 */
package com.android.dx.dex.code;

import com.android.dx.dex.code.CstInsn;
import com.android.dx.dex.code.DalvInsn;
import com.android.dx.dex.code.TargetInsn;
import com.android.dx.rop.code.RegisterSpec;
import com.android.dx.rop.code.RegisterSpecList;
import com.android.dx.rop.cst.Constant;
import com.android.dx.rop.cst.CstInteger;
import com.android.dx.rop.cst.CstKnownNull;
import com.android.dx.rop.cst.CstLiteral64;
import com.android.dx.rop.cst.CstLiteralBits;
import com.android.dx.rop.cst.CstString;
import com.android.dx.util.AnnotatedOutput;
import com.android.dx.util.Hex;
import java.util.BitSet;

public abstract class InsnFormat {
    public static boolean ALLOW_EXTENDED_OPCODES = true;

    public final String listingString(DalvInsn dalvInsn, boolean bl) {
        String string = dalvInsn.getOpcode().getName();
        String string2 = this.insnArgString(dalvInsn);
        String string3 = this.insnCommentString(dalvInsn, bl);
        StringBuilder stringBuilder = new StringBuilder(100);
        stringBuilder.append(string);
        if (string2.length() != 0) {
            stringBuilder.append(' ');
            stringBuilder.append(string2);
        }
        if (string3.length() != 0) {
            stringBuilder.append(" // ");
            stringBuilder.append(string3);
        }
        return stringBuilder.toString();
    }

    public abstract String insnArgString(DalvInsn var1);

    public abstract String insnCommentString(DalvInsn var1, boolean var2);

    public abstract int codeSize();

    public abstract boolean isCompatible(DalvInsn var1);

    public BitSet compatibleRegs(DalvInsn dalvInsn) {
        return new BitSet();
    }

    public boolean branchFits(TargetInsn targetInsn) {
        return false;
    }

    public abstract void writeTo(AnnotatedOutput var1, DalvInsn var2);

    protected static String regListString(RegisterSpecList registerSpecList) {
        int n = registerSpecList.size();
        StringBuffer stringBuffer = new StringBuffer(n * 5 + 2);
        stringBuffer.append('{');
        for (int i = 0; i < n; ++i) {
            if (i != 0) {
                stringBuffer.append(", ");
            }
            stringBuffer.append(registerSpecList.get(i).regString());
        }
        stringBuffer.append('}');
        return stringBuffer.toString();
    }

    protected static String regRangeString(RegisterSpecList registerSpecList) {
        int n = registerSpecList.size();
        StringBuilder stringBuilder = new StringBuilder(30);
        stringBuilder.append("{");
        switch (n) {
            case 0: {
                break;
            }
            case 1: {
                stringBuilder.append(registerSpecList.get(0).regString());
                break;
            }
            default: {
                RegisterSpec registerSpec = registerSpecList.get(n - 1);
                if (registerSpec.getCategory() == 2) {
                    registerSpec = registerSpec.withOffset(1);
                }
                stringBuilder.append(registerSpecList.get(0).regString());
                stringBuilder.append("..");
                stringBuilder.append(registerSpec.regString());
            }
        }
        stringBuilder.append("}");
        return stringBuilder.toString();
    }

    protected static String literalBitsString(CstLiteralBits cstLiteralBits) {
        StringBuffer stringBuffer = new StringBuffer(100);
        stringBuffer.append('#');
        if (cstLiteralBits instanceof CstKnownNull) {
            stringBuffer.append("null");
        } else {
            stringBuffer.append(cstLiteralBits.typeName());
            stringBuffer.append(' ');
            stringBuffer.append(cstLiteralBits.toHuman());
        }
        return stringBuffer.toString();
    }

    protected static String literalBitsComment(CstLiteralBits cstLiteralBits, int n) {
        StringBuffer stringBuffer = new StringBuffer(20);
        stringBuffer.append("#");
        long l = cstLiteralBits instanceof CstLiteral64 ? ((CstLiteral64)cstLiteralBits).getLongBits() : (long)cstLiteralBits.getIntBits();
        switch (n) {
            case 4: {
                stringBuffer.append(Hex.uNibble((int)l));
                break;
            }
            case 8: {
                stringBuffer.append(Hex.u1((int)l));
                break;
            }
            case 16: {
                stringBuffer.append(Hex.u2((int)l));
                break;
            }
            case 32: {
                stringBuffer.append(Hex.u4((int)l));
                break;
            }
            case 64: {
                stringBuffer.append(Hex.u8(l));
                break;
            }
            default: {
                throw new RuntimeException("shouldn't happen");
            }
        }
        return stringBuffer.toString();
    }

    protected static String branchString(DalvInsn dalvInsn) {
        TargetInsn targetInsn = (TargetInsn)dalvInsn;
        int n = targetInsn.getTargetAddress();
        return n == (char)n ? Hex.u2(n) : Hex.u4(n);
    }

    protected static String branchComment(DalvInsn dalvInsn) {
        TargetInsn targetInsn = (TargetInsn)dalvInsn;
        int n = targetInsn.getTargetOffset();
        return n == (short)n ? Hex.s2(n) : Hex.s4(n);
    }

    protected static String cstString(DalvInsn dalvInsn) {
        CstInsn cstInsn = (CstInsn)dalvInsn;
        Constant constant = cstInsn.getConstant();
        return constant instanceof CstString ? ((CstString)constant).toQuoted() : constant.toHuman();
    }

    protected static String cstComment(DalvInsn dalvInsn) {
        CstInsn cstInsn = (CstInsn)dalvInsn;
        if (!cstInsn.hasIndex()) {
            return "";
        }
        StringBuilder stringBuilder = new StringBuilder(20);
        int n = cstInsn.getIndex();
        stringBuilder.append(cstInsn.getConstant().typeName());
        stringBuilder.append('@');
        if (n < 65536) {
            stringBuilder.append(Hex.u2(n));
        } else {
            stringBuilder.append(Hex.u4(n));
        }
        return stringBuilder.toString();
    }

    protected static boolean signedFitsInNibble(int n) {
        return n >= -8 && n <= 7;
    }

    protected static boolean unsignedFitsInNibble(int n) {
        return n == (n & 0xF);
    }

    protected static boolean signedFitsInByte(int n) {
        return (byte)n == n;
    }

    protected static boolean unsignedFitsInByte(int n) {
        return n == (n & 0xFF);
    }

    protected static boolean signedFitsInShort(int n) {
        return (short)n == n;
    }

    protected static boolean unsignedFitsInShort(int n) {
        return n == (n & 0xFFFF);
    }

    protected static boolean isRegListSequential(RegisterSpecList registerSpecList) {
        int n;
        int n2 = registerSpecList.size();
        if (n2 < 2) {
            return true;
        }
        int n3 = n = registerSpecList.get(0).getReg();
        for (int i = 0; i < n2; ++i) {
            RegisterSpec registerSpec = registerSpecList.get(i);
            if (registerSpec.getReg() != n3) {
                return false;
            }
            n3 += registerSpec.getCategory();
        }
        return true;
    }

    protected static int argIndex(DalvInsn dalvInsn) {
        int n = ((CstInteger)((CstInsn)dalvInsn).getConstant()).getValue();
        if (n < 0) {
            throw new IllegalArgumentException("bogus insn");
        }
        return n;
    }

    protected static short opcodeUnit(DalvInsn dalvInsn, int n) {
        if ((n & 0xFF) != n) {
            throw new IllegalArgumentException("arg out of range 0..255");
        }
        int n2 = dalvInsn.getOpcode().getOpcode();
        if ((n2 & 0xFF) != n2) {
            throw new IllegalArgumentException("opcode out of range 0..255");
        }
        return (short)(n2 | n << 8);
    }

    protected static short opcodeUnit(DalvInsn dalvInsn) {
        int n = dalvInsn.getOpcode().getOpcode();
        if (n < 256 || n > 65535) {
            throw new IllegalArgumentException("opcode out of range 0..65535");
        }
        return (short)n;
    }

    protected static short codeUnit(int n, int n2) {
        if ((n & 0xFF) != n) {
            throw new IllegalArgumentException("low out of range 0..255");
        }
        if ((n2 & 0xFF) != n2) {
            throw new IllegalArgumentException("high out of range 0..255");
        }
        return (short)(n | n2 << 8);
    }

    protected static short codeUnit(int n, int n2, int n3, int n4) {
        if ((n & 0xF) != n) {
            throw new IllegalArgumentException("n0 out of range 0..15");
        }
        if ((n2 & 0xF) != n2) {
            throw new IllegalArgumentException("n1 out of range 0..15");
        }
        if ((n3 & 0xF) != n3) {
            throw new IllegalArgumentException("n2 out of range 0..15");
        }
        if ((n4 & 0xF) != n4) {
            throw new IllegalArgumentException("n3 out of range 0..15");
        }
        return (short)(n | n2 << 4 | n3 << 8 | n4 << 12);
    }

    protected static int makeByte(int n, int n2) {
        if ((n & 0xF) != n) {
            throw new IllegalArgumentException("low out of range 0..15");
        }
        if ((n2 & 0xF) != n2) {
            throw new IllegalArgumentException("high out of range 0..15");
        }
        return n | n2 << 4;
    }

    protected static void write(AnnotatedOutput annotatedOutput, short s) {
        annotatedOutput.writeShort(s);
    }

    protected static void write(AnnotatedOutput annotatedOutput, short s, short s2) {
        annotatedOutput.writeShort(s);
        annotatedOutput.writeShort(s2);
    }

    protected static void write(AnnotatedOutput annotatedOutput, short s, short s2, short s3) {
        annotatedOutput.writeShort(s);
        annotatedOutput.writeShort(s2);
        annotatedOutput.writeShort(s3);
    }

    protected static void write(AnnotatedOutput annotatedOutput, short s, short s2, short s3, short s4) {
        annotatedOutput.writeShort(s);
        annotatedOutput.writeShort(s2);
        annotatedOutput.writeShort(s3);
        annotatedOutput.writeShort(s4);
    }

    protected static void write(AnnotatedOutput annotatedOutput, short s, short s2, short s3, short s4, short s5) {
        annotatedOutput.writeShort(s);
        annotatedOutput.writeShort(s2);
        annotatedOutput.writeShort(s3);
        annotatedOutput.writeShort(s4);
        annotatedOutput.writeShort(s5);
    }

    protected static void write(AnnotatedOutput annotatedOutput, short s, int n) {
        InsnFormat.write(annotatedOutput, s, (short)n, (short)(n >> 16));
    }

    protected static void write(AnnotatedOutput annotatedOutput, short s, int n, short s2) {
        InsnFormat.write(annotatedOutput, s, (short)n, (short)(n >> 16), s2);
    }

    protected static void write(AnnotatedOutput annotatedOutput, short s, int n, short s2, short s3) {
        InsnFormat.write(annotatedOutput, s, (short)n, (short)(n >> 16), s2, s3);
    }

    protected static void write(AnnotatedOutput annotatedOutput, short s, long l) {
        InsnFormat.write(annotatedOutput, s, (short)l, (short)(l >> 16), (short)(l >> 32), (short)(l >> 48));
    }
}

