/*
 * Decompiled with CFR 0.152.
 */
package com.android.dx.dex.code;

import com.android.dx.dex.code.DalvInsn;
import com.android.dx.dex.code.Dop;
import com.android.dx.dex.code.FixedSizeInsn;
import com.android.dx.rop.code.RegisterSpecList;
import com.android.dx.rop.code.SourcePosition;
import com.android.dx.rop.cst.Constant;

public final class CstInsn
extends FixedSizeInsn {
    private final Constant constant;
    private int index;
    private int classIndex;

    public CstInsn(Dop dop, SourcePosition sourcePosition, RegisterSpecList registerSpecList, Constant constant) {
        super(dop, sourcePosition, registerSpecList);
        if (constant == null) {
            throw new NullPointerException("constant == null");
        }
        this.constant = constant;
        this.index = -1;
        this.classIndex = -1;
    }

    @Override
    public DalvInsn withOpcode(Dop dop) {
        CstInsn cstInsn = new CstInsn(dop, this.getPosition(), this.getRegisters(), this.constant);
        if (this.index >= 0) {
            cstInsn.setIndex(this.index);
        }
        if (this.classIndex >= 0) {
            cstInsn.setClassIndex(this.classIndex);
        }
        return cstInsn;
    }

    @Override
    public DalvInsn withRegisters(RegisterSpecList registerSpecList) {
        CstInsn cstInsn = new CstInsn(this.getOpcode(), this.getPosition(), registerSpecList, this.constant);
        if (this.index >= 0) {
            cstInsn.setIndex(this.index);
        }
        if (this.classIndex >= 0) {
            cstInsn.setClassIndex(this.classIndex);
        }
        return cstInsn;
    }

    public Constant getConstant() {
        return this.constant;
    }

    public int getIndex() {
        if (this.index < 0) {
            throw new RuntimeException("index not yet set for " + this.constant);
        }
        return this.index;
    }

    public boolean hasIndex() {
        return this.index >= 0;
    }

    public void setIndex(int n) {
        if (n < 0) {
            throw new IllegalArgumentException("index < 0");
        }
        if (this.index >= 0) {
            throw new RuntimeException("index already set");
        }
        this.index = n;
    }

    public int getClassIndex() {
        if (this.classIndex < 0) {
            throw new RuntimeException("class index not yet set");
        }
        return this.classIndex;
    }

    public boolean hasClassIndex() {
        return this.classIndex >= 0;
    }

    public void setClassIndex(int n) {
        if (n < 0) {
            throw new IllegalArgumentException("index < 0");
        }
        if (this.classIndex >= 0) {
            throw new RuntimeException("class index already set");
        }
        this.classIndex = n;
    }

    @Override
    protected String argString() {
        return this.constant.toHuman();
    }
}

