/*
 * Decompiled with CFR 0.152.
 */
package com.android.dx.dex.cf;

import com.android.dx.cf.attrib.AttAnnotationDefault;
import com.android.dx.cf.attrib.AttEnclosingMethod;
import com.android.dx.cf.attrib.AttExceptions;
import com.android.dx.cf.attrib.AttInnerClasses;
import com.android.dx.cf.attrib.AttRuntimeInvisibleAnnotations;
import com.android.dx.cf.attrib.AttRuntimeInvisibleParameterAnnotations;
import com.android.dx.cf.attrib.AttRuntimeVisibleAnnotations;
import com.android.dx.cf.attrib.AttRuntimeVisibleParameterAnnotations;
import com.android.dx.cf.attrib.AttSignature;
import com.android.dx.cf.attrib.InnerClassList;
import com.android.dx.cf.direct.DirectClassFile;
import com.android.dx.cf.iface.AttributeList;
import com.android.dx.cf.iface.Method;
import com.android.dx.cf.iface.MethodList;
import com.android.dx.dex.cf.CfOptions;
import com.android.dx.dex.file.AnnotationUtils;
import com.android.dx.rop.annotation.Annotation;
import com.android.dx.rop.annotation.AnnotationVisibility;
import com.android.dx.rop.annotation.Annotations;
import com.android.dx.rop.annotation.AnnotationsList;
import com.android.dx.rop.annotation.NameValuePair;
import com.android.dx.rop.code.AccessFlags;
import com.android.dx.rop.cst.CstMethodRef;
import com.android.dx.rop.cst.CstNat;
import com.android.dx.rop.cst.CstType;
import com.android.dx.rop.type.StdTypeList;
import com.android.dx.rop.type.Type;
import com.android.dx.rop.type.TypeList;
import com.android.dx.util.MutabilityControl;
import com.android.dx.util.ToHuman;
import com.android.dx.util.Warning;
import java.util.ArrayList;

class AttributeTranslator {
    private AttributeTranslator() {
    }

    public static TypeList getExceptions(Method method) {
        AttributeList attributeList = method.getAttributes();
        AttExceptions attExceptions = (AttExceptions)attributeList.findFirst("Exceptions");
        if (attExceptions == null) {
            return StdTypeList.EMPTY;
        }
        return attExceptions.getExceptions();
    }

    public static Annotations getAnnotations(AttributeList attributeList) {
        Annotations annotations = AttributeTranslator.getAnnotations0(attributeList);
        Annotation annotation = AttributeTranslator.getSignature(attributeList);
        if (annotation != null) {
            annotations = Annotations.combine(annotations, annotation);
        }
        return annotations;
    }

    public static Annotations getClassAnnotations(DirectClassFile directClassFile, CfOptions cfOptions) {
        MutabilityControl mutabilityControl;
        CstType cstType = directClassFile.getThisClass();
        AttributeList attributeList = directClassFile.getAttributes();
        Annotations annotations = AttributeTranslator.getAnnotations(attributeList);
        Annotation annotation = AttributeTranslator.translateEnclosingMethod(attributeList);
        try {
            mutabilityControl = AttributeTranslator.translateInnerClasses(cstType, attributeList, annotation == null);
            if (mutabilityControl != null) {
                annotations = Annotations.combine(annotations, mutabilityControl);
            }
        }
        catch (Warning warning) {
            cfOptions.warn.println("warning: " + warning.getMessage());
        }
        if (annotation != null) {
            annotations = Annotations.combine(annotations, annotation);
        }
        if (AccessFlags.isAnnotation(directClassFile.getAccessFlags()) && (mutabilityControl = AttributeTranslator.translateAnnotationDefaults(directClassFile)) != null) {
            annotations = Annotations.combine(annotations, (Annotation)mutabilityControl);
        }
        return annotations;
    }

    public static Annotations getMethodAnnotations(Method method) {
        Annotations annotations = AttributeTranslator.getAnnotations(method.getAttributes());
        TypeList typeList = AttributeTranslator.getExceptions(method);
        if (typeList.size() != 0) {
            Annotation annotation = AnnotationUtils.makeThrows(typeList);
            annotations = Annotations.combine(annotations, annotation);
        }
        return annotations;
    }

    private static Annotations getAnnotations0(AttributeList attributeList) {
        AttRuntimeVisibleAnnotations attRuntimeVisibleAnnotations = (AttRuntimeVisibleAnnotations)attributeList.findFirst("RuntimeVisibleAnnotations");
        AttRuntimeInvisibleAnnotations attRuntimeInvisibleAnnotations = (AttRuntimeInvisibleAnnotations)attributeList.findFirst("RuntimeInvisibleAnnotations");
        if (attRuntimeVisibleAnnotations == null) {
            if (attRuntimeInvisibleAnnotations == null) {
                return Annotations.EMPTY;
            }
            return attRuntimeInvisibleAnnotations.getAnnotations();
        }
        if (attRuntimeInvisibleAnnotations == null) {
            return attRuntimeVisibleAnnotations.getAnnotations();
        }
        return Annotations.combine(attRuntimeVisibleAnnotations.getAnnotations(), attRuntimeInvisibleAnnotations.getAnnotations());
    }

    private static Annotation getSignature(AttributeList attributeList) {
        AttSignature attSignature = (AttSignature)attributeList.findFirst("Signature");
        if (attSignature == null) {
            return null;
        }
        return AnnotationUtils.makeSignature(attSignature.getSignature());
    }

    private static Annotation translateEnclosingMethod(AttributeList attributeList) {
        AttEnclosingMethod attEnclosingMethod = (AttEnclosingMethod)attributeList.findFirst("EnclosingMethod");
        if (attEnclosingMethod == null) {
            return null;
        }
        CstType cstType = attEnclosingMethod.getEnclosingClass();
        CstNat cstNat = attEnclosingMethod.getMethod();
        if (cstNat == null) {
            return AnnotationUtils.makeEnclosingClass(cstType);
        }
        return AnnotationUtils.makeEnclosingMethod(new CstMethodRef(cstType, cstNat));
    }

    private static Annotations translateInnerClasses(CstType cstType, AttributeList attributeList, boolean bl) {
        ToHuman toHuman;
        Object object;
        int n;
        AttInnerClasses attInnerClasses = (AttInnerClasses)attributeList.findFirst("InnerClasses");
        if (attInnerClasses == null) {
            return null;
        }
        InnerClassList innerClassList = attInnerClasses.getInnerClasses();
        int n2 = innerClassList.size();
        Object object2 = null;
        ArrayList<Type> arrayList = new ArrayList<Type>();
        for (n = 0; n < n2; ++n) {
            object = innerClassList.get(n);
            toHuman = ((InnerClassList.Item)object).getInnerClass();
            if (((CstType)toHuman).equals(cstType)) {
                object2 = object;
                continue;
            }
            if (!cstType.equals(((InnerClassList.Item)object).getOuterClass())) continue;
            arrayList.add(((CstType)toHuman).getClassType());
        }
        n = arrayList.size();
        if (object2 == null && n == 0) {
            return null;
        }
        object = new Annotations();
        if (object2 != null) {
            ((Annotations)object).add(AnnotationUtils.makeInnerClass(((InnerClassList.Item)object2).getInnerName(), ((InnerClassList.Item)object2).getAccessFlags()));
            if (bl) {
                toHuman = ((InnerClassList.Item)object2).getOuterClass();
                if (toHuman == null) {
                    throw new Warning("Ignoring InnerClasses attribute for an anonymous inner class\n(" + cstType.toHuman() + ") that doesn't come with an\n" + "associated EnclosingMethod attribute. " + "This class was probably produced by a\n" + "compiler that did not target the modern " + ".class file format. The recommended\n" + "solution is to recompile the class from " + "source, using an up-to-date compiler\n" + "and without specifying any \"-target\" type " + "options. The consequence of ignoring\n" + "this warning is that reflective operations " + "on this class will incorrectly\n" + "indicate that it is *not* an inner class.");
                }
                ((Annotations)object).add(AnnotationUtils.makeEnclosingClass(((InnerClassList.Item)object2).getOuterClass()));
            }
        }
        if (n != 0) {
            toHuman = new StdTypeList(n);
            for (int i = 0; i < n; ++i) {
                ((StdTypeList)toHuman).set(i, (Type)arrayList.get(i));
            }
            ((MutabilityControl)((Object)toHuman)).setImmutable();
            ((Annotations)object).add(AnnotationUtils.makeMemberClasses((TypeList)((Object)toHuman)));
        }
        ((MutabilityControl)object).setImmutable();
        return object;
    }

    public static AnnotationsList getParameterAnnotations(Method method) {
        AttributeList attributeList = method.getAttributes();
        AttRuntimeVisibleParameterAnnotations attRuntimeVisibleParameterAnnotations = (AttRuntimeVisibleParameterAnnotations)attributeList.findFirst("RuntimeVisibleParameterAnnotations");
        AttRuntimeInvisibleParameterAnnotations attRuntimeInvisibleParameterAnnotations = (AttRuntimeInvisibleParameterAnnotations)attributeList.findFirst("RuntimeInvisibleParameterAnnotations");
        if (attRuntimeVisibleParameterAnnotations == null) {
            if (attRuntimeInvisibleParameterAnnotations == null) {
                return AnnotationsList.EMPTY;
            }
            return attRuntimeInvisibleParameterAnnotations.getParameterAnnotations();
        }
        if (attRuntimeInvisibleParameterAnnotations == null) {
            return attRuntimeVisibleParameterAnnotations.getParameterAnnotations();
        }
        return AnnotationsList.combine(attRuntimeVisibleParameterAnnotations.getParameterAnnotations(), attRuntimeInvisibleParameterAnnotations.getParameterAnnotations());
    }

    private static Annotation translateAnnotationDefaults(DirectClassFile directClassFile) {
        CstType cstType = directClassFile.getThisClass();
        MethodList methodList = directClassFile.getMethods();
        int n = methodList.size();
        Annotation annotation = new Annotation(cstType, AnnotationVisibility.EMBEDDED);
        boolean bl = false;
        for (int i = 0; i < n; ++i) {
            Method method = methodList.get(i);
            AttributeList attributeList = method.getAttributes();
            AttAnnotationDefault attAnnotationDefault = (AttAnnotationDefault)attributeList.findFirst("AnnotationDefault");
            if (attAnnotationDefault == null) continue;
            NameValuePair nameValuePair = new NameValuePair(method.getNat().getName(), attAnnotationDefault.getValue());
            annotation.add(nameValuePair);
            bl = true;
        }
        if (!bl) {
            return null;
        }
        annotation.setImmutable();
        return AnnotationUtils.makeAnnotationDefault(annotation);
    }
}

