/*
 * Decompiled with CFR 0.152.
 */
package com.android.dx.command.dump;

import com.android.dx.cf.code.BasicBlocker;
import com.android.dx.cf.code.ByteBlock;
import com.android.dx.cf.code.ByteBlockList;
import com.android.dx.cf.code.ByteCatchList;
import com.android.dx.cf.code.BytecodeArray;
import com.android.dx.cf.code.ConcreteMethod;
import com.android.dx.cf.code.Ropper;
import com.android.dx.cf.direct.CodeObserver;
import com.android.dx.cf.direct.DirectClassFile;
import com.android.dx.cf.direct.StdAttributeFactory;
import com.android.dx.cf.iface.Member;
import com.android.dx.cf.iface.Method;
import com.android.dx.command.dump.Args;
import com.android.dx.command.dump.BaseDumper;
import com.android.dx.rop.code.AccessFlags;
import com.android.dx.rop.code.BasicBlock;
import com.android.dx.rop.code.BasicBlockList;
import com.android.dx.rop.code.DexTranslationAdvice;
import com.android.dx.rop.code.Insn;
import com.android.dx.rop.code.InsnList;
import com.android.dx.rop.code.RopMethod;
import com.android.dx.rop.cst.CstType;
import com.android.dx.ssa.Optimizer;
import com.android.dx.util.ByteArray;
import com.android.dx.util.Hex;
import com.android.dx.util.IntList;
import java.io.PrintStream;

public class BlockDumper
extends BaseDumper {
    private boolean rop;
    protected DirectClassFile classFile;
    protected boolean suppressDump;
    private boolean first;
    private boolean optimize;

    public static void dump(byte[] byArray, PrintStream printStream, String string, boolean bl, Args args) {
        BlockDumper blockDumper = new BlockDumper(byArray, printStream, string, bl, args);
        blockDumper.dump();
    }

    BlockDumper(byte[] byArray, PrintStream printStream, String string, boolean bl, Args args) {
        super(byArray, printStream, string, args);
        this.rop = bl;
        this.classFile = null;
        this.suppressDump = true;
        this.first = true;
        this.optimize = args.optimize;
    }

    public void dump() {
        byte[] byArray = this.getBytes();
        ByteArray byteArray = new ByteArray(byArray);
        this.classFile = new DirectClassFile(byteArray, this.getFilePath(), this.getStrictParse());
        this.classFile.setAttributeFactory(StdAttributeFactory.THE_ONE);
        this.classFile.getMagic();
        DirectClassFile directClassFile = new DirectClassFile(byteArray, this.getFilePath(), this.getStrictParse());
        directClassFile.setAttributeFactory(StdAttributeFactory.THE_ONE);
        directClassFile.setObserver(this);
        directClassFile.getMagic();
    }

    @Override
    public void changeIndent(int n) {
        if (!this.suppressDump) {
            super.changeIndent(n);
        }
    }

    @Override
    public void parsed(ByteArray byteArray, int n, int n2, String string) {
        if (!this.suppressDump) {
            super.parsed(byteArray, n, n2, string);
        }
    }

    protected boolean shouldDumpMethod(String string) {
        return this.args.method == null || this.args.method.equals(string);
    }

    @Override
    public void startParsingMember(ByteArray byteArray, int n, String string, String string2) {
        if (string2.indexOf(40) < 0) {
            return;
        }
        if (!this.shouldDumpMethod(string)) {
            return;
        }
        this.setAt(byteArray, n);
        this.suppressDump = false;
        if (this.first) {
            this.first = false;
        } else {
            this.parsed(byteArray, n, 0, "\n");
        }
        this.parsed(byteArray, n, 0, "method " + string + " " + string2);
        this.suppressDump = true;
    }

    @Override
    public void endParsingMember(ByteArray byteArray, int n, String string, String string2, Member member) {
        if (!(member instanceof Method)) {
            return;
        }
        if (!this.shouldDumpMethod(string)) {
            return;
        }
        if ((member.getAccessFlags() & 0x500) != 0) {
            return;
        }
        ConcreteMethod concreteMethod = new ConcreteMethod((Method)member, this.classFile, true, true);
        if (this.rop) {
            this.ropDump(concreteMethod);
        } else {
            this.regularDump(concreteMethod);
        }
    }

    private void regularDump(ConcreteMethod concreteMethod) {
        int n;
        BytecodeArray bytecodeArray = concreteMethod.getCode();
        ByteArray byteArray = bytecodeArray.getBytes();
        ByteBlockList byteBlockList = BasicBlocker.identifyBlocks(concreteMethod);
        int n2 = byteBlockList.size();
        CodeObserver codeObserver = new CodeObserver(byteArray, this);
        this.setAt(byteArray, 0);
        this.suppressDump = false;
        int n3 = 0;
        for (n = 0; n < n2; ++n) {
            int n4;
            int n5;
            ByteBlock byteBlock = byteBlockList.get(n);
            int n6 = byteBlock.getStart();
            int n7 = byteBlock.getEnd();
            if (n3 < n6) {
                this.parsed(byteArray, n3, n6 - n3, "dead code " + Hex.u2(n3) + ".." + Hex.u2(n6));
            }
            this.parsed(byteArray, n6, 0, "block " + Hex.u2(byteBlock.getLabel()) + ": " + Hex.u2(n6) + ".." + Hex.u2(n7));
            this.changeIndent(1);
            for (int i = n6; i < n7; i += n5) {
                n5 = bytecodeArray.parseInstruction(i, codeObserver);
                codeObserver.setPreviousOffset(i);
            }
            IntList intList = byteBlock.getSuccessors();
            int n8 = intList.size();
            if (n8 == 0) {
                this.parsed(byteArray, n7, 0, "returns");
            } else {
                for (int i = 0; i < n8; ++i) {
                    n4 = intList.get(i);
                    this.parsed(byteArray, n7, 0, "next " + Hex.u2(n4));
                }
            }
            ByteCatchList byteCatchList = byteBlock.getCatches();
            n4 = byteCatchList.size();
            for (int i = 0; i < n4; ++i) {
                ByteCatchList.Item item = byteCatchList.get(i);
                CstType cstType = item.getExceptionClass();
                this.parsed(byteArray, n7, 0, "catch " + (cstType == CstType.OBJECT ? "<any>" : cstType.toHuman()) + " -> " + Hex.u2(item.getHandlerPc()));
            }
            this.changeIndent(-1);
            n3 = n7;
        }
        n = byteArray.size();
        if (n3 < n) {
            this.parsed(byteArray, n3, n - n3, "dead code " + Hex.u2(n3) + ".." + Hex.u2(n));
        }
        this.suppressDump = true;
    }

    private void ropDump(ConcreteMethod concreteMethod) {
        DexTranslationAdvice dexTranslationAdvice = DexTranslationAdvice.THE_ONE;
        BytecodeArray bytecodeArray = concreteMethod.getCode();
        ByteArray byteArray = bytecodeArray.getBytes();
        RopMethod ropMethod = Ropper.convert(concreteMethod, dexTranslationAdvice, this.classFile.getMethods());
        StringBuffer stringBuffer = new StringBuffer(2000);
        if (this.optimize) {
            boolean bl = AccessFlags.isStatic(concreteMethod.getAccessFlags());
            int n = BlockDumper.computeParamWidth(concreteMethod, bl);
            ropMethod = Optimizer.optimize(ropMethod, n, bl, true, dexTranslationAdvice);
        }
        BasicBlockList basicBlockList = ropMethod.getBlocks();
        int[] nArray = basicBlockList.getLabelsInOrder();
        stringBuffer.append("first " + Hex.u2(ropMethod.getFirstLabel()) + "\n");
        for (int n : nArray) {
            BasicBlock basicBlock = basicBlockList.get(basicBlockList.indexOfLabel(n));
            stringBuffer.append("block ");
            stringBuffer.append(Hex.u2(n));
            stringBuffer.append("\n");
            IntList intList = ropMethod.labelToPredecessors(n);
            int n2 = intList.size();
            for (int i = 0; i < n2; ++i) {
                stringBuffer.append("  pred ");
                stringBuffer.append(Hex.u2(intList.get(i)));
                stringBuffer.append("\n");
            }
            InsnList insnList = basicBlock.getInsns();
            int n3 = insnList.size();
            for (int i = 0; i < n3; ++i) {
                Insn insn = insnList.get(i);
                stringBuffer.append("  ");
                stringBuffer.append(insnList.get(i).toHuman());
                stringBuffer.append("\n");
            }
            IntList intList2 = basicBlock.getSuccessors();
            int n4 = intList2.size();
            if (n4 == 0) {
                stringBuffer.append("  returns\n");
                continue;
            }
            int n5 = basicBlock.getPrimarySuccessor();
            for (int i = 0; i < n4; ++i) {
                int n6 = intList2.get(i);
                stringBuffer.append("  next ");
                stringBuffer.append(Hex.u2(n6));
                if (n4 != 1 && n6 == n5) {
                    stringBuffer.append(" *");
                }
                stringBuffer.append("\n");
            }
        }
        this.suppressDump = false;
        this.setAt(byteArray, 0);
        this.parsed(byteArray, 0, byteArray.size(), stringBuffer.toString());
        this.suppressDump = true;
    }
}

