/*
 * Decompiled with CFR 0.152.
 */
package com.android.dx.command.dump;

import com.android.dx.cf.code.ConcreteMethod;
import com.android.dx.cf.iface.Member;
import com.android.dx.cf.iface.ParseObserver;
import com.android.dx.command.dump.Args;
import com.android.dx.util.ByteArray;
import com.android.dx.util.Hex;
import com.android.dx.util.IndentingWriter;
import com.android.dx.util.TwoColumnOutput;
import java.io.IOException;
import java.io.PrintStream;
import java.io.StringWriter;

public abstract class BaseDumper
implements ParseObserver {
    private final byte[] bytes;
    private final boolean rawBytes;
    private final PrintStream out;
    private final int width;
    private final String filePath;
    private final boolean strictParse;
    private final int hexCols;
    private int indent;
    private String separator;
    private int at;
    protected Args args;

    public BaseDumper(byte[] byArray, PrintStream printStream, String string, Args args) {
        this.bytes = byArray;
        this.rawBytes = args.rawBytes;
        this.out = printStream;
        this.width = args.width <= 0 ? 79 : args.width;
        this.filePath = string;
        this.strictParse = args.strictParse;
        this.indent = 0;
        this.separator = this.rawBytes ? "|" : "";
        this.at = 0;
        this.args = args;
        int n = (this.width - 5) / 15 + 1 & 0xFFFFFFFE;
        if (n < 6) {
            n = 6;
        } else if (n > 10) {
            n = 10;
        }
        this.hexCols = n;
    }

    static int computeParamWidth(ConcreteMethod concreteMethod, boolean bl) {
        return concreteMethod.getEffectiveDescriptor().getParameterTypes().getWordCount();
    }

    @Override
    public void changeIndent(int n) {
        this.indent += n;
        this.separator = this.rawBytes ? "|" : "";
        for (int i = 0; i < this.indent; ++i) {
            this.separator = this.separator + "  ";
        }
    }

    @Override
    public void parsed(ByteArray byteArray, int n, int n2, String string) {
        String string2;
        n = byteArray.underlyingOffset(n, this.getBytes());
        boolean bl = this.getRawBytes();
        if (n < this.at) {
            this.println("<dump skipped backwards to " + Hex.u4(n) + ">");
            this.at = n;
        } else if (n > this.at) {
            string2 = bl ? this.hexDump(this.at, n - this.at) : "";
            this.print(this.twoColumns(string2, "<skipped to " + Hex.u4(n) + ">"));
            this.at = n;
        }
        string2 = bl ? this.hexDump(n, n2) : "";
        this.print(this.twoColumns(string2, string));
        this.at += n2;
    }

    @Override
    public void startParsingMember(ByteArray byteArray, int n, String string, String string2) {
    }

    @Override
    public void endParsingMember(ByteArray byteArray, int n, String string, String string2, Member member) {
    }

    protected final int getAt() {
        return this.at;
    }

    protected final void setAt(ByteArray byteArray, int n) {
        this.at = byteArray.underlyingOffset(n, this.bytes);
    }

    protected final byte[] getBytes() {
        return this.bytes;
    }

    protected final String getFilePath() {
        return this.filePath;
    }

    protected final boolean getStrictParse() {
        return this.strictParse;
    }

    protected final void print(String string) {
        this.out.print(string);
    }

    protected final void println(String string) {
        this.out.println(string);
    }

    protected final boolean getRawBytes() {
        return this.rawBytes;
    }

    protected final int getWidth1() {
        if (this.rawBytes) {
            return 5 + this.hexCols * 2 + this.hexCols / 2;
        }
        return 0;
    }

    protected final int getWidth2() {
        int n = this.rawBytes ? this.getWidth1() + 1 : 0;
        return this.width - n - this.indent * 2;
    }

    protected final String hexDump(int n, int n2) {
        return Hex.dump(this.bytes, n, n2, n, this.hexCols, 4);
    }

    protected final String twoColumns(String string, String string2) {
        int n = this.getWidth1();
        int n2 = this.getWidth2();
        try {
            if (n == 0) {
                int n3 = string2.length();
                StringWriter stringWriter = new StringWriter(n3 * 2);
                IndentingWriter indentingWriter = new IndentingWriter(stringWriter, n2, this.separator);
                indentingWriter.write(string2);
                if (n3 == 0 || string2.charAt(n3 - 1) != '\n') {
                    indentingWriter.write(10);
                }
                indentingWriter.flush();
                return stringWriter.toString();
            }
            return TwoColumnOutput.toString(string, n, this.separator, string2, n2);
        }
        catch (IOException iOException) {
            throw new RuntimeException(iOException);
        }
    }
}

