/*
 * Decompiled with CFR 0.152.
 */
package com.android.dx.cf.direct;

import com.android.dx.cf.attrib.AttSourceFile;
import com.android.dx.cf.cst.ConstantPoolParser;
import com.android.dx.cf.direct.AttributeFactory;
import com.android.dx.cf.direct.AttributeListParser;
import com.android.dx.cf.direct.FieldListParser;
import com.android.dx.cf.direct.MemberListParser;
import com.android.dx.cf.direct.MethodListParser;
import com.android.dx.cf.iface.Attribute;
import com.android.dx.cf.iface.AttributeList;
import com.android.dx.cf.iface.ClassFile;
import com.android.dx.cf.iface.FieldList;
import com.android.dx.cf.iface.MethodList;
import com.android.dx.cf.iface.ParseException;
import com.android.dx.cf.iface.ParseObserver;
import com.android.dx.cf.iface.StdAttributeList;
import com.android.dx.rop.code.AccessFlags;
import com.android.dx.rop.cst.ConstantPool;
import com.android.dx.rop.cst.CstString;
import com.android.dx.rop.cst.CstType;
import com.android.dx.rop.cst.StdConstantPool;
import com.android.dx.rop.type.StdTypeList;
import com.android.dx.rop.type.Type;
import com.android.dx.rop.type.TypeList;
import com.android.dx.util.ByteArray;
import com.android.dx.util.Hex;

public class DirectClassFile
implements ClassFile {
    private static final int CLASS_FILE_MAGIC = -889275714;
    private static final int CLASS_FILE_MIN_MAJOR_VERSION = 45;
    private static final int CLASS_FILE_MAX_MAJOR_VERSION = 51;
    private static final int CLASS_FILE_MAX_MINOR_VERSION = 0;
    private final String filePath;
    private final ByteArray bytes;
    private final boolean strictParse;
    private StdConstantPool pool;
    private int accessFlags;
    private CstType thisClass;
    private CstType superClass;
    private TypeList interfaces;
    private FieldList fields;
    private MethodList methods;
    private StdAttributeList attributes;
    private AttributeFactory attributeFactory;
    private ParseObserver observer;

    public static String stringOrNone(Object object) {
        if (object == null) {
            return "(none)";
        }
        return object.toString();
    }

    public DirectClassFile(ByteArray byteArray, String string, boolean bl) {
        if (byteArray == null) {
            throw new NullPointerException("bytes == null");
        }
        if (string == null) {
            throw new NullPointerException("filePath == null");
        }
        this.filePath = string;
        this.bytes = byteArray;
        this.strictParse = bl;
        this.accessFlags = -1;
    }

    public DirectClassFile(byte[] byArray, String string, boolean bl) {
        this(new ByteArray(byArray), string, bl);
    }

    public void setObserver(ParseObserver parseObserver) {
        this.observer = parseObserver;
    }

    public void setAttributeFactory(AttributeFactory attributeFactory) {
        if (attributeFactory == null) {
            throw new NullPointerException("attributeFactory == null");
        }
        this.attributeFactory = attributeFactory;
    }

    public String getFilePath() {
        return this.filePath;
    }

    public ByteArray getBytes() {
        return this.bytes;
    }

    @Override
    public int getMagic() {
        this.parseToInterfacesIfNecessary();
        return this.getMagic0();
    }

    @Override
    public int getMinorVersion() {
        this.parseToInterfacesIfNecessary();
        return this.getMinorVersion0();
    }

    @Override
    public int getMajorVersion() {
        this.parseToInterfacesIfNecessary();
        return this.getMajorVersion0();
    }

    @Override
    public int getAccessFlags() {
        this.parseToInterfacesIfNecessary();
        return this.accessFlags;
    }

    @Override
    public CstType getThisClass() {
        this.parseToInterfacesIfNecessary();
        return this.thisClass;
    }

    @Override
    public CstType getSuperclass() {
        this.parseToInterfacesIfNecessary();
        return this.superClass;
    }

    @Override
    public ConstantPool getConstantPool() {
        this.parseToInterfacesIfNecessary();
        return this.pool;
    }

    @Override
    public TypeList getInterfaces() {
        this.parseToInterfacesIfNecessary();
        return this.interfaces;
    }

    @Override
    public FieldList getFields() {
        this.parseToEndIfNecessary();
        return this.fields;
    }

    @Override
    public MethodList getMethods() {
        this.parseToEndIfNecessary();
        return this.methods;
    }

    @Override
    public AttributeList getAttributes() {
        this.parseToEndIfNecessary();
        return this.attributes;
    }

    @Override
    public CstString getSourceFile() {
        AttributeList attributeList = this.getAttributes();
        Attribute attribute = attributeList.findFirst("SourceFile");
        if (attribute instanceof AttSourceFile) {
            return ((AttSourceFile)attribute).getSourceFile();
        }
        return null;
    }

    public TypeList makeTypeList(int n, int n2) {
        if (n2 == 0) {
            return StdTypeList.EMPTY;
        }
        if (this.pool == null) {
            throw new IllegalStateException("pool not yet initialized");
        }
        return new DcfTypeList(this.bytes, n, n2, this.pool, this.observer);
    }

    public int getMagic0() {
        return this.bytes.getInt(0);
    }

    public int getMinorVersion0() {
        return this.bytes.getUnsignedShort(4);
    }

    public int getMajorVersion0() {
        return this.bytes.getUnsignedShort(6);
    }

    private void parseToInterfacesIfNecessary() {
        if (this.accessFlags == -1) {
            this.parse();
        }
    }

    private void parseToEndIfNecessary() {
        if (this.attributes == null) {
            this.parse();
        }
    }

    private void parse() {
        try {
            this.parse0();
        }
        catch (ParseException parseException) {
            parseException.addContext("...while parsing " + this.filePath);
            throw parseException;
        }
        catch (RuntimeException runtimeException) {
            ParseException parseException = new ParseException(runtimeException);
            parseException.addContext("...while parsing " + this.filePath);
            throw parseException;
        }
    }

    private boolean isGoodVersion(int n, int n2, int n3) {
        return n == -889275714 && n2 >= 0 && (n3 == 51 ? n2 <= 0 : n3 < 51 && n3 >= 45);
    }

    private void parse0() {
        Object object;
        if (this.bytes.size() < 10) {
            throw new ParseException("severely truncated class file");
        }
        if (this.observer != null) {
            this.observer.parsed(this.bytes, 0, 0, "begin classfile");
            this.observer.parsed(this.bytes, 0, 4, "magic: " + Hex.u4(this.getMagic0()));
            this.observer.parsed(this.bytes, 4, 2, "minor_version: " + Hex.u2(this.getMinorVersion0()));
            this.observer.parsed(this.bytes, 6, 2, "major_version: " + Hex.u2(this.getMajorVersion0()));
        }
        if (this.strictParse && !this.isGoodVersion(this.getMagic0(), this.getMinorVersion0(), this.getMajorVersion0())) {
            throw new ParseException("bad class file magic (" + Hex.u4(this.getMagic0()) + ") or version (" + Hex.u2(this.getMajorVersion0()) + "." + Hex.u2(this.getMinorVersion0()) + ")");
        }
        ConstantPoolParser constantPoolParser = new ConstantPoolParser(this.bytes);
        constantPoolParser.setObserver(this.observer);
        this.pool = constantPoolParser.getPool();
        this.pool.setImmutable();
        int n = constantPoolParser.getEndOffset();
        int n2 = this.bytes.getUnsignedShort(n);
        int n3 = this.bytes.getUnsignedShort(n + 2);
        this.thisClass = (CstType)this.pool.get(n3);
        n3 = this.bytes.getUnsignedShort(n + 4);
        this.superClass = (CstType)this.pool.get0Ok(n3);
        int n4 = this.bytes.getUnsignedShort(n + 6);
        if (this.observer != null) {
            this.observer.parsed(this.bytes, n, 2, "access_flags: " + AccessFlags.classString(n2));
            this.observer.parsed(this.bytes, n + 2, 2, "this_class: " + this.thisClass);
            this.observer.parsed(this.bytes, n + 4, 2, "super_class: " + DirectClassFile.stringOrNone(this.superClass));
            this.observer.parsed(this.bytes, n + 6, 2, "interfaces_count: " + Hex.u2(n4));
            if (n4 != 0) {
                this.observer.parsed(this.bytes, n + 8, 0, "interfaces:");
            }
        }
        this.interfaces = this.makeTypeList(n += 8, n4);
        n += n4 * 2;
        if (this.strictParse) {
            object = this.thisClass.getClassType().getClassName();
            if (!this.filePath.endsWith(".class") || !this.filePath.startsWith((String)object) || this.filePath.length() != ((String)object).length() + 6) {
                throw new ParseException("class name (" + (String)object + ") does not match path (" + this.filePath + ")");
            }
        }
        this.accessFlags = n2;
        object = new FieldListParser(this, this.thisClass, n, this.attributeFactory);
        ((MemberListParser)object).setObserver(this.observer);
        this.fields = ((FieldListParser)object).getList();
        n = ((MemberListParser)object).getEndOffset();
        MethodListParser methodListParser = new MethodListParser(this, this.thisClass, n, this.attributeFactory);
        methodListParser.setObserver(this.observer);
        this.methods = methodListParser.getList();
        n = methodListParser.getEndOffset();
        AttributeListParser attributeListParser = new AttributeListParser(this, 0, n, this.attributeFactory);
        attributeListParser.setObserver(this.observer);
        this.attributes = attributeListParser.getList();
        this.attributes.setImmutable();
        n = attributeListParser.getEndOffset();
        if (n != this.bytes.size()) {
            throw new ParseException("extra bytes at end of class file, at offset " + Hex.u4(n));
        }
        if (this.observer != null) {
            this.observer.parsed(this.bytes, n, 0, "end classfile");
        }
    }

    private static class DcfTypeList
    implements TypeList {
        private final ByteArray bytes;
        private final int size;
        private final StdConstantPool pool;

        public DcfTypeList(ByteArray byteArray, int n, int n2, StdConstantPool stdConstantPool, ParseObserver parseObserver) {
            if (n2 < 0) {
                throw new IllegalArgumentException("size < 0");
            }
            this.bytes = byteArray = byteArray.slice(n, n + n2 * 2);
            this.size = n2;
            this.pool = stdConstantPool;
            for (int i = 0; i < n2; ++i) {
                CstType cstType;
                n = i * 2;
                int n3 = byteArray.getUnsignedShort(n);
                try {
                    cstType = (CstType)stdConstantPool.get(n3);
                }
                catch (ClassCastException classCastException) {
                    throw new RuntimeException("bogus class cpi", classCastException);
                }
                if (parseObserver == null) continue;
                parseObserver.parsed(byteArray, n, 2, "  " + cstType);
            }
        }

        @Override
        public boolean isMutable() {
            return false;
        }

        @Override
        public int size() {
            return this.size;
        }

        @Override
        public int getWordCount() {
            return this.size;
        }

        @Override
        public Type getType(int n) {
            int n2 = this.bytes.getUnsignedShort(n * 2);
            return ((CstType)this.pool.get(n2)).getClassType();
        }

        @Override
        public TypeList withAddedType(Type type) {
            throw new UnsupportedOperationException("unsupported");
        }
    }
}

