/*
 * Decompiled with CFR 0.152.
 */
package com.android.dx.cf.direct;

import com.android.dx.cf.direct.AttributeFactory;
import com.android.dx.cf.direct.DirectClassFile;
import com.android.dx.cf.iface.Attribute;
import com.android.dx.cf.iface.ParseException;
import com.android.dx.cf.iface.ParseObserver;
import com.android.dx.cf.iface.StdAttributeList;
import com.android.dx.util.ByteArray;
import com.android.dx.util.Hex;

final class AttributeListParser {
    private final DirectClassFile cf;
    private final int context;
    private final int offset;
    private final AttributeFactory attributeFactory;
    private final StdAttributeList list;
    private int endOffset;
    private ParseObserver observer;

    public AttributeListParser(DirectClassFile directClassFile, int n, int n2, AttributeFactory attributeFactory) {
        if (directClassFile == null) {
            throw new NullPointerException("cf == null");
        }
        if (attributeFactory == null) {
            throw new NullPointerException("attributeFactory == null");
        }
        int n3 = directClassFile.getBytes().getUnsignedShort(n2);
        this.cf = directClassFile;
        this.context = n;
        this.offset = n2;
        this.attributeFactory = attributeFactory;
        this.list = new StdAttributeList(n3);
        this.endOffset = -1;
    }

    public void setObserver(ParseObserver parseObserver) {
        this.observer = parseObserver;
    }

    public int getEndOffset() {
        this.parseIfNecessary();
        return this.endOffset;
    }

    public StdAttributeList getList() {
        this.parseIfNecessary();
        return this.list;
    }

    private void parseIfNecessary() {
        if (this.endOffset < 0) {
            this.parse();
        }
    }

    private void parse() {
        int n = this.list.size();
        int n2 = this.offset + 2;
        ByteArray byteArray = this.cf.getBytes();
        if (this.observer != null) {
            this.observer.parsed(byteArray, this.offset, 2, "attributes_count: " + Hex.u2(n));
        }
        for (int i = 0; i < n; ++i) {
            try {
                if (this.observer != null) {
                    this.observer.parsed(byteArray, n2, 0, "\nattributes[" + i + "]:\n");
                    this.observer.changeIndent(1);
                }
                Attribute attribute = this.attributeFactory.parse(this.cf, this.context, n2, this.observer);
                n2 += attribute.byteLength();
                this.list.set(i, attribute);
                if (this.observer == null) continue;
                this.observer.changeIndent(-1);
                this.observer.parsed(byteArray, n2, 0, "end attributes[" + i + "]\n");
                continue;
            }
            catch (ParseException parseException) {
                parseException.addContext("...while parsing attributes[" + i + "]");
                throw parseException;
            }
            catch (RuntimeException runtimeException) {
                ParseException parseException = new ParseException(runtimeException);
                parseException.addContext("...while parsing attributes[" + i + "]");
                throw parseException;
            }
        }
        this.endOffset = n2;
    }
}

