/*
 * Decompiled with CFR 0.152.
 */
package com.android.dx.cf.code;

import com.android.dx.cf.code.ExecutionStack;
import com.android.dx.cf.code.Frame;
import com.android.dx.cf.code.Machine;
import com.android.dx.cf.code.Merger;
import com.android.dx.cf.code.SimException;
import com.android.dx.cf.code.SwitchList;
import com.android.dx.rop.code.LocalItem;
import com.android.dx.rop.code.RegisterSpec;
import com.android.dx.rop.cst.Constant;
import com.android.dx.rop.type.Prototype;
import com.android.dx.rop.type.StdTypeList;
import com.android.dx.rop.type.Type;
import com.android.dx.rop.type.TypeBearer;
import java.util.ArrayList;

public abstract class BaseMachine
implements Machine {
    private final Prototype prototype;
    private TypeBearer[] args;
    private int argCount;
    private Type auxType;
    private int auxInt;
    private Constant auxCst;
    private int auxTarget;
    private SwitchList auxCases;
    private ArrayList<Constant> auxInitValues;
    private int localIndex;
    private boolean localInfo;
    private RegisterSpec localTarget;
    private TypeBearer[] results;
    private int resultCount;

    public BaseMachine(Prototype prototype) {
        if (prototype == null) {
            throw new NullPointerException("prototype == null");
        }
        this.prototype = prototype;
        this.args = new TypeBearer[10];
        this.results = new TypeBearer[6];
        this.clearArgs();
    }

    @Override
    public Prototype getPrototype() {
        return this.prototype;
    }

    @Override
    public final void clearArgs() {
        this.argCount = 0;
        this.auxType = null;
        this.auxInt = 0;
        this.auxCst = null;
        this.auxTarget = 0;
        this.auxCases = null;
        this.auxInitValues = null;
        this.localIndex = -1;
        this.localInfo = false;
        this.localTarget = null;
        this.resultCount = -1;
    }

    @Override
    public final void popArgs(Frame frame, int n) {
        ExecutionStack executionStack = frame.getStack();
        this.clearArgs();
        if (n > this.args.length) {
            this.args = new TypeBearer[n + 10];
        }
        for (int i = n - 1; i >= 0; --i) {
            this.args[i] = executionStack.pop();
        }
        this.argCount = n;
    }

    @Override
    public void popArgs(Frame frame, Prototype prototype) {
        StdTypeList stdTypeList = prototype.getParameterTypes();
        int n = stdTypeList.size();
        this.popArgs(frame, n);
        for (int i = 0; i < n; ++i) {
            if (Merger.isPossiblyAssignableFrom(stdTypeList.getType(i), this.args[i])) continue;
            throw new SimException("at stack depth " + (n - 1 - i) + ", expected type " + stdTypeList.getType(i).toHuman() + " but found " + this.args[i].getType().toHuman());
        }
    }

    @Override
    public final void popArgs(Frame frame, Type type) {
        this.popArgs(frame, 1);
        if (!Merger.isPossiblyAssignableFrom(type, this.args[0])) {
            throw new SimException("expected type " + type.toHuman() + " but found " + this.args[0].getType().toHuman());
        }
    }

    @Override
    public final void popArgs(Frame frame, Type type, Type type2) {
        this.popArgs(frame, 2);
        if (!Merger.isPossiblyAssignableFrom(type, this.args[0])) {
            throw new SimException("expected type " + type.toHuman() + " but found " + this.args[0].getType().toHuman());
        }
        if (!Merger.isPossiblyAssignableFrom(type2, this.args[1])) {
            throw new SimException("expected type " + type2.toHuman() + " but found " + this.args[1].getType().toHuman());
        }
    }

    @Override
    public final void popArgs(Frame frame, Type type, Type type2, Type type3) {
        this.popArgs(frame, 3);
        if (!Merger.isPossiblyAssignableFrom(type, this.args[0])) {
            throw new SimException("expected type " + type.toHuman() + " but found " + this.args[0].getType().toHuman());
        }
        if (!Merger.isPossiblyAssignableFrom(type2, this.args[1])) {
            throw new SimException("expected type " + type2.toHuman() + " but found " + this.args[1].getType().toHuman());
        }
        if (!Merger.isPossiblyAssignableFrom(type3, this.args[2])) {
            throw new SimException("expected type " + type3.toHuman() + " but found " + this.args[2].getType().toHuman());
        }
    }

    @Override
    public final void localArg(Frame frame, int n) {
        this.clearArgs();
        this.args[0] = frame.getLocals().get(n);
        this.argCount = 1;
        this.localIndex = n;
    }

    @Override
    public final void localInfo(boolean bl) {
        this.localInfo = bl;
    }

    @Override
    public final void auxType(Type type) {
        this.auxType = type;
    }

    @Override
    public final void auxIntArg(int n) {
        this.auxInt = n;
    }

    @Override
    public final void auxCstArg(Constant constant) {
        if (constant == null) {
            throw new NullPointerException("cst == null");
        }
        this.auxCst = constant;
    }

    @Override
    public final void auxTargetArg(int n) {
        this.auxTarget = n;
    }

    @Override
    public final void auxSwitchArg(SwitchList switchList) {
        if (switchList == null) {
            throw new NullPointerException("cases == null");
        }
        this.auxCases = switchList;
    }

    @Override
    public final void auxInitValues(ArrayList<Constant> arrayList) {
        this.auxInitValues = arrayList;
    }

    @Override
    public final void localTarget(int n, Type type, LocalItem localItem) {
        this.localTarget = RegisterSpec.makeLocalOptional(n, type, localItem);
    }

    protected final int argCount() {
        return this.argCount;
    }

    protected final int argWidth() {
        int n = 0;
        for (int i = 0; i < this.argCount; ++i) {
            n += this.args[i].getType().getCategory();
        }
        return n;
    }

    protected final TypeBearer arg(int n) {
        if (n >= this.argCount) {
            throw new IllegalArgumentException("n >= argCount");
        }
        try {
            return this.args[n];
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            throw new IllegalArgumentException("n < 0");
        }
    }

    protected final Type getAuxType() {
        return this.auxType;
    }

    protected final int getAuxInt() {
        return this.auxInt;
    }

    protected final Constant getAuxCst() {
        return this.auxCst;
    }

    protected final int getAuxTarget() {
        return this.auxTarget;
    }

    protected final SwitchList getAuxCases() {
        return this.auxCases;
    }

    protected final ArrayList<Constant> getInitValues() {
        return this.auxInitValues;
    }

    protected final int getLocalIndex() {
        return this.localIndex;
    }

    protected final boolean getLocalInfo() {
        return this.localInfo;
    }

    protected final RegisterSpec getLocalTarget(boolean bl) {
        Type type;
        if (this.localTarget == null) {
            return null;
        }
        if (this.resultCount != 1) {
            throw new SimException("local target with " + (this.resultCount == 0 ? "no" : "multiple") + " results");
        }
        TypeBearer typeBearer = this.results[0];
        Type type2 = typeBearer.getType();
        if (type2 == (type = this.localTarget.getType())) {
            if (bl) {
                return this.localTarget.withType(typeBearer);
            }
            return this.localTarget;
        }
        if (!Merger.isPossiblyAssignableFrom(type, type2)) {
            BaseMachine.throwLocalMismatch(type2, type);
            return null;
        }
        if (type == Type.OBJECT) {
            this.localTarget = this.localTarget.withType(typeBearer);
        }
        return this.localTarget;
    }

    protected final void clearResult() {
        this.resultCount = 0;
    }

    protected final void setResult(TypeBearer typeBearer) {
        if (typeBearer == null) {
            throw new NullPointerException("result == null");
        }
        this.results[0] = typeBearer;
        this.resultCount = 1;
    }

    protected final void addResult(TypeBearer typeBearer) {
        if (typeBearer == null) {
            throw new NullPointerException("result == null");
        }
        this.results[this.resultCount] = typeBearer;
        ++this.resultCount;
    }

    protected final int resultCount() {
        if (this.resultCount < 0) {
            throw new SimException("results never set");
        }
        return this.resultCount;
    }

    protected final int resultWidth() {
        int n = 0;
        for (int i = 0; i < this.resultCount; ++i) {
            n += this.results[i].getType().getCategory();
        }
        return n;
    }

    protected final TypeBearer result(int n) {
        if (n >= this.resultCount) {
            throw new IllegalArgumentException("n >= resultCount");
        }
        try {
            return this.results[n];
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            throw new IllegalArgumentException("n < 0");
        }
    }

    protected final void storeResults(Frame frame) {
        if (this.resultCount < 0) {
            throw new SimException("results never set");
        }
        if (this.resultCount == 0) {
            return;
        }
        if (this.localTarget != null) {
            frame.getLocals().set(this.getLocalTarget(false));
        } else {
            ExecutionStack executionStack = frame.getStack();
            for (int i = 0; i < this.resultCount; ++i) {
                if (this.localInfo) {
                    executionStack.setLocal();
                }
                executionStack.push(this.results[i]);
            }
        }
    }

    public static void throwLocalMismatch(TypeBearer typeBearer, TypeBearer typeBearer2) {
        throw new SimException("local variable type mismatch: attempt to set or access a value of type " + typeBearer.toHuman() + " using a local variable of type " + typeBearer2.toHuman() + ". This is symptomatic of .class transformation tools " + "that ignore local variable information.");
    }
}

