/*
 * Decompiled with CFR 0.152.
 */
package com.android.dex;

import com.android.dex.Dex;
import com.android.dex.DexException;
import com.android.dex.DexFormat;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.util.Arrays;

public final class TableOfContents {
    public final Section header = new Section(0);
    public final Section stringIds = new Section(1);
    public final Section typeIds = new Section(2);
    public final Section protoIds = new Section(3);
    public final Section fieldIds = new Section(4);
    public final Section methodIds = new Section(5);
    public final Section classDefs = new Section(6);
    public final Section mapList = new Section(4096);
    public final Section typeLists = new Section(4097);
    public final Section annotationSetRefLists = new Section(4098);
    public final Section annotationSets = new Section(4099);
    public final Section classDatas = new Section(8192);
    public final Section codes = new Section(8193);
    public final Section stringDatas = new Section(8194);
    public final Section debugInfos = new Section(8195);
    public final Section annotations = new Section(8196);
    public final Section encodedArrays = new Section(8197);
    public final Section annotationsDirectories = new Section(8198);
    public final Section[] sections = new Section[]{this.header, this.stringIds, this.typeIds, this.protoIds, this.fieldIds, this.methodIds, this.classDefs, this.mapList, this.typeLists, this.annotationSetRefLists, this.annotationSets, this.classDatas, this.codes, this.stringDatas, this.debugInfos, this.annotations, this.encodedArrays, this.annotationsDirectories};
    public int checksum;
    public byte[] signature = new byte[20];
    public int fileSize;
    public int linkSize;
    public int linkOff;
    public int dataSize;
    public int dataOff;

    public void readFrom(Dex dex) throws IOException {
        this.readHeader(dex.open(0));
        this.readMap(dex.open(this.mapList.off));
        this.computeSizesFromOffsets();
    }

    private void readHeader(Dex.Section section) throws UnsupportedEncodingException {
        byte[] byArray = section.readByteArray(8);
        int n = DexFormat.magicToApi(byArray);
        if (n != 13) {
            throw new DexException("Unexpected magic: " + Arrays.toString(byArray));
        }
        this.checksum = section.readInt();
        this.signature = section.readByteArray(20);
        this.fileSize = section.readInt();
        int n2 = section.readInt();
        if (n2 != 112) {
            throw new DexException("Unexpected header: 0x" + Integer.toHexString(n2));
        }
        int n3 = section.readInt();
        if (n3 != 305419896) {
            throw new DexException("Unexpected endian tag: 0x" + Integer.toHexString(n3));
        }
        this.linkSize = section.readInt();
        this.linkOff = section.readInt();
        this.mapList.off = section.readInt();
        if (this.mapList.off == 0) {
            throw new DexException("Cannot merge dex files that do not contain a map");
        }
        this.stringIds.size = section.readInt();
        this.stringIds.off = section.readInt();
        this.typeIds.size = section.readInt();
        this.typeIds.off = section.readInt();
        this.protoIds.size = section.readInt();
        this.protoIds.off = section.readInt();
        this.fieldIds.size = section.readInt();
        this.fieldIds.off = section.readInt();
        this.methodIds.size = section.readInt();
        this.methodIds.off = section.readInt();
        this.classDefs.size = section.readInt();
        this.classDefs.off = section.readInt();
        this.dataSize = section.readInt();
        this.dataOff = section.readInt();
    }

    private void readMap(Dex.Section section) throws IOException {
        int n = section.readInt();
        Section section2 = null;
        for (int i = 0; i < n; ++i) {
            short s = section.readShort();
            section.readShort();
            Section section3 = this.getSection(s);
            int n2 = section.readInt();
            int n3 = section.readInt();
            if (section3.size != 0 && section3.size != n2 || section3.off != -1 && section3.off != n3) {
                throw new DexException("Unexpected map value for 0x" + Integer.toHexString(s));
            }
            section3.size = n2;
            section3.off = n3;
            if (section2 != null && section2.off > section3.off) {
                throw new DexException("Map is unsorted at " + section2 + ", " + section3);
            }
            section2 = section3;
        }
        Arrays.sort(this.sections);
    }

    public void computeSizesFromOffsets() {
        int n = this.dataOff + this.dataSize;
        for (int i = this.sections.length - 1; i >= 0; --i) {
            Section section = this.sections[i];
            if (section.off == -1) continue;
            if (section.off > n) {
                throw new DexException("Map is unsorted at " + section);
            }
            section.byteCount = n - section.off;
            n = section.off;
        }
    }

    private Section getSection(short s) {
        for (Section section : this.sections) {
            if (section.type != s) continue;
            return section;
        }
        throw new IllegalArgumentException("No such map item: " + s);
    }

    public void writeHeader(Dex.Section section) throws IOException {
        section.write(DexFormat.apiToMagic(13).getBytes("UTF-8"));
        section.writeInt(this.checksum);
        section.write(this.signature);
        section.writeInt(this.fileSize);
        section.writeInt(112);
        section.writeInt(305419896);
        section.writeInt(this.linkSize);
        section.writeInt(this.linkOff);
        section.writeInt(this.mapList.off);
        section.writeInt(this.stringIds.size);
        section.writeInt(this.stringIds.off);
        section.writeInt(this.typeIds.size);
        section.writeInt(this.typeIds.off);
        section.writeInt(this.protoIds.size);
        section.writeInt(this.protoIds.off);
        section.writeInt(this.fieldIds.size);
        section.writeInt(this.fieldIds.off);
        section.writeInt(this.methodIds.size);
        section.writeInt(this.methodIds.off);
        section.writeInt(this.classDefs.size);
        section.writeInt(this.classDefs.off);
        section.writeInt(this.dataSize);
        section.writeInt(this.dataOff);
    }

    public void writeMap(Dex.Section section) throws IOException {
        int n = 0;
        for (Section section2 : this.sections) {
            if (!section2.exists()) continue;
            ++n;
        }
        section.writeInt(n);
        for (Section section2 : this.sections) {
            if (!section2.exists()) continue;
            section.writeShort(section2.type);
            section.writeShort((short)0);
            section.writeInt(section2.size);
            section.writeInt(section2.off);
        }
    }

    public static class Section
    implements Comparable<Section> {
        public final short type;
        public int size = 0;
        public int off = -1;
        public int byteCount = 0;

        public Section(int n) {
            this.type = (short)n;
        }

        public boolean exists() {
            return this.size > 0;
        }

        @Override
        public int compareTo(Section section) {
            if (this.off != section.off) {
                return this.off < section.off ? -1 : 1;
            }
            return 0;
        }

        public String toString() {
            return String.format("Section[type=%#x,off=%#x,size=%#x]", this.type, this.off, this.size);
        }
    }
}

