#!/usr/bin/env python

from __future__ import print_function
import argparse
import sys
from .diff import diff


def get_args():
    parser = argparse.ArgumentParser(
        prog="diffimg",
        description="Generate a diff image from two images \
            and/or find difference percentage",
    )
    parser.add_argument("image1", type=str, help="first image")
    parser.add_argument("image2", type=str, help="second image")
    parser.add_argument(
        "--ratio",
        "-r",
        dest="use_ratio",
        action="store_true",
        help="return a ratio instead of percentage",
    )
    parser.add_argument(
        "--delete",
        "-d",
        dest="delete_diff_file",
        action="store_true",
        help="delete diff image file",
    )
    parser.add_argument(
        "--filename",
        "-f",
        dest="diff_img_file",
        type=str,
        default=None,
        help="filename with valid extension to store diff image \
                (defaults to diff_img.jpg)",
    )
    parser.add_argument(
        "--ignore-alpha",
        "-ia",
        dest="ignore_alpha",
        action="store_true",
        help="ignore the alpha channel for ratio calculation \
                and diff img creation",
    )
    return parser.parse_args()


def main():
    args = get_args()
    diff_ratio = diff(
        args.image1,
        args.image2,
        delete_diff_file=args.delete_diff_file,
        diff_img_file=args.diff_img_file,
        ignore_alpha=args.ignore_alpha,
    )
    if args.use_ratio:
        print(diff_ratio)
    else:
        print("Images differ by {}%".format(diff_ratio * 100))
    return 0


if __name__ == "__main__":
    sys.exit(main())
