# Generated by the protocol buffer compiler.  DO NOT EDIT!
# sources: octave_sdk/grpc/quantummachines/octave/api/v1/api.proto
# plugin: python-betterproto
# This file has been @generated

from dataclasses import dataclass
from typing import (
    TYPE_CHECKING,
    AsyncIterable,
    AsyncIterator,
    Dict,
    Iterable,
    List,
    Optional,
    Union,
)

import betterproto
import grpclib
from betterproto.grpc.grpclib_server import ServiceBase


if TYPE_CHECKING:
    import grpclib.server
    from betterproto.grpc.grpclib_client import MetadataLike
    from grpclib.metadata import Deadline


class DeviceState(betterproto.Enum):
    UNSPECIFIED = 0
    NON_OPERATIONAL = 1
    BOOTED = 2
    CONFIGURED = 3
    CLOCK_READY = 4
    INITIALIZED = 5
    OPERATIONAL = 6
    ERRORED = 7


class DeviceError(betterproto.Enum):
    UNSPECIFIED = 0
    PLL = 1
    MOTHERBOARD_FW_UPD = 2
    MODULES_DETECT = 3
    SYNTH_FW_UPD = 4
    SYNTH_COMM = 5
    START_FPGA = 6
    ATTACH_FPGA = 7
    MAIN_PIC = 8
    GPIO_COMM = 9
    FPGA_OVERHEAT = 10
    FPGA_HW_FAIL = 11
    BAD_INPUT_CLOCK = 12
    SYNTH_OVERHEAT = 13
    SYNTH_BAD_READ = 14
    IF_DOWN_CONV_OVERHEAT = 15
    IF_DOWN_CONV_BAD_READ = 16
    RF_DOWN_CONV_OVERHEAT = 17
    RF_DOWN_CONV_BAD_READ = 18
    RF_UP_CONV_OVERHEAT = 19
    RF_UP_CONV_BAD_READ = 20


class OctaveModule(betterproto.Enum):
    UNSPECIFIED = 0
    RF_UPCONVERTER = 1
    RF_DOWNCONVERTER = 2
    IF_DOWNCONVERTER = 3
    SYNTHESIZER = 4
    MOTHERBOARD = 5
    SOM = 6


class ConstantSource(betterproto.Enum):
    UNSPECIFIED = 0
    _50_OHM = 1
    SHORT = 2
    OPEN = 3


class MonitorResponseOctaveError(betterproto.Enum):
    OCTAVE_ERROR_UNSPECIFIED = 0
    OCTAVE_ERROR_BAD_EXTERNAL_CLOCK = 1
    OCTAVE_ERROR_BAD_INTERNAL_CLOCK = 2
    OCTAVE_ERROR_FPGA_NOT_FOUND = 3
    OCTAVE_ERROR_FPGA_HW_FAIL = 4
    OCTAVE_ERROR_FPGA_BITFILE_FAIL = 5
    OCTAVE_ERROR_MODULE_NOT_FOUND = 6
    OCTAVE_ERROR_OVERHEAT = 7
    OCTAVE_ERROR_OVERHEAT_PROTECTION = 8
    OCTAVE_ERROR_READ_TEMP_FAIL = 9
    OCTAVE_ERROR_PLL_NOT_LOCKED = 10


class ControlResponseRdataDebug(betterproto.Enum):
    RDATA_DEBUG_UNSPECIFIED = 0
    RDATA_DEBUG_ERROR_RESPONSE = 160
    RDATA_DEBUG_SUCCESS_RESPONSE = 32


class RfUpConvUpdateIfInputSelection(betterproto.Enum):
    """
    IF input

       One can select two different attenuations for each input channel
       independently (which does not make too much sense). In the current setup,
       ATTN_1 to just a bypass and ATTN_2 is 10dB.

               | ATTN_1 | ATTN_2
               |  (0dB) | (10dB)
       --------+--------+--------
       SW1 (Q) | HIGH   | LOW
       SW2 (I) | HIGH   | LOW
    """

    IF_INPUT_SELECTION_UNSPECIFIED = 0
    IF_INPUT_SELECTION_PASS_THROUGH = 1
    IF_INPUT_SELECTION_ATTENUATE_10DB = 2


class RfUpConvUpdateFastSwitchMode(betterproto.Enum):
    """
    RF output switch

       The output of the up conversion circuit goes through a fast switch. It
       can be controlled in various ways. Some of them depends on the board assembly.

       Control sources:
       1. GPIO
            Will allow either a slow controlled state, or HIGH_Z to allow override.

              | ON   | OFF  | OVERRIDE
          ----+------+------+----------
          SW4 | LOW  | HIGH | HIGH_Z

          This requires the appropriate resistor should be mounted. If not, then
          it is the same as HIGH_Z

       2. DIRECT
            This is a signal that comes from an external SMA. If the external SMA goes directly
            to the switch, it will have a pull-down resistor. In that case, if it is not connected,
            the switch will be ON. If the external SMA is routed to the FPGA, the FPGA will pass it
            as is to the switch.

       3. INVERTED
            This is relevant only if the external SMA is routed to the FPGA. In that case, the
            FPGA will pass it to the switch after inversion.

       We will either use the FPGA or the GPIO to control the switch, but not both. When using the
       FPGA, ON (OFF) would mean that the FPGA outputs a HIGH (LOW) signal continuously.
    """

    FAST_SWITCH_MODE_UNSPECIFIED = 0
    FAST_SWITCH_MODE_ON = 1
    FAST_SWITCH_MODE_OFF = 2
    FAST_SWITCH_MODE_DIRECT = 3
    FAST_SWITCH_MODE_INVERTED = 4


class RfDownConvUpdateRfInput(betterproto.Enum):
    """
    RF Input:

        The are 5 debug inputs (P4, P6, P7, P9 & P3) and the main input (P1).

        SW2 select between the main input and one of the debug inputs
        SW3 selects between P3 and the rest of the debug inputs
        SW4 & SW5 selects one of the rest of the debug inputs
        SW_EN will make the 4 to 1 selector to be disconnected

              |           DEBUG inputs           |      |        |
              | 1-P4 | 2-P6 | 3-P7 | 4-P9 | 5-P3 | Main | FPGA   | DISCONNECT
        ------+------+------+------+------+------+------+--------+------------
          SW2 | HIGH | HIGH | HIGH | HIGH | HIGH | LOW  | HIGH-Z | HIGH
          SW3 | LOW  | LOW  | LOW  | LOW  | HIGH | LOW  | HIGH-Z | LOW
          SW4 | LOW  | HIGH | LOW  | HIGH | LOW  | LOW  | HIGH-Z | LOW
          SW5 | LOW  | LOW  | HIGH | HIGH | LOW  | LOW  | HIGH-Z | LOW
        SW_EN | LOW  | LOW  | LOW  | LOW  | HIGH | HIGH | HIGH-Z | HIGH

        When the output of the 4 way switch is not to be connected,
        we will disable it (SW_EN). In this case, it does not matter
        what SW4 & SW5 are, we set it to LOW.
    """

    RF_INPUT_UNSPECIFIED = 0
    RF_INPUT_DEBUG_1 = 1
    RF_INPUT_DEBUG_2 = 2
    RF_INPUT_DEBUG_3 = 3
    RF_INPUT_DEBUG_4 = 4
    RF_INPUT_DEBUG_5 = 5
    RF_INPUT_MAIN = 6
    RF_INPUT_FPGA_CONTROL = 7
    RF_INPUT_DISCONNECT = 8


class RfDownConvUpdateLoInput(betterproto.Enum):
    """
    LO Input:

        The are 2 optional LO inputs P8 & P10. SW1 selects between them.
            | 1-P8  | 2-P10 | FPGA
        ----+-------+-------+--------
        SW1 | HIGH  | LOW   | HIGH-Z
    """

    LO_INPUT_UNSPECIFIED = 0
    LO_INPUT_1 = 1
    LO_INPUT_2 = 2
    LO_INPUT_FPGA_CONTROL = 3


class IfDownConvUpdateMode(betterproto.Enum):
    """
    Mode

       Two switches are programmed (CTRL6 and CTRL1) as well as three power switches (IF_EN1 - right
       brach, IF_EN2 - mixer input and DET_EN - power detector)

                     | CTRL6  | CTRL1  | IF_EN1 | IF_EN2 | DET_EN
       --------------+--------+--------+--------+--------+--------
        OFF          | HIGH   | HIGH   | LOW    | LOW    | LOW
        BYPASS       | HIGH   | LOW    | HIGH   | LOW    | LOW
        POWER_DETECT | HIGH   | HIGH   | HIGH   | LOW    | HIGH
        MIXER        | LOW    | LOW    | LOW    | HIGH   | LOW
    """

    MODE_UNSPECIFIED = 0
    MODE_OFF = 1
    MODE_BYPASS = 2
    MODE_POWER_DETECT = 3
    MODE_MIXER = 4


class IfDownConvUpdateCoupling(betterproto.Enum):
    """
    Mode

       Two switches are programmed (CTRL4 and CTRL5)

                     | CTRL4  | CTRL5
       --------------+--------+--------
        OPEN         | LOW    | LOW
        DC           | HIGH   | LOW
        AC           | LOW    | HIGH
    """

    COUPLING_UNSPECIFIED = 0
    COUPLING_OPEN = 1
    COUPLING_DC = 2
    COUPLING_AC = 3


class ClockUpdateMode(betterproto.Enum):
    MODE_UNSPECIFIED = 0
    MODE_BUFFERED = 1
    MODE_EXTERNAL = 2
    MODE_INTERNAL = 3


class SynthUpdateReferenceSource(betterproto.Enum):
    REFERENCE_SOURCE_UNSPECIFIED = 0
    REFERENCE_SOURCE_INTERNAL = 1
    REFERENCE_SOURCE_EXTERNAL = 2


class SynthUpdateSynthOutputPower(betterproto.Enum):
    SYNTH_OUTPUT_POWER_UNSPECIFIED = 0
    SYNTH_OUTPUT_POWER_NEG4DB = 1
    SYNTH_OUTPUT_POWER_NEG1DB = 2
    SYNTH_OUTPUT_POWER_POS2DB = 3
    SYNTH_OUTPUT_POWER_POS5DB = 4


class SynthUpdateMainSource(betterproto.Enum):
    MAIN_SOURCE_UNSPECIFIED = 0
    MAIN_SOURCE_EXTERNAL = 1
    MAIN_SOURCE_SYNTHESIZER = 2


class SynthUpdateMainOutput(betterproto.Enum):
    MAIN_OUTPUT_UNSPECIFIED = 0
    MAIN_OUTPUT_MAIN = 1
    MAIN_OUTPUT_OFF = 2
    MAIN_OUTPUT_FPGA_CONTROL = 3


class SynthUpdateSecondaryOutput(betterproto.Enum):
    SECONDARY_OUTPUT_UNSPECIFIED = 0
    SECONDARY_OUTPUT_MAIN = 1
    SECONDARY_OUTPUT_AUXILARY = 2
    SECONDARY_OUTPUT_OFF = 3
    SECONDARY_OUTPUT_FPGA_CONTROL = 4


class SynthRfOutputOutputPort(betterproto.Enum):
    OUTPUT_PORT_UNSPECIFIED = 0
    OUTPUT_PORT_SYNTH = 1
    OUTPUT_PORT_MAIN = 2
    OUTPUT_PORT_SECONDARY = 3


class RfDownConvIfSourceOutputPort(betterproto.Enum):
    OUTPUT_PORT_UNSPECIFIED = 0
    OUTPUT_PORT_I = 1
    OUTPUT_PORT_Q = 2


@dataclass(eq=False, repr=False)
class SubscribeStateRequest(betterproto.Message):
    pass


@dataclass(eq=False, repr=False)
class SubscribeStateResponse(betterproto.Message):
    state: "DeviceState" = betterproto.enum_field(1)
    error: "DeviceError" = betterproto.enum_field(2)


@dataclass(eq=False, repr=False)
class ResetRequest(betterproto.Message):
    pass


@dataclass(eq=False, repr=False)
class ResetResponse(betterproto.Message):
    is_success: bool = betterproto.bool_field(1)
    error_message: str = betterproto.string_field(2)


@dataclass(eq=False, repr=False)
class HealthRequest(betterproto.Message):
    """
    Server expects one HealthRequest, other messages are not used server gRPC is sync => block until the stream ends
    """

    monitor_interval_seconds: int = betterproto.uint32_field(1)
    """
    Request monitor interval min value:
     monitor_interval=MIN(monitor_interval_seconds,monitor_interval_debug_param)
    """

    stop_stream: bool = betterproto.bool_field(2)
    """Not used, left for future code (Async gRPC)"""


@dataclass(eq=False, repr=False)
class HealthResponse(betterproto.Message):
    explore: "ExploreResponse" = betterproto.message_field(1)
    monitor: "MonitorResponse" = betterproto.message_field(2)


@dataclass(eq=False, repr=False)
class GetVersionRequest(betterproto.Message):
    pass


@dataclass(eq=False, repr=False)
class GetVersionResponse(betterproto.Message):
    version: str = betterproto.string_field(1)


@dataclass(eq=False, repr=False)
class ModuleReference(betterproto.Message):
    type: "OctaveModule" = betterproto.enum_field(1)
    index: int = betterproto.int32_field(2)


@dataclass(eq=False, repr=False)
class SaveRequest(betterproto.Message):
    id: str = betterproto.string_field(1)
    modules: List["ModuleReference"] = betterproto.message_field(2)
    overwrite: bool = betterproto.bool_field(3)
    timestamp: int = betterproto.int64_field(4)


@dataclass(eq=False, repr=False)
class SaveResponse(betterproto.Message):
    success: bool = betterproto.bool_field(1)
    message: str = betterproto.string_field(2)


@dataclass(eq=False, repr=False)
class RecallRequest(betterproto.Message):
    id: str = betterproto.string_field(1)


@dataclass(eq=False, repr=False)
class RecallResponse(betterproto.Message):
    success: bool = betterproto.bool_field(1)
    error_message: str = betterproto.string_field(2)


@dataclass(eq=False, repr=False)
class ListRequest(betterproto.Message):
    pass


@dataclass(eq=False, repr=False)
class SaveInfo(betterproto.Message):
    request: "SaveRequest" = betterproto.message_field(1)
    content: "UpdateRequest" = betterproto.message_field(2)


@dataclass(eq=False, repr=False)
class ListResponse(betterproto.Message):
    save_infos: List["SaveInfo"] = betterproto.message_field(1)


@dataclass(eq=False, repr=False)
class MonitorRequest(betterproto.Message):
    sense_only: bool = betterproto.bool_field(1)


@dataclass(eq=False, repr=False)
class MonitorResponse(betterproto.Message):
    modules: List["MonitorResponseModuleStatus"] = betterproto.message_field(1)


@dataclass(eq=False, repr=False)
class MonitorResponseModuleStatusError(betterproto.Message):
    type: "MonitorResponseOctaveError" = betterproto.enum_field(1)


@dataclass(eq=False, repr=False)
class MonitorResponseModuleStatus(betterproto.Message):
    module: "ModuleReference" = betterproto.message_field(1)
    temperature: float = betterproto.float_field(2)
    errors: List["MonitorResponseModuleStatusError"] = betterproto.message_field(3)


@dataclass(eq=False, repr=False)
class ControlRequest(betterproto.Message):
    w_data: bytes = betterproto.bytes_field(1)
    r_length: int = betterproto.int32_field(2)


@dataclass(eq=False, repr=False)
class ControlResponse(betterproto.Message):
    r_data: bytes = betterproto.bytes_field(1)
    """
    r_data will hold the number of written bytes OR RdataDebug enum in case of debug params
    """


@dataclass(eq=False, repr=False)
class ExploreRequest(betterproto.Message):
    pass


@dataclass(eq=False, repr=False)
class ExploreResponse(betterproto.Message):
    modules: List["ExploreResponseModuleId"] = betterproto.message_field(1)


@dataclass(eq=False, repr=False)
class ExploreResponseModuleId(betterproto.Message):
    module: "ModuleReference" = betterproto.message_field(1)
    id: str = betterproto.string_field(2)


@dataclass(eq=False, repr=False)
class UpdateRequest(betterproto.Message):
    updates: List["SingleUpdate"] = betterproto.message_field(1)


@dataclass(eq=False, repr=False)
class UpdateResponse(betterproto.Message):
    success: bool = betterproto.bool_field(1)
    error_message: str = betterproto.string_field(2)


@dataclass(eq=False, repr=False)
class SingleUpdate(betterproto.Message):
    rf_up_conv: "RfUpConvUpdate" = betterproto.message_field(1, group="update")
    rf_down_conv: "RfDownConvUpdate" = betterproto.message_field(2, group="update")
    if_down_conv: "IfDownConvUpdate" = betterproto.message_field(3, group="update")
    synth: "SynthUpdate" = betterproto.message_field(4, group="update")
    clock: "ClockUpdate" = betterproto.message_field(5, group="update")
    motherboard: "MotherboardUpdate" = betterproto.message_field(6, group="update")


@dataclass(eq=False, repr=False)
class RfUpConvUpdate(betterproto.Message):
    index: int = betterproto.uint32_field(1)
    input_attn: "RfUpConvUpdateIfInputSelection" = betterproto.enum_field(2)
    enabled: Optional[bool] = betterproto.message_field(3, wraps=betterproto.TYPE_BOOL)
    """
    Enabled
    
     Both LO amplifier and the mixer amplifier must be
    
                | Enabled | Disabled
      ----------+---------+----------
      10V_LO_EN | HIGH    | LOW
          8V_EN | HIGH    | LOW
    """

    mixer_output_attn: Optional[int] = betterproto.message_field(
        4, wraps=betterproto.TYPE_UINT32
    )
    """ATTB_[0-5], 6 bits."""

    power_amp_enabled: Optional[bool] = betterproto.message_field(
        5, wraps=betterproto.TYPE_BOOL
    )
    """
    power_amp_enabled
    
       The amplified mixer output can be amplified again (with a varible gain), or
       simply bypassed. The power amp should be enabled accordigly.
    
              | enabled | disabled
       -------+--------+----------
       SW3    | LOW     | HIGH
       10V_EN | HIGH    | LOW
    """

    power_amp_attn: Optional[int] = betterproto.message_field(
        6, wraps=betterproto.TYPE_UINT32
    )
    """ATTA_[0-5], 6 bits. (relevant only if rf_pwr_sel is HIGH)"""

    fast_switch_mode: "RfUpConvUpdateFastSwitchMode" = betterproto.enum_field(7)


@dataclass(eq=False, repr=False)
class RfDownConvUpdate(betterproto.Message):
    index: int = betterproto.uint32_field(1)
    rf_input: "RfDownConvUpdateRfInput" = betterproto.enum_field(2)
    lo_input: "RfDownConvUpdateLoInput" = betterproto.enum_field(3)
    enabled: Optional[bool] = betterproto.message_field(4, wraps=betterproto.TYPE_BOOL)
    """P_EN enables the 5.0V power."""


@dataclass(eq=False, repr=False)
class IfDownConvUpdate(betterproto.Message):
    index: int = betterproto.uint32_field(1)
    channel1: "IfDownConvUpdateChannel" = betterproto.message_field(2)
    channel2: "IfDownConvUpdateChannel" = betterproto.message_field(3)


@dataclass(eq=False, repr=False)
class IfDownConvUpdateChannel(betterproto.Message):
    mode: "IfDownConvUpdateMode" = betterproto.enum_field(1)
    coupling: "IfDownConvUpdateCoupling" = betterproto.enum_field(2)


@dataclass(eq=False, repr=False)
class ClockUpdate(betterproto.Message):
    mode: "ClockUpdateMode" = betterproto.enum_field(2)
    """
    There are there general modes:
     1. BUFFERED - The clock distributor will use the external clock and apply divider at most (no PLL)
     2. INTERNAL - Use only internal crystals to achieve the desired output clocks
     3. EXTERNAL - Use PLLs to lock the VCO on an external clock
    
     Both 1. and 3. requires the frequency of the external clock. In case 2., the clock_frequency field is ignored.
    
     Modes 2. and 3. has a variant of using an external 1GHz VCXO, instead of the LMK internal 3GHz VCO.
    
     clock_frequency is in Hz.
    """

    clock_frequency: Optional[float] = betterproto.message_field(
        3, wraps=betterproto.TYPE_DOUBLE
    )
    synthesizers_clock: Optional[float] = betterproto.message_field(
        4, wraps=betterproto.TYPE_DOUBLE
    )
    """
    This is the clock frequency expected by the synthesizers (by default it is 125MHz, but you may change it).
    
     It is important to understand the relation between the synthesizers_clock and the above congiuration. The clocks
     sent to the synthesizers must be an interger division of the "main" clock. The ratio can not exceed 31.
    
     In mode 1., the "main" clock is simply the external clock. For example, if you use an OPT's output (1GHz) and the
     desired synthesizer's clock is 125MHz, it is a division by 8 (which is perfectly fine). You can use the 500MHz NEL
     source as well, and the division will be 4.
    
     In modes 2. and 3., if NOT using the external 1GHz VCXO, we first lock an internal 3GHz VCO and this is the "main" clock.
     Again, if we assume 125MHz clock for the synthesizers, the divider is 24. This is absolutely fine as well.
    
     In modes 2. and 3., if USING the external 1GHz VCXO, the "main" clock is 1GHz.
    
     Note that, for example, you can clock the synthesizers at 62.5MHz if using 1GHz VXO, but not if you don't!
    """

    clustered: Optional[bool] = betterproto.bool_field(5, optional=True)
    """
    This field is used when Octave clock is configured by Gateway when part of cluster mode
    """


@dataclass(eq=False, repr=False)
class MotherboardUpdate(betterproto.Message):
    fan_speed: Optional[float] = betterproto.message_field(
        1, wraps=betterproto.TYPE_DOUBLE
    )


@dataclass(eq=False, repr=False)
class SynthUpdate(betterproto.Message):
    index: int = betterproto.uint32_field(1)
    reference_clock: "SynthUpdateReferenceClock" = betterproto.message_field(2)
    synth_output: "SynthUpdateSynthOutput" = betterproto.message_field(3)
    synth_output_power: "SynthUpdateSynthOutputPower" = betterproto.enum_field(4)
    heater: Optional[int] = betterproto.message_field(5, wraps=betterproto.TYPE_UINT32)
    gain: Optional[int] = betterproto.message_field(6, wraps=betterproto.TYPE_UINT32)
    digital_attn: Optional[int] = betterproto.message_field(
        7, wraps=betterproto.TYPE_UINT32
    )
    """
    Digital attenuator
    
       If the internal synth. generates any tone, the right channel must be selected and then it reaches a 
       programable attenuator. The attenuation will be a 6-bits number times 0.5dB.
    
       If specified, the following steps are applied:
       1. set DIGI_ATT_EN to LOW (*)
       2. set DIGI_ATT[5:0] to digital_attn
       3. set DIGI_ATT_EN to HIGH
    
       (*) DIGI_ATT_EN is constantly HIGH in general.
    """

    main_source: "SynthUpdateMainSource" = betterproto.enum_field(8)
    """
    Main source
    
        The main source select between the EXTERNAL LO input and the internal synth's output.
    
             | EXTERNAL | SYNTHESIZER | FPGA_CONTROL
        -----+----------+-------------+---------------
        SW3  | HIGH     | LOW         | HIGH_Z
    """

    main_output: "SynthUpdateMainOutput" = betterproto.enum_field(9)
    """
    Main output
    
        The main output (P6) is either either ON or OFF. When it is on, it will
        output the LO-source after amplification.
    
             | ON   | OFF  | FPGA_CONTROL
        -----+------+------+---------------
        SW6  | LOW  | HIGH | HIGH_Z
    """

    secondary_output: "SynthUpdateSecondaryOutput" = betterproto.enum_field(10)
    """
    Secondary output
    
        The secondary output (P4) can output the LO-source (like the main output), the
        additional external LO source (P5) or none (OFF).
        output the LO-source after amplification.
    
             | MAIN  | OFF  | AUXILARY_LO | FPGA_CONTROL
        -----+-------+------+-------------+----------------------
        SW4  | HIGH  | HIGH | LOW         | HIGH_Z
        SW5  | HIGH  | LOW  | LOW         | HIGH_Z
    """

    stabilizer: "SynthUpdateStabilizer" = betterproto.message_field(11)


@dataclass(eq=False, repr=False)
class SynthUpdateReferenceClock(betterproto.Message):
    source: "SynthUpdateReferenceSource" = betterproto.enum_field(1)
    frequency: Optional[float] = betterproto.message_field(
        2, wraps=betterproto.TYPE_DOUBLE
    )
    divider: Optional[int] = betterproto.message_field(3, wraps=betterproto.TYPE_INT32)


@dataclass(eq=False, repr=False)
class SynthUpdateSynthOutput(betterproto.Message):
    frequency: Optional[float] = betterproto.message_field(
        1, wraps=betterproto.TYPE_DOUBLE, group="update"
    )
    disabled: Optional[bool] = betterproto.message_field(
        2, wraps=betterproto.TYPE_BOOL, group="update"
    )


@dataclass(eq=False, repr=False)
class SynthUpdateStabilizer(betterproto.Message):
    k_p: Optional[float] = betterproto.message_field(1, wraps=betterproto.TYPE_FLOAT)
    k_i: Optional[float] = betterproto.message_field(2, wraps=betterproto.TYPE_FLOAT)
    k_d: Optional[float] = betterproto.message_field(3, wraps=betterproto.TYPE_FLOAT)
    a: Optional[float] = betterproto.message_field(4, wraps=betterproto.TYPE_FLOAT)
    b: Optional[float] = betterproto.message_field(5, wraps=betterproto.TYPE_FLOAT)
    heater_max: Optional[int] = betterproto.message_field(
        6, wraps=betterproto.TYPE_UINT32
    )
    set_point: Optional[float] = betterproto.message_field(
        7, wraps=betterproto.TYPE_FLOAT
    )
    enabled: Optional[bool] = betterproto.message_field(8, wraps=betterproto.TYPE_BOOL)


@dataclass(eq=False, repr=False)
class AquireRequest(betterproto.Message):
    modules: List["ModuleReference"] = betterproto.message_field(1)
    use_cache: bool = betterproto.bool_field(2)


@dataclass(eq=False, repr=False)
class AquireResponse(betterproto.Message):
    state: "UpdateRequest" = betterproto.message_field(1)


@dataclass(eq=False, repr=False)
class IdentifyRequest(betterproto.Message):
    pass


@dataclass(eq=False, repr=False)
class IdentifyResponse(betterproto.Message):
    """IdentifyResponse"""

    rf_up_converters: List["RfUpConvIdentity"] = betterproto.message_field(1)
    rf_down_converters: List["RfDownConvIdentity"] = betterproto.message_field(2)
    if_down_converters: List["IfDownConvIdentity"] = betterproto.message_field(3)
    synthesizers: List["SynthIdentity"] = betterproto.message_field(4)
    panel_identity: "PanelIdentity" = betterproto.message_field(5)


@dataclass(eq=False, repr=False)
class UpConvRfOutput(betterproto.Message):
    """
    RF UpConv output

        The RF up conv. board has only one output. This is the modulated signal. The board index is
        sufficient to identify it.
    """

    index: int = betterproto.uint32_field(1)


@dataclass(eq=False, repr=False)
class SynthRfOutput(betterproto.Message):
    """
    Synthesizer output

        The synthesizer board has three output:

        1. SYNTH output:
                The output of the synth. is split. One part is routed to an SMA connector (this
                is the Synth. output, P1). The other part will potentially make its way to the
                other outputs.

                (*) Note that the internal Synth may be disabled and nothing will come out of this
                output.

        2. MAIN output
                One of the (amplified) Synth. output OR the (amplified) main LO input (P3) OR zero
                signal may be routed to this output.

                (*) This outpot port is intended to be connected to an UpConv. board LO input,
                but not neccessary.

        3. SECONDATY output
                This port can either output a copy of the MAIN output OR the secondary input LO
                (P5).

                (*) Outputing two copies of the same LO is needed for readout, or to keep coherence
                between two qubits.
    """

    index: int = betterproto.uint32_field(1)
    output_port: "SynthRfOutputOutputPort" = betterproto.enum_field(2)


@dataclass(eq=False, repr=False)
class ExternalRfInput(betterproto.Message):
    lo_input_index: int = betterproto.uint32_field(1, group="input")
    demod_lo_input_index: int = betterproto.uint32_field(2, group="input")
    rf_in_index: int = betterproto.uint32_field(3, group="input")


@dataclass(eq=False, repr=False)
class RfSource(betterproto.Message):
    rf_up_conv_output: "UpConvRfOutput" = betterproto.message_field(1, group="source")
    synth_output: "SynthRfOutput" = betterproto.message_field(2, group="source")
    external_input: "ExternalRfInput" = betterproto.message_field(3, group="source")
    constant_source: "ConstantSource" = betterproto.enum_field(4, group="source")


@dataclass(eq=False, repr=False)
class RfDownConvIfSource(betterproto.Message):
    index: int = betterproto.uint32_field(1)
    output_port: "RfDownConvIfSourceOutputPort" = betterproto.enum_field(2)


@dataclass(eq=False, repr=False)
class IfDownConvIfSource(betterproto.Message):
    index: int = betterproto.uint32_field(1)
    channel_index: int = betterproto.uint32_field(2)


@dataclass(eq=False, repr=False)
class ExternalIfInput(betterproto.Message):
    i_index: int = betterproto.uint32_field(1, group="input")
    q_index: int = betterproto.uint32_field(2, group="input")
    if_lo_i_index: int = betterproto.uint32_field(3, group="input")
    if_lo_q_index: int = betterproto.uint32_field(4, group="input")


@dataclass(eq=False, repr=False)
class IfSource(betterproto.Message):
    rf_downconv_if_source: "RfDownConvIfSource" = betterproto.message_field(
        1, group="source"
    )
    if_downconv_if_source: "IfDownConvIfSource" = betterproto.message_field(
        2, group="source"
    )
    external_if_input: "ExternalIfInput" = betterproto.message_field(3, group="source")
    constant_source: "ConstantSource" = betterproto.enum_field(4, group="source")


@dataclass(eq=False, repr=False)
class RfUpConvIdentity(betterproto.Message):
    index: int = betterproto.uint32_field(1)
    connectivity: "RfUpConvIdentityConnectivity" = betterproto.message_field(2)
    parameters: "RfUpConvIdentityParameters" = betterproto.message_field(3)


@dataclass(eq=False, repr=False)
class RfUpConvIdentityConnectivity(betterproto.Message):
    i_input: "IfSource" = betterproto.message_field(1)
    q_input: "IfSource" = betterproto.message_field(2)
    lo_input: "RfSource" = betterproto.message_field(3)


@dataclass(eq=False, repr=False)
class RfUpConvIdentityParameters(betterproto.Message):
    attn_1_db: float = betterproto.float_field(1)
    attn_2_db: float = betterproto.float_field(2)


@dataclass(eq=False, repr=False)
class RfDownConvIdentity(betterproto.Message):
    index: int = betterproto.uint32_field(1)
    connectivity: "RfDownConvIdentityConnectivity" = betterproto.message_field(2)


@dataclass(eq=False, repr=False)
class RfDownConvIdentityConnectivity(betterproto.Message):
    debug_rf_input_1: "RfSource" = betterproto.message_field(1)
    debug_rf_input_2: "RfSource" = betterproto.message_field(2)
    debug_rf_input_3: "RfSource" = betterproto.message_field(3)
    debug_rf_input_4: "RfSource" = betterproto.message_field(4)
    debug_rf_input_5: "RfSource" = betterproto.message_field(5)
    rf_main_input: "RfSource" = betterproto.message_field(6)
    lo_input_1: "RfSource" = betterproto.message_field(7)
    lo_input_2: "RfSource" = betterproto.message_field(8)


@dataclass(eq=False, repr=False)
class IfDownConvIdentity(betterproto.Message):
    index: int = betterproto.uint32_field(1)
    connectivity: "IfDownConvIdentityConnectivity" = betterproto.message_field(2)


@dataclass(eq=False, repr=False)
class IfDownConvIdentityConnectivity(betterproto.Message):
    channel_1_input: "IfSource" = betterproto.message_field(1)
    channel_1_lo_input: "IfSource" = betterproto.message_field(2)
    channel_2_input: "IfSource" = betterproto.message_field(3)
    channel_2_lo_input: "IfSource" = betterproto.message_field(4)


@dataclass(eq=False, repr=False)
class SynthIdentity(betterproto.Message):
    index: int = betterproto.uint32_field(1)
    connectivity: "SynthIdentityConnectivity" = betterproto.message_field(2)
    parameters: "SynthIdentityParameters" = betterproto.message_field(3)


@dataclass(eq=False, repr=False)
class SynthIdentityConnectivity(betterproto.Message):
    main_lo_input: "RfSource" = betterproto.message_field(1)
    secondary_lo_input: "RfSource" = betterproto.message_field(2)


@dataclass(eq=False, repr=False)
class SynthIdentityParameters(betterproto.Message):
    low_frequency_filters: List["SynthIdentityParametersLowFrequencyFilter"] = (
        betterproto.message_field(1)
    )
    medium_frequency_filter: "SynthIdentityParametersParametrizedFilter" = (
        betterproto.message_field(2)
    )
    high_frequency_filter: "SynthIdentityParametersParametrizedFilter" = (
        betterproto.message_field(3)
    )


@dataclass(eq=False, repr=False)
class SynthIdentityParametersLowFrequencyFilter(betterproto.Message):
    index: int = betterproto.uint32_field(1)
    filter_1: str = betterproto.string_field(2)
    filter_2: str = betterproto.string_field(3)


@dataclass(eq=False, repr=False)
class SynthIdentityParametersParametrizedFilter(betterproto.Message):
    pass


@dataclass(eq=False, repr=False)
class PanelIdentity(betterproto.Message):
    rf_outputs: List["PanelIdentityRfOutput"] = betterproto.message_field(1)
    if_output_i: List["IfSource"] = betterproto.message_field(2)
    if_output_q: List["IfSource"] = betterproto.message_field(3)
    synth_outputs: List["PanelIdentitySynthOutput"] = betterproto.message_field(4)


@dataclass(eq=False, repr=False)
class PanelIdentityRfOutput(betterproto.Message):
    index: int = betterproto.uint32_field(1)
    source: "RfSource" = betterproto.message_field(2)


@dataclass(eq=False, repr=False)
class PanelIdentitySynthOutput(betterproto.Message):
    index: int = betterproto.uint32_field(1)
    source: "RfSource" = betterproto.message_field(2)


@dataclass(eq=False, repr=False)
class MotherboardStatus(betterproto.Message):
    valid_1_g_vco: bool = betterproto.bool_field(1)


class OctaveServiceStub(betterproto.ServiceStub):
    async def subscribe_state(
        self,
        subscribe_state_request: "SubscribeStateRequest",
        *,
        timeout: Optional[float] = None,
        deadline: Optional["Deadline"] = None,
        metadata: Optional["MetadataLike"] = None
    ) -> AsyncIterator[SubscribeStateResponse]:
        async for response in self._unary_stream(
            "/quantummachines.octave.api.v1.OctaveService/SubscribeState",
            subscribe_state_request,
            SubscribeStateResponse,
            timeout=timeout,
            deadline=deadline,
            metadata=metadata,
        ):
            yield response

    async def get_version(
        self,
        get_version_request: "GetVersionRequest",
        *,
        timeout: Optional[float] = None,
        deadline: Optional["Deadline"] = None,
        metadata: Optional["MetadataLike"] = None
    ) -> "GetVersionResponse":
        return await self._unary_unary(
            "/quantummachines.octave.api.v1.OctaveService/GetVersion",
            get_version_request,
            GetVersionResponse,
            timeout=timeout,
            deadline=deadline,
            metadata=metadata,
        )

    async def control(
        self,
        control_request: "ControlRequest",
        *,
        timeout: Optional[float] = None,
        deadline: Optional["Deadline"] = None,
        metadata: Optional["MetadataLike"] = None
    ) -> "ControlResponse":
        return await self._unary_unary(
            "/quantummachines.octave.api.v1.OctaveService/Control",
            control_request,
            ControlResponse,
            timeout=timeout,
            deadline=deadline,
            metadata=metadata,
        )

    async def update(
        self,
        update_request: "UpdateRequest",
        *,
        timeout: Optional[float] = None,
        deadline: Optional["Deadline"] = None,
        metadata: Optional["MetadataLike"] = None
    ) -> "UpdateResponse":
        return await self._unary_unary(
            "/quantummachines.octave.api.v1.OctaveService/Update",
            update_request,
            UpdateResponse,
            timeout=timeout,
            deadline=deadline,
            metadata=metadata,
        )

    async def aquire(
        self,
        aquire_request: "AquireRequest",
        *,
        timeout: Optional[float] = None,
        deadline: Optional["Deadline"] = None,
        metadata: Optional["MetadataLike"] = None
    ) -> "AquireResponse":
        return await self._unary_unary(
            "/quantummachines.octave.api.v1.OctaveService/Aquire",
            aquire_request,
            AquireResponse,
            timeout=timeout,
            deadline=deadline,
            metadata=metadata,
        )

    async def identify(
        self,
        identify_request: "IdentifyRequest",
        *,
        timeout: Optional[float] = None,
        deadline: Optional["Deadline"] = None,
        metadata: Optional["MetadataLike"] = None
    ) -> "IdentifyResponse":
        return await self._unary_unary(
            "/quantummachines.octave.api.v1.OctaveService/Identify",
            identify_request,
            IdentifyResponse,
            timeout=timeout,
            deadline=deadline,
            metadata=metadata,
        )

    async def monitor(
        self,
        monitor_request: "MonitorRequest",
        *,
        timeout: Optional[float] = None,
        deadline: Optional["Deadline"] = None,
        metadata: Optional["MetadataLike"] = None
    ) -> "MonitorResponse":
        return await self._unary_unary(
            "/quantummachines.octave.api.v1.OctaveService/Monitor",
            monitor_request,
            MonitorResponse,
            timeout=timeout,
            deadline=deadline,
            metadata=metadata,
        )

    async def explore(
        self,
        explore_request: "ExploreRequest",
        *,
        timeout: Optional[float] = None,
        deadline: Optional["Deadline"] = None,
        metadata: Optional["MetadataLike"] = None
    ) -> "ExploreResponse":
        return await self._unary_unary(
            "/quantummachines.octave.api.v1.OctaveService/Explore",
            explore_request,
            ExploreResponse,
            timeout=timeout,
            deadline=deadline,
            metadata=metadata,
        )

    async def save(
        self,
        save_request: "SaveRequest",
        *,
        timeout: Optional[float] = None,
        deadline: Optional["Deadline"] = None,
        metadata: Optional["MetadataLike"] = None
    ) -> "SaveResponse":
        return await self._unary_unary(
            "/quantummachines.octave.api.v1.OctaveService/Save",
            save_request,
            SaveResponse,
            timeout=timeout,
            deadline=deadline,
            metadata=metadata,
        )

    async def recall(
        self,
        recall_request: "RecallRequest",
        *,
        timeout: Optional[float] = None,
        deadline: Optional["Deadline"] = None,
        metadata: Optional["MetadataLike"] = None
    ) -> "RecallResponse":
        return await self._unary_unary(
            "/quantummachines.octave.api.v1.OctaveService/Recall",
            recall_request,
            RecallResponse,
            timeout=timeout,
            deadline=deadline,
            metadata=metadata,
        )

    async def list(
        self,
        list_request: "ListRequest",
        *,
        timeout: Optional[float] = None,
        deadline: Optional["Deadline"] = None,
        metadata: Optional["MetadataLike"] = None
    ) -> "ListResponse":
        return await self._unary_unary(
            "/quantummachines.octave.api.v1.OctaveService/List",
            list_request,
            ListResponse,
            timeout=timeout,
            deadline=deadline,
            metadata=metadata,
        )

    async def reset(
        self,
        reset_request: "ResetRequest",
        *,
        timeout: Optional[float] = None,
        deadline: Optional["Deadline"] = None,
        metadata: Optional["MetadataLike"] = None
    ) -> "ResetResponse":
        return await self._unary_unary(
            "/quantummachines.octave.api.v1.OctaveService/Reset",
            reset_request,
            ResetResponse,
            timeout=timeout,
            deadline=deadline,
            metadata=metadata,
        )

    async def health(
        self,
        health_request_iterator: Union[
            AsyncIterable[HealthRequest], Iterable[HealthRequest]
        ],
        *,
        timeout: Optional[float] = None,
        deadline: Optional["Deadline"] = None,
        metadata: Optional["MetadataLike"] = None
    ) -> AsyncIterator[HealthResponse]:
        async for response in self._stream_stream(
            "/quantummachines.octave.api.v1.OctaveService/Health",
            health_request_iterator,
            HealthRequest,
            HealthResponse,
            timeout=timeout,
            deadline=deadline,
            metadata=metadata,
        ):
            yield response


class OctaveServiceBase(ServiceBase):

    async def subscribe_state(
        self, subscribe_state_request: "SubscribeStateRequest"
    ) -> AsyncIterator[SubscribeStateResponse]:
        raise grpclib.GRPCError(grpclib.const.Status.UNIMPLEMENTED)
        yield SubscribeStateResponse()

    async def get_version(
        self, get_version_request: "GetVersionRequest"
    ) -> "GetVersionResponse":
        raise grpclib.GRPCError(grpclib.const.Status.UNIMPLEMENTED)

    async def control(self, control_request: "ControlRequest") -> "ControlResponse":
        raise grpclib.GRPCError(grpclib.const.Status.UNIMPLEMENTED)

    async def update(self, update_request: "UpdateRequest") -> "UpdateResponse":
        raise grpclib.GRPCError(grpclib.const.Status.UNIMPLEMENTED)

    async def aquire(self, aquire_request: "AquireRequest") -> "AquireResponse":
        raise grpclib.GRPCError(grpclib.const.Status.UNIMPLEMENTED)

    async def identify(self, identify_request: "IdentifyRequest") -> "IdentifyResponse":
        raise grpclib.GRPCError(grpclib.const.Status.UNIMPLEMENTED)

    async def monitor(self, monitor_request: "MonitorRequest") -> "MonitorResponse":
        raise grpclib.GRPCError(grpclib.const.Status.UNIMPLEMENTED)

    async def explore(self, explore_request: "ExploreRequest") -> "ExploreResponse":
        raise grpclib.GRPCError(grpclib.const.Status.UNIMPLEMENTED)

    async def save(self, save_request: "SaveRequest") -> "SaveResponse":
        raise grpclib.GRPCError(grpclib.const.Status.UNIMPLEMENTED)

    async def recall(self, recall_request: "RecallRequest") -> "RecallResponse":
        raise grpclib.GRPCError(grpclib.const.Status.UNIMPLEMENTED)

    async def list(self, list_request: "ListRequest") -> "ListResponse":
        raise grpclib.GRPCError(grpclib.const.Status.UNIMPLEMENTED)

    async def reset(self, reset_request: "ResetRequest") -> "ResetResponse":
        raise grpclib.GRPCError(grpclib.const.Status.UNIMPLEMENTED)

    async def health(
        self, health_request_iterator: AsyncIterator[HealthRequest]
    ) -> AsyncIterator[HealthResponse]:
        raise grpclib.GRPCError(grpclib.const.Status.UNIMPLEMENTED)
        yield HealthResponse()

    async def __rpc_subscribe_state(
        self,
        stream: "grpclib.server.Stream[SubscribeStateRequest, SubscribeStateResponse]",
    ) -> None:
        request = await stream.recv_message()
        await self._call_rpc_handler_server_stream(
            self.subscribe_state,
            stream,
            request,
        )

    async def __rpc_get_version(
        self, stream: "grpclib.server.Stream[GetVersionRequest, GetVersionResponse]"
    ) -> None:
        request = await stream.recv_message()
        response = await self.get_version(request)
        await stream.send_message(response)

    async def __rpc_control(
        self, stream: "grpclib.server.Stream[ControlRequest, ControlResponse]"
    ) -> None:
        request = await stream.recv_message()
        response = await self.control(request)
        await stream.send_message(response)

    async def __rpc_update(
        self, stream: "grpclib.server.Stream[UpdateRequest, UpdateResponse]"
    ) -> None:
        request = await stream.recv_message()
        response = await self.update(request)
        await stream.send_message(response)

    async def __rpc_aquire(
        self, stream: "grpclib.server.Stream[AquireRequest, AquireResponse]"
    ) -> None:
        request = await stream.recv_message()
        response = await self.aquire(request)
        await stream.send_message(response)

    async def __rpc_identify(
        self, stream: "grpclib.server.Stream[IdentifyRequest, IdentifyResponse]"
    ) -> None:
        request = await stream.recv_message()
        response = await self.identify(request)
        await stream.send_message(response)

    async def __rpc_monitor(
        self, stream: "grpclib.server.Stream[MonitorRequest, MonitorResponse]"
    ) -> None:
        request = await stream.recv_message()
        response = await self.monitor(request)
        await stream.send_message(response)

    async def __rpc_explore(
        self, stream: "grpclib.server.Stream[ExploreRequest, ExploreResponse]"
    ) -> None:
        request = await stream.recv_message()
        response = await self.explore(request)
        await stream.send_message(response)

    async def __rpc_save(
        self, stream: "grpclib.server.Stream[SaveRequest, SaveResponse]"
    ) -> None:
        request = await stream.recv_message()
        response = await self.save(request)
        await stream.send_message(response)

    async def __rpc_recall(
        self, stream: "grpclib.server.Stream[RecallRequest, RecallResponse]"
    ) -> None:
        request = await stream.recv_message()
        response = await self.recall(request)
        await stream.send_message(response)

    async def __rpc_list(
        self, stream: "grpclib.server.Stream[ListRequest, ListResponse]"
    ) -> None:
        request = await stream.recv_message()
        response = await self.list(request)
        await stream.send_message(response)

    async def __rpc_reset(
        self, stream: "grpclib.server.Stream[ResetRequest, ResetResponse]"
    ) -> None:
        request = await stream.recv_message()
        response = await self.reset(request)
        await stream.send_message(response)

    async def __rpc_health(
        self, stream: "grpclib.server.Stream[HealthRequest, HealthResponse]"
    ) -> None:
        request = stream.__aiter__()
        await self._call_rpc_handler_server_stream(
            self.health,
            stream,
            request,
        )

    def __mapping__(self) -> Dict[str, grpclib.const.Handler]:
        return {
            "/quantummachines.octave.api.v1.OctaveService/SubscribeState": grpclib.const.Handler(
                self.__rpc_subscribe_state,
                grpclib.const.Cardinality.UNARY_STREAM,
                SubscribeStateRequest,
                SubscribeStateResponse,
            ),
            "/quantummachines.octave.api.v1.OctaveService/GetVersion": grpclib.const.Handler(
                self.__rpc_get_version,
                grpclib.const.Cardinality.UNARY_UNARY,
                GetVersionRequest,
                GetVersionResponse,
            ),
            "/quantummachines.octave.api.v1.OctaveService/Control": grpclib.const.Handler(
                self.__rpc_control,
                grpclib.const.Cardinality.UNARY_UNARY,
                ControlRequest,
                ControlResponse,
            ),
            "/quantummachines.octave.api.v1.OctaveService/Update": grpclib.const.Handler(
                self.__rpc_update,
                grpclib.const.Cardinality.UNARY_UNARY,
                UpdateRequest,
                UpdateResponse,
            ),
            "/quantummachines.octave.api.v1.OctaveService/Aquire": grpclib.const.Handler(
                self.__rpc_aquire,
                grpclib.const.Cardinality.UNARY_UNARY,
                AquireRequest,
                AquireResponse,
            ),
            "/quantummachines.octave.api.v1.OctaveService/Identify": grpclib.const.Handler(
                self.__rpc_identify,
                grpclib.const.Cardinality.UNARY_UNARY,
                IdentifyRequest,
                IdentifyResponse,
            ),
            "/quantummachines.octave.api.v1.OctaveService/Monitor": grpclib.const.Handler(
                self.__rpc_monitor,
                grpclib.const.Cardinality.UNARY_UNARY,
                MonitorRequest,
                MonitorResponse,
            ),
            "/quantummachines.octave.api.v1.OctaveService/Explore": grpclib.const.Handler(
                self.__rpc_explore,
                grpclib.const.Cardinality.UNARY_UNARY,
                ExploreRequest,
                ExploreResponse,
            ),
            "/quantummachines.octave.api.v1.OctaveService/Save": grpclib.const.Handler(
                self.__rpc_save,
                grpclib.const.Cardinality.UNARY_UNARY,
                SaveRequest,
                SaveResponse,
            ),
            "/quantummachines.octave.api.v1.OctaveService/Recall": grpclib.const.Handler(
                self.__rpc_recall,
                grpclib.const.Cardinality.UNARY_UNARY,
                RecallRequest,
                RecallResponse,
            ),
            "/quantummachines.octave.api.v1.OctaveService/List": grpclib.const.Handler(
                self.__rpc_list,
                grpclib.const.Cardinality.UNARY_UNARY,
                ListRequest,
                ListResponse,
            ),
            "/quantummachines.octave.api.v1.OctaveService/Reset": grpclib.const.Handler(
                self.__rpc_reset,
                grpclib.const.Cardinality.UNARY_UNARY,
                ResetRequest,
                ResetResponse,
            ),
            "/quantummachines.octave.api.v1.OctaveService/Health": grpclib.const.Handler(
                self.__rpc_health,
                grpclib.const.Cardinality.STREAM_STREAM,
                HealthRequest,
                HealthResponse,
            ),
        }
