from flowui.logger import get_configured_logger
from datetime import datetime
import requests
from urllib.parse import urljoin
import os


class FlowuiBackendRestClient(requests.Session):
    def __init__(self, base_url: str = None, *args, **kwargs):
        super(FlowuiBackendRestClient, self).__init__(*args, **kwargs)
        self.logger = get_configured_logger(self.__class__.__name__)
        if base_url:
            self.base_url = base_url
        else:
            self.base_url = os.environ.get("FLOWUI_BACKEND_HOST", "http://localhost:8000")

    def request(self, method, resource, **kwargs):
        try:
            url = urljoin(self.base_url, resource)
            return super(FlowuiBackendRestClient, self).request(method, url, **kwargs)
        except Exception as e:
            self.logger.exception(e)
            raise e

    def health_check(self):
        resource = "/health-check"
        response = self.request(
            method="get",
            resource=resource
        )
        return response

    def get_operator_secrets(self, operator_repository_id: int, operator_name: str):
        resource = f"/operators-repositories/{operator_repository_id}/secrets/{operator_name}"
        response = self.request(
            method='get',
            resource=resource
        )
        return response

    def get_operator_repository(self, operator_repository_id: int):
        resource = f"/operators-repositories/{operator_repository_id}"
        response = self.request(
            method='get',
            resource=resource
        )
        return response

    def get_operator_repositories(self, workspace_id: int, filters: dict):
        resource = f"/workspaces/{workspace_id}/operators-repositories"
        response = self.request(
            method='get',
            resource=resource,
            params=filters
        )
        return response
