drop table tab_account;
drop table tab_card;
drop table tab_client;
drop table tab_disp;
drop table tab_district;
drop table tab_order;
drop table tab_trans;
drop table _relaggs;

create table tab_account
(loan_id int not null,
account_id int not null,
district_id int not null,
frequency varchar(32),
a_date date,
primary key(account_id));

create table tab_card
(loan_id int not null,
card_id int,
disp_id int,
type varchar(32),
issued date);

create table tab_client
(loan_id int not null,
client_id int not null,
district_id int not null,
birthday date,
sex char,
primary key(client_id));

create table tab_disp
(loan_id int not null,
disp_id int not null,
account_id int not null,
client_id int not null,
type varchar(32),
primary key (disp_id));

create table tab_district
(loan_id int not null,
district_id int not null,
a2 varchar(32),
a3 varchar(32),
a4 int,
a5 int,
a6 int,
a7 int,
a8 int,
a9 int,
a10 double,
a11 int,
a12 double,
a13 double,
a14 int,
a15 int,
a16 int);

create table tab_loan
(loan_id int not null,
account_id int not null,
l_date date,
amount int,
duration int,
payments double,
status char,
primary key(loan_id));

create table tab_order
(loan_id int not null,
order_id int not null,
account_id int not null,
bank_to varchar(32),
account_to varchar(32),
amount double,
k_symbol varchar(32),
primary key(order_id));

create table tab_trans
(loan_id int not null,
trans_id int not null,
account_id int not null,
t_date date,
type varchar(32),
operation varchar(32),
amount double,
balance double,
k_symbol varchar(32),
bank varchar(32),
account varchar(32),
primary key(trans_id));

insert into tab_account values (4959,2,1,'POPLATEK MESICNE','1993-2-26');
insert into tab_account values (4961,19,21,'POPLATEK MESICNE','1995-4-7');
insert into tab_account values (4962,25,68,'POPLATEK MESICNE','1996-7-28');
insert into tab_account values (4967,37,20,'POPLATEK MESICNE','1997-8-18');
insert into tab_account values (4968,38,19,'POPLATEK TYDNE','1997-8-8');
insert into tab_account values (4973,67,16,'POPLATEK MESICNE','1994-10-19');
insert into tab_account values (4986,97,74,'POPLATEK MESICNE','1996-5-5');
insert into tab_account values (4988,103,44,'POPLATEK MESICNE','1996-3-10');
insert into tab_account values (4989,105,21,'POPLATEK MESICNE','1997-7-10');
insert into tab_account values (4990,110,36,'POPLATEK MESICNE','1996-7-17');
insert into tab_account values (4996,132,40,'POPLATEK PO OBRATU','1996-5-11');
insert into tab_account values (5002,173,66,'POPLATEK MESICNE','1993-11-26');
insert into tab_account values (5005,176,71,'POPLATEK TYDNE','1996-8-12');
insert into tab_account values (5015,226,70,'POPLATEK MESICNE','1997-2-23');
insert into tab_account values (5027,276,38,'POPLATEK MESICNE','1997-12-8');
insert into tab_account values (5032,290,56,'POPLATEK MESICNE','1993-12-2');
insert into tab_account values (5034,303,71,'POPLATEK MESICNE','1996-7-25');
insert into tab_account values (5036,309,14,'POPLATEK MESICNE','1997-4-25');
insert into tab_account values (5039,314,15,'POPLATEK PO OBRATU','1996-1-26');
insert into tab_account values (5041,319,47,'POPLATEK TYDNE','1995-10-17');
insert into tab_account values (5042,330,42,'POPLATEK MESICNE','1996-11-24');
insert into tab_account values (5043,339,46,'POPLATEK TYDNE','1996-9-11');
insert into tab_account values (5044,344,54,'POPLATEK MESICNE','1993-12-1');
insert into tab_account values (5045,347,65,'POPLATEK MESICNE','1993-12-13');
insert into tab_account values (5046,349,72,'POPLATEK MESICNE','1997-6-8');
insert into tab_account values (5051,378,68,'POPLATEK MESICNE','1996-7-22');
insert into tab_account values (5060,426,1,'POPLATEK MESICNE','1993-11-29');
insert into tab_account values (5061,440,29,'POPLATEK MESICNE','1996-12-22');
insert into tab_account values (5063,442,54,'POPLATEK MESICNE','1997-3-30');
insert into tab_account values (5072,472,8,'POPLATEK MESICNE','1996-10-11');
insert into tab_account values (5082,501,13,'POPLATEK MESICNE','1995-10-21');
insert into tab_account values (5086,525,70,'POPLATEK MESICNE','1996-3-20');
insert into tab_account values (5088,544,32,'POPLATEK MESICNE','1995-5-15');
insert into tab_account values (5103,666,27,'POPLATEK MESICNE','1996-3-15');
insert into tab_account values (5110,675,58,'POPLATEK MESICNE','1995-8-3');
insert into tab_account values (5117,718,1,'POPLATEK MESICNE','1996-3-3');
insert into tab_account values (5124,785,21,'POPLATEK TYDNE','1997-8-9');
insert into tab_account values (5125,789,39,'POPLATEK MESICNE','1995-2-6');
insert into tab_account values (5126,790,54,'POPLATEK MESICNE','1993-5-11');
insert into tab_account values (5128,808,69,'POPLATEK MESICNE','1995-6-13');
insert into tab_account values (5130,813,16,'POPLATEK MESICNE','1993-2-10');
insert into tab_account values (5131,816,52,'POPLATEK MESICNE','1993-8-5');
insert into tab_account values (5132,817,5,'POPLATEK MESICNE','1994-3-18');
insert into tab_account values (5134,825,19,'POPLATEK MESICNE','1996-3-6');
insert into tab_account values (5136,846,72,'POPLATEK MESICNE','1996-3-9');
insert into tab_account values (5138,854,62,'POPLATEK MESICNE','1993-9-21');
insert into tab_account values (5140,873,73,'POPLATEK MESICNE','1997-4-26');
insert into tab_account values (5145,915,72,'POPLATEK MESICNE','1995-1-18');
insert into tab_account values (5147,938,70,'POPLATEK MESICNE','1997-12-13');
insert into tab_account values (5148,940,37,'POPLATEK MESICNE','1994-11-15');
insert into tab_account values (5151,960,4,'POPLATEK PO OBRATU','1994-11-2');
insert into tab_account values (5154,993,6,'POPLATEK MESICNE','1996-11-14');
insert into tab_account values (5158,1004,70,'POPLATEK MESICNE','1996-7-2');
insert into tab_account values (5160,1011,45,'POPLATEK MESICNE','1994-12-17');
insert into tab_account values (5161,1012,65,'POPLATEK MESICNE','1994-7-9');
insert into tab_account values (5169,1068,52,'POPLATEK MESICNE','1997-2-15');
insert into tab_account values (5170,1071,68,'POPLATEK TYDNE','1993-5-10');
insert into tab_account values (5172,1083,45,'POPLATEK MESICNE','1996-12-6');
insert into tab_account values (5174,1093,54,'POPLATEK MESICNE','1996-1-14');
insert into tab_account values (5176,1106,20,'POPLATEK TYDNE','1993-8-29');
insert into tab_account values (5189,1166,11,'POPLATEK MESICNE','1993-4-21');
insert into tab_account values (5206,1242,74,'POPLATEK PO OBRATU','1996-11-24');
insert into tab_account values (5207,1244,68,'POPLATEK MESICNE','1996-5-8');
insert into tab_account values (5208,1247,25,'POPLATEK MESICNE','1993-6-8');
insert into tab_account values (5209,1250,62,'POPLATEK MESICNE','1996-3-28');
insert into tab_account values (5210,1252,13,'POPLATEK TYDNE','1995-7-26');
insert into tab_account values (5212,1256,38,'POPLATEK MESICNE','1994-4-21');
insert into tab_account values (5214,1270,55,'POPLATEK PO OBRATU','1996-6-7');
insert into tab_account values (5221,1284,55,'POPLATEK MESICNE','1997-7-2');
insert into tab_account values (5226,1318,56,'POPLATEK MESICNE','1997-12-22');
insert into tab_account values (5229,1329,53,'POPLATEK MESICNE','1996-9-16');
insert into tab_account values (5236,1374,53,'POPLATEK MESICNE','1996-9-26');
insert into tab_account values (5237,1375,19,'POPLATEK MESICNE','1994-4-27');
insert into tab_account values (5241,1389,34,'POPLATEK MESICNE','1997-8-5');
insert into tab_account values (5245,1407,19,'POPLATEK PO OBRATU','1997-4-11');
insert into tab_account values (5253,1447,65,'POPLATEK MESICNE','1997-2-20');
insert into tab_account values (5260,1480,41,'POPLATEK TYDNE','1996-7-3');
insert into tab_account values (5265,1498,62,'POPLATEK TYDNE','1997-2-7');
insert into tab_account values (5269,1527,31,'POPLATEK PO OBRATU','1993-11-17');
insert into tab_account values (5270,1528,50,'POPLATEK MESICNE','1996-6-8');
insert into tab_account values (5281,1580,69,'POPLATEK MESICNE','1996-1-8');
insert into tab_account values (5282,1583,69,'POPLATEK PO OBRATU','1994-11-17');
insert into tab_account values (5285,1603,1,'POPLATEK MESICNE','1993-5-9');
insert into tab_account values (5287,1638,6,'POPLATEK TYDNE','1996-11-12');
insert into tab_account values (5293,1656,47,'POPLATEK MESICNE','1997-2-1');
insert into tab_account values (5301,1698,68,'POPLATEK MESICNE','1996-3-14');
insert into tab_account values (5304,1718,71,'POPLATEK MESICNE','1997-9-23');
insert into tab_account values (5310,1762,28,'POPLATEK MESICNE','1993-12-11');
insert into tab_account values (5311,1766,28,'POPLATEK MESICNE','1994-9-3');
insert into tab_account values (5312,1772,31,'POPLATEK TYDNE','1995-2-20');
insert into tab_account values (5313,1776,36,'POPLATEK MESICNE','1997-7-27');
insert into tab_account values (5314,1787,30,'POPLATEK TYDNE','1993-3-22');
insert into tab_account values (5316,1801,46,'POPLATEK MESICNE','1993-2-13');
insert into tab_account values (5318,1808,28,'POPLATEK MESICNE','1997-5-16');
insert into tab_account values (5319,1811,40,'POPLATEK MESICNE','1993-9-22');
insert into tab_account values (5320,1819,55,'POPLATEK TYDNE','1996-10-21');
insert into tab_account values (5325,1843,12,'POPLATEK MESICNE','1993-1-30');
insert into tab_account values (5329,1862,19,'POPLATEK TYDNE','1995-4-15');
insert into tab_account values (5332,1869,1,'POPLATEK MESICNE','1996-6-14');
insert into tab_account values (5334,1876,1,'POPLATEK MESICNE','1997-9-20');
insert into tab_account values (5337,1886,32,'POPLATEK MESICNE','1996-3-5');
insert into tab_account values (5338,1888,6,'POPLATEK MESICNE','1996-10-21');
insert into tab_account values (5343,1906,1,'POPLATEK MESICNE','1996-8-1');
insert into tab_account values (5346,1928,70,'POPLATEK MESICNE','1997-3-2');
insert into tab_account values (5350,1967,26,'POPLATEK TYDNE','1995-2-13');
insert into tab_account values (5351,1978,57,'POPLATEK TYDNE','1993-6-11');
insert into tab_account values (5352,1993,68,'POPLATEK MESICNE','1994-10-30');
insert into tab_account values (5354,2000,5,'POPLATEK MESICNE','1997-8-6');
insert into tab_account values (5358,2018,42,'POPLATEK MESICNE','1995-6-4');
insert into tab_account values (5360,2035,53,'POPLATEK MESICNE','1996-5-10');
insert into tab_account values (5363,2051,64,'POPLATEK TYDNE','1995-11-8');
insert into tab_account values (5365,2055,37,'POPLATEK MESICNE','1997-4-17');
insert into tab_account values (5366,2062,70,'POPLATEK MESICNE','1996-3-6');
insert into tab_account values (5367,2064,54,'POPLATEK MESICNE','1996-12-30');
insert into tab_account values (5368,2073,59,'POPLATEK MESICNE','1997-8-14');
insert into tab_account values (5369,2080,74,'POPLATEK MESICNE','1997-4-27');
insert into tab_account values (5375,2106,1,'POPLATEK MESICNE','1996-2-1');
insert into tab_account values (5377,2116,70,'POPLATEK MESICNE','1996-5-2');
insert into tab_account values (5382,2134,52,'POPLATEK MESICNE','1996-8-6');
insert into tab_account values (5384,2142,42,'POPLATEK MESICNE','1997-9-1');
insert into tab_account values (5385,2143,1,'POPLATEK MESICNE','1996-1-13');
insert into tab_account values (5388,2153,31,'POPLATEK TYDNE','1996-1-7');
insert into tab_account values (5389,2165,51,'POPLATEK MESICNE','1997-4-8');
insert into tab_account values (5390,2167,16,'POPLATEK MESICNE','1993-8-8');
insert into tab_account values (5395,2176,67,'POPLATEK MESICNE','1993-6-6');
insert into tab_account values (5398,2187,9,'POPLATEK TYDNE','1996-2-26');
insert into tab_account values (5409,2218,19,'POPLATEK MESICNE','1994-11-21');
insert into tab_account values (5413,2227,31,'POPLATEK TYDNE','1994-5-22');
insert into tab_account values (5414,2228,34,'POPLATEK MESICNE','1994-3-19');
insert into tab_account values (5415,2236,73,'POPLATEK MESICNE','1995-8-27');
insert into tab_account values (5418,2245,29,'POPLATEK MESICNE','1993-3-30');
insert into tab_account values (5419,2246,1,'POPLATEK MESICNE','1996-4-25');
insert into tab_account values (5420,2247,24,'POPLATEK MESICNE','1996-4-13');
insert into tab_account values (5428,2262,13,'POPLATEK MESICNE','1997-2-8');
insert into tab_account values (5429,2268,1,'POPLATEK MESICNE','1995-2-11');
insert into tab_account values (5435,2279,2,'POPLATEK TYDNE','1996-10-30');
insert into tab_account values (5445,2322,33,'POPLATEK MESICNE','1995-1-2');
insert into tab_account values (5446,2334,50,'POPLATEK MESICNE','1996-3-19');
insert into tab_account values (5447,2335,70,'POPLATEK MESICNE','1996-4-4');
insert into tab_account values (5449,2343,68,'POPLATEK MESICNE','1994-12-9');
insert into tab_account values (5450,2345,5,'POPLATEK MESICNE','1993-10-25');
insert into tab_account values (5451,2350,18,'POPLATEK MESICNE','1996-8-4');
insert into tab_account values (5452,2352,70,'POPLATEK MESICNE','1995-1-21');
insert into tab_account values (5453,2361,28,'POPLATEK MESICNE','1994-2-25');
insert into tab_account values (5463,2413,33,'POPLATEK MESICNE','1997-10-27');
insert into tab_account values (5464,2419,24,'POPLATEK MESICNE','1993-11-27');
insert into tab_account values (5469,2445,52,'POPLATEK MESICNE','1996-7-7');
insert into tab_account values (5470,2456,65,'POPLATEK MESICNE','1995-9-9');
insert into tab_account values (5479,2486,1,'POPLATEK MESICNE','1993-2-27');
insert into tab_account values (5482,2496,51,'POPLATEK MESICNE','1994-5-21');
insert into tab_account values (5486,2516,6,'POPLATEK MESICNE','1995-11-16');
insert into tab_account values (5491,2545,1,'POPLATEK MESICNE','1996-12-4');
insert into tab_account values (5494,2572,64,'POPLATEK PO OBRATU','1994-11-13');
insert into tab_account values (5495,2580,60,'POPLATEK MESICNE','1995-11-9');
insert into tab_account values (5501,2622,1,'POPLATEK MESICNE','1996-8-21');
insert into tab_account values (5519,2694,7,'POPLATEK MESICNE','1993-3-8');
insert into tab_account values (5520,2699,73,'POPLATEK MESICNE','1996-12-25');
insert into tab_account values (5523,2705,63,'POPLATEK PO OBRATU','1993-7-5');
insert into tab_account values (5525,2720,2,'POPLATEK TYDNE','1997-6-16');
insert into tab_account values (5526,2725,52,'POPLATEK MESICNE','1997-4-2');
insert into tab_account values (5527,2728,52,'POPLATEK TYDNE','1997-7-6');
insert into tab_account values (5531,2753,26,'POPLATEK MESICNE','1996-2-13');
insert into tab_account values (5532,2754,57,'POPLATEK TYDNE','1996-1-26');
insert into tab_account values (5533,2762,19,'POPLATEK MESICNE','1993-3-20');
insert into tab_account values (5549,2824,11,'POPLATEK MESICNE','1993-10-20');
insert into tab_account values (5556,2872,1,'POPLATEK MESICNE','1996-9-4');
insert into tab_account values (5561,2910,68,'POPLATEK MESICNE','1997-10-21');
insert into tab_account values (5563,2912,74,'POPLATEK MESICNE','1994-7-30');
insert into tab_account values (5568,2933,10,'POPLATEK MESICNE','1993-6-18');
insert into tab_account values (5569,2936,3,'POPLATEK MESICNE','1996-3-27');
insert into tab_account values (5576,2962,1,'POPLATEK MESICNE','1993-5-30');
insert into tab_account values (5582,2982,19,'POPLATEK MESICNE','1996-6-4');
insert into tab_account values (5584,2986,63,'POPLATEK MESICNE','1996-4-9');
insert into tab_account values (5585,2988,66,'POPLATEK PO OBRATU','1996-10-14');
insert into tab_account values (5586,2994,77,'POPLATEK MESICNE','1996-5-3');
insert into tab_account values (5589,3005,42,'POPLATEK PO OBRATU','1997-1-11');
insert into tab_account values (5591,3021,10,'POPLATEK MESICNE','1996-4-20');
insert into tab_account values (5593,3037,44,'POPLATEK MESICNE','1994-5-26');
insert into tab_account values (5595,3050,60,'POPLATEK MESICNE','1993-5-8');
insert into tab_account values (5599,3064,40,'POPLATEK MESICNE','1993-5-23');
insert into tab_account values (5606,3084,59,'POPLATEK TYDNE','1996-1-28');
insert into tab_account values (5610,3112,38,'POPLATEK MESICNE','1994-8-12');
insert into tab_account values (5611,3115,14,'POPLATEK MESICNE','1996-3-27');
insert into tab_account values (5614,3137,39,'POPLATEK MESICNE','1996-12-15');
insert into tab_account values (5616,3143,38,'POPLATEK MESICNE','1996-10-18');
insert into tab_account values (5620,3161,48,'POPLATEK MESICNE','1996-8-26');
insert into tab_account values (5624,3166,71,'POPLATEK MESICNE','1993-8-10');
insert into tab_account values (5625,3189,29,'POPLATEK MESICNE','1995-11-29');
insert into tab_account values (5634,3229,64,'POPLATEK MESICNE','1995-11-18');
insert into tab_account values (5635,3230,1,'POPLATEK MESICNE','1995-3-11');
insert into tab_account values (5638,3249,74,'POPLATEK MESICNE','1996-10-11');
insert into tab_account values (5643,3273,74,'POPLATEK MESICNE','1995-12-29');
insert into tab_account values (5644,3293,1,'POPLATEK MESICNE','1997-8-8');
insert into tab_account values (5651,3329,3,'POPLATEK MESICNE','1996-10-12');
insert into tab_account values (5656,3353,74,'POPLATEK MESICNE','1996-8-27');
insert into tab_account values (5657,3354,63,'POPLATEK MESICNE','1993-11-5');
insert into tab_account values (5665,3390,12,'POPLATEK TYDNE','1996-12-22');
insert into tab_account values (5669,3403,63,'POPLATEK MESICNE','1997-5-20');
insert into tab_account values (5674,3418,42,'POPLATEK PO OBRATU','1996-9-2');
insert into tab_account values (5681,3448,58,'POPLATEK TYDNE','1996-6-6');
insert into tab_account values (5682,3455,34,'POPLATEK MESICNE','1996-3-13');
insert into tab_account values (5683,3460,16,'POPLATEK MESICNE','1997-4-8');
insert into tab_account values (5693,3489,9,'POPLATEK MESICNE','1994-12-8');
insert into tab_account values (5698,3556,58,'POPLATEK MESICNE','1997-8-29');
insert into tab_account values (5699,3562,50,'POPLATEK MESICNE','1996-7-19');
insert into tab_account values (5706,3608,72,'POPLATEK TYDNE','1994-8-30');
insert into tab_account values (5713,3629,48,'POPLATEK MESICNE','1993-7-27');
insert into tab_account values (5718,3637,53,'POPLATEK MESICNE','1995-10-28');
insert into tab_account values (5719,3664,1,'POPLATEK MESICNE','1996-4-28');
insert into tab_account values (5723,3674,38,'POPLATEK MESICNE','1993-3-12');
insert into tab_account values (5724,3678,1,'POPLATEK MESICNE','1993-3-24');
insert into tab_account values (5725,3679,64,'POPLATEK MESICNE','1995-8-15');
insert into tab_account values (5731,3711,3,'POPLATEK MESICNE','1997-5-8');
insert into tab_account values (5739,3747,1,'POPLATEK MESICNE','1994-5-1');
insert into tab_account values (5740,3752,1,'POPLATEK MESICNE','1994-11-25');
insert into tab_account values (5741,3754,37,'POPLATEK TYDNE','1996-2-19');
insert into tab_account values (5750,3804,7,'POPLATEK MESICNE','1994-4-7');
insert into tab_account values (5754,3834,54,'POPLATEK MESICNE','1993-1-19');
insert into tab_account values (5758,3859,53,'POPLATEK MESICNE','1996-4-23');
insert into tab_account values (5760,3862,1,'POPLATEK MESICNE','1996-11-23');
insert into tab_account values (5765,3875,44,'POPLATEK MESICNE','1997-10-18');
insert into tab_account values (5772,3906,52,'POPLATEK MESICNE','1997-7-8');
insert into tab_account values (5773,3907,37,'POPLATEK MESICNE','1996-4-18');
insert into tab_account values (5774,3916,8,'POPLATEK MESICNE','1997-9-28');
insert into tab_account values (5779,3942,27,'POPLATEK TYDNE','1996-5-10');
insert into tab_account values (5782,3953,1,'POPLATEK MESICNE','1997-6-16');
insert into tab_account values (5784,3967,54,'POPLATEK MESICNE','1996-9-22');
insert into tab_account values (5790,4033,57,'POPLATEK MESICNE','1996-11-19');
insert into tab_account values (5799,4052,36,'POPLATEK TYDNE','1997-1-25');
insert into tab_account values (5804,4079,52,'POPLATEK MESICNE','1993-11-3');
insert into tab_account values (5805,4081,11,'POPLATEK MESICNE','1995-7-22');
insert into tab_account values (5808,4099,54,'POPLATEK MESICNE','1996-5-26');
insert into tab_account values (5815,4116,6,'POPLATEK MESICNE','1997-10-5');
insert into tab_account values (5817,4127,50,'POPLATEK MESICNE','1996-5-3');
insert into tab_account values (5823,4144,1,'POPLATEK MESICNE','1996-8-19');
insert into tab_account values (5830,4190,62,'POPLATEK MESICNE','1995-10-4');
insert into tab_account values (5836,4259,66,'POPLATEK MESICNE','1994-4-8');
insert into tab_account values (5837,4260,56,'POPLATEK MESICNE','1993-10-14');
insert into tab_account values (5841,4268,77,'POPLATEK MESICNE','1997-2-20');
insert into tab_account values (5850,4293,64,'POPLATEK PO OBRATU','1996-2-4');
insert into tab_account values (5856,4320,61,'POPLATEK MESICNE','1996-7-23');
insert into tab_account values (5861,4337,29,'POPLATEK MESICNE','1993-11-16');
insert into tab_account values (5862,4342,74,'POPLATEK MESICNE','1996-4-29');
insert into tab_account values (5865,4354,38,'POPLATEK MESICNE','1997-1-8');
insert into tab_account values (5868,4361,69,'POPLATEK MESICNE','1996-3-11');
insert into tab_account values (5876,4413,74,'POPLATEK TYDNE','1994-1-15');
insert into tab_account values (5877,4414,24,'POPLATEK MESICNE','1993-9-10');
insert into tab_account values (5878,4415,73,'POPLATEK MESICNE','1995-7-5');
insert into tab_account values (5880,4423,39,'POPLATEK MESICNE','1995-4-26');
insert into tab_account values (5882,4427,32,'POPLATEK MESICNE','1993-6-7');
insert into tab_account values (5886,4447,62,'POPLATEK MESICNE','1996-6-16');
insert into tab_account values (5887,4448,60,'POPLATEK MESICNE','1993-6-2');
insert into tab_account values (5889,4456,14,'POPLATEK MESICNE','1996-9-3');
insert into tab_account values (5892,4462,73,'POPLATEK TYDNE','1995-12-27');
insert into tab_account values (5893,4467,17,'POPLATEK TYDNE','1997-4-13');
insert into tab_account values (5895,4473,45,'POPLATEK MESICNE','1995-10-9');
insert into tab_account values (5897,4476,24,'POPLATEK MESICNE','1994-11-10');
insert into tab_account values (5900,4503,50,'POPLATEK MESICNE','1995-1-3');
insert into tab_account values (5906,4533,68,'POPLATEK MESICNE','1997-8-3');
insert into tab_account values (5909,4550,56,'POPLATEK MESICNE','1997-2-6');
insert into tab_account values (5918,4576,27,'POPLATEK MESICNE','1993-6-5');
insert into tab_account values (5922,4580,9,'POPLATEK MESICNE','1994-8-27');
insert into tab_account values (5923,4585,27,'POPLATEK MESICNE','1996-6-8');
insert into tab_account values (5930,4616,1,'POPLATEK MESICNE','1997-9-24');
insert into tab_account values (5931,4618,3,'POPLATEK MESICNE','1996-7-21');
insert into tab_account values (5932,4626,9,'POPLATEK MESICNE','1996-6-15');
insert into tab_account values (5933,4631,77,'POPLATEK PO OBRATU','1996-12-12');
insert into tab_account values (5938,4650,4,'POPLATEK MESICNE','1995-10-15');
insert into tab_account values (5940,4660,63,'POPLATEK MESICNE','1997-1-3');
insert into tab_account values (5942,4681,70,'POPLATEK MESICNE','1995-8-8');
insert into tab_account values (5953,4715,8,'POPLATEK MESICNE','1996-10-28');
insert into tab_account values (5956,4725,73,'POPLATEK MESICNE','1997-4-14');
insert into tab_account values (5959,4727,2,'POPLATEK MESICNE','1995-2-13');
insert into tab_account values (5963,4746,54,'POPLATEK MESICNE','1997-2-21');
insert into tab_account values (5970,4774,66,'POPLATEK MESICNE','1994-1-14');
insert into tab_account values (5973,4784,46,'POPLATEK MESICNE','1997-8-8');
insert into tab_account values (5976,4794,72,'POPLATEK MESICNE','1996-12-18');
insert into tab_account values (5977,4803,26,'POPLATEK MESICNE','1996-6-8');
insert into tab_account values (5980,4825,15,'POPLATEK MESICNE','1994-6-4');
insert into tab_account values (5988,4851,52,'POPLATEK MESICNE','1996-2-4');
insert into tab_account values (5989,4852,47,'POPLATEK MESICNE','1995-4-13');
insert into tab_account values (5991,4858,67,'POPLATEK MESICNE','1997-6-21');
insert into tab_account values (5992,4863,5,'POPLATEK MESICNE','1996-3-12');
insert into tab_account values (5997,4894,14,'POPLATEK MESICNE','1993-6-20');
insert into tab_account values (5999,4907,42,'POPLATEK MESICNE','1994-2-6');
insert into tab_account values (6004,4937,12,'POPLATEK MESICNE','1993-2-20');
insert into tab_account values (6006,4948,43,'POPLATEK MESICNE','1995-7-29');
insert into tab_account values (6007,4949,33,'POPLATEK MESICNE','1996-10-14');
insert into tab_account values (6010,4969,60,'POPLATEK TYDNE','1996-8-19');
insert into tab_account values (6011,4981,54,'POPLATEK MESICNE','1996-1-22');
insert into tab_account values (6012,4994,1,'POPLATEK TYDNE','1996-1-11');
insert into tab_account values (6013,4995,20,'POPLATEK TYDNE','1994-8-1');
insert into tab_account values (6014,4999,1,'POPLATEK MESICNE','1996-2-12');
insert into tab_account values (6015,5001,53,'POPLATEK MESICNE','1995-12-15');
insert into tab_account values (6019,5033,54,'POPLATEK MESICNE','1995-8-3');
insert into tab_account values (6027,5066,13,'POPLATEK TYDNE','1995-8-27');
insert into tab_account values (6028,5072,6,'POPLATEK MESICNE','1996-4-12');
insert into tab_account values (6037,5118,72,'POPLATEK MESICNE','1995-8-5');
insert into tab_account values (6038,5120,1,'POPLATEK MESICNE','1993-6-21');
insert into tab_account values (6043,5126,58,'POPLATEK MESICNE','1995-4-3');
insert into tab_account values (6044,5133,68,'POPLATEK TYDNE','1996-12-8');
insert into tab_account values (6052,5164,5,'POPLATEK MESICNE','1997-5-13');
insert into tab_account values (6054,5180,54,'POPLATEK MESICNE','1997-2-24');
insert into tab_account values (6055,5181,75,'POPLATEK MESICNE','1996-2-3');
insert into tab_account values (6059,5196,13,'POPLATEK TYDNE','1997-6-29');
insert into tab_account values (6063,5213,1,'POPLATEK MESICNE','1995-8-18');
insert into tab_account values (6064,5215,55,'POPLATEK MESICNE','1993-7-1');
insert into tab_account values (6066,5228,77,'POPLATEK PO OBRATU','1993-6-23');
insert into tab_account values (6072,5256,72,'POPLATEK PO OBRATU','1993-10-25');
insert into tab_account values (6073,5263,64,'POPLATEK MESICNE','1995-7-14');
insert into tab_account values (6075,5267,4,'POPLATEK MESICNE','1996-1-12');
insert into tab_account values (6076,5269,49,'POPLATEK MESICNE','1996-7-4');
insert into tab_account values (6077,5270,44,'POPLATEK MESICNE','1993-1-13');
insert into tab_account values (6078,5283,15,'POPLATEK MESICNE','1997-9-18');
insert into tab_account values (6083,5305,47,'POPLATEK MESICNE','1996-9-16');
insert into tab_account values (6087,5313,40,'POPLATEK MESICNE','1993-4-29');
insert into tab_account values (6088,5317,28,'POPLATEK MESICNE','1996-10-20');
insert into tab_account values (6095,5358,4,'POPLATEK MESICNE','1995-5-18');
insert into tab_account values (6097,5362,76,'POPLATEK TYDNE','1996-9-6');
insert into tab_account values (6103,5385,44,'POPLATEK TYDNE','1993-5-21');
insert into tab_account values (6104,5395,47,'POPLATEK MESICNE','1996-4-26');
insert into tab_account values (6109,5422,66,'POPLATEK MESICNE','1994-10-22');
insert into tab_account values (6111,5428,24,'POPLATEK MESICNE','1993-4-14');
insert into tab_account values (6112,5442,34,'POPLATEK MESICNE','1993-3-22');
insert into tab_account values (6113,5445,72,'POPLATEK MESICNE','1997-2-19');
insert into tab_account values (6118,5477,57,'POPLATEK MESICNE','1995-12-17');
insert into tab_account values (6120,5481,52,'POPLATEK MESICNE','1993-8-16');
insert into tab_account values (6130,5541,43,'POPLATEK MESICNE','1995-3-24');
insert into tab_account values (6136,5572,15,'POPLATEK MESICNE','1997-8-11');
insert into tab_account values (6137,5574,13,'POPLATEK TYDNE','1994-7-14');
insert into tab_account values (6142,5591,9,'POPLATEK MESICNE','1996-3-16');
insert into tab_account values (6144,5593,15,'POPLATEK MESICNE','1996-2-27');
insert into tab_account values (6147,5602,19,'POPLATEK PO OBRATU','1996-7-10');
insert into tab_account values (6150,5622,70,'POPLATEK MESICNE','1993-2-8');
insert into tab_account values (6151,5628,61,'POPLATEK MESICNE','1994-6-17');
insert into tab_account values (6153,5632,5,'POPLATEK TYDNE','1994-11-15');
insert into tab_account values (6157,5650,10,'POPLATEK PO OBRATU','1995-1-8');
insert into tab_account values (6168,5698,1,'POPLATEK MESICNE','1997-9-4');
insert into tab_account values (6169,5700,42,'POPLATEK MESICNE','1993-7-20');
insert into tab_account values (6173,5724,14,'POPLATEK PO OBRATU','1995-4-19');
insert into tab_account values (6175,5735,52,'POPLATEK MESICNE','1995-1-25');
insert into tab_account values (6178,5742,74,'POPLATEK PO OBRATU','1995-7-5');
insert into tab_account values (6185,5774,1,'POPLATEK MESICNE','1995-6-8');
insert into tab_account values (6190,5794,70,'POPLATEK MESICNE','1995-7-14');
insert into tab_account values (6196,5837,5,'POPLATEK MESICNE','1996-7-18');
insert into tab_account values (6202,5891,54,'POPLATEK MESICNE','1993-1-25');
insert into tab_account values (6207,5912,45,'POPLATEK MESICNE','1996-10-25');
insert into tab_account values (6210,5927,15,'POPLATEK MESICNE','1993-11-26');
insert into tab_account values (6215,5944,27,'POPLATEK MESICNE','1997-6-6');
insert into tab_account values (6216,5952,50,'POPLATEK MESICNE','1993-9-7');
insert into tab_account values (6223,5991,1,'POPLATEK MESICNE','1993-11-21');
insert into tab_account values (6227,6030,47,'POPLATEK MESICNE','1993-8-24');
insert into tab_account values (6228,6034,6,'POPLATEK TYDNE','1993-3-19');
insert into tab_account values (6229,6040,1,'POPLATEK MESICNE','1993-4-22');
insert into tab_account values (6232,6051,56,'POPLATEK MESICNE','1993-8-28');
insert into tab_account values (6234,6061,1,'POPLATEK MESICNE','1997-3-8');
insert into tab_account values (6235,6062,24,'POPLATEK MESICNE','1996-8-28');
insert into tab_account values (6237,6075,19,'POPLATEK MESICNE','1996-9-15');
insert into tab_account values (6239,6083,6,'POPLATEK TYDNE','1996-9-19');
insert into tab_account values (6242,6097,29,'POPLATEK MESICNE','1997-6-15');
insert into tab_account values (6244,6118,1,'POPLATEK TYDNE','1994-3-7');
insert into tab_account values (6249,6138,54,'POPLATEK MESICNE','1997-1-22');
insert into tab_account values (6253,6148,74,'POPLATEK MESICNE','1993-12-27');
insert into tab_account values (6254,6157,34,'POPLATEK MESICNE','1996-11-11');
insert into tab_account values (6255,6158,67,'POPLATEK MESICNE','1996-5-13');
insert into tab_account values (6272,6226,74,'POPLATEK TYDNE','1993-7-26');
insert into tab_account values (6278,6265,5,'POPLATEK MESICNE','1996-11-1');
insert into tab_account values (6279,6273,38,'POPLATEK MESICNE','1993-7-21');
insert into tab_account values (6283,6289,64,'POPLATEK MESICNE','1995-4-5');
insert into tab_account values (6294,6353,26,'POPLATEK MESICNE','1993-11-26');
insert into tab_account values (6296,6358,3,'POPLATEK MESICNE','1995-5-27');
insert into tab_account values (6297,6363,74,'POPLATEK MESICNE','1993-8-1');
insert into tab_account values (6302,6397,48,'POPLATEK MESICNE','1995-3-15');
insert into tab_account values (6303,6400,31,'POPLATEK PO OBRATU','1995-10-9');
insert into tab_account values (6306,6425,31,'POPLATEK MESICNE','1993-3-29');
insert into tab_account values (6309,6434,1,'POPLATEK MESICNE','1995-5-8');
insert into tab_account values (6310,6440,1,'POPLATEK MESICNE','1996-11-1');
insert into tab_account values (6312,6453,34,'POPLATEK MESICNE','1996-7-27');
insert into tab_account values (6313,6461,50,'POPLATEK MESICNE','1996-7-17');
insert into tab_account values (6315,6472,61,'POPLATEK MESICNE','1994-2-8');
insert into tab_account values (6316,6473,12,'POPLATEK MESICNE','1993-1-26');
insert into tab_account values (6320,6495,6,'POPLATEK MESICNE','1996-7-23');
insert into tab_account values (6321,6505,7,'POPLATEK MESICNE','1997-9-13');
insert into tab_account values (6322,6510,74,'POPLATEK MESICNE','1996-12-18');
insert into tab_account values (6336,6555,38,'POPLATEK TYDNE','1993-3-5');
insert into tab_account values (6338,6592,1,'POPLATEK MESICNE','1996-10-20');
insert into tab_account values (6342,6609,16,'POPLATEK MESICNE','1995-3-27');
insert into tab_account values (6346,6649,1,'POPLATEK MESICNE','1995-7-8');
insert into tab_account values (6350,6678,54,'POPLATEK MESICNE','1996-1-3');
insert into tab_account values (6353,6686,61,'POPLATEK MESICNE','1996-2-10');
insert into tab_account values (6354,6688,16,'POPLATEK MESICNE','1996-6-25');
insert into tab_account values (6355,6699,35,'POPLATEK MESICNE','1996-6-8');
insert into tab_account values (6356,6701,49,'POPLATEK TYDNE','1993-3-15');
insert into tab_account values (6357,6706,38,'POPLATEK MESICNE','1996-12-28');
insert into tab_account values (6358,6715,48,'POPLATEK TYDNE','1993-9-15');
insert into tab_account values (6362,6738,62,'POPLATEK MESICNE','1994-7-28');
insert into tab_account values (6377,6792,1,'POPLATEK MESICNE','1996-5-11');
insert into tab_account values (6386,6856,43,'POPLATEK MESICNE','1995-8-19');
insert into tab_account values (6399,6902,60,'POPLATEK MESICNE','1996-10-22');
insert into tab_account values (6402,6922,3,'POPLATEK TYDNE','1997-5-12');
insert into tab_account values (6403,6924,74,'POPLATEK MESICNE','1994-6-1');
insert into tab_account values (6407,6930,41,'POPLATEK MESICNE','1993-9-8');
insert into tab_account values (6415,6950,36,'POPLATEK MESICNE','1996-10-12');
insert into tab_account values (6421,6985,38,'POPLATEK MESICNE','1995-7-27');
insert into tab_account values (6435,7045,51,'POPLATEK MESICNE','1996-12-26');
insert into tab_account values (6436,7049,69,'POPLATEK MESICNE','1997-10-12');
insert into tab_account values (6437,7052,55,'POPLATEK PO OBRATU','1997-7-17');
insert into tab_account values (6442,7082,57,'POPLATEK MESICNE','1996-9-6');
insert into tab_account values (6450,7099,1,'POPLATEK MESICNE','1996-8-20');
insert into tab_account values (6456,7123,64,'POPLATEK PO OBRATU','1993-4-14');
insert into tab_account values (6460,7133,1,'POPLATEK MESICNE','1993-9-17');
insert into tab_account values (6461,7136,12,'POPLATEK TYDNE','1995-4-9');
insert into tab_account values (6464,7156,71,'POPLATEK MESICNE','1997-9-11');
insert into tab_account values (6468,7176,1,'POPLATEK MESICNE','1996-12-7');
insert into tab_account values (6469,7180,7,'POPLATEK TYDNE','1997-6-12');
insert into tab_account values (6470,7181,77,'POPLATEK PO OBRATU','1996-7-2');
insert into tab_account values (6471,7184,5,'POPLATEK MESICNE','1995-6-19');
insert into tab_account values (6474,7190,49,'POPLATEK MESICNE','1993-9-6');
insert into tab_account values (6486,7240,17,'POPLATEK MESICNE','1996-4-23');
insert into tab_account values (6490,7262,70,'POPLATEK MESICNE','1996-8-30');
insert into tab_account values (6495,7274,11,'POPLATEK MESICNE','1997-9-28');
insert into tab_account values (6499,7401,1,'POPLATEK MESICNE','1993-2-26');
insert into tab_account values (6501,7418,21,'POPLATEK MESICNE','1995-4-7');
insert into tab_account values (6502,7424,68,'POPLATEK MESICNE','1996-7-28');
insert into tab_account values (6508,7437,19,'POPLATEK TYDNE','1997-8-8');
insert into tab_account values (6509,7445,64,'POPLATEK MESICNE','1993-3-18');
insert into tab_account values (6512,7454,4,'POPLATEK MESICNE','1993-4-19');
insert into tab_account values (6520,7485,39,'POPLATEK MESICNE','1993-7-28');
insert into tab_account values (6526,7523,63,'POPLATEK MESICNE','1994-8-29');
insert into tab_account values (6534,7542,54,'POPLATEK MESICNE','1996-5-16');
insert into tab_account values (6535,7546,43,'POPLATEK MESICNE','1994-9-3');
insert into tab_account values (6539,7559,56,'POPLATEK MESICNE','1997-5-24');
insert into tab_account values (6540,7562,72,'POPLATEK TYDNE','1995-1-17');
insert into tab_account values (6541,7565,59,'POPLATEK MESICNE','1996-4-2');
insert into tab_account values (6544,7594,16,'POPLATEK MESICNE','1996-2-16');
insert into tab_account values (6545,7606,21,'POPLATEK MESICNE','1995-3-15');
insert into tab_account values (6546,7607,1,'POPLATEK MESICNE','1993-9-5');
insert into tab_account values (6550,7614,62,'POPLATEK MESICNE','1995-2-8');
insert into tab_account values (6552,7632,68,'POPLATEK MESICNE','1996-9-22');
insert into tab_account values (6553,7636,40,'POPLATEK MESICNE','1996-10-8');
insert into tab_account values (6554,7637,46,'POPLATEK MESICNE','1996-8-19');
insert into tab_account values (6562,7674,1,'POPLATEK MESICNE','1996-7-21');
insert into tab_account values (6568,7713,50,'POPLATEK TYDNE','1996-5-25');
insert into tab_account values (6569,7721,13,'POPLATEK MESICNE','1997-7-3');
insert into tab_account values (6571,7733,19,'POPLATEK TYDNE','1996-7-8');
insert into tab_account values (6574,7745,2,'POPLATEK MESICNE','1996-11-29');
insert into tab_account values (6577,7753,74,'POPLATEK MESICNE','1993-2-8');
insert into tab_account values (6578,7765,52,'POPLATEK TYDNE','1994-7-10');
insert into tab_account values (6580,7769,23,'POPLATEK MESICNE','1993-10-3');
insert into tab_account values (6585,7795,64,'POPLATEK MESICNE','1995-1-5');
insert into tab_account values (6589,7815,19,'POPLATEK TYDNE','1995-4-9');
insert into tab_account values (6591,7819,38,'POPLATEK MESICNE','1993-8-1');
insert into tab_account values (6594,7824,60,'POPLATEK MESICNE','1994-5-17');
insert into tab_account values (6596,7844,1,'POPLATEK MESICNE','1993-11-26');
insert into tab_account values (6598,7857,75,'POPLATEK MESICNE','1993-8-4');
insert into tab_account values (6599,7859,52,'POPLATEK MESICNE','1995-3-14');
insert into tab_account values (6600,7861,34,'POPLATEK MESICNE','1995-4-22');
insert into tab_account values (6605,7890,23,'POPLATEK MESICNE','1996-3-26');
insert into tab_account values (6607,7894,27,'POPLATEK MESICNE','1996-4-9');
insert into tab_account values (6612,7907,70,'POPLATEK MESICNE','1996-7-27');
insert into tab_account values (6613,7926,69,'POPLATEK TYDNE','1996-6-9');
insert into tab_account values (6621,7957,51,'POPLATEK MESICNE','1995-9-7');
insert into tab_account values (6624,7965,55,'POPLATEK MESICNE','1993-11-8');
insert into tab_account values (6625,7966,54,'POPLATEK MESICNE','1996-12-27');
insert into tab_account values (6632,7990,9,'POPLATEK MESICNE','1996-8-30');
insert into tab_account values (6633,7997,10,'POPLATEK MESICNE','1996-4-25');
insert into tab_account values (6641,8026,36,'POPLATEK MESICNE','1997-3-23');
insert into tab_account values (6642,8027,44,'POPLATEK TYDNE','1993-7-7');
insert into tab_account values (6643,8038,47,'POPLATEK MESICNE','1996-8-17');
insert into tab_account values (6644,8039,9,'POPLATEK MESICNE','1995-12-17');
insert into tab_account values (6645,8041,1,'POPLATEK MESICNE','1993-10-10');
insert into tab_account values (6647,8051,1,'POPLATEK TYDNE','1993-2-7');
insert into tab_account values (6650,8073,24,'POPLATEK PO OBRATU','1993-9-3');
insert into tab_account values (6655,8085,73,'POPLATEK MESICNE','1996-4-8');
insert into tab_account values (6659,8092,54,'POPLATEK MESICNE','1995-1-11');
insert into tab_account values (6660,8094,67,'POPLATEK MESICNE','1996-11-24');
insert into tab_account values (6665,8114,59,'POPLATEK MESICNE','1995-10-14');
insert into tab_account values (6667,8127,37,'POPLATEK MESICNE','1994-10-13');
insert into tab_account values (6668,8129,45,'POPLATEK MESICNE','1993-6-26');
insert into tab_account values (6675,8158,48,'POPLATEK TYDNE','1996-6-16');
insert into tab_account values (6676,8159,26,'POPLATEK MESICNE','1995-2-8');
insert into tab_account values (6677,8169,29,'POPLATEK MESICNE','1995-11-28');
insert into tab_account values (6678,8173,11,'POPLATEK MESICNE','1993-7-5');
insert into tab_account values (6682,8225,50,'POPLATEK MESICNE','1996-12-7');
insert into tab_account values (6686,8260,31,'POPLATEK MESICNE','1993-3-24');
insert into tab_account values (6687,8261,13,'POPLATEK MESICNE','1993-5-12');
insert into tab_account values (6688,8268,59,'POPLATEK MESICNE','1996-9-19');
insert into tab_account values (6694,8316,70,'POPLATEK MESICNE','1994-6-4');
insert into tab_account values (6695,8320,51,'POPLATEK MESICNE','1997-1-19');
insert into tab_account values (6696,8321,77,'POPLATEK MESICNE','1993-4-12');
insert into tab_account values (6698,8327,1,'POPLATEK TYDNE','1995-8-8');
insert into tab_account values (6699,8330,48,'POPLATEK MESICNE','1993-3-28');
insert into tab_account values (6704,8377,29,'POPLATEK MESICNE','1993-11-20');
insert into tab_account values (6705,8381,14,'POPLATEK MESICNE','1996-9-17');
insert into tab_account values (6712,8405,20,'POPLATEK MESICNE','1994-5-10');
insert into tab_account values (6715,8411,20,'POPLATEK MESICNE','1994-12-2');
insert into tab_account values (6721,8475,4,'POPLATEK MESICNE','1993-9-8');
insert into tab_account values (6725,8489,19,'POPLATEK MESICNE','1993-9-18');
insert into tab_account values (6726,8492,2,'POPLATEK MESICNE','1994-6-29');
insert into tab_account values (6727,8505,70,'POPLATEK MESICNE','1997-3-20');
insert into tab_account values (6729,8519,23,'POPLATEK MESICNE','1993-4-2');
insert into tab_account values (6730,8523,54,'POPLATEK MESICNE','1996-11-25');
insert into tab_account values (6732,8533,47,'POPLATEK MESICNE','1995-10-10');
insert into tab_account values (6734,8547,14,'POPLATEK TYDNE','1995-7-17');
insert into tab_account values (6736,8558,1,'POPLATEK PO OBRATU','1994-2-27');
insert into tab_account values (6737,8564,68,'POPLATEK MESICNE','1993-9-12');
insert into tab_account values (6738,8566,74,'POPLATEK MESICNE','1993-10-8');
insert into tab_account values (6745,8625,64,'POPLATEK MESICNE','1993-11-10');
insert into tab_account values (6746,8639,46,'POPLATEK MESICNE','1997-8-22');
insert into tab_account values (6748,8645,60,'POPLATEK MESICNE','1997-6-23');
insert into tab_account values (6751,8680,17,'POPLATEK MESICNE','1996-2-12');
insert into tab_account values (6753,8688,66,'POPLATEK MESICNE','1996-11-22');
insert into tab_account values (6755,8713,53,'POPLATEK MESICNE','1997-5-18');
insert into tab_account values (6758,8742,70,'POPLATEK MESICNE','1997-1-28');
insert into tab_account values (6763,8772,1,'POPLATEK MESICNE','1996-5-16');
insert into tab_account values (6764,8776,64,'POPLATEK MESICNE','1994-8-24');
insert into tab_account values (6766,8784,1,'POPLATEK MESICNE','1996-10-16');
insert into tab_account values (6785,8899,1,'POPLATEK TYDNE','1994-9-5');
insert into tab_account values (6790,8919,62,'POPLATEK MESICNE','1997-7-3');
insert into tab_account values (6791,8926,1,'POPLATEK MESICNE','1997-3-21');
insert into tab_account values (6793,8931,63,'POPLATEK TYDNE','1996-1-1');
insert into tab_account values (6805,8972,70,'POPLATEK MESICNE','1996-5-21');
insert into tab_account values (6808,8982,64,'POPLATEK MESICNE','1993-9-25');
insert into tab_account values (6810,9006,40,'POPLATEK TYDNE','1994-9-2');
insert into tab_account values (6816,9017,70,'POPLATEK MESICNE','1995-11-22');
insert into tab_account values (6817,9024,1,'POPLATEK MESICNE','1996-1-5');
insert into tab_account values (6818,9030,72,'POPLATEK MESICNE','1995-1-21');
insert into tab_account values (6819,9031,47,'POPLATEK MESICNE','1997-1-15');
insert into tab_account values (6820,9034,1,'POPLATEK MESICNE','1993-6-28');
insert into tab_account values (6821,9037,1,'POPLATEK MESICNE','1996-10-22');
insert into tab_account values (6824,9052,43,'POPLATEK PO OBRATU','1995-8-30');
insert into tab_account values (6836,9093,47,'POPLATEK MESICNE','1993-6-16');
insert into tab_account values (6841,9104,10,'POPLATEK MESICNE','1994-1-21');
insert into tab_account values (6851,9138,26,'POPLATEK MESICNE','1996-7-18');
insert into tab_account values (6852,9140,32,'POPLATEK MESICNE','1997-8-18');
insert into tab_account values (6855,9153,9,'POPLATEK MESICNE','1996-12-12');
insert into tab_account values (6856,9156,18,'POPLATEK MESICNE','1997-9-14');
insert into tab_account values (6857,9159,64,'POPLATEK MESICNE','1996-8-2');
insert into tab_account values (6859,9167,56,'POPLATEK MESICNE','1997-4-2');
insert into tab_account values (6861,9179,28,'POPLATEK MESICNE','1997-1-21');
insert into tab_account values (6863,9188,45,'POPLATEK MESICNE','1993-2-8');
insert into tab_account values (6865,9199,72,'POPLATEK MESICNE','1996-5-15');
insert into tab_account values (6866,9201,69,'POPLATEK MESICNE','1996-10-28');
insert into tab_account values (6868,9208,29,'POPLATEK MESICNE','1997-5-24');
insert into tab_account values (6871,9225,11,'POPLATEK MESICNE','1996-1-1');
insert into tab_account values (6872,9227,51,'POPLATEK MESICNE','1997-11-4');
insert into tab_account values (6875,9235,37,'POPLATEK MESICNE','1995-6-24');
insert into tab_account values (6876,9236,11,'POPLATEK MESICNE','1993-8-18');
insert into tab_account values (6877,9241,74,'POPLATEK MESICNE','1996-9-25');
insert into tab_account values (6878,9242,57,'POPLATEK MESICNE','1996-3-15');
insert into tab_account values (6887,9263,68,'POPLATEK MESICNE','1996-6-4');
insert into tab_account values (6888,9265,1,'POPLATEK MESICNE','1993-2-4');
insert into tab_account values (6895,9307,68,'POPLATEK MESICNE','1993-1-24');
insert into tab_account values (6903,9337,30,'POPLATEK MESICNE','1993-9-13');
insert into tab_account values (6908,9353,59,'POPLATEK MESICNE','1995-11-3');
insert into tab_account values (6913,9377,1,'POPLATEK MESICNE','1995-9-17');
insert into tab_account values (6919,9403,1,'POPLATEK TYDNE','1993-3-27');
insert into tab_account values (6921,9422,70,'POPLATEK MESICNE','1996-3-6');
insert into tab_account values (6922,9424,54,'POPLATEK MESICNE','1996-12-30');
insert into tab_account values (6923,9433,59,'POPLATEK MESICNE','1997-8-14');
insert into tab_account values (6926,9455,73,'POPLATEK MESICNE','1996-11-3');
insert into tab_account values (6929,9472,1,'POPLATEK TYDNE','1993-7-6');
insert into tab_account values (6932,9491,7,'POPLATEK TYDNE','1996-8-8');
insert into tab_account values (6933,9493,64,'POPLATEK MESICNE','1995-4-2');
insert into tab_account values (6934,9494,21,'POPLATEK MESICNE','1996-5-10');
insert into tab_account values (6938,9504,9,'POPLATEK MESICNE','1996-1-29');
insert into tab_account values (6940,9510,1,'POPLATEK MESICNE','1996-6-9');
insert into tab_account values (6942,9513,59,'POPLATEK MESICNE','1996-5-12');
insert into tab_account values (6944,9548,62,'POPLATEK MESICNE','1996-6-7');
insert into tab_account values (6948,9560,1,'POPLATEK MESICNE','1997-7-13');
insert into tab_account values (6949,9583,31,'POPLATEK TYDNE','1994-5-22');
insert into tab_account values (6950,9591,74,'POPLATEK MESICNE','1993-5-20');
insert into tab_account values (6955,9627,65,'POPLATEK PO OBRATU','1994-7-22');
insert into tab_account values (6956,9631,11,'POPLATEK MESICNE','1996-6-25');
insert into tab_account values (6959,9633,70,'POPLATEK MESICNE','1996-1-8');
insert into tab_account values (6960,9640,1,'POPLATEK MESICNE','1993-3-13');
insert into tab_account values (6961,9645,38,'POPLATEK MESICNE','1996-1-23');
insert into tab_account values (6962,9646,1,'POPLATEK TYDNE','1996-7-30');
insert into tab_account values (6965,9656,61,'POPLATEK MESICNE','1993-11-14');
insert into tab_account values (6969,9673,76,'POPLATEK MESICNE','1997-6-7');
insert into tab_account values (6970,9677,8,'POPLATEK MESICNE','1996-10-13');
insert into tab_account values (6984,9730,54,'POPLATEK MESICNE','1997-1-1');
insert into tab_account values (6985,9731,54,'POPLATEK PO OBRATU','1994-12-1');
insert into tab_account values (6986,9750,74,'POPLATEK MESICNE','1994-5-16');
insert into tab_account values (6992,9790,52,'POPLATEK MESICNE','1995-11-9');
insert into tab_account values (6995,9814,64,'POPLATEK TYDNE','1995-1-19');
insert into tab_account values (6996,9828,11,'POPLATEK MESICNE','1993-5-20');
insert into tab_account values (6998,9833,20,'POPLATEK MESICNE','1993-7-24');
insert into tab_account values (7001,9859,27,'POPLATEK MESICNE','1996-7-8');
insert into tab_account values (7004,9869,12,'POPLATEK MESICNE','1993-8-21');
insert into tab_account values (7008,9897,1,'POPLATEK MESICNE','1995-3-4');
insert into tab_account values (7013,9928,60,'POPLATEK MESICNE','1995-11-9');
insert into tab_account values (7034,10001,24,'POPLATEK MESICNE','1995-5-28');
insert into tab_account values (7035,10005,64,'POPLATEK MESICNE','1997-11-29');
insert into tab_account values (7036,10019,8,'POPLATEK MESICNE','1995-6-15');
insert into tab_account values (7037,10022,1,'POPLATEK MESICNE','1997-5-7');
insert into tab_account values (7046,10049,17,'POPLATEK MESICNE','1996-3-28');
insert into tab_account values (7049,10063,4,'POPLATEK TYDNE','1996-10-13');
insert into tab_account values (7050,10065,76,'POPLATEK MESICNE','1996-3-30');
insert into tab_account values (7051,10068,1,'POPLATEK MESICNE','1997-4-2');
insert into tab_account values (7055,10079,62,'POPLATEK MESICNE','1993-5-6');
insert into tab_account values (7057,10093,1,'POPLATEK TYDNE','1994-7-1');
insert into tab_account values (7061,10105,55,'POPLATEK MESICNE','1993-4-28');
insert into tab_account values (7066,10131,1,'POPLATEK MESICNE','1993-11-27');
insert into tab_account values (7067,10134,22,'POPLATEK MESICNE','1997-4-26');
insert into tab_account values (7072,10148,34,'POPLATEK MESICNE','1997-1-13');
insert into tab_account values (7085,10202,70,'POPLATEK MESICNE','1996-7-8');
insert into tab_account values (7087,10215,38,'POPLATEK MESICNE','1996-4-12');
insert into tab_account values (7088,10233,27,'POPLATEK MESICNE','1996-2-21');
insert into tab_account values (7091,10243,44,'POPLATEK MESICNE','1997-9-3');
insert into tab_account values (7096,10257,27,'POPLATEK MESICNE','1997-5-1');
insert into tab_account values (7097,10266,54,'POPLATEK MESICNE','1993-6-10');
insert into tab_account values (7100,10280,69,'POPLATEK MESICNE','1996-12-1');
insert into tab_account values (7101,10297,14,'POPLATEK MESICNE','1996-1-19');
insert into tab_account values (7104,10320,68,'POPLATEK MESICNE','1993-7-11');
insert into tab_account values (7110,10345,36,'POPLATEK MESICNE','1996-4-7');
insert into tab_account values (7115,10351,23,'POPLATEK MESICNE','1995-5-4');
insert into tab_account values (7119,10361,21,'POPLATEK MESICNE','1996-6-21');
insert into tab_account values (7121,10364,55,'POPLATEK MESICNE','1993-1-17');
insert into tab_account values (7122,10365,22,'POPLATEK MESICNE','1995-9-2');
insert into tab_account values (7129,10404,1,'POPLATEK MESICNE','1996-12-30');
insert into tab_account values (7130,10411,39,'POPLATEK PO OBRATU','1995-11-23');
insert into tab_account values (7136,10436,60,'POPLATEK MESICNE','1996-3-21');
insert into tab_account values (7137,10439,66,'POPLATEK MESICNE','1993-11-21');
insert into tab_account values (7138,10440,72,'POPLATEK MESICNE','1993-9-13');
insert into tab_account values (7139,10445,72,'POPLATEK MESICNE','1996-5-29');
insert into tab_account values (7142,10451,1,'POPLATEK MESICNE','1993-8-29');
insert into tab_account values (7147,10478,70,'POPLATEK TYDNE','1996-2-24');
insert into tab_account values (7151,10493,12,'POPLATEK MESICNE','1997-1-9');
insert into tab_account values (7154,10520,55,'POPLATEK PO OBRATU','1995-10-24');
insert into tab_account values (7164,10613,55,'POPLATEK MESICNE','1997-11-4');
insert into tab_account values (7166,10630,41,'POPLATEK MESICNE','1995-1-15');
insert into tab_account values (7167,10644,16,'POPLATEK MESICNE','1997-7-12');
insert into tab_account values (7168,10645,2,'POPLATEK MESICNE','1996-12-21');
insert into tab_account values (7171,10650,76,'POPLATEK MESICNE','1997-9-9');
insert into tab_account values (7172,10652,1,'POPLATEK MESICNE','1997-3-18');
insert into tab_account values (7176,10663,11,'POPLATEK MESICNE','1993-12-8');
insert into tab_account values (7181,10679,1,'POPLATEK MESICNE','1997-5-30');
insert into tab_account values (7187,10711,36,'POPLATEK MESICNE','1996-7-8');
insert into tab_account values (7189,10728,71,'POPLATEK MESICNE','1994-12-23');
insert into tab_account values (7192,10738,45,'POPLATEK TYDNE','1993-4-17');
insert into tab_account values (7194,10762,1,'POPLATEK MESICNE','1995-10-23');
insert into tab_account values (7195,10774,46,'POPLATEK MESICNE','1997-7-5');
insert into tab_account values (7198,10788,67,'POPLATEK TYDNE','1993-11-22');
insert into tab_account values (7199,10789,75,'POPLATEK MESICNE','1996-9-18');
insert into tab_account values (7200,10799,76,'POPLATEK MESICNE','1997-8-19');
insert into tab_account values (7201,10807,34,'POPLATEK MESICNE','1996-3-13');
insert into tab_account values (7202,10812,16,'POPLATEK MESICNE','1997-4-8');
insert into tab_account values (7209,10857,50,'POPLATEK MESICNE','1996-10-2');
insert into tab_account values (7213,10884,65,'POPLATEK MESICNE','1995-2-20');
insert into tab_account values (7219,10905,32,'POPLATEK MESICNE','1996-11-21');
insert into tab_account values (7220,10911,1,'POPLATEK TYDNE','1993-5-29');
insert into tab_account values (7221,10915,25,'POPLATEK TYDNE','1997-2-15');
insert into tab_account values (7226,10940,50,'POPLATEK MESICNE','1993-9-13');
insert into tab_account values (7227,10942,44,'POPLATEK TYDNE','1994-6-5');
insert into tab_account values (7230,10954,25,'POPLATEK MESICNE','1996-7-29');
insert into tab_account values (7233,10963,16,'POPLATEK MESICNE','1995-5-20');
insert into tab_account values (7235,10973,18,'POPLATEK TYDNE','1993-4-20');
insert into tab_account values (7240,11013,1,'POPLATEK TYDNE','1993-2-14');
insert into tab_account values (7241,11021,1,'POPLATEK MESICNE','1993-8-10');
insert into tab_account values (7242,11027,32,'POPLATEK TYDNE','1996-7-26');
insert into tab_account values (7243,11042,72,'POPLATEK MESICNE','1995-1-29');
insert into tab_account values (7246,11054,59,'POPLATEK TYDNE','1996-2-1');
insert into tab_account values (7249,11065,11,'POPLATEK MESICNE','1993-3-19');
insert into tab_account values (7250,11069,37,'POPLATEK MESICNE','1995-6-2');
insert into tab_account values (7253,11079,16,'POPLATEK MESICNE','1995-11-10');
insert into tab_account values (7255,11096,28,'POPLATEK MESICNE','1996-12-10');
insert into tab_account values (7259,11111,1,'POPLATEK MESICNE','1993-5-20');
insert into tab_account values (7262,11135,75,'POPLATEK MESICNE','1993-10-10');
insert into tab_account values (7263,11138,70,'POPLATEK TYDNE','1995-8-18');
insert into tab_account values (7264,11141,1,'POPLATEK TYDNE','1997-2-11');
insert into tab_account values (7271,11186,12,'POPLATEK MESICNE','1994-11-24');
insert into tab_account values (7277,11231,1,'POPLATEK MESICNE','1997-2-5');
insert into tab_account values (7279,11244,33,'POPLATEK MESICNE','1997-1-12');
insert into tab_account values (7284,11265,15,'POPLATEK MESICNE','1993-1-14');
insert into tab_account values (7286,11271,5,'POPLATEK MESICNE','1995-9-20');
insert into tab_account values (7292,11317,50,'POPLATEK MESICNE','1997-7-11');
insert into tab_account values (7294,11327,7,'POPLATEK MESICNE','1997-10-15');
insert into tab_account values (7295,11328,54,'POPLATEK MESICNE','1996-11-5');
insert into tab_account values (7304,11349,1,'POPLATEK TYDNE','1995-5-26');
insert into tab_account values (7305,11359,61,'POPLATEK MESICNE','1994-10-1');
insert into tab_account values (7308,11362,67,'POPLATEK MESICNE','1995-10-14');
insert into tab_card values (4989,17,127,'classic','1998-6-7');
insert into tab_card values (5015,45,272,'classic','1997-12-5');
insert into tab_card values (5027,53,333,'classic','1998-10-13');
insert into tab_card values (5088,119,655,'classic','1996-8-8');
insert into tab_card values (5103,140,798,'classic','1997-8-22');
insert into tab_card values (5260,280,1793,'classic','1997-6-22');
insert into tab_card values (5311,337,2141,'classic','1996-1-1');
insert into tab_card values (5332,355,2267,'classic','1997-8-28');
insert into tab_card values (5377,408,2560,'classic','1996-12-10');
insert into tab_card values (5428,434,2739,'classic','1997-12-30');
insert into tab_card values (5435,436,2759,'classic','1997-10-9');
insert into tab_card values (5520,511,3257,'junior','1997-8-6');
insert into tab_card values (5526,517,3291,'classic','1998-1-9');
insert into tab_card values (5582,565,3601,'gold','1997-1-6');
insert into tab_card values (5595,577,3687,'classic','1994-2-15');
insert into tab_card values (5644,623,3984,'classic','1998-7-25');
insert into tab_card values (5900,783,5433,'junior','1995-10-24');
insert into tab_card values (5992,813,5873,'junior','1996-10-28');
insert into tab_card values (6118,847,6610,'classic','1997-5-20');
insert into tab_card values (6254,891,7434,'classic','1997-12-23');
insert into tab_card values (6321,923,7855,'classic','1998-9-24');
insert into tab_card values (6464,965,8636,'classic','1998-4-2');
insert into tab_card values (6550,989,9119,'classic','1996-2-21');
insert into tab_card values (6577,1005,9285,'classic','1993-11-7');
insert into tab_card values (6607,1014,9452,'classic','1996-11-2');
insert into tab_card values (6932,1115,11375,'junior','1997-10-3');
insert into tab_card values (6938,1118,11393,'classic','1997-1-2');
insert into tab_card values (6992,1134,11742,'classic','1996-5-31');
insert into tab_card values (7001,1138,11825,'classic','1997-6-29');
insert into tab_card values (7119,1173,12442,'classic','1997-5-8');
insert into tab_card values (7130,1176,12502,'gold','1996-7-3');
insert into tab_card values (7139,1178,12542,'classic','1997-6-19');
insert into tab_card values (7154,1187,12635,'gold','1996-7-17');
insert into tab_card values (7167,1194,12781,'junior','1998-4-30');
insert into tab_card values (7243,1225,13268,'classic','1995-11-22');
insert into tab_card values (7305,1247,13660,'classic','1995-6-13');
insert into tab_card values (4959, null, null, null, null);
insert into tab_card values (4961, null, null, null, null);
insert into tab_card values (4962, null, null, null, null);
insert into tab_card values (4967, null, null, null, null);
insert into tab_card values (4968, null, null, null, null);
insert into tab_card values (4973, null, null, null, null);
insert into tab_card values (4986, null, null, null, null);
insert into tab_card values (4988, null, null, null, null);
insert into tab_card values (4990, null, null, null, null);
insert into tab_card values (4996, null, null, null, null);
insert into tab_card values (5002, null, null, null, null);
insert into tab_card values (5005, null, null, null, null);
insert into tab_card values (5032, null, null, null, null);
insert into tab_card values (5034, null, null, null, null);
insert into tab_card values (5036, null, null, null, null);
insert into tab_card values (5039, null, null, null, null);
insert into tab_card values (5041, null, null, null, null);
insert into tab_card values (5042, null, null, null, null);
insert into tab_card values (5043, null, null, null, null);
insert into tab_card values (5044, null, null, null, null);
insert into tab_card values (5045, null, null, null, null);
insert into tab_card values (5046, null, null, null, null);
insert into tab_card values (5051, null, null, null, null);
insert into tab_card values (5060, null, null, null, null);
insert into tab_card values (5061, null, null, null, null);
insert into tab_card values (5063, null, null, null, null);
insert into tab_card values (5072, null, null, null, null);
insert into tab_card values (5082, null, null, null, null);
insert into tab_card values (5086, null, null, null, null);
insert into tab_card values (5110, null, null, null, null);
insert into tab_card values (5117, null, null, null, null);
insert into tab_card values (5124, null, null, null, null);
insert into tab_card values (5125, null, null, null, null);
insert into tab_card values (5126, null, null, null, null);
insert into tab_card values (5128, null, null, null, null);
insert into tab_card values (5130, null, null, null, null);
insert into tab_card values (5131, null, null, null, null);
insert into tab_card values (5132, null, null, null, null);
insert into tab_card values (5134, null, null, null, null);
insert into tab_card values (5136, null, null, null, null);
insert into tab_card values (5138, null, null, null, null);
insert into tab_card values (5140, null, null, null, null);
insert into tab_card values (5145, null, null, null, null);
insert into tab_card values (5147, null, null, null, null);
insert into tab_card values (5148, null, null, null, null);
insert into tab_card values (5151, null, null, null, null);
insert into tab_card values (5154, null, null, null, null);
insert into tab_card values (5158, null, null, null, null);
insert into tab_card values (5160, null, null, null, null);
insert into tab_card values (5161, null, null, null, null);
insert into tab_card values (5169, null, null, null, null);
insert into tab_card values (5170, null, null, null, null);
insert into tab_card values (5172, null, null, null, null);
insert into tab_card values (5174, null, null, null, null);
insert into tab_card values (5176, null, null, null, null);
insert into tab_card values (5189, null, null, null, null);
insert into tab_card values (5206, null, null, null, null);
insert into tab_card values (5207, null, null, null, null);
insert into tab_card values (5208, null, null, null, null);
insert into tab_card values (5209, null, null, null, null);
insert into tab_card values (5210, null, null, null, null);
insert into tab_card values (5212, null, null, null, null);
insert into tab_card values (5214, null, null, null, null);
insert into tab_card values (5221, null, null, null, null);
insert into tab_card values (5226, null, null, null, null);
insert into tab_card values (5229, null, null, null, null);
insert into tab_card values (5236, null, null, null, null);
insert into tab_card values (5237, null, null, null, null);
insert into tab_card values (5241, null, null, null, null);
insert into tab_card values (5245, null, null, null, null);
insert into tab_card values (5253, null, null, null, null);
insert into tab_card values (5265, null, null, null, null);
insert into tab_card values (5269, null, null, null, null);
insert into tab_card values (5270, null, null, null, null);
insert into tab_card values (5281, null, null, null, null);
insert into tab_card values (5282, null, null, null, null);
insert into tab_card values (5285, null, null, null, null);
insert into tab_card values (5287, null, null, null, null);
insert into tab_card values (5293, null, null, null, null);
insert into tab_card values (5301, null, null, null, null);
insert into tab_card values (5304, null, null, null, null);
insert into tab_card values (5310, null, null, null, null);
insert into tab_card values (5312, null, null, null, null);
insert into tab_card values (5313, null, null, null, null);
insert into tab_card values (5314, null, null, null, null);
insert into tab_card values (5316, null, null, null, null);
insert into tab_card values (5318, null, null, null, null);
insert into tab_card values (5319, null, null, null, null);
insert into tab_card values (5320, null, null, null, null);
insert into tab_card values (5325, null, null, null, null);
insert into tab_card values (5329, null, null, null, null);
insert into tab_card values (5334, null, null, null, null);
insert into tab_card values (5337, null, null, null, null);
insert into tab_card values (5338, null, null, null, null);
insert into tab_card values (5343, null, null, null, null);
insert into tab_card values (5346, null, null, null, null);
insert into tab_card values (5350, null, null, null, null);
insert into tab_card values (5351, null, null, null, null);
insert into tab_card values (5352, null, null, null, null);
insert into tab_card values (5354, null, null, null, null);
insert into tab_card values (5358, null, null, null, null);
insert into tab_card values (5360, null, null, null, null);
insert into tab_card values (5363, null, null, null, null);
insert into tab_card values (5365, null, null, null, null);
insert into tab_card values (5366, null, null, null, null);
insert into tab_card values (5367, null, null, null, null);
insert into tab_card values (5368, null, null, null, null);
insert into tab_card values (5369, null, null, null, null);
insert into tab_card values (5375, null, null, null, null);
insert into tab_card values (5382, null, null, null, null);
insert into tab_card values (5384, null, null, null, null);
insert into tab_card values (5385, null, null, null, null);
insert into tab_card values (5388, null, null, null, null);
insert into tab_card values (5389, null, null, null, null);
insert into tab_card values (5390, null, null, null, null);
insert into tab_card values (5395, null, null, null, null);
insert into tab_card values (5398, null, null, null, null);
insert into tab_card values (5409, null, null, null, null);
insert into tab_card values (5413, null, null, null, null);
insert into tab_card values (5414, null, null, null, null);
insert into tab_card values (5415, null, null, null, null);
insert into tab_card values (5418, null, null, null, null);
insert into tab_card values (5419, null, null, null, null);
insert into tab_card values (5420, null, null, null, null);
insert into tab_card values (5429, null, null, null, null);
insert into tab_card values (5445, null, null, null, null);
insert into tab_card values (5446, null, null, null, null);
insert into tab_card values (5447, null, null, null, null);
insert into tab_card values (5449, null, null, null, null);
insert into tab_card values (5450, null, null, null, null);
insert into tab_card values (5451, null, null, null, null);
insert into tab_card values (5452, null, null, null, null);
insert into tab_card values (5453, null, null, null, null);
insert into tab_card values (5463, null, null, null, null);
insert into tab_card values (5464, null, null, null, null);
insert into tab_card values (5469, null, null, null, null);
insert into tab_card values (5470, null, null, null, null);
insert into tab_card values (5479, null, null, null, null);
insert into tab_card values (5482, null, null, null, null);
insert into tab_card values (5486, null, null, null, null);
insert into tab_card values (5491, null, null, null, null);
insert into tab_card values (5494, null, null, null, null);
insert into tab_card values (5495, null, null, null, null);
insert into tab_card values (5501, null, null, null, null);
insert into tab_card values (5519, null, null, null, null);
insert into tab_card values (5523, null, null, null, null);
insert into tab_card values (5525, null, null, null, null);
insert into tab_card values (5527, null, null, null, null);
insert into tab_card values (5531, null, null, null, null);
insert into tab_card values (5532, null, null, null, null);
insert into tab_card values (5533, null, null, null, null);
insert into tab_card values (5549, null, null, null, null);
insert into tab_card values (5556, null, null, null, null);
insert into tab_card values (5561, null, null, null, null);
insert into tab_card values (5563, null, null, null, null);
insert into tab_card values (5568, null, null, null, null);
insert into tab_card values (5569, null, null, null, null);
insert into tab_card values (5576, null, null, null, null);
insert into tab_card values (5584, null, null, null, null);
insert into tab_card values (5585, null, null, null, null);
insert into tab_card values (5586, null, null, null, null);
insert into tab_card values (5589, null, null, null, null);
insert into tab_card values (5591, null, null, null, null);
insert into tab_card values (5593, null, null, null, null);
insert into tab_card values (5599, null, null, null, null);
insert into tab_card values (5606, null, null, null, null);
insert into tab_card values (5610, null, null, null, null);
insert into tab_card values (5611, null, null, null, null);
insert into tab_card values (5614, null, null, null, null);
insert into tab_card values (5616, null, null, null, null);
insert into tab_card values (5620, null, null, null, null);
insert into tab_card values (5624, null, null, null, null);
insert into tab_card values (5625, null, null, null, null);
insert into tab_card values (5634, null, null, null, null);
insert into tab_card values (5635, null, null, null, null);
insert into tab_card values (5638, null, null, null, null);
insert into tab_card values (5643, null, null, null, null);
insert into tab_card values (5651, null, null, null, null);
insert into tab_card values (5656, null, null, null, null);
insert into tab_card values (5657, null, null, null, null);
insert into tab_card values (5665, null, null, null, null);
insert into tab_card values (5669, null, null, null, null);
insert into tab_card values (5674, null, null, null, null);
insert into tab_card values (5681, null, null, null, null);
insert into tab_card values (5682, null, null, null, null);
insert into tab_card values (5683, null, null, null, null);
insert into tab_card values (5693, null, null, null, null);
insert into tab_card values (5698, null, null, null, null);
insert into tab_card values (5699, null, null, null, null);
insert into tab_card values (5706, null, null, null, null);
insert into tab_card values (5713, null, null, null, null);
insert into tab_card values (5718, null, null, null, null);
insert into tab_card values (5719, null, null, null, null);
insert into tab_card values (5723, null, null, null, null);
insert into tab_card values (5724, null, null, null, null);
insert into tab_card values (5725, null, null, null, null);
insert into tab_card values (5731, null, null, null, null);
insert into tab_card values (5739, null, null, null, null);
insert into tab_card values (5740, null, null, null, null);
insert into tab_card values (5741, null, null, null, null);
insert into tab_card values (5750, null, null, null, null);
insert into tab_card values (5754, null, null, null, null);
insert into tab_card values (5758, null, null, null, null);
insert into tab_card values (5760, null, null, null, null);
insert into tab_card values (5765, null, null, null, null);
insert into tab_card values (5772, null, null, null, null);
insert into tab_card values (5773, null, null, null, null);
insert into tab_card values (5774, null, null, null, null);
insert into tab_card values (5779, null, null, null, null);
insert into tab_card values (5782, null, null, null, null);
insert into tab_card values (5784, null, null, null, null);
insert into tab_card values (5790, null, null, null, null);
insert into tab_card values (5799, null, null, null, null);
insert into tab_card values (5804, null, null, null, null);
insert into tab_card values (5805, null, null, null, null);
insert into tab_card values (5808, null, null, null, null);
insert into tab_card values (5815, null, null, null, null);
insert into tab_card values (5817, null, null, null, null);
insert into tab_card values (5823, null, null, null, null);
insert into tab_card values (5830, null, null, null, null);
insert into tab_card values (5836, null, null, null, null);
insert into tab_card values (5837, null, null, null, null);
insert into tab_card values (5841, null, null, null, null);
insert into tab_card values (5850, null, null, null, null);
insert into tab_card values (5856, null, null, null, null);
insert into tab_card values (5861, null, null, null, null);
insert into tab_card values (5862, null, null, null, null);
insert into tab_card values (5865, null, null, null, null);
insert into tab_card values (5868, null, null, null, null);
insert into tab_card values (5876, null, null, null, null);
insert into tab_card values (5877, null, null, null, null);
insert into tab_card values (5878, null, null, null, null);
insert into tab_card values (5880, null, null, null, null);
insert into tab_card values (5882, null, null, null, null);
insert into tab_card values (5886, null, null, null, null);
insert into tab_card values (5887, null, null, null, null);
insert into tab_card values (5889, null, null, null, null);
insert into tab_card values (5892, null, null, null, null);
insert into tab_card values (5893, null, null, null, null);
insert into tab_card values (5895, null, null, null, null);
insert into tab_card values (5897, null, null, null, null);
insert into tab_card values (5906, null, null, null, null);
insert into tab_card values (5909, null, null, null, null);
insert into tab_card values (5918, null, null, null, null);
insert into tab_card values (5922, null, null, null, null);
insert into tab_card values (5923, null, null, null, null);
insert into tab_card values (5930, null, null, null, null);
insert into tab_card values (5931, null, null, null, null);
insert into tab_card values (5932, null, null, null, null);
insert into tab_card values (5933, null, null, null, null);
insert into tab_card values (5938, null, null, null, null);
insert into tab_card values (5940, null, null, null, null);
insert into tab_card values (5942, null, null, null, null);
insert into tab_card values (5953, null, null, null, null);
insert into tab_card values (5956, null, null, null, null);
insert into tab_card values (5959, null, null, null, null);
insert into tab_card values (5963, null, null, null, null);
insert into tab_card values (5970, null, null, null, null);
insert into tab_card values (5973, null, null, null, null);
insert into tab_card values (5976, null, null, null, null);
insert into tab_card values (5977, null, null, null, null);
insert into tab_card values (5980, null, null, null, null);
insert into tab_card values (5988, null, null, null, null);
insert into tab_card values (5989, null, null, null, null);
insert into tab_card values (5991, null, null, null, null);
insert into tab_card values (5997, null, null, null, null);
insert into tab_card values (5999, null, null, null, null);
insert into tab_card values (6004, null, null, null, null);
insert into tab_card values (6006, null, null, null, null);
insert into tab_card values (6007, null, null, null, null);
insert into tab_card values (6010, null, null, null, null);
insert into tab_card values (6011, null, null, null, null);
insert into tab_card values (6012, null, null, null, null);
insert into tab_card values (6013, null, null, null, null);
insert into tab_card values (6014, null, null, null, null);
insert into tab_card values (6015, null, null, null, null);
insert into tab_card values (6019, null, null, null, null);
insert into tab_card values (6027, null, null, null, null);
insert into tab_card values (6028, null, null, null, null);
insert into tab_card values (6037, null, null, null, null);
insert into tab_card values (6038, null, null, null, null);
insert into tab_card values (6043, null, null, null, null);
insert into tab_card values (6044, null, null, null, null);
insert into tab_card values (6052, null, null, null, null);
insert into tab_card values (6054, null, null, null, null);
insert into tab_card values (6055, null, null, null, null);
insert into tab_card values (6059, null, null, null, null);
insert into tab_card values (6063, null, null, null, null);
insert into tab_card values (6064, null, null, null, null);
insert into tab_card values (6066, null, null, null, null);
insert into tab_card values (6072, null, null, null, null);
insert into tab_card values (6073, null, null, null, null);
insert into tab_card values (6075, null, null, null, null);
insert into tab_card values (6076, null, null, null, null);
insert into tab_card values (6077, null, null, null, null);
insert into tab_card values (6078, null, null, null, null);
insert into tab_card values (6083, null, null, null, null);
insert into tab_card values (6087, null, null, null, null);
insert into tab_card values (6088, null, null, null, null);
insert into tab_card values (6095, null, null, null, null);
insert into tab_card values (6097, null, null, null, null);
insert into tab_card values (6103, null, null, null, null);
insert into tab_card values (6104, null, null, null, null);
insert into tab_card values (6109, null, null, null, null);
insert into tab_card values (6111, null, null, null, null);
insert into tab_card values (6112, null, null, null, null);
insert into tab_card values (6113, null, null, null, null);
insert into tab_card values (6120, null, null, null, null);
insert into tab_card values (6130, null, null, null, null);
insert into tab_card values (6136, null, null, null, null);
insert into tab_card values (6137, null, null, null, null);
insert into tab_card values (6142, null, null, null, null);
insert into tab_card values (6144, null, null, null, null);
insert into tab_card values (6147, null, null, null, null);
insert into tab_card values (6150, null, null, null, null);
insert into tab_card values (6151, null, null, null, null);
insert into tab_card values (6153, null, null, null, null);
insert into tab_card values (6157, null, null, null, null);
insert into tab_card values (6168, null, null, null, null);
insert into tab_card values (6169, null, null, null, null);
insert into tab_card values (6173, null, null, null, null);
insert into tab_card values (6175, null, null, null, null);
insert into tab_card values (6178, null, null, null, null);
insert into tab_card values (6185, null, null, null, null);
insert into tab_card values (6190, null, null, null, null);
insert into tab_card values (6196, null, null, null, null);
insert into tab_card values (6202, null, null, null, null);
insert into tab_card values (6207, null, null, null, null);
insert into tab_card values (6210, null, null, null, null);
insert into tab_card values (6215, null, null, null, null);
insert into tab_card values (6216, null, null, null, null);
insert into tab_card values (6223, null, null, null, null);
insert into tab_card values (6227, null, null, null, null);
insert into tab_card values (6228, null, null, null, null);
insert into tab_card values (6229, null, null, null, null);
insert into tab_card values (6232, null, null, null, null);
insert into tab_card values (6234, null, null, null, null);
insert into tab_card values (6235, null, null, null, null);
insert into tab_card values (6237, null, null, null, null);
insert into tab_card values (6239, null, null, null, null);
insert into tab_card values (6242, null, null, null, null);
insert into tab_card values (6244, null, null, null, null);
insert into tab_card values (6249, null, null, null, null);
insert into tab_card values (6253, null, null, null, null);
insert into tab_card values (6255, null, null, null, null);
insert into tab_card values (6272, null, null, null, null);
insert into tab_card values (6278, null, null, null, null);
insert into tab_card values (6279, null, null, null, null);
insert into tab_card values (6283, null, null, null, null);
insert into tab_card values (6294, null, null, null, null);
insert into tab_card values (6296, null, null, null, null);
insert into tab_card values (6297, null, null, null, null);
insert into tab_card values (6302, null, null, null, null);
insert into tab_card values (6303, null, null, null, null);
insert into tab_card values (6306, null, null, null, null);
insert into tab_card values (6309, null, null, null, null);
insert into tab_card values (6310, null, null, null, null);
insert into tab_card values (6312, null, null, null, null);
insert into tab_card values (6313, null, null, null, null);
insert into tab_card values (6315, null, null, null, null);
insert into tab_card values (6316, null, null, null, null);
insert into tab_card values (6320, null, null, null, null);
insert into tab_card values (6322, null, null, null, null);
insert into tab_card values (6336, null, null, null, null);
insert into tab_card values (6338, null, null, null, null);
insert into tab_card values (6342, null, null, null, null);
insert into tab_card values (6346, null, null, null, null);
insert into tab_card values (6350, null, null, null, null);
insert into tab_card values (6353, null, null, null, null);
insert into tab_card values (6354, null, null, null, null);
insert into tab_card values (6355, null, null, null, null);
insert into tab_card values (6356, null, null, null, null);
insert into tab_card values (6357, null, null, null, null);
insert into tab_card values (6358, null, null, null, null);
insert into tab_card values (6362, null, null, null, null);
insert into tab_card values (6377, null, null, null, null);
insert into tab_card values (6386, null, null, null, null);
insert into tab_card values (6399, null, null, null, null);
insert into tab_card values (6402, null, null, null, null);
insert into tab_card values (6403, null, null, null, null);
insert into tab_card values (6407, null, null, null, null);
insert into tab_card values (6415, null, null, null, null);
insert into tab_card values (6421, null, null, null, null);
insert into tab_card values (6435, null, null, null, null);
insert into tab_card values (6436, null, null, null, null);
insert into tab_card values (6437, null, null, null, null);
insert into tab_card values (6442, null, null, null, null);
insert into tab_card values (6450, null, null, null, null);
insert into tab_card values (6456, null, null, null, null);
insert into tab_card values (6460, null, null, null, null);
insert into tab_card values (6461, null, null, null, null);
insert into tab_card values (6468, null, null, null, null);
insert into tab_card values (6469, null, null, null, null);
insert into tab_card values (6470, null, null, null, null);
insert into tab_card values (6471, null, null, null, null);
insert into tab_card values (6474, null, null, null, null);
insert into tab_card values (6486, null, null, null, null);
insert into tab_card values (6490, null, null, null, null);
insert into tab_card values (6495, null, null, null, null);
insert into tab_card values (6499, null, null, null, null);
insert into tab_card values (6501, null, null, null, null);
insert into tab_card values (6502, null, null, null, null);
insert into tab_card values (6508, null, null, null, null);
insert into tab_card values (6509, null, null, null, null);
insert into tab_card values (6512, null, null, null, null);
insert into tab_card values (6520, null, null, null, null);
insert into tab_card values (6526, null, null, null, null);
insert into tab_card values (6534, null, null, null, null);
insert into tab_card values (6535, null, null, null, null);
insert into tab_card values (6539, null, null, null, null);
insert into tab_card values (6540, null, null, null, null);
insert into tab_card values (6541, null, null, null, null);
insert into tab_card values (6544, null, null, null, null);
insert into tab_card values (6545, null, null, null, null);
insert into tab_card values (6546, null, null, null, null);
insert into tab_card values (6552, null, null, null, null);
insert into tab_card values (6553, null, null, null, null);
insert into tab_card values (6554, null, null, null, null);
insert into tab_card values (6562, null, null, null, null);
insert into tab_card values (6568, null, null, null, null);
insert into tab_card values (6569, null, null, null, null);
insert into tab_card values (6571, null, null, null, null);
insert into tab_card values (6574, null, null, null, null);
insert into tab_card values (6578, null, null, null, null);
insert into tab_card values (6580, null, null, null, null);
insert into tab_card values (6585, null, null, null, null);
insert into tab_card values (6589, null, null, null, null);
insert into tab_card values (6591, null, null, null, null);
insert into tab_card values (6594, null, null, null, null);
insert into tab_card values (6596, null, null, null, null);
insert into tab_card values (6598, null, null, null, null);
insert into tab_card values (6599, null, null, null, null);
insert into tab_card values (6600, null, null, null, null);
insert into tab_card values (6605, null, null, null, null);
insert into tab_card values (6612, null, null, null, null);
insert into tab_card values (6613, null, null, null, null);
insert into tab_card values (6621, null, null, null, null);
insert into tab_card values (6624, null, null, null, null);
insert into tab_card values (6625, null, null, null, null);
insert into tab_card values (6632, null, null, null, null);
insert into tab_card values (6633, null, null, null, null);
insert into tab_card values (6641, null, null, null, null);
insert into tab_card values (6642, null, null, null, null);
insert into tab_card values (6643, null, null, null, null);
insert into tab_card values (6644, null, null, null, null);
insert into tab_card values (6645, null, null, null, null);
insert into tab_card values (6647, null, null, null, null);
insert into tab_card values (6650, null, null, null, null);
insert into tab_card values (6655, null, null, null, null);
insert into tab_card values (6659, null, null, null, null);
insert into tab_card values (6660, null, null, null, null);
insert into tab_card values (6665, null, null, null, null);
insert into tab_card values (6667, null, null, null, null);
insert into tab_card values (6668, null, null, null, null);
insert into tab_card values (6675, null, null, null, null);
insert into tab_card values (6676, null, null, null, null);
insert into tab_card values (6677, null, null, null, null);
insert into tab_card values (6678, null, null, null, null);
insert into tab_card values (6682, null, null, null, null);
insert into tab_card values (6686, null, null, null, null);
insert into tab_card values (6687, null, null, null, null);
insert into tab_card values (6688, null, null, null, null);
insert into tab_card values (6694, null, null, null, null);
insert into tab_card values (6695, null, null, null, null);
insert into tab_card values (6696, null, null, null, null);
insert into tab_card values (6698, null, null, null, null);
insert into tab_card values (6699, null, null, null, null);
insert into tab_card values (6704, null, null, null, null);
insert into tab_card values (6705, null, null, null, null);
insert into tab_card values (6712, null, null, null, null);
insert into tab_card values (6715, null, null, null, null);
insert into tab_card values (6721, null, null, null, null);
insert into tab_card values (6725, null, null, null, null);
insert into tab_card values (6726, null, null, null, null);
insert into tab_card values (6727, null, null, null, null);
insert into tab_card values (6729, null, null, null, null);
insert into tab_card values (6730, null, null, null, null);
insert into tab_card values (6732, null, null, null, null);
insert into tab_card values (6734, null, null, null, null);
insert into tab_card values (6736, null, null, null, null);
insert into tab_card values (6737, null, null, null, null);
insert into tab_card values (6738, null, null, null, null);
insert into tab_card values (6745, null, null, null, null);
insert into tab_card values (6746, null, null, null, null);
insert into tab_card values (6748, null, null, null, null);
insert into tab_card values (6751, null, null, null, null);
insert into tab_card values (6753, null, null, null, null);
insert into tab_card values (6755, null, null, null, null);
insert into tab_card values (6758, null, null, null, null);
insert into tab_card values (6763, null, null, null, null);
insert into tab_card values (6764, null, null, null, null);
insert into tab_card values (6766, null, null, null, null);
insert into tab_card values (6785, null, null, null, null);
insert into tab_card values (6790, null, null, null, null);
insert into tab_card values (6791, null, null, null, null);
insert into tab_card values (6793, null, null, null, null);
insert into tab_card values (6805, null, null, null, null);
insert into tab_card values (6808, null, null, null, null);
insert into tab_card values (6810, null, null, null, null);
insert into tab_card values (6816, null, null, null, null);
insert into tab_card values (6817, null, null, null, null);
insert into tab_card values (6818, null, null, null, null);
insert into tab_card values (6819, null, null, null, null);
insert into tab_card values (6820, null, null, null, null);
insert into tab_card values (6821, null, null, null, null);
insert into tab_card values (6824, null, null, null, null);
insert into tab_card values (6836, null, null, null, null);
insert into tab_card values (6841, null, null, null, null);
insert into tab_card values (6851, null, null, null, null);
insert into tab_card values (6852, null, null, null, null);
insert into tab_card values (6855, null, null, null, null);
insert into tab_card values (6856, null, null, null, null);
insert into tab_card values (6857, null, null, null, null);
insert into tab_card values (6859, null, null, null, null);
insert into tab_card values (6861, null, null, null, null);
insert into tab_card values (6863, null, null, null, null);
insert into tab_card values (6865, null, null, null, null);
insert into tab_card values (6866, null, null, null, null);
insert into tab_card values (6868, null, null, null, null);
insert into tab_card values (6871, null, null, null, null);
insert into tab_card values (6872, null, null, null, null);
insert into tab_card values (6875, null, null, null, null);
insert into tab_card values (6876, null, null, null, null);
insert into tab_card values (6877, null, null, null, null);
insert into tab_card values (6878, null, null, null, null);
insert into tab_card values (6887, null, null, null, null);
insert into tab_card values (6888, null, null, null, null);
insert into tab_card values (6895, null, null, null, null);
insert into tab_card values (6903, null, null, null, null);
insert into tab_card values (6908, null, null, null, null);
insert into tab_card values (6913, null, null, null, null);
insert into tab_card values (6919, null, null, null, null);
insert into tab_card values (6921, null, null, null, null);
insert into tab_card values (6922, null, null, null, null);
insert into tab_card values (6923, null, null, null, null);
insert into tab_card values (6926, null, null, null, null);
insert into tab_card values (6929, null, null, null, null);
insert into tab_card values (6933, null, null, null, null);
insert into tab_card values (6934, null, null, null, null);
insert into tab_card values (6940, null, null, null, null);
insert into tab_card values (6942, null, null, null, null);
insert into tab_card values (6944, null, null, null, null);
insert into tab_card values (6948, null, null, null, null);
insert into tab_card values (6949, null, null, null, null);
insert into tab_card values (6950, null, null, null, null);
insert into tab_card values (6955, null, null, null, null);
insert into tab_card values (6956, null, null, null, null);
insert into tab_card values (6959, null, null, null, null);
insert into tab_card values (6960, null, null, null, null);
insert into tab_card values (6961, null, null, null, null);
insert into tab_card values (6962, null, null, null, null);
insert into tab_card values (6965, null, null, null, null);
insert into tab_card values (6969, null, null, null, null);
insert into tab_card values (6970, null, null, null, null);
insert into tab_card values (6984, null, null, null, null);
insert into tab_card values (6985, null, null, null, null);
insert into tab_card values (6986, null, null, null, null);
insert into tab_card values (6995, null, null, null, null);
insert into tab_card values (6996, null, null, null, null);
insert into tab_card values (6998, null, null, null, null);
insert into tab_card values (7004, null, null, null, null);
insert into tab_card values (7008, null, null, null, null);
insert into tab_card values (7013, null, null, null, null);
insert into tab_card values (7034, null, null, null, null);
insert into tab_card values (7035, null, null, null, null);
insert into tab_card values (7036, null, null, null, null);
insert into tab_card values (7037, null, null, null, null);
insert into tab_card values (7046, null, null, null, null);
insert into tab_card values (7049, null, null, null, null);
insert into tab_card values (7050, null, null, null, null);
insert into tab_card values (7051, null, null, null, null);
insert into tab_card values (7055, null, null, null, null);
insert into tab_card values (7057, null, null, null, null);
insert into tab_card values (7061, null, null, null, null);
insert into tab_card values (7066, null, null, null, null);
insert into tab_card values (7067, null, null, null, null);
insert into tab_card values (7072, null, null, null, null);
insert into tab_card values (7085, null, null, null, null);
insert into tab_card values (7087, null, null, null, null);
insert into tab_card values (7088, null, null, null, null);
insert into tab_card values (7091, null, null, null, null);
insert into tab_card values (7096, null, null, null, null);
insert into tab_card values (7097, null, null, null, null);
insert into tab_card values (7100, null, null, null, null);
insert into tab_card values (7101, null, null, null, null);
insert into tab_card values (7104, null, null, null, null);
insert into tab_card values (7110, null, null, null, null);
insert into tab_card values (7115, null, null, null, null);
insert into tab_card values (7121, null, null, null, null);
insert into tab_card values (7122, null, null, null, null);
insert into tab_card values (7129, null, null, null, null);
insert into tab_card values (7136, null, null, null, null);
insert into tab_card values (7137, null, null, null, null);
insert into tab_card values (7138, null, null, null, null);
insert into tab_card values (7142, null, null, null, null);
insert into tab_card values (7147, null, null, null, null);
insert into tab_card values (7151, null, null, null, null);
insert into tab_card values (7164, null, null, null, null);
insert into tab_card values (7166, null, null, null, null);
insert into tab_card values (7168, null, null, null, null);
insert into tab_card values (7171, null, null, null, null);
insert into tab_card values (7172, null, null, null, null);
insert into tab_card values (7176, null, null, null, null);
insert into tab_card values (7181, null, null, null, null);
insert into tab_card values (7187, null, null, null, null);
insert into tab_card values (7189, null, null, null, null);
insert into tab_card values (7192, null, null, null, null);
insert into tab_card values (7194, null, null, null, null);
insert into tab_card values (7195, null, null, null, null);
insert into tab_card values (7198, null, null, null, null);
insert into tab_card values (7199, null, null, null, null);
insert into tab_card values (7200, null, null, null, null);
insert into tab_card values (7201, null, null, null, null);
insert into tab_card values (7202, null, null, null, null);
insert into tab_card values (7209, null, null, null, null);
insert into tab_card values (7213, null, null, null, null);
insert into tab_card values (7219, null, null, null, null);
insert into tab_card values (7220, null, null, null, null);
insert into tab_card values (7221, null, null, null, null);
insert into tab_card values (7226, null, null, null, null);
insert into tab_card values (7227, null, null, null, null);
insert into tab_card values (7230, null, null, null, null);
insert into tab_card values (7233, null, null, null, null);
insert into tab_card values (7235, null, null, null, null);
insert into tab_card values (7240, null, null, null, null);
insert into tab_card values (7241, null, null, null, null);
insert into tab_card values (7242, null, null, null, null);
insert into tab_card values (7246, null, null, null, null);
insert into tab_card values (7249, null, null, null, null);
insert into tab_card values (7250, null, null, null, null);
insert into tab_card values (7253, null, null, null, null);
insert into tab_card values (7255, null, null, null, null);
insert into tab_card values (7259, null, null, null, null);
insert into tab_card values (7262, null, null, null, null);
insert into tab_card values (7263, null, null, null, null);
insert into tab_card values (7264, null, null, null, null);
insert into tab_card values (7271, null, null, null, null);
insert into tab_card values (7277, null, null, null, null);
insert into tab_card values (7279, null, null, null, null);
insert into tab_card values (7284, null, null, null, null);
insert into tab_card values (7286, null, null, null, null);
insert into tab_card values (7292, null, null, null, null);
insert into tab_card values (7294, null, null, null, null);
insert into tab_card values (7295, null, null, null, null);
insert into tab_card values (7304, null, null, null, null);
insert into tab_card values (7308, null, null, null, null);
insert into tab_client values (4959,2,1,'1945-2-4','m');
insert into tab_client values (4959,3,1,'1940-10-9','f');
insert into tab_client values (4961,25,21,'1939-4-23','f');
insert into tab_client values (4962,31,68,'1962-2-9','m');
insert into tab_client values (4967,45,20,'1952-8-26','m');
insert into tab_client values (4968,46,19,'1940-1-30','f');
insert into tab_client values (4973,78,16,'1944-6-13','f');
insert into tab_client values (4986,116,74,'1942-1-28','m');
insert into tab_client values (4986,117,74,'1936-9-20','f');
insert into tab_client values (4988,124,44,'1967-9-21','m');
insert into tab_client values (4989,127,21,'1950-12-27','f');
insert into tab_client values (4990,132,36,'1953-1-26','m');
insert into tab_client values (4996,158,40,'1945-7-3','f');
insert into tab_client values (4996,159,40,'1938-9-10','m');
insert into tab_client values (5002,210,66,'1939-11-30','m');
insert into tab_client values (5002,211,66,'1945-6-28','f');
insert into tab_client values (5005,215,71,'1967-9-24','m');
insert into tab_client values (5015,272,70,'1944-10-25','f');
insert into tab_client values (5027,333,38,'1971-10-19','m');
insert into tab_client values (5032,352,56,'1940-8-27','m');
insert into tab_client values (5034,370,71,'1956-1-5','f');
insert into tab_client values (5036,376,14,'1973-1-8','f');
insert into tab_client values (5039,383,15,'1939-5-17','f');
insert into tab_client values (5039,384,15,'1935-10-8','m');
insert into tab_client values (5041,389,47,'1974-6-30','f');
insert into tab_client values (5042,403,42,'1973-5-26','f');
insert into tab_client values (5042,404,42,'1967-4-20','m');
insert into tab_client values (5043,414,46,'1947-10-19','f');
insert into tab_client values (5043,415,46,'1945-4-1','m');
insert into tab_client values (5044,421,54,'1965-7-31','m');
insert into tab_client values (5045,424,1,'1947-10-8','m');
insert into tab_client values (5046,426,72,'1937-6-1','m');
insert into tab_client values (5046,427,72,'1941-9-14','f');
insert into tab_client values (5051,458,68,'1961-7-24','m');
insert into tab_client values (5060,512,60,'1965-8-3','f');
insert into tab_client values (5061,530,29,'1957-9-27','f');
insert into tab_client values (5063,533,54,'1941-5-19','f');
insert into tab_client values (5072,568,8,'1960-7-19','f');
insert into tab_client values (5082,603,13,'1966-3-9','f');
insert into tab_client values (5086,631,70,'1956-3-22','f');
insert into tab_client values (5088,655,32,'1942-12-10','m');
insert into tab_client values (5103,798,27,'1940-2-12','f');
insert into tab_client values (5103,799,27,'1936-2-19','m');
insert into tab_client values (5110,810,58,'1945-9-24','f');
insert into tab_client values (5110,811,58,'1940-5-28','m');
insert into tab_client values (5117,861,1,'1956-9-13','f');
insert into tab_client values (5124,939,21,'1952-8-3','m');
insert into tab_client values (5125,944,39,'1970-12-18','m');
insert into tab_client values (5125,945,39,'1977-1-10','f');
insert into tab_client values (5126,946,54,'1951-8-6','m');
insert into tab_client values (5128,968,69,'1957-2-17','m');
insert into tab_client values (5130,976,16,'1955-11-19','f');
insert into tab_client values (5131,980,40,'1961-9-30','m');
insert into tab_client values (5132,981,5,'1960-6-28','m');
insert into tab_client values (5134,992,19,'1948-5-21','m');
insert into tab_client values (5136,1020,72,'1977-5-10','f');
insert into tab_client values (5138,1029,1,'1954-3-16','f');
insert into tab_client values (5140,1051,73,'1971-8-26','f');
insert into tab_client values (5145,1102,72,'1935-1-29','m');
insert into tab_client values (5147,1130,70,'1940-11-26','f');
insert into tab_client values (5148,1133,37,'1958-9-15','f');
insert into tab_client values (5148,1134,37,'1959-10-1','m');
insert into tab_client values (5151,1157,4,'1958-12-30','f');
insert into tab_client values (5154,1197,6,'1966-10-2','f');
insert into tab_client values (5158,1208,70,'1975-9-1','f');
insert into tab_client values (5160,1215,45,'1944-5-6','m');
insert into tab_client values (5161,1216,65,'1945-6-12','f');
insert into tab_client values (5169,1282,52,'1936-11-27','m');
insert into tab_client values (5170,1286,52,'1950-3-13','f');
insert into tab_client values (5172,1300,45,'1979-10-27','m');
insert into tab_client values (5174,1311,54,'1956-12-18','f');
insert into tab_client values (5176,1327,20,'1963-12-31','f');
insert into tab_client values (5189,1404,11,'1968-12-20','f');
insert into tab_client values (5206,1499,74,'1951-11-29','f');
insert into tab_client values (5207,1501,68,'1946-1-22','m');
insert into tab_client values (5208,1505,65,'1971-6-25','f');
insert into tab_client values (5209,1509,62,'1942-4-19','f');
insert into tab_client values (5210,1511,13,'1962-3-6','f');
insert into tab_client values (5212,1516,38,'1946-10-17','f');
insert into tab_client values (5214,1533,55,'1960-12-22','m');
insert into tab_client values (5221,1554,55,'1944-12-15','m');
insert into tab_client values (5226,1594,56,'1939-9-29','m');
insert into tab_client values (5229,1608,53,'1941-11-11','m');
insert into tab_client values (5229,1609,53,'1944-5-30','f');
insert into tab_client values (5236,1662,53,'1967-9-7','m');
insert into tab_client values (5237,1663,19,'1957-4-29','m');
insert into tab_client values (5241,1681,34,'1940-11-25','m');
insert into tab_client values (5245,1705,19,'1946-7-1','f');
insert into tab_client values (5245,1706,19,'1944-7-19','m');
insert into tab_client values (5253,1755,65,'1965-8-18','f');
insert into tab_client values (5260,1793,41,'1945-3-17','f');
insert into tab_client values (5265,1816,62,'1951-7-24','m');
insert into tab_client values (5269,1851,31,'1975-9-12','f');
insert into tab_client values (5270,1852,50,'1962-9-5','m');
insert into tab_client values (5281,1913,69,'1968-4-15','m');
insert into tab_client values (5282,1917,69,'1969-3-13','f');
insert into tab_client values (5285,1944,31,'1957-1-22','f');
insert into tab_client values (5287,1985,6,'1937-12-13','m');
insert into tab_client values (5287,1986,6,'1942-8-13','f');
insert into tab_client values (5293,2008,47,'1940-6-7','m');
insert into tab_client values (5301,2063,68,'1950-9-26','f');
insert into tab_client values (5304,2083,71,'1943-3-12','m');
insert into tab_client values (5310,2136,28,'1940-7-24','f');
insert into tab_client values (5311,2141,28,'1951-9-6','m');
insert into tab_client values (5312,2148,31,'1953-7-20','f');
insert into tab_client values (5313,2153,36,'1949-5-16','f');
insert into tab_client values (5314,2166,30,'1947-7-22','f');
insert into tab_client values (5316,2181,46,'1968-7-22','m');
insert into tab_client values (5318,2190,28,'1974-10-22','m');
insert into tab_client values (5318,2191,28,'1979-8-4','f');
insert into tab_client values (5319,2195,68,'1942-9-13','f');
insert into tab_client values (5320,2205,55,'1952-12-12','m');
insert into tab_client values (5325,2235,14,'1940-4-20','f');
insert into tab_client values (5329,2259,19,'1950-1-2','f');
insert into tab_client values (5332,2267,1,'1966-4-10','f');
insert into tab_client values (5334,2277,1,'1979-3-25','m');
insert into tab_client values (5337,2288,32,'1957-8-23','f');
insert into tab_client values (5337,2289,32,'1954-8-21','m');
insert into tab_client values (5338,2291,6,'1957-9-19','m');
insert into tab_client values (5343,2316,1,'1970-3-25','m');
insert into tab_client values (5346,2342,70,'1948-12-18','m');
insert into tab_client values (5350,2392,26,'1955-5-21','m');
insert into tab_client values (5351,2403,1,'1963-1-25','f');
insert into tab_client values (5352,2422,68,'1976-6-9','f');
insert into tab_client values (5354,2430,5,'1937-10-28','m');
insert into tab_client values (5358,2451,42,'1939-12-6','m');
insert into tab_client values (5360,2470,53,'1943-6-14','m');
insert into tab_client values (5360,2471,53,'1942-1-5','f');
insert into tab_client values (5363,2489,64,'1975-1-28','f');
insert into tab_client values (5365,2494,37,'1971-1-6','m');
insert into tab_client values (5366,2501,70,'1940-12-4','f');
insert into tab_client values (5367,2503,54,'1977-9-23','f');
insert into tab_client values (5368,2514,59,'1957-2-11','m');
insert into tab_client values (5369,2522,74,'1937-9-8','m');
insert into tab_client values (5369,2523,74,'1937-12-2','f');
insert into tab_client values (5375,2550,1,'1976-10-12','f');
insert into tab_client values (5377,2560,70,'1974-6-20','f');
insert into tab_client values (5382,2581,52,'1953-11-19','f');
insert into tab_client values (5384,2590,42,'1964-10-19','f');
insert into tab_client values (5384,2591,42,'1960-2-27','m');
insert into tab_client values (5385,2592,1,'1980-8-31','f');
insert into tab_client values (5385,2593,1,'1977-6-10','m');
insert into tab_client values (5388,2606,31,'1943-1-4','m');
insert into tab_client values (5389,2621,51,'1956-5-9','m');
insert into tab_client values (5390,2623,16,'1965-7-16','f');
insert into tab_client values (5395,2635,67,'1966-12-10','f');
insert into tab_client values (5398,2647,9,'1940-3-26','m');
insert into tab_client values (5398,2648,9,'1934-10-10','f');
insert into tab_client values (5409,2686,19,'1951-3-24','f');
insert into tab_client values (5409,2687,19,'1949-8-22','m');
insert into tab_client values (5413,2698,31,'1970-10-7','f');
insert into tab_client values (5413,2699,31,'1977-2-23','m');
insert into tab_client values (5414,2700,34,'1945-2-22','m');
insert into tab_client values (5415,2708,73,'1958-8-12','m');
insert into tab_client values (5418,2719,29,'1964-10-30','f');
insert into tab_client values (5419,2720,1,'1949-9-5','f');
insert into tab_client values (5420,2721,24,'1950-6-26','f');
insert into tab_client values (5428,2739,13,'1950-1-26','m');
insert into tab_client values (5429,2746,1,'1971-2-25','m');
insert into tab_client values (5435,2759,2,'1974-1-26','m');
insert into tab_client values (5445,2809,33,'1979-2-14','m');
insert into tab_client values (5446,2822,50,'1958-10-19','m');
insert into tab_client values (5447,2823,70,'1946-12-18','f');
insert into tab_client values (5449,2831,68,'1980-7-9','f');
insert into tab_client values (5450,2834,52,'1949-5-23','m');
insert into tab_client values (5451,2841,18,'1973-4-10','f');
insert into tab_client values (5452,2843,70,'1966-10-6','f');
insert into tab_client values (5453,2853,28,'1956-4-25','f');
insert into tab_client values (5463,2915,33,'1954-2-22','f');
insert into tab_client values (5464,2922,43,'1940-9-7','m');
insert into tab_client values (5469,2952,52,'1978-1-17','f');
insert into tab_client values (5470,2966,65,'1955-2-20','m');
insert into tab_client values (5479,3001,1,'1958-10-7','m');
insert into tab_client values (5482,3013,51,'1950-3-18','f');
insert into tab_client values (5482,3014,51,'1953-11-5','m');
insert into tab_client values (5486,3038,6,'1946-3-5','f');
insert into tab_client values (5491,3072,1,'1936-4-14','m');
insert into tab_client values (5491,3073,1,'1937-10-23','f');
insert into tab_client values (5494,3103,64,'1973-3-7','f');
insert into tab_client values (5495,3113,60,'1971-11-12','f');
insert into tab_client values (5495,3114,60,'1971-2-24','m');
insert into tab_client values (5501,3163,1,'1964-5-26','f');
insert into tab_client values (5501,3164,1,'1962-9-10','m');
insert into tab_client values (5519,3251,52,'1962-12-28','f');
insert into tab_client values (5519,3252,52,'1961-3-26','m');
insert into tab_client values (5520,3257,73,'1978-5-11','f');
insert into tab_client values (5523,3264,63,'1950-10-20','f');
insert into tab_client values (5525,3284,2,'1936-7-2','m');
insert into tab_client values (5525,3285,2,'1943-9-17','f');
insert into tab_client values (5526,3291,52,'1947-1-23','m');
insert into tab_client values (5527,3294,52,'1957-3-8','m');
insert into tab_client values (5531,3324,26,'1971-4-13','f');
insert into tab_client values (5531,3325,26,'1963-9-28','m');
insert into tab_client values (5532,3326,57,'1952-12-26','f');
insert into tab_client values (5533,3335,11,'1967-2-10','m');
insert into tab_client values (5549,3414,11,'1947-10-17','f');
insert into tab_client values (5556,3471,1,'1952-9-29','f');
insert into tab_client values (5561,3517,68,'1953-6-24','f');
insert into tab_client values (5563,3519,74,'1949-12-15','m');
insert into tab_client values (5568,3542,10,'1939-9-2','m');
insert into tab_client values (5568,3543,10,'1941-8-19','f');
insert into tab_client values (5569,3546,3,'1971-2-28','m');
insert into tab_client values (5576,3576,1,'1939-3-15','f');
insert into tab_client values (5582,3601,19,'1938-8-3','m');
insert into tab_client values (5582,3602,19,'1940-12-10','f');
insert into tab_client values (5584,3606,63,'1958-6-6','m');
insert into tab_client values (5585,3608,66,'1947-12-9','m');
insert into tab_client values (5585,3609,66,'1955-10-26','f');
insert into tab_client values (5586,3616,77,'1964-4-14','f');
insert into tab_client values (5589,3629,42,'1947-12-13','m');
insert into tab_client values (5591,3649,10,'1959-10-25','f');
insert into tab_client values (5593,3670,44,'1980-9-17','f');
insert into tab_client values (5595,3687,49,'1972-2-6','m');
insert into tab_client values (5595,3688,49,'1975-5-2','f');
insert into tab_client values (5599,3705,1,'1965-6-4','f');
insert into tab_client values (5606,3730,59,'1945-8-7','f');
insert into tab_client values (5610,3763,38,'1977-8-12','f');
insert into tab_client values (5610,3764,38,'1978-1-29','m');
insert into tab_client values (5611,3767,14,'1936-9-7','m');
insert into tab_client values (5611,3768,14,'1944-3-4','f');
insert into tab_client values (5614,3793,39,'1951-6-20','f');
insert into tab_client values (5616,3800,38,'1954-6-15','f');
insert into tab_client values (5616,3801,38,'1948-8-15','m');
insert into tab_client values (5620,3822,48,'1953-11-26','m');
insert into tab_client values (5624,3829,59,'1972-3-13','m');
insert into tab_client values (5625,3855,29,'1939-3-20','m');
insert into tab_client values (5634,3906,64,'1936-12-23','m');
insert into tab_client values (5635,3907,1,'1954-12-9','f');
insert into tab_client values (5638,3929,74,'1957-11-1','m');
insert into tab_client values (5643,3962,74,'1952-11-28','m');
insert into tab_client values (5644,3984,1,'1964-3-13','f');
insert into tab_client values (5651,4024,3,'1964-10-16','m');
insert into tab_client values (5651,4025,3,'1971-10-7','f');
insert into tab_client values (5656,4055,74,'1953-6-1','f');
insert into tab_client values (5657,4056,63,'1952-7-26','f');
insert into tab_client values (5665,4099,12,'1945-5-3','f');
insert into tab_client values (5669,4114,63,'1964-2-9','m');
insert into tab_client values (5674,4132,42,'1962-10-15','m');
insert into tab_client values (5674,4133,42,'1965-3-22','f');
insert into tab_client values (5681,4169,58,'1980-2-19','f');
insert into tab_client values (5681,4170,58,'1983-8-27','m');
insert into tab_client values (5682,4177,34,'1935-12-25','m');
insert into tab_client values (5683,4182,16,'1941-6-23','m');
insert into tab_client values (5683,4183,16,'1940-11-13','f');
insert into tab_client values (5693,4217,9,'1951-6-25','f');
insert into tab_client values (5698,4291,58,'1951-5-7','f');
insert into tab_client values (5699,4299,50,'1977-9-15','f');
insert into tab_client values (5706,4352,72,'1971-7-24','m');
insert into tab_client values (5713,4377,48,'1978-1-31','m');
insert into tab_client values (5718,4386,53,'1945-12-27','f');
insert into tab_client values (5719,4417,1,'1976-4-24','m');
insert into tab_client values (5723,4428,38,'1954-3-9','m');
insert into tab_client values (5724,4433,1,'1968-2-22','m');
insert into tab_client values (5725,4434,64,'1964-3-29','m');
insert into tab_client values (5725,4435,64,'1965-10-30','f');
insert into tab_client values (5731,4474,3,'1964-12-9','f');
insert into tab_client values (5739,4520,1,'1957-6-28','f');
insert into tab_client values (5740,4527,1,'1963-2-4','f');
insert into tab_client values (5741,4529,37,'1976-9-16','m');
insert into tab_client values (5741,4530,37,'1984-9-18','f');
insert into tab_client values (5750,4584,7,'1949-6-24','f');
insert into tab_client values (5754,4620,54,'1940-11-1','f');
insert into tab_client values (5754,4621,54,'1946-2-10','m');
insert into tab_client values (5758,4652,53,'1962-2-26','m');
insert into tab_client values (5760,4656,1,'1942-9-16','m');
insert into tab_client values (5765,4672,44,'1949-8-28','m');
insert into tab_client values (5772,4710,52,'1961-5-9','f');
insert into tab_client values (5772,4711,52,'1955-7-23','m');
insert into tab_client values (5773,4712,37,'1960-6-6','f');
insert into tab_client values (5774,4722,8,'1972-1-28','m');
insert into tab_client values (5779,4754,27,'1939-12-28','f');
insert into tab_client values (5782,4768,1,'1960-4-3','f');
insert into tab_client values (5784,4786,54,'1938-8-16','m');
insert into tab_client values (5790,4861,57,'1977-11-1','f');
insert into tab_client values (5799,4882,36,'1978-12-21','m');
insert into tab_client values (5804,4916,52,'1939-1-9','m');
insert into tab_client values (5805,4918,11,'1968-5-6','m');
insert into tab_client values (5808,4937,54,'1960-11-9','f');
insert into tab_client values (5815,4956,6,'1946-10-10','m');
insert into tab_client values (5817,4968,50,'1938-5-26','m');
insert into tab_client values (5823,4993,1,'1973-6-27','f');
insert into tab_client values (5823,4994,1,'1978-6-21','m');
insert into tab_client values (5830,5050,62,'1951-1-19','m');
insert into tab_client values (5836,5133,66,'1959-8-10','f');
insert into tab_client values (5837,5134,58,'1967-7-19','f');
insert into tab_client values (5841,5143,77,'1973-3-9','m');
insert into tab_client values (5841,5144,77,'1966-6-7','f');
insert into tab_client values (5850,5171,64,'1956-9-23','f');
insert into tab_client values (5856,5203,61,'1945-9-8','f');
insert into tab_client values (5861,5224,29,'1949-7-24','m');
insert into tab_client values (5862,5232,74,'1948-4-6','f');
insert into tab_client values (5865,5245,38,'1942-3-18','f');
insert into tab_client values (5868,5253,69,'1946-10-7','f');
insert into tab_client values (5868,5254,69,'1948-9-16','m');
insert into tab_client values (5876,5318,74,'1968-3-28','m');
insert into tab_client values (5876,5319,74,'1964-9-23','f');
insert into tab_client values (5877,5320,17,'1951-4-7','f');
insert into tab_client values (5877,5321,17,'1950-2-1','m');
insert into tab_client values (5878,5322,73,'1956-3-13','f');
insert into tab_client values (5880,5333,39,'1967-5-29','f');
insert into tab_client values (5882,5337,1,'1961-5-2','m');
insert into tab_client values (5882,5338,1,'1966-5-25','f');
insert into tab_client values (5886,5364,62,'1964-3-14','m');
insert into tab_client values (5886,5365,62,'1971-5-1','f');
insert into tab_client values (5887,5366,60,'1971-9-20','f');
insert into tab_client values (5887,5367,60,'1979-6-6','m');
insert into tab_client values (5889,5376,14,'1970-1-23','m');
insert into tab_client values (5892,5384,73,'1935-7-21','m');
insert into tab_client values (5893,5389,17,'1968-8-31','m');
insert into tab_client values (5895,5395,45,'1962-6-1','m');
insert into tab_client values (5897,5399,24,'1972-12-27','f');
insert into tab_client values (5900,5433,50,'1975-9-24','m');
insert into tab_client values (5906,5468,68,'1944-5-27','f');
insert into tab_client values (5909,5487,56,'1947-9-17','f');
insert into tab_client values (5918,5517,57,'1964-3-13','m');
insert into tab_client values (5922,5521,9,'1973-5-15','f');
insert into tab_client values (5923,5526,27,'1947-3-19','m');
insert into tab_client values (5923,5527,27,'1941-11-28','f');
insert into tab_client values (5930,5563,1,'1976-1-1','m');
insert into tab_client values (5931,5565,3,'1966-12-22','f');
insert into tab_client values (5932,5574,9,'1970-9-12','f');
insert into tab_client values (5933,5579,77,'1951-2-16','m');
insert into tab_client values (5933,5580,77,'1952-3-1','f');
insert into tab_client values (5938,5606,4,'1980-8-6','m');
insert into tab_client values (5940,5618,63,'1953-3-22','f');
insert into tab_client values (5942,5642,70,'1957-11-4','f');
insert into tab_client values (5953,5684,8,'1955-3-2','f');
insert into tab_client values (5956,5699,73,'1950-10-8','m');
insert into tab_client values (5959,5701,2,'1959-11-22','f');
insert into tab_client values (5963,5727,54,'1953-2-24','m');
insert into tab_client values (5970,5760,66,'1948-5-8','m');
insert into tab_client values (5970,5761,66,'1941-5-11','f');
insert into tab_client values (5973,5774,46,'1960-1-15','f');
insert into tab_client values (5973,5775,46,'1955-3-10','m');
insert into tab_client values (5976,5788,72,'1962-5-4','m');
insert into tab_client values (5977,5801,26,'1979-12-10','f');
insert into tab_client values (5980,5826,15,'1968-9-9','m');
insert into tab_client values (5980,5827,15,'1975-1-28','f');
insert into tab_client values (5988,5858,52,'1952-7-17','m');
insert into tab_client values (5988,5859,52,'1945-1-29','f');
insert into tab_client values (5989,5860,47,'1964-4-22','m');
insert into tab_client values (5991,5866,67,'1978-4-3','f');
insert into tab_client values (5992,5873,5,'1979-4-6','f');
insert into tab_client values (5997,5911,14,'1935-10-3','m');
insert into tab_client values (5999,5928,42,'1970-9-10','f');
insert into tab_client values (6004,5965,50,'1951-4-10','m');
insert into tab_client values (6006,5977,43,'1979-5-31','m');
insert into tab_client values (6007,5978,33,'1944-1-27','f');
insert into tab_client values (6010,6001,60,'1937-5-1','m');
insert into tab_client values (6011,6015,54,'1973-11-21','m');
insert into tab_client values (6012,6033,1,'1966-5-27','m');
insert into tab_client values (6013,6034,20,'1939-8-15','m');
insert into tab_client values (6014,6039,1,'1958-7-3','f');
insert into tab_client values (6014,6040,1,'1963-4-10','m');
insert into tab_client values (6015,6042,53,'1963-10-12','m');
insert into tab_client values (6019,6077,54,'1980-4-30','f');
insert into tab_client values (6027,6115,13,'1953-12-25','f');
insert into tab_client values (6028,6122,6,'1968-2-16','f');
insert into tab_client values (6037,6175,72,'1964-5-17','m');
insert into tab_client values (6038,6178,1,'1940-10-15','f');
insert into tab_client values (6043,6185,58,'1948-3-5','f');
insert into tab_client values (6043,6186,58,'1952-5-27','m');
insert into tab_client values (6044,6196,68,'1943-3-9','m');
insert into tab_client values (6052,6235,5,'1940-4-4','m');
insert into tab_client values (6054,6255,54,'1946-1-1','f');
insert into tab_client values (6054,6256,54,'1941-5-21','m');
insert into tab_client values (6055,6257,75,'1942-8-20','f');
insert into tab_client values (6059,6275,13,'1956-12-30','m');
insert into tab_client values (6063,6299,1,'1936-8-9','m');
insert into tab_client values (6064,6301,55,'1949-3-8','f');
insert into tab_client values (6066,6317,77,'1957-1-27','f');
insert into tab_client values (6066,6318,77,'1950-3-5','m');
insert into tab_client values (6072,6349,72,'1972-12-3','m');
insert into tab_client values (6073,6359,64,'1976-7-6','m');
insert into tab_client values (6075,6363,4,'1973-10-20','f');
insert into tab_client values (6076,6366,49,'1966-2-21','m');
insert into tab_client values (6077,6367,44,'1970-4-28','m');
insert into tab_client values (6078,6383,15,'1970-1-7','m');
insert into tab_client values (6083,6408,47,'1956-6-29','m');
insert into tab_client values (6087,6417,40,'1950-1-7','m');
insert into tab_client values (6088,6422,28,'1960-9-23','m');
insert into tab_client values (6095,6469,4,'1953-3-16','m');
insert into tab_client values (6097,6473,76,'1940-9-30','f');
insert into tab_client values (6097,6474,76,'1934-11-30','m');
insert into tab_client values (6103,6499,44,'1963-2-1','m');
insert into tab_client values (6104,6511,47,'1953-8-7','m');
insert into tab_client values (6109,6544,66,'1974-8-4','m');
insert into tab_client values (6109,6545,66,'1978-9-9','f');
insert into tab_client values (6111,6551,24,'1948-8-12','f');
insert into tab_client values (6112,6567,5,'1978-11-21','f');
insert into tab_client values (6113,6571,72,'1971-3-24','f');
insert into tab_client values (6118,6610,57,'1954-6-3','m');
insert into tab_client values (6120,6616,1,'1953-6-18','m');
insert into tab_client values (6130,6691,43,'1942-10-15','m');
insert into tab_client values (6136,6729,15,'1957-12-27','m');
insert into tab_client values (6137,6731,13,'1943-11-26','m');
insert into tab_client values (6142,6749,9,'1943-9-29','f');
insert into tab_client values (6142,6750,9,'1946-6-4','m');
insert into tab_client values (6144,6753,15,'1962-5-23','m');
insert into tab_client values (6147,6764,19,'1944-4-12','m');
insert into tab_client values (6150,6789,57,'1979-3-26','m');
insert into tab_client values (6151,6798,61,'1948-8-3','f');
insert into tab_client values (6153,6803,5,'1980-12-7','f');
insert into tab_client values (6153,6804,5,'1981-6-7','m');
insert into tab_client values (6157,6829,10,'1963-12-24','f');
insert into tab_client values (6168,6892,1,'1951-3-22','f');
insert into tab_client values (6168,6893,1,'1944-1-14','m');
insert into tab_client values (6169,6895,42,'1971-6-24','m');
insert into tab_client values (6173,6922,14,'1939-4-27','f');
insert into tab_client values (6175,6936,52,'1959-2-27','f');
insert into tab_client values (6178,6946,74,'1970-1-29','f');
insert into tab_client values (6185,6987,1,'1968-1-29','m');
insert into tab_client values (6190,7010,70,'1967-6-30','m');
insert into tab_client values (6190,7011,70,'1961-4-14','f');
insert into tab_client values (6196,7065,5,'1971-7-7','f');
insert into tab_client values (6202,7127,3,'1957-9-29','m');
insert into tab_client values (6207,7150,45,'1963-9-16','f');
insert into tab_client values (6210,7166,15,'1964-5-13','m');
insert into tab_client values (6215,7186,27,'1944-6-1','f');
insert into tab_client values (6216,7195,50,'1962-9-11','m');
insert into tab_client values (6223,7241,57,'1957-9-6','f');
insert into tab_client values (6227,7286,47,'1970-2-10','f');
insert into tab_client values (6228,7291,77,'1940-12-2','f');
insert into tab_client values (6229,7299,1,'1938-9-16','m');
insert into tab_client values (6232,7311,56,'1949-5-18','m');
insert into tab_client values (6234,7324,1,'1963-3-18','f');
insert into tab_client values (6235,7325,24,'1975-1-24','m');
insert into tab_client values (6237,7339,19,'1974-2-28','f');
insert into tab_client values (6239,7348,6,'1977-10-26','f');
insert into tab_client values (6242,7366,29,'1973-4-12','f');
insert into tab_client values (6244,7390,1,'1937-11-4','m');
insert into tab_client values (6249,7411,54,'1963-1-25','f');
insert into tab_client values (6249,7412,54,'1955-10-17','m');
insert into tab_client values (6253,7422,74,'1958-11-26','m');
insert into tab_client values (6253,7423,74,'1964-9-8','f');
insert into tab_client values (6254,7434,34,'1942-4-4','f');
insert into tab_client values (6255,7435,67,'1957-4-16','f');
insert into tab_client values (6272,7521,74,'1960-2-9','f');
insert into tab_client values (6278,7567,5,'1937-3-15','m');
insert into tab_client values (6279,7576,38,'1962-7-10','m');
insert into tab_client values (6283,7594,64,'1949-4-7','f');
insert into tab_client values (6294,7672,26,'1953-4-5','m');
insert into tab_client values (6296,7678,3,'1962-4-7','m');
insert into tab_client values (6297,7683,12,'1946-4-1','m');
insert into tab_client values (6302,7723,48,'1966-6-14','f');
insert into tab_client values (6302,7724,48,'1968-2-23','m');
insert into tab_client values (6303,7727,31,'1958-6-13','f');
insert into tab_client values (6306,7753,70,'1978-9-23','f');
insert into tab_client values (6309,7765,1,'1958-2-24','f');
insert into tab_client values (6310,7772,1,'1976-12-30','f');
insert into tab_client values (6312,7787,34,'1951-7-10','m');
insert into tab_client values (6313,7796,50,'1975-9-27','f');
insert into tab_client values (6313,7797,50,'1970-7-30','m');
insert into tab_client values (6315,7814,61,'1976-1-6','f');
insert into tab_client values (6316,7815,4,'1946-1-19','f');
insert into tab_client values (6320,7843,6,'1966-5-11','m');
insert into tab_client values (6321,7855,7,'1964-1-30','f');
insert into tab_client values (6322,7862,74,'1965-10-17','m');
insert into tab_client values (6336,7914,38,'1966-10-24','f');
insert into tab_client values (6338,7959,1,'1978-6-29','f');
insert into tab_client values (6342,7980,16,'1976-8-8','m');
insert into tab_client values (6346,8030,1,'1967-7-19','m');
insert into tab_client values (6350,8064,54,'1966-11-29','f');
insert into tab_client values (6353,8074,61,'1958-10-7','m');
insert into tab_client values (6354,8076,16,'1950-7-27','f');
insert into tab_client values (6355,8089,35,'1965-4-6','m');
insert into tab_client values (6356,8091,5,'1971-2-10','m');
insert into tab_client values (6357,8096,38,'1979-11-2','f');
insert into tab_client values (6358,8105,72,'1963-3-12','m');
insert into tab_client values (6362,8130,62,'1976-5-8','f');
insert into tab_client values (6377,8200,1,'1944-5-31','f');
insert into tab_client values (6386,8276,43,'1979-6-8','f');
insert into tab_client values (6399,8333,60,'1966-2-1','m');
insert into tab_client values (6402,8356,3,'1969-9-4','m');
insert into tab_client values (6403,8359,74,'1979-12-6','m');
insert into tab_client values (6407,8366,41,'1960-5-21','f');
insert into tab_client values (6415,8392,36,'1966-5-8','f');
insert into tab_client values (6415,8393,36,'1966-5-6','m');
insert into tab_client values (6421,8432,38,'1968-1-6','f');
insert into tab_client values (6421,8433,38,'1961-9-11','m');
insert into tab_client values (6435,8502,51,'1943-4-19','m');
insert into tab_client values (6436,8506,69,'1979-12-25','f');
insert into tab_client values (6437,8510,55,'1947-5-24','m');
insert into tab_client values (6442,8548,57,'1945-5-10','f');
insert into tab_client values (6450,8568,1,'1971-12-3','f');
insert into tab_client values (6456,8598,46,'1957-12-31','f');
insert into tab_client values (6460,8610,55,'1948-5-2','f');
insert into tab_client values (6460,8611,55,'1948-10-26','m');
insert into tab_client values (6461,8615,12,'1939-4-13','f');
insert into tab_client values (6464,8636,71,'1941-11-12','f');
insert into tab_client values (6468,8661,1,'1954-5-11','f');
insert into tab_client values (6469,8666,7,'1971-8-28','f');
insert into tab_client values (6470,8667,77,'1967-2-12','f');
insert into tab_client values (6471,8670,5,'1943-1-7','f');
insert into tab_client values (6474,8677,49,'1955-8-14','m');
insert into tab_client values (6474,8678,49,'1962-7-12','f');
insert into tab_client values (6486,8737,17,'1948-4-11','f');
insert into tab_client values (6486,8738,17,'1948-7-10','m');
insert into tab_client values (6490,8764,70,'1940-7-7','f');
insert into tab_client values (6495,8777,11,'1953-4-11','f');
insert into tab_client values (6499,9173,1,'1945-2-4','m');
insert into tab_client values (6499,9174,1,'1940-10-9','f');
insert into tab_client values (6501,9196,21,'1939-4-23','f');
insert into tab_client values (6502,9202,68,'1962-2-9','m');
insert into tab_client values (6508,9217,19,'1940-1-30','f');
insert into tab_client values (6509,9226,64,'1939-12-25','f');
insert into tab_client values (6512,9236,31,'1956-5-7','f');
insert into tab_client values (6520,9273,39,'1955-8-26','f');
insert into tab_client values (6520,9274,39,'1958-4-5','m');
insert into tab_client values (6526,9316,63,'1958-10-26','f');
insert into tab_client values (6534,9340,54,'1967-8-22','m');
insert into tab_client values (6535,9346,43,'1972-12-10','m');
insert into tab_client values (6539,9362,56,'1973-7-19','f');
insert into tab_client values (6540,9366,72,'1975-6-26','m');
insert into tab_client values (6541,9370,59,'1975-12-20','m');
insert into tab_client values (6544,9403,16,'1974-3-22','m');
insert into tab_client values (6545,9417,21,'1949-3-8','m');
insert into tab_client values (6546,9418,1,'1950-4-10','m');
insert into tab_client values (6546,9419,1,'1950-11-9','f');
insert into tab_client values (6550,9427,62,'1970-11-9','f');
insert into tab_client values (6550,9428,62,'1965-5-9','m');
insert into tab_client values (6552,9450,68,'1943-10-11','f');
insert into tab_client values (6552,9451,68,'1942-5-5','m');
insert into tab_client values (6553,9456,40,'1941-12-7','f');
insert into tab_client values (6554,9457,46,'1978-9-26','m');
insert into tab_client values (6554,9458,46,'1973-11-21','f');
insert into tab_client values (6562,9505,1,'1958-8-21','m');
insert into tab_client values (6568,9546,50,'1955-11-2','f');
insert into tab_client values (6569,9555,13,'1947-5-15','f');
insert into tab_client values (6571,9569,19,'1950-7-18','f');
insert into tab_client values (6574,9582,2,'1942-4-14','f');
insert into tab_client values (6577,9593,74,'1968-1-28','f');
insert into tab_client values (6578,9606,52,'1949-2-16','m');
insert into tab_client values (6580,9611,23,'1958-5-27','m');
insert into tab_client values (6585,9641,64,'1945-1-26','m');
insert into tab_client values (6585,9642,64,'1937-9-3','f');
insert into tab_client values (6589,9663,19,'1945-9-24','m');
insert into tab_client values (6589,9664,19,'1944-11-13','f');
insert into tab_client values (6591,9670,38,'1948-5-4','m');
insert into tab_client values (6594,9675,60,'1970-2-19','f');
insert into tab_client values (6596,9702,33,'1951-11-16','f');
insert into tab_client values (6598,9715,35,'1977-11-30','f');
insert into tab_client values (6599,9717,52,'1952-11-10','f');
insert into tab_client values (6599,9718,52,'1959-2-3','m');
insert into tab_client values (6600,9721,34,'1954-12-5','m');
insert into tab_client values (6605,9755,23,'1951-6-5','f');
insert into tab_client values (6607,9760,27,'1969-2-17','m');
insert into tab_client values (6612,9775,70,'1960-6-23','m');
insert into tab_client values (6612,9776,70,'1961-3-5','f');
insert into tab_client values (6613,9798,69,'1950-3-2','f');
insert into tab_client values (6621,9833,51,'1964-9-21','m');
insert into tab_client values (6621,9834,51,'1960-3-17','f');
insert into tab_client values (6624,9844,55,'1945-8-3','m');
insert into tab_client values (6624,9845,55,'1943-6-15','f');
insert into tab_client values (6625,9846,54,'1967-7-1','f');
insert into tab_client values (6632,9872,9,'1967-3-17','f');
insert into tab_client values (6633,9880,10,'1970-12-10','f');
insert into tab_client values (6641,9914,36,'1942-12-8','m');
insert into tab_client values (6642,9915,27,'1967-7-10','m');
insert into tab_client values (6643,9929,47,'1967-7-19','f');
insert into tab_client values (6644,9930,9,'1972-6-23','m');
insert into tab_client values (6645,9933,74,'1941-10-15','m');
insert into tab_client values (6647,9945,31,'1968-4-14','f');
insert into tab_client values (6647,9946,31,'1960-4-20','m');
insert into tab_client values (6650,9973,24,'1945-10-3','f');
insert into tab_client values (6655,9987,73,'1950-6-19','f');
insert into tab_client values (6659,9995,54,'1958-7-7','m');
insert into tab_client values (6660,9997,67,'1962-6-7','m');
insert into tab_client values (6665,10023,59,'1973-3-20','f');
insert into tab_client values (6667,10040,37,'1968-10-30','f');
insert into tab_client values (6667,10041,37,'1968-4-17','m');
insert into tab_client values (6668,10043,45,'1965-10-29','m');
insert into tab_client values (6675,10075,48,'1964-7-1','m');
insert into tab_client values (6676,10076,26,'1969-12-25','f');
insert into tab_client values (6676,10077,26,'1973-6-27','m');
insert into tab_client values (6677,10090,29,'1980-3-14','f');
insert into tab_client values (6678,10095,1,'1976-2-6','f');
insert into tab_client values (6678,10096,1,'1978-1-5','m');
insert into tab_client values (6682,10159,50,'1938-1-6','m');
insert into tab_client values (6686,10198,31,'1976-5-24','m');
insert into tab_client values (6686,10199,31,'1979-8-13','f');
insert into tab_client values (6687,10200,13,'1980-2-16','f');
insert into tab_client values (6687,10201,13,'1985-10-19','m');
insert into tab_client values (6688,10209,59,'1975-10-27','m');
insert into tab_client values (6694,10269,70,'1940-5-11','f');
insert into tab_client values (6695,10273,51,'1958-9-27','f');
insert into tab_client values (6695,10274,51,'1956-10-11','m');
insert into tab_client values (6696,10275,77,'1970-1-25','f');
insert into tab_client values (6696,10276,77,'1976-11-16','m');
insert into tab_client values (6698,10282,1,'1979-6-19','m');
insert into tab_client values (6699,10287,48,'1962-9-3','f');
insert into tab_client values (6699,10288,48,'1959-6-7','m');
insert into tab_client values (6704,10350,29,'1961-9-14','f');
insert into tab_client values (6704,10351,29,'1958-11-10','m');
insert into tab_client values (6705,10355,14,'1976-7-10','f');
insert into tab_client values (6712,10382,20,'1965-2-17','f');
insert into tab_client values (6715,10389,20,'1943-8-15','f');
insert into tab_client values (6721,10459,17,'1964-8-9','f');
insert into tab_client values (6725,10475,51,'1948-8-28','f');
insert into tab_client values (6725,10476,51,'1950-12-4','m');
insert into tab_client values (6726,10479,2,'1955-10-20','f');
insert into tab_client values (6727,10492,70,'1937-11-11','m');
insert into tab_client values (6729,10510,23,'1945-1-26','f');
insert into tab_client values (6729,10511,23,'1950-1-15','m');
insert into tab_client values (6730,10517,54,'1980-9-12','f');
insert into tab_client values (6732,10528,47,'1952-2-16','f');
insert into tab_client values (6734,10543,14,'1945-2-23','f');
insert into tab_client values (6736,10555,1,'1935-12-15','m');
insert into tab_client values (6737,10563,68,'1949-1-7','m');
insert into tab_client values (6737,10564,68,'1954-3-19','f');
insert into tab_client values (6738,10566,74,'1942-11-9','f');
insert into tab_client values (6745,10636,64,'1971-8-3','m');
insert into tab_client values (6746,10654,46,'1962-7-16','f');
insert into tab_client values (6748,10662,60,'1949-8-25','f');
insert into tab_client values (6751,10702,17,'1938-5-3','m');
insert into tab_client values (6751,10703,17,'1943-4-28','f');
insert into tab_client values (6753,10714,66,'1946-3-31','f');
insert into tab_client values (6755,10746,53,'1971-8-4','m');
insert into tab_client values (6758,10777,70,'1980-1-27','f');
insert into tab_client values (6758,10778,70,'1976-3-19','m');
insert into tab_client values (6763,10813,1,'1979-5-13','f');
insert into tab_client values (6764,10818,64,'1972-8-4','m');
insert into tab_client values (6766,10828,1,'1957-11-23','f');
insert into tab_client values (6785,10963,1,'1944-6-15','m');
insert into tab_client values (6790,10987,62,'1961-10-3','f');
insert into tab_client values (6790,10988,62,'1964-6-13','m');
insert into tab_client values (6791,10997,1,'1972-2-6','f');
insert into tab_client values (6791,10998,1,'1967-12-19','m');
insert into tab_client values (6793,11004,63,'1947-11-16','m');
insert into tab_client values (6805,11050,70,'1957-5-4','f');
insert into tab_client values (6808,11063,64,'1955-11-4','f');
insert into tab_client values (6808,11064,64,'1953-7-9','m');
insert into tab_client values (6810,11093,40,'1959-1-29','m');
insert into tab_client values (6816,11105,70,'1957-2-1','f');
insert into tab_client values (6817,11114,1,'1952-7-26','m');
insert into tab_client values (6818,11121,72,'1971-4-10','f');
insert into tab_client values (6818,11122,72,'1979-6-10','m');
insert into tab_client values (6819,11123,47,'1948-1-29','m');
insert into tab_client values (6820,11126,1,'1965-1-22','f');
insert into tab_client values (6821,11130,1,'1961-4-8','f');
insert into tab_client values (6821,11131,1,'1957-7-26','m');
insert into tab_client values (6824,11149,43,'1965-7-14','m');
insert into tab_client values (6836,11195,58,'1953-12-5','m');
insert into tab_client values (6841,11208,10,'1957-3-5','f');
insert into tab_client values (6851,11250,26,'1946-9-23','f');
insert into tab_client values (6852,11252,32,'1965-12-8','f');
insert into tab_client values (6855,11266,9,'1938-9-25','m');
insert into tab_client values (6855,11267,9,'1936-8-26','f');
insert into tab_client values (6856,11271,18,'1937-12-8','m');
insert into tab_client values (6857,11274,64,'1969-4-14','m');
insert into tab_client values (6857,11275,64,'1963-4-18','f');
insert into tab_client values (6859,11286,56,'1940-11-27','f');
insert into tab_client values (6861,11304,28,'1960-10-20','f');
insert into tab_client values (6863,11314,45,'1936-6-2','m');
insert into tab_client values (6865,11327,72,'1947-10-21','m');
insert into tab_client values (6866,11329,69,'1961-1-31','f');
insert into tab_client values (6868,11337,29,'1969-4-3','m');
insert into tab_client values (6871,11359,11,'1972-8-20','m');
insert into tab_client values (6871,11360,11,'1972-4-19','f');
insert into tab_client values (6872,11362,51,'1966-1-11','f');
insert into tab_client values (6875,11371,37,'1941-11-4','f');
insert into tab_client values (6876,11372,11,'1961-9-28','m');
insert into tab_client values (6877,11379,74,'1952-5-28','m');
insert into tab_client values (6877,11380,74,'1951-4-6','f');
insert into tab_client values (6878,11381,57,'1979-7-26','f');
insert into tab_client values (6887,11405,68,'1964-7-29','f');
insert into tab_client values (6887,11406,68,'1970-11-15','m');
insert into tab_client values (6888,11409,32,'1980-5-2','f');
insert into tab_client values (6895,11461,70,'1974-7-8','m');
insert into tab_client values (6903,11497,11,'1959-7-17','f');
insert into tab_client values (6908,11516,59,'1938-11-9','m');
insert into tab_client values (6908,11517,59,'1940-5-21','f');
insert into tab_client values (6913,11545,1,'1966-1-22','f');
insert into tab_client values (6919,11574,1,'1944-4-20','f');
insert into tab_client values (6921,11596,70,'1940-12-4','f');
insert into tab_client values (6922,11598,54,'1977-9-23','f');
insert into tab_client values (6923,11609,59,'1957-2-11','m');
insert into tab_client values (6926,11637,73,'1951-6-12','m');
insert into tab_client values (6926,11638,73,'1954-8-24','f');
insert into tab_client values (6929,11662,76,'1972-4-3','m');
insert into tab_client values (6932,11683,7,'1980-1-28','m');
insert into tab_client values (6933,11685,64,'1965-7-23','f');
insert into tab_client values (6934,11686,21,'1948-10-18','f');
insert into tab_client values (6934,11687,21,'1945-1-23','m');
insert into tab_client values (6938,11701,9,'1949-4-14','m');
insert into tab_client values (6940,11709,1,'1961-8-3','m');
insert into tab_client values (6940,11710,1,'1967-6-19','f');
insert into tab_client values (6942,11713,59,'1951-4-11','f');
insert into tab_client values (6942,11714,59,'1945-7-4','m');
insert into tab_client values (6944,11754,62,'1966-11-3','m');
insert into tab_client values (6948,11768,1,'1971-9-12','f');
insert into tab_client values (6949,11794,31,'1970-10-7','f');
insert into tab_client values (6949,11795,31,'1977-2-23','m');
insert into tab_client values (6950,11804,74,'1944-12-12','m');
insert into tab_client values (6955,11851,65,'1970-4-2','m');
insert into tab_client values (6956,11855,11,'1957-12-1','m');
insert into tab_client values (6959,11857,70,'1952-8-26','m');
insert into tab_client values (6960,11866,1,'1937-9-2','m');
insert into tab_client values (6960,11867,1,'1934-11-19','f');
insert into tab_client values (6961,11873,38,'1963-11-20','f');
insert into tab_client values (6962,11874,1,'1969-1-19','m');
insert into tab_client values (6962,11875,1,'1967-6-23','f');
insert into tab_client values (6965,11886,61,'1941-9-13','f');
insert into tab_client values (6969,11906,76,'1944-12-3','m');
insert into tab_client values (6969,11907,76,'1945-11-16','f');
insert into tab_client values (6970,11911,8,'1939-10-24','m');
insert into tab_client values (6984,11976,54,'1939-10-27','f');
insert into tab_client values (6984,11977,54,'1944-7-1','m');
insert into tab_client values (6985,11978,54,'1971-10-9','m');
insert into tab_client values (6985,11979,54,'1977-12-9','f');
insert into tab_client values (6986,12003,74,'1976-6-23','m');
insert into tab_client values (6992,12050,52,'1943-5-30','m');
insert into tab_client values (6992,12051,52,'1936-9-30','f');
insert into tab_client values (6995,12079,64,'1972-8-12','f');
insert into tab_client values (6996,12095,47,'1939-2-27','m');
insert into tab_client values (6998,12102,21,'1968-9-7','f');
insert into tab_client values (7001,12133,27,'1964-6-26','f');
insert into tab_client values (7004,12144,2,'1980-11-23','m');
insert into tab_client values (7004,12145,2,'1982-6-25','f');
insert into tab_client values (7008,12181,1,'1961-8-19','m');
insert into tab_client values (7013,12220,60,'1971-11-12','f');
insert into tab_client values (7013,12221,60,'1971-2-24','m');
insert into tab_client values (7034,12303,24,'1974-4-5','f');
insert into tab_client values (7035,12308,64,'1978-11-29','m');
insert into tab_client values (7036,12325,8,'1964-10-30','m');
insert into tab_client values (7037,12328,1,'1944-4-8','f');
insert into tab_client values (7046,12358,17,'1943-7-5','m');
insert into tab_client values (7046,12359,17,'1935-10-13','f');
insert into tab_client values (7049,12376,4,'1959-2-17','m');
insert into tab_client values (7050,12378,76,'1946-8-27','f');
insert into tab_client values (7051,12382,1,'1955-11-29','m');
insert into tab_client values (7051,12383,1,'1963-5-13','f');
insert into tab_client values (7055,12396,62,'1970-1-17','f');
insert into tab_client values (7055,12397,62,'1973-6-2','m');
insert into tab_client values (7057,12416,1,'1973-5-30','m');
insert into tab_client values (7057,12417,1,'1974-1-3','f');
insert into tab_client values (7061,12432,55,'1965-3-7','m');
insert into tab_client values (7066,12464,39,'1959-12-17','m');
insert into tab_client values (7067,12468,22,'1969-7-4','m');
insert into tab_client values (7072,12485,34,'1965-4-10','f');
insert into tab_client values (7085,12547,70,'1963-10-13','f');
insert into tab_client values (7087,12561,38,'1966-6-20','m');
insert into tab_client values (7088,12586,27,'1947-1-30','m');
insert into tab_client values (7091,12599,44,'1956-1-1','m');
insert into tab_client values (7096,12616,27,'1965-1-26','f');
insert into tab_client values (7097,12625,54,'1958-12-7','m');
insert into tab_client values (7100,12643,69,'1962-7-20','f');
insert into tab_client values (7101,12662,14,'1953-6-1','m');
insert into tab_client values (7104,12695,68,'1979-3-16','m');
insert into tab_client values (7110,12729,36,'1968-3-21','m');
insert into tab_client values (7110,12730,36,'1964-9-29','f');
insert into tab_client values (7115,12738,23,'1960-10-29','f');
insert into tab_client values (7115,12739,23,'1958-1-17','m');
insert into tab_client values (7119,12750,21,'1940-5-25','f');
insert into tab_client values (7121,12754,55,'1960-8-20','m');
insert into tab_client values (7121,12755,55,'1959-11-1','f');
insert into tab_client values (7122,12756,22,'1949-1-21','f');
insert into tab_client values (7129,12802,1,'1969-8-12','m');
insert into tab_client values (7130,12810,39,'1964-10-14','m');
insert into tab_client values (7136,12840,60,'1939-7-27','m');
insert into tab_client values (7137,12843,66,'1953-5-5','m');
insert into tab_client values (7138,12844,45,'1946-10-15','m');
insert into tab_client values (7139,12850,72,'1955-8-26','m');
insert into tab_client values (7139,12851,72,'1957-9-27','f');
insert into tab_client values (7142,12859,1,'1976-5-21','f');
insert into tab_client values (7147,12890,70,'1958-1-20','f');
insert into tab_client values (7151,12908,12,'1941-3-12','m');
insert into tab_client values (7154,12943,55,'1970-10-12','m');
insert into tab_client values (7164,13051,55,'1965-1-13','m');
insert into tab_client values (7166,13071,41,'1956-2-18','m');
insert into tab_client values (7167,13089,16,'1979-2-14','f');
insert into tab_client values (7168,13090,2,'1980-4-18','f');
insert into tab_client values (7171,13095,76,'1950-3-16','m');
insert into tab_client values (7172,13098,1,'1978-12-15','f');
insert into tab_client values (7176,13113,11,'1976-11-25','m');
insert into tab_client values (7181,13134,1,'1962-11-3','f');
insert into tab_client values (7187,13172,36,'1938-10-19','m');
insert into tab_client values (7189,13190,71,'1956-11-28','m');
insert into tab_client values (7192,13201,31,'1937-5-17','m');
insert into tab_client values (7194,13231,1,'1959-7-1','m');
insert into tab_client values (7195,13246,46,'1942-1-13','f');
insert into tab_client values (7198,13260,72,'1977-5-27','f');
insert into tab_client values (7199,13261,75,'1944-8-1','m');
insert into tab_client values (7199,13262,75,'1938-2-9','f');
insert into tab_client values (7200,13276,76,'1977-1-20','m');
insert into tab_client values (7201,13285,34,'1935-12-25','m');
insert into tab_client values (7202,13290,16,'1941-6-23','m');
insert into tab_client values (7202,13291,16,'1940-11-13','f');
insert into tab_client values (7209,13346,50,'1956-4-15','m');
insert into tab_client values (7213,13380,65,'1942-9-18','m');
insert into tab_client values (7219,13405,32,'1958-8-13','m');
insert into tab_client values (7220,13412,1,'1954-3-20','m');
insert into tab_client values (7221,13417,25,'1951-11-17','f');
insert into tab_client values (7226,13447,13,'1970-5-5','f');
insert into tab_client values (7226,13448,13,'1968-7-8','m');
insert into tab_client values (7227,13451,44,'1955-11-18','f');
insert into tab_client values (7230,13468,25,'1960-10-31','m');
insert into tab_client values (7230,13469,25,'1955-12-8','f');
insert into tab_client values (7233,13480,16,'1953-6-1','m');
insert into tab_client values (7235,13490,18,'1969-5-25','f');
insert into tab_client values (7240,13539,63,'1978-9-7','m');
insert into tab_client values (7241,13548,1,'1976-3-18','m');
insert into tab_client values (7242,13556,32,'1958-7-19','m');
insert into tab_client values (7243,13576,72,'1974-7-7','m');
insert into tab_client values (7246,13590,59,'1977-8-3','m');
insert into tab_client values (7249,13603,46,'1941-7-28','m');
insert into tab_client values (7250,13608,37,'1963-5-15','f');
insert into tab_client values (7253,13620,16,'1970-7-26','m');
insert into tab_client values (7255,13640,28,'1955-6-9','f');
insert into tab_client values (7259,13657,59,'1963-5-12','f');
insert into tab_client values (7259,13658,59,'1957-4-23','m');
insert into tab_client values (7262,13687,75,'1959-5-23','m');
insert into tab_client values (7263,13690,70,'1963-5-16','m');
insert into tab_client values (7264,13694,1,'1976-1-20','f');
insert into tab_client values (7271,13750,12,'1980-11-13','f');
insert into tab_client values (7271,13751,12,'1979-7-20','m');
insert into tab_client values (7277,13803,1,'1947-11-14','m');
insert into tab_client values (7279,13820,33,'1948-7-31','f');
insert into tab_client values (7284,13845,15,'1973-2-16','m');
insert into tab_client values (7286,13852,5,'1972-1-26','m');
insert into tab_client values (7292,13912,50,'1975-11-20','m');
insert into tab_client values (7294,13923,7,'1979-2-22','f');
insert into tab_client values (7295,13924,54,'1952-9-9','f');
insert into tab_client values (7304,13955,1,'1945-10-30','f');
insert into tab_client values (7304,13956,1,'1943-4-6','m');
insert into tab_client values (7305,13968,61,'1968-4-13','m');
insert into tab_client values (7308,13971,67,'1962-10-19','f');
insert into tab_disp values (4959,2,2,2,'OWNER');
insert into tab_disp values (4959,3,2,3,'DISPONENT');
insert into tab_disp values (4961,25,19,25,'OWNER');
insert into tab_disp values (4962,31,25,31,'OWNER');
insert into tab_disp values (4967,45,37,45,'OWNER');
insert into tab_disp values (4968,46,38,46,'OWNER');
insert into tab_disp values (4973,78,67,78,'OWNER');
insert into tab_disp values (4986,116,97,116,'OWNER');
insert into tab_disp values (4986,117,97,117,'DISPONENT');
insert into tab_disp values (4988,124,103,124,'OWNER');
insert into tab_disp values (4989,127,105,127,'OWNER');
insert into tab_disp values (4990,132,110,132,'OWNER');
insert into tab_disp values (4996,158,132,158,'OWNER');
insert into tab_disp values (4996,159,132,159,'DISPONENT');
insert into tab_disp values (5002,210,173,210,'OWNER');
insert into tab_disp values (5002,211,173,211,'DISPONENT');
insert into tab_disp values (5005,215,176,215,'OWNER');
insert into tab_disp values (5015,272,226,272,'OWNER');
insert into tab_disp values (5027,333,276,333,'OWNER');
insert into tab_disp values (5032,352,290,352,'OWNER');
insert into tab_disp values (5034,370,303,370,'OWNER');
insert into tab_disp values (5036,376,309,376,'OWNER');
insert into tab_disp values (5039,383,314,383,'OWNER');
insert into tab_disp values (5039,384,314,384,'DISPONENT');
insert into tab_disp values (5041,389,319,389,'OWNER');
insert into tab_disp values (5042,403,330,403,'OWNER');
insert into tab_disp values (5042,404,330,404,'DISPONENT');
insert into tab_disp values (5043,414,339,414,'OWNER');
insert into tab_disp values (5043,415,339,415,'DISPONENT');
insert into tab_disp values (5044,421,344,421,'OWNER');
insert into tab_disp values (5045,424,347,424,'OWNER');
insert into tab_disp values (5046,426,349,426,'OWNER');
insert into tab_disp values (5046,427,349,427,'DISPONENT');
insert into tab_disp values (5051,458,378,458,'OWNER');
insert into tab_disp values (5060,512,426,512,'OWNER');
insert into tab_disp values (5061,530,440,530,'OWNER');
insert into tab_disp values (5063,533,442,533,'OWNER');
insert into tab_disp values (5072,568,472,568,'OWNER');
insert into tab_disp values (5082,603,501,603,'OWNER');
insert into tab_disp values (5086,631,525,631,'OWNER');
insert into tab_disp values (5088,655,544,655,'OWNER');
insert into tab_disp values (5103,798,666,798,'OWNER');
insert into tab_disp values (5103,799,666,799,'DISPONENT');
insert into tab_disp values (5110,810,675,810,'OWNER');
insert into tab_disp values (5110,811,675,811,'DISPONENT');
insert into tab_disp values (5117,861,718,861,'OWNER');
insert into tab_disp values (5124,939,785,939,'OWNER');
insert into tab_disp values (5125,944,789,944,'OWNER');
insert into tab_disp values (5125,945,789,945,'DISPONENT');
insert into tab_disp values (5126,946,790,946,'OWNER');
insert into tab_disp values (5128,968,808,968,'OWNER');
insert into tab_disp values (5130,976,813,976,'OWNER');
insert into tab_disp values (5131,980,816,980,'OWNER');
insert into tab_disp values (5132,981,817,981,'OWNER');
insert into tab_disp values (5134,992,825,992,'OWNER');
insert into tab_disp values (5136,1020,846,1020,'OWNER');
insert into tab_disp values (5138,1029,854,1029,'OWNER');
insert into tab_disp values (5140,1051,873,1051,'OWNER');
insert into tab_disp values (5145,1102,915,1102,'OWNER');
insert into tab_disp values (5147,1130,938,1130,'OWNER');
insert into tab_disp values (5148,1133,940,1133,'OWNER');
insert into tab_disp values (5148,1134,940,1134,'DISPONENT');
insert into tab_disp values (5151,1157,960,1157,'OWNER');
insert into tab_disp values (5154,1197,993,1197,'OWNER');
insert into tab_disp values (5158,1208,1004,1208,'OWNER');
insert into tab_disp values (5160,1215,1011,1215,'OWNER');
insert into tab_disp values (5161,1216,1012,1216,'OWNER');
insert into tab_disp values (5169,1282,1068,1282,'OWNER');
insert into tab_disp values (5170,1286,1071,1286,'OWNER');
insert into tab_disp values (5172,1300,1083,1300,'OWNER');
insert into tab_disp values (5174,1311,1093,1311,'OWNER');
insert into tab_disp values (5176,1327,1106,1327,'OWNER');
insert into tab_disp values (5189,1404,1166,1404,'OWNER');
insert into tab_disp values (5206,1499,1242,1499,'OWNER');
insert into tab_disp values (5207,1501,1244,1501,'OWNER');
insert into tab_disp values (5208,1505,1247,1505,'OWNER');
insert into tab_disp values (5209,1509,1250,1509,'OWNER');
insert into tab_disp values (5210,1511,1252,1511,'OWNER');
insert into tab_disp values (5212,1516,1256,1516,'OWNER');
insert into tab_disp values (5214,1533,1270,1533,'OWNER');
insert into tab_disp values (5221,1554,1284,1554,'OWNER');
insert into tab_disp values (5226,1594,1318,1594,'OWNER');
insert into tab_disp values (5229,1608,1329,1608,'OWNER');
insert into tab_disp values (5229,1609,1329,1609,'DISPONENT');
insert into tab_disp values (5236,1662,1374,1662,'OWNER');
insert into tab_disp values (5237,1663,1375,1663,'OWNER');
insert into tab_disp values (5241,1681,1389,1681,'OWNER');
insert into tab_disp values (5245,1705,1407,1705,'OWNER');
insert into tab_disp values (5245,1706,1407,1706,'DISPONENT');
insert into tab_disp values (5253,1755,1447,1755,'OWNER');
insert into tab_disp values (5260,1793,1480,1793,'OWNER');
insert into tab_disp values (5265,1816,1498,1816,'OWNER');
insert into tab_disp values (5269,1851,1527,1851,'OWNER');
insert into tab_disp values (5270,1852,1528,1852,'OWNER');
insert into tab_disp values (5281,1913,1580,1913,'OWNER');
insert into tab_disp values (5282,1917,1583,1917,'OWNER');
insert into tab_disp values (5285,1944,1603,1944,'OWNER');
insert into tab_disp values (5287,1985,1638,1985,'OWNER');
insert into tab_disp values (5287,1986,1638,1986,'DISPONENT');
insert into tab_disp values (5293,2008,1656,2008,'OWNER');
insert into tab_disp values (5301,2063,1698,2063,'OWNER');
insert into tab_disp values (5304,2083,1718,2083,'OWNER');
insert into tab_disp values (5310,2136,1762,2136,'OWNER');
insert into tab_disp values (5311,2141,1766,2141,'OWNER');
insert into tab_disp values (5312,2148,1772,2148,'OWNER');
insert into tab_disp values (5313,2153,1776,2153,'OWNER');
insert into tab_disp values (5314,2166,1787,2166,'OWNER');
insert into tab_disp values (5316,2181,1801,2181,'OWNER');
insert into tab_disp values (5318,2190,1808,2190,'OWNER');
insert into tab_disp values (5318,2191,1808,2191,'DISPONENT');
insert into tab_disp values (5319,2195,1811,2195,'OWNER');
insert into tab_disp values (5320,2205,1819,2205,'OWNER');
insert into tab_disp values (5325,2235,1843,2235,'OWNER');
insert into tab_disp values (5329,2259,1862,2259,'OWNER');
insert into tab_disp values (5332,2267,1869,2267,'OWNER');
insert into tab_disp values (5334,2277,1876,2277,'OWNER');
insert into tab_disp values (5337,2288,1886,2288,'OWNER');
insert into tab_disp values (5337,2289,1886,2289,'DISPONENT');
insert into tab_disp values (5338,2291,1888,2291,'OWNER');
insert into tab_disp values (5343,2316,1906,2316,'OWNER');
insert into tab_disp values (5346,2342,1928,2342,'OWNER');
insert into tab_disp values (5350,2392,1967,2392,'OWNER');
insert into tab_disp values (5351,2403,1978,2403,'OWNER');
insert into tab_disp values (5352,2422,1993,2422,'OWNER');
insert into tab_disp values (5354,2430,2000,2430,'OWNER');
insert into tab_disp values (5358,2451,2018,2451,'OWNER');
insert into tab_disp values (5360,2470,2035,2470,'OWNER');
insert into tab_disp values (5360,2471,2035,2471,'DISPONENT');
insert into tab_disp values (5363,2489,2051,2489,'OWNER');
insert into tab_disp values (5365,2494,2055,2494,'OWNER');
insert into tab_disp values (5366,2501,2062,2501,'OWNER');
insert into tab_disp values (5367,2503,2064,2503,'OWNER');
insert into tab_disp values (5368,2514,2073,2514,'OWNER');
insert into tab_disp values (5369,2522,2080,2522,'OWNER');
insert into tab_disp values (5369,2523,2080,2523,'DISPONENT');
insert into tab_disp values (5375,2550,2106,2550,'OWNER');
insert into tab_disp values (5377,2560,2116,2560,'OWNER');
insert into tab_disp values (5382,2581,2134,2581,'OWNER');
insert into tab_disp values (5384,2590,2142,2590,'OWNER');
insert into tab_disp values (5384,2591,2142,2591,'DISPONENT');
insert into tab_disp values (5385,2592,2143,2592,'OWNER');
insert into tab_disp values (5385,2593,2143,2593,'DISPONENT');
insert into tab_disp values (5388,2606,2153,2606,'OWNER');
insert into tab_disp values (5389,2621,2165,2621,'OWNER');
insert into tab_disp values (5390,2623,2167,2623,'OWNER');
insert into tab_disp values (5395,2635,2176,2635,'OWNER');
insert into tab_disp values (5398,2647,2187,2647,'OWNER');
insert into tab_disp values (5398,2648,2187,2648,'DISPONENT');
insert into tab_disp values (5409,2686,2218,2686,'OWNER');
insert into tab_disp values (5409,2687,2218,2687,'DISPONENT');
insert into tab_disp values (5413,2698,2227,2698,'OWNER');
insert into tab_disp values (5413,2699,2227,2699,'DISPONENT');
insert into tab_disp values (5414,2700,2228,2700,'OWNER');
insert into tab_disp values (5415,2708,2236,2708,'OWNER');
insert into tab_disp values (5418,2719,2245,2719,'OWNER');
insert into tab_disp values (5419,2720,2246,2720,'OWNER');
insert into tab_disp values (5420,2721,2247,2721,'OWNER');
insert into tab_disp values (5428,2739,2262,2739,'OWNER');
insert into tab_disp values (5429,2746,2268,2746,'OWNER');
insert into tab_disp values (5435,2759,2279,2759,'OWNER');
insert into tab_disp values (5445,2809,2322,2809,'OWNER');
insert into tab_disp values (5446,2822,2334,2822,'OWNER');
insert into tab_disp values (5447,2823,2335,2823,'OWNER');
insert into tab_disp values (5449,2831,2343,2831,'OWNER');
insert into tab_disp values (5450,2834,2345,2834,'OWNER');
insert into tab_disp values (5451,2841,2350,2841,'OWNER');
insert into tab_disp values (5452,2843,2352,2843,'OWNER');
insert into tab_disp values (5453,2853,2361,2853,'OWNER');
insert into tab_disp values (5463,2915,2413,2915,'OWNER');
insert into tab_disp values (5464,2922,2419,2922,'OWNER');
insert into tab_disp values (5469,2952,2445,2952,'OWNER');
insert into tab_disp values (5470,2966,2456,2966,'OWNER');
insert into tab_disp values (5479,3001,2486,3001,'OWNER');
insert into tab_disp values (5482,3013,2496,3013,'OWNER');
insert into tab_disp values (5482,3014,2496,3014,'DISPONENT');
insert into tab_disp values (5486,3038,2516,3038,'OWNER');
insert into tab_disp values (5491,3072,2545,3072,'OWNER');
insert into tab_disp values (5491,3073,2545,3073,'DISPONENT');
insert into tab_disp values (5494,3103,2572,3103,'OWNER');
insert into tab_disp values (5495,3113,2580,3113,'OWNER');
insert into tab_disp values (5495,3114,2580,3114,'DISPONENT');
insert into tab_disp values (5501,3163,2622,3163,'OWNER');
insert into tab_disp values (5501,3164,2622,3164,'DISPONENT');
insert into tab_disp values (5519,3251,2694,3251,'OWNER');
insert into tab_disp values (5519,3252,2694,3252,'DISPONENT');
insert into tab_disp values (5520,3257,2699,3257,'OWNER');
insert into tab_disp values (5523,3264,2705,3264,'OWNER');
insert into tab_disp values (5525,3284,2720,3284,'OWNER');
insert into tab_disp values (5525,3285,2720,3285,'DISPONENT');
insert into tab_disp values (5526,3291,2725,3291,'OWNER');
insert into tab_disp values (5527,3294,2728,3294,'OWNER');
insert into tab_disp values (5531,3324,2753,3324,'OWNER');
insert into tab_disp values (5531,3325,2753,3325,'DISPONENT');
insert into tab_disp values (5532,3326,2754,3326,'OWNER');
insert into tab_disp values (5533,3335,2762,3335,'OWNER');
insert into tab_disp values (5549,3414,2824,3414,'OWNER');
insert into tab_disp values (5556,3471,2872,3471,'OWNER');
insert into tab_disp values (5561,3517,2910,3517,'OWNER');
insert into tab_disp values (5563,3519,2912,3519,'OWNER');
insert into tab_disp values (5568,3542,2933,3542,'OWNER');
insert into tab_disp values (5568,3543,2933,3543,'DISPONENT');
insert into tab_disp values (5569,3546,2936,3546,'OWNER');
insert into tab_disp values (5576,3576,2962,3576,'OWNER');
insert into tab_disp values (5582,3601,2982,3601,'OWNER');
insert into tab_disp values (5582,3602,2982,3602,'DISPONENT');
insert into tab_disp values (5584,3606,2986,3606,'OWNER');
insert into tab_disp values (5585,3608,2988,3608,'OWNER');
insert into tab_disp values (5585,3609,2988,3609,'DISPONENT');
insert into tab_disp values (5586,3616,2994,3616,'OWNER');
insert into tab_disp values (5589,3629,3005,3629,'OWNER');
insert into tab_disp values (5591,3649,3021,3649,'OWNER');
insert into tab_disp values (5593,3670,3037,3670,'OWNER');
insert into tab_disp values (5595,3687,3050,3687,'OWNER');
insert into tab_disp values (5595,3688,3050,3688,'DISPONENT');
insert into tab_disp values (5599,3705,3064,3705,'OWNER');
insert into tab_disp values (5606,3730,3084,3730,'OWNER');
insert into tab_disp values (5610,3763,3112,3763,'OWNER');
insert into tab_disp values (5610,3764,3112,3764,'DISPONENT');
insert into tab_disp values (5611,3767,3115,3767,'OWNER');
insert into tab_disp values (5611,3768,3115,3768,'DISPONENT');
insert into tab_disp values (5614,3793,3137,3793,'OWNER');
insert into tab_disp values (5616,3800,3143,3800,'OWNER');
insert into tab_disp values (5616,3801,3143,3801,'DISPONENT');
insert into tab_disp values (5620,3822,3161,3822,'OWNER');
insert into tab_disp values (5624,3829,3166,3829,'OWNER');
insert into tab_disp values (5625,3855,3189,3855,'OWNER');
insert into tab_disp values (5634,3906,3229,3906,'OWNER');
insert into tab_disp values (5635,3907,3230,3907,'OWNER');
insert into tab_disp values (5638,3929,3249,3929,'OWNER');
insert into tab_disp values (5643,3962,3273,3962,'OWNER');
insert into tab_disp values (5644,3984,3293,3984,'OWNER');
insert into tab_disp values (5651,4024,3329,4024,'OWNER');
insert into tab_disp values (5651,4025,3329,4025,'DISPONENT');
insert into tab_disp values (5656,4055,3353,4055,'OWNER');
insert into tab_disp values (5657,4056,3354,4056,'OWNER');
insert into tab_disp values (5665,4099,3390,4099,'OWNER');
insert into tab_disp values (5669,4114,3403,4114,'OWNER');
insert into tab_disp values (5674,4132,3418,4132,'OWNER');
insert into tab_disp values (5674,4133,3418,4133,'DISPONENT');
insert into tab_disp values (5681,4169,3448,4169,'OWNER');
insert into tab_disp values (5681,4170,3448,4170,'DISPONENT');
insert into tab_disp values (5682,4177,3455,4177,'OWNER');
insert into tab_disp values (5683,4182,3460,4182,'OWNER');
insert into tab_disp values (5683,4183,3460,4183,'DISPONENT');
insert into tab_disp values (5693,4217,3489,4217,'OWNER');
insert into tab_disp values (5698,4291,3556,4291,'OWNER');
insert into tab_disp values (5699,4299,3562,4299,'OWNER');
insert into tab_disp values (5706,4352,3608,4352,'OWNER');
insert into tab_disp values (5713,4377,3629,4377,'OWNER');
insert into tab_disp values (5718,4386,3637,4386,'OWNER');
insert into tab_disp values (5719,4417,3664,4417,'OWNER');
insert into tab_disp values (5723,4428,3674,4428,'OWNER');
insert into tab_disp values (5724,4433,3678,4433,'OWNER');
insert into tab_disp values (5725,4434,3679,4434,'OWNER');
insert into tab_disp values (5725,4435,3679,4435,'DISPONENT');
insert into tab_disp values (5731,4474,3711,4474,'OWNER');
insert into tab_disp values (5739,4520,3747,4520,'OWNER');
insert into tab_disp values (5740,4527,3752,4527,'OWNER');
insert into tab_disp values (5741,4529,3754,4529,'OWNER');
insert into tab_disp values (5741,4530,3754,4530,'DISPONENT');
insert into tab_disp values (5750,4584,3804,4584,'OWNER');
insert into tab_disp values (5754,4620,3834,4620,'OWNER');
insert into tab_disp values (5754,4621,3834,4621,'DISPONENT');
insert into tab_disp values (5758,4652,3859,4652,'OWNER');
insert into tab_disp values (5760,4656,3862,4656,'OWNER');
insert into tab_disp values (5765,4672,3875,4672,'OWNER');
insert into tab_disp values (5772,4710,3906,4710,'OWNER');
insert into tab_disp values (5772,4711,3906,4711,'DISPONENT');
insert into tab_disp values (5773,4712,3907,4712,'OWNER');
insert into tab_disp values (5774,4722,3916,4722,'OWNER');
insert into tab_disp values (5779,4754,3942,4754,'OWNER');
insert into tab_disp values (5782,4768,3953,4768,'OWNER');
insert into tab_disp values (5784,4786,3967,4786,'OWNER');
insert into tab_disp values (5790,4861,4033,4861,'OWNER');
insert into tab_disp values (5799,4882,4052,4882,'OWNER');
insert into tab_disp values (5804,4916,4079,4916,'OWNER');
insert into tab_disp values (5805,4918,4081,4918,'OWNER');
insert into tab_disp values (5808,4937,4099,4937,'OWNER');
insert into tab_disp values (5815,4956,4116,4956,'OWNER');
insert into tab_disp values (5817,4968,4127,4968,'OWNER');
insert into tab_disp values (5823,4993,4144,4993,'OWNER');
insert into tab_disp values (5823,4994,4144,4994,'DISPONENT');
insert into tab_disp values (5830,5050,4190,5050,'OWNER');
insert into tab_disp values (5836,5133,4259,5133,'OWNER');
insert into tab_disp values (5837,5134,4260,5134,'OWNER');
insert into tab_disp values (5841,5143,4268,5143,'OWNER');
insert into tab_disp values (5841,5144,4268,5144,'DISPONENT');
insert into tab_disp values (5850,5171,4293,5171,'OWNER');
insert into tab_disp values (5856,5203,4320,5203,'OWNER');
insert into tab_disp values (5861,5224,4337,5224,'OWNER');
insert into tab_disp values (5862,5232,4342,5232,'OWNER');
insert into tab_disp values (5865,5245,4354,5245,'OWNER');
insert into tab_disp values (5868,5253,4361,5253,'OWNER');
insert into tab_disp values (5868,5254,4361,5254,'DISPONENT');
insert into tab_disp values (5876,5318,4413,5318,'OWNER');
insert into tab_disp values (5876,5319,4413,5319,'DISPONENT');
insert into tab_disp values (5877,5320,4414,5320,'OWNER');
insert into tab_disp values (5877,5321,4414,5321,'DISPONENT');
insert into tab_disp values (5878,5322,4415,5322,'OWNER');
insert into tab_disp values (5880,5333,4423,5333,'OWNER');
insert into tab_disp values (5882,5337,4427,5337,'OWNER');
insert into tab_disp values (5882,5338,4427,5338,'DISPONENT');
insert into tab_disp values (5886,5364,4447,5364,'OWNER');
insert into tab_disp values (5886,5365,4447,5365,'DISPONENT');
insert into tab_disp values (5887,5366,4448,5366,'OWNER');
insert into tab_disp values (5887,5367,4448,5367,'DISPONENT');
insert into tab_disp values (5889,5376,4456,5376,'OWNER');
insert into tab_disp values (5892,5384,4462,5384,'OWNER');
insert into tab_disp values (5893,5389,4467,5389,'OWNER');
insert into tab_disp values (5895,5395,4473,5395,'OWNER');
insert into tab_disp values (5897,5399,4476,5399,'OWNER');
insert into tab_disp values (5900,5433,4503,5433,'OWNER');
insert into tab_disp values (5906,5468,4533,5468,'OWNER');
insert into tab_disp values (5909,5487,4550,5487,'OWNER');
insert into tab_disp values (5918,5517,4576,5517,'OWNER');
insert into tab_disp values (5922,5521,4580,5521,'OWNER');
insert into tab_disp values (5923,5526,4585,5526,'OWNER');
insert into tab_disp values (5923,5527,4585,5527,'DISPONENT');
insert into tab_disp values (5930,5563,4616,5563,'OWNER');
insert into tab_disp values (5931,5565,4618,5565,'OWNER');
insert into tab_disp values (5932,5574,4626,5574,'OWNER');
insert into tab_disp values (5933,5579,4631,5579,'OWNER');
insert into tab_disp values (5933,5580,4631,5580,'DISPONENT');
insert into tab_disp values (5938,5606,4650,5606,'OWNER');
insert into tab_disp values (5940,5618,4660,5618,'OWNER');
insert into tab_disp values (5942,5642,4681,5642,'OWNER');
insert into tab_disp values (5953,5684,4715,5684,'OWNER');
insert into tab_disp values (5956,5699,4725,5699,'OWNER');
insert into tab_disp values (5959,5701,4727,5701,'OWNER');
insert into tab_disp values (5963,5727,4746,5727,'OWNER');
insert into tab_disp values (5970,5760,4774,5760,'OWNER');
insert into tab_disp values (5970,5761,4774,5761,'DISPONENT');
insert into tab_disp values (5973,5774,4784,5774,'OWNER');
insert into tab_disp values (5973,5775,4784,5775,'DISPONENT');
insert into tab_disp values (5976,5788,4794,5788,'OWNER');
insert into tab_disp values (5977,5801,4803,5801,'OWNER');
insert into tab_disp values (5980,5826,4825,5826,'OWNER');
insert into tab_disp values (5980,5827,4825,5827,'DISPONENT');
insert into tab_disp values (5988,5858,4851,5858,'OWNER');
insert into tab_disp values (5988,5859,4851,5859,'DISPONENT');
insert into tab_disp values (5989,5860,4852,5860,'OWNER');
insert into tab_disp values (5991,5866,4858,5866,'OWNER');
insert into tab_disp values (5992,5873,4863,5873,'OWNER');
insert into tab_disp values (5997,5911,4894,5911,'OWNER');
insert into tab_disp values (5999,5928,4907,5928,'OWNER');
insert into tab_disp values (6004,5965,4937,5965,'OWNER');
insert into tab_disp values (6006,5977,4948,5977,'OWNER');
insert into tab_disp values (6007,5978,4949,5978,'OWNER');
insert into tab_disp values (6010,6001,4969,6001,'OWNER');
insert into tab_disp values (6011,6015,4981,6015,'OWNER');
insert into tab_disp values (6012,6033,4994,6033,'OWNER');
insert into tab_disp values (6013,6034,4995,6034,'OWNER');
insert into tab_disp values (6014,6039,4999,6039,'OWNER');
insert into tab_disp values (6014,6040,4999,6040,'DISPONENT');
insert into tab_disp values (6015,6042,5001,6042,'OWNER');
insert into tab_disp values (6019,6077,5033,6077,'OWNER');
insert into tab_disp values (6027,6115,5066,6115,'OWNER');
insert into tab_disp values (6028,6122,5072,6122,'OWNER');
insert into tab_disp values (6037,6175,5118,6175,'OWNER');
insert into tab_disp values (6038,6178,5120,6178,'OWNER');
insert into tab_disp values (6043,6185,5126,6185,'OWNER');
insert into tab_disp values (6043,6186,5126,6186,'DISPONENT');
insert into tab_disp values (6044,6196,5133,6196,'OWNER');
insert into tab_disp values (6052,6235,5164,6235,'OWNER');
insert into tab_disp values (6054,6255,5180,6255,'OWNER');
insert into tab_disp values (6054,6256,5180,6256,'DISPONENT');
insert into tab_disp values (6055,6257,5181,6257,'OWNER');
insert into tab_disp values (6059,6275,5196,6275,'OWNER');
insert into tab_disp values (6063,6299,5213,6299,'OWNER');
insert into tab_disp values (6064,6301,5215,6301,'OWNER');
insert into tab_disp values (6066,6317,5228,6317,'OWNER');
insert into tab_disp values (6066,6318,5228,6318,'DISPONENT');
insert into tab_disp values (6072,6349,5256,6349,'OWNER');
insert into tab_disp values (6073,6359,5263,6359,'OWNER');
insert into tab_disp values (6075,6363,5267,6363,'OWNER');
insert into tab_disp values (6076,6366,5269,6366,'OWNER');
insert into tab_disp values (6077,6367,5270,6367,'OWNER');
insert into tab_disp values (6078,6383,5283,6383,'OWNER');
insert into tab_disp values (6083,6408,5305,6408,'OWNER');
insert into tab_disp values (6087,6417,5313,6417,'OWNER');
insert into tab_disp values (6088,6422,5317,6422,'OWNER');
insert into tab_disp values (6095,6469,5358,6469,'OWNER');
insert into tab_disp values (6097,6473,5362,6473,'OWNER');
insert into tab_disp values (6097,6474,5362,6474,'DISPONENT');
insert into tab_disp values (6103,6499,5385,6499,'OWNER');
insert into tab_disp values (6104,6511,5395,6511,'OWNER');
insert into tab_disp values (6109,6544,5422,6544,'OWNER');
insert into tab_disp values (6109,6545,5422,6545,'DISPONENT');
insert into tab_disp values (6111,6551,5428,6551,'OWNER');
insert into tab_disp values (6112,6567,5442,6567,'OWNER');
insert into tab_disp values (6113,6571,5445,6571,'OWNER');
insert into tab_disp values (6118,6610,5477,6610,'OWNER');
insert into tab_disp values (6120,6616,5481,6616,'OWNER');
insert into tab_disp values (6130,6691,5541,6691,'OWNER');
insert into tab_disp values (6136,6729,5572,6729,'OWNER');
insert into tab_disp values (6137,6731,5574,6731,'OWNER');
insert into tab_disp values (6142,6749,5591,6749,'OWNER');
insert into tab_disp values (6142,6750,5591,6750,'DISPONENT');
insert into tab_disp values (6144,6753,5593,6753,'OWNER');
insert into tab_disp values (6147,6764,5602,6764,'OWNER');
insert into tab_disp values (6150,6789,5622,6789,'OWNER');
insert into tab_disp values (6151,6798,5628,6798,'OWNER');
insert into tab_disp values (6153,6803,5632,6803,'OWNER');
insert into tab_disp values (6153,6804,5632,6804,'DISPONENT');
insert into tab_disp values (6157,6829,5650,6829,'OWNER');
insert into tab_disp values (6168,6892,5698,6892,'OWNER');
insert into tab_disp values (6168,6893,5698,6893,'DISPONENT');
insert into tab_disp values (6169,6895,5700,6895,'OWNER');
insert into tab_disp values (6173,6922,5724,6922,'OWNER');
insert into tab_disp values (6175,6936,5735,6936,'OWNER');
insert into tab_disp values (6178,6946,5742,6946,'OWNER');
insert into tab_disp values (6185,6987,5774,6987,'OWNER');
insert into tab_disp values (6190,7010,5794,7010,'OWNER');
insert into tab_disp values (6190,7011,5794,7011,'DISPONENT');
insert into tab_disp values (6196,7065,5837,7065,'OWNER');
insert into tab_disp values (6202,7127,5891,7127,'OWNER');
insert into tab_disp values (6207,7150,5912,7150,'OWNER');
insert into tab_disp values (6210,7166,5927,7166,'OWNER');
insert into tab_disp values (6215,7186,5944,7186,'OWNER');
insert into tab_disp values (6216,7195,5952,7195,'OWNER');
insert into tab_disp values (6223,7241,5991,7241,'OWNER');
insert into tab_disp values (6227,7286,6030,7286,'OWNER');
insert into tab_disp values (6228,7291,6034,7291,'OWNER');
insert into tab_disp values (6229,7299,6040,7299,'OWNER');
insert into tab_disp values (6232,7311,6051,7311,'OWNER');
insert into tab_disp values (6234,7324,6061,7324,'OWNER');
insert into tab_disp values (6235,7325,6062,7325,'OWNER');
insert into tab_disp values (6237,7339,6075,7339,'OWNER');
insert into tab_disp values (6239,7348,6083,7348,'OWNER');
insert into tab_disp values (6242,7366,6097,7366,'OWNER');
insert into tab_disp values (6244,7390,6118,7390,'OWNER');
insert into tab_disp values (6249,7411,6138,7411,'OWNER');
insert into tab_disp values (6249,7412,6138,7412,'DISPONENT');
insert into tab_disp values (6253,7422,6148,7422,'OWNER');
insert into tab_disp values (6253,7423,6148,7423,'DISPONENT');
insert into tab_disp values (6254,7434,6157,7434,'OWNER');
insert into tab_disp values (6255,7435,6158,7435,'OWNER');
insert into tab_disp values (6272,7521,6226,7521,'OWNER');
insert into tab_disp values (6278,7567,6265,7567,'OWNER');
insert into tab_disp values (6279,7576,6273,7576,'OWNER');
insert into tab_disp values (6283,7594,6289,7594,'OWNER');
insert into tab_disp values (6294,7672,6353,7672,'OWNER');
insert into tab_disp values (6296,7678,6358,7678,'OWNER');
insert into tab_disp values (6297,7683,6363,7683,'OWNER');
insert into tab_disp values (6302,7723,6397,7723,'OWNER');
insert into tab_disp values (6302,7724,6397,7724,'DISPONENT');
insert into tab_disp values (6303,7727,6400,7727,'OWNER');
insert into tab_disp values (6306,7753,6425,7753,'OWNER');
insert into tab_disp values (6309,7765,6434,7765,'OWNER');
insert into tab_disp values (6310,7772,6440,7772,'OWNER');
insert into tab_disp values (6312,7787,6453,7787,'OWNER');
insert into tab_disp values (6313,7796,6461,7796,'OWNER');
insert into tab_disp values (6313,7797,6461,7797,'DISPONENT');
insert into tab_disp values (6315,7814,6472,7814,'OWNER');
insert into tab_disp values (6316,7815,6473,7815,'OWNER');
insert into tab_disp values (6320,7843,6495,7843,'OWNER');
insert into tab_disp values (6321,7855,6505,7855,'OWNER');
insert into tab_disp values (6322,7862,6510,7862,'OWNER');
insert into tab_disp values (6336,7914,6555,7914,'OWNER');
insert into tab_disp values (6338,7959,6592,7959,'OWNER');
insert into tab_disp values (6342,7980,6609,7980,'OWNER');
insert into tab_disp values (6346,8030,6649,8030,'OWNER');
insert into tab_disp values (6350,8064,6678,8064,'OWNER');
insert into tab_disp values (6353,8074,6686,8074,'OWNER');
insert into tab_disp values (6354,8076,6688,8076,'OWNER');
insert into tab_disp values (6355,8089,6699,8089,'OWNER');
insert into tab_disp values (6356,8091,6701,8091,'OWNER');
insert into tab_disp values (6357,8096,6706,8096,'OWNER');
insert into tab_disp values (6358,8105,6715,8105,'OWNER');
insert into tab_disp values (6362,8130,6738,8130,'OWNER');
insert into tab_disp values (6377,8200,6792,8200,'OWNER');
insert into tab_disp values (6386,8276,6856,8276,'OWNER');
insert into tab_disp values (6399,8333,6902,8333,'OWNER');
insert into tab_disp values (6402,8356,6922,8356,'OWNER');
insert into tab_disp values (6403,8359,6924,8359,'OWNER');
insert into tab_disp values (6407,8366,6930,8366,'OWNER');
insert into tab_disp values (6415,8392,6950,8392,'OWNER');
insert into tab_disp values (6415,8393,6950,8393,'DISPONENT');
insert into tab_disp values (6421,8432,6985,8432,'OWNER');
insert into tab_disp values (6421,8433,6985,8433,'DISPONENT');
insert into tab_disp values (6435,8502,7045,8502,'OWNER');
insert into tab_disp values (6436,8506,7049,8506,'OWNER');
insert into tab_disp values (6437,8510,7052,8510,'OWNER');
insert into tab_disp values (6442,8548,7082,8548,'OWNER');
insert into tab_disp values (6450,8568,7099,8568,'OWNER');
insert into tab_disp values (6456,8598,7123,8598,'OWNER');
insert into tab_disp values (6460,8610,7133,8610,'OWNER');
insert into tab_disp values (6460,8611,7133,8611,'DISPONENT');
insert into tab_disp values (6461,8615,7136,8615,'OWNER');
insert into tab_disp values (6464,8636,7156,8636,'OWNER');
insert into tab_disp values (6468,8661,7176,8661,'OWNER');
insert into tab_disp values (6469,8666,7180,8666,'OWNER');
insert into tab_disp values (6470,8667,7181,8667,'OWNER');
insert into tab_disp values (6471,8670,7184,8670,'OWNER');
insert into tab_disp values (6474,8677,7190,8677,'OWNER');
insert into tab_disp values (6474,8678,7190,8678,'DISPONENT');
insert into tab_disp values (6486,8737,7240,8737,'OWNER');
insert into tab_disp values (6486,8738,7240,8738,'DISPONENT');
insert into tab_disp values (6490,8764,7262,8764,'OWNER');
insert into tab_disp values (6495,8777,7274,8777,'OWNER');
insert into tab_disp values (6499,8865,7401,9173,'OWNER');
insert into tab_disp values (6499,8866,7401,9174,'DISPONENT');
insert into tab_disp values (6501,8888,7418,9196,'OWNER');
insert into tab_disp values (6502,8894,7424,9202,'OWNER');
insert into tab_disp values (6508,8909,7437,9217,'OWNER');
insert into tab_disp values (6509,8918,7445,9226,'OWNER');
insert into tab_disp values (6512,8928,7454,9236,'OWNER');
insert into tab_disp values (6520,8965,7485,9273,'OWNER');
insert into tab_disp values (6520,8966,7485,9274,'DISPONENT');
insert into tab_disp values (6526,9008,7523,9316,'OWNER');
insert into tab_disp values (6534,9032,7542,9340,'OWNER');
insert into tab_disp values (6535,9038,7546,9346,'OWNER');
insert into tab_disp values (6539,9054,7559,9362,'OWNER');
insert into tab_disp values (6540,9058,7562,9366,'OWNER');
insert into tab_disp values (6541,9062,7565,9370,'OWNER');
insert into tab_disp values (6544,9095,7594,9403,'OWNER');
insert into tab_disp values (6545,9109,7606,9417,'OWNER');
insert into tab_disp values (6546,9110,7607,9418,'OWNER');
insert into tab_disp values (6546,9111,7607,9419,'DISPONENT');
insert into tab_disp values (6550,9119,7614,9427,'OWNER');
insert into tab_disp values (6550,9120,7614,9428,'DISPONENT');
insert into tab_disp values (6552,9142,7632,9450,'OWNER');
insert into tab_disp values (6552,9143,7632,9451,'DISPONENT');
insert into tab_disp values (6553,9148,7636,9456,'OWNER');
insert into tab_disp values (6554,9149,7637,9457,'OWNER');
insert into tab_disp values (6554,9150,7637,9458,'DISPONENT');
insert into tab_disp values (6562,9197,7674,9505,'OWNER');
insert into tab_disp values (6568,9238,7713,9546,'OWNER');
insert into tab_disp values (6569,9247,7721,9555,'OWNER');
insert into tab_disp values (6571,9261,7733,9569,'OWNER');
insert into tab_disp values (6574,9274,7745,9582,'OWNER');
insert into tab_disp values (6577,9285,7753,9593,'OWNER');
insert into tab_disp values (6578,9298,7765,9606,'OWNER');
insert into tab_disp values (6580,9303,7769,9611,'OWNER');
insert into tab_disp values (6585,9333,7795,9641,'OWNER');
insert into tab_disp values (6585,9334,7795,9642,'DISPONENT');
insert into tab_disp values (6589,9355,7815,9663,'OWNER');
insert into tab_disp values (6589,9356,7815,9664,'DISPONENT');
insert into tab_disp values (6591,9362,7819,9670,'OWNER');
insert into tab_disp values (6594,9367,7824,9675,'OWNER');
insert into tab_disp values (6596,9394,7844,9702,'OWNER');
insert into tab_disp values (6598,9407,7857,9715,'OWNER');
insert into tab_disp values (6599,9409,7859,9717,'OWNER');
insert into tab_disp values (6599,9410,7859,9718,'DISPONENT');
insert into tab_disp values (6600,9413,7861,9721,'OWNER');
insert into tab_disp values (6605,9447,7890,9755,'OWNER');
insert into tab_disp values (6607,9452,7894,9760,'OWNER');
insert into tab_disp values (6612,9467,7907,9775,'OWNER');
insert into tab_disp values (6612,9468,7907,9776,'DISPONENT');
insert into tab_disp values (6613,9490,7926,9798,'OWNER');
insert into tab_disp values (6621,9525,7957,9833,'OWNER');
insert into tab_disp values (6621,9526,7957,9834,'DISPONENT');
insert into tab_disp values (6624,9536,7965,9844,'OWNER');
insert into tab_disp values (6624,9537,7965,9845,'DISPONENT');
insert into tab_disp values (6625,9538,7966,9846,'OWNER');
insert into tab_disp values (6632,9564,7990,9872,'OWNER');
insert into tab_disp values (6633,9572,7997,9880,'OWNER');
insert into tab_disp values (6641,9606,8026,9914,'OWNER');
insert into tab_disp values (6642,9607,8027,9915,'OWNER');
insert into tab_disp values (6643,9621,8038,9929,'OWNER');
insert into tab_disp values (6644,9622,8039,9930,'OWNER');
insert into tab_disp values (6645,9625,8041,9933,'OWNER');
insert into tab_disp values (6647,9637,8051,9945,'OWNER');
insert into tab_disp values (6647,9638,8051,9946,'DISPONENT');
insert into tab_disp values (6650,9665,8073,9973,'OWNER');
insert into tab_disp values (6655,9679,8085,9987,'OWNER');
insert into tab_disp values (6659,9687,8092,9995,'OWNER');
insert into tab_disp values (6660,9689,8094,9997,'OWNER');
insert into tab_disp values (6665,9715,8114,10023,'OWNER');
insert into tab_disp values (6667,9732,8127,10040,'OWNER');
insert into tab_disp values (6667,9733,8127,10041,'DISPONENT');
insert into tab_disp values (6668,9735,8129,10043,'OWNER');
insert into tab_disp values (6675,9767,8158,10075,'OWNER');
insert into tab_disp values (6676,9768,8159,10076,'OWNER');
insert into tab_disp values (6676,9769,8159,10077,'DISPONENT');
insert into tab_disp values (6677,9782,8169,10090,'OWNER');
insert into tab_disp values (6678,9787,8173,10095,'OWNER');
insert into tab_disp values (6678,9788,8173,10096,'DISPONENT');
insert into tab_disp values (6682,9851,8225,10159,'OWNER');
insert into tab_disp values (6686,9890,8260,10198,'OWNER');
insert into tab_disp values (6686,9891,8260,10199,'DISPONENT');
insert into tab_disp values (6687,9892,8261,10200,'OWNER');
insert into tab_disp values (6687,9893,8261,10201,'DISPONENT');
insert into tab_disp values (6688,9901,8268,10209,'OWNER');
insert into tab_disp values (6694,9961,8316,10269,'OWNER');
insert into tab_disp values (6695,9965,8320,10273,'OWNER');
insert into tab_disp values (6695,9966,8320,10274,'DISPONENT');
insert into tab_disp values (6696,9967,8321,10275,'OWNER');
insert into tab_disp values (6696,9968,8321,10276,'DISPONENT');
insert into tab_disp values (6698,9974,8327,10282,'OWNER');
insert into tab_disp values (6699,9979,8330,10287,'OWNER');
insert into tab_disp values (6699,9980,8330,10288,'DISPONENT');
insert into tab_disp values (6704,10042,8377,10350,'OWNER');
insert into tab_disp values (6704,10043,8377,10351,'DISPONENT');
insert into tab_disp values (6705,10047,8381,10355,'OWNER');
insert into tab_disp values (6712,10074,8405,10382,'OWNER');
insert into tab_disp values (6715,10081,8411,10389,'OWNER');
insert into tab_disp values (6721,10151,8475,10459,'OWNER');
insert into tab_disp values (6725,10167,8489,10475,'OWNER');
insert into tab_disp values (6725,10168,8489,10476,'DISPONENT');
insert into tab_disp values (6726,10171,8492,10479,'OWNER');
insert into tab_disp values (6727,10184,8505,10492,'OWNER');
insert into tab_disp values (6729,10202,8519,10510,'OWNER');
insert into tab_disp values (6729,10203,8519,10511,'DISPONENT');
insert into tab_disp values (6730,10209,8523,10517,'OWNER');
insert into tab_disp values (6732,10220,8533,10528,'OWNER');
insert into tab_disp values (6734,10235,8547,10543,'OWNER');
insert into tab_disp values (6736,10247,8558,10555,'OWNER');
insert into tab_disp values (6737,10255,8564,10563,'OWNER');
insert into tab_disp values (6737,10256,8564,10564,'DISPONENT');
insert into tab_disp values (6738,10258,8566,10566,'OWNER');
insert into tab_disp values (6745,10328,8625,10636,'OWNER');
insert into tab_disp values (6746,10346,8639,10654,'OWNER');
insert into tab_disp values (6748,10354,8645,10662,'OWNER');
insert into tab_disp values (6751,10394,8680,10702,'OWNER');
insert into tab_disp values (6751,10395,8680,10703,'DISPONENT');
insert into tab_disp values (6753,10406,8688,10714,'OWNER');
insert into tab_disp values (6755,10438,8713,10746,'OWNER');
insert into tab_disp values (6758,10469,8742,10777,'OWNER');
insert into tab_disp values (6758,10470,8742,10778,'DISPONENT');
insert into tab_disp values (6763,10505,8772,10813,'OWNER');
insert into tab_disp values (6764,10510,8776,10818,'OWNER');
insert into tab_disp values (6766,10520,8784,10828,'OWNER');
insert into tab_disp values (6785,10655,8899,10963,'OWNER');
insert into tab_disp values (6790,10679,8919,10987,'OWNER');
insert into tab_disp values (6790,10680,8919,10988,'DISPONENT');
insert into tab_disp values (6791,10689,8926,10997,'OWNER');
insert into tab_disp values (6791,10690,8926,10998,'DISPONENT');
insert into tab_disp values (6793,10696,8931,11004,'OWNER');
insert into tab_disp values (6805,10742,8972,11050,'OWNER');
insert into tab_disp values (6808,10755,8982,11063,'OWNER');
insert into tab_disp values (6808,10756,8982,11064,'DISPONENT');
insert into tab_disp values (6810,10785,9006,11093,'OWNER');
insert into tab_disp values (6816,10797,9017,11105,'OWNER');
insert into tab_disp values (6817,10806,9024,11114,'OWNER');
insert into tab_disp values (6818,10813,9030,11121,'OWNER');
insert into tab_disp values (6818,10814,9030,11122,'DISPONENT');
insert into tab_disp values (6819,10815,9031,11123,'OWNER');
insert into tab_disp values (6820,10818,9034,11126,'OWNER');
insert into tab_disp values (6821,10822,9037,11130,'OWNER');
insert into tab_disp values (6821,10823,9037,11131,'DISPONENT');
insert into tab_disp values (6824,10841,9052,11149,'OWNER');
insert into tab_disp values (6836,10887,9093,11195,'OWNER');
insert into tab_disp values (6841,10900,9104,11208,'OWNER');
insert into tab_disp values (6851,10942,9138,11250,'OWNER');
insert into tab_disp values (6852,10944,9140,11252,'OWNER');
insert into tab_disp values (6855,10958,9153,11266,'OWNER');
insert into tab_disp values (6855,10959,9153,11267,'DISPONENT');
insert into tab_disp values (6856,10963,9156,11271,'OWNER');
insert into tab_disp values (6857,10966,9159,11274,'OWNER');
insert into tab_disp values (6857,10967,9159,11275,'DISPONENT');
insert into tab_disp values (6859,10978,9167,11286,'OWNER');
insert into tab_disp values (6861,10996,9179,11304,'OWNER');
insert into tab_disp values (6863,11006,9188,11314,'OWNER');
insert into tab_disp values (6865,11019,9199,11327,'OWNER');
insert into tab_disp values (6866,11021,9201,11329,'OWNER');
insert into tab_disp values (6868,11029,9208,11337,'OWNER');
insert into tab_disp values (6871,11051,9225,11359,'OWNER');
insert into tab_disp values (6871,11052,9225,11360,'DISPONENT');
insert into tab_disp values (6872,11054,9227,11362,'OWNER');
insert into tab_disp values (6875,11063,9235,11371,'OWNER');
insert into tab_disp values (6876,11064,9236,11372,'OWNER');
insert into tab_disp values (6877,11071,9241,11379,'OWNER');
insert into tab_disp values (6877,11072,9241,11380,'DISPONENT');
insert into tab_disp values (6878,11073,9242,11381,'OWNER');
insert into tab_disp values (6887,11097,9263,11405,'OWNER');
insert into tab_disp values (6887,11098,9263,11406,'DISPONENT');
insert into tab_disp values (6888,11101,9265,11409,'OWNER');
insert into tab_disp values (6895,11153,9307,11461,'OWNER');
insert into tab_disp values (6903,11189,9337,11497,'OWNER');
insert into tab_disp values (6908,11208,9353,11516,'OWNER');
insert into tab_disp values (6908,11209,9353,11517,'DISPONENT');
insert into tab_disp values (6913,11237,9377,11545,'OWNER');
insert into tab_disp values (6919,11266,9403,11574,'OWNER');
insert into tab_disp values (6921,11288,9422,11596,'OWNER');
insert into tab_disp values (6922,11290,9424,11598,'OWNER');
insert into tab_disp values (6923,11301,9433,11609,'OWNER');
insert into tab_disp values (6926,11329,9455,11637,'OWNER');
insert into tab_disp values (6926,11330,9455,11638,'DISPONENT');
insert into tab_disp values (6929,11354,9472,11662,'OWNER');
insert into tab_disp values (6932,11375,9491,11683,'OWNER');
insert into tab_disp values (6933,11377,9493,11685,'OWNER');
insert into tab_disp values (6934,11378,9494,11686,'OWNER');
insert into tab_disp values (6934,11379,9494,11687,'DISPONENT');
insert into tab_disp values (6938,11393,9504,11701,'OWNER');
insert into tab_disp values (6940,11401,9510,11709,'OWNER');
insert into tab_disp values (6940,11402,9510,11710,'DISPONENT');
insert into tab_disp values (6942,11405,9513,11713,'OWNER');
insert into tab_disp values (6942,11406,9513,11714,'DISPONENT');
insert into tab_disp values (6944,11446,9548,11754,'OWNER');
insert into tab_disp values (6948,11460,9560,11768,'OWNER');
insert into tab_disp values (6949,11486,9583,11794,'OWNER');
insert into tab_disp values (6949,11487,9583,11795,'DISPONENT');
insert into tab_disp values (6950,11496,9591,11804,'OWNER');
insert into tab_disp values (6955,11543,9627,11851,'OWNER');
insert into tab_disp values (6956,11547,9631,11855,'OWNER');
insert into tab_disp values (6959,11549,9633,11857,'OWNER');
insert into tab_disp values (6960,11558,9640,11866,'OWNER');
insert into tab_disp values (6960,11559,9640,11867,'DISPONENT');
insert into tab_disp values (6961,11565,9645,11873,'OWNER');
insert into tab_disp values (6962,11566,9646,11874,'OWNER');
insert into tab_disp values (6962,11567,9646,11875,'DISPONENT');
insert into tab_disp values (6965,11578,9656,11886,'OWNER');
insert into tab_disp values (6969,11598,9673,11906,'OWNER');
insert into tab_disp values (6969,11599,9673,11907,'DISPONENT');
insert into tab_disp values (6970,11603,9677,11911,'OWNER');
insert into tab_disp values (6984,11668,9730,11976,'OWNER');
insert into tab_disp values (6984,11669,9730,11977,'DISPONENT');
insert into tab_disp values (6985,11670,9731,11978,'OWNER');
insert into tab_disp values (6985,11671,9731,11979,'DISPONENT');
insert into tab_disp values (6986,11695,9750,12003,'OWNER');
insert into tab_disp values (6992,11742,9790,12050,'OWNER');
insert into tab_disp values (6992,11743,9790,12051,'DISPONENT');
insert into tab_disp values (6995,11771,9814,12079,'OWNER');
insert into tab_disp values (6996,11787,9828,12095,'OWNER');
insert into tab_disp values (6998,11794,9833,12102,'OWNER');
insert into tab_disp values (7001,11825,9859,12133,'OWNER');
insert into tab_disp values (7004,11836,9869,12144,'OWNER');
insert into tab_disp values (7004,11837,9869,12145,'DISPONENT');
insert into tab_disp values (7008,11873,9897,12181,'OWNER');
insert into tab_disp values (7013,11912,9928,12220,'OWNER');
insert into tab_disp values (7013,11913,9928,12221,'DISPONENT');
insert into tab_disp values (7034,11995,10001,12303,'OWNER');
insert into tab_disp values (7035,12000,10005,12308,'OWNER');
insert into tab_disp values (7036,12017,10019,12325,'OWNER');
insert into tab_disp values (7037,12020,10022,12328,'OWNER');
insert into tab_disp values (7046,12050,10049,12358,'OWNER');
insert into tab_disp values (7046,12051,10049,12359,'DISPONENT');
insert into tab_disp values (7049,12068,10063,12376,'OWNER');
insert into tab_disp values (7050,12070,10065,12378,'OWNER');
insert into tab_disp values (7051,12074,10068,12382,'OWNER');
insert into tab_disp values (7051,12075,10068,12383,'DISPONENT');
insert into tab_disp values (7055,12088,10079,12396,'OWNER');
insert into tab_disp values (7055,12089,10079,12397,'DISPONENT');
insert into tab_disp values (7057,12108,10093,12416,'OWNER');
insert into tab_disp values (7057,12109,10093,12417,'DISPONENT');
insert into tab_disp values (7061,12124,10105,12432,'OWNER');
insert into tab_disp values (7066,12156,10131,12464,'OWNER');
insert into tab_disp values (7067,12160,10134,12468,'OWNER');
insert into tab_disp values (7072,12177,10148,12485,'OWNER');
insert into tab_disp values (7085,12239,10202,12547,'OWNER');
insert into tab_disp values (7087,12253,10215,12561,'OWNER');
insert into tab_disp values (7088,12278,10233,12586,'OWNER');
insert into tab_disp values (7091,12291,10243,12599,'OWNER');
insert into tab_disp values (7096,12308,10257,12616,'OWNER');
insert into tab_disp values (7097,12317,10266,12625,'OWNER');
insert into tab_disp values (7100,12335,10280,12643,'OWNER');
insert into tab_disp values (7101,12354,10297,12662,'OWNER');
insert into tab_disp values (7104,12387,10320,12695,'OWNER');
insert into tab_disp values (7110,12421,10345,12729,'OWNER');
insert into tab_disp values (7110,12422,10345,12730,'DISPONENT');
insert into tab_disp values (7115,12430,10351,12738,'OWNER');
insert into tab_disp values (7115,12431,10351,12739,'DISPONENT');
insert into tab_disp values (7119,12442,10361,12750,'OWNER');
insert into tab_disp values (7121,12446,10364,12754,'OWNER');
insert into tab_disp values (7121,12447,10364,12755,'DISPONENT');
insert into tab_disp values (7122,12448,10365,12756,'OWNER');
insert into tab_disp values (7129,12494,10404,12802,'OWNER');
insert into tab_disp values (7130,12502,10411,12810,'OWNER');
insert into tab_disp values (7136,12532,10436,12840,'OWNER');
insert into tab_disp values (7137,12535,10439,12843,'OWNER');
insert into tab_disp values (7138,12536,10440,12844,'OWNER');
insert into tab_disp values (7139,12542,10445,12850,'OWNER');
insert into tab_disp values (7139,12543,10445,12851,'DISPONENT');
insert into tab_disp values (7142,12551,10451,12859,'OWNER');
insert into tab_disp values (7147,12582,10478,12890,'OWNER');
insert into tab_disp values (7151,12600,10493,12908,'OWNER');
insert into tab_disp values (7154,12635,10520,12943,'OWNER');
insert into tab_disp values (7164,12743,10613,13051,'OWNER');
insert into tab_disp values (7166,12763,10630,13071,'OWNER');
insert into tab_disp values (7167,12781,10644,13089,'OWNER');
insert into tab_disp values (7168,12782,10645,13090,'OWNER');
insert into tab_disp values (7171,12787,10650,13095,'OWNER');
insert into tab_disp values (7172,12790,10652,13098,'OWNER');
insert into tab_disp values (7176,12805,10663,13113,'OWNER');
insert into tab_disp values (7181,12826,10679,13134,'OWNER');
insert into tab_disp values (7187,12864,10711,13172,'OWNER');
insert into tab_disp values (7189,12882,10728,13190,'OWNER');
insert into tab_disp values (7192,12893,10738,13201,'OWNER');
insert into tab_disp values (7194,12923,10762,13231,'OWNER');
insert into tab_disp values (7195,12938,10774,13246,'OWNER');
insert into tab_disp values (7198,12952,10788,13260,'OWNER');
insert into tab_disp values (7199,12953,10789,13261,'OWNER');
insert into tab_disp values (7199,12954,10789,13262,'DISPONENT');
insert into tab_disp values (7200,12968,10799,13276,'OWNER');
insert into tab_disp values (7201,12977,10807,13285,'OWNER');
insert into tab_disp values (7202,12982,10812,13290,'OWNER');
insert into tab_disp values (7202,12983,10812,13291,'DISPONENT');
insert into tab_disp values (7209,13038,10857,13346,'OWNER');
insert into tab_disp values (7213,13072,10884,13380,'OWNER');
insert into tab_disp values (7219,13097,10905,13405,'OWNER');
insert into tab_disp values (7220,13104,10911,13412,'OWNER');
insert into tab_disp values (7221,13109,10915,13417,'OWNER');
insert into tab_disp values (7226,13139,10940,13447,'OWNER');
insert into tab_disp values (7226,13140,10940,13448,'DISPONENT');
insert into tab_disp values (7227,13143,10942,13451,'OWNER');
insert into tab_disp values (7230,13160,10954,13468,'OWNER');
insert into tab_disp values (7230,13161,10954,13469,'DISPONENT');
insert into tab_disp values (7233,13172,10963,13480,'OWNER');
insert into tab_disp values (7235,13182,10973,13490,'OWNER');
insert into tab_disp values (7240,13231,11013,13539,'OWNER');
insert into tab_disp values (7241,13240,11021,13548,'OWNER');
insert into tab_disp values (7242,13248,11027,13556,'OWNER');
insert into tab_disp values (7243,13268,11042,13576,'OWNER');
insert into tab_disp values (7246,13282,11054,13590,'OWNER');
insert into tab_disp values (7249,13295,11065,13603,'OWNER');
insert into tab_disp values (7250,13300,11069,13608,'OWNER');
insert into tab_disp values (7253,13312,11079,13620,'OWNER');
insert into tab_disp values (7255,13332,11096,13640,'OWNER');
insert into tab_disp values (7259,13349,11111,13657,'OWNER');
insert into tab_disp values (7259,13350,11111,13658,'DISPONENT');
insert into tab_disp values (7262,13379,11135,13687,'OWNER');
insert into tab_disp values (7263,13382,11138,13690,'OWNER');
insert into tab_disp values (7264,13386,11141,13694,'OWNER');
insert into tab_disp values (7271,13442,11186,13750,'OWNER');
insert into tab_disp values (7271,13443,11186,13751,'DISPONENT');
insert into tab_disp values (7277,13495,11231,13803,'OWNER');
insert into tab_disp values (7279,13512,11244,13820,'OWNER');
insert into tab_disp values (7284,13537,11265,13845,'OWNER');
insert into tab_disp values (7286,13544,11271,13852,'OWNER');
insert into tab_disp values (7292,13604,11317,13912,'OWNER');
insert into tab_disp values (7294,13615,11327,13923,'OWNER');
insert into tab_disp values (7295,13616,11328,13924,'OWNER');
insert into tab_disp values (7304,13647,11349,13955,'OWNER');
insert into tab_disp values (7304,13648,11349,13956,'DISPONENT');
insert into tab_disp values (7305,13660,11359,13968,'OWNER');
insert into tab_disp values (7308,13663,11362,13971,'OWNER');
insert into tab_district values (4959,1,'Hl.m. Praha','Prague',1204953,0,0,0,1,1,100.00,12541,0.29,0.43,167,85677,99107);
insert into tab_district values (4959,1,'Hl.m. Praha','Prague',1204953,0,0,0,1,1,100.00,12541,0.29,0.43,167,85677,99107);
insert into tab_district values (4961,21,'Tabor','south Bohemia',103347,87,16,7,1,7,67.00,9104,1.51,2.07,123,2299,2354);
insert into tab_district values (4962,68,'Frydek - Mistek','north Moravia',228848,15,40,18,2,6,57.20,9893,4.09,4.72,96,5623,5887);
insert into tab_district values (4967,20,'Strakonice','south Bohemia',70646,94,14,3,1,4,58.40,8547,2.65,3.64,120,1563,1542);
insert into tab_district values (4968,19,'Prachatice','south Bohemia',51428,50,11,3,1,4,52.70,8402,3.13,3.98,120,999,1099);
insert into tab_district values (4973,16,'Jindrichuv Hradec','south Bohemia',93931,74,21,10,1,8,56.90,8427,1.12,1.54,107,1874,1913);
insert into tab_district values (4986,74,'Ostrava - mesto','north Moravia',323870,0,0,0,1,1,100.00,10673,4.75,5.44,100,18782,18347);
insert into tab_district values (4986,74,'Ostrava - mesto','north Moravia',323870,0,0,0,1,1,100.00,10673,4.75,5.44,100,18782,18347);
insert into tab_district values (4988,44,'Chrudim','east Bohemia',105606,77,26,7,2,7,53.00,8254,2.79,3.76,97,2166,2325);
insert into tab_district values (4989,21,'Tabor','south Bohemia',103347,87,16,7,1,7,67.00,9104,1.51,2.07,123,2299,2354);
insert into tab_district values (4990,36,'Liberec','north Bohemia',159617,29,19,8,1,9,85.20,9198,3.33,4.28,131,5796,6132);
insert into tab_district values (4996,40,'Teplice','north Bohemia',128118,9,16,6,3,8,85.30,9317,6.49,7.07,97,6949,6872);
insert into tab_district values (4996,40,'Teplice','north Bohemia',128118,9,16,6,3,8,85.30,9317,6.49,7.07,97,6949,6872);
insert into tab_district values (5002,66,'Zdar nad Sazavou','south Moravia',125832,151,41,2,3,5,48.30,8512,3.51,4.12,102,2247,2103);
insert into tab_district values (5002,66,'Zdar nad Sazavou','south Moravia',125832,151,41,2,3,5,48.30,8512,3.51,4.12,102,2247,2103);
insert into tab_district values (5005,71,'Novy Jicin','north Moravia',161227,5,35,11,4,10,69.70,8678,5.93,5.57,102,4980,4595);
insert into tab_district values (5015,70,'Karvina','north Moravia',285387,0,2,8,5,7,89.90,10177,6.63,7.75,81,9878,10108);
insert into tab_district values (5027,38,'Louny','north Bohemia',85852,41,23,4,2,4,59.80,8965,7.08,8.23,104,2653,2822);
insert into tab_district values (5032,56,'Breclav','south Moravia',124605,11,42,14,1,8,46.00,8772,4.69,4.98,126,2854,3158);
insert into tab_district values (5034,71,'Novy Jicin','north Moravia',161227,5,35,11,4,10,69.70,8678,5.93,5.57,102,4980,4595);
insert into tab_district values (5036,14,'Ceske Budejovice','south Bohemia',177686,69,27,10,1,9,74.80,10045,1.42,1.71,135,6604,6295);
insert into tab_district values (5039,15,'Cesky Krumlov','south Bohemia',58796,22,16,7,1,5,51.90,9045,3.13,3.60,124,1845,1879);
insert into tab_district values (5039,15,'Cesky Krumlov','south Bohemia',58796,22,16,7,1,5,51.90,9045,3.13,3.60,124,1845,1879);
insert into tab_district values (5041,47,'Pardubice','east Bohemia',162580,83,26,5,1,6,72.80,9538,1.51,1.81,111,6079,5410);
insert into tab_district values (5042,42,'Havlickuv Brod','east Bohemia',95907,87,25,5,2,7,59.10,8388,2.41,2.94,87,1658,1668);
insert into tab_district values (5042,42,'Havlickuv Brod','east Bohemia',95907,87,25,5,2,7,59.10,8388,2.41,2.94,87,1658,1668);
insert into tab_district values (5043,46,'Nachod','east Bohemia',112709,48,20,7,3,10,73.50,8369,1.79,2.31,117,2854,2618);
insert into tab_district values (5043,46,'Nachod','east Bohemia',112709,48,20,7,3,10,73.50,8369,1.79,2.31,117,2854,2618);
insert into tab_district values (5044,54,'Brno - mesto','south Moravia',387570,0,0,0,1,1,100.00,9897,1.60,1.96,140,18721,18696);
insert into tab_district values (5045,1,'Hl.m. Praha','Prague',1204953,0,0,0,1,1,100.00,12541,0.29,0.43,167,85677,99107);
insert into tab_district values (5046,72,'Olomouc','north Moravia',226122,32,50,7,4,4,62.60,8994,3.80,4.79,110,9672,9208);
insert into tab_district values (5046,72,'Olomouc','north Moravia',226122,32,50,7,4,4,62.60,8994,3.80,4.79,110,9672,9208);
insert into tab_district values (5051,68,'Frydek - Mistek','north Moravia',228848,15,40,18,2,6,57.20,9893,4.09,4.72,96,5623,5887);
insert into tab_district values (5060,60,'Prostejov','south Moravia',110643,49,41,4,1,4,51.90,8441,3.45,4.48,115,1879,2252);
insert into tab_district values (5061,29,'Rokycany','west Bohemia',45714,52,10,5,1,6,55.60,8843,2.82,3.60,113,818,888);
insert into tab_district values (5063,54,'Brno - mesto','south Moravia',387570,0,0,0,1,1,100.00,9897,1.60,1.96,140,18721,18696);
insert into tab_district values (5072,8,'Mlada Boleslav','central Bohemia',112065,95,19,7,1,8,69.40,11277,1.25,1.44,127,5179,4987);
insert into tab_district values (5082,13,'Rakovnik','central Bohemia',53921,61,22,1,1,2,41.30,8598,2.77,3.26,123,1597,1875);
insert into tab_district values (5086,70,'Karvina','north Moravia',285387,0,2,8,5,7,89.90,10177,6.63,7.75,81,9878,10108);
insert into tab_district values (5088,32,'Ceska Lipa','north Bohemia',105058,32,19,7,2,10,81.00,9272,2.80,3.22,118,4340,4505);
insert into tab_district values (5103,27,'Plzen - jih','west Bohemia',67298,71,19,10,0,7,43.80,8561,0.65,1.29,110,1029,1127);
insert into tab_district values (5103,27,'Plzen - jih','west Bohemia',67298,71,19,10,0,7,43.80,8561,0.65,1.29,110,1029,1127);
insert into tab_district values (5110,58,'Jihlava','south Moravia',109164,98,16,6,1,4,63.60,8757,3.38,3.95,96,2212,2471);
insert into tab_district values (5110,58,'Jihlava','south Moravia',109164,98,16,6,1,4,63.60,8757,3.38,3.95,96,2212,2471);
insert into tab_district values (5117,1,'Hl.m. Praha','Prague',1204953,0,0,0,1,1,100.00,12541,0.29,0.43,167,85677,99107);
insert into tab_district values (5124,21,'Tabor','south Bohemia',103347,87,16,7,1,7,67.00,9104,1.51,2.07,123,2299,2354);
insert into tab_district values (5125,39,'Most','north Bohemia',119895,17,4,3,2,4,89.90,10446,7.34,9.40,90,4947,4743);
insert into tab_district values (5125,39,'Most','north Bohemia',119895,17,4,3,2,4,89.90,10446,7.34,9.40,90,4947,4743);
insert into tab_district values (5126,54,'Brno - mesto','south Moravia',387570,0,0,0,1,1,100.00,9897,1.60,1.96,140,18721,18696);
insert into tab_district values (5128,69,'Jesenik','north Moravia',42821,4,13,5,1,3,48.40,8173,NULL,7.01,124,NULL,1358);
insert into tab_district values (5130,16,'Jindrichuv Hradec','south Bohemia',93931,74,21,10,1,8,56.90,8427,1.12,1.54,107,1874,1913);
insert into tab_district values (5131,40,'Teplice','north Bohemia',128118,9,16,6,3,8,85.30,9317,6.49,7.07,97,6949,6872);
insert into tab_district values (5132,5,'Kolin','central Bohemia',95616,65,30,4,1,6,51.40,9307,3.85,4.43,118,2616,3040);
insert into tab_district values (5134,19,'Prachatice','south Bohemia',51428,50,11,3,1,4,52.70,8402,3.13,3.98,120,999,1099);
insert into tab_district values (5136,72,'Olomouc','north Moravia',226122,32,50,7,4,4,62.60,8994,3.80,4.79,110,9672,9208);
insert into tab_district values (5138,1,'Hl.m. Praha','Prague',1204953,0,0,0,1,1,100.00,12541,0.29,0.43,167,85677,99107);
insert into tab_district values (5140,73,'Opava','north Moravia',182027,17,49,12,2,7,56.40,8746,3.33,3.74,90,4355,4433);
insert into tab_district values (5145,72,'Olomouc','north Moravia',226122,32,50,7,4,4,62.60,8994,3.80,4.79,110,9672,9208);
insert into tab_district values (5147,70,'Karvina','north Moravia',285387,0,2,8,5,7,89.90,10177,6.63,7.75,81,9878,10108);
insert into tab_district values (5148,37,'Litomerice','north Bohemia',114006,71,26,6,2,9,62.30,9065,4.46,5.39,123,4147,4166);
insert into tab_district values (5148,37,'Litomerice','north Bohemia',114006,71,26,6,2,9,62.30,9065,4.46,5.39,123,4147,4166);
insert into tab_district values (5151,4,'Kladno','central Bohemia',149893,63,29,6,2,6,67.40,9753,4.64,5.05,109,5244,5892);
insert into tab_district values (5154,6,'Kutna Hora','central Bohemia',77963,60,23,4,2,4,51.50,8546,2.95,4.02,126,2640,3120);
insert into tab_district values (5158,70,'Karvina','north Moravia',285387,0,2,8,5,7,89.90,10177,6.63,7.75,81,9878,10108);
insert into tab_district values (5160,45,'Jicin','east Bohemia',77917,85,19,6,1,5,53.50,8390,2.28,2.89,132,2080,2122);
insert into tab_district values (5161,65,'Znojmo','south Moravia',114200,101,41,4,1,4,43.70,8403,5.74,5.72,105,2157,2718);
insert into tab_district values (5169,52,'Usti nad Orlici','east Bohemia',139012,59,41,8,3,10,61.90,8363,2.52,3.49,108,2564,2799);
insert into tab_district values (5170,52,'Usti nad Orlici','east Bohemia',139012,59,41,8,3,10,61.90,8363,2.52,3.49,108,2564,2799);
insert into tab_district values (5172,45,'Jicin','east Bohemia',77917,85,19,6,1,5,53.50,8390,2.28,2.89,132,2080,2122);
insert into tab_district values (5174,54,'Brno - mesto','south Moravia',387570,0,0,0,1,1,100.00,9897,1.60,1.96,140,18721,18696);
insert into tab_district values (5176,20,'Strakonice','south Bohemia',70646,94,14,3,1,4,58.40,8547,2.65,3.64,120,1563,1542);
insert into tab_district values (5189,11,'Praha - zapad','central Bohemia',75637,35,36,9,0,7,36.50,9622,0.45,0.59,154,3475,3529);
insert into tab_district values (5206,74,'Ostrava - mesto','north Moravia',323870,0,0,0,1,1,100.00,10673,4.75,5.44,100,18782,18347);
insert into tab_district values (5207,68,'Frydek - Mistek','north Moravia',228848,15,40,18,2,6,57.20,9893,4.09,4.72,96,5623,5887);
insert into tab_district values (5208,65,'Znojmo','south Moravia',114200,101,41,4,1,4,43.70,8403,5.74,5.72,105,2157,2718);
insert into tab_district values (5209,62,'Uherske Hradiste','south Moravia',145688,22,41,13,2,5,40.70,8544,1.29,1.86,109,2719,2906);
insert into tab_district values (5210,13,'Rakovnik','central Bohemia',53921,61,22,1,1,2,41.30,8598,2.77,3.26,123,1597,1875);
insert into tab_district values (5212,38,'Louny','north Bohemia',85852,41,23,4,2,4,59.80,8965,7.08,8.23,104,2653,2822);
insert into tab_district values (5214,55,'Brno - venkov','south Moravia',157042,49,70,18,0,9,33.90,8743,1.88,2.43,111,3659,3894);
insert into tab_district values (5221,55,'Brno - venkov','south Moravia',157042,49,70,18,0,9,33.90,8743,1.88,2.43,111,3659,3894);
insert into tab_district values (5226,56,'Breclav','south Moravia',124605,11,42,14,1,8,46.00,8772,4.69,4.98,126,2854,3158);
insert into tab_district values (5229,53,'Blansko','south Moravia',107911,88,33,6,2,7,50.90,8240,2.53,3.56,99,1850,1903);
insert into tab_district values (5229,53,'Blansko','south Moravia',107911,88,33,6,2,7,50.90,8240,2.53,3.56,99,1850,1903);
insert into tab_district values (5236,53,'Blansko','south Moravia',107911,88,33,6,2,7,50.90,8240,2.53,3.56,99,1850,1903);
insert into tab_district values (5237,19,'Prachatice','south Bohemia',51428,50,11,3,1,4,52.70,8402,3.13,3.98,120,999,1099);
insert into tab_district values (5241,34,'Chomutov','north Bohemia',125236,28,11,1,4,5,87.70,9675,6.43,7.68,100,5323,5190);
insert into tab_district values (5245,19,'Prachatice','south Bohemia',51428,50,11,3,1,4,52.70,8402,3.13,3.98,120,999,1099);
insert into tab_district values (5245,19,'Prachatice','south Bohemia',51428,50,11,3,1,4,52.70,8402,3.13,3.98,120,999,1099);
insert into tab_district values (5253,65,'Znojmo','south Moravia',114200,101,41,4,1,4,43.70,8403,5.74,5.72,105,2157,2718);
insert into tab_district values (5260,41,'Usti nad Labem','north Bohemia',118650,8,8,5,1,3,85.60,9832,3.32,4.48,114,6445,5471);
insert into tab_district values (5265,62,'Uherske Hradiste','south Moravia',145688,22,41,13,2,5,40.70,8544,1.29,1.86,109,2719,2906);
insert into tab_district values (5269,31,'Tachov','west Bohemia',51313,34,12,3,1,4,59.20,8930,3.52,4.20,108,1328,1452);
insert into tab_district values (5270,50,'Svitavy','east Bohemia',102609,75,33,2,3,6,52.00,8187,4.83,5.45,94,2123,2134);
insert into tab_district values (5281,69,'Jesenik','north Moravia',42821,4,13,5,1,3,48.40,8173,NULL,7.01,124,NULL,1358);
insert into tab_district values (5282,69,'Jesenik','north Moravia',42821,4,13,5,1,3,48.40,8173,NULL,7.01,124,NULL,1358);
insert into tab_district values (5285,31,'Tachov','west Bohemia',51313,34,12,3,1,4,59.20,8930,3.52,4.20,108,1328,1452);
insert into tab_district values (5287,6,'Kutna Hora','central Bohemia',77963,60,23,4,2,4,51.50,8546,2.95,4.02,126,2640,3120);
insert into tab_district values (5287,6,'Kutna Hora','central Bohemia',77963,60,23,4,2,4,51.50,8546,2.95,4.02,126,2640,3120);
insert into tab_district values (5293,47,'Pardubice','east Bohemia',162580,83,26,5,1,6,72.80,9538,1.51,1.81,111,6079,5410);
insert into tab_district values (5301,68,'Frydek - Mistek','north Moravia',228848,15,40,18,2,6,57.20,9893,4.09,4.72,96,5623,5887);
insert into tab_district values (5304,71,'Novy Jicin','north Moravia',161227,5,35,11,4,10,69.70,8678,5.93,5.57,102,4980,4595);
insert into tab_district values (5310,28,'Plzen - sever','west Bohemia',72541,66,26,10,0,8,36.90,8594,1.62,2.01,112,1580,1525);
insert into tab_district values (5311,28,'Plzen - sever','west Bohemia',72541,66,26,10,0,8,36.90,8594,1.62,2.01,112,1580,1525);
insert into tab_district values (5312,31,'Tachov','west Bohemia',51313,34,12,3,1,4,59.20,8930,3.52,4.20,108,1328,1452);
insert into tab_district values (5313,36,'Liberec','north Bohemia',159617,29,19,8,1,9,85.20,9198,3.33,4.28,131,5796,6132);
insert into tab_district values (5314,30,'Sokolov','west Bohemia',94812,15,13,8,2,10,81.80,9650,3.38,3.67,100,2985,2804);
insert into tab_district values (5316,46,'Nachod','east Bohemia',112709,48,20,7,3,10,73.50,8369,1.79,2.31,117,2854,2618);
insert into tab_district values (5318,28,'Plzen - sever','west Bohemia',72541,66,26,10,0,8,36.90,8594,1.62,2.01,112,1580,1525);
insert into tab_district values (5318,28,'Plzen - sever','west Bohemia',72541,66,26,10,0,8,36.90,8594,1.62,2.01,112,1580,1525);
insert into tab_district values (5319,68,'Frydek - Mistek','north Moravia',228848,15,40,18,2,6,57.20,9893,4.09,4.72,96,5623,5887);
insert into tab_district values (5320,55,'Brno - venkov','south Moravia',157042,49,70,18,0,9,33.90,8743,1.88,2.43,111,3659,3894);
insert into tab_district values (5325,14,'Ceske Budejovice','south Bohemia',177686,69,27,10,1,9,74.80,10045,1.42,1.71,135,6604,6295);
insert into tab_district values (5329,19,'Prachatice','south Bohemia',51428,50,11,3,1,4,52.70,8402,3.13,3.98,120,999,1099);
insert into tab_district values (5332,1,'Hl.m. Praha','Prague',1204953,0,0,0,1,1,100.00,12541,0.29,0.43,167,85677,99107);
insert into tab_district values (5334,1,'Hl.m. Praha','Prague',1204953,0,0,0,1,1,100.00,12541,0.29,0.43,167,85677,99107);
insert into tab_district values (5337,32,'Ceska Lipa','north Bohemia',105058,32,19,7,2,10,81.00,9272,2.80,3.22,118,4340,4505);
insert into tab_district values (5337,32,'Ceska Lipa','north Bohemia',105058,32,19,7,2,10,81.00,9272,2.80,3.22,118,4340,4505);
insert into tab_district values (5338,6,'Kutna Hora','central Bohemia',77963,60,23,4,2,4,51.50,8546,2.95,4.02,126,2640,3120);
insert into tab_district values (5343,1,'Hl.m. Praha','Prague',1204953,0,0,0,1,1,100.00,12541,0.29,0.43,167,85677,99107);
insert into tab_district values (5346,70,'Karvina','north Moravia',285387,0,2,8,5,7,89.90,10177,6.63,7.75,81,9878,10108);
insert into tab_district values (5350,26,'Plzen - mesto','west Bohemia',170449,0,0,0,1,1,100.00,10787,2.64,3.09,131,6041,6261);
insert into tab_district values (5351,1,'Hl.m. Praha','Prague',1204953,0,0,0,1,1,100.00,12541,0.29,0.43,167,85677,99107);
insert into tab_district values (5352,68,'Frydek - Mistek','north Moravia',228848,15,40,18,2,6,57.20,9893,4.09,4.72,96,5623,5887);
insert into tab_district values (5354,5,'Kolin','central Bohemia',95616,65,30,4,1,6,51.40,9307,3.85,4.43,118,2616,3040);
insert into tab_district values (5358,42,'Havlickuv Brod','east Bohemia',95907,87,25,5,2,7,59.10,8388,2.41,2.94,87,1658,1668);
insert into tab_district values (5360,53,'Blansko','south Moravia',107911,88,33,6,2,7,50.90,8240,2.53,3.56,99,1850,1903);
insert into tab_district values (5360,53,'Blansko','south Moravia',107911,88,33,6,2,7,50.90,8240,2.53,3.56,99,1850,1903);
insert into tab_district values (5363,64,'Zlin','south Moravia',197099,29,41,10,2,10,74.70,9624,1.60,2.31,145,4484,4265);
insert into tab_district values (5365,37,'Litomerice','north Bohemia',114006,71,26,6,2,9,62.30,9065,4.46,5.39,123,4147,4166);
insert into tab_district values (5366,70,'Karvina','north Moravia',285387,0,2,8,5,7,89.90,10177,6.63,7.75,81,9878,10108);
insert into tab_district values (5367,54,'Brno - mesto','south Moravia',387570,0,0,0,1,1,100.00,9897,1.60,1.96,140,18721,18696);
insert into tab_district values (5368,59,'Kromeriz','south Moravia',108871,41,29,7,2,6,62.10,8444,3.24,3.47,106,2595,2305);
insert into tab_district values (5369,74,'Ostrava - mesto','north Moravia',323870,0,0,0,1,1,100.00,10673,4.75,5.44,100,18782,18347);
insert into tab_district values (5369,74,'Ostrava - mesto','north Moravia',323870,0,0,0,1,1,100.00,10673,4.75,5.44,100,18782,18347);
insert into tab_district values (5375,1,'Hl.m. Praha','Prague',1204953,0,0,0,1,1,100.00,12541,0.29,0.43,167,85677,99107);
insert into tab_district values (5377,70,'Karvina','north Moravia',285387,0,2,8,5,7,89.90,10177,6.63,7.75,81,9878,10108);
insert into tab_district values (5382,52,'Usti nad Orlici','east Bohemia',139012,59,41,8,3,10,61.90,8363,2.52,3.49,108,2564,2799);
insert into tab_district values (5384,42,'Havlickuv Brod','east Bohemia',95907,87,25,5,2,7,59.10,8388,2.41,2.94,87,1658,1668);
insert into tab_district values (5384,42,'Havlickuv Brod','east Bohemia',95907,87,25,5,2,7,59.10,8388,2.41,2.94,87,1658,1668);
insert into tab_district values (5385,1,'Hl.m. Praha','Prague',1204953,0,0,0,1,1,100.00,12541,0.29,0.43,167,85677,99107);
insert into tab_district values (5385,1,'Hl.m. Praha','Prague',1204953,0,0,0,1,1,100.00,12541,0.29,0.43,167,85677,99107);
insert into tab_district values (5388,31,'Tachov','west Bohemia',51313,34,12,3,1,4,59.20,8930,3.52,4.20,108,1328,1452);
insert into tab_district values (5389,51,'Trutnov','east Bohemia',121947,37,28,7,3,11,70.50,8541,2.51,2.97,131,3496,3839);
insert into tab_district values (5390,16,'Jindrichuv Hradec','south Bohemia',93931,74,21,10,1,8,56.90,8427,1.12,1.54,107,1874,1913);
insert into tab_district values (5395,67,'Bruntal','north Moravia',106054,38,25,6,2,6,63.10,8110,5.77,6.55,109,3244,3079);
insert into tab_district values (5398,9,'Nymburk','central Bohemia',81344,61,23,4,2,6,55.30,8899,3.39,3.97,149,2987,2487);
insert into tab_district values (5398,9,'Nymburk','central Bohemia',81344,61,23,4,2,6,55.30,8899,3.39,3.97,149,2987,2487);
insert into tab_district values (5409,19,'Prachatice','south Bohemia',51428,50,11,3,1,4,52.70,8402,3.13,3.98,120,999,1099);
insert into tab_district values (5409,19,'Prachatice','south Bohemia',51428,50,11,3,1,4,52.70,8402,3.13,3.98,120,999,1099);
insert into tab_district values (5413,31,'Tachov','west Bohemia',51313,34,12,3,1,4,59.20,8930,3.52,4.20,108,1328,1452);
insert into tab_district values (5413,31,'Tachov','west Bohemia',51313,34,12,3,1,4,59.20,8930,3.52,4.20,108,1328,1452);
insert into tab_district values (5414,34,'Chomutov','north Bohemia',125236,28,11,1,4,5,87.70,9675,6.43,7.68,100,5323,5190);
insert into tab_district values (5415,73,'Opava','north Moravia',182027,17,49,12,2,7,56.40,8746,3.33,3.74,90,4355,4433);
insert into tab_district values (5418,29,'Rokycany','west Bohemia',45714,52,10,5,1,6,55.60,8843,2.82,3.60,113,818,888);
insert into tab_district values (5419,1,'Hl.m. Praha','Prague',1204953,0,0,0,1,1,100.00,12541,0.29,0.43,167,85677,99107);
insert into tab_district values (5420,24,'Karlovy Vary','west Bohemia',122603,25,21,6,2,8,80.00,8991,1.39,2.01,128,5198,5273);
insert into tab_district values (5428,13,'Rakovnik','central Bohemia',53921,61,22,1,1,2,41.30,8598,2.77,3.26,123,1597,1875);
insert into tab_district values (5429,1,'Hl.m. Praha','Prague',1204953,0,0,0,1,1,100.00,12541,0.29,0.43,167,85677,99107);
insert into tab_district values (5435,2,'Benesov','central Bohemia',88884,80,26,6,2,5,46.70,8507,1.67,1.85,132,2159,2674);
insert into tab_district values (5445,33,'Decin','north Bohemia',133777,24,17,7,3,11,84.70,8705,5.75,7.61,116,4650,4859);
insert into tab_district values (5446,50,'Svitavy','east Bohemia',102609,75,33,2,3,6,52.00,8187,4.83,5.45,94,2123,2134);
insert into tab_district values (5447,70,'Karvina','north Moravia',285387,0,2,8,5,7,89.90,10177,6.63,7.75,81,9878,10108);
insert into tab_district values (5449,68,'Frydek - Mistek','north Moravia',228848,15,40,18,2,6,57.20,9893,4.09,4.72,96,5623,5887);
insert into tab_district values (5450,52,'Usti nad Orlici','east Bohemia',139012,59,41,8,3,10,61.90,8363,2.52,3.49,108,2564,2799);
insert into tab_district values (5451,18,'Pisek','south Bohemia',70699,60,13,2,1,4,65.30,8968,2.83,3.35,131,1740,1910);
insert into tab_district values (5452,70,'Karvina','north Moravia',285387,0,2,8,5,7,89.90,10177,6.63,7.75,81,9878,10108);
insert into tab_district values (5453,28,'Plzen - sever','west Bohemia',72541,66,26,10,0,8,36.90,8594,1.62,2.01,112,1580,1525);
insert into tab_district values (5463,33,'Decin','north Bohemia',133777,24,17,7,3,11,84.70,8705,5.75,7.61,116,4650,4859);
insert into tab_district values (5464,43,'Hradec Kralove','east Bohemia',161854,73,21,6,1,6,76.30,9425,1.72,2.50,125,4085,3891);
insert into tab_district values (5469,52,'Usti nad Orlici','east Bohemia',139012,59,41,8,3,10,61.90,8363,2.52,3.49,108,2564,2799);
insert into tab_district values (5470,65,'Znojmo','south Moravia',114200,101,41,4,1,4,43.70,8403,5.74,5.72,105,2157,2718);
insert into tab_district values (5479,1,'Hl.m. Praha','Prague',1204953,0,0,0,1,1,100.00,12541,0.29,0.43,167,85677,99107);
insert into tab_district values (5482,51,'Trutnov','east Bohemia',121947,37,28,7,3,11,70.50,8541,2.51,2.97,131,3496,3839);
insert into tab_district values (5482,51,'Trutnov','east Bohemia',121947,37,28,7,3,11,70.50,8541,2.51,2.97,131,3496,3839);
insert into tab_district values (5486,6,'Kutna Hora','central Bohemia',77963,60,23,4,2,4,51.50,8546,2.95,4.02,126,2640,3120);
insert into tab_district values (5491,1,'Hl.m. Praha','Prague',1204953,0,0,0,1,1,100.00,12541,0.29,0.43,167,85677,99107);
insert into tab_district values (5491,1,'Hl.m. Praha','Prague',1204953,0,0,0,1,1,100.00,12541,0.29,0.43,167,85677,99107);
insert into tab_district values (5494,64,'Zlin','south Moravia',197099,29,41,10,2,10,74.70,9624,1.60,2.31,145,4484,4265);
insert into tab_district values (5495,60,'Prostejov','south Moravia',110643,49,41,4,1,4,51.90,8441,3.45,4.48,115,1879,2252);
insert into tab_district values (5495,60,'Prostejov','south Moravia',110643,49,41,4,1,4,51.90,8441,3.45,4.48,115,1879,2252);
insert into tab_district values (5501,1,'Hl.m. Praha','Prague',1204953,0,0,0,1,1,100.00,12541,0.29,0.43,167,85677,99107);
insert into tab_district values (5501,1,'Hl.m. Praha','Prague',1204953,0,0,0,1,1,100.00,12541,0.29,0.43,167,85677,99107);
insert into tab_district values (5519,52,'Usti nad Orlici','east Bohemia',139012,59,41,8,3,10,61.90,8363,2.52,3.49,108,2564,2799);
insert into tab_district values (5519,52,'Usti nad Orlici','east Bohemia',139012,59,41,8,3,10,61.90,8363,2.52,3.49,108,2564,2799);
insert into tab_district values (5520,73,'Opava','north Moravia',182027,17,49,12,2,7,56.40,8746,3.33,3.74,90,4355,4433);
insert into tab_district values (5523,63,'Vyskov','south Moravia',86513,38,36,5,1,5,50.50,8288,3.79,4.52,110,1562,1460);
insert into tab_district values (5525,2,'Benesov','central Bohemia',88884,80,26,6,2,5,46.70,8507,1.67,1.85,132,2159,2674);
insert into tab_district values (5525,2,'Benesov','central Bohemia',88884,80,26,6,2,5,46.70,8507,1.67,1.85,132,2159,2674);
insert into tab_district values (5526,52,'Usti nad Orlici','east Bohemia',139012,59,41,8,3,10,61.90,8363,2.52,3.49,108,2564,2799);
insert into tab_district values (5527,52,'Usti nad Orlici','east Bohemia',139012,59,41,8,3,10,61.90,8363,2.52,3.49,108,2564,2799);
insert into tab_district values (5531,26,'Plzen - mesto','west Bohemia',170449,0,0,0,1,1,100.00,10787,2.64,3.09,131,6041,6261);
insert into tab_district values (5531,26,'Plzen - mesto','west Bohemia',170449,0,0,0,1,1,100.00,10787,2.64,3.09,131,6041,6261);
insert into tab_district values (5532,57,'Hodonin','south Moravia',161954,21,37,20,3,8,48.00,8720,3.73,4.50,116,3729,3651);
insert into tab_district values (5533,11,'Praha - zapad','central Bohemia',75637,35,36,9,0,7,36.50,9622,0.45,0.59,154,3475,3529);
insert into tab_district values (5549,11,'Praha - zapad','central Bohemia',75637,35,36,9,0,7,36.50,9622,0.45,0.59,154,3475,3529);
insert into tab_district values (5556,1,'Hl.m. Praha','Prague',1204953,0,0,0,1,1,100.00,12541,0.29,0.43,167,85677,99107);
insert into tab_district values (5561,68,'Frydek - Mistek','north Moravia',228848,15,40,18,2,6,57.20,9893,4.09,4.72,96,5623,5887);
insert into tab_district values (5563,74,'Ostrava - mesto','north Moravia',323870,0,0,0,1,1,100.00,10673,4.75,5.44,100,18782,18347);
insert into tab_district values (5568,10,'Praha - vychod','central Bohemia',92084,55,29,4,3,5,46.70,10124,0.56,0.54,141,3810,4316);
insert into tab_district values (5568,10,'Praha - vychod','central Bohemia',92084,55,29,4,3,5,46.70,10124,0.56,0.54,141,3810,4316);
insert into tab_district values (5569,3,'Beroun','central Bohemia',75232,55,26,4,1,5,41.70,8980,1.95,2.21,111,2824,2813);
insert into tab_district values (5576,1,'Hl.m. Praha','Prague',1204953,0,0,0,1,1,100.00,12541,0.29,0.43,167,85677,99107);
insert into tab_district values (5582,19,'Prachatice','south Bohemia',51428,50,11,3,1,4,52.70,8402,3.13,3.98,120,999,1099);
insert into tab_district values (5582,19,'Prachatice','south Bohemia',51428,50,11,3,1,4,52.70,8402,3.13,3.98,120,999,1099);
insert into tab_district values (5584,63,'Vyskov','south Moravia',86513,38,36,5,1,5,50.50,8288,3.79,4.52,110,1562,1460);
insert into tab_district values (5585,66,'Zdar nad Sazavou','south Moravia',125832,151,41,2,3,5,48.30,8512,3.51,4.12,102,2247,2103);
insert into tab_district values (5585,66,'Zdar nad Sazavou','south Moravia',125832,151,41,2,3,5,48.30,8512,3.51,4.12,102,2247,2103);
insert into tab_district values (5586,77,'Vsetin','north Moravia',148545,8,35,12,3,4,53.50,8909,4.01,5.56,113,3460,3590);
insert into tab_district values (5589,42,'Havlickuv Brod','east Bohemia',95907,87,25,5,2,7,59.10,8388,2.41,2.94,87,1658,1668);
insert into tab_district values (5591,10,'Praha - vychod','central Bohemia',92084,55,29,4,3,5,46.70,10124,0.56,0.54,141,3810,4316);
insert into tab_district values (5593,44,'Chrudim','east Bohemia',105606,77,26,7,2,7,53.00,8254,2.79,3.76,97,2166,2325);
insert into tab_district values (5595,49,'Semily','east Bohemia',75685,31,28,5,1,9,60.80,8208,1.89,2.26,155,1660,2123);
insert into tab_district values (5595,49,'Semily','east Bohemia',75685,31,28,5,1,9,60.80,8208,1.89,2.26,155,1660,2123);
insert into tab_district values (5599,1,'Hl.m. Praha','Prague',1204953,0,0,0,1,1,100.00,12541,0.29,0.43,167,85677,99107);
insert into tab_district values (5606,59,'Kromeriz','south Moravia',108871,41,29,7,2,6,62.10,8444,3.24,3.47,106,2595,2305);
insert into tab_district values (5610,38,'Louny','north Bohemia',85852,41,23,4,2,4,59.80,8965,7.08,8.23,104,2653,2822);
insert into tab_district values (5610,38,'Louny','north Bohemia',85852,41,23,4,2,4,59.80,8965,7.08,8.23,104,2653,2822);
insert into tab_district values (5611,14,'Ceske Budejovice','south Bohemia',177686,69,27,10,1,9,74.80,10045,1.42,1.71,135,6604,6295);
insert into tab_district values (5611,14,'Ceske Budejovice','south Bohemia',177686,69,27,10,1,9,74.80,10045,1.42,1.71,135,6604,6295);
insert into tab_district values (5614,39,'Most','north Bohemia',119895,17,4,3,2,4,89.90,10446,7.34,9.40,90,4947,4743);
insert into tab_district values (5616,38,'Louny','north Bohemia',85852,41,23,4,2,4,59.80,8965,7.08,8.23,104,2653,2822);
insert into tab_district values (5616,38,'Louny','north Bohemia',85852,41,23,4,2,4,59.80,8965,7.08,8.23,104,2653,2822);
insert into tab_district values (5620,48,'Rychnov nad Kneznou','east Bohemia',78955,50,24,8,1,9,59.00,9060,1.78,2.44,124,1655,1717);
insert into tab_district values (5624,59,'Kromeriz','south Moravia',108871,41,29,7,2,6,62.10,8444,3.24,3.47,106,2595,2305);
insert into tab_district values (5625,29,'Rokycany','west Bohemia',45714,52,10,5,1,6,55.60,8843,2.82,3.60,113,818,888);
insert into tab_district values (5634,64,'Zlin','south Moravia',197099,29,41,10,2,10,74.70,9624,1.60,2.31,145,4484,4265);
insert into tab_district values (5635,1,'Hl.m. Praha','Prague',1204953,0,0,0,1,1,100.00,12541,0.29,0.43,167,85677,99107);
insert into tab_district values (5638,74,'Ostrava - mesto','north Moravia',323870,0,0,0,1,1,100.00,10673,4.75,5.44,100,18782,18347);
insert into tab_district values (5643,74,'Ostrava - mesto','north Moravia',323870,0,0,0,1,1,100.00,10673,4.75,5.44,100,18782,18347);
insert into tab_district values (5644,1,'Hl.m. Praha','Prague',1204953,0,0,0,1,1,100.00,12541,0.29,0.43,167,85677,99107);
insert into tab_district values (5651,3,'Beroun','central Bohemia',75232,55,26,4,1,5,41.70,8980,1.95,2.21,111,2824,2813);
insert into tab_district values (5651,3,'Beroun','central Bohemia',75232,55,26,4,1,5,41.70,8980,1.95,2.21,111,2824,2813);
insert into tab_district values (5656,74,'Ostrava - mesto','north Moravia',323870,0,0,0,1,1,100.00,10673,4.75,5.44,100,18782,18347);
insert into tab_district values (5657,63,'Vyskov','south Moravia',86513,38,36,5,1,5,50.50,8288,3.79,4.52,110,1562,1460);
insert into tab_district values (5665,12,'Pribram','central Bohemia',107870,84,29,6,1,6,58.00,8754,3.83,4.31,137,3804,3868);
insert into tab_district values (5669,63,'Vyskov','south Moravia',86513,38,36,5,1,5,50.50,8288,3.79,4.52,110,1562,1460);
insert into tab_district values (5674,42,'Havlickuv Brod','east Bohemia',95907,87,25,5,2,7,59.10,8388,2.41,2.94,87,1658,1668);
insert into tab_district values (5674,42,'Havlickuv Brod','east Bohemia',95907,87,25,5,2,7,59.10,8388,2.41,2.94,87,1658,1668);
insert into tab_district values (5681,58,'Jihlava','south Moravia',109164,98,16,6,1,4,63.60,8757,3.38,3.95,96,2212,2471);
insert into tab_district values (5681,58,'Jihlava','south Moravia',109164,98,16,6,1,4,63.60,8757,3.38,3.95,96,2212,2471);
insert into tab_district values (5682,34,'Chomutov','north Bohemia',125236,28,11,1,4,5,87.70,9675,6.43,7.68,100,5323,5190);
insert into tab_district values (5683,16,'Jindrichuv Hradec','south Bohemia',93931,74,21,10,1,8,56.90,8427,1.12,1.54,107,1874,1913);
insert into tab_district values (5683,16,'Jindrichuv Hradec','south Bohemia',93931,74,21,10,1,8,56.90,8427,1.12,1.54,107,1874,1913);
insert into tab_district values (5693,9,'Nymburk','central Bohemia',81344,61,23,4,2,6,55.30,8899,3.39,3.97,149,2987,2487);
insert into tab_district values (5698,58,'Jihlava','south Moravia',109164,98,16,6,1,4,63.60,8757,3.38,3.95,96,2212,2471);
insert into tab_district values (5699,50,'Svitavy','east Bohemia',102609,75,33,2,3,6,52.00,8187,4.83,5.45,94,2123,2134);
insert into tab_district values (5706,72,'Olomouc','north Moravia',226122,32,50,7,4,4,62.60,8994,3.80,4.79,110,9672,9208);
insert into tab_district values (5713,48,'Rychnov nad Kneznou','east Bohemia',78955,50,24,8,1,9,59.00,9060,1.78,2.44,124,1655,1717);
insert into tab_district values (5718,53,'Blansko','south Moravia',107911,88,33,6,2,7,50.90,8240,2.53,3.56,99,1850,1903);
insert into tab_district values (5719,1,'Hl.m. Praha','Prague',1204953,0,0,0,1,1,100.00,12541,0.29,0.43,167,85677,99107);
insert into tab_district values (5723,38,'Louny','north Bohemia',85852,41,23,4,2,4,59.80,8965,7.08,8.23,104,2653,2822);
insert into tab_district values (5724,1,'Hl.m. Praha','Prague',1204953,0,0,0,1,1,100.00,12541,0.29,0.43,167,85677,99107);
insert into tab_district values (5725,64,'Zlin','south Moravia',197099,29,41,10,2,10,74.70,9624,1.60,2.31,145,4484,4265);
insert into tab_district values (5725,64,'Zlin','south Moravia',197099,29,41,10,2,10,74.70,9624,1.60,2.31,145,4484,4265);
insert into tab_district values (5731,3,'Beroun','central Bohemia',75232,55,26,4,1,5,41.70,8980,1.95,2.21,111,2824,2813);
insert into tab_district values (5739,1,'Hl.m. Praha','Prague',1204953,0,0,0,1,1,100.00,12541,0.29,0.43,167,85677,99107);
insert into tab_district values (5740,1,'Hl.m. Praha','Prague',1204953,0,0,0,1,1,100.00,12541,0.29,0.43,167,85677,99107);
insert into tab_district values (5741,37,'Litomerice','north Bohemia',114006,71,26,6,2,9,62.30,9065,4.46,5.39,123,4147,4166);
insert into tab_district values (5741,37,'Litomerice','north Bohemia',114006,71,26,6,2,9,62.30,9065,4.46,5.39,123,4147,4166);
insert into tab_district values (5750,7,'Melnik','central Bohemia',94725,38,28,1,3,6,63.40,9920,2.26,2.87,130,4289,4846);
insert into tab_district values (5754,54,'Brno - mesto','south Moravia',387570,0,0,0,1,1,100.00,9897,1.60,1.96,140,18721,18696);
insert into tab_district values (5754,54,'Brno - mesto','south Moravia',387570,0,0,0,1,1,100.00,9897,1.60,1.96,140,18721,18696);
insert into tab_district values (5758,53,'Blansko','south Moravia',107911,88,33,6,2,7,50.90,8240,2.53,3.56,99,1850,1903);
insert into tab_district values (5760,1,'Hl.m. Praha','Prague',1204953,0,0,0,1,1,100.00,12541,0.29,0.43,167,85677,99107);
insert into tab_district values (5765,44,'Chrudim','east Bohemia',105606,77,26,7,2,7,53.00,8254,2.79,3.76,97,2166,2325);
insert into tab_district values (5772,52,'Usti nad Orlici','east Bohemia',139012,59,41,8,3,10,61.90,8363,2.52,3.49,108,2564,2799);
insert into tab_district values (5772,52,'Usti nad Orlici','east Bohemia',139012,59,41,8,3,10,61.90,8363,2.52,3.49,108,2564,2799);
insert into tab_district values (5773,37,'Litomerice','north Bohemia',114006,71,26,6,2,9,62.30,9065,4.46,5.39,123,4147,4166);
insert into tab_district values (5774,8,'Mlada Boleslav','central Bohemia',112065,95,19,7,1,8,69.40,11277,1.25,1.44,127,5179,4987);
insert into tab_district values (5779,27,'Plzen - jih','west Bohemia',67298,71,19,10,0,7,43.80,8561,0.65,1.29,110,1029,1127);
insert into tab_district values (5782,1,'Hl.m. Praha','Prague',1204953,0,0,0,1,1,100.00,12541,0.29,0.43,167,85677,99107);
insert into tab_district values (5784,54,'Brno - mesto','south Moravia',387570,0,0,0,1,1,100.00,9897,1.60,1.96,140,18721,18696);
insert into tab_district values (5790,57,'Hodonin','south Moravia',161954,21,37,20,3,8,48.00,8720,3.73,4.50,116,3729,3651);
insert into tab_district values (5799,36,'Liberec','north Bohemia',159617,29,19,8,1,9,85.20,9198,3.33,4.28,131,5796,6132);
insert into tab_district values (5804,52,'Usti nad Orlici','east Bohemia',139012,59,41,8,3,10,61.90,8363,2.52,3.49,108,2564,2799);
insert into tab_district values (5805,11,'Praha - zapad','central Bohemia',75637,35,36,9,0,7,36.50,9622,0.45,0.59,154,3475,3529);
insert into tab_district values (5808,54,'Brno - mesto','south Moravia',387570,0,0,0,1,1,100.00,9897,1.60,1.96,140,18721,18696);
insert into tab_district values (5815,6,'Kutna Hora','central Bohemia',77963,60,23,4,2,4,51.50,8546,2.95,4.02,126,2640,3120);
insert into tab_district values (5817,50,'Svitavy','east Bohemia',102609,75,33,2,3,6,52.00,8187,4.83,5.45,94,2123,2134);
insert into tab_district values (5823,1,'Hl.m. Praha','Prague',1204953,0,0,0,1,1,100.00,12541,0.29,0.43,167,85677,99107);
insert into tab_district values (5823,1,'Hl.m. Praha','Prague',1204953,0,0,0,1,1,100.00,12541,0.29,0.43,167,85677,99107);
insert into tab_district values (5830,62,'Uherske Hradiste','south Moravia',145688,22,41,13,2,5,40.70,8544,1.29,1.86,109,2719,2906);
insert into tab_district values (5836,66,'Zdar nad Sazavou','south Moravia',125832,151,41,2,3,5,48.30,8512,3.51,4.12,102,2247,2103);
insert into tab_district values (5837,58,'Jihlava','south Moravia',109164,98,16,6,1,4,63.60,8757,3.38,3.95,96,2212,2471);
insert into tab_district values (5841,77,'Vsetin','north Moravia',148545,8,35,12,3,4,53.50,8909,4.01,5.56,113,3460,3590);
insert into tab_district values (5841,77,'Vsetin','north Moravia',148545,8,35,12,3,4,53.50,8909,4.01,5.56,113,3460,3590);
insert into tab_district values (5850,64,'Zlin','south Moravia',197099,29,41,10,2,10,74.70,9624,1.60,2.31,145,4484,4265);
insert into tab_district values (5856,61,'Trebic','south Moravia',117897,139,28,5,1,6,53.80,8814,4.76,5.74,107,2112,2059);
insert into tab_district values (5861,29,'Rokycany','west Bohemia',45714,52,10,5,1,6,55.60,8843,2.82,3.60,113,818,888);
insert into tab_district values (5862,74,'Ostrava - mesto','north Moravia',323870,0,0,0,1,1,100.00,10673,4.75,5.44,100,18782,18347);
insert into tab_district values (5865,38,'Louny','north Bohemia',85852,41,23,4,2,4,59.80,8965,7.08,8.23,104,2653,2822);
insert into tab_district values (5868,69,'Jesenik','north Moravia',42821,4,13,5,1,3,48.40,8173,NULL,7.01,124,NULL,1358);
insert into tab_district values (5868,69,'Jesenik','north Moravia',42821,4,13,5,1,3,48.40,8173,NULL,7.01,124,NULL,1358);
insert into tab_district values (5876,74,'Ostrava - mesto','north Moravia',323870,0,0,0,1,1,100.00,10673,4.75,5.44,100,18782,18347);
insert into tab_district values (5876,74,'Ostrava - mesto','north Moravia',323870,0,0,0,1,1,100.00,10673,4.75,5.44,100,18782,18347);
insert into tab_district values (5877,17,'Pelhrimov','south Bohemia',74062,99,15,4,2,7,61.40,8114,2.38,2.62,119,1003,1181);
insert into tab_district values (5877,17,'Pelhrimov','south Bohemia',74062,99,15,4,2,7,61.40,8114,2.38,2.62,119,1003,1181);
insert into tab_district values (5878,73,'Opava','north Moravia',182027,17,49,12,2,7,56.40,8746,3.33,3.74,90,4355,4433);
insert into tab_district values (5880,39,'Most','north Bohemia',119895,17,4,3,2,4,89.90,10446,7.34,9.40,90,4947,4743);
insert into tab_district values (5882,1,'Hl.m. Praha','Prague',1204953,0,0,0,1,1,100.00,12541,0.29,0.43,167,85677,99107);
insert into tab_district values (5882,1,'Hl.m. Praha','Prague',1204953,0,0,0,1,1,100.00,12541,0.29,0.43,167,85677,99107);
insert into tab_district values (5886,62,'Uherske Hradiste','south Moravia',145688,22,41,13,2,5,40.70,8544,1.29,1.86,109,2719,2906);
insert into tab_district values (5886,62,'Uherske Hradiste','south Moravia',145688,22,41,13,2,5,40.70,8544,1.29,1.86,109,2719,2906);
insert into tab_district values (5887,60,'Prostejov','south Moravia',110643,49,41,4,1,4,51.90,8441,3.45,4.48,115,1879,2252);
insert into tab_district values (5887,60,'Prostejov','south Moravia',110643,49,41,4,1,4,51.90,8441,3.45,4.48,115,1879,2252);
insert into tab_district values (5889,14,'Ceske Budejovice','south Bohemia',177686,69,27,10,1,9,74.80,10045,1.42,1.71,135,6604,6295);
insert into tab_district values (5892,73,'Opava','north Moravia',182027,17,49,12,2,7,56.40,8746,3.33,3.74,90,4355,4433);
insert into tab_district values (5893,17,'Pelhrimov','south Bohemia',74062,99,15,4,2,7,61.40,8114,2.38,2.62,119,1003,1181);
insert into tab_district values (5895,45,'Jicin','east Bohemia',77917,85,19,6,1,5,53.50,8390,2.28,2.89,132,2080,2122);
insert into tab_district values (5897,24,'Karlovy Vary','west Bohemia',122603,25,21,6,2,8,80.00,8991,1.39,2.01,128,5198,5273);
insert into tab_district values (5900,50,'Svitavy','east Bohemia',102609,75,33,2,3,6,52.00,8187,4.83,5.45,94,2123,2134);
insert into tab_district values (5906,68,'Frydek - Mistek','north Moravia',228848,15,40,18,2,6,57.20,9893,4.09,4.72,96,5623,5887);
insert into tab_district values (5909,56,'Breclav','south Moravia',124605,11,42,14,1,8,46.00,8772,4.69,4.98,126,2854,3158);
insert into tab_district values (5918,57,'Hodonin','south Moravia',161954,21,37,20,3,8,48.00,8720,3.73,4.50,116,3729,3651);
insert into tab_district values (5922,9,'Nymburk','central Bohemia',81344,61,23,4,2,6,55.30,8899,3.39,3.97,149,2987,2487);
insert into tab_district values (5923,27,'Plzen - jih','west Bohemia',67298,71,19,10,0,7,43.80,8561,0.65,1.29,110,1029,1127);
insert into tab_district values (5923,27,'Plzen - jih','west Bohemia',67298,71,19,10,0,7,43.80,8561,0.65,1.29,110,1029,1127);
insert into tab_district values (5930,1,'Hl.m. Praha','Prague',1204953,0,0,0,1,1,100.00,12541,0.29,0.43,167,85677,99107);
insert into tab_district values (5931,3,'Beroun','central Bohemia',75232,55,26,4,1,5,41.70,8980,1.95,2.21,111,2824,2813);
insert into tab_district values (5932,9,'Nymburk','central Bohemia',81344,61,23,4,2,6,55.30,8899,3.39,3.97,149,2987,2487);
insert into tab_district values (5933,77,'Vsetin','north Moravia',148545,8,35,12,3,4,53.50,8909,4.01,5.56,113,3460,3590);
insert into tab_district values (5933,77,'Vsetin','north Moravia',148545,8,35,12,3,4,53.50,8909,4.01,5.56,113,3460,3590);
insert into tab_district values (5938,4,'Kladno','central Bohemia',149893,63,29,6,2,6,67.40,9753,4.64,5.05,109,5244,5892);
insert into tab_district values (5940,63,'Vyskov','south Moravia',86513,38,36,5,1,5,50.50,8288,3.79,4.52,110,1562,1460);
insert into tab_district values (5942,70,'Karvina','north Moravia',285387,0,2,8,5,7,89.90,10177,6.63,7.75,81,9878,10108);
insert into tab_district values (5953,8,'Mlada Boleslav','central Bohemia',112065,95,19,7,1,8,69.40,11277,1.25,1.44,127,5179,4987);
insert into tab_district values (5956,73,'Opava','north Moravia',182027,17,49,12,2,7,56.40,8746,3.33,3.74,90,4355,4433);
insert into tab_district values (5959,2,'Benesov','central Bohemia',88884,80,26,6,2,5,46.70,8507,1.67,1.85,132,2159,2674);
insert into tab_district values (5963,54,'Brno - mesto','south Moravia',387570,0,0,0,1,1,100.00,9897,1.60,1.96,140,18721,18696);
insert into tab_district values (5970,66,'Zdar nad Sazavou','south Moravia',125832,151,41,2,3,5,48.30,8512,3.51,4.12,102,2247,2103);
insert into tab_district values (5970,66,'Zdar nad Sazavou','south Moravia',125832,151,41,2,3,5,48.30,8512,3.51,4.12,102,2247,2103);
insert into tab_district values (5973,46,'Nachod','east Bohemia',112709,48,20,7,3,10,73.50,8369,1.79,2.31,117,2854,2618);
insert into tab_district values (5973,46,'Nachod','east Bohemia',112709,48,20,7,3,10,73.50,8369,1.79,2.31,117,2854,2618);
insert into tab_district values (5976,72,'Olomouc','north Moravia',226122,32,50,7,4,4,62.60,8994,3.80,4.79,110,9672,9208);
insert into tab_district values (5977,26,'Plzen - mesto','west Bohemia',170449,0,0,0,1,1,100.00,10787,2.64,3.09,131,6041,6261);
insert into tab_district values (5980,15,'Cesky Krumlov','south Bohemia',58796,22,16,7,1,5,51.90,9045,3.13,3.60,124,1845,1879);
insert into tab_district values (5980,15,'Cesky Krumlov','south Bohemia',58796,22,16,7,1,5,51.90,9045,3.13,3.60,124,1845,1879);
insert into tab_district values (5988,52,'Usti nad Orlici','east Bohemia',139012,59,41,8,3,10,61.90,8363,2.52,3.49,108,2564,2799);
insert into tab_district values (5988,52,'Usti nad Orlici','east Bohemia',139012,59,41,8,3,10,61.90,8363,2.52,3.49,108,2564,2799);
insert into tab_district values (5989,47,'Pardubice','east Bohemia',162580,83,26,5,1,6,72.80,9538,1.51,1.81,111,6079,5410);
insert into tab_district values (5991,67,'Bruntal','north Moravia',106054,38,25,6,2,6,63.10,8110,5.77,6.55,109,3244,3079);
insert into tab_district values (5992,5,'Kolin','central Bohemia',95616,65,30,4,1,6,51.40,9307,3.85,4.43,118,2616,3040);
insert into tab_district values (5997,14,'Ceske Budejovice','south Bohemia',177686,69,27,10,1,9,74.80,10045,1.42,1.71,135,6604,6295);
insert into tab_district values (5999,42,'Havlickuv Brod','east Bohemia',95907,87,25,5,2,7,59.10,8388,2.41,2.94,87,1658,1668);
insert into tab_district values (6004,50,'Svitavy','east Bohemia',102609,75,33,2,3,6,52.00,8187,4.83,5.45,94,2123,2134);
insert into tab_district values (6006,43,'Hradec Kralove','east Bohemia',161854,73,21,6,1,6,76.30,9425,1.72,2.50,125,4085,3891);
insert into tab_district values (6007,33,'Decin','north Bohemia',133777,24,17,7,3,11,84.70,8705,5.75,7.61,116,4650,4859);
insert into tab_district values (6010,60,'Prostejov','south Moravia',110643,49,41,4,1,4,51.90,8441,3.45,4.48,115,1879,2252);
insert into tab_district values (6011,54,'Brno - mesto','south Moravia',387570,0,0,0,1,1,100.00,9897,1.60,1.96,140,18721,18696);
insert into tab_district values (6012,1,'Hl.m. Praha','Prague',1204953,0,0,0,1,1,100.00,12541,0.29,0.43,167,85677,99107);
insert into tab_district values (6013,20,'Strakonice','south Bohemia',70646,94,14,3,1,4,58.40,8547,2.65,3.64,120,1563,1542);
insert into tab_district values (6014,1,'Hl.m. Praha','Prague',1204953,0,0,0,1,1,100.00,12541,0.29,0.43,167,85677,99107);
insert into tab_district values (6014,1,'Hl.m. Praha','Prague',1204953,0,0,0,1,1,100.00,12541,0.29,0.43,167,85677,99107);
insert into tab_district values (6015,53,'Blansko','south Moravia',107911,88,33,6,2,7,50.90,8240,2.53,3.56,99,1850,1903);
insert into tab_district values (6019,54,'Brno - mesto','south Moravia',387570,0,0,0,1,1,100.00,9897,1.60,1.96,140,18721,18696);
insert into tab_district values (6027,13,'Rakovnik','central Bohemia',53921,61,22,1,1,2,41.30,8598,2.77,3.26,123,1597,1875);
insert into tab_district values (6028,6,'Kutna Hora','central Bohemia',77963,60,23,4,2,4,51.50,8546,2.95,4.02,126,2640,3120);
insert into tab_district values (6037,72,'Olomouc','north Moravia',226122,32,50,7,4,4,62.60,8994,3.80,4.79,110,9672,9208);
insert into tab_district values (6038,1,'Hl.m. Praha','Prague',1204953,0,0,0,1,1,100.00,12541,0.29,0.43,167,85677,99107);
insert into tab_district values (6043,58,'Jihlava','south Moravia',109164,98,16,6,1,4,63.60,8757,3.38,3.95,96,2212,2471);
insert into tab_district values (6043,58,'Jihlava','south Moravia',109164,98,16,6,1,4,63.60,8757,3.38,3.95,96,2212,2471);
insert into tab_district values (6044,68,'Frydek - Mistek','north Moravia',228848,15,40,18,2,6,57.20,9893,4.09,4.72,96,5623,5887);
insert into tab_district values (6052,5,'Kolin','central Bohemia',95616,65,30,4,1,6,51.40,9307,3.85,4.43,118,2616,3040);
insert into tab_district values (6054,54,'Brno - mesto','south Moravia',387570,0,0,0,1,1,100.00,9897,1.60,1.96,140,18721,18696);
insert into tab_district values (6054,54,'Brno - mesto','south Moravia',387570,0,0,0,1,1,100.00,9897,1.60,1.96,140,18721,18696);
insert into tab_district values (6055,75,'Prerov','north Moravia',138032,67,30,4,2,5,64.60,8819,5.38,5.66,99,4063,4505);
insert into tab_district values (6059,13,'Rakovnik','central Bohemia',53921,61,22,1,1,2,41.30,8598,2.77,3.26,123,1597,1875);
insert into tab_district values (6063,1,'Hl.m. Praha','Prague',1204953,0,0,0,1,1,100.00,12541,0.29,0.43,167,85677,99107);
insert into tab_district values (6064,55,'Brno - venkov','south Moravia',157042,49,70,18,0,9,33.90,8743,1.88,2.43,111,3659,3894);
insert into tab_district values (6066,77,'Vsetin','north Moravia',148545,8,35,12,3,4,53.50,8909,4.01,5.56,113,3460,3590);
insert into tab_district values (6066,77,'Vsetin','north Moravia',148545,8,35,12,3,4,53.50,8909,4.01,5.56,113,3460,3590);
insert into tab_district values (6072,72,'Olomouc','north Moravia',226122,32,50,7,4,4,62.60,8994,3.80,4.79,110,9672,9208);
insert into tab_district values (6073,64,'Zlin','south Moravia',197099,29,41,10,2,10,74.70,9624,1.60,2.31,145,4484,4265);
insert into tab_district values (6075,4,'Kladno','central Bohemia',149893,63,29,6,2,6,67.40,9753,4.64,5.05,109,5244,5892);
insert into tab_district values (6076,49,'Semily','east Bohemia',75685,31,28,5,1,9,60.80,8208,1.89,2.26,155,1660,2123);
insert into tab_district values (6077,44,'Chrudim','east Bohemia',105606,77,26,7,2,7,53.00,8254,2.79,3.76,97,2166,2325);
insert into tab_district values (6078,15,'Cesky Krumlov','south Bohemia',58796,22,16,7,1,5,51.90,9045,3.13,3.60,124,1845,1879);
insert into tab_district values (6083,47,'Pardubice','east Bohemia',162580,83,26,5,1,6,72.80,9538,1.51,1.81,111,6079,5410);
insert into tab_district values (6087,40,'Teplice','north Bohemia',128118,9,16,6,3,8,85.30,9317,6.49,7.07,97,6949,6872);
insert into tab_district values (6088,28,'Plzen - sever','west Bohemia',72541,66,26,10,0,8,36.90,8594,1.62,2.01,112,1580,1525);
insert into tab_district values (6095,4,'Kladno','central Bohemia',149893,63,29,6,2,6,67.40,9753,4.64,5.05,109,5244,5892);
insert into tab_district values (6097,76,'Sumperk','north Moravia',127369,31,32,13,2,7,51.20,8369,4.73,5.88,107,3736,2807);
insert into tab_district values (6097,76,'Sumperk','north Moravia',127369,31,32,13,2,7,51.20,8369,4.73,5.88,107,3736,2807);
insert into tab_district values (6103,44,'Chrudim','east Bohemia',105606,77,26,7,2,7,53.00,8254,2.79,3.76,97,2166,2325);
insert into tab_district values (6104,47,'Pardubice','east Bohemia',162580,83,26,5,1,6,72.80,9538,1.51,1.81,111,6079,5410);
insert into tab_district values (6109,66,'Zdar nad Sazavou','south Moravia',125832,151,41,2,3,5,48.30,8512,3.51,4.12,102,2247,2103);
insert into tab_district values (6109,66,'Zdar nad Sazavou','south Moravia',125832,151,41,2,3,5,48.30,8512,3.51,4.12,102,2247,2103);
insert into tab_district values (6111,24,'Karlovy Vary','west Bohemia',122603,25,21,6,2,8,80.00,8991,1.39,2.01,128,5198,5273);
insert into tab_district values (6112,5,'Kolin','central Bohemia',95616,65,30,4,1,6,51.40,9307,3.85,4.43,118,2616,3040);
insert into tab_district values (6113,72,'Olomouc','north Moravia',226122,32,50,7,4,4,62.60,8994,3.80,4.79,110,9672,9208);
insert into tab_district values (6118,57,'Hodonin','south Moravia',161954,21,37,20,3,8,48.00,8720,3.73,4.50,116,3729,3651);
insert into tab_district values (6120,1,'Hl.m. Praha','Prague',1204953,0,0,0,1,1,100.00,12541,0.29,0.43,167,85677,99107);
insert into tab_district values (6130,43,'Hradec Kralove','east Bohemia',161854,73,21,6,1,6,76.30,9425,1.72,2.50,125,4085,3891);
insert into tab_district values (6136,15,'Cesky Krumlov','south Bohemia',58796,22,16,7,1,5,51.90,9045,3.13,3.60,124,1845,1879);
insert into tab_district values (6137,13,'Rakovnik','central Bohemia',53921,61,22,1,1,2,41.30,8598,2.77,3.26,123,1597,1875);
insert into tab_district values (6142,9,'Nymburk','central Bohemia',81344,61,23,4,2,6,55.30,8899,3.39,3.97,149,2987,2487);
insert into tab_district values (6142,9,'Nymburk','central Bohemia',81344,61,23,4,2,6,55.30,8899,3.39,3.97,149,2987,2487);
insert into tab_district values (6144,15,'Cesky Krumlov','south Bohemia',58796,22,16,7,1,5,51.90,9045,3.13,3.60,124,1845,1879);
insert into tab_district values (6147,19,'Prachatice','south Bohemia',51428,50,11,3,1,4,52.70,8402,3.13,3.98,120,999,1099);
insert into tab_district values (6150,57,'Hodonin','south Moravia',161954,21,37,20,3,8,48.00,8720,3.73,4.50,116,3729,3651);
insert into tab_district values (6151,61,'Trebic','south Moravia',117897,139,28,5,1,6,53.80,8814,4.76,5.74,107,2112,2059);
insert into tab_district values (6153,5,'Kolin','central Bohemia',95616,65,30,4,1,6,51.40,9307,3.85,4.43,118,2616,3040);
insert into tab_district values (6153,5,'Kolin','central Bohemia',95616,65,30,4,1,6,51.40,9307,3.85,4.43,118,2616,3040);
insert into tab_district values (6157,10,'Praha - vychod','central Bohemia',92084,55,29,4,3,5,46.70,10124,0.56,0.54,141,3810,4316);
insert into tab_district values (6168,1,'Hl.m. Praha','Prague',1204953,0,0,0,1,1,100.00,12541,0.29,0.43,167,85677,99107);
insert into tab_district values (6168,1,'Hl.m. Praha','Prague',1204953,0,0,0,1,1,100.00,12541,0.29,0.43,167,85677,99107);
insert into tab_district values (6169,42,'Havlickuv Brod','east Bohemia',95907,87,25,5,2,7,59.10,8388,2.41,2.94,87,1658,1668);
insert into tab_district values (6173,14,'Ceske Budejovice','south Bohemia',177686,69,27,10,1,9,74.80,10045,1.42,1.71,135,6604,6295);
insert into tab_district values (6175,52,'Usti nad Orlici','east Bohemia',139012,59,41,8,3,10,61.90,8363,2.52,3.49,108,2564,2799);
insert into tab_district values (6178,74,'Ostrava - mesto','north Moravia',323870,0,0,0,1,1,100.00,10673,4.75,5.44,100,18782,18347);
insert into tab_district values (6185,1,'Hl.m. Praha','Prague',1204953,0,0,0,1,1,100.00,12541,0.29,0.43,167,85677,99107);
insert into tab_district values (6190,70,'Karvina','north Moravia',285387,0,2,8,5,7,89.90,10177,6.63,7.75,81,9878,10108);
insert into tab_district values (6190,70,'Karvina','north Moravia',285387,0,2,8,5,7,89.90,10177,6.63,7.75,81,9878,10108);
insert into tab_district values (6196,5,'Kolin','central Bohemia',95616,65,30,4,1,6,51.40,9307,3.85,4.43,118,2616,3040);
insert into tab_district values (6202,3,'Beroun','central Bohemia',75232,55,26,4,1,5,41.70,8980,1.95,2.21,111,2824,2813);
insert into tab_district values (6207,45,'Jicin','east Bohemia',77917,85,19,6,1,5,53.50,8390,2.28,2.89,132,2080,2122);
insert into tab_district values (6210,15,'Cesky Krumlov','south Bohemia',58796,22,16,7,1,5,51.90,9045,3.13,3.60,124,1845,1879);
insert into tab_district values (6215,27,'Plzen - jih','west Bohemia',67298,71,19,10,0,7,43.80,8561,0.65,1.29,110,1029,1127);
insert into tab_district values (6216,50,'Svitavy','east Bohemia',102609,75,33,2,3,6,52.00,8187,4.83,5.45,94,2123,2134);
insert into tab_district values (6223,57,'Hodonin','south Moravia',161954,21,37,20,3,8,48.00,8720,3.73,4.50,116,3729,3651);
insert into tab_district values (6227,47,'Pardubice','east Bohemia',162580,83,26,5,1,6,72.80,9538,1.51,1.81,111,6079,5410);
insert into tab_district values (6228,77,'Vsetin','north Moravia',148545,8,35,12,3,4,53.50,8909,4.01,5.56,113,3460,3590);
insert into tab_district values (6229,1,'Hl.m. Praha','Prague',1204953,0,0,0,1,1,100.00,12541,0.29,0.43,167,85677,99107);
insert into tab_district values (6232,56,'Breclav','south Moravia',124605,11,42,14,1,8,46.00,8772,4.69,4.98,126,2854,3158);
insert into tab_district values (6234,1,'Hl.m. Praha','Prague',1204953,0,0,0,1,1,100.00,12541,0.29,0.43,167,85677,99107);
insert into tab_district values (6235,24,'Karlovy Vary','west Bohemia',122603,25,21,6,2,8,80.00,8991,1.39,2.01,128,5198,5273);
insert into tab_district values (6237,19,'Prachatice','south Bohemia',51428,50,11,3,1,4,52.70,8402,3.13,3.98,120,999,1099);
insert into tab_district values (6239,6,'Kutna Hora','central Bohemia',77963,60,23,4,2,4,51.50,8546,2.95,4.02,126,2640,3120);
insert into tab_district values (6242,29,'Rokycany','west Bohemia',45714,52,10,5,1,6,55.60,8843,2.82,3.60,113,818,888);
insert into tab_district values (6244,1,'Hl.m. Praha','Prague',1204953,0,0,0,1,1,100.00,12541,0.29,0.43,167,85677,99107);
insert into tab_district values (6249,54,'Brno - mesto','south Moravia',387570,0,0,0,1,1,100.00,9897,1.60,1.96,140,18721,18696);
insert into tab_district values (6249,54,'Brno - mesto','south Moravia',387570,0,0,0,1,1,100.00,9897,1.60,1.96,140,18721,18696);
insert into tab_district values (6253,74,'Ostrava - mesto','north Moravia',323870,0,0,0,1,1,100.00,10673,4.75,5.44,100,18782,18347);
insert into tab_district values (6253,74,'Ostrava - mesto','north Moravia',323870,0,0,0,1,1,100.00,10673,4.75,5.44,100,18782,18347);
insert into tab_district values (6254,34,'Chomutov','north Bohemia',125236,28,11,1,4,5,87.70,9675,6.43,7.68,100,5323,5190);
insert into tab_district values (6255,67,'Bruntal','north Moravia',106054,38,25,6,2,6,63.10,8110,5.77,6.55,109,3244,3079);
insert into tab_district values (6272,74,'Ostrava - mesto','north Moravia',323870,0,0,0,1,1,100.00,10673,4.75,5.44,100,18782,18347);
insert into tab_district values (6278,5,'Kolin','central Bohemia',95616,65,30,4,1,6,51.40,9307,3.85,4.43,118,2616,3040);
insert into tab_district values (6279,38,'Louny','north Bohemia',85852,41,23,4,2,4,59.80,8965,7.08,8.23,104,2653,2822);
insert into tab_district values (6283,64,'Zlin','south Moravia',197099,29,41,10,2,10,74.70,9624,1.60,2.31,145,4484,4265);
insert into tab_district values (6294,26,'Plzen - mesto','west Bohemia',170449,0,0,0,1,1,100.00,10787,2.64,3.09,131,6041,6261);
insert into tab_district values (6296,3,'Beroun','central Bohemia',75232,55,26,4,1,5,41.70,8980,1.95,2.21,111,2824,2813);
insert into tab_district values (6297,12,'Pribram','central Bohemia',107870,84,29,6,1,6,58.00,8754,3.83,4.31,137,3804,3868);
insert into tab_district values (6302,48,'Rychnov nad Kneznou','east Bohemia',78955,50,24,8,1,9,59.00,9060,1.78,2.44,124,1655,1717);
insert into tab_district values (6302,48,'Rychnov nad Kneznou','east Bohemia',78955,50,24,8,1,9,59.00,9060,1.78,2.44,124,1655,1717);
insert into tab_district values (6303,31,'Tachov','west Bohemia',51313,34,12,3,1,4,59.20,8930,3.52,4.20,108,1328,1452);
insert into tab_district values (6306,70,'Karvina','north Moravia',285387,0,2,8,5,7,89.90,10177,6.63,7.75,81,9878,10108);
insert into tab_district values (6309,1,'Hl.m. Praha','Prague',1204953,0,0,0,1,1,100.00,12541,0.29,0.43,167,85677,99107);
insert into tab_district values (6310,1,'Hl.m. Praha','Prague',1204953,0,0,0,1,1,100.00,12541,0.29,0.43,167,85677,99107);
insert into tab_district values (6312,34,'Chomutov','north Bohemia',125236,28,11,1,4,5,87.70,9675,6.43,7.68,100,5323,5190);
insert into tab_district values (6313,50,'Svitavy','east Bohemia',102609,75,33,2,3,6,52.00,8187,4.83,5.45,94,2123,2134);
insert into tab_district values (6313,50,'Svitavy','east Bohemia',102609,75,33,2,3,6,52.00,8187,4.83,5.45,94,2123,2134);
insert into tab_district values (6315,61,'Trebic','south Moravia',117897,139,28,5,1,6,53.80,8814,4.76,5.74,107,2112,2059);
insert into tab_district values (6316,4,'Kladno','central Bohemia',149893,63,29,6,2,6,67.40,9753,4.64,5.05,109,5244,5892);
insert into tab_district values (6320,6,'Kutna Hora','central Bohemia',77963,60,23,4,2,4,51.50,8546,2.95,4.02,126,2640,3120);
insert into tab_district values (6321,7,'Melnik','central Bohemia',94725,38,28,1,3,6,63.40,9920,2.26,2.87,130,4289,4846);
insert into tab_district values (6322,74,'Ostrava - mesto','north Moravia',323870,0,0,0,1,1,100.00,10673,4.75,5.44,100,18782,18347);
insert into tab_district values (6336,38,'Louny','north Bohemia',85852,41,23,4,2,4,59.80,8965,7.08,8.23,104,2653,2822);
insert into tab_district values (6338,1,'Hl.m. Praha','Prague',1204953,0,0,0,1,1,100.00,12541,0.29,0.43,167,85677,99107);
insert into tab_district values (6342,16,'Jindrichuv Hradec','south Bohemia',93931,74,21,10,1,8,56.90,8427,1.12,1.54,107,1874,1913);
insert into tab_district values (6346,1,'Hl.m. Praha','Prague',1204953,0,0,0,1,1,100.00,12541,0.29,0.43,167,85677,99107);
insert into tab_district values (6350,54,'Brno - mesto','south Moravia',387570,0,0,0,1,1,100.00,9897,1.60,1.96,140,18721,18696);
insert into tab_district values (6353,61,'Trebic','south Moravia',117897,139,28,5,1,6,53.80,8814,4.76,5.74,107,2112,2059);
insert into tab_district values (6354,16,'Jindrichuv Hradec','south Bohemia',93931,74,21,10,1,8,56.90,8427,1.12,1.54,107,1874,1913);
insert into tab_district values (6355,35,'Jablonec n. Nisou','north Bohemia',88768,10,18,5,1,7,80.50,8867,1.02,1.21,130,3384,3620);
insert into tab_district values (6356,5,'Kolin','central Bohemia',95616,65,30,4,1,6,51.40,9307,3.85,4.43,118,2616,3040);
insert into tab_district values (6357,38,'Louny','north Bohemia',85852,41,23,4,2,4,59.80,8965,7.08,8.23,104,2653,2822);
insert into tab_district values (6358,72,'Olomouc','north Moravia',226122,32,50,7,4,4,62.60,8994,3.80,4.79,110,9672,9208);
insert into tab_district values (6362,62,'Uherske Hradiste','south Moravia',145688,22,41,13,2,5,40.70,8544,1.29,1.86,109,2719,2906);
insert into tab_district values (6377,1,'Hl.m. Praha','Prague',1204953,0,0,0,1,1,100.00,12541,0.29,0.43,167,85677,99107);
insert into tab_district values (6386,43,'Hradec Kralove','east Bohemia',161854,73,21,6,1,6,76.30,9425,1.72,2.50,125,4085,3891);
insert into tab_district values (6399,60,'Prostejov','south Moravia',110643,49,41,4,1,4,51.90,8441,3.45,4.48,115,1879,2252);
insert into tab_district values (6402,3,'Beroun','central Bohemia',75232,55,26,4,1,5,41.70,8980,1.95,2.21,111,2824,2813);
insert into tab_district values (6403,74,'Ostrava - mesto','north Moravia',323870,0,0,0,1,1,100.00,10673,4.75,5.44,100,18782,18347);
insert into tab_district values (6407,41,'Usti nad Labem','north Bohemia',118650,8,8,5,1,3,85.60,9832,3.32,4.48,114,6445,5471);
insert into tab_district values (6415,36,'Liberec','north Bohemia',159617,29,19,8,1,9,85.20,9198,3.33,4.28,131,5796,6132);
insert into tab_district values (6415,36,'Liberec','north Bohemia',159617,29,19,8,1,9,85.20,9198,3.33,4.28,131,5796,6132);
insert into tab_district values (6421,38,'Louny','north Bohemia',85852,41,23,4,2,4,59.80,8965,7.08,8.23,104,2653,2822);
insert into tab_district values (6421,38,'Louny','north Bohemia',85852,41,23,4,2,4,59.80,8965,7.08,8.23,104,2653,2822);
insert into tab_district values (6435,51,'Trutnov','east Bohemia',121947,37,28,7,3,11,70.50,8541,2.51,2.97,131,3496,3839);
insert into tab_district values (6436,69,'Jesenik','north Moravia',42821,4,13,5,1,3,48.40,8173,NULL,7.01,124,NULL,1358);
insert into tab_district values (6437,55,'Brno - venkov','south Moravia',157042,49,70,18,0,9,33.90,8743,1.88,2.43,111,3659,3894);
insert into tab_district values (6442,57,'Hodonin','south Moravia',161954,21,37,20,3,8,48.00,8720,3.73,4.50,116,3729,3651);
insert into tab_district values (6450,1,'Hl.m. Praha','Prague',1204953,0,0,0,1,1,100.00,12541,0.29,0.43,167,85677,99107);
insert into tab_district values (6456,46,'Nachod','east Bohemia',112709,48,20,7,3,10,73.50,8369,1.79,2.31,117,2854,2618);
insert into tab_district values (6460,55,'Brno - venkov','south Moravia',157042,49,70,18,0,9,33.90,8743,1.88,2.43,111,3659,3894);
insert into tab_district values (6460,55,'Brno - venkov','south Moravia',157042,49,70,18,0,9,33.90,8743,1.88,2.43,111,3659,3894);
insert into tab_district values (6461,12,'Pribram','central Bohemia',107870,84,29,6,1,6,58.00,8754,3.83,4.31,137,3804,3868);
insert into tab_district values (6464,71,'Novy Jicin','north Moravia',161227,5,35,11,4,10,69.70,8678,5.93,5.57,102,4980,4595);
insert into tab_district values (6468,1,'Hl.m. Praha','Prague',1204953,0,0,0,1,1,100.00,12541,0.29,0.43,167,85677,99107);
insert into tab_district values (6469,7,'Melnik','central Bohemia',94725,38,28,1,3,6,63.40,9920,2.26,2.87,130,4289,4846);
insert into tab_district values (6470,77,'Vsetin','north Moravia',148545,8,35,12,3,4,53.50,8909,4.01,5.56,113,3460,3590);
insert into tab_district values (6471,5,'Kolin','central Bohemia',95616,65,30,4,1,6,51.40,9307,3.85,4.43,118,2616,3040);
insert into tab_district values (6474,49,'Semily','east Bohemia',75685,31,28,5,1,9,60.80,8208,1.89,2.26,155,1660,2123);
insert into tab_district values (6474,49,'Semily','east Bohemia',75685,31,28,5,1,9,60.80,8208,1.89,2.26,155,1660,2123);
insert into tab_district values (6486,17,'Pelhrimov','south Bohemia',74062,99,15,4,2,7,61.40,8114,2.38,2.62,119,1003,1181);
insert into tab_district values (6486,17,'Pelhrimov','south Bohemia',74062,99,15,4,2,7,61.40,8114,2.38,2.62,119,1003,1181);
insert into tab_district values (6490,70,'Karvina','north Moravia',285387,0,2,8,5,7,89.90,10177,6.63,7.75,81,9878,10108);
insert into tab_district values (6495,11,'Praha - zapad','central Bohemia',75637,35,36,9,0,7,36.50,9622,0.45,0.59,154,3475,3529);
insert into tab_district values (6499,1,'Hl.m. Praha','Prague',1204953,0,0,0,1,1,100.00,12541,0.29,0.43,167,85677,99107);
insert into tab_district values (6499,1,'Hl.m. Praha','Prague',1204953,0,0,0,1,1,100.00,12541,0.29,0.43,167,85677,99107);
insert into tab_district values (6501,21,'Tabor','south Bohemia',103347,87,16,7,1,7,67.00,9104,1.51,2.07,123,2299,2354);
insert into tab_district values (6502,68,'Frydek - Mistek','north Moravia',228848,15,40,18,2,6,57.20,9893,4.09,4.72,96,5623,5887);
insert into tab_district values (6508,19,'Prachatice','south Bohemia',51428,50,11,3,1,4,52.70,8402,3.13,3.98,120,999,1099);
insert into tab_district values (6509,64,'Zlin','south Moravia',197099,29,41,10,2,10,74.70,9624,1.60,2.31,145,4484,4265);
insert into tab_district values (6512,31,'Tachov','west Bohemia',51313,34,12,3,1,4,59.20,8930,3.52,4.20,108,1328,1452);
insert into tab_district values (6520,39,'Most','north Bohemia',119895,17,4,3,2,4,89.90,10446,7.34,9.40,90,4947,4743);
insert into tab_district values (6520,39,'Most','north Bohemia',119895,17,4,3,2,4,89.90,10446,7.34,9.40,90,4947,4743);
insert into tab_district values (6526,63,'Vyskov','south Moravia',86513,38,36,5,1,5,50.50,8288,3.79,4.52,110,1562,1460);
insert into tab_district values (6534,54,'Brno - mesto','south Moravia',387570,0,0,0,1,1,100.00,9897,1.60,1.96,140,18721,18696);
insert into tab_district values (6535,43,'Hradec Kralove','east Bohemia',161854,73,21,6,1,6,76.30,9425,1.72,2.50,125,4085,3891);
insert into tab_district values (6539,56,'Breclav','south Moravia',124605,11,42,14,1,8,46.00,8772,4.69,4.98,126,2854,3158);
insert into tab_district values (6540,72,'Olomouc','north Moravia',226122,32,50,7,4,4,62.60,8994,3.80,4.79,110,9672,9208);
insert into tab_district values (6541,59,'Kromeriz','south Moravia',108871,41,29,7,2,6,62.10,8444,3.24,3.47,106,2595,2305);
insert into tab_district values (6544,16,'Jindrichuv Hradec','south Bohemia',93931,74,21,10,1,8,56.90,8427,1.12,1.54,107,1874,1913);
insert into tab_district values (6545,21,'Tabor','south Bohemia',103347,87,16,7,1,7,67.00,9104,1.51,2.07,123,2299,2354);
insert into tab_district values (6546,1,'Hl.m. Praha','Prague',1204953,0,0,0,1,1,100.00,12541,0.29,0.43,167,85677,99107);
insert into tab_district values (6546,1,'Hl.m. Praha','Prague',1204953,0,0,0,1,1,100.00,12541,0.29,0.43,167,85677,99107);
insert into tab_district values (6550,62,'Uherske Hradiste','south Moravia',145688,22,41,13,2,5,40.70,8544,1.29,1.86,109,2719,2906);
insert into tab_district values (6550,62,'Uherske Hradiste','south Moravia',145688,22,41,13,2,5,40.70,8544,1.29,1.86,109,2719,2906);
insert into tab_district values (6552,68,'Frydek - Mistek','north Moravia',228848,15,40,18,2,6,57.20,9893,4.09,4.72,96,5623,5887);
insert into tab_district values (6552,68,'Frydek - Mistek','north Moravia',228848,15,40,18,2,6,57.20,9893,4.09,4.72,96,5623,5887);
insert into tab_district values (6553,40,'Teplice','north Bohemia',128118,9,16,6,3,8,85.30,9317,6.49,7.07,97,6949,6872);
insert into tab_district values (6554,46,'Nachod','east Bohemia',112709,48,20,7,3,10,73.50,8369,1.79,2.31,117,2854,2618);
insert into tab_district values (6554,46,'Nachod','east Bohemia',112709,48,20,7,3,10,73.50,8369,1.79,2.31,117,2854,2618);
insert into tab_district values (6562,1,'Hl.m. Praha','Prague',1204953,0,0,0,1,1,100.00,12541,0.29,0.43,167,85677,99107);
insert into tab_district values (6568,50,'Svitavy','east Bohemia',102609,75,33,2,3,6,52.00,8187,4.83,5.45,94,2123,2134);
insert into tab_district values (6569,13,'Rakovnik','central Bohemia',53921,61,22,1,1,2,41.30,8598,2.77,3.26,123,1597,1875);
insert into tab_district values (6571,19,'Prachatice','south Bohemia',51428,50,11,3,1,4,52.70,8402,3.13,3.98,120,999,1099);
insert into tab_district values (6574,2,'Benesov','central Bohemia',88884,80,26,6,2,5,46.70,8507,1.67,1.85,132,2159,2674);
insert into tab_district values (6577,74,'Ostrava - mesto','north Moravia',323870,0,0,0,1,1,100.00,10673,4.75,5.44,100,18782,18347);
insert into tab_district values (6578,52,'Usti nad Orlici','east Bohemia',139012,59,41,8,3,10,61.90,8363,2.52,3.49,108,2564,2799);
insert into tab_district values (6580,23,'Cheb','west Bohemia',87419,21,11,4,3,9,85.50,8624,1.79,2.66,102,2879,3198);
insert into tab_district values (6585,64,'Zlin','south Moravia',197099,29,41,10,2,10,74.70,9624,1.60,2.31,145,4484,4265);
insert into tab_district values (6585,64,'Zlin','south Moravia',197099,29,41,10,2,10,74.70,9624,1.60,2.31,145,4484,4265);
insert into tab_district values (6589,19,'Prachatice','south Bohemia',51428,50,11,3,1,4,52.70,8402,3.13,3.98,120,999,1099);
insert into tab_district values (6589,19,'Prachatice','south Bohemia',51428,50,11,3,1,4,52.70,8402,3.13,3.98,120,999,1099);
insert into tab_district values (6591,38,'Louny','north Bohemia',85852,41,23,4,2,4,59.80,8965,7.08,8.23,104,2653,2822);
insert into tab_district values (6594,60,'Prostejov','south Moravia',110643,49,41,4,1,4,51.90,8441,3.45,4.48,115,1879,2252);
insert into tab_district values (6596,33,'Decin','north Bohemia',133777,24,17,7,3,11,84.70,8705,5.75,7.61,116,4650,4859);
insert into tab_district values (6598,35,'Jablonec n. Nisou','north Bohemia',88768,10,18,5,1,7,80.50,8867,1.02,1.21,130,3384,3620);
insert into tab_district values (6599,52,'Usti nad Orlici','east Bohemia',139012,59,41,8,3,10,61.90,8363,2.52,3.49,108,2564,2799);
insert into tab_district values (6599,52,'Usti nad Orlici','east Bohemia',139012,59,41,8,3,10,61.90,8363,2.52,3.49,108,2564,2799);
insert into tab_district values (6600,34,'Chomutov','north Bohemia',125236,28,11,1,4,5,87.70,9675,6.43,7.68,100,5323,5190);
insert into tab_district values (6605,23,'Cheb','west Bohemia',87419,21,11,4,3,9,85.50,8624,1.79,2.66,102,2879,3198);
insert into tab_district values (6607,27,'Plzen - jih','west Bohemia',67298,71,19,10,0,7,43.80,8561,0.65,1.29,110,1029,1127);
insert into tab_district values (6612,70,'Karvina','north Moravia',285387,0,2,8,5,7,89.90,10177,6.63,7.75,81,9878,10108);
insert into tab_district values (6612,70,'Karvina','north Moravia',285387,0,2,8,5,7,89.90,10177,6.63,7.75,81,9878,10108);
insert into tab_district values (6613,69,'Jesenik','north Moravia',42821,4,13,5,1,3,48.40,8173,NULL,7.01,124,NULL,1358);
insert into tab_district values (6621,51,'Trutnov','east Bohemia',121947,37,28,7,3,11,70.50,8541,2.51,2.97,131,3496,3839);
insert into tab_district values (6621,51,'Trutnov','east Bohemia',121947,37,28,7,3,11,70.50,8541,2.51,2.97,131,3496,3839);
insert into tab_district values (6624,55,'Brno - venkov','south Moravia',157042,49,70,18,0,9,33.90,8743,1.88,2.43,111,3659,3894);
insert into tab_district values (6624,55,'Brno - venkov','south Moravia',157042,49,70,18,0,9,33.90,8743,1.88,2.43,111,3659,3894);
insert into tab_district values (6625,54,'Brno - mesto','south Moravia',387570,0,0,0,1,1,100.00,9897,1.60,1.96,140,18721,18696);
insert into tab_district values (6632,9,'Nymburk','central Bohemia',81344,61,23,4,2,6,55.30,8899,3.39,3.97,149,2987,2487);
insert into tab_district values (6633,10,'Praha - vychod','central Bohemia',92084,55,29,4,3,5,46.70,10124,0.56,0.54,141,3810,4316);
insert into tab_district values (6641,36,'Liberec','north Bohemia',159617,29,19,8,1,9,85.20,9198,3.33,4.28,131,5796,6132);
insert into tab_district values (6642,27,'Plzen - jih','west Bohemia',67298,71,19,10,0,7,43.80,8561,0.65,1.29,110,1029,1127);
insert into tab_district values (6643,47,'Pardubice','east Bohemia',162580,83,26,5,1,6,72.80,9538,1.51,1.81,111,6079,5410);
insert into tab_district values (6644,9,'Nymburk','central Bohemia',81344,61,23,4,2,6,55.30,8899,3.39,3.97,149,2987,2487);
insert into tab_district values (6645,74,'Ostrava - mesto','north Moravia',323870,0,0,0,1,1,100.00,10673,4.75,5.44,100,18782,18347);
insert into tab_district values (6647,31,'Tachov','west Bohemia',51313,34,12,3,1,4,59.20,8930,3.52,4.20,108,1328,1452);
insert into tab_district values (6647,31,'Tachov','west Bohemia',51313,34,12,3,1,4,59.20,8930,3.52,4.20,108,1328,1452);
insert into tab_district values (6650,24,'Karlovy Vary','west Bohemia',122603,25,21,6,2,8,80.00,8991,1.39,2.01,128,5198,5273);
insert into tab_district values (6655,73,'Opava','north Moravia',182027,17,49,12,2,7,56.40,8746,3.33,3.74,90,4355,4433);
insert into tab_district values (6659,54,'Brno - mesto','south Moravia',387570,0,0,0,1,1,100.00,9897,1.60,1.96,140,18721,18696);
insert into tab_district values (6660,67,'Bruntal','north Moravia',106054,38,25,6,2,6,63.10,8110,5.77,6.55,109,3244,3079);
insert into tab_district values (6665,59,'Kromeriz','south Moravia',108871,41,29,7,2,6,62.10,8444,3.24,3.47,106,2595,2305);
insert into tab_district values (6667,37,'Litomerice','north Bohemia',114006,71,26,6,2,9,62.30,9065,4.46,5.39,123,4147,4166);
insert into tab_district values (6667,37,'Litomerice','north Bohemia',114006,71,26,6,2,9,62.30,9065,4.46,5.39,123,4147,4166);
insert into tab_district values (6668,45,'Jicin','east Bohemia',77917,85,19,6,1,5,53.50,8390,2.28,2.89,132,2080,2122);
insert into tab_district values (6675,48,'Rychnov nad Kneznou','east Bohemia',78955,50,24,8,1,9,59.00,9060,1.78,2.44,124,1655,1717);
insert into tab_district values (6676,26,'Plzen - mesto','west Bohemia',170449,0,0,0,1,1,100.00,10787,2.64,3.09,131,6041,6261);
insert into tab_district values (6676,26,'Plzen - mesto','west Bohemia',170449,0,0,0,1,1,100.00,10787,2.64,3.09,131,6041,6261);
insert into tab_district values (6677,29,'Rokycany','west Bohemia',45714,52,10,5,1,6,55.60,8843,2.82,3.60,113,818,888);
insert into tab_district values (6678,1,'Hl.m. Praha','Prague',1204953,0,0,0,1,1,100.00,12541,0.29,0.43,167,85677,99107);
insert into tab_district values (6678,1,'Hl.m. Praha','Prague',1204953,0,0,0,1,1,100.00,12541,0.29,0.43,167,85677,99107);
insert into tab_district values (6682,50,'Svitavy','east Bohemia',102609,75,33,2,3,6,52.00,8187,4.83,5.45,94,2123,2134);
insert into tab_district values (6686,31,'Tachov','west Bohemia',51313,34,12,3,1,4,59.20,8930,3.52,4.20,108,1328,1452);
insert into tab_district values (6686,31,'Tachov','west Bohemia',51313,34,12,3,1,4,59.20,8930,3.52,4.20,108,1328,1452);
insert into tab_district values (6687,13,'Rakovnik','central Bohemia',53921,61,22,1,1,2,41.30,8598,2.77,3.26,123,1597,1875);
insert into tab_district values (6687,13,'Rakovnik','central Bohemia',53921,61,22,1,1,2,41.30,8598,2.77,3.26,123,1597,1875);
insert into tab_district values (6688,59,'Kromeriz','south Moravia',108871,41,29,7,2,6,62.10,8444,3.24,3.47,106,2595,2305);
insert into tab_district values (6694,70,'Karvina','north Moravia',285387,0,2,8,5,7,89.90,10177,6.63,7.75,81,9878,10108);
insert into tab_district values (6695,51,'Trutnov','east Bohemia',121947,37,28,7,3,11,70.50,8541,2.51,2.97,131,3496,3839);
insert into tab_district values (6695,51,'Trutnov','east Bohemia',121947,37,28,7,3,11,70.50,8541,2.51,2.97,131,3496,3839);
insert into tab_district values (6696,77,'Vsetin','north Moravia',148545,8,35,12,3,4,53.50,8909,4.01,5.56,113,3460,3590);
insert into tab_district values (6696,77,'Vsetin','north Moravia',148545,8,35,12,3,4,53.50,8909,4.01,5.56,113,3460,3590);
insert into tab_district values (6698,1,'Hl.m. Praha','Prague',1204953,0,0,0,1,1,100.00,12541,0.29,0.43,167,85677,99107);
insert into tab_district values (6699,48,'Rychnov nad Kneznou','east Bohemia',78955,50,24,8,1,9,59.00,9060,1.78,2.44,124,1655,1717);
insert into tab_district values (6699,48,'Rychnov nad Kneznou','east Bohemia',78955,50,24,8,1,9,59.00,9060,1.78,2.44,124,1655,1717);
insert into tab_district values (6704,29,'Rokycany','west Bohemia',45714,52,10,5,1,6,55.60,8843,2.82,3.60,113,818,888);
insert into tab_district values (6704,29,'Rokycany','west Bohemia',45714,52,10,5,1,6,55.60,8843,2.82,3.60,113,818,888);
insert into tab_district values (6705,14,'Ceske Budejovice','south Bohemia',177686,69,27,10,1,9,74.80,10045,1.42,1.71,135,6604,6295);
insert into tab_district values (6712,20,'Strakonice','south Bohemia',70646,94,14,3,1,4,58.40,8547,2.65,3.64,120,1563,1542);
insert into tab_district values (6715,20,'Strakonice','south Bohemia',70646,94,14,3,1,4,58.40,8547,2.65,3.64,120,1563,1542);
insert into tab_district values (6721,17,'Pelhrimov','south Bohemia',74062,99,15,4,2,7,61.40,8114,2.38,2.62,119,1003,1181);
insert into tab_district values (6725,51,'Trutnov','east Bohemia',121947,37,28,7,3,11,70.50,8541,2.51,2.97,131,3496,3839);
insert into tab_district values (6725,51,'Trutnov','east Bohemia',121947,37,28,7,3,11,70.50,8541,2.51,2.97,131,3496,3839);
insert into tab_district values (6726,2,'Benesov','central Bohemia',88884,80,26,6,2,5,46.70,8507,1.67,1.85,132,2159,2674);
insert into tab_district values (6727,70,'Karvina','north Moravia',285387,0,2,8,5,7,89.90,10177,6.63,7.75,81,9878,10108);
insert into tab_district values (6729,23,'Cheb','west Bohemia',87419,21,11,4,3,9,85.50,8624,1.79,2.66,102,2879,3198);
insert into tab_district values (6729,23,'Cheb','west Bohemia',87419,21,11,4,3,9,85.50,8624,1.79,2.66,102,2879,3198);
insert into tab_district values (6730,54,'Brno - mesto','south Moravia',387570,0,0,0,1,1,100.00,9897,1.60,1.96,140,18721,18696);
insert into tab_district values (6732,47,'Pardubice','east Bohemia',162580,83,26,5,1,6,72.80,9538,1.51,1.81,111,6079,5410);
insert into tab_district values (6734,14,'Ceske Budejovice','south Bohemia',177686,69,27,10,1,9,74.80,10045,1.42,1.71,135,6604,6295);
insert into tab_district values (6736,1,'Hl.m. Praha','Prague',1204953,0,0,0,1,1,100.00,12541,0.29,0.43,167,85677,99107);
insert into tab_district values (6737,68,'Frydek - Mistek','north Moravia',228848,15,40,18,2,6,57.20,9893,4.09,4.72,96,5623,5887);
insert into tab_district values (6737,68,'Frydek - Mistek','north Moravia',228848,15,40,18,2,6,57.20,9893,4.09,4.72,96,5623,5887);
insert into tab_district values (6738,74,'Ostrava - mesto','north Moravia',323870,0,0,0,1,1,100.00,10673,4.75,5.44,100,18782,18347);
insert into tab_district values (6745,64,'Zlin','south Moravia',197099,29,41,10,2,10,74.70,9624,1.60,2.31,145,4484,4265);
insert into tab_district values (6746,46,'Nachod','east Bohemia',112709,48,20,7,3,10,73.50,8369,1.79,2.31,117,2854,2618);
insert into tab_district values (6748,60,'Prostejov','south Moravia',110643,49,41,4,1,4,51.90,8441,3.45,4.48,115,1879,2252);
insert into tab_district values (6751,17,'Pelhrimov','south Bohemia',74062,99,15,4,2,7,61.40,8114,2.38,2.62,119,1003,1181);
insert into tab_district values (6751,17,'Pelhrimov','south Bohemia',74062,99,15,4,2,7,61.40,8114,2.38,2.62,119,1003,1181);
insert into tab_district values (6753,66,'Zdar nad Sazavou','south Moravia',125832,151,41,2,3,5,48.30,8512,3.51,4.12,102,2247,2103);
insert into tab_district values (6755,53,'Blansko','south Moravia',107911,88,33,6,2,7,50.90,8240,2.53,3.56,99,1850,1903);
insert into tab_district values (6758,70,'Karvina','north Moravia',285387,0,2,8,5,7,89.90,10177,6.63,7.75,81,9878,10108);
insert into tab_district values (6758,70,'Karvina','north Moravia',285387,0,2,8,5,7,89.90,10177,6.63,7.75,81,9878,10108);
insert into tab_district values (6763,1,'Hl.m. Praha','Prague',1204953,0,0,0,1,1,100.00,12541,0.29,0.43,167,85677,99107);
insert into tab_district values (6764,64,'Zlin','south Moravia',197099,29,41,10,2,10,74.70,9624,1.60,2.31,145,4484,4265);
insert into tab_district values (6766,1,'Hl.m. Praha','Prague',1204953,0,0,0,1,1,100.00,12541,0.29,0.43,167,85677,99107);
insert into tab_district values (6785,1,'Hl.m. Praha','Prague',1204953,0,0,0,1,1,100.00,12541,0.29,0.43,167,85677,99107);
insert into tab_district values (6790,62,'Uherske Hradiste','south Moravia',145688,22,41,13,2,5,40.70,8544,1.29,1.86,109,2719,2906);
insert into tab_district values (6790,62,'Uherske Hradiste','south Moravia',145688,22,41,13,2,5,40.70,8544,1.29,1.86,109,2719,2906);
insert into tab_district values (6791,1,'Hl.m. Praha','Prague',1204953,0,0,0,1,1,100.00,12541,0.29,0.43,167,85677,99107);
insert into tab_district values (6791,1,'Hl.m. Praha','Prague',1204953,0,0,0,1,1,100.00,12541,0.29,0.43,167,85677,99107);
insert into tab_district values (6793,63,'Vyskov','south Moravia',86513,38,36,5,1,5,50.50,8288,3.79,4.52,110,1562,1460);
insert into tab_district values (6805,70,'Karvina','north Moravia',285387,0,2,8,5,7,89.90,10177,6.63,7.75,81,9878,10108);
insert into tab_district values (6808,64,'Zlin','south Moravia',197099,29,41,10,2,10,74.70,9624,1.60,2.31,145,4484,4265);
insert into tab_district values (6808,64,'Zlin','south Moravia',197099,29,41,10,2,10,74.70,9624,1.60,2.31,145,4484,4265);
insert into tab_district values (6810,40,'Teplice','north Bohemia',128118,9,16,6,3,8,85.30,9317,6.49,7.07,97,6949,6872);
insert into tab_district values (6816,70,'Karvina','north Moravia',285387,0,2,8,5,7,89.90,10177,6.63,7.75,81,9878,10108);
insert into tab_district values (6817,1,'Hl.m. Praha','Prague',1204953,0,0,0,1,1,100.00,12541,0.29,0.43,167,85677,99107);
insert into tab_district values (6818,72,'Olomouc','north Moravia',226122,32,50,7,4,4,62.60,8994,3.80,4.79,110,9672,9208);
insert into tab_district values (6818,72,'Olomouc','north Moravia',226122,32,50,7,4,4,62.60,8994,3.80,4.79,110,9672,9208);
insert into tab_district values (6819,47,'Pardubice','east Bohemia',162580,83,26,5,1,6,72.80,9538,1.51,1.81,111,6079,5410);
insert into tab_district values (6820,1,'Hl.m. Praha','Prague',1204953,0,0,0,1,1,100.00,12541,0.29,0.43,167,85677,99107);
insert into tab_district values (6821,1,'Hl.m. Praha','Prague',1204953,0,0,0,1,1,100.00,12541,0.29,0.43,167,85677,99107);
insert into tab_district values (6821,1,'Hl.m. Praha','Prague',1204953,0,0,0,1,1,100.00,12541,0.29,0.43,167,85677,99107);
insert into tab_district values (6824,43,'Hradec Kralove','east Bohemia',161854,73,21,6,1,6,76.30,9425,1.72,2.50,125,4085,3891);
insert into tab_district values (6836,58,'Jihlava','south Moravia',109164,98,16,6,1,4,63.60,8757,3.38,3.95,96,2212,2471);
insert into tab_district values (6841,10,'Praha - vychod','central Bohemia',92084,55,29,4,3,5,46.70,10124,0.56,0.54,141,3810,4316);
insert into tab_district values (6851,26,'Plzen - mesto','west Bohemia',170449,0,0,0,1,1,100.00,10787,2.64,3.09,131,6041,6261);
insert into tab_district values (6852,32,'Ceska Lipa','north Bohemia',105058,32,19,7,2,10,81.00,9272,2.80,3.22,118,4340,4505);
insert into tab_district values (6855,9,'Nymburk','central Bohemia',81344,61,23,4,2,6,55.30,8899,3.39,3.97,149,2987,2487);
insert into tab_district values (6855,9,'Nymburk','central Bohemia',81344,61,23,4,2,6,55.30,8899,3.39,3.97,149,2987,2487);
insert into tab_district values (6856,18,'Pisek','south Bohemia',70699,60,13,2,1,4,65.30,8968,2.83,3.35,131,1740,1910);
insert into tab_district values (6857,64,'Zlin','south Moravia',197099,29,41,10,2,10,74.70,9624,1.60,2.31,145,4484,4265);
insert into tab_district values (6857,64,'Zlin','south Moravia',197099,29,41,10,2,10,74.70,9624,1.60,2.31,145,4484,4265);
insert into tab_district values (6859,56,'Breclav','south Moravia',124605,11,42,14,1,8,46.00,8772,4.69,4.98,126,2854,3158);
insert into tab_district values (6861,28,'Plzen - sever','west Bohemia',72541,66,26,10,0,8,36.90,8594,1.62,2.01,112,1580,1525);
insert into tab_district values (6863,45,'Jicin','east Bohemia',77917,85,19,6,1,5,53.50,8390,2.28,2.89,132,2080,2122);
insert into tab_district values (6865,72,'Olomouc','north Moravia',226122,32,50,7,4,4,62.60,8994,3.80,4.79,110,9672,9208);
insert into tab_district values (6866,69,'Jesenik','north Moravia',42821,4,13,5,1,3,48.40,8173,NULL,7.01,124,NULL,1358);
insert into tab_district values (6868,29,'Rokycany','west Bohemia',45714,52,10,5,1,6,55.60,8843,2.82,3.60,113,818,888);
insert into tab_district values (6871,11,'Praha - zapad','central Bohemia',75637,35,36,9,0,7,36.50,9622,0.45,0.59,154,3475,3529);
insert into tab_district values (6871,11,'Praha - zapad','central Bohemia',75637,35,36,9,0,7,36.50,9622,0.45,0.59,154,3475,3529);
insert into tab_district values (6872,51,'Trutnov','east Bohemia',121947,37,28,7,3,11,70.50,8541,2.51,2.97,131,3496,3839);
insert into tab_district values (6875,37,'Litomerice','north Bohemia',114006,71,26,6,2,9,62.30,9065,4.46,5.39,123,4147,4166);
insert into tab_district values (6876,11,'Praha - zapad','central Bohemia',75637,35,36,9,0,7,36.50,9622,0.45,0.59,154,3475,3529);
insert into tab_district values (6877,74,'Ostrava - mesto','north Moravia',323870,0,0,0,1,1,100.00,10673,4.75,5.44,100,18782,18347);
insert into tab_district values (6877,74,'Ostrava - mesto','north Moravia',323870,0,0,0,1,1,100.00,10673,4.75,5.44,100,18782,18347);
insert into tab_district values (6878,57,'Hodonin','south Moravia',161954,21,37,20,3,8,48.00,8720,3.73,4.50,116,3729,3651);
insert into tab_district values (6887,68,'Frydek - Mistek','north Moravia',228848,15,40,18,2,6,57.20,9893,4.09,4.72,96,5623,5887);
insert into tab_district values (6887,68,'Frydek - Mistek','north Moravia',228848,15,40,18,2,6,57.20,9893,4.09,4.72,96,5623,5887);
insert into tab_district values (6888,32,'Ceska Lipa','north Bohemia',105058,32,19,7,2,10,81.00,9272,2.80,3.22,118,4340,4505);
insert into tab_district values (6895,70,'Karvina','north Moravia',285387,0,2,8,5,7,89.90,10177,6.63,7.75,81,9878,10108);
insert into tab_district values (6903,11,'Praha - zapad','central Bohemia',75637,35,36,9,0,7,36.50,9622,0.45,0.59,154,3475,3529);
insert into tab_district values (6908,59,'Kromeriz','south Moravia',108871,41,29,7,2,6,62.10,8444,3.24,3.47,106,2595,2305);
insert into tab_district values (6908,59,'Kromeriz','south Moravia',108871,41,29,7,2,6,62.10,8444,3.24,3.47,106,2595,2305);
insert into tab_district values (6913,1,'Hl.m. Praha','Prague',1204953,0,0,0,1,1,100.00,12541,0.29,0.43,167,85677,99107);
insert into tab_district values (6919,1,'Hl.m. Praha','Prague',1204953,0,0,0,1,1,100.00,12541,0.29,0.43,167,85677,99107);
insert into tab_district values (6921,70,'Karvina','north Moravia',285387,0,2,8,5,7,89.90,10177,6.63,7.75,81,9878,10108);
insert into tab_district values (6922,54,'Brno - mesto','south Moravia',387570,0,0,0,1,1,100.00,9897,1.60,1.96,140,18721,18696);
insert into tab_district values (6923,59,'Kromeriz','south Moravia',108871,41,29,7,2,6,62.10,8444,3.24,3.47,106,2595,2305);
insert into tab_district values (6926,73,'Opava','north Moravia',182027,17,49,12,2,7,56.40,8746,3.33,3.74,90,4355,4433);
insert into tab_district values (6926,73,'Opava','north Moravia',182027,17,49,12,2,7,56.40,8746,3.33,3.74,90,4355,4433);
insert into tab_district values (6929,76,'Sumperk','north Moravia',127369,31,32,13,2,7,51.20,8369,4.73,5.88,107,3736,2807);
insert into tab_district values (6932,7,'Melnik','central Bohemia',94725,38,28,1,3,6,63.40,9920,2.26,2.87,130,4289,4846);
insert into tab_district values (6933,64,'Zlin','south Moravia',197099,29,41,10,2,10,74.70,9624,1.60,2.31,145,4484,4265);
insert into tab_district values (6934,21,'Tabor','south Bohemia',103347,87,16,7,1,7,67.00,9104,1.51,2.07,123,2299,2354);
insert into tab_district values (6934,21,'Tabor','south Bohemia',103347,87,16,7,1,7,67.00,9104,1.51,2.07,123,2299,2354);
insert into tab_district values (6938,9,'Nymburk','central Bohemia',81344,61,23,4,2,6,55.30,8899,3.39,3.97,149,2987,2487);
insert into tab_district values (6940,1,'Hl.m. Praha','Prague',1204953,0,0,0,1,1,100.00,12541,0.29,0.43,167,85677,99107);
insert into tab_district values (6940,1,'Hl.m. Praha','Prague',1204953,0,0,0,1,1,100.00,12541,0.29,0.43,167,85677,99107);
insert into tab_district values (6942,59,'Kromeriz','south Moravia',108871,41,29,7,2,6,62.10,8444,3.24,3.47,106,2595,2305);
insert into tab_district values (6942,59,'Kromeriz','south Moravia',108871,41,29,7,2,6,62.10,8444,3.24,3.47,106,2595,2305);
insert into tab_district values (6944,62,'Uherske Hradiste','south Moravia',145688,22,41,13,2,5,40.70,8544,1.29,1.86,109,2719,2906);
insert into tab_district values (6948,1,'Hl.m. Praha','Prague',1204953,0,0,0,1,1,100.00,12541,0.29,0.43,167,85677,99107);
insert into tab_district values (6949,31,'Tachov','west Bohemia',51313,34,12,3,1,4,59.20,8930,3.52,4.20,108,1328,1452);
insert into tab_district values (6949,31,'Tachov','west Bohemia',51313,34,12,3,1,4,59.20,8930,3.52,4.20,108,1328,1452);
insert into tab_district values (6950,74,'Ostrava - mesto','north Moravia',323870,0,0,0,1,1,100.00,10673,4.75,5.44,100,18782,18347);
insert into tab_district values (6955,65,'Znojmo','south Moravia',114200,101,41,4,1,4,43.70,8403,5.74,5.72,105,2157,2718);
insert into tab_district values (6956,11,'Praha - zapad','central Bohemia',75637,35,36,9,0,7,36.50,9622,0.45,0.59,154,3475,3529);
insert into tab_district values (6959,70,'Karvina','north Moravia',285387,0,2,8,5,7,89.90,10177,6.63,7.75,81,9878,10108);
insert into tab_district values (6960,1,'Hl.m. Praha','Prague',1204953,0,0,0,1,1,100.00,12541,0.29,0.43,167,85677,99107);
insert into tab_district values (6960,1,'Hl.m. Praha','Prague',1204953,0,0,0,1,1,100.00,12541,0.29,0.43,167,85677,99107);
insert into tab_district values (6961,38,'Louny','north Bohemia',85852,41,23,4,2,4,59.80,8965,7.08,8.23,104,2653,2822);
insert into tab_district values (6962,1,'Hl.m. Praha','Prague',1204953,0,0,0,1,1,100.00,12541,0.29,0.43,167,85677,99107);
insert into tab_district values (6962,1,'Hl.m. Praha','Prague',1204953,0,0,0,1,1,100.00,12541,0.29,0.43,167,85677,99107);
insert into tab_district values (6965,61,'Trebic','south Moravia',117897,139,28,5,1,6,53.80,8814,4.76,5.74,107,2112,2059);
insert into tab_district values (6969,76,'Sumperk','north Moravia',127369,31,32,13,2,7,51.20,8369,4.73,5.88,107,3736,2807);
insert into tab_district values (6969,76,'Sumperk','north Moravia',127369,31,32,13,2,7,51.20,8369,4.73,5.88,107,3736,2807);
insert into tab_district values (6970,8,'Mlada Boleslav','central Bohemia',112065,95,19,7,1,8,69.40,11277,1.25,1.44,127,5179,4987);
insert into tab_district values (6984,54,'Brno - mesto','south Moravia',387570,0,0,0,1,1,100.00,9897,1.60,1.96,140,18721,18696);
insert into tab_district values (6984,54,'Brno - mesto','south Moravia',387570,0,0,0,1,1,100.00,9897,1.60,1.96,140,18721,18696);
insert into tab_district values (6985,54,'Brno - mesto','south Moravia',387570,0,0,0,1,1,100.00,9897,1.60,1.96,140,18721,18696);
insert into tab_district values (6985,54,'Brno - mesto','south Moravia',387570,0,0,0,1,1,100.00,9897,1.60,1.96,140,18721,18696);
insert into tab_district values (6986,74,'Ostrava - mesto','north Moravia',323870,0,0,0,1,1,100.00,10673,4.75,5.44,100,18782,18347);
insert into tab_district values (6992,52,'Usti nad Orlici','east Bohemia',139012,59,41,8,3,10,61.90,8363,2.52,3.49,108,2564,2799);
insert into tab_district values (6992,52,'Usti nad Orlici','east Bohemia',139012,59,41,8,3,10,61.90,8363,2.52,3.49,108,2564,2799);
insert into tab_district values (6995,64,'Zlin','south Moravia',197099,29,41,10,2,10,74.70,9624,1.60,2.31,145,4484,4265);
insert into tab_district values (6996,47,'Pardubice','east Bohemia',162580,83,26,5,1,6,72.80,9538,1.51,1.81,111,6079,5410);
insert into tab_district values (6998,21,'Tabor','south Bohemia',103347,87,16,7,1,7,67.00,9104,1.51,2.07,123,2299,2354);
insert into tab_district values (7001,27,'Plzen - jih','west Bohemia',67298,71,19,10,0,7,43.80,8561,0.65,1.29,110,1029,1127);
insert into tab_district values (7004,2,'Benesov','central Bohemia',88884,80,26,6,2,5,46.70,8507,1.67,1.85,132,2159,2674);
insert into tab_district values (7004,2,'Benesov','central Bohemia',88884,80,26,6,2,5,46.70,8507,1.67,1.85,132,2159,2674);
insert into tab_district values (7008,1,'Hl.m. Praha','Prague',1204953,0,0,0,1,1,100.00,12541,0.29,0.43,167,85677,99107);
insert into tab_district values (7013,60,'Prostejov','south Moravia',110643,49,41,4,1,4,51.90,8441,3.45,4.48,115,1879,2252);
insert into tab_district values (7013,60,'Prostejov','south Moravia',110643,49,41,4,1,4,51.90,8441,3.45,4.48,115,1879,2252);
insert into tab_district values (7034,24,'Karlovy Vary','west Bohemia',122603,25,21,6,2,8,80.00,8991,1.39,2.01,128,5198,5273);
insert into tab_district values (7035,64,'Zlin','south Moravia',197099,29,41,10,2,10,74.70,9624,1.60,2.31,145,4484,4265);
insert into tab_district values (7036,8,'Mlada Boleslav','central Bohemia',112065,95,19,7,1,8,69.40,11277,1.25,1.44,127,5179,4987);
insert into tab_district values (7037,1,'Hl.m. Praha','Prague',1204953,0,0,0,1,1,100.00,12541,0.29,0.43,167,85677,99107);
insert into tab_district values (7046,17,'Pelhrimov','south Bohemia',74062,99,15,4,2,7,61.40,8114,2.38,2.62,119,1003,1181);
insert into tab_district values (7046,17,'Pelhrimov','south Bohemia',74062,99,15,4,2,7,61.40,8114,2.38,2.62,119,1003,1181);
insert into tab_district values (7049,4,'Kladno','central Bohemia',149893,63,29,6,2,6,67.40,9753,4.64,5.05,109,5244,5892);
insert into tab_district values (7050,76,'Sumperk','north Moravia',127369,31,32,13,2,7,51.20,8369,4.73,5.88,107,3736,2807);
insert into tab_district values (7051,1,'Hl.m. Praha','Prague',1204953,0,0,0,1,1,100.00,12541,0.29,0.43,167,85677,99107);
insert into tab_district values (7051,1,'Hl.m. Praha','Prague',1204953,0,0,0,1,1,100.00,12541,0.29,0.43,167,85677,99107);
insert into tab_district values (7055,62,'Uherske Hradiste','south Moravia',145688,22,41,13,2,5,40.70,8544,1.29,1.86,109,2719,2906);
insert into tab_district values (7055,62,'Uherske Hradiste','south Moravia',145688,22,41,13,2,5,40.70,8544,1.29,1.86,109,2719,2906);
insert into tab_district values (7057,1,'Hl.m. Praha','Prague',1204953,0,0,0,1,1,100.00,12541,0.29,0.43,167,85677,99107);
insert into tab_district values (7057,1,'Hl.m. Praha','Prague',1204953,0,0,0,1,1,100.00,12541,0.29,0.43,167,85677,99107);
insert into tab_district values (7061,55,'Brno - venkov','south Moravia',157042,49,70,18,0,9,33.90,8743,1.88,2.43,111,3659,3894);
insert into tab_district values (7066,39,'Most','north Bohemia',119895,17,4,3,2,4,89.90,10446,7.34,9.40,90,4947,4743);
insert into tab_district values (7067,22,'Domazlice','west Bohemia',58400,65,16,4,1,6,52.40,8620,1.10,1.25,100,1089,1117);
insert into tab_district values (7072,34,'Chomutov','north Bohemia',125236,28,11,1,4,5,87.70,9675,6.43,7.68,100,5323,5190);
insert into tab_district values (7085,70,'Karvina','north Moravia',285387,0,2,8,5,7,89.90,10177,6.63,7.75,81,9878,10108);
insert into tab_district values (7087,38,'Louny','north Bohemia',85852,41,23,4,2,4,59.80,8965,7.08,8.23,104,2653,2822);
insert into tab_district values (7088,27,'Plzen - jih','west Bohemia',67298,71,19,10,0,7,43.80,8561,0.65,1.29,110,1029,1127);
insert into tab_district values (7091,44,'Chrudim','east Bohemia',105606,77,26,7,2,7,53.00,8254,2.79,3.76,97,2166,2325);
insert into tab_district values (7096,27,'Plzen - jih','west Bohemia',67298,71,19,10,0,7,43.80,8561,0.65,1.29,110,1029,1127);
insert into tab_district values (7097,54,'Brno - mesto','south Moravia',387570,0,0,0,1,1,100.00,9897,1.60,1.96,140,18721,18696);
insert into tab_district values (7100,69,'Jesenik','north Moravia',42821,4,13,5,1,3,48.40,8173,NULL,7.01,124,NULL,1358);
insert into tab_district values (7101,14,'Ceske Budejovice','south Bohemia',177686,69,27,10,1,9,74.80,10045,1.42,1.71,135,6604,6295);
insert into tab_district values (7104,68,'Frydek - Mistek','north Moravia',228848,15,40,18,2,6,57.20,9893,4.09,4.72,96,5623,5887);
insert into tab_district values (7110,36,'Liberec','north Bohemia',159617,29,19,8,1,9,85.20,9198,3.33,4.28,131,5796,6132);
insert into tab_district values (7110,36,'Liberec','north Bohemia',159617,29,19,8,1,9,85.20,9198,3.33,4.28,131,5796,6132);
insert into tab_district values (7115,23,'Cheb','west Bohemia',87419,21,11,4,3,9,85.50,8624,1.79,2.66,102,2879,3198);
insert into tab_district values (7115,23,'Cheb','west Bohemia',87419,21,11,4,3,9,85.50,8624,1.79,2.66,102,2879,3198);
insert into tab_district values (7119,21,'Tabor','south Bohemia',103347,87,16,7,1,7,67.00,9104,1.51,2.07,123,2299,2354);
insert into tab_district values (7121,55,'Brno - venkov','south Moravia',157042,49,70,18,0,9,33.90,8743,1.88,2.43,111,3659,3894);
insert into tab_district values (7121,55,'Brno - venkov','south Moravia',157042,49,70,18,0,9,33.90,8743,1.88,2.43,111,3659,3894);
insert into tab_district values (7122,22,'Domazlice','west Bohemia',58400,65,16,4,1,6,52.40,8620,1.10,1.25,100,1089,1117);
insert into tab_district values (7129,1,'Hl.m. Praha','Prague',1204953,0,0,0,1,1,100.00,12541,0.29,0.43,167,85677,99107);
insert into tab_district values (7130,39,'Most','north Bohemia',119895,17,4,3,2,4,89.90,10446,7.34,9.40,90,4947,4743);
insert into tab_district values (7136,60,'Prostejov','south Moravia',110643,49,41,4,1,4,51.90,8441,3.45,4.48,115,1879,2252);
insert into tab_district values (7137,66,'Zdar nad Sazavou','south Moravia',125832,151,41,2,3,5,48.30,8512,3.51,4.12,102,2247,2103);
insert into tab_district values (7138,45,'Jicin','east Bohemia',77917,85,19,6,1,5,53.50,8390,2.28,2.89,132,2080,2122);
insert into tab_district values (7139,72,'Olomouc','north Moravia',226122,32,50,7,4,4,62.60,8994,3.80,4.79,110,9672,9208);
insert into tab_district values (7139,72,'Olomouc','north Moravia',226122,32,50,7,4,4,62.60,8994,3.80,4.79,110,9672,9208);
insert into tab_district values (7142,1,'Hl.m. Praha','Prague',1204953,0,0,0,1,1,100.00,12541,0.29,0.43,167,85677,99107);
insert into tab_district values (7147,70,'Karvina','north Moravia',285387,0,2,8,5,7,89.90,10177,6.63,7.75,81,9878,10108);
insert into tab_district values (7151,12,'Pribram','central Bohemia',107870,84,29,6,1,6,58.00,8754,3.83,4.31,137,3804,3868);
insert into tab_district values (7154,55,'Brno - venkov','south Moravia',157042,49,70,18,0,9,33.90,8743,1.88,2.43,111,3659,3894);
insert into tab_district values (7164,55,'Brno - venkov','south Moravia',157042,49,70,18,0,9,33.90,8743,1.88,2.43,111,3659,3894);
insert into tab_district values (7166,41,'Usti nad Labem','north Bohemia',118650,8,8,5,1,3,85.60,9832,3.32,4.48,114,6445,5471);
insert into tab_district values (7167,16,'Jindrichuv Hradec','south Bohemia',93931,74,21,10,1,8,56.90,8427,1.12,1.54,107,1874,1913);
insert into tab_district values (7168,2,'Benesov','central Bohemia',88884,80,26,6,2,5,46.70,8507,1.67,1.85,132,2159,2674);
insert into tab_district values (7171,76,'Sumperk','north Moravia',127369,31,32,13,2,7,51.20,8369,4.73,5.88,107,3736,2807);
insert into tab_district values (7172,1,'Hl.m. Praha','Prague',1204953,0,0,0,1,1,100.00,12541,0.29,0.43,167,85677,99107);
insert into tab_district values (7176,11,'Praha - zapad','central Bohemia',75637,35,36,9,0,7,36.50,9622,0.45,0.59,154,3475,3529);
insert into tab_district values (7181,1,'Hl.m. Praha','Prague',1204953,0,0,0,1,1,100.00,12541,0.29,0.43,167,85677,99107);
insert into tab_district values (7187,36,'Liberec','north Bohemia',159617,29,19,8,1,9,85.20,9198,3.33,4.28,131,5796,6132);
insert into tab_district values (7189,71,'Novy Jicin','north Moravia',161227,5,35,11,4,10,69.70,8678,5.93,5.57,102,4980,4595);
insert into tab_district values (7192,31,'Tachov','west Bohemia',51313,34,12,3,1,4,59.20,8930,3.52,4.20,108,1328,1452);
insert into tab_district values (7194,1,'Hl.m. Praha','Prague',1204953,0,0,0,1,1,100.00,12541,0.29,0.43,167,85677,99107);
insert into tab_district values (7195,46,'Nachod','east Bohemia',112709,48,20,7,3,10,73.50,8369,1.79,2.31,117,2854,2618);
insert into tab_district values (7198,72,'Olomouc','north Moravia',226122,32,50,7,4,4,62.60,8994,3.80,4.79,110,9672,9208);
insert into tab_district values (7199,75,'Prerov','north Moravia',138032,67,30,4,2,5,64.60,8819,5.38,5.66,99,4063,4505);
insert into tab_district values (7199,75,'Prerov','north Moravia',138032,67,30,4,2,5,64.60,8819,5.38,5.66,99,4063,4505);
insert into tab_district values (7200,76,'Sumperk','north Moravia',127369,31,32,13,2,7,51.20,8369,4.73,5.88,107,3736,2807);
insert into tab_district values (7201,34,'Chomutov','north Bohemia',125236,28,11,1,4,5,87.70,9675,6.43,7.68,100,5323,5190);
insert into tab_district values (7202,16,'Jindrichuv Hradec','south Bohemia',93931,74,21,10,1,8,56.90,8427,1.12,1.54,107,1874,1913);
insert into tab_district values (7202,16,'Jindrichuv Hradec','south Bohemia',93931,74,21,10,1,8,56.90,8427,1.12,1.54,107,1874,1913);
insert into tab_district values (7209,50,'Svitavy','east Bohemia',102609,75,33,2,3,6,52.00,8187,4.83,5.45,94,2123,2134);
insert into tab_district values (7213,65,'Znojmo','south Moravia',114200,101,41,4,1,4,43.70,8403,5.74,5.72,105,2157,2718);
insert into tab_district values (7219,32,'Ceska Lipa','north Bohemia',105058,32,19,7,2,10,81.00,9272,2.80,3.22,118,4340,4505);
insert into tab_district values (7220,1,'Hl.m. Praha','Prague',1204953,0,0,0,1,1,100.00,12541,0.29,0.43,167,85677,99107);
insert into tab_district values (7221,25,'Klatovy','west Bohemia',88757,60,33,3,2,10,61.70,8554,2.47,2.68,113,1822,2218);
insert into tab_district values (7226,13,'Rakovnik','central Bohemia',53921,61,22,1,1,2,41.30,8598,2.77,3.26,123,1597,1875);
insert into tab_district values (7226,13,'Rakovnik','central Bohemia',53921,61,22,1,1,2,41.30,8598,2.77,3.26,123,1597,1875);
insert into tab_district values (7227,44,'Chrudim','east Bohemia',105606,77,26,7,2,7,53.00,8254,2.79,3.76,97,2166,2325);
insert into tab_district values (7230,25,'Klatovy','west Bohemia',88757,60,33,3,2,10,61.70,8554,2.47,2.68,113,1822,2218);
insert into tab_district values (7230,25,'Klatovy','west Bohemia',88757,60,33,3,2,10,61.70,8554,2.47,2.68,113,1822,2218);
insert into tab_district values (7233,16,'Jindrichuv Hradec','south Bohemia',93931,74,21,10,1,8,56.90,8427,1.12,1.54,107,1874,1913);
insert into tab_district values (7235,18,'Pisek','south Bohemia',70699,60,13,2,1,4,65.30,8968,2.83,3.35,131,1740,1910);
insert into tab_district values (7240,63,'Vyskov','south Moravia',86513,38,36,5,1,5,50.50,8288,3.79,4.52,110,1562,1460);
insert into tab_district values (7241,1,'Hl.m. Praha','Prague',1204953,0,0,0,1,1,100.00,12541,0.29,0.43,167,85677,99107);
insert into tab_district values (7242,32,'Ceska Lipa','north Bohemia',105058,32,19,7,2,10,81.00,9272,2.80,3.22,118,4340,4505);
insert into tab_district values (7243,72,'Olomouc','north Moravia',226122,32,50,7,4,4,62.60,8994,3.80,4.79,110,9672,9208);
insert into tab_district values (7246,59,'Kromeriz','south Moravia',108871,41,29,7,2,6,62.10,8444,3.24,3.47,106,2595,2305);
insert into tab_district values (7249,46,'Nachod','east Bohemia',112709,48,20,7,3,10,73.50,8369,1.79,2.31,117,2854,2618);
insert into tab_district values (7250,37,'Litomerice','north Bohemia',114006,71,26,6,2,9,62.30,9065,4.46,5.39,123,4147,4166);
insert into tab_district values (7253,16,'Jindrichuv Hradec','south Bohemia',93931,74,21,10,1,8,56.90,8427,1.12,1.54,107,1874,1913);
insert into tab_district values (7255,28,'Plzen - sever','west Bohemia',72541,66,26,10,0,8,36.90,8594,1.62,2.01,112,1580,1525);
insert into tab_district values (7259,59,'Kromeriz','south Moravia',108871,41,29,7,2,6,62.10,8444,3.24,3.47,106,2595,2305);
insert into tab_district values (7259,59,'Kromeriz','south Moravia',108871,41,29,7,2,6,62.10,8444,3.24,3.47,106,2595,2305);
insert into tab_district values (7262,75,'Prerov','north Moravia',138032,67,30,4,2,5,64.60,8819,5.38,5.66,99,4063,4505);
insert into tab_district values (7263,70,'Karvina','north Moravia',285387,0,2,8,5,7,89.90,10177,6.63,7.75,81,9878,10108);
insert into tab_district values (7264,1,'Hl.m. Praha','Prague',1204953,0,0,0,1,1,100.00,12541,0.29,0.43,167,85677,99107);
insert into tab_district values (7271,12,'Pribram','central Bohemia',107870,84,29,6,1,6,58.00,8754,3.83,4.31,137,3804,3868);
insert into tab_district values (7271,12,'Pribram','central Bohemia',107870,84,29,6,1,6,58.00,8754,3.83,4.31,137,3804,3868);
insert into tab_district values (7277,1,'Hl.m. Praha','Prague',1204953,0,0,0,1,1,100.00,12541,0.29,0.43,167,85677,99107);
insert into tab_district values (7279,33,'Decin','north Bohemia',133777,24,17,7,3,11,84.70,8705,5.75,7.61,116,4650,4859);
insert into tab_district values (7284,15,'Cesky Krumlov','south Bohemia',58796,22,16,7,1,5,51.90,9045,3.13,3.60,124,1845,1879);
insert into tab_district values (7286,5,'Kolin','central Bohemia',95616,65,30,4,1,6,51.40,9307,3.85,4.43,118,2616,3040);
insert into tab_district values (7292,50,'Svitavy','east Bohemia',102609,75,33,2,3,6,52.00,8187,4.83,5.45,94,2123,2134);
insert into tab_district values (7294,7,'Melnik','central Bohemia',94725,38,28,1,3,6,63.40,9920,2.26,2.87,130,4289,4846);
insert into tab_district values (7295,54,'Brno - mesto','south Moravia',387570,0,0,0,1,1,100.00,9897,1.60,1.96,140,18721,18696);
insert into tab_district values (7304,1,'Hl.m. Praha','Prague',1204953,0,0,0,1,1,100.00,12541,0.29,0.43,167,85677,99107);
insert into tab_district values (7304,1,'Hl.m. Praha','Prague',1204953,0,0,0,1,1,100.00,12541,0.29,0.43,167,85677,99107);
insert into tab_district values (7305,61,'Trebic','south Moravia',117897,139,28,5,1,6,53.80,8814,4.76,5.74,107,2112,2059);
insert into tab_district values (7308,67,'Bruntal','north Moravia',106054,38,25,6,2,6,63.10,8110,5.77,6.55,109,3244,3079);
insert into tab_district values (6038,1,'Hl.m. Praha','Prague',1204953,0,0,0,1,1,100.00,12541,0.29,0.43,167,85677,99107);
insert into tab_district values (6766,1,'Hl.m. Praha','Prague',1204953,0,0,0,1,1,100.00,12541,0.29,0.43,167,85677,99107);
insert into tab_district values (6763,1,'Hl.m. Praha','Prague',1204953,0,0,0,1,1,100.00,12541,0.29,0.43,167,85677,99107);
insert into tab_district values (5719,1,'Hl.m. Praha','Prague',1204953,0,0,0,1,1,100.00,12541,0.29,0.43,167,85677,99107);
insert into tab_district values (6185,1,'Hl.m. Praha','Prague',1204953,0,0,0,1,1,100.00,12541,0.29,0.43,167,85677,99107);
insert into tab_district values (6645,1,'Hl.m. Praha','Prague',1204953,0,0,0,1,1,100.00,12541,0.29,0.43,167,85677,99107);
insert into tab_district values (6460,1,'Hl.m. Praha','Prague',1204953,0,0,0,1,1,100.00,12541,0.29,0.43,167,85677,99107);
insert into tab_district values (6223,1,'Hl.m. Praha','Prague',1204953,0,0,0,1,1,100.00,12541,0.29,0.43,167,85677,99107);
insert into tab_district values (6948,1,'Hl.m. Praha','Prague',1204953,0,0,0,1,1,100.00,12541,0.29,0.43,167,85677,99107);
insert into tab_district values (7142,1,'Hl.m. Praha','Prague',1204953,0,0,0,1,1,100.00,12541,0.29,0.43,167,85677,99107);
insert into tab_district values (6229,1,'Hl.m. Praha','Prague',1204953,0,0,0,1,1,100.00,12541,0.29,0.43,167,85677,99107);
insert into tab_district values (5823,1,'Hl.m. Praha','Prague',1204953,0,0,0,1,1,100.00,12541,0.29,0.43,167,85677,99107);
insert into tab_district values (6785,1,'Hl.m. Praha','Prague',1204953,0,0,0,1,1,100.00,12541,0.29,0.43,167,85677,99107);
insert into tab_district values (7129,1,'Hl.m. Praha','Prague',1204953,0,0,0,1,1,100.00,12541,0.29,0.43,167,85677,99107);
insert into tab_district values (6919,1,'Hl.m. Praha','Prague',1204953,0,0,0,1,1,100.00,12541,0.29,0.43,167,85677,99107);
insert into tab_district values (7220,1,'Hl.m. Praha','Prague',1204953,0,0,0,1,1,100.00,12541,0.29,0.43,167,85677,99107);
insert into tab_district values (6698,1,'Hl.m. Praha','Prague',1204953,0,0,0,1,1,100.00,12541,0.29,0.43,167,85677,99107);
insert into tab_district values (5060,1,'Hl.m. Praha','Prague',1204953,0,0,0,1,1,100.00,12541,0.29,0.43,167,85677,99107);
insert into tab_district values (7172,1,'Hl.m. Praha','Prague',1204953,0,0,0,1,1,100.00,12541,0.29,0.43,167,85677,99107);
insert into tab_district values (5117,1,'Hl.m. Praha','Prague',1204953,0,0,0,1,1,100.00,12541,0.29,0.43,167,85677,99107);
insert into tab_district values (7181,1,'Hl.m. Praha','Prague',1204953,0,0,0,1,1,100.00,12541,0.29,0.43,167,85677,99107);
insert into tab_district values (7241,1,'Hl.m. Praha','Prague',1204953,0,0,0,1,1,100.00,12541,0.29,0.43,167,85677,99107);
insert into tab_district values (6962,1,'Hl.m. Praha','Prague',1204953,0,0,0,1,1,100.00,12541,0.29,0.43,167,85677,99107);
insert into tab_district values (5501,1,'Hl.m. Praha','Prague',1204953,0,0,0,1,1,100.00,12541,0.29,0.43,167,85677,99107);
insert into tab_district values (6929,1,'Hl.m. Praha','Prague',1204953,0,0,0,1,1,100.00,12541,0.29,0.43,167,85677,99107);
insert into tab_district values (5740,1,'Hl.m. Praha','Prague',1204953,0,0,0,1,1,100.00,12541,0.29,0.43,167,85677,99107);
insert into tab_district values (6234,1,'Hl.m. Praha','Prague',1204953,0,0,0,1,1,100.00,12541,0.29,0.43,167,85677,99107);
insert into tab_district values (5343,1,'Hl.m. Praha','Prague',1204953,0,0,0,1,1,100.00,12541,0.29,0.43,167,85677,99107);
insert into tab_district values (7264,1,'Hl.m. Praha','Prague',1204953,0,0,0,1,1,100.00,12541,0.29,0.43,167,85677,99107);
insert into tab_district values (6546,1,'Hl.m. Praha','Prague',1204953,0,0,0,1,1,100.00,12541,0.29,0.43,167,85677,99107);
insert into tab_district values (5419,1,'Hl.m. Praha','Prague',1204953,0,0,0,1,1,100.00,12541,0.29,0.43,167,85677,99107);
insert into tab_district values (7057,1,'Hl.m. Praha','Prague',1204953,0,0,0,1,1,100.00,12541,0.29,0.43,167,85677,99107);
insert into tab_district values (6888,1,'Hl.m. Praha','Prague',1204953,0,0,0,1,1,100.00,12541,0.29,0.43,167,85677,99107);
insert into tab_district values (7304,1,'Hl.m. Praha','Prague',1204953,0,0,0,1,1,100.00,12541,0.29,0.43,167,85677,99107);
insert into tab_district values (5724,1,'Hl.m. Praha','Prague',1204953,0,0,0,1,1,100.00,12541,0.29,0.43,167,85677,99107);
insert into tab_district values (6450,1,'Hl.m. Praha','Prague',1204953,0,0,0,1,1,100.00,12541,0.29,0.43,167,85677,99107);
insert into tab_district values (6960,1,'Hl.m. Praha','Prague',1204953,0,0,0,1,1,100.00,12541,0.29,0.43,167,85677,99107);
insert into tab_district values (6244,1,'Hl.m. Praha','Prague',1204953,0,0,0,1,1,100.00,12541,0.29,0.43,167,85677,99107);
insert into tab_district values (5739,1,'Hl.m. Praha','Prague',1204953,0,0,0,1,1,100.00,12541,0.29,0.43,167,85677,99107);
insert into tab_district values (5576,1,'Hl.m. Praha','Prague',1204953,0,0,0,1,1,100.00,12541,0.29,0.43,167,85677,99107);
insert into tab_district values (7051,1,'Hl.m. Praha','Prague',1204953,0,0,0,1,1,100.00,12541,0.29,0.43,167,85677,99107);
insert into tab_district values (7008,1,'Hl.m. Praha','Prague',1204953,0,0,0,1,1,100.00,12541,0.29,0.43,167,85677,99107);
insert into tab_district values (7277,1,'Hl.m. Praha','Prague',1204953,0,0,0,1,1,100.00,12541,0.29,0.43,167,85677,99107);
insert into tab_district values (6338,1,'Hl.m. Praha','Prague',1204953,0,0,0,1,1,100.00,12541,0.29,0.43,167,85677,99107);
insert into tab_district values (5479,1,'Hl.m. Praha','Prague',1204953,0,0,0,1,1,100.00,12541,0.29,0.43,167,85677,99107);
insert into tab_district values (6063,1,'Hl.m. Praha','Prague',1204953,0,0,0,1,1,100.00,12541,0.29,0.43,167,85677,99107);
insert into tab_district values (4959,1,'Hl.m. Praha','Prague',1204953,0,0,0,1,1,100.00,12541,0.29,0.43,167,85677,99107);
insert into tab_district values (5782,1,'Hl.m. Praha','Prague',1204953,0,0,0,1,1,100.00,12541,0.29,0.43,167,85677,99107);
insert into tab_district values (6820,1,'Hl.m. Praha','Prague',1204953,0,0,0,1,1,100.00,12541,0.29,0.43,167,85677,99107);
insert into tab_district values (7037,1,'Hl.m. Praha','Prague',1204953,0,0,0,1,1,100.00,12541,0.29,0.43,167,85677,99107);
insert into tab_district values (6309,1,'Hl.m. Praha','Prague',1204953,0,0,0,1,1,100.00,12541,0.29,0.43,167,85677,99107);
insert into tab_district values (6817,1,'Hl.m. Praha','Prague',1204953,0,0,0,1,1,100.00,12541,0.29,0.43,167,85677,99107);
insert into tab_district values (6168,1,'Hl.m. Praha','Prague',1204953,0,0,0,1,1,100.00,12541,0.29,0.43,167,85677,99107);
insert into tab_district values (6346,1,'Hl.m. Praha','Prague',1204953,0,0,0,1,1,100.00,12541,0.29,0.43,167,85677,99107);
insert into tab_district values (5556,1,'Hl.m. Praha','Prague',1204953,0,0,0,1,1,100.00,12541,0.29,0.43,167,85677,99107);
insert into tab_district values (5644,1,'Hl.m. Praha','Prague',1204953,0,0,0,1,1,100.00,12541,0.29,0.43,167,85677,99107);
insert into tab_district values (6377,1,'Hl.m. Praha','Prague',1204953,0,0,0,1,1,100.00,12541,0.29,0.43,167,85677,99107);
insert into tab_district values (6562,1,'Hl.m. Praha','Prague',1204953,0,0,0,1,1,100.00,12541,0.29,0.43,167,85677,99107);
insert into tab_district values (6014,1,'Hl.m. Praha','Prague',1204953,0,0,0,1,1,100.00,12541,0.29,0.43,167,85677,99107);
insert into tab_district values (7240,1,'Hl.m. Praha','Prague',1204953,0,0,0,1,1,100.00,12541,0.29,0.43,167,85677,99107);
insert into tab_district values (6468,1,'Hl.m. Praha','Prague',1204953,0,0,0,1,1,100.00,12541,0.29,0.43,167,85677,99107);
insert into tab_district values (6913,1,'Hl.m. Praha','Prague',1204953,0,0,0,1,1,100.00,12541,0.29,0.43,167,85677,99107);
insert into tab_district values (6940,1,'Hl.m. Praha','Prague',1204953,0,0,0,1,1,100.00,12541,0.29,0.43,167,85677,99107);
insert into tab_district values (6821,1,'Hl.m. Praha','Prague',1204953,0,0,0,1,1,100.00,12541,0.29,0.43,167,85677,99107);
insert into tab_district values (6596,1,'Hl.m. Praha','Prague',1204953,0,0,0,1,1,100.00,12541,0.29,0.43,167,85677,99107);
insert into tab_district values (6736,1,'Hl.m. Praha','Prague',1204953,0,0,0,1,1,100.00,12541,0.29,0.43,167,85677,99107);
insert into tab_district values (6310,1,'Hl.m. Praha','Prague',1204953,0,0,0,1,1,100.00,12541,0.29,0.43,167,85677,99107);
insert into tab_district values (5491,1,'Hl.m. Praha','Prague',1204953,0,0,0,1,1,100.00,12541,0.29,0.43,167,85677,99107);
insert into tab_district values (5429,1,'Hl.m. Praha','Prague',1204953,0,0,0,1,1,100.00,12541,0.29,0.43,167,85677,99107);
insert into tab_district values (6647,1,'Hl.m. Praha','Prague',1204953,0,0,0,1,1,100.00,12541,0.29,0.43,167,85677,99107);
insert into tab_district values (5334,1,'Hl.m. Praha','Prague',1204953,0,0,0,1,1,100.00,12541,0.29,0.43,167,85677,99107);
insert into tab_district values (6499,1,'Hl.m. Praha','Prague',1204953,0,0,0,1,1,100.00,12541,0.29,0.43,167,85677,99107);
insert into tab_district values (6012,1,'Hl.m. Praha','Prague',1204953,0,0,0,1,1,100.00,12541,0.29,0.43,167,85677,99107);
insert into tab_district values (7259,1,'Hl.m. Praha','Prague',1204953,0,0,0,1,1,100.00,12541,0.29,0.43,167,85677,99107);
insert into tab_district values (5760,1,'Hl.m. Praha','Prague',1204953,0,0,0,1,1,100.00,12541,0.29,0.43,167,85677,99107);
insert into tab_district values (5332,1,'Hl.m. Praha','Prague',1204953,0,0,0,1,1,100.00,12541,0.29,0.43,167,85677,99107);
insert into tab_district values (5385,1,'Hl.m. Praha','Prague',1204953,0,0,0,1,1,100.00,12541,0.29,0.43,167,85677,99107);
insert into tab_district values (7194,1,'Hl.m. Praha','Prague',1204953,0,0,0,1,1,100.00,12541,0.29,0.43,167,85677,99107);
insert into tab_district values (6791,1,'Hl.m. Praha','Prague',1204953,0,0,0,1,1,100.00,12541,0.29,0.43,167,85677,99107);
insert into tab_district values (5375,1,'Hl.m. Praha','Prague',1204953,0,0,0,1,1,100.00,12541,0.29,0.43,167,85677,99107);
insert into tab_district values (7066,1,'Hl.m. Praha','Prague',1204953,0,0,0,1,1,100.00,12541,0.29,0.43,167,85677,99107);
insert into tab_district values (5635,1,'Hl.m. Praha','Prague',1204953,0,0,0,1,1,100.00,12541,0.29,0.43,167,85677,99107);
insert into tab_district values (5930,1,'Hl.m. Praha','Prague',1204953,0,0,0,1,1,100.00,12541,0.29,0.43,167,85677,99107);
insert into tab_district values (5285,1,'Hl.m. Praha','Prague',1204953,0,0,0,1,1,100.00,12541,0.29,0.43,167,85677,99107);
insert into tab_district values (6574,2,'Benesov','central Bohemia',88884,80,26,6,2,5,46.70,8507,1.67,1.85,132,2159,2674);
insert into tab_district values (5525,2,'Benesov','central Bohemia',88884,80,26,6,2,5,46.70,8507,1.67,1.85,132,2159,2674);
insert into tab_district values (5959,2,'Benesov','central Bohemia',88884,80,26,6,2,5,46.70,8507,1.67,1.85,132,2159,2674);
insert into tab_district values (6726,2,'Benesov','central Bohemia',88884,80,26,6,2,5,46.70,8507,1.67,1.85,132,2159,2674);
insert into tab_district values (5435,2,'Benesov','central Bohemia',88884,80,26,6,2,5,46.70,8507,1.67,1.85,132,2159,2674);
insert into tab_district values (7168,2,'Benesov','central Bohemia',88884,80,26,6,2,5,46.70,8507,1.67,1.85,132,2159,2674);
insert into tab_district values (5569,3,'Beroun','central Bohemia',75232,55,26,4,1,5,41.70,8980,1.95,2.21,111,2824,2813);
insert into tab_district values (5731,3,'Beroun','central Bohemia',75232,55,26,4,1,5,41.70,8980,1.95,2.21,111,2824,2813);
insert into tab_district values (6402,3,'Beroun','central Bohemia',75232,55,26,4,1,5,41.70,8980,1.95,2.21,111,2824,2813);
insert into tab_district values (5651,3,'Beroun','central Bohemia',75232,55,26,4,1,5,41.70,8980,1.95,2.21,111,2824,2813);
insert into tab_district values (5931,3,'Beroun','central Bohemia',75232,55,26,4,1,5,41.70,8980,1.95,2.21,111,2824,2813);
insert into tab_district values (6296,3,'Beroun','central Bohemia',75232,55,26,4,1,5,41.70,8980,1.95,2.21,111,2824,2813);
insert into tab_district values (6721,4,'Kladno','central Bohemia',149893,63,29,6,2,6,67.40,9753,4.64,5.05,109,5244,5892);
insert into tab_district values (6512,4,'Kladno','central Bohemia',149893,63,29,6,2,6,67.40,9753,4.64,5.05,109,5244,5892);
insert into tab_district values (5938,4,'Kladno','central Bohemia',149893,63,29,6,2,6,67.40,9753,4.64,5.05,109,5244,5892);
insert into tab_district values (6095,4,'Kladno','central Bohemia',149893,63,29,6,2,6,67.40,9753,4.64,5.05,109,5244,5892);
insert into tab_district values (7049,4,'Kladno','central Bohemia',149893,63,29,6,2,6,67.40,9753,4.64,5.05,109,5244,5892);
insert into tab_district values (5151,4,'Kladno','central Bohemia',149893,63,29,6,2,6,67.40,9753,4.64,5.05,109,5244,5892);
insert into tab_district values (6075,4,'Kladno','central Bohemia',149893,63,29,6,2,6,67.40,9753,4.64,5.05,109,5244,5892);
insert into tab_district values (5132,5,'Kolin','central Bohemia',95616,65,30,4,1,6,51.40,9307,3.85,4.43,118,2616,3040);
insert into tab_district values (6196,5,'Kolin','central Bohemia',95616,65,30,4,1,6,51.40,9307,3.85,4.43,118,2616,3040);
insert into tab_district values (6471,5,'Kolin','central Bohemia',95616,65,30,4,1,6,51.40,9307,3.85,4.43,118,2616,3040);
insert into tab_district values (5992,5,'Kolin','central Bohemia',95616,65,30,4,1,6,51.40,9307,3.85,4.43,118,2616,3040);
insert into tab_district values (5450,5,'Kolin','central Bohemia',95616,65,30,4,1,6,51.40,9307,3.85,4.43,118,2616,3040);
insert into tab_district values (6278,5,'Kolin','central Bohemia',95616,65,30,4,1,6,51.40,9307,3.85,4.43,118,2616,3040);
insert into tab_district values (6052,5,'Kolin','central Bohemia',95616,65,30,4,1,6,51.40,9307,3.85,4.43,118,2616,3040);
insert into tab_district values (6153,5,'Kolin','central Bohemia',95616,65,30,4,1,6,51.40,9307,3.85,4.43,118,2616,3040);
insert into tab_district values (5354,5,'Kolin','central Bohemia',95616,65,30,4,1,6,51.40,9307,3.85,4.43,118,2616,3040);
insert into tab_district values (7286,5,'Kolin','central Bohemia',95616,65,30,4,1,6,51.40,9307,3.85,4.43,118,2616,3040);
insert into tab_district values (6320,6,'Kutna Hora','central Bohemia',77963,60,23,4,2,4,51.50,8546,2.95,4.02,126,2640,3120);
insert into tab_district values (5287,6,'Kutna Hora','central Bohemia',77963,60,23,4,2,4,51.50,8546,2.95,4.02,126,2640,3120);
insert into tab_district values (6239,6,'Kutna Hora','central Bohemia',77963,60,23,4,2,4,51.50,8546,2.95,4.02,126,2640,3120);
insert into tab_district values (5486,6,'Kutna Hora','central Bohemia',77963,60,23,4,2,4,51.50,8546,2.95,4.02,126,2640,3120);
insert into tab_district values (5338,6,'Kutna Hora','central Bohemia',77963,60,23,4,2,4,51.50,8546,2.95,4.02,126,2640,3120);
insert into tab_district values (6028,6,'Kutna Hora','central Bohemia',77963,60,23,4,2,4,51.50,8546,2.95,4.02,126,2640,3120);
insert into tab_district values (6228,6,'Kutna Hora','central Bohemia',77963,60,23,4,2,4,51.50,8546,2.95,4.02,126,2640,3120);
insert into tab_district values (5154,6,'Kutna Hora','central Bohemia',77963,60,23,4,2,4,51.50,8546,2.95,4.02,126,2640,3120);
insert into tab_district values (5815,6,'Kutna Hora','central Bohemia',77963,60,23,4,2,4,51.50,8546,2.95,4.02,126,2640,3120);
insert into tab_district values (6321,7,'Melnik','central Bohemia',94725,38,28,1,3,6,63.40,9920,2.26,2.87,130,4289,4846);
insert into tab_district values (5750,7,'Melnik','central Bohemia',94725,38,28,1,3,6,63.40,9920,2.26,2.87,130,4289,4846);
insert into tab_district values (6469,7,'Melnik','central Bohemia',94725,38,28,1,3,6,63.40,9920,2.26,2.87,130,4289,4846);
insert into tab_district values (5519,7,'Melnik','central Bohemia',94725,38,28,1,3,6,63.40,9920,2.26,2.87,130,4289,4846);
insert into tab_district values (7294,7,'Melnik','central Bohemia',94725,38,28,1,3,6,63.40,9920,2.26,2.87,130,4289,4846);
insert into tab_district values (6932,7,'Melnik','central Bohemia',94725,38,28,1,3,6,63.40,9920,2.26,2.87,130,4289,4846);
insert into tab_district values (5953,8,'Mlada Boleslav','central Bohemia',112065,95,19,7,1,8,69.40,11277,1.25,1.44,127,5179,4987);
insert into tab_district values (7036,8,'Mlada Boleslav','central Bohemia',112065,95,19,7,1,8,69.40,11277,1.25,1.44,127,5179,4987);
insert into tab_district values (6970,8,'Mlada Boleslav','central Bohemia',112065,95,19,7,1,8,69.40,11277,1.25,1.44,127,5179,4987);
insert into tab_district values (5072,8,'Mlada Boleslav','central Bohemia',112065,95,19,7,1,8,69.40,11277,1.25,1.44,127,5179,4987);
insert into tab_district values (5774,8,'Mlada Boleslav','central Bohemia',112065,95,19,7,1,8,69.40,11277,1.25,1.44,127,5179,4987);
insert into tab_district values (6855,9,'Nymburk','central Bohemia',81344,61,23,4,2,6,55.30,8899,3.39,3.97,149,2987,2487);
insert into tab_district values (5932,9,'Nymburk','central Bohemia',81344,61,23,4,2,6,55.30,8899,3.39,3.97,149,2987,2487);
insert into tab_district values (6644,9,'Nymburk','central Bohemia',81344,61,23,4,2,6,55.30,8899,3.39,3.97,149,2987,2487);
insert into tab_district values (5398,9,'Nymburk','central Bohemia',81344,61,23,4,2,6,55.30,8899,3.39,3.97,149,2987,2487);
insert into tab_district values (5693,9,'Nymburk','central Bohemia',81344,61,23,4,2,6,55.30,8899,3.39,3.97,149,2987,2487);
insert into tab_district values (5922,9,'Nymburk','central Bohemia',81344,61,23,4,2,6,55.30,8899,3.39,3.97,149,2987,2487);
insert into tab_district values (6938,9,'Nymburk','central Bohemia',81344,61,23,4,2,6,55.30,8899,3.39,3.97,149,2987,2487);
insert into tab_district values (6142,9,'Nymburk','central Bohemia',81344,61,23,4,2,6,55.30,8899,3.39,3.97,149,2987,2487);
insert into tab_district values (6632,9,'Nymburk','central Bohemia',81344,61,23,4,2,6,55.30,8899,3.39,3.97,149,2987,2487);
insert into tab_district values (6841,10,'Praha - vychod','central Bohemia',92084,55,29,4,3,5,46.70,10124,0.56,0.54,141,3810,4316);
insert into tab_district values (5568,10,'Praha - vychod','central Bohemia',92084,55,29,4,3,5,46.70,10124,0.56,0.54,141,3810,4316);
insert into tab_district values (5591,10,'Praha - vychod','central Bohemia',92084,55,29,4,3,5,46.70,10124,0.56,0.54,141,3810,4316);
insert into tab_district values (6157,10,'Praha - vychod','central Bohemia',92084,55,29,4,3,5,46.70,10124,0.56,0.54,141,3810,4316);
insert into tab_district values (6633,10,'Praha - vychod','central Bohemia',92084,55,29,4,3,5,46.70,10124,0.56,0.54,141,3810,4316);
insert into tab_district values (6678,11,'Praha - zapad','central Bohemia',75637,35,36,9,0,7,36.50,9622,0.45,0.59,154,3475,3529);
insert into tab_district values (6956,11,'Praha - zapad','central Bohemia',75637,35,36,9,0,7,36.50,9622,0.45,0.59,154,3475,3529);
insert into tab_district values (6996,11,'Praha - zapad','central Bohemia',75637,35,36,9,0,7,36.50,9622,0.45,0.59,154,3475,3529);
insert into tab_district values (6871,11,'Praha - zapad','central Bohemia',75637,35,36,9,0,7,36.50,9622,0.45,0.59,154,3475,3529);
insert into tab_district values (6876,11,'Praha - zapad','central Bohemia',75637,35,36,9,0,7,36.50,9622,0.45,0.59,154,3475,3529);
insert into tab_district values (5549,11,'Praha - zapad','central Bohemia',75637,35,36,9,0,7,36.50,9622,0.45,0.59,154,3475,3529);
insert into tab_district values (5805,11,'Praha - zapad','central Bohemia',75637,35,36,9,0,7,36.50,9622,0.45,0.59,154,3475,3529);
insert into tab_district values (7176,11,'Praha - zapad','central Bohemia',75637,35,36,9,0,7,36.50,9622,0.45,0.59,154,3475,3529);
insert into tab_district values (5189,11,'Praha - zapad','central Bohemia',75637,35,36,9,0,7,36.50,9622,0.45,0.59,154,3475,3529);
insert into tab_district values (7249,11,'Praha - zapad','central Bohemia',75637,35,36,9,0,7,36.50,9622,0.45,0.59,154,3475,3529);
insert into tab_district values (6495,11,'Praha - zapad','central Bohemia',75637,35,36,9,0,7,36.50,9622,0.45,0.59,154,3475,3529);
insert into tab_district values (7151,12,'Pribram','central Bohemia',107870,84,29,6,1,6,58.00,8754,3.83,4.31,137,3804,3868);
insert into tab_district values (6316,12,'Pribram','central Bohemia',107870,84,29,6,1,6,58.00,8754,3.83,4.31,137,3804,3868);
insert into tab_district values (7004,12,'Pribram','central Bohemia',107870,84,29,6,1,6,58.00,8754,3.83,4.31,137,3804,3868);
insert into tab_district values (5665,12,'Pribram','central Bohemia',107870,84,29,6,1,6,58.00,8754,3.83,4.31,137,3804,3868);
insert into tab_district values (6004,12,'Pribram','central Bohemia',107870,84,29,6,1,6,58.00,8754,3.83,4.31,137,3804,3868);
insert into tab_district values (5325,12,'Pribram','central Bohemia',107870,84,29,6,1,6,58.00,8754,3.83,4.31,137,3804,3868);
insert into tab_district values (6461,12,'Pribram','central Bohemia',107870,84,29,6,1,6,58.00,8754,3.83,4.31,137,3804,3868);
insert into tab_district values (7271,12,'Pribram','central Bohemia',107870,84,29,6,1,6,58.00,8754,3.83,4.31,137,3804,3868);
insert into tab_district values (6059,13,'Rakovnik','central Bohemia',53921,61,22,1,1,2,41.30,8598,2.77,3.26,123,1597,1875);
insert into tab_district values (6027,13,'Rakovnik','central Bohemia',53921,61,22,1,1,2,41.30,8598,2.77,3.26,123,1597,1875);
insert into tab_district values (6137,13,'Rakovnik','central Bohemia',53921,61,22,1,1,2,41.30,8598,2.77,3.26,123,1597,1875);
insert into tab_district values (6569,13,'Rakovnik','central Bohemia',53921,61,22,1,1,2,41.30,8598,2.77,3.26,123,1597,1875);
insert into tab_district values (5210,13,'Rakovnik','central Bohemia',53921,61,22,1,1,2,41.30,8598,2.77,3.26,123,1597,1875);
insert into tab_district values (5082,13,'Rakovnik','central Bohemia',53921,61,22,1,1,2,41.30,8598,2.77,3.26,123,1597,1875);
insert into tab_district values (6687,13,'Rakovnik','central Bohemia',53921,61,22,1,1,2,41.30,8598,2.77,3.26,123,1597,1875);
insert into tab_district values (5428,13,'Rakovnik','central Bohemia',53921,61,22,1,1,2,41.30,8598,2.77,3.26,123,1597,1875);
insert into tab_district values (6734,14,'Ceske Budejovice','south Bohemia',177686,69,27,10,1,9,74.80,10045,1.42,1.71,135,6604,6295);
insert into tab_district values (6705,14,'Ceske Budejovice','south Bohemia',177686,69,27,10,1,9,74.80,10045,1.42,1.71,135,6604,6295);
insert into tab_district values (5889,14,'Ceske Budejovice','south Bohemia',177686,69,27,10,1,9,74.80,10045,1.42,1.71,135,6604,6295);
insert into tab_district values (5036,14,'Ceske Budejovice','south Bohemia',177686,69,27,10,1,9,74.80,10045,1.42,1.71,135,6604,6295);
insert into tab_district values (6173,14,'Ceske Budejovice','south Bohemia',177686,69,27,10,1,9,74.80,10045,1.42,1.71,135,6604,6295);
insert into tab_district values (7101,14,'Ceske Budejovice','south Bohemia',177686,69,27,10,1,9,74.80,10045,1.42,1.71,135,6604,6295);
insert into tab_district values (5611,14,'Ceske Budejovice','south Bohemia',177686,69,27,10,1,9,74.80,10045,1.42,1.71,135,6604,6295);
insert into tab_district values (5997,14,'Ceske Budejovice','south Bohemia',177686,69,27,10,1,9,74.80,10045,1.42,1.71,135,6604,6295);
insert into tab_district values (6210,15,'Cesky Krumlov','south Bohemia',58796,22,16,7,1,5,51.90,9045,3.13,3.60,124,1845,1879);
insert into tab_district values (6078,15,'Cesky Krumlov','south Bohemia',58796,22,16,7,1,5,51.90,9045,3.13,3.60,124,1845,1879);
insert into tab_district values (7284,15,'Cesky Krumlov','south Bohemia',58796,22,16,7,1,5,51.90,9045,3.13,3.60,124,1845,1879);
insert into tab_district values (6136,15,'Cesky Krumlov','south Bohemia',58796,22,16,7,1,5,51.90,9045,3.13,3.60,124,1845,1879);
insert into tab_district values (6144,15,'Cesky Krumlov','south Bohemia',58796,22,16,7,1,5,51.90,9045,3.13,3.60,124,1845,1879);
insert into tab_district values (5039,15,'Cesky Krumlov','south Bohemia',58796,22,16,7,1,5,51.90,9045,3.13,3.60,124,1845,1879);
insert into tab_district values (5980,15,'Cesky Krumlov','south Bohemia',58796,22,16,7,1,5,51.90,9045,3.13,3.60,124,1845,1879);
insert into tab_district values (4973,16,'Jindrichuv Hradec','south Bohemia',93931,74,21,10,1,8,56.90,8427,1.12,1.54,107,1874,1913);
insert into tab_district values (7253,16,'Jindrichuv Hradec','south Bohemia',93931,74,21,10,1,8,56.90,8427,1.12,1.54,107,1874,1913);
insert into tab_district values (7167,16,'Jindrichuv Hradec','south Bohemia',93931,74,21,10,1,8,56.90,8427,1.12,1.54,107,1874,1913);
insert into tab_district values (6544,16,'Jindrichuv Hradec','south Bohemia',93931,74,21,10,1,8,56.90,8427,1.12,1.54,107,1874,1913);
insert into tab_district values (5683,16,'Jindrichuv Hradec','south Bohemia',93931,74,21,10,1,8,56.90,8427,1.12,1.54,107,1874,1913);
insert into tab_district values (7233,16,'Jindrichuv Hradec','south Bohemia',93931,74,21,10,1,8,56.90,8427,1.12,1.54,107,1874,1913);
insert into tab_district values (6354,16,'Jindrichuv Hradec','south Bohemia',93931,74,21,10,1,8,56.90,8427,1.12,1.54,107,1874,1913);
insert into tab_district values (7202,16,'Jindrichuv Hradec','south Bohemia',93931,74,21,10,1,8,56.90,8427,1.12,1.54,107,1874,1913);
insert into tab_district values (6342,16,'Jindrichuv Hradec','south Bohemia',93931,74,21,10,1,8,56.90,8427,1.12,1.54,107,1874,1913);
insert into tab_district values (5390,16,'Jindrichuv Hradec','south Bohemia',93931,74,21,10,1,8,56.90,8427,1.12,1.54,107,1874,1913);
insert into tab_district values (5130,16,'Jindrichuv Hradec','south Bohemia',93931,74,21,10,1,8,56.90,8427,1.12,1.54,107,1874,1913);
insert into tab_district values (5893,17,'Pelhrimov','south Bohemia',74062,99,15,4,2,7,61.40,8114,2.38,2.62,119,1003,1181);
insert into tab_district values (6486,17,'Pelhrimov','south Bohemia',74062,99,15,4,2,7,61.40,8114,2.38,2.62,119,1003,1181);
insert into tab_district values (7046,17,'Pelhrimov','south Bohemia',74062,99,15,4,2,7,61.40,8114,2.38,2.62,119,1003,1181);
insert into tab_district values (6751,17,'Pelhrimov','south Bohemia',74062,99,15,4,2,7,61.40,8114,2.38,2.62,119,1003,1181);
insert into tab_district values (5451,18,'Pisek','south Bohemia',70699,60,13,2,1,4,65.30,8968,2.83,3.35,131,1740,1910);
insert into tab_district values (7235,18,'Pisek','south Bohemia',70699,60,13,2,1,4,65.30,8968,2.83,3.35,131,1740,1910);
insert into tab_district values (6856,18,'Pisek','south Bohemia',70699,60,13,2,1,4,65.30,8968,2.83,3.35,131,1740,1910);
insert into tab_district values (5533,19,'Prachatice','south Bohemia',51428,50,11,3,1,4,52.70,8402,3.13,3.98,120,999,1099);
insert into tab_district values (6725,19,'Prachatice','south Bohemia',51428,50,11,3,1,4,52.70,8402,3.13,3.98,120,999,1099);
insert into tab_district values (5409,19,'Prachatice','south Bohemia',51428,50,11,3,1,4,52.70,8402,3.13,3.98,120,999,1099);
insert into tab_district values (6589,19,'Prachatice','south Bohemia',51428,50,11,3,1,4,52.70,8402,3.13,3.98,120,999,1099);
insert into tab_district values (5329,19,'Prachatice','south Bohemia',51428,50,11,3,1,4,52.70,8402,3.13,3.98,120,999,1099);
insert into tab_district values (5134,19,'Prachatice','south Bohemia',51428,50,11,3,1,4,52.70,8402,3.13,3.98,120,999,1099);
insert into tab_district values (5237,19,'Prachatice','south Bohemia',51428,50,11,3,1,4,52.70,8402,3.13,3.98,120,999,1099);
insert into tab_district values (6571,19,'Prachatice','south Bohemia',51428,50,11,3,1,4,52.70,8402,3.13,3.98,120,999,1099);
insert into tab_district values (5582,19,'Prachatice','south Bohemia',51428,50,11,3,1,4,52.70,8402,3.13,3.98,120,999,1099);
insert into tab_district values (4968,19,'Prachatice','south Bohemia',51428,50,11,3,1,4,52.70,8402,3.13,3.98,120,999,1099);
insert into tab_district values (5245,19,'Prachatice','south Bohemia',51428,50,11,3,1,4,52.70,8402,3.13,3.98,120,999,1099);
insert into tab_district values (6237,19,'Prachatice','south Bohemia',51428,50,11,3,1,4,52.70,8402,3.13,3.98,120,999,1099);
insert into tab_district values (6147,19,'Prachatice','south Bohemia',51428,50,11,3,1,4,52.70,8402,3.13,3.98,120,999,1099);
insert into tab_district values (6508,19,'Prachatice','south Bohemia',51428,50,11,3,1,4,52.70,8402,3.13,3.98,120,999,1099);
insert into tab_district values (6998,20,'Strakonice','south Bohemia',70646,94,14,3,1,4,58.40,8547,2.65,3.64,120,1563,1542);
insert into tab_district values (6715,20,'Strakonice','south Bohemia',70646,94,14,3,1,4,58.40,8547,2.65,3.64,120,1563,1542);
insert into tab_district values (4967,20,'Strakonice','south Bohemia',70646,94,14,3,1,4,58.40,8547,2.65,3.64,120,1563,1542);
insert into tab_district values (6013,20,'Strakonice','south Bohemia',70646,94,14,3,1,4,58.40,8547,2.65,3.64,120,1563,1542);
insert into tab_district values (6712,20,'Strakonice','south Bohemia',70646,94,14,3,1,4,58.40,8547,2.65,3.64,120,1563,1542);
insert into tab_district values (5176,20,'Strakonice','south Bohemia',70646,94,14,3,1,4,58.40,8547,2.65,3.64,120,1563,1542);
insert into tab_district values (6934,21,'Tabor','south Bohemia',103347,87,16,7,1,7,67.00,9104,1.51,2.07,123,2299,2354);
insert into tab_district values (5124,21,'Tabor','south Bohemia',103347,87,16,7,1,7,67.00,9104,1.51,2.07,123,2299,2354);
insert into tab_district values (4961,21,'Tabor','south Bohemia',103347,87,16,7,1,7,67.00,9104,1.51,2.07,123,2299,2354);
insert into tab_district values (7119,21,'Tabor','south Bohemia',103347,87,16,7,1,7,67.00,9104,1.51,2.07,123,2299,2354);
insert into tab_district values (6501,21,'Tabor','south Bohemia',103347,87,16,7,1,7,67.00,9104,1.51,2.07,123,2299,2354);
insert into tab_district values (6545,21,'Tabor','south Bohemia',103347,87,16,7,1,7,67.00,9104,1.51,2.07,123,2299,2354);
insert into tab_district values (4989,21,'Tabor','south Bohemia',103347,87,16,7,1,7,67.00,9104,1.51,2.07,123,2299,2354);
insert into tab_district values (7122,22,'Domazlice','west Bohemia',58400,65,16,4,1,6,52.40,8620,1.10,1.25,100,1089,1117);
insert into tab_district values (7067,22,'Domazlice','west Bohemia',58400,65,16,4,1,6,52.40,8620,1.10,1.25,100,1089,1117);
insert into tab_district values (7115,23,'Cheb','west Bohemia',87419,21,11,4,3,9,85.50,8624,1.79,2.66,102,2879,3198);
insert into tab_district values (6580,23,'Cheb','west Bohemia',87419,21,11,4,3,9,85.50,8624,1.79,2.66,102,2879,3198);
insert into tab_district values (6605,23,'Cheb','west Bohemia',87419,21,11,4,3,9,85.50,8624,1.79,2.66,102,2879,3198);
insert into tab_district values (6729,23,'Cheb','west Bohemia',87419,21,11,4,3,9,85.50,8624,1.79,2.66,102,2879,3198);
insert into tab_district values (5877,24,'Karlovy Vary','west Bohemia',122603,25,21,6,2,8,80.00,8991,1.39,2.01,128,5198,5273);
insert into tab_district values (5464,24,'Karlovy Vary','west Bohemia',122603,25,21,6,2,8,80.00,8991,1.39,2.01,128,5198,5273);
insert into tab_district values (6650,24,'Karlovy Vary','west Bohemia',122603,25,21,6,2,8,80.00,8991,1.39,2.01,128,5198,5273);
insert into tab_district values (5420,24,'Karlovy Vary','west Bohemia',122603,25,21,6,2,8,80.00,8991,1.39,2.01,128,5198,5273);
insert into tab_district values (6235,24,'Karlovy Vary','west Bohemia',122603,25,21,6,2,8,80.00,8991,1.39,2.01,128,5198,5273);
insert into tab_district values (7034,24,'Karlovy Vary','west Bohemia',122603,25,21,6,2,8,80.00,8991,1.39,2.01,128,5198,5273);
insert into tab_district values (6111,24,'Karlovy Vary','west Bohemia',122603,25,21,6,2,8,80.00,8991,1.39,2.01,128,5198,5273);
insert into tab_district values (5897,24,'Karlovy Vary','west Bohemia',122603,25,21,6,2,8,80.00,8991,1.39,2.01,128,5198,5273);
insert into tab_district values (7230,25,'Klatovy','west Bohemia',88757,60,33,3,2,10,61.70,8554,2.47,2.68,113,1822,2218);
insert into tab_district values (7221,25,'Klatovy','west Bohemia',88757,60,33,3,2,10,61.70,8554,2.47,2.68,113,1822,2218);
insert into tab_district values (5208,25,'Klatovy','west Bohemia',88757,60,33,3,2,10,61.70,8554,2.47,2.68,113,1822,2218);
insert into tab_district values (6851,26,'Plzen - mesto','west Bohemia',170449,0,0,0,1,1,100.00,10787,2.64,3.09,131,6041,6261);
insert into tab_district values (6294,26,'Plzen - mesto','west Bohemia',170449,0,0,0,1,1,100.00,10787,2.64,3.09,131,6041,6261);
insert into tab_district values (5531,26,'Plzen - mesto','west Bohemia',170449,0,0,0,1,1,100.00,10787,2.64,3.09,131,6041,6261);
insert into tab_district values (5977,26,'Plzen - mesto','west Bohemia',170449,0,0,0,1,1,100.00,10787,2.64,3.09,131,6041,6261);
insert into tab_district values (6676,26,'Plzen - mesto','west Bohemia',170449,0,0,0,1,1,100.00,10787,2.64,3.09,131,6041,6261);
insert into tab_district values (5350,26,'Plzen - mesto','west Bohemia',170449,0,0,0,1,1,100.00,10787,2.64,3.09,131,6041,6261);
insert into tab_district values (5918,27,'Plzen - jih','west Bohemia',67298,71,19,10,0,7,43.80,8561,0.65,1.29,110,1029,1127);
insert into tab_district values (5923,27,'Plzen - jih','west Bohemia',67298,71,19,10,0,7,43.80,8561,0.65,1.29,110,1029,1127);
insert into tab_district values (7088,27,'Plzen - jih','west Bohemia',67298,71,19,10,0,7,43.80,8561,0.65,1.29,110,1029,1127);
insert into tab_district values (6215,27,'Plzen - jih','west Bohemia',67298,71,19,10,0,7,43.80,8561,0.65,1.29,110,1029,1127);
insert into tab_district values (7096,27,'Plzen - jih','west Bohemia',67298,71,19,10,0,7,43.80,8561,0.65,1.29,110,1029,1127);
insert into tab_district values (6607,27,'Plzen - jih','west Bohemia',67298,71,19,10,0,7,43.80,8561,0.65,1.29,110,1029,1127);
insert into tab_district values (5103,27,'Plzen - jih','west Bohemia',67298,71,19,10,0,7,43.80,8561,0.65,1.29,110,1029,1127);
insert into tab_district values (7001,27,'Plzen - jih','west Bohemia',67298,71,19,10,0,7,43.80,8561,0.65,1.29,110,1029,1127);
insert into tab_district values (5779,27,'Plzen - jih','west Bohemia',67298,71,19,10,0,7,43.80,8561,0.65,1.29,110,1029,1127);
insert into tab_district values (7255,28,'Plzen - sever','west Bohemia',72541,66,26,10,0,8,36.90,8594,1.62,2.01,112,1580,1525);
insert into tab_district values (5318,28,'Plzen - sever','west Bohemia',72541,66,26,10,0,8,36.90,8594,1.62,2.01,112,1580,1525);
insert into tab_district values (5310,28,'Plzen - sever','west Bohemia',72541,66,26,10,0,8,36.90,8594,1.62,2.01,112,1580,1525);
insert into tab_district values (5311,28,'Plzen - sever','west Bohemia',72541,66,26,10,0,8,36.90,8594,1.62,2.01,112,1580,1525);
insert into tab_district values (6088,28,'Plzen - sever','west Bohemia',72541,66,26,10,0,8,36.90,8594,1.62,2.01,112,1580,1525);
insert into tab_district values (5453,28,'Plzen - sever','west Bohemia',72541,66,26,10,0,8,36.90,8594,1.62,2.01,112,1580,1525);
insert into tab_district values (6861,28,'Plzen - sever','west Bohemia',72541,66,26,10,0,8,36.90,8594,1.62,2.01,112,1580,1525);
insert into tab_district values (6868,29,'Rokycany','west Bohemia',45714,52,10,5,1,6,55.60,8843,2.82,3.60,113,818,888);
insert into tab_district values (5625,29,'Rokycany','west Bohemia',45714,52,10,5,1,6,55.60,8843,2.82,3.60,113,818,888);
insert into tab_district values (5418,29,'Rokycany','west Bohemia',45714,52,10,5,1,6,55.60,8843,2.82,3.60,113,818,888);
insert into tab_district values (6704,29,'Rokycany','west Bohemia',45714,52,10,5,1,6,55.60,8843,2.82,3.60,113,818,888);
insert into tab_district values (6242,29,'Rokycany','west Bohemia',45714,52,10,5,1,6,55.60,8843,2.82,3.60,113,818,888);
insert into tab_district values (6677,29,'Rokycany','west Bohemia',45714,52,10,5,1,6,55.60,8843,2.82,3.60,113,818,888);
insert into tab_district values (5061,29,'Rokycany','west Bohemia',45714,52,10,5,1,6,55.60,8843,2.82,3.60,113,818,888);
insert into tab_district values (5861,29,'Rokycany','west Bohemia',45714,52,10,5,1,6,55.60,8843,2.82,3.60,113,818,888);
insert into tab_district values (5314,30,'Sokolov','west Bohemia',94812,15,13,8,2,10,81.80,9650,3.38,3.67,100,2985,2804);
insert into tab_district values (6903,30,'Sokolov','west Bohemia',94812,15,13,8,2,10,81.80,9650,3.38,3.67,100,2985,2804);
insert into tab_district values (6686,31,'Tachov','west Bohemia',51313,34,12,3,1,4,59.20,8930,3.52,4.20,108,1328,1452);
insert into tab_district values (5269,31,'Tachov','west Bohemia',51313,34,12,3,1,4,59.20,8930,3.52,4.20,108,1328,1452);
insert into tab_district values (5312,31,'Tachov','west Bohemia',51313,34,12,3,1,4,59.20,8930,3.52,4.20,108,1328,1452);
insert into tab_district values (6306,31,'Tachov','west Bohemia',51313,34,12,3,1,4,59.20,8930,3.52,4.20,108,1328,1452);
insert into tab_district values (6303,31,'Tachov','west Bohemia',51313,34,12,3,1,4,59.20,8930,3.52,4.20,108,1328,1452);
insert into tab_district values (5388,31,'Tachov','west Bohemia',51313,34,12,3,1,4,59.20,8930,3.52,4.20,108,1328,1452);
insert into tab_district values (6949,31,'Tachov','west Bohemia',51313,34,12,3,1,4,59.20,8930,3.52,4.20,108,1328,1452);
insert into tab_district values (5413,31,'Tachov','west Bohemia',51313,34,12,3,1,4,59.20,8930,3.52,4.20,108,1328,1452);
insert into tab_district values (5882,32,'Ceska Lipa','north Bohemia',105058,32,19,7,2,10,81.00,9272,2.80,3.22,118,4340,4505);
insert into tab_district values (6852,32,'Ceska Lipa','north Bohemia',105058,32,19,7,2,10,81.00,9272,2.80,3.22,118,4340,4505);
insert into tab_district values (5088,32,'Ceska Lipa','north Bohemia',105058,32,19,7,2,10,81.00,9272,2.80,3.22,118,4340,4505);
insert into tab_district values (7219,32,'Ceska Lipa','north Bohemia',105058,32,19,7,2,10,81.00,9272,2.80,3.22,118,4340,4505);
insert into tab_district values (7242,32,'Ceska Lipa','north Bohemia',105058,32,19,7,2,10,81.00,9272,2.80,3.22,118,4340,4505);
insert into tab_district values (5337,32,'Ceska Lipa','north Bohemia',105058,32,19,7,2,10,81.00,9272,2.80,3.22,118,4340,4505);
insert into tab_district values (7279,33,'Decin','north Bohemia',133777,24,17,7,3,11,84.70,8705,5.75,7.61,116,4650,4859);
insert into tab_district values (5463,33,'Decin','north Bohemia',133777,24,17,7,3,11,84.70,8705,5.75,7.61,116,4650,4859);
insert into tab_district values (5445,33,'Decin','north Bohemia',133777,24,17,7,3,11,84.70,8705,5.75,7.61,116,4650,4859);
insert into tab_district values (6007,33,'Decin','north Bohemia',133777,24,17,7,3,11,84.70,8705,5.75,7.61,116,4650,4859);
insert into tab_district values (5414,34,'Chomutov','north Bohemia',125236,28,11,1,4,5,87.70,9675,6.43,7.68,100,5323,5190);
insert into tab_district values (6600,34,'Chomutov','north Bohemia',125236,28,11,1,4,5,87.70,9675,6.43,7.68,100,5323,5190);
insert into tab_district values (6112,34,'Chomutov','north Bohemia',125236,28,11,1,4,5,87.70,9675,6.43,7.68,100,5323,5190);
insert into tab_district values (6254,34,'Chomutov','north Bohemia',125236,28,11,1,4,5,87.70,9675,6.43,7.68,100,5323,5190);
insert into tab_district values (7072,34,'Chomutov','north Bohemia',125236,28,11,1,4,5,87.70,9675,6.43,7.68,100,5323,5190);
insert into tab_district values (6312,34,'Chomutov','north Bohemia',125236,28,11,1,4,5,87.70,9675,6.43,7.68,100,5323,5190);
insert into tab_district values (5682,34,'Chomutov','north Bohemia',125236,28,11,1,4,5,87.70,9675,6.43,7.68,100,5323,5190);
insert into tab_district values (5241,34,'Chomutov','north Bohemia',125236,28,11,1,4,5,87.70,9675,6.43,7.68,100,5323,5190);
insert into tab_district values (7201,34,'Chomutov','north Bohemia',125236,28,11,1,4,5,87.70,9675,6.43,7.68,100,5323,5190);
insert into tab_district values (6355,35,'Jablonec n. Nisou','north Bohemia',88768,10,18,5,1,7,80.50,8867,1.02,1.21,130,3384,3620);
insert into tab_district values (4990,36,'Liberec','north Bohemia',159617,29,19,8,1,9,85.20,9198,3.33,4.28,131,5796,6132);
insert into tab_district values (5799,36,'Liberec','north Bohemia',159617,29,19,8,1,9,85.20,9198,3.33,4.28,131,5796,6132);
insert into tab_district values (7110,36,'Liberec','north Bohemia',159617,29,19,8,1,9,85.20,9198,3.33,4.28,131,5796,6132);
insert into tab_district values (6641,36,'Liberec','north Bohemia',159617,29,19,8,1,9,85.20,9198,3.33,4.28,131,5796,6132);
insert into tab_district values (7187,36,'Liberec','north Bohemia',159617,29,19,8,1,9,85.20,9198,3.33,4.28,131,5796,6132);
insert into tab_district values (6415,36,'Liberec','north Bohemia',159617,29,19,8,1,9,85.20,9198,3.33,4.28,131,5796,6132);
insert into tab_district values (5313,36,'Liberec','north Bohemia',159617,29,19,8,1,9,85.20,9198,3.33,4.28,131,5796,6132);
insert into tab_district values (6875,37,'Litomerice','north Bohemia',114006,71,26,6,2,9,62.30,9065,4.46,5.39,123,4147,4166);
insert into tab_district values (7250,37,'Litomerice','north Bohemia',114006,71,26,6,2,9,62.30,9065,4.46,5.39,123,4147,4166);
insert into tab_district values (5365,37,'Litomerice','north Bohemia',114006,71,26,6,2,9,62.30,9065,4.46,5.39,123,4147,4166);
insert into tab_district values (6667,37,'Litomerice','north Bohemia',114006,71,26,6,2,9,62.30,9065,4.46,5.39,123,4147,4166);
insert into tab_district values (5148,37,'Litomerice','north Bohemia',114006,71,26,6,2,9,62.30,9065,4.46,5.39,123,4147,4166);
insert into tab_district values (5773,37,'Litomerice','north Bohemia',114006,71,26,6,2,9,62.30,9065,4.46,5.39,123,4147,4166);
insert into tab_district values (5741,37,'Litomerice','north Bohemia',114006,71,26,6,2,9,62.30,9065,4.46,5.39,123,4147,4166);
insert into tab_district values (7087,38,'Louny','north Bohemia',85852,41,23,4,2,4,59.80,8965,7.08,8.23,104,2653,2822);
insert into tab_district values (6279,38,'Louny','north Bohemia',85852,41,23,4,2,4,59.80,8965,7.08,8.23,104,2653,2822);
insert into tab_district values (5616,38,'Louny','north Bohemia',85852,41,23,4,2,4,59.80,8965,7.08,8.23,104,2653,2822);
insert into tab_district values (6357,38,'Louny','north Bohemia',85852,41,23,4,2,4,59.80,8965,7.08,8.23,104,2653,2822);
insert into tab_district values (5865,38,'Louny','north Bohemia',85852,41,23,4,2,4,59.80,8965,7.08,8.23,104,2653,2822);
insert into tab_district values (5027,38,'Louny','north Bohemia',85852,41,23,4,2,4,59.80,8965,7.08,8.23,104,2653,2822);
insert into tab_district values (5610,38,'Louny','north Bohemia',85852,41,23,4,2,4,59.80,8965,7.08,8.23,104,2653,2822);
insert into tab_district values (5723,38,'Louny','north Bohemia',85852,41,23,4,2,4,59.80,8965,7.08,8.23,104,2653,2822);
insert into tab_district values (6336,38,'Louny','north Bohemia',85852,41,23,4,2,4,59.80,8965,7.08,8.23,104,2653,2822);
insert into tab_district values (6961,38,'Louny','north Bohemia',85852,41,23,4,2,4,59.80,8965,7.08,8.23,104,2653,2822);
insert into tab_district values (6591,38,'Louny','north Bohemia',85852,41,23,4,2,4,59.80,8965,7.08,8.23,104,2653,2822);
insert into tab_district values (5212,38,'Louny','north Bohemia',85852,41,23,4,2,4,59.80,8965,7.08,8.23,104,2653,2822);
insert into tab_district values (6421,38,'Louny','north Bohemia',85852,41,23,4,2,4,59.80,8965,7.08,8.23,104,2653,2822);
insert into tab_district values (6520,39,'Most','north Bohemia',119895,17,4,3,2,4,89.90,10446,7.34,9.40,90,4947,4743);
insert into tab_district values (7130,39,'Most','north Bohemia',119895,17,4,3,2,4,89.90,10446,7.34,9.40,90,4947,4743);
insert into tab_district values (5880,39,'Most','north Bohemia',119895,17,4,3,2,4,89.90,10446,7.34,9.40,90,4947,4743);
insert into tab_district values (5614,39,'Most','north Bohemia',119895,17,4,3,2,4,89.90,10446,7.34,9.40,90,4947,4743);
insert into tab_district values (5125,39,'Most','north Bohemia',119895,17,4,3,2,4,89.90,10446,7.34,9.40,90,4947,4743);
insert into tab_district values (4996,40,'Teplice','north Bohemia',128118,9,16,6,3,8,85.30,9317,6.49,7.07,97,6949,6872);
insert into tab_district values (6810,40,'Teplice','north Bohemia',128118,9,16,6,3,8,85.30,9317,6.49,7.07,97,6949,6872);
insert into tab_district values (6553,40,'Teplice','north Bohemia',128118,9,16,6,3,8,85.30,9317,6.49,7.07,97,6949,6872);
insert into tab_district values (6087,40,'Teplice','north Bohemia',128118,9,16,6,3,8,85.30,9317,6.49,7.07,97,6949,6872);
insert into tab_district values (5599,40,'Teplice','north Bohemia',128118,9,16,6,3,8,85.30,9317,6.49,7.07,97,6949,6872);
insert into tab_district values (5319,40,'Teplice','north Bohemia',128118,9,16,6,3,8,85.30,9317,6.49,7.07,97,6949,6872);
insert into tab_district values (5260,41,'Usti nad Labem','north Bohemia',118650,8,8,5,1,3,85.60,9832,3.32,4.48,114,6445,5471);
insert into tab_district values (7166,41,'Usti nad Labem','north Bohemia',118650,8,8,5,1,3,85.60,9832,3.32,4.48,114,6445,5471);
insert into tab_district values (6407,41,'Usti nad Labem','north Bohemia',118650,8,8,5,1,3,85.60,9832,3.32,4.48,114,6445,5471);
insert into tab_district values (5589,42,'Havlickuv Brod','east Bohemia',95907,87,25,5,2,7,59.10,8388,2.41,2.94,87,1658,1668);
insert into tab_district values (5042,42,'Havlickuv Brod','east Bohemia',95907,87,25,5,2,7,59.10,8388,2.41,2.94,87,1658,1668);
insert into tab_district values (5999,42,'Havlickuv Brod','east Bohemia',95907,87,25,5,2,7,59.10,8388,2.41,2.94,87,1658,1668);
insert into tab_district values (5674,42,'Havlickuv Brod','east Bohemia',95907,87,25,5,2,7,59.10,8388,2.41,2.94,87,1658,1668);
insert into tab_district values (5384,42,'Havlickuv Brod','east Bohemia',95907,87,25,5,2,7,59.10,8388,2.41,2.94,87,1658,1668);
insert into tab_district values (5358,42,'Havlickuv Brod','east Bohemia',95907,87,25,5,2,7,59.10,8388,2.41,2.94,87,1658,1668);
insert into tab_district values (6169,42,'Havlickuv Brod','east Bohemia',95907,87,25,5,2,7,59.10,8388,2.41,2.94,87,1658,1668);
insert into tab_district values (6006,43,'Hradec Kralove','east Bohemia',161854,73,21,6,1,6,76.30,9425,1.72,2.50,125,4085,3891);
insert into tab_district values (6535,43,'Hradec Kralove','east Bohemia',161854,73,21,6,1,6,76.30,9425,1.72,2.50,125,4085,3891);
insert into tab_district values (6386,43,'Hradec Kralove','east Bohemia',161854,73,21,6,1,6,76.30,9425,1.72,2.50,125,4085,3891);
insert into tab_district values (6130,43,'Hradec Kralove','east Bohemia',161854,73,21,6,1,6,76.30,9425,1.72,2.50,125,4085,3891);
insert into tab_district values (6824,43,'Hradec Kralove','east Bohemia',161854,73,21,6,1,6,76.30,9425,1.72,2.50,125,4085,3891);
insert into tab_district values (5593,44,'Chrudim','east Bohemia',105606,77,26,7,2,7,53.00,8254,2.79,3.76,97,2166,2325);
insert into tab_district values (7227,44,'Chrudim','east Bohemia',105606,77,26,7,2,7,53.00,8254,2.79,3.76,97,2166,2325);
insert into tab_district values (6642,44,'Chrudim','east Bohemia',105606,77,26,7,2,7,53.00,8254,2.79,3.76,97,2166,2325);
insert into tab_district values (5765,44,'Chrudim','east Bohemia',105606,77,26,7,2,7,53.00,8254,2.79,3.76,97,2166,2325);
insert into tab_district values (7091,44,'Chrudim','east Bohemia',105606,77,26,7,2,7,53.00,8254,2.79,3.76,97,2166,2325);
insert into tab_district values (4988,44,'Chrudim','east Bohemia',105606,77,26,7,2,7,53.00,8254,2.79,3.76,97,2166,2325);
insert into tab_district values (6103,44,'Chrudim','east Bohemia',105606,77,26,7,2,7,53.00,8254,2.79,3.76,97,2166,2325);
insert into tab_district values (6077,44,'Chrudim','east Bohemia',105606,77,26,7,2,7,53.00,8254,2.79,3.76,97,2166,2325);
insert into tab_district values (5895,45,'Jicin','east Bohemia',77917,85,19,6,1,5,53.50,8390,2.28,2.89,132,2080,2122);
insert into tab_district values (6207,45,'Jicin','east Bohemia',77917,85,19,6,1,5,53.50,8390,2.28,2.89,132,2080,2122);
insert into tab_district values (7192,45,'Jicin','east Bohemia',77917,85,19,6,1,5,53.50,8390,2.28,2.89,132,2080,2122);
insert into tab_district values (6668,45,'Jicin','east Bohemia',77917,85,19,6,1,5,53.50,8390,2.28,2.89,132,2080,2122);
insert into tab_district values (5172,45,'Jicin','east Bohemia',77917,85,19,6,1,5,53.50,8390,2.28,2.89,132,2080,2122);
insert into tab_district values (6863,45,'Jicin','east Bohemia',77917,85,19,6,1,5,53.50,8390,2.28,2.89,132,2080,2122);
insert into tab_district values (5160,45,'Jicin','east Bohemia',77917,85,19,6,1,5,53.50,8390,2.28,2.89,132,2080,2122);
insert into tab_district values (5316,46,'Nachod','east Bohemia',112709,48,20,7,3,10,73.50,8369,1.79,2.31,117,2854,2618);
insert into tab_district values (6746,46,'Nachod','east Bohemia',112709,48,20,7,3,10,73.50,8369,1.79,2.31,117,2854,2618);
insert into tab_district values (5043,46,'Nachod','east Bohemia',112709,48,20,7,3,10,73.50,8369,1.79,2.31,117,2854,2618);
insert into tab_district values (5973,46,'Nachod','east Bohemia',112709,48,20,7,3,10,73.50,8369,1.79,2.31,117,2854,2618);
insert into tab_district values (6554,46,'Nachod','east Bohemia',112709,48,20,7,3,10,73.50,8369,1.79,2.31,117,2854,2618);
insert into tab_district values (7195,46,'Nachod','east Bohemia',112709,48,20,7,3,10,73.50,8369,1.79,2.31,117,2854,2618);
insert into tab_district values (6083,47,'Pardubice','east Bohemia',162580,83,26,5,1,6,72.80,9538,1.51,1.81,111,6079,5410);
insert into tab_district values (6227,47,'Pardubice','east Bohemia',162580,83,26,5,1,6,72.80,9538,1.51,1.81,111,6079,5410);
insert into tab_district values (6836,47,'Pardubice','east Bohemia',162580,83,26,5,1,6,72.80,9538,1.51,1.81,111,6079,5410);
insert into tab_district values (6732,47,'Pardubice','east Bohemia',162580,83,26,5,1,6,72.80,9538,1.51,1.81,111,6079,5410);
insert into tab_district values (5041,47,'Pardubice','east Bohemia',162580,83,26,5,1,6,72.80,9538,1.51,1.81,111,6079,5410);
insert into tab_district values (5989,47,'Pardubice','east Bohemia',162580,83,26,5,1,6,72.80,9538,1.51,1.81,111,6079,5410);
insert into tab_district values (5293,47,'Pardubice','east Bohemia',162580,83,26,5,1,6,72.80,9538,1.51,1.81,111,6079,5410);
insert into tab_district values (6643,47,'Pardubice','east Bohemia',162580,83,26,5,1,6,72.80,9538,1.51,1.81,111,6079,5410);
insert into tab_district values (6819,47,'Pardubice','east Bohemia',162580,83,26,5,1,6,72.80,9538,1.51,1.81,111,6079,5410);
insert into tab_district values (6104,47,'Pardubice','east Bohemia',162580,83,26,5,1,6,72.80,9538,1.51,1.81,111,6079,5410);
insert into tab_district values (5713,48,'Rychnov nad Kneznou','east Bohemia',78955,50,24,8,1,9,59.00,9060,1.78,2.44,124,1655,1717);
insert into tab_district values (6358,48,'Rychnov nad Kneznou','east Bohemia',78955,50,24,8,1,9,59.00,9060,1.78,2.44,124,1655,1717);
insert into tab_district values (6675,48,'Rychnov nad Kneznou','east Bohemia',78955,50,24,8,1,9,59.00,9060,1.78,2.44,124,1655,1717);
insert into tab_district values (6302,48,'Rychnov nad Kneznou','east Bohemia',78955,50,24,8,1,9,59.00,9060,1.78,2.44,124,1655,1717);
insert into tab_district values (5620,48,'Rychnov nad Kneznou','east Bohemia',78955,50,24,8,1,9,59.00,9060,1.78,2.44,124,1655,1717);
insert into tab_district values (6699,48,'Rychnov nad Kneznou','east Bohemia',78955,50,24,8,1,9,59.00,9060,1.78,2.44,124,1655,1717);
insert into tab_district values (6076,49,'Semily','east Bohemia',75685,31,28,5,1,9,60.80,8208,1.89,2.26,155,1660,2123);
insert into tab_district values (6356,49,'Semily','east Bohemia',75685,31,28,5,1,9,60.80,8208,1.89,2.26,155,1660,2123);
insert into tab_district values (6474,49,'Semily','east Bohemia',75685,31,28,5,1,9,60.80,8208,1.89,2.26,155,1660,2123);
insert into tab_district values (6568,50,'Svitavy','east Bohemia',102609,75,33,2,3,6,52.00,8187,4.83,5.45,94,2123,2134);
insert into tab_district values (5699,50,'Svitavy','east Bohemia',102609,75,33,2,3,6,52.00,8187,4.83,5.45,94,2123,2134);
insert into tab_district values (7292,50,'Svitavy','east Bohemia',102609,75,33,2,3,6,52.00,8187,4.83,5.45,94,2123,2134);
insert into tab_district values (7209,50,'Svitavy','east Bohemia',102609,75,33,2,3,6,52.00,8187,4.83,5.45,94,2123,2134);
insert into tab_district values (6682,50,'Svitavy','east Bohemia',102609,75,33,2,3,6,52.00,8187,4.83,5.45,94,2123,2134);
insert into tab_district values (6216,50,'Svitavy','east Bohemia',102609,75,33,2,3,6,52.00,8187,4.83,5.45,94,2123,2134);
insert into tab_district values (5900,50,'Svitavy','east Bohemia',102609,75,33,2,3,6,52.00,8187,4.83,5.45,94,2123,2134);
insert into tab_district values (6313,50,'Svitavy','east Bohemia',102609,75,33,2,3,6,52.00,8187,4.83,5.45,94,2123,2134);
insert into tab_district values (7226,50,'Svitavy','east Bohemia',102609,75,33,2,3,6,52.00,8187,4.83,5.45,94,2123,2134);
insert into tab_district values (5270,50,'Svitavy','east Bohemia',102609,75,33,2,3,6,52.00,8187,4.83,5.45,94,2123,2134);
insert into tab_district values (5446,50,'Svitavy','east Bohemia',102609,75,33,2,3,6,52.00,8187,4.83,5.45,94,2123,2134);
insert into tab_district values (5817,50,'Svitavy','east Bohemia',102609,75,33,2,3,6,52.00,8187,4.83,5.45,94,2123,2134);
insert into tab_district values (6435,51,'Trutnov','east Bohemia',121947,37,28,7,3,11,70.50,8541,2.51,2.97,131,3496,3839);
insert into tab_district values (6621,51,'Trutnov','east Bohemia',121947,37,28,7,3,11,70.50,8541,2.51,2.97,131,3496,3839);
insert into tab_district values (5482,51,'Trutnov','east Bohemia',121947,37,28,7,3,11,70.50,8541,2.51,2.97,131,3496,3839);
insert into tab_district values (5389,51,'Trutnov','east Bohemia',121947,37,28,7,3,11,70.50,8541,2.51,2.97,131,3496,3839);
insert into tab_district values (6872,51,'Trutnov','east Bohemia',121947,37,28,7,3,11,70.50,8541,2.51,2.97,131,3496,3839);
insert into tab_district values (6695,51,'Trutnov','east Bohemia',121947,37,28,7,3,11,70.50,8541,2.51,2.97,131,3496,3839);
insert into tab_district values (5804,52,'Usti nad Orlici','east Bohemia',139012,59,41,8,3,10,61.90,8363,2.52,3.49,108,2564,2799);
insert into tab_district values (5526,52,'Usti nad Orlici','east Bohemia',139012,59,41,8,3,10,61.90,8363,2.52,3.49,108,2564,2799);
insert into tab_district values (6578,52,'Usti nad Orlici','east Bohemia',139012,59,41,8,3,10,61.90,8363,2.52,3.49,108,2564,2799);
insert into tab_district values (6175,52,'Usti nad Orlici','east Bohemia',139012,59,41,8,3,10,61.90,8363,2.52,3.49,108,2564,2799);
insert into tab_district values (5469,52,'Usti nad Orlici','east Bohemia',139012,59,41,8,3,10,61.90,8363,2.52,3.49,108,2564,2799);
insert into tab_district values (5527,52,'Usti nad Orlici','east Bohemia',139012,59,41,8,3,10,61.90,8363,2.52,3.49,108,2564,2799);
insert into tab_district values (6120,52,'Usti nad Orlici','east Bohemia',139012,59,41,8,3,10,61.90,8363,2.52,3.49,108,2564,2799);
insert into tab_district values (5131,52,'Usti nad Orlici','east Bohemia',139012,59,41,8,3,10,61.90,8363,2.52,3.49,108,2564,2799);
insert into tab_district values (5382,52,'Usti nad Orlici','east Bohemia',139012,59,41,8,3,10,61.90,8363,2.52,3.49,108,2564,2799);
insert into tab_district values (6992,52,'Usti nad Orlici','east Bohemia',139012,59,41,8,3,10,61.90,8363,2.52,3.49,108,2564,2799);
insert into tab_district values (5169,52,'Usti nad Orlici','east Bohemia',139012,59,41,8,3,10,61.90,8363,2.52,3.49,108,2564,2799);
insert into tab_district values (5988,52,'Usti nad Orlici','east Bohemia',139012,59,41,8,3,10,61.90,8363,2.52,3.49,108,2564,2799);
insert into tab_district values (6599,52,'Usti nad Orlici','east Bohemia',139012,59,41,8,3,10,61.90,8363,2.52,3.49,108,2564,2799);
insert into tab_district values (5772,52,'Usti nad Orlici','east Bohemia',139012,59,41,8,3,10,61.90,8363,2.52,3.49,108,2564,2799);
insert into tab_district values (5360,53,'Blansko','south Moravia',107911,88,33,6,2,7,50.90,8240,2.53,3.56,99,1850,1903);
insert into tab_district values (5236,53,'Blansko','south Moravia',107911,88,33,6,2,7,50.90,8240,2.53,3.56,99,1850,1903);
insert into tab_district values (5229,53,'Blansko','south Moravia',107911,88,33,6,2,7,50.90,8240,2.53,3.56,99,1850,1903);
insert into tab_district values (6755,53,'Blansko','south Moravia',107911,88,33,6,2,7,50.90,8240,2.53,3.56,99,1850,1903);
insert into tab_district values (5758,53,'Blansko','south Moravia',107911,88,33,6,2,7,50.90,8240,2.53,3.56,99,1850,1903);
insert into tab_district values (5718,53,'Blansko','south Moravia',107911,88,33,6,2,7,50.90,8240,2.53,3.56,99,1850,1903);
insert into tab_district values (6015,53,'Blansko','south Moravia',107911,88,33,6,2,7,50.90,8240,2.53,3.56,99,1850,1903);
insert into tab_district values (5367,54,'Brno - mesto','south Moravia',387570,0,0,0,1,1,100.00,9897,1.60,1.96,140,18721,18696);
insert into tab_district values (5174,54,'Brno - mesto','south Moravia',387570,0,0,0,1,1,100.00,9897,1.60,1.96,140,18721,18696);
insert into tab_district values (6011,54,'Brno - mesto','south Moravia',387570,0,0,0,1,1,100.00,9897,1.60,1.96,140,18721,18696);
insert into tab_district values (6625,54,'Brno - mesto','south Moravia',387570,0,0,0,1,1,100.00,9897,1.60,1.96,140,18721,18696);
insert into tab_district values (6350,54,'Brno - mesto','south Moravia',387570,0,0,0,1,1,100.00,9897,1.60,1.96,140,18721,18696);
insert into tab_district values (6534,54,'Brno - mesto','south Moravia',387570,0,0,0,1,1,100.00,9897,1.60,1.96,140,18721,18696);
insert into tab_district values (7097,54,'Brno - mesto','south Moravia',387570,0,0,0,1,1,100.00,9897,1.60,1.96,140,18721,18696);
insert into tab_district values (5754,54,'Brno - mesto','south Moravia',387570,0,0,0,1,1,100.00,9897,1.60,1.96,140,18721,18696);
insert into tab_district values (6659,54,'Brno - mesto','south Moravia',387570,0,0,0,1,1,100.00,9897,1.60,1.96,140,18721,18696);
insert into tab_district values (7295,54,'Brno - mesto','south Moravia',387570,0,0,0,1,1,100.00,9897,1.60,1.96,140,18721,18696);
insert into tab_district values (5784,54,'Brno - mesto','south Moravia',387570,0,0,0,1,1,100.00,9897,1.60,1.96,140,18721,18696);
insert into tab_district values (6019,54,'Brno - mesto','south Moravia',387570,0,0,0,1,1,100.00,9897,1.60,1.96,140,18721,18696);
insert into tab_district values (6202,54,'Brno - mesto','south Moravia',387570,0,0,0,1,1,100.00,9897,1.60,1.96,140,18721,18696);
insert into tab_district values (6984,54,'Brno - mesto','south Moravia',387570,0,0,0,1,1,100.00,9897,1.60,1.96,140,18721,18696);
insert into tab_district values (5963,54,'Brno - mesto','south Moravia',387570,0,0,0,1,1,100.00,9897,1.60,1.96,140,18721,18696);
insert into tab_district values (6730,54,'Brno - mesto','south Moravia',387570,0,0,0,1,1,100.00,9897,1.60,1.96,140,18721,18696);
insert into tab_district values (6249,54,'Brno - mesto','south Moravia',387570,0,0,0,1,1,100.00,9897,1.60,1.96,140,18721,18696);
insert into tab_district values (5063,54,'Brno - mesto','south Moravia',387570,0,0,0,1,1,100.00,9897,1.60,1.96,140,18721,18696);
insert into tab_district values (5808,54,'Brno - mesto','south Moravia',387570,0,0,0,1,1,100.00,9897,1.60,1.96,140,18721,18696);
insert into tab_district values (6922,54,'Brno - mesto','south Moravia',387570,0,0,0,1,1,100.00,9897,1.60,1.96,140,18721,18696);
insert into tab_district values (5044,54,'Brno - mesto','south Moravia',387570,0,0,0,1,1,100.00,9897,1.60,1.96,140,18721,18696);
insert into tab_district values (6985,54,'Brno - mesto','south Moravia',387570,0,0,0,1,1,100.00,9897,1.60,1.96,140,18721,18696);
insert into tab_district values (5126,54,'Brno - mesto','south Moravia',387570,0,0,0,1,1,100.00,9897,1.60,1.96,140,18721,18696);
insert into tab_district values (6054,54,'Brno - mesto','south Moravia',387570,0,0,0,1,1,100.00,9897,1.60,1.96,140,18721,18696);
insert into tab_district values (7061,55,'Brno - venkov','south Moravia',157042,49,70,18,0,9,33.90,8743,1.88,2.43,111,3659,3894);
insert into tab_district values (6064,55,'Brno - venkov','south Moravia',157042,49,70,18,0,9,33.90,8743,1.88,2.43,111,3659,3894);
insert into tab_district values (5221,55,'Brno - venkov','south Moravia',157042,49,70,18,0,9,33.90,8743,1.88,2.43,111,3659,3894);
insert into tab_district values (5214,55,'Brno - venkov','south Moravia',157042,49,70,18,0,9,33.90,8743,1.88,2.43,111,3659,3894);
insert into tab_district values (6624,55,'Brno - venkov','south Moravia',157042,49,70,18,0,9,33.90,8743,1.88,2.43,111,3659,3894);
insert into tab_district values (5320,55,'Brno - venkov','south Moravia',157042,49,70,18,0,9,33.90,8743,1.88,2.43,111,3659,3894);
insert into tab_district values (7164,55,'Brno - venkov','south Moravia',157042,49,70,18,0,9,33.90,8743,1.88,2.43,111,3659,3894);
insert into tab_district values (7154,55,'Brno - venkov','south Moravia',157042,49,70,18,0,9,33.90,8743,1.88,2.43,111,3659,3894);
insert into tab_district values (6437,55,'Brno - venkov','south Moravia',157042,49,70,18,0,9,33.90,8743,1.88,2.43,111,3659,3894);
insert into tab_district values (7121,55,'Brno - venkov','south Moravia',157042,49,70,18,0,9,33.90,8743,1.88,2.43,111,3659,3894);
insert into tab_district values (6539,56,'Breclav','south Moravia',124605,11,42,14,1,8,46.00,8772,4.69,4.98,126,2854,3158);
insert into tab_district values (5032,56,'Breclav','south Moravia',124605,11,42,14,1,8,46.00,8772,4.69,4.98,126,2854,3158);
insert into tab_district values (5226,56,'Breclav','south Moravia',124605,11,42,14,1,8,46.00,8772,4.69,4.98,126,2854,3158);
insert into tab_district values (6859,56,'Breclav','south Moravia',124605,11,42,14,1,8,46.00,8772,4.69,4.98,126,2854,3158);
insert into tab_district values (5909,56,'Breclav','south Moravia',124605,11,42,14,1,8,46.00,8772,4.69,4.98,126,2854,3158);
insert into tab_district values (5837,56,'Breclav','south Moravia',124605,11,42,14,1,8,46.00,8772,4.69,4.98,126,2854,3158);
insert into tab_district values (6232,56,'Breclav','south Moravia',124605,11,42,14,1,8,46.00,8772,4.69,4.98,126,2854,3158);
insert into tab_district values (5351,57,'Hodonin','south Moravia',161954,21,37,20,3,8,48.00,8720,3.73,4.50,116,3729,3651);
insert into tab_district values (5532,57,'Hodonin','south Moravia',161954,21,37,20,3,8,48.00,8720,3.73,4.50,116,3729,3651);
insert into tab_district values (5790,57,'Hodonin','south Moravia',161954,21,37,20,3,8,48.00,8720,3.73,4.50,116,3729,3651);
insert into tab_district values (6118,57,'Hodonin','south Moravia',161954,21,37,20,3,8,48.00,8720,3.73,4.50,116,3729,3651);
insert into tab_district values (6878,57,'Hodonin','south Moravia',161954,21,37,20,3,8,48.00,8720,3.73,4.50,116,3729,3651);
insert into tab_district values (6442,57,'Hodonin','south Moravia',161954,21,37,20,3,8,48.00,8720,3.73,4.50,116,3729,3651);
insert into tab_district values (5681,58,'Jihlava','south Moravia',109164,98,16,6,1,4,63.60,8757,3.38,3.95,96,2212,2471);
insert into tab_district values (5110,58,'Jihlava','south Moravia',109164,98,16,6,1,4,63.60,8757,3.38,3.95,96,2212,2471);
insert into tab_district values (6043,58,'Jihlava','south Moravia',109164,98,16,6,1,4,63.60,8757,3.38,3.95,96,2212,2471);
insert into tab_district values (5698,58,'Jihlava','south Moravia',109164,98,16,6,1,4,63.60,8757,3.38,3.95,96,2212,2471);
insert into tab_district values (6942,59,'Kromeriz','south Moravia',108871,41,29,7,2,6,62.10,8444,3.24,3.47,106,2595,2305);
insert into tab_district values (5368,59,'Kromeriz','south Moravia',108871,41,29,7,2,6,62.10,8444,3.24,3.47,106,2595,2305);
insert into tab_district values (6665,59,'Kromeriz','south Moravia',108871,41,29,7,2,6,62.10,8444,3.24,3.47,106,2595,2305);
insert into tab_district values (6923,59,'Kromeriz','south Moravia',108871,41,29,7,2,6,62.10,8444,3.24,3.47,106,2595,2305);
insert into tab_district values (7246,59,'Kromeriz','south Moravia',108871,41,29,7,2,6,62.10,8444,3.24,3.47,106,2595,2305);
insert into tab_district values (5606,59,'Kromeriz','south Moravia',108871,41,29,7,2,6,62.10,8444,3.24,3.47,106,2595,2305);
insert into tab_district values (6688,59,'Kromeriz','south Moravia',108871,41,29,7,2,6,62.10,8444,3.24,3.47,106,2595,2305);
insert into tab_district values (6908,59,'Kromeriz','south Moravia',108871,41,29,7,2,6,62.10,8444,3.24,3.47,106,2595,2305);
insert into tab_district values (6541,59,'Kromeriz','south Moravia',108871,41,29,7,2,6,62.10,8444,3.24,3.47,106,2595,2305);
insert into tab_district values (6399,60,'Prostejov','south Moravia',110643,49,41,4,1,4,51.90,8441,3.45,4.48,115,1879,2252);
insert into tab_district values (5887,60,'Prostejov','south Moravia',110643,49,41,4,1,4,51.90,8441,3.45,4.48,115,1879,2252);
insert into tab_district values (6594,60,'Prostejov','south Moravia',110643,49,41,4,1,4,51.90,8441,3.45,4.48,115,1879,2252);
insert into tab_district values (6010,60,'Prostejov','south Moravia',110643,49,41,4,1,4,51.90,8441,3.45,4.48,115,1879,2252);
insert into tab_district values (5595,60,'Prostejov','south Moravia',110643,49,41,4,1,4,51.90,8441,3.45,4.48,115,1879,2252);
insert into tab_district values (6748,60,'Prostejov','south Moravia',110643,49,41,4,1,4,51.90,8441,3.45,4.48,115,1879,2252);
insert into tab_district values (7136,60,'Prostejov','south Moravia',110643,49,41,4,1,4,51.90,8441,3.45,4.48,115,1879,2252);
insert into tab_district values (7013,60,'Prostejov','south Moravia',110643,49,41,4,1,4,51.90,8441,3.45,4.48,115,1879,2252);
insert into tab_district values (5495,60,'Prostejov','south Moravia',110643,49,41,4,1,4,51.90,8441,3.45,4.48,115,1879,2252);
insert into tab_district values (7305,61,'Trebic','south Moravia',117897,139,28,5,1,6,53.80,8814,4.76,5.74,107,2112,2059);
insert into tab_district values (6353,61,'Trebic','south Moravia',117897,139,28,5,1,6,53.80,8814,4.76,5.74,107,2112,2059);
insert into tab_district values (6965,61,'Trebic','south Moravia',117897,139,28,5,1,6,53.80,8814,4.76,5.74,107,2112,2059);
insert into tab_district values (6315,61,'Trebic','south Moravia',117897,139,28,5,1,6,53.80,8814,4.76,5.74,107,2112,2059);
insert into tab_district values (6151,61,'Trebic','south Moravia',117897,139,28,5,1,6,53.80,8814,4.76,5.74,107,2112,2059);
insert into tab_district values (5856,61,'Trebic','south Moravia',117897,139,28,5,1,6,53.80,8814,4.76,5.74,107,2112,2059);
insert into tab_district values (6362,62,'Uherske Hradiste','south Moravia',145688,22,41,13,2,5,40.70,8544,1.29,1.86,109,2719,2906);
insert into tab_district values (6790,62,'Uherske Hradiste','south Moravia',145688,22,41,13,2,5,40.70,8544,1.29,1.86,109,2719,2906);
insert into tab_district values (5265,62,'Uherske Hradiste','south Moravia',145688,22,41,13,2,5,40.70,8544,1.29,1.86,109,2719,2906);
insert into tab_district values (5886,62,'Uherske Hradiste','south Moravia',145688,22,41,13,2,5,40.70,8544,1.29,1.86,109,2719,2906);
insert into tab_district values (5138,62,'Uherske Hradiste','south Moravia',145688,22,41,13,2,5,40.70,8544,1.29,1.86,109,2719,2906);
insert into tab_district values (6944,62,'Uherske Hradiste','south Moravia',145688,22,41,13,2,5,40.70,8544,1.29,1.86,109,2719,2906);
insert into tab_district values (7055,62,'Uherske Hradiste','south Moravia',145688,22,41,13,2,5,40.70,8544,1.29,1.86,109,2719,2906);
insert into tab_district values (5209,62,'Uherske Hradiste','south Moravia',145688,22,41,13,2,5,40.70,8544,1.29,1.86,109,2719,2906);
insert into tab_district values (5830,62,'Uherske Hradiste','south Moravia',145688,22,41,13,2,5,40.70,8544,1.29,1.86,109,2719,2906);
insert into tab_district values (6550,62,'Uherske Hradiste','south Moravia',145688,22,41,13,2,5,40.70,8544,1.29,1.86,109,2719,2906);
insert into tab_district values (5657,63,'Vyskov','south Moravia',86513,38,36,5,1,5,50.50,8288,3.79,4.52,110,1562,1460);
insert into tab_district values (5669,63,'Vyskov','south Moravia',86513,38,36,5,1,5,50.50,8288,3.79,4.52,110,1562,1460);
insert into tab_district values (6793,63,'Vyskov','south Moravia',86513,38,36,5,1,5,50.50,8288,3.79,4.52,110,1562,1460);
insert into tab_district values (5940,63,'Vyskov','south Moravia',86513,38,36,5,1,5,50.50,8288,3.79,4.52,110,1562,1460);
insert into tab_district values (5523,63,'Vyskov','south Moravia',86513,38,36,5,1,5,50.50,8288,3.79,4.52,110,1562,1460);
insert into tab_district values (6526,63,'Vyskov','south Moravia',86513,38,36,5,1,5,50.50,8288,3.79,4.52,110,1562,1460);
insert into tab_district values (5584,63,'Vyskov','south Moravia',86513,38,36,5,1,5,50.50,8288,3.79,4.52,110,1562,1460);
insert into tab_district values (6857,64,'Zlin','south Moravia',197099,29,41,10,2,10,74.70,9624,1.60,2.31,145,4484,4265);
insert into tab_district values (6283,64,'Zlin','south Moravia',197099,29,41,10,2,10,74.70,9624,1.60,2.31,145,4484,4265);
insert into tab_district values (5850,64,'Zlin','south Moravia',197099,29,41,10,2,10,74.70,9624,1.60,2.31,145,4484,4265);
insert into tab_district values (5634,64,'Zlin','south Moravia',197099,29,41,10,2,10,74.70,9624,1.60,2.31,145,4484,4265);
insert into tab_district values (5363,64,'Zlin','south Moravia',197099,29,41,10,2,10,74.70,9624,1.60,2.31,145,4484,4265);
insert into tab_district values (6509,64,'Zlin','south Moravia',197099,29,41,10,2,10,74.70,9624,1.60,2.31,145,4484,4265);
insert into tab_district values (6073,64,'Zlin','south Moravia',197099,29,41,10,2,10,74.70,9624,1.60,2.31,145,4484,4265);
insert into tab_district values (6585,64,'Zlin','south Moravia',197099,29,41,10,2,10,74.70,9624,1.60,2.31,145,4484,4265);
insert into tab_district values (7035,64,'Zlin','south Moravia',197099,29,41,10,2,10,74.70,9624,1.60,2.31,145,4484,4265);
insert into tab_district values (6456,64,'Zlin','south Moravia',197099,29,41,10,2,10,74.70,9624,1.60,2.31,145,4484,4265);
insert into tab_district values (6745,64,'Zlin','south Moravia',197099,29,41,10,2,10,74.70,9624,1.60,2.31,145,4484,4265);
insert into tab_district values (5725,64,'Zlin','south Moravia',197099,29,41,10,2,10,74.70,9624,1.60,2.31,145,4484,4265);
insert into tab_district values (5494,64,'Zlin','south Moravia',197099,29,41,10,2,10,74.70,9624,1.60,2.31,145,4484,4265);
insert into tab_district values (6808,64,'Zlin','south Moravia',197099,29,41,10,2,10,74.70,9624,1.60,2.31,145,4484,4265);
insert into tab_district values (6933,64,'Zlin','south Moravia',197099,29,41,10,2,10,74.70,9624,1.60,2.31,145,4484,4265);
insert into tab_district values (6764,64,'Zlin','south Moravia',197099,29,41,10,2,10,74.70,9624,1.60,2.31,145,4484,4265);
insert into tab_district values (6995,64,'Zlin','south Moravia',197099,29,41,10,2,10,74.70,9624,1.60,2.31,145,4484,4265);
insert into tab_district values (5161,65,'Znojmo','south Moravia',114200,101,41,4,1,4,43.70,8403,5.74,5.72,105,2157,2718);
insert into tab_district values (5470,65,'Znojmo','south Moravia',114200,101,41,4,1,4,43.70,8403,5.74,5.72,105,2157,2718);
insert into tab_district values (7213,65,'Znojmo','south Moravia',114200,101,41,4,1,4,43.70,8403,5.74,5.72,105,2157,2718);
insert into tab_district values (5253,65,'Znojmo','south Moravia',114200,101,41,4,1,4,43.70,8403,5.74,5.72,105,2157,2718);
insert into tab_district values (6955,65,'Znojmo','south Moravia',114200,101,41,4,1,4,43.70,8403,5.74,5.72,105,2157,2718);
insert into tab_district values (5045,65,'Znojmo','south Moravia',114200,101,41,4,1,4,43.70,8403,5.74,5.72,105,2157,2718);
insert into tab_district values (5585,66,'Zdar nad Sazavou','south Moravia',125832,151,41,2,3,5,48.30,8512,3.51,4.12,102,2247,2103);
insert into tab_district values (6109,66,'Zdar nad Sazavou','south Moravia',125832,151,41,2,3,5,48.30,8512,3.51,4.12,102,2247,2103);
insert into tab_district values (5836,66,'Zdar nad Sazavou','south Moravia',125832,151,41,2,3,5,48.30,8512,3.51,4.12,102,2247,2103);
insert into tab_district values (5002,66,'Zdar nad Sazavou','south Moravia',125832,151,41,2,3,5,48.30,8512,3.51,4.12,102,2247,2103);
insert into tab_district values (5970,66,'Zdar nad Sazavou','south Moravia',125832,151,41,2,3,5,48.30,8512,3.51,4.12,102,2247,2103);
insert into tab_district values (6753,66,'Zdar nad Sazavou','south Moravia',125832,151,41,2,3,5,48.30,8512,3.51,4.12,102,2247,2103);
insert into tab_district values (7137,66,'Zdar nad Sazavou','south Moravia',125832,151,41,2,3,5,48.30,8512,3.51,4.12,102,2247,2103);
insert into tab_district values (6255,67,'Bruntal','north Moravia',106054,38,25,6,2,6,63.10,8110,5.77,6.55,109,3244,3079);
insert into tab_district values (5395,67,'Bruntal','north Moravia',106054,38,25,6,2,6,63.10,8110,5.77,6.55,109,3244,3079);
insert into tab_district values (5991,67,'Bruntal','north Moravia',106054,38,25,6,2,6,63.10,8110,5.77,6.55,109,3244,3079);
insert into tab_district values (7308,67,'Bruntal','north Moravia',106054,38,25,6,2,6,63.10,8110,5.77,6.55,109,3244,3079);
insert into tab_district values (7198,67,'Bruntal','north Moravia',106054,38,25,6,2,6,63.10,8110,5.77,6.55,109,3244,3079);
insert into tab_district values (6660,67,'Bruntal','north Moravia',106054,38,25,6,2,6,63.10,8110,5.77,6.55,109,3244,3079);
insert into tab_district values (6737,68,'Frydek - Mistek','north Moravia',228848,15,40,18,2,6,57.20,9893,4.09,4.72,96,5623,5887);
insert into tab_district values (6044,68,'Frydek - Mistek','north Moravia',228848,15,40,18,2,6,57.20,9893,4.09,4.72,96,5623,5887);
insert into tab_district values (7104,68,'Frydek - Mistek','north Moravia',228848,15,40,18,2,6,57.20,9893,4.09,4.72,96,5623,5887);
insert into tab_district values (6895,68,'Frydek - Mistek','north Moravia',228848,15,40,18,2,6,57.20,9893,4.09,4.72,96,5623,5887);
insert into tab_district values (6552,68,'Frydek - Mistek','north Moravia',228848,15,40,18,2,6,57.20,9893,4.09,4.72,96,5623,5887);
insert into tab_district values (5301,68,'Frydek - Mistek','north Moravia',228848,15,40,18,2,6,57.20,9893,4.09,4.72,96,5623,5887);
insert into tab_district values (5170,68,'Frydek - Mistek','north Moravia',228848,15,40,18,2,6,57.20,9893,4.09,4.72,96,5623,5887);
insert into tab_district values (6887,68,'Frydek - Mistek','north Moravia',228848,15,40,18,2,6,57.20,9893,4.09,4.72,96,5623,5887);
insert into tab_district values (5561,68,'Frydek - Mistek','north Moravia',228848,15,40,18,2,6,57.20,9893,4.09,4.72,96,5623,5887);
insert into tab_district values (5207,68,'Frydek - Mistek','north Moravia',228848,15,40,18,2,6,57.20,9893,4.09,4.72,96,5623,5887);
insert into tab_district values (5906,68,'Frydek - Mistek','north Moravia',228848,15,40,18,2,6,57.20,9893,4.09,4.72,96,5623,5887);
insert into tab_district values (5352,68,'Frydek - Mistek','north Moravia',228848,15,40,18,2,6,57.20,9893,4.09,4.72,96,5623,5887);
insert into tab_district values (4962,68,'Frydek - Mistek','north Moravia',228848,15,40,18,2,6,57.20,9893,4.09,4.72,96,5623,5887);
insert into tab_district values (5051,68,'Frydek - Mistek','north Moravia',228848,15,40,18,2,6,57.20,9893,4.09,4.72,96,5623,5887);
insert into tab_district values (6502,68,'Frydek - Mistek','north Moravia',228848,15,40,18,2,6,57.20,9893,4.09,4.72,96,5623,5887);
insert into tab_district values (5449,68,'Frydek - Mistek','north Moravia',228848,15,40,18,2,6,57.20,9893,4.09,4.72,96,5623,5887);
insert into tab_district values (6866,69,'Jesenik','north Moravia',42821,4,13,5,1,3,48.40,8173,NULL,7.01,124,NULL,1358);
insert into tab_district values (5282,69,'Jesenik','north Moravia',42821,4,13,5,1,3,48.40,8173,NULL,7.01,124,NULL,1358);
insert into tab_district values (5128,69,'Jesenik','north Moravia',42821,4,13,5,1,3,48.40,8173,NULL,7.01,124,NULL,1358);
insert into tab_district values (5868,69,'Jesenik','north Moravia',42821,4,13,5,1,3,48.40,8173,NULL,7.01,124,NULL,1358);
insert into tab_district values (7100,69,'Jesenik','north Moravia',42821,4,13,5,1,3,48.40,8173,NULL,7.01,124,NULL,1358);
insert into tab_district values (5281,69,'Jesenik','north Moravia',42821,4,13,5,1,3,48.40,8173,NULL,7.01,124,NULL,1358);
insert into tab_district values (6613,69,'Jesenik','north Moravia',42821,4,13,5,1,3,48.40,8173,NULL,7.01,124,NULL,1358);
insert into tab_district values (6436,69,'Jesenik','north Moravia',42821,4,13,5,1,3,48.40,8173,NULL,7.01,124,NULL,1358);
insert into tab_district values (6959,70,'Karvina','north Moravia',285387,0,2,8,5,7,89.90,10177,6.63,7.75,81,9878,10108);
insert into tab_district values (6727,70,'Karvina','north Moravia',285387,0,2,8,5,7,89.90,10177,6.63,7.75,81,9878,10108);
insert into tab_district values (5147,70,'Karvina','north Moravia',285387,0,2,8,5,7,89.90,10177,6.63,7.75,81,9878,10108);
insert into tab_district values (6150,70,'Karvina','north Moravia',285387,0,2,8,5,7,89.90,10177,6.63,7.75,81,9878,10108);
insert into tab_district values (6921,70,'Karvina','north Moravia',285387,0,2,8,5,7,89.90,10177,6.63,7.75,81,9878,10108);
insert into tab_district values (5366,70,'Karvina','north Moravia',285387,0,2,8,5,7,89.90,10177,6.63,7.75,81,9878,10108);
insert into tab_district values (7147,70,'Karvina','north Moravia',285387,0,2,8,5,7,89.90,10177,6.63,7.75,81,9878,10108);
insert into tab_district values (5158,70,'Karvina','north Moravia',285387,0,2,8,5,7,89.90,10177,6.63,7.75,81,9878,10108);
insert into tab_district values (6490,70,'Karvina','north Moravia',285387,0,2,8,5,7,89.90,10177,6.63,7.75,81,9878,10108);
insert into tab_district values (6694,70,'Karvina','north Moravia',285387,0,2,8,5,7,89.90,10177,6.63,7.75,81,9878,10108);
insert into tab_district values (5942,70,'Karvina','north Moravia',285387,0,2,8,5,7,89.90,10177,6.63,7.75,81,9878,10108);
insert into tab_district values (7085,70,'Karvina','north Moravia',285387,0,2,8,5,7,89.90,10177,6.63,7.75,81,9878,10108);
insert into tab_district values (5447,70,'Karvina','north Moravia',285387,0,2,8,5,7,89.90,10177,6.63,7.75,81,9878,10108);
insert into tab_district values (5086,70,'Karvina','north Moravia',285387,0,2,8,5,7,89.90,10177,6.63,7.75,81,9878,10108);
insert into tab_district values (6758,70,'Karvina','north Moravia',285387,0,2,8,5,7,89.90,10177,6.63,7.75,81,9878,10108);
insert into tab_district values (5377,70,'Karvina','north Moravia',285387,0,2,8,5,7,89.90,10177,6.63,7.75,81,9878,10108);
insert into tab_district values (6805,70,'Karvina','north Moravia',285387,0,2,8,5,7,89.90,10177,6.63,7.75,81,9878,10108);
insert into tab_district values (6190,70,'Karvina','north Moravia',285387,0,2,8,5,7,89.90,10177,6.63,7.75,81,9878,10108);
insert into tab_district values (5015,70,'Karvina','north Moravia',285387,0,2,8,5,7,89.90,10177,6.63,7.75,81,9878,10108);
insert into tab_district values (6612,70,'Karvina','north Moravia',285387,0,2,8,5,7,89.90,10177,6.63,7.75,81,9878,10108);
insert into tab_district values (6816,70,'Karvina','north Moravia',285387,0,2,8,5,7,89.90,10177,6.63,7.75,81,9878,10108);
insert into tab_district values (5452,70,'Karvina','north Moravia',285387,0,2,8,5,7,89.90,10177,6.63,7.75,81,9878,10108);
insert into tab_district values (5346,70,'Karvina','north Moravia',285387,0,2,8,5,7,89.90,10177,6.63,7.75,81,9878,10108);
insert into tab_district values (7263,70,'Karvina','north Moravia',285387,0,2,8,5,7,89.90,10177,6.63,7.75,81,9878,10108);
insert into tab_district values (6464,71,'Novy Jicin','north Moravia',161227,5,35,11,4,10,69.70,8678,5.93,5.57,102,4980,4595);
insert into tab_district values (5005,71,'Novy Jicin','north Moravia',161227,5,35,11,4,10,69.70,8678,5.93,5.57,102,4980,4595);
insert into tab_district values (5304,71,'Novy Jicin','north Moravia',161227,5,35,11,4,10,69.70,8678,5.93,5.57,102,4980,4595);
insert into tab_district values (5034,71,'Novy Jicin','north Moravia',161227,5,35,11,4,10,69.70,8678,5.93,5.57,102,4980,4595);
insert into tab_district values (5624,71,'Novy Jicin','north Moravia',161227,5,35,11,4,10,69.70,8678,5.93,5.57,102,4980,4595);
insert into tab_district values (7189,71,'Novy Jicin','north Moravia',161227,5,35,11,4,10,69.70,8678,5.93,5.57,102,4980,4595);
insert into tab_district values (7138,72,'Olomouc','north Moravia',226122,32,50,7,4,4,62.60,8994,3.80,4.79,110,9672,9208);
insert into tab_district values (5976,72,'Olomouc','north Moravia',226122,32,50,7,4,4,62.60,8994,3.80,4.79,110,9672,9208);
insert into tab_district values (5145,72,'Olomouc','north Moravia',226122,32,50,7,4,4,62.60,8994,3.80,4.79,110,9672,9208);
insert into tab_district values (7139,72,'Olomouc','north Moravia',226122,32,50,7,4,4,62.60,8994,3.80,4.79,110,9672,9208);
insert into tab_district values (6072,72,'Olomouc','north Moravia',226122,32,50,7,4,4,62.60,8994,3.80,4.79,110,9672,9208);
insert into tab_district values (6113,72,'Olomouc','north Moravia',226122,32,50,7,4,4,62.60,8994,3.80,4.79,110,9672,9208);
insert into tab_district values (6037,72,'Olomouc','north Moravia',226122,32,50,7,4,4,62.60,8994,3.80,4.79,110,9672,9208);
insert into tab_district values (7243,72,'Olomouc','north Moravia',226122,32,50,7,4,4,62.60,8994,3.80,4.79,110,9672,9208);
insert into tab_district values (6540,72,'Olomouc','north Moravia',226122,32,50,7,4,4,62.60,8994,3.80,4.79,110,9672,9208);
insert into tab_district values (6865,72,'Olomouc','north Moravia',226122,32,50,7,4,4,62.60,8994,3.80,4.79,110,9672,9208);
insert into tab_district values (5136,72,'Olomouc','north Moravia',226122,32,50,7,4,4,62.60,8994,3.80,4.79,110,9672,9208);
insert into tab_district values (5706,72,'Olomouc','north Moravia',226122,32,50,7,4,4,62.60,8994,3.80,4.79,110,9672,9208);
insert into tab_district values (6818,72,'Olomouc','north Moravia',226122,32,50,7,4,4,62.60,8994,3.80,4.79,110,9672,9208);
insert into tab_district values (5046,72,'Olomouc','north Moravia',226122,32,50,7,4,4,62.60,8994,3.80,4.79,110,9672,9208);
insert into tab_district values (5878,73,'Opava','north Moravia',182027,17,49,12,2,7,56.40,8746,3.33,3.74,90,4355,4433);
insert into tab_district values (5140,73,'Opava','north Moravia',182027,17,49,12,2,7,56.40,8746,3.33,3.74,90,4355,4433);
insert into tab_district values (5520,73,'Opava','north Moravia',182027,17,49,12,2,7,56.40,8746,3.33,3.74,90,4355,4433);
insert into tab_district values (5415,73,'Opava','north Moravia',182027,17,49,12,2,7,56.40,8746,3.33,3.74,90,4355,4433);
insert into tab_district values (5892,73,'Opava','north Moravia',182027,17,49,12,2,7,56.40,8746,3.33,3.74,90,4355,4433);
insert into tab_district values (5956,73,'Opava','north Moravia',182027,17,49,12,2,7,56.40,8746,3.33,3.74,90,4355,4433);
insert into tab_district values (6655,73,'Opava','north Moravia',182027,17,49,12,2,7,56.40,8746,3.33,3.74,90,4355,4433);
insert into tab_district values (6926,73,'Opava','north Moravia',182027,17,49,12,2,7,56.40,8746,3.33,3.74,90,4355,4433);
insert into tab_district values (5369,74,'Ostrava - mesto','north Moravia',323870,0,0,0,1,1,100.00,10673,4.75,5.44,100,18782,18347);
insert into tab_district values (5643,74,'Ostrava - mesto','north Moravia',323870,0,0,0,1,1,100.00,10673,4.75,5.44,100,18782,18347);
insert into tab_district values (6877,74,'Ostrava - mesto','north Moravia',323870,0,0,0,1,1,100.00,10673,4.75,5.44,100,18782,18347);
insert into tab_district values (6986,74,'Ostrava - mesto','north Moravia',323870,0,0,0,1,1,100.00,10673,4.75,5.44,100,18782,18347);
insert into tab_district values (5206,74,'Ostrava - mesto','north Moravia',323870,0,0,0,1,1,100.00,10673,4.75,5.44,100,18782,18347);
insert into tab_district values (5563,74,'Ostrava - mesto','north Moravia',323870,0,0,0,1,1,100.00,10673,4.75,5.44,100,18782,18347);
insert into tab_district values (5876,74,'Ostrava - mesto','north Moravia',323870,0,0,0,1,1,100.00,10673,4.75,5.44,100,18782,18347);
insert into tab_district values (5638,74,'Ostrava - mesto','north Moravia',323870,0,0,0,1,1,100.00,10673,4.75,5.44,100,18782,18347);
insert into tab_district values (6178,74,'Ostrava - mesto','north Moravia',323870,0,0,0,1,1,100.00,10673,4.75,5.44,100,18782,18347);
insert into tab_district values (6322,74,'Ostrava - mesto','north Moravia',323870,0,0,0,1,1,100.00,10673,4.75,5.44,100,18782,18347);
insert into tab_district values (4986,74,'Ostrava - mesto','north Moravia',323870,0,0,0,1,1,100.00,10673,4.75,5.44,100,18782,18347);
insert into tab_district values (6738,74,'Ostrava - mesto','north Moravia',323870,0,0,0,1,1,100.00,10673,4.75,5.44,100,18782,18347);
insert into tab_district values (6272,74,'Ostrava - mesto','north Moravia',323870,0,0,0,1,1,100.00,10673,4.75,5.44,100,18782,18347);
insert into tab_district values (5656,74,'Ostrava - mesto','north Moravia',323870,0,0,0,1,1,100.00,10673,4.75,5.44,100,18782,18347);
insert into tab_district values (6253,74,'Ostrava - mesto','north Moravia',323870,0,0,0,1,1,100.00,10673,4.75,5.44,100,18782,18347);
insert into tab_district values (5862,74,'Ostrava - mesto','north Moravia',323870,0,0,0,1,1,100.00,10673,4.75,5.44,100,18782,18347);
insert into tab_district values (6297,74,'Ostrava - mesto','north Moravia',323870,0,0,0,1,1,100.00,10673,4.75,5.44,100,18782,18347);
insert into tab_district values (6577,74,'Ostrava - mesto','north Moravia',323870,0,0,0,1,1,100.00,10673,4.75,5.44,100,18782,18347);
insert into tab_district values (6403,74,'Ostrava - mesto','north Moravia',323870,0,0,0,1,1,100.00,10673,4.75,5.44,100,18782,18347);
insert into tab_district values (6950,74,'Ostrava - mesto','north Moravia',323870,0,0,0,1,1,100.00,10673,4.75,5.44,100,18782,18347);
insert into tab_district values (7199,75,'Prerov','north Moravia',138032,67,30,4,2,5,64.60,8819,5.38,5.66,99,4063,4505);
insert into tab_district values (6055,75,'Prerov','north Moravia',138032,67,30,4,2,5,64.60,8819,5.38,5.66,99,4063,4505);
insert into tab_district values (7262,75,'Prerov','north Moravia',138032,67,30,4,2,5,64.60,8819,5.38,5.66,99,4063,4505);
insert into tab_district values (6598,75,'Prerov','north Moravia',138032,67,30,4,2,5,64.60,8819,5.38,5.66,99,4063,4505);
insert into tab_district values (6969,76,'Sumperk','north Moravia',127369,31,32,13,2,7,51.20,8369,4.73,5.88,107,3736,2807);
insert into tab_district values (7171,76,'Sumperk','north Moravia',127369,31,32,13,2,7,51.20,8369,4.73,5.88,107,3736,2807);
insert into tab_district values (7200,76,'Sumperk','north Moravia',127369,31,32,13,2,7,51.20,8369,4.73,5.88,107,3736,2807);
insert into tab_district values (7050,76,'Sumperk','north Moravia',127369,31,32,13,2,7,51.20,8369,4.73,5.88,107,3736,2807);
insert into tab_district values (6097,76,'Sumperk','north Moravia',127369,31,32,13,2,7,51.20,8369,4.73,5.88,107,3736,2807);
insert into tab_district values (6696,77,'Vsetin','north Moravia',148545,8,35,12,3,4,53.50,8909,4.01,5.56,113,3460,3590);
insert into tab_district values (5586,77,'Vsetin','north Moravia',148545,8,35,12,3,4,53.50,8909,4.01,5.56,113,3460,3590);
insert into tab_district values (6066,77,'Vsetin','north Moravia',148545,8,35,12,3,4,53.50,8909,4.01,5.56,113,3460,3590);
insert into tab_district values (5841,77,'Vsetin','north Moravia',148545,8,35,12,3,4,53.50,8909,4.01,5.56,113,3460,3590);
insert into tab_district values (6470,77,'Vsetin','north Moravia',148545,8,35,12,3,4,53.50,8909,4.01,5.56,113,3460,3590);
insert into tab_district values (5933,77,'Vsetin','north Moravia',148545,8,35,12,3,4,53.50,8909,4.01,5.56,113,3460,3590);
insert into tab_loan values (4959,2,'1994-1-5',80952,24,3373.00,'A');
insert into tab_loan values (4961,19,'1996-4-29',30276,12,2523.00,'B');
insert into tab_loan values (4962,25,'1997-12-8',30276,12,2523.00,'A');
insert into tab_loan values (4967,37,'1998-10-14',318480,60,5308.00,'D');
insert into tab_loan values (4968,38,'1998-4-19',110736,48,2307.00,'C');
insert into tab_loan values (4973,67,'1996-5-2',165960,24,6915.00,'A');
insert into tab_loan values (4986,97,'1997-8-10',102876,12,8573.00,'A');
insert into tab_loan values (4988,103,'1997-12-6',265320,36,7370.00,'D');
insert into tab_loan values (4989,105,'1998-12-5',352704,48,7348.00,'C');
insert into tab_loan values (4990,110,'1997-9-8',162576,36,4516.00,'C');
insert into tab_loan values (4996,132,'1996-11-6',88440,12,7370.00,'A');
insert into tab_loan values (5002,173,'1994-5-31',104808,12,8734.00,'A');
insert into tab_loan values (5005,176,'1997-4-10',27456,12,2288.00,'A');
insert into tab_loan values (5015,226,'1998-7-12',109344,12,9112.00,'C');
insert into tab_loan values (5027,276,'1998-12-2',160920,36,4470.00,'C');
insert into tab_loan values (5032,290,'1994-11-3',123696,48,2577.00,'A');
insert into tab_loan values (5034,303,'1998-5-30',112752,36,3132.00,'C');
insert into tab_loan values (5036,309,'1998-11-25',91248,48,1901.00,'C');
insert into tab_loan values (5039,314,'1997-5-3',66840,24,2785.00,'C');
insert into tab_loan values (5041,319,'1997-7-11',369000,60,6150.00,'C');
insert into tab_loan values (5042,330,'1998-7-12',331584,48,6908.00,'C');
insert into tab_loan values (5043,339,'1997-12-25',468060,60,7801.00,'C');
insert into tab_loan values (5044,344,'1994-12-21',100980,60,1683.00,'C');
insert into tab_loan values (5045,347,'1995-5-1',187224,24,7801.00,'B');
insert into tab_loan values (5046,349,'1998-9-9',42816,12,3568.00,'C');
insert into tab_loan values (5051,378,'1997-10-11',230400,60,3840.00,'C');
insert into tab_loan values (5060,426,'1994-7-19',252060,60,4201.00,'D');
insert into tab_loan values (5061,440,'1998-3-13',84288,48,1756.00,'C');
insert into tab_loan values (5063,442,'1997-7-10',357840,48,7455.00,'D');
insert into tab_loan values (5072,472,'1997-4-28',196800,24,8200.00,'D');
insert into tab_loan values (5082,501,'1996-10-24',262980,60,4383.00,'C');
insert into tab_loan values (5086,525,'1997-7-16',210384,48,4383.00,'C');
insert into tab_loan values (5088,544,'1996-8-22',91152,24,3798.00,'A');
insert into tab_loan values (5103,666,'1997-11-28',12540,12,1045.00,'A');
insert into tab_loan values (5110,675,'1997-4-1',102240,60,1704.00,'C');
insert into tab_loan values (5117,718,'1997-8-20',76944,12,6412.00,'A');
insert into tab_loan values (5124,785,'1998-2-12',156096,36,4336.00,'C');
insert into tab_loan values (5125,789,'1995-11-23',73056,48,1522.00,'C');
insert into tab_loan values (5126,790,'1994-7-24',208128,48,4336.00,'B');
insert into tab_loan values (5128,808,'1996-4-11',215616,48,4492.00,'D');
insert into tab_loan values (5130,813,'1994-5-11',24312,12,2026.00,'A');
insert into tab_loan values (5131,816,'1995-1-8',48624,24,2026.00,'A');
insert into tab_loan values (5132,817,'1995-2-17',538500,60,8975.00,'C');
insert into tab_loan values (5134,825,'1997-2-2',53076,12,4423.00,'A');
insert into tab_loan values (5136,846,'1996-7-28',187104,24,7796.00,'A');
insert into tab_loan values (5138,854,'1995-5-30',87216,48,1817.00,'C');
insert into tab_loan values (5140,873,'1998-2-24',178500,60,2975.00,'C');
insert into tab_loan values (5145,915,'1995-9-16',309552,48,6449.00,'C');
insert into tab_loan values (5147,938,'1998-5-21',22260,60,371.00,'C');
insert into tab_loan values (5148,940,'1996-5-29',284280,60,4738.00,'C');
insert into tab_loan values (5151,960,'1995-5-24',189060,60,3151.00,'C');
insert into tab_loan values (5154,993,'1998-7-1',108720,60,1812.00,'C');
insert into tab_loan values (5158,1004,'1998-4-11',188532,36,5237.00,'C');
insert into tab_loan values (5160,1011,'1995-12-18',204000,60,3400.00,'C');
insert into tab_loan values (5161,1012,'1994-10-28',98184,24,4091.00,'A');
insert into tab_loan values (5169,1068,'1998-9-24',253200,60,4220.00,'C');
insert into tab_loan values (5170,1071,'1994-1-20',253200,60,4220.00,'C');
insert into tab_loan values (5172,1083,'1998-4-16',50976,36,1416.00,'C');
insert into tab_loan values (5174,1093,'1997-6-13',385104,48,8023.00,'C');
insert into tab_loan values (5176,1106,'1994-11-12',192552,24,8023.00,'B');
insert into tab_loan values (5189,1166,'1994-2-7',149040,48,3105.00,'A');
insert into tab_loan values (5206,1242,'1997-9-7',128544,24,5356.00,'C');
insert into tab_loan values (5207,1244,'1997-2-28',35904,48,748.00,'C');
insert into tab_loan values (5208,1247,'1995-3-16',99696,48,2077.00,'D');
insert into tab_loan values (5209,1250,'1996-11-25',182640,48,3805.00,'C');
insert into tab_loan values (5210,1252,'1997-4-1',148140,36,4115.00,'C');
insert into tab_loan values (5212,1256,'1995-5-29',71064,36,1974.00,'A');
insert into tab_loan values (5214,1270,'1997-7-1',74772,36,2077.00,'C');
insert into tab_loan values (5221,1284,'1998-12-5',52512,12,4376.00,'C');
insert into tab_loan values (5226,1318,'1998-10-11',185544,36,5154.00,'C');
insert into tab_loan values (5229,1329,'1997-9-6',23520,12,1960.00,'A');
insert into tab_loan values (5236,1374,'1997-9-15',389136,48,8107.00,'C');
insert into tab_loan values (5237,1375,'1995-8-29',45336,24,1889.00,'A');
insert into tab_loan values (5241,1389,'1998-9-2',125472,24,5228.00,'C');
insert into tab_loan values (5245,1407,'1998-1-17',125472,24,5228.00,'C');
insert into tab_loan values (5253,1447,'1997-6-3',100080,48,2085.00,'C');
insert into tab_loan values (5260,1480,'1998-1-19',123300,36,3425.00,'C');
insert into tab_loan values (5265,1498,'1998-10-7',165780,60,2763.00,'C');
insert into tab_loan values (5269,1527,'1994-11-19',164052,36,4557.00,'B');
insert into tab_loan values (5270,1528,'1997-7-21',191088,48,3981.00,'C');
insert into tab_loan values (5281,1580,'1997-11-27',194256,24,8094.00,'C');
insert into tab_loan values (5282,1583,'1996-8-24',388512,48,8094.00,'D');
insert into tab_loan values (5285,1603,'1994-2-6',78936,12,6578.00,'A');
insert into tab_loan values (5287,1638,'1998-1-26',64224,24,2676.00,'C');
insert into tab_loan values (5293,1656,'1998-10-29',189792,48,3954.00,'C');
insert into tab_loan values (5301,1698,'1996-7-6',141948,36,3943.00,'C');
insert into tab_loan values (5304,1718,'1998-8-20',172272,24,7178.00,'C');
insert into tab_loan values (5310,1762,'1995-4-28',248148,36,6893.00,'A');
insert into tab_loan values (5311,1766,'1996-6-15',30060,60,501.00,'C');
insert into tab_loan values (5312,1772,'1996-3-13',202788,36,5633.00,'C');
insert into tab_loan values (5313,1776,'1998-5-27',43200,24,1800.00,'C');
insert into tab_loan values (5314,1787,'1993-7-5',96396,12,8033.00,'B');
insert into tab_loan values (5316,1801,'1993-7-11',165960,36,4610.00,'A');
insert into tab_loan values (5318,1808,'1998-9-30',385584,48,8033.00,'C');
insert into tab_loan values (5319,1811,'1994-6-23',239460,60,3991.00,'C');
insert into tab_loan values (5320,1819,'1998-1-11',143676,36,3991.00,'C');
insert into tab_loan values (5325,1843,'1993-8-3',105804,36,2939.00,'A');
insert into tab_loan values (5329,1862,'1996-10-16',396120,60,6602.00,'C');
insert into tab_loan values (5332,1869,'1998-1-29',37944,36,1054.00,'C');
insert into tab_loan values (5334,1876,'1998-9-10',209040,24,8710.00,'C');
insert into tab_loan values (5337,1886,'1996-7-31',162468,36,4513.00,'C');
insert into tab_loan values (5338,1888,'1997-8-30',57360,12,4780.00,'B');
insert into tab_loan values (5343,1906,'1997-10-8',44952,24,1873.00,'C');
insert into tab_loan values (5346,1928,'1998-12-6',55632,24,2318.00,'C');
insert into tab_loan values (5350,1967,'1996-4-21',249312,48,5194.00,'C');
insert into tab_loan values (5351,1978,'1994-12-4',205200,36,5700.00,'A');
insert into tab_loan values (5352,1993,'1995-4-15',68400,12,5700.00,'B');
insert into tab_loan values (5354,2000,'1998-7-14',290820,60,4847.00,'C');
insert into tab_loan values (5358,2018,'1997-1-21',38520,12,3210.00,'A');
insert into tab_loan values (5360,2035,'1998-1-25',176328,36,4898.00,'C');
insert into tab_loan values (5363,2051,'1997-4-22',293880,60,4898.00,'D');
insert into tab_loan values (5365,2055,'1998-7-19',271260,60,4521.00,'C');
insert into tab_loan values (5366,2062,'1996-10-29',86184,12,7182.00,'A');
insert into tab_loan values (5367,2064,'1997-8-26',83628,36,2323.00,'C');
insert into tab_loan values (5368,2073,'1998-10-5',44640,24,1860.00,'C');
insert into tab_loan values (5369,2080,'1997-9-12',214596,36,5961.00,'C');
insert into tab_loan values (5375,2106,'1996-10-3',101520,12,8460.00,'A');
insert into tab_loan values (5377,2116,'1997-8-4',92400,12,7700.00,'A');
insert into tab_loan values (5382,2134,'1997-3-17',22932,36,637.00,'C');
insert into tab_loan values (5384,2142,'1998-3-7',23328,12,1944.00,'C');
insert into tab_loan values (5385,2143,'1996-9-9',71460,36,1985.00,'C');
insert into tab_loan values (5388,2153,'1996-11-28',61560,12,5130.00,'A');
insert into tab_loan values (5389,2165,'1997-8-22',78600,24,3275.00,'C');
insert into tab_loan values (5390,2167,'1994-10-30',170256,24,7094.00,'A');
insert into tab_loan values (5395,2176,'1994-7-30',299088,36,8308.00,'B');
insert into tab_loan values (5398,2187,'1997-11-4',53472,12,4456.00,'A');
insert into tab_loan values (5409,2218,'1995-11-18',182040,60,3034.00,'C');
insert into tab_loan values (5413,2227,'1995-12-12',92976,24,3874.00,'A');
insert into tab_loan values (5414,2228,'1995-3-29',185952,48,3874.00,'C');
insert into tab_loan values (5415,2236,'1996-9-26',139464,36,3874.00,'D');
insert into tab_loan values (5418,2245,'1995-1-16',347952,48,7249.00,'C');
insert into tab_loan values (5419,2246,'1997-2-5',415800,60,6930.00,'C');
insert into tab_loan values (5420,2247,'1997-2-24',72504,24,3021.00,'C');
insert into tab_loan values (5428,2262,'1998-12-2',230220,36,6395.00,'C');
insert into tab_loan values (5429,2268,'1996-7-18',20196,36,561.00,'C');
insert into tab_loan values (5435,2279,'1998-6-1',314688,48,6556.00,'C');
insert into tab_loan values (5445,2322,'1996-6-29',46320,24,1930.00,'A');
insert into tab_loan values (5446,2334,'1997-8-4',48312,24,2013.00,'C');
insert into tab_loan values (5447,2335,'1997-11-12',541200,60,9020.00,'D');
insert into tab_loan values (5449,2343,'1995-11-4',99336,24,4139.00,'A');
insert into tab_loan values (5450,2345,'1994-12-11',199680,60,3328.00,'C');
insert into tab_loan values (5451,2350,'1997-5-11',159744,48,3328.00,'C');
insert into tab_loan values (5452,2352,'1996-4-29',49440,60,824.00,'C');
insert into tab_loan values (5453,2361,'1995-4-1',156672,36,4352.00,'A');
insert into tab_loan values (5463,2413,'1998-10-6',17952,12,1496.00,'C');
insert into tab_loan values (5464,2419,'1995-1-30',95808,12,7984.00,'A');
insert into tab_loan values (5469,2445,'1997-12-26',293160,60,4886.00,'C');
insert into tab_loan values (5470,2456,'1996-4-15',200976,48,4187.00,'C');
insert into tab_loan values (5479,2486,'1994-1-10',24516,12,2043.00,'A');
insert into tab_loan values (5482,2496,'1996-1-12',165120,60,2752.00,'C');
insert into tab_loan values (5486,2516,'1997-6-13',466608,48,9721.00,'C');
insert into tab_loan values (5491,2545,'1998-2-13',428784,48,8933.00,'C');
insert into tab_loan values (5494,2572,'1996-6-13',360000,48,7500.00,'C');
insert into tab_loan values (5495,2580,'1996-8-2',89340,60,1489.00,'C');
insert into tab_loan values (5501,2622,'1998-5-21',136344,24,5681.00,'C');
insert into tab_loan values (5519,2694,'1994-3-8',91632,12,7636.00,'A');
insert into tab_loan values (5520,2699,'1998-8-30',231168,48,4816.00,'C');
insert into tab_loan values (5523,2705,'1993-12-8',93888,36,2608.00,'A');
insert into tab_loan values (5525,2720,'1998-4-27',93888,36,2608.00,'C');
insert into tab_loan values (5526,2725,'1998-11-8',69624,36,1934.00,'C');
insert into tab_loan values (5527,2728,'1998-6-15',156420,60,2607.00,'C');
insert into tab_loan values (5531,2753,'1997-9-30',66432,24,2768.00,'C');
insert into tab_loan values (5532,2754,'1997-5-4',335280,48,6985.00,'C');
insert into tab_loan values (5533,2762,'1994-7-5',111384,24,4641.00,'A');
insert into tab_loan values (5549,2824,'1994-7-16',50460,60,841.00,'C');
insert into tab_loan values (5556,2872,'1997-5-19',268320,60,4472.00,'C');
insert into tab_loan values (5561,2910,'1998-8-29',437460,60,7291.00,'C');
insert into tab_loan values (5563,2912,'1996-2-29',380160,60,6336.00,'C');
insert into tab_loan values (5568,2933,'1994-5-17',272520,60,4542.00,'C');
insert into tab_loan values (5569,2936,'1998-1-20',504000,60,8400.00,'C');
insert into tab_loan values (5576,2962,'1994-12-21',31248,12,2604.00,'A');
insert into tab_loan values (5582,2982,'1998-4-17',41256,12,3438.00,'C');
insert into tab_loan values (5584,2986,'1997-12-6',24792,24,1033.00,'C');
insert into tab_loan values (5585,2988,'1998-7-8',88608,12,7384.00,'C');
insert into tab_loan values (5586,2994,'1996-9-14',48744,36,1354.00,'C');
insert into tab_loan values (5589,3005,'1998-6-5',390000,48,8125.00,'C');
insert into tab_loan values (5591,3021,'1996-12-4',155616,48,3242.00,'C');
insert into tab_loan values (5593,3037,'1996-4-18',277884,36,7719.00,'D');
insert into tab_loan values (5595,3050,'1994-9-2',82896,12,6908.00,'A');
insert into tab_loan values (5599,3064,'1995-3-21',15420,12,1285.00,'A');
insert into tab_loan values (5606,3084,'1996-8-28',253512,36,7042.00,'D');
insert into tab_loan values (5610,3112,'1996-2-24',123216,48,2567.00,'C');
insert into tab_loan values (5611,3115,'1996-11-15',321180,60,5353.00,'C');
insert into tab_loan values (5614,3137,'1998-9-21',253560,60,4226.00,'C');
insert into tab_loan values (5616,3143,'1998-5-15',130896,24,5454.00,'C');
insert into tab_loan values (5620,3161,'1998-6-16',30012,12,2501.00,'C');
insert into tab_loan values (5624,3166,'1995-1-3',177744,48,3703.00,'D');
insert into tab_loan values (5625,3189,'1996-12-15',222180,60,3703.00,'D');
insert into tab_loan values (5634,3229,'1997-5-1',39024,12,3252.00,'A');
insert into tab_loan values (5635,3230,'1996-10-4',77184,36,2144.00,'C');
insert into tab_loan values (5638,3249,'1997-8-27',68124,12,5677.00,'A');
insert into tab_loan values (5643,3273,'1997-9-21',94512,12,7876.00,'B');
insert into tab_loan values (5644,3293,'1998-11-27',276084,36,7669.00,'C');
insert into tab_loan values (5651,3329,'1997-12-8',19248,12,1604.00,'A');
insert into tab_loan values (5656,3353,'1997-2-9',146064,24,6086.00,'C');
insert into tab_loan values (5657,3354,'1994-7-5',4980,12,415.00,'A');
insert into tab_loan values (5665,3390,'1998-3-11',40632,12,3386.00,'C');
insert into tab_loan values (5669,3403,'1998-6-27',71820,36,1995.00,'C');
insert into tab_loan values (5674,3418,'1997-6-10',207264,48,4318.00,'C');
insert into tab_loan values (5681,3448,'1997-10-20',68664,24,2861.00,'C');
insert into tab_loan values (5682,3455,'1997-3-7',67464,12,5622.00,'A');
insert into tab_loan values (5683,3460,'1998-5-29',140688,48,2931.00,'C');
insert into tab_loan values (5693,3489,'1995-8-1',44088,24,1837.00,'A');
insert into tab_loan values (5698,3556,'1998-9-22',174840,60,2914.00,'C');
insert into tab_loan values (5699,3562,'1998-5-24',174960,24,7290.00,'C');
insert into tab_loan values (5706,3608,'1996-5-24',161496,36,4486.00,'C');
insert into tab_loan values (5713,3629,'1995-5-30',158760,60,2646.00,'C');
insert into tab_loan values (5718,3637,'1997-9-1',14028,12,1169.00,'A');
insert into tab_loan values (5719,3664,'1997-9-20',271584,48,5658.00,'C');
insert into tab_loan values (5723,3674,'1994-9-10',23628,12,1969.00,'A');
insert into tab_loan values (5724,3678,'1995-2-5',316140,60,5269.00,'D');
insert into tab_loan values (5725,3679,'1996-7-23',444864,48,9268.00,'C');
insert into tab_loan values (5731,3711,'1997-11-5',460980,60,7683.00,'D');
insert into tab_loan values (5739,3747,'1995-1-2',76380,12,6365.00,'A');
insert into tab_loan values (5740,3752,'1995-4-2',18564,12,1547.00,'A');
insert into tab_loan values (5741,3754,'1996-11-3',68544,24,2856.00,'A');
insert into tab_loan values (5750,3804,'1996-2-8',63252,12,5271.00,'A');
insert into tab_loan values (5754,3834,'1994-9-28',23052,12,1921.00,'A');
insert into tab_loan values (5758,3859,'1997-5-2',307200,60,5120.00,'D');
insert into tab_loan values (5760,3862,'1998-9-18',74916,36,2081.00,'C');
insert into tab_loan values (5765,3875,'1998-2-10',153936,24,6414.00,'C');
insert into tab_loan values (5772,3906,'1998-3-8',334620,60,5577.00,'C');
insert into tab_loan values (5773,3907,'1998-3-16',133848,24,5577.00,'C');
insert into tab_loan values (5774,3916,'1998-7-12',96984,36,2694.00,'C');
insert into tab_loan values (5779,3942,'1997-10-14',107352,36,2982.00,'C');
insert into tab_loan values (5782,3953,'1998-1-4',63576,12,5298.00,'C');
insert into tab_loan values (5784,3967,'1997-3-29',84600,36,2350.00,'D');
insert into tab_loan values (5790,4033,'1997-3-20',84288,48,1756.00,'C');
insert into tab_loan values (5799,4052,'1997-12-28',106128,36,2948.00,'C');
insert into tab_loan values (5804,4079,'1995-4-5',158976,48,3312.00,'C');
insert into tab_loan values (5805,4081,'1995-11-28',137904,24,5746.00,'B');
insert into tab_loan values (5808,4099,'1997-7-31',41856,48,872.00,'C');
insert into tab_loan values (5815,4116,'1998-6-3',151200,36,4200.00,'C');
insert into tab_loan values (5817,4127,'1997-8-15',100800,24,4200.00,'D');
insert into tab_loan values (5823,4144,'1998-6-21',212976,36,5916.00,'C');
insert into tab_loan values (5830,4190,'1997-8-28',405780,60,6763.00,'C');
insert into tab_loan values (5836,4259,'1994-8-27',79632,24,3318.00,'A');
insert into tab_loan values (5837,4260,'1994-6-29',244560,60,4076.00,'C');
insert into tab_loan values (5841,4268,'1998-11-4',41988,12,3499.00,'C');
insert into tab_loan values (5850,4293,'1997-5-22',164196,36,4561.00,'C');
insert into tab_loan values (5856,4320,'1997-8-9',51360,12,4280.00,'B');
insert into tab_loan values (5861,4337,'1994-12-8',51408,24,2142.00,'A');
insert into tab_loan values (5862,4342,'1997-12-9',100128,24,4172.00,'C');
insert into tab_loan values (5865,4354,'1998-10-30',327660,60,5461.00,'C');
insert into tab_loan values (5868,4361,'1997-3-29',90156,12,7513.00,'A');
insert into tab_loan values (5876,4413,'1995-2-8',221280,48,4610.00,'C');
insert into tab_loan values (5877,4414,'1995-2-23',97224,24,4051.00,'A');
insert into tab_loan values (5878,4415,'1997-4-1',74040,12,6170.00,'A');
insert into tab_loan values (5880,4423,'1995-10-31',73836,36,2051.00,'A');
insert into tab_loan values (5882,4427,'1994-9-26',87816,12,7318.00,'A');
insert into tab_loan values (5886,4447,'1996-10-31',192744,36,5354.00,'C');
insert into tab_loan values (5887,4448,'1994-10-3',192744,36,5354.00,'A');
insert into tab_loan values (5889,4456,'1998-2-9',321240,60,5354.00,'C');
insert into tab_loan values (5892,4462,'1996-5-14',66480,24,2770.00,'B');
insert into tab_loan values (5893,4467,'1998-8-3',86184,36,2394.00,'C');
insert into tab_loan values (5895,4473,'1997-1-3',93960,60,1566.00,'C');
insert into tab_loan values (5897,4476,'1996-9-25',15192,24,633.00,'A');
insert into tab_loan values (5900,4503,'1996-1-1',135360,48,2820.00,'C');
insert into tab_loan values (5906,4533,'1998-5-5',81144,36,2254.00,'C');
insert into tab_loan values (5909,4550,'1998-1-3',61320,60,1022.00,'C');
insert into tab_loan values (5918,4576,'1994-6-4',300204,36,8339.00,'A');
insert into tab_loan values (5922,4580,'1995-8-5',20220,12,1685.00,'A');
insert into tab_loan values (5923,4585,'1996-10-10',64656,48,1347.00,'C');
insert into tab_loan values (5930,4616,'1998-1-12',66696,24,2779.00,'C');
insert into tab_loan values (5931,4618,'1997-3-17',66696,24,2779.00,'D');
insert into tab_loan values (5932,4626,'1997-6-18',33348,12,2779.00,'A');
insert into tab_loan values (5933,4631,'1997-12-13',87528,24,3647.00,'C');
insert into tab_loan values (5938,4650,'1996-8-25',402000,60,6700.00,'C');
insert into tab_loan values (5940,4660,'1997-5-28',106944,24,4456.00,'C');
insert into tab_loan values (5942,4681,'1997-3-15',162624,48,3388.00,'C');
insert into tab_loan values (5953,4715,'1997-3-14',97176,24,4049.00,'C');
insert into tab_loan values (5956,4725,'1997-11-4',168264,36,4674.00,'C');
insert into tab_loan values (5959,4727,'1995-8-11',107640,24,4485.00,'A');
insert into tab_loan values (5963,4746,'1997-9-7',204780,60,3413.00,'C');
insert into tab_loan values (5970,4774,'1995-7-9',465072,48,9689.00,'C');
insert into tab_loan values (5973,4784,'1997-11-24',219456,48,4572.00,'C');
insert into tab_loan values (5976,4794,'1997-12-27',465504,48,9698.00,'D');
insert into tab_loan values (5977,4803,'1997-2-25',59136,48,1232.00,'C');
insert into tab_loan values (5980,4825,'1995-8-18',21396,12,1783.00,'A');
insert into tab_loan values (5988,4851,'1996-8-22',141648,24,5902.00,'A');
insert into tab_loan values (5989,4852,'1996-3-4',213300,36,5925.00,'C');
insert into tab_loan values (5991,4858,'1998-7-27',335184,48,6983.00,'D');
insert into tab_loan values (5992,4863,'1997-3-18',76080,12,6340.00,'A');
insert into tab_loan values (5997,4894,'1993-11-4',117024,24,4876.00,'A');
insert into tab_loan values (5999,4907,'1996-1-3',98832,48,2059.00,'C');
insert into tab_loan values (6004,4937,'1994-7-23',143904,24,5996.00,'A');
insert into tab_loan values (6006,4948,'1996-11-15',359760,60,5996.00,'C');
insert into tab_loan values (6007,4949,'1997-8-30',289920,48,6040.00,'C');
insert into tab_loan values (6010,4969,'1997-3-6',150180,60,2503.00,'C');
insert into tab_loan values (6011,4981,'1996-11-28',179328,48,3736.00,'C');
insert into tab_loan values (6012,4994,'1996-8-3',258444,36,7179.00,'C');
insert into tab_loan values (6013,4995,'1996-2-3',128988,36,3583.00,'D');
insert into tab_loan values (6014,4999,'1997-5-18',165168,36,4588.00,'C');
insert into tab_loan values (6015,5001,'1996-11-9',110112,24,4588.00,'A');
insert into tab_loan values (6019,5033,'1996-7-25',11400,12,950.00,'A');
insert into tab_loan values (6027,5066,'1996-2-10',61656,24,2569.00,'B');
insert into tab_loan values (6028,5072,'1997-2-9',317520,60,5292.00,'C');
insert into tab_loan values (6037,5118,'1997-5-4',53232,48,1109.00,'C');
insert into tab_loan values (6038,5120,'1994-8-10',323472,48,6739.00,'A');
insert into tab_loan values (6043,5126,'1996-1-11',20352,48,424.00,'C');
insert into tab_loan values (6044,5133,'1998-1-27',57060,12,4755.00,'C');
insert into tab_loan values (6052,5164,'1998-3-23',22356,36,621.00,'C');
insert into tab_loan values (6054,5180,'1998-7-16',58764,12,4897.00,'C');
insert into tab_loan values (6055,5181,'1997-4-28',399120,60,6652.00,'C');
insert into tab_loan values (6059,5196,'1997-12-28',79824,12,6652.00,'A');
insert into tab_loan values (6063,5213,'1996-4-25',320976,48,6687.00,'D');
insert into tab_loan values (6064,5215,'1994-8-4',14628,12,1219.00,'A');
insert into tab_loan values (6066,5228,'1994-7-11',173808,24,7242.00,'A');
insert into tab_loan values (6072,5256,'1994-5-10',193968,36,5388.00,'A');
insert into tab_loan values (6073,5263,'1996-11-12',276300,60,4605.00,'C');
insert into tab_loan values (6075,5267,'1997-11-26',129312,24,5388.00,'D');
insert into tab_loan values (6076,5269,'1997-2-2',117420,60,1957.00,'C');
insert into tab_loan values (6077,5270,'1993-11-22',79608,24,3317.00,'A');
insert into tab_loan values (6078,5283,'1998-9-9',170832,48,3559.00,'C');
insert into tab_loan values (6083,5305,'1998-3-31',240528,48,5011.00,'C');
insert into tab_loan values (6087,5313,'1994-2-27',300660,60,5011.00,'C');
insert into tab_loan values (6088,5317,'1997-3-7',90180,36,2505.00,'C');
insert into tab_loan values (6095,5358,'1997-1-24',68340,60,1139.00,'C');
insert into tab_loan values (6097,5362,'1997-8-21',202848,48,4226.00,'C');
insert into tab_loan values (6103,5385,'1994-4-7',149340,60,2489.00,'C');
insert into tab_loan values (6104,5395,'1997-9-5',158184,36,4394.00,'C');
insert into tab_loan values (6109,5422,'1996-6-3',368880,60,6148.00,'C');
insert into tab_loan values (6111,5428,'1993-9-24',174744,24,7281.00,'B');
insert into tab_loan values (6112,5442,'1994-6-17',174744,24,7281.00,'B');
insert into tab_loan values (6113,5445,'1997-10-1',78696,36,2186.00,'C');
insert into tab_loan values (6118,5477,'1997-10-4',349392,48,7279.00,'C');
insert into tab_loan values (6120,5481,'1994-9-11',209184,48,4358.00,'A');
insert into tab_loan values (6130,5541,'1996-7-18',32640,48,680.00,'C');
insert into tab_loan values (6136,5572,'1998-4-19',140880,60,2348.00,'C');
insert into tab_loan values (6137,5574,'1996-4-10',44628,12,3719.00,'A');
insert into tab_loan values (6142,5591,'1997-1-21',221880,60,3698.00,'C');
insert into tab_loan values (6144,5593,'1996-8-9',44376,12,3698.00,'A');
insert into tab_loan values (6147,5602,'1997-12-28',177504,48,3698.00,'C');
insert into tab_loan values (6150,5622,'1994-11-2',83016,12,6918.00,'A');
insert into tab_loan values (6151,5628,'1995-4-25',225420,60,3757.00,'C');
insert into tab_loan values (6153,5632,'1995-7-25',285600,60,4760.00,'C');
insert into tab_loan values (6157,5650,'1995-7-10',98592,24,4108.00,'A');
insert into tab_loan values (6168,5698,'1998-11-21',99216,36,2756.00,'C');
insert into tab_loan values (6169,5700,'1995-3-16',103680,60,1728.00,'D');
insert into tab_loan values (6173,5724,'1997-1-8',232560,48,4845.00,'C');
insert into tab_loan values (6175,5735,'1996-2-21',290700,60,4845.00,'D');
insert into tab_loan values (6178,5742,'1995-12-16',232560,48,4845.00,'C');
insert into tab_loan values (6185,5774,'1995-11-28',31176,24,1299.00,'A');
insert into tab_loan values (6190,5794,'1996-5-6',123600,60,2060.00,'C');
insert into tab_loan values (6196,5837,'1997-9-14',177804,36,4939.00,'C');
insert into tab_loan values (6202,5891,'1994-4-18',65184,12,5432.00,'A');
insert into tab_loan values (6207,5912,'1998-6-23',184620,60,3077.00,'C');
insert into tab_loan values (6210,5927,'1994-6-6',87216,48,1817.00,'B');
insert into tab_loan values (6215,5944,'1998-6-18',78720,48,1640.00,'C');
insert into tab_loan values (6216,5952,'1994-9-30',141240,24,5885.00,'A');
insert into tab_loan values (6223,5991,'1994-11-3',61056,48,1272.00,'A');
insert into tab_loan values (6227,6030,'1995-3-4',28248,24,1177.00,'A');
insert into tab_loan values (6228,6034,'1993-12-1',464520,60,7742.00,'B');
insert into tab_loan values (6229,6040,'1994-10-2',11736,24,489.00,'A');
insert into tab_loan values (6232,6051,'1994-7-8',276660,36,7685.00,'B');
insert into tab_loan values (6234,6061,'1998-5-28',5148,12,429.00,'C');
insert into tab_loan values (6235,6062,'1998-4-19',321360,60,5356.00,'C');
insert into tab_loan values (6237,6075,'1998-1-6',407952,48,8499.00,'D');
insert into tab_loan values (6239,6083,'1997-9-28',360864,48,7518.00,'D');
insert into tab_loan values (6242,6097,'1997-10-22',26208,36,728.00,'C');
insert into tab_loan values (6244,6118,'1995-1-8',270648,36,7518.00,'B');
insert into tab_loan values (6249,6138,'1997-7-30',67608,24,2817.00,'C');
insert into tab_loan values (6253,6148,'1994-11-4',59760,24,2490.00,'A');
insert into tab_loan values (6254,6157,'1997-12-28',247920,48,5165.00,'C');
insert into tab_loan values (6255,6158,'1997-2-8',247920,48,5165.00,'D');
insert into tab_loan values (6272,6226,'1994-12-20',398640,60,6644.00,'C');
insert into tab_loan values (6278,6265,'1997-6-10',87360,24,3640.00,'C');
insert into tab_loan values (6279,6273,'1994-6-7',87360,24,3640.00,'A');
insert into tab_loan values (6283,6289,'1996-8-11',85632,48,1784.00,'C');
insert into tab_loan values (6294,6353,'1995-2-12',79920,60,1332.00,'C');
insert into tab_loan values (6296,6358,'1996-8-6',270384,48,5633.00,'C');
insert into tab_loan values (6297,6363,'1994-10-25',17508,12,1459.00,'A');
insert into tab_loan values (6302,6397,'1996-9-16',181020,60,3017.00,'C');
insert into tab_loan values (6303,6400,'1996-2-12',72408,24,3017.00,'B');
insert into tab_loan values (6306,6425,'1994-12-20',36684,12,3057.00,'A');
insert into tab_loan values (6309,6434,'1996-11-11',110136,24,4589.00,'A');
insert into tab_loan values (6310,6440,'1997-6-17',34572,12,2881.00,'A');
insert into tab_loan values (6312,6453,'1998-5-17',10944,36,304.00,'C');
insert into tab_loan values (6313,6461,'1997-6-15',150912,36,4192.00,'C');
insert into tab_loan values (6315,6472,'1995-2-6',43164,12,3597.00,'A');
insert into tab_loan values (6316,6473,'1994-5-26',76908,12,6409.00,'B');
insert into tab_loan values (6320,6495,'1998-4-28',104964,12,8747.00,'C');
insert into tab_loan values (6321,6505,'1998-10-8',38496,12,3208.00,'C');
insert into tab_loan values (6322,6510,'1997-5-6',76992,24,3208.00,'C');
insert into tab_loan values (6336,6555,'1994-3-31',212400,36,5900.00,'A');
insert into tab_loan values (6338,6592,'1997-8-24',390660,60,6511.00,'C');
insert into tab_loan values (6342,6609,'1995-11-12',60156,36,1671.00,'B');
insert into tab_loan values (6346,6649,'1997-5-22',100260,60,1671.00,'C');
insert into tab_loan values (6350,6678,'1997-7-9',294384,48,6133.00,'C');
insert into tab_loan values (6353,6686,'1997-12-25',116496,24,4854.00,'C');
insert into tab_loan values (6354,6688,'1996-10-23',22968,36,638.00,'C');
insert into tab_loan values (6355,6699,'1997-9-24',127200,48,2650.00,'C');
insert into tab_loan values (6356,6701,'1993-12-8',95400,36,2650.00,'A');
insert into tab_loan values (6357,6706,'1998-7-12',64860,60,1081.00,'C');
insert into tab_loan values (6358,6715,'1995-1-14',137880,60,2298.00,'D');
insert into tab_loan values (6362,6738,'1995-10-31',37908,12,3159.00,'A');
insert into tab_loan values (6377,6792,'1997-3-17',17184,12,1432.00,'A');
insert into tab_loan values (6386,6856,'1997-4-30',124344,36,3454.00,'C');
insert into tab_loan values (6399,6902,'1997-12-21',49320,36,1370.00,'C');
insert into tab_loan values (6402,6922,'1998-12-6',139488,24,5812.00,'C');
insert into tab_loan values (6403,6924,'1995-12-5',194880,48,4060.00,'C');
insert into tab_loan values (6407,6930,'1994-5-26',25944,24,1081.00,'A');
insert into tab_loan values (6415,6950,'1997-2-12',475680,48,9910.00,'C');
insert into tab_loan values (6421,6985,'1996-7-25',96768,36,2688.00,'C');
insert into tab_loan values (6435,7045,'1997-6-16',288720,48,6015.00,'C');
insert into tab_loan values (6436,7049,'1998-5-22',495180,60,8253.00,'C');
insert into tab_loan values (6437,7052,'1997-11-9',63972,36,1777.00,'D');
insert into tab_loan values (6442,7082,'1998-2-8',194160,48,4045.00,'C');
insert into tab_loan values (6450,7099,'1998-6-10',234336,48,4882.00,'C');
insert into tab_loan values (6456,7123,'1993-12-9',47016,12,3918.00,'A');
insert into tab_loan values (6460,7133,'1994-11-6',48672,36,1352.00,'A');
insert into tab_loan values (6461,7136,'1996-9-19',74124,36,2059.00,'C');
insert into tab_loan values (6464,7156,'1998-4-16',49488,24,2062.00,'C');
insert into tab_loan values (6468,7176,'1997-11-30',203940,60,3399.00,'C');
insert into tab_loan values (6469,7180,'1998-11-17',99744,24,4156.00,'C');
insert into tab_loan values (6470,7181,'1998-5-17',49872,12,4156.00,'C');
insert into tab_loan values (6471,7184,'1996-8-4',155640,24,6485.00,'A');
insert into tab_loan values (6474,7190,'1995-6-6',63360,60,1056.00,'C');
insert into tab_loan values (6486,7240,'1998-1-15',152160,60,2536.00,'C');
insert into tab_loan values (6490,7262,'1997-2-10',73260,60,1221.00,'C');
insert into tab_loan values (6495,7274,'1998-3-12',49044,12,4087.00,'C');
insert into tab_loan values (6499,7401,'1994-1-5',80952,24,3373.00,'A');
insert into tab_loan values (6501,7418,'1996-4-29',30276,12,2523.00,'B');
insert into tab_loan values (6502,7424,'1997-12-8',30276,12,2523.00,'A');
insert into tab_loan values (6508,7437,'1998-4-19',110736,48,2307.00,'C');
insert into tab_loan values (6509,7445,'1994-3-15',55368,24,2307.00,'A');
insert into tab_loan values (6512,7454,'1994-5-26',63312,48,1319.00,'A');
insert into tab_loan values (6520,7485,'1994-3-16',91200,24,3800.00,'A');
insert into tab_loan values (6526,7523,'1995-1-3',288468,36,8013.00,'A');
insert into tab_loan values (6534,7542,'1997-10-19',590820,60,9847.00,'C');
insert into tab_loan values (6535,7546,'1995-11-2',41952,12,3496.00,'A');
insert into tab_loan values (6539,7559,'1998-7-11',12792,12,1066.00,'C');
insert into tab_loan values (6540,7562,'1995-12-31',309600,48,6450.00,'C');
insert into tab_loan values (6541,7565,'1997-8-17',153504,48,3198.00,'C');
insert into tab_loan values (6544,7594,'1997-12-11',130464,48,2718.00,'C');
insert into tab_loan values (6545,7606,'1995-12-12',191880,60,3198.00,'C');
insert into tab_loan values (6546,7607,'1995-3-27',31728,24,1322.00,'A');
insert into tab_loan values (6550,7614,'1996-5-18',320592,48,6679.00,'C');
insert into tab_loan values (6552,7632,'1998-1-8',170448,48,3551.00,'C');
insert into tab_loan values (6553,7636,'1998-1-26',42384,12,3532.00,'C');
insert into tab_loan values (6554,7637,'1997-1-29',390096,48,8127.00,'C');
insert into tab_loan values (6562,7674,'1997-3-21',94488,24,3937.00,'C');
insert into tab_loan values (6568,7713,'1998-2-25',220440,60,3674.00,'C');
insert into tab_loan values (6569,7721,'1998-5-28',45456,12,3788.00,'C');
insert into tab_loan values (6571,7733,'1998-5-12',140064,24,5836.00,'C');
insert into tab_loan values (6574,7745,'1997-12-20',77544,36,2154.00,'C');
insert into tab_loan values (6577,7753,'1994-3-11',51696,24,2154.00,'A');
insert into tab_loan values (6578,7765,'1995-12-11',27984,12,2332.00,'A');
insert into tab_loan values (6580,7769,'1994-5-22',196080,48,4085.00,'A');
insert into tab_loan values (6585,7795,'1996-10-29',372120,60,6202.00,'C');
insert into tab_loan values (6589,7815,'1996-1-1',189696,24,7904.00,'A');
insert into tab_loan values (6591,7819,'1995-2-2',20832,48,434.00,'C');
insert into tab_loan values (6594,7824,'1994-9-28',189696,24,7904.00,'B');
insert into tab_loan values (6596,7844,'1994-6-25',91584,24,3816.00,'A');
insert into tab_loan values (6598,7857,'1995-1-18',68112,12,5676.00,'A');
insert into tab_loan values (6599,7859,'1996-11-19',72120,12,6010.00,'A');
insert into tab_loan values (6600,7861,'1995-10-8',21852,36,607.00,'A');
insert into tab_loan values (6605,7890,'1997-10-14',79344,48,1653.00,'C');
insert into tab_loan values (6607,7894,'1997-10-21',153144,36,4254.00,'C');
insert into tab_loan values (6612,7907,'1997-8-31',97392,12,8116.00,'A');
insert into tab_loan values (6613,7926,'1996-9-22',84120,24,3505.00,'A');
insert into tab_loan values (6621,7957,'1997-6-14',42900,12,3575.00,'A');
insert into tab_loan values (6624,7965,'1994-9-30',71460,12,5955.00,'A');
insert into tab_loan values (6625,7966,'1997-9-7',473280,60,7888.00,'D');
insert into tab_loan values (6632,7990,'1998-4-23',144960,48,3020.00,'C');
insert into tab_loan values (6633,7997,'1998-2-5',160656,24,6694.00,'C');
insert into tab_loan values (6641,8026,'1997-9-9',128268,36,3563.00,'C');
insert into tab_loan values (6642,8027,'1994-6-5',77640,12,6470.00,'A');
insert into tab_loan values (6643,8038,'1998-1-18',35856,24,1494.00,'C');
insert into tab_loan values (6644,8039,'1996-10-20',93600,24,3900.00,'A');
insert into tab_loan values (6645,8041,'1994-11-6',140400,36,3900.00,'A');
insert into tab_loan values (6647,8051,'1994-6-1',208320,48,4340.00,'A');
insert into tab_loan values (6650,8073,'1994-2-17',49320,12,4110.00,'B');
insert into tab_loan values (6655,8085,'1997-10-17',260400,60,4340.00,'D');
insert into tab_loan values (6659,8092,'1996-2-20',56100,60,935.00,'C');
insert into tab_loan values (6660,8094,'1997-5-9',220428,36,6123.00,'C');
insert into tab_loan values (6665,8114,'1997-8-15',99300,60,1655.00,'C');
insert into tab_loan values (6667,8127,'1996-7-15',155880,24,6495.00,'A');
insert into tab_loan values (6668,8129,'1994-7-30',74736,36,2076.00,'A');
insert into tab_loan values (6675,8158,'1997-11-1',238716,36,6631.00,'C');
insert into tab_loan values (6676,8159,'1995-6-13',29784,24,1241.00,'A');
insert into tab_loan values (6677,8169,'1997-8-12',97980,60,1633.00,'C');
insert into tab_loan values (6678,8173,'1994-5-20',80340,12,6695.00,'A');
insert into tab_loan values (6682,8225,'1998-3-30',36204,12,3017.00,'D');
insert into tab_loan values (6686,8260,'1994-8-25',224604,36,6239.00,'A');
insert into tab_loan values (6687,8261,'1993-9-13',87840,24,3660.00,'A');
insert into tab_loan values (6688,8268,'1997-9-26',8616,24,359.00,'C');
insert into tab_loan values (6694,8316,'1995-3-19',134784,24,5616.00,'A');
insert into tab_loan values (6695,8320,'1997-6-4',309660,60,5161.00,'C');
insert into tab_loan values (6696,8321,'1994-5-9',89040,60,1484.00,'C');
insert into tab_loan values (6698,8327,'1996-3-10',247728,48,5161.00,'C');
insert into tab_loan values (6699,8330,'1994-3-30',7656,24,319.00,'A');
insert into tab_loan values (6704,8377,'1995-6-1',417060,60,6951.00,'C');
insert into tab_loan values (6705,8381,'1997-7-25',333648,48,6951.00,'D');
insert into tab_loan values (6712,8405,'1995-10-14',266220,60,4437.00,'C');
insert into tab_loan values (6715,8411,'1996-5-6',220620,60,3677.00,'C');
insert into tab_loan values (6721,8475,'1994-1-21',21072,24,878.00,'A');
insert into tab_loan values (6725,8489,'1995-6-23',265320,36,7370.00,'A');
insert into tab_loan values (6726,8492,'1995-9-3',85860,60,1431.00,'C');
insert into tab_loan values (6727,8505,'1997-12-10',42840,12,3570.00,'A');
insert into tab_loan values (6729,8519,'1994-8-11',74688,12,6224.00,'A');
insert into tab_loan values (6730,8523,'1998-2-15',93036,12,7753.00,'C');
insert into tab_loan values (6732,8533,'1996-9-19',174048,48,3626.00,'C');
insert into tab_loan values (6734,8547,'1996-5-30',173016,36,4806.00,'C');
insert into tab_loan values (6736,8558,'1994-6-14',288360,60,4806.00,'C');
insert into tab_loan values (6737,8564,'1995-3-11',76680,24,3195.00,'A');
insert into tab_loan values (6738,8566,'1994-9-29',230220,36,6395.00,'B');
insert into tab_loan values (6745,8625,'1995-4-10',47304,24,1971.00,'A');
insert into tab_loan values (6746,8639,'1998-6-6',185640,60,3094.00,'C');
insert into tab_loan values (6748,8645,'1998-12-8',240900,60,4015.00,'C');
insert into tab_loan values (6751,8680,'1996-7-14',85716,36,2381.00,'C');
insert into tab_loan values (6753,8688,'1997-3-20',67980,12,5665.00,'A');
insert into tab_loan values (6755,8713,'1998-7-24',170700,60,2845.00,'C');
insert into tab_loan values (6758,8742,'1997-7-29',33144,12,2762.00,'A');
insert into tab_loan values (6763,8772,'1997-6-19',88272,48,1839.00,'C');
insert into tab_loan values (6764,8776,'1995-8-26',33984,48,708.00,'C');
insert into tab_loan values (6766,8784,'1998-4-28',74352,24,3098.00,'C');
insert into tab_loan values (6785,8899,'1995-12-25',125340,60,2089.00,'C');
insert into tab_loan values (6790,8919,'1998-6-8',76104,24,3171.00,'C');
insert into tab_loan values (6791,8926,'1998-1-23',566640,60,9444.00,'C');
insert into tab_loan values (6793,8931,'1997-1-30',186300,60,3105.00,'C');
insert into tab_loan values (6805,8972,'1996-12-21',45024,48,938.00,'C');
insert into tab_loan values (6808,8982,'1994-10-12',227880,36,6330.00,'A');
insert into tab_loan values (6810,9006,'1996-6-8',186384,48,3883.00,'C');
insert into tab_loan values (6816,9017,'1996-3-26',100224,48,2088.00,'D');
insert into tab_loan values (6817,9024,'1996-10-4',70656,48,1472.00,'C');
insert into tab_loan values (6818,9030,'1996-12-12',155616,48,3242.00,'C');
insert into tab_loan values (6819,9031,'1997-5-3',50112,24,2088.00,'C');
insert into tab_loan values (6820,9034,'1993-12-16',38148,12,3179.00,'A');
insert into tab_loan values (6821,9037,'1998-9-15',321936,48,6707.00,'C');
insert into tab_loan values (6824,9052,'1997-2-26',71976,24,2999.00,'D');
insert into tab_loan values (6836,9093,'1994-8-3',189300,60,3155.00,'C');
insert into tab_loan values (6841,9104,'1994-8-7',172080,48,3585.00,'A');
insert into tab_loan values (6851,9138,'1997-6-3',272220,60,4537.00,'D');
insert into tab_loan values (6852,9140,'1998-11-10',16032,48,334.00,'C');
insert into tab_loan values (6855,9153,'1998-3-1',52236,36,1451.00,'C');
insert into tab_loan values (6856,9156,'1998-12-1',163332,36,4537.00,'C');
insert into tab_loan values (6857,9159,'1998-6-8',69600,48,1450.00,'C');
insert into tab_loan values (6859,9167,'1998-3-7',272220,60,4537.00,'C');
insert into tab_loan values (6861,9179,'1998-2-28',215040,60,3584.00,'C');
insert into tab_loan values (6863,9188,'1993-7-28',127080,60,2118.00,'A');
insert into tab_loan values (6865,9199,'1996-9-11',29448,12,2454.00,'B');
insert into tab_loan values (6866,9201,'1998-2-5',122472,24,5103.00,'C');
insert into tab_loan values (6868,9208,'1998-10-12',82128,24,3422.00,'C');
insert into tab_loan values (6871,9225,'1997-4-13',164256,48,3422.00,'C');
insert into tab_loan values (6872,9227,'1998-4-29',191580,60,3193.00,'C');
insert into tab_loan values (6875,9235,'1997-3-13',83280,48,1735.00,'C');
insert into tab_loan values (6876,9236,'1993-12-21',86616,12,7218.00,'A');
insert into tab_loan values (6877,9241,'1997-6-19',285240,60,4754.00,'C');
insert into tab_loan values (6878,9242,'1997-1-24',23184,12,1932.00,'A');
insert into tab_loan values (6887,9263,'1997-5-8',39576,12,3298.00,'A');
insert into tab_loan values (6888,9265,'1994-7-11',39576,12,3298.00,'A');
insert into tab_loan values (6895,9307,'1994-9-19',41904,12,3492.00,'A');
insert into tab_loan values (6903,9337,'1994-6-4',52128,24,2172.00,'A');
insert into tab_loan values (6908,9353,'1997-6-8',188616,24,7859.00,'C');
insert into tab_loan values (6913,9377,'1997-4-29',99936,24,4164.00,'C');
insert into tab_loan values (6919,9403,'1994-8-5',120888,36,3358.00,'A');
insert into tab_loan values (6921,9422,'1996-10-29',86184,12,7182.00,'A');
insert into tab_loan values (6922,9424,'1997-8-26',83628,36,2323.00,'C');
insert into tab_loan values (6923,9433,'1998-10-5',44640,24,1860.00,'C');
insert into tab_loan values (6926,9455,'1998-2-7',374760,60,6246.00,'C');
insert into tab_loan values (6929,9472,'1995-5-8',36396,12,3033.00,'A');
insert into tab_loan values (6932,9491,'1998-6-25',225504,48,4698.00,'C');
insert into tab_loan values (6933,9493,'1995-9-9',188688,48,3931.00,'C');
insert into tab_loan values (6934,9494,'1997-2-9',116832,12,9736.00,'A');
insert into tab_loan values (6938,9504,'1997-3-10',341280,60,5688.00,'C');
insert into tab_loan values (6940,9510,'1996-11-22',228276,36,6341.00,'C');
insert into tab_loan values (6942,9513,'1997-7-16',18324,12,1527.00,'A');
insert into tab_loan values (6944,9548,'1996-11-15',46176,48,962.00,'C');
insert into tab_loan values (6948,9560,'1998-3-15',157068,36,4363.00,'C');
insert into tab_loan values (6949,9583,'1995-12-12',104712,24,4363.00,'A');
insert into tab_loan values (6950,9591,'1995-4-11',104712,24,4363.00,'A');
insert into tab_loan values (6955,9627,'1995-11-22',244368,48,5091.00,'C');
insert into tab_loan values (6956,9631,'1997-11-9',59448,24,2477.00,'C');
insert into tab_loan values (6959,9633,'1997-6-30',59448,24,2477.00,'D');
insert into tab_loan values (6960,9640,'1995-1-11',76416,24,3184.00,'A');
insert into tab_loan values (6961,9645,'1996-6-6',176148,36,4893.00,'C');
insert into tab_loan values (6962,9646,'1998-4-2',279072,48,5814.00,'C');
insert into tab_loan values (6965,9656,'1995-6-13',139536,24,5814.00,'A');
insert into tab_loan values (6969,9673,'1998-9-12',88200,36,2450.00,'C');
insert into tab_loan values (6970,9677,'1997-6-17',31620,60,527.00,'C');
insert into tab_loan values (6984,9730,'1997-8-15',116040,60,1934.00,'C');
insert into tab_loan values (6985,9731,'1995-11-22',113796,36,3161.00,'A');
insert into tab_loan values (6986,9750,'1995-2-11',151728,48,3161.00,'D');
insert into tab_loan values (6992,9790,'1996-7-27',133968,48,2791.00,'C');
insert into tab_loan values (6995,9814,'1996-9-26',96168,12,8014.00,'A');
insert into tab_loan values (6996,9828,'1995-4-13',126600,24,5275.00,'A');
insert into tab_loan values (6998,9833,'1994-5-21',97632,12,8136.00,'A');
insert into tab_loan values (7001,9859,'1997-8-10',300600,60,5010.00,'C');
insert into tab_loan values (7004,9869,'1995-3-15',331560,60,5526.00,'C');
insert into tab_loan values (7008,9897,'1995-9-22',36168,12,3014.00,'A');
insert into tab_loan values (7013,9928,'1996-8-2',89340,60,1489.00,'C');
insert into tab_loan values (7034,10001,'1996-7-11',19044,36,529.00,'C');
insert into tab_loan values (7035,10005,'1998-7-29',210744,36,5854.00,'C');
insert into tab_loan values (7036,10019,'1996-9-25',194940,36,5415.00,'C');
insert into tab_loan values (7037,10022,'1998-1-3',218064,48,4543.00,'C');
insert into tab_loan values (7046,10049,'1997-3-28',91632,12,7636.00,'A');
insert into tab_loan values (7049,10063,'1997-6-24',233424,36,6484.00,'C');
insert into tab_loan values (7050,10065,'1997-9-23',311232,48,6484.00,'C');
insert into tab_loan values (7051,10068,'1997-7-28',77808,12,6484.00,'A');
insert into tab_loan values (7055,10079,'1994-4-6',167100,60,2785.00,'C');
insert into tab_loan values (7057,10093,'1995-10-20',231696,36,6436.00,'A');
insert into tab_loan values (7061,10105,'1994-8-27',121896,24,5079.00,'A');
insert into tab_loan values (7066,10131,'1994-5-2',215388,36,5983.00,'B');
insert into tab_loan values (7067,10134,'1998-1-11',136368,24,5682.00,'C');
insert into tab_loan values (7072,10148,'1998-1-27',22104,12,1842.00,'C');
insert into tab_loan values (7085,10202,'1997-6-19',305424,48,6363.00,'C');
insert into tab_loan values (7087,10215,'1997-2-20',44304,24,1846.00,'C');
insert into tab_loan values (7088,10233,'1997-5-3',239160,60,3986.00,'C');
insert into tab_loan values (7091,10243,'1998-9-22',113436,36,3151.00,'C');
insert into tab_loan values (7096,10257,'1998-9-2',37812,12,3151.00,'C');
insert into tab_loan values (7097,10266,'1993-12-23',75624,24,3151.00,'B');
insert into tab_loan values (7100,10280,'1997-12-31',348120,60,5802.00,'C');
insert into tab_loan values (7101,10297,'1996-11-18',421008,48,8771.00,'C');
insert into tab_loan values (7104,10320,'1993-12-13',259740,60,4329.00,'A');
insert into tab_loan values (7110,10345,'1998-1-21',31260,12,2605.00,'C');
insert into tab_loan values (7115,10351,'1997-3-4',88704,48,1848.00,'C');
insert into tab_loan values (7119,10361,'1997-6-2',86880,12,7240.00,'A');
insert into tab_loan values (7121,10364,'1993-11-10',21924,36,609.00,'A');
insert into tab_loan values (7122,10365,'1997-1-4',260640,36,7240.00,'D');
insert into tab_loan values (7129,10404,'1998-3-1',194280,60,3238.00,'C');
insert into tab_loan values (7130,10411,'1996-12-11',123408,24,5142.00,'A');
insert into tab_loan values (7136,10436,'1996-9-28',54396,36,1511.00,'C');
insert into tab_loan values (7137,10439,'1994-6-3',151560,24,6315.00,'A');
insert into tab_loan values (7138,10440,'1995-7-3',60000,60,1000.00,'C');
insert into tab_loan values (7139,10445,'1998-1-22',23412,12,1951.00,'C');
insert into tab_loan values (7142,10451,'1994-12-19',482940,60,8049.00,'D');
insert into tab_loan values (7147,10478,'1998-1-2',267600,48,5575.00,'C');
insert into tab_loan values (7151,10493,'1998-2-18',133800,24,5575.00,'C');
insert into tab_loan values (7154,10520,'1996-12-5',417600,60,6960.00,'C');
insert into tab_loan values (7164,10613,'1998-8-15',249792,48,5204.00,'C');
insert into tab_loan values (7166,10630,'1995-6-24',198240,24,8260.00,'A');
insert into tab_loan values (7167,10644,'1998-6-18',269964,36,7499.00,'C');
insert into tab_loan values (7168,10645,'1998-7-5',208332,36,5787.00,'C');
insert into tab_loan values (7171,10650,'1998-2-24',196224,48,4088.00,'C');
insert into tab_loan values (7172,10652,'1998-5-7',45720,12,3810.00,'C');
insert into tab_loan values (7176,10663,'1995-10-28',260028,36,7223.00,'A');
insert into tab_loan values (7181,10679,'1997-10-2',197808,24,8242.00,'C');
insert into tab_loan values (7187,10711,'1997-12-24',24180,60,403.00,'C');
insert into tab_loan values (7189,10728,'1996-3-21',154656,48,3222.00,'C');
insert into tab_loan values (7192,10738,'1994-12-21',115992,36,3222.00,'A');
insert into tab_loan values (7194,10762,'1996-9-17',68832,36,1912.00,'C');
insert into tab_loan values (7195,10774,'1998-4-23',339168,48,7066.00,'C');
insert into tab_loan values (7198,10788,'1994-8-23',45768,12,3814.00,'A');
insert into tab_loan values (7199,10789,'1997-12-9',45768,12,3814.00,'A');
insert into tab_loan values (7200,10799,'1998-7-11',31140,60,519.00,'C');
insert into tab_loan values (7201,10807,'1997-3-7',67464,12,5622.00,'A');
insert into tab_loan values (7202,10812,'1998-5-29',140688,48,2931.00,'C');
insert into tab_loan values (7209,10857,'1997-11-30',385560,60,6426.00,'D');
insert into tab_loan values (7213,10884,'1996-2-13',113544,36,3154.00,'C');
insert into tab_loan values (7219,10905,'1997-8-23',57120,48,1190.00,'C');
insert into tab_loan values (7220,10911,'1994-7-28',131292,36,3647.00,'A');
insert into tab_loan values (7221,10915,'1998-6-11',152460,60,2541.00,'C');
insert into tab_loan values (7226,10940,'1994-2-23',197748,36,5493.00,'A');
insert into tab_loan values (7227,10942,'1995-10-2',314520,60,5242.00,'C');
insert into tab_loan values (7230,10954,'1997-4-2',18720,60,312.00,'C');
insert into tab_loan values (7233,10963,'1996-12-25',115812,36,3217.00,'C');
insert into tab_loan values (7235,10973,'1993-10-13',154416,48,3217.00,'A');
insert into tab_loan values (7240,11013,'1993-9-6',274740,60,4579.00,'A');
insert into tab_loan values (7241,11021,'1995-3-4',168984,24,7041.00,'B');
insert into tab_loan values (7242,11027,'1997-10-23',48096,24,2004.00,'C');
insert into tab_loan values (7243,11042,'1995-12-4',217152,36,6032.00,'A');
insert into tab_loan values (7246,11054,'1996-8-20',148920,60,2482.00,'C');
insert into tab_loan values (7249,11065,'1994-6-12',69360,48,1445.00,'A');
insert into tab_loan values (7250,11069,'1997-3-4',119136,48,2482.00,'C');
insert into tab_loan values (7253,11079,'1997-4-26',98304,12,8192.00,'A');
insert into tab_loan values (7255,11096,'1997-6-9',213300,60,3555.00,'C');
insert into tab_loan values (7259,11111,'1994-1-31',108144,36,3004.00,'A');
insert into tab_loan values (7262,11135,'1994-3-1',182628,36,5073.00,'A');
insert into tab_loan values (7263,11138,'1996-1-19',89880,24,3745.00,'A');
insert into tab_loan values (7264,11141,'1997-10-7',44940,12,3745.00,'A');
insert into tab_loan values (7271,11186,'1996-10-2',392460,60,6541.00,'C');
insert into tab_loan values (7277,11231,'1997-10-24',89280,12,7440.00,'A');
insert into tab_loan values (7279,11244,'1997-12-11',155760,24,6490.00,'C');
insert into tab_loan values (7284,11265,'1993-9-15',52788,12,4399.00,'A');
insert into tab_loan values (7286,11271,'1997-1-31',67320,36,1870.00,'C');
insert into tab_loan values (7292,11317,'1998-11-22',317460,60,5291.00,'C');
insert into tab_loan values (7294,11327,'1998-9-27',39168,24,1632.00,'C');
insert into tab_loan values (7295,11328,'1998-7-18',280440,60,4674.00,'C');
insert into tab_loan values (7304,11349,'1995-10-29',419880,60,6998.00,'C');
insert into tab_loan values (7305,11359,'1996-8-6',54024,12,4502.00,'A');
insert into tab_loan values (7308,11362,'1996-12-27',129408,24,5392.00,'A');
insert into tab_order values (4959,29402,2,'ST','89597016',3372.70,'UVER');
insert into tab_order values (4959,29403,2,'QR','13943797',7266.00,'SIPO');
insert into tab_order values (4961,29423,19,'QR','14132368',2523.20,'UVER');
insert into tab_order values (4962,29431,25,'YZ','1301700',2523.20,'UVER');
insert into tab_order values (4962,29432,25,'IJ','4896235',6817.00,'SIPO');
insert into tab_order values (4962,29433,25,'AB','79838293',1110.00,NULL);
insert into tab_order values (4962,29434,25,'WX','52864879',164.00,'POJISTNE');
insert into tab_order values (4967,29451,37,'QR','71644407',5307.50,'UVER');
insert into tab_order values (4967,29452,37,'IJ','29728555',2317.00,'SIPO');
insert into tab_order values (4967,29453,37,'OP','23782724',2584.00,NULL);
insert into tab_order values (4967,29454,37,'YZ','89609831',97.00,'POJISTNE');
insert into tab_order values (4968,29455,38,'QR','79067885',2306.80,'UVER');
insert into tab_order values (4968,29456,38,'EF','2692229',6901.00,'SIPO');
insert into tab_order values (4968,29457,38,'KL','83435654',231.00,NULL);
insert into tab_order values (4968,29458,38,'OP','64685678',228.00,'POJISTNE');
insert into tab_order values (4973,29502,67,'YZ','45128363',6915.00,'UVER');
insert into tab_order values (4973,29503,67,'YZ','57342255',6393.00,'SIPO');
insert into tab_order values (4973,29504,67,'UV','59079301',445.00,NULL);
insert into tab_order values (4986,29559,97,'ST','69820374',1436.00,'SIPO');
insert into tab_order values (4986,29560,97,'CD','33796209',2411.00,NULL);
insert into tab_order values (4986,29561,97,'ST','83123987',3.00,'POJISTNE');
insert into tab_order values (4986,29562,97,'CD','94469666',15.00,NULL);
insert into tab_order values (4986,29563,97,'MN','9693319',8573.00,'UVER');
insert into tab_order values (4988,29575,103,'MN','2646291',7370.20,'UVER');
insert into tab_order values (4989,29578,105,'UV','58251345',7348.00,'UVER');
insert into tab_order values (4990,29584,110,'OP','24390584',3050.00,'SIPO');
insert into tab_order values (4990,29585,110,'YZ','18149984',98.00,NULL);
insert into tab_order values (4990,29586,110,'ST','14772266',4516.00,'UVER');
insert into tab_order values (4996,29614,132,'WX','80542558',7370.20,'UVER');
insert into tab_order values (5002,29659,173,'KL','95605074',6256.00,'SIPO');
insert into tab_order values (5002,29660,173,'KL','26238835',1428.00,NULL);
insert into tab_order values (5002,29661,173,'CD','85405385',735.00,'POJISTNE');
insert into tab_order values (5002,29662,173,'CD','50065535',189.00,NULL);
insert into tab_order values (5002,29663,173,'UV','38819456',8734.00,'UVER');
insert into tab_order values (5005,29667,176,'GH','53236597',2288.30,'UVER');
insert into tab_order values (5005,29668,176,'AB','55640232',4564.00,'SIPO');
insert into tab_order values (5005,29669,176,'OP','90734010',36.00,NULL);
insert into tab_order values (5005,29670,176,'QR','11736327',97.00,'POJISTNE');
insert into tab_order values (5015,29743,226,'UV','29971635',8928.00,'SIPO');
insert into tab_order values (5015,29744,226,'GH','39824432',9112.00,'UVER');
insert into tab_order values (5027,29815,276,'AB','22070646',4470.50,'UVER');
insert into tab_order values (5027,29816,276,'EF','80801391',5212.00,'SIPO');
insert into tab_order values (5032,29838,290,'YZ','60961633',2577.00,'UVER');
insert into tab_order values (5032,29839,290,'UV','10382223',2653.00,'SIPO');
insert into tab_order values (5032,29840,290,'IJ','5267882',3274.00,NULL);
insert into tab_order values (5034,29857,303,'KL','43664085',3803.00,'SIPO');
insert into tab_order values (5034,29858,303,'UV','25709551',3132.00,'UVER');
insert into tab_order values (5036,29863,309,'UV','74396675',1901.00,'UVER');
insert into tab_order values (5039,29872,314,'WX','56231456',2785.00,'UVER');
insert into tab_order values (5039,29873,314,'KL','99187093',13691.00,'SIPO');
insert into tab_order values (5041,29877,319,'GH','41618597',6149.50,'UVER');
insert into tab_order values (5041,29878,319,'KL','87909203',1057.00,'SIPO');
insert into tab_order values (5041,29879,319,'KL','32717514',2196.00,NULL);
insert into tab_order values (5041,29880,319,'AB','559258',416.00,'POJISTNE');
insert into tab_order values (5042,29895,330,'OP','23515820',6908.00,'UVER');
insert into tab_order values (5043,29906,339,'OP','60226070',7801.20,'UVER');
insert into tab_order values (5043,29907,339,'WX','52391654',4087.00,'SIPO');
insert into tab_order values (5043,29908,339,'IJ','21728092',48.00,NULL);
insert into tab_order values (5044,29913,344,'WX','47483712',4739.00,'SIPO');
insert into tab_order values (5044,29914,344,'CD','77219027',1683.00,'UVER');
insert into tab_order values (5045,29917,347,'CD','37914210',7801.20,'UVER');
insert into tab_order values (5046,29918,349,'ST','83005469',4660.00,'SIPO');
insert into tab_order values (5046,29919,349,'YZ','66345286',3568.00,'UVER');
insert into tab_order values (5051,29967,378,'MN','28203147',3840.20,'UVER');
insert into tab_order values (5051,29968,378,'KL','6934583',8537.00,'SIPO');
insert into tab_order values (5051,29969,378,'AB','85313254',1184.00,NULL);
insert into tab_order values (5051,29970,378,'ST','70710897',2.00,'POJISTNE');
insert into tab_order values (5051,29971,378,'KL','23140502',4.00,NULL);
insert into tab_order values (5060,30045,426,'MN','45444989',4201.20,'UVER');
insert into tab_order values (5060,30046,426,'AB','9528249',7497.00,'SIPO');
insert into tab_order values (5060,30047,426,'GH','34606760',886.00,NULL);
insert into tab_order values (5061,30061,440,'QR','84914481',5825.00,'SIPO');
insert into tab_order values (5061,30062,440,'GH','78983664',1756.00,'UVER');
insert into tab_order values (5063,30066,442,'EF','55799275',7455.00,'UVER');
insert into tab_order values (5063,30067,442,'CD','21739507',5606.00,'SIPO');
insert into tab_order values (5063,30068,442,'ST','98938321',2068.00,NULL);
insert into tab_order values (5072,30113,472,'UV','6824928',8200.20,'UVER');
insert into tab_order values (5082,30160,501,'KL','79491948',4382.70,'UVER');
insert into tab_order values (5086,30191,525,'MN','88872944',4382.70,'UVER');
insert into tab_order values (5086,30192,525,'ST','67853247',6454.00,'SIPO');
insert into tab_order values (5088,30217,544,'EF','24082440',3798.20,'UVER');
insert into tab_order values (5103,30372,666,'AB','85506128',3936.00,'SIPO');
insert into tab_order values (5103,30373,666,'ST','70089435',2282.00,NULL);
insert into tab_order values (5103,30374,666,'GH','93173819',955.00,'POJISTNE');
insert into tab_order values (5103,30375,666,'UV','65873688',1045.00,'UVER');
insert into tab_order values (5110,30392,675,'MN','74623369',6358.00,'SIPO');
insert into tab_order values (5110,30393,675,'MN','56463271',1704.00,'UVER');
insert into tab_order values (5117,30450,718,'KL','3925556',6412.00,'UVER');
insert into tab_order values (5117,30451,718,'KL','22049463',726.00,'SIPO');
insert into tab_order values (5117,30452,718,'QR','9956103',7122.00,NULL);
insert into tab_order values (5117,30453,718,'MN','10620361',6041.00,'POJISTNE');
insert into tab_order values (5124,30545,785,'MN','34928149',4335.80,'UVER');
insert into tab_order values (5124,30546,785,'CD','69687145',7395.00,'SIPO');
insert into tab_order values (5125,30552,789,'OP','64140730',2153.00,'SIPO');
insert into tab_order values (5125,30553,789,'OP','84300315',1641.00,NULL);
insert into tab_order values (5125,30554,789,'AB','13870329',1522.00,'UVER');
insert into tab_order values (5126,30555,790,'MN','86892044',4335.80,'UVER');
insert into tab_order values (5128,30578,808,'QR','95864551',4492.00,'UVER');
insert into tab_order values (5130,30583,813,'IJ','39089608',2025.70,'UVER');
insert into tab_order values (5131,30587,816,'OP','35554933',2025.70,'UVER');
insert into tab_order values (5131,30588,816,'QR','67616367',4514.00,'SIPO');
insert into tab_order values (5132,30589,817,'GH','53805935',4605.00,'SIPO');
insert into tab_order values (5132,30590,817,'AB','75855749',8975.00,'UVER');
insert into tab_order values (5134,30603,825,'YZ','35577237',9235.00,'SIPO');
insert into tab_order values (5134,30604,825,'YZ','87110560',4423.00,'UVER');
insert into tab_order values (5136,30630,846,'WX','61563986',7795.50,'UVER');
insert into tab_order values (5138,30642,854,'AB','21777671',382.00,'SIPO');
insert into tab_order values (5138,30643,854,'KL','41849011',1105.00,NULL);
insert into tab_order values (5138,30644,854,'IJ','6306148',2843.00,'POJISTNE');
insert into tab_order values (5138,30645,854,'OP','54977858',1817.00,'UVER');
insert into tab_order values (5140,30678,873,'CD','22322130',878.00,'SIPO');
insert into tab_order values (5140,30679,873,'QR','57947230',1540.00,NULL);
insert into tab_order values (5140,30680,873,'YZ','91838556',2211.00,'POJISTNE');
insert into tab_order values (5140,30681,873,'UV','38070190',2975.00,'UVER');
insert into tab_order values (5145,30743,915,'MN','88686042',6449.00,'UVER');
insert into tab_order values (5145,30744,915,'EF','73569780',14291.00,'SIPO');
insert into tab_order values (5147,30778,938,'AB','33329439',3282.00,'SIPO');
insert into tab_order values (5147,30779,938,'GH','56959378',371.00,'UVER');
insert into tab_order values (5148,30781,940,'OP','99014985',4738.00,'UVER');
insert into tab_order values (5151,30804,960,'YZ','8817315',3151.00,'UVER');
insert into tab_order values (5151,30805,960,'CD','19250178',5940.00,'SIPO');
insert into tab_order values (5154,30847,993,'WX','89932006',1812.30,'UVER');
insert into tab_order values (5158,30869,1004,'KL','48386609',5237.00,'UVER');
insert into tab_order values (5160,30880,1011,'QR','9464615',3400.50,'UVER');
insert into tab_order values (5160,30881,1011,'WX','17116374',7085.00,'SIPO');
insert into tab_order values (5161,30882,1012,'EF','56211417',4090.80,'UVER');
insert into tab_order values (5169,30955,1068,'ST','2958560',4219.50,'UVER');
insert into tab_order values (5169,30956,1068,'AB','6389087',4737.00,'SIPO');
insert into tab_order values (5169,30957,1068,'YZ','29813301',3273.00,NULL);
insert into tab_order values (5169,30958,1068,'CD','73765313',632.00,'POJISTNE');
insert into tab_order values (5170,30961,1071,'GH','21432626',4219.50,'UVER');
insert into tab_order values (5172,30974,1083,'KL','52041840',1930.00,'SIPO');
insert into tab_order values (5172,30975,1083,'KL','1474237',835.00,NULL);
insert into tab_order values (5172,30976,1083,'YZ','70442372',4351.00,'POJISTNE');
insert into tab_order values (5172,30977,1083,'EF','96308820',1416.00,'UVER');
insert into tab_order values (5174,30989,1093,'ST','99570404',8022.80,'UVER');
insert into tab_order values (5174,30990,1093,'EF','21858203',10261.00,'SIPO');
insert into tab_order values (5176,31017,1106,'WX','7667500',8022.80,'UVER');
insert into tab_order values (5189,31097,1166,'CD','62584346',3105.20,'UVER');
insert into tab_order values (5189,31098,1166,'EF','69850820',4397.00,'SIPO');
insert into tab_order values (5206,31214,1242,'CD','11588836',5355.70,'UVER');
insert into tab_order values (5206,31215,1242,'GH','12355560',4910.00,'SIPO');
insert into tab_order values (5206,31216,1242,'AB','62675297',3674.00,NULL);
insert into tab_order values (5206,31217,1242,'OP','25744539',422.00,'POJISTNE');
insert into tab_order values (5206,31218,1242,'UV','13214141',38.00,NULL);
insert into tab_order values (5207,31219,1244,'EF','22533941',903.00,'SIPO');
insert into tab_order values (5207,31220,1244,'IJ','81744551',2122.00,NULL);
insert into tab_order values (5207,31221,1244,'WX','97042274',406.00,'POJISTNE');
insert into tab_order values (5207,31222,1244,'QR','49724513',54.00,NULL);
insert into tab_order values (5207,31223,1244,'AB','67696446',748.00,'UVER');
insert into tab_order values (5208,31226,1247,'YZ','9652227',2077.00,'UVER');
insert into tab_order values (5209,31231,1250,'GH','21845096',3805.20,'UVER');
insert into tab_order values (5209,31232,1250,'YZ','14470041',61.00,'SIPO');
insert into tab_order values (5209,31233,1250,'IJ','49418222',10069.00,NULL);
insert into tab_order values (5210,31235,1252,'UV','84370898',4114.70,'UVER');
insert into tab_order values (5212,31239,1256,'AB','72944313',1178.00,'SIPO');
insert into tab_order values (5212,31240,1256,'ST','69528400',5450.00,NULL);
insert into tab_order values (5212,31241,1256,'IJ','9768981',1974.00,'UVER');
insert into tab_order values (5214,31262,1270,'AB','27904290',2077.30,'UVER');
insert into tab_order values (5214,31263,1270,'WX','88882463',4162.00,'SIPO');
insert into tab_order values (5221,31282,1284,'AB','29951918',4375.50,'UVER');
insert into tab_order values (5226,31328,1318,'ST','77757256',5154.00,'UVER');
insert into tab_order values (5226,31329,1318,'AB','10788429',8677.00,'SIPO');
insert into tab_order values (5226,31330,1318,'AB','50830727',1762.00,NULL);
insert into tab_order values (5226,31331,1318,'MN','13490295',2015.00,'POJISTNE');
insert into tab_order values (5226,31332,1318,'AB','44717049',744.00,NULL);
insert into tab_order values (5229,31354,1329,'UV','31472492',1960.20,'UVER');
insert into tab_order values (5229,31355,1329,'QR','69419830',3368.00,'SIPO');
insert into tab_order values (5229,31356,1329,'AB','48227208',5081.00,NULL);
insert into tab_order values (5236,31426,1374,'WX','38325822',8107.30,'UVER');
insert into tab_order values (5237,31427,1375,'CD','90090238',5930.00,'SIPO');
insert into tab_order values (5237,31428,1375,'MN','47862768',1889.00,'UVER');
insert into tab_order values (5241,31447,1389,'IJ','18867123',5227.70,'UVER');
insert into tab_order values (5241,31448,1389,'WX','71177351',6376.00,'SIPO');
insert into tab_order values (5245,31483,1407,'UV','51198023',5227.70,'UVER');
insert into tab_order values (5245,31484,1407,'ST','30396717',14882.00,'SIPO');
insert into tab_order values (5253,31538,1447,'YZ','1155138',2084.70,'UVER');
insert into tab_order values (5253,31539,1447,'OP','54932880',8210.00,'SIPO');
insert into tab_order values (5260,31581,1480,'WX','70736652',3425.20,'UVER');
insert into tab_order values (5265,31613,1498,'ST','26674098',2762.80,'UVER');
insert into tab_order values (5269,31649,1527,'EF','27702808',4557.20,'UVER');
insert into tab_order values (5270,31651,1528,'QR','58779168',3981.00,'UVER');
insert into tab_order values (5281,31729,1580,'UV','11339313',8094.20,'UVER');
insert into tab_order values (5282,31732,1583,'QR','49376446',8094.20,'UVER');
insert into tab_order values (5285,31762,1603,'WX','92258166',2359.00,'SIPO');
insert into tab_order values (5285,31763,1603,'MN','3211814',1187.00,NULL);
insert into tab_order values (5285,31764,1603,'CD','6821167',6578.00,'UVER');
insert into tab_order values (5287,31801,1638,'AB','8848363',2676.00,'UVER');
insert into tab_order values (5287,31802,1638,'QR','57185012',9749.00,'SIPO');
insert into tab_order values (5293,31832,1656,'IJ','73249953',3954.30,'UVER');
insert into tab_order values (5293,31833,1656,'YZ','10182565',12113.00,'SIPO');
insert into tab_order values (5301,31891,1698,'UV','6397009',9642.00,'SIPO');
insert into tab_order values (5301,31892,1698,'CD','30528074',3943.00,'UVER');
insert into tab_order values (5304,31917,1718,'CD','9266335',7178.00,'UVER');
insert into tab_order values (5304,31918,1718,'AB','69613939',14456.00,'SIPO');
insert into tab_order values (5310,31974,1762,'CD','73894780',853.00,'SIPO');
insert into tab_order values (5310,31975,1762,'QR','49858301',3352.00,NULL);
insert into tab_order values (5310,31976,1762,'MN','87955689',1972.00,'POJISTNE');
insert into tab_order values (5310,31977,1762,'QR','76073628',6893.00,'UVER');
insert into tab_order values (5311,31982,1766,'KL','85209738',4353.00,'SIPO');
insert into tab_order values (5311,31983,1766,'EF','6482232',43.00,NULL);
insert into tab_order values (5311,31984,1766,'YZ','88636147',49.00,'POJISTNE');
insert into tab_order values (5311,31985,1766,'OP','41643542',2390.00,NULL);
insert into tab_order values (5311,31986,1766,'CD','41536575',501.00,'UVER');
insert into tab_order values (5312,31992,1772,'WX','51707452',5633.00,'UVER');
insert into tab_order values (5312,31993,1772,'IJ','88971179',11994.00,'SIPO');
insert into tab_order values (5313,31997,1776,'YZ','86032962',5710.00,'SIPO');
insert into tab_order values (5313,31998,1776,'WX','80855452',1800.00,'UVER');
insert into tab_order values (5314,32012,1787,'EF','8468449',8033.20,'UVER');
insert into tab_order values (5316,32035,1801,'OP','33671474',4610.00,'UVER');
insert into tab_order values (5316,32036,1801,'QR','49547737',4167.00,'SIPO');
insert into tab_order values (5316,32037,1801,'YZ','80957543',3419.00,NULL);
insert into tab_order values (5316,32038,1801,'AB','73968469',956.00,'POJISTNE');
insert into tab_order values (5318,32047,1808,'QR','39164525',8033.20,'UVER');
insert into tab_order values (5319,32052,1811,'EF','84066038',3990.80,'UVER');
insert into tab_order values (5319,32053,1811,'ST','37117743',4206.00,'SIPO');
insert into tab_order values (5319,32054,1811,'KL','87739562',6745.00,NULL);
insert into tab_order values (5320,32064,1819,'UV','82792853',3990.80,'UVER');
insert into tab_order values (5320,32065,1819,'OP','78877323',966.00,'SIPO');
insert into tab_order values (5320,32066,1819,'MN','18223607',1236.00,NULL);
insert into tab_order values (5320,32067,1819,'UV','82754003',8253.00,'POJISTNE');
insert into tab_order values (5325,32104,1843,'QR','70984434',2938.70,'UVER');
insert into tab_order values (5325,32105,1843,'QR','62958741',6994.00,'SIPO');
insert into tab_order values (5329,32128,1862,'YZ','95449792',6601.70,'UVER');
insert into tab_order values (5332,32137,1869,'YZ','44563007',1054.00,'UVER');
insert into tab_order values (5334,32143,1876,'IJ','65358716',2329.00,'SIPO');
insert into tab_order values (5334,32144,1876,'YZ','2049482',723.00,NULL);
insert into tab_order values (5334,32145,1876,'EF','57234233',8710.00,'UVER');
insert into tab_order values (5337,32157,1886,'QR','56325697',4512.70,'UVER');
insert into tab_order values (5337,32158,1886,'KL','65109085',4198.00,'SIPO');
insert into tab_order values (5338,32160,1888,'KL','40829509',4780.00,'UVER');
insert into tab_order values (5338,32161,1888,'OP','88992631',510.00,'SIPO');
insert into tab_order values (5338,32162,1888,'YZ','35539561',3473.00,NULL);
insert into tab_order values (5338,32163,1888,'OP','94599204',3269.00,'POJISTNE');
insert into tab_order values (5343,32190,1906,'OP','59762132',1872.80,'UVER');
insert into tab_order values (5343,32191,1906,'YZ','62735038',7355.00,'SIPO');
insert into tab_order values (5343,32192,1906,'YZ','40499287',158.00,NULL);
insert into tab_order values (5346,32222,1928,'GH','84353714',2317.50,'UVER');
insert into tab_order values (5350,32277,1967,'YZ','88398128',5194.00,'UVER');
insert into tab_order values (5350,32278,1967,'KL','91595464',14164.00,'SIPO');
insert into tab_order values (5351,32293,1978,'KL','82303452',5700.30,'UVER');
insert into tab_order values (5351,32294,1978,'OP','85430520',7001.00,'SIPO');
insert into tab_order values (5351,32295,1978,'UV','57071173',5900.00,NULL);
insert into tab_order values (5351,32296,1978,'KL','25988853',356.00,'POJISTNE');
insert into tab_order values (5352,32310,1993,'ST','35646581',5700.30,'UVER');
insert into tab_order values (5354,32321,2000,'YZ','79359417',3318.00,'SIPO');
insert into tab_order values (5354,32322,2000,'GH','21546656',48.00,NULL);
insert into tab_order values (5354,32323,2000,'AB','32802260',14.00,'POJISTNE');
insert into tab_order values (5354,32324,2000,'KL','13970154',4847.00,'UVER');
insert into tab_order values (5358,32352,2018,'WX','36951273',3115.00,'SIPO');
insert into tab_order values (5358,32353,2018,'ST','33088541',3210.00,'UVER');
insert into tab_order values (5360,32377,2035,'WX','13259464',4898.20,'UVER');
insert into tab_order values (5360,32378,2035,'GH','67583274',8404.00,'SIPO');
insert into tab_order values (5360,32379,2035,'CD','27185577',917.00,NULL);
insert into tab_order values (5360,32380,2035,'EF','38668644',121.00,'POJISTNE');
insert into tab_order values (5360,32381,2035,'WX','54719960',93.00,NULL);
insert into tab_order values (5363,32405,2051,'UV','74274343',4898.20,'UVER');
insert into tab_order values (5365,32414,2055,'WX','8321655',6844.00,'SIPO');
insert into tab_order values (5365,32415,2055,'KL','87599461',4521.00,'UVER');
insert into tab_order values (5366,32427,2062,'QR','97387158',7182.50,'UVER');
insert into tab_order values (5366,32428,2062,'ST','30643040',107.00,'SIPO');
insert into tab_order values (5366,32429,2062,'YZ','28156739',3136.00,NULL);
insert into tab_order values (5367,32431,2064,'EF','1838881',2322.70,'UVER');
insert into tab_order values (5368,32445,2073,'KL','67186093',1860.00,'UVER');
insert into tab_order values (5369,32454,2080,'UV','34001827',5961.00,'UVER');
insert into tab_order values (5369,32455,2080,'UV','62451505',13628.00,'SIPO');
insert into tab_order values (5375,32487,2106,'IJ','64902251',3468.00,'SIPO');
insert into tab_order values (5375,32488,2106,'KL','14528537',8460.00,'UVER');
insert into tab_order values (5377,32498,2116,'EF','68418848',7699.80,'UVER');
insert into tab_order values (5377,32499,2116,'EF','86869412',1307.00,'SIPO');
insert into tab_order values (5377,32500,2116,'QR','59543710',3407.00,NULL);
insert into tab_order values (5382,32525,2134,'AB','67233997',3118.00,'SIPO');
insert into tab_order values (5382,32526,2134,'WX','15210831',641.00,NULL);
insert into tab_order values (5382,32527,2134,'MN','47395515',637.00,'UVER');
insert into tab_order values (5384,32537,2142,'YZ','3758663',9768.00,'SIPO');
insert into tab_order values (5384,32538,2142,'OP','47238999',1944.00,'UVER');
insert into tab_order values (5385,32539,2143,'MN','66855954',7264.00,'SIPO');
insert into tab_order values (5385,32540,2143,'OP','18297326',1985.00,'UVER');
insert into tab_order values (5388,32557,2153,'IJ','28541732',5129.50,'UVER');
insert into tab_order values (5388,32558,2153,'KL','60141891',1737.00,'SIPO');
insert into tab_order values (5388,32559,2153,'CD','79112446',10303.00,NULL);
insert into tab_order values (5388,32560,2153,'AB','94730412',2223.00,'POJISTNE');
insert into tab_order values (5389,32575,2165,'CD','40212154',3274.80,'UVER');
insert into tab_order values (5389,32576,2165,'IJ','83407926',12493.00,'SIPO');
insert into tab_order values (5390,32580,2167,'IJ','18770349',5922.00,'SIPO');
insert into tab_order values (5390,32581,2167,'QR','38404792',7094.00,'UVER');
insert into tab_order values (5395,32597,2176,'MN','81908911',8307.80,'UVER');
insert into tab_order values (5395,32598,2176,'KL','62845337',1085.00,'SIPO');
insert into tab_order values (5395,32599,2176,'EF','57953965',5135.00,NULL);
insert into tab_order values (5398,32613,2187,'WX','29976457',4456.00,'UVER');
insert into tab_order values (5409,32658,2218,'YZ','85124015',3034.00,'UVER');
insert into tab_order values (5413,32669,2227,'MN','86397230',3873.70,'UVER');
insert into tab_order values (5413,32670,2227,'EF','69415771',13386.00,'SIPO');
insert into tab_order values (5414,32671,2228,'CD','46155524',3873.70,'UVER');
insert into tab_order values (5414,32672,2228,'ST','68287300',4625.00,'SIPO');
insert into tab_order values (5415,32683,2236,'OP','68195986',3873.70,'UVER');
insert into tab_order values (5418,32700,2245,'UV','2059746',7248.80,'UVER');
insert into tab_order values (5419,32701,2246,'YZ','72096937',6930.00,'UVER');
insert into tab_order values (5420,32702,2247,'UV','52448576',3021.00,'UVER');
insert into tab_order values (5420,32703,2247,'OP','77294456',592.00,'SIPO');
insert into tab_order values (5420,32704,2247,'CD','39011389',1344.00,NULL);
insert into tab_order values (5420,32705,2247,'WX','68231224',659.00,'POJISTNE');
insert into tab_order values (5420,32706,2247,'UV','83908128',1051.00,NULL);
insert into tab_order values (5428,32729,2262,'CD','77488755',6395.00,'UVER');
insert into tab_order values (5429,32734,2268,'ST','1695228',5742.00,'SIPO');
insert into tab_order values (5429,32735,2268,'AB','38343775',561.00,'UVER');
insert into tab_order values (5435,32753,2279,'OP','19501900',6556.30,'UVER');
insert into tab_order values (5445,32815,2322,'KL','89574056',1930.00,'UVER');
insert into tab_order values (5445,32816,2322,'ST','75713777',3359.00,'SIPO');
insert into tab_order values (5445,32817,2322,'QR','87459748',690.00,NULL);
insert into tab_order values (5445,32818,2322,'EF','97367155',1019.00,'POJISTNE');
insert into tab_order values (5445,32819,2322,'ST','14182174',1612.00,NULL);
insert into tab_order values (5446,32834,2334,'IJ','17270642',2013.00,'UVER');
insert into tab_order values (5446,32835,2334,'ST','92322378',10707.00,'SIPO');
insert into tab_order values (5447,32836,2335,'YZ','25760704',2036.00,'SIPO');
insert into tab_order values (5447,32837,2335,'EF','61203175',1069.00,NULL);
insert into tab_order values (5447,32838,2335,'UV','98547273',485.00,'POJISTNE');
insert into tab_order values (5447,32839,2335,'OP','63746511',1676.00,NULL);
insert into tab_order values (5447,32840,2335,'GH','8226937',9020.00,'UVER');
insert into tab_order values (5449,32849,2343,'UV','28312742',4723.00,'SIPO');
insert into tab_order values (5449,32850,2343,'KL','67309921',4139.00,'UVER');
insert into tab_order values (5450,32853,2345,'QR','31917315',3328.20,'UVER');
insert into tab_order values (5450,32854,2345,'QR','16879636',3612.00,'SIPO');
insert into tab_order values (5451,32863,2350,'OP','74027311',3328.20,'UVER');
insert into tab_order values (5451,32864,2350,'KL','56521683',575.00,'SIPO');
insert into tab_order values (5451,32865,2350,'IJ','98643308',5263.00,NULL);
insert into tab_order values (5452,32867,2352,'MN','33949649',5581.00,'SIPO');
insert into tab_order values (5452,32868,2352,'GH','79024326',34.00,NULL);
insert into tab_order values (5452,32869,2352,'EF','61734002',4.00,'POJISTNE');
insert into tab_order values (5452,32870,2352,'AB','25421935',824.00,'UVER');
insert into tab_order values (5453,32878,2361,'MN','781095',4613.00,'SIPO');
insert into tab_order values (5453,32879,2361,'YZ','17524379',4352.00,'UVER');
insert into tab_order values (5463,32957,2413,'KL','97954469',6448.00,'SIPO');
insert into tab_order values (5463,32958,2413,'MN','81122290',1496.00,'UVER');
insert into tab_order values (5464,32965,2419,'ST','79840576',7984.30,'UVER');
insert into tab_order values (5469,33007,2445,'ST','37553960',4886.00,'UVER');
insert into tab_order values (5470,33018,2456,'YZ','58417534',4187.30,'UVER');
insert into tab_order values (5470,33019,2456,'KL','71291804',9554.00,'SIPO');
insert into tab_order values (5479,33072,2486,'OP','68277156',2043.00,'UVER');
insert into tab_order values (5482,33091,2496,'GH','76618009',4982.00,'SIPO');
insert into tab_order values (5482,33092,2496,'MN','51870715',2752.00,'UVER');
insert into tab_order values (5486,33123,2516,'AB','61216103',9721.00,'UVER');
insert into tab_order values (5491,33169,2545,'AB','584811',2637.00,'SIPO');
insert into tab_order values (5491,33170,2545,'ST','28254646',671.00,NULL);
insert into tab_order values (5491,33171,2545,'GH','74550294',713.00,'POJISTNE');
insert into tab_order values (5491,33172,2545,'ST','49701792',8933.00,'UVER');
insert into tab_order values (5494,33208,2572,'ST','86283236',7500.00,'UVER');
insert into tab_order values (5495,33216,2580,'AB','96968262',5016.00,'SIPO');
insert into tab_order values (5495,33217,2580,'KL','10807258',1489.00,'UVER');
insert into tab_order values (5501,33267,2622,'YZ','32006168',7067.00,'SIPO');
insert into tab_order values (5501,33268,2622,'EF','66704517',5681.00,'UVER');
insert into tab_order values (5519,33380,2694,'ST','95437645',3532.00,'SIPO');
insert into tab_order values (5519,33381,2694,'GH','45261365',7636.00,'UVER');
insert into tab_order values (5520,33387,2699,'AB','41725951',4816.00,'UVER');
insert into tab_order values (5520,33388,2699,'IJ','10817695',3743.00,'SIPO');
insert into tab_order values (5520,33389,2699,'CD','32435608',662.00,NULL);
insert into tab_order values (5523,33401,2705,'YZ','50098043',2608.20,'UVER');
insert into tab_order values (5523,33402,2705,'GH','33252960',10723.00,'SIPO');
insert into tab_order values (5525,33419,2720,'ST','27251911',2608.20,'UVER');
insert into tab_order values (5525,33420,2720,'YZ','96241729',6206.00,'SIPO');
insert into tab_order values (5525,33421,2720,'AB','33301061',4719.00,NULL);
insert into tab_order values (5526,33429,2725,'CD','59237199',3197.00,'SIPO');
insert into tab_order values (5526,33430,2725,'WX','80807143',66.00,NULL);
insert into tab_order values (5526,33431,2725,'IJ','64775931',461.00,'POJISTNE');
insert into tab_order values (5526,33432,2725,'WX','31665891',1934.00,'UVER');
insert into tab_order values (5527,33434,2728,'OP','99268948',2607.00,'UVER');
insert into tab_order values (5527,33435,2728,'EF','96346175',11222.00,'SIPO');
insert into tab_order values (5531,33471,2753,'GH','41750717',2768.00,'UVER');
insert into tab_order values (5531,33472,2753,'MN','97449540',6869.00,'SIPO');
insert into tab_order values (5532,33473,2754,'WX','6736475',6985.30,'UVER');
insert into tab_order values (5532,33474,2754,'MN','10118246',2882.00,'SIPO');
insert into tab_order values (5532,33475,2754,'QR','77635740',226.00,NULL);
insert into tab_order values (5533,33485,2762,'EF','73534762',4641.00,'UVER');
insert into tab_order values (5533,33486,2762,'UV','85078340',6892.00,'SIPO');
insert into tab_order values (5533,33487,2762,'CD','75502043',733.00,NULL);
insert into tab_order values (5549,33581,2824,'EF','94259202',7289.00,'SIPO');
insert into tab_order values (5549,33582,2824,'YZ','96265625',841.00,'UVER');
insert into tab_order values (5556,33653,2872,'CD','99307715',4040.00,'SIPO');
insert into tab_order values (5556,33654,2872,'ST','89302223',4059.00,NULL);
insert into tab_order values (5556,33655,2872,'EF','76374816',4472.00,'UVER');
insert into tab_order values (5561,33702,2910,'UV','32031208',7291.30,'UVER');
insert into tab_order values (5561,33703,2910,'UV','77491187',6778.00,'SIPO');
insert into tab_order values (5561,33704,2910,'OP','4570603',7656.00,NULL);
insert into tab_order values (5563,33709,2912,'GH','80799913',6336.00,'UVER');
insert into tab_order values (5568,33742,2933,'YZ','92012846',4542.00,'UVER');
insert into tab_order values (5568,33743,2933,'MN','29096329',5907.00,'SIPO');
insert into tab_order values (5569,33745,2936,'GH','70934575',4247.00,'SIPO');
insert into tab_order values (5569,33746,2936,'OP','93174194',8400.00,'UVER');
insert into tab_order values (5576,33786,2962,'YZ','75064962',2604.50,'UVER');
insert into tab_order values (5582,33814,2982,'AB','34302795',3438.00,'UVER');
insert into tab_order values (5582,33815,2982,'KL','40149122',8143.00,'SIPO');
insert into tab_order values (5582,33816,2982,'EF','48207306',164.00,NULL);
insert into tab_order values (5582,33817,2982,'OP','37620991',226.00,'POJISTNE');
insert into tab_order values (5582,33818,2982,'ST','51036828',23.00,NULL);
insert into tab_order values (5584,33824,2986,'MN','61638289',3301.00,'SIPO');
insert into tab_order values (5584,33825,2986,'CD','64366233',1390.00,NULL);
insert into tab_order values (5584,33826,2986,'WX','94623159',1033.00,'UVER');
insert into tab_order values (5585,33828,2988,'IJ','47759002',7384.00,'UVER');
insert into tab_order values (5586,33837,2994,'WX','20186478',3217.00,'SIPO');
insert into tab_order values (5586,33838,2994,'WX','65474504',1354.00,'UVER');
insert into tab_order values (5589,33853,3005,'CD','95518534',8125.30,'UVER');
insert into tab_order values (5589,33854,3005,'IJ','33958757',6883.00,'SIPO');
insert into tab_order values (5589,33855,3005,'AB','44410479',7696.00,NULL);
insert into tab_order values (5591,33875,3021,'AB','86677175',3241.80,'UVER');
insert into tab_order values (5593,33897,3037,'KL','19517636',7718.70,'UVER');
insert into tab_order values (5595,33915,3050,'AB','71189987',6907.50,'UVER');
insert into tab_order values (5595,33916,3050,'AB','72762232',9716.00,'SIPO');
insert into tab_order values (5595,33917,3050,'AB','62503671',119.00,NULL);
insert into tab_order values (5595,33918,3050,'CD','93120836',41.00,'POJISTNE');
insert into tab_order values (5599,33940,3064,'IJ','63995122',1455.00,'SIPO');
insert into tab_order values (5599,33941,3064,'EF','30132371',4714.00,NULL);
insert into tab_order values (5599,33942,3064,'ST','35513132',1285.00,'UVER');
insert into tab_order values (5606,33968,3084,'MN','37864983',7042.00,'UVER');
insert into tab_order values (5610,34015,3112,'IJ','66820907',2567.30,'UVER');
insert into tab_order values (5610,34016,3112,'OP','66618603',1468.00,'SIPO');
insert into tab_order values (5610,34017,3112,'KL','83437150',1584.00,NULL);
insert into tab_order values (5611,34022,3115,'UV','94811379',5353.30,'UVER');
insert into tab_order values (5611,34023,3115,'IJ','68203913',14723.00,'SIPO');
insert into tab_order values (5614,34053,3137,'ST','85610150',4226.50,'UVER');
insert into tab_order values (5616,34060,3143,'IJ','86599880',4474.00,'SIPO');
insert into tab_order values (5616,34061,3143,'OP','92271554',5454.00,'UVER');
insert into tab_order values (5620,34088,3161,'CD','21771204',2501.00,'UVER');
insert into tab_order values (5624,34098,3166,'UV','16657728',3702.80,'UVER');
insert into tab_order values (5625,34124,3189,'WX','75490885',3702.80,'UVER');
insert into tab_order values (5634,34188,3229,'QR','63988697',3252.20,'UVER');
insert into tab_order values (5634,34189,3229,'YZ','97103529',6828.00,'SIPO');
insert into tab_order values (5634,34190,3229,'WX','5108792',6411.00,NULL);
insert into tab_order values (5635,34191,3230,'YZ','9279585',2144.00,'UVER');
insert into tab_order values (5638,34219,3249,'YZ','65147852',8197.00,'SIPO');
insert into tab_order values (5638,34220,3249,'GH','63599234',5677.00,'UVER');
insert into tab_order values (5643,34256,3273,'GH','14236212',7876.00,'UVER');
insert into tab_order values (5644,34277,3293,'AB','78677373',7668.70,'UVER');
insert into tab_order values (5644,34278,3293,'MN','12542009',3231.00,'SIPO');
insert into tab_order values (5644,34279,3293,'EF','86246293',567.00,NULL);
insert into tab_order values (5644,34280,3293,'WX','16846144',58.00,'POJISTNE');
insert into tab_order values (5644,34281,3293,'CD','46667754',221.00,NULL);
insert into tab_order values (5651,34332,3329,'GH','58081787',9249.00,'SIPO');
insert into tab_order values (5651,34333,3329,'YZ','25896650',1604.00,'UVER');
insert into tab_order values (5656,34360,3353,'AB','20473671',6086.20,'UVER');
insert into tab_order values (5656,34361,3353,'WX','11269444',10616.00,'SIPO');
insert into tab_order values (5656,34362,3353,'CD','19594610',58.00,NULL);
insert into tab_order values (5656,34363,3353,'UV','21930182',414.00,'POJISTNE');
insert into tab_order values (5657,34364,3354,'IJ','6930423',489.00,'SIPO');
insert into tab_order values (5657,34365,3354,'WX','12488460',2704.00,NULL);
insert into tab_order values (5657,34366,3354,'KL','6017333',1540.00,'POJISTNE');
insert into tab_order values (5657,34367,3354,'GH','34654396',415.00,'UVER');
insert into tab_order values (5665,34412,3390,'WX','72620779',3385.50,'UVER');
insert into tab_order values (5665,34413,3390,'IJ','88170289',850.00,'SIPO');
insert into tab_order values (5665,34414,3390,'IJ','12870973',2004.00,NULL);
insert into tab_order values (5665,34415,3390,'KL','2908385',105.00,'POJISTNE');
insert into tab_order values (5665,34416,3390,'KL','97396742',560.00,NULL);
insert into tab_order values (5669,34437,3403,'QR','57706224',1995.00,'UVER');
insert into tab_order values (5674,34459,3418,'ST','23146361',4318.00,'UVER');
insert into tab_order values (5681,34502,3448,'AB','16375589',2860.70,'UVER');
insert into tab_order values (5682,34507,3455,'EF','29934013',5622.50,'UVER');
insert into tab_order values (5683,34512,3460,'IJ','5287313',2931.00,'UVER');
insert into tab_order values (5693,34568,3489,'YZ','33276313',3373.00,'SIPO');
insert into tab_order values (5693,34569,3489,'ST','2520353',1837.00,'UVER');
insert into tab_order values (5698,34642,3556,'AB','15446061',2913.80,'UVER');
insert into tab_order values (5698,34643,3556,'OP','63096010',4240.00,'SIPO');
insert into tab_order values (5698,34644,3556,'AB','8922565',984.00,NULL);
insert into tab_order values (5699,34652,3562,'MN','34374082',7290.50,'UVER');
insert into tab_order values (5706,34710,3608,'QR','97533720',4486.00,'UVER');
insert into tab_order values (5706,34711,3608,'AB','49062126',3124.00,'SIPO');
insert into tab_order values (5713,34754,3629,'MN','36472505',2645.50,'UVER');
insert into tab_order values (5713,34755,3629,'CD','72661483',1894.00,'SIPO');
insert into tab_order values (5713,34756,3629,'QR','11967546',368.00,NULL);
insert into tab_order values (5713,34757,3629,'UV','21008116',8742.00,'POJISTNE');
insert into tab_order values (5718,34773,3637,'YZ','98685901',4877.00,'SIPO');
insert into tab_order values (5718,34774,3637,'ST','57452273',219.00,NULL);
insert into tab_order values (5718,34775,3637,'MN','80355101',1169.00,'UVER');
insert into tab_order values (5719,34810,3664,'GH','3468728',5658.00,'UVER');
insert into tab_order values (5723,34825,3674,'EF','94948046',1968.70,'UVER');
insert into tab_order values (5723,34826,3674,'EF','25279706',9503.00,'SIPO');
insert into tab_order values (5724,34831,3678,'CD','68775540',5269.00,'UVER');
insert into tab_order values (5725,34832,3679,'CD','36547637',3869.00,'SIPO');
insert into tab_order values (5725,34833,3679,'OP','62108045',5148.00,NULL);
insert into tab_order values (5725,34834,3679,'KL','30865085',9268.00,'UVER');
insert into tab_order values (5731,34870,3711,'CD','24353820',7683.20,'UVER');
insert into tab_order values (5739,34920,3747,'IJ','82686203',2389.00,'SIPO');
insert into tab_order values (5739,34921,3747,'IJ','93115895',1827.00,NULL);
insert into tab_order values (5739,34922,3747,'UV','1665688',1500.00,'POJISTNE');
insert into tab_order values (5739,34923,3747,'MN','80613380',6365.00,'UVER');
insert into tab_order values (5740,34930,3752,'IJ','56390714',3218.00,'SIPO');
insert into tab_order values (5740,34931,3752,'YZ','34449517',1547.00,'UVER');
insert into tab_order values (5741,34933,3754,'GH','72773557',2856.00,'UVER');
insert into tab_order values (5741,34934,3754,'YZ','10911417',3976.00,'SIPO');
insert into tab_order values (5741,34935,3754,'OP','52597421',1184.00,NULL);
insert into tab_order values (5741,34936,3754,'MN','55045568',913.00,'POJISTNE');
insert into tab_order values (5741,34937,3754,'UV','27539909',900.00,NULL);
insert into tab_order values (5750,35010,3804,'KL','84903490',5270.70,'UVER');
insert into tab_order values (5750,35011,3804,'WX','32746297',643.00,'SIPO');
insert into tab_order values (5750,35012,3804,'CD','46665102',4458.00,NULL);
insert into tab_order values (5754,35049,3834,'KL','49577087',3114.00,'SIPO');
insert into tab_order values (5754,35050,3834,'YZ','63132923',375.00,NULL);
insert into tab_order values (5754,35051,3834,'MN','51878350',3189.00,'POJISTNE');
insert into tab_order values (5754,35052,3834,'YZ','52872371',262.00,NULL);
insert into tab_order values (5754,35053,3834,'WX','34075695',1921.00,'UVER');
insert into tab_order values (5758,35087,3859,'WX','17110729',5120.20,'UVER');
insert into tab_order values (5760,35091,3862,'MN','12050682',2080.80,'UVER');
insert into tab_order values (5760,35092,3862,'UV','37094020',3508.00,'SIPO');
insert into tab_order values (5760,35093,3862,'YZ','17165685',7824.00,NULL);
insert into tab_order values (5765,35116,3875,'IJ','93942355',6413.70,'UVER');
insert into tab_order values (5772,35159,3906,'EF','96055197',5577.30,'UVER');
insert into tab_order values (5773,35160,3907,'CD','56403291',5577.30,'UVER');
insert into tab_order values (5774,35173,3916,'EF','91283201',2693.70,'UVER');
insert into tab_order values (5774,35174,3916,'UV','38921874',10900.00,'SIPO');
insert into tab_order values (5774,35175,3916,'UV','51592075',1078.00,NULL);
insert into tab_order values (5774,35176,3916,'AB','23392904',2570.00,'POJISTNE');
insert into tab_order values (5779,35213,3942,'YZ','11209202',2982.50,'UVER');
insert into tab_order values (5779,35214,3942,'ST','34098577',13428.00,'SIPO');
insert into tab_order values (5782,35231,3953,'AB','85838764',5297.70,'UVER');
insert into tab_order values (5784,35245,3967,'AB','28307140',2349.50,'UVER');
insert into tab_order values (5790,35334,4033,'MN','70536905',1494.00,'SIPO');
insert into tab_order values (5790,35335,4033,'OP','86237394',2808.00,NULL);
insert into tab_order values (5790,35336,4033,'OP','46252030',1756.00,'UVER');
insert into tab_order values (5799,35364,4052,'IJ','25790983',2948.00,'UVER');
insert into tab_order values (5804,35402,4079,'WX','16481298',3312.00,'UVER');
insert into tab_order values (5804,35403,4079,'AB','19063937',5009.00,'SIPO');
insert into tab_order values (5804,35404,4079,'QR','7362539',218.00,NULL);
insert into tab_order values (5804,35405,4079,'ST','81205659',321.00,'POJISTNE');
insert into tab_order values (5805,35409,4081,'YZ','22211885',5746.00,'UVER');
insert into tab_order values (5808,35433,4099,'AB','31954735',1926.00,'SIPO');
insert into tab_order values (5808,35434,4099,'IJ','40898221',403.00,NULL);
insert into tab_order values (5808,35435,4099,'QR','6660080',1298.00,'POJISTNE');
insert into tab_order values (5808,35436,4099,'GH','75250422',872.00,'UVER');
insert into tab_order values (5815,35462,4116,'MN','92376952',4200.20,'UVER');
insert into tab_order values (5815,35463,4116,'IJ','69320016',14448.00,'SIPO');
insert into tab_order values (5817,35472,4127,'CD','6366193',4200.20,'UVER');
insert into tab_order values (5817,35473,4127,'QR','34589725',11105.00,'SIPO');
insert into tab_order values (5817,35474,4127,'GH','77216887',221.00,NULL);
insert into tab_order values (5817,35475,4127,'QR','28738975',69.00,'POJISTNE');
insert into tab_order values (5823,35494,4144,'QR','13202494',5915.70,'UVER');
insert into tab_order values (5823,35495,4144,'WX','44854801',8753.00,'SIPO');
insert into tab_order values (5830,35565,4190,'QR','51522499',2901.00,'SIPO');
insert into tab_order values (5830,35566,4190,'MN','24471074',1100.00,NULL);
insert into tab_order values (5830,35567,4190,'IJ','72617375',1242.00,'POJISTNE');
insert into tab_order values (5830,35568,4190,'QR','57476657',6763.00,'UVER');
insert into tab_order values (5836,35668,4259,'ST','4058731',3318.00,'UVER');
insert into tab_order values (5836,35669,4259,'CD','73520475',9516.00,'SIPO');
insert into tab_order values (5836,35670,4259,'AB','40486842',2255.00,NULL);
insert into tab_order values (5837,35671,4260,'EF','42941677',4075.50,'UVER');
insert into tab_order values (5837,35672,4260,'OP','18079054',12006.00,'SIPO');
insert into tab_order values (5841,35683,4268,'IJ','24499589',6646.00,'SIPO');
insert into tab_order values (5841,35684,4268,'AB','28338015',3499.00,'UVER');
insert into tab_order values (5850,35718,4293,'GH','89613037',4561.00,'UVER');
insert into tab_order values (5850,35719,4293,'IJ','75312357',4797.00,'SIPO');
insert into tab_order values (5856,35752,4320,'GH','15082747',4280.00,'UVER');
insert into tab_order values (5861,35774,4337,'IJ','15837014',2142.00,'UVER');
insert into tab_order values (5862,35781,4342,'AB','4569364',4172.00,'UVER');
insert into tab_order values (5862,35782,4342,'KL','52346587',6135.00,'SIPO');
insert into tab_order values (5865,35794,4354,'MN','33371013',5461.30,'UVER');
insert into tab_order values (5865,35795,4354,'CD','23047155',12756.00,'SIPO');
insert into tab_order values (5868,35802,4361,'AB','55740487',7512.70,'UVER');
insert into tab_order values (5876,35874,4413,'QR','63660216',4610.00,'UVER');
insert into tab_order values (5876,35875,4413,'UV','8759522',7802.00,'SIPO');
insert into tab_order values (5877,35876,4414,'ST','75805902',3716.00,'SIPO');
insert into tab_order values (5877,35877,4414,'ST','35362416',3509.00,NULL);
insert into tab_order values (5877,35878,4414,'EF','88424551',4051.00,'UVER');
insert into tab_order values (5878,35879,4415,'AB','8593738',4601.00,'SIPO');
insert into tab_order values (5878,35880,4415,'MN','61133015',3408.00,NULL);
insert into tab_order values (5878,35881,4415,'QR','19646489',77.00,'POJISTNE');
insert into tab_order values (5878,35882,4415,'OP','67352598',397.00,NULL);
insert into tab_order values (5878,35883,4415,'EF','42558240',6170.00,'UVER');
insert into tab_order values (5880,35899,4423,'GH','47825217',2051.00,'UVER');
insert into tab_order values (5880,35900,4423,'CD','4275078',1277.00,'SIPO');
insert into tab_order values (5880,35901,4423,'QR','21013897',4015.00,NULL);
insert into tab_order values (5882,35905,4427,'KL','17050731',5005.00,'SIPO');
insert into tab_order values (5882,35906,4427,'CD','55410188',7318.00,'UVER');
insert into tab_order values (5886,35931,4447,'WX','55297768',5353.50,'UVER');
insert into tab_order values (5887,35932,4448,'WX','57328462',5353.50,'UVER');
insert into tab_order values (5889,35941,4456,'IJ','41103047',5353.50,'UVER');
insert into tab_order values (5892,35951,4462,'AB','98249196',2770.30,'UVER');
insert into tab_order values (5893,35956,4467,'UV','25870239',2394.50,'UVER');
insert into tab_order values (5893,35957,4467,'QR','66281664',4556.00,'SIPO');
insert into tab_order values (5895,35967,4473,'EF','96544521',5528.00,'SIPO');
insert into tab_order values (5895,35968,4473,'KL','69761729',3525.00,NULL);
insert into tab_order values (5895,35969,4473,'KL','75815641',1566.00,'UVER');
insert into tab_order values (5897,35972,4476,'YZ','51957607',3195.00,'SIPO');
insert into tab_order values (5897,35973,4476,'EF','27366185',912.00,NULL);
insert into tab_order values (5897,35974,4476,'GH','96384197',3103.00,'POJISTNE');
insert into tab_order values (5897,35975,4476,'UV','18494886',633.00,'UVER');
insert into tab_order values (5900,36008,4503,'YZ','21099597',2819.80,'UVER');
insert into tab_order values (5906,36048,4533,'CD','10384428',2253.50,'UVER');
insert into tab_order values (5906,36049,4533,'OP','65046036',10479.00,'SIPO');
insert into tab_order values (5909,36066,4550,'IJ','71980470',1113.00,'SIPO');
insert into tab_order values (5909,36067,4550,'EF','95971029',1607.00,NULL);
insert into tab_order values (5909,36068,4550,'ST','19181561',424.00,'POJISTNE');
insert into tab_order values (5909,36069,4550,'WX','30900681',1022.00,'UVER');
insert into tab_order values (5918,36110,4576,'UV','20694566',8339.00,'UVER');
insert into tab_order values (5922,36115,4580,'ST','99807279',1684.80,'UVER');
insert into tab_order values (5922,36116,4580,'AB','90886467',8723.00,'SIPO');
insert into tab_order values (5923,36124,4585,'YZ','64408206',4065.00,'SIPO');
insert into tab_order values (5923,36125,4585,'GH','3908431',1347.00,'UVER');
insert into tab_order values (5930,36166,4616,'GH','74167519',2778.70,'UVER');
insert into tab_order values (5930,36167,4616,'WX','88828020',12260.00,'SIPO');
insert into tab_order values (5931,36170,4618,'WX','54633820',2778.70,'UVER');
insert into tab_order values (5932,36181,4626,'IJ','69861972',2778.70,'UVER');
insert into tab_order values (5933,36189,4631,'KL','39618468',3647.00,'UVER');
insert into tab_order values (5938,36217,4650,'YZ','59294611',554.00,'SIPO');
insert into tab_order values (5938,36218,4650,'KL','6576216',2828.00,NULL);
insert into tab_order values (5938,36219,4650,'ST','50796478',6700.00,'UVER');
insert into tab_order values (5940,36230,4660,'QR','35342312',4456.00,'UVER');
insert into tab_order values (5940,36231,4660,'QR','85892647',2121.00,'SIPO');
insert into tab_order values (5940,36232,4660,'UV','85081994',475.00,NULL);
insert into tab_order values (5940,36233,4660,'MN','76798975',437.00,'POJISTNE');
insert into tab_order values (5942,36263,4681,'ST','8383214',3388.00,'UVER');
insert into tab_order values (5942,36264,4681,'CD','50554043',5016.00,'SIPO');
insert into tab_order values (5942,36265,4681,'OP','30791741',4515.00,NULL);
insert into tab_order values (5953,36325,4715,'AB','94525420',4049.00,'UVER');
insert into tab_order values (5956,36341,4725,'KL','46966421',4674.20,'UVER');
insert into tab_order values (5956,36342,4725,'KL','77940284',13462.00,'SIPO');
insert into tab_order values (5959,36345,4727,'YZ','36371326',4485.00,'UVER');
insert into tab_order values (5959,36346,4727,'QR','30821961',3580.00,'SIPO');
insert into tab_order values (5959,36347,4727,'UV','87424748',1861.00,NULL);
insert into tab_order values (5963,36371,4746,'UV','51417624',3413.00,'UVER');
insert into tab_order values (5970,36413,4774,'EF','85673802',9689.00,'UVER');
insert into tab_order values (5973,36424,4784,'CD','68459832',4572.00,'UVER');
insert into tab_order values (5976,36443,4794,'MN','92189216',1922.00,'SIPO');
insert into tab_order values (5976,36444,4794,'EF','60735916',603.00,NULL);
insert into tab_order values (5976,36445,4794,'UV','85381936',3142.00,'POJISTNE');
insert into tab_order values (5976,36446,4794,'CD','91262608',1660.00,NULL);
insert into tab_order values (5976,36447,4794,'KL','80407201',9698.00,'UVER');
insert into tab_order values (5977,36454,4803,'UV','17711252',1232.00,'UVER');
insert into tab_order values (5980,36489,4825,'OP','74436640',1783.20,'UVER');
insert into tab_order values (5988,36529,4851,'MN','12253350',5902.20,'UVER');
insert into tab_order values (5988,36530,4851,'YZ','40565508',4285.00,'SIPO');
insert into tab_order values (5989,36531,4852,'QR','23212576',4794.00,'SIPO');
insert into tab_order values (5989,36532,4852,'YZ','98242383',5925.00,'UVER');
insert into tab_order values (5991,36539,4858,'AB','67520165',6983.30,'UVER');
insert into tab_order values (5992,36547,4863,'MN','69927233',6340.30,'UVER');
insert into tab_order values (5992,36548,4863,'OP','70381557',3300.00,'SIPO');
insert into tab_order values (5992,36549,4863,'QR','66434705',6036.00,NULL);
insert into tab_order values (5997,36599,4894,'ST','81512897',4875.80,'UVER');
insert into tab_order values (5999,36618,4907,'YZ','25638538',3938.00,'SIPO');
insert into tab_order values (5999,36619,4907,'AB','5604631',1253.00,NULL);
insert into tab_order values (5999,36620,4907,'QR','82890259',325.00,'POJISTNE');
insert into tab_order values (5999,36621,4907,'IJ','5619949',2059.00,'UVER');
insert into tab_order values (6004,36665,4937,'ST','47568672',5996.20,'UVER');
insert into tab_order values (6004,36666,4937,'OP','13841212',2687.00,'SIPO');
insert into tab_order values (6004,36667,4937,'OP','43502605',800.00,NULL);
insert into tab_order values (6006,36679,4948,'KL','70243751',5996.20,'UVER');
insert into tab_order values (6006,36680,4948,'WX','39958155',4710.00,'SIPO');
insert into tab_order values (6007,36681,4949,'WX','44724160',6039.80,'UVER');
insert into tab_order values (6010,36709,4969,'ST','80888122',2502.80,'UVER');
insert into tab_order values (6010,36710,4969,'UV','87679707',8309.00,'SIPO');
insert into tab_order values (6010,36711,4969,'AB','94635641',610.00,NULL);
insert into tab_order values (6011,36729,4981,'YZ','61511546',4930.00,'SIPO');
insert into tab_order values (6011,36730,4981,'GH','9506047',3736.00,'UVER');
insert into tab_order values (6012,36748,4994,'MN','80840283',7178.80,'UVER');
insert into tab_order values (6013,36749,4995,'QR','68653625',3583.00,'UVER');
insert into tab_order values (6014,36754,4999,'GH','95365690',4588.50,'UVER');
insert into tab_order values (6014,36755,4999,'WX','20009368',7028.00,'SIPO');
insert into tab_order values (6014,36756,4999,'MN','71272724',6327.00,NULL);
insert into tab_order values (6015,36758,5001,'OP','7923072',4588.50,'UVER');
insert into tab_order values (6015,36759,5001,'OP','11451143',9292.00,'SIPO');
insert into tab_order values (6019,36799,5033,'CD','73070150',1820.00,'SIPO');
insert into tab_order values (6019,36800,5033,'QR','93854265',754.00,NULL);
insert into tab_order values (6019,36801,5033,'EF','12796581',2196.00,'POJISTNE');
insert into tab_order values (6019,36802,5033,'EF','25932383',950.00,'UVER');
insert into tab_order values (6027,36852,5066,'CD','56157791',2568.80,'UVER');
insert into tab_order values (6027,36853,5066,'OP','2258235',4206.00,'SIPO');
insert into tab_order values (6027,36854,5066,'EF','39506387',1018.00,NULL);
insert into tab_order values (6027,36855,5066,'YZ','10269540',132.00,'POJISTNE');
insert into tab_order values (6027,36856,5066,'KL','45041960',1283.00,NULL);
insert into tab_order values (6028,36866,5072,'CD','10877579',1863.00,'SIPO');
insert into tab_order values (6028,36867,5072,'EF','85992329',5869.00,NULL);
insert into tab_order values (6028,36868,5072,'OP','62572306',1065.00,'POJISTNE');
insert into tab_order values (6028,36869,5072,'OP','5224442',805.00,NULL);
insert into tab_order values (6028,36870,5072,'IJ','38607579',5292.00,'UVER');
insert into tab_order values (6037,36928,5118,'GH','99441033',3095.00,'SIPO');
insert into tab_order values (6037,36929,5118,'CD','97549569',446.00,NULL);
insert into tab_order values (6037,36930,5118,'CD','59396386',1109.00,'UVER');
insert into tab_order values (6038,36934,5120,'MN','4935771',6738.70,'UVER');
insert into tab_order values (6038,36935,5120,'YZ','26903707',3008.00,'SIPO');
insert into tab_order values (6043,36946,5126,'YZ','63854801',4208.00,'SIPO');
insert into tab_order values (6043,36947,5126,'GH','96935939',424.00,'UVER');
insert into tab_order values (6044,36956,5133,'MN','16182625',4755.00,'UVER');
insert into tab_order values (6044,36957,5133,'AB','50449115',286.00,'SIPO');
insert into tab_order values (6044,36958,5133,'IJ','35177278',412.00,NULL);
insert into tab_order values (6044,36959,5133,'QR','97651743',3913.00,'POJISTNE');
insert into tab_order values (6052,37012,5164,'EF','54096066',4261.00,'SIPO');
insert into tab_order values (6052,37013,5164,'UV','10503888',621.00,'UVER');
insert into tab_order values (6054,37032,5180,'WX','41377508',4897.00,'UVER');
insert into tab_order values (6055,37033,5181,'WX','47686052',6652.50,'UVER');
insert into tab_order values (6059,37059,5196,'YZ','95793395',6652.50,'UVER');
insert into tab_order values (6059,37060,5196,'CD','22101694',7905.00,'SIPO');
insert into tab_order values (6063,37085,5213,'OP','46268802',6687.00,'UVER');
insert into tab_order values (6064,37087,5215,'KL','58698618',2.00,'SIPO');
insert into tab_order values (6064,37088,5215,'QR','81640040',5315.00,NULL);
insert into tab_order values (6064,37089,5215,'KL','3664792',372.00,'POJISTNE');
insert into tab_order values (6064,37090,5215,'QR','71636765',870.00,NULL);
insert into tab_order values (6064,37091,5215,'KL','79302054',1219.00,'UVER');
insert into tab_order values (6066,37108,5228,'OP','7177615',7242.00,'UVER');
insert into tab_order values (6072,37154,5256,'KL','11066365',5388.50,'UVER');
insert into tab_order values (6073,37167,5263,'GH','63990634',3950.00,'SIPO');
insert into tab_order values (6073,37168,5263,'MN','57356619',4605.00,'UVER');
insert into tab_order values (6075,37173,5267,'MN','56727522',5388.50,'UVER');
insert into tab_order values (6076,37177,5269,'UV','7043707',793.00,'SIPO');
insert into tab_order values (6076,37178,5269,'OP','84263461',7260.00,NULL);
insert into tab_order values (6076,37179,5269,'OP','61308646',1957.00,'UVER');
insert into tab_order values (6077,37180,5270,'CD','13973260',3317.00,'UVER');
insert into tab_order values (6078,37196,5283,'KL','94041960',3559.00,'UVER');
insert into tab_order values (6078,37197,5283,'YZ','67168420',9649.00,'SIPO');
insert into tab_order values (6083,37238,5305,'MN','81407129',5011.20,'UVER');
insert into tab_order values (6087,37251,5313,'QR','80564933',5011.20,'UVER');
insert into tab_order values (6087,37252,5313,'MN','60921382',5791.00,'SIPO');
insert into tab_order values (6087,37253,5313,'UV','15263599',1167.00,NULL);
insert into tab_order values (6087,37254,5313,'AB','62256020',958.00,'POJISTNE');
insert into tab_order values (6088,37257,5317,'AB','69538569',2504.80,'UVER');
insert into tab_order values (6088,37258,5317,'KL','53978085',4331.00,'SIPO');
insert into tab_order values (6095,37317,5358,'ST','89332604',9191.00,'SIPO');
insert into tab_order values (6095,37318,5358,'MN','3237545',1139.00,'UVER');
insert into tab_order values (6097,37323,5362,'OP','24749118',4226.30,'UVER');
insert into tab_order values (6097,37324,5362,'UV','18269801',6413.00,'SIPO');
insert into tab_order values (6097,37325,5362,'IJ','23946857',7962.00,NULL);
insert into tab_order values (6103,37361,5385,'KL','92821448',2489.30,'UVER');
insert into tab_order values (6103,37362,5385,'YZ','67199128',8754.00,'SIPO');
insert into tab_order values (6104,37378,5395,'WX','43853229',4393.80,'UVER');
insert into tab_order values (6109,37421,5422,'YZ','91485505',6148.00,'UVER');
insert into tab_order values (6109,37422,5422,'AB','38885069',832.00,'SIPO');
insert into tab_order values (6109,37423,5422,'WX','95722668',2320.00,NULL);
insert into tab_order values (6109,37424,5422,'EF','40573519',1435.00,'POJISTNE');
insert into tab_order values (6111,37435,5428,'MN','55829697',7281.30,'UVER');
insert into tab_order values (6112,37456,5442,'CD','26435643',7281.30,'UVER');
insert into tab_order values (6112,37457,5442,'EF','14627766',8110.00,'SIPO');
insert into tab_order values (6112,37458,5442,'MN','10828179',2070.00,NULL);
insert into tab_order values (6112,37459,5442,'IJ','7772154',1017.00,'POJISTNE');
insert into tab_order values (6113,37462,5445,'QR','10110479',2186.00,'UVER');
insert into tab_order values (6113,37463,5445,'UV','2227068',685.00,'SIPO');
insert into tab_order values (6113,37464,5445,'IJ','80277055',1439.00,NULL);
insert into tab_order values (6113,37465,5445,'OP','4871046',624.00,'POJISTNE');
insert into tab_order values (6113,37466,5445,'KL','26684844',859.00,NULL);
insert into tab_order values (6118,37516,5477,'UV','48098021',7279.30,'UVER');
insert into tab_order values (6118,37517,5477,'UV','40210610',6342.00,'SIPO');
insert into tab_order values (6120,37520,5481,'IJ','17114121',4358.00,'UVER');
insert into tab_order values (6130,37616,5541,'UV','59490781',3114.00,'SIPO');
insert into tab_order values (6130,37617,5541,'QR','48447573',648.00,NULL);
insert into tab_order values (6130,37618,5541,'WX','66726541',680.00,'UVER');
insert into tab_order values (6136,37665,5572,'IJ','85013025',2348.00,'UVER');
insert into tab_order values (6136,37666,5572,'KL','53127735',11314.00,'SIPO');
insert into tab_order values (6137,37668,5574,'CD','52011740',3719.00,'UVER');
insert into tab_order values (6137,37669,5574,'QR','36525643',11878.00,'SIPO');
insert into tab_order values (6142,37699,5591,'ST','19205475',3697.80,'UVER');
insert into tab_order values (6142,37700,5591,'GH','38603085',323.00,'SIPO');
insert into tab_order values (6142,37701,5591,'UV','44512021',2872.00,NULL);
insert into tab_order values (6142,37702,5591,'OP','87980109',345.00,'POJISTNE');
insert into tab_order values (6142,37703,5591,'YZ','30955463',2.00,NULL);
insert into tab_order values (6144,37706,5593,'GH','67515390',3697.80,'UVER');
insert into tab_order values (6144,37707,5593,'EF','48020237',6049.00,'SIPO');
insert into tab_order values (6147,37716,5602,'EF','42234236',3697.80,'UVER');
insert into tab_order values (6150,37740,5622,'UV','45906978',6918.30,'UVER');
insert into tab_order values (6150,37741,5622,'ST','24175644',6327.00,'SIPO');
insert into tab_order values (6150,37742,5622,'EF','71167778',573.00,NULL);
insert into tab_order values (6151,37748,5628,'QR','30017256',3757.00,'UVER');
insert into tab_order values (6153,37755,5632,'ST','84198254',4760.00,'UVER');
insert into tab_order values (6157,37782,5650,'EF','10689866',4108.30,'UVER');
insert into tab_order values (6157,37783,5650,'GH','29767215',10530.00,'SIPO');
insert into tab_order values (6168,37847,5698,'OP','81442999',2756.00,'UVER');
insert into tab_order values (6168,37848,5698,'QR','64414620',10120.00,'SIPO');
insert into tab_order values (6169,37850,5700,'UV','47866308',1728.00,'UVER');
insert into tab_order values (6173,37888,5724,'WX','9607071',4845.00,'UVER');
insert into tab_order values (6173,37889,5724,'IJ','5197179',2692.00,'SIPO');
insert into tab_order values (6173,37890,5724,'MN','30744582',561.00,NULL);
insert into tab_order values (6173,37891,5724,'YZ','83046674',281.00,'POJISTNE');
insert into tab_order values (6173,37892,5724,'WX','21557212',1220.00,NULL);
insert into tab_order values (6175,37906,5735,'MN','1054633',4845.00,'UVER');
insert into tab_order values (6178,37915,5742,'GH','19201743',4845.00,'UVER');
insert into tab_order values (6185,37964,5774,'UV','69220012',1413.00,'SIPO');
insert into tab_order values (6185,37965,5774,'OP','39872121',7143.00,NULL);
insert into tab_order values (6185,37966,5774,'ST','4440504',1299.00,'UVER');
insert into tab_order values (6190,37995,5794,'CD','1848161',2060.00,'UVER');
insert into tab_order values (6196,38053,5837,'KL','80529534',4939.00,'UVER');
insert into tab_order values (6202,38118,5891,'EF','95617645',5432.30,'UVER');
insert into tab_order values (6207,38151,5912,'CD','6367522',3076.80,'UVER');
insert into tab_order values (6207,38152,5912,'OP','65154915',9846.00,'SIPO');
insert into tab_order values (6210,38166,5927,'OP','95520770',1817.30,'UVER');
insert into tab_order values (6215,38190,5944,'AB','49417829',4685.00,'SIPO');
insert into tab_order values (6215,38191,5944,'AB','50435006',1640.00,'UVER');
insert into tab_order values (6216,38198,5952,'EF','22068012',5885.30,'UVER');
insert into tab_order values (6216,38199,5952,'GH','68812089',3028.00,'SIPO');
insert into tab_order values (6216,38200,5952,'MN','40625691',1374.00,NULL);
insert into tab_order values (6216,38201,5952,'YZ','2707452',3684.00,'POJISTNE');
insert into tab_order values (6216,38202,5952,'WX','37493223',1594.00,NULL);
insert into tab_order values (6223,38263,5991,'UV','6799704',1978.00,'SIPO');
insert into tab_order values (6223,38264,5991,'KL','83801996',4235.00,NULL);
insert into tab_order values (6223,38265,5991,'MN','49866914',1272.00,'UVER');
insert into tab_order values (6227,38326,6030,'WX','18410075',1177.00,'UVER');
insert into tab_order values (6228,38328,6034,'MN','6834680',7741.80,'UVER');
insert into tab_order values (6229,38338,6040,'UV','45750951',2635.00,'SIPO');
insert into tab_order values (6229,38339,6040,'EF','96697401',1321.00,NULL);
insert into tab_order values (6229,38340,6040,'GH','15017515',5015.00,'POJISTNE');
insert into tab_order values (6229,38341,6040,'QR','12242263',489.00,'UVER');
insert into tab_order values (6232,38359,6051,'AB','22275466',7685.00,'UVER');
insert into tab_order values (6234,38373,6061,'YZ','38191717',8521.00,'SIPO');
insert into tab_order values (6234,38374,6061,'KL','92930179',429.00,'UVER');
insert into tab_order values (6235,38375,6062,'OP','96754401',5356.00,'UVER');
insert into tab_order values (6235,38376,6062,'KL','65052980',10608.00,'SIPO');
insert into tab_order values (6237,38395,6075,'ST','38067519',8499.00,'UVER');
insert into tab_order values (6239,38408,6083,'MN','44330716',7518.00,'UVER');
insert into tab_order values (6242,38431,6097,'WX','87940978',3155.00,'SIPO');
insert into tab_order values (6242,38432,6097,'KL','34494578',728.00,'UVER');
insert into tab_order values (6244,38462,6118,'UV','16368747',7518.00,'UVER');
insert into tab_order values (6249,38500,6138,'EF','68264150',2817.30,'UVER');
insert into tab_order values (6249,38501,6138,'WX','42320823',10869.00,'SIPO');
insert into tab_order values (6253,38519,6148,'YZ','26888096',7847.00,'SIPO');
insert into tab_order values (6253,38520,6148,'QR','40286940',2490.00,'UVER');
insert into tab_order values (6254,38539,6157,'GH','85308313',5165.20,'UVER');
insert into tab_order values (6254,38540,6157,'MN','97978877',9523.00,'SIPO');
insert into tab_order values (6255,38541,6158,'ST','22791475',5165.20,'UVER');
insert into tab_order values (6272,38649,6226,'KL','83721154',6643.70,'UVER');
insert into tab_order values (6278,38694,6265,'WX','43599933',3639.50,'UVER');
insert into tab_order values (6278,38695,6265,'EF','11553663',7274.00,'SIPO');
insert into tab_order values (6279,38708,6273,'QR','34498596',3639.50,'UVER');
insert into tab_order values (6283,38729,6289,'GH','34028458',1784.50,'UVER');
insert into tab_order values (6294,38820,6353,'EF','55760598',586.00,'SIPO');
insert into tab_order values (6294,38821,6353,'OP','1903015',5984.00,NULL);
insert into tab_order values (6294,38822,6353,'CD','62611573',1332.00,'UVER');
insert into tab_order values (6296,38829,6358,'GH','31235045',5632.80,'UVER');
insert into tab_order values (6296,38830,6358,'EF','69701927',13076.00,'SIPO');
insert into tab_order values (6297,38837,6363,'UV','2478039',1459.00,'UVER');
insert into tab_order values (6302,38885,6397,'GH','75494760',3016.70,'UVER');
insert into tab_order values (6303,38888,6400,'OP','68610131',3016.70,'UVER');
insert into tab_order values (6303,38889,6400,'OP','10098511',7320.00,'SIPO');
insert into tab_order values (6303,38890,6400,'QR','30437541',143.00,NULL);
insert into tab_order values (6303,38891,6400,'EF','79846286',7396.00,'POJISTNE');
insert into tab_order values (6306,38921,6425,'KL','41016417',3057.00,'UVER');
insert into tab_order values (6309,38930,6434,'GH','56125944',4589.20,'UVER');
insert into tab_order values (6309,38931,6434,'EF','10144585',4891.00,'SIPO');
insert into tab_order values (6310,38936,6440,'UV','75896376',2881.00,'UVER');
insert into tab_order values (6312,38955,6453,'MN','92548077',1514.00,'SIPO');
insert into tab_order values (6312,38956,6453,'KL','17806643',695.00,NULL);
insert into tab_order values (6312,38957,6453,'EF','98467659',541.00,'POJISTNE');
insert into tab_order values (6312,38958,6453,'KL','10349285',304.00,'UVER');
insert into tab_order values (6313,38965,6461,'MN','30961704',4192.50,'UVER');
insert into tab_order values (6315,38982,6472,'QR','3375345',3597.00,'UVER');
insert into tab_order values (6316,38983,6473,'KL','93282901',6408.80,'UVER');
insert into tab_order values (6320,39014,6495,'OP','70482468',8606.00,'SIPO');
insert into tab_order values (6320,39015,6495,'EF','70085698',8747.00,'UVER');
insert into tab_order values (6321,39027,6505,'WX','49671936',3207.80,'UVER');
insert into tab_order values (6322,39032,6510,'EF','50882208',3207.80,'UVER');
insert into tab_order values (6336,39102,6555,'UV','80658405',5900.00,'UVER');
insert into tab_order values (6338,39151,6592,'QR','62818646',6510.70,'UVER');
insert into tab_order values (6338,39152,6592,'QR','16516280',10755.00,'SIPO');
insert into tab_order values (6342,39177,6609,'ST','70020216',1671.00,'UVER');
insert into tab_order values (6342,39178,6609,'UV','11188424',3881.00,'SIPO');
insert into tab_order values (6342,39179,6609,'GH','27650201',1624.00,NULL);
insert into tab_order values (6346,39241,6649,'CD','71315157',1671.00,'UVER');
insert into tab_order values (6350,39284,6678,'AB','46673387',6133.00,'UVER');
insert into tab_order values (6353,39303,6686,'ST','36217254',4853.80,'UVER');
insert into tab_order values (6354,39305,6688,'AB','1844835',1753.00,'SIPO');
insert into tab_order values (6354,39306,6688,'OP','24286341',1282.00,NULL);
insert into tab_order values (6354,39307,6688,'AB','44432550',570.00,'POJISTNE');
insert into tab_order values (6354,39308,6688,'EF','9123272',638.00,'UVER');
insert into tab_order values (6355,39324,6699,'AB','40932357',2650.20,'UVER');
insert into tab_order values (6355,39325,6699,'UV','79769712',7303.00,'SIPO');
insert into tab_order values (6355,39326,6699,'EF','81050043',5504.00,NULL);
insert into tab_order values (6356,39328,6701,'CD','54543888',2650.20,'UVER');
insert into tab_order values (6357,39337,6706,'ST','63843142',1982.00,'SIPO');
insert into tab_order values (6357,39338,6706,'IJ','19147312',671.00,NULL);
insert into tab_order values (6357,39339,6706,'CD','23725885',815.00,'POJISTNE');
insert into tab_order values (6357,39340,6706,'WX','83129149',1081.00,'UVER');
insert into tab_order values (6358,39352,6715,'GH','85509657',2298.20,'UVER');
insert into tab_order values (6362,39380,6738,'ST','11352903',3159.00,'UVER');
insert into tab_order values (6377,39463,6792,'GH','65384101',3520.00,'SIPO');
insert into tab_order values (6377,39464,6792,'AB','20771622',49.00,NULL);
insert into tab_order values (6377,39465,6792,'YZ','5785042',423.00,'POJISTNE');
insert into tab_order values (6377,39466,6792,'YZ','76593392',1432.00,'UVER');
insert into tab_order values (6386,39555,6856,'CD','38296979',3454.00,'UVER');
insert into tab_order values (6386,39556,6856,'CD','71201121',2557.00,'SIPO');
insert into tab_order values (6386,39557,6856,'YZ','61659604',794.00,NULL);
insert into tab_order values (6386,39558,6856,'WX','70674234',6965.00,'POJISTNE');
insert into tab_order values (6399,39617,6902,'OP','39091980',3738.00,'SIPO');
insert into tab_order values (6399,39618,6902,'YZ','4458135',827.00,NULL);
insert into tab_order values (6399,39619,6902,'ST','86353617',1370.00,'UVER');
insert into tab_order values (6402,39646,6922,'UV','54632151',5811.70,'UVER');
insert into tab_order values (6403,39648,6924,'UV','50566107',4059.50,'UVER');
insert into tab_order values (6403,39649,6924,'CD','76091629',4585.00,'SIPO');
insert into tab_order values (6407,39661,6930,'WX','22201913',1081.00,'UVER');
insert into tab_order values (6415,39689,6950,'ST','88771885',8561.00,'SIPO');
insert into tab_order values (6415,39690,6950,'IJ','13666057',9910.00,'UVER');
insert into tab_order values (6421,39741,6985,'ST','77922910',2687.50,'UVER');
insert into tab_order values (6421,39742,6985,'ST','73746818',13167.00,'SIPO');
insert into tab_order values (6435,39830,7045,'MN','36153978',6015.30,'UVER');
insert into tab_order values (6436,39835,7049,'GH','52499610',8253.20,'UVER');
insert into tab_order values (6437,39841,7052,'AB','10413468',1776.70,'UVER');
insert into tab_order values (6442,39890,7082,'CD','91626292',6359.00,'SIPO');
insert into tab_order values (6442,39891,7082,'AB','93874412',1204.00,NULL);
insert into tab_order values (6442,39892,7082,'CD','47163563',15.00,'POJISTNE');
insert into tab_order values (6442,39893,7082,'AB','18123281',262.00,NULL);
insert into tab_order values (6442,39894,7082,'YZ','25515216',4045.00,'UVER');
insert into tab_order values (6450,39924,7099,'AB','75017177',4882.50,'UVER');
insert into tab_order values (6450,39925,7099,'UV','96372824',236.00,'SIPO');
insert into tab_order values (6450,39926,7099,'QR','8235311',11766.00,NULL);
insert into tab_order values (6450,39927,7099,'AB','62618040',528.00,'POJISTNE');
insert into tab_order values (6456,39966,7123,'WX','42583918',3918.20,'UVER');
insert into tab_order values (6456,39967,7123,'KL','42013669',14581.00,'SIPO');
insert into tab_order values (6460,39986,7133,'CD','49628651',2683.00,'SIPO');
insert into tab_order values (6460,39987,7133,'YZ','28418004',44.00,NULL);
insert into tab_order values (6460,39988,7133,'IJ','89750158',115.00,'POJISTNE');
insert into tab_order values (6460,39989,7133,'ST','56658023',56.00,NULL);
insert into tab_order values (6460,39990,7133,'AB','27370810',1352.00,'UVER');
insert into tab_order values (6461,39994,7136,'ST','16474801',2059.00,'UVER');
insert into tab_order values (6461,39995,7136,'ST','35699868',1080.00,'SIPO');
insert into tab_order values (6461,39996,7136,'UV','45092648',2235.00,NULL);
insert into tab_order values (6461,39997,7136,'AB','13272279',547.00,'POJISTNE');
insert into tab_order values (6464,40034,7156,'MN','60879224',2062.00,'UVER');
insert into tab_order values (6468,40065,7176,'KL','12137484',6110.00,'SIPO');
insert into tab_order values (6468,40066,7176,'CD','11141997',3399.00,'UVER');
insert into tab_order values (6469,40071,7180,'YZ','5624032',4156.50,'UVER');
insert into tab_order values (6469,40072,7180,'ST','71244883',8089.00,'SIPO');
insert into tab_order values (6470,40073,7181,'KL','76611220',4156.50,'UVER');
insert into tab_order values (6470,40074,7181,'UV','66605192',5030.00,'SIPO');
insert into tab_order values (6470,40075,7181,'OP','86960434',421.00,NULL);
insert into tab_order values (6470,40076,7181,'IJ','99126499',16.00,'POJISTNE');
insert into tab_order values (6470,40077,7181,'OP','40795511',514.00,NULL);
insert into tab_order values (6471,40084,7184,'GH','64944064',3434.00,'SIPO');
insert into tab_order values (6471,40085,7184,'AB','5196965',1879.00,NULL);
insert into tab_order values (6471,40086,7184,'QR','43513906',691.00,'POJISTNE');
insert into tab_order values (6471,40087,7184,'EF','15510481',276.00,NULL);
insert into tab_order values (6471,40088,7184,'AB','95096921',6485.00,'UVER');
insert into tab_order values (6474,40099,7190,'WX','11074567',5394.00,'SIPO');
insert into tab_order values (6474,40100,7190,'MN','63233262',1056.00,'UVER');
insert into tab_order values (6486,40169,7240,'WX','51813179',2535.70,'UVER');
insert into tab_order values (6486,40170,7240,'QR','38210588',9136.00,'SIPO');
insert into tab_order values (6490,40207,7262,'EF','83855402',1900.00,'SIPO');
insert into tab_order values (6490,40208,7262,'UV','4781288',6875.00,NULL);
insert into tab_order values (6490,40209,7262,'UV','99959164',1221.00,'UVER');
insert into tab_order values (6495,40226,7274,'WX','91164630',4086.80,'UVER');
insert into tab_order values (6495,40227,7274,'WX','33532422',4603.00,'SIPO');
insert into tab_order values (6499,40328,7401,'ST','89597016',3372.70,'UVER');
insert into tab_order values (6499,40329,7401,'QR','13943797',7266.00,'SIPO');
insert into tab_order values (6501,40349,7418,'QR','14132368',2523.20,'UVER');
insert into tab_order values (6502,40357,7424,'YZ','1301700',2523.20,'UVER');
insert into tab_order values (6502,40358,7424,'IJ','4896235',6817.00,'SIPO');
insert into tab_order values (6502,40359,7424,'AB','79838293',1110.00,NULL);
insert into tab_order values (6502,40360,7424,'WX','52864879',164.00,'POJISTNE');
insert into tab_order values (6508,40381,7437,'QR','79067885',2306.80,'UVER');
insert into tab_order values (6508,40382,7437,'EF','2692229',6901.00,'SIPO');
insert into tab_order values (6508,40383,7437,'KL','83435654',231.00,NULL);
insert into tab_order values (6508,40384,7437,'OP','64685678',228.00,'POJISTNE');
insert into tab_order values (6509,40395,7445,'WX','21391058',2306.80,'UVER');
insert into tab_order values (6512,40410,7454,'QR','96140414',2306.00,'SIPO');
insert into tab_order values (6512,40411,7454,'AB','52242457',471.00,NULL);
insert into tab_order values (6512,40412,7454,'QR','90570520',1319.00,'UVER');
insert into tab_order values (6520,40462,7485,'OP','40248417',3799.80,'UVER');
insert into tab_order values (6520,40463,7485,'UV','56684088',10279.00,'SIPO');
insert into tab_order values (6526,40524,7523,'QR','92478555',8013.00,'UVER');
insert into tab_order values (6534,40559,7542,'OP','63780206',3683.00,'SIPO');
insert into tab_order values (6534,40560,7542,'UV','94022273',3389.00,NULL);
insert into tab_order values (6534,40561,7542,'CD','1739269',9847.00,'UVER');
insert into tab_order values (6535,40565,7546,'AB','36362540',3495.80,'UVER');
insert into tab_order values (6535,40566,7546,'EF','8914953',3861.00,'SIPO');
insert into tab_order values (6535,40567,7546,'ST','87915062',198.00,NULL);
insert into tab_order values (6535,40568,7546,'ST','3298998',49.00,'POJISTNE');
insert into tab_order values (6539,40588,7559,'YZ','78349375',4112.00,'SIPO');
insert into tab_order values (6539,40589,7559,'GH','48709929',1066.00,'UVER');
insert into tab_order values (6540,40593,7562,'YZ','13822353',6450.20,'UVER');
insert into tab_order values (6541,40597,7565,'EF','61455482',3197.80,'UVER');
insert into tab_order values (6541,40598,7565,'GH','98498379',6649.00,'SIPO');
insert into tab_order values (6541,40599,7565,'MN','24854338',228.00,NULL);
insert into tab_order values (6544,40635,7594,'QR','61969953',2718.00,'UVER');
insert into tab_order values (6544,40636,7594,'YZ','48485803',2302.00,'SIPO');
insert into tab_order values (6544,40637,7594,'MN','40380853',2165.00,NULL);
insert into tab_order values (6544,40638,7594,'WX','62343466',1347.00,'POJISTNE');
insert into tab_order values (6544,40639,7594,'IJ','4607093',210.00,NULL);
insert into tab_order values (6545,40654,7606,'MN','80371361',3197.80,'UVER');
insert into tab_order values (6545,40655,7606,'AB','99149345',4268.00,'SIPO');
insert into tab_order values (6545,40656,7606,'CD','41400957',5856.00,NULL);
insert into tab_order values (6546,40657,7607,'KL','40659213',6020.00,'SIPO');
insert into tab_order values (6546,40658,7607,'GH','90159475',1322.00,'UVER');
insert into tab_order values (6550,40671,7614,'WX','54133033',6678.70,'UVER');
insert into tab_order values (6552,40694,7632,'KL','82218134',9629.00,'SIPO');
insert into tab_order values (6552,40695,7632,'WX','61472195',3551.00,'UVER');
insert into tab_order values (6553,40702,7636,'KL','97231417',3532.00,'UVER');
insert into tab_order values (6553,40703,7636,'CD','96037745',3077.00,'SIPO');
insert into tab_order values (6553,40704,7636,'CD','10650349',325.00,NULL);
insert into tab_order values (6554,40705,7637,'GH','40997958',9397.00,'SIPO');
insert into tab_order values (6554,40706,7637,'YZ','40161162',8127.00,'UVER');
insert into tab_order values (6562,40758,7674,'GH','13693094',3937.30,'UVER');
insert into tab_order values (6562,40759,7674,'ST','57784575',1477.00,'SIPO');
insert into tab_order values (6562,40760,7674,'YZ','18857425',7383.00,NULL);
insert into tab_order values (6568,40815,7713,'UV','76325124',3673.70,'UVER');
insert into tab_order values (6568,40816,7713,'ST','45360702',8418.00,'SIPO');
insert into tab_order values (6569,40827,7721,'IJ','35142588',3788.30,'UVER');
insert into tab_order values (6571,40846,7733,'EF','37232846',5836.00,'UVER');
insert into tab_order values (6574,40865,7745,'WX','97571604',2153.80,'UVER');
insert into tab_order values (6574,40866,7745,'WX','99381535',10160.00,'SIPO');
insert into tab_order values (6577,40883,7753,'GH','62899923',2153.80,'UVER');
insert into tab_order values (6578,40897,7765,'IJ','74587321',2332.00,'UVER');
insert into tab_order values (6578,40898,7765,'EF','75713848',8217.00,'SIPO');
insert into tab_order values (6580,40906,7769,'OP','57404768',4085.00,'UVER');
insert into tab_order values (6585,40947,7795,'AB','32384473',6202.00,'UVER');
insert into tab_order values (6589,40975,7815,'MN','67844575',7903.80,'UVER');
insert into tab_order values (6589,40976,7815,'KL','1201522',1475.00,'SIPO');
insert into tab_order values (6589,40977,7815,'ST','1738054',268.00,NULL);
insert into tab_order values (6589,40978,7815,'IJ','92419248',2197.00,'POJISTNE');
insert into tab_order values (6591,40987,7819,'KL','64831554',1953.00,'SIPO');
insert into tab_order values (6591,40988,7819,'MN','77821957',733.00,NULL);
insert into tab_order values (6591,40989,7819,'CD','46939146',1296.00,'POJISTNE');
insert into tab_order values (6591,40990,7819,'WX','14313167',1721.00,NULL);
insert into tab_order values (6591,40991,7819,'UV','847703',434.00,'UVER');
insert into tab_order values (6594,40999,7824,'KL','63899862',7903.80,'UVER');
insert into tab_order values (6594,41000,7824,'ST','63655739',2156.00,'SIPO');
insert into tab_order values (6594,41001,7824,'GH','44470602',1525.00,NULL);
insert into tab_order values (6596,41042,7844,'UV','97729610',3816.00,'UVER');
insert into tab_order values (6598,41059,7857,'WX','74962877',5676.00,'UVER');
insert into tab_order values (6598,41060,7857,'EF','68440097',8157.00,'SIPO');
insert into tab_order values (6598,41061,7857,'MN','40089714',1042.00,NULL);
insert into tab_order values (6598,41062,7857,'KL','92092263',137.00,'POJISTNE');
insert into tab_order values (6599,41064,7859,'UV','4752576',6010.20,'UVER');
insert into tab_order values (6600,41066,7861,'GH','21743178',8400.00,'SIPO');
insert into tab_order values (6600,41067,7861,'OP','58806037',400.00,NULL);
insert into tab_order values (6600,41068,7861,'WX','69198441',26.00,'POJISTNE');
insert into tab_order values (6600,41069,7861,'MN','77948432',131.00,NULL);
insert into tab_order values (6600,41070,7861,'WX','68080514',607.00,'UVER');
insert into tab_order values (6605,41106,7890,'ST','40316993',4304.00,'SIPO');
insert into tab_order values (6605,41107,7890,'WX','15278214',1653.00,'UVER');
insert into tab_order values (6607,41111,7894,'CD','54257065',4253.70,'UVER');
insert into tab_order values (6607,41112,7894,'ST','28510761',4780.00,'SIPO');
insert into tab_order values (6607,41113,7894,'ST','49265408',2705.00,NULL);
insert into tab_order values (6612,41131,7907,'EF','4643744',8116.20,'UVER');
insert into tab_order values (6612,41132,7907,'IJ','24488801',6327.00,'SIPO');
insert into tab_order values (6613,41168,7926,'GH','19511139',3505.00,'UVER');
insert into tab_order values (6621,41214,7957,'YZ','74890845',3575.00,'UVER');
insert into tab_order values (6621,41215,7957,'WX','45545804',6164.00,'SIPO');
insert into tab_order values (6621,41216,7957,'EF','66945707',6055.00,NULL);
insert into tab_order values (6624,41230,7965,'YZ','98081868',5955.00,'UVER');
insert into tab_order values (6624,41231,7965,'IJ','47610610',7268.00,'SIPO');
insert into tab_order values (6625,41232,7966,'MN','70140522',7887.70,'UVER');
insert into tab_order values (6632,41266,7990,'AB','48107528',3020.00,'UVER');
insert into tab_order values (6632,41267,7990,'IJ','79489946',7158.00,'SIPO');
insert into tab_order values (6633,41276,7997,'ST','41260135',6694.20,'UVER');
insert into tab_order values (6641,41316,8026,'GH','42597097',3563.00,'UVER');
insert into tab_order values (6642,41317,8027,'CD','58650100',6469.70,'UVER');
insert into tab_order values (6643,41332,8038,'AB','66150927',5215.00,'SIPO');
insert into tab_order values (6643,41333,8038,'QR','85338079',1494.00,'UVER');
insert into tab_order values (6644,41334,8039,'UV','23606485',3900.50,'UVER');
insert into tab_order values (6644,41335,8039,'AB','63169944',1074.00,'SIPO');
insert into tab_order values (6644,41336,8039,'MN','52981835',610.00,NULL);
insert into tab_order values (6644,41337,8039,'IJ','3321844',3231.00,'POJISTNE');
insert into tab_order values (6645,41339,8041,'UV','52271634',3900.50,'UVER');
insert into tab_order values (6647,41351,8051,'AB','43162244',4340.00,'UVER');
insert into tab_order values (6650,41380,8073,'OP','7434404',4110.00,'UVER');
insert into tab_order values (6650,41381,8073,'GH','14566856',695.00,'SIPO');
insert into tab_order values (6650,41382,8073,'IJ','4501516',11567.00,NULL);
insert into tab_order values (6655,41406,8085,'ST','4945105',4340.00,'UVER');
insert into tab_order values (6655,41407,8085,'KL','18004334',916.00,'SIPO');
insert into tab_order values (6655,41408,8085,'KL','82082688',10965.00,NULL);
insert into tab_order values (6659,41415,8092,'ST','92639082',6216.00,'SIPO');
insert into tab_order values (6659,41416,8092,'QR','98730998',935.00,'UVER');
insert into tab_order values (6660,41418,8094,'UV','16097522',6123.00,'UVER');
insert into tab_order values (6660,41419,8094,'CD','81951832',5665.00,'SIPO');
insert into tab_order values (6665,41452,8114,'MN','69633596',5958.00,'SIPO');
insert into tab_order values (6665,41453,8114,'GH','65448498',494.00,NULL);
insert into tab_order values (6665,41454,8114,'EF','93537979',1655.00,'UVER');
insert into tab_order values (6667,41468,8127,'AB','15843767',6494.80,'UVER');
insert into tab_order values (6667,41469,8127,'IJ','10767406',8305.00,'SIPO');
insert into tab_order values (6668,41471,8129,'AB','67742585',6184.00,'SIPO');
insert into tab_order values (6668,41472,8129,'KL','34254557',2076.00,'UVER');
insert into tab_order values (6675,41512,8158,'QR','37226617',6630.70,'UVER');
insert into tab_order values (6675,41513,8158,'UV','88843780',9538.00,'SIPO');
insert into tab_order values (6675,41514,8158,'OP','99838619',2148.00,NULL);
insert into tab_order values (6676,41515,8159,'WX','6845528',3034.00,'SIPO');
insert into tab_order values (6676,41516,8159,'QR','17476857',1552.00,NULL);
insert into tab_order values (6676,41517,8159,'GH','50695323',1241.00,'UVER');
insert into tab_order values (6677,41532,8169,'WX','75957637',2148.00,'SIPO');
insert into tab_order values (6677,41533,8169,'GH','17758477',3575.00,NULL);
insert into tab_order values (6677,41534,8169,'IJ','33620470',1633.00,'UVER');
insert into tab_order values (6678,41538,8173,'MN','9593391',6695.00,'UVER');
insert into tab_order values (6682,41606,8225,'ST','69110774',3017.20,'UVER');
insert into tab_order values (6686,41652,8260,'QR','25747537',6239.20,'UVER');
insert into tab_order values (6687,41653,8261,'AB','89613669',3659.80,'UVER');
insert into tab_order values (6687,41654,8261,'GH','72995984',1915.00,'SIPO');
insert into tab_order values (6687,41655,8261,'YZ','66767722',413.00,NULL);
insert into tab_order values (6687,41656,8261,'OP','24150228',646.00,'POJISTNE');
insert into tab_order values (6687,41657,8261,'KL','89226317',2163.00,NULL);
insert into tab_order values (6688,41666,8268,'YZ','74354535',1999.00,'SIPO');
insert into tab_order values (6688,41667,8268,'UV','88068616',5870.00,NULL);
insert into tab_order values (6688,41668,8268,'ST','69461178',359.00,'UVER');
insert into tab_order values (6694,41742,8316,'ST','47769522',5616.20,'UVER');
insert into tab_order values (6695,41746,8320,'UV','30686378',5161.20,'UVER');
insert into tab_order values (6695,41747,8320,'KL','9010935',9105.00,'SIPO');
insert into tab_order values (6696,41748,8321,'WX','27547550',7041.00,'SIPO');
insert into tab_order values (6696,41749,8321,'AB','48114669',1484.00,'UVER');
insert into tab_order values (6698,41754,8327,'IJ','33872771',5161.20,'UVER');
insert into tab_order values (6698,41755,8327,'UV','66402190',4104.00,'SIPO');
insert into tab_order values (6698,41756,8327,'QR','54091328',2539.00,NULL);
insert into tab_order values (6699,41760,8330,'EF','78180604',3708.00,'SIPO');
insert into tab_order values (6699,41761,8330,'EF','4814380',319.00,'UVER');
insert into tab_order values (6704,41827,8377,'QR','64508902',6950.80,'UVER');
insert into tab_order values (6704,41828,8377,'QR','50940710',1172.00,'SIPO');
insert into tab_order values (6704,41829,8377,'MN','65432101',5018.00,NULL);
insert into tab_order values (6705,41834,8381,'IJ','59746819',6950.80,'UVER');
insert into tab_order values (6705,41835,8381,'AB','88732933',740.00,'SIPO');
insert into tab_order values (6705,41836,8381,'QR','19546556',8039.00,NULL);
insert into tab_order values (6712,41881,8405,'YZ','84832042',410.00,'SIPO');
insert into tab_order values (6712,41882,8405,'ST','21518677',4095.00,NULL);
insert into tab_order values (6712,41883,8405,'UV','41846251',3344.00,'POJISTNE');
insert into tab_order values (6712,41884,8405,'OP','25666362',4437.00,'UVER');
insert into tab_order values (6715,41894,8411,'GH','55101638',3677.30,'UVER');
insert into tab_order values (6715,41895,8411,'CD','50854969',5812.00,'SIPO');
insert into tab_order values (6715,41896,8411,'OP','18521237',3507.00,NULL);
insert into tab_order values (6721,41989,8475,'EF','54853975',495.00,'SIPO');
insert into tab_order values (6721,41990,8475,'WX','90749495',3833.00,NULL);
insert into tab_order values (6721,41991,8475,'AB','42267400',878.00,'UVER');
insert into tab_order values (6725,42003,8489,'ST','2885187',3835.00,'SIPO');
insert into tab_order values (6725,42004,8489,'GH','20661109',7370.00,'UVER');
insert into tab_order values (6726,42008,8492,'ST','72004610',4403.00,'SIPO');
insert into tab_order values (6726,42009,8492,'EF','88451617',1431.00,'UVER');
insert into tab_order values (6727,42029,8505,'UV','92435764',3570.00,'UVER');
insert into tab_order values (6729,42047,8519,'KL','62055730',6224.30,'UVER');
insert into tab_order values (6729,42048,8519,'IJ','12003517',13711.00,'SIPO');
insert into tab_order values (6730,42056,8523,'AB','52086591',7753.30,'UVER');
insert into tab_order values (6732,42068,8533,'YZ','84493583',3626.00,'UVER');
insert into tab_order values (6734,42084,8547,'AB','64253020',4806.50,'UVER');
insert into tab_order values (6736,42104,8558,'OP','72949552',4806.50,'UVER');
insert into tab_order values (6737,42115,8564,'ST','88073575',3195.00,'UVER');
insert into tab_order values (6737,42116,8564,'UV','59670215',7170.00,'SIPO');
insert into tab_order values (6737,42117,8564,'EF','30920487',5483.00,NULL);
insert into tab_order values (6738,42119,8566,'MN','44048529',6394.80,'UVER');
insert into tab_order values (6738,42120,8566,'AB','72264265',555.00,'SIPO');
insert into tab_order values (6738,42121,8566,'OP','72889137',8894.00,NULL);
insert into tab_order values (6745,42200,8625,'UV','74800854',1970.80,'UVER');
insert into tab_order values (6745,42201,8625,'YZ','85545950',8151.00,'SIPO');
insert into tab_order values (6746,42221,8639,'MN','67667299',3094.50,'UVER');
insert into tab_order values (6748,42234,8645,'KL','37808364',8919.00,'SIPO');
insert into tab_order values (6748,42235,8645,'CD','50500750',4015.00,'UVER');
insert into tab_order values (6751,42274,8680,'UV','42112159',2381.20,'UVER');
insert into tab_order values (6751,42275,8680,'ST','96207493',3598.00,'SIPO');
insert into tab_order values (6751,42276,8680,'OP','23105997',8566.00,NULL);
insert into tab_order values (6753,42286,8688,'WX','81943165',5665.00,'UVER');
insert into tab_order values (6755,42322,8713,'ST','10424369',2845.00,'UVER');
insert into tab_order values (6758,42360,8742,'MN','70177709',68.00,'SIPO');
insert into tab_order values (6758,42361,8742,'EF','59493338',235.00,NULL);
insert into tab_order values (6758,42362,8742,'YZ','45149773',6089.00,'POJISTNE');
insert into tab_order values (6758,42363,8742,'GH','12393570',2762.00,'UVER');
insert into tab_order values (6763,42414,8772,'KL','85151469',1839.30,'UVER');
insert into tab_order values (6763,42415,8772,'CD','19611203',7357.00,'SIPO');
insert into tab_order values (6764,42420,8776,'CD','88153653',708.00,'UVER');
insert into tab_order values (6766,42431,8784,'UV','10770130',3098.00,'UVER');
insert into tab_order values (6766,42432,8784,'KL','68974447',7097.00,'SIPO');
insert into tab_order values (6785,42584,8899,'CD','16985112',2088.80,'UVER');
insert into tab_order values (6785,42585,8899,'OP','23646956',3713.00,'SIPO');
insert into tab_order values (6790,42612,8919,'KL','55111950',166.00,'SIPO');
insert into tab_order values (6790,42613,8919,'ST','41956782',2670.00,NULL);
insert into tab_order values (6790,42614,8919,'IJ','5126792',3171.00,'UVER');
insert into tab_order values (6791,42625,8926,'ST','35869842',3912.00,'SIPO');
insert into tab_order values (6791,42626,8926,'WX','2699643',2693.00,NULL);
insert into tab_order values (6791,42627,8926,'MN','94917398',1142.00,'POJISTNE');
insert into tab_order values (6791,42628,8926,'UV','49839079',25.00,NULL);
insert into tab_order values (6791,42629,8926,'CD','21242875',9444.00,'UVER');
insert into tab_order values (6793,42633,8931,'KL','7974166',3104.70,'UVER');
insert into tab_order values (6793,42634,8931,'WX','9704506',1749.00,'SIPO');
insert into tab_order values (6793,42635,8931,'MN','66827905',6294.00,NULL);
insert into tab_order values (6805,42697,8972,'EF','61556398',4719.00,'SIPO');
insert into tab_order values (6805,42698,8972,'YZ','5877823',2056.00,NULL);
insert into tab_order values (6805,42699,8972,'CD','75504857',938.00,'UVER');
insert into tab_order values (6808,42713,8982,'OP','77285653',6330.20,'UVER');
insert into tab_order values (6810,42743,9006,'YZ','28411376',3883.00,'UVER');
insert into tab_order values (6810,42744,9006,'UV','73640763',4541.00,'SIPO');
insert into tab_order values (6816,42763,9017,'IJ','66171890',2088.00,'UVER');
insert into tab_order values (6817,42771,9024,'AB','4807711',6270.00,'SIPO');
insert into tab_order values (6817,42772,9024,'GH','77119290',1472.00,'UVER');
insert into tab_order values (6818,42779,9030,'UV','55505740',2587.00,'SIPO');
insert into tab_order values (6818,42780,9030,'YZ','49006336',831.00,NULL);
insert into tab_order values (6818,42781,9030,'UV','13342953',3242.00,'UVER');
insert into tab_order values (6819,42782,9031,'UV','95826726',2088.00,'UVER');
insert into tab_order values (6819,42783,9031,'AB','35263872',4228.00,'SIPO');
insert into tab_order values (6819,42784,9031,'AB','50771135',145.00,NULL);
insert into tab_order values (6819,42785,9031,'IJ','85827368',645.00,'POJISTNE');
insert into tab_order values (6820,42787,9034,'UV','53641200',3179.00,'UVER');
insert into tab_order values (6820,42788,9034,'YZ','1820415',4697.00,'SIPO');
insert into tab_order values (6820,42789,9034,'ST','92149078',621.00,NULL);
insert into tab_order values (6820,42790,9034,'AB','22182023',9115.00,'POJISTNE');
insert into tab_order values (6821,42796,9037,'QR','79376786',3416.00,'SIPO');
insert into tab_order values (6821,42797,9037,'QR','77797412',4033.00,NULL);
insert into tab_order values (6821,42798,9037,'YZ','68518405',6707.00,'UVER');
insert into tab_order values (6824,42813,9052,'QR','10905218',2999.30,'UVER');
insert into tab_order values (6836,42874,9093,'AB','28652066',1311.00,'SIPO');
insert into tab_order values (6836,42875,9093,'QR','62233042',2617.00,NULL);
insert into tab_order values (6836,42876,9093,'OP','60554724',3155.00,'UVER');
insert into tab_order values (6841,42889,9104,'AB','10966873',3585.20,'UVER');
insert into tab_order values (6851,42942,9138,'ST','11258626',4537.30,'UVER');
insert into tab_order values (6851,42943,9138,'IJ','72567075',9519.00,'SIPO');
insert into tab_order values (6851,42944,9138,'ST','63407915',2666.00,NULL);
insert into tab_order values (6852,42946,9140,'CD','64458685',9264.00,'SIPO');
insert into tab_order values (6852,42947,9140,'UV','6970173',19.00,NULL);
insert into tab_order values (6852,42948,9140,'WX','30615341',56.00,'POJISTNE');
insert into tab_order values (6852,42949,9140,'MN','91346168',334.00,'UVER');
insert into tab_order values (6855,42965,9153,'GH','1709419',5042.00,'SIPO');
insert into tab_order values (6855,42966,9153,'ST','27339548',1451.00,'UVER');
insert into tab_order values (6856,42971,9156,'WX','22888767',4537.30,'UVER');
insert into tab_order values (6857,42976,9159,'EF','35698783',6869.00,'SIPO');
insert into tab_order values (6857,42977,9159,'QR','61719810',1847.00,NULL);
insert into tab_order values (6857,42978,9159,'YZ','78505074',253.00,'POJISTNE');
insert into tab_order values (6857,42979,9159,'IJ','98776262',316.00,NULL);
insert into tab_order values (6857,42980,9159,'ST','70977645',1450.00,'UVER');
insert into tab_order values (6859,42990,9167,'MN','98049097',4537.30,'UVER');
insert into tab_order values (6859,42991,9167,'QR','15502429',4950.00,'SIPO');
insert into tab_order values (6859,42992,9167,'WX','99994199',887.00,NULL);
insert into tab_order values (6859,42993,9167,'AB','40962070',545.00,'POJISTNE');
insert into tab_order values (6861,43002,9179,'CD','47917145',3583.70,'UVER');
insert into tab_order values (6863,43009,9188,'GH','22466057',2118.30,'UVER');
insert into tab_order values (6863,43010,9188,'OP','94166147',7936.00,'SIPO');
insert into tab_order values (6863,43011,9188,'GH','11309677',471.00,NULL);
insert into tab_order values (6863,43012,9188,'OP','96138745',66.00,'POJISTNE');
insert into tab_order values (6865,43023,9199,'WX','42162633',2454.50,'UVER');
insert into tab_order values (6866,43025,9201,'AB','85031735',5103.00,'UVER');
insert into tab_order values (6866,43026,9201,'CD','29740798',13461.00,'SIPO');
insert into tab_order values (6868,43034,9208,'WX','63637012',3421.50,'UVER');
insert into tab_order values (6871,43055,9225,'YZ','44963038',3421.50,'UVER');
insert into tab_order values (6872,43056,9227,'IJ','23946523',1784.00,'SIPO');
insert into tab_order values (6872,43057,9227,'AB','54022675',1164.00,NULL);
insert into tab_order values (6872,43058,9227,'GH','92207109',3193.00,'UVER');
insert into tab_order values (6875,43068,9235,'UV','2864957',1735.00,'UVER');
insert into tab_order values (6876,43069,9236,'YZ','16537583',2239.00,'SIPO');
insert into tab_order values (6876,43070,9236,'AB','10692495',2276.00,NULL);
insert into tab_order values (6876,43071,9236,'KL','67995285',7218.00,'UVER');
insert into tab_order values (6877,43081,9241,'ST','73753130',4753.70,'UVER');
insert into tab_order values (6877,43082,9241,'WX','9130680',3595.00,'SIPO');
insert into tab_order values (6878,43083,9242,'IJ','54940307',1932.00,'UVER');
insert into tab_order values (6887,43117,9263,'YZ','8448315',3298.30,'UVER');
insert into tab_order values (6887,43118,9263,'IJ','66611260',9874.00,'SIPO');
insert into tab_order values (6887,43119,9263,'ST','63701718',62.00,NULL);
insert into tab_order values (6888,43122,9265,'IJ','81887966',3298.30,'UVER');
insert into tab_order values (6888,43123,9265,'EF','98678969',9493.00,'SIPO');
insert into tab_order values (6888,43124,9265,'EF','84062218',4017.00,NULL);
insert into tab_order values (6895,43182,9307,'EF','53406888',3491.50,'UVER');
insert into tab_order values (6895,43183,9307,'EF','84733318',4654.00,'SIPO');
insert into tab_order values (6895,43184,9307,'AB','52218389',2735.00,NULL);
insert into tab_order values (6903,43228,9337,'CD','56037777',2172.00,'UVER');
insert into tab_order values (6908,43248,9353,'WX','95570617',7859.00,'UVER');
insert into tab_order values (6908,43249,9353,'GH','35453134',10240.00,'SIPO');
insert into tab_order values (6913,43294,9377,'QR','64104062',4164.00,'UVER');
insert into tab_order values (6913,43295,9377,'QR','54912304',2758.00,'SIPO');
insert into tab_order values (6913,43296,9377,'AB','52341222',3983.00,NULL);
insert into tab_order values (6919,43327,9403,'GH','93069415',3358.00,'UVER');
insert into tab_order values (6919,43328,9403,'IJ','75850492',3225.00,'SIPO');
insert into tab_order values (6921,43357,9422,'QR','97387158',7182.50,'UVER');
insert into tab_order values (6921,43358,9422,'ST','30643040',107.00,'SIPO');
insert into tab_order values (6921,43359,9422,'YZ','28156739',3136.00,NULL);
insert into tab_order values (6922,43361,9424,'EF','1838881',2322.70,'UVER');
insert into tab_order values (6923,43375,9433,'KL','67186093',1860.00,'UVER');
insert into tab_order values (6926,43405,9455,'YZ','28933072',6245.80,'UVER');
insert into tab_order values (6926,43406,9455,'KL','21014684',2789.00,'SIPO');
insert into tab_order values (6926,43407,9455,'IJ','47912371',618.00,NULL);
insert into tab_order values (6926,43408,9455,'IJ','93110262',7793.00,'POJISTNE');
insert into tab_order values (6929,43436,9472,'AB','21299124',3033.00,'UVER');
insert into tab_order values (6929,43437,9472,'KL','17279625',5119.00,'SIPO');
insert into tab_order values (6932,43465,9491,'ST','8897775',4698.00,'UVER');
insert into tab_order values (6932,43466,9491,'GH','6734550',4704.00,'SIPO');
insert into tab_order values (6932,43467,9491,'GH','42563897',2245.00,NULL);
insert into tab_order values (6932,43468,9491,'QR','50093847',872.00,'POJISTNE');
insert into tab_order values (6933,43469,9493,'AB','57428258',3930.80,'UVER');
insert into tab_order values (6933,43470,9493,'WX','47398895',6803.00,'SIPO');
insert into tab_order values (6934,43471,9494,'IJ','95319723',4746.00,'SIPO');
insert into tab_order values (6934,43472,9494,'GH','66095858',9736.00,'UVER');
insert into tab_order values (6938,43489,9504,'KL','22714406',5688.00,'UVER');
insert into tab_order values (6940,43501,9510,'EF','56462389',6341.00,'UVER');
insert into tab_order values (6942,43508,9513,'WX','64432430',8319.00,'SIPO');
insert into tab_order values (6942,43509,9513,'WX','37582862',1527.00,'UVER');
insert into tab_order values (6944,43561,9548,'YZ','97789895',9613.00,'SIPO');
insert into tab_order values (6944,43562,9548,'OP','54906487',962.00,'UVER');
insert into tab_order values (6948,43573,9560,'OP','86154901',4362.70,'UVER');
insert into tab_order values (6948,43574,9560,'EF','53716289',7234.00,'SIPO');
insert into tab_order values (6949,43600,9583,'MN','86397230',4362.70,'UVER');
insert into tab_order values (6949,43601,9583,'EF','69415771',13386.00,'SIPO');
insert into tab_order values (6950,43610,9591,'WX','37543189',4362.70,'UVER');
insert into tab_order values (6950,43611,9591,'QR','26528680',4146.00,'SIPO');
insert into tab_order values (6955,43664,9627,'KL','63660836',5091.30,'UVER');
insert into tab_order values (6956,43669,9631,'MN','51593184',2476.80,'UVER');
insert into tab_order values (6959,43673,9633,'ST','67566084',2476.80,'UVER');
insert into tab_order values (6960,43683,9640,'WX','56319099',3184.30,'UVER');
insert into tab_order values (6960,43684,9640,'QR','35819530',10597.00,'SIPO');
insert into tab_order values (6960,43685,9640,'GH','37369465',4087.00,NULL);
insert into tab_order values (6961,43692,9645,'EF','71165287',4893.00,'UVER');
insert into tab_order values (6961,43693,9645,'KL','32246267',5183.00,'SIPO');
insert into tab_order values (6962,43694,9646,'QR','71861016',5813.50,'UVER');
insert into tab_order values (6965,43708,9656,'EF','27695667',5813.50,'UVER');
insert into tab_order values (6965,43709,9656,'OP','12446082',10721.00,'SIPO');
insert into tab_order values (6969,43737,9673,'QR','70481157',2450.20,'UVER');
insert into tab_order values (6969,43738,9673,'GH','96695422',3684.00,'SIPO');
insert into tab_order values (6970,43746,9677,'WX','83789282',8944.00,'SIPO');
insert into tab_order values (6970,43747,9677,'AB','25327652',527.00,'UVER');
insert into tab_order values (6984,43821,9730,'WX','53964394',258.00,'SIPO');
insert into tab_order values (6984,43822,9730,'AB','9366584',4764.00,NULL);
insert into tab_order values (6984,43823,9730,'WX','82324945',1934.00,'UVER');
insert into tab_order values (6985,43824,9731,'IJ','58578437',3160.70,'UVER');
insert into tab_order values (6985,43825,9731,'AB','50025022',4967.00,'SIPO');
insert into tab_order values (6985,43826,9731,'OP','14137328',1320.00,NULL);
insert into tab_order values (6986,43849,9750,'OP','14637118',3160.70,'UVER');
insert into tab_order values (6992,43912,9790,'UV','22918135',2791.00,'UVER');
insert into tab_order values (6992,43913,9790,'EF','28873682',9210.00,'SIPO');
insert into tab_order values (6992,43914,9790,'AB','42063897',993.00,NULL);
insert into tab_order values (6992,43915,9790,'QR','93822401',2488.00,'POJISTNE');
insert into tab_order values (6995,43945,9814,'QR','6911552',8013.70,'UVER');
insert into tab_order values (6996,43962,9828,'UV','86956995',5274.70,'UVER');
insert into tab_order values (6998,43972,9833,'OP','18851059',8136.00,'UVER');
insert into tab_order values (6998,43973,9833,'ST','35473787',6531.00,'SIPO');
insert into tab_order values (6998,43974,9833,'EF','18397510',5915.00,NULL);
insert into tab_order values (7001,44009,9859,'EF','18163144',5010.50,'UVER');
insert into tab_order values (7001,44010,9859,'QR','24650532',1008.00,'SIPO');
insert into tab_order values (7001,44011,9859,'KL','16269088',1476.00,NULL);
insert into tab_order values (7001,44012,9859,'KL','56029701',765.00,'POJISTNE');
insert into tab_order values (7004,44027,9869,'YZ','58726429',5887.00,'SIPO');
insert into tab_order values (7004,44028,9869,'MN','41454464',2498.00,NULL);
insert into tab_order values (7004,44029,9869,'CD','29203164',5526.00,'UVER');
insert into tab_order values (7008,44070,9897,'IJ','58063542',3013.50,'UVER');
insert into tab_order values (7008,44071,9897,'ST','84057002',1507.00,'SIPO');
insert into tab_order values (7008,44072,9897,'IJ','22879386',4339.00,NULL);
insert into tab_order values (7008,44073,9897,'YZ','57870101',6953.00,'POJISTNE');
insert into tab_order values (7013,44112,9928,'AB','96968262',5016.00,'SIPO');
insert into tab_order values (7013,44113,9928,'KL','10807258',1489.00,'UVER');
insert into tab_order values (7034,44226,10001,'WX','77369373',529.00,'UVER');
insert into tab_order values (7035,44232,10005,'WX','1889122',5854.20,'UVER');
insert into tab_order values (7035,44233,10005,'WX','9563577',9151.00,'SIPO');
insert into tab_order values (7036,44247,10019,'QR','87297737',5415.00,'UVER');
insert into tab_order values (7037,44249,10022,'OP','56197208',4542.70,'UVER');
insert into tab_order values (7037,44250,10022,'MN','25915658',7678.00,'SIPO');
insert into tab_order values (7037,44251,10022,'MN','82763254',4104.00,NULL);
insert into tab_order values (7046,44297,10049,'CD','7603472',1609.00,'SIPO');
insert into tab_order values (7046,44298,10049,'ST','95437645',1281.00,NULL);
insert into tab_order values (7046,44299,10049,'GH','45261365',7636.00,'UVER');
insert into tab_order values (7049,44321,10063,'UV','42204785',6483.70,'UVER');
insert into tab_order values (7049,44322,10063,'GH','12242025',90.00,'SIPO');
insert into tab_order values (7049,44323,10063,'UV','1152956',7601.00,NULL);
insert into tab_order values (7049,44324,10063,'YZ','79726081',2746.00,'POJISTNE');
insert into tab_order values (7049,44325,10063,'ST','68336278',1326.00,NULL);
insert into tab_order values (7050,44328,10065,'CD','54091745',6483.70,'UVER');
insert into tab_order values (7051,44330,10068,'WX','81110077',6483.70,'UVER');
insert into tab_order values (7055,44345,10079,'YZ','33228176',2784.80,'UVER');
insert into tab_order values (7057,44355,10093,'GH','24015391',6436.00,'UVER');
insert into tab_order values (7057,44356,10093,'EF','14110547',2762.00,'SIPO');
insert into tab_order values (7057,44357,10093,'WX','57294940',331.00,NULL);
insert into tab_order values (7057,44358,10093,'EF','80783962',7082.00,'POJISTNE');
insert into tab_order values (7061,44373,10105,'OP','27668351',5079.00,'UVER');
insert into tab_order values (7066,44408,10131,'YZ','64831644',5983.00,'UVER');
insert into tab_order values (7067,44412,10134,'EF','12704295',5681.80,'UVER');
insert into tab_order values (7067,44413,10134,'QR','69918125',9535.00,'SIPO');
insert into tab_order values (7072,44435,10148,'UV','70086633',4205.00,'SIPO');
insert into tab_order values (7072,44436,10148,'UV','85131781',1866.00,NULL);
insert into tab_order values (7072,44437,10148,'ST','5157071',1842.00,'UVER');
insert into tab_order values (7085,44523,10202,'AB','31367302',6363.30,'UVER');
insert into tab_order values (7085,44524,10202,'QR','56383961',1281.00,'SIPO');
insert into tab_order values (7085,44525,10202,'CD','86462396',4880.00,NULL);
insert into tab_order values (7087,44536,10215,'UV','65958177',152.00,'SIPO');
insert into tab_order values (7087,44537,10215,'GH','18670410',4122.00,NULL);
insert into tab_order values (7087,44538,10215,'WX','33332234',1846.00,'UVER');
insert into tab_order values (7088,44562,10233,'MN','72738069',3985.70,'UVER');
insert into tab_order values (7088,44563,10233,'WX','6003463',456.00,'SIPO');
insert into tab_order values (7088,44564,10233,'CD','70803910',53.00,NULL);
insert into tab_order values (7088,44565,10233,'OP','53952217',986.00,'POJISTNE');
insert into tab_order values (7088,44566,10233,'MN','69788956',4260.00,NULL);
insert into tab_order values (7091,44578,10243,'GH','33131796',3151.30,'UVER');
insert into tab_order values (7096,44598,10257,'IJ','7045454',3151.30,'UVER');
insert into tab_order values (7096,44599,10257,'YZ','6128639',14801.00,'SIPO');
insert into tab_order values (7097,44611,10266,'EF','72682583',3151.30,'UVER');
insert into tab_order values (7100,44634,10280,'EF','13051045',5802.30,'UVER');
insert into tab_order values (7101,44665,10297,'CD','53796619',9902.00,'SIPO');
insert into tab_order values (7101,44666,10297,'WX','2840400',8771.00,'UVER');
insert into tab_order values (7104,44698,10320,'KL','11919367',4328.80,'UVER');
insert into tab_order values (7104,44699,10320,'KL','6873333',12414.00,'SIPO');
insert into tab_order values (7110,44732,10345,'UV','98083507',6742.00,'SIPO');
insert into tab_order values (7110,44733,10345,'UV','38070029',2605.00,'UVER');
insert into tab_order values (7115,44743,10351,'CD','99277340',4410.00,'SIPO');
insert into tab_order values (7115,44744,10351,'GH','66402935',1848.00,'UVER');
insert into tab_order values (7119,44765,10361,'CD','64321249',7240.00,'UVER');
insert into tab_order values (7121,44769,10364,'EF','67477196',6262.00,'SIPO');
insert into tab_order values (7121,44770,10364,'IJ','11477667',609.00,'UVER');
insert into tab_order values (7122,44771,10365,'OP','35377323',7240.00,'UVER');
insert into tab_order values (7122,44772,10365,'MN','91104155',4325.00,'SIPO');
insert into tab_order values (7122,44773,10365,'GH','19185972',6395.00,NULL);
insert into tab_order values (7122,44774,10365,'OP','23228162',331.00,'POJISTNE');
insert into tab_order values (7122,44775,10365,'YZ','81018465',1773.00,NULL);
insert into tab_order values (7129,44836,10404,'AB','3621232',2171.00,'SIPO');
insert into tab_order values (7129,44837,10404,'AB','74571001',1203.00,NULL);
insert into tab_order values (7129,44838,10404,'AB','21209323',100.00,'POJISTNE');
insert into tab_order values (7129,44839,10404,'UV','60165852',883.00,NULL);
insert into tab_order values (7129,44840,10404,'ST','55139064',3238.00,'UVER');
insert into tab_order values (7130,44850,10411,'GH','82482695',5142.00,'UVER');
insert into tab_order values (7130,44851,10411,'ST','41324371',3020.00,'SIPO');
insert into tab_order values (7130,44852,10411,'GH','93566715',1807.00,NULL);
insert into tab_order values (7130,44853,10411,'CD','33192354',2323.00,'POJISTNE');
insert into tab_order values (7130,44854,10411,'ST','47737151',7732.00,NULL);
insert into tab_order values (7136,44894,10436,'AB','4855519',1511.00,'UVER');
insert into tab_order values (7137,44899,10439,'AB','78703766',6315.00,'UVER');
insert into tab_order values (7137,44900,10439,'WX','55833750',10134.00,'SIPO');
insert into tab_order values (7138,44901,10440,'YZ','4957092',2960.00,'SIPO');
insert into tab_order values (7138,44902,10440,'IJ','96339386',1950.00,NULL);
insert into tab_order values (7138,44903,10440,'AB','1623732',1000.00,'UVER');
insert into tab_order values (7139,44909,10445,'MN','24684030',3234.00,'SIPO');
insert into tab_order values (7139,44910,10445,'EF','399',1951.00,'UVER');
insert into tab_order values (7142,44923,10451,'CD','58286762',2439.00,'SIPO');
insert into tab_order values (7142,44924,10451,'QR','73621487',4653.00,NULL);
insert into tab_order values (7142,44925,10451,'MN','92217593',689.00,'POJISTNE');
insert into tab_order values (7142,44926,10451,'YZ','10042131',8049.00,'UVER');
insert into tab_order values (7147,44966,10478,'MN','41004979',5575.30,'UVER');
insert into tab_order values (7151,44983,10493,'UV','88460844',5575.30,'UVER');
insert into tab_order values (7151,44984,10493,'YZ','11884606',8594.00,'SIPO');
insert into tab_order values (7151,44985,10493,'AB','16853463',842.00,NULL);
insert into tab_order values (7154,45022,10520,'MN','4994863',6959.80,'UVER');
insert into tab_order values (7164,45167,10613,'MN','57666522',5204.20,'UVER');
insert into tab_order values (7166,45189,10630,'UV','65871029',7303.00,'SIPO');
insert into tab_order values (7166,45190,10630,'OP','6516325',8260.00,'UVER');
insert into tab_order values (7167,45210,10644,'ST','68935322',7498.70,'UVER');
insert into tab_order values (7167,45211,10644,'GH','87092184',11053.00,'SIPO');
insert into tab_order values (7168,45212,10645,'AB','62736219',5787.00,'UVER');
insert into tab_order values (7168,45213,10645,'MN','86990302',3740.00,'SIPO');
insert into tab_order values (7171,45221,10650,'QR','49945110',4088.00,'UVER');
insert into tab_order values (7171,45222,10650,'WX','40695470',10356.00,'SIPO');
insert into tab_order values (7172,45224,10652,'UV','59188014',3810.00,'UVER');
insert into tab_order values (7172,45225,10652,'MN','74468493',1290.00,'SIPO');
insert into tab_order values (7172,45226,10652,'QR','87759685',2362.00,NULL);
insert into tab_order values (7176,45244,10663,'MN','48801767',7223.20,'UVER');
insert into tab_order values (7176,45245,10663,'YZ','75102978',4782.00,'SIPO');
insert into tab_order values (7176,45246,10663,'YZ','54900079',9317.00,NULL);
insert into tab_order values (7181,45271,10679,'AB','88228171',8241.80,'UVER');
insert into tab_order values (7181,45272,10679,'UV','90083878',6670.00,'SIPO');
insert into tab_order values (7187,45324,10711,'MN','4543543',2714.00,'SIPO');
insert into tab_order values (7187,45325,10711,'OP','49912905',413.00,NULL);
insert into tab_order values (7187,45326,10711,'WX','75319576',85.00,'POJISTNE');
insert into tab_order values (7187,45327,10711,'EF','39264708',443.00,NULL);
insert into tab_order values (7187,45328,10711,'GH','56366127',403.00,'UVER');
insert into tab_order values (7189,45347,10728,'QR','3507805',3221.50,'UVER');
insert into tab_order values (7189,45348,10728,'UV','56014490',3867.00,'SIPO');
insert into tab_order values (7192,45363,10738,'UV','56781524',3221.50,'UVER');
insert into tab_order values (7192,45364,10738,'CD','73939931',186.00,'SIPO');
insert into tab_order values (7192,45365,10738,'CD','41088736',8042.00,NULL);
insert into tab_order values (7194,45401,10762,'WX','41995155',5435.00,'SIPO');
insert into tab_order values (7194,45402,10762,'YZ','96996306',1912.00,'UVER');
insert into tab_order values (7195,45417,10774,'AB','56546854',3728.00,'SIPO');
insert into tab_order values (7195,45418,10774,'QR','93903570',7066.00,'UVER');
insert into tab_order values (7198,45433,10788,'EF','82111698',3813.70,'UVER');
insert into tab_order values (7199,45435,10789,'IJ','33691179',3813.70,'UVER');
insert into tab_order values (7199,45436,10789,'GH','34503346',10340.00,'SIPO');
insert into tab_order values (7199,45437,10789,'GH','94227504',933.00,NULL);
insert into tab_order values (7199,45438,10789,'AB','38727879',2670.00,'POJISTNE');
insert into tab_order values (7200,45448,10799,'UV','80825555',519.00,'UVER');
insert into tab_order values (7201,45455,10807,'EF','29934013',5622.50,'UVER');
insert into tab_order values (7202,45460,10812,'IJ','5287313',2931.00,'UVER');
insert into tab_order values (7209,45536,10857,'UV','47286009',6426.30,'UVER');
insert into tab_order values (7213,45575,10884,'IJ','46969729',3154.00,'UVER');
insert into tab_order values (7213,45576,10884,'EF','72628474',1326.00,'SIPO');
insert into tab_order values (7213,45577,10884,'QR','42624378',4408.00,NULL);
insert into tab_order values (7219,45606,10905,'AB','20420891',2939.00,'SIPO');
insert into tab_order values (7219,45607,10905,'EF','13832676',1682.00,NULL);
insert into tab_order values (7219,45608,10905,'KL','88619136',1190.00,'UVER');
insert into tab_order values (7220,45612,10911,'QR','35383486',3647.00,'UVER');
insert into tab_order values (7220,45613,10911,'YZ','70292973',7312.00,'SIPO');
insert into tab_order values (7221,45618,10915,'AB','40481370',2540.80,'UVER');
insert into tab_order values (7221,45619,10915,'CD','80617797',2596.00,'SIPO');
insert into tab_order values (7221,45620,10915,'GH','27411347',390.00,NULL);
insert into tab_order values (7221,45621,10915,'IJ','40923118',3651.00,'POJISTNE');
insert into tab_order values (7221,45622,10915,'WX','53494477',4520.00,NULL);
insert into tab_order values (7226,45666,10940,'KL','1789451',7517.00,'SIPO');
insert into tab_order values (7226,45667,10940,'YZ','91803866',5493.00,'UVER');
insert into tab_order values (7227,45669,10942,'IJ','35088640',5242.00,'UVER');
insert into tab_order values (7227,45670,10942,'AB','71402126',10472.00,'SIPO');
insert into tab_order values (7230,45688,10954,'ST','11468434',312.00,'UVER');
insert into tab_order values (7233,45704,10963,'AB','61788761',3216.70,'UVER');
insert into tab_order values (7235,45717,10973,'OP','88414823',3216.70,'UVER');
insert into tab_order values (7240,45776,11013,'YZ','91721045',4579.00,'UVER');
insert into tab_order values (7240,45777,11013,'CD','27690512',756.00,'SIPO');
insert into tab_order values (7240,45778,11013,'IJ','43103534',9499.00,NULL);
insert into tab_order values (7241,45793,11021,'KL','1485199',7040.70,'UVER');
insert into tab_order values (7242,45800,11027,'QR','81596547',2004.20,'UVER');
insert into tab_order values (7242,45801,11027,'GH','23646575',3799.00,'SIPO');
insert into tab_order values (7243,45826,11042,'EF','86233681',6031.80,'UVER');
insert into tab_order values (7243,45827,11042,'UV','59894961',8436.00,'SIPO');
insert into tab_order values (7246,45846,11054,'KL','99520563',2482.00,'UVER');
insert into tab_order values (7246,45847,11054,'EF','28344845',11506.00,'SIPO');
insert into tab_order values (7249,45868,11065,'MN','13170600',1445.00,'UVER');
insert into tab_order values (7250,45873,11069,'QR','55347859',2482.00,'UVER');
insert into tab_order values (7253,45885,11079,'UV','40114671',8191.50,'UVER');
insert into tab_order values (7255,45902,11096,'QR','41980844',6661.00,'SIPO');
insert into tab_order values (7255,45903,11096,'WX','43682754',3555.00,'UVER');
insert into tab_order values (7259,45922,11111,'MN','63972902',3004.50,'UVER');
insert into tab_order values (7259,45923,11111,'CD','17909336',4736.00,'SIPO');
insert into tab_order values (7262,45969,11135,'OP','24313068',3264.00,'SIPO');
insert into tab_order values (7262,45970,11135,'UV','31748539',5073.00,'UVER');
insert into tab_order values (7263,45974,11138,'YZ','73215025',3744.70,'UVER');
insert into tab_order values (7264,45978,11141,'QR','68096905',3744.70,'UVER');
insert into tab_order values (7271,46055,11186,'UV','92339318',6541.20,'UVER');
insert into tab_order values (7271,46056,11186,'WX','55896991',9810.00,'SIPO');
insert into tab_order values (7277,46125,11231,'CD','69176065',7440.50,'UVER');
insert into tab_order values (7277,46126,11231,'AB','4824811',9783.00,'SIPO');
insert into tab_order values (7277,46127,11231,'UV','15493494',229.00,NULL);
insert into tab_order values (7279,46149,11244,'KL','40766275',6490.50,'UVER');
insert into tab_order values (7279,46150,11244,'EF','90770136',12154.00,'SIPO');
insert into tab_order values (7284,46184,11265,'KL','37816989',506.00,'SIPO');
insert into tab_order values (7284,46185,11265,'WX','80508869',2607.00,NULL);
insert into tab_order values (7284,46186,11265,'KL','33709621',4399.00,'UVER');
insert into tab_order values (7286,46193,11271,'QR','24716264',1870.30,'UVER');
insert into tab_order values (7286,46194,11271,'EF','69184708',5808.00,'SIPO');
insert into tab_order values (7286,46195,11271,'AB','31909245',2364.00,NULL);
insert into tab_order values (7286,46196,11271,'IJ','36822885',516.00,'POJISTNE');
insert into tab_order values (7292,46258,11317,'CD','66904526',5290.80,'UVER');
insert into tab_order values (7292,46259,11317,'KL','72136521',3849.00,'SIPO');
insert into tab_order values (7292,46260,11317,'YZ','43205881',2784.00,NULL);
insert into tab_order values (7294,46273,11327,'YZ','5815422',3693.00,'SIPO');
insert into tab_order values (7294,46274,11327,'CD','61814498',1632.00,'UVER');
insert into tab_order values (7295,46275,11328,'YZ','75745355',4674.00,'UVER');
insert into tab_order values (7304,46311,11349,'KL','66436326',6998.00,'UVER');
insert into tab_order values (7304,46312,11349,'GH','57291018',10886.00,'SIPO');
insert into tab_order values (7305,46328,11359,'EF','37834555',4502.30,'UVER');
insert into tab_order values (7305,46329,11359,'OP','33080721',4518.00,'SIPO');
insert into tab_order values (7305,46330,11359,'AB','90330576',254.00,NULL);
insert into tab_order values (7308,46334,11362,'YZ','70641225',4780.00,'SIPO');
insert into tab_order values (7308,46335,11362,'MN','78507822',56.00,NULL);
insert into tab_order values (7308,46336,11362,'ST','40799850',330.00,'POJISTNE');
insert into tab_order values (7308,46337,11362,'KL','20009470',129.00,NULL);
insert into tab_order values (7308,46338,11362,'MN','61540514',5392.00,'UVER');
insert into tab_trans values (4959,276,2,'1993-2-26','PRIJEM','VKLAD',1100.00,1100.00,NULL,NULL,NULL);
insert into tab_trans values (4959,279,2,'1993-3-12','PRIJEM','PREVOD Z UCTU',20236.00,21336.00,NULL,'ST','66487163');
insert into tab_trans values (4959,280,2,'1993-4-12','PRIJEM','PREVOD Z UCTU',20236.00,45285.50,NULL,'ST','66487163');
insert into tab_trans values (4959,281,2,'1993-5-12','PRIJEM','PREVOD Z UCTU',20236.00,54630.90,NULL,'ST','66487163');
insert into tab_trans values (4959,282,2,'1993-6-12','PRIJEM','PREVOD Z UCTU',30354.00,67529.60,NULL,'ST','66487163');
insert into tab_trans values (4959,283,2,'1993-7-12','PRIJEM','PREVOD Z UCTU',20236.00,62325.50,NULL,'ST','66487163');
insert into tab_trans values (4959,284,2,'1993-8-12','PRIJEM','PREVOD Z UCTU',20236.00,49138.90,NULL,'ST','66487163');
insert into tab_trans values (4959,285,2,'1993-9-12','PRIJEM','PREVOD Z UCTU',20236.00,39961.80,NULL,'ST','66487163');
insert into tab_trans values (4959,286,2,'1993-10-12','PRIJEM','PREVOD Z UCTU',20236.00,30744.00,NULL,'ST','66487163');
insert into tab_trans values (4959,287,2,'1993-11-12','PRIJEM','PREVOD Z UCTU',20236.00,40800.40,NULL,'ST','66487163');
insert into tab_trans values (4959,288,2,'1993-12-12','PRIJEM','PREVOD Z UCTU',30354.00,47212.90,NULL,'ST','66487163');
insert into tab_trans values (4959,355,2,'1993-7-11','VYDAJ','VYBER',3200.00,42089.50,NULL,NULL,'0');
insert into tab_trans values (4959,356,2,'1993-8-7','VYDAJ','VYBER',2900.00,28902.90,NULL,NULL,'0');
insert into tab_trans values (4959,357,2,'1993-9-14','VYDAJ','VYBER',3600.00,36361.80,NULL,NULL,'0');
insert into tab_trans values (4959,358,2,'1993-10-3','VYDAJ','VYBER',4000.00,17774.00,NULL,NULL,'0');
insert into tab_trans values (4959,359,2,'1993-11-21','VYDAJ','VYBER',3800.00,37000.40,NULL,NULL,'0');
insert into tab_trans values (4959,360,2,'1993-12-8','VYDAJ','VYBER',3500.00,21058.90,NULL,NULL,'0');
insert into tab_trans values (4959,428,2,'1993-8-5','VYDAJ','PREVOD NA UCET',7266.00,31802.90,'SIPO','QR','13943797');
insert into tab_trans values (4959,429,2,'1993-9-5','VYDAJ','PREVOD NA UCET',7266.00,19725.80,'SIPO','QR','13943797');
insert into tab_trans values (4959,430,2,'1993-10-5','VYDAJ','PREVOD NA UCET',7266.00,10508.00,'SIPO','QR','13943797');
insert into tab_trans values (4959,431,2,'1993-11-5','VYDAJ','PREVOD NA UCET',7266.00,20564.40,'SIPO','QR','13943797');
insert into tab_trans values (4959,432,2,'1993-12-5','VYDAJ','PREVOD NA UCET',7266.00,24558.90,'SIPO','QR','13943797');
insert into tab_trans values (4959,493,2,'1993-8-22','VYBER','VYBER',21286.00,27852.90,NULL,NULL,NULL);
insert into tab_trans values (4959,495,2,'1993-12-21','VYBER','VYBER',13396.00,30816.90,NULL,NULL,NULL);
insert into tab_trans values (4959,497,2,'1993-7-19','VYBER','VYBER',13145.00,49180.50,NULL,NULL,NULL);
insert into tab_trans values (4959,546,2,'1993-12-10','VYDAJ','VYBER',4200.00,16858.90,NULL,NULL,NULL);
insert into tab_trans values (4959,590,2,'1993-12-19','VYDAJ','VYBER',3000.00,44212.90,NULL,NULL,NULL);
insert into tab_trans values (4959,592,2,'1993-9-26','VYDAJ','VYBER',10200.00,21661.80,NULL,NULL,NULL);
insert into tab_trans values (4959,632,2,'1993-7-31','VYDAJ','VYBER',14.60,39068.90,'SLUZBY',NULL,NULL);
insert into tab_trans values (4959,633,2,'1993-8-31','VYDAJ','VYBER',14.60,26991.80,'SLUZBY',NULL,NULL);
insert into tab_trans values (4959,634,2,'1993-9-30','VYDAJ','VYBER',14.60,21774.00,'SLUZBY',NULL,NULL);
insert into tab_trans values (4959,635,2,'1993-10-31','VYDAJ','VYBER',14.60,27830.40,'SLUZBY',NULL,NULL);
insert into tab_trans values (4959,636,2,'1993-11-30','VYDAJ','VYBER',14.60,31824.90,'SLUZBY',NULL,NULL);
insert into tab_trans values (4959,637,2,'1993-12-31','VYDAJ','VYBER',14.60,27840.60,'SLUZBY',NULL,NULL);
insert into tab_trans values (4959,697,2,'1993-3-28','PRIJEM','VKLAD',3700.00,25036.00,NULL,NULL,NULL);
insert into tab_trans values (4959,698,2,'1993-4-27','VYDAJ','VYBER',11000.00,34285.50,NULL,NULL,NULL);
insert into tab_trans values (4959,699,2,'1993-5-27','VYDAJ','VYBER',17600.00,37030.90,NULL,NULL,NULL);
insert into tab_trans values (4959,700,2,'1993-6-26','VYDAJ','VYBER',22400.00,45129.60,NULL,NULL,NULL);
insert into tab_trans values (4959,701,2,'1993-7-26','VYDAJ','VYBER',10300.00,38880.50,NULL,NULL,NULL);
insert into tab_trans values (4959,702,2,'1993-8-25','VYDAJ','VYBER',1000.00,26852.90,NULL,NULL,NULL);
insert into tab_trans values (4959,703,2,'1993-9-24','VYDAJ','VYBER',4500.00,31861.80,NULL,NULL,NULL);
insert into tab_trans values (4959,704,2,'1993-10-24','VYDAJ','VYBER',3000.00,27744.00,NULL,NULL,NULL);
insert into tab_trans values (4959,705,2,'1993-11-23','VYDAJ','VYBER',5300.00,31700.40,NULL,NULL,NULL);
insert into tab_trans values (4959,706,2,'1993-12-23','VYDAJ','VYBER',3100.00,27716.90,NULL,NULL,NULL);
insert into tab_trans values (4959,3530483,2,'1993-3-31','PRIJEM',NULL,13.50,25049.50,'UROK',NULL,NULL);
insert into tab_trans values (4959,3530484,2,'1993-4-30','PRIJEM',NULL,109.50,34394.90,'UROK',NULL,NULL);
insert into tab_trans values (4959,3530485,2,'1993-5-31','PRIJEM',NULL,144.70,37175.60,'UROK',NULL,NULL);
insert into tab_trans values (4959,3530486,2,'1993-6-30','PRIJEM',NULL,159.90,45289.50,'UROK',NULL,NULL);
insert into tab_trans values (4959,3530487,2,'1993-7-31','PRIJEM',NULL,203.00,39083.50,'UROK',NULL,NULL);
insert into tab_trans values (4959,3530488,2,'1993-8-31','PRIJEM',NULL,153.50,27006.40,'UROK',NULL,NULL);
insert into tab_trans values (4959,3530489,2,'1993-9-30','PRIJEM',NULL,126.80,21788.60,'UROK',NULL,NULL);
insert into tab_trans values (4959,3530490,2,'1993-10-31','PRIJEM',NULL,101.00,27845.00,'UROK',NULL,NULL);
insert into tab_trans values (4959,3530491,2,'1993-11-30','PRIJEM',NULL,139.10,31839.50,'UROK',NULL,NULL);
insert into tab_trans values (4959,3530492,2,'1993-12-31','PRIJEM',NULL,138.30,27855.20,'UROK',NULL,NULL);
insert into tab_trans values (4961,4530,19,'1995-4-7','PRIJEM','VKLAD',1000.00,1000.00,NULL,NULL,NULL);
insert into tab_trans values (4961,4534,19,'1995-4-10','PRIJEM','PREVOD Z UCTU',15139.00,16139.00,NULL,'OP','29053187');
insert into tab_trans values (4961,4535,19,'1995-5-10','PRIJEM','PREVOD Z UCTU',15139.00,35772.10,NULL,'OP','29053187');
insert into tab_trans values (4961,4536,19,'1995-6-10','PRIJEM','PREVOD Z UCTU',22708.00,55830.50,NULL,'OP','29053187');
insert into tab_trans values (4961,4537,19,'1995-7-10','PRIJEM','PREVOD Z UCTU',15139.00,57683.70,NULL,'OP','29053187');
insert into tab_trans values (4961,4538,19,'1995-8-10','PRIJEM','PREVOD Z UCTU',15139.00,55296.50,NULL,'OP','29053187');
insert into tab_trans values (4961,4539,19,'1995-9-10','PRIJEM','PREVOD Z UCTU',15139.00,34542.00,NULL,'OP','29053187');
insert into tab_trans values (4961,4540,19,'1995-10-10','PRIJEM','PREVOD Z UCTU',15139.00,36262.30,NULL,'OP','29053187');
insert into tab_trans values (4961,4541,19,'1995-11-10','PRIJEM','PREVOD Z UCTU',15139.00,25092.70,NULL,'OP','29053187');
insert into tab_trans values (4961,4542,19,'1995-12-10','PRIJEM','PREVOD Z UCTU',22708.00,29038.50,NULL,'OP','29053187');
insert into tab_trans values (4961,4543,19,'1996-1-10','PRIJEM','PREVOD Z UCTU',15139.00,41024.40,NULL,'OP','29053187');
insert into tab_trans values (4961,4544,19,'1996-2-10','PRIJEM','PREVOD Z UCTU',15139.00,21421.10,NULL,'OP','29053187');
insert into tab_trans values (4961,4545,19,'1996-3-10','PRIJEM','PREVOD Z UCTU',15139.00,35162.20,NULL,'OP','29053187');
insert into tab_trans values (4961,4546,19,'1996-4-10','PRIJEM','PREVOD Z UCTU',15139.00,15854.00,NULL,'OP','29053187');
insert into tab_trans values (4961,4586,19,'1995-8-9','VYDAJ','VYBER',2800.00,40157.50,NULL,NULL,'0');
insert into tab_trans values (4961,4587,19,'1995-9-23','VYDAJ','VYBER',2800.00,16742.00,NULL,NULL,'0');
insert into tab_trans values (4961,4588,19,'1995-10-10','VYDAJ','VYBER',3000.00,33262.30,NULL,NULL,'0');
insert into tab_trans values (4961,4589,19,'1995-11-12','VYDAJ','VYBER',2100.00,22992.70,NULL,NULL,'0');
insert into tab_trans values (4961,4590,19,'1995-11-29','VYDAJ','VYBER',2700.00,20292.70,NULL,NULL,'0');
insert into tab_trans values (4961,4591,19,'1995-12-31','VYDAJ','VYBER',1600.00,24885.40,NULL,NULL,'0');
insert into tab_trans values (4961,4592,19,'1996-2-10','VYDAJ','VYBER',1800.00,19621.10,NULL,NULL,'0');
insert into tab_trans values (4961,4593,19,'1996-3-7','VYDAJ','VYBER',2300.00,20023.20,NULL,NULL,'0');
insert into tab_trans values (4961,4594,19,'1996-3-24','VYDAJ','VYBER',2000.00,16162.20,NULL,NULL,'0');
insert into tab_trans values (4961,4635,19,'1995-9-13','VYDAJ','VYBER',15000.00,19542.00,'SIPO',NULL,'0');
insert into tab_trans values (4961,4636,19,'1995-10-10','VYDAJ','VYBER',13200.00,20062.30,'SIPO',NULL,'0');
insert into tab_trans values (4961,4637,19,'1995-11-5','VYDAJ','VYBER',16800.00,9953.70,'SIPO',NULL,'0');
insert into tab_trans values (4961,4638,19,'1995-11-29','VYDAJ','VYBER',16700.00,3592.70,'SIPO',NULL,'0');
insert into tab_trans values (4961,4639,19,'1996-1-15','VYDAJ','VYBER',16300.00,17824.40,'SIPO',NULL,'0');
insert into tab_trans values (4961,4640,19,'1996-1-30','VYDAJ','VYBER',14200.00,3624.40,'SIPO',NULL,'0');
insert into tab_trans values (4961,4641,19,'1996-3-16','VYDAJ','VYBER',17000.00,18162.20,'SIPO',NULL,'0');
insert into tab_trans values (4961,4642,19,'1996-4-6','VYDAJ','VYBER',18200.00,715.00,'SIPO',NULL,'0');
insert into tab_trans values (4961,4685,19,'1995-8-23','VYBER','VYBER',11765.00,43531.50,NULL,NULL,NULL);
insert into tab_trans values (4961,4688,19,'1995-9-6','VYBER','VYBER',16543.00,19403.00,NULL,NULL,NULL);
insert into tab_trans values (4961,4713,19,'1995-12-19','VYDAJ','VYBER',2700.00,26338.50,NULL,NULL,NULL);
insert into tab_trans values (4961,4723,19,'1996-1-12','VYDAJ','VYBER',2100.00,34124.40,NULL,NULL,NULL);
insert into tab_trans values (4961,4725,19,'1996-1-10','VYDAJ','VYBER',4800.00,36224.40,NULL,NULL,NULL);
insert into tab_trans values (4961,4770,19,'1995-8-31','VYDAJ','VYBER',14.60,43946.00,'SLUZBY',NULL,NULL);
insert into tab_trans values (4961,4771,19,'1995-9-30','VYDAJ','VYBER',14.60,16923.30,'SLUZBY',NULL,NULL);
insert into tab_trans values (4961,4772,19,'1995-10-31','VYDAJ','VYBER',14.60,20253.70,'SLUZBY',NULL,NULL);
insert into tab_trans values (4961,4773,19,'1995-11-30','VYDAJ','VYBER',14.60,3730.50,'SLUZBY',NULL,NULL);
insert into tab_trans values (4961,4774,19,'1995-12-31','VYDAJ','VYBER',14.60,26485.40,'SLUZBY',NULL,NULL);
insert into tab_trans values (4961,4775,19,'1996-1-31','VYDAJ','VYBER',14.60,3782.10,'SLUZBY',NULL,NULL);
insert into tab_trans values (4961,4776,19,'1996-2-29','VYDAJ','VYBER',14.60,19723.20,'SLUZBY',NULL,NULL);
insert into tab_trans values (4961,4777,19,'1996-3-31','VYDAJ','VYBER',14.60,16315.00,'SLUZBY',NULL,NULL);
insert into tab_trans values (4961,4810,19,'1995-5-7','PRIJEM','VKLAD',4400.00,20633.10,NULL,NULL,NULL);
insert into tab_trans values (4961,4811,19,'1995-6-6','VYDAJ','VYBER',2900.00,33122.50,NULL,NULL,NULL);
insert into tab_trans values (4961,4812,19,'1995-7-6','VYDAJ','VYBER',13700.00,42544.70,NULL,NULL,NULL);
insert into tab_trans values (4961,4813,19,'1995-8-5','VYDAJ','VYBER',15200.00,42957.50,NULL,NULL,NULL);
insert into tab_trans values (4961,4814,19,'1995-9-4','VYDAJ','VYBER',8000.00,35946.00,NULL,NULL,NULL);
insert into tab_trans values (4961,4815,19,'1995-10-4','PRIJEM','VKLAD',4200.00,21123.30,NULL,NULL,NULL);
insert into tab_trans values (4961,4816,19,'1995-11-3','PRIJEM','VKLAD',6500.00,26753.70,NULL,NULL,NULL);
insert into tab_trans values (4961,4817,19,'1995-12-3','PRIJEM','VKLAD',2600.00,6330.50,NULL,NULL,NULL);
insert into tab_trans values (4961,4818,19,'1996-1-2','PRIJEM','VKLAD',1000.00,25885.40,NULL,NULL,NULL);
insert into tab_trans values (4961,4819,19,'1996-2-1','PRIJEM','VKLAD',2500.00,6282.10,NULL,NULL,NULL);
insert into tab_trans values (4961,4820,19,'1996-3-2','PRIJEM','VKLAD',2600.00,22323.20,NULL,NULL,NULL);
insert into tab_trans values (4961,4821,19,'1996-4-1','PRIJEM','VKLAD',2600.00,18915.00,NULL,NULL,NULL);
insert into tab_trans values (4961,3445002,19,'1995-4-30','PRIJEM',NULL,47.10,16186.10,'UROK',NULL,NULL);
insert into tab_trans values (4961,3445003,19,'1995-5-31','PRIJEM',NULL,125.20,36022.50,'UROK',NULL,NULL);
insert into tab_trans values (4961,3445004,19,'1995-6-30','PRIJEM',NULL,207.00,56244.70,'UROK',NULL,NULL);
insert into tab_trans values (4961,3445005,19,'1995-7-31','PRIJEM',NULL,236.80,58157.50,'UROK',NULL,NULL);
insert into tab_trans values (4961,3445006,19,'1995-8-31','PRIJEM',NULL,214.40,43960.60,'UROK',NULL,NULL);
insert into tab_trans values (4961,3445007,19,'1995-9-30','PRIJEM',NULL,98.00,16839.90,'UROK',NULL,NULL);
insert into tab_trans values (4961,3445008,19,'1995-10-31','PRIJEM',NULL,84.30,20146.70,'UROK',NULL,NULL);
insert into tab_trans values (4961,3445009,19,'1995-11-30','PRIJEM',NULL,76.30,3669.10,'UROK',NULL,NULL);
insert into tab_trans values (4961,3445010,19,'1995-12-31','PRIJEM',NULL,80.70,26500.00,'UROK',NULL,NULL);
insert into tab_trans values (4961,3445011,19,'1996-1-31','PRIJEM',NULL,85.50,3709.90,'UROK',NULL,NULL);
insert into tab_trans values (4961,3445012,19,'1996-2-29','PRIJEM',NULL,60.90,19681.90,'UROK',NULL,NULL);
insert into tab_trans values (4961,3445013,19,'1996-3-31','PRIJEM',NULL,83.80,16245.90,'UROK',NULL,NULL);
insert into tab_trans values (4961,3681168,19,'1995-4-30','PRIJEM',NULL,47.10,16233.10,'UROK',NULL,NULL);
insert into tab_trans values (4961,3681169,19,'1995-5-31','PRIJEM',NULL,125.20,35897.40,'UROK',NULL,NULL);
insert into tab_trans values (4961,3681170,19,'1995-6-30','PRIJEM',NULL,207.20,56037.70,'UROK',NULL,NULL);
insert into tab_trans values (4961,3681171,19,'1995-7-31','PRIJEM',NULL,237.10,57920.70,'UROK',NULL,NULL);
insert into tab_trans values (4961,3681172,19,'1995-8-31','PRIJEM',NULL,214.70,43746.20,'UROK',NULL,NULL);
insert into tab_trans values (4961,3681173,19,'1995-9-30','PRIJEM',NULL,98.00,16937.90,'UROK',NULL,NULL);
insert into tab_trans values (4961,3681174,19,'1995-10-31','PRIJEM',NULL,121.70,20268.30,'UROK',NULL,NULL);
insert into tab_trans values (4961,3681175,19,'1995-11-30','PRIJEM',NULL,76.10,3745.10,'UROK',NULL,NULL);
insert into tab_trans values (4961,3681176,19,'1995-12-31','PRIJEM',NULL,80.80,26419.30,'UROK',NULL,NULL);
insert into tab_trans values (4961,3681177,19,'1996-1-31','PRIJEM',NULL,86.80,3796.70,'UROK',NULL,NULL);
insert into tab_trans values (4961,3681178,19,'1996-2-29','PRIJEM',NULL,55.90,19737.80,'UROK',NULL,NULL);
insert into tab_trans values (4961,3681179,19,'1996-3-31','PRIJEM',NULL,83.60,16329.60,'UROK',NULL,NULL);
insert into tab_trans values (4962,6145,25,'1996-7-28','PRIJEM','VKLAD',900.00,900.00,NULL,NULL,NULL);
insert into tab_trans values (4962,6150,25,'1996-9-3','PRIJEM','VKLAD',13067.00,29767.00,NULL,NULL,NULL);
insert into tab_trans values (4962,6151,25,'1996-11-10','PRIJEM','VKLAD',19946.00,86326.00,NULL,NULL,NULL);
insert into tab_trans values (4962,6152,25,'1996-12-16','PRIJEM','VKLAD',48955.00,103446.50,NULL,NULL,NULL);
insert into tab_trans values (4962,6154,25,'1996-11-7','PRIJEM','VKLAD',48119.00,113444.00,NULL,NULL,NULL);
insert into tab_trans values (4962,6156,25,'1996-11-29','PRIJEM','VKLAD',29361.00,68871.00,NULL,NULL,NULL);
insert into tab_trans values (4962,6158,25,'1996-9-6','PRIJEM','VKLAD',41759.00,113580.00,NULL,NULL,NULL);
insert into tab_trans values (4962,6162,25,'1996-10-3','PRIJEM','VKLAD',22573.00,80709.50,NULL,NULL,NULL);
insert into tab_trans values (4962,6163,25,'1996-12-10','PRIJEM','VKLAD',25125.00,77338.50,NULL,NULL,NULL);
insert into tab_trans values (4962,6164,25,'1996-12-9','PRIJEM','VKLAD',47179.00,115113.50,NULL,NULL,NULL);
insert into tab_trans values (4962,6166,25,'1996-11-15','PRIJEM','VKLAD',31101.00,109110.00,NULL,NULL,NULL);
insert into tab_trans values (4962,6167,25,'1996-11-6','PRIJEM','VKLAD',29145.00,116735.00,NULL,NULL,NULL);
insert into tab_trans values (4962,6168,25,'1996-9-25','PRIJEM','VKLAD',13794.00,91374.00,NULL,NULL,NULL);
insert into tab_trans values (4962,6171,25,'1996-9-5','PRIJEM','VKLAD',42054.00,71821.00,NULL,NULL,NULL);
insert into tab_trans values (4962,6173,25,'1996-10-28','PRIJEM','VKLAD',40895.00,87313.50,NULL,NULL,NULL);
insert into tab_trans values (4962,6175,25,'1997-4-7','PRIJEM','VKLAD',39433.00,111484.70,NULL,NULL,NULL);
insert into tab_trans values (4962,6176,25,'1997-5-9','PRIJEM','VKLAD',8802.00,61961.80,NULL,NULL,NULL);
insert into tab_trans values (4962,6177,25,'1997-5-3','PRIJEM','VKLAD',18951.00,54433.80,NULL,NULL,NULL);
insert into tab_trans values (4962,6178,25,'1997-6-9','PRIJEM','VKLAD',5271.00,71718.70,NULL,NULL,NULL);
insert into tab_trans values (4962,6179,25,'1997-2-6','PRIJEM','VKLAD',39485.00,82186.40,NULL,NULL,NULL);
insert into tab_trans values (4962,6180,25,'1997-5-28','PRIJEM','VKLAD',30931.00,88129.80,NULL,NULL,NULL);
insert into tab_trans values (4962,6181,25,'1997-10-23','PRIJEM','VKLAD',8094.00,64548.10,NULL,NULL,NULL);
insert into tab_trans values (4962,6182,25,'1997-9-17','PRIJEM','VKLAD',42433.00,86810.10,NULL,NULL,NULL);
insert into tab_trans values (4962,6183,25,'1997-9-1','PRIJEM','VKLAD',12761.00,55068.10,NULL,NULL,NULL);
insert into tab_trans values (4962,6184,25,'1997-4-5','PRIJEM','VKLAD',49734.00,73161.70,NULL,NULL,NULL);
insert into tab_trans values (4962,6185,25,'1997-11-20','PRIJEM','VKLAD',36216.00,119652.70,NULL,NULL,NULL);
insert into tab_trans values (4962,6186,25,'1997-2-2','PRIJEM','VKLAD',15549.00,44901.40,NULL,NULL,NULL);
insert into tab_trans values (4962,6187,25,'1997-1-11','PRIJEM','VKLAD',41021.00,92783.50,NULL,NULL,NULL);
insert into tab_trans values (4962,6188,25,'1997-5-10','PRIJEM','VKLAD',36054.00,98015.80,NULL,NULL,NULL);
insert into tab_trans values (4962,6189,25,'1997-7-26','PRIJEM','VKLAD',20895.00,51678.30,NULL,NULL,NULL);
insert into tab_trans values (4962,6190,25,'1997-7-6','PRIJEM','VKLAD',37842.00,72774.30,NULL,NULL,NULL);
insert into tab_trans values (4962,6191,25,'1997-9-27','PRIJEM','VKLAD',18292.00,71502.10,NULL,NULL,NULL);
insert into tab_trans values (4962,6192,25,'1997-10-11','PRIJEM','VKLAD',26124.00,87154.10,NULL,NULL,NULL);
insert into tab_trans values (4962,6193,25,'1997-8-9','PRIJEM','VKLAD',18228.00,66723.80,NULL,NULL,NULL);
insert into tab_trans values (4962,6194,25,'1997-10-29','PRIJEM','VKLAD',29180.00,91228.10,NULL,NULL,NULL);
insert into tab_trans values (4962,6222,25,'1996-10-7','VYDAJ','VYBER',2400.00,77199.50,NULL,NULL,'0');
insert into tab_trans values (4962,6223,25,'1996-11-11','VYDAJ','VYBER',1500.00,78009.00,NULL,NULL,'0');
insert into tab_trans values (4962,6224,25,'1996-12-20','VYDAJ','VYBER',1900.00,101546.50,NULL,NULL,'0');
insert into tab_trans values (4962,6225,25,'1997-1-22','VYDAJ','VYBER',2000.00,47915.50,NULL,NULL,'0');
insert into tab_trans values (4962,6226,25,'1997-2-3','VYDAJ','VYBER',2200.00,42701.40,NULL,NULL,'0');
insert into tab_trans values (4962,6227,25,'1997-3-25','VYDAJ','VYBER',3200.00,26207.50,NULL,NULL,'0');
insert into tab_trans values (4962,6228,25,'1997-3-31','VYDAJ','VYBER',2900.00,23427.70,NULL,NULL,'0');
insert into tab_trans values (4962,6229,25,'1997-5-2','VYDAJ','VYBER',1600.00,35482.80,NULL,NULL,'0');
insert into tab_trans values (4962,6230,25,'1997-6-4','VYDAJ','VYBER',1800.00,75221.70,NULL,NULL,'0');
insert into tab_trans values (4962,6231,25,'1997-7-10','VYDAJ','VYBER',1700.00,52783.30,NULL,NULL,'0');
insert into tab_trans values (4962,6232,25,'1997-7-28','VYDAJ','VYBER',2100.00,49578.30,NULL,NULL,'0');
insert into tab_trans values (4962,6233,25,'1997-9-9','VYDAJ','VYBER',2600.00,51194.10,NULL,NULL,'0');
insert into tab_trans values (4962,6234,25,'1997-10-10','VYDAJ','VYBER',2600.00,61030.10,NULL,NULL,'0');
insert into tab_trans values (4962,6235,25,'1997-10-27','VYDAJ','VYBER',2500.00,62048.10,NULL,NULL,'0');
insert into tab_trans values (4962,6258,25,'1996-10-10','VYDAJ','PREVOD NA UCET',6817.00,70218.50,'SIPO','IJ','4896235');
insert into tab_trans values (4962,6259,25,'1996-11-10','VYDAJ','PREVOD NA UCET',6817.00,79509.00,'SIPO','IJ','4896235');
insert into tab_trans values (4962,6260,25,'1996-12-10','VYDAJ','PREVOD NA UCET',6817.00,70521.50,'SIPO','IJ','4896235');
insert into tab_trans values (4962,6261,25,'1997-1-10','VYDAJ','PREVOD NA UCET',6817.00,51762.50,'SIPO','IJ','4896235');
insert into tab_trans values (4962,6262,25,'1997-2-10','VYDAJ','PREVOD NA UCET',6817.00,74095.40,'SIPO','IJ','4896235');
insert into tab_trans values (4962,6263,25,'1997-3-10','VYDAJ','PREVOD NA UCET',6817.00,31007.50,'SIPO','IJ','4896235');
insert into tab_trans values (4962,6264,25,'1997-4-10','VYDAJ','PREVOD NA UCET',6817.00,77303.70,'SIPO','IJ','4896235');
insert into tab_trans values (4962,6265,25,'1997-5-10','VYDAJ','PREVOD NA UCET',6817.00,91198.80,'SIPO','IJ','4896235');
insert into tab_trans values (4962,6266,25,'1997-6-10','VYDAJ','PREVOD NA UCET',6817.00,64901.70,'SIPO','IJ','4896235');
insert into tab_trans values (4962,6267,25,'1997-7-10','VYDAJ','PREVOD NA UCET',6817.00,54483.30,'SIPO','IJ','4896235');
insert into tab_trans values (4962,6268,25,'1997-8-10','VYDAJ','PREVOD NA UCET',6817.00,59906.80,'SIPO','IJ','4896235');
insert into tab_trans values (4962,6269,25,'1997-9-10','VYDAJ','PREVOD NA UCET',6817.00,44377.10,'SIPO','IJ','4896235');
insert into tab_trans values (4962,6270,25,'1997-10-10','VYDAJ','PREVOD NA UCET',6817.00,63630.10,'SIPO','IJ','4896235');
insert into tab_trans values (4962,6271,25,'1997-11-10','VYDAJ','PREVOD NA UCET',6817.00,83436.70,'SIPO','IJ','4896235');
insert into tab_trans values (4962,6294,25,'1996-10-6','VYDAJ','PREVOD NA UCET',1110.00,79599.50,NULL,'AB','79838293');
insert into tab_trans values (4962,6295,25,'1996-11-6','VYDAJ','PREVOD NA UCET',1110.00,65325.00,NULL,'AB','79838293');
insert into tab_trans values (4962,6296,25,'1996-12-6','VYDAJ','PREVOD NA UCET',1110.00,68098.50,NULL,'AB','79838293');
insert into tab_trans values (4962,6297,25,'1997-1-6','VYDAJ','PREVOD NA UCET',1110.00,58743.50,NULL,'AB','79838293');
insert into tab_trans values (4962,6298,25,'1997-2-6','VYDAJ','PREVOD NA UCET',1110.00,81076.40,NULL,'AB','79838293');
insert into tab_trans values (4962,6299,25,'1997-3-6','VYDAJ','PREVOD NA UCET',1110.00,37988.50,NULL,'AB','79838293');
insert into tab_trans values (4962,6300,25,'1997-4-6','VYDAJ','PREVOD NA UCET',1110.00,72051.70,NULL,'AB','79838293');
insert into tab_trans values (4962,6301,25,'1997-5-6','VYDAJ','PREVOD NA UCET',1110.00,53323.80,NULL,'AB','79838293');
insert into tab_trans values (4962,6302,25,'1997-6-6','VYDAJ','PREVOD NA UCET',1110.00,74111.70,NULL,'AB','79838293');
insert into tab_trans values (4962,6303,25,'1997-7-6','VYDAJ','PREVOD NA UCET',1110.00,71664.30,NULL,'AB','79838293');
insert into tab_trans values (4962,6304,25,'1997-8-6','VYDAJ','PREVOD NA UCET',1110.00,48659.80,NULL,'AB','79838293');
insert into tab_trans values (4962,6305,25,'1997-9-6','VYDAJ','PREVOD NA UCET',1110.00,53958.10,NULL,'AB','79838293');
insert into tab_trans values (4962,6306,25,'1997-10-6','VYDAJ','PREVOD NA UCET',1110.00,70611.10,NULL,'AB','79838293');
insert into tab_trans values (4962,6307,25,'1997-11-6','VYDAJ','PREVOD NA UCET',1110.00,90417.70,NULL,'AB','79838293');
insert into tab_trans values (4962,6308,25,'1997-12-6','VYDAJ','PREVOD NA UCET',1110.00,31621.90,NULL,'AB','79838293');
insert into tab_trans values (4962,6330,25,'1996-10-8','VYDAJ','PREVOD NA UCET',164.00,77035.50,'POJISTNE','WX','52864879');
insert into tab_trans values (4962,6331,25,'1996-11-8','VYDAJ','PREVOD NA UCET',164.00,66380.00,'POJISTNE','WX','52864879');
insert into tab_trans values (4962,6332,25,'1996-12-8','VYDAJ','PREVOD NA UCET',164.00,67934.50,'POJISTNE','WX','52864879');
insert into tab_trans values (4962,6333,25,'1997-1-8','VYDAJ','PREVOD NA UCET',164.00,58579.50,'POJISTNE','WX','52864879');
insert into tab_trans values (4962,6334,25,'1997-2-8','VYDAJ','PREVOD NA UCET',164.00,80912.40,'POJISTNE','WX','52864879');
insert into tab_trans values (4962,6335,25,'1997-3-8','VYDAJ','PREVOD NA UCET',164.00,37824.50,'POJISTNE','WX','52864879');
insert into tab_trans values (4962,6336,25,'1997-4-8','VYDAJ','PREVOD NA UCET',164.00,84120.70,'POJISTNE','WX','52864879');
insert into tab_trans values (4962,6337,25,'1997-5-8','VYDAJ','PREVOD NA UCET',164.00,53159.80,'POJISTNE','WX','52864879');
insert into tab_trans values (4962,6338,25,'1997-6-8','VYDAJ','PREVOD NA UCET',164.00,66447.70,'POJISTNE','WX','52864879');
insert into tab_trans values (4962,6339,25,'1997-7-8','VYDAJ','PREVOD NA UCET',164.00,61300.30,'POJISTNE','WX','52864879');
insert into tab_trans values (4962,6340,25,'1997-8-8','VYDAJ','PREVOD NA UCET',164.00,48495.80,'POJISTNE','WX','52864879');
insert into tab_trans values (4962,6341,25,'1997-9-8','VYDAJ','PREVOD NA UCET',164.00,53794.10,'POJISTNE','WX','52864879');
insert into tab_trans values (4962,6342,25,'1997-10-8','VYDAJ','PREVOD NA UCET',164.00,70447.10,'POJISTNE','WX','52864879');
insert into tab_trans values (4962,6343,25,'1997-11-8','VYDAJ','PREVOD NA UCET',164.00,90253.70,'POJISTNE','WX','52864879');
insert into tab_trans values (4962,6358,25,'1996-12-12','VYBER','VYBER',16030.00,54491.50,NULL,NULL,NULL);
insert into tab_trans values (4962,6368,25,'1997-1-18','VYBER','VYBER',3627.00,82315.50,NULL,NULL,NULL);
insert into tab_trans values (4962,6369,25,'1997-1-11','VYBER','VYBER',3841.00,88942.50,NULL,NULL,NULL);
insert into tab_trans values (4962,6370,25,'1997-12-2','VYBER','VYBER',7278.00,32731.90,NULL,NULL,NULL);
insert into tab_trans values (4962,6372,25,'1997-2-20','VYBER','VYBER',22926.00,51169.40,NULL,NULL,NULL);
insert into tab_trans values (4962,6373,25,'1997-4-15','VYBER','VYBER',13141.00,64162.70,NULL,NULL,NULL);
insert into tab_trans values (4962,6383,25,'1997-6-22','VYDAJ','VYBER',16800.00,48101.70,NULL,NULL,NULL);
insert into tab_trans values (4962,6386,25,'1997-1-19','VYDAJ','VYBER',7800.00,58615.50,NULL,NULL,NULL);
insert into tab_trans values (4962,6388,25,'1996-12-27','VYDAJ','VYBER',2400.00,62846.50,NULL,NULL,NULL);
insert into tab_trans values (4962,6397,25,'1997-1-17','VYDAJ','VYBER',3000.00,85942.50,NULL,NULL,NULL);
insert into tab_trans values (4962,6398,25,'1997-1-19','VYDAJ','VYBER',7500.00,66415.50,NULL,NULL,NULL);
insert into tab_trans values (4962,6399,25,'1997-1-19','VYDAJ','VYBER',8400.00,73915.50,NULL,NULL,NULL);
insert into tab_trans values (4962,6400,25,'1997-1-29','VYDAJ','VYBER',7800.00,29115.50,NULL,NULL,NULL);
insert into tab_trans values (4962,6401,25,'1997-1-21','VYDAJ','VYBER',8700.00,49915.50,NULL,NULL,NULL);
insert into tab_trans values (4962,6402,25,'1997-1-1','VYDAJ','VYBER',3300.00,59853.50,NULL,NULL,NULL);
insert into tab_trans values (4962,6412,25,'1997-5-29','VYDAJ','VYBER',11400.00,76729.80,NULL,NULL,NULL);
insert into tab_trans values (4962,6413,25,'1997-6-7','VYDAJ','VYBER',7500.00,66611.70,NULL,NULL,NULL);
insert into tab_trans values (4962,6414,25,'1997-7-25','VYDAJ','VYBER',6900.00,30783.30,NULL,NULL,NULL);
insert into tab_trans values (4962,6415,25,'1997-4-29','VYDAJ','VYBER',5700.00,36862.70,NULL,NULL,NULL);
insert into tab_trans values (4962,6417,25,'1997-7-6','VYDAJ','VYBER',10200.00,61464.30,NULL,NULL,NULL);
insert into tab_trans values (4962,6430,25,'1996-10-31','VYDAJ','VYBER',14.60,87590.00,'SLUZBY',NULL,NULL);
insert into tab_trans values (4962,6431,25,'1996-11-30','VYDAJ','VYBER',14.60,69208.50,'SLUZBY',NULL,NULL);
insert into tab_trans values (4962,6432,25,'1996-12-31','VYDAJ','VYBER',14.60,63153.50,'SLUZBY',NULL,NULL);
insert into tab_trans values (4962,6433,25,'1997-1-31','VYDAJ','VYBER',14.60,29352.40,'SLUZBY',NULL,NULL);
insert into tab_trans values (4962,6434,25,'1997-2-28','VYDAJ','VYBER',14.60,39098.50,'SLUZBY',NULL,NULL);
insert into tab_trans values (4962,6435,25,'1997-3-31','VYDAJ','VYBER',14.60,26327.70,'SLUZBY',NULL,NULL);
insert into tab_trans values (4962,6436,25,'1997-4-30','VYDAJ','VYBER',14.60,37082.80,'SLUZBY',NULL,NULL);
insert into tab_trans values (4962,6437,25,'1997-5-31','VYDAJ','VYBER',14.60,77021.70,'SLUZBY',NULL,NULL);
insert into tab_trans values (4962,6438,25,'1997-6-30','VYDAJ','VYBER',14.60,34932.30,'SLUZBY',NULL,NULL);
insert into tab_trans values (4962,6439,25,'1997-7-31','VYDAJ','VYBER',14.60,49769.80,'SLUZBY',NULL,NULL);
insert into tab_trans values (4962,6440,25,'1997-8-31','VYDAJ','VYBER',14.60,42307.10,'SLUZBY',NULL,NULL);
insert into tab_trans values (4962,6441,25,'1997-9-30','VYDAJ','VYBER',14.60,71721.10,'SLUZBY',NULL,NULL);
insert into tab_trans values (4962,6442,25,'1997-10-31','VYDAJ','VYBER',14.60,91527.70,'SLUZBY',NULL,NULL);
insert into tab_trans values (4962,6443,25,'1997-11-30','VYDAJ','VYBER',14.60,40009.90,'SLUZBY',NULL,NULL);
insert into tab_trans values (4962,6456,25,'1996-8-27','PRIJEM','VKLAD',15800.00,16700.00,NULL,NULL,NULL);
insert into tab_trans values (4962,6457,25,'1996-9-6','VYDAJ','VYBER',36000.00,77580.00,NULL,NULL,NULL);
insert into tab_trans values (4962,6458,25,'1996-9-26','VYDAJ','VYBER',33600.00,57774.00,NULL,NULL,NULL);
insert into tab_trans values (4962,6459,25,'1996-10-26','VYDAJ','VYBER',23800.00,46418.50,NULL,NULL,NULL);
insert into tab_trans values (4962,6460,25,'1996-11-6','VYDAJ','VYBER',50300.00,66435.00,NULL,NULL,NULL);
insert into tab_trans values (4962,6461,25,'1996-11-7','VYDAJ','VYBER',46900.00,66544.00,NULL,NULL,NULL);
insert into tab_trans values (4962,6462,25,'1996-11-15','VYDAJ','VYBER',62800.00,46310.00,NULL,NULL,NULL);
insert into tab_trans values (4962,6463,25,'1996-11-25','VYDAJ','VYBER',6800.00,39510.00,NULL,NULL,NULL);
insert into tab_trans values (4962,6464,25,'1996-12-9','VYDAJ','VYBER',62900.00,52213.50,NULL,NULL,NULL);
insert into tab_trans values (4962,6465,25,'1996-12-25','VYDAJ','VYBER',36300.00,65246.50,NULL,NULL,NULL);
insert into tab_trans values (4962,6466,25,'1997-1-24','VYDAJ','VYBER',11000.00,36915.50,NULL,NULL,NULL);
insert into tab_trans values (4962,6467,25,'1997-2-23','VYDAJ','VYBER',12300.00,38869.40,NULL,NULL,NULL);
insert into tab_trans values (4962,6468,25,'1997-3-25','VYDAJ','VYBER',1600.00,29407.50,NULL,NULL,NULL);
insert into tab_trans values (4962,6469,25,'1997-4-7','VYDAJ','VYBER',27200.00,84284.70,NULL,NULL,NULL);
insert into tab_trans values (4962,6470,25,'1997-4-24','VYDAJ','VYBER',21600.00,42562.70,NULL,NULL,NULL);
insert into tab_trans values (4962,6471,25,'1997-5-24','VYDAJ','VYBER',34000.00,57198.80,NULL,NULL,NULL);
insert into tab_trans values (4962,6472,25,'1997-6-23','VYDAJ','VYBER',13400.00,34701.70,NULL,NULL,NULL);
insert into tab_trans values (4962,6473,25,'1997-7-23','VYDAJ','VYBER',15100.00,37683.30,NULL,NULL,NULL);
insert into tab_trans values (4962,6474,25,'1997-8-22','VYDAJ','VYBER',17800.00,42106.80,NULL,NULL,NULL);
insert into tab_trans values (4962,6475,25,'1997-9-21','VYDAJ','VYBER',33600.00,53210.10,NULL,NULL,NULL);
insert into tab_trans values (4962,6476,25,'1997-10-21','VYDAJ','VYBER',30700.00,56454.10,NULL,NULL,NULL);
insert into tab_trans values (4962,6477,25,'1997-11-20','VYDAJ','VYBER',59200.00,39652.70,NULL,NULL,NULL);
insert into tab_trans values (4962,6478,25,'1997-11-20','VYDAJ','VYBER',20800.00,98852.70,NULL,NULL,NULL);
insert into tab_trans values (4962,3531117,25,'1996-9-30','PRIJEM',NULL,362.50,58136.50,'UROK',NULL,NULL);
insert into tab_trans values (4962,3531118,25,'1996-10-31','PRIJEM',NULL,291.10,87604.60,'UROK',NULL,NULL);
insert into tab_trans values (4962,3531119,25,'1996-11-30','PRIJEM',NULL,352.10,69223.10,'UROK',NULL,NULL);
insert into tab_trans values (4962,3531120,25,'1996-12-31','PRIJEM',NULL,321.70,63168.10,'UROK',NULL,NULL);
insert into tab_trans values (4962,3531121,25,'1997-1-31','PRIJEM',NULL,251.50,29367.00,'UROK',NULL,NULL);
insert into tab_trans values (4962,3531122,25,'1997-2-28','PRIJEM',NULL,243.70,39113.10,'UROK',NULL,NULL);
insert into tab_trans values (4962,3531123,25,'1997-3-31','PRIJEM',NULL,134.80,26342.30,'UROK',NULL,NULL);
insert into tab_trans values (4962,3531124,25,'1997-4-30','PRIJEM',NULL,234.70,37097.40,'UROK',NULL,NULL);
insert into tab_trans values (4962,3531125,25,'1997-5-31','PRIJEM',NULL,306.50,77036.30,'UROK',NULL,NULL);
insert into tab_trans values (4962,3531126,25,'1997-6-30','PRIJEM',NULL,245.20,34946.90,'UROK',NULL,NULL);
insert into tab_trans values (4962,3531127,25,'1997-7-31','PRIJEM',NULL,206.00,49784.40,'UROK',NULL,NULL);
insert into tab_trans values (4962,3531128,25,'1997-8-31','PRIJEM',NULL,214.90,42321.70,'UROK',NULL,NULL);
insert into tab_trans values (4962,3531129,25,'1997-9-30','PRIJEM',NULL,233.60,71735.70,'UROK',NULL,NULL);
insert into tab_trans values (4962,3531130,25,'1997-10-31','PRIJEM',NULL,314.20,91542.30,'UROK',NULL,NULL);
insert into tab_trans values (4962,3531131,25,'1997-11-30','PRIJEM',NULL,371.80,40024.50,'UROK',NULL,NULL);
insert into tab_trans values (4967,11043,37,'1997-8-18','PRIJEM','VKLAD',900.00,900.00,NULL,NULL,NULL);
insert into tab_trans values (4967,11045,37,'1997-11-1','PRIJEM','VKLAD',11660.00,46867.70,NULL,NULL,NULL);
insert into tab_trans values (4967,11046,37,'1997-11-28','PRIJEM','VKLAD',37413.00,69482.70,NULL,NULL,NULL);
insert into tab_trans values (4967,11048,37,'1997-12-30','PRIJEM','VKLAD',21018.00,62472.40,NULL,NULL,NULL);
insert into tab_trans values (4967,11049,37,'1997-9-11','PRIJEM','VKLAD',38257.00,94491.80,NULL,NULL,NULL);
insert into tab_trans values (4967,11052,37,'1997-8-22','PRIJEM','VKLAD',21538.00,56150.00,NULL,NULL,NULL);
insert into tab_trans values (4967,11054,37,'1997-8-20','PRIJEM','VKLAD',33712.00,34612.00,NULL,NULL,NULL);
insert into tab_trans values (4967,11058,37,'1997-9-17','PRIJEM','VKLAD',7878.00,102369.80,NULL,NULL,NULL);
insert into tab_trans values (4967,11059,37,'1998-3-5','PRIJEM','VKLAD',47001.00,64178.50,NULL,NULL,NULL);
insert into tab_trans values (4967,11060,37,'1998-7-11','PRIJEM','VKLAD',7585.00,17051.90,NULL,NULL,NULL);
insert into tab_trans values (4967,11061,37,'1998-8-14','PRIJEM','VKLAD',47785.00,46773.80,NULL,NULL,NULL);
insert into tab_trans values (4967,11062,37,'1998-3-27','PRIJEM','VKLAD',26615.00,79392.50,NULL,NULL,NULL);
insert into tab_trans values (4967,11063,37,'1998-4-19','PRIJEM','VKLAD',11830.00,40303.90,NULL,NULL,NULL);
insert into tab_trans values (4967,11064,37,'1998-3-9','PRIJEM','VKLAD',42997.00,104761.50,NULL,NULL,NULL);
insert into tab_trans values (4967,11065,37,'1998-5-12','PRIJEM','VKLAD',24116.00,72886.20,NULL,NULL,NULL);
insert into tab_trans values (4967,11066,37,'1998-4-29','PRIJEM','VKLAD',17195.00,57498.90,NULL,NULL,NULL);
insert into tab_trans values (4967,11068,37,'1998-9-20','PRIJEM','VKLAD',42957.00,49186.10,NULL,NULL,NULL);
insert into tab_trans values (4967,11079,37,'1997-11-5','VYDAJ','VYBER',6700.00,40167.70,NULL,NULL,'0');
insert into tab_trans values (4967,11080,37,'1997-12-14','VYDAJ','VYBER',4500.00,60154.40,NULL,NULL,'0');
insert into tab_trans values (4967,11081,37,'1998-1-14','VYDAJ','VYBER',4500.00,35186.70,NULL,NULL,'0');
insert into tab_trans values (4967,11082,37,'1998-2-7','VYDAJ','VYBER',5500.00,17518.30,NULL,NULL,'0');
insert into tab_trans values (4967,11083,37,'1998-3-11','VYDAJ','VYBER',6200.00,95977.50,NULL,NULL,'0');
insert into tab_trans values (4967,11084,37,'1998-4-5','VYDAJ','VYBER',5800.00,49871.90,NULL,NULL,'0');
insert into tab_trans values (4967,11085,37,'1998-5-17','VYDAJ','VYBER',5100.00,39286.20,NULL,NULL,'0');
insert into tab_trans values (4967,11086,37,'1998-6-18','VYDAJ','VYBER',7000.00,14375.40,NULL,NULL,'0');
insert into tab_trans values (4967,11087,37,'1998-7-19','VYDAJ','VYBER',6200.00,9051.90,NULL,NULL,'0');
insert into tab_trans values (4967,11088,37,'1998-8-13','VYDAJ','VYBER',5100.00,-1011.20,NULL,NULL,'0');
insert into tab_trans values (4967,11089,37,'1998-8-29','VYDAJ','VYBER',7300.00,15469.80,NULL,NULL,'0');
insert into tab_trans values (4967,11090,37,'1998-10-6','VYDAJ','VYBER',3200.00,32565.80,NULL,NULL,'0');
insert into tab_trans values (4967,11103,37,'1997-11-8','VYDAJ','PREVOD NA UCET',2317.00,37753.70,'SIPO','IJ','29728555');
insert into tab_trans values (4967,11104,37,'1997-12-8','VYDAJ','PREVOD NA UCET',2317.00,67238.40,'SIPO','IJ','29728555');
insert into tab_trans values (4967,11105,37,'1998-1-8','VYDAJ','PREVOD NA UCET',2317.00,53070.70,'SIPO','IJ','29728555');
insert into tab_trans values (4967,11106,37,'1998-2-8','VYDAJ','PREVOD NA UCET',2317.00,15104.30,'SIPO','IJ','29728555');
insert into tab_trans values (4967,11107,37,'1998-3-8','VYDAJ','PREVOD NA UCET',2317.00,61764.50,'SIPO','IJ','29728555');
insert into tab_trans values (4967,11108,37,'1998-4-8','VYDAJ','PREVOD NA UCET',2317.00,47457.90,'SIPO','IJ','29728555');
insert into tab_trans values (4967,11109,37,'1998-5-8','VYDAJ','PREVOD NA UCET',2317.00,55254.20,'SIPO','IJ','29728555');
insert into tab_trans values (4967,11110,37,'1998-6-8','VYDAJ','PREVOD NA UCET',2317.00,37059.40,'SIPO','IJ','29728555');
insert into tab_trans values (4967,11111,37,'1998-7-8','VYDAJ','PREVOD NA UCET',2317.00,12050.90,'SIPO','IJ','29728555');
insert into tab_trans values (4967,11112,37,'1998-8-8','VYDAJ','PREVOD NA UCET',2317.00,6672.80,'SIPO','IJ','29728555');
insert into tab_trans values (4967,11113,37,'1998-9-8','VYDAJ','PREVOD NA UCET',2317.00,13113.10,'SIPO','IJ','29728555');
insert into tab_trans values (4967,11114,37,'1998-10-8','VYDAJ','PREVOD NA UCET',2317.00,30151.80,'SIPO','IJ','29728555');
insert into tab_trans values (4967,11127,37,'1997-11-9','VYDAJ','PREVOD NA UCET',2584.00,35169.70,NULL,'OP','23782724');
insert into tab_trans values (4967,11128,37,'1997-12-9','VYDAJ','PREVOD NA UCET',2584.00,64654.40,NULL,'OP','23782724');
insert into tab_trans values (4967,11129,37,'1998-1-9','VYDAJ','PREVOD NA UCET',2584.00,46586.70,NULL,'OP','23782724');
insert into tab_trans values (4967,11130,37,'1998-2-9','VYDAJ','PREVOD NA UCET',2584.00,12520.30,NULL,'OP','23782724');
insert into tab_trans values (4967,11131,37,'1998-3-9','VYDAJ','PREVOD NA UCET',2584.00,102177.50,NULL,'OP','23782724');
insert into tab_trans values (4967,11132,37,'1998-4-9','VYDAJ','PREVOD NA UCET',2584.00,44873.90,NULL,'OP','23782724');
insert into tab_trans values (4967,11133,37,'1998-5-9','VYDAJ','PREVOD NA UCET',2584.00,52670.20,NULL,'OP','23782724');
insert into tab_trans values (4967,11134,37,'1998-6-9','VYDAJ','PREVOD NA UCET',2584.00,34475.40,NULL,'OP','23782724');
insert into tab_trans values (4967,11135,37,'1998-7-9','VYDAJ','PREVOD NA UCET',2584.00,9466.90,NULL,'OP','23782724');
insert into tab_trans values (4967,11136,37,'1998-8-9','VYDAJ','PREVOD NA UCET',2584.00,4088.80,NULL,'OP','23782724');
insert into tab_trans values (4967,11137,37,'1998-9-9','VYDAJ','PREVOD NA UCET',2584.00,10529.10,NULL,'OP','23782724');
insert into tab_trans values (4967,11138,37,'1998-10-9','VYDAJ','PREVOD NA UCET',2584.00,27567.80,NULL,'OP','23782724');
insert into tab_trans values (4967,11151,37,'1997-11-7','VYDAJ','PREVOD NA UCET',97.00,40070.70,'POJISTNE','YZ','89609831');
insert into tab_trans values (4967,11152,37,'1997-12-7','VYDAJ','PREVOD NA UCET',97.00,69555.40,'POJISTNE','YZ','89609831');
insert into tab_trans values (4967,11153,37,'1998-1-7','VYDAJ','PREVOD NA UCET',97.00,55387.70,'POJISTNE','YZ','89609831');
insert into tab_trans values (4967,11154,37,'1998-2-7','VYDAJ','PREVOD NA UCET',97.00,17421.30,'POJISTNE','YZ','89609831');
insert into tab_trans values (4967,11155,37,'1998-3-7','VYDAJ','PREVOD NA UCET',97.00,64081.50,'POJISTNE','YZ','89609831');
insert into tab_trans values (4967,11156,37,'1998-4-7','VYDAJ','PREVOD NA UCET',97.00,49774.90,'POJISTNE','YZ','89609831');
insert into tab_trans values (4967,11157,37,'1998-5-7','VYDAJ','PREVOD NA UCET',97.00,57571.20,'POJISTNE','YZ','89609831');
insert into tab_trans values (4967,11158,37,'1998-6-7','VYDAJ','PREVOD NA UCET',97.00,39376.40,'POJISTNE','YZ','89609831');
insert into tab_trans values (4967,11159,37,'1998-7-7','VYDAJ','PREVOD NA UCET',97.00,14367.90,'POJISTNE','YZ','89609831');
insert into tab_trans values (4967,11160,37,'1998-8-7','VYDAJ','PREVOD NA UCET',97.00,8989.80,'POJISTNE','YZ','89609831');
insert into tab_trans values (4967,11161,37,'1998-9-7','VYDAJ','PREVOD NA UCET',97.00,15430.10,'POJISTNE','YZ','89609831');
insert into tab_trans values (4967,11162,37,'1998-10-7','VYDAJ','PREVOD NA UCET',97.00,32468.80,'POJISTNE','YZ','89609831');
insert into tab_trans values (4967,11173,37,'1998-8-17','VYBER','VYBER',24004.00,22769.80,NULL,NULL,NULL);
insert into tab_trans values (4967,11175,37,'1998-3-29','VYBER','VYBER',17651.00,61741.50,NULL,NULL,NULL);
insert into tab_trans values (4967,11181,37,'1997-12-30','VYDAJ','VYBER',7200.00,55272.40,NULL,NULL,NULL);
insert into tab_trans values (4967,11189,37,'1998-1-19','VYDAJ','VYBER',2700.00,22886.70,NULL,NULL,NULL);
insert into tab_trans values (4967,11190,37,'1998-1-12','VYDAJ','VYBER',2400.00,44186.70,NULL,NULL,NULL);
insert into tab_trans values (4967,11193,37,'1998-1-8','VYDAJ','VYBER',3900.00,49170.70,NULL,NULL,NULL);
insert into tab_trans values (4967,11194,37,'1998-1-13','VYDAJ','VYBER',4500.00,39686.70,NULL,NULL,NULL);
insert into tab_trans values (4967,11201,37,'1998-9-26','VYDAJ','VYBER',11400.00,37786.10,NULL,NULL,NULL);
insert into tab_trans values (4967,11202,37,'1998-5-11','VYDAJ','VYBER',3900.00,48770.20,NULL,NULL,NULL);
insert into tab_trans values (4967,11204,37,'1998-3-31','VYDAJ','VYBER',6300.00,55686.50,NULL,NULL,NULL);
insert into tab_trans values (4967,11205,37,'1998-10-4','VYDAJ','VYBER',2100.00,35765.80,NULL,NULL,NULL);
insert into tab_trans values (4967,11217,37,'1997-11-30','VYDAJ','VYBER',14.60,69652.40,'SLUZBY',NULL,NULL);
insert into tab_trans values (4967,11218,37,'1997-12-31','VYDAJ','VYBER',14.60,55484.70,'SLUZBY',NULL,NULL);
insert into tab_trans values (4967,11219,37,'1998-1-31','VYDAJ','VYBER',14.60,23018.30,'SLUZBY',NULL,NULL);
insert into tab_trans values (4967,11220,37,'1998-2-28','VYDAJ','VYBER',14.60,17177.50,'SLUZBY',NULL,NULL);
insert into tab_trans values (4967,11221,37,'1998-3-31','VYDAJ','VYBER',14.60,55671.90,'SLUZBY',NULL,NULL);
insert into tab_trans values (4967,11222,37,'1998-4-30','VYDAJ','VYBER',14.60,57668.20,'SLUZBY',NULL,NULL);
insert into tab_trans values (4967,11223,37,'1998-5-31','VYDAJ','VYBER',14.60,39473.40,'SLUZBY',NULL,NULL);
insert into tab_trans values (4967,11224,37,'1998-6-30','VYDAJ','VYBER',14.60,14464.90,'SLUZBY',NULL,NULL);
insert into tab_trans values (4967,11225,37,'1998-7-31','VYDAJ','VYBER',14.60,9086.80,'SLUZBY',NULL,NULL);
insert into tab_trans values (4967,11226,37,'1998-8-31','VYDAJ','VYBER',14.60,15527.10,'SLUZBY',NULL,NULL);
insert into tab_trans values (4967,11227,37,'1998-9-30','VYDAJ','VYBER',14.60,37865.80,'SLUZBY',NULL,NULL);
insert into tab_trans values (4967,11230,37,'1997-9-17','VYDAJ','VYBER',42400.00,41569.80,NULL,NULL,NULL);
insert into tab_trans values (4967,11231,37,'1997-9-17','VYDAJ','VYBER',18400.00,83969.80,NULL,NULL,NULL);
insert into tab_trans values (4967,11232,37,'1997-10-17','VYDAJ','VYBER',7000.00,34857.80,NULL,NULL,NULL);
insert into tab_trans values (4967,11233,37,'1997-11-16','VYDAJ','VYBER',3100.00,32069.70,NULL,NULL,NULL);
insert into tab_trans values (4967,11234,37,'1997-12-16','VYDAJ','VYBER',18700.00,41454.40,NULL,NULL,NULL);
insert into tab_trans values (4967,11235,37,'1998-1-15','VYDAJ','VYBER',9600.00,25586.70,NULL,NULL,NULL);
insert into tab_trans values (4967,11236,37,'1998-2-14','PRIJEM','VKLAD',4600.00,17120.30,NULL,NULL,NULL);
insert into tab_trans values (4967,11237,37,'1998-3-16','VYDAJ','VYBER',43200.00,52777.50,NULL,NULL,NULL);
insert into tab_trans values (4967,11238,37,'1998-4-15','VYDAJ','VYBER',16400.00,28473.90,NULL,NULL,NULL);
insert into tab_trans values (4967,11239,37,'1998-5-15','VYDAJ','VYBER',28500.00,44386.20,NULL,NULL,NULL);
insert into tab_trans values (4967,11240,37,'1998-6-14','VYDAJ','VYBER',13100.00,21375.40,NULL,NULL,NULL);
insert into tab_trans values (4967,11241,37,'1998-7-14','VYDAJ','VYBER',1800.00,15251.90,NULL,NULL,NULL);
insert into tab_trans values (4967,11242,37,'1998-9-12','VYDAJ','VYBER',4300.00,6229.10,NULL,NULL,NULL);
insert into tab_trans values (4967,11243,37,'1998-10-12','VYDAJ','VYBER',11200.00,16367.80,NULL,NULL,NULL);
insert into tab_trans values (4967,3531675,37,'1997-8-31','PRIJEM',NULL,84.80,56234.80,'UROK',NULL,NULL);
insert into tab_trans values (4967,3531676,37,'1997-9-30','PRIJEM',NULL,288.10,41857.80,'UROK',NULL,NULL);
insert into tab_trans values (4967,3531677,37,'1997-10-31','PRIJEM',NULL,349.90,35207.70,'UROK',NULL,NULL);
insert into tab_trans values (4967,3531678,37,'1997-11-30','PRIJEM',NULL,184.30,69667.00,'UROK',NULL,NULL);
insert into tab_trans values (4967,3531679,37,'1997-12-31','PRIJEM',NULL,226.90,55499.30,'UROK',NULL,NULL);
insert into tab_trans values (4967,3531680,37,'1998-1-31','PRIJEM',NULL,146.20,23032.90,'UROK',NULL,NULL);
insert into tab_trans values (4967,3531681,37,'1998-2-28','PRIJEM',NULL,71.80,17192.10,'UROK',NULL,NULL);
insert into tab_trans values (4967,3531682,37,'1998-3-31','PRIJEM',NULL,245.00,61986.50,'UROK',NULL,NULL);
insert into tab_trans values (4967,3531683,37,'1998-4-30','PRIJEM',NULL,183.90,57682.80,'UROK',NULL,NULL);
insert into tab_trans values (4967,3531684,37,'1998-5-31','PRIJEM',NULL,201.80,39488.00,'UROK',NULL,NULL);
insert into tab_trans values (4967,3531685,37,'1998-6-30','PRIJEM',NULL,104.10,14479.50,'UROK',NULL,NULL);
insert into tab_trans values (4967,3531686,37,'1998-7-31','PRIJEM',NULL,49.50,9101.40,'UROK',NULL,NULL);
insert into tab_trans values (4967,3531687,37,'1998-8-31','PRIJEM',NULL,72.30,15542.10,'UROK',NULL,NULL);
insert into tab_trans values (4967,3531688,37,'1998-8-31','VYDAJ','VYBER',0.40,15541.70,'SANKC. UROK',NULL,NULL);
insert into tab_trans values (4967,3531689,37,'1998-9-30','PRIJEM',NULL,94.30,37880.40,'UROK',NULL,NULL);
insert into tab_trans values (4968,11261,38,'1997-8-8','PRIJEM','VKLAD',1100.00,14941.00,NULL,NULL,NULL);
insert into tab_trans values (4968,11269,38,'1997-8-8','PRIJEM','PREVOD Z UCTU',13841.00,13841.00,NULL,'YZ','66502475');
insert into tab_trans values (4968,11270,38,'1997-9-8','PRIJEM','PREVOD Z UCTU',13841.00,35430.20,NULL,'YZ','66502475');
insert into tab_trans values (4968,11271,38,'1997-10-8','PRIJEM','PREVOD Z UCTU',13841.00,46698.90,NULL,'YZ','66502475');
insert into tab_trans values (4968,11272,38,'1997-11-8','PRIJEM','PREVOD Z UCTU',13841.00,50023.90,NULL,'YZ','66502475');
insert into tab_trans values (4968,11273,38,'1997-12-8','PRIJEM','PREVOD Z UCTU',20762.00,55991.10,NULL,'YZ','66502475');
insert into tab_trans values (4968,11274,38,'1998-1-8','PRIJEM','PREVOD Z UCTU',13841.00,33743.10,NULL,'YZ','66502475');
insert into tab_trans values (4968,11275,38,'1998-2-8','PRIJEM','PREVOD Z UCTU',13841.00,29511.60,NULL,'YZ','66502475');
insert into tab_trans values (4968,11276,38,'1998-3-8','PRIJEM','PREVOD Z UCTU',13841.00,29579.60,NULL,'YZ','66502475');
insert into tab_trans values (4968,11277,38,'1998-4-8','PRIJEM','PREVOD Z UCTU',13841.00,37647.70,NULL,'YZ','66502475');
insert into tab_trans values (4968,11297,38,'1997-12-8','VYDAJ','VYBER',1800.00,54191.10,NULL,NULL,'0');
insert into tab_trans values (4968,11298,38,'1998-1-13','VYDAJ','VYBER',1700.00,25512.10,NULL,NULL,'0');
insert into tab_trans values (4968,11299,38,'1998-2-7','VYDAJ','VYBER',1500.00,15670.60,NULL,NULL,'0');
insert into tab_trans values (4968,11300,38,'1998-2-25','VYDAJ','VYBER',2500.00,26780.60,NULL,NULL,'0');
insert into tab_trans values (4968,11301,38,'1998-4-6','VYDAJ','VYBER',2500.00,30707.70,NULL,NULL,'0');
insert into tab_trans values (4968,11322,38,'1998-1-7','VYDAJ','PREVOD NA UCET',6901.00,19902.10,'SIPO','EF','2692229');
insert into tab_trans values (4968,11323,38,'1998-2-7','VYDAJ','PREVOD NA UCET',6901.00,17170.60,'SIPO','EF','2692229');
insert into tab_trans values (4968,11324,38,'1998-3-7','VYDAJ','PREVOD NA UCET',6901.00,15738.60,'SIPO','EF','2692229');
insert into tab_trans values (4968,11325,38,'1998-4-7','VYDAJ','PREVOD NA UCET',6901.00,23806.70,'SIPO','EF','2692229');
insert into tab_trans values (4968,11345,38,'1997-12-10','VYDAJ','PREVOD NA UCET',231.00,47360.10,NULL,'KL','83435654');
insert into tab_trans values (4968,11346,38,'1998-1-10','VYDAJ','PREVOD NA UCET',231.00,33512.10,NULL,'KL','83435654');
insert into tab_trans values (4968,11347,38,'1998-2-10','VYDAJ','PREVOD NA UCET',231.00,29280.60,NULL,'KL','83435654');
insert into tab_trans values (4968,11348,38,'1998-3-10','VYDAJ','PREVOD NA UCET',231.00,29348.60,NULL,'KL','83435654');
insert into tab_trans values (4968,11349,38,'1998-4-10','VYDAJ','PREVOD NA UCET',231.00,37416.70,NULL,'KL','83435654');
insert into tab_trans values (4968,11370,38,'1998-1-5','VYDAJ','PREVOD NA UCET',228.00,26803.10,'POJISTNE','OP','64685678');
insert into tab_trans values (4968,11371,38,'1998-2-5','VYDAJ','PREVOD NA UCET',228.00,24071.60,'POJISTNE','OP','64685678');
insert into tab_trans values (4968,11372,38,'1998-3-5','VYDAJ','PREVOD NA UCET',228.00,20739.60,'POJISTNE','OP','64685678');
insert into tab_trans values (4968,11373,38,'1998-4-5','VYDAJ','PREVOD NA UCET',228.00,33207.70,'POJISTNE','OP','64685678');
insert into tab_trans values (4968,11392,38,'1998-3-5','VYBER','VYBER',5896.00,20967.60,NULL,NULL,NULL);
insert into tab_trans values (4968,11398,38,'1998-1-5','VYDAJ','VYBER',16800.00,27031.10,NULL,NULL,NULL);
insert into tab_trans values (4968,11399,38,'1997-12-9','VYDAJ','VYBER',6600.00,47591.10,NULL,NULL,NULL);
insert into tab_trans values (4968,11407,38,'1998-1-12','VYDAJ','VYBER',1500.00,27212.10,NULL,NULL,NULL);
insert into tab_trans values (4968,11408,38,'1998-1-10','VYDAJ','VYBER',4800.00,28712.10,NULL,NULL,NULL);
insert into tab_trans values (4968,11409,38,'1998-1-21','VYDAJ','VYBER',3300.00,22212.10,NULL,NULL,NULL);
insert into tab_trans values (4968,11412,38,'1998-1-3','VYDAJ','VYBER',3900.00,43631.10,NULL,NULL,NULL);
insert into tab_trans values (4968,11434,38,'1997-12-31','VYDAJ','VYBER',30.00,47531.10,'SLUZBY',NULL,NULL);
insert into tab_trans values (4968,11435,38,'1998-1-31','VYDAJ','VYBER',30.00,22299.60,'SLUZBY',NULL,NULL);
insert into tab_trans values (4968,11436,38,'1998-2-28','VYDAJ','VYBER',30.00,26863.60,'SLUZBY',NULL,NULL);
insert into tab_trans values (4968,11437,38,'1998-3-31','VYDAJ','VYBER',30.00,29435.70,'SLUZBY',NULL,NULL);
insert into tab_trans values (4968,11446,38,'1997-9-7','PRIJEM','VKLAD',6600.00,21589.20,NULL,NULL,NULL);
insert into tab_trans values (4968,11447,38,'1997-10-7','VYDAJ','VYBER',2700.00,32857.90,NULL,NULL,NULL);
insert into tab_trans values (4968,11448,38,'1997-11-6','VYDAJ','VYBER',10700.00,36182.90,NULL,NULL,NULL);
insert into tab_trans values (4968,11449,38,'1997-12-6','VYDAJ','VYBER',15000.00,35229.10,NULL,NULL,NULL);
insert into tab_trans values (4968,11450,38,'1998-1-5','PRIJEM','VKLAD',200.00,43831.10,NULL,NULL,NULL);
insert into tab_trans values (4968,11451,38,'1998-2-4','PRIJEM','VKLAD',2000.00,24299.60,NULL,NULL,NULL);
insert into tab_trans values (4968,11452,38,'1998-3-6','PRIJEM','VKLAD',1900.00,22639.60,NULL,NULL,NULL);
insert into tab_trans values (4968,11453,38,'1998-4-5','PRIJEM','VKLAD',4000.00,33435.70,NULL,NULL,NULL);
insert into tab_trans values (4968,3531693,38,'1997-8-31','PRIJEM',NULL,48.20,14989.20,'UROK',NULL,NULL);
insert into tab_trans values (4968,3531694,38,'1997-9-30','PRIJEM',NULL,127.70,35557.90,'UROK',NULL,NULL);
insert into tab_trans values (4968,3531695,38,'1997-10-31','PRIJEM',NULL,184.00,46882.90,'UROK',NULL,NULL);
insert into tab_trans values (4968,3531696,38,'1997-11-30','PRIJEM',NULL,205.20,50229.10,'UROK',NULL,NULL);
insert into tab_trans values (4968,3531697,38,'1997-12-31','PRIJEM',NULL,201.00,47561.10,'UROK',NULL,NULL);
insert into tab_trans values (4968,3531698,38,'1998-1-31','PRIJEM',NULL,117.50,22329.60,'UROK',NULL,NULL);
insert into tab_trans values (4968,3531699,38,'1998-2-28','PRIJEM',NULL,113.00,26893.60,'UROK',NULL,NULL);
insert into tab_trans values (4968,3531700,38,'1998-3-31','PRIJEM',NULL,117.10,29465.70,'UROK',NULL,NULL);
insert into tab_trans values (4973,19809,67,'1994-10-19','PRIJEM','VKLAD',700.00,700.00,NULL,NULL,NULL);
insert into tab_trans values (4973,19820,67,'1994-11-5','PRIJEM','PREVOD Z UCTU',41490.00,42190.00,NULL,'GH','15195447');
insert into tab_trans values (4973,19821,67,'1994-12-5','PRIJEM','PREVOD Z UCTU',62235.00,94282.80,NULL,'GH','15195447');
insert into tab_trans values (4973,19822,67,'1995-1-5','PRIJEM','PREVOD Z UCTU',41490.00,101658.70,NULL,'GH','15195447');
insert into tab_trans values (4973,19823,67,'1995-2-5','PRIJEM','PREVOD Z UCTU',41490.00,106608.50,NULL,'GH','15195447');
insert into tab_trans values (4973,19824,67,'1995-3-5','PRIJEM','PREVOD Z UCTU',41490.00,107069.60,NULL,'GH','15195447');
insert into tab_trans values (4973,19825,67,'1995-4-5','PRIJEM','PREVOD Z UCTU',41490.00,74327.10,NULL,'GH','15195447');
insert into tab_trans values (4973,19826,67,'1995-5-5','PRIJEM','PREVOD Z UCTU',41490.00,86849.40,NULL,'GH','15195447');
insert into tab_trans values (4973,19827,67,'1995-6-5','PRIJEM','PREVOD Z UCTU',62235.00,100151.70,NULL,'GH','15195447');
insert into tab_trans values (4973,19828,67,'1995-7-5','PRIJEM','PREVOD Z UCTU',41490.00,59086.80,NULL,'GH','15195447');
insert into tab_trans values (4973,19829,67,'1995-8-5','PRIJEM','PREVOD Z UCTU',41490.00,79760.40,NULL,'GH','15195447');
insert into tab_trans values (4973,19830,67,'1995-9-5','PRIJEM','PREVOD Z UCTU',41490.00,73582.50,NULL,'GH','15195447');
insert into tab_trans values (4973,19831,67,'1995-10-5','PRIJEM','PREVOD Z UCTU',41490.00,85227.60,NULL,'GH','15195447');
insert into tab_trans values (4973,19832,67,'1995-11-5','PRIJEM','PREVOD Z UCTU',41490.00,85068.00,NULL,'GH','15195447');
insert into tab_trans values (4973,19833,67,'1995-12-5','PRIJEM','PREVOD Z UCTU',62235.00,89068.80,NULL,'GH','15195447');
insert into tab_trans values (4973,19834,67,'1996-1-5','PRIJEM','PREVOD Z UCTU',41490.00,82346.20,NULL,'GH','15195447');
insert into tab_trans values (4973,19835,67,'1996-2-5','PRIJEM','PREVOD Z UCTU',41490.00,91306.70,NULL,'GH','15195447');
insert into tab_trans values (4973,19836,67,'1996-3-5','PRIJEM','PREVOD Z UCTU',41490.00,65903.20,NULL,'GH','15195447');
insert into tab_trans values (4973,19837,67,'1996-4-5','PRIJEM','PREVOD Z UCTU',41490.00,64130.70,NULL,'GH','15195447');
insert into tab_trans values (4973,19884,67,'1995-3-26','VYDAJ','VYBER',6900.00,32631.60,NULL,NULL,'0');
insert into tab_trans values (4973,19885,67,'1995-3-25','VYDAJ','VYBER',7300.00,39531.60,NULL,NULL,'0');
insert into tab_trans values (4973,19886,67,'1995-5-21','VYDAJ','VYBER',8700.00,43111.40,NULL,NULL,'0');
insert into tab_trans values (4973,19887,67,'1995-5-31','VYDAJ','VYBER',5400.00,37916.70,NULL,NULL,'0');
insert into tab_trans values (4973,19888,67,'1995-6-27','VYDAJ','VYBER',5800.00,17413.70,NULL,NULL,'0');
insert into tab_trans values (4973,19889,67,'1995-8-10','VYDAJ','VYBER',6700.00,73060.40,NULL,NULL,'0');
insert into tab_trans values (4973,19890,67,'1995-9-4','VYDAJ','VYBER',5900.00,32092.50,NULL,NULL,'0');
insert into tab_trans values (4973,19891,67,'1995-10-13','VYDAJ','VYBER',8600.00,70234.60,NULL,NULL,'0');
insert into tab_trans values (4973,19892,67,'1995-11-4','VYDAJ','VYBER',5600.00,43578.00,NULL,NULL,'0');
insert into tab_trans values (4973,19893,67,'1995-12-15','VYDAJ','VYBER',7500.00,48930.80,NULL,NULL,'0');
insert into tab_trans values (4973,19894,67,'1996-1-4','VYDAJ','VYBER',8300.00,40856.20,NULL,NULL,'0');
insert into tab_trans values (4973,19895,67,'1996-2-11','VYDAJ','VYBER',7900.00,83406.70,NULL,NULL,'0');
insert into tab_trans values (4973,19896,67,'1996-3-10','VYDAJ','VYBER',8000.00,57903.20,NULL,NULL,'0');
insert into tab_trans values (4973,19897,67,'1996-4-15','VYDAJ','VYBER',4500.00,30792.70,NULL,NULL,'0');
insert into tab_trans values (4973,19944,67,'1995-3-12','VYDAJ','PREVOD NA UCET',6393.00,59276.60,'SIPO','YZ','57342255');
insert into tab_trans values (4973,19945,67,'1995-4-12','VYDAJ','PREVOD NA UCET',6393.00,67934.10,'SIPO','YZ','57342255');
insert into tab_trans values (4973,19946,67,'1995-5-12','VYDAJ','PREVOD NA UCET',6393.00,71756.40,'SIPO','YZ','57342255');
insert into tab_trans values (4973,19947,67,'1995-6-12','VYDAJ','PREVOD NA UCET',6393.00,53058.70,'SIPO','YZ','57342255');
insert into tab_trans values (4973,19948,67,'1995-7-12','VYDAJ','PREVOD NA UCET',6393.00,52693.80,'SIPO','YZ','57342255');
insert into tab_trans values (4973,19949,67,'1995-8-12','VYDAJ','PREVOD NA UCET',6393.00,66667.40,'SIPO','YZ','57342255');
insert into tab_trans values (4973,19950,67,'1995-9-12','VYDAJ','PREVOD NA UCET',6393.00,61489.50,'SIPO','YZ','57342255');
insert into tab_trans values (4973,19951,67,'1995-10-12','VYDAJ','PREVOD NA UCET',6393.00,78834.60,'SIPO','YZ','57342255');
insert into tab_trans values (4973,19952,67,'1995-11-12','VYDAJ','PREVOD NA UCET',6393.00,78675.00,'SIPO','YZ','57342255');
insert into tab_trans values (4973,19953,67,'1995-12-12','VYDAJ','PREVOD NA UCET',6393.00,82675.80,'SIPO','YZ','57342255');
insert into tab_trans values (4973,19954,67,'1996-1-12','VYDAJ','PREVOD NA UCET',6393.00,72237.20,'SIPO','YZ','57342255');
insert into tab_trans values (4973,19955,67,'1996-2-12','VYDAJ','PREVOD NA UCET',6393.00,42113.70,'SIPO','YZ','57342255');
insert into tab_trans values (4973,19956,67,'1996-3-12','VYDAJ','PREVOD NA UCET',6393.00,51510.20,'SIPO','YZ','57342255');
insert into tab_trans values (4973,19957,67,'1996-4-12','VYDAJ','PREVOD NA UCET',6393.00,35737.70,'SIPO','YZ','57342255');
insert into tab_trans values (4973,20004,67,'1995-3-13','VYDAJ','PREVOD NA UCET',445.00,58831.60,NULL,'UV','59079301');
insert into tab_trans values (4973,20005,67,'1995-4-13','VYDAJ','PREVOD NA UCET',445.00,67489.10,NULL,'UV','59079301');
insert into tab_trans values (4973,20006,67,'1995-5-13','VYDAJ','PREVOD NA UCET',445.00,71311.40,NULL,'UV','59079301');
insert into tab_trans values (4973,20007,67,'1995-6-13','VYDAJ','PREVOD NA UCET',445.00,52613.70,NULL,'UV','59079301');
insert into tab_trans values (4973,20008,67,'1995-7-13','VYDAJ','PREVOD NA UCET',445.00,52248.80,NULL,'UV','59079301');
insert into tab_trans values (4973,20009,67,'1995-8-13','VYDAJ','PREVOD NA UCET',445.00,66222.40,NULL,'UV','59079301');
insert into tab_trans values (4973,20010,67,'1995-9-13','VYDAJ','PREVOD NA UCET',445.00,61044.50,NULL,'UV','59079301');
insert into tab_trans values (4973,20011,67,'1995-10-13','VYDAJ','PREVOD NA UCET',445.00,69789.60,NULL,'UV','59079301');
insert into tab_trans values (4973,20012,67,'1995-11-13','VYDAJ','PREVOD NA UCET',445.00,78230.00,NULL,'UV','59079301');
insert into tab_trans values (4973,20013,67,'1995-12-13','VYDAJ','PREVOD NA UCET',445.00,56430.80,NULL,'UV','59079301');
insert into tab_trans values (4973,20014,67,'1996-1-13','VYDAJ','PREVOD NA UCET',445.00,49592.20,NULL,'UV','59079301');
insert into tab_trans values (4973,20015,67,'1996-2-13','VYDAJ','PREVOD NA UCET',445.00,41668.70,NULL,'UV','59079301');
insert into tab_trans values (4973,20016,67,'1996-3-13','VYDAJ','PREVOD NA UCET',445.00,37065.20,NULL,'UV','59079301');
insert into tab_trans values (4973,20017,67,'1996-4-13','VYDAJ','PREVOD NA UCET',445.00,35292.70,NULL,'UV','59079301');
insert into tab_trans values (4973,20060,67,'1996-1-10','VYBER','VYBER',3716.00,78630.20,NULL,NULL,NULL);
insert into tab_trans values (4973,20061,67,'1996-3-4','VYBER','VYBER',17427.00,24413.20,NULL,NULL,NULL);
insert into tab_trans values (4973,20062,67,'1996-3-20','VYBER','VYBER',14570.00,22495.20,NULL,NULL,NULL);
insert into tab_trans values (4973,20066,67,'1996-4-26','VYBER','VYBER',3303.00,23589.70,NULL,NULL,NULL);
insert into tab_trans values (4973,20089,67,'1995-12-2','VYDAJ','VYBER',7500.00,26833.80,NULL,NULL,NULL);
insert into tab_trans values (4973,20099,67,'1995-5-9','VYDAJ','VYBER',8700.00,78149.40,NULL,NULL,NULL);
insert into tab_trans values (4973,20100,67,'1995-11-18','VYDAJ','VYBER',12900.00,37130.00,NULL,NULL,NULL);
insert into tab_trans values (4973,20101,67,'1995-8-21','VYDAJ','VYBER',6900.00,37822.40,NULL,NULL,NULL);
insert into tab_trans values (4973,20102,67,'1995-9-6','VYDAJ','VYBER',5700.00,67882.50,NULL,NULL,NULL);
insert into tab_trans values (4973,20103,67,'1995-6-17','VYDAJ','VYBER',13500.00,23213.70,NULL,NULL,NULL);
insert into tab_trans values (4973,20104,67,'1995-11-21','VYDAJ','VYBER',3000.00,34130.00,NULL,NULL,NULL);
insert into tab_trans values (4973,20108,67,'1996-4-24','VYDAJ','VYBER',3900.00,26892.70,NULL,NULL,NULL);
insert into tab_trans values (4973,20133,67,'1995-3-31','VYDAJ','VYBER',14.60,32837.10,'SLUZBY',NULL,NULL);
insert into tab_trans values (4973,20134,67,'1995-4-30','VYDAJ','VYBER',14.60,45359.40,'SLUZBY',NULL,NULL);
insert into tab_trans values (4973,20135,67,'1995-5-31','VYDAJ','VYBER',14.60,43316.70,'SLUZBY',NULL,NULL);
insert into tab_trans values (4973,20136,67,'1995-6-30','VYDAJ','VYBER',14.60,17596.80,'SLUZBY',NULL,NULL);
insert into tab_trans values (4973,20137,67,'1995-7-31','VYDAJ','VYBER',14.60,38270.40,'SLUZBY',NULL,NULL);
insert into tab_trans values (4973,20138,67,'1995-8-31','VYDAJ','VYBER',14.60,37992.50,'SLUZBY',NULL,NULL);
insert into tab_trans values (4973,20139,67,'1995-9-30','VYDAJ','VYBER',14.60,43737.60,'SLUZBY',NULL,NULL);
insert into tab_trans values (4973,20140,67,'1995-10-31','VYDAJ','VYBER',14.60,49178.00,'SLUZBY',NULL,NULL);
insert into tab_trans values (4973,20141,67,'1995-11-30','VYDAJ','VYBER',14.60,34333.80,'SLUZBY',NULL,NULL);
insert into tab_trans values (4973,20142,67,'1995-12-31','VYDAJ','VYBER',14.60,49156.20,'SLUZBY',NULL,NULL);
insert into tab_trans values (4973,20143,67,'1996-1-31','VYDAJ','VYBER',14.60,49816.70,'SLUZBY',NULL,NULL);
insert into tab_trans values (4973,20144,67,'1996-2-29','VYDAJ','VYBER',14.60,41840.20,'SLUZBY',NULL,NULL);
insert into tab_trans values (4973,20145,67,'1996-3-31','VYDAJ','VYBER',14.60,22640.70,'SLUZBY',NULL,NULL);
insert into tab_trans values (4973,20146,67,'1996-4-30','VYDAJ','VYBER',14.60,23689.20,'SLUZBY',NULL,NULL);
insert into tab_trans values (4973,20178,67,'1994-11-18','VYDAJ','VYBER',10200.00,31990.00,NULL,NULL,NULL);
insert into tab_trans values (4973,20179,67,'1994-12-18','VYDAJ','VYBER',34300.00,59982.80,NULL,NULL,NULL);
insert into tab_trans values (4973,20180,67,'1995-1-17','VYDAJ','VYBER',36800.00,64858.70,NULL,NULL,NULL);
insert into tab_trans values (4973,20181,67,'1995-2-16','VYDAJ','VYBER',41300.00,65308.50,NULL,NULL,NULL);
insert into tab_trans values (4973,20182,67,'1995-3-5','VYDAJ','VYBER',41400.00,65669.60,NULL,NULL,NULL);
insert into tab_trans values (4973,20183,67,'1995-3-18','VYDAJ','VYBER',12000.00,46831.60,NULL,NULL,NULL);
insert into tab_trans values (4973,20184,67,'1995-4-17','VYDAJ','VYBER',22300.00,45189.10,NULL,NULL,NULL);
insert into tab_trans values (4973,20185,67,'1995-5-17','VYDAJ','VYBER',19500.00,51811.40,NULL,NULL,NULL);
insert into tab_trans values (4973,20186,67,'1995-6-5','VYDAJ','VYBER',40700.00,59451.70,NULL,NULL,NULL);
insert into tab_trans values (4973,20187,67,'1995-6-16','VYDAJ','VYBER',15900.00,36713.70,NULL,NULL,NULL);
insert into tab_trans values (4973,20188,67,'1995-7-16','VYDAJ','VYBER',14100.00,38148.80,NULL,NULL,NULL);
insert into tab_trans values (4973,20189,67,'1995-8-15','VYDAJ','VYBER',21500.00,44722.40,NULL,NULL,NULL);
insert into tab_trans values (4973,20190,67,'1995-9-14','VYDAJ','VYBER',17500.00,43544.50,NULL,NULL,NULL);
insert into tab_trans values (4973,20191,67,'1995-10-14','VYDAJ','VYBER',20800.00,48989.60,NULL,NULL,NULL);
insert into tab_trans values (4973,20192,67,'1995-11-13','VYDAJ','VYBER',28200.00,50030.00,NULL,NULL,NULL);
insert into tab_trans values (4973,20193,67,'1995-12-13','VYDAJ','VYBER',25800.00,56875.80,NULL,NULL,NULL);
insert into tab_trans values (4973,20194,67,'1996-1-12','VYDAJ','VYBER',22200.00,50037.20,NULL,NULL,NULL);
insert into tab_trans values (4973,20195,67,'1996-2-11','VYDAJ','VYBER',34900.00,48506.70,NULL,NULL,NULL);
insert into tab_trans values (4973,20196,67,'1996-3-12','VYDAJ','VYBER',14000.00,37510.20,NULL,NULL,NULL);
insert into tab_trans values (4973,20197,67,'1996-4-11','VYDAJ','VYBER',22000.00,42130.70,NULL,NULL,NULL);
insert into tab_trans values (4973,3532728,67,'1994-11-30','PRIJEM',NULL,57.80,32047.80,'UROK',NULL,NULL);
insert into tab_trans values (4973,3532729,67,'1994-12-31','PRIJEM',NULL,186.00,60168.70,'UROK',NULL,NULL);
insert into tab_trans values (4973,3532730,67,'1995-1-31','PRIJEM',NULL,259.80,65118.50,'UROK',NULL,NULL);
insert into tab_trans values (4973,3532731,67,'1995-2-28','PRIJEM',NULL,271.10,65579.60,'UROK',NULL,NULL);
insert into tab_trans values (4973,3532732,67,'1995-3-31','PRIJEM',NULL,220.10,32851.70,'UROK',NULL,NULL);
insert into tab_trans values (4973,3532733,67,'1995-4-30','PRIJEM',NULL,184.90,45374.00,'UROK',NULL,NULL);
insert into tab_trans values (4973,3532734,67,'1995-5-31','PRIJEM',NULL,219.90,43331.30,'UROK',NULL,NULL);
insert into tab_trans values (4973,3532735,67,'1995-6-30','PRIJEM',NULL,197.70,17611.40,'UROK',NULL,NULL);
insert into tab_trans values (4973,3532736,67,'1995-7-31','PRIJEM',NULL,136.20,38285.00,'UROK',NULL,NULL);
insert into tab_trans values (4973,3532737,67,'1995-8-31','PRIJEM',NULL,184.70,38007.10,'UROK',NULL,NULL);
insert into tab_trans values (4973,3532738,67,'1995-9-30','PRIJEM',NULL,207.70,43752.20,'UROK',NULL,NULL);
insert into tab_trans values (4973,3532739,67,'1995-10-31','PRIJEM',NULL,203.10,49192.60,'UROK',NULL,NULL);
insert into tab_trans values (4973,3532740,67,'1995-11-30','PRIJEM',NULL,218.40,34348.40,'UROK',NULL,NULL);
insert into tab_trans values (4973,3532741,67,'1995-12-31','PRIJEM',NULL,240.00,49170.80,'UROK',NULL,NULL);
insert into tab_trans values (4973,3532742,67,'1996-1-31','PRIJEM',NULL,239.10,49831.30,'UROK',NULL,NULL);
insert into tab_trans values (4973,3532743,67,'1996-2-29','PRIJEM',NULL,186.10,41854.80,'UROK',NULL,NULL);
insert into tab_trans values (4973,3532744,67,'1996-3-31','PRIJEM',NULL,160.10,22655.30,'UROK',NULL,NULL);
insert into tab_trans values (4973,3532745,67,'1996-4-30','PRIJEM',NULL,114.10,23703.80,'UROK',NULL,NULL);
insert into tab_trans values (4986,29886,97,'1996-5-5','PRIJEM','VKLAD',900.00,900.00,NULL,NULL,NULL);
insert into tab_trans values (4986,29891,97,'1996-5-14','PRIJEM','VKLAD',17928.00,18828.00,NULL,NULL,NULL);
insert into tab_trans values (4986,29892,97,'1996-6-14','PRIJEM','VKLAD',26892.00,50265.60,NULL,NULL,NULL);
insert into tab_trans values (4986,29893,97,'1996-7-14','PRIJEM','VKLAD',17928.00,54546.20,NULL,NULL,NULL);
insert into tab_trans values (4986,29894,97,'1996-8-14','PRIJEM','VKLAD',17928.00,60094.00,NULL,NULL,NULL);
insert into tab_trans values (4986,29895,97,'1996-9-14','PRIJEM','VKLAD',17928.00,59662.70,NULL,NULL,NULL);
insert into tab_trans values (4986,29896,97,'1996-10-14','PRIJEM','VKLAD',17928.00,56154.80,NULL,NULL,NULL);
insert into tab_trans values (4986,29897,97,'1996-11-14','PRIJEM','VKLAD',17928.00,51798.40,NULL,NULL,NULL);
insert into tab_trans values (4986,29898,97,'1996-12-14','PRIJEM','VKLAD',26892.00,38394.90,NULL,NULL,NULL);
insert into tab_trans values (4986,29899,97,'1997-1-14','PRIJEM','VKLAD',17928.00,36685.10,NULL,NULL,NULL);
insert into tab_trans values (4986,29900,97,'1997-2-14','PRIJEM','VKLAD',17928.00,36236.70,NULL,NULL,NULL);
insert into tab_trans values (4986,29901,97,'1997-3-14','PRIJEM','VKLAD',17928.00,30136.20,NULL,NULL,NULL);
insert into tab_trans values (4986,29902,97,'1997-4-14','PRIJEM','VKLAD',17928.00,36220.90,NULL,NULL,NULL);
insert into tab_trans values (4986,29903,97,'1997-5-14','PRIJEM','VKLAD',17928.00,40536.80,NULL,NULL,NULL);
insert into tab_trans values (4986,29904,97,'1997-6-14','PRIJEM','VKLAD',26892.00,55321.50,NULL,NULL,NULL);
insert into tab_trans values (4986,29905,97,'1997-7-14','PRIJEM','VKLAD',17928.00,46888.90,NULL,NULL,NULL);
insert into tab_trans values (4986,29932,97,'1996-10-10','VYDAJ','PREVOD NA UCET',1436.00,38226.80,'SIPO','ST','69820374');
insert into tab_trans values (4986,29933,97,'1996-11-10','VYDAJ','PREVOD NA UCET',1436.00,33870.40,'SIPO','ST','69820374');
insert into tab_trans values (4986,29934,97,'1996-12-10','VYDAJ','PREVOD NA UCET',1436.00,11502.90,'SIPO','ST','69820374');
insert into tab_trans values (4986,29935,97,'1997-1-10','VYDAJ','PREVOD NA UCET',1436.00,18757.10,'SIPO','ST','69820374');
insert into tab_trans values (4986,29936,97,'1997-2-10','VYDAJ','PREVOD NA UCET',1436.00,18308.70,'SIPO','ST','69820374');
insert into tab_trans values (4986,29937,97,'1997-3-10','VYDAJ','PREVOD NA UCET',1436.00,12208.20,'SIPO','ST','69820374');
insert into tab_trans values (4986,29938,97,'1997-4-10','VYDAJ','PREVOD NA UCET',1436.00,21652.90,'SIPO','ST','69820374');
insert into tab_trans values (4986,29939,97,'1997-5-10','VYDAJ','PREVOD NA UCET',1436.00,22608.80,'SIPO','ST','69820374');
insert into tab_trans values (4986,29940,97,'1997-6-10','VYDAJ','PREVOD NA UCET',1436.00,28429.50,'SIPO','ST','69820374');
insert into tab_trans values (4986,29941,97,'1997-7-10','VYDAJ','PREVOD NA UCET',1436.00,34960.90,'SIPO','ST','69820374');
insert into tab_trans values (4986,29967,97,'1996-9-14','VYDAJ','PREVOD NA UCET',2411.00,57251.70,NULL,'CD','33796209');
insert into tab_trans values (4986,29968,97,'1996-10-14','VYDAJ','PREVOD NA UCET',2411.00,53743.80,NULL,'CD','33796209');
insert into tab_trans values (4986,29969,97,'1996-11-14','VYDAJ','PREVOD NA UCET',2411.00,49387.40,NULL,'CD','33796209');
insert into tab_trans values (4986,29970,97,'1996-12-14','VYDAJ','PREVOD NA UCET',2411.00,35983.90,NULL,'CD','33796209');
insert into tab_trans values (4986,29971,97,'1997-1-14','VYDAJ','PREVOD NA UCET',2411.00,34274.10,NULL,'CD','33796209');
insert into tab_trans values (4986,29972,97,'1997-2-14','VYDAJ','PREVOD NA UCET',2411.00,33825.70,NULL,'CD','33796209');
insert into tab_trans values (4986,29973,97,'1997-3-14','VYDAJ','PREVOD NA UCET',2411.00,27725.20,NULL,'CD','33796209');
insert into tab_trans values (4986,29974,97,'1997-4-14','VYDAJ','PREVOD NA UCET',2411.00,33809.90,NULL,'CD','33796209');
insert into tab_trans values (4986,29975,97,'1997-5-14','VYDAJ','PREVOD NA UCET',2411.00,38125.80,NULL,'CD','33796209');
insert into tab_trans values (4986,29976,97,'1997-6-14','VYDAJ','PREVOD NA UCET',2411.00,52910.50,NULL,'CD','33796209');
insert into tab_trans values (4986,29977,97,'1997-7-14','VYDAJ','PREVOD NA UCET',2411.00,44477.90,NULL,'CD','33796209');
insert into tab_trans values (4986,30004,97,'1996-10-5','VYDAJ','PREVOD NA UCET',3.00,39677.80,'POJISTNE','ST','83123987');
insert into tab_trans values (4986,30005,97,'1996-11-5','VYDAJ','PREVOD NA UCET',3.00,35321.40,'POJISTNE','ST','83123987');
insert into tab_trans values (4986,30006,97,'1996-12-5','VYDAJ','PREVOD NA UCET',3.00,28453.90,'POJISTNE','ST','83123987');
insert into tab_trans values (4986,30007,97,'1997-1-5','VYDAJ','PREVOD NA UCET',3.00,25168.10,'POJISTNE','ST','83123987');
insert into tab_trans values (4986,30008,97,'1997-2-5','VYDAJ','PREVOD NA UCET',3.00,19759.70,'POJISTNE','ST','83123987');
insert into tab_trans values (4986,30009,97,'1997-3-5','VYDAJ','PREVOD NA UCET',3.00,13659.20,'POJISTNE','ST','83123987');
insert into tab_trans values (4986,30010,97,'1997-4-5','VYDAJ','PREVOD NA UCET',3.00,23103.90,'POJISTNE','ST','83123987');
insert into tab_trans values (4986,30011,97,'1997-5-5','VYDAJ','PREVOD NA UCET',3.00,24059.80,'POJISTNE','ST','83123987');
insert into tab_trans values (4986,30012,97,'1997-6-5','VYDAJ','PREVOD NA UCET',3.00,29880.50,'POJISTNE','ST','83123987');
insert into tab_trans values (4986,30013,97,'1997-7-5','VYDAJ','PREVOD NA UCET',3.00,36411.90,'POJISTNE','ST','83123987');
insert into tab_trans values (4986,30014,97,'1997-8-5','VYDAJ','PREVOD NA UCET',3.00,40531.30,'POJISTNE','ST','83123987');
insert into tab_trans values (4986,30040,97,'1996-10-7','VYDAJ','PREVOD NA UCET',15.00,39662.80,NULL,'CD','94469666');
insert into tab_trans values (4986,30041,97,'1996-11-7','VYDAJ','PREVOD NA UCET',15.00,35306.40,NULL,'CD','94469666');
insert into tab_trans values (4986,30042,97,'1996-12-7','VYDAJ','PREVOD NA UCET',15.00,24238.90,NULL,'CD','94469666');
insert into tab_trans values (4986,30043,97,'1997-1-7','VYDAJ','PREVOD NA UCET',15.00,25153.10,NULL,'CD','94469666');
insert into tab_trans values (4986,30044,97,'1997-2-7','VYDAJ','PREVOD NA UCET',15.00,19744.70,NULL,'CD','94469666');
insert into tab_trans values (4986,30045,97,'1997-3-7','VYDAJ','PREVOD NA UCET',15.00,13644.20,NULL,'CD','94469666');
insert into tab_trans values (4986,30046,97,'1997-4-7','VYDAJ','PREVOD NA UCET',15.00,23088.90,NULL,'CD','94469666');
insert into tab_trans values (4986,30047,97,'1997-5-7','VYDAJ','PREVOD NA UCET',15.00,24044.80,NULL,'CD','94469666');
insert into tab_trans values (4986,30048,97,'1997-6-7','VYDAJ','PREVOD NA UCET',15.00,29865.50,NULL,'CD','94469666');
insert into tab_trans values (4986,30049,97,'1997-7-7','VYDAJ','PREVOD NA UCET',15.00,36396.90,NULL,'CD','94469666');
insert into tab_trans values (4986,30050,97,'1997-8-7','VYDAJ','PREVOD NA UCET',15.00,40516.30,NULL,'CD','94469666');
insert into tab_trans values (4986,30076,97,'1996-10-18','VYDAJ','VYBER',6900.00,46843.80,NULL,NULL,'0');
insert into tab_trans values (4986,30077,97,'1996-11-26','VYDAJ','VYBER',8500.00,40887.40,NULL,NULL,'0');
insert into tab_trans values (4986,30078,97,'1996-12-9','VYDAJ','VYBER',11300.00,12938.90,NULL,NULL,'0');
insert into tab_trans values (4986,30079,97,'1997-1-19','VYDAJ','VYBER',11100.00,23174.10,NULL,NULL,'0');
insert into tab_trans values (4986,30080,97,'1997-2-19','VYDAJ','VYBER',8800.00,22385.70,NULL,NULL,'0');
insert into tab_trans values (4986,30081,97,'1997-2-24','VYDAJ','VYBER',7400.00,14985.70,NULL,NULL,'0');
insert into tab_trans values (4986,30082,97,'1997-4-14','VYDAJ','VYBER',6700.00,27109.90,NULL,NULL,'0');
insert into tab_trans values (4986,30083,97,'1997-5-16','VYDAJ','VYBER',8300.00,29825.80,NULL,NULL,'0');
insert into tab_trans values (4986,30084,97,'1997-6-20','VYDAJ','VYBER',8600.00,41670.50,NULL,NULL,'0');
insert into tab_trans values (4986,30085,97,'1997-7-11','VYDAJ','VYBER',6000.00,28960.90,NULL,NULL,'0');
insert into tab_trans values (4986,30107,97,'1997-1-8','VYDAJ','VYBER',4960.00,20193.10,NULL,NULL,NULL);
insert into tab_trans values (4986,30109,97,'1996-12-17','VYDAJ','VYBER',4320.00,31663.90,NULL,NULL,NULL);
insert into tab_trans values (4986,30112,97,'1996-12-6','VYDAJ','VYBER',4200.00,24253.90,NULL,NULL,NULL);
insert into tab_trans values (4986,30116,97,'1997-6-17','VYDAJ','VYBER',2640.00,50270.50,NULL,NULL,NULL);
insert into tab_trans values (4986,30118,97,'1997-4-10','VYDAJ','VYBER',3360.00,18292.90,NULL,NULL,NULL);
insert into tab_trans values (4986,30119,97,'1997-5-21','VYDAJ','VYBER',2640.00,27185.80,NULL,NULL,NULL);
insert into tab_trans values (4986,30121,97,'1997-4-17','VYDAJ','VYBER',1440.00,25669.90,NULL,NULL,NULL);
insert into tab_trans values (4986,30122,97,'1997-2-18','VYDAJ','VYBER',2640.00,31185.70,NULL,NULL,NULL);
insert into tab_trans values (4986,30134,97,'1996-9-30','VYDAJ','VYBER',14.60,57480.80,'SLUZBY',NULL,NULL);
insert into tab_trans values (4986,30135,97,'1996-10-31','VYDAJ','VYBER',14.60,47024.40,'SLUZBY',NULL,NULL);
insert into tab_trans values (4986,30136,97,'1996-11-30','VYDAJ','VYBER',14.60,41056.90,'SLUZBY',NULL,NULL);
insert into tab_trans values (4986,30137,97,'1996-12-31','VYDAJ','VYBER',14.60,25171.10,'SLUZBY',NULL,NULL);
insert into tab_trans values (4986,30138,97,'1997-1-31','VYDAJ','VYBER',14.60,19762.70,'SLUZBY',NULL,NULL);
insert into tab_trans values (4986,30139,97,'1997-2-28','VYDAJ','VYBER',14.60,15062.20,'SLUZBY',NULL,NULL);
insert into tab_trans values (4986,30140,97,'1997-3-31','VYDAJ','VYBER',14.60,27806.90,'SLUZBY',NULL,NULL);
insert into tab_trans values (4986,30141,97,'1997-4-30','VYDAJ','VYBER',14.60,24062.80,'SLUZBY',NULL,NULL);
insert into tab_trans values (4986,30142,97,'1997-5-31','VYDAJ','VYBER',14.60,29883.50,'SLUZBY',NULL,NULL);
insert into tab_trans values (4986,30143,97,'1997-6-30','VYDAJ','VYBER',14.60,36414.90,'SLUZBY',NULL,NULL);
insert into tab_trans values (4986,30144,97,'1997-7-31','VYDAJ','VYBER',14.60,40534.30,'SLUZBY',NULL,NULL);
insert into tab_trans values (4986,30161,97,'1996-6-4','PRIJEM','VKLAD',4500.00,23373.50,NULL,NULL,NULL);
insert into tab_trans values (4986,30162,97,'1996-7-4','VYDAJ','VYBER',13800.00,36618.20,NULL,NULL,NULL);
insert into tab_trans values (4986,30163,97,'1996-8-3','VYDAJ','VYBER',12600.00,42166.00,NULL,NULL,NULL);
insert into tab_trans values (4986,30164,97,'1996-9-2','VYDAJ','VYBER',18600.00,41734.70,NULL,NULL,NULL);
insert into tab_trans values (4986,30165,97,'1996-10-2','VYDAJ','VYBER',17800.00,39680.80,NULL,NULL,NULL);
insert into tab_trans values (4986,30166,97,'1996-11-1','VYDAJ','VYBER',11700.00,35324.40,NULL,NULL,NULL);
insert into tab_trans values (4986,30167,97,'1996-12-1','VYDAJ','VYBER',12600.00,28456.90,NULL,NULL,NULL);
insert into tab_trans values (4986,30168,97,'1996-12-31','VYDAJ','VYBER',6600.00,25185.70,NULL,NULL,NULL);
insert into tab_trans values (4986,30169,97,'1997-1-30','VYDAJ','VYBER',3500.00,19674.10,NULL,NULL,NULL);
insert into tab_trans values (4986,30170,97,'1997-3-1','VYDAJ','VYBER',1400.00,13662.20,NULL,NULL,NULL);
insert into tab_trans values (4986,30171,97,'1997-3-31','VYDAJ','VYBER',4700.00,23106.90,NULL,NULL,NULL);
insert into tab_trans values (4986,30172,97,'1997-4-30','VYDAJ','VYBER',1700.00,24077.40,NULL,NULL,NULL);
insert into tab_trans values (4986,30173,97,'1997-5-30','PRIJEM','VKLAD',2600.00,29785.80,NULL,NULL,NULL);
insert into tab_trans values (4986,30174,97,'1997-6-29','VYDAJ','VYBER',5400.00,36270.50,NULL,NULL,NULL);
insert into tab_trans values (4986,30175,97,'1997-7-29','VYDAJ','VYBER',4100.00,40377.90,NULL,NULL,NULL);
insert into tab_trans values (4986,3533692,97,'1996-5-31','PRIJEM',NULL,45.60,18873.50,'UROK',NULL,NULL);
insert into tab_trans values (4986,3533693,97,'1996-6-30','PRIJEM',NULL,152.70,50418.20,'UROK',NULL,NULL);
insert into tab_trans values (4986,3533694,97,'1996-7-31','PRIJEM',NULL,219.80,54766.00,'UROK',NULL,NULL);
insert into tab_trans values (4986,3533695,97,'1996-8-31','PRIJEM',NULL,240.70,60334.70,'UROK',NULL,NULL);
insert into tab_trans values (4986,3533696,97,'1996-9-30','PRIJEM',NULL,243.70,57495.40,'UROK',NULL,NULL);
insert into tab_trans values (4986,3533697,97,'1996-10-31','PRIJEM',NULL,195.20,47039.00,'UROK',NULL,NULL);
insert into tab_trans values (4986,3533698,97,'1996-11-30','PRIJEM',NULL,184.10,41071.50,'UROK',NULL,NULL);
insert into tab_trans values (4986,3533699,97,'1996-12-31','PRIJEM',NULL,121.80,31785.70,'UROK',NULL,NULL);
insert into tab_trans values (4986,3533700,97,'1997-1-31','PRIJEM',NULL,103.20,19777.30,'UROK',NULL,NULL);
insert into tab_trans values (4986,3533701,97,'1997-2-28','PRIJEM',NULL,91.10,15076.80,'UROK',NULL,NULL);
insert into tab_trans values (4986,3533702,97,'1997-3-31','PRIJEM',NULL,96.20,27821.50,'UROK',NULL,NULL);
insert into tab_trans values (4986,3533703,97,'1997-4-30','PRIJEM',NULL,107.60,25777.40,'UROK',NULL,NULL);
insert into tab_trans values (4986,3533704,97,'1997-5-31','PRIJEM',NULL,112.20,29898.10,'UROK',NULL,NULL);
insert into tab_trans values (4986,3533705,97,'1997-6-30','PRIJEM',NULL,159.10,36429.50,'UROK',NULL,NULL);
insert into tab_trans values (4986,3533706,97,'1997-7-31','PRIJEM',NULL,170.90,40548.90,'UROK',NULL,NULL);
insert into tab_trans values (4988,31998,103,'1996-3-10','PRIJEM','VKLAD',1000.00,1000.00,NULL,NULL,NULL);
insert into tab_trans values (4988,31999,103,'1997-6-25','PRIJEM','VKLAD',8226.00,45252.60,NULL,NULL,NULL);
insert into tab_trans values (4988,32000,103,'1997-3-18','PRIJEM','VKLAD',8814.00,65746.80,NULL,NULL,NULL);
insert into tab_trans values (4988,32001,103,'1997-5-19','PRIJEM','VKLAD',38249.00,92609.40,NULL,NULL,NULL);
insert into tab_trans values (4988,32002,103,'1997-3-8','PRIJEM','VKLAD',47897.00,110432.80,NULL,NULL,NULL);
insert into tab_trans values (4988,32003,103,'1997-4-28','PRIJEM','VKLAD',19823.00,79733.50,NULL,NULL,NULL);
insert into tab_trans values (4988,32004,103,'1997-4-8','PRIJEM','VKLAD',15505.00,59910.50,NULL,NULL,NULL);
insert into tab_trans values (4988,32005,103,'1997-7-15','PRIJEM','VKLAD',29251.00,67730.40,NULL,NULL,NULL);
insert into tab_trans values (4988,32006,103,'1997-2-15','PRIJEM','VKLAD',18987.00,84644.00,NULL,NULL,NULL);
insert into tab_trans values (4988,32007,103,'1997-7-20','PRIJEM','VKLAD',48308.00,116038.40,NULL,NULL,NULL);
insert into tab_trans values (4988,32008,103,'1997-2-13','PRIJEM','VKLAD',34957.00,65657.00,NULL,NULL,NULL);
insert into tab_trans values (4988,32009,103,'1997-5-2','PRIJEM','VKLAD',7136.00,85860.40,NULL,NULL,NULL);
insert into tab_trans values (4988,32038,103,'1997-4-5','VYDAJ','VYBER',6900.00,44405.50,NULL,NULL,'0');
insert into tab_trans values (4988,32039,103,'1997-5-11','VYDAJ','VYBER',8700.00,54360.40,NULL,NULL,'0');
insert into tab_trans values (4988,32040,103,'1997-6-10','VYDAJ','VYBER',6600.00,37026.60,NULL,NULL,'0');
insert into tab_trans values (4988,32041,103,'1997-7-8','VYDAJ','VYBER',5800.00,38479.40,NULL,NULL,'0');
insert into tab_trans values (4988,32042,103,'1997-8-18','VYDAJ','VYBER',7500.00,37640.40,NULL,NULL,'0');
insert into tab_trans values (4988,32043,103,'1997-9-19','VYDAJ','VYBER',9300.00,20000.00,NULL,NULL,'0');
insert into tab_trans values (4988,32044,103,'1997-10-12','VYDAJ','VYBER',10300.00,13505.50,NULL,NULL,'0');
insert into tab_trans values (4988,32045,103,'1997-11-2','VYDAJ','VYBER',7900.00,4759.80,NULL,NULL,'0');
insert into tab_trans values (4988,32062,103,'1997-8-13','VYBER','VYBER',23736.00,45140.40,NULL,NULL,NULL);
insert into tab_trans values (4988,32063,103,'1997-11-1','VYBER','VYBER',14689.00,12659.80,NULL,NULL,NULL);
insert into tab_trans values (4988,32064,103,'1997-5-22','VYBER','VYBER',22734.00,69875.40,NULL,NULL,NULL);
insert into tab_trans values (4988,32066,103,'1997-6-1','VYBER','VYBER',14782.00,48426.60,NULL,NULL,NULL);
insert into tab_trans values (4988,32068,103,'1997-9-5','VYBER','VYBER',6231.00,29300.00,NULL,NULL,NULL);
insert into tab_trans values (4988,32069,103,'1997-9-20','VYBER','VYBER',19621.00,379.00,NULL,NULL,NULL);
insert into tab_trans values (4988,32107,103,'1997-4-30','VYDAJ','VYBER',1500.00,78739.00,NULL,NULL,NULL);
insert into tab_trans values (4988,32108,103,'1997-9-2','VYDAJ','VYBER',2100.00,35531.00,NULL,NULL,NULL);
insert into tab_trans values (4988,32110,103,'1997-5-28','VYDAJ','VYBER',7200.00,62675.40,NULL,NULL,NULL);
insert into tab_trans values (4988,32133,103,'1997-4-30','VYDAJ','VYBER',14.60,78724.40,'SLUZBY',NULL,NULL);
insert into tab_trans values (4988,32134,103,'1997-5-31','VYDAJ','VYBER',14.60,63208.60,'SLUZBY',NULL,NULL);
insert into tab_trans values (4988,32135,103,'1997-6-30','VYDAJ','VYBER',14.60,45579.40,'SLUZBY',NULL,NULL);
insert into tab_trans values (4988,32136,103,'1997-7-31','VYDAJ','VYBER',14.60,97576.40,'SLUZBY',NULL,NULL);
insert into tab_trans values (4988,32137,103,'1997-8-31','VYDAJ','VYBER',14.60,38131.00,'SLUZBY',NULL,NULL);
insert into tab_trans values (4988,32138,103,'1997-9-30','VYDAJ','VYBER',14.60,505.50,'SLUZBY',NULL,NULL);
insert into tab_trans values (4988,32139,103,'1997-10-31','VYDAJ','VYBER',14.60,27353.20,'SLUZBY',NULL,NULL);
insert into tab_trans values (4988,32140,103,'1997-11-30','VYDAJ','VYBER',14.60,19978.20,'SLUZBY',NULL,NULL);
insert into tab_trans values (4988,32153,103,'1996-4-9','PRIJEM','VKLAD',12900.00,13900.00,NULL,NULL,NULL);
insert into tab_trans values (4988,32154,103,'1996-5-9','PRIJEM','VKLAD',6200.00,20100.00,NULL,NULL,NULL);
insert into tab_trans values (4988,32155,103,'1996-6-8','PRIJEM','VKLAD',4300.00,24400.00,NULL,NULL,NULL);
insert into tab_trans values (4988,32156,103,'1996-7-8','PRIJEM','VKLAD',2500.00,26900.00,NULL,NULL,NULL);
insert into tab_trans values (4988,32157,103,'1996-8-7','VYDAJ','VYBER',1500.00,25400.00,NULL,NULL,NULL);
insert into tab_trans values (4988,32158,103,'1996-9-6','PRIJEM','VKLAD',1700.00,27100.00,NULL,NULL,NULL);
insert into tab_trans values (4988,32159,103,'1996-10-6','PRIJEM','VKLAD',1700.00,28800.00,NULL,NULL,NULL);
insert into tab_trans values (4988,32160,103,'1996-11-5','PRIJEM','VKLAD',4900.00,33700.00,NULL,NULL,NULL);
insert into tab_trans values (4988,32161,103,'1996-12-5','VYDAJ','VYBER',1500.00,32200.00,NULL,NULL,NULL);
insert into tab_trans values (4988,32162,103,'1997-2-3','VYDAJ','VYBER',1500.00,30700.00,NULL,NULL,NULL);
insert into tab_trans values (4988,32163,103,'1997-3-5','VYDAJ','VYBER',22500.00,62535.80,NULL,NULL,NULL);
insert into tab_trans values (4988,32164,103,'1997-3-8','VYDAJ','VYBER',53500.00,56932.80,NULL,NULL,NULL);
insert into tab_trans values (4988,32165,103,'1997-4-4','VYDAJ','VYBER',15000.00,51305.50,NULL,NULL,NULL);
insert into tab_trans values (4988,32166,103,'1997-5-4','VYDAJ','VYBER',22800.00,63060.40,NULL,NULL,NULL);
insert into tab_trans values (4988,32167,103,'1997-6-3','VYDAJ','VYBER',4800.00,43626.60,NULL,NULL,NULL);
insert into tab_trans values (4988,32168,103,'1997-7-3','VYDAJ','VYBER',1300.00,44279.40,NULL,NULL,NULL);
insert into tab_trans values (4988,32169,103,'1997-7-20','VYDAJ','VYBER',19000.00,97038.40,NULL,NULL,NULL);
insert into tab_trans values (4988,32170,103,'1997-8-2','VYDAJ','VYBER',28700.00,68876.40,NULL,NULL,NULL);
insert into tab_trans values (4988,32171,103,'1997-9-1','VYDAJ','VYBER',500.00,37631.00,NULL,NULL,NULL);
insert into tab_trans values (4988,32172,103,'1997-10-1','PRIJEM','VKLAD',23300.00,23805.50,NULL,NULL,NULL);
insert into tab_trans values (4988,32173,103,'1997-10-31','PRIJEM','VKLAD',13800.00,27305.50,NULL,NULL,NULL);
insert into tab_trans values (4988,32174,103,'1997-11-30','PRIJEM','VKLAD',15200.00,19959.80,NULL,NULL,NULL);
insert into tab_trans values (4988,3445106,103,'1997-2-28','PRIJEM',NULL,195.90,85035.80,'UROK',NULL,NULL);
insert into tab_trans values (4988,3445107,103,'1997-3-31','PRIJEM',NULL,279.20,66305.50,'UROK',NULL,NULL);
insert into tab_trans values (4988,3445108,103,'1997-4-30','PRIJEM',NULL,252.70,80239.00,'UROK',NULL,NULL);
insert into tab_trans values (4988,3445109,103,'1997-5-31','PRIJEM',NULL,274.00,62949.30,'UROK',NULL,NULL);
insert into tab_trans values (4988,3445110,103,'1997-6-30','PRIJEM',NULL,170.70,45423.30,'UROK',NULL,NULL);
insert into tab_trans values (4988,3445111,103,'1997-7-31','PRIJEM',NULL,276.30,97314.70,'UROK',NULL,NULL);
insert into tab_trans values (4988,3445112,103,'1997-8-31','PRIJEM',NULL,252.70,37893.10,'UROK',NULL,NULL);
insert into tab_trans values (4988,3445113,103,'1997-9-30','PRIJEM',NULL,75.40,454.40,'UROK',NULL,NULL);
insert into tab_trans values (4988,3445114,103,'1997-9-30','VYDAJ','VYBER',4.80,524.90,'SANKC. UROK',NULL,NULL);
insert into tab_trans values (4988,3445115,103,'1997-10-31','PRIJEM',NULL,33.40,27372.30,'UROK',NULL,NULL);
insert into tab_trans values (4988,3445116,103,'1997-10-31','VYDAJ','VYBER',4.50,27367.80,'SANKC. UROK',NULL,NULL);
insert into tab_trans values (4988,3445117,103,'1997-11-30','PRIJEM',NULL,17.50,19992.80,'UROK',NULL,NULL);
insert into tab_trans values (4988,3681217,103,'1997-2-28','PRIJEM',NULL,195.90,84839.90,'UROK',NULL,NULL);
insert into tab_trans values (4988,3681218,103,'1997-3-31','PRIJEM',NULL,279.50,66026.30,'UROK',NULL,NULL);
insert into tab_trans values (4988,3681219,103,'1997-4-30','PRIJEM',NULL,252.80,79986.30,'UROK',NULL,NULL);
insert into tab_trans values (4988,3681220,103,'1997-5-31','PRIJEM',NULL,273.90,63223.20,'UROK',NULL,NULL);
insert into tab_trans values (4988,3681221,103,'1997-6-30','PRIJEM',NULL,170.70,45594.00,'UROK',NULL,NULL);
insert into tab_trans values (4988,3681222,103,'1997-7-31','PRIJEM',NULL,276.30,97591.00,'UROK',NULL,NULL);
insert into tab_trans values (4988,3681223,103,'1997-8-31','PRIJEM',NULL,252.50,38145.60,'UROK',NULL,NULL);
insert into tab_trans values (4988,3681224,103,'1997-9-30','PRIJEM',NULL,75.40,529.70,'UROK',NULL,NULL);
insert into tab_trans values (4988,3681225,103,'1997-9-30','VYDAJ','VYBER',4.80,520.10,'SANKC. UROK',NULL,NULL);
insert into tab_trans values (4988,3681226,103,'1997-10-31','PRIJEM',NULL,33.40,27338.90,'UROK',NULL,NULL);
insert into tab_trans values (4988,3681227,103,'1997-10-31','VYDAJ','VYBER',4.40,27348.80,'SANKC. UROK',NULL,NULL);
insert into tab_trans values (4988,3681228,103,'1997-11-30','PRIJEM',NULL,15.50,19975.20,'UROK',NULL,NULL);
insert into tab_trans values (4989,32642,105,'1997-7-10','PRIJEM','VKLAD',800.00,800.00,NULL,NULL,NULL);
insert into tab_trans values (4989,32643,105,'1997-12-8','PRIJEM','VKLAD',49101.00,74394.10,NULL,NULL,NULL);
insert into tab_trans values (4989,32645,105,'1997-9-20','PRIJEM','VKLAD',5577.00,24877.00,NULL,NULL,NULL);
insert into tab_trans values (4989,32646,105,'1997-10-28','PRIJEM','VKLAD',41590.00,63305.00,NULL,NULL,NULL);
insert into tab_trans values (4989,32647,105,'1998-4-3','PRIJEM','VKLAD',36510.00,61933.50,NULL,NULL,NULL);
insert into tab_trans values (4989,32648,105,'1998-8-31','PRIJEM','VKLAD',32534.00,39440.40,NULL,NULL,NULL);
insert into tab_trans values (4989,32649,105,'1998-5-16','PRIJEM','VKLAD',30421.00,55835.80,NULL,NULL,NULL);
insert into tab_trans values (4989,32667,105,'1998-6-18','VYDAJ','VYBER',9800.00,14989.40,NULL,NULL,'0');
insert into tab_trans values (4989,32668,105,'1998-7-9','VYDAJ','VYBER',5000.00,16583.00,NULL,NULL,'0');
insert into tab_trans values (4989,32669,105,'1998-8-10','VYDAJ','VYBER',4700.00,16535.70,NULL,NULL,'0');
insert into tab_trans values (4989,32670,105,'1998-8-30','VYDAJ','VYBER',9700.00,6835.70,NULL,NULL,'0');
insert into tab_trans values (4989,32671,105,'1998-10-12','VYDAJ','VYBER',6000.00,20818.30,NULL,NULL,'0');
insert into tab_trans values (4989,32672,105,'1998-11-4','VYDAJ','VYBER',7400.00,23692.60,NULL,NULL,'0');
insert into tab_trans values (4989,32681,105,'1998-5-17','VYBER','VYBER',4019.00,51816.80,NULL,NULL,NULL);
insert into tab_trans values (4989,32686,105,'1998-6-7','VYDAJ','VYBER',11100.00,24789.40,NULL,NULL,NULL);
insert into tab_trans values (4989,32697,105,'1998-12-2','VYDAJ','VYBER',5700.00,30175.30,NULL,NULL,NULL);
insert into tab_trans values (4989,32698,105,'1998-9-7','VYDAJ','VYBER',6900.00,22325.80,NULL,NULL,NULL);
insert into tab_trans values (4989,32716,105,'1998-5-31','VYDAJ','VYBER',14.60,51989.40,'SLUZBY',NULL,NULL);
insert into tab_trans values (4989,32717,105,'1998-6-30','VYDAJ','VYBER',14.60,15083.00,'SLUZBY',NULL,NULL);
insert into tab_trans values (4989,32718,105,'1998-7-31','VYDAJ','VYBER',14.60,16635.70,'SLUZBY',NULL,NULL);
insert into tab_trans values (4989,32719,105,'1998-8-31','VYDAJ','VYBER',14.60,39425.80,'SLUZBY',NULL,NULL);
insert into tab_trans values (4989,32720,105,'1998-9-30','VYDAJ','VYBER',14.60,22418.30,'SLUZBY',NULL,NULL);
insert into tab_trans values (4989,32721,105,'1998-10-31','VYDAJ','VYBER',14.60,20892.60,'SLUZBY',NULL,NULL);
insert into tab_trans values (4989,32722,105,'1998-11-30','VYDAJ','VYBER',14.60,23775.30,'SLUZBY',NULL,NULL);
insert into tab_trans values (4989,32723,105,'1997-8-9','PRIJEM','VKLAD',15100.00,15900.00,NULL,NULL,NULL);
insert into tab_trans values (4989,32724,105,'1997-9-8','PRIJEM','VKLAD',3400.00,19300.00,NULL,NULL,NULL);
insert into tab_trans values (4989,32725,105,'1997-10-8','VYDAJ','VYBER',3200.00,21715.00,NULL,NULL,NULL);
insert into tab_trans values (4989,32726,105,'1997-11-7','VYDAJ','VYBER',24500.00,38929.30,NULL,NULL,NULL);
insert into tab_trans values (4989,32727,105,'1997-12-7','VYDAJ','VYBER',13900.00,25293.10,NULL,NULL,NULL);
insert into tab_trans values (4989,32728,105,'1998-1-6','VYDAJ','VYBER',29900.00,44793.60,NULL,NULL,NULL);
insert into tab_trans values (4989,32729,105,'1998-2-5','VYDAJ','VYBER',14400.00,30703.60,NULL,NULL,NULL);
insert into tab_trans values (4989,32730,105,'1998-3-7','VYDAJ','VYBER',5900.00,25113.60,NULL,NULL,NULL);
insert into tab_trans values (4989,32731,105,'1998-4-6','VYDAJ','VYBER',24600.00,37333.50,NULL,NULL,NULL);
insert into tab_trans values (4989,32732,105,'1998-5-6','VYDAJ','VYBER',12100.00,25414.80,NULL,NULL,NULL);
insert into tab_trans values (4989,32733,105,'1998-6-5','VYDAJ','VYBER',16100.00,35889.40,NULL,NULL,NULL);
insert into tab_trans values (4989,32734,105,'1998-7-5','PRIJEM','VKLAD',6500.00,21583.00,NULL,NULL,NULL);
insert into tab_trans values (4989,32735,105,'1998-8-4','PRIJEM','VKLAD',4600.00,21235.70,NULL,NULL,NULL);
insert into tab_trans values (4989,32736,105,'1998-9-3','VYDAJ','VYBER',10200.00,29225.80,NULL,NULL,NULL);
insert into tab_trans values (4989,32737,105,'1998-10-3','PRIJEM','VKLAD',4400.00,26818.30,NULL,NULL,NULL);
insert into tab_trans values (4989,32738,105,'1998-11-2','PRIJEM','VKLAD',10200.00,31092.60,NULL,NULL,NULL);
insert into tab_trans values (4989,32739,105,'1998-12-2','PRIJEM','VKLAD',12100.00,35875.30,NULL,NULL,NULL);
insert into tab_trans values (4989,3534001,105,'1997-9-30','PRIJEM',NULL,38.00,24915.00,'UROK',NULL,NULL);
insert into tab_trans values (4989,3534002,105,'1997-10-31','PRIJEM',NULL,124.30,63429.30,'UROK',NULL,NULL);
insert into tab_trans values (4989,3534003,105,'1997-11-30','PRIJEM',NULL,263.80,39193.10,'UROK',NULL,NULL);
insert into tab_trans values (4989,3534004,105,'1997-12-31','PRIJEM',NULL,299.50,74693.60,'UROK',NULL,NULL);
insert into tab_trans values (4989,3534005,105,'1998-1-31','PRIJEM',NULL,310.00,45103.60,'UROK',NULL,NULL);
insert into tab_trans values (4989,3534006,105,'1998-2-28','PRIJEM',NULL,310.00,31013.60,'UROK',NULL,NULL);
insert into tab_trans values (4989,3534007,105,'1998-3-31','PRIJEM',NULL,310.00,25423.50,'UROK',NULL,NULL);
insert into tab_trans values (4989,3534008,105,'1998-4-30','PRIJEM',NULL,181.30,37514.80,'UROK',NULL,NULL);
insert into tab_trans values (4989,3534009,105,'1998-5-31','PRIJEM',NULL,187.20,52004.00,'UROK',NULL,NULL);
insert into tab_trans values (4989,3534010,105,'1998-6-30','PRIJEM',NULL,108.20,15097.60,'UROK',NULL,NULL);
insert into tab_trans values (4989,3534011,105,'1998-7-31','PRIJEM',NULL,67.40,16650.30,'UROK',NULL,NULL);
insert into tab_trans values (4989,3534012,105,'1998-8-31','PRIJEM',NULL,70.60,6906.40,'UROK',NULL,NULL);
insert into tab_trans values (4989,3534013,105,'1998-9-30','PRIJEM',NULL,107.10,22432.90,'UROK',NULL,NULL);
insert into tab_trans values (4989,3534014,105,'1998-10-31','PRIJEM',NULL,88.90,20907.20,'UROK',NULL,NULL);
insert into tab_trans values (4989,3534015,105,'1998-11-30','PRIJEM',NULL,97.30,23789.90,'UROK',NULL,NULL);
insert into tab_trans values (4990,34076,110,'1996-7-17','PRIJEM','VKLAD',900.00,900.00,NULL,NULL,NULL);
insert into tab_trans values (4990,34084,110,'1996-8-13','PRIJEM','VKLAD',23438.00,24338.00,NULL,NULL,NULL);
insert into tab_trans values (4990,34085,110,'1996-9-13','PRIJEM','VKLAD',23438.00,48329.40,NULL,NULL,NULL);
insert into tab_trans values (4990,34086,110,'1996-10-13','PRIJEM','VKLAD',23438.00,63103.50,NULL,NULL,NULL);
insert into tab_trans values (4990,34087,110,'1996-11-13','PRIJEM','VKLAD',23438.00,66313.50,NULL,NULL,NULL);
insert into tab_trans values (4990,34088,110,'1996-12-13','PRIJEM','VKLAD',35157.00,79652.20,NULL,NULL,NULL);
insert into tab_trans values (4990,34089,110,'1997-1-13','PRIJEM','VKLAD',23438.00,72340.40,NULL,NULL,NULL);
insert into tab_trans values (4990,34090,110,'1997-2-13','PRIJEM','VKLAD',23438.00,52942.60,NULL,NULL,NULL);
insert into tab_trans values (4990,34091,110,'1997-3-13','PRIJEM','VKLAD',23438.00,70035.10,NULL,NULL,NULL);
insert into tab_trans values (4990,34092,110,'1997-4-13','PRIJEM','VKLAD',23438.00,65406.50,NULL,NULL,NULL);
insert into tab_trans values (4990,34093,110,'1997-5-13','PRIJEM','VKLAD',23438.00,65284.40,NULL,NULL,NULL);
insert into tab_trans values (4990,34094,110,'1997-6-13','PRIJEM','VKLAD',35157.00,66482.20,NULL,NULL,NULL);
insert into tab_trans values (4990,34095,110,'1997-7-13','PRIJEM','VKLAD',23438.00,54505.00,NULL,NULL,NULL);
insert into tab_trans values (4990,34096,110,'1997-8-13','PRIJEM','VKLAD',23438.00,58379.80,NULL,NULL,NULL);
insert into tab_trans values (4990,34125,110,'1997-1-6','VYDAJ','PREVOD NA UCET',3050.00,51280.40,'SIPO','OP','24390584');
insert into tab_trans values (4990,34126,110,'1997-2-6','VYDAJ','PREVOD NA UCET',3050.00,30602.60,'SIPO','OP','24390584');
insert into tab_trans values (4990,34127,110,'1997-3-6','VYDAJ','PREVOD NA UCET',3050.00,46695.10,'SIPO','OP','24390584');
insert into tab_trans values (4990,34128,110,'1997-4-6','VYDAJ','PREVOD NA UCET',3050.00,42066.50,'SIPO','OP','24390584');
insert into tab_trans values (4990,34129,110,'1997-5-6','VYDAJ','PREVOD NA UCET',3050.00,41944.40,'SIPO','OP','24390584');
insert into tab_trans values (4990,34130,110,'1997-6-6','VYDAJ','PREVOD NA UCET',3050.00,39423.20,'SIPO','OP','24390584');
insert into tab_trans values (4990,34131,110,'1997-7-6','VYDAJ','PREVOD NA UCET',3050.00,32665.00,'SIPO','OP','24390584');
insert into tab_trans values (4990,34132,110,'1997-8-6','VYDAJ','PREVOD NA UCET',3050.00,47039.80,'SIPO','OP','24390584');
insert into tab_trans values (4990,34133,110,'1997-9-6','VYDAJ','PREVOD NA UCET',3050.00,55539.80,'SIPO','OP','24390584');
insert into tab_trans values (4990,34161,110,'1997-1-9','VYDAJ','PREVOD NA UCET',98.00,49862.40,NULL,'YZ','18149984');
insert into tab_trans values (4990,34162,110,'1997-2-9','VYDAJ','PREVOD NA UCET',98.00,30504.60,NULL,'YZ','18149984');
insert into tab_trans values (4990,34163,110,'1997-3-9','VYDAJ','PREVOD NA UCET',98.00,46597.10,NULL,'YZ','18149984');
insert into tab_trans values (4990,34164,110,'1997-4-9','VYDAJ','PREVOD NA UCET',98.00,41968.50,NULL,'YZ','18149984');
insert into tab_trans values (4990,34165,110,'1997-5-9','VYDAJ','PREVOD NA UCET',98.00,41846.40,NULL,'YZ','18149984');
insert into tab_trans values (4990,34166,110,'1997-6-9','VYDAJ','PREVOD NA UCET',98.00,39325.20,NULL,'YZ','18149984');
insert into tab_trans values (4990,34167,110,'1997-7-9','VYDAJ','PREVOD NA UCET',98.00,32567.00,NULL,'YZ','18149984');
insert into tab_trans values (4990,34168,110,'1997-8-9','VYDAJ','PREVOD NA UCET',98.00,46941.80,NULL,'YZ','18149984');
insert into tab_trans values (4990,34197,110,'1997-1-22','VYDAJ','VYBER',3700.00,42980.40,NULL,NULL,'0');
insert into tab_trans values (4990,34198,110,'1997-1-28','VYDAJ','VYBER',5200.00,35860.40,NULL,NULL,'0');
insert into tab_trans values (4990,34199,110,'1997-3-13','VYDAJ','VYBER',4500.00,65535.10,NULL,NULL,'0');
insert into tab_trans values (4990,34200,110,'1997-4-19','VYDAJ','VYBER',3600.00,44806.50,NULL,NULL,'0');
insert into tab_trans values (4990,34201,110,'1997-5-21','VYDAJ','VYBER',4800.00,42284.40,NULL,NULL,'0');
insert into tab_trans values (4990,34202,110,'1997-6-12','VYDAJ','VYBER',3500.00,31325.20,NULL,NULL,'0');
insert into tab_trans values (4990,34203,110,'1997-6-30','VYDAJ','VYBER',4900.00,35715.00,NULL,NULL,'0');
insert into tab_trans values (4990,34204,110,'1997-7-31','VYDAJ','VYBER',4600.00,50089.80,NULL,NULL,'0');
insert into tab_trans values (4990,34222,110,'1997-6-18','VYDAJ','VYBER',20160.00,40442.20,NULL,NULL,NULL);
insert into tab_trans values (4990,34230,110,'1997-1-23','VYDAJ','VYBER',1920.00,41060.40,NULL,NULL,NULL);
insert into tab_trans values (4990,34231,110,'1997-1-19','VYDAJ','VYBER',1080.00,46680.40,NULL,NULL,NULL);
insert into tab_trans values (4990,34232,110,'1997-1-17','VYDAJ','VYBER',2880.00,47760.40,NULL,NULL,NULL);
insert into tab_trans values (4990,34233,110,'1997-1-28','VYDAJ','VYBER',2400.00,33460.40,NULL,NULL,NULL);
insert into tab_trans values (4990,34234,110,'1997-1-9','VYDAJ','VYBER',1320.00,49960.40,NULL,NULL,NULL);
insert into tab_trans values (4990,34235,110,'1997-1-10','VYDAJ','VYBER',960.00,48902.40,NULL,NULL,NULL);
insert into tab_trans values (4990,34244,110,'1996-12-13','VYDAJ','VYBER',2520.00,77132.20,NULL,NULL,NULL);
insert into tab_trans values (4990,34245,110,'1997-6-13','VYDAJ','VYBER',5880.00,60602.20,NULL,NULL,NULL);
insert into tab_trans values (4990,34248,110,'1997-2-15','VYDAJ','VYBER',3360.00,49582.60,NULL,NULL,NULL);
insert into tab_trans values (4990,34267,110,'1996-12-31','VYDAJ','VYBER',14.60,54330.40,'SLUZBY',NULL,NULL);
insert into tab_trans values (4990,34268,110,'1997-1-31','VYDAJ','VYBER',14.60,33652.60,'SLUZBY',NULL,NULL);
insert into tab_trans values (4990,34269,110,'1997-2-28','VYDAJ','VYBER',14.60,49745.10,'SLUZBY',NULL,NULL);
insert into tab_trans values (4990,34270,110,'1997-3-31','VYDAJ','VYBER',14.60,45116.50,'SLUZBY',NULL,NULL);
insert into tab_trans values (4990,34271,110,'1997-4-30','VYDAJ','VYBER',14.60,44994.40,'SLUZBY',NULL,NULL);
insert into tab_trans values (4990,34272,110,'1997-5-31','VYDAJ','VYBER',14.60,42473.20,'SLUZBY',NULL,NULL);
insert into tab_trans values (4990,34273,110,'1997-6-30','VYDAJ','VYBER',14.60,40615.00,'SLUZBY',NULL,NULL);
insert into tab_trans values (4990,34274,110,'1997-7-31','VYDAJ','VYBER',14.60,54689.80,'SLUZBY',NULL,NULL);
insert into tab_trans values (4990,34275,110,'1997-8-31','VYDAJ','VYBER',14.60,58589.80,'SLUZBY',NULL,NULL);
insert into tab_trans values (4990,34291,110,'1996-8-16','PRIJEM','VKLAD',500.00,24838.00,NULL,NULL,NULL);
insert into tab_trans values (4990,34292,110,'1996-9-15','VYDAJ','VYBER',8800.00,39529.40,NULL,NULL,NULL);
insert into tab_trans values (4990,34293,110,'1996-10-15','VYDAJ','VYBER',20400.00,42703.50,NULL,NULL,NULL);
insert into tab_trans values (4990,34294,110,'1996-11-14','VYDAJ','VYBER',22000.00,44313.50,NULL,NULL,NULL);
insert into tab_trans values (4990,34295,110,'1996-12-14','VYDAJ','VYBER',23000.00,54132.20,NULL,NULL,NULL);
insert into tab_trans values (4990,34296,110,'1997-1-13','VYDAJ','VYBER',21700.00,50640.40,NULL,NULL,NULL);
insert into tab_trans values (4990,34297,110,'1997-2-12','VYDAJ','VYBER',1000.00,29504.60,NULL,NULL,NULL);
insert into tab_trans values (4990,34298,110,'1997-3-14','VYDAJ','VYBER',20600.00,44935.10,NULL,NULL,NULL);
insert into tab_trans values (4990,34299,110,'1997-4-13','VYDAJ','VYBER',17000.00,48406.50,NULL,NULL,NULL);
insert into tab_trans values (4990,34300,110,'1997-5-13','VYDAJ','VYBER',18200.00,47084.40,NULL,NULL,NULL);
insert into tab_trans values (4990,34301,110,'1997-6-12','VYDAJ','VYBER',4500.00,34825.20,NULL,NULL,NULL);
insert into tab_trans values (4990,34302,110,'1997-7-12','VYDAJ','VYBER',1500.00,31067.00,NULL,NULL,NULL);
insert into tab_trans values (4990,34303,110,'1997-8-11','VYDAJ','VYBER',12000.00,34941.80,NULL,NULL,NULL);
insert into tab_trans values (4990,3534173,110,'1996-8-31','PRIJEM',NULL,53.40,24891.40,'UROK',NULL,NULL);
insert into tab_trans values (4990,3534174,110,'1996-9-30','PRIJEM',NULL,136.10,39665.50,'UROK',NULL,NULL);
insert into tab_trans values (4990,3534175,110,'1996-10-31','PRIJEM',NULL,172.00,42875.50,'UROK',NULL,NULL);
insert into tab_trans values (4990,3534176,110,'1996-11-30','PRIJEM',NULL,181.70,44495.20,'UROK',NULL,NULL);
insert into tab_trans values (4990,3534177,110,'1996-12-31','PRIJEM',NULL,212.80,54345.00,'UROK',NULL,NULL);
insert into tab_trans values (4990,3534178,110,'1997-1-31','PRIJEM',NULL,206.80,33667.20,'UROK',NULL,NULL);
insert into tab_trans values (4990,3534179,110,'1997-2-28','PRIJEM',NULL,177.10,49759.70,'UROK',NULL,NULL);
insert into tab_trans values (4990,3534180,110,'1997-3-31','PRIJEM',NULL,196.00,45131.10,'UROK',NULL,NULL);
insert into tab_trans values (4990,3534181,110,'1997-4-30','PRIJEM',NULL,202.50,45009.00,'UROK',NULL,NULL);
insert into tab_trans values (4990,3534182,110,'1997-5-31','PRIJEM',NULL,203.40,42487.80,'UROK',NULL,NULL);
insert into tab_trans values (4990,3534183,110,'1997-6-30','PRIJEM',NULL,187.40,40629.60,'UROK',NULL,NULL);
insert into tab_trans values (4990,3534184,110,'1997-7-31','PRIJEM',NULL,199.30,54704.40,'UROK',NULL,NULL);
insert into tab_trans values (4990,3534185,110,'1997-8-31','PRIJEM',NULL,224.70,58604.40,'UROK',NULL,NULL);
insert into tab_trans values (4996,40404,132,'1996-5-11','PRIJEM','VKLAD',200.00,200.00,NULL,NULL,NULL);
insert into tab_trans values (4996,40409,132,'1996-9-13','PRIJEM','VKLAD',21375.00,75669.40,NULL,NULL,NULL);
insert into tab_trans values (4996,40410,132,'1996-5-22','PRIJEM','VKLAD',33953.00,82129.00,NULL,NULL,NULL);
insert into tab_trans values (4996,40412,132,'1996-6-27','PRIJEM','VKLAD',34460.00,87405.90,NULL,NULL,NULL);
insert into tab_trans values (4996,40414,132,'1996-7-14','PRIJEM','VKLAD',31623.00,88574.00,NULL,NULL,NULL);
insert into tab_trans values (4996,40415,132,'1996-7-30','PRIJEM','VKLAD',14665.00,103239.00,NULL,NULL,NULL);
insert into tab_trans values (4996,40417,132,'1996-5-21','PRIJEM','VKLAD',47976.00,48176.00,NULL,NULL,NULL);
insert into tab_trans values (4996,40418,132,'1996-10-17','PRIJEM','VKLAD',14699.00,85225.10,NULL,NULL,NULL);
insert into tab_trans values (4996,40419,132,'1996-10-12','PRIJEM','VKLAD',29380.00,70526.10,NULL,NULL,NULL);
insert into tab_trans values (4996,40421,132,'1996-9-6','PRIJEM','VKLAD',39794.00,75794.40,NULL,NULL,NULL);
insert into tab_trans values (4996,40459,132,'1996-8-19','VYDAJ','VYBER',7200.00,35900.50,NULL,NULL,'0');
insert into tab_trans values (4996,40460,132,'1996-9-17','VYDAJ','VYBER',9300.00,51036.40,NULL,NULL,'0');
insert into tab_trans values (4996,40461,132,'1996-10-18','VYDAJ','VYBER',6500.00,78725.10,NULL,NULL,'0');
insert into tab_trans values (4996,40500,132,'1996-9-15','VYBER','VYBER',15333.00,60336.40,NULL,NULL,NULL);
insert into tab_trans values (4996,40560,132,'1996-8-9','VYDAJ','VYBER',4200.00,43100.50,NULL,NULL,NULL);
insert into tab_trans values (4996,40575,132,'1996-7-31','VYDAJ','VYBER',100.00,68400.50,'SLUZBY',NULL,NULL);
insert into tab_trans values (4996,40576,132,'1996-8-31','VYDAJ','VYBER',100.00,36000.40,'SLUZBY',NULL,NULL);
insert into tab_trans values (4996,40577,132,'1996-9-30','VYDAJ','VYBER',100.00,51146.10,'SLUZBY',NULL,NULL);
insert into tab_trans values (4996,40578,132,'1996-10-31','VYDAJ','VYBER',100.00,78907.60,'SLUZBY',NULL,NULL);
insert into tab_trans values (4996,40604,132,'1996-6-10','VYDAJ','VYBER',29300.00,52945.90,NULL,NULL,NULL);
insert into tab_trans values (4996,40605,132,'1996-7-10','VYDAJ','VYBER',30800.00,56951.00,NULL,NULL,NULL);
insert into tab_trans values (4996,40606,132,'1996-7-30','VYDAJ','VYBER',35100.00,68139.00,NULL,NULL,NULL);
insert into tab_trans values (4996,40607,132,'1996-8-9','VYDAJ','VYBER',21100.00,47300.50,NULL,NULL,NULL);
insert into tab_trans values (4996,40608,132,'1996-9-8','VYDAJ','VYBER',21500.00,54294.40,NULL,NULL,NULL);
insert into tab_trans values (4996,40609,132,'1996-10-8','VYDAJ','VYBER',10000.00,41146.10,NULL,NULL,NULL);
insert into tab_trans values (4996,3534923,132,'1996-5-31','PRIJEM',NULL,116.90,82245.90,'UROK',NULL,NULL);
insert into tab_trans values (4996,3534924,132,'1996-6-30','PRIJEM',NULL,345.10,87751.00,'UROK',NULL,NULL);
insert into tab_trans values (4996,3534925,132,'1996-7-31','PRIJEM',NULL,361.60,68500.50,'UROK',NULL,NULL);
insert into tab_trans values (4996,3534926,132,'1996-8-31','PRIJEM',NULL,199.90,36100.40,'UROK',NULL,NULL);
insert into tab_trans values (4996,3534927,132,'1996-9-30','PRIJEM',NULL,209.70,51246.10,'UROK',NULL,NULL);
insert into tab_trans values (4996,3534928,132,'1996-10-31','PRIJEM',NULL,282.60,79007.60,'UROK',NULL,NULL);
insert into tab_trans values (5002,51521,173,'1993-11-26','PRIJEM','VKLAD',500.00,500.00,NULL,NULL,NULL);
insert into tab_trans values (5002,51533,173,'1993-12-9','PRIJEM','VKLAD',25970.00,26470.00,NULL,NULL,NULL);
insert into tab_trans values (5002,51534,173,'1994-1-9','PRIJEM','VKLAD',17313.00,41502.50,NULL,NULL,NULL);
insert into tab_trans values (5002,51535,173,'1994-2-9','PRIJEM','VKLAD',17313.00,52226.20,NULL,NULL,NULL);
insert into tab_trans values (5002,51536,173,'1994-3-9','PRIJEM','VKLAD',17313.00,56787.60,NULL,NULL,NULL);
insert into tab_trans values (5002,51537,173,'1994-4-9','PRIJEM','VKLAD',17313.00,57865.30,NULL,NULL,NULL);
insert into tab_trans values (5002,51538,173,'1994-5-9','PRIJEM','VKLAD',17313.00,49323.40,NULL,NULL,NULL);
insert into tab_trans values (5002,51609,173,'1994-4-11','VYDAJ','PREVOD NA UCET',6256.00,51609.30,'SIPO','KL','95605074');
insert into tab_trans values (5002,51610,173,'1994-5-11','VYDAJ','PREVOD NA UCET',6256.00,43067.40,'SIPO','KL','95605074');
insert into tab_trans values (5002,51681,173,'1994-4-14','VYDAJ','PREVOD NA UCET',1428.00,40457.30,NULL,'KL','26238835');
insert into tab_trans values (5002,51682,173,'1994-5-14','VYDAJ','PREVOD NA UCET',1428.00,40715.40,NULL,'KL','26238835');
insert into tab_trans values (5002,51753,173,'1994-4-12','VYDAJ','PREVOD NA UCET',735.00,50874.30,'POJISTNE','CD','85405385');
insert into tab_trans values (5002,51754,173,'1994-5-12','VYDAJ','PREVOD NA UCET',735.00,42332.40,'POJISTNE','CD','85405385');
insert into tab_trans values (5002,51825,173,'1994-4-13','VYDAJ','PREVOD NA UCET',189.00,50685.30,NULL,'CD','50065535');
insert into tab_trans values (5002,51826,173,'1994-5-13','VYDAJ','PREVOD NA UCET',189.00,42143.40,NULL,'CD','50065535');
insert into tab_trans values (5002,51897,173,'1994-4-14','VYDAJ','VYBER',8800.00,41885.30,NULL,NULL,'0');
insert into tab_trans values (5002,51898,173,'1994-5-17','VYDAJ','VYBER',8800.00,31915.40,NULL,NULL,'0');
insert into tab_trans values (5002,52016,173,'1994-5-2','VYDAJ','VYBER',2400.00,32010.40,NULL,NULL,NULL);
insert into tab_trans values (5002,52050,173,'1994-4-30','VYDAJ','VYBER',14.60,34410.40,'SLUZBY',NULL,NULL);
insert into tab_trans values (5002,52106,173,'1993-12-26','VYDAJ','VYBER',2300.00,24170.00,NULL,NULL,NULL);
insert into tab_trans values (5002,52107,173,'1994-1-25','VYDAJ','VYBER',6700.00,34802.50,NULL,NULL,NULL);
insert into tab_trans values (5002,52108,173,'1994-2-24','VYDAJ','VYBER',12900.00,39326.20,NULL,NULL,NULL);
insert into tab_trans values (5002,52109,173,'1994-3-26','VYDAJ','VYBER',16400.00,40387.60,NULL,NULL,NULL);
insert into tab_trans values (5002,52110,173,'1994-4-25','VYDAJ','VYBER',6200.00,34257.30,NULL,NULL,NULL);
insert into tab_trans values (5002,52111,173,'1994-5-25','VYDAJ','VYBER',3900.00,28015.40,NULL,NULL,NULL);
insert into tab_trans values (5002,3536192,173,'1993-12-31','PRIJEM',NULL,19.50,24189.50,'UROK',NULL,NULL);
insert into tab_trans values (5002,3536193,173,'1994-1-31','PRIJEM',NULL,110.70,34913.20,'UROK',NULL,NULL);
insert into tab_trans values (5002,3536194,173,'1994-2-28','PRIJEM',NULL,148.40,39474.60,'UROK',NULL,NULL);
insert into tab_trans values (5002,3536195,173,'1994-3-31','PRIJEM',NULL,164.70,40552.30,'UROK',NULL,NULL);
insert into tab_trans values (5002,3536196,173,'1994-4-30','PRIJEM',NULL,167.70,34425.00,'UROK',NULL,NULL);
insert into tab_trans values (5005,53034,176,'1996-8-12','PRIJEM','VKLAD',800.00,800.00,NULL,NULL,NULL);
insert into tab_trans values (5005,53036,176,'1996-11-10','PRIJEM','VKLAD',10709.00,61196.10,NULL,NULL,NULL);
insert into tab_trans values (5005,53037,176,'1996-8-15','PRIJEM','VKLAD',8375.00,9175.00,NULL,NULL,NULL);
insert into tab_trans values (5005,53039,176,'1996-10-14','PRIJEM','VKLAD',11019.00,39561.30,NULL,NULL,NULL);
insert into tab_trans values (5005,53040,176,'1996-8-24','PRIJEM','VKLAD',42187.00,51362.00,NULL,NULL,NULL);
insert into tab_trans values (5005,53042,176,'1996-10-25','PRIJEM','VKLAD',11662.00,66347.30,NULL,NULL,NULL);
insert into tab_trans values (5005,53043,176,'1996-11-15','PRIJEM','VKLAD',44971.00,79370.10,NULL,NULL,NULL);
insert into tab_trans values (5005,53046,176,'1996-10-22','PRIJEM','VKLAD',15124.00,54685.30,NULL,NULL,NULL);
insert into tab_trans values (5005,53051,176,'1997-2-27','PRIJEM','VKLAD',21720.00,100790.40,NULL,NULL,NULL);
insert into tab_trans values (5005,53053,176,'1997-1-8','PRIJEM','VKLAD',24559.00,83503.50,NULL,NULL,NULL);
insert into tab_trans values (5005,53057,176,'1997-4-1','PRIJEM','VKLAD',34768.00,104138.90,NULL,NULL,NULL);
insert into tab_trans values (5005,53060,176,'1997-1-4','PRIJEM','VKLAD',46388.00,58944.50,NULL,NULL,NULL);
insert into tab_trans values (5005,53062,176,'1997-3-25','PRIJEM','VKLAD',47395.00,111282.30,NULL,NULL,NULL);
insert into tab_trans values (5005,53065,176,'1997-2-1','PRIJEM','VKLAD',19292.00,51365.40,NULL,NULL,NULL);
insert into tab_trans values (5005,53069,176,'1997-1-19','PRIJEM','VKLAD',18262.00,45468.50,NULL,NULL,NULL);
insert into tab_trans values (5005,53070,176,'1997-4-2','PRIJEM','VKLAD',26942.00,69180.90,NULL,NULL,NULL);
insert into tab_trans values (5005,53075,176,'1997-3-24','PRIJEM','VKLAD',17333.00,63887.30,NULL,NULL,NULL);
insert into tab_trans values (5005,53076,176,'1997-2-19','PRIJEM','VKLAD',21550.00,43018.40,NULL,NULL,NULL);
insert into tab_trans values (5005,53077,176,'1997-2-20','PRIJEM','VKLAD',36052.00,79070.40,NULL,NULL,NULL);
insert into tab_trans values (5005,53105,176,'1996-11-4','VYDAJ','VYBER',3100.00,50487.10,NULL,NULL,'0');
insert into tab_trans values (5005,53106,176,'1996-12-16','VYDAJ','VYBER',1700.00,12449.80,NULL,NULL,'0');
insert into tab_trans values (5005,53107,176,'1997-1-12','VYDAJ','VYBER',2100.00,38467.50,NULL,NULL,'0');
insert into tab_trans values (5005,53108,176,'1997-2-10','VYDAJ','VYBER',2500.00,26165.40,NULL,NULL,'0');
insert into tab_trans values (5005,53109,176,'1997-3-6','VYDAJ','VYBER',1500.00,99451.30,NULL,NULL,'0');
insert into tab_trans values (5005,53141,176,'1996-11-12','VYDAJ','PREVOD NA UCET',4564.00,34496.10,'SIPO','AB','55640232');
insert into tab_trans values (5005,53142,176,'1996-12-12','VYDAJ','PREVOD NA UCET',4564.00,14246.80,'SIPO','AB','55640232');
insert into tab_trans values (5005,53143,176,'1997-1-12','VYDAJ','PREVOD NA UCET',4564.00,33903.50,'SIPO','AB','55640232');
insert into tab_trans values (5005,53144,176,'1997-2-12','VYDAJ','PREVOD NA UCET',4564.00,21565.40,'SIPO','AB','55640232');
insert into tab_trans values (5005,53145,176,'1997-3-12','VYDAJ','PREVOD NA UCET',4564.00,46651.30,'SIPO','AB','55640232');
insert into tab_trans values (5005,53177,176,'1996-11-11','VYDAJ','PREVOD NA UCET',36.00,39060.10,NULL,'OP','90734010');
insert into tab_trans values (5005,53178,176,'1996-12-11','VYDAJ','PREVOD NA UCET',36.00,35993.80,NULL,'OP','90734010');
insert into tab_trans values (5005,53179,176,'1997-1-11','VYDAJ','PREVOD NA UCET',36.00,40567.50,NULL,'OP','90734010');
insert into tab_trans values (5005,53180,176,'1997-2-11','VYDAJ','PREVOD NA UCET',36.00,26129.40,NULL,'OP','90734010');
insert into tab_trans values (5005,53181,176,'1997-3-11','VYDAJ','PREVOD NA UCET',36.00,51215.30,NULL,'OP','90734010');
insert into tab_trans values (5005,53213,176,'1996-11-14','VYDAJ','PREVOD NA UCET',97.00,34399.10,'POJISTNE','QR','11736327');
insert into tab_trans values (5005,53214,176,'1996-12-14','VYDAJ','PREVOD NA UCET',97.00,14149.80,'POJISTNE','QR','11736327');
insert into tab_trans values (5005,53215,176,'1997-1-14','VYDAJ','PREVOD NA UCET',97.00,31406.50,'POJISTNE','QR','11736327');
insert into tab_trans values (5005,53216,176,'1997-2-14','VYDAJ','PREVOD NA UCET',97.00,21468.40,'POJISTNE','QR','11736327');
insert into tab_trans values (5005,53217,176,'1997-3-14','VYDAJ','PREVOD NA UCET',97.00,46554.30,'POJISTNE','QR','11736327');
insert into tab_trans values (5005,53239,176,'1996-12-12','VYBER','VYBER',17183.00,18810.80,NULL,NULL,NULL);
insert into tab_trans values (5005,53240,176,'1996-11-29','VYBER','VYBER',5976.00,71294.10,NULL,NULL,NULL);
insert into tab_trans values (5005,53248,176,'1996-11-2','VYBER','VYBER',12947.00,53587.10,NULL,NULL,NULL);
insert into tab_trans values (5005,53262,176,'1996-12-11','VYDAJ','VYBER',7800.00,36029.80,NULL,NULL,NULL);
insert into tab_trans values (5005,53271,176,'1997-1-22','VYDAJ','VYBER',8400.00,37068.50,NULL,NULL,NULL);
insert into tab_trans values (5005,53272,176,'1997-1-13','VYDAJ','VYBER',2400.00,31503.50,NULL,NULL,NULL);
insert into tab_trans values (5005,53273,176,'1997-1-14','VYDAJ','VYBER',1800.00,29606.50,NULL,NULL,NULL);
insert into tab_trans values (5005,53274,176,'1997-1-8','VYDAJ','VYBER',8400.00,75103.50,NULL,NULL,NULL);
insert into tab_trans values (5005,53275,176,'1997-1-18','VYDAJ','VYBER',2400.00,27206.50,NULL,NULL,NULL);
insert into tab_trans values (5005,53276,176,'1997-1-29','VYDAJ','VYBER',5100.00,31968.50,NULL,NULL,NULL);
insert into tab_trans values (5005,53284,176,'1996-11-17','VYDAJ','VYBER',2100.00,77270.10,NULL,NULL,NULL);
insert into tab_trans values (5005,53287,176,'1997-4-6','VYDAJ','VYBER',4200.00,64980.90,NULL,NULL,NULL);
insert into tab_trans values (5005,53306,176,'1996-10-31','VYDAJ','VYBER',30.00,66534.10,'SLUZBY',NULL,NULL);
insert into tab_trans values (5005,53307,176,'1996-11-30','VYDAJ','VYBER',30.00,71529.80,'SLUZBY',NULL,NULL);
insert into tab_trans values (5005,53308,176,'1996-12-31','VYDAJ','VYBER',30.00,12556.50,'SLUZBY',NULL,NULL);
insert into tab_trans values (5005,53309,176,'1997-1-31','VYDAJ','VYBER',30.00,32073.40,'SLUZBY',NULL,NULL);
insert into tab_trans values (5005,53310,176,'1997-2-28','VYDAJ','VYBER',30.00,100951.30,'SLUZBY',NULL,NULL);
insert into tab_trans values (5005,53311,176,'1997-3-31','VYDAJ','VYBER',30.00,69370.90,'SLUZBY',NULL,NULL);
insert into tab_trans values (5005,53332,176,'1996-9-11','VYDAJ','VYBER',14100.00,37328.30,NULL,NULL,NULL);
insert into tab_trans values (5005,53333,176,'1996-10-11','VYDAJ','VYBER',9000.00,28542.30,NULL,NULL,NULL);
insert into tab_trans values (5005,53334,176,'1996-11-10','VYDAJ','VYBER',22100.00,39096.10,NULL,NULL,NULL);
insert into tab_trans values (5005,53335,176,'1996-12-10','VYDAJ','VYBER',27700.00,43829.80,NULL,NULL,NULL);
insert into tab_trans values (5005,53336,176,'1997-1-9','VYDAJ','VYBER',34500.00,40603.50,NULL,NULL,NULL);
insert into tab_trans values (5005,53337,176,'1997-2-8','VYDAJ','VYBER',22700.00,28665.40,NULL,NULL,NULL);
insert into tab_trans values (5005,53338,176,'1997-3-10','VYDAJ','VYBER',48200.00,51251.30,NULL,NULL,NULL);
insert into tab_trans values (5005,53339,176,'1997-3-25','VYDAJ','VYBER',42200.00,69082.30,NULL,NULL,NULL);
insert into tab_trans values (5005,53340,176,'1997-4-1','VYDAJ','VYBER',61900.00,42238.90,NULL,NULL,NULL);
insert into tab_trans values (5005,53341,176,'1997-4-9','VYDAJ','VYBER',28700.00,36280.90,NULL,NULL,NULL);
insert into tab_trans values (5005,3536281,176,'1996-8-31','PRIJEM',NULL,66.30,51428.30,'UROK',NULL,NULL);
insert into tab_trans values (5005,3536282,176,'1996-9-30','PRIJEM',NULL,214.00,37542.30,'UROK',NULL,NULL);
insert into tab_trans values (5005,3536283,176,'1996-10-31','PRIJEM',NULL,216.80,66564.10,'UROK',NULL,NULL);
insert into tab_trans values (5005,3536284,176,'1996-11-30','PRIJEM',NULL,265.70,71559.80,'UROK',NULL,NULL);
insert into tab_trans values (5005,3536285,176,'1996-12-31','PRIJEM',NULL,136.70,12586.50,'UROK',NULL,NULL);
insert into tab_trans values (5005,3536286,176,'1997-1-31','PRIJEM',NULL,134.90,32103.40,'UROK',NULL,NULL);
insert into tab_trans values (5005,3536287,176,'1997-2-28','PRIJEM',NULL,190.90,100981.30,'UROK',NULL,NULL);
insert into tab_trans values (5005,3536288,176,'1997-3-31','PRIJEM',NULL,318.70,69400.90,'UROK',NULL,NULL);
insert into tab_trans values (5015,67923,226,'1997-2-23','PRIJEM','VKLAD',1000.00,1000.00,NULL,NULL,NULL);
insert into tab_trans values (5015,67926,226,'1997-3-8','PRIJEM','VKLAD',19059.00,20059.00,NULL,NULL,NULL);
insert into tab_trans values (5015,67927,226,'1997-4-8','PRIJEM','VKLAD',19059.00,41639.20,NULL,NULL,NULL);
insert into tab_trans values (5015,67928,226,'1997-5-8','PRIJEM','VKLAD',19059.00,52002.20,NULL,NULL,NULL);
insert into tab_trans values (5015,67929,226,'1997-6-8','PRIJEM','VKLAD',28588.00,72338.60,NULL,NULL,NULL);
insert into tab_trans values (5015,67930,226,'1997-7-8','PRIJEM','VKLAD',19059.00,68185.20,NULL,NULL,NULL);
insert into tab_trans values (5015,67931,226,'1997-8-8','PRIJEM','VKLAD',19059.00,56608.20,NULL,NULL,NULL);
insert into tab_trans values (5015,67932,226,'1997-9-8','PRIJEM','VKLAD',19059.00,61386.50,NULL,NULL,NULL);
insert into tab_trans values (5015,67933,226,'1997-10-8','PRIJEM','VKLAD',19059.00,55585.30,NULL,NULL,NULL);
insert into tab_trans values (5015,67934,226,'1997-11-8','PRIJEM','VKLAD',19059.00,60890.70,NULL,NULL,NULL);
insert into tab_trans values (5015,67935,226,'1997-12-8','PRIJEM','VKLAD',28588.00,69626.60,NULL,NULL,NULL);
insert into tab_trans values (5015,67936,226,'1998-1-8','PRIJEM','VKLAD',19059.00,64549.40,NULL,NULL,NULL);
insert into tab_trans values (5015,67937,226,'1998-2-8','PRIJEM','VKLAD',19059.00,44330.10,NULL,NULL,NULL);
insert into tab_trans values (5015,67938,226,'1998-3-8','PRIJEM','VKLAD',19059.00,66412.30,NULL,NULL,NULL);
insert into tab_trans values (5015,67939,226,'1998-4-8','PRIJEM','VKLAD',19059.00,59540.30,NULL,NULL,NULL);
insert into tab_trans values (5015,67940,226,'1998-5-8','PRIJEM','VKLAD',19059.00,59172.80,NULL,NULL,NULL);
insert into tab_trans values (5015,67941,226,'1998-6-8','PRIJEM','VKLAD',28588.00,80433.20,NULL,NULL,NULL);
insert into tab_trans values (5015,67942,226,'1998-7-8','PRIJEM','VKLAD',19059.00,75585.00,NULL,NULL,NULL);
insert into tab_trans values (5015,67954,226,'1997-7-11','VYDAJ','PREVOD NA UCET',8928.00,59257.20,'SIPO','UV','29971635');
insert into tab_trans values (5015,67955,226,'1997-8-11','VYDAJ','PREVOD NA UCET',8928.00,41920.20,'SIPO','UV','29971635');
insert into tab_trans values (5015,67956,226,'1997-9-11','VYDAJ','PREVOD NA UCET',8928.00,52458.50,'SIPO','UV','29971635');
insert into tab_trans values (5015,67957,226,'1997-10-11','VYDAJ','PREVOD NA UCET',8928.00,46657.30,'SIPO','UV','29971635');
insert into tab_trans values (5015,67958,226,'1997-11-11','VYDAJ','PREVOD NA UCET',8928.00,51962.70,'SIPO','UV','29971635');
insert into tab_trans values (5015,67959,226,'1997-12-11','VYDAJ','PREVOD NA UCET',8928.00,60698.60,'SIPO','UV','29971635');
insert into tab_trans values (5015,67960,226,'1998-1-11','VYDAJ','PREVOD NA UCET',8928.00,55621.40,'SIPO','UV','29971635');
insert into tab_trans values (5015,67961,226,'1998-2-11','VYDAJ','PREVOD NA UCET',8928.00,35402.10,'SIPO','UV','29971635');
insert into tab_trans values (5015,67962,226,'1998-3-11','VYDAJ','PREVOD NA UCET',8928.00,57484.30,'SIPO','UV','29971635');
insert into tab_trans values (5015,67963,226,'1998-4-11','VYDAJ','PREVOD NA UCET',8928.00,50612.30,'SIPO','UV','29971635');
insert into tab_trans values (5015,67964,226,'1998-5-11','VYDAJ','PREVOD NA UCET',8928.00,50244.80,'SIPO','UV','29971635');
insert into tab_trans values (5015,67965,226,'1998-6-11','VYDAJ','PREVOD NA UCET',8928.00,71505.20,'SIPO','UV','29971635');
insert into tab_trans values (5015,67966,226,'1998-7-11','VYDAJ','PREVOD NA UCET',8928.00,66657.00,'SIPO','UV','29971635');
insert into tab_trans values (5015,67978,226,'1997-7-12','VYDAJ','VYBER',6300.00,52957.20,NULL,NULL,'0');
insert into tab_trans values (5015,67979,226,'1997-8-5','VYDAJ','VYBER',7700.00,37549.20,NULL,NULL,'0');
insert into tab_trans values (5015,67980,226,'1997-9-11','VYDAJ','VYBER',8300.00,44158.50,NULL,NULL,'0');
insert into tab_trans values (5015,67981,226,'1997-10-3','VYDAJ','VYBER',8600.00,36526.30,NULL,NULL,'0');
insert into tab_trans values (5015,67982,226,'1997-11-12','VYDAJ','VYBER',6100.00,45862.70,NULL,NULL,'0');
insert into tab_trans values (5015,67983,226,'1997-12-6','VYDAJ','VYBER',7900.00,41038.60,NULL,NULL,'0');
insert into tab_trans values (5015,67984,226,'1998-1-13','VYDAJ','VYBER',8300.00,47321.40,NULL,NULL,'0');
insert into tab_trans values (5015,67985,226,'1998-2-6','VYDAJ','VYBER',6100.00,25271.10,NULL,NULL,'0');
insert into tab_trans values (5015,67986,226,'1998-3-15','VYDAJ','VYBER',7000.00,50484.30,NULL,NULL,'0');
insert into tab_trans values (5015,67987,226,'1998-4-2','VYDAJ','VYBER',11900.00,40481.30,NULL,NULL,'0');
insert into tab_trans values (5015,67988,226,'1998-5-5','VYDAJ','VYBER',11400.00,40113.80,NULL,NULL,'0');
insert into tab_trans values (5015,67989,226,'1998-6-12','VYDAJ','VYBER',7000.00,64505.20,NULL,NULL,'0');
insert into tab_trans values (5015,67999,226,'1998-1-26','VYDAJ','VYBER',14720.00,31201.40,NULL,NULL,NULL);
insert into tab_trans values (5015,68000,226,'1997-12-29','VYDAJ','VYBER',4320.00,45278.60,NULL,NULL,NULL);
insert into tab_trans values (5015,68002,226,'1997-12-22','VYDAJ','VYBER',4200.00,49598.60,NULL,NULL,NULL);
insert into tab_trans values (5015,68005,226,'1997-8-9','VYDAJ','VYBER',5760.00,50848.20,NULL,NULL,NULL);
insert into tab_trans values (5015,68006,226,'1997-8-20','VYDAJ','VYBER',2160.00,39760.20,NULL,NULL,NULL);
insert into tab_trans values (5015,68008,226,'1998-1-25','VYDAJ','VYBER KARTOU',2900.00,45921.40,NULL,NULL,'0');
insert into tab_trans values (5015,68017,226,'1997-7-31','VYDAJ','VYBER',14.60,45249.20,'SLUZBY',NULL,NULL);
insert into tab_trans values (5015,68018,226,'1997-8-31','VYDAJ','VYBER',14.60,42327.50,'SLUZBY',NULL,NULL);
insert into tab_trans values (5015,68019,226,'1997-9-30','VYDAJ','VYBER',14.60,45126.30,'SLUZBY',NULL,NULL);
insert into tab_trans values (5015,68020,226,'1997-10-31','VYDAJ','VYBER',14.60,41831.70,'SLUZBY',NULL,NULL);
insert into tab_trans values (5015,68021,226,'1997-11-30','VYDAJ','VYBER',14.60,48938.60,'SLUZBY',NULL,NULL);
insert into tab_trans values (5015,68022,226,'1997-12-31','VYDAJ','VYBER',14.60,45490.40,'SLUZBY',NULL,NULL);
insert into tab_trans values (5015,68023,226,'1998-1-31','VYDAJ','VYBER',14.60,31371.10,'SLUZBY',NULL,NULL);
insert into tab_trans values (5015,68024,226,'1998-2-28','VYDAJ','VYBER',14.60,47353.30,'SLUZBY',NULL,NULL);
insert into tab_trans values (5015,68025,226,'1998-3-31','VYDAJ','VYBER',14.60,52381.30,'SLUZBY',NULL,NULL);
insert into tab_trans values (5015,68026,226,'1998-4-30','VYDAJ','VYBER',14.60,51513.80,'SLUZBY',NULL,NULL);
insert into tab_trans values (5015,68027,226,'1998-5-31','VYDAJ','VYBER',14.60,51845.20,'SLUZBY',NULL,NULL);
insert into tab_trans values (5015,68028,226,'1998-6-30','VYDAJ','VYBER',14.60,56526.00,'SLUZBY',NULL,NULL);
insert into tab_trans values (5015,68034,226,'1997-3-25','PRIJEM','VKLAD',2500.00,22559.00,NULL,NULL,NULL);
insert into tab_trans values (5015,68035,226,'1997-4-24','VYDAJ','VYBER',8800.00,32839.20,NULL,NULL,NULL);
insert into tab_trans values (5015,68036,226,'1997-5-24','VYDAJ','VYBER',8400.00,43602.20,NULL,NULL,NULL);
insert into tab_trans values (5015,68037,226,'1997-6-23','VYDAJ','VYBER',23400.00,48938.60,NULL,NULL,NULL);
insert into tab_trans values (5015,68038,226,'1997-7-23','VYDAJ','VYBER',7900.00,45057.20,NULL,NULL,NULL);
insert into tab_trans values (5015,68039,226,'1997-8-22','PRIJEM','VKLAD',2400.00,42160.20,NULL,NULL,NULL);
insert into tab_trans values (5015,68040,226,'1997-9-21','PRIJEM','VKLAD',800.00,44958.50,NULL,NULL,NULL);
insert into tab_trans values (5015,68041,226,'1997-10-21','VYDAJ','VYBER',5000.00,41657.30,NULL,NULL,NULL);
insert into tab_trans values (5015,68042,226,'1997-11-20','PRIJEM','VKLAD',2900.00,48762.70,NULL,NULL,NULL);
insert into tab_trans values (5015,68043,226,'1997-12-20','VYDAJ','VYBER',6900.00,53798.60,NULL,NULL,NULL);
insert into tab_trans values (5015,68044,226,'1998-1-19','PRIJEM','VKLAD',1500.00,48821.40,NULL,NULL,NULL);
insert into tab_trans values (5015,68045,226,'1998-2-18','PRIJEM','VKLAD',11800.00,47202.10,NULL,NULL,NULL);
insert into tab_trans values (5015,68046,226,'1998-3-20','PRIJEM','VKLAD',1700.00,52184.30,NULL,NULL,NULL);
insert into tab_trans values (5015,68047,226,'1998-4-19','PRIJEM','VKLAD',700.00,51312.30,NULL,NULL,NULL);
insert into tab_trans values (5015,68048,226,'1998-5-19','PRIJEM','VKLAD',1400.00,51644.80,NULL,NULL,NULL);
insert into tab_trans values (5015,68049,226,'1998-6-18','VYDAJ','VYBER',8200.00,56305.20,NULL,NULL,NULL);
insert into tab_trans values (5015,3538010,226,'1997-3-31','PRIJEM',NULL,21.20,22580.20,'UROK',NULL,NULL);
insert into tab_trans values (5015,3538011,226,'1997-4-30','PRIJEM',NULL,104.00,32943.20,'UROK',NULL,NULL);
insert into tab_trans values (5015,3538012,226,'1997-5-31','PRIJEM',NULL,148.40,43750.60,'UROK',NULL,NULL);
insert into tab_trans values (5015,3538013,226,'1997-6-30','PRIJEM',NULL,187.60,49126.20,'UROK',NULL,NULL);
insert into tab_trans values (5015,3538014,226,'1997-7-31','PRIJEM',NULL,206.60,45263.80,'UROK',NULL,NULL);
insert into tab_trans values (5015,3538015,226,'1997-8-31','PRIJEM',NULL,181.90,42342.10,'UROK',NULL,NULL);
insert into tab_trans values (5015,3538016,226,'1997-9-30','PRIJEM',NULL,182.50,45140.90,'UROK',NULL,NULL);
insert into tab_trans values (5015,3538017,226,'1997-10-31','PRIJEM',NULL,189.00,41846.30,'UROK',NULL,NULL);
insert into tab_trans values (5015,3538018,226,'1997-11-30','PRIJEM',NULL,190.50,48953.20,'UROK',NULL,NULL);
insert into tab_trans values (5015,3538019,226,'1997-12-31','PRIJEM',NULL,226.50,45505.00,'UROK',NULL,NULL);
insert into tab_trans values (5015,3538020,226,'1998-1-31','PRIJEM',NULL,184.30,31385.70,'UROK',NULL,NULL);
insert into tab_trans values (5015,3538021,226,'1998-2-28','PRIJEM',NULL,165.80,47367.90,'UROK',NULL,NULL);
insert into tab_trans values (5015,3538022,226,'1998-3-31','PRIJEM',NULL,211.60,52395.90,'UROK',NULL,NULL);
insert into tab_trans values (5015,3538023,226,'1998-4-30','PRIJEM',NULL,216.10,51528.40,'UROK',NULL,NULL);
insert into tab_trans values (5015,3538024,226,'1998-5-31','PRIJEM',NULL,215.00,51859.80,'UROK',NULL,NULL);
insert into tab_trans values (5015,3538025,226,'1998-6-30','PRIJEM',NULL,235.50,56540.60,'UROK',NULL,NULL);
insert into tab_trans values (5027,82433,276,'1997-12-8','PRIJEM','VKLAD',700.00,700.00,NULL,NULL,NULL);
insert into tab_trans values (5027,82445,276,'1997-12-13','PRIJEM','PREVOD Z UCTU',40234.00,40934.00,NULL,'ST','78938924');
insert into tab_trans values (5027,82446,276,'1998-1-13','PRIJEM','PREVOD Z UCTU',26823.00,57861.50,NULL,'ST','78938924');
insert into tab_trans values (5027,82447,276,'1998-2-13','PRIJEM','PREVOD Z UCTU',26823.00,66798.30,NULL,'ST','78938924');
insert into tab_trans values (5027,82448,276,'1998-3-13','PRIJEM','PREVOD Z UCTU',26823.00,72283.70,NULL,'ST','78938924');
insert into tab_trans values (5027,82449,276,'1998-4-13','PRIJEM','PREVOD Z UCTU',26823.00,74599.00,NULL,'ST','78938924');
insert into tab_trans values (5027,82450,276,'1998-5-13','PRIJEM','PREVOD Z UCTU',26823.00,67902.40,NULL,'ST','78938924');
insert into tab_trans values (5027,82451,276,'1998-6-13','PRIJEM','PREVOD Z UCTU',40234.00,72191.00,NULL,'ST','78938924');
insert into tab_trans values (5027,82452,276,'1998-7-13','PRIJEM','PREVOD Z UCTU',26823.00,70048.90,NULL,'ST','78938924');
insert into tab_trans values (5027,82453,276,'1998-8-13','PRIJEM','PREVOD Z UCTU',26823.00,61311.30,NULL,'ST','78938924');
insert into tab_trans values (5027,82454,276,'1998-9-13','PRIJEM','PREVOD Z UCTU',26823.00,55338.60,NULL,'ST','78938924');
insert into tab_trans values (5027,82455,276,'1998-10-13','PRIJEM','PREVOD Z UCTU',26823.00,53650.90,NULL,'ST','78938924');
insert into tab_trans values (5027,82456,276,'1998-11-13','PRIJEM','PREVOD Z UCTU',26823.00,52251.10,NULL,'ST','78938924');
insert into tab_trans values (5027,82474,276,'1998-5-12','VYDAJ','VYBER',5600.00,41079.40,NULL,NULL,'0');
insert into tab_trans values (5027,82475,276,'1998-6-10','VYDAJ','VYBER',3400.00,31957.00,NULL,NULL,'0');
insert into tab_trans values (5027,82476,276,'1998-7-19','VYDAJ','VYBER',3500.00,66548.90,NULL,NULL,'0');
insert into tab_trans values (5027,82477,276,'1998-8-2','VYDAJ','VYBER',3900.00,62900.30,NULL,NULL,'0');
insert into tab_trans values (5027,82478,276,'1998-9-10','VYDAJ','VYBER',6300.00,28515.60,NULL,NULL,'0');
insert into tab_trans values (5027,82479,276,'1998-10-8','VYDAJ','VYBER',3800.00,26827.90,NULL,NULL,'0');
insert into tab_trans values (5027,82480,276,'1998-11-17','VYDAJ','VYBER',4100.00,48151.10,NULL,NULL,'0');
insert into tab_trans values (5027,82498,276,'1998-5-7','VYDAJ','PREVOD NA UCET',5212.00,46679.40,'SIPO','EF','80801391');
insert into tab_trans values (5027,82499,276,'1998-6-7','VYDAJ','PREVOD NA UCET',5212.00,35357.00,'SIPO','EF','80801391');
insert into tab_trans values (5027,82500,276,'1998-7-7','VYDAJ','PREVOD NA UCET',5212.00,43225.90,'SIPO','EF','80801391');
insert into tab_trans values (5027,82501,276,'1998-8-7','VYDAJ','PREVOD NA UCET',5212.00,34488.30,'SIPO','EF','80801391');
insert into tab_trans values (5027,82502,276,'1998-9-7','VYDAJ','PREVOD NA UCET',5212.00,34815.60,'SIPO','EF','80801391');
insert into tab_trans values (5027,82503,276,'1998-10-7','VYDAJ','PREVOD NA UCET',5212.00,30627.90,'SIPO','EF','80801391');
insert into tab_trans values (5027,82504,276,'1998-11-7','VYDAJ','PREVOD NA UCET',5212.00,25428.10,'SIPO','EF','80801391');
insert into tab_trans values (5027,82509,276,'1998-6-4','VYBER','VYBER',16593.00,51569.00,NULL,NULL,NULL);
insert into tab_trans values (5027,82539,276,'1998-4-30','VYDAJ','VYBER',14.60,74891.40,'SLUZBY',NULL,NULL);
insert into tab_trans values (5027,82540,276,'1998-5-31','VYDAJ','VYBER',14.60,68162.00,'SLUZBY',NULL,NULL);
insert into tab_trans values (5027,82541,276,'1998-6-30','VYDAJ','VYBER',14.60,72437.90,'SLUZBY',NULL,NULL);
insert into tab_trans values (5027,82542,276,'1998-7-31','VYDAJ','VYBER',14.60,66800.30,'SLUZBY',NULL,NULL);
insert into tab_trans values (5027,82543,276,'1998-8-31','VYDAJ','VYBER',14.60,61527.60,'SLUZBY',NULL,NULL);
insert into tab_trans values (5027,82544,276,'1998-9-30','VYDAJ','VYBER',14.60,55539.90,'SLUZBY',NULL,NULL);
insert into tab_trans values (5027,82545,276,'1998-10-31','VYDAJ','VYBER',14.60,53840.10,'SLUZBY',NULL,NULL);
insert into tab_trans values (5027,82546,276,'1998-11-30','VYDAJ','VYBER',14.60,48325.00,'SLUZBY',NULL,NULL);
insert into tab_trans values (5027,82547,276,'1998-1-7','VYDAJ','VYBER',10000.00,31038.50,NULL,NULL,NULL);
insert into tab_trans values (5027,82548,276,'1998-2-6','VYDAJ','VYBER',18100.00,39975.30,NULL,NULL,NULL);
insert into tab_trans values (5027,82549,276,'1998-3-8','VYDAJ','VYBER',21600.00,45460.70,NULL,NULL,NULL);
insert into tab_trans values (5027,82550,276,'1998-4-7','VYDAJ','VYBER',24800.00,47776.00,NULL,NULL,NULL);
insert into tab_trans values (5027,82551,276,'1998-5-7','VYDAJ','VYBER',23000.00,51891.40,NULL,NULL,NULL);
insert into tab_trans values (5027,82552,276,'1998-6-6','VYDAJ','VYBER',11000.00,40569.00,NULL,NULL,NULL);
insert into tab_trans values (5027,82553,276,'1998-7-6','VYDAJ','VYBER',24000.00,48437.90,NULL,NULL,NULL);
insert into tab_trans values (5027,82554,276,'1998-8-5','VYDAJ','VYBER',23200.00,39700.30,NULL,NULL,NULL);
insert into tab_trans values (5027,82555,276,'1998-9-4','VYDAJ','VYBER',21500.00,40027.60,NULL,NULL,NULL);
insert into tab_trans values (5027,82556,276,'1998-10-4','VYDAJ','VYBER',19700.00,35839.90,NULL,NULL,NULL);
insert into tab_trans values (5027,82557,276,'1998-11-3','VYDAJ','VYBER',23200.00,30640.10,NULL,NULL,NULL);
insert into tab_trans values (5027,3539677,276,'1997-12-31','PRIJEM',NULL,104.50,41038.50,'UROK',NULL,NULL);
insert into tab_trans values (5027,3539678,276,'1998-1-31','PRIJEM',NULL,213.80,58075.30,'UROK',NULL,NULL);
insert into tab_trans values (5027,3539679,276,'1998-2-28','PRIJEM',NULL,262.40,67060.70,'UROK',NULL,NULL);
insert into tab_trans values (5027,3539680,276,'1998-3-31','PRIJEM',NULL,292.30,72576.00,'UROK',NULL,NULL);
insert into tab_trans values (5027,3539681,276,'1998-4-30','PRIJEM',NULL,307.00,74906.00,'UROK',NULL,NULL);
insert into tab_trans values (5027,3539682,276,'1998-5-31','PRIJEM',NULL,274.20,68176.60,'UROK',NULL,NULL);
insert into tab_trans values (5027,3539683,276,'1998-6-30','PRIJEM',NULL,261.50,72452.50,'UROK',NULL,NULL);
insert into tab_trans values (5027,3539684,276,'1998-7-31','PRIJEM',NULL,266.00,66814.90,'UROK',NULL,NULL);
insert into tab_trans values (5027,3539685,276,'1998-8-31','PRIJEM',NULL,230.90,61542.20,'UROK',NULL,NULL);
insert into tab_trans values (5027,3539686,276,'1998-9-30','PRIJEM',NULL,215.90,55554.50,'UROK',NULL,NULL);
insert into tab_trans values (5027,3539687,276,'1998-10-31','PRIJEM',NULL,203.80,53854.70,'UROK',NULL,NULL);
insert into tab_trans values (5027,3539688,276,'1998-11-30','PRIJEM',NULL,188.50,48339.60,'UROK',NULL,NULL);
insert into tab_trans values (5032,86578,290,'1993-12-2','PRIJEM','VKLAD',300.00,300.00,NULL,NULL,NULL);
insert into tab_trans values (5032,86580,290,'1994-5-3','PRIJEM','VKLAD',22600.00,77401.10,NULL,NULL,NULL);
insert into tab_trans values (5032,86581,290,'1994-8-13','PRIJEM','VKLAD',48476.00,78731.80,NULL,NULL,NULL);
insert into tab_trans values (5032,86582,290,'1994-2-16','PRIJEM','VKLAD',15377.00,75073.50,NULL,NULL,NULL);
insert into tab_trans values (5032,86583,290,'1994-1-24','PRIJEM','VKLAD',46075.00,57175.00,NULL,NULL,NULL);
insert into tab_trans values (5032,86584,290,'1994-2-7','PRIJEM','VKLAD',17162.00,59696.50,NULL,NULL,NULL);
insert into tab_trans values (5032,86585,290,'1994-4-23','PRIJEM','VKLAD',47749.00,86575.50,NULL,NULL,NULL);
insert into tab_trans values (5032,86586,290,'1994-6-5','PRIJEM','VKLAD',37703.00,77969.20,NULL,NULL,NULL);
insert into tab_trans values (5032,86587,290,'1994-6-8','PRIJEM','VKLAD',11853.00,89822.20,NULL,NULL,NULL);
insert into tab_trans values (5032,86588,290,'1994-7-10','PRIJEM','VKLAD',22805.00,51750.50,NULL,NULL,NULL);
insert into tab_trans values (5032,86660,290,'1994-5-5','VYDAJ','VYBER',1700.00,75701.10,NULL,NULL,'0');
insert into tab_trans values (5032,86661,290,'1994-6-23','VYDAJ','VYBER',2500.00,47000.20,NULL,NULL,'0');
insert into tab_trans values (5032,86662,290,'1994-7-8','VYDAJ','VYBER',2100.00,28945.50,NULL,NULL,'0');
insert into tab_trans values (5032,86663,290,'1994-8-21','VYDAJ','VYBER',2200.00,76531.80,NULL,NULL,'0');
insert into tab_trans values (5032,86664,290,'1994-9-18','VYDAJ','VYBER',2500.00,33465.70,NULL,NULL,'0');
insert into tab_trans values (5032,86665,290,'1994-10-1','VYDAJ','VYBER',3200.00,28415.10,NULL,NULL,'0');
insert into tab_trans values (5032,86732,290,'1994-5-10','VYDAJ','PREVOD NA UCET',2653.00,73048.10,'SIPO','UV','10382223');
insert into tab_trans values (5032,86733,290,'1994-6-10','VYDAJ','PREVOD NA UCET',2653.00,83895.20,'SIPO','UV','10382223');
insert into tab_trans values (5032,86734,290,'1994-7-10','VYDAJ','PREVOD NA UCET',2653.00,42523.50,'SIPO','UV','10382223');
insert into tab_trans values (5032,86735,290,'1994-8-10','VYDAJ','PREVOD NA UCET',2653.00,33529.80,'SIPO','UV','10382223');
insert into tab_trans values (5032,86736,290,'1994-9-10','VYDAJ','PREVOD NA UCET',2653.00,35965.70,'SIPO','UV','10382223');
insert into tab_trans values (5032,86737,290,'1994-10-10','VYDAJ','PREVOD NA UCET',2653.00,25762.10,'SIPO','UV','10382223');
insert into tab_trans values (5032,86804,290,'1994-5-10','VYDAJ','PREVOD NA UCET',3274.00,69774.10,NULL,'IJ','5267882');
insert into tab_trans values (5032,86805,290,'1994-6-10','VYDAJ','PREVOD NA UCET',3274.00,86548.20,NULL,'IJ','5267882');
insert into tab_trans values (5032,86806,290,'1994-7-10','VYDAJ','PREVOD NA UCET',3274.00,48476.50,NULL,'IJ','5267882');
insert into tab_trans values (5032,86807,290,'1994-8-10','VYDAJ','PREVOD NA UCET',3274.00,30255.80,NULL,'IJ','5267882');
insert into tab_trans values (5032,86808,290,'1994-9-10','VYDAJ','PREVOD NA UCET',3274.00,38618.70,NULL,'IJ','5267882');
insert into tab_trans values (5032,86809,290,'1994-10-10','VYDAJ','PREVOD NA UCET',3274.00,22488.10,NULL,'IJ','5267882');
insert into tab_trans values (5032,86875,290,'1994-6-22','VYBER','VYBER',21795.00,49500.20,NULL,NULL,NULL);
insert into tab_trans values (5032,86876,290,'1994-5-21','VYBER','VYBER',18667.00,51107.10,NULL,NULL,NULL);
insert into tab_trans values (5032,86878,290,'1994-9-9','VYBER','VYBER',9868.00,41892.70,NULL,NULL,NULL);
insert into tab_trans values (5032,86921,290,'1994-6-14','VYDAJ','VYBER',12600.00,71295.20,NULL,NULL,NULL);
insert into tab_trans values (5032,86979,290,'1994-7-10','VYDAJ','VYBER',3300.00,45176.50,NULL,NULL,NULL);
insert into tab_trans values (5032,86980,290,'1994-7-4','VYDAJ','VYBER',6300.00,31045.50,NULL,NULL,NULL);
insert into tab_trans values (5032,87015,290,'1994-5-31','VYDAJ','VYBER',14.60,51366.20,'SLUZBY',NULL,NULL);
insert into tab_trans values (5032,87016,290,'1994-6-30','VYDAJ','VYBER',14.60,37345.50,'SLUZBY',NULL,NULL);
insert into tab_trans values (5032,87017,290,'1994-7-31','VYDAJ','VYBER',14.60,36182.80,'SLUZBY',NULL,NULL);
insert into tab_trans values (5032,87018,290,'1994-8-31','VYDAJ','VYBER',14.60,51760.70,'SLUZBY',NULL,NULL);
insert into tab_trans values (5032,87019,290,'1994-9-30','VYDAJ','VYBER',14.60,31615.10,'SLUZBY',NULL,NULL);
insert into tab_trans values (5032,87020,290,'1994-10-31','VYDAJ','VYBER',14.60,25187.20,'SLUZBY',NULL,NULL);
insert into tab_trans values (5032,87070,290,'1994-1-1','PRIJEM','VKLAD',10800.00,11100.00,NULL,NULL,NULL);
insert into tab_trans values (5032,87071,290,'1994-1-31','VYDAJ','VYBER',14700.00,42534.50,NULL,NULL,NULL);
insert into tab_trans values (5032,87072,290,'1994-3-2','VYDAJ','VYBER',23800.00,51513.70,NULL,NULL,NULL);
insert into tab_trans values (5032,87073,290,'1994-4-1','VYDAJ','VYBER',13000.00,38826.50,NULL,NULL,NULL);
insert into tab_trans values (5032,87074,290,'1994-5-1','VYDAJ','VYBER',32100.00,54801.10,NULL,NULL,NULL);
insert into tab_trans values (5032,87075,290,'1994-5-31','VYDAJ','VYBER',11100.00,40266.20,NULL,NULL,NULL);
insert into tab_trans values (5032,87076,290,'1994-6-30','VYDAJ','VYBER',9900.00,37360.10,NULL,NULL,NULL);
insert into tab_trans values (5032,87077,290,'1994-7-30','VYDAJ','VYBER',6500.00,36023.50,NULL,NULL,NULL);
insert into tab_trans values (5032,87078,290,'1994-8-29','VYDAJ','VYBER',25000.00,51531.80,NULL,NULL,NULL);
insert into tab_trans values (5032,87079,290,'1994-9-28','VYDAJ','VYBER',2000.00,31465.70,NULL,NULL,NULL);
insert into tab_trans values (5032,87080,290,'1994-10-28','PRIJEM','VKLAD',2600.00,25088.10,NULL,NULL,NULL);
insert into tab_trans values (5032,3540237,290,'1994-1-31','PRIJEM',NULL,59.50,57234.50,'UROK',NULL,NULL);
insert into tab_trans values (5032,3540238,290,'1994-2-28','PRIJEM',NULL,240.20,75313.70,'UROK',NULL,NULL);
insert into tab_trans values (5032,3540239,290,'1994-3-31','PRIJEM',NULL,312.80,51826.50,'UROK',NULL,NULL);
insert into tab_trans values (5032,3540240,290,'1994-4-30','PRIJEM',NULL,325.60,86901.10,'UROK',NULL,NULL);
insert into tab_trans values (5032,3540241,290,'1994-5-31','PRIJEM',NULL,273.70,51380.80,'UROK',NULL,NULL);
insert into tab_trans values (5032,3540242,290,'1994-6-30','PRIJEM',NULL,259.90,47260.10,'UROK',NULL,NULL);
insert into tab_trans values (5032,3540243,290,'1994-7-31','PRIJEM',NULL,173.90,36197.40,'UROK',NULL,NULL);
insert into tab_trans values (5032,3540244,290,'1994-8-31','PRIJEM',NULL,243.50,51775.30,'UROK',NULL,NULL);
insert into tab_trans values (5032,3540245,290,'1994-9-30','PRIJEM',NULL,164.00,31629.70,'UROK',NULL,NULL);
insert into tab_trans values (5032,3540246,290,'1994-10-31','PRIJEM',NULL,113.70,25201.80,'UROK',NULL,NULL);
insert into tab_trans values (5034,89828,303,'1996-7-25','PRIJEM','VKLAD',900.00,900.00,NULL,NULL,NULL);
insert into tab_trans values (5034,89836,303,'1996-8-5','PRIJEM','VKLAD',15405.00,16305.00,NULL,NULL,NULL);
insert into tab_trans values (5034,89837,303,'1996-9-5','PRIJEM','VKLAD',15405.00,35831.90,NULL,NULL,NULL);
insert into tab_trans values (5034,89838,303,'1996-10-5','PRIJEM','VKLAD',15405.00,44331.30,NULL,NULL,NULL);
insert into tab_trans values (5034,89839,303,'1996-11-5','PRIJEM','VKLAD',15405.00,51765.40,NULL,NULL,NULL);
insert into tab_trans values (5034,89840,303,'1996-12-5','PRIJEM','VKLAD',23108.00,62127.70,NULL,NULL,NULL);
insert into tab_trans values (5034,89841,303,'1997-1-5','PRIJEM','VKLAD',15405.00,50718.40,NULL,NULL,NULL);
insert into tab_trans values (5034,89842,303,'1997-2-5','PRIJEM','VKLAD',15405.00,41260.60,NULL,NULL,NULL);
insert into tab_trans values (5034,89843,303,'1997-3-5','PRIJEM','VKLAD',15405.00,50286.50,NULL,NULL,NULL);
insert into tab_trans values (5034,89844,303,'1997-4-5','PRIJEM','VKLAD',15405.00,52102.30,NULL,NULL,NULL);
insert into tab_trans values (5034,89845,303,'1997-5-5','PRIJEM','VKLAD',15405.00,55466.20,NULL,NULL,NULL);
insert into tab_trans values (5034,89846,303,'1997-6-5','PRIJEM','VKLAD',23108.00,63644.70,NULL,NULL,NULL);
insert into tab_trans values (5034,89847,303,'1997-7-5','PRIJEM','VKLAD',15405.00,43487.90,NULL,NULL,NULL);
insert into tab_trans values (5034,89848,303,'1997-8-5','PRIJEM','VKLAD',15405.00,57130.80,NULL,NULL,NULL);
insert into tab_trans values (5034,89849,303,'1997-9-5','PRIJEM','VKLAD',15405.00,58915.00,NULL,NULL,NULL);
insert into tab_trans values (5034,89850,303,'1997-10-5','PRIJEM','VKLAD',15405.00,60716.40,NULL,NULL,NULL);
insert into tab_trans values (5034,89851,303,'1997-11-5','PRIJEM','VKLAD',15405.00,59920.60,NULL,NULL,NULL);
insert into tab_trans values (5034,89852,303,'1997-12-5','PRIJEM','VKLAD',23108.00,68401.90,NULL,NULL,NULL);
insert into tab_trans values (5034,89853,303,'1998-1-5','PRIJEM','VKLAD',15405.00,65425.90,NULL,NULL,NULL);
insert into tab_trans values (5034,89854,303,'1998-2-5','PRIJEM','VKLAD',15405.00,53856.20,NULL,NULL,NULL);
insert into tab_trans values (5034,89855,303,'1998-3-5','PRIJEM','VKLAD',15405.00,60526.40,NULL,NULL,NULL);
insert into tab_trans values (5034,89856,303,'1998-4-5','PRIJEM','VKLAD',15405.00,58178.90,NULL,NULL,NULL);
insert into tab_trans values (5034,89857,303,'1998-5-5','PRIJEM','VKLAD',15405.00,61819.60,NULL,NULL,NULL);
insert into tab_trans values (5034,89876,303,'1996-12-9','VYDAJ','PREVOD NA UCET',3803.00,56124.70,'SIPO','KL','43664085');
insert into tab_trans values (5034,89877,303,'1997-1-9','VYDAJ','PREVOD NA UCET',3803.00,44615.40,'SIPO','KL','43664085');
insert into tab_trans values (5034,89878,303,'1997-2-9','VYDAJ','PREVOD NA UCET',3803.00,37457.60,'SIPO','KL','43664085');
insert into tab_trans values (5034,89879,303,'1997-3-9','VYDAJ','PREVOD NA UCET',3803.00,46483.50,'SIPO','KL','43664085');
insert into tab_trans values (5034,89880,303,'1997-4-9','VYDAJ','PREVOD NA UCET',3803.00,48299.30,'SIPO','KL','43664085');
insert into tab_trans values (5034,89881,303,'1997-5-9','VYDAJ','PREVOD NA UCET',3803.00,49263.20,'SIPO','KL','43664085');
insert into tab_trans values (5034,89882,303,'1997-6-9','VYDAJ','PREVOD NA UCET',3803.00,59841.70,'SIPO','KL','43664085');
insert into tab_trans values (5034,89883,303,'1997-7-9','VYDAJ','PREVOD NA UCET',3803.00,39684.90,'SIPO','KL','43664085');
insert into tab_trans values (5034,89884,303,'1997-8-9','VYDAJ','PREVOD NA UCET',3803.00,49227.80,'SIPO','KL','43664085');
insert into tab_trans values (5034,89885,303,'1997-9-9','VYDAJ','PREVOD NA UCET',3803.00,55112.00,'SIPO','KL','43664085');
insert into tab_trans values (5034,89886,303,'1997-10-9','VYDAJ','PREVOD NA UCET',3803.00,56913.40,'SIPO','KL','43664085');
insert into tab_trans values (5034,89887,303,'1997-11-9','VYDAJ','PREVOD NA UCET',3803.00,56117.60,'SIPO','KL','43664085');
insert into tab_trans values (5034,89888,303,'1997-12-9','VYDAJ','PREVOD NA UCET',3803.00,64598.90,'SIPO','KL','43664085');
insert into tab_trans values (5034,89889,303,'1998-1-9','VYDAJ','PREVOD NA UCET',3803.00,61622.90,'SIPO','KL','43664085');
insert into tab_trans values (5034,89890,303,'1998-2-9','VYDAJ','PREVOD NA UCET',3803.00,50053.20,'SIPO','KL','43664085');
insert into tab_trans values (5034,89891,303,'1998-3-9','VYDAJ','PREVOD NA UCET',3803.00,53923.40,'SIPO','KL','43664085');
insert into tab_trans values (5034,89892,303,'1998-4-9','VYDAJ','PREVOD NA UCET',3803.00,54375.90,'SIPO','KL','43664085');
insert into tab_trans values (5034,89893,303,'1998-5-9','VYDAJ','PREVOD NA UCET',3803.00,58016.60,'SIPO','KL','43664085');
insert into tab_trans values (5034,89912,303,'1996-12-5','VYDAJ','VYBER',2200.00,59927.70,NULL,NULL,'0');
insert into tab_trans values (5034,89913,303,'1997-1-8','VYDAJ','VYBER',2300.00,48418.40,NULL,NULL,'0');
insert into tab_trans values (5034,89914,303,'1997-1-29','VYDAJ','VYBER',2600.00,25715.40,NULL,NULL,'0');
insert into tab_trans values (5034,89915,303,'1997-3-16','VYDAJ','VYBER',3300.00,40543.50,NULL,NULL,'0');
insert into tab_trans values (5034,89916,303,'1997-3-31','VYDAJ','VYBER',2300.00,36697.30,NULL,NULL,'0');
insert into tab_trans values (5034,89917,303,'1997-5-9','VYDAJ','VYBER',2400.00,53066.20,NULL,NULL,'0');
insert into tab_trans values (5034,89918,303,'1997-6-18','VYDAJ','VYBER',2700.00,19261.70,NULL,NULL,'0');
insert into tab_trans values (5034,89919,303,'1997-6-26','VYDAJ','VYBER',3500.00,27961.70,NULL,NULL,'0');
insert into tab_trans values (5034,89920,303,'1997-8-6','VYDAJ','VYBER',4100.00,53030.80,NULL,NULL,'0');
insert into tab_trans values (5034,89921,303,'1997-9-1','VYDAJ','VYBER',3400.00,43510.00,NULL,NULL,'0');
insert into tab_trans values (5034,89922,303,'1997-10-4','VYDAJ','VYBER',3000.00,45311.40,NULL,NULL,'0');
insert into tab_trans values (5034,89923,303,'1997-10-31','VYDAJ','VYBER',3800.00,44515.60,NULL,NULL,'0');
insert into tab_trans values (5034,89924,303,'1997-11-28','VYDAJ','VYBER',2500.00,49417.60,NULL,NULL,'0');
insert into tab_trans values (5034,89925,303,'1997-12-25','VYDAJ','VYBER',3800.00,49798.90,NULL,NULL,'0');
insert into tab_trans values (5034,89926,303,'1998-2-14','VYDAJ','VYBER',3100.00,46953.20,NULL,NULL,'0');
insert into tab_trans values (5034,89927,303,'1998-3-5','VYDAJ','VYBER',2800.00,57726.40,NULL,NULL,'0');
insert into tab_trans values (5034,89928,303,'1998-4-3','VYDAJ','VYBER',4000.00,42773.90,NULL,NULL,'0');
insert into tab_trans values (5034,89929,303,'1998-5-20','VYDAJ','VYBER',2700.00,48916.60,NULL,NULL,'0');
insert into tab_trans values (5034,89938,303,'1997-6-11','VYDAJ','VYBER',35360.00,24481.70,NULL,NULL,NULL);
insert into tab_trans values (5034,89941,303,'1997-1-18','VYDAJ','VYBER',15200.00,29415.40,NULL,NULL,NULL);
insert into tab_trans values (5034,89942,303,'1998-1-21','VYDAJ','VYBER',14560.00,38262.90,NULL,NULL,NULL);
insert into tab_trans values (5034,89943,303,'1996-12-20','VYDAJ','VYBER',1920.00,54204.70,NULL,NULL,NULL);
insert into tab_trans values (5034,89944,303,'1997-12-2','VYDAJ','VYBER',4320.00,45293.90,NULL,NULL,NULL);
insert into tab_trans values (5034,89953,303,'1997-3-16','VYDAJ','VYBER',2640.00,43843.50,NULL,NULL,NULL);
insert into tab_trans values (5034,89954,303,'1997-1-4','VYDAJ','VYBER',4080.00,35313.40,NULL,NULL,NULL);
insert into tab_trans values (5034,89955,303,'1997-6-17','VYDAJ','VYBER',2520.00,21961.70,NULL,NULL,NULL);
insert into tab_trans values (5034,89956,303,'1998-3-15','VYDAJ','VYBER',3840.00,50083.40,NULL,NULL,NULL);
insert into tab_trans values (5034,89959,303,'1998-5-3','VYDAJ','VYBER',3360.00,46414.60,NULL,NULL,NULL);
insert into tab_trans values (5034,89973,303,'1996-12-31','VYDAJ','VYBER',14.60,39393.40,'SLUZBY',NULL,NULL);
insert into tab_trans values (5034,89974,303,'1997-1-31','VYDAJ','VYBER',14.60,25855.60,'SLUZBY',NULL,NULL);
insert into tab_trans values (5034,89975,303,'1997-2-28','VYDAJ','VYBER',14.60,34881.50,'SLUZBY',NULL,NULL);
insert into tab_trans values (5034,89976,303,'1997-3-31','VYDAJ','VYBER',14.60,38997.30,'SLUZBY',NULL,NULL);
insert into tab_trans values (5034,89977,303,'1997-4-30','VYDAJ','VYBER',14.60,40061.20,'SLUZBY',NULL,NULL);
insert into tab_trans values (5034,89978,303,'1997-5-31','VYDAJ','VYBER',14.60,40536.70,'SLUZBY',NULL,NULL);
insert into tab_trans values (5034,89979,303,'1997-6-30','VYDAJ','VYBER',14.60,28082.90,'SLUZBY',NULL,NULL);
insert into tab_trans values (5034,89980,303,'1997-7-31','VYDAJ','VYBER',14.60,41725.80,'SLUZBY',NULL,NULL);
insert into tab_trans values (5034,89981,303,'1997-8-31','VYDAJ','VYBER',14.60,46910.00,'SLUZBY',NULL,NULL);
insert into tab_trans values (5034,89982,303,'1997-9-30','VYDAJ','VYBER',14.60,48311.40,'SLUZBY',NULL,NULL);
insert into tab_trans values (5034,89983,303,'1997-10-31','VYDAJ','VYBER',14.60,48315.60,'SLUZBY',NULL,NULL);
insert into tab_trans values (5034,89984,303,'1997-11-30','VYDAJ','VYBER',14.60,49613.90,'SLUZBY',NULL,NULL);
insert into tab_trans values (5034,89985,303,'1997-12-31','VYDAJ','VYBER',14.60,50020.90,'SLUZBY',NULL,NULL);
insert into tab_trans values (5034,89986,303,'1998-1-31','VYDAJ','VYBER',14.60,38451.20,'SLUZBY',NULL,NULL);
insert into tab_trans values (5034,89987,303,'1998-2-28','VYDAJ','VYBER',14.60,45121.40,'SLUZBY',NULL,NULL);
insert into tab_trans values (5034,89988,303,'1998-3-31','VYDAJ','VYBER',14.60,46773.90,'SLUZBY',NULL,NULL);
insert into tab_trans values (5034,89989,303,'1998-4-30','VYDAJ','VYBER',14.60,49774.60,'SLUZBY',NULL,NULL);
insert into tab_trans values (5034,89997,303,'1996-8-24','PRIJEM','VKLAD',4100.00,20405.00,NULL,NULL,NULL);
insert into tab_trans values (5034,89998,303,'1996-9-23','VYDAJ','VYBER',7000.00,28831.90,NULL,NULL,NULL);
insert into tab_trans values (5034,89999,303,'1996-10-23','VYDAJ','VYBER',8100.00,36231.30,NULL,NULL,NULL);
insert into tab_trans values (5034,90000,303,'1996-11-22','VYDAJ','VYBER',12900.00,38865.40,NULL,NULL,NULL);
insert into tab_trans values (5034,90001,303,'1996-12-22','VYDAJ','VYBER',15000.00,39204.70,NULL,NULL,NULL);
insert into tab_trans values (5034,90002,303,'1997-1-21','VYDAJ','VYBER',1100.00,28315.40,NULL,NULL,NULL);
insert into tab_trans values (5034,90003,303,'1997-2-20','VYDAJ','VYBER',2700.00,34757.60,NULL,NULL,NULL);
insert into tab_trans values (5034,90004,303,'1997-3-22','VYDAJ','VYBER',1700.00,38843.50,NULL,NULL,NULL);
insert into tab_trans values (5034,90005,303,'1997-4-21','VYDAJ','VYBER',8400.00,39899.30,NULL,NULL,NULL);
insert into tab_trans values (5034,90006,303,'1997-5-21','VYDAJ','VYBER',8900.00,40363.20,NULL,NULL,NULL);
insert into tab_trans values (5034,90007,303,'1997-6-20','PRIJEM','VKLAD',12200.00,31461.70,NULL,NULL,NULL);
insert into tab_trans values (5034,90008,303,'1997-7-20','PRIJEM','VKLAD',1900.00,41584.90,NULL,NULL,NULL);
insert into tab_trans values (5034,90009,303,'1997-8-19','VYDAJ','VYBER',2500.00,46727.80,NULL,NULL,NULL);
insert into tab_trans values (5034,90010,303,'1997-9-18','VYDAJ','VYBER',7000.00,48112.00,NULL,NULL,NULL);
insert into tab_trans values (5034,90011,303,'1997-10-18','VYDAJ','VYBER',8800.00,48113.40,NULL,NULL,NULL);
insert into tab_trans values (5034,90012,303,'1997-11-17','VYDAJ','VYBER',4200.00,51917.60,NULL,NULL,NULL);
insert into tab_trans values (5034,90013,303,'1997-12-17','VYDAJ','VYBER',11000.00,53598.90,NULL,NULL,NULL);
insert into tab_trans values (5034,90014,303,'1998-1-16','VYDAJ','VYBER',8800.00,52822.90,NULL,NULL,NULL);
insert into tab_trans values (5034,90015,303,'1998-2-15','VYDAJ','VYBER',2000.00,44953.20,NULL,NULL,NULL);
insert into tab_trans values (5034,90016,303,'1998-3-17','VYDAJ','VYBER',3500.00,46583.40,NULL,NULL,NULL);
insert into tab_trans values (5034,90017,303,'1998-4-16','VYDAJ','VYBER',4800.00,49575.90,NULL,NULL,NULL);
insert into tab_trans values (5034,90018,303,'1998-5-16','VYDAJ','VYBER',6400.00,51616.60,NULL,NULL,NULL);
insert into tab_trans values (5034,3540569,303,'1996-8-31','PRIJEM',NULL,21.90,20426.90,'UROK',NULL,NULL);
insert into tab_trans values (5034,3540570,303,'1996-9-30','PRIJEM',NULL,94.40,28926.30,'UROK',NULL,NULL);
insert into tab_trans values (5034,3540571,303,'1996-10-31','PRIJEM',NULL,129.10,36360.40,'UROK',NULL,NULL);
insert into tab_trans values (5034,3540572,303,'1996-11-30','PRIJEM',NULL,154.30,39019.70,'UROK',NULL,NULL);
insert into tab_trans values (5034,3540573,303,'1996-12-31','PRIJEM',NULL,203.40,39408.00,'UROK',NULL,NULL);
insert into tab_trans values (5034,3540574,303,'1997-1-31','PRIJEM',NULL,154.70,25870.20,'UROK',NULL,NULL);
insert into tab_trans values (5034,3540575,303,'1997-2-28','PRIJEM',NULL,138.60,34896.10,'UROK',NULL,NULL);
insert into tab_trans values (5034,3540576,303,'1997-3-31','PRIJEM',NULL,168.40,39011.90,'UROK',NULL,NULL);
insert into tab_trans values (5034,3540577,303,'1997-4-30','PRIJEM',NULL,176.50,40075.80,'UROK',NULL,NULL);
insert into tab_trans values (5034,3540578,303,'1997-5-31','PRIJEM',NULL,188.10,40551.30,'UROK',NULL,NULL);
insert into tab_trans values (5034,3540579,303,'1997-6-30','PRIJEM',NULL,135.80,28097.50,'UROK',NULL,NULL);
insert into tab_trans values (5034,3540580,303,'1997-7-31','PRIJEM',NULL,155.50,41740.40,'UROK',NULL,NULL);
insert into tab_trans values (5034,3540581,303,'1997-8-31','PRIJEM',NULL,196.80,46924.60,'UROK',NULL,NULL);
insert into tab_trans values (5034,3540582,303,'1997-9-30','PRIJEM',NULL,214.00,48326.00,'UROK',NULL,NULL);
insert into tab_trans values (5034,3540583,303,'1997-10-31','PRIJEM',NULL,216.80,48330.20,'UROK',NULL,NULL);
insert into tab_trans values (5034,3540584,303,'1997-11-30','PRIJEM',NULL,211.00,49628.50,'UROK',NULL,NULL);
insert into tab_trans values (5034,3540585,303,'1997-12-31','PRIJEM',NULL,236.60,50035.50,'UROK',NULL,NULL);
insert into tab_trans values (5034,3540586,303,'1998-1-31','PRIJEM',NULL,203.00,38465.80,'UROK',NULL,NULL);
insert into tab_trans values (5034,3540587,303,'1998-2-28','PRIJEM',NULL,182.70,45136.00,'UROK',NULL,NULL);
insert into tab_trans values (5034,3540588,303,'1998-3-31','PRIJEM',NULL,205.10,46788.50,'UROK',NULL,NULL);
insert into tab_trans values (5034,3540589,303,'1998-4-30','PRIJEM',NULL,213.30,49789.20,'UROK',NULL,NULL);
insert into tab_trans values (5036,91108,309,'1997-4-25','PRIJEM','VKLAD',900.00,900.00,NULL,NULL,NULL);
insert into tab_trans values (5036,91113,309,'1997-5-10','PRIJEM','VKLAD',19151.00,20051.00,NULL,NULL,NULL);
insert into tab_trans values (5036,91114,309,'1997-6-10','PRIJEM','VKLAD',28726.00,52599.40,NULL,NULL,NULL);
insert into tab_trans values (5036,91115,309,'1997-7-10','PRIJEM','VKLAD',19151.00,55461.80,NULL,NULL,NULL);
insert into tab_trans values (5036,91116,309,'1997-8-10','PRIJEM','VKLAD',19151.00,53161.10,NULL,NULL,NULL);
insert into tab_trans values (5036,91117,309,'1997-9-10','PRIJEM','VKLAD',19151.00,53555.80,NULL,NULL,NULL);
insert into tab_trans values (5036,91118,309,'1997-10-10','PRIJEM','VKLAD',19151.00,47745.30,NULL,NULL,NULL);
insert into tab_trans values (5036,91119,309,'1997-11-10','PRIJEM','VKLAD',19151.00,40705.30,NULL,NULL,NULL);
insert into tab_trans values (5036,91120,309,'1997-12-10','PRIJEM','VKLAD',28726.00,50125.20,NULL,NULL,NULL);
insert into tab_trans values (5036,91121,309,'1998-1-10','PRIJEM','VKLAD',19151.00,41343.20,NULL,NULL,NULL);
insert into tab_trans values (5036,91122,309,'1998-2-10','PRIJEM','VKLAD',19151.00,31470.70,NULL,NULL,NULL);
insert into tab_trans values (5036,91123,309,'1998-3-10','PRIJEM','VKLAD',19151.00,40373.90,NULL,NULL,NULL);
insert into tab_trans values (5036,91124,309,'1998-4-10','PRIJEM','VKLAD',19151.00,43535.00,NULL,NULL,NULL);
insert into tab_trans values (5036,91125,309,'1998-5-10','PRIJEM','VKLAD',19151.00,47779.40,NULL,NULL,NULL);
insert into tab_trans values (5036,91126,309,'1998-6-10','PRIJEM','VKLAD',28726.00,59725.70,NULL,NULL,NULL);
insert into tab_trans values (5036,91127,309,'1998-7-10','PRIJEM','VKLAD',19151.00,47254.80,NULL,NULL,NULL);
insert into tab_trans values (5036,91128,309,'1998-8-10','PRIJEM','VKLAD',19151.00,40942.50,NULL,NULL,NULL);
insert into tab_trans values (5036,91129,309,'1998-9-10','PRIJEM','VKLAD',19151.00,43096.10,NULL,NULL,NULL);
insert into tab_trans values (5036,91130,309,'1998-10-10','PRIJEM','VKLAD',19151.00,38646.70,NULL,NULL,NULL);
insert into tab_trans values (5036,91131,309,'1998-11-10','PRIJEM','VKLAD',19151.00,33966.70,NULL,NULL,NULL);
insert into tab_trans values (5036,91141,309,'1997-9-7','VYDAJ','VYBER',1700.00,34404.80,NULL,NULL,'0');
insert into tab_trans values (5036,91142,309,'1997-10-15','VYDAJ','VYBER',2800.00,41345.30,NULL,NULL,'0');
insert into tab_trans values (5036,91143,309,'1997-11-14','VYDAJ','VYBER',2000.00,38705.30,NULL,NULL,'0');
insert into tab_trans values (5036,91144,309,'1997-12-1','VYDAJ','VYBER',1700.00,21399.20,NULL,NULL,'0');
insert into tab_trans values (5036,91145,309,'1998-1-21','VYDAJ','VYBER',1900.00,22183.20,NULL,NULL,'0');
insert into tab_trans values (5036,91146,309,'1998-2-21','VYDAJ','VYBER',1200.00,22470.70,NULL,NULL,'0');
insert into tab_trans values (5036,91147,309,'1998-3-1','VYDAJ','VYBER',1300.00,21222.90,NULL,NULL,'0');
insert into tab_trans values (5036,91148,309,'1998-3-30','VYDAJ','VYBER',1600.00,24273.90,NULL,NULL,'0');
insert into tab_trans values (5036,91149,309,'1998-5-15','VYDAJ','VYBER',1300.00,46479.40,NULL,NULL,'0');
insert into tab_trans values (5036,91150,309,'1998-6-19','VYDAJ','VYBER',2400.00,31925.70,NULL,NULL,'0');
insert into tab_trans values (5036,91151,309,'1998-6-28','VYDAJ','VYBER',2500.00,29425.70,NULL,NULL,'0');
insert into tab_trans values (5036,91152,309,'1998-8-9','VYDAJ','VYBER',1600.00,21791.50,NULL,NULL,'0');
insert into tab_trans values (5036,91153,309,'1998-9-10','VYDAJ','VYBER',1700.00,41396.10,NULL,NULL,'0');
insert into tab_trans values (5036,91154,309,'1998-10-6','VYDAJ','VYBER',2400.00,19495.70,NULL,NULL,'0');
insert into tab_trans values (5036,91160,309,'1998-1-18','VYDAJ','VYBER',1600.00,35783.20,NULL,NULL,NULL);
insert into tab_trans values (5036,91161,309,'1997-12-21','VYDAJ','VYBER',3680.00,46445.20,NULL,NULL,NULL);
insert into tab_trans values (5036,91169,309,'1998-1-5','VYDAJ','VYBER',2880.00,22192.20,NULL,NULL,NULL);
insert into tab_trans values (5036,91170,309,'1998-1-21','VYDAJ','VYBER',2760.00,19423.20,NULL,NULL,NULL);
insert into tab_trans values (5036,91171,309,'1998-1-25','VYDAJ','VYBER',2520.00,16903.20,NULL,NULL,NULL);
insert into tab_trans values (5036,91172,309,'1998-1-17','VYDAJ','VYBER',3000.00,37383.20,NULL,NULL,NULL);
insert into tab_trans values (5036,91173,309,'1998-1-2','VYDAJ','VYBER',1800.00,25072.20,NULL,NULL,NULL);
insert into tab_trans values (5036,91176,309,'1997-10-14','VYDAJ','VYBER',3600.00,44145.30,NULL,NULL,NULL);
insert into tab_trans values (5036,91177,309,'1997-9-27','VYDAJ','VYBER',4920.00,28435.80,NULL,NULL,NULL);
insert into tab_trans values (5036,91180,309,'1998-1-30','VYDAJ','VYBER',4680.00,12223.20,NULL,NULL,NULL);
insert into tab_trans values (5036,91182,309,'1998-1-16','VYDAJ','VYBER',960.00,40383.20,NULL,NULL,NULL);
insert into tab_trans values (5036,91183,309,'1998-11-1','VYDAJ','VYBER',5520.00,14815.70,NULL,NULL,NULL);
insert into tab_trans values (5036,91185,309,'1998-7-7','VYDAJ','VYBER',1440.00,28103.80,NULL,NULL,NULL);
insert into tab_trans values (5036,91187,309,'1998-7-13','VYDAJ','VYBER',2880.00,44374.80,NULL,NULL,NULL);
insert into tab_trans values (5036,91197,309,'1997-9-30','VYDAJ','VYBER',14.60,28594.30,'SLUZBY',NULL,NULL);
insert into tab_trans values (5036,91198,309,'1997-10-31','VYDAJ','VYBER',14.60,21554.30,'SLUZBY',NULL,NULL);
insert into tab_trans values (5036,91199,309,'1997-11-30','VYDAJ','VYBER',14.60,23099.20,'SLUZBY',NULL,NULL);
insert into tab_trans values (5036,91200,309,'1997-12-31','VYDAJ','VYBER',14.60,26872.20,'SLUZBY',NULL,NULL);
insert into tab_trans values (5036,91201,309,'1998-1-31','VYDAJ','VYBER',14.60,12319.70,'SLUZBY',NULL,NULL);
insert into tab_trans values (5036,91202,309,'1998-2-28','VYDAJ','VYBER',14.60,22522.90,'SLUZBY',NULL,NULL);
insert into tab_trans values (5036,91203,309,'1998-3-31','VYDAJ','VYBER',14.60,24384.00,'SLUZBY',NULL,NULL);
insert into tab_trans values (5036,91204,309,'1998-4-30','VYDAJ','VYBER',14.60,28628.40,'SLUZBY',NULL,NULL);
insert into tab_trans values (5036,91205,309,'1998-5-31','VYDAJ','VYBER',14.60,30999.70,'SLUZBY',NULL,NULL);
insert into tab_trans values (5036,91206,309,'1998-6-30','VYDAJ','VYBER',14.60,29543.80,'SLUZBY',NULL,NULL);
insert into tab_trans values (5036,91207,309,'1998-7-31','VYDAJ','VYBER',14.60,23391.50,'SLUZBY',NULL,NULL);
insert into tab_trans values (5036,91208,309,'1998-8-31','VYDAJ','VYBER',14.60,23945.10,'SLUZBY',NULL,NULL);
insert into tab_trans values (5036,91209,309,'1998-9-30','VYDAJ','VYBER',14.60,21895.70,'SLUZBY',NULL,NULL);
insert into tab_trans values (5036,91210,309,'1998-10-31','VYDAJ','VYBER',14.60,20335.70,'SLUZBY',NULL,NULL);
insert into tab_trans values (5036,91212,309,'1997-5-25','PRIJEM','VKLAD',3800.00,23851.00,NULL,NULL,NULL);
insert into tab_trans values (5036,91213,309,'1997-6-24','VYDAJ','VYBER',16400.00,36199.40,NULL,NULL,NULL);
insert into tab_trans values (5036,91214,309,'1997-7-24','VYDAJ','VYBER',21600.00,33861.80,NULL,NULL,NULL);
insert into tab_trans values (5036,91215,309,'1997-8-23','VYDAJ','VYBER',17200.00,35961.10,NULL,NULL,NULL);
insert into tab_trans values (5036,91216,309,'1997-9-22','VYDAJ','VYBER',20200.00,33355.80,NULL,NULL,NULL);
insert into tab_trans values (5036,91217,309,'1997-10-22','VYDAJ','VYBER',19900.00,21445.30,NULL,NULL,NULL);
insert into tab_trans values (5036,91218,309,'1997-11-21','VYDAJ','VYBER',15700.00,23005.30,NULL,NULL,NULL);
insert into tab_trans values (5036,91219,309,'1997-12-21','VYDAJ','VYBER',19700.00,26745.20,NULL,NULL,NULL);
insert into tab_trans values (5036,91220,309,'1998-1-20','VYDAJ','VYBER',11700.00,24083.20,NULL,NULL,NULL);
insert into tab_trans values (5036,91221,309,'1998-2-19','VYDAJ','VYBER',7800.00,23670.70,NULL,NULL,NULL);
insert into tab_trans values (5036,91222,309,'1998-3-21','VYDAJ','VYBER',14500.00,25873.90,NULL,NULL,NULL);
insert into tab_trans values (5036,91223,309,'1998-4-20','VYDAJ','VYBER',15000.00,28535.00,NULL,NULL,NULL);
insert into tab_trans values (5036,91224,309,'1998-5-20','VYDAJ','VYBER',15600.00,30879.40,NULL,NULL,NULL);
insert into tab_trans values (5036,91225,309,'1998-6-19','VYDAJ','VYBER',25400.00,34325.70,NULL,NULL,NULL);
insert into tab_trans values (5036,91226,309,'1998-7-19','VYDAJ','VYBER',21100.00,23274.80,NULL,NULL,NULL);
insert into tab_trans values (5036,91227,309,'1998-8-18','VYDAJ','VYBER',17100.00,23842.50,NULL,NULL,NULL);
insert into tab_trans values (5036,91228,309,'1998-9-17','VYDAJ','VYBER',19600.00,21796.10,NULL,NULL,NULL);
insert into tab_trans values (5036,91229,309,'1998-10-17','VYDAJ','VYBER',18400.00,20246.70,NULL,NULL,NULL);
insert into tab_trans values (5036,91230,309,'1998-11-16','VYDAJ','VYBER',19100.00,14866.70,NULL,NULL,NULL);
insert into tab_trans values (5036,3540711,309,'1997-5-31','PRIJEM',NULL,22.40,23873.40,'UROK',NULL,NULL);
insert into tab_trans values (5036,3540712,309,'1997-6-30','PRIJEM',NULL,111.40,36310.80,'UROK',NULL,NULL);
insert into tab_trans values (5036,3540713,309,'1997-7-31','PRIJEM',NULL,148.30,34010.10,'UROK',NULL,NULL);
insert into tab_trans values (5036,3540714,309,'1997-8-31','PRIJEM',NULL,143.60,36104.80,'UROK',NULL,NULL);
insert into tab_trans values (5036,3540715,309,'1997-9-30','PRIJEM',NULL,173.20,28608.90,'UROK',NULL,NULL);
insert into tab_trans values (5036,3540716,309,'1997-10-31','PRIJEM',NULL,123.60,21568.90,'UROK',NULL,NULL);
insert into tab_trans values (5036,3540717,309,'1997-11-30','PRIJEM',NULL,108.50,23113.80,'UROK',NULL,NULL);
insert into tab_trans values (5036,3540718,309,'1997-12-31','PRIJEM',NULL,141.60,26886.80,'UROK',NULL,NULL);
insert into tab_trans values (5036,3540719,309,'1998-1-31','PRIJEM',NULL,111.10,12334.30,'UROK',NULL,NULL);
insert into tab_trans values (5036,3540720,309,'1998-2-28','PRIJEM',NULL,66.80,22537.50,'UROK',NULL,NULL);
insert into tab_trans values (5036,3540721,309,'1998-3-31','PRIJEM',NULL,124.80,24398.60,'UROK',NULL,NULL);
insert into tab_trans values (5036,3540722,309,'1998-4-30','PRIJEM',NULL,107.90,28643.00,'UROK',NULL,NULL);
insert into tab_trans values (5036,3540723,309,'1998-5-31','PRIJEM',NULL,135.00,31014.30,'UROK',NULL,NULL);
insert into tab_trans values (5036,3540724,309,'1998-6-30','PRIJEM',NULL,132.70,29558.40,'UROK',NULL,NULL);
insert into tab_trans values (5036,3540725,309,'1998-7-31','PRIJEM',NULL,131.30,23406.10,'UROK',NULL,NULL);
insert into tab_trans values (5036,3540726,309,'1998-8-31','PRIJEM',NULL,117.20,23959.70,'UROK',NULL,NULL);
insert into tab_trans values (5036,3540727,309,'1998-9-30','PRIJEM',NULL,114.20,21910.30,'UROK',NULL,NULL);
insert into tab_trans values (5036,3540728,309,'1998-10-31','PRIJEM',NULL,103.60,20350.30,'UROK',NULL,NULL);
insert into tab_trans values (5039,92385,314,'1996-1-26','PRIJEM','VKLAD',700.00,700.00,NULL,NULL,NULL);
insert into tab_trans values (5039,92387,314,'1996-2-6','PRIJEM','PREVOD Z UCTU',36897.00,37597.00,NULL,'IJ','74523085');
insert into tab_trans values (5039,92388,314,'1996-3-6','PRIJEM','PREVOD Z UCTU',36897.00,66815.50,NULL,'IJ','74523085');
insert into tab_trans values (5039,92389,314,'1996-4-6','PRIJEM','PREVOD Z UCTU',36897.00,82849.90,NULL,'IJ','74523085');
insert into tab_trans values (5039,92390,314,'1996-5-6','PRIJEM','PREVOD Z UCTU',36897.00,90744.30,NULL,'IJ','74523085');
insert into tab_trans values (5039,92391,314,'1996-6-6','PRIJEM','PREVOD Z UCTU',55346.00,109016.30,NULL,'IJ','74523085');
insert into tab_trans values (5039,92392,314,'1996-7-6','PRIJEM','PREVOD Z UCTU',36897.00,63316.40,NULL,'IJ','74523085');
insert into tab_trans values (5039,92393,314,'1996-8-6','PRIJEM','PREVOD Z UCTU',36897.00,65578.30,NULL,'IJ','74523085');
insert into tab_trans values (5039,92394,314,'1996-9-6','PRIJEM','PREVOD Z UCTU',36897.00,52541.00,NULL,'IJ','74523085');
insert into tab_trans values (5039,92395,314,'1996-10-6','PRIJEM','PREVOD Z UCTU',36897.00,57643.40,NULL,'IJ','74523085');
insert into tab_trans values (5039,92396,314,'1996-11-6','PRIJEM','PREVOD Z UCTU',36897.00,53077.20,NULL,'IJ','74523085');
insert into tab_trans values (5039,92397,314,'1996-12-6','PRIJEM','PREVOD Z UCTU',55346.00,77950.70,NULL,'IJ','74523085');
insert into tab_trans values (5039,92398,314,'1997-1-6','PRIJEM','PREVOD Z UCTU',36897.00,62847.10,NULL,'IJ','74523085');
insert into tab_trans values (5039,92399,314,'1997-2-6','PRIJEM','PREVOD Z UCTU',36897.00,55670.80,NULL,'IJ','74523085');
insert into tab_trans values (5039,92400,314,'1997-3-6','PRIJEM','PREVOD Z UCTU',36897.00,70307.80,NULL,'IJ','74523085');
insert into tab_trans values (5039,92401,314,'1997-4-6','PRIJEM','PREVOD Z UCTU',36897.00,72588.90,NULL,'IJ','74523085');
insert into tab_trans values (5039,92427,314,'1996-6-3','VYDAJ','VYBER',2800.00,53670.30,NULL,NULL,'0');
insert into tab_trans values (5039,92428,314,'1996-7-17','VYDAJ','VYBER',3300.00,43625.40,NULL,NULL,'0');
insert into tab_trans values (5039,92429,314,'1996-8-2','VYDAJ','VYBER',3200.00,28681.30,NULL,NULL,'0');
insert into tab_trans values (5039,92430,314,'1996-8-30','VYDAJ','VYBER',3500.00,15580.30,NULL,NULL,'0');
insert into tab_trans values (5039,92431,314,'1996-9-30','VYDAJ','VYBER',2200.00,20846.40,NULL,NULL,'0');
insert into tab_trans values (5039,92432,314,'1996-10-30','VYDAJ','VYBER',2500.00,27552.40,NULL,NULL,'0');
insert into tab_trans values (5039,92433,314,'1996-11-29','VYDAJ','VYBER',2400.00,22557.20,NULL,NULL,'0');
insert into tab_trans values (5039,92434,314,'1997-1-25','VYDAJ','VYBER',3300.00,20956.10,NULL,NULL,'0');
insert into tab_trans values (5039,92435,314,'1997-1-26','VYDAJ','VYBER',2200.00,18756.10,NULL,NULL,'0');
insert into tab_trans values (5039,92436,314,'1997-3-15','VYDAJ','VYBER',2000.00,54616.80,NULL,NULL,'0');
insert into tab_trans values (5039,92437,314,'1997-4-25','VYDAJ','VYBER',2200.00,36997.90,NULL,NULL,'0');
insert into tab_trans values (5039,92463,314,'1996-6-10','VYDAJ','PREVOD NA UCET',13691.00,35425.30,'SIPO','KL','99187093');
insert into tab_trans values (5039,92464,314,'1996-7-10','VYDAJ','PREVOD NA UCET',13691.00,46925.40,'SIPO','KL','99187093');
insert into tab_trans values (5039,92465,314,'1996-8-10','VYDAJ','PREVOD NA UCET',13691.00,51887.30,'SIPO','KL','99187093');
insert into tab_trans values (5039,92466,314,'1996-9-10','VYDAJ','PREVOD NA UCET',13691.00,29550.00,'SIPO','KL','99187093');
insert into tab_trans values (5039,92467,314,'1996-10-10','VYDAJ','PREVOD NA UCET',13691.00,43952.40,'SIPO','KL','99187093');
insert into tab_trans values (5039,92468,314,'1996-11-10','VYDAJ','PREVOD NA UCET',13691.00,39386.20,'SIPO','KL','99187093');
insert into tab_trans values (5039,92469,314,'1996-12-10','VYDAJ','PREVOD NA UCET',13691.00,23136.70,'SIPO','KL','99187093');
insert into tab_trans values (5039,92470,314,'1997-1-10','VYDAJ','PREVOD NA UCET',13691.00,37456.10,'SIPO','KL','99187093');
insert into tab_trans values (5039,92471,314,'1997-2-10','VYDAJ','PREVOD NA UCET',13691.00,41979.80,'SIPO','KL','99187093');
insert into tab_trans values (5039,92472,314,'1997-3-10','VYDAJ','PREVOD NA UCET',13691.00,56616.80,'SIPO','KL','99187093');
insert into tab_trans values (5039,92473,314,'1997-4-10','VYDAJ','PREVOD NA UCET',13691.00,58897.90,'SIPO','KL','99187093');
insert into tab_trans values (5039,92494,314,'1996-11-3','VYBER','VYBER',11408.00,16180.20,NULL,NULL,NULL);
insert into tab_trans values (5039,92496,314,'1996-12-9','VYBER','VYBER',13797.00,47027.70,NULL,NULL,NULL);
insert into tab_trans values (5039,92498,314,'1996-8-15','VYBER','VYBER',9214.00,42673.30,NULL,NULL,NULL);
insert into tab_trans values (5039,92500,314,'1996-8-25','VYBER','VYBER',15293.00,19080.30,NULL,NULL,NULL);
insert into tab_trans values (5039,92501,314,'1996-11-26','VYBER','VYBER',6729.00,24957.20,NULL,NULL,NULL);
insert into tab_trans values (5039,92506,314,'1996-12-7','VYBER','VYBER',17126.00,60824.70,NULL,NULL,NULL);
insert into tab_trans values (5039,92520,314,'1997-1-7','VYDAJ','VYBER',11700.00,51147.10,NULL,NULL,NULL);
insert into tab_trans values (5039,92534,314,'1997-1-15','VYDAJ','VYBER',6900.00,30556.10,NULL,NULL,NULL);
insert into tab_trans values (5039,92535,314,'1997-1-16','VYDAJ','VYBER',6900.00,23656.10,NULL,NULL,NULL);
insert into tab_trans values (5039,92543,314,'1996-9-19','VYDAJ','VYBER',10800.00,18750.00,NULL,NULL,NULL);
insert into tab_trans values (5039,92546,314,'1996-9-9','VYDAJ','VYBER',9300.00,43241.00,NULL,NULL,NULL);
insert into tab_trans values (5039,92547,314,'1996-7-9','VYDAJ','VYBER',2700.00,60616.40,NULL,NULL,NULL);
insert into tab_trans values (5039,92549,314,'1996-12-9','VYDAJ','VYBER',10200.00,36827.70,NULL,NULL,NULL);
insert into tab_trans values (5039,92553,314,'1997-4-27','VYDAJ','VYBER',14400.00,22597.90,NULL,NULL,NULL);
insert into tab_trans values (5039,92566,314,'1996-6-30','VYDAJ','VYBER',100.00,26419.40,'SLUZBY',NULL,NULL);
insert into tab_trans values (5039,92567,314,'1996-7-31','VYDAJ','VYBER',100.00,31881.30,'SLUZBY',NULL,NULL);
insert into tab_trans values (5039,92568,314,'1996-8-31','VYDAJ','VYBER',100.00,15644.00,'SLUZBY',NULL,NULL);
insert into tab_trans values (5039,92569,314,'1996-9-30','VYDAJ','VYBER',100.00,20746.40,'SLUZBY',NULL,NULL);
insert into tab_trans values (5039,92570,314,'1996-10-31','VYDAJ','VYBER',100.00,27588.20,'SLUZBY',NULL,NULL);
insert into tab_trans values (5039,92571,314,'1996-11-30','VYDAJ','VYBER',100.00,22604.70,'SLUZBY',NULL,NULL);
insert into tab_trans values (5039,92572,314,'1996-12-31','VYDAJ','VYBER',100.00,25950.10,'SLUZBY',NULL,NULL);
insert into tab_trans values (5039,92573,314,'1997-1-31','VYDAJ','VYBER',100.00,18773.80,'SLUZBY',NULL,NULL);
insert into tab_trans values (5039,92574,314,'1997-2-28','VYDAJ','VYBER',100.00,33410.80,'SLUZBY',NULL,NULL);
insert into tab_trans values (5039,92575,314,'1997-3-31','VYDAJ','VYBER',100.00,35691.90,'SLUZBY',NULL,NULL);
insert into tab_trans values (5039,92576,314,'1997-4-30','VYDAJ','VYBER',100.00,22674.30,'SLUZBY',NULL,NULL);
insert into tab_trans values (5039,92596,314,'1996-2-25','VYDAJ','VYBER',7700.00,29897.00,NULL,NULL,NULL);
insert into tab_trans values (5039,92597,314,'1996-3-26','VYDAJ','VYBER',21000.00,45815.50,NULL,NULL,NULL);
insert into tab_trans values (5039,92598,314,'1996-4-25','VYDAJ','VYBER',29200.00,53649.90,NULL,NULL,NULL);
insert into tab_trans values (5039,92599,314,'1996-5-25','VYDAJ','VYBER',34500.00,56244.30,NULL,NULL,NULL);
insert into tab_trans values (5039,92600,314,'1996-6-6','VYDAJ','VYBER',59900.00,49116.30,NULL,NULL,NULL);
insert into tab_trans values (5039,92601,314,'1996-6-24','VYDAJ','VYBER',9100.00,26325.30,NULL,NULL,NULL);
insert into tab_trans values (5039,92602,314,'1996-7-24','VYDAJ','VYBER',11800.00,31825.40,NULL,NULL,NULL);
insert into tab_trans values (5039,92603,314,'1996-8-23','VYDAJ','VYBER',8300.00,34373.30,NULL,NULL,NULL);
insert into tab_trans values (5039,92604,314,'1996-9-22','PRIJEM','VKLAD',4200.00,22950.00,NULL,NULL,NULL);
insert into tab_trans values (5039,92605,314,'1996-10-22','VYDAJ','VYBER',13900.00,30052.40,NULL,NULL,NULL);
insert into tab_trans values (5039,92606,314,'1996-11-21','VYDAJ','VYBER',7700.00,31686.20,NULL,NULL,NULL);
insert into tab_trans values (5039,92607,314,'1996-12-21','PRIJEM','VKLAD',2800.00,25936.70,NULL,NULL,NULL);
insert into tab_trans values (5039,92608,314,'1997-1-20','PRIJEM','VKLAD',600.00,24256.10,NULL,NULL,NULL);
insert into tab_trans values (5039,92609,314,'1997-2-19','VYDAJ','VYBER',8600.00,33379.80,NULL,NULL,NULL);
insert into tab_trans values (5039,92610,314,'1997-3-21','VYDAJ','VYBER',19000.00,35616.80,NULL,NULL,NULL);
insert into tab_trans values (5039,92611,314,'1997-4-20','VYDAJ','VYBER',19700.00,39197.90,NULL,NULL,NULL);
insert into tab_trans values (5039,3540884,314,'1996-2-29','PRIJEM',NULL,21.50,29918.50,'UROK',NULL,NULL);
insert into tab_trans values (5039,3540885,314,'1996-3-31','PRIJEM',NULL,137.40,45952.90,'UROK',NULL,NULL);
insert into tab_trans values (5039,3540886,314,'1996-4-30','PRIJEM',NULL,197.40,53847.30,'UROK',NULL,NULL);
insert into tab_trans values (5039,3540887,314,'1996-5-31','PRIJEM',NULL,226.00,56470.30,'UROK',NULL,NULL);
insert into tab_trans values (5039,3540888,314,'1996-6-30','PRIJEM',NULL,194.10,26519.40,'UROK',NULL,NULL);
insert into tab_trans values (5039,3540889,314,'1996-7-31','PRIJEM',NULL,156.00,31981.30,'UROK',NULL,NULL);
insert into tab_trans values (5039,3540890,314,'1996-8-31','PRIJEM',NULL,163.70,15744.00,'UROK',NULL,NULL);
insert into tab_trans values (5039,3540891,314,'1996-9-30','PRIJEM',NULL,96.40,23046.40,'UROK',NULL,NULL);
insert into tab_trans values (5039,3540892,314,'1996-10-31','PRIJEM',NULL,135.80,27688.20,'UROK',NULL,NULL);
insert into tab_trans values (5039,3540893,314,'1996-11-30','PRIJEM',NULL,147.50,22704.70,'UROK',NULL,NULL);
insert into tab_trans values (5039,3540894,314,'1996-12-31','PRIJEM',NULL,113.40,26050.10,'UROK',NULL,NULL);
insert into tab_trans values (5039,3540895,314,'1997-1-31','PRIJEM',NULL,117.80,18873.80,'UROK',NULL,NULL);
insert into tab_trans values (5039,3540896,314,'1997-2-28','PRIJEM',NULL,131.00,33510.80,'UROK',NULL,NULL);
insert into tab_trans values (5039,3540897,314,'1997-3-31','PRIJEM',NULL,175.10,35791.90,'UROK',NULL,NULL);
insert into tab_trans values (5039,3540898,314,'1997-4-30','PRIJEM',NULL,176.40,22774.30,'UROK',NULL,NULL);
insert into tab_trans values (5041,93624,319,'1995-10-17','PRIJEM','VKLAD',700.00,700.00,NULL,NULL,NULL);
insert into tab_trans values (5041,93625,319,'1995-11-20','PRIJEM','VKLAD',9512.00,22612.00,NULL,NULL,NULL);
insert into tab_trans values (5041,93627,319,'1995-12-23','PRIJEM','VKLAD',9904.00,59595.50,NULL,NULL,NULL);
insert into tab_trans values (5041,93635,319,'1995-11-30','PRIJEM','VKLAD',7174.00,29786.00,NULL,NULL,NULL);
insert into tab_trans values (5041,93637,319,'1995-12-29','PRIJEM','VKLAD',18295.00,77890.50,NULL,NULL,NULL);
insert into tab_trans values (5041,93639,319,'1995-12-14','PRIJEM','VKLAD',44470.00,74291.50,NULL,NULL,NULL);
insert into tab_trans values (5041,93648,319,'1996-2-28','PRIJEM','VKLAD',43718.00,60796.80,NULL,NULL,NULL);
insert into tab_trans values (5041,93649,319,'1996-10-2','PRIJEM','VKLAD',38257.00,89707.70,NULL,NULL,NULL);
insert into tab_trans values (5041,93650,319,'1996-9-2','PRIJEM','VKLAD',44577.00,89424.30,NULL,NULL,NULL);
insert into tab_trans values (5041,93651,319,'1996-5-24','PRIJEM','VKLAD',38189.00,63493.30,NULL,NULL,NULL);
insert into tab_trans values (5041,93652,319,'1996-8-10','PRIJEM','VKLAD',18765.00,65740.90,NULL,NULL,NULL);
insert into tab_trans values (5041,93653,319,'1996-6-9','PRIJEM','VKLAD',29057.00,83865.40,NULL,NULL,NULL);
insert into tab_trans values (5041,93654,319,'1996-8-8','PRIJEM','VKLAD',10164.00,46975.90,NULL,NULL,NULL);
insert into tab_trans values (5041,93656,319,'1997-6-29','PRIJEM','VKLAD',27893.00,68800.30,NULL,NULL,NULL);
insert into tab_trans values (5041,93657,319,'1997-2-9','PRIJEM','VKLAD',8809.00,46958.10,NULL,NULL,NULL);
insert into tab_trans values (5041,93660,319,'1997-4-18','PRIJEM','VKLAD',26002.00,110827.30,NULL,NULL,NULL);
insert into tab_trans values (5041,93662,319,'1997-1-1','PRIJEM','VKLAD',9778.00,56902.50,NULL,NULL,NULL);
insert into tab_trans values (5041,93663,319,'1997-4-16','PRIJEM','VKLAD',23907.00,84825.30,NULL,NULL,NULL);
insert into tab_trans values (5041,93667,319,'1997-1-1','PRIJEM','VKLAD',20231.00,47124.50,NULL,NULL,NULL);
insert into tab_trans values (5041,93668,319,'1997-4-6','PRIJEM','VKLAD',47415.00,82487.30,NULL,NULL,NULL);
insert into tab_trans values (5041,93710,319,'1996-1-21','VYDAJ','VYBER',9100.00,32577.80,NULL,NULL,'0');
insert into tab_trans values (5041,93711,319,'1996-1-29','VYDAJ','VYBER',5700.00,10977.80,NULL,NULL,'0');
insert into tab_trans values (5041,93712,319,'1996-3-7','VYDAJ','VYBER',7900.00,52939.20,NULL,NULL,'0');
insert into tab_trans values (5041,93713,319,'1996-4-18','VYDAJ','VYBER',4300.00,24773.20,NULL,NULL,'0');
insert into tab_trans values (5041,93714,319,'1996-5-17','VYDAJ','VYBER',4200.00,25304.30,NULL,NULL,'0');
insert into tab_trans values (5041,93715,319,'1996-5-30','VYDAJ','VYBER',8800.00,54693.30,NULL,NULL,'0');
insert into tab_trans values (5041,93716,319,'1996-7-18','VYDAJ','VYBER',6600.00,42439.20,NULL,NULL,'0');
insert into tab_trans values (5041,93717,319,'1996-8-4','VYDAJ','VYBER',5800.00,36811.90,NULL,NULL,'0');
insert into tab_trans values (5041,93718,319,'1996-8-30','VYDAJ','VYBER',5800.00,44671.90,NULL,NULL,'0');
insert into tab_trans values (5041,93719,319,'1996-10-26','VYDAJ','VYBER',5500.00,59438.70,NULL,NULL,'0');
insert into tab_trans values (5041,93720,319,'1996-11-19','VYDAJ','VYBER',5200.00,38176.40,NULL,NULL,'0');
insert into tab_trans values (5041,93721,319,'1996-12-22','VYDAJ','VYBER',4800.00,33971.80,NULL,NULL,'0');
insert into tab_trans values (5041,93722,319,'1997-1-28','VYDAJ','VYBER',4800.00,23033.50,NULL,NULL,'0');
insert into tab_trans values (5041,93723,319,'1997-2-10','VYDAJ','VYBER',4900.00,41642.10,NULL,NULL,'0');
insert into tab_trans values (5041,93724,319,'1997-3-28','VYDAJ','VYBER',5500.00,34937.30,NULL,NULL,'0');
insert into tab_trans values (5041,93725,319,'1997-4-18','VYDAJ','VYBER',6000.00,104827.30,NULL,NULL,'0');
insert into tab_trans values (5041,93726,319,'1997-4-30','VYDAJ','VYBER',5200.00,80326.40,NULL,NULL,'0');
insert into tab_trans values (5041,93727,319,'1997-6-6','VYDAJ','VYBER',6700.00,44376.30,NULL,NULL,'0');
insert into tab_trans values (5041,93758,319,'1996-1-13','VYDAJ','PREVOD NA UCET',1057.00,66973.80,'SIPO','KL','87909203');
insert into tab_trans values (5041,93759,319,'1996-2-13','VYDAJ','PREVOD NA UCET',1057.00,9674.80,'SIPO','KL','87909203');
insert into tab_trans values (5041,93760,319,'1996-3-13','VYDAJ','PREVOD NA UCET',1057.00,51466.20,'SIPO','KL','87909203');
insert into tab_trans values (5041,93761,319,'1996-4-13','VYDAJ','PREVOD NA UCET',1057.00,28869.20,'SIPO','KL','87909203');
insert into tab_trans values (5041,93762,319,'1996-5-13','VYDAJ','PREVOD NA UCET',1057.00,23400.30,'SIPO','KL','87909203');
insert into tab_trans values (5041,93763,319,'1996-6-13','VYDAJ','PREVOD NA UCET',1057.00,82392.40,'SIPO','KL','87909203');
insert into tab_trans values (5041,93764,319,'1996-7-13','VYDAJ','PREVOD NA UCET',1057.00,53935.20,'SIPO','KL','87909203');
insert into tab_trans values (5041,93765,319,'1996-8-13','VYDAJ','PREVOD NA UCET',1057.00,52667.90,'SIPO','KL','87909203');
insert into tab_trans values (5041,93766,319,'1996-9-13','VYDAJ','PREVOD NA UCET',1057.00,53451.30,'SIPO','KL','87909203');
insert into tab_trans values (5041,93767,319,'1996-10-13','VYDAJ','PREVOD NA UCET',1057.00,67134.70,'SIPO','KL','87909203');
insert into tab_trans values (5041,93768,319,'1996-11-13','VYDAJ','PREVOD NA UCET',1057.00,45572.40,'SIPO','KL','87909203');
insert into tab_trans values (5041,93769,319,'1996-12-13','VYDAJ','PREVOD NA UCET',1057.00,40967.80,'SIPO','KL','87909203');
insert into tab_trans values (5041,93770,319,'1997-1-13','VYDAJ','PREVOD NA UCET',1057.00,38429.50,'SIPO','KL','87909203');
insert into tab_trans values (5041,93771,319,'1997-2-13','VYDAJ','PREVOD NA UCET',1057.00,40585.10,'SIPO','KL','87909203');
insert into tab_trans values (5041,93772,319,'1997-3-13','VYDAJ','PREVOD NA UCET',1057.00,42633.30,'SIPO','KL','87909203');
insert into tab_trans values (5041,93773,319,'1997-4-13','VYDAJ','PREVOD NA UCET',1057.00,63114.30,'SIPO','KL','87909203');
insert into tab_trans values (5041,93774,319,'1997-5-13','VYDAJ','PREVOD NA UCET',1057.00,53053.40,'SIPO','KL','87909203');
insert into tab_trans values (5041,93775,319,'1997-6-13','VYDAJ','PREVOD NA UCET',1057.00,43103.30,'SIPO','KL','87909203');
insert into tab_trans values (5041,93806,319,'1996-1-14','VYDAJ','PREVOD NA UCET',2196.00,62977.80,NULL,'KL','32717514');
insert into tab_trans values (5041,93807,319,'1996-2-14','VYDAJ','PREVOD NA UCET',2196.00,17078.80,NULL,'KL','32717514');
insert into tab_trans values (5041,93808,319,'1996-3-14','VYDAJ','PREVOD NA UCET',2196.00,49270.20,NULL,'KL','32717514');
insert into tab_trans values (5041,93809,319,'1996-4-14','VYDAJ','PREVOD NA UCET',2196.00,29073.20,NULL,'KL','32717514');
insert into tab_trans values (5041,93810,319,'1996-5-14','VYDAJ','PREVOD NA UCET',2196.00,29504.30,NULL,'KL','32717514');
insert into tab_trans values (5041,93811,319,'1996-6-14','VYDAJ','PREVOD NA UCET',2196.00,55196.40,NULL,'KL','32717514');
insert into tab_trans values (5041,93812,319,'1996-7-14','VYDAJ','PREVOD NA UCET',2196.00,49039.20,NULL,'KL','32717514');
insert into tab_trans values (5041,93813,319,'1996-8-14','VYDAJ','PREVOD NA UCET',2196.00,50471.90,NULL,'KL','32717514');
insert into tab_trans values (5041,93814,319,'1996-9-14','VYDAJ','PREVOD NA UCET',2196.00,51255.30,NULL,'KL','32717514');
insert into tab_trans values (5041,93815,319,'1996-10-14','VYDAJ','PREVOD NA UCET',2196.00,64938.70,NULL,'KL','32717514');
insert into tab_trans values (5041,93816,319,'1996-11-14','VYDAJ','PREVOD NA UCET',2196.00,43376.40,NULL,'KL','32717514');
insert into tab_trans values (5041,93817,319,'1996-12-14','VYDAJ','PREVOD NA UCET',2196.00,38771.80,NULL,'KL','32717514');
insert into tab_trans values (5041,93818,319,'1997-1-14','VYDAJ','PREVOD NA UCET',2196.00,29933.50,NULL,'KL','32717514');
insert into tab_trans values (5041,93819,319,'1997-2-14','VYDAJ','PREVOD NA UCET',2196.00,38389.10,NULL,'KL','32717514');
insert into tab_trans values (5041,93820,319,'1997-3-14','VYDAJ','PREVOD NA UCET',2196.00,40437.30,NULL,'KL','32717514');
insert into tab_trans values (5041,93821,319,'1997-4-14','VYDAJ','PREVOD NA UCET',2196.00,60918.30,NULL,'KL','32717514');
insert into tab_trans values (5041,93822,319,'1997-5-14','VYDAJ','PREVOD NA UCET',2196.00,50857.40,NULL,'KL','32717514');
insert into tab_trans values (5041,93823,319,'1997-6-14','VYDAJ','PREVOD NA UCET',2196.00,40907.30,NULL,'KL','32717514');
insert into tab_trans values (5041,93854,319,'1996-1-10','VYDAJ','PREVOD NA UCET',416.00,70130.80,'POJISTNE','AB','559258');
insert into tab_trans values (5041,93855,319,'1996-2-10','VYDAJ','PREVOD NA UCET',416.00,10731.80,'POJISTNE','AB','559258');
insert into tab_trans values (5041,93856,319,'1996-3-10','VYDAJ','PREVOD NA UCET',416.00,52523.20,'POJISTNE','AB','559258');
insert into tab_trans values (5041,93857,319,'1996-4-10','VYDAJ','PREVOD NA UCET',416.00,29926.20,'POJISTNE','AB','559258');
insert into tab_trans values (5041,93858,319,'1996-5-10','VYDAJ','PREVOD NA UCET',416.00,24457.30,'POJISTNE','AB','559258');
insert into tab_trans values (5041,93859,319,'1996-6-10','VYDAJ','PREVOD NA UCET',416.00,83449.40,'POJISTNE','AB','559258');
insert into tab_trans values (5041,93860,319,'1996-7-10','VYDAJ','PREVOD NA UCET',416.00,54992.20,'POJISTNE','AB','559258');
insert into tab_trans values (5041,93861,319,'1996-8-10','VYDAJ','PREVOD NA UCET',416.00,65324.90,'POJISTNE','AB','559258');
insert into tab_trans values (5041,93862,319,'1996-9-10','VYDAJ','PREVOD NA UCET',416.00,79108.30,'POJISTNE','AB','559258');
insert into tab_trans values (5041,93863,319,'1996-10-10','VYDAJ','PREVOD NA UCET',416.00,89291.70,'POJISTNE','AB','559258');
insert into tab_trans values (5041,93864,319,'1996-11-10','VYDAJ','PREVOD NA UCET',416.00,46629.40,'POJISTNE','AB','559258');
insert into tab_trans values (5041,93865,319,'1996-12-10','VYDAJ','PREVOD NA UCET',416.00,42024.80,'POJISTNE','AB','559258');
insert into tab_trans values (5041,93866,319,'1997-1-10','VYDAJ','PREVOD NA UCET',416.00,39486.50,'POJISTNE','AB','559258');
insert into tab_trans values (5041,93867,319,'1997-2-10','VYDAJ','PREVOD NA UCET',416.00,46542.10,'POJISTNE','AB','559258');
insert into tab_trans values (5041,93868,319,'1997-3-10','VYDAJ','PREVOD NA UCET',416.00,43690.30,'POJISTNE','AB','559258');
insert into tab_trans values (5041,93869,319,'1997-4-10','VYDAJ','PREVOD NA UCET',416.00,64171.30,'POJISTNE','AB','559258');
insert into tab_trans values (5041,93870,319,'1997-5-10','VYDAJ','PREVOD NA UCET',416.00,54110.40,'POJISTNE','AB','559258');
insert into tab_trans values (5041,93871,319,'1997-6-10','VYDAJ','PREVOD NA UCET',416.00,44160.30,'POJISTNE','AB','559258');
insert into tab_trans values (5041,93872,319,'1997-7-10','VYDAJ','PREVOD NA UCET',416.00,59544.80,'POJISTNE','AB','559258');
insert into tab_trans values (5041,93902,319,'1996-11-6','VYBER','VYBER',9118.00,50545.40,NULL,NULL,NULL);
insert into tab_trans values (5041,93907,319,'1997-4-29','VYBER','VYBER',19587.00,85240.30,NULL,NULL,NULL);
insert into tab_trans values (5041,93926,319,'1996-1-14','VYDAJ','VYBER',12600.00,50377.80,NULL,NULL,NULL);
insert into tab_trans values (5041,93927,319,'1997-1-6','VYDAJ','VYBER',11700.00,45202.50,NULL,NULL,NULL);
insert into tab_trans values (5041,93930,319,'1996-12-27','VYDAJ','VYBER',7200.00,26771.80,NULL,NULL,NULL);
insert into tab_trans values (5041,93939,319,'1996-1-17','VYDAJ','VYBER',3600.00,41677.80,NULL,NULL,NULL);
insert into tab_trans values (5041,93940,319,'1996-1-12','VYDAJ','VYBER',2100.00,68030.80,NULL,NULL,NULL);
insert into tab_trans values (5041,93941,319,'1996-1-3','VYDAJ','VYBER',7500.00,70546.80,NULL,NULL,NULL);
insert into tab_trans values (5041,93942,319,'1996-1-24','VYDAJ','VYBER',3600.00,16677.80,NULL,NULL,NULL);
insert into tab_trans values (5041,93943,319,'1996-1-13','VYDAJ','VYBER',1800.00,65173.80,NULL,NULL,NULL);
insert into tab_trans values (5041,93947,319,'1997-1-6','VYDAJ','VYBER',5400.00,39802.50,NULL,NULL,NULL);
insert into tab_trans values (5041,93948,319,'1997-1-18','VYDAJ','VYBER',2100.00,27833.50,NULL,NULL,NULL);
insert into tab_trans values (5041,93949,319,'1997-1-14','VYDAJ','VYBER',6300.00,32129.50,NULL,NULL,NULL);
insert into tab_trans values (5041,93962,319,'1996-1-22','VYDAJ','VYBER',12300.00,20277.80,NULL,NULL,NULL);
insert into tab_trans values (5041,93964,319,'1996-4-7','VYDAJ','VYBER',10800.00,30342.20,NULL,NULL,NULL);
insert into tab_trans values (5041,93965,319,'1996-9-7','VYDAJ','VYBER',9900.00,79524.30,NULL,NULL,NULL);
insert into tab_trans values (5041,93967,319,'1997-5-10','VYDAJ','VYBER',8100.00,54526.40,NULL,NULL,NULL);
insert into tab_trans values (5041,93969,319,'1997-1-7','VYDAJ','VYBER',9300.00,30502.50,NULL,NULL,NULL);
insert into tab_trans values (5041,93989,319,'1995-12-31','VYDAJ','VYBER',30.00,78046.80,'SLUZBY',NULL,NULL);
insert into tab_trans values (5041,93990,319,'1996-1-31','VYDAJ','VYBER',30.00,11147.80,'SLUZBY',NULL,NULL);
insert into tab_trans values (5041,93991,319,'1996-2-29','VYDAJ','VYBER',30.00,60839.20,'SLUZBY',NULL,NULL);
insert into tab_trans values (5041,93992,319,'1996-3-31','VYDAJ','VYBER',30.00,41142.20,'SLUZBY',NULL,NULL);
insert into tab_trans values (5041,93993,319,'1996-4-30','VYDAJ','VYBER',30.00,24873.30,'SLUZBY',NULL,NULL);
insert into tab_trans values (5041,93994,319,'1996-5-31','VYDAJ','VYBER',30.00,54808.40,'SLUZBY',NULL,NULL);
insert into tab_trans values (5041,93995,319,'1996-6-30','VYDAJ','VYBER',30.00,55408.20,'SLUZBY',NULL,NULL);
insert into tab_trans values (5041,93996,319,'1996-7-31','VYDAJ','VYBER',30.00,42611.90,'SLUZBY',NULL,NULL);
insert into tab_trans values (5041,93997,319,'1996-8-31','VYDAJ','VYBER',30.00,44847.30,'SLUZBY',NULL,NULL);
insert into tab_trans values (5041,93998,319,'1996-9-30','VYDAJ','VYBER',30.00,51450.70,'SLUZBY',NULL,NULL);
insert into tab_trans values (5041,93999,319,'1996-10-31','VYDAJ','VYBER',30.00,59663.40,'SLUZBY',NULL,NULL);
insert into tab_trans values (5041,94000,319,'1996-11-30','VYDAJ','VYBER',30.00,38340.80,'SLUZBY',NULL,NULL);
insert into tab_trans values (5041,94001,319,'1996-12-31','VYDAJ','VYBER',30.00,26893.50,'SLUZBY',NULL,NULL);
insert into tab_trans values (5041,94002,319,'1997-1-31','VYDAJ','VYBER',30.00,23149.10,'SLUZBY',NULL,NULL);
insert into tab_trans values (5041,94003,319,'1997-2-28','VYDAJ','VYBER',30.00,38506.30,'SLUZBY',NULL,NULL);
insert into tab_trans values (5041,94004,319,'1997-3-31','VYDAJ','VYBER',30.00,35072.30,'SLUZBY',NULL,NULL);
insert into tab_trans values (5041,94005,319,'1997-4-30','VYDAJ','VYBER',30.00,85526.40,'SLUZBY',NULL,NULL);
insert into tab_trans values (5041,94006,319,'1997-5-31','VYDAJ','VYBER',30.00,51076.30,'SLUZBY',NULL,NULL);
insert into tab_trans values (5041,94007,319,'1997-6-30','VYDAJ','VYBER',30.00,68960.80,'SLUZBY',NULL,NULL);
insert into tab_trans values (5041,94025,319,'1995-11-16','PRIJEM','VKLAD',12400.00,13100.00,NULL,NULL,NULL);
insert into tab_trans values (5041,94026,319,'1995-12-16','VYDAJ','VYBER',24600.00,49691.50,NULL,NULL,NULL);
insert into tab_trans values (5041,94027,319,'1996-1-15','VYDAJ','VYBER',5100.00,45277.80,NULL,NULL,NULL);
insert into tab_trans values (5041,94028,319,'1996-2-14','PRIJEM','VKLAD',9600.00,19274.80,NULL,NULL,NULL);
insert into tab_trans values (5041,94029,319,'1996-3-15','VYDAJ','VYBER',8300.00,40970.20,NULL,NULL,NULL);
insert into tab_trans values (5041,94030,319,'1996-4-14','PRIJEM','VKLAD',2400.00,31269.20,NULL,NULL,NULL);
insert into tab_trans values (5041,94031,319,'1996-5-14','PRIJEM','VKLAD',8300.00,31700.30,NULL,NULL,NULL);
insert into tab_trans values (5041,94032,319,'1996-6-13','VYDAJ','VYBER',25000.00,57392.40,NULL,NULL,NULL);
insert into tab_trans values (5041,94033,319,'1996-7-13','VYDAJ','VYBER',2700.00,51235.20,NULL,NULL,NULL);
insert into tab_trans values (5041,94034,319,'1996-8-12','VYDAJ','VYBER',11600.00,53724.90,NULL,NULL,NULL);
insert into tab_trans values (5041,94035,319,'1996-9-11','VYDAJ','VYBER',24600.00,54508.30,NULL,NULL,NULL);
insert into tab_trans values (5041,94036,319,'1996-10-11','VYDAJ','VYBER',21100.00,68191.70,NULL,NULL,NULL);
insert into tab_trans values (5041,94037,319,'1996-11-10','VYDAJ','VYBER',3500.00,47045.40,NULL,NULL,NULL);
insert into tab_trans values (5041,94038,319,'1996-12-10','PRIJEM','VKLAD',4100.00,42440.80,NULL,NULL,NULL);
insert into tab_trans values (5041,94039,319,'1997-1-9','PRIJEM','VKLAD',9400.00,39902.50,NULL,NULL,NULL);
insert into tab_trans values (5041,94040,319,'1997-2-8','PRIJEM','VKLAD',15000.00,38149.10,NULL,NULL,NULL);
insert into tab_trans values (5041,94041,319,'1997-3-10','PRIJEM','VKLAD',5600.00,44106.30,NULL,NULL,NULL);
insert into tab_trans values (5041,94042,319,'1997-4-9','VYDAJ','VYBER',17900.00,64587.30,NULL,NULL,NULL);
insert into tab_trans values (5041,94043,319,'1997-5-9','VYDAJ','VYBER',17700.00,62626.40,NULL,NULL,NULL);
insert into tab_trans values (5041,94044,319,'1997-6-8','PRIJEM','VKLAD',200.00,44576.30,NULL,NULL,NULL);
insert into tab_trans values (5041,94045,319,'1997-7-8','VYDAJ','VYBER',9000.00,59960.80,NULL,NULL,NULL);
insert into tab_trans values (5041,3541040,319,'1995-11-30','PRIJEM',NULL,35.50,29821.50,'UROK',NULL,NULL);
insert into tab_trans values (5041,3541041,319,'1995-12-31','PRIJEM',NULL,186.30,78076.80,'UROK',NULL,NULL);
insert into tab_trans values (5041,3541042,319,'1996-1-31','PRIJEM',NULL,199.90,11177.80,'UROK',NULL,NULL);
insert into tab_trans values (5041,3541043,319,'1996-2-29','PRIJEM',NULL,72.40,60869.20,'UROK',NULL,NULL);
insert into tab_trans values (5041,3541044,319,'1996-3-31','PRIJEM',NULL,202.00,41172.20,'UROK',NULL,NULL);
insert into tab_trans values (5041,3541045,319,'1996-4-30','PRIJEM',NULL,130.10,24903.30,'UROK',NULL,NULL);
insert into tab_trans values (5041,3541046,319,'1996-5-31','PRIJEM',NULL,145.10,54838.40,'UROK',NULL,NULL);
insert into tab_trans values (5041,3541047,319,'1996-6-30','PRIJEM',NULL,241.80,55438.20,'UROK',NULL,NULL);
insert into tab_trans values (5041,3541048,319,'1996-7-31','PRIJEM',NULL,202.80,42641.90,'UROK',NULL,NULL);
insert into tab_trans values (5041,3541049,319,'1996-8-31','PRIJEM',NULL,205.40,44877.30,'UROK',NULL,NULL);
insert into tab_trans values (5041,3541050,319,'1996-9-30','PRIJEM',NULL,225.40,51480.70,'UROK',NULL,NULL);
insert into tab_trans values (5041,3541051,319,'1996-10-31','PRIJEM',NULL,254.70,59693.40,'UROK',NULL,NULL);
insert into tab_trans values (5041,3541052,319,'1996-11-30','PRIJEM',NULL,194.40,38370.80,'UROK',NULL,NULL);
insert into tab_trans values (5041,3541053,319,'1996-12-31','PRIJEM',NULL,151.70,26923.50,'UROK',NULL,NULL);
insert into tab_trans values (5041,3541054,319,'1997-1-31','PRIJEM',NULL,145.60,23179.10,'UROK',NULL,NULL);
insert into tab_trans values (5041,3541055,319,'1997-2-28','PRIJEM',NULL,147.20,38536.30,'UROK',NULL,NULL);
insert into tab_trans values (5041,3541056,319,'1997-3-31','PRIJEM',NULL,165.00,35102.30,'UROK',NULL,NULL);
insert into tab_trans values (5041,3541057,319,'1997-4-30','PRIJEM',NULL,316.10,85556.40,'UROK',NULL,NULL);
insert into tab_trans values (5041,3541058,319,'1997-5-31','PRIJEM',NULL,248.90,51106.30,'UROK',NULL,NULL);
insert into tab_trans values (5041,3541059,319,'1997-6-30','PRIJEM',NULL,190.40,68990.80,'UROK',NULL,NULL);
insert into tab_trans values (5042,96621,330,'1996-11-24','PRIJEM','VKLAD',400.00,400.00,NULL,NULL,NULL);
insert into tab_trans values (5042,96633,330,'1996-12-6','PRIJEM','VKLAD',33590.00,33990.00,NULL,NULL,NULL);
insert into tab_trans values (5042,96634,330,'1997-1-6','PRIJEM','VKLAD',22393.00,52315.10,NULL,NULL,NULL);
insert into tab_trans values (5042,96635,330,'1997-2-6','PRIJEM','VKLAD',22393.00,56938.10,NULL,NULL,NULL);
insert into tab_trans values (5042,96636,330,'1997-3-6','PRIJEM','VKLAD',22393.00,63481.30,NULL,NULL,NULL);
insert into tab_trans values (5042,96637,330,'1997-4-6','PRIJEM','VKLAD',22393.00,64252.70,NULL,NULL,NULL);
insert into tab_trans values (5042,96638,330,'1997-5-6','PRIJEM','VKLAD',22393.00,58213.10,NULL,NULL,NULL);
insert into tab_trans values (5042,96639,330,'1997-6-6','PRIJEM','VKLAD',33590.00,73943.00,NULL,NULL,NULL);
insert into tab_trans values (5042,96640,330,'1997-7-6','PRIJEM','VKLAD',22393.00,35743.50,NULL,NULL,NULL);
insert into tab_trans values (5042,96641,330,'1997-8-6','PRIJEM','VKLAD',22393.00,45236.40,NULL,NULL,NULL);
insert into tab_trans values (5042,96642,330,'1997-9-6','PRIJEM','VKLAD',22393.00,53124.10,NULL,NULL,NULL);
insert into tab_trans values (5042,96643,330,'1997-10-6','PRIJEM','VKLAD',22393.00,60867.70,NULL,NULL,NULL);
insert into tab_trans values (5042,96644,330,'1997-11-6','PRIJEM','VKLAD',22393.00,60106.60,NULL,NULL,NULL);
insert into tab_trans values (5042,96645,330,'1997-12-6','PRIJEM','VKLAD',33590.00,64835.00,NULL,NULL,NULL);
insert into tab_trans values (5042,96646,330,'1998-1-6','PRIJEM','VKLAD',22393.00,61722.80,NULL,NULL,NULL);
insert into tab_trans values (5042,96647,330,'1998-2-6','PRIJEM','VKLAD',22393.00,50161.10,NULL,NULL,NULL);
insert into tab_trans values (5042,96648,330,'1998-3-6','PRIJEM','VKLAD',22393.00,60917.90,NULL,NULL,NULL);
insert into tab_trans values (5042,96649,330,'1998-4-6','PRIJEM','VKLAD',22393.00,56280.20,NULL,NULL,NULL);
insert into tab_trans values (5042,96650,330,'1998-5-6','PRIJEM','VKLAD',22393.00,58944.90,NULL,NULL,NULL);
insert into tab_trans values (5042,96651,330,'1998-6-6','PRIJEM','VKLAD',33590.00,73515.00,NULL,NULL,NULL);
insert into tab_trans values (5042,96652,330,'1998-7-6','PRIJEM','VKLAD',22393.00,57774.80,NULL,NULL,NULL);
insert into tab_trans values (5042,96673,330,'1997-4-5','VYDAJ','VYBER',6500.00,41859.70,NULL,NULL,'0');
insert into tab_trans values (5042,96674,330,'1997-4-24','VYDAJ','VYBER',8500.00,35612.70,NULL,NULL,'0');
insert into tab_trans values (5042,96675,330,'1997-6-8','VYDAJ','VYBER',8600.00,65343.00,NULL,NULL,'0');
insert into tab_trans values (5042,96676,330,'1997-7-20','VYDAJ','VYBER',10400.00,23543.50,NULL,NULL,'0');
insert into tab_trans values (5042,96677,330,'1997-8-20','VYDAJ','VYBER',4400.00,40836.40,NULL,NULL,'0');
insert into tab_trans values (5042,96678,330,'1997-9-19','VYDAJ','VYBER',4800.00,47244.10,NULL,NULL,'0');
insert into tab_trans values (5042,96679,330,'1997-10-21','VYDAJ','VYBER',9100.00,37567.70,NULL,NULL,'0');
insert into tab_trans values (5042,96680,330,'1997-11-10','VYDAJ','VYBER',6200.00,53906.60,NULL,NULL,'0');
insert into tab_trans values (5042,96681,330,'1997-12-5','VYDAJ','VYBER',4900.00,31245.00,NULL,NULL,'0');
insert into tab_trans values (5042,96682,330,'1998-1-12','VYDAJ','VYBER',5700.00,49302.80,NULL,NULL,'0');
insert into tab_trans values (5042,96683,330,'1998-2-2','VYDAJ','VYBER',9000.00,27768.10,NULL,NULL,'0');
insert into tab_trans values (5042,96684,330,'1998-3-6','VYDAJ','VYBER',6800.00,54117.90,NULL,NULL,'0');
insert into tab_trans values (5042,96685,330,'1998-4-19','VYDAJ','VYBER',9600.00,36380.20,NULL,NULL,'0');
insert into tab_trans values (5042,96686,330,'1998-5-6','VYDAJ','VYBER',5900.00,53044.90,NULL,NULL,'0');
insert into tab_trans values (5042,96687,330,'1998-6-10','VYDAJ','VYBER',8800.00,57035.00,NULL,NULL,'0');
insert into tab_trans values (5042,96695,330,'1997-6-26','VYDAJ','VYBER',27040.00,16403.00,NULL,NULL,NULL);
insert into tab_trans values (5042,96696,330,'1998-6-9','VYDAJ','VYBER',7680.00,65835.00,NULL,NULL,NULL);
insert into tab_trans values (5042,96699,330,'1998-1-6','VYDAJ','VYBER',6720.00,55002.80,NULL,NULL,NULL);
insert into tab_trans values (5042,96701,330,'1997-12-26','VYDAJ','VYBER',3200.00,39135.00,NULL,NULL,NULL);
insert into tab_trans values (5042,96709,330,'1997-11-15','VYDAJ','VYBER',3720.00,50186.60,NULL,NULL,NULL);
insert into tab_trans values (5042,96710,330,'1997-4-9','VYDAJ','VYBER',2040.00,62212.70,NULL,NULL,NULL);
insert into tab_trans values (5042,96711,330,'1997-7-2','VYDAJ','VYBER',3240.00,13350.50,NULL,NULL,NULL);
insert into tab_trans values (5042,96712,330,'1997-9-18','VYDAJ','VYBER',1080.00,52044.10,NULL,NULL,NULL);
insert into tab_trans values (5042,96713,330,'1997-7-16','VYDAJ','VYBER',1800.00,33943.50,NULL,NULL,NULL);
insert into tab_trans values (5042,96714,330,'1998-7-8','VYDAJ','VYBER',2280.00,55494.80,NULL,NULL,NULL);
insert into tab_trans values (5042,96715,330,'1998-6-22','VYDAJ','VYBER',5520.00,35215.00,NULL,NULL,NULL);
insert into tab_trans values (5042,96716,330,'1998-4-1','VYDAJ','VYBER',2400.00,33887.20,NULL,NULL,NULL);
insert into tab_trans values (5042,96733,330,'1997-4-30','VYDAJ','VYBER',14.60,35820.10,'SLUZBY',NULL,NULL);
insert into tab_trans values (5042,96734,330,'1997-5-31','VYDAJ','VYBER',14.60,40353.00,'SLUZBY',NULL,NULL);
insert into tab_trans values (5042,96735,330,'1997-6-30','VYDAJ','VYBER',14.60,16590.50,'SLUZBY',NULL,NULL);
insert into tab_trans values (5042,96736,330,'1997-7-31','VYDAJ','VYBER',14.60,22843.40,'SLUZBY',NULL,NULL);
insert into tab_trans values (5042,96737,330,'1997-8-31','VYDAJ','VYBER',14.60,30731.10,'SLUZBY',NULL,NULL);
insert into tab_trans values (5042,96738,330,'1997-9-30','VYDAJ','VYBER',14.60,38474.70,'SLUZBY',NULL,NULL);
insert into tab_trans values (5042,96739,330,'1997-10-31','VYDAJ','VYBER',14.60,37713.60,'SLUZBY',NULL,NULL);
insert into tab_trans values (5042,96740,330,'1997-11-30','VYDAJ','VYBER',14.60,36145.00,'SLUZBY',NULL,NULL);
insert into tab_trans values (5042,96741,330,'1997-12-31','VYDAJ','VYBER',14.60,39329.80,'SLUZBY',NULL,NULL);
insert into tab_trans values (5042,96742,330,'1998-1-31','VYDAJ','VYBER',14.60,36768.10,'SLUZBY',NULL,NULL);
insert into tab_trans values (5042,96743,330,'1998-2-28','VYDAJ','VYBER',14.60,38524.90,'SLUZBY',NULL,NULL);
insert into tab_trans values (5042,96744,330,'1998-3-31','VYDAJ','VYBER',14.60,36287.20,'SLUZBY',NULL,NULL);
insert into tab_trans values (5042,96745,330,'1998-4-30','VYDAJ','VYBER',14.60,36551.90,'SLUZBY',NULL,NULL);
insert into tab_trans values (5042,96746,330,'1998-5-31','VYDAJ','VYBER',14.60,39925.00,'SLUZBY',NULL,NULL);
insert into tab_trans values (5042,96747,330,'1998-6-30','VYDAJ','VYBER',14.60,35381.80,'SLUZBY',NULL,NULL);
insert into tab_trans values (5042,96753,330,'1996-12-24','VYDAJ','VYBER',4100.00,29890.00,NULL,NULL,NULL);
insert into tab_trans values (5042,96754,330,'1997-1-23','VYDAJ','VYBER',17900.00,34415.10,NULL,NULL,NULL);
insert into tab_trans values (5042,96755,330,'1997-2-22','VYDAJ','VYBER',16000.00,40938.10,NULL,NULL,NULL);
insert into tab_trans values (5042,96756,330,'1997-3-24','VYDAJ','VYBER',15300.00,48181.30,NULL,NULL,NULL);
insert into tab_trans values (5042,96757,330,'1997-4-23','VYDAJ','VYBER',18100.00,44112.70,NULL,NULL,NULL);
insert into tab_trans values (5042,96758,330,'1997-5-23','VYDAJ','VYBER',18000.00,40213.10,NULL,NULL,NULL);
insert into tab_trans values (5042,96759,330,'1997-6-22','VYDAJ','VYBER',21900.00,43443.00,NULL,NULL,NULL);
insert into tab_trans values (5042,96760,330,'1997-7-22','VYDAJ','VYBER',800.00,22743.50,NULL,NULL,NULL);
insert into tab_trans values (5042,96761,330,'1997-8-21','VYDAJ','VYBER',10200.00,30636.40,NULL,NULL,NULL);
insert into tab_trans values (5042,96762,330,'1997-9-20','VYDAJ','VYBER',8900.00,38344.10,NULL,NULL,NULL);
insert into tab_trans values (5042,96763,330,'1997-10-20','VYDAJ','VYBER',14200.00,46667.70,NULL,NULL,NULL);
insert into tab_trans values (5042,96764,330,'1997-11-19','VYDAJ','VYBER',14200.00,35986.60,NULL,NULL,NULL);
insert into tab_trans values (5042,96765,330,'1997-12-19','VYDAJ','VYBER',22500.00,42335.00,NULL,NULL,NULL);
insert into tab_trans values (5042,96766,330,'1998-1-18','VYDAJ','VYBER',12700.00,36602.80,NULL,NULL,NULL);
insert into tab_trans values (5042,96767,330,'1998-2-17','VYDAJ','VYBER',11800.00,38361.10,NULL,NULL,NULL);
insert into tab_trans values (5042,96768,330,'1998-3-19','VYDAJ','VYBER',18000.00,36117.90,NULL,NULL,NULL);
insert into tab_trans values (5042,96769,330,'1998-4-18','VYDAJ','VYBER',10300.00,45980.20,NULL,NULL,NULL);
insert into tab_trans values (5042,96770,330,'1998-5-18','VYDAJ','VYBER',13300.00,39744.90,NULL,NULL,NULL);
insert into tab_trans values (5042,96771,330,'1998-6-17','VYDAJ','VYBER',16300.00,40735.00,NULL,NULL,NULL);
insert into tab_trans values (5042,3541398,330,'1996-12-31','PRIJEM',NULL,32.10,29922.10,'UROK',NULL,NULL);
insert into tab_trans values (5042,3541399,330,'1997-1-31','PRIJEM',NULL,130.00,34545.10,'UROK',NULL,NULL);
insert into tab_trans values (5042,3541400,330,'1997-2-28','PRIJEM',NULL,150.20,41088.30,'UROK',NULL,NULL);
insert into tab_trans values (5042,3541401,330,'1997-3-31','PRIJEM',NULL,178.40,48359.70,'UROK',NULL,NULL);
insert into tab_trans values (5042,3541402,330,'1997-4-30','PRIJEM',NULL,222.00,35834.70,'UROK',NULL,NULL);
insert into tab_trans values (5042,3541403,330,'1997-5-31','PRIJEM',NULL,154.60,40367.60,'UROK',NULL,NULL);
insert into tab_trans values (5042,3541404,330,'1997-6-30','PRIJEM',NULL,202.00,16605.10,'UROK',NULL,NULL);
insert into tab_trans values (5042,3541405,330,'1997-7-31','PRIJEM',NULL,114.50,22858.00,'UROK',NULL,NULL);
insert into tab_trans values (5042,3541406,330,'1997-8-31','PRIJEM',NULL,109.30,30745.70,'UROK',NULL,NULL);
insert into tab_trans values (5042,3541407,330,'1997-9-30','PRIJEM',NULL,145.30,38489.30,'UROK',NULL,NULL);
insert into tab_trans values (5042,3541408,330,'1997-10-31','PRIJEM',NULL,160.50,37728.20,'UROK',NULL,NULL);
insert into tab_trans values (5042,3541409,330,'1997-11-30','PRIJEM',NULL,172.90,36159.60,'UROK',NULL,NULL);
insert into tab_trans values (5042,3541410,330,'1997-12-31','PRIJEM',NULL,209.50,39344.40,'UROK',NULL,NULL);
insert into tab_trans values (5042,3541411,330,'1998-1-31','PRIJEM',NULL,179.80,36782.70,'UROK',NULL,NULL);
insert into tab_trans values (5042,3541412,330,'1998-2-28','PRIJEM',NULL,178.40,38539.50,'UROK',NULL,NULL);
insert into tab_trans values (5042,3541413,330,'1998-3-31','PRIJEM',NULL,183.90,36301.80,'UROK',NULL,NULL);
insert into tab_trans values (5042,3541414,330,'1998-4-30','PRIJEM',NULL,186.30,36566.50,'UROK',NULL,NULL);
insert into tab_trans values (5042,3541415,330,'1998-5-31','PRIJEM',NULL,194.70,39939.60,'UROK',NULL,NULL);
insert into tab_trans values (5042,3541416,330,'1998-6-30','PRIJEM',NULL,181.50,35396.40,'UROK',NULL,NULL);
insert into tab_trans values (5043,99038,339,'1996-9-11','PRIJEM','VKLAD',400.00,400.00,NULL,NULL,NULL);
insert into tab_trans values (5043,99047,339,'1996-9-12','PRIJEM','PREVOD Z UCTU',46807.00,47207.00,NULL,'GH','68440270');
insert into tab_trans values (5043,99048,339,'1996-10-12','PRIJEM','PREVOD Z UCTU',46807.00,81638.60,NULL,'GH','68440270');
insert into tab_trans values (5043,99049,339,'1996-11-12','PRIJEM','PREVOD Z UCTU',46807.00,96934.80,NULL,'GH','68440270');
insert into tab_trans values (5043,99050,339,'1996-12-12','PRIJEM','PREVOD Z UCTU',70210.00,127425.30,NULL,'GH','68440270');
insert into tab_trans values (5043,99051,339,'1997-1-12','PRIJEM','PREVOD Z UCTU',46807.00,96232.20,NULL,'GH','68440270');
insert into tab_trans values (5043,99052,339,'1997-2-12','PRIJEM','PREVOD Z UCTU',46807.00,79313.00,NULL,'GH','68440270');
insert into tab_trans values (5043,99053,339,'1997-3-12','PRIJEM','PREVOD Z UCTU',46807.00,77008.10,NULL,'GH','68440270');
insert into tab_trans values (5043,99054,339,'1997-4-12','PRIJEM','PREVOD Z UCTU',46807.00,89249.90,NULL,'GH','68440270');
insert into tab_trans values (5043,99055,339,'1997-5-12','PRIJEM','PREVOD Z UCTU',46807.00,92395.80,NULL,'GH','68440270');
insert into tab_trans values (5043,99056,339,'1997-6-12','PRIJEM','PREVOD Z UCTU',70210.00,99681.60,NULL,'GH','68440270');
insert into tab_trans values (5043,99057,339,'1997-7-12','PRIJEM','PREVOD Z UCTU',46807.00,57210.30,NULL,'GH','68440270');
insert into tab_trans values (5043,99058,339,'1997-8-12','PRIJEM','PREVOD Z UCTU',46807.00,58181.50,NULL,'GH','68440270');
insert into tab_trans values (5043,99059,339,'1997-9-12','PRIJEM','PREVOD Z UCTU',46807.00,68601.60,NULL,'GH','68440270');
insert into tab_trans values (5043,99060,339,'1997-10-12','PRIJEM','PREVOD Z UCTU',46807.00,91781.00,NULL,'GH','68440270');
insert into tab_trans values (5043,99061,339,'1997-11-12','PRIJEM','PREVOD Z UCTU',46807.00,94661.10,NULL,'GH','68440270');
insert into tab_trans values (5043,99062,339,'1997-12-12','PRIJEM','PREVOD Z UCTU',70210.00,109334.60,NULL,'GH','68440270');
insert into tab_trans values (5043,99087,339,'1997-1-4','VYDAJ','VYBER',9000.00,86825.20,NULL,NULL,'0');
insert into tab_trans values (5043,99088,339,'1997-2-7','VYDAJ','VYBER',5800.00,55641.00,NULL,NULL,'0');
insert into tab_trans values (5043,99089,339,'1997-3-21','VYDAJ','VYBER',8900.00,68108.10,NULL,NULL,'0');
insert into tab_trans values (5043,99090,339,'1997-4-19','VYDAJ','VYBER',8600.00,76546.90,NULL,NULL,'0');
insert into tab_trans values (5043,99091,339,'1997-5-16','VYDAJ','VYBER',10300.00,82095.80,NULL,NULL,'0');
insert into tab_trans values (5043,99092,339,'1997-5-31','VYDAJ','VYBER',8000.00,70820.60,NULL,NULL,'0');
insert into tab_trans values (5043,99093,339,'1997-7-11','VYDAJ','VYBER',6300.00,10403.30,NULL,NULL,'0');
insert into tab_trans values (5043,99094,339,'1997-8-2','VYDAJ','VYBER',7500.00,34500.50,NULL,NULL,'0');
insert into tab_trans values (5043,99095,339,'1997-8-30','VYDAJ','VYBER',6300.00,51881.50,NULL,NULL,'0');
insert into tab_trans values (5043,99096,339,'1997-10-12','VYDAJ','VYBER',8800.00,82981.00,NULL,NULL,'0');
insert into tab_trans values (5043,99097,339,'1997-11-16','VYDAJ','VYBER',8200.00,86461.10,NULL,NULL,'0');
insert into tab_trans values (5043,99098,339,'1997-12-23','VYDAJ','VYBER',7500.00,95234.60,NULL,NULL,'0');
insert into tab_trans values (5043,99124,339,'1997-2-8','VYDAJ','PREVOD NA UCET',4087.00,32554.00,'SIPO','WX','52391654');
insert into tab_trans values (5043,99125,339,'1997-3-8','VYDAJ','PREVOD NA UCET',4087.00,75483.10,'SIPO','WX','52391654');
insert into tab_trans values (5043,99126,339,'1997-4-8','VYDAJ','PREVOD NA UCET',4087.00,64242.90,'SIPO','WX','52391654');
insert into tab_trans values (5043,99127,339,'1997-5-8','VYDAJ','PREVOD NA UCET',4087.00,72736.80,'SIPO','WX','52391654');
insert into tab_trans values (5043,99128,339,'1997-6-8','VYDAJ','PREVOD NA UCET',4087.00,44019.60,'SIPO','WX','52391654');
insert into tab_trans values (5043,99129,339,'1997-7-8','VYDAJ','PREVOD NA UCET',4087.00,21351.30,'SIPO','WX','52391654');
insert into tab_trans values (5043,99130,339,'1997-8-8','VYDAJ','PREVOD NA UCET',4087.00,11422.50,'SIPO','WX','52391654');
insert into tab_trans values (5043,99131,339,'1997-9-8','VYDAJ','PREVOD NA UCET',4087.00,21794.60,'SIPO','WX','52391654');
insert into tab_trans values (5043,99132,339,'1997-10-8','VYDAJ','PREVOD NA UCET',4087.00,44974.00,'SIPO','WX','52391654');
insert into tab_trans values (5043,99133,339,'1997-11-8','VYDAJ','PREVOD NA UCET',4087.00,47902.10,'SIPO','WX','52391654');
insert into tab_trans values (5043,99134,339,'1997-12-8','VYDAJ','PREVOD NA UCET',4087.00,39172.60,'SIPO','WX','52391654');
insert into tab_trans values (5043,99160,339,'1997-2-8','VYDAJ','PREVOD NA UCET',48.00,32506.00,NULL,'IJ','21728092');
insert into tab_trans values (5043,99161,339,'1997-3-8','VYDAJ','PREVOD NA UCET',48.00,75435.10,NULL,'IJ','21728092');
insert into tab_trans values (5043,99162,339,'1997-4-8','VYDAJ','PREVOD NA UCET',48.00,68329.90,NULL,'IJ','21728092');
insert into tab_trans values (5043,99163,339,'1997-5-8','VYDAJ','PREVOD NA UCET',48.00,72688.80,NULL,'IJ','21728092');
insert into tab_trans values (5043,99164,339,'1997-6-8','VYDAJ','PREVOD NA UCET',48.00,29471.60,NULL,'IJ','21728092');
insert into tab_trans values (5043,99165,339,'1997-7-8','VYDAJ','PREVOD NA UCET',48.00,21303.30,NULL,'IJ','21728092');
insert into tab_trans values (5043,99166,339,'1997-8-8','VYDAJ','PREVOD NA UCET',48.00,11374.50,NULL,'IJ','21728092');
insert into tab_trans values (5043,99167,339,'1997-9-8','VYDAJ','PREVOD NA UCET',48.00,25881.60,NULL,'IJ','21728092');
insert into tab_trans values (5043,99168,339,'1997-10-8','VYDAJ','PREVOD NA UCET',48.00,49061.00,NULL,'IJ','21728092');
insert into tab_trans values (5043,99169,339,'1997-11-8','VYDAJ','PREVOD NA UCET',48.00,47854.10,NULL,'IJ','21728092');
insert into tab_trans values (5043,99170,339,'1997-12-8','VYDAJ','PREVOD NA UCET',48.00,39124.60,NULL,'IJ','21728092');
insert into tab_trans values (5043,99187,339,'1997-3-11','VYBER','VYBER',15234.00,30201.10,NULL,NULL,NULL);
insert into tab_trans values (5043,99188,339,'1997-11-17','VYBER','VYBER',23458.00,63003.10,NULL,NULL,NULL);
insert into tab_trans values (5043,99189,339,'1997-9-2','VYBER','VYBER',18211.00,33829.60,NULL,NULL,NULL);
insert into tab_trans values (5043,99190,339,'1997-8-1','VYBER','VYBER',5156.00,42000.50,NULL,NULL,NULL);
insert into tab_trans values (5043,99191,339,'1997-6-5','VYBER','VYBER',22684.00,48106.60,NULL,NULL,NULL);
insert into tab_trans values (5043,99192,339,'1997-4-16','VYBER','VYBER',4103.00,85146.90,NULL,NULL,NULL);
insert into tab_trans values (5043,99193,339,'1997-10-16','VYBER','VYBER',9357.00,73624.00,NULL,NULL,NULL);
insert into tab_trans values (5043,99194,339,'1997-8-4','VYBER','VYBER',10491.00,24009.50,NULL,NULL,NULL);
insert into tab_trans values (5043,99199,339,'1997-6-17','VYDAJ','VYBER',37500.00,25281.60,NULL,NULL,NULL);
insert into tab_trans values (5043,99202,339,'1997-1-21','VYDAJ','VYBER',20100.00,71332.20,NULL,NULL,NULL);
insert into tab_trans values (5043,99205,339,'1997-12-23','VYDAJ','VYBER',6600.00,102734.60,NULL,NULL,NULL);
insert into tab_trans values (5043,99213,339,'1997-1-12','VYDAJ','VYBER',2400.00,93832.20,NULL,NULL,NULL);
insert into tab_trans values (5043,99214,339,'1997-1-17','VYDAJ','VYBER',2400.00,91432.20,NULL,NULL,NULL);
insert into tab_trans values (5043,99218,339,'1997-1-25','VYDAJ','VYBER',2400.00,68932.20,NULL,NULL,NULL);
insert into tab_trans values (5043,99229,339,'1997-7-23','VYDAJ','VYBER',10200.00,47010.30,NULL,NULL,NULL);
insert into tab_trans values (5043,99230,339,'1997-5-29','VYDAJ','VYBER',3600.00,78495.80,NULL,NULL,NULL);
insert into tab_trans values (5043,99231,339,'1997-1-31','VYDAJ','VYBER',7800.00,61471.00,NULL,NULL,NULL);
insert into tab_trans values (5043,99232,339,'1997-12-5','VYDAJ','VYBER',9000.00,54259.60,NULL,NULL,NULL);
insert into tab_trans values (5043,99250,339,'1997-1-31','VYDAJ','VYBER',30.00,61441.00,'SLUZBY',NULL,NULL);
insert into tab_trans values (5043,99251,339,'1997-2-28','VYDAJ','VYBER',30.00,79570.10,'SLUZBY',NULL,NULL);
insert into tab_trans values (5043,99252,339,'1997-3-31','VYDAJ','VYBER',30.00,68377.90,'SLUZBY',NULL,NULL);
insert into tab_trans values (5043,99253,339,'1997-4-30','VYDAJ','VYBER',30.00,76823.80,'SLUZBY',NULL,NULL);
insert into tab_trans values (5043,99254,339,'1997-5-31','VYDAJ','VYBER',30.00,70790.60,'SLUZBY',NULL,NULL);
insert into tab_trans values (5043,99255,339,'1997-6-30','VYDAJ','VYBER',30.00,25438.30,'SLUZBY',NULL,NULL);
insert into tab_trans values (5043,99256,339,'1997-7-31','VYDAJ','VYBER',30.00,47156.50,'SLUZBY',NULL,NULL);
insert into tab_trans values (5043,99257,339,'1997-8-31','VYDAJ','VYBER',30.00,52040.60,'SLUZBY',NULL,NULL);
insert into tab_trans values (5043,99258,339,'1997-9-30','VYDAJ','VYBER',30.00,68809.00,'SLUZBY',NULL,NULL);
insert into tab_trans values (5043,99259,339,'1997-10-31','VYDAJ','VYBER',30.00,73889.10,'SLUZBY',NULL,NULL);
insert into tab_trans values (5043,99260,339,'1997-11-30','VYDAJ','VYBER',30.00,63259.60,'SLUZBY',NULL,NULL);
insert into tab_trans values (5043,99273,339,'1996-10-11','VYDAJ','VYBER',12500.00,34831.60,NULL,NULL,NULL);
insert into tab_trans values (5043,99274,339,'1996-11-10','VYDAJ','VYBER',31800.00,50127.80,NULL,NULL,NULL);
insert into tab_trans values (5043,99275,339,'1996-12-10','VYDAJ','VYBER',40100.00,57215.30,NULL,NULL,NULL);
insert into tab_trans values (5043,99276,339,'1996-12-12','VYDAJ','VYBER',32000.00,95425.30,NULL,NULL,NULL);
insert into tab_trans values (5043,99277,339,'1997-1-9','VYDAJ','VYBER',37400.00,49425.20,NULL,NULL,NULL);
insert into tab_trans values (5043,99278,339,'1997-2-8','VYDAJ','VYBER',19000.00,36641.00,NULL,NULL,NULL);
insert into tab_trans values (5043,99279,339,'1997-3-10','VYDAJ','VYBER',30000.00,45435.10,NULL,NULL,NULL);
insert into tab_trans values (5043,99280,339,'1997-4-9','VYDAJ','VYBER',21800.00,42442.90,NULL,NULL,NULL);
insert into tab_trans values (5043,99281,339,'1997-5-9','VYDAJ','VYBER',27100.00,45588.80,NULL,NULL,NULL);
insert into tab_trans values (5043,99282,339,'1997-6-8','VYDAJ','VYBER',14500.00,29519.60,NULL,NULL,NULL);
insert into tab_trans values (5043,99283,339,'1997-6-12','VYDAJ','VYBER',36900.00,62781.60,NULL,NULL,NULL);
insert into tab_trans values (5043,99284,339,'1997-7-8','VYDAJ','VYBER',4600.00,16703.30,NULL,NULL,NULL);
insert into tab_trans values (5043,99285,339,'1997-8-7','VYDAJ','VYBER',8500.00,15509.50,NULL,NULL,NULL);
insert into tab_trans values (5043,99286,339,'1997-9-6','VYDAJ','VYBER',7900.00,25929.60,NULL,NULL,NULL);
insert into tab_trans values (5043,99287,339,'1997-10-6','VYDAJ','VYBER',19700.00,49109.00,NULL,NULL,NULL);
insert into tab_trans values (5043,99288,339,'1997-11-5','VYDAJ','VYBER',21900.00,51989.10,NULL,NULL,NULL);
insert into tab_trans values (5043,99289,339,'1997-12-5','VYDAJ','VYBER',11000.00,43259.60,NULL,NULL,NULL);
insert into tab_trans values (5043,3541728,339,'1996-9-30','PRIJEM',NULL,124.60,47331.60,'UROK',NULL,NULL);
insert into tab_trans values (5043,3541729,339,'1996-10-31','PRIJEM',NULL,289.30,81927.80,'UROK',NULL,NULL);
insert into tab_trans values (5043,3541730,339,'1996-11-30','PRIJEM',NULL,380.50,97315.30,'UROK',NULL,NULL);
insert into tab_trans values (5043,3541731,339,'1996-12-31','PRIJEM',NULL,399.80,95825.20,'UROK',NULL,NULL);
insert into tab_trans values (5043,3541732,339,'1997-1-31','PRIJEM',NULL,338.80,69271.00,'UROK',NULL,NULL);
insert into tab_trans values (5043,3541733,339,'1997-2-28','PRIJEM',NULL,287.10,79600.10,'UROK',NULL,NULL);
insert into tab_trans values (5043,3541734,339,'1997-3-31','PRIJEM',NULL,299.80,68407.90,'UROK',NULL,NULL);
insert into tab_trans values (5043,3541735,339,'1997-4-30','PRIJEM',NULL,306.90,76853.80,'UROK',NULL,NULL);
insert into tab_trans values (5043,3541736,339,'1997-5-31','PRIJEM',NULL,324.70,78820.60,'UROK',NULL,NULL);
insert into tab_trans values (5043,3541737,339,'1997-6-30','PRIJEM',NULL,186.70,25468.30,'UROK',NULL,NULL);
insert into tab_trans values (5043,3541738,339,'1997-7-31','PRIJEM',NULL,176.20,47186.50,'UROK',NULL,NULL);
insert into tab_trans values (5043,3541739,339,'1997-8-31','PRIJEM',NULL,189.10,52070.60,'UROK',NULL,NULL);
insert into tab_trans values (5043,3541740,339,'1997-9-30','PRIJEM',NULL,237.40,68839.00,'UROK',NULL,NULL);
insert into tab_trans values (5043,3541741,339,'1997-10-31','PRIJEM',NULL,295.10,73919.10,'UROK',NULL,NULL);
insert into tab_trans values (5043,3541742,339,'1997-11-30','PRIJEM',NULL,286.50,63289.60,'UROK',NULL,NULL);
insert into tab_trans values (5044,100489,344,'1993-12-1','PRIJEM','VKLAD',600.00,600.00,NULL,NULL,NULL);
insert into tab_trans values (5044,100501,344,'1993-12-6','PRIJEM','VKLAD',20922.00,21522.00,NULL,NULL,NULL);
insert into tab_trans values (5044,100502,344,'1994-1-6','PRIJEM','VKLAD',13948.00,38745.70,NULL,NULL,NULL);
insert into tab_trans values (5044,100503,344,'1994-2-6','PRIJEM','VKLAD',13948.00,44998.60,NULL,NULL,NULL);
insert into tab_trans values (5044,100504,344,'1994-3-6','PRIJEM','VKLAD',13948.00,50875.60,NULL,NULL,NULL);
insert into tab_trans values (5044,100505,344,'1994-4-6','PRIJEM','VKLAD',13948.00,50920.30,NULL,NULL,NULL);
insert into tab_trans values (5044,100506,344,'1994-5-6','PRIJEM','VKLAD',13948.00,44993.10,NULL,NULL,NULL);
insert into tab_trans values (5044,100507,344,'1994-6-6','PRIJEM','VKLAD',20922.00,51215.80,NULL,NULL,NULL);
insert into tab_trans values (5044,100508,344,'1994-7-6','PRIJEM','VKLAD',13948.00,36032.40,NULL,NULL,NULL);
insert into tab_trans values (5044,100509,344,'1994-8-6','PRIJEM','VKLAD',13948.00,37742.60,NULL,NULL,NULL);
insert into tab_trans values (5044,100510,344,'1994-9-6','PRIJEM','VKLAD',13948.00,44460.80,NULL,NULL,NULL);
insert into tab_trans values (5044,100511,344,'1994-10-6','PRIJEM','VKLAD',13948.00,45001.00,NULL,NULL,NULL);
insert into tab_trans values (5044,100512,344,'1994-11-6','PRIJEM','VKLAD',13948.00,46546.80,NULL,NULL,NULL);
insert into tab_trans values (5044,100513,344,'1994-12-6','PRIJEM','VKLAD',20922.00,53376.70,NULL,NULL,NULL);
insert into tab_trans values (5044,100577,344,'1994-4-10','VYDAJ','PREVOD NA UCET',4739.00,44581.30,'SIPO','WX','47483712');
insert into tab_trans values (5044,100578,344,'1994-5-10','VYDAJ','PREVOD NA UCET',4739.00,37054.10,'SIPO','WX','47483712');
insert into tab_trans values (5044,100579,344,'1994-6-10','VYDAJ','PREVOD NA UCET',4739.00,46476.80,'SIPO','WX','47483712');
insert into tab_trans values (5044,100580,344,'1994-7-10','VYDAJ','PREVOD NA UCET',4739.00,31293.40,'SIPO','WX','47483712');
insert into tab_trans values (5044,100581,344,'1994-8-10','VYDAJ','PREVOD NA UCET',4739.00,33003.60,'SIPO','WX','47483712');
insert into tab_trans values (5044,100582,344,'1994-9-10','VYDAJ','PREVOD NA UCET',4739.00,38521.80,'SIPO','WX','47483712');
insert into tab_trans values (5044,100583,344,'1994-10-10','VYDAJ','PREVOD NA UCET',4739.00,40262.00,'SIPO','WX','47483712');
insert into tab_trans values (5044,100584,344,'1994-11-10','VYDAJ','PREVOD NA UCET',4739.00,41807.80,'SIPO','WX','47483712');
insert into tab_trans values (5044,100585,344,'1994-12-10','VYDAJ','PREVOD NA UCET',4739.00,48637.70,'SIPO','WX','47483712');
insert into tab_trans values (5044,100649,344,'1994-4-8','VYDAJ','VYBER',1600.00,49320.30,NULL,NULL,'0');
insert into tab_trans values (5044,100650,344,'1994-5-6','VYDAJ','VYBER',2300.00,41793.10,NULL,NULL,'0');
insert into tab_trans values (5044,100651,344,'1994-6-14','VYDAJ','VYBER',1500.00,44976.80,NULL,NULL,'0');
insert into tab_trans values (5044,100652,344,'1994-7-25','VYDAJ','VYBER',1500.00,29793.40,NULL,NULL,'0');
insert into tab_trans values (5044,100653,344,'1994-7-31','VYDAJ','VYBER',1800.00,23809.20,NULL,NULL,'0');
insert into tab_trans values (5044,100654,344,'1994-9-9','VYDAJ','VYBER',1200.00,43260.80,NULL,NULL,'0');
insert into tab_trans values (5044,100655,344,'1994-10-25','VYDAJ','VYBER',1700.00,38562.00,NULL,NULL,'0');
insert into tab_trans values (5044,100656,344,'1994-11-5','VYDAJ','VYBER',900.00,32598.80,NULL,NULL,'0');
insert into tab_trans values (5044,100657,344,'1994-12-10','VYDAJ','VYBER',1500.00,47137.70,NULL,NULL,'0');
insert into tab_trans values (5044,100707,344,'1994-6-16','VYDAJ','VYBER',22900.00,22076.80,NULL,NULL,NULL);
insert into tab_trans values (5044,100731,344,'1994-5-4','VYDAJ','VYBER',4900.00,31045.10,NULL,NULL,NULL);
insert into tab_trans values (5044,100732,344,'1994-11-21','VYDAJ','VYBER',4100.00,37707.80,NULL,NULL,NULL);
insert into tab_trans values (5044,100733,344,'1994-8-22','VYDAJ','VYBER',1400.00,31603.60,NULL,NULL,NULL);
insert into tab_trans values (5044,100735,344,'1994-5-6','VYDAJ','VYBER',900.00,44093.10,NULL,NULL,NULL);
insert into tab_trans values (5044,100736,344,'1994-9-11','VYDAJ','VYBER',1000.00,37521.80,NULL,NULL,NULL);
insert into tab_trans values (5044,100779,344,'1994-4-30','VYDAJ','VYBER',14.60,35945.10,'SLUZBY',NULL,NULL);
insert into tab_trans values (5044,100780,344,'1994-5-31','VYDAJ','VYBER',14.60,30293.80,'SLUZBY',NULL,NULL);
insert into tab_trans values (5044,100781,344,'1994-6-30','VYDAJ','VYBER',14.60,22084.40,'SLUZBY',NULL,NULL);
insert into tab_trans values (5044,100782,344,'1994-7-31','VYDAJ','VYBER',14.60,23794.60,'SLUZBY',NULL,NULL);
insert into tab_trans values (5044,100783,344,'1994-8-31','VYDAJ','VYBER',14.60,30512.80,'SLUZBY',NULL,NULL);
insert into tab_trans values (5044,100784,344,'1994-9-30','VYDAJ','VYBER',14.60,31053.00,'SLUZBY',NULL,NULL);
insert into tab_trans values (5044,100785,344,'1994-10-31','VYDAJ','VYBER',14.60,33498.80,'SLUZBY',NULL,NULL);
insert into tab_trans values (5044,100786,344,'1994-11-30','VYDAJ','VYBER',14.60,32454.70,'SLUZBY',NULL,NULL);
insert into tab_trans values (5044,100835,344,'1993-12-31','PRIJEM','VKLAD',3200.00,24797.70,NULL,NULL,NULL);
insert into tab_trans values (5044,100836,344,'1994-1-30','VYDAJ','VYBER',7800.00,30945.70,NULL,NULL,NULL);
insert into tab_trans values (5044,100837,344,'1994-3-1','VYDAJ','VYBER',8200.00,36927.60,NULL,NULL,NULL);
insert into tab_trans values (5044,100838,344,'1994-3-31','VYDAJ','VYBER',14100.00,36972.30,NULL,NULL,NULL);
insert into tab_trans values (5044,100839,344,'1994-4-30','VYDAJ','VYBER',8800.00,35959.70,NULL,NULL,NULL);
insert into tab_trans values (5044,100840,344,'1994-5-30','VYDAJ','VYBER',6900.00,30154.10,NULL,NULL,NULL);
insert into tab_trans values (5044,100841,344,'1994-6-29','VYDAJ','VYBER',100.00,21976.80,NULL,NULL,NULL);
insert into tab_trans values (5044,100842,344,'1994-7-29','VYDAJ','VYBER',4300.00,25493.40,NULL,NULL,NULL);
insert into tab_trans values (5044,100843,344,'1994-8-28','VYDAJ','VYBER',1200.00,30403.60,NULL,NULL,NULL);
insert into tab_trans values (5044,100844,344,'1994-9-27','VYDAJ','VYBER',6600.00,30921.80,NULL,NULL,NULL);
insert into tab_trans values (5044,100845,344,'1994-10-27','VYDAJ','VYBER',5200.00,33362.00,NULL,NULL,NULL);
insert into tab_trans values (5044,100846,344,'1994-11-26','VYDAJ','VYBER',5400.00,32307.80,NULL,NULL,NULL);
insert into tab_trans values (5044,3541896,344,'1993-12-31','PRIJEM',NULL,75.70,21597.70,'UROK',NULL,NULL);
insert into tab_trans values (5044,3541897,344,'1994-1-31','PRIJEM',NULL,105.00,31050.60,'UROK',NULL,NULL);
insert into tab_trans values (5044,3541898,344,'1994-2-28','PRIJEM',NULL,128.90,45127.60,'UROK',NULL,NULL);
insert into tab_trans values (5044,3541899,344,'1994-3-31','PRIJEM',NULL,196.70,51072.30,'UROK',NULL,NULL);
insert into tab_trans values (5044,3541900,344,'1994-4-30','PRIJEM',NULL,178.50,44759.70,'UROK',NULL,NULL);
insert into tab_trans values (5044,3541901,344,'1994-5-31','PRIJEM',NULL,154.30,30308.40,'UROK',NULL,NULL);
insert into tab_trans values (5044,3541902,344,'1994-6-30','PRIJEM',NULL,122.10,22099.00,'UROK',NULL,NULL);
insert into tab_trans values (5044,3541903,344,'1994-7-31','PRIJEM',NULL,115.80,25609.20,'UROK',NULL,NULL);
insert into tab_trans values (5044,3541904,344,'1994-8-31','PRIJEM',NULL,123.80,30527.40,'UROK',NULL,NULL);
insert into tab_trans values (5044,3541905,344,'1994-9-30','PRIJEM',NULL,145.80,31067.60,'UROK',NULL,NULL);
insert into tab_trans values (5044,3541906,344,'1994-10-31','PRIJEM',NULL,151.50,33513.40,'UROK',NULL,NULL);
insert into tab_trans values (5044,3541907,344,'1994-11-30','PRIJEM',NULL,161.50,32469.30,'UROK',NULL,NULL);
insert into tab_trans values (5045,101827,347,'1993-12-13','PRIJEM','VKLAD',200.00,200.00,NULL,NULL,NULL);
insert into tab_trans values (5045,101842,347,'1993-12-27','PRIJEM','VKLAD',24776.00,24976.00,NULL,NULL,NULL);
insert into tab_trans values (5045,101854,347,'1994-9-24','PRIJEM','VKLAD',32689.00,60266.60,NULL,NULL,NULL);
insert into tab_trans values (5045,101855,347,'1994-5-29','PRIJEM','VKLAD',30828.00,92262.80,NULL,NULL,NULL);
insert into tab_trans values (5045,101856,347,'1994-4-30','PRIJEM','VKLAD',5426.00,75138.80,NULL,NULL,NULL);
insert into tab_trans values (5045,101857,347,'1994-7-15','PRIJEM','VKLAD',36500.00,55088.70,NULL,NULL,NULL);
insert into tab_trans values (5045,101858,347,'1994-5-14','PRIJEM','VKLAD',20811.00,70849.80,NULL,NULL,NULL);
insert into tab_trans values (5045,101859,347,'1994-10-11','PRIJEM','VKLAD',34009.00,65960.30,NULL,NULL,NULL);
insert into tab_trans values (5045,101860,347,'1994-8-5','PRIJEM','VKLAD',34803.00,90056.00,NULL,NULL,NULL);
insert into tab_trans values (5045,101861,347,'1994-6-28','PRIJEM','VKLAD',37607.00,37363.70,NULL,NULL,NULL);
insert into tab_trans values (5045,101862,347,'1994-11-24','PRIJEM','VKLAD',46293.00,72482.30,NULL,NULL,NULL);
insert into tab_trans values (5045,101863,347,'1994-4-11','PRIJEM','VKLAD',42958.00,68963.00,NULL,NULL,NULL);
insert into tab_trans values (5045,101864,347,'1994-4-28','PRIJEM','VKLAD',21876.00,69539.00,NULL,NULL,NULL);
insert into tab_trans values (5045,101865,347,'1995-2-25','PRIJEM','VKLAD',10415.00,38815.10,NULL,NULL,NULL);
insert into tab_trans values (5045,101867,347,'1995-1-21','PRIJEM','VKLAD',39721.00,67324.50,NULL,NULL,NULL);
insert into tab_trans values (5045,101868,347,'1995-1-15','PRIJEM','VKLAD',17806.00,27603.50,NULL,NULL,NULL);
insert into tab_trans values (5045,101873,347,'1995-4-23','PRIJEM','VKLAD',43463.00,50770.80,NULL,NULL,NULL);
insert into tab_trans values (5045,101929,347,'1994-6-9','VYDAJ','VYBER',7800.00,84756.70,NULL,NULL,'0');
insert into tab_trans values (5045,101930,347,'1994-7-7','VYDAJ','VYBER',5500.00,32100.70,NULL,NULL,'0');
insert into tab_trans values (5045,101931,347,'1994-8-26','VYDAJ','VYBER',6300.00,42579.00,NULL,NULL,'0');
insert into tab_trans values (5045,101932,347,'1994-9-10','VYDAJ','VYBER',9900.00,27577.60,NULL,NULL,'0');
insert into tab_trans values (5045,101933,347,'1994-10-12','VYDAJ','VYBER',7600.00,58360.30,NULL,NULL,'0');
insert into tab_trans values (5045,101934,347,'1994-11-18','VYDAJ','VYBER',7500.00,26189.30,NULL,NULL,'0');
insert into tab_trans values (5045,101935,347,'1994-12-8','VYDAJ','VYBER',8400.00,35790.00,NULL,NULL,'0');
insert into tab_trans values (5045,101936,347,'1995-1-10','VYDAJ','VYBER',9700.00,9797.50,NULL,NULL,'0');
insert into tab_trans values (5045,101937,347,'1995-2-13','VYDAJ','VYBER',8700.00,34755.10,NULL,NULL,'0');
insert into tab_trans values (5045,101938,347,'1995-3-6','VYDAJ','VYBER',7800.00,31202.80,NULL,NULL,'0');
insert into tab_trans values (5045,101939,347,'1995-4-9','VYDAJ','VYBER',8200.00,7307.80,NULL,NULL,'0');
insert into tab_trans values (5045,101987,347,'1994-10-10','VYBER','VYBER',3250.00,31951.30,NULL,NULL,NULL);
insert into tab_trans values (5045,101989,347,'1994-8-17','VYBER','VYBER',7377.00,48879.00,NULL,NULL,NULL);
insert into tab_trans values (5045,101990,347,'1994-10-25','VYBER','VYBER',9314.00,49046.30,NULL,NULL,NULL);
insert into tab_trans values (5045,101991,347,'1994-10-28','VYBER','VYBER',3255.00,45791.30,NULL,NULL,NULL);
insert into tab_trans values (5045,101994,347,'1994-7-8','VYBER','VYBER',6812.00,21988.70,NULL,NULL,NULL);
insert into tab_trans values (5045,101995,347,'1994-5-27','VYBER','VYBER',9415.00,61434.80,NULL,NULL,NULL);
insert into tab_trans values (5045,101996,347,'1994-9-30','VYBER','VYBER',16414.00,44015.90,NULL,NULL,NULL);
insert into tab_trans values (5045,101997,347,'1994-11-29','VYBER','VYBER',11975.00,60507.30,NULL,NULL,NULL);
insert into tab_trans values (5045,101999,347,'1995-2-22','VYBER','VYBER',6355.00,28400.10,NULL,NULL,NULL);
insert into tab_trans values (5045,102007,347,'1995-3-25','VYBER','VYBER',15669.00,5133.80,NULL,NULL,NULL);
insert into tab_trans values (5045,102039,347,'1994-6-26','VYDAJ','VYBER',51900.00,-243.30,NULL,NULL,NULL);
insert into tab_trans values (5045,102051,347,'1994-12-27','VYDAJ','VYBER',6900.00,14190.00,NULL,NULL,NULL);
insert into tab_trans values (5045,102061,347,'1994-12-9','VYDAJ','VYBER',14700.00,21090.00,NULL,NULL,NULL);
insert into tab_trans values (5045,102062,347,'1994-7-7','VYDAJ','VYBER',3300.00,28800.70,NULL,NULL,NULL);
insert into tab_trans values (5045,102110,347,'1994-5-31','VYDAJ','VYBER',14.60,92556.70,'SLUZBY',NULL,NULL);
insert into tab_trans values (5045,102111,347,'1994-6-30','VYDAJ','VYBER',14.60,37600.70,'SLUZBY',NULL,NULL);
insert into tab_trans values (5045,102112,347,'1994-7-31','VYDAJ','VYBER',14.60,55253.00,'SLUZBY',NULL,NULL);
insert into tab_trans values (5045,102113,347,'1994-8-31','VYDAJ','VYBER',14.60,42777.60,'SLUZBY',NULL,NULL);
insert into tab_trans values (5045,102114,347,'1994-9-30','VYDAJ','VYBER',14.60,44001.30,'SLUZBY',NULL,NULL);
insert into tab_trans values (5045,102115,347,'1994-10-31','VYDAJ','VYBER',14.60,45989.30,'SLUZBY',NULL,NULL);
insert into tab_trans values (5045,102116,347,'1994-11-30','VYDAJ','VYBER',14.60,60690.00,'SLUZBY',NULL,NULL);
insert into tab_trans values (5045,102117,347,'1994-12-31','VYDAJ','VYBER',14.60,14297.50,'SLUZBY',NULL,NULL);
insert into tab_trans values (5045,102118,347,'1995-1-31','VYDAJ','VYBER',14.60,67455.10,'SLUZBY',NULL,NULL);
insert into tab_trans values (5045,102119,347,'1995-2-28','VYDAJ','VYBER',14.60,39002.80,'SLUZBY',NULL,NULL);
insert into tab_trans values (5045,102120,347,'1995-3-31','VYDAJ','VYBER',14.60,5207.80,'SLUZBY',NULL,NULL);
insert into tab_trans values (5045,102121,347,'1995-4-30','VYDAJ','VYBER',14.60,50832.10,'SLUZBY',NULL,NULL);
insert into tab_trans values (5045,102165,347,'1994-1-12','PRIJEM','VKLAD',1000.00,25992.80,NULL,NULL,NULL);
insert into tab_trans values (5045,102166,347,'1994-2-11','VYDAJ','VYBER',3100.00,22996.80,NULL,NULL,NULL);
insert into tab_trans values (5045,102167,347,'1994-3-13','PRIJEM','VKLAD',2800.00,25900.90,NULL,NULL,NULL);
insert into tab_trans values (5045,102168,347,'1994-4-12','VYDAJ','VYBER',21300.00,47663.00,NULL,NULL,NULL);
insert into tab_trans values (5045,102169,347,'1994-5-12','VYDAJ','VYBER',25100.00,50038.80,NULL,NULL,NULL);
insert into tab_trans values (5045,102170,347,'1994-6-11','VYDAJ','VYBER',33100.00,51656.70,NULL,NULL,NULL);
insert into tab_trans values (5045,102171,347,'1994-7-11','VYDAJ','VYBER',3400.00,18588.70,NULL,NULL,NULL);
insert into tab_trans values (5045,102172,347,'1994-8-10','VYDAJ','VYBER',33800.00,56256.00,NULL,NULL,NULL);
insert into tab_trans values (5045,102173,347,'1994-9-9','VYDAJ','VYBER',5300.00,37477.60,NULL,NULL,NULL);
insert into tab_trans values (5045,102174,347,'1994-10-9','VYDAJ','VYBER',8800.00,35201.30,NULL,NULL,NULL);
insert into tab_trans values (5045,102175,347,'1994-11-8','VYDAJ','VYBER',12300.00,33689.30,NULL,NULL,NULL);
insert into tab_trans values (5045,102176,347,'1994-12-8','VYDAJ','VYBER',16500.00,44190.00,NULL,NULL,NULL);
insert into tab_trans values (5045,102177,347,'1995-1-7','PRIJEM','VKLAD',5200.00,19497.50,NULL,NULL,NULL);
insert into tab_trans values (5045,102178,347,'1995-2-6','VYDAJ','VYBER',24000.00,43455.10,NULL,NULL,NULL);
insert into tab_trans values (5045,102179,347,'1995-3-8','VYDAJ','VYBER',10400.00,20802.80,NULL,NULL,NULL);
insert into tab_trans values (5045,102180,347,'1995-4-7','PRIJEM','VKLAD',10300.00,15507.80,NULL,NULL,NULL);
insert into tab_trans values (5045,3445356,347,'1993-12-31','PRIJEM',NULL,16.80,24992.80,'UROK',NULL,NULL);
insert into tab_trans values (5045,3445357,347,'1994-1-31','PRIJEM',NULL,104.10,26096.80,'UROK',NULL,NULL);
insert into tab_trans values (5045,3445358,347,'1994-2-28','PRIJEM',NULL,104.10,23100.90,'UROK',NULL,NULL);
insert into tab_trans values (5045,3445359,347,'1994-3-31','PRIJEM',NULL,104.10,26005.00,'UROK',NULL,NULL);
insert into tab_trans values (5045,3445360,347,'1994-4-30','PRIJEM',NULL,173.80,69712.80,'UROK',NULL,NULL);
insert into tab_trans values (5045,3445361,347,'1994-5-31','PRIJEM',NULL,308.50,92571.30,'UROK',NULL,NULL);
insert into tab_trans values (5045,3445362,347,'1994-6-30','PRIJEM',NULL,251.80,37615.40,'UROK',NULL,NULL);
insert into tab_trans values (5045,3445363,347,'1994-6-30','VYDAJ','VYBER',0.20,37615.30,'SANKC. UROK',NULL,NULL);
insert into tab_trans values (5045,3445364,347,'1994-7-31','PRIJEM',NULL,178.90,55267.60,'UROK',NULL,NULL);
insert into tab_trans values (5045,3445365,347,'1994-8-31','PRIJEM',NULL,213.20,42792.20,'UROK',NULL,NULL);
insert into tab_trans values (5045,3445366,347,'1994-9-30','PRIJEM',NULL,163.30,60429.90,'UROK',NULL,NULL);
insert into tab_trans values (5045,3445367,347,'1994-10-31','PRIJEM',NULL,212.60,46003.90,'UROK',NULL,NULL);
insert into tab_trans values (5045,3445368,347,'1994-11-30','PRIJEM',NULL,197.30,60704.60,'UROK',NULL,NULL);
insert into tab_trans values (5045,3445369,347,'1994-12-31','PRIJEM',NULL,122.10,14312.10,'UROK',NULL,NULL);
insert into tab_trans values (5045,3445370,347,'1995-1-31','PRIJEM',NULL,145.30,67469.70,'UROK',NULL,NULL);
insert into tab_trans values (5045,3445371,347,'1995-2-28','PRIJEM',NULL,202.30,39017.40,'UROK',NULL,NULL);
insert into tab_trans values (5045,3445372,347,'1995-3-31','PRIJEM',NULL,88.50,5222.40,'UROK',NULL,NULL);
insert into tab_trans values (5045,3445373,347,'1995-4-30','PRIJEM',NULL,75.90,50846.70,'UROK',NULL,NULL);
insert into tab_trans values (5046,102528,349,'1997-6-8','PRIJEM','VKLAD',1100.00,1100.00,NULL,NULL,NULL);
insert into tab_trans values (5046,102534,349,'1997-6-10','PRIJEM','VKLAD',10486.00,11586.00,NULL,NULL,NULL);
insert into tab_trans values (5046,102535,349,'1997-7-10','PRIJEM','VKLAD',6991.00,25810.80,NULL,NULL,NULL);
insert into tab_trans values (5046,102536,349,'1997-8-10','PRIJEM','VKLAD',6991.00,31492.10,NULL,NULL,NULL);
insert into tab_trans values (5046,102537,349,'1997-9-10','PRIJEM','VKLAD',6991.00,30207.50,NULL,NULL,NULL);
insert into tab_trans values (5046,102538,349,'1997-10-10','PRIJEM','VKLAD',6991.00,26325.90,NULL,NULL,NULL);
insert into tab_trans values (5046,102539,349,'1997-11-10','PRIJEM','VKLAD',6991.00,20768.90,NULL,NULL,NULL);
insert into tab_trans values (5046,102540,349,'1997-12-10','PRIJEM','VKLAD',10486.00,20943.00,NULL,NULL,NULL);
insert into tab_trans values (5046,102541,349,'1998-1-10','PRIJEM','VKLAD',6991.00,19961.20,NULL,NULL,NULL);
insert into tab_trans values (5046,102542,349,'1998-2-10','PRIJEM','VKLAD',6991.00,18248.10,NULL,NULL,NULL);
insert into tab_trans values (5046,102543,349,'1998-3-10','PRIJEM','VKLAD',6991.00,17528.90,NULL,NULL,NULL);
insert into tab_trans values (5046,102544,349,'1998-4-10','PRIJEM','VKLAD',6991.00,12704.90,NULL,NULL,NULL);
insert into tab_trans values (5046,102545,349,'1998-5-10','PRIJEM','VKLAD',6991.00,16172.50,NULL,NULL,NULL);
insert into tab_trans values (5046,102546,349,'1998-6-10','PRIJEM','VKLAD',10486.00,20941.40,NULL,NULL,NULL);
insert into tab_trans values (5046,102547,349,'1998-7-10','PRIJEM','VKLAD',6991.00,22053.90,NULL,NULL,NULL);
insert into tab_trans values (5046,102548,349,'1998-8-10','PRIJEM','VKLAD',6991.00,18342.50,NULL,NULL,NULL);
insert into tab_trans values (5046,102563,349,'1997-11-9','VYDAJ','PREVOD NA UCET',4660.00,13777.90,'SIPO','ST','83005469');
insert into tab_trans values (5046,102564,349,'1997-12-9','VYDAJ','PREVOD NA UCET',4660.00,10457.00,'SIPO','ST','83005469');
insert into tab_trans values (5046,102565,349,'1998-1-9','VYDAJ','PREVOD NA UCET',4660.00,12970.20,'SIPO','ST','83005469');
insert into tab_trans values (5046,102566,349,'1998-2-9','VYDAJ','PREVOD NA UCET',4660.00,11257.10,'SIPO','ST','83005469');
insert into tab_trans values (5046,102567,349,'1998-3-9','VYDAJ','PREVOD NA UCET',4660.00,10537.90,'SIPO','ST','83005469');
insert into tab_trans values (5046,102568,349,'1998-4-9','VYDAJ','PREVOD NA UCET',4660.00,5713.90,'SIPO','ST','83005469');
insert into tab_trans values (5046,102569,349,'1998-5-9','VYDAJ','PREVOD NA UCET',4660.00,9181.50,'SIPO','ST','83005469');
insert into tab_trans values (5046,102570,349,'1998-6-9','VYDAJ','PREVOD NA UCET',4660.00,10455.40,'SIPO','ST','83005469');
insert into tab_trans values (5046,102571,349,'1998-7-9','VYDAJ','PREVOD NA UCET',4660.00,15062.90,'SIPO','ST','83005469');
insert into tab_trans values (5046,102572,349,'1998-8-9','VYDAJ','PREVOD NA UCET',4660.00,11351.50,'SIPO','ST','83005469');
insert into tab_trans values (5046,102586,349,'1997-10-9','VYDAJ','VYBER',3000.00,19334.90,NULL,NULL,'0');
insert into tab_trans values (5046,102587,349,'1997-11-23','VYDAJ','VYBER',2700.00,18068.90,NULL,NULL,'0');
insert into tab_trans values (5046,102588,349,'1997-12-7','VYDAJ','VYBER',3000.00,15117.00,NULL,NULL,'0');
insert into tab_trans values (5046,102589,349,'1998-1-14','VYDAJ','VYBER',2300.00,15861.20,NULL,NULL,'0');
insert into tab_trans values (5046,102590,349,'1998-2-15','VYDAJ','VYBER',4000.00,14248.10,NULL,NULL,'0');
insert into tab_trans values (5046,102591,349,'1998-3-16','VYDAJ','VYBER',4100.00,13428.90,NULL,NULL,'0');
insert into tab_trans values (5046,102592,349,'1998-4-6','VYDAJ','VYBER',3800.00,10373.90,NULL,NULL,'0');
insert into tab_trans values (5046,102593,349,'1998-5-18','VYDAJ','VYBER',2600.00,13572.50,NULL,NULL,'0');
insert into tab_trans values (5046,102594,349,'1998-6-14','VYDAJ','VYBER',3600.00,12781.40,NULL,NULL,'0');
insert into tab_trans values (5046,102595,349,'1998-7-13','VYDAJ','VYBER',3300.00,18753.90,NULL,NULL,'0');
insert into tab_trans values (5046,102596,349,'1998-8-4','VYDAJ','VYBER',4400.00,16011.50,NULL,NULL,'0');
insert into tab_trans values (5046,102605,349,'1997-12-5','VYDAJ','VYBER',2560.00,18117.00,NULL,NULL,NULL);
insert into tab_trans values (5046,102613,349,'1998-1-1','VYDAJ','VYBER',2880.00,18130.20,NULL,NULL,NULL);
insert into tab_trans values (5046,102615,349,'1998-1-10','VYDAJ','VYBER',1800.00,18161.20,NULL,NULL,NULL);
insert into tab_trans values (5046,102618,349,'1998-1-3','VYDAJ','VYBER',1800.00,16330.20,NULL,NULL,NULL);
insert into tab_trans values (5046,102622,349,'1997-10-23','VYDAJ','VYBER',5280.00,21045.90,NULL,NULL,NULL);
insert into tab_trans values (5046,102623,349,'1997-11-30','VYDAJ','VYBER',1560.00,16577.00,NULL,NULL,NULL);
insert into tab_trans values (5046,102626,349,'1998-8-17','VYDAJ','VYBER',2400.00,15942.50,NULL,NULL,NULL);
insert into tab_trans values (5046,102628,349,'1998-6-11','VYDAJ','VYBER',4560.00,16381.40,NULL,NULL,NULL);
insert into tab_trans values (5046,102639,349,'1997-10-31','VYDAJ','VYBER',14.60,21137.90,'SLUZBY',NULL,NULL);
insert into tab_trans values (5046,102640,349,'1997-11-30','VYDAJ','VYBER',14.60,18137.00,'SLUZBY',NULL,NULL);
insert into tab_trans values (5046,102641,349,'1997-12-31','VYDAJ','VYBER',14.60,21010.20,'SLUZBY',NULL,NULL);
insert into tab_trans values (5046,102642,349,'1998-1-31','VYDAJ','VYBER',14.60,15917.10,'SLUZBY',NULL,NULL);
insert into tab_trans values (5046,102643,349,'1998-2-28','VYDAJ','VYBER',14.60,14297.90,'SLUZBY',NULL,NULL);
insert into tab_trans values (5046,102644,349,'1998-3-31','VYDAJ','VYBER',14.60,13473.90,'SLUZBY',NULL,NULL);
insert into tab_trans values (5046,102645,349,'1998-4-30','VYDAJ','VYBER',14.60,12741.50,'SLUZBY',NULL,NULL);
insert into tab_trans values (5046,102646,349,'1998-5-31','VYDAJ','VYBER',14.60,13615.40,'SLUZBY',NULL,NULL);
insert into tab_trans values (5046,102647,349,'1998-6-30','VYDAJ','VYBER',14.60,12822.90,'SLUZBY',NULL,NULL);
insert into tab_trans values (5046,102648,349,'1998-7-31','VYDAJ','VYBER',14.60,18811.50,'SLUZBY',NULL,NULL);
insert into tab_trans values (5046,102649,349,'1998-8-31','VYDAJ','VYBER',14.60,15996.60,'SLUZBY',NULL,NULL);
insert into tab_trans values (5046,102653,349,'1997-7-8','PRIJEM','VKLAD',7200.00,18819.80,NULL,NULL,NULL);
insert into tab_trans values (5046,102654,349,'1997-8-7','VYDAJ','VYBER',1400.00,24501.10,NULL,NULL,NULL);
insert into tab_trans values (5046,102655,349,'1997-9-6','VYDAJ','VYBER',8400.00,23216.50,NULL,NULL,NULL);
insert into tab_trans values (5046,102656,349,'1997-10-6','VYDAJ','VYBER',8000.00,22334.90,NULL,NULL,NULL);
insert into tab_trans values (5046,102657,349,'1997-11-5','VYDAJ','VYBER',2700.00,18437.90,NULL,NULL,NULL);
insert into tab_trans values (5046,102658,349,'1997-12-5','PRIJEM','VKLAD',4100.00,20677.00,NULL,NULL,NULL);
insert into tab_trans values (5046,102659,349,'1998-1-4','PRIJEM','VKLAD',1300.00,17630.20,NULL,NULL,NULL);
insert into tab_trans values (5046,102660,349,'1998-3-5','PRIJEM','VKLAD',900.00,15197.90,NULL,NULL,NULL);
insert into tab_trans values (5046,102661,349,'1998-4-4','PRIJEM','VKLAD',700.00,14173.90,NULL,NULL,NULL);
insert into tab_trans values (5046,102662,349,'1998-5-4','PRIJEM','VKLAD',1100.00,13841.50,NULL,NULL,NULL);
insert into tab_trans values (5046,102663,349,'1998-6-3','PRIJEM','VKLAD',1500.00,15115.40,NULL,NULL,NULL);
insert into tab_trans values (5046,102664,349,'1998-7-3','PRIJEM','VKLAD',6900.00,19722.90,NULL,NULL,NULL);
insert into tab_trans values (5046,102665,349,'1998-8-2','PRIJEM','VKLAD',1600.00,20411.50,NULL,NULL,NULL);
insert into tab_trans values (5046,102666,349,'1998-9-1','PRIJEM','VKLAD',2700.00,18696.60,NULL,NULL,NULL);
insert into tab_trans values (5046,3542089,349,'1997-6-30','PRIJEM',NULL,33.80,11619.80,'UROK',NULL,NULL);
insert into tab_trans values (5046,3542090,349,'1997-7-31','PRIJEM',NULL,90.30,25901.10,'UROK',NULL,NULL);
insert into tab_trans values (5046,3542091,349,'1997-8-31','PRIJEM',NULL,124.30,31616.50,'UROK',NULL,NULL);
insert into tab_trans values (5046,3542092,349,'1997-9-30','PRIJEM',NULL,127.50,30334.90,'UROK',NULL,NULL);
insert into tab_trans values (5046,3542093,349,'1997-10-31','PRIJEM',NULL,106.50,21152.50,'UROK',NULL,NULL);
insert into tab_trans values (5046,3542094,349,'1997-11-30','PRIJEM',NULL,82.80,18151.60,'UROK',NULL,NULL);
insert into tab_trans values (5046,3542095,349,'1997-12-31','PRIJEM',NULL,81.80,21024.80,'UROK',NULL,NULL);
insert into tab_trans values (5046,3542096,349,'1998-1-31','PRIJEM',NULL,70.50,15931.70,'UROK',NULL,NULL);
insert into tab_trans values (5046,3542097,349,'1998-2-28','PRIJEM',NULL,64.40,14312.50,'UROK',NULL,NULL);
insert into tab_trans values (5046,3542098,349,'1998-3-31','PRIJEM',NULL,59.60,13488.50,'UROK',NULL,NULL);
insert into tab_trans values (5046,3542099,349,'1998-4-30','PRIJEM',NULL,51.20,12756.10,'UROK',NULL,NULL);
insert into tab_trans values (5046,3542100,349,'1998-5-31','PRIJEM',NULL,57.50,13630.00,'UROK',NULL,NULL);
insert into tab_trans values (5046,3542101,349,'1998-6-30','PRIJEM',NULL,56.10,12837.50,'UROK',NULL,NULL);
insert into tab_trans values (5046,3542102,349,'1998-7-31','PRIJEM',NULL,72.10,18826.10,'UROK',NULL,NULL);
insert into tab_trans values (5046,3542103,349,'1998-8-31','PRIJEM',NULL,68.70,16011.20,'UROK',NULL,NULL);
insert into tab_trans values (5051,111809,378,'1996-7-22','PRIJEM','VKLAD',900.00,21474.00,NULL,NULL,NULL);
insert into tab_trans values (5051,111810,378,'1996-10-14','PRIJEM','VKLAD',40063.00,102547.30,NULL,NULL,NULL);
insert into tab_trans values (5051,111811,378,'1996-9-30','PRIJEM','VKLAD',39536.00,75599.90,NULL,NULL,NULL);
insert into tab_trans values (5051,111812,378,'1996-12-28','PRIJEM','VKLAD',14899.00,113274.10,NULL,NULL,NULL);
insert into tab_trans values (5051,111813,378,'1996-11-13','PRIJEM','VKLAD',41594.00,110265.80,NULL,NULL,NULL);
insert into tab_trans values (5051,111816,378,'1996-8-4','PRIJEM','VKLAD',31772.00,73888.10,NULL,NULL,NULL);
insert into tab_trans values (5051,111817,378,'1996-10-27','PRIJEM','VKLAD',20179.00,102008.30,NULL,NULL,NULL);
insert into tab_trans values (5051,111818,378,'1996-12-30','PRIJEM','VKLAD',23037.00,127409.10,NULL,NULL,NULL);
insert into tab_trans values (5051,111819,378,'1996-12-29','PRIJEM','VKLAD',45998.00,104372.10,NULL,NULL,NULL);
insert into tab_trans values (5051,111822,378,'1996-11-29','PRIJEM','VKLAD',18642.00,86123.80,NULL,NULL,NULL);
insert into tab_trans values (5051,111823,378,'1996-12-19','PRIJEM','VKLAD',40589.00,145352.10,NULL,NULL,NULL);
insert into tab_trans values (5051,111824,378,'1996-8-26','PRIJEM','VKLAD',13957.00,70799.10,NULL,NULL,NULL);
insert into tab_trans values (5051,111827,378,'1996-12-26','PRIJEM','VKLAD',42223.00,98375.10,NULL,NULL,NULL);
insert into tab_trans values (5051,111828,378,'1996-8-12','PRIJEM','VKLAD',16754.00,90642.10,NULL,NULL,NULL);
insert into tab_trans values (5051,111829,378,'1996-11-5','PRIJEM','VKLAD',37371.00,136514.80,NULL,NULL,NULL);
insert into tab_trans values (5051,111830,378,'1996-10-22','PRIJEM','VKLAD',18989.00,81829.30,NULL,NULL,NULL);
insert into tab_trans values (5051,111831,378,'1996-7-27','PRIJEM','VKLAD',20600.00,42074.00,NULL,NULL,NULL);
insert into tab_trans values (5051,111832,378,'1996-12-13','PRIJEM','VKLAD',31015.00,108947.10,NULL,NULL,NULL);
insert into tab_trans values (5051,111833,378,'1996-7-22','PRIJEM','VKLAD',20574.00,20574.00,NULL,NULL,NULL);
insert into tab_trans values (5051,111834,378,'1997-7-26','PRIJEM','VKLAD',17360.00,63272.70,NULL,NULL,NULL);
insert into tab_trans values (5051,111835,378,'1997-2-8','PRIJEM','VKLAD',30688.00,132469.10,NULL,NULL,NULL);
insert into tab_trans values (5051,111836,378,'1997-1-9','PRIJEM','VKLAD',18381.00,111727.20,NULL,NULL,NULL);
insert into tab_trans values (5051,111837,378,'1997-5-19','PRIJEM','VKLAD',44741.00,100759.80,NULL,NULL,NULL);
insert into tab_trans values (5051,111838,378,'1997-2-4','PRIJEM','VKLAD',8563.00,101785.10,NULL,NULL,NULL);
insert into tab_trans values (5051,111839,378,'1997-4-25','PRIJEM','VKLAD',34712.00,88113.40,NULL,NULL,NULL);
insert into tab_trans values (5051,111842,378,'1997-6-6','PRIJEM','VKLAD',15086.00,103399.00,NULL,NULL,NULL);
insert into tab_trans values (5051,111843,378,'1997-9-9','PRIJEM','VKLAD',43007.00,95313.70,NULL,NULL,NULL);
insert into tab_trans values (5051,111844,378,'1997-8-16','PRIJEM','VKLAD',19303.00,73090.30,NULL,NULL,NULL);
insert into tab_trans values (5051,111846,378,'1997-6-17','PRIJEM','VKLAD',46089.00,102569.00,NULL,NULL,NULL);
insert into tab_trans values (5051,111847,378,'1997-3-29','PRIJEM','VKLAD',48038.00,106474.50,NULL,NULL,NULL);
insert into tab_trans values (5051,111849,378,'1997-5-11','PRIJEM','VKLAD',38091.00,123241.80,NULL,NULL,NULL);
insert into tab_trans values (5051,111852,378,'1997-2-22','PRIJEM','VKLAD',41199.00,89337.10,NULL,NULL,NULL);
insert into tab_trans values (5051,111853,378,'1997-1-15','PRIJEM','VKLAD',31607.00,72511.20,NULL,NULL,NULL);
insert into tab_trans values (5051,111854,378,'1997-2-14','PRIJEM','VKLAD',38892.00,120638.10,NULL,NULL,NULL);
insert into tab_trans values (5051,111855,378,'1997-6-8','PRIJEM','VKLAD',24485.00,90180.00,NULL,NULL,NULL);
insert into tab_trans values (5051,111857,378,'1997-1-23','PRIJEM','VKLAD',38085.00,92896.20,NULL,NULL,NULL);
insert into tab_trans values (5051,111859,378,'1997-3-2','PRIJEM','VKLAD',9657.00,95563.50,NULL,NULL,NULL);
insert into tab_trans values (5051,111860,378,'1997-6-9','PRIJEM','VKLAD',11123.00,101303.00,NULL,NULL,NULL);
insert into tab_trans values (5051,111894,378,'1996-8-30','VYDAJ','VYBER',3000.00,67799.10,NULL,NULL,'0');
insert into tab_trans values (5051,111895,378,'1996-10-13','VYDAJ','VYBER',3600.00,62484.30,NULL,NULL,'0');
insert into tab_trans values (5051,111896,378,'1996-10-30','VYDAJ','VYBER',3200.00,98808.30,NULL,NULL,'0');
insert into tab_trans values (5051,111897,378,'1996-12-18','VYDAJ','VYBER',3000.00,104763.10,NULL,NULL,'0');
insert into tab_trans values (5051,111898,378,'1997-1-11','VYDAJ','VYBER',4400.00,50627.20,NULL,NULL,'0');
insert into tab_trans values (5051,111899,378,'1997-2-26','VYDAJ','VYBER',3800.00,85537.10,NULL,NULL,'0');
insert into tab_trans values (5051,111900,378,'1997-3-23','VYDAJ','VYBER',3400.00,58436.50,NULL,NULL,'0');
insert into tab_trans values (5051,111901,378,'1997-4-2','VYDAJ','VYBER',3800.00,102997.40,NULL,NULL,'0');
insert into tab_trans values (5051,111902,378,'1997-5-6','VYDAJ','VYBER',3300.00,85154.80,NULL,NULL,'0');
insert into tab_trans values (5051,111903,378,'1997-6-2','VYDAJ','VYBER',3500.00,88313.00,NULL,NULL,'0');
insert into tab_trans values (5051,111904,378,'1997-7-17','VYDAJ','VYBER',5400.00,45912.70,NULL,NULL,'0');
insert into tab_trans values (5051,111905,378,'1997-8-18','VYDAJ','VYBER',2700.00,52090.30,NULL,NULL,'0');
insert into tab_trans values (5051,111906,378,'1997-9-17','VYDAJ','VYBER',3600.00,56390.70,NULL,NULL,'0');
insert into tab_trans values (5051,111930,378,'1996-9-12','VYDAJ','PREVOD NA UCET',8537.00,59507.90,'SIPO','KL','6934583');
insert into tab_trans values (5051,111931,378,'1996-10-12','VYDAJ','PREVOD NA UCET',8537.00,67268.30,'SIPO','KL','6934583');
insert into tab_trans values (5051,111932,378,'1996-11-12','VYDAJ','PREVOD NA UCET',8537.00,68671.80,'SIPO','KL','6934583');
insert into tab_trans values (5051,111933,378,'1996-12-12','VYDAJ','PREVOD NA UCET',8537.00,77934.10,'SIPO','KL','6934583');
insert into tab_trans values (5051,111934,378,'1997-1-12','VYDAJ','PREVOD NA UCET',8537.00,42088.20,'SIPO','KL','6934583');
insert into tab_trans values (5051,111935,378,'1997-2-12','VYDAJ','PREVOD NA UCET',8537.00,82930.10,'SIPO','KL','6934583');
insert into tab_trans values (5051,111936,378,'1997-3-12','VYDAJ','PREVOD NA UCET',8537.00,87022.50,'SIPO','KL','6934583');
insert into tab_trans values (5051,111937,378,'1997-4-12','VYDAJ','PREVOD NA UCET',8537.00,91754.40,'SIPO','KL','6934583');
insert into tab_trans values (5051,111938,378,'1997-5-12','VYDAJ','PREVOD NA UCET',8537.00,79304.80,'SIPO','KL','6934583');
insert into tab_trans values (5051,111939,378,'1997-6-12','VYDAJ','PREVOD NA UCET',8537.00,92766.00,'SIPO','KL','6934583');
insert into tab_trans values (5051,111940,378,'1997-7-12','VYDAJ','PREVOD NA UCET',8537.00,58596.70,'SIPO','KL','6934583');
insert into tab_trans values (5051,111941,378,'1997-8-12','VYDAJ','PREVOD NA UCET',8537.00,54971.30,'SIPO','KL','6934583');
insert into tab_trans values (5051,111942,378,'1997-9-12','VYDAJ','PREVOD NA UCET',8537.00,86776.70,'SIPO','KL','6934583');
insert into tab_trans values (5051,111966,378,'1996-9-13','VYDAJ','PREVOD NA UCET',1184.00,58323.90,NULL,'AB','85313254');
insert into tab_trans values (5051,111967,378,'1996-10-13','VYDAJ','PREVOD NA UCET',1184.00,66084.30,NULL,'AB','85313254');
insert into tab_trans values (5051,111968,378,'1996-11-13','VYDAJ','PREVOD NA UCET',1184.00,109081.80,NULL,'AB','85313254');
insert into tab_trans values (5051,111969,378,'1996-12-13','VYDAJ','PREVOD NA UCET',1184.00,107763.10,NULL,'AB','85313254');
insert into tab_trans values (5051,111970,378,'1997-1-13','VYDAJ','PREVOD NA UCET',1184.00,40904.20,NULL,'AB','85313254');
insert into tab_trans values (5051,111971,378,'1997-2-13','VYDAJ','PREVOD NA UCET',1184.00,81746.10,NULL,'AB','85313254');
insert into tab_trans values (5051,111972,378,'1997-3-13','VYDAJ','PREVOD NA UCET',1184.00,85836.50,NULL,'AB','85313254');
insert into tab_trans values (5051,111973,378,'1997-4-13','VYDAJ','PREVOD NA UCET',1184.00,90570.40,NULL,'AB','85313254');
insert into tab_trans values (5051,111974,378,'1997-5-13','VYDAJ','PREVOD NA UCET',1184.00,78118.80,NULL,'AB','85313254');
insert into tab_trans values (5051,111975,378,'1997-6-13','VYDAJ','PREVOD NA UCET',1184.00,91580.00,NULL,'AB','85313254');
insert into tab_trans values (5051,111976,378,'1997-7-13','VYDAJ','PREVOD NA UCET',1184.00,57412.70,NULL,'AB','85313254');
insert into tab_trans values (5051,111977,378,'1997-8-13','VYDAJ','PREVOD NA UCET',1184.00,53787.30,NULL,'AB','85313254');
insert into tab_trans values (5051,111978,378,'1997-9-13','VYDAJ','PREVOD NA UCET',1184.00,85590.70,NULL,'AB','85313254');
insert into tab_trans values (5051,112002,378,'1996-9-12','VYDAJ','PREVOD NA UCET',2.00,68044.90,'POJISTNE','ST','70710897');
insert into tab_trans values (5051,112003,378,'1996-10-12','VYDAJ','PREVOD NA UCET',2.00,75805.30,'POJISTNE','ST','70710897');
insert into tab_trans values (5051,112004,378,'1996-11-12','VYDAJ','PREVOD NA UCET',2.00,77208.80,'POJISTNE','ST','70710897');
insert into tab_trans values (5051,112005,378,'1996-12-12','VYDAJ','PREVOD NA UCET',2.00,77932.10,'POJISTNE','ST','70710897');
insert into tab_trans values (5051,112006,378,'1997-1-12','VYDAJ','PREVOD NA UCET',2.00,50625.20,'POJISTNE','ST','70710897');
insert into tab_trans values (5051,112007,378,'1997-2-12','VYDAJ','PREVOD NA UCET',2.00,91467.10,'POJISTNE','ST','70710897');
insert into tab_trans values (5051,112008,378,'1997-3-12','VYDAJ','PREVOD NA UCET',2.00,87020.50,'POJISTNE','ST','70710897');
insert into tab_trans values (5051,112009,378,'1997-4-12','VYDAJ','PREVOD NA UCET',2.00,102991.40,'POJISTNE','ST','70710897');
insert into tab_trans values (5051,112010,378,'1997-5-12','VYDAJ','PREVOD NA UCET',2.00,79302.80,'POJISTNE','ST','70710897');
insert into tab_trans values (5051,112011,378,'1997-6-12','VYDAJ','PREVOD NA UCET',2.00,92764.00,'POJISTNE','ST','70710897');
insert into tab_trans values (5051,112012,378,'1997-7-12','VYDAJ','PREVOD NA UCET',2.00,67133.70,'POJISTNE','ST','70710897');
insert into tab_trans values (5051,112013,378,'1997-8-12','VYDAJ','PREVOD NA UCET',2.00,63508.30,'POJISTNE','ST','70710897');
insert into tab_trans values (5051,112014,378,'1997-9-12','VYDAJ','PREVOD NA UCET',2.00,86774.70,'POJISTNE','ST','70710897');
insert into tab_trans values (5051,112038,378,'1996-9-7','VYDAJ','PREVOD NA UCET',4.00,68046.90,NULL,'KL','23140502');
insert into tab_trans values (5051,112039,378,'1996-10-7','VYDAJ','PREVOD NA UCET',4.00,75807.30,NULL,'KL','23140502');
insert into tab_trans values (5051,112040,378,'1996-11-7','VYDAJ','PREVOD NA UCET',4.00,77210.80,NULL,'KL','23140502');
insert into tab_trans values (5051,112041,378,'1996-12-7','VYDAJ','PREVOD NA UCET',4.00,86471.10,NULL,'KL','23140502');
insert into tab_trans values (5051,112042,378,'1997-1-7','VYDAJ','PREVOD NA UCET',4.00,93346.20,NULL,'KL','23140502');
insert into tab_trans values (5051,112043,378,'1997-2-7','VYDAJ','PREVOD NA UCET',4.00,101781.10,NULL,'KL','23140502');
insert into tab_trans values (5051,112044,378,'1997-3-7','VYDAJ','PREVOD NA UCET',4.00,95559.50,NULL,'KL','23140502');
insert into tab_trans values (5051,112045,378,'1997-4-7','VYDAJ','PREVOD NA UCET',4.00,102993.40,NULL,'KL','23140502');
insert into tab_trans values (5051,112046,378,'1997-5-7','VYDAJ','PREVOD NA UCET',4.00,85150.80,NULL,'KL','23140502');
insert into tab_trans values (5051,112047,378,'1997-6-7','VYDAJ','PREVOD NA UCET',4.00,65695.00,NULL,'KL','23140502');
insert into tab_trans values (5051,112048,378,'1997-7-7','VYDAJ','PREVOD NA UCET',4.00,71335.70,NULL,'KL','23140502');
insert into tab_trans values (5051,112049,378,'1997-8-7','VYDAJ','PREVOD NA UCET',4.00,63510.30,NULL,'KL','23140502');
insert into tab_trans values (5051,112050,378,'1997-9-7','VYDAJ','PREVOD NA UCET',4.00,52306.70,NULL,'KL','23140502');
insert into tab_trans values (5051,112051,378,'1997-10-7','VYDAJ','PREVOD NA UCET',4.00,49277.30,NULL,'KL','23140502');
insert into tab_trans values (5051,112068,378,'1996-9-17','VYBER','VYBER',11160.00,47163.90,NULL,NULL,NULL);
insert into tab_trans values (5051,112078,378,'1996-10-19','VYBER','VYBER',11007.00,91540.30,NULL,NULL,NULL);
insert into tab_trans values (5051,112079,378,'1997-10-2','VYBER','VYBER',7354.00,49281.30,NULL,NULL,NULL);
insert into tab_trans values (5051,112080,378,'1997-4-15','VYBER','VYBER',12269.00,78301.40,NULL,NULL,NULL);
insert into tab_trans values (5051,112096,378,'1997-6-15','VYDAJ','VYBER',35100.00,56480.00,NULL,NULL,NULL);
insert into tab_trans values (5051,112099,378,'1997-1-2','VYDAJ','VYBER',8700.00,93350.20,NULL,NULL,NULL);
insert into tab_trans values (5051,112101,378,'1996-12-23','VYDAJ','VYBER',3000.00,56152.10,NULL,NULL,NULL);
insert into tab_trans values (5051,112105,378,'1996-11-20','VYDAJ','VYBER',1500.00,67481.80,NULL,NULL,NULL);
insert into tab_trans values (5051,112107,378,'1997-7-11','VYDAJ','VYBER',4200.00,67135.70,NULL,NULL,NULL);
insert into tab_trans values (5051,112108,378,'1997-5-26','VYDAJ','VYBER',9300.00,91459.80,NULL,NULL,NULL);
insert into tab_trans values (5051,112110,378,'1997-4-12','VYDAJ','VYBER',2700.00,100291.40,NULL,NULL,NULL);
insert into tab_trans values (5051,112126,378,'1996-8-31','VYDAJ','VYBER',14.60,68050.90,'SLUZBY',NULL,NULL);
insert into tab_trans values (5051,112127,378,'1996-9-30','VYDAJ','VYBER',14.60,75811.30,'SLUZBY',NULL,NULL);
insert into tab_trans values (5051,112128,378,'1996-10-31','VYDAJ','VYBER',14.60,99143.80,'SLUZBY',NULL,NULL);
insert into tab_trans values (5051,112129,378,'1996-11-30','VYDAJ','VYBER',14.60,86475.10,'SLUZBY',NULL,NULL);
insert into tab_trans values (5051,112130,378,'1996-12-31','VYDAJ','VYBER',14.60,102050.20,'SLUZBY',NULL,NULL);
insert into tab_trans values (5051,112131,378,'1997-1-31','VYDAJ','VYBER',14.60,93222.10,'SLUZBY',NULL,NULL);
insert into tab_trans values (5051,112132,378,'1997-2-28','VYDAJ','VYBER',14.60,85906.50,'SLUZBY',NULL,NULL);
insert into tab_trans values (5051,112133,378,'1997-3-31','VYDAJ','VYBER',14.60,106797.40,'SLUZBY',NULL,NULL);
insert into tab_trans values (5051,112134,378,'1997-4-30','VYDAJ','VYBER',14.60,88454.80,'SLUZBY',NULL,NULL);
insert into tab_trans values (5051,112135,378,'1997-5-31','VYDAJ','VYBER',14.60,91813.00,'SLUZBY',NULL,NULL);
insert into tab_trans values (5051,112136,378,'1997-6-30','VYDAJ','VYBER',14.60,71339.70,'SLUZBY',NULL,NULL);
insert into tab_trans values (5051,112137,378,'1997-7-31','VYDAJ','VYBER',14.60,63514.30,'SLUZBY',NULL,NULL);
insert into tab_trans values (5051,112138,378,'1997-8-31','VYDAJ','VYBER',14.60,52310.70,'SLUZBY',NULL,NULL);
insert into tab_trans values (5051,112139,378,'1997-9-30','VYDAJ','VYBER',14.60,56635.30,'SLUZBY',NULL,NULL);
insert into tab_trans values (5051,112154,378,'1996-8-21','VYDAJ','VYBER',33800.00,56842.10,NULL,NULL,NULL);
insert into tab_trans values (5051,112155,378,'1996-9-20','VYDAJ','VYBER',11100.00,36063.90,NULL,NULL,NULL);
insert into tab_trans values (5051,112156,378,'1996-10-20','VYDAJ','VYBER',28700.00,62840.30,NULL,NULL,NULL);
insert into tab_trans values (5051,112157,378,'1996-11-5','VYDAJ','VYBER',19100.00,117414.80,NULL,NULL,NULL);
insert into tab_trans values (5051,112158,378,'1996-11-7','VYDAJ','VYBER',40200.00,77214.80,NULL,NULL,NULL);
insert into tab_trans values (5051,112159,378,'1996-11-19','VYDAJ','VYBER',40100.00,68981.80,NULL,NULL,NULL);
insert into tab_trans values (5051,112160,378,'1996-12-19','VYDAJ','VYBER',59900.00,59152.10,NULL,NULL,NULL);
insert into tab_trans values (5051,112161,378,'1996-12-19','VYDAJ','VYBER',26300.00,119052.10,NULL,NULL,NULL);
insert into tab_trans values (5051,112162,378,'1996-12-28','VYDAJ','VYBER',54900.00,58374.10,NULL,NULL,NULL);
insert into tab_trans values (5051,112163,378,'1996-12-30','VYDAJ','VYBER',25700.00,101709.10,NULL,NULL,NULL);
insert into tab_trans values (5051,112164,378,'1997-1-9','VYDAJ','VYBER',56700.00,55027.20,NULL,NULL,NULL);
insert into tab_trans values (5051,112165,378,'1997-1-18','VYDAJ','VYBER',17700.00,54811.20,NULL,NULL,NULL);
insert into tab_trans values (5051,112166,378,'1997-2-8','VYDAJ','VYBER',41000.00,91469.10,NULL,NULL,NULL);
insert into tab_trans values (5051,112167,378,'1997-2-14','VYDAJ','VYBER',59000.00,61638.10,NULL,NULL,NULL);
insert into tab_trans values (5051,112168,378,'1997-2-17','VYDAJ','VYBER',13500.00,48138.10,NULL,NULL,NULL);
insert into tab_trans values (5051,112169,378,'1997-3-19','VYDAJ','VYBER',24000.00,61836.50,NULL,NULL,NULL);
insert into tab_trans values (5051,112170,378,'1997-4-18','VYDAJ','VYBER',24900.00,53401.40,NULL,NULL,NULL);
insert into tab_trans values (5051,112171,378,'1997-5-11','VYDAJ','VYBER',35400.00,87841.80,NULL,NULL,NULL);
insert into tab_trans values (5051,112172,378,'1997-5-18','VYDAJ','VYBER',22100.00,56018.80,NULL,NULL,NULL);
insert into tab_trans values (5051,112173,378,'1997-6-6','VYDAJ','VYBER',37700.00,65699.00,NULL,NULL,NULL);
insert into tab_trans values (5051,112174,378,'1997-6-17','VYDAJ','VYBER',31600.00,70969.00,NULL,NULL,NULL);
insert into tab_trans values (5051,112175,378,'1997-7-17','VYDAJ','VYBER',6100.00,51312.70,NULL,NULL,NULL);
insert into tab_trans values (5051,112176,378,'1997-8-16','VYDAJ','VYBER',18300.00,54790.30,NULL,NULL,NULL);
insert into tab_trans values (5051,112177,378,'1997-9-15','VYDAJ','VYBER',25600.00,59990.70,NULL,NULL,NULL);
insert into tab_trans values (5051,3543017,378,'1996-7-31','PRIJEM',NULL,42.10,42116.10,'UROK',NULL,NULL);
insert into tab_trans values (5051,3543018,378,'1996-8-31','PRIJEM',NULL,266.40,68065.50,'UROK',NULL,NULL);
insert into tab_trans values (5051,3543019,378,'1996-9-30','PRIJEM',NULL,226.10,75825.90,'UROK',NULL,NULL);
insert into tab_trans values (5051,3543020,378,'1996-10-31','PRIJEM',NULL,350.10,99158.40,'UROK',NULL,NULL);
insert into tab_trans values (5051,3543021,378,'1996-11-30','PRIJEM',NULL,365.90,86489.70,'UROK',NULL,NULL);
insert into tab_trans values (5051,3543022,378,'1996-12-31','PRIJEM',NULL,355.70,102064.80,'UROK',NULL,NULL);
insert into tab_trans values (5051,3543023,378,'1997-1-31','PRIJEM',NULL,340.50,93236.70,'UROK',NULL,NULL);
insert into tab_trans values (5051,3543024,378,'1997-2-28','PRIJEM',NULL,383.90,85921.10,'UROK',NULL,NULL);
insert into tab_trans values (5051,3543025,378,'1997-3-31','PRIJEM',NULL,337.50,106812.00,'UROK',NULL,NULL);
insert into tab_trans values (5051,3543026,378,'1997-4-30','PRIJEM',NULL,356.10,88469.40,'UROK',NULL,NULL);
insert into tab_trans values (5051,3543027,378,'1997-5-31','PRIJEM',NULL,367.80,91827.60,'UROK',NULL,NULL);
insert into tab_trans values (5051,3543028,378,'1997-6-30','PRIJEM',NULL,385.30,71354.30,'UROK',NULL,NULL);
insert into tab_trans values (5051,3543029,378,'1997-7-31','PRIJEM',NULL,256.20,63528.90,'UROK',NULL,NULL);
insert into tab_trans values (5051,3543030,378,'1997-8-31','PRIJEM',NULL,235.00,52325.30,'UROK',NULL,NULL);
insert into tab_trans values (5051,3543031,378,'1997-9-30','PRIJEM',NULL,259.10,56649.90,'UROK',NULL,NULL);
insert into tab_trans values (5060,126587,426,'1993-11-29','PRIJEM','VKLAD',900.00,900.00,NULL,NULL,NULL);
insert into tab_trans values (5060,126600,426,'1993-12-20','PRIJEM','VKLAD',19612.00,20512.00,NULL,NULL,NULL);
insert into tab_trans values (5060,126618,426,'1994-4-10','PRIJEM','VKLAD',32587.00,93606.90,NULL,NULL,NULL);
insert into tab_trans values (5060,126619,426,'1994-3-28','PRIJEM','VKLAD',28805.00,106259.60,NULL,NULL,NULL);
insert into tab_trans values (5060,126620,426,'1994-1-25','PRIJEM','VKLAD',11033.00,55137.20,NULL,NULL,NULL);
insert into tab_trans values (5060,126621,426,'1994-7-10','PRIJEM','VKLAD',20025.00,96183.50,NULL,NULL,NULL);
insert into tab_trans values (5060,126622,426,'1994-1-9','PRIJEM','VKLAD',23884.00,44104.20,NULL,NULL,NULL);
insert into tab_trans values (5060,126623,426,'1994-7-4','PRIJEM','VKLAD',17488.00,77044.50,NULL,NULL,NULL);
insert into tab_trans values (5060,126624,426,'1994-4-17','PRIJEM','VKLAD',17330.00,76698.90,NULL,NULL,NULL);
insert into tab_trans values (5060,126626,426,'1994-4-2','PRIJEM','VKLAD',9152.00,73905.90,NULL,NULL,NULL);
insert into tab_trans values (5060,126627,426,'1994-7-3','PRIJEM','VKLAD',20825.00,59556.50,NULL,NULL,NULL);
insert into tab_trans values (5060,126629,426,'1994-6-7','PRIJEM','VKLAD',29824.00,78521.50,NULL,NULL,NULL);
insert into tab_trans values (5060,126630,426,'1994-5-11','PRIJEM','VKLAD',49937.00,86531.20,NULL,NULL,NULL);
insert into tab_trans values (5060,126632,426,'1994-6-22','PRIJEM','VKLAD',26221.00,54744.50,NULL,NULL,NULL);
insert into tab_trans values (5060,126633,426,'1994-3-27','PRIJEM','VKLAD',20971.00,77454.60,NULL,NULL,NULL);
insert into tab_trans values (5060,126635,426,'1994-3-26','PRIJEM','VKLAD',18110.00,56483.60,NULL,NULL,NULL);
insert into tab_trans values (5060,126636,426,'1994-2-17','PRIJEM','VKLAD',18312.00,73856.80,NULL,NULL,NULL);
insert into tab_trans values (5060,126639,426,'1994-5-29','PRIJEM','VKLAD',5422.00,48473.20,NULL,NULL,NULL);
insert into tab_trans values (5060,126640,426,'1994-2-12','PRIJEM','VKLAD',17900.00,55544.80,NULL,NULL,NULL);
insert into tab_trans values (5060,126688,426,'1994-3-15','VYDAJ','VYBER',4300.00,38373.60,NULL,NULL,'0');
insert into tab_trans values (5060,126689,426,'1994-4-11','VYDAJ','VYBER',3800.00,89806.90,NULL,NULL,'0');
insert into tab_trans values (5060,126690,426,'1994-5-1','VYDAJ','VYBER',4400.00,45681.20,NULL,NULL,'0');
insert into tab_trans values (5060,126691,426,'1994-6-17','VYDAJ','VYBER',3700.00,28523.50,NULL,NULL,'0');
insert into tab_trans values (5060,126692,426,'1994-7-13','VYDAJ','VYBER',4600.00,91583.50,NULL,NULL,'0');
insert into tab_trans values (5060,126760,426,'1994-3-13','VYDAJ','PREVOD NA UCET',7497.00,42673.60,'SIPO','AB','9528249');
insert into tab_trans values (5060,126761,426,'1994-4-13','VYDAJ','PREVOD NA UCET',7497.00,82309.90,'SIPO','AB','9528249');
insert into tab_trans values (5060,126762,426,'1994-5-13','VYDAJ','PREVOD NA UCET',7497.00,74247.20,'SIPO','AB','9528249');
insert into tab_trans values (5060,126763,426,'1994-6-13','VYDAJ','PREVOD NA UCET',7497.00,70138.50,'SIPO','AB','9528249');
insert into tab_trans values (5060,126764,426,'1994-7-13','VYDAJ','PREVOD NA UCET',7497.00,84086.50,'SIPO','AB','9528249');
insert into tab_trans values (5060,126832,426,'1994-3-9','VYDAJ','PREVOD NA UCET',886.00,50170.60,NULL,'GH','34606760');
insert into tab_trans values (5060,126833,426,'1994-4-9','VYDAJ','PREVOD NA UCET',886.00,61019.90,NULL,'GH','34606760');
insert into tab_trans values (5060,126834,426,'1994-5-9','VYDAJ','PREVOD NA UCET',886.00,36594.20,NULL,'GH','34606760');
insert into tab_trans values (5060,126835,426,'1994-6-9','VYDAJ','PREVOD NA UCET',886.00,77635.50,NULL,'GH','34606760');
insert into tab_trans values (5060,126836,426,'1994-7-9','VYDAJ','PREVOD NA UCET',886.00,76158.50,NULL,'GH','34606760');
insert into tab_trans values (5060,126899,426,'1994-5-12','VYBER','VYBER',4787.00,81744.20,NULL,NULL,NULL);
insert into tab_trans values (5060,126901,426,'1994-5-2','VYBER','VYBER',8201.00,37480.20,NULL,NULL,NULL);
insert into tab_trans values (5060,126903,426,'1994-7-14','VYBER','VYBER',13990.00,70096.50,NULL,NULL,NULL);
insert into tab_trans values (5060,126904,426,'1994-6-17','VYBER','VYBER',4615.00,32223.50,NULL,NULL,NULL);
insert into tab_trans values (5060,126905,426,'1994-5-20','VYBER','VYBER',9796.00,64451.20,NULL,NULL,NULL);
insert into tab_trans values (5060,126906,426,'1994-4-16','VYBER','VYBER',22941.00,59368.90,NULL,NULL,NULL);
insert into tab_trans values (5060,126931,426,'1994-6-14','VYDAJ','VYBER',33300.00,36838.50,NULL,NULL,NULL);
insert into tab_trans values (5060,126988,426,'1994-4-4','VYDAJ','VYBER',12000.00,61905.90,NULL,NULL,NULL);
insert into tab_trans values (5060,127029,426,'1994-2-28','VYDAJ','VYBER',14.60,51056.60,'SLUZBY',NULL,NULL);
insert into tab_trans values (5060,127030,426,'1994-3-31','VYDAJ','VYBER',14.60,64753.90,'SLUZBY',NULL,NULL);
insert into tab_trans values (5060,127031,426,'1994-4-30','VYDAJ','VYBER',14.60,50081.20,'SLUZBY',NULL,NULL);
insert into tab_trans values (5060,127032,426,'1994-5-31','VYDAJ','VYBER',14.60,48697.50,'SLUZBY',NULL,NULL);
insert into tab_trans values (5060,127033,426,'1994-6-30','VYDAJ','VYBER',14.60,38731.50,'SLUZBY',NULL,NULL);
insert into tab_trans values (5060,127087,426,'1993-12-29','VYDAJ','VYBER',300.00,20212.00,NULL,NULL,NULL);
insert into tab_trans values (5060,127088,426,'1994-1-28','VYDAJ','VYBER',17600.00,37537.20,NULL,NULL,NULL);
insert into tab_trans values (5060,127089,426,'1994-2-27','VYDAJ','VYBER',23000.00,50856.80,NULL,NULL,NULL);
insert into tab_trans values (5060,127090,426,'1994-3-29','VYDAJ','VYBER',41700.00,64559.60,NULL,NULL,NULL);
insert into tab_trans values (5060,127091,426,'1994-4-28','VYDAJ','VYBER',26900.00,49798.90,NULL,NULL,NULL);
insert into tab_trans values (5060,127092,426,'1994-5-28','VYDAJ','VYBER',21400.00,43051.20,NULL,NULL,NULL);
insert into tab_trans values (5060,127093,426,'1994-6-27','VYDAJ','VYBER',16200.00,38544.50,NULL,NULL,NULL);
insert into tab_trans values (5060,3544633,426,'1993-12-31','PRIJEM',NULL,8.20,20220.20,'UROK',NULL,NULL);
insert into tab_trans values (5060,3544634,426,'1994-1-31','PRIJEM',NULL,107.60,37644.80,'UROK',NULL,NULL);
insert into tab_trans values (5060,3544635,426,'1994-2-28','PRIJEM',NULL,214.40,51071.20,'UROK',NULL,NULL);
insert into tab_trans values (5060,3544636,426,'1994-3-31','PRIJEM',NULL,208.90,64768.50,'UROK',NULL,NULL);
insert into tab_trans values (5060,3544637,426,'1994-4-30','PRIJEM',NULL,296.90,50095.80,'UROK',NULL,NULL);
insert into tab_trans values (5060,3544638,426,'1994-5-31','PRIJEM',NULL,238.90,48712.10,'UROK',NULL,NULL);
insert into tab_trans values (5060,3544639,426,'1994-6-30','PRIJEM',NULL,201.60,38746.10,'UROK',NULL,NULL);
insert into tab_trans values (5061,130895,440,'1996-12-22','PRIJEM','VKLAD',500.00,500.00,NULL,NULL,NULL);
insert into tab_trans values (5061,130908,440,'1997-1-10','PRIJEM','VKLAD',16463.00,16963.00,NULL,NULL,NULL);
insert into tab_trans values (5061,130909,440,'1997-2-10','PRIJEM','VKLAD',16463.00,37657.30,NULL,NULL,NULL);
insert into tab_trans values (5061,130910,440,'1997-3-10','PRIJEM','VKLAD',16463.00,47822.00,NULL,NULL,NULL);
insert into tab_trans values (5061,130911,440,'1997-4-10','PRIJEM','VKLAD',16463.00,50218.40,NULL,NULL,NULL);
insert into tab_trans values (5061,130912,440,'1997-5-10','PRIJEM','VKLAD',16463.00,48118.50,NULL,NULL,NULL);
insert into tab_trans values (5061,130913,440,'1997-6-10','PRIJEM','VKLAD',24694.50,30308.50,NULL,NULL,NULL);
insert into tab_trans values (5061,130914,440,'1997-7-10','PRIJEM','VKLAD',16463.00,33440.90,NULL,NULL,NULL);
insert into tab_trans values (5061,130915,440,'1997-8-10','PRIJEM','VKLAD',16463.00,32041.60,NULL,NULL,NULL);
insert into tab_trans values (5061,130916,440,'1997-9-10','PRIJEM','VKLAD',16463.00,30215.40,NULL,NULL,NULL);
insert into tab_trans values (5061,130917,440,'1997-10-10','PRIJEM','VKLAD',16463.00,30735.20,NULL,NULL,NULL);
insert into tab_trans values (5061,130918,440,'1997-11-10','PRIJEM','VKLAD',16463.00,32657.80,NULL,NULL,NULL);
insert into tab_trans values (5061,130919,440,'1997-12-10','PRIJEM','VKLAD',24694.50,44324.20,NULL,NULL,NULL);
insert into tab_trans values (5061,130920,440,'1998-1-10','PRIJEM','VKLAD',16463.00,25774.60,NULL,NULL,NULL);
insert into tab_trans values (5061,130921,440,'1998-2-10','PRIJEM','VKLAD',16463.00,30091.10,NULL,NULL,NULL);
insert into tab_trans values (5061,130922,440,'1998-3-10','PRIJEM','VKLAD',16463.00,41126.20,NULL,NULL,NULL);
insert into tab_trans values (5061,130949,440,'1997-6-9','VYDAJ','PREVOD NA UCET',5825.00,5614.00,'SIPO','QR','84914481');
insert into tab_trans values (5061,130950,440,'1997-7-9','VYDAJ','PREVOD NA UCET',5825.00,16977.90,'SIPO','QR','84914481');
insert into tab_trans values (5061,130951,440,'1997-8-9','VYDAJ','PREVOD NA UCET',5825.00,15578.60,'SIPO','QR','84914481');
insert into tab_trans values (5061,130952,440,'1997-9-9','VYDAJ','PREVOD NA UCET',5825.00,13752.40,'SIPO','QR','84914481');
insert into tab_trans values (5061,130953,440,'1997-10-9','VYDAJ','PREVOD NA UCET',5825.00,14272.20,'SIPO','QR','84914481');
insert into tab_trans values (5061,130954,440,'1997-11-9','VYDAJ','PREVOD NA UCET',5825.00,16194.80,'SIPO','QR','84914481');
insert into tab_trans values (5061,130955,440,'1997-12-9','VYDAJ','PREVOD NA UCET',5825.00,19629.70,'SIPO','QR','84914481');
insert into tab_trans values (5061,130956,440,'1998-1-9','VYDAJ','PREVOD NA UCET',5825.00,9311.60,'SIPO','QR','84914481');
insert into tab_trans values (5061,130957,440,'1998-2-9','VYDAJ','PREVOD NA UCET',5825.00,13628.10,'SIPO','QR','84914481');
insert into tab_trans values (5061,130958,440,'1998-3-9','VYDAJ','PREVOD NA UCET',5825.00,24663.20,'SIPO','QR','84914481');
insert into tab_trans values (5061,130984,440,'1997-5-17','VYDAJ','VYBER',2200.00,45918.50,NULL,NULL,'0');
insert into tab_trans values (5061,130985,440,'1997-5-31','VYDAJ','VYBER',1600.00,27439.00,NULL,NULL,'0');
insert into tab_trans values (5061,130986,440,'1997-6-25','VYDAJ','VYBER',1300.00,22708.50,NULL,NULL,'0');
insert into tab_trans values (5061,130987,440,'1997-7-30','VYDAJ','VYBER',1700.00,26340.90,NULL,NULL,'0');
insert into tab_trans values (5061,130988,440,'1997-8-31','VYDAJ','VYBER',1700.00,19592.00,NULL,NULL,'0');
insert into tab_trans values (5061,130989,440,'1997-10-9','VYDAJ','VYBER',1200.00,20097.20,NULL,NULL,'0');
insert into tab_trans values (5061,130990,440,'1997-11-27','VYDAJ','VYBER',2100.00,25357.80,NULL,NULL,'0');
insert into tab_trans values (5061,130991,440,'1997-12-16','VYDAJ','VYBER',2000.00,42324.20,NULL,NULL,'0');
insert into tab_trans values (5061,130992,440,'1998-1-15','VYDAJ','VYBER',1700.00,21674.60,NULL,NULL,'0');
insert into tab_trans values (5061,130993,440,'1998-1-31','VYDAJ','VYBER',1100.00,19467.70,NULL,NULL,'0');
insert into tab_trans values (5061,130994,440,'1998-3-10','VYDAJ','VYBER',1600.00,39526.20,NULL,NULL,'0');
insert into tab_trans values (5061,131005,440,'1997-6-7','VYDAJ','VYBER',16000.00,11439.00,NULL,NULL,NULL);
insert into tab_trans values (5061,131009,440,'1998-1-6','VYDAJ','VYBER',8320.00,15136.60,NULL,NULL,NULL);
insert into tab_trans values (5061,131011,440,'1997-12-23','VYDAJ','VYBER',2080.00,26344.20,NULL,NULL,NULL);
insert into tab_trans values (5061,131025,440,'1998-1-26','VYDAJ','VYBER',1800.00,20474.60,NULL,NULL,NULL);
insert into tab_trans values (5061,131026,440,'1998-1-5','VYDAJ','VYBER',3000.00,23456.60,NULL,NULL,NULL);
insert into tab_trans values (5061,131028,440,'1998-1-23','VYDAJ','VYBER',1800.00,22274.60,NULL,NULL,NULL);
insert into tab_trans values (5061,131029,440,'1998-1-15','VYDAJ','VYBER',1560.00,23374.60,NULL,NULL,NULL);
insert into tab_trans values (5061,131030,440,'1998-1-13','VYDAJ','VYBER',840.00,24934.60,NULL,NULL,NULL);
insert into tab_trans values (5061,131034,440,'1997-8-26','VYDAJ','VYBER',4560.00,21181.60,NULL,NULL,NULL);
insert into tab_trans values (5061,131035,440,'1997-8-8','VYDAJ','VYBER',5040.00,21403.60,NULL,NULL,NULL);
insert into tab_trans values (5061,131060,440,'1997-5-31','VYDAJ','VYBER',14.60,29039.00,'SLUZBY',NULL,NULL);
insert into tab_trans values (5061,131061,440,'1997-6-30','VYDAJ','VYBER',14.60,22802.90,'SLUZBY',NULL,NULL);
insert into tab_trans values (5061,131062,440,'1997-7-31','VYDAJ','VYBER',14.60,26443.60,'SLUZBY',NULL,NULL);
insert into tab_trans values (5061,131063,440,'1997-8-31','VYDAJ','VYBER',14.60,19577.40,'SLUZBY',NULL,NULL);
insert into tab_trans values (5061,131064,440,'1997-9-30','VYDAJ','VYBER',14.60,21297.20,'SLUZBY',NULL,NULL);
insert into tab_trans values (5061,131065,440,'1997-10-31','VYDAJ','VYBER',14.60,22019.80,'SLUZBY',NULL,NULL);
insert into tab_trans values (5061,131066,440,'1997-11-30','VYDAJ','VYBER',14.60,25454.70,'SLUZBY',NULL,NULL);
insert into tab_trans values (5061,131067,440,'1997-12-31','VYDAJ','VYBER',14.60,26456.60,'SLUZBY',NULL,NULL);
insert into tab_trans values (5061,131068,440,'1998-1-31','VYDAJ','VYBER',14.60,19453.10,'SLUZBY',NULL,NULL);
insert into tab_trans values (5061,131069,440,'1998-2-28','VYDAJ','VYBER',14.60,30488.20,'SLUZBY',NULL,NULL);
insert into tab_trans values (5061,131079,440,'1997-1-21','PRIJEM','VKLAD',4200.00,21163.00,NULL,NULL,NULL);
insert into tab_trans values (5061,131080,440,'1997-2-20','VYDAJ','VYBER',6400.00,31257.30,NULL,NULL,NULL);
insert into tab_trans values (5061,131081,440,'1997-3-22','VYDAJ','VYBER',14200.00,33622.00,NULL,NULL,NULL);
insert into tab_trans values (5061,131082,440,'1997-4-21','VYDAJ','VYBER',18700.00,31518.40,NULL,NULL,NULL);
insert into tab_trans values (5061,131083,440,'1997-5-21','VYDAJ','VYBER',17000.00,28918.50,NULL,NULL,NULL);
insert into tab_trans values (5061,131084,440,'1997-6-20','VYDAJ','VYBER',6300.00,24008.50,NULL,NULL,NULL);
insert into tab_trans values (5061,131085,440,'1997-7-20','VYDAJ','VYBER',5400.00,28040.90,NULL,NULL,NULL);
insert into tab_trans values (5061,131086,440,'1997-8-19','VYDAJ','VYBER',6300.00,25741.60,NULL,NULL,NULL);
insert into tab_trans values (5061,131087,440,'1997-9-18','VYDAJ','VYBER',9000.00,21215.40,NULL,NULL,NULL);
insert into tab_trans values (5061,131088,440,'1997-10-18','VYDAJ','VYBER',8800.00,21935.20,NULL,NULL,NULL);
insert into tab_trans values (5061,131089,440,'1997-11-17','VYDAJ','VYBER',5200.00,27457.80,NULL,NULL,NULL);
insert into tab_trans values (5061,131090,440,'1997-12-17','VYDAJ','VYBER',13900.00,28424.20,NULL,NULL,NULL);
insert into tab_trans values (5061,131091,440,'1998-1-16','PRIJEM','VKLAD',2400.00,24074.60,NULL,NULL,NULL);
insert into tab_trans values (5061,131092,440,'1998-2-15','PRIJEM','VKLAD',300.00,30391.10,NULL,NULL,NULL);
insert into tab_trans values (5061,3545064,440,'1997-1-31','PRIJEM',NULL,31.30,21194.30,'UROK',NULL,NULL);
insert into tab_trans values (5061,3545065,440,'1997-2-28','PRIJEM',NULL,101.70,31359.00,'UROK',NULL,NULL);
insert into tab_trans values (5061,3545066,440,'1997-3-31','PRIJEM',NULL,133.40,33755.40,'UROK',NULL,NULL);
insert into tab_trans values (5061,3545067,440,'1997-4-30','PRIJEM',NULL,137.20,31655.50,'UROK',NULL,NULL);
insert into tab_trans values (5061,3545068,440,'1997-5-31','PRIJEM',NULL,135.00,29053.60,'UROK',NULL,NULL);
insert into tab_trans values (5061,3545069,440,'1997-6-30','PRIJEM',NULL,109.00,22817.50,'UROK',NULL,NULL);
insert into tab_trans values (5061,3545070,440,'1997-7-31','PRIJEM',NULL,117.40,26458.20,'UROK',NULL,NULL);
insert into tab_trans values (5061,3545071,440,'1997-8-31','PRIJEM',NULL,110.40,21292.00,'UROK',NULL,NULL);
insert into tab_trans values (5061,3545072,440,'1997-9-30','PRIJEM',NULL,96.40,21311.80,'UROK',NULL,NULL);
insert into tab_trans values (5061,3545073,440,'1997-10-31','PRIJEM',NULL,99.20,22034.40,'UROK',NULL,NULL);
insert into tab_trans values (5061,3545074,440,'1997-11-30','PRIJEM',NULL,111.50,25469.30,'UROK',NULL,NULL);
insert into tab_trans values (5061,3545075,440,'1997-12-31','PRIJEM',NULL,127.00,26471.20,'UROK',NULL,NULL);
insert into tab_trans values (5061,3545076,440,'1998-1-31','PRIJEM',NULL,93.10,20567.70,'UROK',NULL,NULL);
insert into tab_trans values (5061,3545077,440,'1998-2-28','PRIJEM',NULL,111.70,30502.80,'UROK',NULL,NULL);
insert into tab_trans values (5063,131735,442,'1997-3-30','PRIJEM','VKLAD',600.00,600.00,NULL,NULL,NULL);
insert into tab_trans values (5063,131887,442,'1997-6-28','PRIJEM','VKLAD',9500.00,10100.00,NULL,NULL,NULL);
insert into tab_trans values (5072,141122,472,'1996-10-11','PRIJEM','VKLAD',300.00,300.00,NULL,NULL,NULL);
insert into tab_trans values (5072,141133,472,'1996-11-7','PRIJEM','PREVOD Z UCTU',49201.00,49501.00,NULL,'IJ','8199900');
insert into tab_trans values (5072,141134,472,'1996-12-7','PRIJEM','PREVOD Z UCTU',73802.00,112214.70,NULL,'IJ','8199900');
insert into tab_trans values (5072,141135,472,'1997-1-7','PRIJEM','PREVOD Z UCTU',49201.00,91295.70,NULL,'IJ','8199900');
insert into tab_trans values (5072,141136,472,'1997-2-7','PRIJEM','PREVOD Z UCTU',49201.00,108424.20,NULL,'IJ','8199900');
insert into tab_trans values (5072,141137,472,'1997-3-7','PRIJEM','PREVOD Z UCTU',49201.00,113888.00,NULL,'IJ','8199900');
insert into tab_trans values (5072,141138,472,'1997-4-7','PRIJEM','PREVOD Z UCTU',49201.00,86366.10,NULL,'IJ','8199900');
insert into tab_trans values (5072,141173,472,'1997-3-11','VYDAJ','VYBER',10800.00,36988.00,NULL,NULL,'0');
insert into tab_trans values (5072,141174,472,'1997-4-18','VYDAJ','VYBER',10000.00,38166.10,NULL,NULL,'0');
insert into tab_trans values (5072,141268,472,'1997-3-31','VYDAJ','VYBER',14.60,37165.10,'SLUZBY',NULL,NULL);
insert into tab_trans values (5072,141289,472,'1996-11-10','VYDAJ','VYBER',11200.00,38301.00,NULL,NULL,NULL);
insert into tab_trans values (5072,141290,472,'1996-12-7','VYDAJ','VYBER',49800.00,62414.70,NULL,NULL,NULL);
insert into tab_trans values (5072,141291,472,'1996-12-10','VYDAJ','VYBER',20500.00,41914.70,NULL,NULL,NULL);
insert into tab_trans values (5072,141292,472,'1997-1-9','VYDAJ','VYBER',32300.00,58995.70,NULL,NULL,NULL);
insert into tab_trans values (5072,141293,472,'1997-2-8','VYDAJ','VYBER',44000.00,64424.20,NULL,NULL,NULL);
insert into tab_trans values (5072,141294,472,'1997-3-7','VYDAJ','VYBER',42400.00,71488.00,NULL,NULL,NULL);
insert into tab_trans values (5072,141295,472,'1997-3-10','VYDAJ','VYBER',23700.00,47788.00,NULL,NULL,NULL);
insert into tab_trans values (5072,141296,472,'1997-4-9','VYDAJ','VYBER',38200.00,48166.10,NULL,NULL,NULL);
insert into tab_trans values (5072,3445516,472,'1996-11-30','PRIJEM',NULL,111.70,38412.70,'UROK',NULL,NULL);
insert into tab_trans values (5072,3445517,472,'1996-12-31','PRIJEM',NULL,180.00,42094.70,'UROK',NULL,NULL);
insert into tab_trans values (5072,3445518,472,'1997-1-31','PRIJEM',NULL,227.50,59223.20,'UROK',NULL,NULL);
insert into tab_trans values (5072,3445519,472,'1997-2-28','PRIJEM',NULL,262.90,64687.00,'UROK',NULL,NULL);
insert into tab_trans values (5072,3445520,472,'1997-3-31','PRIJEM',NULL,191.70,37179.70,'UROK',NULL,NULL);
insert into tab_trans values (5082,150201,501,'1995-10-21','PRIJEM','VKLAD',900.00,900.00,NULL,NULL,NULL);
insert into tab_trans values (5082,150204,501,'1995-11-24','PRIJEM','VKLAD',11393.00,47515.00,NULL,NULL,NULL);
insert into tab_trans values (5082,150205,501,'1995-12-28','PRIJEM','VKLAD',14228.00,78574.30,NULL,NULL,NULL);
insert into tab_trans values (5082,150214,501,'1995-12-24','PRIJEM','VKLAD',14354.00,64346.30,NULL,NULL,NULL);
insert into tab_trans values (5082,150217,501,'1995-11-16','PRIJEM','VKLAD',44022.00,44922.00,NULL,NULL,NULL);
insert into tab_trans values (5082,150218,501,'1995-12-2','PRIJEM','VKLAD',24711.00,72292.30,NULL,NULL,NULL);
insert into tab_trans values (5082,150219,501,'1996-7-5','PRIJEM','VKLAD',40681.00,70152.10,NULL,NULL,NULL);
insert into tab_trans values (5082,150220,501,'1996-5-5','PRIJEM','VKLAD',27025.00,52684.00,NULL,NULL,NULL);
insert into tab_trans values (5082,150221,501,'1996-10-16','PRIJEM','VKLAD',43444.00,76081.30,NULL,NULL,NULL);
insert into tab_trans values (5082,150266,501,'1995-12-29','VYDAJ','VYBER',5200.00,73374.30,NULL,NULL,'0');
insert into tab_trans values (5082,150267,501,'1996-2-9','VYDAJ','VYBER',5700.00,45971.70,NULL,NULL,'0');
insert into tab_trans values (5082,150268,501,'1996-2-26','VYDAJ','VYBER',3000.00,29971.70,NULL,NULL,'0');
insert into tab_trans values (5082,150269,501,'1996-4-15','VYDAJ','VYBER',3200.00,26749.20,NULL,NULL,'0');
insert into tab_trans values (5082,150270,501,'1996-5-1','VYDAJ','VYBER',4200.00,25659.00,NULL,NULL,'0');
insert into tab_trans values (5082,150271,501,'1996-6-14','VYDAJ','VYBER',5600.00,31246.60,NULL,NULL,'0');
insert into tab_trans values (5082,150272,501,'1996-7-8','VYDAJ','VYBER',2900.00,67252.10,NULL,NULL,'0');
insert into tab_trans values (5082,150273,501,'1996-8-10','VYDAJ','VYBER',3800.00,45044.50,NULL,NULL,'0');
insert into tab_trans values (5082,150274,501,'1996-9-12','VYDAJ','VYBER',5500.00,24213.60,NULL,NULL,'0');
insert into tab_trans values (5082,150275,501,'1996-10-6','VYDAJ','VYBER',4700.00,25837.30,NULL,NULL,'0');
insert into tab_trans values (5082,150335,501,'1996-10-15','VYDAJ','VYBER',3900.00,32637.30,NULL,NULL,NULL);
insert into tab_trans values (5082,150336,501,'1996-9-4','VYDAJ','VYBER',10200.00,29713.60,NULL,NULL,NULL);
insert into tab_trans values (5082,150337,501,'1996-5-5','VYDAJ','VYBER',13200.00,39484.00,NULL,NULL,NULL);
insert into tab_trans values (5082,150338,501,'1996-6-18','VYDAJ','VYBER',2100.00,29346.60,NULL,NULL,NULL);
insert into tab_trans values (5082,150363,501,'1995-12-31','VYDAJ','VYBER',14.60,73582.60,'SLUZBY',NULL,NULL);
insert into tab_trans values (5082,150364,501,'1996-1-31','VYDAJ','VYBER',14.60,51671.70,'SLUZBY',NULL,NULL);
insert into tab_trans values (5082,150365,501,'1996-2-29','VYDAJ','VYBER',14.60,30138.40,'SLUZBY',NULL,NULL);
insert into tab_trans values (5082,150366,501,'1996-3-31','VYDAJ','VYBER',14.60,29949.20,'SLUZBY',NULL,NULL);
insert into tab_trans values (5082,150367,501,'1996-4-30','VYDAJ','VYBER',14.60,29859.00,'SLUZBY',NULL,NULL);
insert into tab_trans values (5082,150368,501,'1996-5-31','VYDAJ','VYBER',14.60,36846.60,'SLUZBY',NULL,NULL);
insert into tab_trans values (5082,150369,501,'1996-6-30','VYDAJ','VYBER',14.60,29471.10,'SLUZBY',NULL,NULL);
insert into tab_trans values (5082,150370,501,'1996-7-31','VYDAJ','VYBER',14.60,48844.50,'SLUZBY',NULL,NULL);
insert into tab_trans values (5082,150371,501,'1996-8-31','VYDAJ','VYBER',14.60,39913.60,'SLUZBY',NULL,NULL);
insert into tab_trans values (5082,150372,501,'1996-9-30','VYDAJ','VYBER',14.60,30537.30,'SLUZBY',NULL,NULL);
insert into tab_trans values (5082,150399,501,'1995-11-20','VYDAJ','VYBER',8800.00,36122.00,NULL,NULL,NULL);
insert into tab_trans values (5082,150400,501,'1995-12-20','VYDAJ','VYBER',22300.00,49992.30,NULL,NULL,NULL);
insert into tab_trans values (5082,150401,501,'1996-1-19','VYDAJ','VYBER',22200.00,51382.60,NULL,NULL,NULL);
insert into tab_trans values (5082,150402,501,'1996-2-18','VYDAJ','VYBER',13000.00,32971.70,NULL,NULL,NULL);
insert into tab_trans values (5082,150403,501,'1996-3-19','VYDAJ','VYBER',300.00,29838.40,NULL,NULL,NULL);
insert into tab_trans values (5082,150404,501,'1996-4-18','PRIJEM','VKLAD',3000.00,29749.20,NULL,NULL,NULL);
insert into tab_trans values (5082,150405,501,'1996-5-18','VYDAJ','VYBER',2800.00,36684.00,NULL,NULL,NULL);
insert into tab_trans values (5082,150406,501,'1996-6-17','PRIJEM','VKLAD',200.00,31446.60,NULL,NULL,NULL);
insert into tab_trans values (5082,150407,501,'1996-7-17','VYDAJ','VYBER',18600.00,48652.10,NULL,NULL,NULL);
insert into tab_trans values (5082,150408,501,'1996-8-16','VYDAJ','VYBER',5300.00,39744.50,NULL,NULL,NULL);
insert into tab_trans values (5082,150409,501,'1996-9-15','PRIJEM','VKLAD',6200.00,30413.60,NULL,NULL,NULL);
insert into tab_trans values (5082,150410,501,'1996-10-15','PRIJEM','VKLAD',10700.00,36537.30,NULL,NULL,NULL);
insert into tab_trans values (5082,3547230,501,'1995-11-30','PRIJEM',NULL,66.30,47581.30,'UROK',NULL,NULL);
insert into tab_trans values (5082,3547231,501,'1995-12-31','PRIJEM',NULL,223.00,73597.30,'UROK',NULL,NULL);
insert into tab_trans values (5082,3547232,501,'1996-1-31','PRIJEM',NULL,303.70,51686.30,'UROK',NULL,NULL);
insert into tab_trans values (5082,3547233,501,'1996-2-29','PRIJEM',NULL,181.30,30153.00,'UROK',NULL,NULL);
insert into tab_trans values (5082,3547234,501,'1996-3-31','PRIJEM',NULL,125.50,29963.80,'UROK',NULL,NULL);
insert into tab_trans values (5082,3547235,501,'1996-4-30','PRIJEM',NULL,124.40,29873.60,'UROK',NULL,NULL);
insert into tab_trans values (5082,3547236,501,'1996-5-31','PRIJEM',NULL,177.10,36861.20,'UROK',NULL,NULL);
insert into tab_trans values (5082,3547237,501,'1996-6-30','PRIJEM',NULL,139.10,29485.70,'UROK',NULL,NULL);
insert into tab_trans values (5082,3547238,501,'1996-7-31','PRIJEM',NULL,207.00,48859.10,'UROK',NULL,NULL);
insert into tab_trans values (5082,3547239,501,'1996-8-31','PRIJEM',NULL,183.70,39928.20,'UROK',NULL,NULL);
insert into tab_trans values (5082,3547240,501,'1996-9-30','PRIJEM',NULL,138.30,30551.90,'UROK',NULL,NULL);
insert into tab_trans values (5086,157003,525,'1996-3-20','PRIJEM','VKLAD',300.00,300.00,NULL,NULL,NULL);
insert into tab_trans values (5086,157005,525,'1996-10-29','PRIJEM','VKLAD',26868.00,53100.80,NULL,NULL,NULL);
insert into tab_trans values (5086,157006,525,'1996-5-2','PRIJEM','VKLAD',20657.00,20957.00,NULL,NULL,NULL);
insert into tab_trans values (5086,157007,525,'1996-12-15','PRIJEM','VKLAD',12678.00,51628.20,NULL,NULL,NULL);
insert into tab_trans values (5086,157008,525,'1996-7-24','PRIJEM','VKLAD',34562.00,54948.30,NULL,NULL,NULL);
insert into tab_trans values (5086,157009,525,'1997-6-30','PRIJEM','VKLAD',29206.00,60346.00,NULL,NULL,NULL);
insert into tab_trans values (5086,157012,525,'1997-1-23','PRIJEM','VKLAD',5265.00,43886.90,NULL,NULL,NULL);
insert into tab_trans values (5086,157013,525,'1997-3-4','PRIJEM','VKLAD',19668.00,55007.30,NULL,NULL,NULL);
insert into tab_trans values (5086,157014,525,'1997-4-23','PRIJEM','VKLAD',45903.00,121135.20,NULL,NULL,NULL);
insert into tab_trans values (5086,157015,525,'1997-4-22','PRIJEM','VKLAD',48984.00,75232.20,NULL,NULL,NULL);
insert into tab_trans values (5086,157048,525,'1997-2-6','VYDAJ','VYBER',3100.00,40946.70,NULL,NULL,'0');
insert into tab_trans values (5086,157049,525,'1997-3-15','VYDAJ','VYBER',6300.00,35353.30,NULL,NULL,'0');
insert into tab_trans values (5086,157050,525,'1997-4-8','VYDAJ','VYBER',4700.00,30802.20,NULL,NULL,'0');
insert into tab_trans values (5086,157051,525,'1997-5-17','VYDAJ','VYBER',3900.00,57798.40,NULL,NULL,'0');
insert into tab_trans values (5086,157052,525,'1997-6-17','VYDAJ','VYBER',2900.00,42540.00,NULL,NULL,'0');
insert into tab_trans values (5086,157084,525,'1997-2-12','VYDAJ','PREVOD NA UCET',6454.00,34492.70,'SIPO','ST','67853247');
insert into tab_trans values (5086,157085,525,'1997-3-12','VYDAJ','PREVOD NA UCET',6454.00,38353.30,'SIPO','ST','67853247');
insert into tab_trans values (5086,157086,525,'1997-4-12','VYDAJ','PREVOD NA UCET',6454.00,24348.20,'SIPO','ST','67853247');
insert into tab_trans values (5086,157087,525,'1997-5-12','VYDAJ','PREVOD NA UCET',6454.00,90098.40,'SIPO','ST','67853247');
insert into tab_trans values (5086,157088,525,'1997-6-12','VYDAJ','PREVOD NA UCET',6454.00,51640.00,'SIPO','ST','67853247');
insert into tab_trans values (5086,157089,525,'1997-7-12','VYDAJ','PREVOD NA UCET',6454.00,54078.30,'SIPO','ST','67853247');
insert into tab_trans values (5086,157120,525,'1997-6-26','VYDAJ','VYBER',11400.00,31140.00,NULL,NULL,NULL);
insert into tab_trans values (5086,157151,525,'1997-3-11','VYDAJ','VYBER',10200.00,44807.30,NULL,NULL,NULL);
insert into tab_trans values (5086,157172,525,'1997-1-31','VYDAJ','VYBER',14.60,44046.70,'SLUZBY',NULL,NULL);
insert into tab_trans values (5086,157173,525,'1997-2-28','VYDAJ','VYBER',14.60,35339.30,'SLUZBY',NULL,NULL);
insert into tab_trans values (5086,157174,525,'1997-3-31','VYDAJ','VYBER',14.60,35502.20,'SLUZBY',NULL,NULL);
insert into tab_trans values (5086,157175,525,'1997-4-30','VYDAJ','VYBER',14.60,96552.40,'SLUZBY',NULL,NULL);
insert into tab_trans values (5086,157176,525,'1997-5-31','VYDAJ','VYBER',14.60,58094.00,'SLUZBY',NULL,NULL);
insert into tab_trans values (5086,157177,525,'1997-6-30','VYDAJ','VYBER',14.60,60532.30,'SLUZBY',NULL,NULL);
insert into tab_trans values (5086,157195,525,'1996-5-19','PRIJEM','VKLAD',900.00,21857.00,NULL,NULL,NULL);
insert into tab_trans values (5086,157196,525,'1996-6-18','PRIJEM','VKLAD',600.00,22495.20,NULL,NULL,NULL);
insert into tab_trans values (5086,157197,525,'1996-7-18','VYDAJ','VYBER',2200.00,20386.30,NULL,NULL,NULL);
insert into tab_trans values (5086,157198,525,'1996-8-17','VYDAJ','VYBER',17600.00,37474.90,NULL,NULL,NULL);
insert into tab_trans values (5086,157199,525,'1996-9-16','VYDAJ','VYBER',5300.00,32403.90,NULL,NULL,NULL);
insert into tab_trans values (5086,157200,525,'1996-10-16','VYDAJ','VYBER',6400.00,26232.80,NULL,NULL,NULL);
insert into tab_trans values (5086,157201,525,'1996-11-15','VYDAJ','VYBER',14600.00,38729.00,NULL,NULL,NULL);
insert into tab_trans values (5086,157202,525,'1996-12-15','VYDAJ','VYBER',10600.00,41028.20,NULL,NULL,NULL);
insert into tab_trans values (5086,157203,525,'1997-1-14','VYDAJ','VYBER',2600.00,38621.90,NULL,NULL,NULL);
insert into tab_trans values (5086,157204,525,'1997-2-13','PRIJEM','VKLAD',700.00,35192.70,NULL,NULL,NULL);
insert into tab_trans values (5086,157205,525,'1997-3-15','PRIJEM','VKLAD',3300.00,41653.30,NULL,NULL,NULL);
insert into tab_trans values (5086,157206,525,'1997-4-14','PRIJEM','VKLAD',1900.00,26248.20,NULL,NULL,NULL);
insert into tab_trans values (5086,157207,525,'1997-4-23','VYDAJ','VYBER',24800.00,96335.20,NULL,NULL,NULL);
insert into tab_trans values (5086,157208,525,'1997-5-14','VYDAJ','VYBER',28400.00,61698.40,NULL,NULL,NULL);
insert into tab_trans values (5086,157209,525,'1997-6-13','VYDAJ','VYBER',6200.00,45440.00,NULL,NULL,NULL);
insert into tab_trans values (5086,157210,525,'1997-7-13','VYDAJ','VYBER',7600.00,46478.30,NULL,NULL,NULL);
insert into tab_trans values (5086,3548083,525,'1996-5-31','PRIJEM',NULL,38.20,21895.20,'UROK',NULL,NULL);
insert into tab_trans values (5086,3548084,525,'1996-6-30','PRIJEM',NULL,91.10,22586.30,'UROK',NULL,NULL);
insert into tab_trans values (5086,3548085,525,'1996-7-31','PRIJEM',NULL,126.70,55074.90,'UROK',NULL,NULL);
insert into tab_trans values (5086,3548086,525,'1996-8-31','PRIJEM',NULL,229.00,37703.90,'UROK',NULL,NULL);
insert into tab_trans values (5086,3548087,525,'1996-9-30','PRIJEM',NULL,229.00,32632.80,'UROK',NULL,NULL);
insert into tab_trans values (5086,3548088,525,'1996-10-31','PRIJEM',NULL,228.20,53329.00,'UROK',NULL,NULL);
insert into tab_trans values (5086,3548089,525,'1996-11-30','PRIJEM',NULL,221.20,38950.20,'UROK',NULL,NULL);
insert into tab_trans values (5086,3548090,525,'1996-12-31','PRIJEM',NULL,193.70,41221.90,'UROK',NULL,NULL);
insert into tab_trans values (5086,3548091,525,'1997-1-31','PRIJEM',NULL,174.40,44061.30,'UROK',NULL,NULL);
insert into tab_trans values (5086,3548092,525,'1997-2-28','PRIJEM',NULL,161.20,35353.90,'UROK',NULL,NULL);
insert into tab_trans values (5086,3548093,525,'1997-3-31','PRIJEM',NULL,163.50,35516.80,'UROK',NULL,NULL);
insert into tab_trans values (5086,3548094,525,'1997-4-30','PRIJEM',NULL,231.80,96567.00,'UROK',NULL,NULL);
insert into tab_trans values (5086,3548095,525,'1997-5-31','PRIJEM',NULL,310.20,58108.60,'UROK',NULL,NULL);
insert into tab_trans values (5086,3548096,525,'1997-6-30','PRIJEM',NULL,200.90,60546.90,'UROK',NULL,NULL);
insert into tab_trans values (5088,162840,544,'1995-5-15','PRIJEM','VKLAD',400.00,400.00,NULL,NULL,NULL);
insert into tab_trans values (5088,162846,544,'1995-6-10','PRIJEM','PREVOD Z UCTU',34184.00,34584.00,NULL,'YZ','58388644');
insert into tab_trans values (5088,162847,544,'1995-7-10','PRIJEM','PREVOD Z UCTU',22789.00,52342.60,NULL,'YZ','58388644');
insert into tab_trans values (5088,162848,544,'1995-8-10','PRIJEM','PREVOD Z UCTU',22789.00,61877.30,NULL,'YZ','58388644');
insert into tab_trans values (5088,162849,544,'1995-9-10','PRIJEM','PREVOD Z UCTU',22789.00,65136.90,NULL,'YZ','58388644');
insert into tab_trans values (5088,162850,544,'1995-10-10','PRIJEM','PREVOD Z UCTU',22789.00,70014.40,NULL,'YZ','58388644');
insert into tab_trans values (5088,162851,544,'1995-11-10','PRIJEM','PREVOD Z UCTU',22789.00,67379.40,NULL,'YZ','58388644');
insert into tab_trans values (5088,162852,544,'1995-12-10','PRIJEM','PREVOD Z UCTU',34184.00,72327.70,NULL,'YZ','58388644');
insert into tab_trans values (5088,162853,544,'1996-1-10','PRIJEM','PREVOD Z UCTU',22789.00,52983.70,NULL,'YZ','58388644');
insert into tab_trans values (5088,162854,544,'1996-2-10','PRIJEM','PREVOD Z UCTU',22789.00,44706.20,NULL,'YZ','58388644');
insert into tab_trans values (5088,162855,544,'1996-3-10','PRIJEM','PREVOD Z UCTU',22789.00,67634.80,NULL,'YZ','58388644');
insert into tab_trans values (5088,162856,544,'1996-4-10','PRIJEM','PREVOD Z UCTU',22789.00,59808.10,NULL,'YZ','58388644');
insert into tab_trans values (5088,162857,544,'1996-5-10','PRIJEM','PREVOD Z UCTU',22789.00,61619.50,NULL,'YZ','58388644');
insert into tab_trans values (5088,162858,544,'1996-6-10','PRIJEM','PREVOD Z UCTU',34184.00,65918.50,NULL,'YZ','58388644');
insert into tab_trans values (5088,162859,544,'1996-7-10','PRIJEM','PREVOD Z UCTU',22789.00,63176.30,NULL,'YZ','58388644');
insert into tab_trans values (5088,162860,544,'1996-8-10','PRIJEM','PREVOD Z UCTU',22789.00,53978.80,NULL,'YZ','58388644');
insert into tab_trans values (5088,162898,544,'1995-10-15','VYDAJ','VYBER',4100.00,44414.40,NULL,NULL,'0');
insert into tab_trans values (5088,162899,544,'1995-11-14','VYDAJ','VYBER',3800.00,42179.40,NULL,NULL,'0');
insert into tab_trans values (5088,162900,544,'1995-11-28','VYDAJ','VYBER',4200.00,37979.40,NULL,NULL,'0');
insert into tab_trans values (5088,162901,544,'1996-1-9','VYDAJ','VYBER',3500.00,30194.70,NULL,NULL,'0');
insert into tab_trans values (5088,162902,544,'1996-2-2','VYDAJ','VYBER',2400.00,17217.20,NULL,NULL,'0');
insert into tab_trans values (5088,162903,544,'1996-3-13','VYDAJ','VYBER',3100.00,46134.80,NULL,NULL,'0');
insert into tab_trans values (5088,162904,544,'1996-3-31','VYDAJ','VYBER',3100.00,43233.70,NULL,NULL,'0');
insert into tab_trans values (5088,162905,544,'1996-5-10','VYDAJ','VYBER',3200.00,58419.50,NULL,NULL,'0');
insert into tab_trans values (5088,162906,544,'1996-6-14','VYDAJ','VYBER',3300.00,62618.50,NULL,NULL,'0');
insert into tab_trans values (5088,162907,544,'1996-7-13','VYDAJ','VYBER',3200.00,59976.30,NULL,NULL,'0');
insert into tab_trans values (5088,162908,544,'1996-8-19','VYDAJ','VYBER',3800.00,39378.80,NULL,NULL,'0');
insert into tab_trans values (5088,162942,544,'1996-1-25','VYBER','VYBER',2491.00,37192.70,NULL,NULL,NULL);
insert into tab_trans values (5088,162943,544,'1996-4-18','VYBER','VYBER',12968.00,46840.10,NULL,NULL,NULL);
insert into tab_trans values (5088,162944,544,'1996-6-21','VYBER','VYBER',16344.00,46274.50,NULL,NULL,NULL);
insert into tab_trans values (5088,162972,544,'1996-6-1','VYDAJ','VYBER',26700.00,31934.50,NULL,NULL,NULL);
insert into tab_trans values (5088,162976,544,'1996-1-25','VYDAJ','VYBER',17700.00,19492.70,NULL,NULL,NULL);
insert into tab_trans values (5088,162979,544,'1995-12-24','VYDAJ','VYBER',4200.00,44627.70,NULL,NULL,NULL);
insert into tab_trans values (5088,162984,544,'1995-12-30','VYDAJ','VYBER',11100.00,33527.70,NULL,NULL,NULL);
insert into tab_trans values (5088,162988,544,'1996-8-18','VYDAJ','VYBER KARTOU',1800.00,52178.80,NULL,NULL,'0');
insert into tab_trans values (5088,162989,544,'1996-7-16','VYDAJ','VYBER',3000.00,56976.30,NULL,NULL,NULL);
insert into tab_trans values (5088,162990,544,'1996-8-8','VYDAJ','VYBER',13500.00,31189.80,NULL,NULL,NULL);
insert into tab_trans values (5088,162991,544,'1996-8-18','VYDAJ','VYBER',9000.00,43178.80,NULL,NULL,NULL);
insert into tab_trans values (5088,163011,544,'1995-10-31','VYDAJ','VYBER',14.60,44590.40,'SLUZBY',NULL,NULL);
insert into tab_trans values (5088,163012,544,'1995-11-30','VYDAJ','VYBER',14.60,38143.70,'SLUZBY',NULL,NULL);
insert into tab_trans values (5088,163013,544,'1995-12-31','VYDAJ','VYBER',14.60,33694.70,'SLUZBY',NULL,NULL);
insert into tab_trans values (5088,163014,544,'1996-1-31','VYDAJ','VYBER',14.60,19617.20,'SLUZBY',NULL,NULL);
insert into tab_trans values (5088,163015,544,'1996-2-29','VYDAJ','VYBER',14.60,44845.80,'SLUZBY',NULL,NULL);
insert into tab_trans values (5088,163016,544,'1996-3-31','VYDAJ','VYBER',14.60,43219.10,'SLUZBY',NULL,NULL);
insert into tab_trans values (5088,163017,544,'1996-4-30','VYDAJ','VYBER',14.60,47030.50,'SLUZBY',NULL,NULL);
insert into tab_trans values (5088,163018,544,'1996-5-31','VYDAJ','VYBER',14.60,58634.50,'SLUZBY',NULL,NULL);
insert into tab_trans values (5088,163019,544,'1996-6-30','VYDAJ','VYBER',14.60,46487.30,'SLUZBY',NULL,NULL);
insert into tab_trans values (5088,163020,544,'1996-7-31','VYDAJ','VYBER',14.60,57189.80,'SLUZBY',NULL,NULL);
insert into tab_trans values (5088,163049,544,'1995-6-14','VYDAJ','VYBER',5100.00,29484.00,NULL,NULL,NULL);
insert into tab_trans values (5088,163050,544,'1995-7-14','VYDAJ','VYBER',13400.00,38942.60,NULL,NULL,NULL);
insert into tab_trans values (5088,163051,544,'1995-8-13','VYDAJ','VYBER',19700.00,42177.30,NULL,NULL,NULL);
insert into tab_trans values (5088,163052,544,'1995-9-12','VYDAJ','VYBER',18100.00,47036.90,NULL,NULL,NULL);
insert into tab_trans values (5088,163053,544,'1995-10-12','VYDAJ','VYBER',21500.00,48514.40,NULL,NULL,NULL);
insert into tab_trans values (5088,163054,544,'1995-11-11','VYDAJ','VYBER',21400.00,45979.40,NULL,NULL,NULL);
insert into tab_trans values (5088,163055,544,'1995-12-11','VYDAJ','VYBER',23500.00,48827.70,NULL,NULL,NULL);
insert into tab_trans values (5088,163056,544,'1996-1-10','VYDAJ','VYBER',13300.00,39683.70,NULL,NULL,NULL);
insert into tab_trans values (5088,163057,544,'1996-2-9','PRIJEM','VKLAD',4700.00,21917.20,NULL,NULL,NULL);
insert into tab_trans values (5088,163058,544,'1996-3-10','VYDAJ','VYBER',18400.00,49234.80,NULL,NULL,NULL);
insert into tab_trans values (5088,163059,544,'1996-4-9','VYDAJ','VYBER',6200.00,37019.10,NULL,NULL,NULL);
insert into tab_trans values (5088,163060,544,'1996-5-9','VYDAJ','VYBER',8200.00,38830.50,NULL,NULL,NULL);
insert into tab_trans values (5088,163061,544,'1996-6-8','VYDAJ','VYBER',200.00,31734.50,NULL,NULL,NULL);
insert into tab_trans values (5088,163062,544,'1996-7-8','VYDAJ','VYBER',6100.00,40387.30,NULL,NULL,NULL);
insert into tab_trans values (5088,163063,544,'1996-8-7','VYDAJ','VYBER',12500.00,44689.80,NULL,NULL,NULL);
insert into tab_trans values (5088,3548681,544,'1995-6-30','PRIJEM',NULL,69.60,29553.60,'UROK',NULL,NULL);
insert into tab_trans values (5088,3548682,544,'1995-7-31','PRIJEM',NULL,145.70,39088.30,'UROK',NULL,NULL);
insert into tab_trans values (5088,3548683,544,'1995-8-31','PRIJEM',NULL,170.50,42347.90,'UROK',NULL,NULL);
insert into tab_trans values (5088,3548684,544,'1995-9-30','PRIJEM',NULL,188.60,47225.40,'UROK',NULL,NULL);
insert into tab_trans values (5088,3548685,544,'1995-10-31','PRIJEM',NULL,190.60,44605.00,'UROK',NULL,NULL);
insert into tab_trans values (5088,3548686,544,'1995-11-30','PRIJEM',NULL,178.90,38158.30,'UROK',NULL,NULL);
insert into tab_trans values (5088,3548687,544,'1995-12-31','PRIJEM',NULL,181.60,33709.30,'UROK',NULL,NULL);
insert into tab_trans values (5088,3548688,544,'1996-1-31','PRIJEM',NULL,139.10,19631.80,'UROK',NULL,NULL);
insert into tab_trans values (5088,3548689,544,'1996-2-29','PRIJEM',NULL,154.20,44860.40,'UROK',NULL,NULL);
insert into tab_trans values (5088,3548690,544,'1996-3-31','PRIJEM',NULL,198.90,46333.70,'UROK',NULL,NULL);
insert into tab_trans values (5088,3548691,544,'1996-4-30','PRIJEM',NULL,205.00,47045.10,'UROK',NULL,NULL);
insert into tab_trans values (5088,3548692,544,'1996-5-31','PRIJEM',NULL,229.50,58649.10,'UROK',NULL,NULL);
insert into tab_trans values (5088,3548693,544,'1996-6-30','PRIJEM',NULL,227.40,46501.90,'UROK',NULL,NULL);
insert into tab_trans values (5088,3548694,544,'1996-7-31','PRIJEM',NULL,228.10,57204.40,'UROK',NULL,NULL);
insert into tab_trans values (5103,196338,666,'1996-3-15','PRIJEM','VKLAD',200.00,200.00,NULL,NULL,NULL);
insert into tab_trans values (5103,196342,666,'1996-4-10','PRIJEM','VKLAD',14658.00,14858.00,NULL,NULL,NULL);
insert into tab_trans values (5103,196343,666,'1996-5-10','PRIJEM','VKLAD',14658.00,35264.50,NULL,NULL,NULL);
insert into tab_trans values (5103,196344,666,'1996-6-10','PRIJEM','VKLAD',21987.00,53062.40,NULL,NULL,NULL);
insert into tab_trans values (5103,196345,666,'1996-7-10','PRIJEM','VKLAD',14658.00,57779.40,NULL,NULL,NULL);
insert into tab_trans values (5103,196346,666,'1996-8-10','PRIJEM','VKLAD',14658.00,56713.60,NULL,NULL,NULL);
insert into tab_trans values (5103,196347,666,'1996-9-10','PRIJEM','VKLAD',14658.00,45105.60,NULL,NULL,NULL);
insert into tab_trans values (5103,196348,666,'1996-10-10','PRIJEM','VKLAD',14658.00,46640.90,NULL,NULL,NULL);
insert into tab_trans values (5103,196349,666,'1996-11-10','PRIJEM','VKLAD',14658.00,45372.30,NULL,NULL,NULL);
insert into tab_trans values (5103,196350,666,'1996-12-10','PRIJEM','VKLAD',21987.00,52508.50,NULL,NULL,NULL);
insert into tab_trans values (5103,196351,666,'1997-1-10','PRIJEM','VKLAD',14658.00,43895.50,NULL,NULL,NULL);
insert into tab_trans values (5103,196352,666,'1997-2-10','PRIJEM','VKLAD',14658.00,44817.00,NULL,NULL,NULL);
insert into tab_trans values (5103,196353,666,'1997-3-10','PRIJEM','VKLAD',14658.00,52460.10,NULL,NULL,NULL);
insert into tab_trans values (5103,196354,666,'1997-4-10','PRIJEM','VKLAD',14658.00,52011.10,NULL,NULL,NULL);
insert into tab_trans values (5103,196355,666,'1997-5-10','PRIJEM','VKLAD',14658.00,56483.90,NULL,NULL,NULL);
insert into tab_trans values (5103,196356,666,'1997-6-10','PRIJEM','VKLAD',21987.00,56149.40,NULL,NULL,NULL);
insert into tab_trans values (5103,196357,666,'1997-7-10','PRIJEM','VKLAD',14658.00,56844.70,NULL,NULL,NULL);
insert into tab_trans values (5103,196358,666,'1997-8-10','PRIJEM','VKLAD',14658.00,55005.30,NULL,NULL,NULL);
insert into tab_trans values (5103,196359,666,'1997-9-10','PRIJEM','VKLAD',14658.00,52499.20,NULL,NULL,NULL);
insert into tab_trans values (5103,196360,666,'1997-10-10','PRIJEM','VKLAD',14658.00,53378.60,NULL,NULL,NULL);
insert into tab_trans values (5103,196361,666,'1997-11-10','PRIJEM','VKLAD',14658.00,54562.20,NULL,NULL,NULL);
insert into tab_trans values (5103,196383,666,'1996-9-7','VYDAJ','PREVOD NA UCET',3936.00,35484.60,'SIPO','AB','85506128');
insert into tab_trans values (5103,196384,666,'1996-10-7','VYDAJ','PREVOD NA UCET',3936.00,35219.90,'SIPO','AB','85506128');
insert into tab_trans values (5103,196385,666,'1996-11-7','VYDAJ','PREVOD NA UCET',3936.00,33951.30,'SIPO','AB','85506128');
insert into tab_trans values (5103,196386,666,'1996-12-7','VYDAJ','PREVOD NA UCET',3936.00,33758.50,'SIPO','AB','85506128');
insert into tab_trans values (5103,196387,666,'1997-1-7','VYDAJ','PREVOD NA UCET',3936.00,20874.50,'SIPO','AB','85506128');
insert into tab_trans values (5103,196388,666,'1997-2-7','VYDAJ','PREVOD NA UCET',3936.00,31396.00,'SIPO','AB','85506128');
insert into tab_trans values (5103,196389,666,'1997-3-7','VYDAJ','PREVOD NA UCET',3936.00,41039.10,'SIPO','AB','85506128');
insert into tab_trans values (5103,196390,666,'1997-4-7','VYDAJ','PREVOD NA UCET',3936.00,37790.10,'SIPO','AB','85506128');
insert into tab_trans values (5103,196391,666,'1997-5-7','VYDAJ','PREVOD NA UCET',3936.00,46462.90,'SIPO','AB','85506128');
insert into tab_trans values (5103,196392,666,'1997-6-7','VYDAJ','PREVOD NA UCET',3936.00,51659.40,'SIPO','AB','85506128');
insert into tab_trans values (5103,196393,666,'1997-7-7','VYDAJ','PREVOD NA UCET',3936.00,51223.70,'SIPO','AB','85506128');
insert into tab_trans values (5103,196394,666,'1997-8-7','VYDAJ','PREVOD NA UCET',3936.00,43584.30,'SIPO','AB','85506128');
insert into tab_trans values (5103,196395,666,'1997-9-7','VYDAJ','PREVOD NA UCET',3936.00,41078.20,'SIPO','AB','85506128');
insert into tab_trans values (5103,196396,666,'1997-10-7','VYDAJ','PREVOD NA UCET',3936.00,41957.60,'SIPO','AB','85506128');
insert into tab_trans values (5103,196397,666,'1997-11-7','VYDAJ','PREVOD NA UCET',3936.00,43141.20,'SIPO','AB','85506128');
insert into tab_trans values (5103,196419,666,'1996-9-8','VYDAJ','PREVOD NA UCET',2282.00,33202.60,NULL,'ST','70089435');
insert into tab_trans values (5103,196420,666,'1996-10-8','VYDAJ','PREVOD NA UCET',2282.00,32937.90,NULL,'ST','70089435');
insert into tab_trans values (5103,196421,666,'1996-11-8','VYDAJ','PREVOD NA UCET',2282.00,31669.30,NULL,'ST','70089435');
insert into tab_trans values (5103,196422,666,'1996-12-8','VYDAJ','PREVOD NA UCET',2282.00,31476.50,NULL,'ST','70089435');
insert into tab_trans values (5103,196423,666,'1997-1-8','VYDAJ','PREVOD NA UCET',2282.00,18592.50,NULL,'ST','70089435');
insert into tab_trans values (5103,196424,666,'1997-2-8','VYDAJ','PREVOD NA UCET',2282.00,31114.00,NULL,'ST','70089435');
insert into tab_trans values (5103,196425,666,'1997-3-8','VYDAJ','PREVOD NA UCET',2282.00,38757.10,NULL,'ST','70089435');
insert into tab_trans values (5103,196426,666,'1997-4-8','VYDAJ','PREVOD NA UCET',2282.00,35508.10,NULL,'ST','70089435');
insert into tab_trans values (5103,196427,666,'1997-5-8','VYDAJ','PREVOD NA UCET',2282.00,44180.90,NULL,'ST','70089435');
insert into tab_trans values (5103,196428,666,'1997-6-8','VYDAJ','PREVOD NA UCET',2282.00,35117.40,NULL,'ST','70089435');
insert into tab_trans values (5103,196429,666,'1997-7-8','VYDAJ','PREVOD NA UCET',2282.00,48941.70,NULL,'ST','70089435');
insert into tab_trans values (5103,196430,666,'1997-8-8','VYDAJ','PREVOD NA UCET',2282.00,41302.30,NULL,'ST','70089435');
insert into tab_trans values (5103,196431,666,'1997-9-8','VYDAJ','PREVOD NA UCET',2282.00,38796.20,NULL,'ST','70089435');
insert into tab_trans values (5103,196432,666,'1997-10-8','VYDAJ','PREVOD NA UCET',2282.00,39675.60,NULL,'ST','70089435');
insert into tab_trans values (5103,196433,666,'1997-11-8','VYDAJ','PREVOD NA UCET',2282.00,40859.20,NULL,'ST','70089435');
insert into tab_trans values (5103,196455,666,'1996-9-9','VYDAJ','PREVOD NA UCET',955.00,31647.60,'POJISTNE','GH','93173819');
insert into tab_trans values (5103,196456,666,'1996-10-9','VYDAJ','PREVOD NA UCET',955.00,31982.90,'POJISTNE','GH','93173819');
insert into tab_trans values (5103,196457,666,'1996-11-9','VYDAJ','PREVOD NA UCET',955.00,30714.30,'POJISTNE','GH','93173819');
insert into tab_trans values (5103,196458,666,'1996-12-9','VYDAJ','PREVOD NA UCET',955.00,30521.50,'POJISTNE','GH','93173819');
insert into tab_trans values (5103,196459,666,'1997-1-9','VYDAJ','PREVOD NA UCET',955.00,29237.50,'POJISTNE','GH','93173819');
insert into tab_trans values (5103,196460,666,'1997-2-9','VYDAJ','PREVOD NA UCET',955.00,30159.00,'POJISTNE','GH','93173819');
insert into tab_trans values (5103,196461,666,'1997-3-9','VYDAJ','PREVOD NA UCET',955.00,37802.10,'POJISTNE','GH','93173819');
insert into tab_trans values (5103,196462,666,'1997-4-9','VYDAJ','PREVOD NA UCET',955.00,37353.10,'POJISTNE','GH','93173819');
insert into tab_trans values (5103,196463,666,'1997-5-9','VYDAJ','PREVOD NA UCET',955.00,43225.90,'POJISTNE','GH','93173819');
insert into tab_trans values (5103,196464,666,'1997-6-9','VYDAJ','PREVOD NA UCET',955.00,34162.40,'POJISTNE','GH','93173819');
insert into tab_trans values (5103,196465,666,'1997-7-9','VYDAJ','PREVOD NA UCET',955.00,42186.70,'POJISTNE','GH','93173819');
insert into tab_trans values (5103,196466,666,'1997-8-9','VYDAJ','PREVOD NA UCET',955.00,40347.30,'POJISTNE','GH','93173819');
insert into tab_trans values (5103,196467,666,'1997-9-9','VYDAJ','PREVOD NA UCET',955.00,37841.20,'POJISTNE','GH','93173819');
insert into tab_trans values (5103,196468,666,'1997-10-9','VYDAJ','PREVOD NA UCET',955.00,38720.60,'POJISTNE','GH','93173819');
insert into tab_trans values (5103,196469,666,'1997-11-9','VYDAJ','PREVOD NA UCET',955.00,39904.20,'POJISTNE','GH','93173819');
insert into tab_trans values (5103,196490,666,'1996-8-11','VYDAJ','VYBER',1100.00,55613.60,NULL,NULL,'0');
insert into tab_trans values (5103,196491,666,'1996-9-9','VYDAJ','VYBER',1200.00,30447.60,NULL,NULL,'0');
insert into tab_trans values (5103,196492,666,'1996-10-16','VYDAJ','VYBER',1000.00,38440.90,NULL,NULL,'0');
insert into tab_trans values (5103,196493,666,'1996-11-4','VYDAJ','VYBER',700.00,37887.30,NULL,NULL,'0');
insert into tab_trans values (5103,196494,666,'1996-12-11','VYDAJ','VYBER',1200.00,45208.50,NULL,NULL,'0');
insert into tab_trans values (5103,196495,666,'1997-1-22','VYDAJ','VYBER',700.00,35995.50,NULL,NULL,'0');
insert into tab_trans values (5103,196496,666,'1997-2-1','VYDAJ','VYBER',800.00,35332.00,NULL,NULL,'0');
insert into tab_trans values (5103,196497,666,'1997-3-12','VYDAJ','VYBER',1300.00,42460.10,NULL,NULL,'0');
insert into tab_trans values (5103,196498,666,'1997-3-31','VYDAJ','VYBER',900.00,41740.70,NULL,NULL,'0');
insert into tab_trans values (5103,196499,666,'1997-5-23','VYDAJ','VYBER',1100.00,55383.90,NULL,NULL,'0');
insert into tab_trans values (5103,196500,666,'1997-6-15','VYDAJ','VYBER',1200.00,54949.40,NULL,NULL,'0');
insert into tab_trans values (5103,196501,666,'1997-7-23','VYDAJ','VYBER',800.00,56044.70,NULL,NULL,'0');
insert into tab_trans values (5103,196502,666,'1997-8-16','VYDAJ','VYBER',700.00,54305.30,NULL,NULL,'0');
insert into tab_trans values (5103,196503,666,'1997-9-5','VYDAJ','VYBER',900.00,53614.20,NULL,NULL,'0');
insert into tab_trans values (5103,196504,666,'1997-10-29','VYDAJ','VYBER',700.00,52678.60,NULL,NULL,'0');
insert into tab_trans values (5103,196505,666,'1997-11-5','VYDAJ','VYBER',900.00,47077.20,NULL,NULL,'0');
insert into tab_trans values (5103,196520,666,'1997-6-8','VYDAJ','VYBER',20160.00,37399.40,NULL,NULL,NULL);
insert into tab_trans values (5103,196523,666,'1997-1-1','VYDAJ','VYBER',10720.00,32730.50,NULL,NULL,NULL);
insert into tab_trans values (5103,196525,666,'1996-12-25','VYDAJ','VYBER',1920.00,43288.50,NULL,NULL,NULL);
insert into tab_trans values (5103,196534,666,'1997-1-15','VYDAJ','VYBER',1440.00,41735.50,NULL,NULL,NULL);
insert into tab_trans values (5103,196535,666,'1997-1-3','VYDAJ','VYBER',1440.00,31290.50,NULL,NULL,NULL);
insert into tab_trans values (5103,196536,666,'1997-1-3','VYDAJ','VYBER',3120.00,28170.50,NULL,NULL,NULL);
insert into tab_trans values (5103,196537,666,'1997-1-6','VYDAJ','VYBER',3360.00,24810.50,NULL,NULL,NULL);
insert into tab_trans values (5103,196538,666,'1997-1-18','VYDAJ','VYBER',3000.00,38735.50,NULL,NULL,NULL);
insert into tab_trans values (5103,196539,666,'1997-1-19','VYDAJ','VYBER',2040.00,36695.50,NULL,NULL,NULL);
insert into tab_trans values (5103,196546,666,'1996-9-8','VYDAJ','VYBER',600.00,32602.60,NULL,NULL,NULL);
insert into tab_trans values (5103,196547,666,'1996-11-15','VYDAJ','VYBER',2520.00,37552.30,NULL,NULL,NULL);
insert into tab_trans values (5103,196550,666,'1996-9-2','VYDAJ','VYBER',4560.00,39420.60,NULL,NULL,NULL);
insert into tab_trans values (5103,196552,666,'1997-5-7','VYDAJ','VYBER',1800.00,50398.90,NULL,NULL,NULL);
insert into tab_trans values (5103,196554,666,'1997-1-11','VYDAJ','VYBER',720.00,43175.50,NULL,NULL,NULL);
insert into tab_trans values (5103,196555,666,'1997-8-4','VYDAJ','VYBER',1440.00,54820.30,NULL,NULL,NULL);
insert into tab_trans values (5103,196556,666,'1997-9-22','VYDAJ','VYBER KARTOU',3400.00,49099.20,NULL,NULL,'0');
insert into tab_trans values (5103,196573,666,'1996-8-31','VYDAJ','VYBER',14.60,43980.60,'SLUZBY',NULL,NULL);
insert into tab_trans values (5103,196574,666,'1996-9-30','VYDAJ','VYBER',14.60,39155.90,'SLUZBY',NULL,NULL);
insert into tab_trans values (5103,196575,666,'1996-10-31','VYDAJ','VYBER',14.60,38587.30,'SLUZBY',NULL,NULL);
insert into tab_trans values (5103,196576,666,'1996-11-30','VYDAJ','VYBER',14.60,37694.50,'SLUZBY',NULL,NULL);
insert into tab_trans values (5103,196577,666,'1996-12-31','VYDAJ','VYBER',14.60,43450.50,'SLUZBY',NULL,NULL);
insert into tab_trans values (5103,196578,666,'1997-1-31','VYDAJ','VYBER',14.60,36132.00,'SLUZBY',NULL,NULL);
insert into tab_trans values (5103,196579,666,'1997-2-28','VYDAJ','VYBER',14.60,44975.10,'SLUZBY',NULL,NULL);
insert into tab_trans values (5103,196580,666,'1997-3-31','VYDAJ','VYBER',14.60,41726.10,'SLUZBY',NULL,NULL);
insert into tab_trans values (5103,196581,666,'1997-4-30','VYDAJ','VYBER',14.60,52198.90,'SLUZBY',NULL,NULL);
insert into tab_trans values (5103,196582,666,'1997-5-31','VYDAJ','VYBER',14.60,55595.40,'SLUZBY',NULL,NULL);
insert into tab_trans values (5103,196583,666,'1997-6-30','VYDAJ','VYBER',14.60,55159.70,'SLUZBY',NULL,NULL);
insert into tab_trans values (5103,196584,666,'1997-7-31','VYDAJ','VYBER',14.60,56260.30,'SLUZBY',NULL,NULL);
insert into tab_trans values (5103,196585,666,'1997-8-31','VYDAJ','VYBER',14.60,54514.20,'SLUZBY',NULL,NULL);
insert into tab_trans values (5103,196586,666,'1997-9-30','VYDAJ','VYBER',14.60,49293.60,'SLUZBY',NULL,NULL);
insert into tab_trans values (5103,196587,666,'1997-10-31','VYDAJ','VYBER',14.60,52877.20,'SLUZBY',NULL,NULL);
insert into tab_trans values (5103,196601,666,'1996-4-14','PRIJEM','VKLAD',5700.00,20558.00,NULL,NULL,NULL);
insert into tab_trans values (5103,196602,666,'1996-5-14','VYDAJ','VYBER',4300.00,30964.50,NULL,NULL,NULL);
insert into tab_trans values (5103,196603,666,'1996-6-13','VYDAJ','VYBER',10100.00,42962.40,NULL,NULL,NULL);
insert into tab_trans values (5103,196604,666,'1996-7-13','VYDAJ','VYBER',15900.00,41879.40,NULL,NULL,NULL);
insert into tab_trans values (5103,196605,666,'1996-8-12','VYDAJ','VYBER',11800.00,43813.60,NULL,NULL,NULL);
insert into tab_trans values (5103,196606,666,'1996-9-11','VYDAJ','VYBER',6100.00,39005.60,NULL,NULL,NULL);
insert into tab_trans values (5103,196607,666,'1996-10-11','VYDAJ','VYBER',7200.00,39440.90,NULL,NULL,NULL);
insert into tab_trans values (5103,196608,666,'1996-11-10','VYDAJ','VYBER',5300.00,40072.30,NULL,NULL,NULL);
insert into tab_trans values (5103,196609,666,'1996-12-10','VYDAJ','VYBER',6100.00,46408.50,NULL,NULL,NULL);
insert into tab_trans values (5103,196610,666,'1997-1-9','PRIJEM','VKLAD',11600.00,30192.50,NULL,NULL,NULL);
insert into tab_trans values (5103,196611,666,'1997-2-8','PRIJEM','VKLAD',2000.00,33396.00,NULL,NULL,NULL);
insert into tab_trans values (5103,196612,666,'1997-3-10','VYDAJ','VYBER',8700.00,43760.10,NULL,NULL,NULL);
insert into tab_trans values (5103,196613,666,'1997-4-9','PRIJEM','VKLAD',2800.00,38308.10,NULL,NULL,NULL);
insert into tab_trans values (5103,196614,666,'1997-5-9','VYDAJ','VYBER',1400.00,41825.90,NULL,NULL,NULL);
insert into tab_trans values (5103,196615,666,'1997-6-8','PRIJEM','VKLAD',5900.00,57559.40,NULL,NULL,NULL);
insert into tab_trans values (5103,196616,666,'1997-7-8','VYDAJ','VYBER',5800.00,43141.70,NULL,NULL,NULL);
insert into tab_trans values (5103,196617,666,'1997-8-7','VYDAJ','VYBER',7300.00,47520.30,NULL,NULL,NULL);
insert into tab_trans values (5103,196618,666,'1997-9-6','VYDAJ','VYBER',8600.00,45014.20,NULL,NULL,NULL);
insert into tab_trans values (5103,196619,666,'1997-10-6','VYDAJ','VYBER KARTOU',3400.00,45893.60,NULL,NULL,'0');
insert into tab_trans values (5103,196620,666,'1997-11-5','VYDAJ','VYBER',4900.00,47977.20,NULL,NULL,NULL);
insert into tab_trans values (5103,3552561,666,'1996-4-30','PRIJEM',NULL,48.50,20606.50,'UROK',NULL,NULL);
insert into tab_trans values (5103,3552562,666,'1996-5-31','PRIJEM',NULL,110.80,31075.40,'UROK',NULL,NULL);
insert into tab_trans values (5103,3552563,666,'1996-6-30','PRIJEM',NULL,159.00,43121.40,'UROK',NULL,NULL);
insert into tab_trans values (5103,3552564,666,'1996-7-31','PRIJEM',NULL,176.20,42055.60,'UROK',NULL,NULL);
insert into tab_trans values (5103,3552565,666,'1996-8-31','PRIJEM',NULL,181.60,43995.20,'UROK',NULL,NULL);
insert into tab_trans values (5103,3552566,666,'1996-9-30','PRIJEM',NULL,164.90,39170.50,'UROK',NULL,NULL);
insert into tab_trans values (5103,3552567,666,'1996-10-31','PRIJEM',NULL,161.00,38601.90,'UROK',NULL,NULL);
insert into tab_trans values (5103,3552568,666,'1996-11-30','PRIJEM',NULL,156.80,37709.10,'UROK',NULL,NULL);
insert into tab_trans values (5103,3552569,666,'1996-12-31','PRIJEM',NULL,176.60,43465.10,'UROK',NULL,NULL);
insert into tab_trans values (5103,3552570,666,'1997-1-31','PRIJEM',NULL,151.10,36146.60,'UROK',NULL,NULL);
insert into tab_trans values (5103,3552571,666,'1997-2-28','PRIJEM',NULL,172.70,44989.70,'UROK',NULL,NULL);
insert into tab_trans values (5103,3552572,666,'1997-3-31','PRIJEM',NULL,180.60,42640.70,'UROK',NULL,NULL);
insert into tab_trans values (5103,3552573,666,'1997-4-30','PRIJEM',NULL,202.40,52213.50,'UROK',NULL,NULL);
insert into tab_trans values (5103,3552574,666,'1997-5-31','PRIJEM',NULL,226.10,55610.00,'UROK',NULL,NULL);
insert into tab_trans values (5103,3552575,666,'1997-6-30','PRIJEM',NULL,224.90,55174.30,'UROK',NULL,NULL);
insert into tab_trans values (5103,3552576,666,'1997-7-31','PRIJEM',NULL,230.20,56274.90,'UROK',NULL,NULL);
insert into tab_trans values (5103,3552577,666,'1997-8-31','PRIJEM',NULL,223.60,54528.80,'UROK',NULL,NULL);
insert into tab_trans values (5103,3552578,666,'1997-9-30','PRIJEM',NULL,209.00,49308.20,'UROK',NULL,NULL);
insert into tab_trans values (5103,3552579,666,'1997-10-31','PRIJEM',NULL,213.20,52891.80,'UROK',NULL,NULL);
insert into tab_trans values (5110,198803,675,'1995-8-3','PRIJEM','VKLAD',900.00,900.00,NULL,NULL,NULL);
insert into tab_trans values (5110,198811,675,'1995-8-14','PRIJEM','VKLAD',9538.00,10438.00,NULL,NULL,NULL);
insert into tab_trans values (5110,198812,675,'1995-9-14','PRIJEM','VKLAD',9538.00,26401.30,NULL,NULL,NULL);
insert into tab_trans values (5110,198813,675,'1995-10-14','PRIJEM','VKLAD',9538.00,36120.40,NULL,NULL,NULL);
insert into tab_trans values (5110,198814,675,'1995-11-14','PRIJEM','VKLAD',9538.00,38691.90,NULL,NULL,NULL);
insert into tab_trans values (5110,198815,675,'1995-12-14','PRIJEM','VKLAD',14307.00,43455.50,NULL,NULL,NULL);
insert into tab_trans values (5110,198816,675,'1996-1-14','PRIJEM','VKLAD',9538.00,20992.70,NULL,NULL,NULL);
insert into tab_trans values (5110,198817,675,'1996-2-14','PRIJEM','VKLAD',9538.00,23386.30,NULL,NULL,NULL);
insert into tab_trans values (5110,198818,675,'1996-3-14','PRIJEM','VKLAD',9538.00,29941.10,NULL,NULL,NULL);
insert into tab_trans values (5110,198819,675,'1996-4-14','PRIJEM','VKLAD',9538.00,33326.40,NULL,NULL,NULL);
insert into tab_trans values (5110,198820,675,'1996-5-14','PRIJEM','VKLAD',9538.00,36526.50,NULL,NULL,NULL);
insert into tab_trans values (5110,198821,675,'1996-6-14','PRIJEM','VKLAD',14307.00,33781.90,NULL,NULL,NULL);
insert into tab_trans values (5110,198822,675,'1996-7-14','PRIJEM','VKLAD',9538.00,36573.70,NULL,NULL,NULL);
insert into tab_trans values (5110,198823,675,'1996-8-14','PRIJEM','VKLAD',9538.00,40584.50,NULL,NULL,NULL);
insert into tab_trans values (5110,198824,675,'1996-9-14','PRIJEM','VKLAD',9538.00,31628.90,NULL,NULL,NULL);
insert into tab_trans values (5110,198825,675,'1996-10-14','PRIJEM','VKLAD',9538.00,30603.10,NULL,NULL,NULL);
insert into tab_trans values (5110,198826,675,'1996-11-14','PRIJEM','VKLAD',9538.00,38093.80,NULL,NULL,NULL);
insert into tab_trans values (5110,198827,675,'1996-12-14','PRIJEM','VKLAD',14307.00,40619.90,NULL,NULL,NULL);
insert into tab_trans values (5110,198828,675,'1997-1-14','PRIJEM','VKLAD',9538.00,29720.90,NULL,NULL,NULL);
insert into tab_trans values (5110,198829,675,'1997-2-14','PRIJEM','VKLAD',9538.00,30245.90,NULL,NULL,NULL);
insert into tab_trans values (5110,198830,675,'1997-3-14','PRIJEM','VKLAD',9538.00,39833.60,NULL,NULL,NULL);
insert into tab_trans values (5110,198864,675,'1996-1-9','VYDAJ','PREVOD NA UCET',6358.00,13854.70,'SIPO','MN','74623369');
insert into tab_trans values (5110,198865,675,'1996-2-9','VYDAJ','PREVOD NA UCET',6358.00,15448.30,'SIPO','MN','74623369');
insert into tab_trans values (5110,198866,675,'1996-3-9','VYDAJ','PREVOD NA UCET',6358.00,21703.10,'SIPO','MN','74623369');
insert into tab_trans values (5110,198867,675,'1996-4-9','VYDAJ','PREVOD NA UCET',6358.00,25288.40,'SIPO','MN','74623369');
insert into tab_trans values (5110,198868,675,'1996-5-9','VYDAJ','PREVOD NA UCET',6358.00,26988.50,'SIPO','MN','74623369');
insert into tab_trans values (5110,198869,675,'1996-6-9','VYDAJ','PREVOD NA UCET',6358.00,19474.90,'SIPO','MN','74623369');
insert into tab_trans values (5110,198870,675,'1996-7-9','VYDAJ','PREVOD NA UCET',6358.00,27035.70,'SIPO','MN','74623369');
insert into tab_trans values (5110,198871,675,'1996-8-9','VYDAJ','PREVOD NA UCET',6358.00,31046.50,'SIPO','MN','74623369');
insert into tab_trans values (5110,198872,675,'1996-9-9','VYDAJ','PREVOD NA UCET',6358.00,22090.90,'SIPO','MN','74623369');
insert into tab_trans values (5110,198873,675,'1996-10-9','VYDAJ','PREVOD NA UCET',6358.00,21065.10,'SIPO','MN','74623369');
insert into tab_trans values (5110,198874,675,'1996-11-9','VYDAJ','PREVOD NA UCET',6358.00,28555.80,'SIPO','MN','74623369');
insert into tab_trans values (5110,198875,675,'1996-12-9','VYDAJ','PREVOD NA UCET',6358.00,26312.90,'SIPO','MN','74623369');
insert into tab_trans values (5110,198876,675,'1997-1-9','VYDAJ','PREVOD NA UCET',6358.00,23542.90,'SIPO','MN','74623369');
insert into tab_trans values (5110,198877,675,'1997-2-9','VYDAJ','PREVOD NA UCET',6358.00,20707.90,'SIPO','MN','74623369');
insert into tab_trans values (5110,198878,675,'1997-3-9','VYDAJ','PREVOD NA UCET',6358.00,30295.60,'SIPO','MN','74623369');
insert into tab_trans values (5110,198912,675,'1996-1-7','VYDAJ','VYBER',1900.00,34612.70,NULL,NULL,'0');
insert into tab_trans values (5110,198913,675,'1996-2-9','VYDAJ','VYBER',1600.00,13848.30,NULL,NULL,'0');
insert into tab_trans values (5110,198914,675,'1996-3-12','VYDAJ','VYBER',1300.00,20403.10,NULL,NULL,'0');
insert into tab_trans values (5110,198915,675,'1996-4-13','VYDAJ','VYBER',1500.00,23788.40,NULL,NULL,'0');
insert into tab_trans values (5110,198916,675,'1996-5-16','VYDAJ','VYBER',2000.00,34526.50,NULL,NULL,'0');
insert into tab_trans values (5110,198917,675,'1996-6-6','VYDAJ','VYBER',1900.00,29552.90,NULL,NULL,'0');
insert into tab_trans values (5110,198918,675,'1996-7-18','VYDAJ','VYBER',1300.00,35273.70,NULL,NULL,'0');
insert into tab_trans values (5110,198919,675,'1996-8-18','VYDAJ','VYBER',1200.00,39384.50,NULL,NULL,'0');
insert into tab_trans values (5110,198920,675,'1996-9-7','VYDAJ','VYBER',1900.00,28448.90,NULL,NULL,'0');
insert into tab_trans values (5110,198921,675,'1996-10-4','VYDAJ','VYBER',1200.00,31743.10,NULL,NULL,'0');
insert into tab_trans values (5110,198922,675,'1996-11-17','VYDAJ','VYBER',1600.00,36493.80,NULL,NULL,'0');
insert into tab_trans values (5110,198923,675,'1996-12-9','VYDAJ','VYBER',1300.00,32670.90,NULL,NULL,'0');
insert into tab_trans values (5110,198924,675,'1997-1-14','VYDAJ','VYBER',2000.00,27720.90,NULL,NULL,'0');
insert into tab_trans values (5110,198925,675,'1997-2-4','VYDAJ','VYBER',1600.00,27065.90,NULL,NULL,'0');
insert into tab_trans values (5110,198926,675,'1997-3-21','VYDAJ','VYBER',900.00,33533.60,NULL,NULL,'0');
insert into tab_trans values (5110,198953,675,'1996-1-7','VYDAJ','VYBER',14400.00,20212.70,NULL,NULL,NULL);
insert into tab_trans values (5110,198957,675,'1996-12-20','VYDAJ','VYBER',3840.00,36779.90,NULL,NULL,NULL);
insert into tab_trans values (5110,198967,675,'1996-1-23','VYDAJ','VYBER',3000.00,16672.70,NULL,NULL,NULL);
insert into tab_trans values (5110,198968,675,'1996-1-28','VYDAJ','VYBER',1200.00,13432.70,NULL,NULL,NULL);
insert into tab_trans values (5110,198970,675,'1996-1-26','VYDAJ','VYBER',2040.00,14632.70,NULL,NULL,NULL);
insert into tab_trans values (5110,198971,675,'1996-1-11','VYDAJ','VYBER',2400.00,11454.70,NULL,NULL,NULL);
insert into tab_trans values (5110,198972,675,'1997-1-6','VYDAJ','VYBER',2520.00,29900.90,NULL,NULL,NULL);
insert into tab_trans values (5110,198973,675,'1997-1-26','VYDAJ','VYBER',1800.00,31200.90,NULL,NULL,NULL);
insert into tab_trans values (5110,198974,675,'1997-1-13','VYDAJ','VYBER',3360.00,20182.90,NULL,NULL,NULL);
insert into tab_trans values (5110,198975,675,'1997-1-1','VYDAJ','VYBER',2760.00,33860.90,NULL,NULL,NULL);
insert into tab_trans values (5110,198976,675,'1997-1-2','VYDAJ','VYBER',1440.00,32420.90,NULL,NULL,NULL);
insert into tab_trans values (5110,198977,675,'1997-1-22','VYDAJ','VYBER',1320.00,26400.90,NULL,NULL,NULL);
insert into tab_trans values (5110,198986,675,'1996-10-7','VYDAJ','VYBER',4320.00,27423.10,NULL,NULL,NULL);
insert into tab_trans values (5110,198987,675,'1996-12-6','VYDAJ','VYBER',5160.00,33970.90,NULL,NULL,NULL);
insert into tab_trans values (5110,198988,675,'1996-6-7','VYDAJ','VYBER',3720.00,25832.90,NULL,NULL,NULL);
insert into tab_trans values (5110,198989,675,'1996-9-3','VYDAJ','VYBER',5880.00,30348.90,NULL,NULL,NULL);
insert into tab_trans values (5110,198990,675,'1996-1-20','VYDAJ','VYBER',1320.00,19672.70,NULL,NULL,NULL);
insert into tab_trans values (5110,198993,675,'1997-1-30','VYDAJ','VYBER',2640.00,28560.90,NULL,NULL,NULL);
insert into tab_trans values (5110,198994,675,'1997-3-18','VYDAJ','VYBER',5400.00,34433.60,NULL,NULL,NULL);
insert into tab_trans values (5110,199008,675,'1995-12-31','VYDAJ','VYBER',14.60,43612.70,'SLUZBY',NULL,NULL);
insert into tab_trans values (5110,199009,675,'1996-1-31','VYDAJ','VYBER',14.60,21806.30,'SLUZBY',NULL,NULL);
insert into tab_trans values (5110,199010,675,'1996-2-29','VYDAJ','VYBER',14.60,28061.10,'SLUZBY',NULL,NULL);
insert into tab_trans values (5110,199011,675,'1996-3-31','VYDAJ','VYBER',14.60,31646.40,'SLUZBY',NULL,NULL);
insert into tab_trans values (5110,199012,675,'1996-4-30','VYDAJ','VYBER',14.60,33346.50,'SLUZBY',NULL,NULL);
insert into tab_trans values (5110,199013,675,'1996-5-31','VYDAJ','VYBER',14.60,31452.90,'SLUZBY',NULL,NULL);
insert into tab_trans values (5110,199014,675,'1996-6-30','VYDAJ','VYBER',14.60,33393.70,'SLUZBY',NULL,NULL);
insert into tab_trans values (5110,199015,675,'1996-7-31','VYDAJ','VYBER',14.60,37404.50,'SLUZBY',NULL,NULL);
insert into tab_trans values (5110,199016,675,'1996-8-31','VYDAJ','VYBER',14.60,36228.90,'SLUZBY',NULL,NULL);
insert into tab_trans values (5110,199017,675,'1996-9-30','VYDAJ','VYBER',14.60,32943.10,'SLUZBY',NULL,NULL);
insert into tab_trans values (5110,199018,675,'1996-10-31','VYDAJ','VYBER',14.60,34913.80,'SLUZBY',NULL,NULL);
insert into tab_trans values (5110,199019,675,'1996-11-30','VYDAJ','VYBER',14.60,39130.90,'SLUZBY',NULL,NULL);
insert into tab_trans values (5110,199020,675,'1996-12-31','VYDAJ','VYBER',14.60,36620.90,'SLUZBY',NULL,NULL);
insert into tab_trans values (5110,199021,675,'1997-1-31','VYDAJ','VYBER',14.60,28665.90,'SLUZBY',NULL,NULL);
insert into tab_trans values (5110,199022,675,'1997-2-28','VYDAJ','VYBER',14.60,36653.60,'SLUZBY',NULL,NULL);
insert into tab_trans values (5110,199023,675,'1997-3-31','VYDAJ','VYBER',14.60,34768.40,'SLUZBY',NULL,NULL);
insert into tab_trans values (5110,199044,675,'1995-9-2','PRIJEM','VKLAD',6400.00,16863.30,NULL,NULL,NULL);
insert into tab_trans values (5110,199045,675,'1995-10-2','PRIJEM','VKLAD',100.00,26582.40,NULL,NULL,NULL);
insert into tab_trans values (5110,199046,675,'1995-11-1','VYDAJ','VYBER',7100.00,29153.90,NULL,NULL,NULL);
insert into tab_trans values (5110,199047,675,'1995-12-1','VYDAJ','VYBER',9700.00,29148.50,NULL,NULL,NULL);
insert into tab_trans values (5110,199048,675,'1995-12-31','VYDAJ','VYBER',7100.00,36512.70,NULL,NULL,NULL);
insert into tab_trans values (5110,199049,675,'1996-1-30','PRIJEM','VKLAD',8300.00,21732.70,NULL,NULL,NULL);
insert into tab_trans values (5110,199050,675,'1996-2-29','PRIJEM','VKLAD',4600.00,27986.30,NULL,NULL,NULL);
insert into tab_trans values (5110,199051,675,'1996-3-30','PRIJEM','VKLAD',1600.00,31541.10,NULL,NULL,NULL);
insert into tab_trans values (5110,199052,675,'1996-4-29','VYDAJ','VYBER',100.00,33226.40,NULL,NULL,NULL);
insert into tab_trans values (5110,199053,675,'1996-5-29','VYDAJ','VYBER',3200.00,31326.50,NULL,NULL,NULL);
insert into tab_trans values (5110,199054,675,'1996-6-28','VYDAJ','VYBER',500.00,33281.90,NULL,NULL,NULL);
insert into tab_trans values (5110,199055,675,'1996-7-28','PRIJEM','VKLAD',2000.00,37273.70,NULL,NULL,NULL);
insert into tab_trans values (5110,199056,675,'1996-8-27','VYDAJ','VYBER',3300.00,36084.50,NULL,NULL,NULL);
insert into tab_trans values (5110,199057,675,'1996-9-26','PRIJEM','VKLAD',1200.00,32828.90,NULL,NULL,NULL);
insert into tab_trans values (5110,199058,675,'1996-10-26','PRIJEM','VKLAD',4200.00,34803.10,NULL,NULL,NULL);
insert into tab_trans values (5110,199059,675,'1996-11-25','PRIJEM','VKLAD',2500.00,38993.80,NULL,NULL,NULL);
insert into tab_trans values (5110,199060,675,'1996-12-25','VYDAJ','VYBER',300.00,36479.90,NULL,NULL,NULL);
insert into tab_trans values (5110,199061,675,'1997-1-24','PRIJEM','VKLAD',6600.00,33000.90,NULL,NULL,NULL);
insert into tab_trans values (5110,199062,675,'1997-2-23','PRIJEM','VKLAD',6300.00,36545.90,NULL,NULL,NULL);
insert into tab_trans values (5110,199063,675,'1997-3-25','PRIJEM','VKLAD',1100.00,34633.60,NULL,NULL,NULL);
insert into tab_trans values (5110,3552678,675,'1995-8-31','PRIJEM',NULL,25.30,10463.30,'UROK',NULL,NULL);
insert into tab_trans values (5110,3552679,675,'1995-9-30','PRIJEM',NULL,81.20,26482.40,'UROK',NULL,NULL);
insert into tab_trans values (5110,3552680,675,'1995-10-31','PRIJEM',NULL,133.50,36253.90,'UROK',NULL,NULL);
insert into tab_trans values (5110,3552681,675,'1995-11-30','PRIJEM',NULL,156.60,38848.50,'UROK',NULL,NULL);
insert into tab_trans values (5110,3552682,675,'1995-12-31','PRIJEM',NULL,171.80,43627.30,'UROK',NULL,NULL);
insert into tab_trans values (5110,3552683,675,'1996-1-31','PRIJEM',NULL,88.20,21820.90,'UROK',NULL,NULL);
insert into tab_trans values (5110,3552684,675,'1996-2-29','PRIJEM',NULL,89.40,28075.70,'UROK',NULL,NULL);
insert into tab_trans values (5110,3552685,675,'1996-3-31','PRIJEM',NULL,119.90,31661.00,'UROK',NULL,NULL);
insert into tab_trans values (5110,3552686,675,'1996-4-30','PRIJEM',NULL,134.70,33361.10,'UROK',NULL,NULL);
insert into tab_trans values (5110,3552687,675,'1996-5-31','PRIJEM',NULL,141.00,31467.50,'UROK',NULL,NULL);
insert into tab_trans values (5110,3552688,675,'1996-6-30','PRIJEM',NULL,126.40,33408.30,'UROK',NULL,NULL);
insert into tab_trans values (5110,3552689,675,'1996-7-31','PRIJEM',NULL,145.40,37419.10,'UROK',NULL,NULL);
insert into tab_trans values (5110,3552690,675,'1996-8-31','PRIJEM',NULL,159.00,36243.50,'UROK',NULL,NULL);
insert into tab_trans values (5110,3552691,675,'1996-9-30','PRIJEM',NULL,128.80,32957.70,'UROK',NULL,NULL);
insert into tab_trans values (5110,3552692,675,'1996-10-31','PRIJEM',NULL,125.30,34928.40,'UROK',NULL,NULL);
insert into tab_trans values (5110,3552693,675,'1996-11-30','PRIJEM',NULL,151.70,39145.50,'UROK',NULL,NULL);
insert into tab_trans values (5110,3552694,675,'1996-12-31','PRIJEM',NULL,155.50,36635.50,'UROK',NULL,NULL);
insert into tab_trans values (5110,3552695,675,'1997-1-31','PRIJEM',NULL,119.60,28680.50,'UROK',NULL,NULL);
insert into tab_trans values (5110,3552696,675,'1997-2-28','PRIJEM',NULL,122.20,36668.20,'UROK',NULL,NULL);
insert into tab_trans values (5110,3552697,675,'1997-3-31','PRIJEM',NULL,149.50,34783.00,'UROK',NULL,NULL);
insert into tab_trans values (5117,211365,718,'1996-3-3','PRIJEM','VKLAD',500.00,500.00,NULL,NULL,NULL);
insert into tab_trans values (5117,211366,718,'1996-10-8','PRIJEM','VKLAD',16704.00,67544.10,NULL,NULL,NULL);
insert into tab_trans values (5117,211367,718,'1996-8-16','PRIJEM','VKLAD',12569.00,45926.30,NULL,NULL,NULL);
insert into tab_trans values (5117,211368,718,'1996-9-3','PRIJEM','VKLAD',49059.00,105529.40,NULL,NULL,NULL);
insert into tab_trans values (5117,211369,718,'1996-8-18','PRIJEM','VKLAD',28333.00,74259.30,NULL,NULL,NULL);
insert into tab_trans values (5117,211370,718,'1996-6-22','PRIJEM','VKLAD',7086.00,31586.00,NULL,NULL,NULL);
insert into tab_trans values (5117,211372,718,'1997-7-5','PRIJEM','VKLAD',46289.00,79711.80,NULL,NULL,NULL);
insert into tab_trans values (5117,211373,718,'1997-6-1','PRIJEM','VKLAD',5001.00,36919.50,NULL,NULL,NULL);
insert into tab_trans values (5117,211376,718,'1997-7-26','PRIJEM','VKLAD',44284.00,92737.80,NULL,NULL,NULL);
insert into tab_trans values (5117,211377,718,'1997-1-9','PRIJEM','VKLAD',30421.00,40732.60,NULL,NULL,NULL);
insert into tab_trans values (5117,211378,718,'1997-1-28','PRIJEM','VKLAD',15179.00,46578.60,NULL,NULL,NULL);
insert into tab_trans values (5117,211379,718,'1997-8-2','PRIJEM','VKLAD',31206.00,105970.40,NULL,NULL,NULL);
insert into tab_trans values (5117,211380,718,'1997-1-10','PRIJEM','VKLAD',46782.00,80188.60,NULL,NULL,NULL);
insert into tab_trans values (5117,211414,718,'1996-10-22','VYDAJ','VYBER',5800.00,43577.10,NULL,NULL,'0');
insert into tab_trans values (5117,211415,718,'1996-11-10','VYDAJ','VYBER',6700.00,27426.10,NULL,NULL,'0');
insert into tab_trans values (5117,211416,718,'1996-12-3','VYDAJ','VYBER',7100.00,18190.00,NULL,NULL,'0');
insert into tab_trans values (5117,211417,718,'1997-1-2','VYDAJ','VYBER',7700.00,17433.60,NULL,NULL,'0');
insert into tab_trans values (5117,211418,718,'1997-1-27','VYDAJ','VYBER',4800.00,31399.60,NULL,NULL,'0');
insert into tab_trans values (5117,211419,718,'1997-3-13','VYDAJ','VYBER',6000.00,13467.70,NULL,NULL,'0');
insert into tab_trans values (5117,211420,718,'1997-4-26','VYDAJ','VYBER',6800.00,9256.20,NULL,NULL,'0');
insert into tab_trans values (5117,211421,718,'1997-5-21','VYDAJ','VYBER',5200.00,10443.90,NULL,NULL,'0');
insert into tab_trans values (5117,211422,718,'1997-6-19','VYDAJ','VYBER',7800.00,15230.50,NULL,NULL,'0');
insert into tab_trans values (5117,211423,718,'1997-7-7','VYDAJ','VYBER',6300.00,66289.80,NULL,NULL,'0');
insert into tab_trans values (5117,211424,718,'1997-8-8','VYDAJ','VYBER',8300.00,76523.40,NULL,NULL,'0');
insert into tab_trans values (5117,211450,718,'1996-10-9','VYDAJ','PREVOD NA UCET',726.00,66818.10,'SIPO','KL','22049463');
insert into tab_trans values (5117,211451,718,'1996-11-9','VYDAJ','PREVOD NA UCET',726.00,34126.10,'SIPO','KL','22049463');
insert into tab_trans values (5117,211452,718,'1996-12-9','VYDAJ','PREVOD NA UCET',726.00,10342.00,'SIPO','KL','22049463');
insert into tab_trans values (5117,211453,718,'1997-1-9','VYDAJ','PREVOD NA UCET',726.00,40006.60,'SIPO','KL','22049463');
insert into tab_trans values (5117,211454,718,'1997-2-9','VYDAJ','PREVOD NA UCET',726.00,26595.80,'SIPO','KL','22049463');
insert into tab_trans values (5117,211455,718,'1997-3-9','VYDAJ','PREVOD NA UCET',726.00,25508.70,'SIPO','KL','22049463');
insert into tab_trans values (5117,211456,718,'1997-4-9','VYDAJ','PREVOD NA UCET',726.00,22097.20,'SIPO','KL','22049463');
insert into tab_trans values (5117,211457,718,'1997-5-9','VYDAJ','PREVOD NA UCET',726.00,21684.90,'SIPO','KL','22049463');
insert into tab_trans values (5117,211458,718,'1997-6-9','VYDAJ','PREVOD NA UCET',726.00,29071.50,'SIPO','KL','22049463');
insert into tab_trans values (5117,211459,718,'1997-7-9','VYDAJ','PREVOD NA UCET',726.00,65563.80,'SIPO','KL','22049463');
insert into tab_trans values (5117,211460,718,'1997-8-9','VYDAJ','PREVOD NA UCET',726.00,75797.40,'SIPO','KL','22049463');
insert into tab_trans values (5117,211487,718,'1996-11-6','VYDAJ','PREVOD NA UCET',7122.00,34852.10,NULL,'QR','9956103');
insert into tab_trans values (5117,211488,718,'1996-12-6','VYDAJ','PREVOD NA UCET',7122.00,11068.00,NULL,'QR','9956103');
insert into tab_trans values (5117,211489,718,'1997-1-6','VYDAJ','PREVOD NA UCET',7122.00,10311.60,NULL,'QR','9956103');
insert into tab_trans values (5117,211490,718,'1997-2-6','VYDAJ','PREVOD NA UCET',7122.00,27321.80,NULL,'QR','9956103');
insert into tab_trans values (5117,211491,718,'1997-3-6','VYDAJ','PREVOD NA UCET',7122.00,26234.70,NULL,'QR','9956103');
insert into tab_trans values (5117,211492,718,'1997-4-6','VYDAJ','PREVOD NA UCET',7122.00,22823.20,NULL,'QR','9956103');
insert into tab_trans values (5117,211493,718,'1997-5-6','VYDAJ','PREVOD NA UCET',7122.00,22410.90,NULL,'QR','9956103');
insert into tab_trans values (5117,211494,718,'1997-6-6','VYDAJ','PREVOD NA UCET',7122.00,29797.50,NULL,'QR','9956103');
insert into tab_trans values (5117,211495,718,'1997-7-6','VYDAJ','PREVOD NA UCET',7122.00,72589.80,NULL,'QR','9956103');
insert into tab_trans values (5117,211496,718,'1997-8-6','VYDAJ','PREVOD NA UCET',7122.00,84823.40,NULL,'QR','9956103');
insert into tab_trans values (5117,211522,718,'1996-10-12','VYDAJ','PREVOD NA UCET',6041.00,60777.10,'POJISTNE','MN','10620361');
insert into tab_trans values (5117,211523,718,'1996-11-12','VYDAJ','PREVOD NA UCET',6041.00,21385.10,'POJISTNE','MN','10620361');
insert into tab_trans values (5117,211524,718,'1996-12-12','VYDAJ','PREVOD NA UCET',6041.00,4301.00,'POJISTNE','MN','10620361');
insert into tab_trans values (5117,211525,718,'1997-1-12','VYDAJ','PREVOD NA UCET',6041.00,74147.60,'POJISTNE','MN','10620361');
insert into tab_trans values (5117,211526,718,'1997-2-12','VYDAJ','PREVOD NA UCET',6041.00,20554.80,'POJISTNE','MN','10620361');
insert into tab_trans values (5117,211527,718,'1997-3-12','VYDAJ','PREVOD NA UCET',6041.00,19467.70,'POJISTNE','MN','10620361');
insert into tab_trans values (5117,211528,718,'1997-4-12','VYDAJ','PREVOD NA UCET',6041.00,16056.20,'POJISTNE','MN','10620361');
insert into tab_trans values (5117,211529,718,'1997-5-12','VYDAJ','PREVOD NA UCET',6041.00,15643.90,'POJISTNE','MN','10620361');
insert into tab_trans values (5117,211530,718,'1997-6-12','VYDAJ','PREVOD NA UCET',6041.00,23030.50,'POJISTNE','MN','10620361');
insert into tab_trans values (5117,211531,718,'1997-7-12','VYDAJ','PREVOD NA UCET',6041.00,59522.80,'POJISTNE','MN','10620361');
insert into tab_trans values (5117,211532,718,'1997-8-12','VYDAJ','PREVOD NA UCET',6041.00,69756.40,'POJISTNE','MN','10620361');
insert into tab_trans values (5117,211550,718,'1997-7-13','VYBER','VYBER',11069.00,48453.80,NULL,NULL,NULL);
insert into tab_trans values (5117,211554,718,'1997-2-1','VYBER','VYBER',12279.00,34443.80,NULL,NULL,NULL);
insert into tab_trans values (5117,211556,718,'1997-1-14','VYBER','VYBER',22148.00,51999.60,NULL,NULL,NULL);
insert into tab_trans values (5117,211557,718,'1997-8-5','VYBER','VYBER',14025.00,91945.40,NULL,NULL,NULL);
insert into tab_trans values (5117,211580,718,'1997-1-16','VYDAJ','VYBER',4800.00,38799.60,NULL,NULL,NULL);
insert into tab_trans values (5117,211581,718,'1997-1-9','VYDAJ','VYBER',6600.00,33406.60,NULL,NULL,NULL);
insert into tab_trans values (5117,211582,718,'1997-1-21','VYDAJ','VYBER',8700.00,30099.60,NULL,NULL,NULL);
insert into tab_trans values (5117,211583,718,'1997-1-15','VYDAJ','VYBER',3900.00,43599.60,NULL,NULL,NULL);
insert into tab_trans values (5117,211584,718,'1997-1-14','VYDAJ','VYBER',4500.00,47499.60,NULL,NULL,NULL);
insert into tab_trans values (5117,211593,718,'1996-12-1','VYDAJ','VYBER',6300.00,25290.00,NULL,NULL,NULL);
insert into tab_trans values (5117,211596,718,'1996-10-16','VYDAJ','VYBER',11400.00,49377.10,NULL,NULL,NULL);
insert into tab_trans values (5117,211600,718,'1997-8-15','VYDAJ','VYBER',10500.00,59256.40,NULL,NULL,NULL);
insert into tab_trans values (5117,211622,718,'1996-10-31','VYDAJ','VYBER',14.60,41974.10,'SLUZBY',NULL,NULL);
insert into tab_trans values (5117,211623,718,'1996-11-30','VYDAJ','VYBER',14.60,31590.00,'SLUZBY',NULL,NULL);
insert into tab_trans values (5117,211624,718,'1996-12-31','VYDAJ','VYBER',14.60,25133.60,'SLUZBY',NULL,NULL);
insert into tab_trans values (5117,211625,718,'1997-1-31','VYDAJ','VYBER',14.60,46722.80,'SLUZBY',NULL,NULL);
insert into tab_trans values (5117,211626,718,'1997-2-28','VYDAJ','VYBER',14.60,33356.70,'SLUZBY',NULL,NULL);
insert into tab_trans values (5117,211627,718,'1997-3-31','VYDAJ','VYBER',14.60,29945.20,'SLUZBY',NULL,NULL);
insert into tab_trans values (5117,211628,718,'1997-4-30','VYDAJ','VYBER',14.60,29532.90,'SLUZBY',NULL,NULL);
insert into tab_trans values (5117,211629,718,'1997-5-31','VYDAJ','VYBER',14.60,31918.50,'SLUZBY',NULL,NULL);
insert into tab_trans values (5117,211630,718,'1997-6-30','VYDAJ','VYBER',14.60,33422.80,'SLUZBY',NULL,NULL);
insert into tab_trans values (5117,211631,718,'1997-7-31','VYDAJ','VYBER',14.60,74764.40,'SLUZBY',NULL,NULL);
insert into tab_trans values (5117,211648,718,'1996-4-2','PRIJEM','VKLAD',13700.00,14200.00,NULL,NULL,NULL);
insert into tab_trans values (5117,211649,718,'1996-5-2','PRIJEM','VKLAD',5800.00,20000.00,NULL,NULL,NULL);
insert into tab_trans values (5117,211650,718,'1996-6-1','PRIJEM','VKLAD',4500.00,24500.00,NULL,NULL,NULL);
insert into tab_trans values (5117,211651,718,'1996-7-1','VYDAJ','VYBER',500.00,31125.50,NULL,NULL,NULL);
insert into tab_trans values (5117,211652,718,'1996-7-31','PRIJEM','VKLAD',2100.00,33357.30,NULL,NULL,NULL);
insert into tab_trans values (5117,211653,718,'1996-8-30','VYDAJ','VYBER',18000.00,56259.30,NULL,NULL,NULL);
insert into tab_trans values (5117,211654,718,'1996-9-3','VYDAJ','VYBER',49800.00,55729.40,NULL,NULL,NULL);
insert into tab_trans values (5117,211655,718,'1996-9-29','VYDAJ','VYBER',5300.00,50429.40,NULL,NULL,NULL);
insert into tab_trans values (5117,211656,718,'1996-10-29','VYDAJ','VYBER',1800.00,41777.10,NULL,NULL,NULL);
insert into tab_trans values (5117,211657,718,'1996-11-28','PRIJEM','VKLAD',10100.00,31485.10,NULL,NULL,NULL);
insert into tab_trans values (5117,211658,718,'1996-12-28','PRIJEM','VKLAD',20800.00,25101.00,NULL,NULL,NULL);
insert into tab_trans values (5117,211659,718,'1997-1-27','PRIJEM','VKLAD',6100.00,36199.60,NULL,NULL,NULL);
insert into tab_trans values (5117,211660,718,'1997-2-26','PRIJEM','VKLAD',12700.00,33254.80,NULL,NULL,NULL);
insert into tab_trans values (5117,211661,718,'1997-3-28','PRIJEM','VKLAD',16400.00,29867.70,NULL,NULL,NULL);
insert into tab_trans values (5117,211662,718,'1997-4-27','PRIJEM','VKLAD',20200.00,29456.20,NULL,NULL,NULL);
insert into tab_trans values (5117,211663,718,'1997-5-27','PRIJEM','VKLAD',21400.00,31843.90,NULL,NULL,NULL);
insert into tab_trans values (5117,211664,718,'1997-6-26','PRIJEM','VKLAD',18100.00,33330.50,NULL,NULL,NULL);
insert into tab_trans values (5117,211665,718,'1997-7-26','VYDAJ','VYBER',18200.00,74537.80,NULL,NULL,NULL);
insert into tab_trans values (5117,3554085,718,'1996-6-30','PRIJEM',NULL,39.50,31625.50,'UROK',NULL,NULL);
insert into tab_trans values (5117,3554086,718,'1996-7-31','PRIJEM',NULL,131.80,31257.30,'UROK',NULL,NULL);
insert into tab_trans values (5117,3554087,718,'1996-8-31','PRIJEM',NULL,211.10,56470.40,'UROK',NULL,NULL);
insert into tab_trans values (5117,3554088,718,'1996-9-30','PRIJEM',NULL,410.70,50840.10,'UROK',NULL,NULL);
insert into tab_trans values (5117,3554089,718,'1996-10-31','PRIJEM',NULL,211.50,41988.70,'UROK',NULL,NULL);
insert into tab_trans values (5117,3554090,718,'1996-11-30','PRIJEM',NULL,119.60,31604.60,'UROK',NULL,NULL);
insert into tab_trans values (5117,3554091,718,'1996-12-31','PRIJEM',NULL,47.10,25148.20,'UROK',NULL,NULL);
insert into tab_trans values (5117,3554092,718,'1997-1-31','PRIJEM',NULL,158.90,46737.40,'UROK',NULL,NULL);
insert into tab_trans values (5117,3554093,718,'1997-2-28','PRIJEM',NULL,116.50,33371.30,'UROK',NULL,NULL);
insert into tab_trans values (5117,3554094,718,'1997-3-31','PRIJEM',NULL,92.00,29959.80,'UROK',NULL,NULL);
insert into tab_trans values (5117,3554095,718,'1997-4-30','PRIJEM',NULL,91.40,29547.50,'UROK',NULL,NULL);
insert into tab_trans values (5117,3554096,718,'1997-5-31','PRIJEM',NULL,89.20,31933.10,'UROK',NULL,NULL);
insert into tab_trans values (5117,3554097,718,'1997-6-30','PRIJEM',NULL,106.90,33437.40,'UROK',NULL,NULL);
insert into tab_trans values (5117,3554098,718,'1997-7-31','PRIJEM',NULL,241.30,74779.00,'UROK',NULL,NULL);
insert into tab_trans values (5124,230565,785,'1997-8-9','PRIJEM','VKLAD',700.00,700.00,NULL,NULL,NULL);
insert into tab_trans values (5124,230573,785,'1997-8-12','PRIJEM','PREVOD Z UCTU',26015.00,26715.00,NULL,'YZ','27742272');
insert into tab_trans values (5124,230574,785,'1997-9-12','PRIJEM','PREVOD Z UCTU',26015.00,53101.80,NULL,'YZ','27742272');
insert into tab_trans values (5124,230575,785,'1997-10-12','PRIJEM','PREVOD Z UCTU',26015.00,68897.80,NULL,'YZ','27742272');
insert into tab_trans values (5124,230576,785,'1997-11-12','PRIJEM','PREVOD Z UCTU',26015.00,74876.50,NULL,'YZ','27742272');
insert into tab_trans values (5124,230577,785,'1997-12-12','PRIJEM','PREVOD Z UCTU',39022.00,93801.30,NULL,'YZ','27742272');
insert into tab_trans values (5124,230578,785,'1998-1-12','PRIJEM','PREVOD Z UCTU',26015.00,62775.40,NULL,'YZ','27742272');
insert into tab_trans values (5124,230601,785,'1997-12-16','VYDAJ','VYBER',5300.00,88501.30,NULL,NULL,'0');
insert into tab_trans values (5124,230602,785,'1998-1-11','VYDAJ','VYBER',2900.00,36760.40,NULL,NULL,'0');
insert into tab_trans values (5124,230626,785,'1998-1-8','VYDAJ','PREVOD NA UCET',7395.00,39660.40,'SIPO','CD','69687145');
insert into tab_trans values (5124,230627,785,'1998-2-8','VYDAJ','PREVOD NA UCET',7395.00,28471.90,'SIPO','CD','69687145');
insert into tab_trans values (5124,230642,785,'1997-12-18','VYBER','VYBER',16432.00,72069.30,NULL,NULL,NULL);
insert into tab_trans values (5124,230652,785,'1997-12-28','VYDAJ','VYBER',8400.00,63669.30,NULL,NULL,NULL);
insert into tab_trans values (5124,230660,785,'1998-1-13','VYDAJ','VYBER',2700.00,60075.40,NULL,NULL,NULL);
insert into tab_trans values (5124,230661,785,'1998-1-23','VYDAJ','VYBER',5400.00,54675.40,NULL,NULL,NULL);
insert into tab_trans values (5124,230662,785,'1998-1-29','VYDAJ','VYBER',8100.00,39075.40,NULL,NULL,NULL);
insert into tab_trans values (5124,230663,785,'1998-1-25','VYDAJ','VYBER',2400.00,47175.40,NULL,NULL,NULL);
insert into tab_trans values (5124,230664,785,'1998-1-25','VYDAJ','VYBER',5100.00,49575.40,NULL,NULL,NULL);
insert into tab_trans values (5124,230665,785,'1998-1-2','VYDAJ','VYBER',7800.00,56155.40,NULL,NULL,NULL);
insert into tab_trans values (5124,230689,785,'1997-12-31','VYDAJ','VYBER',30.00,63955.40,'SLUZBY',NULL,NULL);
insert into tab_trans values (5124,230690,785,'1998-1-31','VYDAJ','VYBER',30.00,39266.90,'SLUZBY',NULL,NULL);
insert into tab_trans values (5124,230701,785,'1997-9-8','PRIJEM','VKLAD',300.00,27086.80,NULL,NULL,NULL);
insert into tab_trans values (5124,230702,785,'1997-10-8','VYDAJ','VYBER',10400.00,42882.80,NULL,NULL,NULL);
insert into tab_trans values (5124,230703,785,'1997-11-7','VYDAJ','VYBER',20300.00,48861.50,NULL,NULL,NULL);
insert into tab_trans values (5124,230704,785,'1997-12-7','VYDAJ','VYBER',20400.00,54779.30,NULL,NULL,NULL);
insert into tab_trans values (5124,230705,785,'1998-1-6','VYDAJ','VYBER',9100.00,47055.40,NULL,NULL,NULL);
insert into tab_trans values (5124,230706,785,'1998-2-5','VYDAJ','VYBER',3400.00,35866.90,NULL,NULL,NULL);
insert into tab_trans values (5124,3556156,785,'1997-8-31','PRIJEM',NULL,71.80,26786.80,'UROK',NULL,NULL);
insert into tab_trans values (5124,3556157,785,'1997-9-30','PRIJEM',NULL,180.90,53282.80,'UROK',NULL,NULL);
insert into tab_trans values (5124,3556158,785,'1997-10-31','PRIJEM',NULL,263.70,69161.50,'UROK',NULL,NULL);
insert into tab_trans values (5124,3556159,785,'1997-11-30','PRIJEM',NULL,302.80,75179.30,'UROK',NULL,NULL);
insert into tab_trans values (5124,3556160,785,'1997-12-31','PRIJEM',NULL,316.10,63985.40,'UROK',NULL,NULL);
insert into tab_trans values (5124,3556161,785,'1998-1-31','PRIJEM',NULL,221.60,39296.90,'UROK',NULL,NULL);
insert into tab_trans values (5125,231709,789,'1995-2-6','PRIJEM','VKLAD',500.00,500.00,NULL,NULL,NULL);
insert into tab_trans values (5125,231711,789,'1995-2-12','PRIJEM','VKLAD',5692.00,6192.00,NULL,NULL,NULL);
insert into tab_trans values (5125,231712,789,'1995-3-12','PRIJEM','VKLAD',5692.00,19799.70,NULL,NULL,NULL);
insert into tab_trans values (5125,231713,789,'1995-4-12','PRIJEM','VKLAD',5692.00,28154.00,NULL,NULL,NULL);
insert into tab_trans values (5125,231714,789,'1995-5-12','PRIJEM','VKLAD',5692.00,32750.60,NULL,NULL,NULL);
insert into tab_trans values (5125,231715,789,'1995-6-12','PRIJEM','VKLAD',8538.00,33418.20,NULL,NULL,NULL);
insert into tab_trans values (5125,231716,789,'1995-7-12','PRIJEM','VKLAD',5692.00,27038.80,NULL,NULL,NULL);
insert into tab_trans values (5125,231717,789,'1995-8-12','PRIJEM','VKLAD',5692.00,25435.70,NULL,NULL,NULL);
insert into tab_trans values (5125,231718,789,'1995-9-12','PRIJEM','VKLAD',5692.00,25379.60,NULL,NULL,NULL);
insert into tab_trans values (5125,231719,789,'1995-10-12','PRIJEM','VKLAD',5692.00,24364.30,NULL,NULL,NULL);
insert into tab_trans values (5125,231720,789,'1995-11-12','PRIJEM','VKLAD',5692.00,21545.70,NULL,NULL,NULL);
insert into tab_trans values (5125,231764,789,'1995-7-11','VYDAJ','PREVOD NA UCET',2153.00,21346.80,'SIPO','OP','64140730');
insert into tab_trans values (5125,231765,789,'1995-8-11','VYDAJ','PREVOD NA UCET',2153.00,19743.70,'SIPO','OP','64140730');
insert into tab_trans values (5125,231766,789,'1995-9-11','VYDAJ','PREVOD NA UCET',2153.00,19687.60,'SIPO','OP','64140730');
insert into tab_trans values (5125,231767,789,'1995-10-11','VYDAJ','PREVOD NA UCET',2153.00,18672.30,'SIPO','OP','64140730');
insert into tab_trans values (5125,231768,789,'1995-11-11','VYDAJ','PREVOD NA UCET',2153.00,15853.70,'SIPO','OP','64140730');
insert into tab_trans values (5125,231812,789,'1995-7-5','VYDAJ','PREVOD NA UCET',1641.00,30599.80,NULL,'OP','84300315');
insert into tab_trans values (5125,231813,789,'1995-8-5','VYDAJ','PREVOD NA UCET',1641.00,21896.70,NULL,'OP','84300315');
insert into tab_trans values (5125,231814,789,'1995-9-5','VYDAJ','PREVOD NA UCET',1641.00,21840.60,NULL,'OP','84300315');
insert into tab_trans values (5125,231815,789,'1995-10-5','VYDAJ','PREVOD NA UCET',1641.00,22125.30,NULL,'OP','84300315');
insert into tab_trans values (5125,231816,789,'1995-11-5','VYDAJ','PREVOD NA UCET',1641.00,18006.70,NULL,'OP','84300315');
insert into tab_trans values (5125,231859,789,'1995-6-11','VYDAJ','VYBER',1300.00,24880.20,NULL,NULL,'0');
insert into tab_trans values (5125,231860,789,'1995-7-3','VYDAJ','VYBER',1300.00,32240.80,NULL,NULL,'0');
insert into tab_trans values (5125,231861,789,'1995-8-15','VYDAJ','VYBER',1200.00,24235.70,NULL,NULL,'0');
insert into tab_trans values (5125,231862,789,'1995-9-4','VYDAJ','VYBER',1500.00,23481.60,NULL,NULL,'0');
insert into tab_trans values (5125,231863,789,'1995-10-5','VYDAJ','VYBER',1300.00,20825.30,NULL,NULL,'0');
insert into tab_trans values (5125,231864,789,'1995-10-24','VYDAJ','VYBER',1400.00,22964.30,NULL,NULL,'0');
insert into tab_trans values (5125,231933,789,'1995-9-3','VYDAJ','VYBER',840.00,23481.60,NULL,NULL,NULL);
insert into tab_trans values (5125,231958,789,'1995-6-30','VYDAJ','VYBER',14.60,33540.80,'SLUZBY',NULL,NULL);
insert into tab_trans values (5125,231959,789,'1995-7-31','VYDAJ','VYBER',14.60,27137.70,'SLUZBY',NULL,NULL);
insert into tab_trans values (5125,231960,789,'1995-8-31','VYDAJ','VYBER',14.60,24321.60,'SLUZBY',NULL,NULL);
insert into tab_trans values (5125,231961,789,'1995-9-30','VYDAJ','VYBER',14.60,25466.30,'SLUZBY',NULL,NULL);
insert into tab_trans values (5125,231962,789,'1995-10-31','VYDAJ','VYBER',14.60,23047.70,'SLUZBY',NULL,NULL);
insert into tab_trans values (5125,232000,789,'1995-3-8','PRIJEM','VKLAD',7900.00,14107.70,NULL,NULL,NULL);
insert into tab_trans values (5125,232001,789,'1995-4-7','PRIJEM','VKLAD',2600.00,22462.00,NULL,NULL,NULL);
insert into tab_trans values (5125,232002,789,'1995-5-7','VYDAJ','VYBER',1200.00,27058.60,NULL,NULL,NULL);
insert into tab_trans values (5125,232003,789,'1995-6-6','VYDAJ','VYBER',6700.00,26180.20,NULL,NULL,NULL);
insert into tab_trans values (5125,232004,789,'1995-7-6','VYDAJ','VYBER',7100.00,23499.80,NULL,NULL,NULL);
insert into tab_trans values (5125,232005,789,'1995-8-5','VYDAJ','VYBER',3600.00,23537.70,NULL,NULL,NULL);
insert into tab_trans values (5125,232006,789,'1995-9-4','PRIJEM','VKLAD',1500.00,24981.60,NULL,NULL,NULL);
insert into tab_trans values (5125,232007,789,'1995-10-4','VYDAJ','VYBER',1700.00,23766.30,NULL,NULL,NULL);
insert into tab_trans values (5125,232008,789,'1995-11-3','VYDAJ','VYBER',3400.00,19647.70,NULL,NULL,NULL);
insert into tab_trans values (5125,3556302,789,'1995-2-28','PRIJEM',NULL,15.70,6207.70,'UROK',NULL,NULL);
insert into tab_trans values (5125,3556303,789,'1995-3-31','PRIJEM',NULL,62.40,19862.00,'UROK',NULL,NULL);
insert into tab_trans values (5125,3556304,789,'1995-4-30','PRIJEM',NULL,104.50,28258.60,'UROK',NULL,NULL);
insert into tab_trans values (5125,3556305,789,'1995-5-31','PRIJEM',NULL,129.70,32880.20,'UROK',NULL,NULL);
insert into tab_trans values (5125,3556306,789,'1995-6-30','PRIJEM',NULL,137.10,33555.40,'UROK',NULL,NULL);
insert into tab_trans values (5125,3556307,789,'1995-7-31','PRIJEM',NULL,113.50,27152.30,'UROK',NULL,NULL);
insert into tab_trans values (5125,3556308,789,'1995-8-31','PRIJEM',NULL,100.50,24336.20,'UROK',NULL,NULL);
insert into tab_trans values (5125,3556309,789,'1995-9-30','PRIJEM',NULL,101.30,25480.90,'UROK',NULL,NULL);
insert into tab_trans values (5125,3556310,789,'1995-10-31','PRIJEM',NULL,98.00,23062.30,'UROK',NULL,NULL);
insert into tab_trans values (5126,232062,790,'1993-5-11','PRIJEM','VKLAD',300.00,300.00,NULL,NULL,NULL);
insert into tab_trans values (5126,232065,790,'1993-12-5','PRIJEM','VKLAD',37604.00,92167.40,NULL,NULL,NULL);
insert into tab_trans values (5126,232067,790,'1993-11-13','PRIJEM','VKLAD',14803.00,59430.10,NULL,NULL,NULL);
insert into tab_trans values (5126,232069,790,'1993-6-21','PRIJEM','VKLAD',32699.00,42599.00,NULL,NULL,NULL);
insert into tab_trans values (5126,232070,790,'1993-7-6','PRIJEM','VKLAD',5459.00,48117.20,NULL,NULL,NULL);
insert into tab_trans values (5126,232071,790,'1993-10-8','PRIJEM','VKLAD',20509.00,96064.00,NULL,NULL,NULL);
insert into tab_trans values (5126,232072,790,'1993-9-27','PRIJEM','VKLAD',45360.00,75383.80,NULL,NULL,NULL);
insert into tab_trans values (5126,232073,790,'1994-4-28','PRIJEM','VKLAD',29993.00,43039.60,NULL,NULL,NULL);
insert into tab_trans values (5126,232075,790,'1994-7-21','PRIJEM','VKLAD',38929.00,81474.60,NULL,NULL,NULL);
insert into tab_trans values (5126,232076,790,'1994-6-26','PRIJEM','VKLAD',25970.00,53075.20,NULL,NULL,NULL);
insert into tab_trans values (5126,232077,790,'1994-7-1','PRIJEM','VKLAD',8843.00,58445.60,NULL,NULL,NULL);
insert into tab_trans values (5126,232079,790,'1994-1-14','PRIJEM','VKLAD',47493.00,48159.90,NULL,NULL,NULL);
insert into tab_trans values (5126,232142,790,'1993-12-15','VYDAJ','VYBER',5800.00,42867.40,NULL,NULL,'0');
insert into tab_trans values (5126,232143,790,'1994-1-12','VYDAJ','VYBER',5700.00,666.90,NULL,NULL,'0');
insert into tab_trans values (5126,232144,790,'1994-2-13','VYDAJ','VYBER',3700.00,22475.10,NULL,NULL,'0');
insert into tab_trans values (5126,232145,790,'1994-3-6','VYDAJ','VYBER',2600.00,-1069.70,NULL,NULL,'0');
insert into tab_trans values (5126,232146,790,'1994-4-20','VYDAJ','VYBER',3500.00,13046.60,NULL,NULL,'0');
insert into tab_trans values (5126,232147,790,'1994-5-8','VYDAJ','VYBER',4300.00,30580.70,NULL,NULL,'0');
insert into tab_trans values (5126,232148,790,'1994-6-4','VYDAJ','VYBER',3600.00,27105.20,NULL,NULL,'0');
insert into tab_trans values (5126,232149,790,'1994-6-28','VYDAJ','VYBER',3600.00,49475.20,NULL,NULL,'0');
insert into tab_trans values (5126,232218,790,'1994-2-16','VYBER','VYBER',20995.00,1480.10,NULL,NULL,NULL);
insert into tab_trans values (5126,232252,790,'1994-1-5','VYDAJ','VYBER',29400.00,13666.90,NULL,NULL,NULL);
insert into tab_trans values (5126,232257,790,'1993-12-13','VYDAJ','VYBER',8700.00,48667.40,NULL,NULL,NULL);
insert into tab_trans values (5126,232269,790,'1994-1-8','VYDAJ','VYBER',6900.00,12666.90,NULL,NULL,NULL);
insert into tab_trans values (5126,232270,790,'1994-1-9','VYDAJ','VYBER',4500.00,8166.90,NULL,NULL,NULL);
insert into tab_trans values (5126,232271,790,'1994-1-10','VYDAJ','VYBER',1800.00,6366.90,NULL,NULL,NULL);
insert into tab_trans values (5126,232272,790,'1994-1-17','VYDAJ','VYBER',6000.00,42159.90,NULL,NULL,NULL);
insert into tab_trans values (5126,232273,790,'1994-1-23','VYDAJ','VYBER',7200.00,34959.90,NULL,NULL,NULL);
insert into tab_trans values (5126,232274,790,'1994-1-26','VYDAJ','VYBER',6000.00,28959.90,NULL,NULL,NULL);
insert into tab_trans values (5126,232300,790,'1993-12-4','VYDAJ','VYBER',5100.00,54563.40,NULL,NULL,NULL);
insert into tab_trans values (5126,232339,790,'1993-11-30','VYDAJ','VYBER',14.60,59663.40,'SLUZBY',NULL,NULL);
insert into tab_trans values (5126,232340,790,'1993-12-31','VYDAJ','VYBER',14.60,43066.90,'SLUZBY',NULL,NULL);
insert into tab_trans values (5126,232341,790,'1994-1-31','VYDAJ','VYBER',14.60,29075.10,'SLUZBY',NULL,NULL);
insert into tab_trans values (5126,232342,790,'1994-2-28','VYDAJ','VYBER',14.60,1530.30,'SLUZBY',NULL,NULL);
insert into tab_trans values (5126,232343,790,'1994-3-31','VYDAJ','VYBER',14.60,8846.60,'SLUZBY',NULL,NULL);
insert into tab_trans values (5126,232344,790,'1994-4-30','VYDAJ','VYBER',14.60,43080.70,'SLUZBY',NULL,NULL);
insert into tab_trans values (5126,232345,790,'1994-5-31','VYDAJ','VYBER',14.60,30705.20,'SLUZBY',NULL,NULL);
insert into tab_trans values (5126,232346,790,'1994-6-30','VYDAJ','VYBER',14.60,49602.60,'SLUZBY',NULL,NULL);
insert into tab_trans values (5126,232400,790,'1993-6-10','PRIJEM','VKLAD',9600.00,9900.00,NULL,NULL,NULL);
insert into tab_trans values (5126,232401,790,'1993-7-10','VYDAJ','VYBER',12300.00,35817.20,NULL,NULL,NULL);
insert into tab_trans values (5126,232402,790,'1993-8-9','VYDAJ','VYBER',5300.00,30674.60,NULL,NULL,NULL);
insert into tab_trans values (5126,232403,790,'1993-9-8','VYDAJ','VYBER',800.00,30023.80,NULL,NULL,NULL);
insert into tab_trans values (5126,232404,790,'1993-10-8','VYDAJ','VYBER',36500.00,59564.00,NULL,NULL,NULL);
insert into tab_trans values (5126,232405,790,'1993-11-7','VYDAJ','VYBER',15200.00,44627.10,NULL,NULL,NULL);
insert into tab_trans values (5126,232406,790,'1993-12-7','VYDAJ','VYBER',34800.00,57367.40,NULL,NULL,NULL);
insert into tab_trans values (5126,232407,790,'1994-1-6','PRIJEM','VKLAD',5900.00,19566.90,NULL,NULL,NULL);
insert into tab_trans values (5126,232408,790,'1994-2-5','VYDAJ','VYBER',2900.00,26175.10,NULL,NULL,NULL);
insert into tab_trans values (5126,232409,790,'1994-3-7','PRIJEM','VKLAD',9900.00,8830.30,NULL,NULL,NULL);
insert into tab_trans values (5126,232410,790,'1994-4-6','PRIJEM','VKLAD',7700.00,16546.60,NULL,NULL,NULL);
insert into tab_trans values (5126,232411,790,'1994-5-6','VYDAJ','VYBER',8200.00,34880.70,NULL,NULL,NULL);
insert into tab_trans values (5126,232412,790,'1994-7-5','VYDAJ','VYBER',15900.00,42545.60,NULL,NULL,NULL);
insert into tab_trans values (5126,3445872,790,'1993-6-30','PRIJEM',NULL,59.20,42658.20,'UROK',NULL,NULL);
insert into tab_trans values (5126,3445873,790,'1993-7-31','PRIJEM',NULL,157.40,35974.60,'UROK',NULL,NULL);
insert into tab_trans values (5126,3445874,790,'1993-8-31','PRIJEM',NULL,149.20,30823.80,'UROK',NULL,NULL);
insert into tab_trans values (5126,3445875,790,'1993-9-30','PRIJEM',NULL,171.20,75555.00,'UROK',NULL,NULL);
insert into tab_trans values (5126,3445876,790,'1993-10-31','PRIJEM',NULL,263.10,59827.10,'UROK',NULL,NULL);
insert into tab_trans values (5126,3445877,790,'1993-11-30','PRIJEM',NULL,247.90,59678.00,'UROK',NULL,NULL);
insert into tab_trans values (5126,3445878,790,'1993-12-31','PRIJEM',NULL,214.20,43081.50,'UROK',NULL,NULL);
insert into tab_trans values (5126,3445879,790,'1994-1-31','PRIJEM',NULL,129.70,29089.70,'UROK',NULL,NULL);
insert into tab_trans values (5126,3445880,790,'1994-2-28','PRIJEM',NULL,64.80,1544.90,'UROK',NULL,NULL);
insert into tab_trans values (5126,3445881,790,'1994-3-31','PRIJEM',NULL,30.90,8861.20,'UROK',NULL,NULL);
insert into tab_trans values (5126,3445882,790,'1994-4-30','PRIJEM',NULL,55.70,43095.30,'UROK',NULL,NULL);
insert into tab_trans values (5126,3445883,790,'1994-5-31','PRIJEM',NULL,139.20,30719.80,'UROK',NULL,NULL);
insert into tab_trans values (5126,3445884,790,'1994-6-30','PRIJEM',NULL,141.90,49617.20,'UROK',NULL,NULL);
insert into tab_trans values (5128,236452,808,'1995-6-13','PRIJEM','VKLAD',200.00,200.00,NULL,NULL,NULL);
insert into tab_trans values (5128,236459,808,'1995-7-7','PRIJEM','VKLAD',15420.00,15620.00,NULL,NULL,NULL);
insert into tab_trans values (5128,236460,808,'1995-8-7','PRIJEM','VKLAD',15420.00,32526.90,NULL,NULL,NULL);
insert into tab_trans values (5128,236461,808,'1995-9-7','PRIJEM','VKLAD',15420.00,42240.30,NULL,NULL,NULL);
insert into tab_trans values (5128,236462,808,'1995-10-7','PRIJEM','VKLAD',15420.00,50124.80,NULL,NULL,NULL);
insert into tab_trans values (5128,236463,808,'1995-11-7','PRIJEM','VKLAD',15420.00,48544.70,NULL,NULL,NULL);
insert into tab_trans values (5128,236464,808,'1995-12-7','PRIJEM','VKLAD',23130.00,43230.40,NULL,NULL,NULL);
insert into tab_trans values (5128,236465,808,'1996-1-7','PRIJEM','VKLAD',15420.00,31461.20,NULL,NULL,NULL);
insert into tab_trans values (5128,236466,808,'1996-2-7','PRIJEM','VKLAD',15420.00,28454.50,NULL,NULL,NULL);
insert into tab_trans values (5128,236467,808,'1996-3-7','PRIJEM','VKLAD',15420.00,28275.40,NULL,NULL,NULL);
insert into tab_trans values (5128,236468,808,'1996-4-7','PRIJEM','VKLAD',15420.00,12040.60,NULL,NULL,NULL);
insert into tab_trans values (5128,236512,808,'1995-11-30','VYDAJ','VYBER',10000.00,20100.40,'SIPO',NULL,'0');
insert into tab_trans values (5128,236513,808,'1996-1-14','VYDAJ','VYBER',11600.00,15421.20,'SIPO',NULL,'0');
insert into tab_trans values (5128,236514,808,'1996-2-9','VYDAJ','VYBER',7200.00,17154.50,'SIPO',NULL,'0');
insert into tab_trans values (5128,236515,808,'1996-3-9','VYDAJ','VYBER',11700.00,8275.40,'SIPO',NULL,'0');
insert into tab_trans values (5128,236516,808,'1996-3-27','VYDAJ','VYBER',11700.00,-3424.60,'SIPO',NULL,'0');
insert into tab_trans values (5128,236559,808,'1995-11-5','VYDAJ','VYBER',4200.00,33124.70,NULL,NULL,'0');
insert into tab_trans values (5128,236560,808,'1995-12-18','VYDAJ','VYBER',3200.00,27930.40,NULL,NULL,'0');
insert into tab_trans values (5128,236561,808,'1996-1-2','VYDAJ','VYBER',4600.00,16041.20,NULL,NULL,'0');
insert into tab_trans values (5128,236562,808,'1996-2-18','VYDAJ','VYBER',4400.00,12754.50,NULL,NULL,'0');
insert into tab_trans values (5128,236563,808,'1996-3-9','VYDAJ','VYBER',4700.00,23575.40,NULL,NULL,'0');
insert into tab_trans values (5128,236605,808,'1995-12-26','VYDAJ','VYBER',2080.00,25850.40,NULL,NULL,NULL);
insert into tab_trans values (5128,236616,808,'1996-1-9','VYDAJ','VYBER',840.00,30621.20,NULL,NULL,NULL);
insert into tab_trans values (5128,236618,808,'1996-1-15','VYDAJ','VYBER',960.00,14461.20,NULL,NULL,NULL);
insert into tab_trans values (5128,236619,808,'1996-1-24','VYDAJ','VYBER',1560.00,12901.20,NULL,NULL,NULL);
insert into tab_trans values (5128,236634,808,'1995-12-27','VYDAJ','VYBER',5400.00,20450.40,NULL,NULL,NULL);
insert into tab_trans values (5128,236663,808,'1995-11-30','VYDAJ','VYBER',14.60,30100.40,'SLUZBY',NULL,NULL);
insert into tab_trans values (5128,236664,808,'1995-12-31','VYDAJ','VYBER',14.60,20641.20,'SLUZBY',NULL,NULL);
insert into tab_trans values (5128,236665,808,'1996-1-31','VYDAJ','VYBER',14.60,13034.50,'SLUZBY',NULL,NULL);
insert into tab_trans values (5128,236666,808,'1996-2-29','VYDAJ','VYBER',14.60,12855.40,'SLUZBY',NULL,NULL);
insert into tab_trans values (5128,236667,808,'1996-3-31','VYDAJ','VYBER',14.60,-3365.80,'SLUZBY',NULL,NULL);
insert into tab_trans values (5128,236700,808,'1995-7-13','PRIJEM','VKLAD',1400.00,17020.00,NULL,NULL,NULL);
insert into tab_trans values (5128,236701,808,'1995-8-12','VYDAJ','VYBER',5900.00,26626.90,NULL,NULL,NULL);
insert into tab_trans values (5128,236702,808,'1995-9-11','VYDAJ','VYBER',7800.00,34440.30,NULL,NULL,NULL);
insert into tab_trans values (5128,236703,808,'1995-10-11','VYDAJ','VYBER',13100.00,37024.80,NULL,NULL,NULL);
insert into tab_trans values (5128,236704,808,'1995-11-10','VYDAJ','VYBER',18700.00,29844.70,NULL,NULL,NULL);
insert into tab_trans values (5128,236705,808,'1995-12-10','VYDAJ','VYBER',12100.00,31130.40,NULL,NULL,NULL);
insert into tab_trans values (5128,236706,808,'1996-1-9','VYDAJ','VYBER',3600.00,27021.20,NULL,NULL,NULL);
insert into tab_trans values (5128,236707,808,'1996-2-8','VYDAJ','VYBER',4100.00,24354.50,NULL,NULL,NULL);
insert into tab_trans values (5128,236708,808,'1996-3-9','VYDAJ','VYBER',3600.00,19975.40,NULL,NULL,NULL);
insert into tab_trans values (5128,236709,808,'1996-4-8','VYDAJ','VYBER',3400.00,8640.60,NULL,NULL,NULL);
insert into tab_trans values (5128,3446008,808,'1995-7-31','PRIJEM',NULL,43.50,17063.50,'UROK',NULL,NULL);
insert into tab_trans values (5128,3446009,808,'1995-8-31','PRIJEM',NULL,96.60,26723.50,'UROK',NULL,NULL);
insert into tab_trans values (5128,3446010,808,'1995-9-30','PRIJEM',NULL,132.20,34572.40,'UROK',NULL,NULL);
insert into tab_trans values (5128,3446011,808,'1995-10-31','PRIJEM',NULL,149.80,37324.70,'UROK',NULL,NULL);
insert into tab_trans values (5128,3446012,808,'1995-11-30','PRIJEM',NULL,135.10,29979.80,'UROK',NULL,NULL);
insert into tab_trans values (5128,3446013,808,'1995-12-31','PRIJEM',NULL,102.70,20553.10,'UROK',NULL,NULL);
insert into tab_trans values (5128,3446014,808,'1996-1-31','PRIJEM',NULL,74.00,13049.10,'UROK',NULL,NULL);
insert into tab_trans values (5128,3446015,808,'1996-2-29','PRIJEM',NULL,57.70,12812.20,'UROK',NULL,NULL);
insert into tab_trans values (5128,3446016,808,'1996-3-31','PRIJEM',NULL,42.40,-3351.20,'UROK',NULL,NULL);
insert into tab_trans values (5128,3446017,808,'1996-3-31','VYDAJ','VYBER',6.80,-3372.60,'SANKC. UROK',NULL,NULL);
insert into tab_trans values (5128,3681270,808,'1995-7-31','PRIJEM',NULL,43.50,17106.90,'UROK',NULL,NULL);
insert into tab_trans values (5128,3681271,808,'1995-8-31','PRIJEM',NULL,96.70,26820.30,'UROK',NULL,NULL);
insert into tab_trans values (5128,3681272,808,'1995-9-30','PRIJEM',NULL,132.40,34704.80,'UROK',NULL,NULL);
insert into tab_trans values (5128,3681273,808,'1995-10-31','PRIJEM',NULL,150.00,37174.80,'UROK',NULL,NULL);
insert into tab_trans values (5128,3681274,808,'1995-11-30','PRIJEM',NULL,135.20,30115.00,'UROK',NULL,NULL);
insert into tab_trans values (5128,3681275,808,'1995-12-31','PRIJEM',NULL,102.70,20655.80,'UROK',NULL,NULL);
insert into tab_trans values (5128,3681276,808,'1996-1-31','PRIJEM',NULL,74.00,12975.20,'UROK',NULL,NULL);
insert into tab_trans values (5128,3681277,808,'1996-2-29','PRIJEM',NULL,57.70,12870.00,'UROK',NULL,NULL);
insert into tab_trans values (5128,3681278,808,'1996-3-31','PRIJEM',NULL,31.10,-3393.60,'UROK',NULL,NULL);
insert into tab_trans values (5128,3681279,808,'1996-3-31','VYDAJ','VYBER',6.80,-3379.40,'SANKC. UROK',NULL,NULL);
insert into tab_trans values (5130,237649,813,'1993-2-10','PRIJEM','VKLAD',1100.00,1100.00,NULL,NULL,NULL);
insert into tab_trans values (5130,237651,813,'1993-2-11','PRIJEM','PREVOD Z UCTU',12154.00,13254.00,NULL,'QR','19537103');
insert into tab_trans values (5130,237652,813,'1993-3-11','PRIJEM','PREVOD Z UCTU',12154.00,25443.50,NULL,'QR','19537103');
insert into tab_trans values (5130,237653,813,'1993-4-11','PRIJEM','PREVOD Z UCTU',12154.00,38387.40,NULL,'QR','19537103');
insert into tab_trans values (5130,237654,813,'1993-5-11','PRIJEM','PREVOD Z UCTU',12154.00,42684.30,NULL,'QR','19537103');
insert into tab_trans values (5130,237655,813,'1993-6-11','PRIJEM','PREVOD Z UCTU',18231.00,45087.30,NULL,'QR','19537103');
insert into tab_trans values (5130,237656,813,'1993-7-11','PRIJEM','PREVOD Z UCTU',12154.00,34856.50,NULL,'QR','19537103');
insert into tab_trans values (5130,237657,813,'1993-8-11','PRIJEM','PREVOD Z UCTU',12154.00,38911.10,NULL,'QR','19537103');
insert into tab_trans values (5130,237658,813,'1993-9-11','PRIJEM','PREVOD Z UCTU',12154.00,35730.20,NULL,'QR','19537103');
insert into tab_trans values (5130,237659,813,'1993-10-11','PRIJEM','PREVOD Z UCTU',12154.00,43802.20,NULL,'QR','19537103');
insert into tab_trans values (5130,237660,813,'1993-11-11','PRIJEM','PREVOD Z UCTU',12154.00,36928.50,NULL,'QR','19537103');
insert into tab_trans values (5130,237661,813,'1993-12-11','PRIJEM','PREVOD Z UCTU',18231.00,48277.90,NULL,'QR','19537103');
insert into tab_trans values (5130,237662,813,'1994-1-11','PRIJEM','PREVOD Z UCTU',12154.00,34990.60,NULL,'QR','19537103');
insert into tab_trans values (5130,237663,813,'1994-2-11','PRIJEM','PREVOD Z UCTU',12154.00,34250.40,NULL,'QR','19537103');
insert into tab_trans values (5130,237664,813,'1994-3-11','PRIJEM','PREVOD Z UCTU',12154.00,37714.80,NULL,'QR','19537103');
insert into tab_trans values (5130,237665,813,'1994-4-11','PRIJEM','PREVOD Z UCTU',12154.00,38537.10,NULL,'QR','19537103');
insert into tab_trans values (5130,237727,813,'1993-6-10','VYDAJ','VYBER',1700.00,26856.30,NULL,NULL,'0');
insert into tab_trans values (5130,237728,813,'1993-7-11','VYDAJ','VYBER',2100.00,32756.50,NULL,NULL,'0');
insert into tab_trans values (5130,237729,813,'1993-8-11','VYDAJ','VYBER',2300.00,36611.10,NULL,NULL,'0');
insert into tab_trans values (5130,237730,813,'1993-9-6','VYDAJ','VYBER',1900.00,22376.20,NULL,NULL,'0');
insert into tab_trans values (5130,237731,813,'1993-10-17','VYDAJ','VYBER',2000.00,41802.20,NULL,NULL,'0');
insert into tab_trans values (5130,237732,813,'1993-11-15','VYDAJ','VYBER',2500.00,34428.50,NULL,NULL,'0');
insert into tab_trans values (5130,237733,813,'1993-12-5','VYDAJ','VYBER',1300.00,33246.90,NULL,NULL,'0');
insert into tab_trans values (5130,237734,813,'1994-1-12','VYDAJ','VYBER',1600.00,33390.60,NULL,NULL,'0');
insert into tab_trans values (5130,237735,813,'1994-2-4','VYDAJ','VYBER',3000.00,20296.40,NULL,NULL,'0');
insert into tab_trans values (5130,237736,813,'1994-3-13','VYDAJ','VYBER',2600.00,35114.80,NULL,NULL,'0');
insert into tab_trans values (5130,237737,813,'1994-3-27','VYDAJ','VYBER',1700.00,29161.80,NULL,NULL,'0');
insert into tab_trans values (5130,237795,813,'1993-12-14','VYBER','VYBER',22444.00,25833.90,NULL,NULL,NULL);
insert into tab_trans values (5130,237796,813,'1993-6-22','VYBER','VYBER',24322.00,20765.30,NULL,NULL,NULL);
insert into tab_trans values (5130,237798,813,'1993-8-24','VYBER','VYBER',12449.00,24162.10,NULL,NULL,NULL);
insert into tab_trans values (5130,237799,813,'1993-10-27','VYBER','VYBER',15870.00,25932.20,NULL,NULL,NULL);
insert into tab_trans values (5130,237803,813,'1994-3-25','VYBER','VYBER',4253.00,30861.80,NULL,NULL,NULL);
insert into tab_trans values (5130,237842,813,'1993-12-18','VYDAJ','VYBER',4500.00,21333.90,NULL,NULL,NULL);
insert into tab_trans values (5130,237851,813,'1993-7-22','VYDAJ','VYBER',3900.00,28856.50,NULL,NULL,NULL);
insert into tab_trans values (5130,237853,813,'1994-3-4','VYDAJ','VYBER',11700.00,22660.80,NULL,NULL,NULL);
insert into tab_trans values (5130,237855,813,'1994-4-15','VYDAJ','VYBER',3600.00,34937.10,NULL,NULL,NULL);
insert into tab_trans values (5130,237857,813,'1994-1-30','VYDAJ','VYBER',10200.00,23190.60,NULL,NULL,NULL);
insert into tab_trans values (5130,237880,813,'1993-6-30','VYDAJ','VYBER',14.60,20902.50,'SLUZBY',NULL,NULL);
insert into tab_trans values (5130,237881,813,'1993-7-31','VYDAJ','VYBER',14.60,28957.10,'SLUZBY',NULL,NULL);
insert into tab_trans values (5130,237882,813,'1993-8-31','VYDAJ','VYBER',14.60,24276.20,'SLUZBY',NULL,NULL);
insert into tab_trans values (5130,237883,813,'1993-9-30','VYDAJ','VYBER',14.60,35848.20,'SLUZBY',NULL,NULL);
insert into tab_trans values (5130,237884,813,'1993-10-31','VYDAJ','VYBER',14.60,26074.50,'SLUZBY',NULL,NULL);
insert into tab_trans values (5130,237885,813,'1993-11-30','VYDAJ','VYBER',14.60,34546.90,'SLUZBY',NULL,NULL);
insert into tab_trans values (5130,237886,813,'1993-12-31','VYDAJ','VYBER',14.60,21436.60,'SLUZBY',NULL,NULL);
insert into tab_trans values (5130,237887,813,'1994-1-31','VYDAJ','VYBER',14.60,23296.40,'SLUZBY',NULL,NULL);
insert into tab_trans values (5130,237888,813,'1994-2-28','VYDAJ','VYBER',14.60,34360.80,'SLUZBY',NULL,NULL);
insert into tab_trans values (5130,237889,813,'1994-3-31','VYDAJ','VYBER',14.60,29283.10,'SLUZBY',NULL,NULL);
insert into tab_trans values (5130,237890,813,'1994-4-30','VYDAJ','VYBER',14.60,35061.90,'SLUZBY',NULL,NULL);
insert into tab_trans values (5130,237946,813,'1993-3-12','PRIJEM','VKLAD',700.00,26143.50,NULL,NULL,NULL);
insert into tab_trans values (5130,237947,813,'1993-4-11','VYDAJ','VYBER',8000.00,30387.40,NULL,NULL,NULL);
insert into tab_trans values (5130,237948,813,'1993-5-11','VYDAJ','VYBER',8300.00,34384.30,NULL,NULL,NULL);
insert into tab_trans values (5130,237949,813,'1993-6-10','VYDAJ','VYBER',6000.00,28556.30,NULL,NULL,NULL);
insert into tab_trans values (5130,237950,813,'1993-7-10','PRIJEM','VKLAD',1800.00,22702.50,NULL,NULL,NULL);
insert into tab_trans values (5130,237951,813,'1993-8-9','VYDAJ','VYBER',2200.00,26757.10,NULL,NULL,NULL);
insert into tab_trans values (5130,237952,813,'1993-9-8','PRIJEM','VKLAD',1200.00,23576.20,NULL,NULL,NULL);
insert into tab_trans values (5130,237953,813,'1993-10-8','VYDAJ','VYBER',4200.00,31648.20,NULL,NULL,NULL);
insert into tab_trans values (5130,237954,813,'1993-11-7','VYDAJ','VYBER',1300.00,24774.50,NULL,NULL,NULL);
insert into tab_trans values (5130,237955,813,'1993-12-7','VYDAJ','VYBER',3200.00,30046.90,NULL,NULL,NULL);
insert into tab_trans values (5130,237956,813,'1994-1-6','PRIJEM','VKLAD',1400.00,22836.60,NULL,NULL,NULL);
insert into tab_trans values (5130,237957,813,'1994-2-5','PRIJEM','VKLAD',1800.00,22096.40,NULL,NULL,NULL);
insert into tab_trans values (5130,237958,813,'1994-3-7','PRIJEM','VKLAD',2900.00,25560.80,NULL,NULL,NULL);
insert into tab_trans values (5130,237959,813,'1994-4-6','VYDAJ','VYBER',2900.00,26383.10,NULL,NULL,NULL);
insert into tab_trans values (5130,237960,813,'1994-5-6','VYDAJ','VYBER',6600.00,28461.90,NULL,NULL,NULL);
insert into tab_trans values (5130,3556862,813,'1993-2-28','PRIJEM',NULL,35.50,13289.50,'UROK',NULL,NULL);
insert into tab_trans values (5130,3556863,813,'1993-3-31','PRIJEM',NULL,89.90,26233.40,'UROK',NULL,NULL);
insert into tab_trans values (5130,3556864,813,'1993-4-30','PRIJEM',NULL,142.90,30530.30,'UROK',NULL,NULL);
insert into tab_trans values (5130,3556865,813,'1993-5-31','PRIJEM',NULL,172.00,34556.30,'UROK',NULL,NULL);
insert into tab_trans values (5130,3556866,813,'1993-6-30','PRIJEM',NULL,151.80,20917.10,'UROK',NULL,NULL);
insert into tab_trans values (5130,3556867,813,'1993-7-31','PRIJEM',NULL,115.20,28971.70,'UROK',NULL,NULL);
insert into tab_trans values (5130,3556868,813,'1993-8-31','PRIJEM',NULL,128.70,24290.80,'UROK',NULL,NULL);
insert into tab_trans values (5130,3556869,813,'1993-9-30','PRIJEM',NULL,132.50,35862.80,'UROK',NULL,NULL);
insert into tab_trans values (5130,3556870,813,'1993-10-31','PRIJEM',NULL,157.00,26089.10,'UROK',NULL,NULL);
insert into tab_trans values (5130,3556871,813,'1993-11-30','PRIJEM',NULL,133.00,34561.50,'UROK',NULL,NULL);
insert into tab_trans values (5130,3556872,813,'1993-12-31','PRIJEM',NULL,117.30,21451.20,'UROK',NULL,NULL);
insert into tab_trans values (5130,3556873,813,'1994-1-31','PRIJEM',NULL,120.30,23311.00,'UROK',NULL,NULL);
insert into tab_trans values (5130,3556874,813,'1994-2-28','PRIJEM',NULL,125.10,34375.40,'UROK',NULL,NULL);
insert into tab_trans values (5130,3556875,813,'1994-3-31','PRIJEM',NULL,135.80,29297.70,'UROK',NULL,NULL);
insert into tab_trans values (5130,3556876,813,'1994-4-30','PRIJEM',NULL,139.40,35076.50,'UROK',NULL,NULL);
insert into tab_trans values (5131,238688,816,'1993-8-5','PRIJEM','VKLAD',200.00,200.00,NULL,NULL,NULL);
insert into tab_trans values (5131,238691,816,'1993-9-9','PRIJEM','VKLAD',30827.00,53473.10,NULL,NULL,NULL);
insert into tab_trans values (5131,238693,816,'1993-8-23','PRIJEM','VKLAD',17225.00,17425.00,NULL,NULL,NULL);
insert into tab_trans values (5131,238703,816,'1993-12-9','PRIJEM','VKLAD',10560.00,47362.40,NULL,NULL,NULL);
insert into tab_trans values (5131,238705,816,'1993-10-2','PRIJEM','VKLAD',41561.00,95216.80,NULL,NULL,NULL);
insert into tab_trans values (5131,238707,816,'1994-12-4','PRIJEM','VKLAD',9203.00,91336.40,NULL,NULL,NULL);
insert into tab_trans values (5131,238708,816,'1994-11-22','PRIJEM','VKLAD',12702.00,107112.40,NULL,NULL,NULL);
insert into tab_trans values (5131,238709,816,'1994-8-14','PRIJEM','VKLAD',17836.00,46168.60,NULL,NULL,NULL);
insert into tab_trans values (5131,238710,816,'1994-9-11','PRIJEM','VKLAD',29344.00,86032.80,NULL,NULL,NULL);
insert into tab_trans values (5131,238711,816,'1994-12-17','PRIJEM','VKLAD',23058.00,134187.40,NULL,NULL,NULL);
insert into tab_trans values (5131,238712,816,'1994-1-15','PRIJEM','VKLAD',35319.00,73390.70,NULL,NULL,NULL);
insert into tab_trans values (5131,238713,816,'1994-3-5','PRIJEM','VKLAD',22630.00,70776.70,NULL,NULL,NULL);
insert into tab_trans values (5131,238714,816,'1994-12-15','PRIJEM','VKLAD',38607.00,111129.40,NULL,NULL,NULL);
insert into tab_trans values (5131,238715,816,'1994-8-25','PRIJEM','VKLAD',26486.00,72654.60,NULL,NULL,NULL);
insert into tab_trans values (5131,238716,816,'1994-3-5','PRIJEM','VKLAD',21740.00,92516.70,NULL,NULL,NULL);
insert into tab_trans values (5131,238717,816,'1994-1-21','PRIJEM','VKLAD',40562.00,131627.70,NULL,NULL,NULL);
insert into tab_trans values (5131,238718,816,'1994-10-26','PRIJEM','VKLAD',21264.00,78088.30,NULL,NULL,NULL);
insert into tab_trans values (5131,238719,816,'1994-8-28','PRIJEM','VKLAD',16871.00,89525.60,NULL,NULL,NULL);
insert into tab_trans values (5131,238720,816,'1994-5-16','PRIJEM','VKLAD',38432.00,93384.20,NULL,NULL,NULL);
insert into tab_trans values (5131,238721,816,'1994-11-20','PRIJEM','VKLAD',39836.00,94410.40,NULL,NULL,NULL);
insert into tab_trans values (5131,238722,816,'1994-11-11','PRIJEM','VKLAD',6166.00,54574.40,NULL,NULL,NULL);
insert into tab_trans values (5131,238723,816,'1994-3-7','PRIJEM','VKLAD',28864.00,121380.70,NULL,NULL,NULL);
insert into tab_trans values (5131,238724,816,'1994-5-3','PRIJEM','VKLAD',37253.00,59466.20,NULL,NULL,NULL);
insert into tab_trans values (5131,238725,816,'1994-1-19','PRIJEM','VKLAD',37175.00,96465.70,NULL,NULL,NULL);
insert into tab_trans values (5131,238726,816,'1994-7-20','PRIJEM','VKLAD',8803.00,44662.00,NULL,NULL,NULL);
insert into tab_trans values (5131,238727,816,'1994-6-2','PRIJEM','VKLAD',21882.00,84156.60,NULL,NULL,NULL);
insert into tab_trans values (5131,238728,816,'1994-12-3','PRIJEM','VKLAD',12950.00,82133.40,NULL,NULL,NULL);
insert into tab_trans values (5131,238729,816,'1994-3-12','PRIJEM','VKLAD',30315.00,105881.70,NULL,NULL,NULL);
insert into tab_trans values (5131,238730,816,'1994-9-28','PRIJEM','VKLAD',8807.00,92739.80,NULL,NULL,NULL);
insert into tab_trans values (5131,238731,816,'1994-2-5','PRIJEM','VKLAD',37606.00,90007.60,NULL,NULL,NULL);
insert into tab_trans values (5131,238823,816,'1994-2-11','VYDAJ','VYBER',1800.00,83693.60,NULL,NULL,'0');
insert into tab_trans values (5131,238824,816,'1994-3-25','VYDAJ','VYBER',2600.00,44081.70,NULL,NULL,'0');
insert into tab_trans values (5131,238825,816,'1994-3-30','VYDAJ','VYBER',2900.00,41181.70,NULL,NULL,'0');
insert into tab_trans values (5131,238826,816,'1994-5-2','VYDAJ','VYBER',1200.00,22213.20,NULL,NULL,'0');
insert into tab_trans values (5131,238827,816,'1994-6-8','VYDAJ','VYBER',1800.00,77842.60,NULL,NULL,'0');
insert into tab_trans values (5131,238828,816,'1994-7-22','VYDAJ','VYBER',2800.00,41862.00,NULL,NULL,'0');
insert into tab_trans values (5131,238829,816,'1994-8-5','VYDAJ','VYBER',1100.00,32846.60,NULL,NULL,'0');
insert into tab_trans values (5131,238830,816,'1994-9-11','VYDAJ','VYBER',2100.00,83932.80,NULL,NULL,'0');
insert into tab_trans values (5131,238831,816,'1994-10-3','VYDAJ','VYBER',1300.00,61338.30,NULL,NULL,'0');
insert into tab_trans values (5131,238832,816,'1994-10-31','VYDAJ','VYBER',2400.00,52937.00,NULL,NULL,'0');
insert into tab_trans values (5131,238833,816,'1994-12-7','VYDAJ','VYBER',1400.00,85422.40,NULL,NULL,'0');
insert into tab_trans values (5131,238895,816,'1994-2-7','VYDAJ','PREVOD NA UCET',4514.00,85493.60,'SIPO','QR','67616367');
insert into tab_trans values (5131,238896,816,'1994-3-7','VYDAJ','PREVOD NA UCET',4514.00,75566.70,'SIPO','QR','67616367');
insert into tab_trans values (5131,238897,816,'1994-4-7','VYDAJ','PREVOD NA UCET',4514.00,20128.70,'SIPO','QR','67616367');
insert into tab_trans values (5131,238898,816,'1994-5-7','VYDAJ','PREVOD NA UCET',4514.00,54952.20,'SIPO','QR','67616367');
insert into tab_trans values (5131,238899,816,'1994-6-7','VYDAJ','PREVOD NA UCET',4514.00,79642.60,'SIPO','QR','67616367');
insert into tab_trans values (5131,238900,816,'1994-7-7','VYDAJ','PREVOD NA UCET',4514.00,47145.00,'SIPO','QR','67616367');
insert into tab_trans values (5131,238901,816,'1994-8-7','VYDAJ','PREVOD NA UCET',4514.00,28332.60,'SIPO','QR','67616367');
insert into tab_trans values (5131,238902,816,'1994-9-7','VYDAJ','PREVOD NA UCET',4514.00,56688.80,'SIPO','QR','67616367');
insert into tab_trans values (5131,238903,816,'1994-10-7','VYDAJ','PREVOD NA UCET',4514.00,56824.30,'SIPO','QR','67616367');
insert into tab_trans values (5131,238904,816,'1994-11-7','VYDAJ','PREVOD NA UCET',4514.00,48408.40,'SIPO','QR','67616367');
insert into tab_trans values (5131,238905,816,'1994-12-7','VYDAJ','PREVOD NA UCET',4514.00,86822.40,'SIPO','QR','67616367');
insert into tab_trans values (5131,238906,816,'1995-1-7','VYDAJ','PREVOD NA UCET',4514.00,47993.60,'SIPO','QR','67616367');
insert into tab_trans values (5131,238964,816,'1994-3-1','VYBER','VYBER',15584.00,68446.70,NULL,NULL,NULL);
insert into tab_trans values (5131,238965,816,'1994-4-6','VYBER','VYBER',5466.00,24642.70,NULL,NULL,NULL);
insert into tab_trans values (5131,238966,816,'1994-7-18','VYBER','VYBER',5286.00,35859.00,NULL,NULL,NULL);
insert into tab_trans values (5131,238974,816,'1994-12-20','VYDAJ','VYBER',8700.00,84887.40,NULL,NULL,NULL);
insert into tab_trans values (5131,238985,816,'1994-1-21','VYDAJ','VYBER',8100.00,94927.70,NULL,NULL,NULL);
insert into tab_trans values (5131,238986,816,'1994-1-27','VYDAJ','VYBER',5100.00,83527.70,NULL,NULL,NULL);
insert into tab_trans values (5131,238989,816,'1994-1-23','VYDAJ','VYBER',6300.00,88627.70,NULL,NULL,NULL);
insert into tab_trans values (5131,238990,816,'1994-1-19','VYDAJ','VYBER',5400.00,91065.70,NULL,NULL,NULL);
insert into tab_trans values (5131,238995,816,'1995-1-2','VYDAJ','VYBER',7200.00,52507.60,NULL,NULL,NULL);
insert into tab_trans values (5131,239022,816,'1994-1-17','VYDAJ','VYBER',14100.00,59290.70,NULL,NULL,NULL);
insert into tab_trans values (5131,239023,816,'1994-7-23','VYDAJ','VYBER',2700.00,39162.00,NULL,NULL,NULL);
insert into tab_trans values (5131,239024,816,'1994-12-8','VYDAJ','VYBER',12900.00,72522.40,NULL,NULL,NULL);
insert into tab_trans values (5131,239025,816,'1994-3-12','VYDAJ','VYBER',6300.00,46681.70,NULL,NULL,NULL);
insert into tab_trans values (5131,239026,816,'1994-7-9','VYDAJ','VYBER',6000.00,41145.00,NULL,NULL,NULL);
insert into tab_trans values (5131,239059,816,'1994-1-31','VYDAJ','VYBER',14.60,83801.60,'SLUZBY',NULL,NULL);
insert into tab_trans values (5131,239060,816,'1994-2-28','VYDAJ','VYBER',14.60,84030.70,'SLUZBY',NULL,NULL);
insert into tab_trans values (5131,239061,816,'1994-3-31','VYDAJ','VYBER',14.60,41408.70,'SLUZBY',NULL,NULL);
insert into tab_trans values (5131,239062,816,'1994-4-30','VYDAJ','VYBER',14.60,20213.20,'SLUZBY',NULL,NULL);
insert into tab_trans values (5131,239063,816,'1994-5-31','VYDAJ','VYBER',14.60,93674.60,'SLUZBY',NULL,NULL);
insert into tab_trans values (5131,239064,816,'1994-6-30','VYDAJ','VYBER',14.60,78159.00,'SLUZBY',NULL,NULL);
insert into tab_trans values (5131,239065,816,'1994-7-31','VYDAJ','VYBER',14.60,39346.60,'SLUZBY',NULL,NULL);
insert into tab_trans values (5131,239066,816,'1994-8-31','VYDAJ','VYBER',14.60,61202.80,'SLUZBY',NULL,NULL);
insert into tab_trans values (5131,239067,816,'1994-9-30','VYDAJ','VYBER',14.60,62638.30,'SLUZBY',NULL,NULL);
insert into tab_trans values (5131,239068,816,'1994-10-31','VYDAJ','VYBER',14.60,52922.40,'SLUZBY',NULL,NULL);
insert into tab_trans values (5131,239069,816,'1994-11-30','VYDAJ','VYBER',14.60,69183.40,'SLUZBY',NULL,NULL);
insert into tab_trans values (5131,239070,816,'1994-12-31','VYDAJ','VYBER',14.60,59707.60,'SLUZBY',NULL,NULL);
insert into tab_trans values (5131,239118,816,'1993-9-4','PRIJEM','VKLAD',5200.00,22646.10,NULL,NULL,NULL);
insert into tab_trans values (5131,239119,816,'1993-10-4','VYDAJ','VYBER',36700.00,58516.80,NULL,NULL,NULL);
insert into tab_trans values (5131,239120,816,'1993-11-3','VYDAJ','VYBER',14800.00,43958.60,NULL,NULL,NULL);
insert into tab_trans values (5131,239121,816,'1993-12-3','VYDAJ','VYBER',7400.00,36802.40,NULL,NULL,NULL);
insert into tab_trans values (5131,239122,816,'1994-1-2','VYDAJ','VYBER',9500.00,38071.70,NULL,NULL,NULL);
insert into tab_trans values (5131,239123,816,'1994-1-21','VYDAJ','VYBER',28600.00,103027.70,NULL,NULL,NULL);
insert into tab_trans values (5131,239124,816,'1994-2-1','VYDAJ','VYBER',31400.00,52401.60,NULL,NULL,NULL);
insert into tab_trans values (5131,239125,816,'1994-3-3','VYDAJ','VYBER',20300.00,48146.70,NULL,NULL,NULL);
insert into tab_trans values (5131,239126,816,'1994-3-7','VYDAJ','VYBER',41300.00,80080.70,NULL,NULL,NULL);
insert into tab_trans values (5131,239127,816,'1994-3-12','VYDAJ','VYBER',52900.00,52981.70,NULL,NULL,NULL);
insert into tab_trans values (5131,239128,816,'1994-4-2','VYDAJ','VYBER',11300.00,30108.70,NULL,NULL,NULL);
insert into tab_trans values (5131,239129,816,'1994-5-2','PRIJEM','VKLAD',3200.00,23413.20,NULL,NULL,NULL);
insert into tab_trans values (5131,239130,816,'1994-6-1','VYDAJ','VYBER',31400.00,62274.60,NULL,NULL,NULL);
insert into tab_trans values (5131,239131,816,'1994-7-1','VYDAJ','VYBER',26500.00,51659.00,NULL,NULL,NULL);
insert into tab_trans values (5131,239132,816,'1994-7-31','VYDAJ','VYBER',5400.00,33946.60,NULL,NULL,NULL);
insert into tab_trans values (5131,239133,816,'1994-8-30','VYDAJ','VYBER',28500.00,61025.60,NULL,NULL,NULL);
insert into tab_trans values (5131,239134,816,'1994-9-29','VYDAJ','VYBER',30400.00,62339.80,NULL,NULL,NULL);
insert into tab_trans values (5131,239135,816,'1994-10-29','VYDAJ','VYBER',23000.00,55088.30,NULL,NULL,NULL);
insert into tab_trans values (5131,239136,816,'1994-11-28','VYDAJ','VYBER',38200.00,68912.40,NULL,NULL,NULL);
insert into tab_trans values (5131,239137,816,'1994-12-17','VYDAJ','VYBER',40600.00,93587.40,NULL,NULL,NULL);
insert into tab_trans values (5131,239138,816,'1994-12-28','VYDAJ','VYBER',25500.00,59387.40,NULL,NULL,NULL);
insert into tab_trans values (5131,3557020,816,'1993-8-31','PRIJEM',NULL,21.10,17446.10,'UROK',NULL,NULL);
insert into tab_trans values (5131,3557021,816,'1993-9-30','PRIJEM',NULL,182.80,53655.80,'UROK',NULL,NULL);
insert into tab_trans values (5131,3557022,816,'1993-10-31','PRIJEM',NULL,241.80,58758.60,'UROK',NULL,NULL);
insert into tab_trans values (5131,3557023,816,'1993-11-30','PRIJEM',NULL,243.80,44202.40,'UROK',NULL,NULL);
insert into tab_trans values (5131,3557024,816,'1993-12-31','PRIJEM',NULL,209.30,47571.70,'UROK',NULL,NULL);
insert into tab_trans values (5131,3557025,816,'1994-1-31','PRIJEM',NULL,288.50,83816.20,'UROK',NULL,NULL);
insert into tab_trans values (5131,3557026,816,'1994-2-28','PRIJEM',NULL,351.70,84045.30,'UROK',NULL,NULL);
insert into tab_trans values (5131,3557027,816,'1994-3-31','PRIJEM',NULL,241.60,41423.30,'UROK',NULL,NULL);
insert into tab_trans values (5131,3557028,816,'1994-4-30','PRIJEM',NULL,99.10,20227.80,'UROK',NULL,NULL);
insert into tab_trans values (5131,3557029,816,'1994-5-31','PRIJEM',NULL,305.00,93689.20,'UROK',NULL,NULL);
insert into tab_trans values (5131,3557030,816,'1994-6-30','PRIJEM',NULL,331.00,78173.60,'UROK',NULL,NULL);
insert into tab_trans values (5131,3557031,816,'1994-7-31','PRIJEM',NULL,199.20,39361.20,'UROK',NULL,NULL);
insert into tab_trans values (5131,3557032,816,'1994-8-31','PRIJEM',NULL,191.80,61217.40,'UROK',NULL,NULL);
insert into tab_trans values (5131,3557033,816,'1994-9-30','PRIJEM',NULL,313.10,62652.90,'UROK',NULL,NULL);
insert into tab_trans values (5131,3557034,816,'1994-10-31','PRIJEM',NULL,248.70,55337.00,'UROK',NULL,NULL);
insert into tab_trans values (5131,3557035,816,'1994-11-30','PRIJEM',NULL,285.60,69198.00,'UROK',NULL,NULL);
insert into tab_trans values (5131,3557036,816,'1994-12-31','PRIJEM',NULL,334.90,59722.20,'UROK',NULL,NULL);
insert into tab_trans values (5132,239271,817,'1994-3-18','PRIJEM','VKLAD',200.00,200.00,NULL,NULL,NULL);
insert into tab_trans values (5132,239275,817,'1994-4-5','PRIJEM','VKLAD',21388.00,21588.00,NULL,NULL,NULL);
insert into tab_trans values (5132,239276,817,'1994-5-5','PRIJEM','VKLAD',21388.00,42216.40,NULL,NULL,NULL);
insert into tab_trans values (5132,239277,817,'1994-6-5','PRIJEM','VKLAD',32082.00,67414.10,NULL,NULL,NULL);
insert into tab_trans values (5132,239278,817,'1994-7-5','PRIJEM','VKLAD',21388.00,69775.90,NULL,NULL,NULL);
insert into tab_trans values (5132,239279,817,'1994-8-5','PRIJEM','VKLAD',21388.00,57453.20,NULL,NULL,NULL);
insert into tab_trans values (5132,239280,817,'1994-9-5','PRIJEM','VKLAD',21388.00,58074.90,NULL,NULL,NULL);
insert into tab_trans values (5132,239281,817,'1994-10-5','PRIJEM','VKLAD',21388.00,53027.30,NULL,NULL,NULL);
insert into tab_trans values (5132,239282,817,'1994-11-5','PRIJEM','VKLAD',21388.00,40824.40,NULL,NULL,NULL);
insert into tab_trans values (5132,239283,817,'1994-12-5','PRIJEM','VKLAD',32082.00,46919.00,NULL,NULL,NULL);
insert into tab_trans values (5132,239284,817,'1995-1-5','PRIJEM','VKLAD',21388.00,45199.50,NULL,NULL,NULL);
insert into tab_trans values (5132,239285,817,'1995-2-5','PRIJEM','VKLAD',21388.00,41676.00,NULL,NULL,NULL);
insert into tab_trans values (5132,239339,817,'1994-8-14','VYDAJ','PREVOD NA UCET',4605.00,52848.20,'SIPO','GH','53805935');
insert into tab_trans values (5132,239340,817,'1994-9-14','VYDAJ','PREVOD NA UCET',4605.00,53469.90,'SIPO','GH','53805935');
insert into tab_trans values (5132,239341,817,'1994-10-14','VYDAJ','PREVOD NA UCET',4605.00,36422.30,'SIPO','GH','53805935');
insert into tab_trans values (5132,239342,817,'1994-11-14','VYDAJ','PREVOD NA UCET',4605.00,25019.40,'SIPO','GH','53805935');
insert into tab_trans values (5132,239343,817,'1994-12-14','VYDAJ','PREVOD NA UCET',4605.00,29214.00,'SIPO','GH','53805935');
insert into tab_trans values (5132,239344,817,'1995-1-14','VYDAJ','PREVOD NA UCET',4605.00,30894.50,'SIPO','GH','53805935');
insert into tab_trans values (5132,239345,817,'1995-2-14','VYDAJ','PREVOD NA UCET',4605.00,23271.00,'SIPO','GH','53805935');
insert into tab_trans values (5132,239399,817,'1994-7-27','VYDAJ','VYBER',10100.00,35875.90,NULL,NULL,'0');
insert into tab_trans values (5132,239400,817,'1994-9-15','VYDAJ','VYBER',10600.00,32469.90,NULL,NULL,'0');
insert into tab_trans values (5132,239401,817,'1994-10-5','VYDAJ','VYBER',12000.00,41027.30,NULL,NULL,'0');
insert into tab_trans values (5132,239402,817,'1994-10-29','VYDAJ','VYBER',7500.00,19322.30,NULL,NULL,'0');
insert into tab_trans values (5132,239403,817,'1994-12-4','VYDAJ','VYBER',8100.00,14837.00,NULL,NULL,'0');
insert into tab_trans values (5132,239404,817,'1995-1-23','VYDAJ','VYBER',8300.00,22594.50,NULL,NULL,'0');
insert into tab_trans values (5132,239405,817,'1995-2-12','VYDAJ','VYBER',5800.00,27876.00,NULL,NULL,'0');
insert into tab_trans values (5132,239458,817,'1995-1-27','VYDAJ','VYBER',2400.00,20194.50,NULL,NULL,NULL);
insert into tab_trans values (5132,239462,817,'1994-12-27','VYDAJ','VYBER',2880.00,23694.00,NULL,NULL,NULL);
insert into tab_trans values (5132,239468,817,'1994-11-19','VYDAJ','VYBER',2160.00,22859.40,NULL,NULL,NULL);
insert into tab_trans values (5132,239469,817,'1994-9-27','VYDAJ','VYBER',960.00,31509.90,NULL,NULL,NULL);
insert into tab_trans values (5132,239470,817,'1994-12-20','VYDAJ','VYBER',2640.00,26574.00,NULL,NULL,NULL);
insert into tab_trans values (5132,239501,817,'1994-8-31','VYDAJ','VYBER',14.60,36686.90,'SLUZBY',NULL,NULL);
insert into tab_trans values (5132,239502,817,'1994-9-30','VYDAJ','VYBER',14.60,31639.30,'SLUZBY',NULL,NULL);
insert into tab_trans values (5132,239503,817,'1994-10-31','VYDAJ','VYBER',14.60,19436.40,'SLUZBY',NULL,NULL);
insert into tab_trans values (5132,239504,817,'1994-11-30','VYDAJ','VYBER',14.60,22937.00,'SLUZBY',NULL,NULL);
insert into tab_trans values (5132,239505,817,'1994-12-31','VYDAJ','VYBER',14.60,23811.50,'SLUZBY',NULL,NULL);
insert into tab_trans values (5132,239506,817,'1995-1-31','VYDAJ','VYBER',14.60,20288.00,'SLUZBY',NULL,NULL);
insert into tab_trans values (5132,239553,817,'1994-4-17','VYDAJ','VYBER',800.00,20788.00,NULL,NULL,NULL);
insert into tab_trans values (5132,239554,817,'1994-5-17','VYDAJ','VYBER',7000.00,35216.40,NULL,NULL,NULL);
insert into tab_trans values (5132,239555,817,'1994-6-16','VYDAJ','VYBER',19200.00,48214.10,NULL,NULL,NULL);
insert into tab_trans values (5132,239556,817,'1994-7-16','VYDAJ','VYBER',23800.00,45975.90,NULL,NULL,NULL);
insert into tab_trans values (5132,239557,817,'1994-8-15','VYDAJ','VYBER',16300.00,36548.20,NULL,NULL,NULL);
insert into tab_trans values (5132,239558,817,'1994-9-14','VYDAJ','VYBER',10400.00,43069.90,NULL,NULL,NULL);
insert into tab_trans values (5132,239559,817,'1994-10-14','VYDAJ','VYBER',9600.00,26822.30,NULL,NULL,NULL);
insert into tab_trans values (5132,239560,817,'1994-11-13','VYDAJ','VYBER',11200.00,29624.40,NULL,NULL,NULL);
insert into tab_trans values (5132,239561,817,'1994-12-13','VYDAJ','VYBER',13100.00,33819.00,NULL,NULL,NULL);
insert into tab_trans values (5132,239562,817,'1995-1-12','VYDAJ','VYBER',9700.00,35499.50,NULL,NULL,NULL);
insert into tab_trans values (5132,239563,817,'1995-2-11','VYDAJ','VYBER',8000.00,33676.00,NULL,NULL,NULL);
insert into tab_trans values (5132,3557085,817,'1994-4-30','PRIJEM',NULL,40.40,20828.40,'UROK',NULL,NULL);
insert into tab_trans values (5132,3557086,817,'1994-5-31','PRIJEM',NULL,115.70,35332.10,'UROK',NULL,NULL);
insert into tab_trans values (5132,3557087,817,'1994-6-30','PRIJEM',NULL,173.80,48387.90,'UROK',NULL,NULL);
insert into tab_trans values (5132,3557088,817,'1994-7-31','PRIJEM',NULL,189.30,36065.20,'UROK',NULL,NULL);
insert into tab_trans values (5132,3557089,817,'1994-8-31','PRIJEM',NULL,153.30,36701.50,'UROK',NULL,NULL);
insert into tab_trans values (5132,3557090,817,'1994-9-30','PRIJEM',NULL,144.00,31653.90,'UROK',NULL,NULL);
insert into tab_trans values (5132,3557091,817,'1994-10-31','PRIJEM',NULL,128.70,19451.00,'UROK',NULL,NULL);
insert into tab_trans values (5132,3557092,817,'1994-11-30','PRIJEM',NULL,92.20,22951.60,'UROK',NULL,NULL);
insert into tab_trans values (5132,3557093,817,'1994-12-31','PRIJEM',NULL,132.10,23826.10,'UROK',NULL,NULL);
insert into tab_trans values (5132,3557094,817,'1995-1-31','PRIJEM',NULL,108.10,20302.60,'UROK',NULL,NULL);
insert into tab_trans values (5134,241377,825,'1996-3-6','PRIJEM','VKLAD',500.00,500.00,NULL,NULL,NULL);
insert into tab_trans values (5134,241380,825,'1996-3-8','PRIJEM','VKLAD',15878.00,16378.00,NULL,NULL,NULL);
insert into tab_trans values (5134,241381,825,'1996-4-8','PRIJEM','VKLAD',15878.00,35608.80,NULL,NULL,NULL);
insert into tab_trans values (5134,241382,825,'1996-5-8','PRIJEM','VKLAD',15878.00,47916.50,NULL,NULL,NULL);
insert into tab_trans values (5134,241383,825,'1996-6-8','PRIJEM','VKLAD',23817.00,65121.60,NULL,NULL,NULL);
insert into tab_trans values (5134,241384,825,'1996-7-8','PRIJEM','VKLAD',15878.00,61852.90,NULL,NULL,NULL);
insert into tab_trans values (5134,241385,825,'1996-8-8','PRIJEM','VKLAD',15878.00,54537.70,NULL,NULL,NULL);
insert into tab_trans values (5134,241386,825,'1996-9-8','PRIJEM','VKLAD',15878.00,44393.20,NULL,NULL,NULL);
insert into tab_trans values (5134,241387,825,'1996-10-8','PRIJEM','VKLAD',15878.00,33095.60,NULL,NULL,NULL);
insert into tab_trans values (5134,241388,825,'1996-11-8','PRIJEM','VKLAD',15878.00,30454.10,NULL,NULL,NULL);
insert into tab_trans values (5134,241389,825,'1996-12-8','PRIJEM','VKLAD',23817.00,40144.10,NULL,NULL,NULL);
insert into tab_trans values (5134,241390,825,'1997-1-8','PRIJEM','VKLAD',15878.00,30029.10,NULL,NULL,NULL);
insert into tab_trans values (5134,241421,825,'1996-8-7','VYDAJ','PREVOD NA UCET',9235.00,38659.70,'SIPO','YZ','35577237');
insert into tab_trans values (5134,241422,825,'1996-9-7','VYDAJ','PREVOD NA UCET',9235.00,28515.20,'SIPO','YZ','35577237');
insert into tab_trans values (5134,241423,825,'1996-10-7','VYDAJ','PREVOD NA UCET',9235.00,17217.60,'SIPO','YZ','35577237');
insert into tab_trans values (5134,241424,825,'1996-11-7','VYDAJ','PREVOD NA UCET',9235.00,14576.10,'SIPO','YZ','35577237');
insert into tab_trans values (5134,241425,825,'1996-12-7','VYDAJ','PREVOD NA UCET',9235.00,16327.10,'SIPO','YZ','35577237');
insert into tab_trans values (5134,241426,825,'1997-1-7','VYDAJ','PREVOD NA UCET',9235.00,14151.10,'SIPO','YZ','35577237');
insert into tab_trans values (5134,241456,825,'1996-6-29','VYDAJ','VYBER',4700.00,60421.60,NULL,NULL,'0');
insert into tab_trans values (5134,241457,825,'1996-8-26','VYDAJ','VYBER',5100.00,49437.70,NULL,NULL,'0');
insert into tab_trans values (5134,241458,825,'1996-9-21','VYDAJ','VYBER',3400.00,35473.20,NULL,NULL,'0');
insert into tab_trans values (5134,241459,825,'1996-10-13','VYDAJ','VYBER',3000.00,30095.60,NULL,NULL,'0');
insert into tab_trans values (5134,241460,825,'1996-11-5','VYDAJ','VYBER',4200.00,23811.10,NULL,NULL,'0');
insert into tab_trans values (5134,241461,825,'1996-12-24','VYDAJ','VYBER',4200.00,30904.10,NULL,NULL,'0');
insert into tab_trans values (5134,241462,825,'1997-1-11','VYDAJ','VYBER',4200.00,25829.10,NULL,NULL,'0');
insert into tab_trans values (5134,241490,825,'1997-1-6','VYDAJ','VYBER',2080.00,23386.10,NULL,NULL,NULL);
insert into tab_trans values (5134,241492,825,'1996-12-25','VYDAJ','VYBER',4000.00,26904.10,NULL,NULL,NULL);
insert into tab_trans values (5134,241501,825,'1997-1-18','VYDAJ','VYBER',960.00,22109.10,NULL,NULL,NULL);
insert into tab_trans values (5134,241502,825,'1997-1-12','VYDAJ','VYBER',2760.00,23069.10,NULL,NULL,NULL);
insert into tab_trans values (5134,241503,825,'1997-1-20','VYDAJ','VYBER',3360.00,18749.10,NULL,NULL,NULL);
insert into tab_trans values (5134,241505,825,'1997-1-21','VYDAJ','VYBER',2520.00,16229.10,NULL,NULL,NULL);
insert into tab_trans values (5134,241506,825,'1997-1-22','VYDAJ','VYBER',840.00,15389.10,NULL,NULL,NULL);
insert into tab_trans values (5134,241515,825,'1996-12-15','VYDAJ','VYBER',5040.00,35104.10,NULL,NULL,NULL);
insert into tab_trans values (5134,241516,825,'1996-10-7','VYDAJ','VYBER',4680.00,26452.60,NULL,NULL,NULL);
insert into tab_trans values (5134,241517,825,'1996-9-20','VYDAJ','VYBER',5520.00,38873.20,NULL,NULL,NULL);
insert into tab_trans values (5134,241518,825,'1997-1-6','VYDAJ','VYBER',3360.00,25466.10,NULL,NULL,NULL);
insert into tab_trans values (5134,241535,825,'1996-7-31','VYDAJ','VYBER',14.60,62094.70,'SLUZBY',NULL,NULL);
insert into tab_trans values (5134,241536,825,'1996-8-31','VYDAJ','VYBER',14.60,49650.20,'SLUZBY',NULL,NULL);
insert into tab_trans values (5134,241537,825,'1996-9-30','VYDAJ','VYBER',14.60,35632.60,'SLUZBY',NULL,NULL);
insert into tab_trans values (5134,241538,825,'1996-10-31','VYDAJ','VYBER',14.60,30211.10,'SLUZBY',NULL,NULL);
insert into tab_trans values (5134,241539,825,'1996-11-30','VYDAJ','VYBER',14.60,30562.10,'SLUZBY',NULL,NULL);
insert into tab_trans values (5134,241540,825,'1996-12-31','VYDAJ','VYBER',14.60,28826.10,'SLUZBY',NULL,NULL);
insert into tab_trans values (5134,241541,825,'1997-1-31','VYDAJ','VYBER',14.60,21065.70,'SLUZBY',NULL,NULL);
insert into tab_trans values (5134,241564,825,'1996-4-5','PRIJEM','VKLAD',3300.00,19730.80,NULL,NULL,NULL);
insert into tab_trans values (5134,241565,825,'1996-5-5','VYDAJ','VYBER',3700.00,32038.50,NULL,NULL,NULL);
insert into tab_trans values (5134,241566,825,'1996-6-4','VYDAJ','VYBER',6800.00,41304.60,NULL,NULL,NULL);
insert into tab_trans values (5134,241567,825,'1996-7-4','VYDAJ','VYBER',14700.00,45974.90,NULL,NULL,NULL);
insert into tab_trans values (5134,241568,825,'1996-8-3','VYDAJ','VYBER',14200.00,47894.70,NULL,NULL,NULL);
insert into tab_trans values (5134,241569,825,'1996-9-2','VYDAJ','VYBER',11900.00,37750.20,NULL,NULL,NULL);
insert into tab_trans values (5134,241570,825,'1996-10-2','VYDAJ','VYBER',4500.00,31132.60,NULL,NULL,NULL);
insert into tab_trans values (5134,241571,825,'1996-11-1','VYDAJ','VYBER',2200.00,28011.10,NULL,NULL,NULL);
insert into tab_trans values (5134,241572,825,'1996-12-1','VYDAJ','VYBER',5000.00,25562.10,NULL,NULL,NULL);
insert into tab_trans values (5134,241573,825,'1996-12-31','PRIJEM','VKLAD',1800.00,28704.10,NULL,NULL,NULL);
insert into tab_trans values (5134,241574,825,'1997-1-30','PRIJEM','VKLAD',5600.00,20989.10,NULL,NULL,NULL);
insert into tab_trans values (5134,3557359,825,'1996-3-31','PRIJEM',NULL,52.80,16430.80,'UROK',NULL,NULL);
insert into tab_trans values (5134,3557360,825,'1996-4-30','PRIJEM',NULL,129.70,35738.50,'UROK',NULL,NULL);
insert into tab_trans values (5134,3557361,825,'1996-5-31','PRIJEM',NULL,188.10,48104.60,'UROK',NULL,NULL);
insert into tab_trans values (5134,3557362,825,'1996-6-30','PRIJEM',NULL,253.30,60674.90,'UROK',NULL,NULL);
insert into tab_trans values (5134,3557363,825,'1996-7-31','PRIJEM',NULL,256.40,62109.30,'UROK',NULL,NULL);
insert into tab_trans values (5134,3557364,825,'1996-8-31','PRIJEM',NULL,227.10,49664.80,'UROK',NULL,NULL);
insert into tab_trans values (5134,3557365,825,'1996-9-30','PRIJEM',NULL,174.00,35647.20,'UROK',NULL,NULL);
insert into tab_trans values (5134,3557366,825,'1996-10-31','PRIJEM',NULL,130.10,30225.70,'UROK',NULL,NULL);
insert into tab_trans values (5134,3557367,825,'1996-11-30','PRIJEM',NULL,122.60,30576.70,'UROK',NULL,NULL);
insert into tab_trans values (5134,3557368,825,'1996-12-31','PRIJEM',NULL,136.70,28840.70,'UROK',NULL,NULL);
insert into tab_trans values (5134,3557369,825,'1997-1-31','PRIJEM',NULL,91.20,21080.30,'UROK',NULL,NULL);
insert into tab_trans values (5136,246308,846,'1996-3-9','PRIJEM','VKLAD',300.00,300.00,NULL,NULL,NULL);
insert into tab_trans values (5136,246313,846,'1996-7-20','PRIJEM','VKLAD',24212.00,89875.70,NULL,NULL,NULL);
insert into tab_trans values (5136,246314,846,'1996-4-12','PRIJEM','VKLAD',26040.00,46359.50,NULL,NULL,NULL);
insert into tab_trans values (5136,246317,846,'1996-5-14','PRIJEM','VKLAD',13177.00,101991.50,NULL,NULL,NULL);
insert into tab_trans values (5136,246319,846,'1996-3-31','PRIJEM','VKLAD',18017.00,18317.00,NULL,NULL,NULL);
insert into tab_trans values (5136,246324,846,'1996-5-11','PRIJEM','VKLAD',34903.00,88814.50,NULL,NULL,NULL);
insert into tab_trans values (5136,246325,846,'1996-7-21','PRIJEM','VKLAD',43502.00,133377.70,NULL,NULL,NULL);
insert into tab_trans values (5136,246328,846,'1996-7-18','PRIJEM','VKLAD',17331.00,65663.70,NULL,NULL,NULL);
insert into tab_trans values (5136,246331,846,'1996-7-5','PRIJEM','VKLAD',31649.00,74432.70,NULL,NULL,NULL);
insert into tab_trans values (5136,246333,846,'1996-5-18','PRIJEM','VKLAD',35202.00,137193.50,NULL,NULL,NULL);
insert into tab_trans values (5136,246334,846,'1996-4-13','PRIJEM','VKLAD',41498.00,87857.50,NULL,NULL,NULL);
insert into tab_trans values (5136,246367,846,'1996-6-9','VYDAJ','VYBER',5200.00,50052.70,NULL,NULL,'0');
insert into tab_trans values (5136,246368,846,'1996-6-26','VYDAJ','VYBER',7500.00,42552.70,NULL,NULL,'0');
insert into tab_trans values (5136,246458,846,'1996-5-31','VYDAJ','VYBER',14.60,88052.70,'SLUZBY',NULL,NULL);
insert into tab_trans values (5136,246459,846,'1996-6-30','VYDAJ','VYBER',14.60,42783.70,'SLUZBY',NULL,NULL);
insert into tab_trans values (5136,246489,846,'1996-4-8','PRIJEM','VKLAD',2000.00,20319.50,NULL,NULL,NULL);
insert into tab_trans values (5136,246490,846,'1996-5-8','VYDAJ','VYBER',34200.00,53911.50,NULL,NULL,NULL);
insert into tab_trans values (5136,246491,846,'1996-5-18','VYDAJ','VYBER',49500.00,87693.50,NULL,NULL,NULL);
insert into tab_trans values (5136,246492,846,'1996-6-7','VYDAJ','VYBER',32800.00,55252.70,NULL,NULL,NULL);
insert into tab_trans values (5136,246493,846,'1996-7-7','VYDAJ','VYBER',26100.00,48332.70,NULL,NULL,NULL);
insert into tab_trans values (5136,246494,846,'1996-7-21','VYDAJ','VYBER',46500.00,86877.70,NULL,NULL,NULL);
insert into tab_trans values (5136,3558041,846,'1996-3-31','PRIJEM',NULL,2.50,18319.50,'UROK',NULL,NULL);
insert into tab_trans values (5136,3558042,846,'1996-4-30','PRIJEM',NULL,254.10,88111.50,'UROK',NULL,NULL);
insert into tab_trans values (5136,3558043,846,'1996-5-31','PRIJEM',NULL,373.80,88067.30,'UROK',NULL,NULL);
insert into tab_trans values (5136,3558044,846,'1996-6-30','PRIJEM',NULL,245.60,42798.30,'UROK',NULL,NULL);
insert into tab_trans values (5138,248272,854,'1993-9-21','PRIJEM','VKLAD',700.00,700.00,NULL,NULL,NULL);
insert into tab_trans values (5138,248282,854,'1993-10-8','PRIJEM','VKLAD',10405.00,11105.00,NULL,NULL,NULL);
insert into tab_trans values (5138,248283,854,'1993-11-8','PRIJEM','VKLAD',10405.00,27335.00,NULL,NULL,NULL);
insert into tab_trans values (5138,248284,854,'1993-12-8','PRIJEM','VKLAD',15608.00,40826.00,NULL,NULL,NULL);
insert into tab_trans values (5138,248285,854,'1994-1-8','PRIJEM','VKLAD',10405.00,41445.10,NULL,NULL,NULL);
insert into tab_trans values (5138,248286,854,'1994-2-8','PRIJEM','VKLAD',10405.00,43682.80,NULL,NULL,NULL);
insert into tab_trans values (5138,248287,854,'1994-3-8','PRIJEM','VKLAD',10405.00,40693.70,NULL,NULL,NULL);
insert into tab_trans values (5138,248288,854,'1994-4-8','PRIJEM','VKLAD',10405.00,37993.20,NULL,NULL,NULL);
insert into tab_trans values (5138,248289,854,'1994-5-8','PRIJEM','VKLAD',10405.00,39788.70,NULL,NULL,NULL);
insert into tab_trans values (5138,248290,854,'1994-6-8','PRIJEM','VKLAD',15608.00,43787.30,NULL,NULL,NULL);
insert into tab_trans values (5138,248291,854,'1994-7-8','PRIJEM','VKLAD',10405.00,40990.30,NULL,NULL,NULL);
insert into tab_trans values (5138,248292,854,'1994-8-8','PRIJEM','VKLAD',10405.00,39590.60,NULL,NULL,NULL);
insert into tab_trans values (5138,248293,854,'1994-9-8','PRIJEM','VKLAD',10405.00,39090.20,NULL,NULL,NULL);
insert into tab_trans values (5138,248294,854,'1994-10-8','PRIJEM','VKLAD',10405.00,34474.80,NULL,NULL,NULL);
insert into tab_trans values (5138,248295,854,'1994-11-8','PRIJEM','VKLAD',10405.00,37954.70,NULL,NULL,NULL);
insert into tab_trans values (5138,248296,854,'1994-12-8','PRIJEM','VKLAD',15608.00,42746.10,NULL,NULL,NULL);
insert into tab_trans values (5138,248297,854,'1995-1-8','PRIJEM','VKLAD',10405.00,36943.10,NULL,NULL,NULL);
insert into tab_trans values (5138,248298,854,'1995-2-8','PRIJEM','VKLAD',10405.00,34723.60,NULL,NULL,NULL);
insert into tab_trans values (5138,248299,854,'1995-3-8','PRIJEM','VKLAD',10405.00,30493.90,NULL,NULL,NULL);
insert into tab_trans values (5138,248300,854,'1995-4-8','PRIJEM','VKLAD',10405.00,30753.90,NULL,NULL,NULL);
insert into tab_trans values (5138,248301,854,'1995-5-8','PRIJEM','VKLAD',10405.00,32420.30,NULL,NULL,NULL);
insert into tab_trans values (5138,248358,854,'1994-2-10','VYDAJ','PREVOD NA UCET',382.00,43300.80,'SIPO','AB','21777671');
insert into tab_trans values (5138,248359,854,'1994-3-10','VYDAJ','PREVOD NA UCET',382.00,40311.70,'SIPO','AB','21777671');
insert into tab_trans values (5138,248360,854,'1994-4-10','VYDAJ','PREVOD NA UCET',382.00,37611.20,'SIPO','AB','21777671');
insert into tab_trans values (5138,248361,854,'1994-5-10','VYDAJ','PREVOD NA UCET',382.00,39406.70,'SIPO','AB','21777671');
insert into tab_trans values (5138,248362,854,'1994-6-10','VYDAJ','PREVOD NA UCET',382.00,42105.30,'SIPO','AB','21777671');
insert into tab_trans values (5138,248363,854,'1994-7-10','VYDAJ','PREVOD NA UCET',382.00,40608.30,'SIPO','AB','21777671');
insert into tab_trans values (5138,248364,854,'1994-8-10','VYDAJ','PREVOD NA UCET',382.00,39208.60,'SIPO','AB','21777671');
insert into tab_trans values (5138,248365,854,'1994-9-10','VYDAJ','PREVOD NA UCET',382.00,38708.20,'SIPO','AB','21777671');
insert into tab_trans values (5138,248366,854,'1994-10-10','VYDAJ','PREVOD NA UCET',382.00,32692.80,'SIPO','AB','21777671');
insert into tab_trans values (5138,248367,854,'1994-11-10','VYDAJ','PREVOD NA UCET',382.00,37572.70,'SIPO','AB','21777671');
insert into tab_trans values (5138,248368,854,'1994-12-10','VYDAJ','PREVOD NA UCET',382.00,42364.10,'SIPO','AB','21777671');
insert into tab_trans values (5138,248369,854,'1995-1-10','VYDAJ','PREVOD NA UCET',382.00,36561.10,'SIPO','AB','21777671');
insert into tab_trans values (5138,248370,854,'1995-2-10','VYDAJ','PREVOD NA UCET',382.00,34341.60,'SIPO','AB','21777671');
insert into tab_trans values (5138,248371,854,'1995-3-10','VYDAJ','PREVOD NA UCET',382.00,28411.90,'SIPO','AB','21777671');
insert into tab_trans values (5138,248372,854,'1995-4-10','VYDAJ','PREVOD NA UCET',382.00,30371.90,'SIPO','AB','21777671');
insert into tab_trans values (5138,248373,854,'1995-5-10','VYDAJ','PREVOD NA UCET',382.00,32038.30,'SIPO','AB','21777671');
insert into tab_trans values (5138,248431,854,'1994-3-5','VYDAJ','PREVOD NA UCET',1105.00,30288.70,NULL,'KL','41849011');
insert into tab_trans values (5138,248432,854,'1994-4-5','VYDAJ','PREVOD NA UCET',1105.00,27588.20,NULL,'KL','41849011');
insert into tab_trans values (5138,248433,854,'1994-5-5','VYDAJ','PREVOD NA UCET',1105.00,29383.70,NULL,'KL','41849011');
insert into tab_trans values (5138,248434,854,'1994-6-5','VYDAJ','PREVOD NA UCET',1105.00,28179.30,NULL,'KL','41849011');
insert into tab_trans values (5138,248435,854,'1994-7-5','VYDAJ','PREVOD NA UCET',1105.00,30585.30,NULL,'KL','41849011');
insert into tab_trans values (5138,248436,854,'1994-8-5','VYDAJ','PREVOD NA UCET',1105.00,29185.60,NULL,'KL','41849011');
insert into tab_trans values (5138,248437,854,'1994-9-5','VYDAJ','PREVOD NA UCET',1105.00,28685.20,NULL,'KL','41849011');
insert into tab_trans values (5138,248438,854,'1994-10-5','VYDAJ','PREVOD NA UCET',1105.00,24069.80,NULL,'KL','41849011');
insert into tab_trans values (5138,248439,854,'1994-11-5','VYDAJ','PREVOD NA UCET',1105.00,27549.70,NULL,'KL','41849011');
insert into tab_trans values (5138,248440,854,'1994-12-5','VYDAJ','PREVOD NA UCET',1105.00,27138.10,NULL,'KL','41849011');
insert into tab_trans values (5138,248441,854,'1995-1-5','VYDAJ','PREVOD NA UCET',1105.00,26538.10,NULL,'KL','41849011');
insert into tab_trans values (5138,248442,854,'1995-2-5','VYDAJ','PREVOD NA UCET',1105.00,24318.60,NULL,'KL','41849011');
insert into tab_trans values (5138,248443,854,'1995-3-5','VYDAJ','PREVOD NA UCET',1105.00,20088.90,NULL,'KL','41849011');
insert into tab_trans values (5138,248444,854,'1995-4-5','VYDAJ','PREVOD NA UCET',1105.00,22048.90,NULL,'KL','41849011');
insert into tab_trans values (5138,248445,854,'1995-5-5','VYDAJ','PREVOD NA UCET',1105.00,22015.30,NULL,'KL','41849011');
insert into tab_trans values (5138,248502,854,'1994-2-14','VYDAJ','PREVOD NA UCET',2843.00,40457.80,'POJISTNE','IJ','6306148');
insert into tab_trans values (5138,248503,854,'1994-3-14','VYDAJ','PREVOD NA UCET',2843.00,37468.70,'POJISTNE','IJ','6306148');
insert into tab_trans values (5138,248504,854,'1994-4-14','VYDAJ','PREVOD NA UCET',2843.00,34768.20,'POJISTNE','IJ','6306148');
insert into tab_trans values (5138,248505,854,'1994-5-14','VYDAJ','PREVOD NA UCET',2843.00,35263.70,'POJISTNE','IJ','6306148');
insert into tab_trans values (5138,248506,854,'1994-6-14','VYDAJ','PREVOD NA UCET',2843.00,39262.30,'POJISTNE','IJ','6306148');
insert into tab_trans values (5138,248507,854,'1994-7-14','VYDAJ','PREVOD NA UCET',2843.00,36165.30,'POJISTNE','IJ','6306148');
insert into tab_trans values (5138,248508,854,'1994-8-14','VYDAJ','PREVOD NA UCET',2843.00,36365.60,'POJISTNE','IJ','6306148');
insert into tab_trans values (5138,248509,854,'1994-9-14','VYDAJ','PREVOD NA UCET',2843.00,35865.20,'POJISTNE','IJ','6306148');
insert into tab_trans values (5138,248510,854,'1994-10-14','VYDAJ','PREVOD NA UCET',2843.00,29849.80,'POJISTNE','IJ','6306148');
insert into tab_trans values (5138,248511,854,'1994-11-14','VYDAJ','PREVOD NA UCET',2843.00,34729.70,'POJISTNE','IJ','6306148');
insert into tab_trans values (5138,248512,854,'1994-12-14','VYDAJ','PREVOD NA UCET',2843.00,39521.10,'POJISTNE','IJ','6306148');
insert into tab_trans values (5138,248513,854,'1995-1-14','VYDAJ','PREVOD NA UCET',2843.00,31618.10,'POJISTNE','IJ','6306148');
insert into tab_trans values (5138,248514,854,'1995-2-14','VYDAJ','PREVOD NA UCET',2843.00,25298.60,'POJISTNE','IJ','6306148');
insert into tab_trans values (5138,248515,854,'1995-3-14','VYDAJ','PREVOD NA UCET',2843.00,25568.90,'POJISTNE','IJ','6306148');
insert into tab_trans values (5138,248516,854,'1995-4-14','VYDAJ','PREVOD NA UCET',2843.00,25028.90,'POJISTNE','IJ','6306148');
insert into tab_trans values (5138,248517,854,'1995-5-14','VYDAJ','PREVOD NA UCET',2843.00,26795.30,'POJISTNE','IJ','6306148');
insert into tab_trans values (5138,248574,854,'1994-2-24','VYDAJ','VYBER',1800.00,33357.80,NULL,NULL,'0');
insert into tab_trans values (5138,248575,854,'1994-3-3','VYDAJ','VYBER',2100.00,31393.70,NULL,NULL,'0');
insert into tab_trans values (5138,248576,854,'1994-4-26','VYDAJ','VYBER',1100.00,30368.20,NULL,NULL,'0');
insert into tab_trans values (5138,248577,854,'1994-5-10','VYDAJ','VYBER',1300.00,38106.70,NULL,NULL,'0');
insert into tab_trans values (5138,248578,854,'1994-6-9','VYDAJ','VYBER',1300.00,42487.30,NULL,NULL,'0');
insert into tab_trans values (5138,248579,854,'1994-7-14','VYDAJ','VYBER',1200.00,34965.30,NULL,NULL,'0');
insert into tab_trans values (5138,248580,854,'1994-7-24','VYDAJ','VYBER',2200.00,30165.30,NULL,NULL,'0');
insert into tab_trans values (5138,248581,854,'1994-9-3','VYDAJ','VYBER',2300.00,29790.20,NULL,NULL,'0');
insert into tab_trans values (5138,248582,854,'1994-10-9','VYDAJ','VYBER',1400.00,33074.80,NULL,NULL,'0');
insert into tab_trans values (5138,248583,854,'1994-11-24','VYDAJ','VYBER',1300.00,28129.70,NULL,NULL,'0');
insert into tab_trans values (5138,248584,854,'1994-12-24','VYDAJ','VYBER',2700.00,30121.10,NULL,NULL,'0');
insert into tab_trans values (5138,248585,854,'1995-1-16','VYDAJ','VYBER',1300.00,27118.10,NULL,NULL,'0');
insert into tab_trans values (5138,248586,854,'1995-2-20','VYDAJ','VYBER',1800.00,23498.60,NULL,NULL,'0');
insert into tab_trans values (5138,248587,854,'1995-3-9','VYDAJ','VYBER',1700.00,28793.90,NULL,NULL,'0');
insert into tab_trans values (5138,248588,854,'1995-4-7','VYDAJ','VYBER',1700.00,20348.90,NULL,NULL,'0');
insert into tab_trans values (5138,248589,854,'1995-5-2','VYDAJ','VYBER',2000.00,23120.30,NULL,NULL,'0');
insert into tab_trans values (5138,248634,854,'1994-12-27','VYDAJ','VYBER',1900.00,28221.10,NULL,NULL,NULL);
insert into tab_trans values (5138,248651,854,'1995-1-28','VYDAJ','VYBER',1100.00,25318.10,NULL,NULL,NULL);
insert into tab_trans values (5138,248652,854,'1995-1-15','VYDAJ','VYBER',500.00,29118.10,NULL,NULL,NULL);
insert into tab_trans values (5138,248653,854,'1995-1-3','VYDAJ','VYBER',700.00,27643.10,NULL,NULL,NULL);
insert into tab_trans values (5138,248654,854,'1995-1-14','VYDAJ','VYBER',2100.00,34461.10,NULL,NULL,NULL);
insert into tab_trans values (5138,248655,854,'1995-1-22','VYDAJ','VYBER',700.00,26418.10,NULL,NULL,NULL);
insert into tab_trans values (5138,248656,854,'1995-1-16','VYDAJ','VYBER',700.00,28418.10,NULL,NULL,NULL);
insert into tab_trans values (5138,248681,854,'1994-9-16','VYDAJ','VYBER',4700.00,31165.20,NULL,NULL,NULL);
insert into tab_trans values (5138,248682,854,'1994-7-11','VYDAJ','VYBER',1600.00,39008.30,NULL,NULL,NULL);
insert into tab_trans values (5138,248686,854,'1995-3-3','VYDAJ','VYBER',2400.00,21193.90,NULL,NULL,NULL);
insert into tab_trans values (5138,248720,854,'1994-2-28','VYDAJ','VYBER',14.60,33493.70,'SLUZBY',NULL,NULL);
insert into tab_trans values (5138,248721,854,'1994-3-31','VYDAJ','VYBER',14.60,28693.20,'SLUZBY',NULL,NULL);
insert into tab_trans values (5138,248722,854,'1994-4-30','VYDAJ','VYBER',14.60,30488.70,'SLUZBY',NULL,NULL);
insert into tab_trans values (5138,248723,854,'1994-5-31','VYDAJ','VYBER',14.60,29284.30,'SLUZBY',NULL,NULL);
insert into tab_trans values (5138,248724,854,'1994-6-30','VYDAJ','VYBER',14.60,31690.30,'SLUZBY',NULL,NULL);
insert into tab_trans values (5138,248725,854,'1994-7-31','VYDAJ','VYBER',14.60,30290.60,'SLUZBY',NULL,NULL);
insert into tab_trans values (5138,248726,854,'1994-8-31','VYDAJ','VYBER',14.60,32090.20,'SLUZBY',NULL,NULL);
insert into tab_trans values (5138,248727,854,'1994-9-30','VYDAJ','VYBER',14.60,25174.80,'SLUZBY',NULL,NULL);
insert into tab_trans values (5138,248728,854,'1994-10-31','VYDAJ','VYBER',14.60,28654.70,'SLUZBY',NULL,NULL);
insert into tab_trans values (5138,248729,854,'1994-11-30','VYDAJ','VYBER',14.60,28243.10,'SLUZBY',NULL,NULL);
insert into tab_trans values (5138,248730,854,'1994-12-31','VYDAJ','VYBER',14.60,28343.10,'SLUZBY',NULL,NULL);
insert into tab_trans values (5138,248731,854,'1995-1-31','VYDAJ','VYBER',14.60,25423.60,'SLUZBY',NULL,NULL);
insert into tab_trans values (5138,248732,854,'1995-2-28','VYDAJ','VYBER',14.60,23593.90,'SLUZBY',NULL,NULL);
insert into tab_trans values (5138,248733,854,'1995-3-31','VYDAJ','VYBER',14.60,23153.90,'SLUZBY',NULL,NULL);
insert into tab_trans values (5138,248734,854,'1995-4-30','VYDAJ','VYBER',14.60,25120.30,'SLUZBY',NULL,NULL);
insert into tab_trans values (5138,248778,854,'1993-10-21','PRIJEM','VKLAD',5800.00,16905.00,NULL,NULL,NULL);
insert into tab_trans values (5138,248779,854,'1993-11-20','VYDAJ','VYBER',2200.00,25135.00,NULL,NULL,NULL);
insert into tab_trans values (5138,248780,854,'1993-12-20','VYDAJ','VYBER',9900.00,30926.00,NULL,NULL,NULL);
insert into tab_trans values (5138,248781,854,'1994-1-19','VYDAJ','VYBER',8300.00,33145.10,NULL,NULL,NULL);
insert into tab_trans values (5138,248782,854,'1994-2-18','VYDAJ','VYBER',5300.00,35157.80,NULL,NULL,NULL);
insert into tab_trans values (5138,248783,854,'1994-3-20','VYDAJ','VYBER',8900.00,28568.70,NULL,NULL,NULL);
insert into tab_trans values (5138,248784,854,'1994-4-19','VYDAJ','VYBER',3300.00,31468.20,NULL,NULL,NULL);
insert into tab_trans values (5138,248785,854,'1994-5-19','VYDAJ','VYBER',6100.00,29163.70,NULL,NULL,NULL);
insert into tab_trans values (5138,248786,854,'1994-6-18','VYDAJ','VYBER',7700.00,31562.30,NULL,NULL,NULL);
insert into tab_trans values (5138,248787,854,'1994-7-18','VYDAJ','VYBER',2600.00,32365.30,NULL,NULL,NULL);
insert into tab_trans values (5138,248788,854,'1994-8-17','VYDAJ','VYBER',4400.00,31965.60,NULL,NULL,NULL);
insert into tab_trans values (5138,248789,854,'1994-9-16','VYDAJ','VYBER',6100.00,25065.20,NULL,NULL,NULL);
insert into tab_trans values (5138,248790,854,'1994-10-16','VYDAJ','VYBER',1300.00,28549.80,NULL,NULL,NULL);
insert into tab_trans values (5138,248791,854,'1994-11-15','VYDAJ','VYBER',5300.00,29429.70,NULL,NULL,NULL);
insert into tab_trans values (5138,248792,854,'1994-12-15','VYDAJ','VYBER',6700.00,32821.10,NULL,NULL,NULL);
insert into tab_trans values (5138,248793,854,'1995-1-14','VYDAJ','VYBER',2000.00,29618.10,NULL,NULL,NULL);
insert into tab_trans values (5138,248794,854,'1995-2-13','VYDAJ','VYBER',6200.00,28141.60,NULL,NULL,NULL);
insert into tab_trans values (5138,248795,854,'1995-3-15','VYDAJ','VYBER',2500.00,23068.90,NULL,NULL,NULL);
insert into tab_trans values (5138,248796,854,'1995-4-14','VYDAJ','VYBER',2500.00,27871.90,NULL,NULL,NULL);
insert into tab_trans values (5138,248797,854,'1995-5-14','VYDAJ','VYBER',2400.00,29638.30,NULL,NULL,NULL);
insert into tab_trans values (5138,3558222,854,'1993-10-31','PRIJEM',NULL,25.00,16930.00,'UROK',NULL,NULL);
insert into tab_trans values (5138,3558223,854,'1993-11-30','PRIJEM',NULL,83.00,25218.00,'UROK',NULL,NULL);
insert into tab_trans values (5138,3558224,854,'1993-12-31','PRIJEM',NULL,114.10,31040.10,'UROK',NULL,NULL);
insert into tab_trans values (5138,3558225,854,'1994-1-31','PRIJEM',NULL,132.70,33277.80,'UROK',NULL,NULL);
insert into tab_trans values (5138,3558226,854,'1994-2-28','PRIJEM',NULL,150.50,33508.30,'UROK',NULL,NULL);
insert into tab_trans values (5138,3558227,854,'1994-3-31','PRIJEM',NULL,139.10,28707.80,'UROK',NULL,NULL);
insert into tab_trans values (5138,3558228,854,'1994-4-30','PRIJEM',NULL,135.20,30503.30,'UROK',NULL,NULL);
insert into tab_trans values (5138,3558229,854,'1994-5-31','PRIJEM',NULL,135.20,29298.90,'UROK',NULL,NULL);
insert into tab_trans values (5138,3558230,854,'1994-6-30','PRIJEM',NULL,142.60,31704.90,'UROK',NULL,NULL);
insert into tab_trans values (5138,3558231,854,'1994-7-31','PRIJEM',NULL,139.90,30305.20,'UROK',NULL,NULL);
insert into tab_trans values (5138,3558232,854,'1994-8-31','PRIJEM',NULL,139.20,32104.80,'UROK',NULL,NULL);
insert into tab_trans values (5138,3558233,854,'1994-9-30','PRIJEM',NULL,124.10,25189.40,'UROK',NULL,NULL);
insert into tab_trans values (5138,3558234,854,'1994-10-31','PRIJEM',NULL,119.50,28669.30,'UROK',NULL,NULL);
insert into tab_trans values (5138,3558235,854,'1994-11-30','PRIJEM',NULL,128.00,28257.70,'UROK',NULL,NULL);
insert into tab_trans values (5138,3558236,854,'1994-12-31','PRIJEM',NULL,136.60,28357.70,'UROK',NULL,NULL);
insert into tab_trans values (5138,3558237,854,'1995-1-31','PRIJEM',NULL,120.10,25438.20,'UROK',NULL,NULL);
insert into tab_trans values (5138,3558238,854,'1995-2-28','PRIJEM',NULL,109.90,23608.50,'UROK',NULL,NULL);
insert into tab_trans values (5138,3558239,854,'1995-3-31','PRIJEM',NULL,99.60,23168.50,'UROK',NULL,NULL);
insert into tab_trans values (5138,3558240,854,'1995-4-30','PRIJEM',NULL,106.00,25134.90,'UROK',NULL,NULL);
insert into tab_trans values (5140,254347,873,'1997-4-26','PRIJEM','VKLAD',1000.00,1000.00,NULL,NULL,NULL);
insert into tab_trans values (5140,254352,873,'1997-5-13','PRIJEM','VKLAD',6944.00,7944.00,NULL,NULL,NULL);
insert into tab_trans values (5140,254353,873,'1997-6-13','PRIJEM','VKLAD',10416.00,24871.60,NULL,NULL,NULL);
insert into tab_trans values (5140,254354,873,'1997-7-13','PRIJEM','VKLAD',6944.00,31584.30,NULL,NULL,NULL);
insert into tab_trans values (5140,254355,873,'1997-8-13','PRIJEM','VKLAD',6944.00,39137.70,NULL,NULL,NULL);
insert into tab_trans values (5140,254356,873,'1997-9-13','PRIJEM','VKLAD',6944.00,39315.60,NULL,NULL,NULL);
insert into tab_trans values (5140,254357,873,'1997-10-13','PRIJEM','VKLAD',6944.00,31259.10,NULL,NULL,NULL);
insert into tab_trans values (5140,254358,873,'1997-11-13','PRIJEM','VKLAD',6944.00,28783.50,NULL,NULL,NULL);
insert into tab_trans values (5140,254359,873,'1997-12-13','PRIJEM','VKLAD',10416.00,20125.20,NULL,NULL,NULL);
insert into tab_trans values (5140,254360,873,'1998-1-13','PRIJEM','VKLAD',6944.00,15392.80,NULL,NULL,NULL);
insert into tab_trans values (5140,254361,873,'1998-2-13','PRIJEM','VKLAD',6944.00,16975.60,NULL,NULL,NULL);
insert into tab_trans values (5140,254380,873,'1997-9-13','VYDAJ','PREVOD NA UCET',878.00,38437.60,'SIPO','CD','22322130');
insert into tab_trans values (5140,254381,873,'1997-10-13','VYDAJ','PREVOD NA UCET',878.00,30381.10,'SIPO','CD','22322130');
insert into tab_trans values (5140,254382,873,'1997-11-13','VYDAJ','PREVOD NA UCET',878.00,27905.50,'SIPO','CD','22322130');
insert into tab_trans values (5140,254383,873,'1997-12-13','VYDAJ','PREVOD NA UCET',878.00,19247.20,'SIPO','CD','22322130');
insert into tab_trans values (5140,254384,873,'1998-1-13','VYDAJ','PREVOD NA UCET',878.00,14514.80,'SIPO','CD','22322130');
insert into tab_trans values (5140,254385,873,'1998-2-13','VYDAJ','PREVOD NA UCET',878.00,16097.60,'SIPO','CD','22322130');
insert into tab_trans values (5140,254405,873,'1997-10-10','VYDAJ','PREVOD NA UCET',1540.00,27715.10,NULL,'QR','57947230');
insert into tab_trans values (5140,254406,873,'1997-11-10','VYDAJ','PREVOD NA UCET',1540.00,21839.50,NULL,'QR','57947230');
insert into tab_trans values (5140,254407,873,'1997-12-10','VYDAJ','PREVOD NA UCET',1540.00,9709.20,NULL,'QR','57947230');
insert into tab_trans values (5140,254408,873,'1998-1-10','VYDAJ','PREVOD NA UCET',1540.00,8448.80,NULL,'QR','57947230');
insert into tab_trans values (5140,254409,873,'1998-2-10','VYDAJ','PREVOD NA UCET',1540.00,13631.60,NULL,'QR','57947230');
insert into tab_trans values (5140,254429,873,'1997-10-8','VYDAJ','PREVOD NA UCET',2211.00,29255.10,'POJISTNE','YZ','91838556');
insert into tab_trans values (5140,254430,873,'1997-11-8','VYDAJ','PREVOD NA UCET',2211.00,23379.50,'POJISTNE','YZ','91838556');
insert into tab_trans values (5140,254431,873,'1997-12-8','VYDAJ','PREVOD NA UCET',2211.00,11249.20,'POJISTNE','YZ','91838556');
insert into tab_trans values (5140,254432,873,'1998-1-8','VYDAJ','PREVOD NA UCET',2211.00,9988.80,'POJISTNE','YZ','91838556');
insert into tab_trans values (5140,254433,873,'1998-2-8','VYDAJ','PREVOD NA UCET',2211.00,15171.60,'POJISTNE','YZ','91838556');
insert into tab_trans values (5140,254453,873,'1997-10-12','VYDAJ','VYBER',3400.00,24315.10,NULL,NULL,'0');
insert into tab_trans values (5140,254454,873,'1997-11-3','VYDAJ','VYBER',2000.00,25590.50,NULL,NULL,'0');
insert into tab_trans values (5140,254455,873,'1997-11-29','VYDAJ','VYBER',3300.00,23005.50,NULL,NULL,'0');
insert into tab_trans values (5140,254456,873,'1998-1-4','VYDAJ','VYBER',2200.00,15439.80,NULL,NULL,'0');
insert into tab_trans values (5140,254457,873,'1998-2-12','VYDAJ','VYBER',3600.00,10031.60,NULL,NULL,'0');
insert into tab_trans values (5140,254470,873,'1997-12-3','VYDAJ','VYBER',4000.00,13460.20,NULL,NULL,NULL);
insert into tab_trans values (5140,254478,873,'1998-1-6','VYDAJ','VYBER',600.00,12199.80,NULL,NULL,NULL);
insert into tab_trans values (5140,254479,873,'1998-1-5','VYDAJ','VYBER',2640.00,12799.80,NULL,NULL,NULL);
insert into tab_trans values (5140,254481,873,'1998-1-17','VYDAJ','VYBER',960.00,13554.80,NULL,NULL,NULL);
insert into tab_trans values (5140,254482,873,'1998-1-25','VYDAJ','VYBER',1320.00,17334.80,NULL,NULL,NULL);
insert into tab_trans values (5140,254483,873,'1998-1-2','VYDAJ','VYBER',600.00,17639.80,NULL,NULL,NULL);
insert into tab_trans values (5140,254485,873,'1997-12-1','VYDAJ','VYBER',5640.00,17460.20,NULL,NULL,NULL);
insert into tab_trans values (5140,254487,873,'1997-12-17','VYDAJ','VYBER',3960.00,15287.20,NULL,NULL,NULL);
insert into tab_trans values (5140,254508,873,'1997-9-30','VYDAJ','VYBER',14.60,31466.10,'SLUZBY',NULL,NULL);
insert into tab_trans values (5140,254509,873,'1997-10-31','VYDAJ','VYBER',14.60,27590.50,'SLUZBY',NULL,NULL);
insert into tab_trans values (5140,254510,873,'1997-11-30','VYDAJ','VYBER',14.60,23100.20,'SLUZBY',NULL,NULL);
insert into tab_trans values (5140,254511,873,'1997-12-31','VYDAJ','VYBER',14.60,18239.80,'SLUZBY',NULL,NULL);
insert into tab_trans values (5140,254512,873,'1998-1-31','VYDAJ','VYBER',14.60,17382.60,'SLUZBY',NULL,NULL);
insert into tab_trans values (5140,254523,873,'1997-5-26','PRIJEM','VKLAD',6500.00,14444.00,NULL,NULL,NULL);
insert into tab_trans values (5140,254524,873,'1997-6-25','VYDAJ','VYBER',300.00,24571.60,NULL,NULL,NULL);
insert into tab_trans values (5140,254525,873,'1997-7-25','PRIJEM','VKLAD',500.00,32084.30,NULL,NULL,NULL);
insert into tab_trans values (5140,254526,873,'1997-8-24','VYDAJ','VYBER',6900.00,32237.70,NULL,NULL,NULL);
insert into tab_trans values (5140,254527,873,'1997-9-23','VYDAJ','VYBER',7100.00,31337.60,NULL,NULL,NULL);
insert into tab_trans values (5140,254528,873,'1997-10-23','VYDAJ','VYBER',2900.00,27481.10,NULL,NULL,NULL);
insert into tab_trans values (5140,254529,873,'1997-11-22','VYDAJ','VYBER',1600.00,26305.50,NULL,NULL,NULL);
insert into tab_trans values (5140,254530,873,'1997-12-22','PRIJEM','VKLAD',2900.00,18187.20,NULL,NULL,NULL);
insert into tab_trans values (5140,254531,873,'1998-1-21','PRIJEM','VKLAD',5100.00,18654.80,NULL,NULL,NULL);
insert into tab_trans values (5140,254532,873,'1998-2-20','PRIJEM','VKLAD',3300.00,19397.60,NULL,NULL,NULL);
insert into tab_trans values (5140,3559002,873,'1997-5-31','PRIJEM',NULL,11.60,14455.60,'UROK',NULL,NULL);
insert into tab_trans values (5140,3559003,873,'1997-6-30','PRIJEM',NULL,68.60,24640.30,'UROK',NULL,NULL);
insert into tab_trans values (5140,3559004,873,'1997-7-31','PRIJEM',NULL,109.50,32193.70,'UROK',NULL,NULL);
insert into tab_trans values (5140,3559005,873,'1997-8-31','PRIJEM',NULL,133.80,32371.50,'UROK',NULL,NULL);
insert into tab_trans values (5140,3559006,873,'1997-9-30','PRIJEM',NULL,143.20,31480.70,'UROK',NULL,NULL);
insert into tab_trans values (5140,3559007,873,'1997-10-31','PRIJEM',NULL,124.00,27605.10,'UROK',NULL,NULL);
insert into tab_trans values (5140,3559008,873,'1997-11-30','PRIJEM',NULL,109.30,23114.80,'UROK',NULL,NULL);
insert into tab_trans values (5140,3559009,873,'1997-12-31','PRIJEM',NULL,67.20,18254.40,'UROK',NULL,NULL);
insert into tab_trans values (5140,3559010,873,'1998-1-31','PRIJEM',NULL,62.40,17397.20,'UROK',NULL,NULL);
insert into tab_trans values (5145,267325,915,'1995-1-18','PRIJEM','VKLAD',700.00,700.00,NULL,NULL,NULL);
insert into tab_trans values (5145,267327,915,'1995-2-9','PRIJEM','PREVOD Z UCTU',38694.00,39394.00,NULL,'UV','92093485');
insert into tab_trans values (5145,267328,915,'1995-3-9','PRIJEM','PREVOD Z UCTU',38694.00,69943.70,NULL,'UV','92093485');
insert into tab_trans values (5145,267329,915,'1995-4-9','PRIJEM','PREVOD Z UCTU',38694.00,88399.70,NULL,'UV','92093485');
insert into tab_trans values (5145,267330,915,'1995-5-9','PRIJEM','PREVOD Z UCTU',38694.00,98117.60,NULL,'UV','92093485');
insert into tab_trans values (5145,267331,915,'1995-6-9','PRIJEM','PREVOD Z UCTU',58041.00,121713.20,NULL,'UV','92093485');
insert into tab_trans values (5145,267332,915,'1995-7-9','PRIJEM','PREVOD Z UCTU',38694.00,79521.20,NULL,'UV','92093485');
insert into tab_trans values (5145,267333,915,'1995-8-9','PRIJEM','PREVOD Z UCTU',38694.00,74403.20,NULL,'UV','92093485');
insert into tab_trans values (5145,267334,915,'1995-9-9','PRIJEM','PREVOD Z UCTU',38694.00,82390.40,NULL,'UV','92093485');
insert into tab_trans values (5145,267379,915,'1995-6-22','VYDAJ','VYBER',7300.00,40622.20,NULL,NULL,'0');
insert into tab_trans values (5145,267380,915,'1995-7-9','VYDAJ','VYBER',9100.00,70421.20,NULL,NULL,'0');
insert into tab_trans values (5145,267381,915,'1995-8-7','VYDAJ','VYBER',7800.00,35709.20,NULL,NULL,'0');
insert into tab_trans values (5145,267427,915,'1995-6-10','VYDAJ','PREVOD NA UCET',14291.00,56822.20,'SIPO','EF','73569780');
insert into tab_trans values (5145,267428,915,'1995-7-10','VYDAJ','PREVOD NA UCET',14291.00,56130.20,'SIPO','EF','73569780');
insert into tab_trans values (5145,267429,915,'1995-8-10','VYDAJ','PREVOD NA UCET',14291.00,60112.20,'SIPO','EF','73569780');
insert into tab_trans values (5145,267430,915,'1995-9-10','VYDAJ','PREVOD NA UCET',14291.00,68099.40,'SIPO','EF','73569780');
insert into tab_trans values (5145,267553,915,'1995-6-30','VYDAJ','VYBER',14.60,40827.20,'SLUZBY',NULL,NULL);
insert into tab_trans values (5145,267554,915,'1995-7-31','VYDAJ','VYBER',14.60,43509.20,'SLUZBY',NULL,NULL);
insert into tab_trans values (5145,267555,915,'1995-8-31','VYDAJ','VYBER',14.60,43696.40,'SLUZBY',NULL,NULL);
insert into tab_trans values (5145,267595,915,'1995-2-17','VYDAJ','VYBER',8200.00,31194.00,NULL,NULL,NULL);
insert into tab_trans values (5145,267596,915,'1995-3-19','VYDAJ','VYBER',20400.00,49543.70,NULL,NULL,NULL);
insert into tab_trans values (5145,267597,915,'1995-4-18','VYDAJ','VYBER',29200.00,59199.70,NULL,NULL,NULL);
insert into tab_trans values (5145,267598,915,'1995-5-18','VYDAJ','VYBER',34700.00,63417.60,NULL,NULL,NULL);
insert into tab_trans values (5145,267599,915,'1995-6-9','VYDAJ','VYBER',50600.00,71113.20,NULL,NULL,NULL);
insert into tab_trans values (5145,267600,915,'1995-6-17','VYDAJ','VYBER',8900.00,47922.20,NULL,NULL,NULL);
insert into tab_trans values (5145,267601,915,'1995-7-17','VYDAJ','VYBER',12800.00,43330.20,NULL,NULL,NULL);
insert into tab_trans values (5145,267602,915,'1995-8-16','VYDAJ','VYBER',16600.00,43512.20,NULL,NULL,NULL);
insert into tab_trans values (5145,267603,915,'1995-9-15','VYDAJ','VYBER',16300.00,51799.40,NULL,NULL,NULL);
insert into tab_trans values (5145,3560650,915,'1995-2-28','PRIJEM',NULL,55.70,31249.70,'UROK',NULL,NULL);
insert into tab_trans values (5145,3560651,915,'1995-3-31','PRIJEM',NULL,162.00,49705.70,'UROK',NULL,NULL);
insert into tab_trans values (5145,3560652,915,'1995-4-30','PRIJEM',NULL,223.90,59423.60,'UROK',NULL,NULL);
insert into tab_trans values (5145,3560653,915,'1995-5-31','PRIJEM',NULL,254.60,63672.20,'UROK',NULL,NULL);
insert into tab_trans values (5145,3560654,915,'1995-6-30','PRIJEM',NULL,219.70,40841.90,'UROK',NULL,NULL);
insert into tab_trans values (5145,3560655,915,'1995-7-31','PRIJEM',NULL,193.50,43523.80,'UROK',NULL,NULL);
insert into tab_trans values (5145,3560656,915,'1995-8-31','PRIJEM',NULL,198.90,43711.00,'UROK',NULL,NULL);
insert into tab_trans values (5147,273705,938,'1997-12-13','PRIJEM','VKLAD',700.00,700.00,NULL,NULL,NULL);
insert into tab_trans values (5147,273718,938,'1998-1-13','PRIJEM','VKLAD',4923.00,18223.00,NULL,NULL,NULL);
insert into tab_trans values (5147,273719,938,'1998-2-13','PRIJEM','VKLAD',4923.00,24792.50,NULL,NULL,NULL);
insert into tab_trans values (5147,273720,938,'1998-3-13','PRIJEM','VKLAD',4923.00,29807.10,NULL,NULL,NULL);
insert into tab_trans values (5147,273721,938,'1998-4-13','PRIJEM','VKLAD',4923.00,30735.20,NULL,NULL,NULL);
insert into tab_trans values (5147,273722,938,'1998-5-13','PRIJEM','VKLAD',4923.00,31277.60,NULL,NULL,NULL);
insert into tab_trans values (5147,273830,938,'1998-1-12','PRIJEM','VKLAD',12600.00,13300.00,NULL,NULL,NULL);
insert into tab_trans values (5147,273831,938,'1998-2-11','PRIJEM','VKLAD',1600.00,19869.50,NULL,NULL,NULL);
insert into tab_trans values (5147,273832,938,'1998-3-13','VYDAJ','VYBER',4300.00,25507.10,NULL,NULL,NULL);
insert into tab_trans values (5147,273833,938,'1998-4-12','PRIJEM','VKLAD',200.00,25812.20,NULL,NULL,NULL);
insert into tab_trans values (5147,273834,938,'1998-5-12','VYDAJ','VYBER',4500.00,26354.60,NULL,NULL,NULL);
insert into tab_trans values (5147,3561519,938,'1998-1-31','PRIJEM',NULL,46.50,18269.50,'UROK',NULL,NULL);
insert into tab_trans values (5147,3561520,938,'1998-2-28','PRIJEM',NULL,91.60,24884.10,'UROK',NULL,NULL);
insert into tab_trans values (5147,3561521,938,'1998-3-31','PRIJEM',NULL,105.10,25612.20,'UROK',NULL,NULL);
insert into tab_trans values (5147,3561522,938,'1998-4-30','PRIJEM',NULL,119.40,30854.60,'UROK',NULL,NULL);
insert into tab_trans values (5148,274158,940,'1994-11-15','PRIJEM','VKLAD',300.00,300.00,NULL,NULL,NULL);
insert into tab_trans values (5148,274170,940,'1994-12-11','PRIJEM','PREVOD Z UCTU',56756.00,57056.00,NULL,'ST','99876164');
insert into tab_trans values (5148,274171,940,'1995-1-11','PRIJEM','PREVOD Z UCTU',37837.00,78886.60,NULL,'ST','99876164');
insert into tab_trans values (5148,274172,940,'1995-2-11','PRIJEM','PREVOD Z UCTU',37837.00,89820.40,NULL,'ST','99876164');
insert into tab_trans values (5148,274173,940,'1995-3-11','PRIJEM','PREVOD Z UCTU',37837.00,94384.00,NULL,'ST','99876164');
insert into tab_trans values (5148,274174,940,'1995-4-11','PRIJEM','PREVOD Z UCTU',37837.00,99266.80,NULL,'ST','99876164');
insert into tab_trans values (5148,274175,940,'1995-5-11','PRIJEM','PREVOD Z UCTU',37837.00,67470.60,NULL,'ST','99876164');
insert into tab_trans values (5148,274176,940,'1995-6-11','PRIJEM','PREVOD Z UCTU',56756.00,87289.00,NULL,'ST','99876164');
insert into tab_trans values (5148,274177,940,'1995-7-11','PRIJEM','PREVOD Z UCTU',37837.00,80044.90,NULL,'ST','99876164');
insert into tab_trans values (5148,274178,940,'1995-8-11','PRIJEM','PREVOD Z UCTU',37837.00,83824.70,NULL,'ST','99876164');
insert into tab_trans values (5148,274179,940,'1995-9-11','PRIJEM','PREVOD Z UCTU',37837.00,97275.00,NULL,'ST','99876164');
insert into tab_trans values (5148,274180,940,'1995-10-11','PRIJEM','PREVOD Z UCTU',37837.00,88947.80,NULL,'ST','99876164');
insert into tab_trans values (5148,274181,940,'1995-11-11','PRIJEM','PREVOD Z UCTU',37837.00,91491.40,NULL,'ST','99876164');
insert into tab_trans values (5148,274182,940,'1995-12-11','PRIJEM','PREVOD Z UCTU',56756.00,105636.20,NULL,'ST','99876164');
insert into tab_trans values (5148,274183,940,'1996-1-11','PRIJEM','PREVOD Z UCTU',37837.00,91275.20,NULL,'ST','99876164');
insert into tab_trans values (5148,274184,940,'1996-2-11','PRIJEM','PREVOD Z UCTU',37837.00,99245.10,NULL,'ST','99876164');
insert into tab_trans values (5148,274185,940,'1996-3-11','PRIJEM','PREVOD Z UCTU',37837.00,109361.90,NULL,'ST','99876164');
insert into tab_trans values (5148,274186,940,'1996-4-11','PRIJEM','PREVOD Z UCTU',37837.00,74831.10,NULL,'ST','99876164');
insert into tab_trans values (5148,274187,940,'1996-5-11','PRIJEM','PREVOD Z UCTU',37837.00,99217.30,NULL,'ST','99876164');
insert into tab_trans values (5148,274234,940,'1995-4-25','VYDAJ','VYBER',4500.00,49206.80,NULL,NULL,'0');
insert into tab_trans values (5148,274235,940,'1995-5-8','VYDAJ','VYBER',6000.00,29633.60,NULL,NULL,'0');
insert into tab_trans values (5148,274236,940,'1995-6-2','VYDAJ','VYBER',4400.00,43457.00,NULL,NULL,'0');
insert into tab_trans values (5148,274237,940,'1995-7-6','VYDAJ','VYBER',5700.00,42207.90,NULL,NULL,'0');
insert into tab_trans values (5148,274238,940,'1995-8-13','VYDAJ','VYBER',4300.00,59224.70,NULL,NULL,'0');
insert into tab_trans values (5148,274239,940,'1995-9-19','VYDAJ','VYBER',4200.00,58875.00,NULL,NULL,'0');
insert into tab_trans values (5148,274240,940,'1995-10-7','VYDAJ','VYBER',3500.00,51110.80,NULL,NULL,'0');
insert into tab_trans values (5148,274241,940,'1995-11-21','VYDAJ','VYBER',4500.00,74391.40,NULL,NULL,'0');
insert into tab_trans values (5148,274242,940,'1995-12-3','VYDAJ','VYBER',5800.00,68880.20,NULL,NULL,'0');
insert into tab_trans values (5148,274243,940,'1996-1-14','VYDAJ','VYBER',3900.00,87375.20,NULL,NULL,'0');
insert into tab_trans values (5148,274244,940,'1996-2-8','VYDAJ','VYBER',5400.00,82308.10,NULL,NULL,'0');
insert into tab_trans values (5148,274245,940,'1996-3-21','VYDAJ','VYBER',4300.00,41747.90,NULL,NULL,'0');
insert into tab_trans values (5148,274246,940,'1996-4-4','VYDAJ','VYBER',4900.00,37094.10,NULL,NULL,'0');
insert into tab_trans values (5148,274247,940,'1996-5-12','VYDAJ','VYBER',4600.00,94617.30,NULL,NULL,'0');
insert into tab_trans values (5148,274283,940,'1995-7-16','VYBER','VYBER',4857.00,52087.90,NULL,NULL,NULL);
insert into tab_trans values (5148,274284,940,'1995-4-18','VYBER','VYBER',14160.00,53706.80,NULL,NULL,NULL);
insert into tab_trans values (5148,274285,940,'1995-6-8','VYBER','VYBER',12924.00,30533.00,NULL,NULL,NULL);
insert into tab_trans values (5148,274297,940,'1996-3-15','VYBER','VYBER',6514.00,46047.90,NULL,NULL,NULL);
insert into tab_trans values (5148,274313,940,'1996-1-6','VYDAJ','VYBER',15000.00,64038.20,NULL,NULL,NULL);
insert into tab_trans values (5148,274317,940,'1995-12-8','VYDAJ','VYBER',3300.00,65580.20,NULL,NULL,NULL);
insert into tab_trans values (5148,274324,940,'1995-7-19','VYDAJ','VYBER',6300.00,45787.90,NULL,NULL,NULL);
insert into tab_trans values (5148,274326,940,'1995-5-7','VYDAJ','VYBER',13800.00,35633.60,NULL,NULL,NULL);
insert into tab_trans values (5148,274327,940,'1995-11-13','VYDAJ','VYBER',12600.00,78891.40,NULL,NULL,NULL);
insert into tab_trans values (5148,274328,940,'1995-9-30','VYDAJ'