/*
 * Decompiled with CFR 0.152.
 */
package model.reframe;

import data.catalog.Catalog;
import data.instance.Instances;
import data.parameter.NumericShiftFunction;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.Random;
import java.util.stream.Collectors;
import model.Model;
import model.ModelOptions;
import model.reframe.Reframer;
import util.GlobalRandom;

public class RRS
extends Reframer {
    public RRS(Model baseCls, ModelOptions opt) {
        super(baseCls, opt);
    }

    public RRS(Model baseCls, ModelOptions opt, boolean i, boolean o) {
        super(baseCls, opt, i, o);
    }

    @Override
    public void reframe(Instances deploy, Catalog cat) throws Exception {
        if (this.input) {
            this.shifts.addAll(this.cls.getShifts());
        }
        if (this.shifts.isEmpty()) {
            this.input = false;
        }
        if (!this.opts.mode.equals("regression")) {
            this.output = false;
        }
        this.cls.deployShifts(deploy, cat);
        Random r = GlobalRandom.instance();
        for (NumericShiftFunction sh2 : this.shifts) {
            double[] parTrain = sh2.getParamsOrig();
            double[] parDeploy = sh2.getParamsDeploy();
            double baseAlpha = (parTrain[1] - parTrain[0]) / (parDeploy[1] - parDeploy[0]);
            double baseBeta = parTrain[0] - baseAlpha * parDeploy[0];
            sh2.setParameters(new double[]{baseAlpha, baseBeta});
        }
        double overallBestPerf = this.evaluatePerformance(deploy, cat);
        HashMap<NumericShiftFunction, double[]> origShifts = new HashMap<NumericShiftFunction, double[]>();
        for (NumericShiftFunction sh3 : this.shifts) {
            origShifts.put(sh3, Arrays.copyOf(sh3.getParameters(), sh3.getParameters().length));
        }
        ArrayList bestParams = new ArrayList();
        bestParams.add(origShifts);
        int i = 0;
        while (i < 1000) {
            double chosenBeta;
            double maxBeta;
            double minBeta;
            double chosenAlpha;
            double baseAlpha;
            double[] paramsDeploy;
            double[] paramsTrain;
            HashMap<NumericShiftFunction, double[]> currentParams = new HashMap<NumericShiftFunction, double[]>();
            if (this.input) {
                ArrayList inShifts = new ArrayList(this.shifts.stream().filter(sh -> !sh.isOutput()).collect(Collectors.toList()));
                for (NumericShiftFunction sh4 : inShifts) {
                    paramsTrain = sh4.getParamsOrig();
                    paramsDeploy = sh4.getParamsDeploy();
                    double m1 = paramsTrain[0];
                    double mm1 = paramsTrain[1];
                    double m2 = paramsDeploy[0];
                    double mm2 = paramsDeploy[1];
                    baseAlpha = (mm1 - m1) / (mm2 - m2);
                    chosenAlpha = Math.pow(10.0, 0.5 * r.nextGaussian()) * baseAlpha;
                    minBeta = m1 - chosenAlpha * mm2;
                    maxBeta = mm1 - chosenAlpha * m2;
                    chosenBeta = 0.5 * (minBeta + maxBeta + r.nextGaussian() * 0.5 * (maxBeta - minBeta));
                    currentParams.put(sh4, new double[]{chosenAlpha, chosenBeta});
                }
            }
            if (this.output) {
                ArrayList outShifts = new ArrayList(this.shifts.stream().filter(sh -> sh.isOutput()).collect(Collectors.toList()));
                for (NumericShiftFunction outShift : outShifts) {
                    paramsTrain = outShift.getParamsOrig();
                    paramsDeploy = outShift.getParamsDeploy();
                    double m2 = paramsTrain[0];
                    double mm2 = paramsTrain[1];
                    double m1 = paramsDeploy[0];
                    double mm1 = paramsDeploy[1];
                    baseAlpha = (mm1 - m1) / (mm2 - m2);
                    chosenAlpha = Math.pow(10.0, 0.5 * r.nextGaussian()) * baseAlpha;
                    minBeta = m1 - chosenAlpha * m2;
                    maxBeta = mm1 - chosenAlpha * m2;
                    chosenBeta = 0.5 * (minBeta + maxBeta + r.nextGaussian() * 0.5 * (maxBeta - minBeta));
                    currentParams.put(outShift, new double[]{chosenAlpha, chosenBeta});
                }
            }
            this.applyShifts(currentParams);
            double endPerf = this.evaluatePerformance(deploy, cat);
            if (endPerf >= overallBestPerf) {
                if (endPerf > overallBestPerf) {
                    overallBestPerf = endPerf;
                    bestParams.clear();
                }
                HashMap<NumericShiftFunction, double[]> toInsert = new HashMap<NumericShiftFunction, double[]>();
                for (Map.Entry<NumericShiftFunction, double[]> ent : currentParams.entrySet()) {
                    toInsert.put(ent.getKey(), Arrays.copyOf(ent.getValue(), ent.getValue().length));
                }
                bestParams.add(toInsert);
            }
            ++i;
        }
        HashMap chosenParams = null;
        if (bestParams.size() == 1) {
            chosenParams = (HashMap)bestParams.get(0);
        } else if (bestParams.size() > 1) {
            chosenParams = (HashMap)bestParams.get(r.nextInt(bestParams.size()));
        }
        if (chosenParams != null) {
            this.applyShifts(chosenParams);
        }
    }
}

