/*
 * Decompiled with CFR 0.152.
 */
package data.aggregate;

import data.aggregate.AggregateFunction;
import data.aggregate.sensitivity.SingletonSensitivity;
import data.kind.Numeric;
import data.value.Value;
import java.util.ArrayList;
import java.util.function.BiConsumer;
import java.util.function.BinaryOperator;
import java.util.function.Function;
import java.util.function.Supplier;
import util.Couple;

public class StandardDeviation
extends AggregateFunction<Couple<Double[], Long>> {
    public StandardDeviation() {
        this.sensitivity = new SingletonSensitivity();
        this.funcTypeIn = new Numeric();
        this.funcTypeOut = new Numeric();
        this.needsFeature = true;
        this.name = "std";
    }

    @Override
    public Value applyFunction(ArrayList<Value> s) {
        Double sumSqr = 0.0;
        Double sum = 0.0;
        for (Value val : s) {
            Double curr = val.getNumericValue();
            sumSqr = sumSqr + curr * curr;
            sum = sum + curr;
        }
        Double var = ((double)s.size() * sumSqr - sum * sum) / (double)(s.size() * s.size());
        Double res = var < 0.0 ? 0.0 : Math.sqrt(var);
        return new Value(res);
    }

    @Override
    public Supplier<Couple<Double[], Long>> supplier() {
        return () -> new Couple<Double[], Long>(new Double[]{0.0, 0.0}, 0L);
    }

    @Override
    public BiConsumer<Couple<Double[], Long>, Value> accumulator() {
        return (accum, val) -> {
            double v = val.getNumericValue();
            Double[] doubleArray = (Double[])accum.getLeft();
            doubleArray[0] = doubleArray[0] + v * v;
            Double[] doubleArray2 = (Double[])accum.getLeft();
            doubleArray2[1] = doubleArray2[1] + v;
            accum.setRight((Long)accum.getRight() + 1L);
        };
    }

    @Override
    public BinaryOperator<Couple<Double[], Long>> combiner() {
        return (a, b) -> {
            Double[] doubleArray = (Double[])a.getLeft();
            doubleArray[0] = doubleArray[0] + ((Double[])b.getLeft())[0];
            Double[] doubleArray2 = (Double[])a.getLeft();
            doubleArray2[1] = doubleArray2[1] + ((Double[])b.getLeft())[1];
            a.setRight((Long)a.getRight() + (Long)b.getRight());
            return a;
        };
    }

    @Override
    public Function<Couple<Double[], Long>, Value> finisher() {
        return a -> {
            if ((Long)a.getRight() < 2L) {
                return new Value(null);
            }
            double sumSqr = ((Double[])a.getLeft())[0];
            double sum = ((Double[])a.getLeft())[1];
            double n = ((Long)a.getRight()).doubleValue();
            double var = (n * sumSqr - sum * sum) / (n * n);
            double res = var < 0.0 ? 0.0 : Math.sqrt(var);
            return new Value(res);
        };
    }
}

