/*
 * Decompiled with CFR 0.152.
 */
package ida.ilp.treeLiker;

import ida.ilp.treeLiker.Aggregable;
import ida.ilp.treeLiker.Aggregables;
import ida.ilp.treeLiker.aggregables.VoidAggregables;
import ida.utils.VectorUtils;
import ida.utils.collections.IntegerSet;
import java.util.Arrays;

public class Domain {
    private int hashCode = -1;
    private IntegerSet integerSet;
    private Aggregables aggregables;
    public static final Domain emptyDomain = new Domain(IntegerSet.emptySet);

    public Domain(IntegerSet integerSet) {
        this.integerSet = integerSet;
        this.aggregables = VoidAggregables.construct(integerSet.size());
    }

    public Domain(IntegerSet integerSet, Aggregables aggregables) {
        this.integerSet = integerSet;
        this.aggregables = aggregables;
    }

    public IntegerSet integerSet() {
        return this.integerSet;
    }

    public Aggregables aggregables() {
        return this.aggregables;
    }

    public static Domain[] cross(Domain[] a, Domain[] b) {
        Domain[] retVal = new Domain[a.length];
        for (int i = 0; i < a.length; ++i) {
            retVal[i] = Domain.cross(a[i], b[i]);
        }
        return retVal;
    }

    public static Domain cross(Domain a, Domain b) {
        IntegerSet newIntegerSet = IntegerSet.intersection(a.integerSet(), b.integerSet());
        if (newIntegerSet.isEmpty()) {
            return emptyDomain;
        }
        Aggregables newAggregables = null;
        if (a.aggregables instanceof VoidAggregables || b.aggregables instanceof VoidAggregables) {
            newAggregables = VoidAggregables.construct(newIntegerSet.size());
        } else {
            int indexA = 0;
            int indexB = 0;
            int[] newValues = newIntegerSet.values();
            int[] aValues = a.integerSet.values();
            int[] bValues = b.integerSet.values();
            newAggregables = new Aggregables(newValues.length);
            for (int i = 0; i < newValues.length; ++i) {
                int val = newValues[i];
                while (aValues[indexA] < val) {
                    ++indexA;
                }
                while (bValues[indexB] < val) {
                    ++indexB;
                }
                newAggregables.add(a.aggregables.get(indexA).cross((Aggregable)b.aggregables.get(indexB)));
            }
        }
        return new Domain(newIntegerSet, newAggregables);
    }

    public Domain select(IntegerSet selectedValues) {
        IntegerSet newIntegerSet = IntegerSet.intersection(this.integerSet, selectedValues);
        if (newIntegerSet.isEmpty()) {
            return emptyDomain;
        }
        Aggregables<Object> newAggregables = new Aggregables<Object>(newIntegerSet.size());
        int[] values = this.integerSet.values();
        int[] selected = newIntegerSet.values();
        int index = 0;
        for (int i = 0; i < values.length; ++i) {
            if (values[i] != selected[index]) continue;
            newAggregables.add(this.aggregables.get(i));
            ++index;
        }
        return new Domain(newIntegerSet, newAggregables);
    }

    public boolean isEmpty() {
        return this.integerSet.isEmpty();
    }

    public Aggregable getAggregableByDomainElement(int key) {
        int index = Arrays.binarySearch(this.integerSet.values(), key);
        if (index >= 0) {
            return this.aggregables.get(index);
        }
        return null;
    }

    public boolean equals(Object o) {
        if (o instanceof Domain) {
            Domain d = (Domain)o;
            if (this.hashCode() != d.hashCode()) {
                return false;
            }
            return this.integerSet.equals(d.integerSet) && this.aggregables.equals(d.aggregables);
        }
        return false;
    }

    public int hashCode() {
        if (this.hashCode == -1) {
            int hash = 7;
            hash = 97 * hash + (this.integerSet != null ? this.integerSet.hashCode() : 0);
            this.hashCode = hash = 97 * hash + (this.aggregables != null ? this.aggregables.hashCode() : 0);
        }
        return this.hashCode;
    }

    public String toString() {
        return "Domain[" + VectorUtils.intArrayToString(this.integerSet.values()) + ", " + this.aggregables + "]";
    }

    public static boolean allAreSubsets(Domain[] a, Domain[] b, boolean[] mask) {
        for (int i = 0; i < a.length; ++i) {
            if (!mask[i] || a[i].integerSet.isSubsetOf(b[i].integerSet)) continue;
            return false;
        }
        return true;
    }

    public static int countNonEmpty(Domain[] domains, boolean[] mask) {
        int count = 0;
        for (int i = 0; i < domains.length; ++i) {
            if (!mask[i] || domains[i].integerSet.isEmpty()) continue;
            ++count;
        }
        return count;
    }

    public static int countNonEmpty(Domain[] domains) {
        int count = 0;
        for (int i = 0; i < domains.length; ++i) {
            if (domains[i].integerSet.isEmpty()) continue;
            ++count;
        }
        return count;
    }
}

