/*
 * Decompiled with CFR 0.152.
 */
package proper.tester.engine;

import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Random;
import proper.tester.database.Column;
import proper.tester.database.DatabaseConfig;
import proper.tester.database.Table;
import proper.tester.engine.Labeler;

public class DatabaseEngine {
    private static DatabaseEngine instance = null;
    private static final long RANDOM_SEED = 0L;
    private boolean isConnected = false;
    private Connection conn;
    private Random random;

    private DatabaseEngine() {
    }

    public static DatabaseEngine getInstance() {
        if (instance == null) {
            instance = new DatabaseEngine();
        }
        return instance;
    }

    public boolean connect(String type, String server, String database, String user, String password) {
        return this.connect(type, server, DatabaseConfig.getDefaultPort(type), database, user, password);
    }

    public boolean connect(String type, String server, String port, String database, String user, String password) {
        return this.connect(DatabaseConfig.getDriver(type), DatabaseConfig.buildURL(type, server, port, database), user, password);
    }

    public Connection getConnection() {
        return this.conn;
    }

    private boolean connect(String driver, String url, String user, String password) {
        boolean result = true;
        if (!this.isConnected) {
            try {
                Class.forName(driver);
                this.conn = DriverManager.getConnection(url, user, password);
                this.isConnected = true;
            }
            catch (SQLException e) {
                result = false;
                e.printStackTrace();
            }
            catch (Exception e) {
                result = false;
                e.printStackTrace();
            }
        }
        return result;
    }

    public boolean disconnect() {
        boolean result = true;
        if (this.isConnected) {
            try {
                this.conn.close();
                this.isConnected = false;
            }
            catch (SQLException e) {
                result = false;
                e.printStackTrace();
            }
        }
        return result;
    }

    private boolean getRelations(Table table) {
        boolean result = false;
        Table parent = (Table)table.getParent();
        if (this.isConnected) {
            try {
                Table child;
                String tableName;
                ResultSet exportSet = this.conn.getMetaData().getExportedKeys(null, null, table.getName());
                while (exportSet.next()) {
                    tableName = exportSet.getString("FKTABLE_NAME");
                    child = this.getTableInfo(tableName);
                    if (parent != null && (parent.equals(child) || table.containsChild(child))) continue;
                    child.setParent(table);
                    child.setAllowsChildren(true);
                    this.getRelations(child);
                    table.addChild(child);
                }
                ResultSet importSet = this.conn.getMetaData().getImportedKeys(null, null, table.getName());
                while (importSet.next()) {
                    tableName = importSet.getString("PKTABLE_NAME");
                    child = this.getTableInfo(tableName);
                    if (parent != null && (parent.equals(child) || table.containsChild(child))) continue;
                    child.setParent(table);
                    child.setAllowsChildren(true);
                    this.getRelations(child);
                    table.addChild(child);
                }
                exportSet.close();
                importSet.close();
                result = true;
            }
            catch (SQLException e) {
                e.printStackTrace();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return result;
    }

    private Table getTableInfo(String name) {
        Table result = null;
        if (this.isConnected) {
            try {
                result = new Table(name);
                result.setNbInstances(0);
                ResultSet tableSet = this.conn.getMetaData().getTables(null, null, name, new String[]{"TABLE"});
                while (tableSet.next()) {
                    Column tmpCol;
                    ResultSet columnsSet = this.conn.getMetaData().getPrimaryKeys(null, null, name);
                    while (columnsSet.next()) {
                        tmpCol = new Column(columnsSet.getString("COLUMN_NAME"));
                        tmpCol.isPk(true);
                        tmpCol.setMaxValue("1");
                        if (result.containsColumn(tmpCol)) continue;
                        result.addColumn(tmpCol);
                    }
                    columnsSet.close();
                    columnsSet = this.conn.getMetaData().getImportedKeys(null, null, name);
                    while (columnsSet.next()) {
                        tmpCol = new Column(columnsSet.getString("FKCOLUMN_NAME"));
                        tmpCol.isFk(true, columnsSet.getString("PKTABLE_NAME"));
                        tmpCol.setMaxValue("1");
                        if (result.containsColumn(tmpCol)) continue;
                        result.addColumn(tmpCol);
                    }
                    columnsSet.close();
                    columnsSet = this.conn.getMetaData().getColumns(null, null, name, null);
                    while (columnsSet.next()) {
                        tmpCol = new Column(columnsSet.getString("COLUMN_NAME"));
                        tmpCol.setMaxValue("1");
                        if (result.containsColumn(tmpCol)) continue;
                        result.addColumn(tmpCol);
                    }
                    columnsSet.close();
                }
                tableSet.close();
            }
            catch (SQLException e) {
                e.printStackTrace();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return result;
    }

    public Table discoverRelations(String rootTableName) {
        Table result = null;
        if (this.isConnected) {
            result = this.getTableInfo(rootTableName);
            this.getRelations(result);
        }
        return result;
    }

    private boolean generateRootData(Table table) {
        boolean result = true;
        int nbInstance = table.getNbInstances();
        if (this.isConnected) {
            try {
                int i = 0;
                while (i < nbInstance) {
                    String insertSql = "INSERT INTO " + table.getName() + " (";
                    String valuesSql = "VALUES (";
                    int commaCount = 0;
                    int colCount = 0;
                    while (colCount < table.getColumnCount()) {
                        Column tmpCol = table.getColumnAt(colCount);
                        if (!tmpCol.equals(Labeler.getInstance().getLabeledColumn()) && !tmpCol.isFk()) {
                            if (commaCount != 0) {
                                insertSql = String.valueOf(insertSql) + ",";
                                valuesSql = String.valueOf(valuesSql) + ",";
                            }
                            if (tmpCol.isPk()) {
                                insertSql = String.valueOf(insertSql) + tmpCol.getName();
                                valuesSql = String.valueOf(valuesSql) + Integer.toString(i);
                            } else {
                                insertSql = String.valueOf(insertSql) + tmpCol.getName();
                                valuesSql = String.valueOf(valuesSql) + this.random(tmpCol.getMaxValue());
                            }
                            ++commaCount;
                        }
                        ++colCount;
                    }
                    valuesSql = String.valueOf(valuesSql) + ");";
                    insertSql = String.valueOf(insertSql) + ") " + valuesSql;
                    Statement insertStatement = this.conn.createStatement(1004, 1008);
                    System.out.println("Inserting(RD): " + insertSql);
                    insertStatement.executeUpdate(insertSql);
                    insertStatement.close();
                    ++i;
                }
            }
            catch (SQLException e) {
                result = false;
                e.printStackTrace();
            }
            catch (Exception e) {
                result = false;
                e.printStackTrace();
            }
        }
        return result;
    }

    private boolean generateFKData(Table table) {
        boolean result = true;
        Table parent = (Table)table.getParent();
        int idCount = 0;
        String selectSql = "SELECT " + parent.getPrimaryKey().getName() + " AS PK FROM " + parent.getName();
        if (this.isConnected) {
            try {
                Statement selectStatement = this.conn.createStatement(1004, 1008);
                ResultSet selectSet = selectStatement.executeQuery(selectSql);
                while (selectSet.next()) {
                    String parentPk = selectSet.getString("PK");
                    int nbInstance = 1;
                    nbInstance = this.random(table.getNbInstances());
                    int i = 0;
                    while (i < nbInstance) {
                        String insertSql = "INSERT INTO " + table.getName() + " (";
                        String valuesSql = "VALUES (";
                        int commaCount = 0;
                        int colCount = 0;
                        while (colCount < table.getColumnCount()) {
                            Column tmpCol = table.getColumnAt(colCount);
                            if (!(tmpCol.equals(Labeler.getInstance().getLabeledColumn()) || tmpCol.isFk() && !parent.containsColumn(tmpCol))) {
                                if (commaCount != 0) {
                                    insertSql = String.valueOf(insertSql) + ",";
                                    valuesSql = String.valueOf(valuesSql) + ",";
                                }
                                if (tmpCol.isPk()) {
                                    insertSql = String.valueOf(insertSql) + tmpCol.getName();
                                    valuesSql = String.valueOf(valuesSql) + Integer.toString(idCount);
                                } else if (tmpCol.isFk() && parent.equals(tmpCol.getFkTable())) {
                                    insertSql = String.valueOf(insertSql) + tmpCol.getName();
                                    valuesSql = String.valueOf(valuesSql) + parentPk;
                                } else if (!tmpCol.isFk()) {
                                    insertSql = String.valueOf(insertSql) + tmpCol.getName();
                                    valuesSql = String.valueOf(valuesSql) + this.random(tmpCol.getMaxValue());
                                }
                                ++commaCount;
                            }
                            ++colCount;
                        }
                        valuesSql = String.valueOf(valuesSql) + ");";
                        insertSql = String.valueOf(insertSql) + ") " + valuesSql;
                        Statement insertStatement = this.conn.createStatement(1004, 1008);
                        System.out.println("Inserting(FK): " + insertSql);
                        insertStatement.executeUpdate(insertSql);
                        insertStatement.close();
                        ++idCount;
                        ++i;
                    }
                }
            }
            catch (SQLException e) {
                result = false;
                e.printStackTrace();
            }
            catch (Exception e) {
                result = false;
                e.printStackTrace();
            }
        }
        return result;
    }

    private boolean generateSimpleData(Table table) {
        boolean result = true;
        Table parent = (Table)table.getParent();
        int nbInstances = 0;
        try {
            Statement selectStatement = this.conn.createStatement(1004, 1008);
            ResultSet selectSet = selectStatement.executeQuery("SELECT COUNT(*) AS NB FROM " + parent.getName() + ";");
            while (selectSet.next()) {
                nbInstances = selectSet.getInt("NB");
            }
            selectSet.close();
            selectStatement.close();
        }
        catch (SQLException e) {
            result = false;
            e.printStackTrace();
        }
        catch (Exception e) {
            result = false;
            e.printStackTrace();
        }
        int i = 0;
        while (i < nbInstances) {
            String sqlInsert = "INSERT INTO " + table.getName() + " (";
            String sqlValues = "VALUES (";
            int commaCount = 0;
            int colCount = 0;
            while (colCount < table.getColumnCount()) {
                Column tmpCol = table.getColumnAt(colCount);
                if (!tmpCol.equals(Labeler.getInstance().getLabeledColumn()) && !tmpCol.isFk()) {
                    if (commaCount != 0) {
                        sqlInsert = String.valueOf(sqlInsert) + ", ";
                        sqlValues = String.valueOf(sqlValues) + ", ";
                    }
                    sqlInsert = String.valueOf(sqlInsert) + tmpCol.getName();
                    sqlValues = tmpCol.isPk() ? String.valueOf(sqlValues) + Integer.toString(i) : String.valueOf(sqlValues) + this.random(tmpCol.getMaxValue());
                    ++commaCount;
                }
                ++colCount;
            }
            sqlValues = String.valueOf(sqlValues) + ");";
            sqlInsert = String.valueOf(sqlInsert) + ") " + sqlValues;
            if (this.isConnected) {
                try {
                    Statement insertStatement = this.conn.createStatement(1004, 1008);
                    System.out.println("Inserting(SD): " + sqlInsert);
                    insertStatement.executeUpdate(sqlInsert);
                    insertStatement.close();
                }
                catch (SQLException e) {
                    e.printStackTrace();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            ++i;
        }
        return result;
    }

    private boolean generateData(Table table) {
        boolean result = true;
        if (result) {
            result = !table.isRoot() ? (table.containsColumn(((Table)table.getParent()).getPrimaryKey()) ? this.generateFKData(table) : this.generateSimpleData(table)) : this.generateRootData(table);
        }
        if (result) {
            int childCount = 0;
            while (childCount < table.getChildCount()) {
                result = this.generateData((Table)table.getChildAt(childCount));
                ++childCount;
            }
        }
        return result;
    }

    private boolean linkGeneratedData(Table table) {
        boolean result = true;
        int i = 0;
        while (i < table.getChildCount()) {
            Table child = (Table)table.getChildAt(i);
            result = this.linkGeneratedData(child);
            ++i;
        }
        if (result) {
            i = 0;
            while (i < table.getColumnCount()) {
                Table parent = (Table)table.getParent();
                Column tmpCol = table.getColumnAt(i);
                if (tmpCol.isFk() && (table.isRoot() || !parent.equals(tmpCol.getFkTable()))) {
                    int nbInstances = 1;
                    String selectFkSql = "SELECT " + tmpCol.getName() + " AS FK_COL FROM " + tmpCol.getFkTable() + ";";
                    String selectPkSql = "SELECT " + table.getPrimaryKey().getName() + " AS PK_COL FROM " + table.getName() + ";";
                    if (this.isConnected) {
                        try {
                            Statement selectFkStatement = this.conn.createStatement(1004, 1008);
                            Statement selectPkStatement = this.conn.createStatement(1004, 1008);
                            ResultSet selectFkSet = selectFkStatement.executeQuery(selectFkSql);
                            ResultSet selectPkSet = selectPkStatement.executeQuery(selectPkSql);
                            Statement updateStatement = this.conn.createStatement(1004, 1008);
                            while (selectFkSet.next()) {
                                String fkValue = selectFkSet.getString("FK_COL");
                                int j = 0;
                                while (j < nbInstances && selectPkSet.next()) {
                                    String pkValue = selectPkSet.getString("PK_COL");
                                    String updateSql = "UPDATE " + table.getName() + " SET " + tmpCol.getName() + "=" + fkValue + " WHERE " + table.getPrimaryKey().getName() + "=" + pkValue + ";";
                                    updateStatement.executeUpdate(updateSql);
                                    ++j;
                                }
                            }
                            selectFkSet.close();
                            selectPkSet.close();
                            selectFkStatement.close();
                            selectPkStatement.close();
                        }
                        catch (SQLException e) {
                            result = false;
                            e.printStackTrace();
                        }
                        catch (Exception e) {
                            result = false;
                            e.printStackTrace();
                        }
                    }
                }
                ++i;
            }
        }
        return result;
    }

    public String buildLabelingSelect(Table tableCondition) {
        String result = null;
        String sql = null;
        Column conditionColumn = null;
        Column selectedColumn = tableCondition.getPrimaryKey();
        int limit = Labeler.getInstance().getLimitCondition();
        int[] cardinality = Labeler.getInstance().getCardinality();
        int iterCardinality = Labeler.getInstance().getDepth() - 1;
        Table parent = (Table)tableCondition.getParent();
        Column parentSelectedColumn = parent.getPrimaryKey();
        if (!tableCondition.isRoot()) {
            Column tmpCol;
            int i = 0;
            while (i < tableCondition.getColumnCount()) {
                tmpCol = tableCondition.getColumnAt(i);
                if (tmpCol.equals(Labeler.getInstance().getColumnCondition())) {
                    conditionColumn = tmpCol;
                }
                if (tmpCol.isFk() && ((Table)tableCondition.getParent()).containsColumn(tmpCol)) {
                    selectedColumn = tmpCol;
                }
                ++i;
            }
            sql = "SELECT " + selectedColumn.getName() + " FROM " + tableCondition.getName() + " WHERE " + conditionColumn.getName() + "<=" + limit + " GROUP BY " + selectedColumn.getName();
            while (!parent.isRoot()) {
                sql = String.valueOf(sql) + " HAVING COUNT(*) <= " + cardinality[iterCardinality];
                --iterCardinality;
                parentSelectedColumn = parent.getPrimaryKey();
                i = 0;
                while (i < parent.getColumnCount()) {
                    tmpCol = parent.getColumnAt(i);
                    if (tmpCol.isFk() && ((Table)parent.getParent()).containsColumn(tmpCol)) {
                        parentSelectedColumn = tmpCol;
                    }
                    ++i;
                }
                sql = "SELECT " + parentSelectedColumn.getName() + " FROM " + parent.getName() + " WHERE " + selectedColumn.getName() + " IN (" + sql + ") GROUP BY " + parentSelectedColumn.getName();
                parent = (Table)parent.getParent();
                selectedColumn = parentSelectedColumn;
            }
            sql = String.valueOf(sql) + " HAVING COUNT(*) >= " + cardinality[iterCardinality];
            result = sql = "SELECT " + parent.getPrimaryKey().getName() + " FROM " + parent.getName() + " WHERE " + parentSelectedColumn.getName() + " IN (" + sql + ") GROUP BY " + parent.getPrimaryKey().getName() + ";";
        }
        return result;
    }

    private Table labelingConditionTable(Table table) {
        Table result = null;
        Table child = null;
        int i = 0;
        while (i < table.getChildCount()) {
            child = this.labelingConditionTable((Table)table.getChildAt(i));
            if (child != null && child.equals(Labeler.getInstance().getTableCondition())) {
                result = child;
            }
            ++i;
        }
        if (table.equals(Labeler.getInstance().getTableCondition())) {
            result = table;
        }
        return result;
    }

    public boolean label(Table table) {
        boolean result = true;
        String matchLabel = Labeler.getInstance().getMatchLabel();
        String noMatchLabel = Labeler.getInstance().getNoMatchLabel();
        Column labeledColumn = Labeler.getInstance().getLabeledColumn();
        String selectSql = this.buildLabelingSelect(this.labelingConditionTable(table));
        String matchUpdateSql = "UPDATE " + table.getName() + " SET " + labeledColumn.getName() + "= '" + matchLabel + "' WHERE " + table.getPrimaryKey() + " IN (";
        String noMatchUpdateSql = "UPDATE " + table.getName() + " SET " + labeledColumn.getName() + "= '" + noMatchLabel + "' WHERE " + table.getPrimaryKey() + " NOT IN (";
        int commaCount = 0;
        if (this.isConnected) {
            try {
                Statement updateStatement = this.conn.createStatement(1004, 1008);
                Statement selectStatement = this.conn.createStatement(1004, 1008);
                ResultSet selectSet = selectStatement.executeQuery(selectSql);
                System.out.println("Lines to select: " + selectSql);
                commaCount = 0;
                while (selectSet.next()) {
                    if (commaCount != 0) {
                        matchUpdateSql = String.valueOf(matchUpdateSql) + ",";
                        noMatchUpdateSql = String.valueOf(noMatchUpdateSql) + ",";
                    }
                    matchUpdateSql = String.valueOf(matchUpdateSql) + selectSet.getString(1);
                    noMatchUpdateSql = String.valueOf(noMatchUpdateSql) + selectSet.getString(1);
                    ++commaCount;
                }
                matchUpdateSql = String.valueOf(matchUpdateSql) + ");";
                noMatchUpdateSql = String.valueOf(noMatchUpdateSql) + ");";
                if (commaCount > 0) {
                    System.out.println("Updating matching values: " + matchUpdateSql);
                    System.out.println("Updating other values: " + noMatchUpdateSql);
                    updateStatement.executeUpdate(matchUpdateSql);
                    updateStatement.executeUpdate(noMatchUpdateSql);
                } else {
                    noMatchUpdateSql = "UPDATE " + table.getName() + " SET " + labeledColumn.getName() + "= '" + noMatchLabel + "';";
                    System.out.println("Updating values: " + noMatchUpdateSql);
                    updateStatement.executeUpdate(noMatchUpdateSql);
                }
            }
            catch (SQLException e) {
                result = false;
                e.printStackTrace();
            }
            catch (Exception e) {
                result = false;
                e.printStackTrace();
            }
        }
        return result;
    }

    public boolean generation(Table table) {
        this.random = new Random(0L);
        boolean result = this.generateData(table);
        if (result) {
            result = this.linkGeneratedData(table);
        }
        return result;
    }

    private String random(String maxVal) {
        return Integer.toString(this.random(Integer.parseInt(maxVal)));
    }

    private int random(int maxVal) {
        int rnd = 0;
        if (maxVal > 0) {
            rnd = this.random.nextInt(maxVal) + 1;
        }
        return rnd;
    }

    public static void main(String[] args) {
        Table table = DatabaseEngine.getInstance().discoverRelations("train");
        Labeler.getInstance().setLabeledColumn(table.getColumnAt(1));
        int[] cardinality = new int[]{1, 1};
        Labeler.getInstance().setMatchLabel("east");
        Labeler.getInstance().setNoMatchLabel("west");
        Labeler.getInstance().setTableCondition("load1");
        Labeler.getInstance().setColumnCondition("load1_weight");
        Labeler.getInstance().setLimitCondition(5);
        Labeler.getInstance().setDepth(2);
        Labeler.getInstance().setCardinality(cardinality);
        DatabaseEngine.getInstance().generateData(table);
        DatabaseEngine.getInstance().linkGeneratedData(table);
        DatabaseEngine.getInstance().disconnect();
    }
}

