/*
 * Decompiled with CFR 0.152.
 */
package proper.remote;

import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringReader;
import java.net.Socket;
import proper.net.Data;
import proper.remote.Server;
import proper.remote.messages.Message;
import proper.util.Stopwatch;

public abstract class Processor
extends Thread {
    protected Server server;
    protected Socket client;
    protected Message msg;
    protected Data sender;
    protected int timeout;

    public Processor(Server server, Socket client) {
        this.server = server;
        this.client = client;
        this.timeout = 30;
        this.msg = this.readAll();
        this.sender = new Data();
        server.addListener(this.sender);
    }

    public void addToErrorLog(String msg) {
        this.server.addToErrorLog(msg);
    }

    public void addToAccessLog(String msg) {
        this.server.addToAccessLog(msg);
    }

    protected void waitForReader(Reader r) throws Exception {
        Stopwatch watch = new Stopwatch();
        while (watch.getSeconds() < (long)this.timeout && !r.ready()) {
        }
    }

    protected Message readAll() {
        Message result = null;
        if (this.client == null) {
            return result;
        }
        try {
            BufferedReader input = new BufferedReader(new InputStreamReader(this.client.getInputStream()));
            this.waitForReader(input);
            String line = "";
            while (input.ready()) {
                line = String.valueOf(line) + input.readLine() + "\n";
            }
            result = new Message(new StringReader(line));
            this.client.close();
        }
        catch (Exception e) {
            this.server.println(e);
            this.server.addToErrorLog(e.getMessage());
            result = null;
        }
        return result;
    }

    protected Message getMessage() {
        return this.msg;
    }

    protected Message createMessage() {
        return this.server.createMessage();
    }

    public Message createMessage(String request) {
        return this.server.createMessage(request);
    }

    protected String getRequest() {
        return this.msg.getType();
    }

    protected abstract void initialize() throws Exception;

    protected abstract boolean process() throws Exception;

    @Override
    public void run() {
        try {
            boolean result = this.process();
        }
        catch (Exception e) {
            this.server.println(e);
            boolean result = false;
        }
    }
}

