/*
 * Decompiled with CFR 0.152.
 */
package proper.remote;

import java.net.InetSocketAddress;
import java.util.Stack;

public class ClientList {
    private Stack clients = new Stack();
    private Stack jobs = new Stack();

    public int size() {
        return this.clients.size();
    }

    public InetSocketAddress get(int index) {
        if (index >= 0 && index < this.size()) {
            return (InetSocketAddress)this.clients.get(index);
        }
        return null;
    }

    public String getJob(int index) {
        if (index >= 0 && index < this.size()) {
            return (String)this.jobs.get(index);
        }
        return null;
    }

    public boolean contains(InetSocketAddress client) {
        return this.clients.contains(client);
    }

    public int indexOf(InetSocketAddress client) {
        return this.clients.indexOf(client);
    }

    public void add(InetSocketAddress client) {
        this.add(client, "");
    }

    public void add(InetSocketAddress client, String job) {
        this.clients.add(client);
        this.jobs.add(job);
    }

    public InetSocketAddress remove(int index) {
        this.jobs.remove(index);
        return (InetSocketAddress)this.clients.remove(index);
    }

    public InetSocketAddress remove(InetSocketAddress client) {
        if (this.clients.contains(client)) {
            return this.remove(this.clients.indexOf(client));
        }
        return null;
    }

    public void push(InetSocketAddress client) {
        this.push(client, "");
    }

    public void push(InetSocketAddress client, String job) {
        this.clients.push(client);
        this.jobs.push(job);
    }

    public InetSocketAddress pop() {
        if (this.clients.empty()) {
            return null;
        }
        this.jobs.pop();
        return (InetSocketAddress)this.clients.pop();
    }

    public InetSocketAddress peek() {
        if (this.clients.empty()) {
            return null;
        }
        return (InetSocketAddress)this.clients.peek();
    }

    public InetSocketAddress peekJob() {
        if (this.jobs.empty()) {
            return null;
        }
        return (InetSocketAddress)this.jobs.peek();
    }

    public String toString() {
        String result = "";
        int i = 0;
        while (i < this.size()) {
            result = String.valueOf(result) + this.get(i) + ": " + this.getJob(i) + "\n";
            ++i;
        }
        return result;
    }
}

