/*
 * Decompiled with CFR 0.152.
 */
package proper.relaggs;

import java.io.InputStream;
import java.util.Enumeration;
import java.util.Properties;
import java.util.StringTokenizer;

public class RelaggsConfig {
    private static String cfgfile = "proper/relaggs/relaggs.prop";
    private static Properties properties = new Properties();
    public static String dblimit_rows = "%ROWS%";
    public static String dblimit = "LIMIT " + dblimit_rows;
    public static boolean dbuseforeignkeys = false;
    public static String relaggs_tmpprefix = "_relaggstmp";
    public static int max_aggr_values = 40;
    public static int max_groups = 10;
    public static int min_avg_group_size = 20;
    public static double min_fill_percentage = 0.75;
    public static boolean use_builtin_stddev = true;
    public static boolean use_sample_stddev = true;

    static {
        RelaggsConfig.init();
    }

    private static void init() {
        try {
            InputStream is = RelaggsConfig.class.getResourceAsStream("/" + cfgfile);
            if (is != null) {
                properties.load(is);
                RelaggsConfig.getValues();
            } else {
                System.out.println("Can't find RELAGGS property file.");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            System.out.println("Reading RELAGGS property file unsuccessful.");
        }
    }

    public static void getValues() {
        dblimit = properties.getProperty("database_limit", dblimit);
        dblimit_rows = properties.getProperty("database_limit_rows", dblimit_rows);
        dbuseforeignkeys = Boolean.getBoolean(properties.getProperty("database_useforeignkeys", Boolean.toString(dbuseforeignkeys)));
        relaggs_tmpprefix = properties.getProperty("relaggs_tmpprefix", relaggs_tmpprefix);
        max_aggr_values = new Integer(properties.getProperty("max_aggr_values", Integer.toString(max_aggr_values)));
        max_groups = new Integer(properties.getProperty("max_groups", Integer.toString(max_groups)));
        min_avg_group_size = new Integer(properties.getProperty("min_avg_group_size", Integer.toString(min_avg_group_size)));
        min_fill_percentage = new Double(properties.getProperty("min_fill_percentage", Double.toString(min_fill_percentage)));
        use_builtin_stddev = Boolean.getBoolean(properties.getProperty("use_builtin_stddev", Boolean.toString(use_builtin_stddev)));
        use_sample_stddev = Boolean.getBoolean(properties.getProperty("use_sample_stddev", Boolean.toString(use_sample_stddev)));
    }

    public static boolean setProperty(String name, String value) {
        boolean result;
        if (properties.getProperty(name) != null) {
            properties.setProperty(name, value);
            RelaggsConfig.getValues();
            result = true;
        } else {
            System.out.println("RELAGGS: unknown property '" + name + "'!");
            result = false;
        }
        return result;
    }

    public static boolean setPropertiesList(String list) {
        boolean result = true;
        StringTokenizer tok = new StringTokenizer(list, ",");
        while (tok.hasMoreTokens()) {
            String pair = tok.nextToken();
            boolean bl = result = result && RelaggsConfig.setProperty(pair.substring(0, pair.indexOf("=")), pair.substring(pair.indexOf("=") + 1));
        }
        return result;
    }

    public static String getPropertiesList() {
        String result = "";
        Enumeration<?> enm = properties.propertyNames();
        while (enm.hasMoreElements()) {
            String name = enm.nextElement().toString();
            if (result.length() > 0) {
                result = String.valueOf(result) + ",";
            }
            result = String.valueOf(result) + name + "=" + properties.getProperty(name);
        }
        return result;
    }
}

