/*
 * Decompiled with CFR 0.152.
 */
package proper.gui.remote;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.MouseEvent;
import java.io.File;
import java.util.Hashtable;
import java.util.Vector;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTextField;
import javax.swing.ListModel;
import proper.app.Jobs;
import proper.gui.core.dialog.EditDialog;
import proper.gui.core.dialog.FileChooser;
import proper.gui.core.frame.ApplicationFrame;
import proper.gui.core.frame.ChildFrame;
import proper.gui.core.io.ImageLoader;
import proper.gui.core.io.SimpleFileFilter;
import proper.gui.core.list.JListHelper;
import proper.gui.core.list.List;
import proper.gui.core.table.JTableHelper;
import proper.gui.core.table.PropertyTable;
import proper.gui.core.table.TableSorter;
import proper.gui.remote.Generator;
import proper.io.Ant;
import proper.io.AntTarget;
import proper.io.TextFile;
import proper.util.ProperVector;
import proper.util.Strings;
import proper.util.Timestamp;
import proper.xml.Attribute;
import proper.xml.Comment;
import proper.xml.Document;
import proper.xml.Element;
import proper.xml.Path;

public class Jobber
extends ChildFrame {
    protected JTabbedPane tabbedPane;
    protected List listAvailableTargets;
    protected List listChosenTargets;
    protected List listJobs;
    protected JLabel labelJobfile;
    protected JPanel panelTargets;
    protected JPanel panelAvailableTargets;
    protected JPanel panelChosenTargets;
    protected JPanel panelParameter;
    protected JPanel panelProperties;
    protected JPanel panelJobs;
    protected JCheckBox checkExchange;
    protected JCheckBox checkAppend;
    protected JCheckBox checkProperties;
    protected JTextField textJobfile;
    protected JTextField textSearch;
    protected JButton buttonGenerate;
    protected JButton buttonExit;
    protected JButton buttonJobfile;
    protected JButton buttonReset;
    protected JButton buttonDeleteJob;
    protected JButton buttonSaveJobs;
    protected JButton buttonEditJob;
    protected JButton buttonSearch;
    protected JButton buttonStop;
    protected JButton buttonClear;
    protected JButton buttonAddFile;
    protected JButton buttonAdd;
    protected JButton buttonInsert;
    protected JButton buttonAddAll;
    protected JButton buttonAddSync;
    protected JButton buttonInsertSync;
    protected JButton buttonAddDist;
    protected JButton buttonDelete;
    protected JButton buttonDeleteAll;
    protected JButton buttonUp;
    protected JButton buttonDown;
    protected JButton buttonLoadTargets;
    protected JButton buttonSaveTargets;
    protected JScrollPane paneAvailableTargets;
    protected JScrollPane paneChosenTargets;
    protected JScrollPane paneProperties;
    protected JScrollPane paneJobs;
    protected PropertyTable tableProperties;
    protected FileChooser fileChooser;
    protected SimpleFileFilter filter;
    protected TableSorter sorterProperties;
    protected JMenuItem menuInsertSync;
    protected String jobfile;
    protected Hashtable files;
    protected Vector datasets;
    protected boolean exchange;
    protected boolean append;
    protected String[][] properties;
    protected Generator generator;

    public Jobber(ApplicationFrame parent) {
        super(parent, "Jobber");
    }

    @Override
    protected void initialize() {
        super.initialize();
        this.jobfile = "jobs";
        this.exchange = false;
        this.append = false;
        this.files = new Hashtable();
        this.datasets = new ProperVector();
        this.properties = new String[1][2];
        this.generator = null;
    }

    @Override
    protected void createFrame() {
        super.createFrame();
        this.setConfirmExit(false);
        this.getContentPane().setLayout(new BorderLayout());
        this.fileChooser = new FileChooser(new File(System.getProperty("user.dir")));
        this.panelTargets = new JPanel(new GridLayout(1, 2));
        this.panelProperties = new JPanel(new BorderLayout());
        this.panelJobs = new JPanel(new BorderLayout());
        this.tabbedPane = new JTabbedPane();
        this.tabbedPane.addTab("Targets", ImageLoader.getImageIcon("editor.gif"), this.panelTargets);
        this.tabbedPane.addTab("Properties", ImageLoader.getImageIcon("properties.gif"), this.panelProperties);
        this.tabbedPane.addTab("Jobs", ImageLoader.getImageIcon("computer.gif"), this.panelJobs);
        this.getContentPane().add((Component)this.tabbedPane, "Center");
        this.listAvailableTargets = new List((ListModel)new DefaultListModel());
        this.listAvailableTargets.setPopupMenuEnabled(true);
        this.listAvailableTargets.addMouseListener(this);
        this.listChosenTargets = new List((ListModel)new DefaultListModel());
        this.listChosenTargets.setPopupMenuEnabled(true);
        this.listChosenTargets.addMouseListener(this);
        this.menuInsertSync = new JMenuItem("Insert sync");
        this.menuInsertSync.addActionListener(this);
        this.listChosenTargets.getPopupMenu().addSeparator();
        this.listChosenTargets.getPopupMenu().add(this.menuInsertSync);
        this.paneAvailableTargets = new JScrollPane(this.listAvailableTargets);
        this.paneChosenTargets = new JScrollPane(this.listChosenTargets);
        this.panelAvailableTargets = new JPanel(new BorderLayout());
        this.panelChosenTargets = new JPanel(new BorderLayout());
        this.panelAvailableTargets.add((Component)this.paneAvailableTargets, "Center");
        this.panelChosenTargets.add((Component)this.paneChosenTargets, "Center");
        this.panelTargets.add(this.panelAvailableTargets);
        this.panelTargets.add(this.panelChosenTargets);
        this.buttonClear = new JButton("Clear", ImageLoader.getImageIcon("new.gif"));
        this.buttonClear.addActionListener(this);
        this.buttonAddFile = new JButton("Add File", ImageLoader.getImageIcon("open.gif"));
        this.buttonAddFile.addActionListener(this);
        this.buttonAdd = new JButton("Add");
        this.buttonAdd.addActionListener(this);
        this.buttonInsert = new JButton("Insert");
        this.buttonInsert.addActionListener(this);
        this.buttonAddAll = new JButton("Add all");
        this.buttonAddAll.addActionListener(this);
        this.buttonAddSync = new JButton("Add sync");
        this.buttonAddSync.addActionListener(this);
        this.buttonInsertSync = new JButton("Insert sync");
        this.buttonInsertSync.addActionListener(this);
        this.buttonAddDist = new JButton("Add dist");
        this.buttonAddDist.addActionListener(this);
        JPanel panel = new JPanel(new GridLayout(0, 1));
        panel.add(this.buttonClear);
        panel.add(this.buttonAddFile);
        panel.add(this.buttonAdd);
        panel.add(this.buttonInsert);
        panel.add(this.buttonAddAll);
        panel.add(this.buttonAddSync);
        panel.add(this.buttonInsertSync);
        JPanel panel2 = new JPanel(new BorderLayout());
        panel2.add((Component)panel, "North");
        this.panelAvailableTargets.add((Component)panel2, "East");
        this.buttonDelete = new JButton("Delete", ImageLoader.getImageIcon("delete.gif"));
        this.buttonDelete.addActionListener(this);
        this.buttonDeleteAll = new JButton("Delete all");
        this.buttonDeleteAll.addActionListener(this);
        this.buttonUp = new JButton("Up", ImageLoader.getImageIcon("up.gif"));
        this.buttonUp.addActionListener(this);
        this.buttonDown = new JButton("Down", ImageLoader.getImageIcon("down.gif"));
        this.buttonDown.addActionListener(this);
        this.buttonLoadTargets = new JButton("Load", ImageLoader.getImageIcon("open.gif"));
        this.buttonLoadTargets.addActionListener(this);
        this.buttonSaveTargets = new JButton("Save", ImageLoader.getImageIcon("save.gif"));
        this.buttonSaveTargets.addActionListener(this);
        panel = new JPanel(new GridLayout(0, 1));
        panel.add(this.buttonDelete);
        panel.add(this.buttonDeleteAll);
        panel.add(this.buttonUp);
        panel.add(this.buttonDown);
        panel.add(this.buttonLoadTargets);
        panel.add(this.buttonSaveTargets);
        panel2 = new JPanel(new BorderLayout());
        panel2.add((Component)panel, "North");
        this.panelChosenTargets.add((Component)panel2, "East");
        this.listJobs = new List();
        this.listJobs.setFont(Font.decode(this.getCustomFont()));
        this.listJobs.setPopupMenuEnabled(true);
        this.listJobs.addMouseListener(this);
        this.paneJobs = new JScrollPane(this.listJobs);
        this.panelJobs.add((Component)this.paneJobs, "Center");
        this.panelParameter = new JPanel(new GridLayout(2, 1));
        this.labelJobfile = new JLabel("Jobfile");
        this.textJobfile = new JTextField(this.jobfile, 20);
        this.textJobfile.setEnabled(false);
        this.buttonJobfile = new JButton("Choose", ImageLoader.getImageIcon("open.gif"));
        this.buttonJobfile.addActionListener(this);
        this.buttonReset = new JButton("Reset Jobs", ImageLoader.getImageIcon("new.gif"));
        this.buttonReset.addActionListener(this);
        panel = new JPanel(new FlowLayout());
        panel.add(this.labelJobfile);
        panel.add(this.textJobfile);
        panel.add(this.buttonJobfile);
        panel.add(this.buttonReset);
        this.panelParameter.add(panel);
        panel = new JPanel(new FlowLayout());
        this.checkExchange = new JCheckBox("file exchange between Server and Client", this.exchange);
        this.checkAppend = new JCheckBox("append Jobs to file", this.append);
        panel.add(this.checkAppend);
        this.panelParameter.add(panel);
        this.getContentPane().add((Component)this.panelParameter, "North");
        this.tableProperties = new PropertyTable();
        this.paneProperties = new JScrollPane(this.tableProperties);
        this.checkProperties = new JCheckBox("Override Properties with these values");
        this.panelProperties.add((Component)this.checkProperties, "North");
        this.panelProperties.add((Component)this.paneProperties, "Center");
        this.panelProperties.add((Component)new JLabel("Note: if a property starts with a '-', but is not a flag, then it must be transformed to '=', e.g. '-P -M 0' becomes '=P -M 0'"), "South");
        this.buttonGenerate = new JButton("Generate", ImageLoader.getImageIcon("run.gif"));
        this.buttonGenerate.addActionListener(this);
        this.buttonExit = new JButton("Exit", ImageLoader.getImageIcon("forward.gif"));
        this.buttonExit.addActionListener(this);
        this.labelStatus.setHorizontalAlignment(0);
        panel = new JPanel(new BorderLayout());
        panel.add((Component)this.buttonGenerate, "West");
        panel.add((Component)this.labelStatus, "Center");
        panel.add((Component)this.buttonExit, "East");
        this.getContentPane().add((Component)panel, "South");
        this.buttonStop = new JButton("Stop", ImageLoader.getImageIcon("stop2.gif"));
        this.buttonStop.addActionListener(this);
        this.buttonEditJob = new JButton("Edit", ImageLoader.getImageIcon("glasses.gif"));
        this.buttonEditJob.addActionListener(this);
        this.buttonDeleteJob = new JButton("Delete", ImageLoader.getImageIcon("delete.gif"));
        this.buttonDeleteJob.addActionListener(this);
        this.buttonSaveJobs = new JButton("Save", ImageLoader.getImageIcon("save.gif"));
        this.buttonSaveJobs.addActionListener(this);
        panel = new JPanel(new GridLayout(4, 1));
        panel.add(this.buttonStop);
        panel.add(this.buttonEditJob);
        panel.add(this.buttonDeleteJob);
        panel.add(this.buttonSaveJobs);
        panel2 = new JPanel(new BorderLayout());
        panel2.add((Component)panel, "North");
        this.panelJobs.add((Component)panel2, "East");
        this.textSearch = new JTextField("", 30);
        this.buttonSearch = new JButton("Search", ImageLoader.getImageIcon("find.gif"));
        this.buttonSearch.addActionListener(this);
        panel = new JPanel(new FlowLayout());
        panel.add(this.textSearch);
        panel.add(this.buttonSearch);
        this.panelJobs.add((Component)panel, "North");
    }

    @Override
    protected void setEnabledState(boolean enabled) {
        this.listAvailableTargets.setEnabled(enabled);
        this.listChosenTargets.setEnabled(enabled);
        this.listJobs.setEnabled(enabled);
        this.checkExchange.setEnabled(enabled);
        this.checkAppend.setEnabled(enabled);
        this.textSearch.setEnabled(enabled);
        this.buttonGenerate.setEnabled(enabled);
        this.buttonExit.setEnabled(enabled);
        this.buttonJobfile.setEnabled(enabled);
        this.buttonDeleteJob.setEnabled(enabled);
        this.buttonSaveJobs.setEnabled(enabled);
        this.buttonEditJob.setEnabled(enabled);
        this.buttonSearch.setEnabled(enabled);
        this.buttonClear.setEnabled(enabled);
        this.buttonAddFile.setEnabled(enabled);
        this.buttonAdd.setEnabled(enabled);
        this.buttonInsert.setEnabled(enabled);
        this.buttonAddAll.setEnabled(enabled);
        this.buttonAddSync.setEnabled(enabled);
        this.buttonInsertSync.setEnabled(enabled);
        this.buttonAddDist.setEnabled(enabled);
        this.buttonDelete.setEnabled(enabled);
        this.buttonDeleteAll.setEnabled(enabled);
        this.buttonUp.setEnabled(enabled);
        this.buttonDown.setEnabled(enabled);
        this.tableProperties.setEnabled(enabled);
        this.checkProperties.setEnabled(enabled);
        this.repaint();
    }

    private DefaultListModel getListModel(JList list) {
        return (DefaultListModel)list.getModel();
    }

    private void addTargetsFromFile(String filename) {
        if (!filename.startsWith("#")) {
            if (filename.equals("synchronize") || filename.equals("distribute")) {
                this.getListModel(this.listAvailableTargets).addElement(filename);
            } else if (!this.files.containsKey(filename)) {
                Ant ant = new Ant(filename);
                Vector targets = ant.getAntTargets();
                int i = 0;
                while (i < targets.size()) {
                    this.getListModel(this.listAvailableTargets).addElement(targets.get(i));
                    ++i;
                }
                this.files.put(filename, ant);
            }
        }
    }

    private void close() {
        this.windowClosing(null);
    }

    private void chooseJobfile() {
        if (this.textJobfile != null && !this.textJobfile.getText().equals("")) {
            try {
                this.fileChooser.setSelectedFile(new File(this.textJobfile.getText()));
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        this.fileChooser.resetChoosableFileFilters();
        this.fileChooser.setMultiSelectionEnabled(false);
        int retVal = this.fileChooser.showOpenDialog(this);
        if (retVal != 0) {
            return;
        }
        this.textJobfile.setText(this.fileChooser.getSelectedFile().getAbsolutePath());
    }

    private void resetJobs() {
        this.jobfile = this.cl.getValue("jobfile", this.jobfile);
        this.textJobfile.setText(this.jobfile);
        this.exchange = this.cl.exists("exchange");
        this.checkExchange.setSelected(this.exchange);
        this.append = this.cl.exists("append");
        this.checkAppend.setSelected(this.append);
        this.listAvailableTargets.setModel(new DefaultListModel());
        this.listChosenTargets.setModel(new DefaultListModel());
        this.listJobs.setModel(new DefaultListModel());
        this.files.clear();
        String[] list = Strings.breakUp(this.cl.getValue("file"), ",");
        int i = 0;
        while (i < list.length) {
            this.addTargetsFromFile(list[i]);
            ++i;
        }
        this.checkProperties.setSelected(false);
        Jobs jobs = new Jobs();
        this.properties = jobs.getProperties("build.xml");
        if (this.properties == null) {
            this.properties = new String[1][2];
        }
        this.tableProperties.setProperties(this.properties);
        JTableHelper.setOptimalColumnWidth(this.tableProperties);
    }

    private void generate() {
        this.tabbedPane.setSelectedIndex(2);
        this.generator = new Generator(this);
        this.generator.start();
    }

    private void stop() {
        if (this.generator != null) {
            this.generator.stopRunning();
        }
    }

    protected void loadJobs() {
        Vector lines = TextFile.load(this.jobfile);
        int i = 0;
        while (i < lines.size()) {
            String line = (String)lines.get(i);
            if (line.equals("")) {
                line = " ";
                lines.set(i, line);
            }
            ++i;
        }
        this.listJobs.setListData(lines);
    }

    private void saveJobs() {
        Vector lines = Strings.arrayToVector(JListHelper.toStringArray(JListHelper.getAllListData(this.listJobs)));
        int i = 0;
        while (i < lines.size()) {
            String line = (String)lines.get(i);
            lines.set(i, line.trim());
            ++i;
        }
        TextFile.save(this.jobfile, lines);
        this.tabbedPane.setTitleAt(2, "Jobs");
    }

    private void editJob() {
        int index = this.listJobs.getSelectedIndex();
        if (index == -1) {
            return;
        }
        EditDialog edit = new EditDialog(this, "Edit");
        edit.setText((String)this.listJobs.getSelectedValue());
        edit.setEditable(true);
        edit.show();
        if (!this.listJobs.getSelectedValue().equals(edit.getText())) {
            Vector lines = Strings.arrayToVector(JListHelper.toStringArray(JListHelper.getAllListData(this.listJobs)));
            lines.set(index, edit.getText());
            this.listJobs.setListData(lines);
            this.listJobs.setSelectedIndex(index);
        }
    }

    private void deleteJob() {
        if (this.listJobs.getSelectedIndex() > -1) {
            this.listJobs.setListData(JListHelper.toStringArray(JListHelper.getInverseSelectedValues(this.listJobs)));
            this.tabbedPane.setTitleAt(2, "Jobs *");
        }
    }

    private void searchJobs() {
        if (this.textSearch.getText().equals("")) {
            this.listJobs.setSelectedIndices(new int[0]);
            return;
        }
        this.listJobs.select(this.textSearch.getText());
    }

    private void clearTargets() {
        this.files.clear();
        this.listAvailableTargets.setModel(new DefaultListModel());
    }

    private void addFile() {
        this.fileChooser.setFileFilter(new SimpleFileFilter("xml", "XML-Files"));
        this.fileChooser.setMultiSelectionEnabled(true);
        int retVal = this.fileChooser.showOpenDialog(this);
        if (retVal != 0) {
            return;
        }
        int i = 0;
        while (i < this.fileChooser.getSelectedFiles().length) {
            String filename = this.fileChooser.getSelectedFiles()[i].getAbsolutePath();
            this.addTargetsFromFile(filename);
            ++i;
        }
    }

    private void addTargets() {
        if (this.listAvailableTargets.getSelectedIndex() == -1) {
            return;
        }
        int i = 0;
        while (i < this.listAvailableTargets.getSelectedValues().length) {
            this.getListModel(this.listChosenTargets).addElement(this.listAvailableTargets.getSelectedValues()[i]);
            ++i;
        }
    }

    private void insertTargets() {
        if (this.listAvailableTargets.getSelectedIndex() == -1) {
            return;
        }
        int index = this.listChosenTargets.getSelectedIndex();
        if (index == -1) {
            index = this.getListModel(this.listChosenTargets).getSize();
        }
        int i = 0;
        while (i < this.listAvailableTargets.getSelectedValues().length) {
            this.getListModel(this.listChosenTargets).insertElementAt(this.listAvailableTargets.getSelectedValues()[i], index + i);
            ++i;
        }
    }

    private void addAllTargets() {
        int i = 0;
        while (i < this.getListModel(this.listAvailableTargets).size()) {
            this.getListModel(this.listChosenTargets).addElement(this.getListModel(this.listAvailableTargets).getElementAt(i));
            ++i;
        }
    }

    private void addSync() {
        this.getListModel(this.listChosenTargets).addElement("synchronize");
    }

    private void insertSync() {
        int index = this.listChosenTargets.getSelectedIndex();
        if (index == -1) {
            index = this.getListModel(this.listChosenTargets).getSize();
        }
        this.getListModel(this.listChosenTargets).insertElementAt("synchronize", index);
    }

    private void addDist() {
        this.getListModel(this.listChosenTargets).addElement("distribute");
    }

    private void deleteTargets() {
        if (this.listChosenTargets.getSelectedIndex() == -1) {
            return;
        }
        int[] indices = this.listChosenTargets.getSelectedIndices();
        int i = indices.length - 1;
        while (i >= 0) {
            this.getListModel(this.listChosenTargets).removeElementAt(indices[i]);
            --i;
        }
    }

    private void deleteAllTargets() {
        this.listChosenTargets.setModel(new DefaultListModel());
    }

    private void moveUp() {
        int index = this.listChosenTargets.getSelectedIndex();
        if (index == -1) {
            return;
        }
        DefaultListModel model = this.getListModel(this.listChosenTargets);
        if (model.size() == 1) {
            return;
        }
        if (index == 0) {
            return;
        }
        Object item = model.getElementAt(index);
        model.removeElementAt(index);
        model.insertElementAt(item, index - 1);
        this.listChosenTargets.setSelectedIndex(index - 1);
    }

    private void moveDown() {
        int index = this.listChosenTargets.getSelectedIndex();
        if (index == -1) {
            return;
        }
        DefaultListModel model = this.getListModel(this.listChosenTargets);
        if (model.size() == 1) {
            return;
        }
        if (index == model.size() - 1) {
            return;
        }
        Object item = model.getElementAt(index);
        model.removeElementAt(index);
        model.insertElementAt(item, index + 1);
        this.listChosenTargets.setSelectedIndex(index + 1);
    }

    private void loadTargets() {
        Element subnode;
        int i;
        Element node;
        this.fileChooser.setFileFilter(new SimpleFileFilter("xml", "XML-Files"));
        this.fileChooser.setMultiSelectionEnabled(false);
        int retVal = this.fileChooser.showOpenDialog(this);
        if (retVal != 0) {
            return;
        }
        Path path = new Path();
        Document doc = new Document();
        doc.read(this.fileChooser.getSelectedFile().getAbsolutePath());
        Vector nodes = path.get(doc.getRoot(), "//jobs");
        if (nodes.size() > 0 && (node = (Element)nodes.get(0)).getAttribute("filename") != null) {
            this.textJobfile.setText(node.getAttribute("filename").getValue());
            this.loadJobs();
        }
        if ((nodes = path.get(doc.getRoot(), "//property")).size() > 0) {
            Object[][] props = new Object[nodes.size()][2];
            i = 0;
            while (i < nodes.size()) {
                subnode = (Element)nodes.get(i);
                if (i == 0 && (node = (Element)subnode.getParent()).getAttribute("override") != null) {
                    this.checkProperties.setSelected(node.getAttribute("override").getValue().equals("yes"));
                }
                props[i][0] = subnode.getAttribute("name").getValue();
                props[i][1] = subnode.getAttribute("value").getValue();
                ++i;
            }
            this.tableProperties.setProperties(props);
            JTableHelper.setOptimalColumnWidth(this.tableProperties);
        }
        this.clearTargets();
        nodes = path.get(doc.getRoot(), "//file");
        i = 0;
        while (i < nodes.size()) {
            node = (Element)nodes.get(i);
            this.addTargetsFromFile(node.getAttribute("name").getValue());
            ++i;
        }
        this.deleteAllTargets();
        DefaultListModel model = this.getListModel(this.listChosenTargets);
        nodes = path.get(doc.getRoot(), "//job");
        i = 0;
        while (i < nodes.size()) {
            node = (Element)nodes.get(i);
            if (node.getChildCount() != 0) {
                subnode = (Element)node.getChildAt(0);
                if (subnode.getName().equals("file")) {
                    String filename = subnode.getAttribute("name").getValue();
                    Ant ant = (Ant)this.files.get(filename);
                    model.addElement(new AntTarget(ant, subnode.getAttribute("target").getValue()));
                } else if (subnode.getName().equals("command")) {
                    model.addElement(subnode.getContent());
                } else {
                    this.println("Unknown node: " + subnode.getName());
                }
            }
            ++i;
        }
    }

    private void saveTargets() {
        Element child;
        this.fileChooser.setFileFilter(new SimpleFileFilter("xml", "XML-Files"));
        this.fileChooser.setMultiSelectionEnabled(false);
        int retVal = this.fileChooser.showSaveDialog(this);
        if (retVal != 0) {
            return;
        }
        Document doc = new Document();
        Element node = new Element("jobber");
        doc.getRoot().add(node);
        node.add(new Comment("last saved: " + new Timestamp()));
        Element subnode = new Element(node, "properties");
        if (this.checkProperties.isSelected()) {
            subnode.addAttribute(new Attribute("override", "yes"));
        } else {
            subnode.addAttribute(new Attribute("override", "no"));
        }
        Object[][] props = this.tableProperties.getProperties();
        int i = 0;
        while (i < props.length) {
            child = new Element(subnode, "property");
            child.addAttribute(new Attribute("name", props[i][0].toString()));
            child.addAttribute(new Attribute("value", props[i][1].toString()));
            ++i;
        }
        subnode = new Element(node, "jobs");
        subnode.addAttribute(new Attribute("filename", this.textJobfile.getText()));
        node = subnode;
        DefaultListModel model = this.getListModel(this.listChosenTargets);
        i = 0;
        while (i < model.size()) {
            child = new Element(node, "job");
            if (model.getElementAt(i) instanceof AntTarget) {
                AntTarget target = (AntTarget)model.getElementAt(i);
                subnode = new Element(child, "file");
                subnode.addAttribute(new Attribute("name", target.getFilename()));
                subnode.addAttribute(new Attribute("target", target.getTarget()));
            } else if (model.getElementAt(i) instanceof String) {
                subnode = new Element(child, "command");
                subnode.setContent(model.getElementAt(i).toString());
            } else {
                this.println("Unknown type: " + model.getElementAt(i).getClass().getName());
            }
            ++i;
        }
        doc.write(this.fileChooser.getSelectedFile().getAbsolutePath());
    }

    @Override
    public void mousePressed(MouseEvent e) {
        int index;
        if (e.getComponent() == this.listJobs) {
            int index2 = this.listJobs.locationToIndex(e.getPoint());
            if (index2 > -1 && e.getClickCount() == 2) {
                e.consume();
                this.editJob();
            }
        } else if (e.getComponent() == this.listAvailableTargets && (index = this.listAvailableTargets.locationToIndex(e.getPoint())) > -1 && e.getClickCount() == 2) {
            e.consume();
            this.addTargets();
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        Object source = e.getSource();
        if (source == this.buttonExit) {
            this.close();
        } else if (source == this.buttonGenerate) {
            this.generate();
        } else if (source == this.buttonJobfile) {
            this.chooseJobfile();
        } else if (source == this.buttonReset) {
            this.resetJobs();
        } else if (source == this.buttonStop) {
            this.stop();
        } else if (source == this.buttonEditJob) {
            this.editJob();
        } else if (source == this.buttonDeleteJob) {
            this.deleteJob();
        } else if (source == this.buttonSaveJobs) {
            this.saveJobs();
        } else if (source == this.buttonSearch) {
            this.searchJobs();
        } else if (source == this.buttonClear) {
            this.clearTargets();
        } else if (source == this.buttonAddFile) {
            this.addFile();
        } else if (source == this.buttonAdd) {
            this.addTargets();
        } else if (source == this.buttonInsert) {
            this.insertTargets();
        } else if (source == this.buttonAddAll) {
            this.addAllTargets();
        } else if (source == this.buttonAddSync) {
            this.addSync();
        } else if (source == this.buttonInsertSync || source == this.menuInsertSync) {
            this.insertSync();
        } else if (source == this.buttonAddDist) {
            this.addDist();
        } else if (source == this.buttonDelete) {
            this.deleteTargets();
        } else if (source == this.buttonDeleteAll) {
            this.deleteAllTargets();
        } else if (source == this.buttonUp) {
            this.moveUp();
        } else if (source == this.buttonDown) {
            this.moveDown();
        } else if (source == this.buttonLoadTargets) {
            this.loadTargets();
        } else if (source == this.buttonSaveTargets) {
            this.saveTargets();
        }
    }

    @Override
    protected boolean afterCreate() {
        this.resetJobs();
        return true;
    }

    @Override
    public void printDescription() {
        System.out.println("Creates Jobs for the distributed computing using proper.app.Jobs for this");
        System.out.println("purpose.");
        System.out.println();
    }

    @Override
    public void printUsage() {
        super.printUsage();
        System.out.println(" -file name[,name[,...]]");
        System.out.println("  the files that shall be processed");
        System.out.println("  commands like 'synchronize' are prefixed with '#'");
        System.out.println("  if none is provided then all are used");
        System.out.println(" -jobfile <filename> (optional)");
        System.out.println("  the file where to store the resulting jobs, default is " + this.jobfile);
        System.out.println(" -exchange (optional)");
        System.out.println("  whether to include 'get_file' commands or not, default is " + this.exchange);
        System.out.println(" -append (optional)");
        System.out.println("  whether to append the jobs to the file or not, default is " + this.append);
    }

    public static void main(String[] args) throws Exception {
        Jobber frame = new Jobber(null);
        frame.run(args);
    }
}

