/*
 * Decompiled with CFR 0.152.
 */
package proper.engine;

import java.util.Vector;
import proper.database.ColumnLister;
import proper.database.Dropper;
import proper.database.Join;
import proper.database.JoinTreeNode;
import proper.database.Joiner;
import proper.database.Modifier;
import proper.database.RelationDiscoverer;
import proper.database.TableLister;
import proper.engine.DatabaseEngine;
import proper.util.ProperVector;
import proper.util.TemporaryName;

public class Propagator
extends DatabaseEngine {
    public static final String TMPPREFIX = "_propagated_";
    private ColumnLister col;
    private TableLister tab;
    private Joiner join;
    private Dropper drop;
    private Modifier modifier;
    private RelationDiscoverer discoverer;
    private JoinTreeNode root;
    private TemporaryName tmpName;
    private boolean showRelations;

    public Propagator() {
        this.setParameter("database", "eastwest");
        this.setParameter("table", "train_");
        this.setParameter("field", "train0");
        this.setParameter("join", "leftouter");
        this.setParameter("exclude_tables", "");
        this.setParameter("max_depth", "1");
        this.setParameter("instead_null", "");
        this.setParameter("tree", "");
        this.tmpName = new TemporaryName(TMPPREFIX);
        this.showRelations = true;
        this.root = null;
    }

    @Override
    protected boolean initialize() {
        boolean result;
        if (this.initialized) {
            result = true;
        } else {
            super.initialize();
            this.col = new ColumnLister(this.conn);
            this.tab = new TableLister(this.conn);
            this.join = new Joiner(this.conn);
            this.drop = new Dropper(this.conn);
            this.discoverer = new RelationDiscoverer(this.conn);
            this.modifier = new Modifier(this.conn);
            result = true;
        }
        return result;
    }

    public void setTemporaryName(TemporaryName tmpName) {
        if (tmpName != null) {
            this.tmpName = tmpName;
        }
    }

    public TemporaryName getTemporaryName() {
        return this.tmpName;
    }

    public void setShowRelations(boolean showRelations) {
        this.showRelations = showRelations;
    }

    public boolean getShowRelations() {
        return this.showRelations;
    }

    public void dropTables() {
        this.initialize();
        Vector tables = this.tab.getList("_propagated_%");
        this.drop.drop(tables);
    }

    private boolean execute(Join relation, String resultTable) {
        this.println("Propagating: " + relation.getLeftTable() + " -> " + relation.getRightTable());
        ProperVector joinCols = new ProperVector();
        joinCols.add(relation);
        boolean result = this.join.join(relation.getLeftTable(), relation.getRightTable(), joinCols, resultTable, this.getStringParameter("field"));
        return result;
    }

    /*
     * Unable to fully structure code
     */
    private boolean execute(JoinTreeNode node) {
        result = true;
        ok = node.isLeaf() == false;
        i = 0;
        while (i < node.getChildCount()) {
            v0 = ok = ok != false && node.getChildAt(i).isLeaf() != false;
            if (!ok) break;
            ++i;
        }
        if (!ok) {
            i = 0;
            while (i < node.getChildCount()) {
                if (!node.getChildAt(i).isLeaf()) {
                    v1 = result = result != false && this.execute((JoinTreeNode)node.getChildAt(i)) != false;
                }
                if (!result) break;
                ++i;
            }
        }
        if (!result) {
            return result;
        }
        if (node != this.root) ** GOTO lbl30
        return result;
lbl-1000:
        // 1 sources

        {
            currTmp = this.tmpName.next();
            currName = node.getChildJoinAt(0).getLeftTable();
            result = this.execute(node.getJoin(), currTmp);
            ((JoinTreeNode)node.getParent()).add(new JoinTreeNode(currName));
            this.drop.drop(currName);
            this.modifier.renameTable(currTmp, currName);
            node.remove(0);
lbl30:
            // 2 sources

            ** while (node.getChildCount() > 0)
        }
lbl31:
        // 1 sources

        return result;
    }

    @Override
    public boolean execute() {
        boolean result;
        super.execute();
        try {
            this.col.setSort(true);
            this.join.setJoinType(Joiner.parseType(this.getStringParameter("join")));
            this.join.setInsteadOfNull(this.getStringParameter("instead_null"));
            this.discoverer.setTable(this.getStringParameter("table"));
            this.discoverer.setExcludes(this.getStringParameter("exclude_tables"));
            this.discoverer.setUseForeignKeys(this.exists("use_foreign_keys"));
            this.discoverer.setMaxDepth(Integer.parseInt(this.getStringParameter("max_depth")));
            if (this.getVerbose()) {
                this.println(this.discoverer);
            }
            this.dropTables();
            this.root = !this.getStringParameter("tree").equals("") ? JoinTreeNode.parseTreeString(this.getStringParameter("tree")) : this.discoverer.discover();
            String targetTable = this.root.toString();
            if (this.getShowRelations()) {
                this.println("Relations:\n");
                this.println(this.root.toString(true));
                this.println("Left over tables: " + this.discoverer.leftOverTables(this.root));
            }
            result = this.execute(this.root);
            this.dropTables();
        }
        catch (Exception e) {
            this.println(e);
            result = false;
        }
        this.println("Finished = " + result);
        return result;
    }
}

