/*
 * Decompiled with CFR 0.152.
 */
package proper.database;

import java.util.StringTokenizer;
import proper.core.Assignable;
import proper.database.Column;
import proper.util.Strings;

public class Join
implements Comparable,
Assignable {
    protected Column[] colLeft;
    protected Column[] colRight;
    protected int size;
    protected int[] type;

    public Join(String tableLeft, String columnLeft, String tableRight, String columnRight) {
        this(tableLeft, new String[]{columnLeft}, tableRight, new String[]{columnRight});
    }

    public Join(String tableLeft, String[] columnsLeft, String tableRight, String[] columnsRight) {
        this(tableLeft, columnsLeft, 0, tableRight, columnsRight);
    }

    public Join(String tableLeft, String columnLeft, int size, String tableRight, String columnRight) {
        this(tableLeft, new String[]{columnLeft}, size, tableRight, new String[]{columnRight});
    }

    public Join(String tableLeft, String[] columnsLeft, int size, String tableRight, String[] columnsRight) {
        this(tableLeft, columnsLeft, size, tableRight, columnsRight, Join.getIntArray(1111, columnsLeft.length));
    }

    public Join(String tableLeft, String columnLeft, int size, String tableRight, String columnRight, int type) {
        this(tableLeft, new String[]{columnLeft}, size, tableRight, new String[]{columnRight}, new int[]{type});
    }

    public Join(String tableLeft, String[] columnsLeft, int size, String tableRight, String[] columnsRight, int[] types) {
        Column[] left = new Column[columnsLeft.length];
        Column[] right = new Column[columnsRight.length];
        int i = 0;
        while (i < columnsLeft.length) {
            left[i] = new Column(String.valueOf(tableLeft) + "." + columnsLeft[i]);
            right[i] = new Column(String.valueOf(tableRight) + "." + columnsRight[i]);
            ++i;
        }
        this.initialize(left, size, right, types);
    }

    public Join(Column colLeft, Column colRight) {
        this(new Column[]{colLeft}, new Column[]{colRight});
    }

    public Join(Column[] colsLeft, Column[] colsRight) {
        this(colsLeft, 0, colsRight);
    }

    public Join(Column colLeft, int size, Column colRight) {
        this(new Column[]{colLeft}, size, new Column[]{colRight});
    }

    public Join(Column[] colsLeft, int size, Column[] colsRight) {
        this.initialize(colsLeft, size, colsRight, Join.getIntArray(1111, colsLeft.length));
    }

    public Join(Column colLeft, int size, Column colRight, int type) {
        this.initialize(new Column[]{colLeft}, size, new Column[]{colRight}, new int[]{type});
    }

    public Join(Column[] colsLeft, int size, Column[] colsRight, int[] types) {
        this.initialize(colsLeft, size, colsRight, types);
    }

    protected void initialize(Column[] colsLeft, int size, Column[] colsRight, int[] types) {
        if (colsLeft.length != colsRight.length || colsLeft.length != types.length) {
            throw new IllegalArgumentException("Number of left and right columns, as well as the number of types must have the same dimension!");
        }
        this.colLeft = new Column[colsLeft.length];
        this.colRight = new Column[colsRight.length];
        this.type = new int[types.length];
        this.size = size;
        int i = 0;
        while (i < colsLeft.length) {
            this.colLeft[i] = (Column)colsLeft[i].clone();
            this.colRight[i] = (Column)colsRight[i].clone();
            this.type[i] = types[i];
            ++i;
        }
    }

    private static int[] getIntArray(int value, int size) {
        int[] result = new int[size];
        int i = 0;
        while (i < size) {
            result[i] = value;
            ++i;
        }
        return result;
    }

    public int count() {
        return this.colLeft.length;
    }

    public String getLeftTable() {
        return this.colLeft[0].getTable();
    }

    public String getLeftColumn() {
        return this.colLeft[0].getName();
    }

    public String getLeftColumn(int index) {
        return this.colLeft[index].getName();
    }

    public Column getLeftObject() {
        return this.colLeft[0];
    }

    public Column getLeftObject(int index) {
        return this.colLeft[index];
    }

    public void setSize(int size) {
        this.size = size;
    }

    public int getSize() {
        return this.size;
    }

    public int getType() {
        return this.type[0];
    }

    public int getType(int index) {
        return this.type[index];
    }

    public String getRightTable() {
        return this.colRight[0].getTable();
    }

    public String getRightColumn() {
        return this.colRight[0].getName();
    }

    public String getRightColumn(int index) {
        return this.colRight[index].getName();
    }

    public Column getRightObject() {
        return this.colRight[0];
    }

    public Column getRightObject(int index) {
        return this.colRight[index];
    }

    public String getLeft() {
        return this.colLeft[0].toString();
    }

    public String getLeft(int index) {
        return this.colLeft[index].toString();
    }

    public String getRight() {
        return this.colRight[0].toString();
    }

    public String getRight(int index) {
        return this.colRight[index].toString();
    }

    @Override
    public void assign(Object o) {
        if (!(o instanceof Join)) {
            return;
        }
        Join j = (Join)o;
        this.colLeft = new Column[j.count()];
        this.colRight = new Column[j.count()];
        this.type = new int[j.count()];
        this.size = j.getSize();
        int i = 0;
        while (i < j.count()) {
            this.colLeft[i] = (Column)j.getLeftObject(i).clone();
            this.colRight[i] = (Column)j.getRightObject(i).clone();
            this.type[i] = j.getType(i);
            ++i;
        }
    }

    public int compareTo(Object o) throws ClassCastException {
        int result = 0;
        Join j = (Join)o;
        result = new Integer(this.count()).compareTo(new Integer(j.count()));
        if (result == 0) {
            result = this.toStringJoin().toLowerCase().compareTo(j.toStringJoin().toLowerCase());
        }
        if (result == 0) {
            int i = 0;
            while (i < this.count()) {
                result = new Integer(this.getType(i)).compareTo(new Integer(j.getType(i)));
                if (result != 0) break;
                ++i;
            }
        }
        return result;
    }

    public boolean equals(Object obj) {
        return this.compareTo(obj) == 0;
    }

    public String toStringJoin() {
        String result = "";
        int i = 0;
        while (i < this.count()) {
            if (i > 0) {
                result = String.valueOf(result) + " AND ";
            }
            result = String.valueOf(result) + "COALESCE(" + this.getLeft(i) + "," + "9999999" + ") = COALESCE(" + this.getRight(i) + "," + "9999999" + ")";
            ++i;
        }
        return result;
    }

    public String toStringNode() {
        String result = this.getLeftTable();
        result = String.valueOf(result) + "(";
        result = String.valueOf(result) + this.getSize();
        result = String.valueOf(result) + ";";
        int i = 0;
        while (i < this.count()) {
            if (i > 0) {
                result = String.valueOf(result) + ":";
            }
            result = String.valueOf(result) + this.getLeft(i);
            ++i;
        }
        result = String.valueOf(result) + ";";
        i = 0;
        while (i < this.count()) {
            if (i > 0) {
                result = String.valueOf(result) + ":";
            }
            result = String.valueOf(result) + this.getRight(i);
            ++i;
        }
        result = String.valueOf(result) + ";";
        i = 0;
        while (i < this.count()) {
            if (i > 0) {
                result = String.valueOf(result) + ":";
            }
            result = String.valueOf(result) + this.getType(i);
            ++i;
        }
        result = String.valueOf(result) + ")";
        return result;
    }

    public String toString() {
        return this.getLeftTable();
    }

    public static Join parseString(String s) {
        String colSelf = "";
        String size = "0";
        String type = "1111";
        String colForeign = "";
        if (s.indexOf("(") > -1) {
            String tmp = s.substring(s.indexOf("(") + 1, s.length() - 1);
            StringTokenizer tok = new StringTokenizer(tmp, ";");
            if (tok.hasMoreTokens()) {
                size = tok.nextToken();
            }
            if (tok.hasMoreTokens()) {
                colSelf = tok.nextToken();
            }
            if (tok.hasMoreTokens()) {
                colForeign = tok.nextToken();
            }
            if (tok.hasMoreTokens()) {
                type = tok.nextToken();
            }
        } else {
            colSelf = s;
        }
        String[] colsSelf = Strings.breakUp(colSelf, ":");
        String[] colsForeign = Strings.breakUp(colForeign, ":");
        String[] typesStr = Strings.breakUp(type, ":");
        int[] types = new int[typesStr.length];
        int i = 0;
        while (i < typesStr.length) {
            types[i] = Integer.parseInt(typesStr[i]);
            ++i;
        }
        Column[] self = new Column[colsSelf.length];
        Column[] foreign = new Column[colsSelf.length];
        if (types.length != colsSelf.length) {
            types = new int[colsSelf.length];
            i = 0;
            while (i < types.length) {
                types[i] = Integer.parseInt(typesStr[0]);
                ++i;
            }
        }
        i = 0;
        while (i < self.length) {
            self[i] = new Column(colsSelf[i], types[i]);
            foreign[i] = new Column(colsForeign[i], types[i]);
            ++i;
        }
        return new Join(self, Integer.parseInt(size), foreign, types);
    }

    public static void main(String[] args) {
        Join j1 = new Join("table2", "col2", "table3", "col3");
        Join j2 = new Join("table2", "col2", 12, "table3", "col3");
        System.out.println("\ntoString():");
        System.out.println(j1);
        System.out.println(j2);
        System.out.println("\ntoStringJoin():");
        System.out.println(j1.toStringJoin());
        System.out.println(j2.toStringJoin());
        System.out.println("\ntoStringNode():");
        System.out.println(j1.toStringNode());
        System.out.println(j2.toStringNode());
        String s = "table1(1;table1.col1;table2.col2)";
        System.out.println("\nconverting string into join:");
        System.out.println(String.valueOf(s) + " -> " + Join.parseString(s).toStringNode());
        j1 = new Join("table2", new String[]{"col2a", "cols2b"}, "table3", new String[]{"col3a", "col3b"});
        j2 = new Join("table2", new String[]{"col2a", "cols2b"}, 12, "table3", new String[]{"col3a", "col3b"});
        System.out.println("\ntoString():");
        System.out.println(j1);
        System.out.println(j2);
        System.out.println("\ntoStringJoin():");
        System.out.println(j1.toStringJoin());
        System.out.println(j2.toStringJoin());
        System.out.println("\ntoStringNode():");
        System.out.println(j1.toStringNode());
        System.out.println(j2.toStringNode());
        s = "table1(1;table1.col1a:table1.col1b;table2.col2a:table2.col2b)";
        System.out.println("\nconverting string into join:");
        System.out.println(String.valueOf(s) + " -> " + Join.parseString(s).toStringNode());
    }
}

