/*
 * Decompiled with CFR 0.152.
 */
package proper.app;

import java.io.File;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Vector;
import proper.app.Application;
import proper.io.CopyFile;
import proper.io.TextFile;
import proper.util.ProperVector;
import proper.util.Strings;

public class Standalone
extends Application {
    private HashSet imports = new HashSet();
    private HashSet images = new HashSet();

    @Override
    protected void defineParameters() {
        super.defineParameters();
        this.addDefinition("class", "the class from which we shall create a standalone version", true, "<name>", false);
        this.addDefinition("input_dir", "the directory just above 'proper/gui/...', normally './src'", true, "<name>", false);
        this.addDefinition("output_dir", "the directory where to copy the transformed files to", true, "<name>", false);
        this.addDefinition("package", "the new package for all the components, if no package name is provided, the\npackage declaration is removed from the files.", true, "[<name>]", false);
    }

    @Override
    public void printDescription() {
        System.out.println("Transforms the ArffViewer and all necessary components into a standalone");
        System.out.println("version with a new package structure. Makes it easy to integrate the Viewer");
        System.out.println("in other applications.");
        System.out.println();
    }

    private String getPackage(String classname) {
        return classname.replaceAll("\\.[^\\.]*$", "");
    }

    private String getDirectory(String classname) {
        return String.valueOf(this.cl.getValue("input_dir")) + "/" + this.getPackage(classname).replaceAll("\\.", "/");
    }

    private String getFilename(String classname) {
        return String.valueOf(this.cl.getValue("input_dir")) + "/" + classname.replaceAll("\\.", "/") + ".java";
    }

    private String getNewFilename(String classname) {
        return String.valueOf(this.cl.getValue("output_dir")) + "/" + this.cl.getValue("package").replaceAll("\\.", "/") + "/" + classname.replaceAll(".*\\.", "") + ".java";
    }

    private Vector loadFile(String classname) {
        String filename = this.getFilename(classname);
        Vector lines = TextFile.load(filename);
        if (lines.size() == 0) {
            this.println("Error loading: " + filename);
        }
        int i = 0;
        while (i < lines.size()) {
            String line = lines.get(i).toString().trim();
            line = line.replaceAll("//.*", "");
            line = line.replaceAll("^/\\*.*", "");
            line = line.replaceAll("^\\*.*", "");
            line = line.replaceAll("^\\*/.*", "");
            if ((line = line.trim()).equals("")) {
                lines.remove(i);
                continue;
            }
            ++i;
        }
        return lines;
    }

    private boolean createDir(String dir) {
        boolean result = true;
        try {
            File file = new File(dir);
            if (!file.exists()) {
                file.mkdirs();
            }
        }
        catch (Exception e) {
            System.out.println("Failed to create dir: " + dir);
            System.out.println(e);
            result = false;
        }
        return result;
    }

    private String getSuperclass(String classname) {
        String result = "";
        try {
            Class<?> cls = Class.forName(classname);
            if (cls.getSuperclass() != null && result.startsWith("proper.")) {
                result = cls.getSuperclass().getName();
            }
        }
        catch (Exception e) {
            this.println(e);
            result = "";
        }
        return result;
    }

    private Vector getInterfaces(String classname) {
        ProperVector result = new ProperVector();
        try {
            Class<?> cls = Class.forName(classname);
            int i = 0;
            while (i < cls.getInterfaces().length) {
                String name = cls.getInterfaces()[i].getName();
                if (name.startsWith("proper.")) {
                    result.add(name);
                }
                ++i;
            }
        }
        catch (Exception e) {
            this.println(e);
        }
        return result;
    }

    private Vector getPackageFiles(String classname) {
        ProperVector result = new ProperVector();
        try {
            String[] files = new File(this.getDirectory(classname)).list();
            if (files != null) {
                int i = 0;
                while (i < files.length) {
                    String file = files[i];
                    if (file.endsWith(".java")) {
                        file = String.valueOf(this.getPackage(classname)) + "." + file.replaceAll(".java", "");
                        result.add(file);
                    }
                    ++i;
                }
            }
        }
        catch (Exception e) {
            this.println(e);
        }
        return result;
    }

    private boolean getClasses(String classname) {
        String line;
        this.println(" -" + classname);
        this.imports.add(classname);
        boolean result = true;
        ProperVector newClasses = new ProperVector();
        Vector file = this.loadFile(classname);
        if (file.size() == 0) {
            return false;
        }
        Vector packagefiles = this.getPackageFiles(classname);
        int i = 0;
        while (i < file.size()) {
            line = file.get(i).toString();
            int n = 0;
            while (n < packagefiles.size()) {
                String filename = packagefiles.get(n).toString();
                if (line.indexOf(filename = filename.replaceAll(".*\\.", "")) > -1 && !this.imports.contains(packagefiles.get(n))) {
                    newClasses.add(packagefiles.get(n));
                }
                ++n;
            }
            ++i;
        }
        String superclass = classname;
        while (!(superclass = this.getSuperclass(superclass)).equals("") && !this.imports.contains(superclass)) {
            if (this.imports.contains(superclass)) continue;
            newClasses.add(superclass);
        }
        Vector interfaces = this.getInterfaces(classname);
        i = 0;
        while (i < interfaces.size()) {
            if (!this.imports.contains(interfaces.get(i))) {
                newClasses.add(interfaces.get(i));
            }
            ++i;
        }
        i = 0;
        while (i < file.size()) {
            line = file.get(i).toString().trim();
            if (line.startsWith("import proper.") && !this.imports.contains(line = line.replaceAll("import ", "").replaceAll(";", ""))) {
                newClasses.add(line);
            }
            ++i;
        }
        i = 0;
        while (i < newClasses.size()) {
            if (!this.imports.contains(newClasses.get(i)) && !(result = this.getClasses(newClasses.get(i).toString()))) break;
            ++i;
        }
        return result;
    }

    private Vector getImages(String classname) {
        ProperVector result = new ProperVector();
        Vector file = this.loadFile(classname);
        int i = 0;
        while (i < file.size()) {
            String line = file.get(i).toString();
            if (line.matches(".*\"[^\"]*\\.gif\".*")) {
                line = line.replaceAll(".gif\".*", ".gif");
                line = line.replaceAll("[^\"]*\"", "");
                result.add(line);
            }
            ++i;
        }
        return result;
    }

    private boolean determineImages() {
        Iterator iter = this.imports.iterator();
        while (iter.hasNext()) {
            Vector files = this.getImages(iter.next().toString());
            int i = 0;
            while (i < files.size()) {
                this.images.add(files.get(i));
                ++i;
            }
        }
        return true;
    }

    private Vector transform(Vector lines) {
        String pack = this.cl.getValue("package");
        int i = 0;
        while (i < lines.size()) {
            String line = lines.get(i).toString().trim();
            if (line.startsWith("package ")) {
                if (pack.equals("")) {
                    lines.set(i, "");
                } else {
                    lines.set(i, "package " + pack + ";");
                }
            } else {
                if (line.startsWith("import proper.")) {
                    if (pack.equals("")) {
                        lines.set(i, "");
                    } else {
                        lines.set(i, "import " + pack + "." + line.replaceAll(".*\\.", ""));
                    }
                }
                if (line.indexOf("@see") > -1 && line.indexOf("proper.") > -1) {
                    int pos2;
                    int pos = lines.get(i).toString().indexOf("*");
                    if (pos == -1) {
                        pos = 0;
                    }
                    if ((pos2 = lines.get(i).toString().indexOf("proper.") - pos - 6) < 0) {
                        pos2 = 0;
                    }
                    String classname = line.trim().replaceAll(".*\\.", "");
                    if (pack.equals("")) {
                        lines.set(i, String.valueOf(Strings.stringOf(" ", pos)) + "* @see" + Strings.stringOf(" ", pos2) + classname);
                    } else {
                        lines.set(i, String.valueOf(Strings.stringOf(" ", pos)) + "* @see" + Strings.stringOf(" ", pos2) + pack + "." + classname);
                    }
                }
                if (line.indexOf("proper/gui/core/images/") > -1) {
                    if (pack.equals("")) {
                        lines.set(i, line.replaceAll("proper/gui/core/images/", "images/"));
                    } else {
                        lines.set(i, line.replaceAll("proper/gui/core/images/", String.valueOf(pack.replaceAll("\\.", "/")) + "/images/"));
                    }
                }
            }
            ++i;
        }
        return lines;
    }

    private boolean copyFiles() {
        boolean result;
        String dir = this.cl.getValue("output_dir");
        if (this.cl.hasValue("package")) {
            dir = String.valueOf(dir) + "/" + this.cl.getValue("package").replaceAll("\\.", "/");
        }
        if (!(result = this.createDir(dir))) {
            return result;
        }
        Iterator iter = this.imports.iterator();
        while (iter.hasNext()) {
            String classname = iter.next().toString();
            this.println(" -" + classname);
            String filename = this.getFilename(classname);
            String newFilename = this.getNewFilename(classname);
            Vector file = TextFile.load(filename);
            if (file.size() == 0) {
                this.println("Error loading: " + filename);
                result = false;
            }
            if (result) {
                file = this.transform(file);
                result = TextFile.save(newFilename, file);
            }
            if (!result) break;
        }
        return result;
    }

    private boolean copyImages() {
        boolean result;
        String dir = this.cl.getValue("output_dir");
        if (this.cl.hasValue("package")) {
            dir = String.valueOf(dir) + "/" + this.cl.getValue("package").replaceAll("\\.", "/");
        }
        if (!(result = this.createDir(dir = String.valueOf(dir) + "/images/"))) {
            return result;
        }
        Iterator iter = this.images.iterator();
        while (iter.hasNext()) {
            String imagename = iter.next().toString();
            this.println(" -" + imagename);
            result = CopyFile.copy(String.valueOf(this.cl.getValue("input_dir")) + "/" + "proper/gui/core/images/" + imagename, String.valueOf(dir) + imagename);
            if (!result) break;
        }
        return result;
    }

    @Override
    protected boolean process() throws Exception {
        this.println("\nTransforming\n============\n");
        this.println("Determining imports...");
        boolean result = this.getClasses(this.cl.getValue("class"));
        if (result) {
            this.println("\nDetermining images...");
            result = this.determineImages();
        }
        if (result) {
            this.println("\nCopying files to " + this.cl.getValue("output_dir") + "...");
            result = this.copyFiles();
        }
        if (result) {
            this.println("\nCopying images to " + this.cl.getValue("output_dir") + "/images...");
            result = this.copyImages();
        }
        if (result) {
            this.println("\nFinished!");
        } else {
            this.println("\nFailed!");
        }
        return result;
    }

    public static void main(String[] args) throws Exception {
        Standalone app = new Standalone();
        app.run(args);
    }
}

