/*
 * Decompiled with CFR 0.152.
 */
package proper.app;

import java.util.Vector;
import proper.app.DatabaseApplication;
import proper.engine.Engine;
import proper.engine.Flattener;
import proper.engine.ReMilker;
import proper.engine.Relaggs;

public class REMILK
extends DatabaseApplication {
    private int maxDepth;

    @Override
    protected void defaultParameters() {
        super.defaultParameters();
        this.maxDepth = 1;
    }

    @Override
    protected void defineParameters() {
        super.defineParameters();
        this.addDefinition("table", "the table that contains the target", true, "<name>", false);
        this.addDefinition("field", "the field to use as class", true, "<name>", false);
        this.addDefinition("result_table", "the table the combined propositionalized data from RELAGGS and MILK is stored", true, "<name>", false);
        this.addDefinition("result_table_relaggs", "the table RELAGGS stores the propositionalized data", true, "<name>", false);
        this.addDefinition("skip_relaggs", "if this flag is given, Proper assumes that RELAGGS was already run", false, "", true);
        this.addDefinition("result_table_milk", "the table MILK stores the flattened data", true, "<name>", false);
        this.addDefinition("skip_milk", "if this flag is given, Proper assumes that MILK was already run", false, "", true);
        this.addDefinition("exclude_tables", "tables you want to exclude from the aggregation through Relaggs", true, "<name[,name...]>", true);
        this.addDefinition("join", "type of join to be performed in RELAGGS and MILK, can be 'natural' or\n'leftouter' ('leftouter' implies '-any_index')", true, "natural | leftouter", true);
        this.addDefinition("any_index", "whether to use any index or the primary key for aggregation", false, "", true);
        this.addDefinition("index", "specifies the index to use instead of the primary key (implies '-any_index')", true, "<name>", true);
        this.addDefinition("max_depth", "defines the maximal depth the search for relations does, -1 means unlimited\ndefault is: " + this.maxDepth, true, "<int>", true);
        this.addDefinition("use_foreign_keys", "uses foreign key relations to determine relations between tables rather \nthan matching column names", false, "", true);
        this.addDefinition("instead_null", "defines the values for columns (type is determined automatically) which is\nused instead of NULL values after a Join.", true, "<col=value[,col=value[,...]]>", true);
        this.addDefinition("tree", "instead of discovering the structure of the DB itself a tree structure can\nbe defined by the user. It starts with the root node, the children are\nseparated by ',' and a substree is surrounded by '[' and ']', e.g.:\na[b,c,d[e,f[g,h]]", true, "<tree-string>", true);
        this.addDefinition("propagation", "whether to use propagation of keys instead of joins for the branches and\nperform joins only at the last level", false, "", true);
        this.addDefinition("properties", "comma-separated list of RELAGGS properties (key-valuye pairs)", true, "<key=value[,key=value[,...]]>", true);
    }

    @Override
    public void printDescription() {
        System.out.println("Combines propositionalization based on RELAGGS and MILK via left outer join.");
        System.out.println();
    }

    @Override
    protected boolean process() throws Exception {
        Relaggs relaggs = new Relaggs();
        Flattener milk = new Flattener();
        ReMilker engine = new ReMilker();
        this.initEngine(relaggs);
        this.initEngine(milk);
        this.initEngine(engine);
        Vector params = this.cl.getParameters();
        int i = 0;
        while (i < params.size()) {
            String param = params.get(i).toString();
            if (param.equals("table") || param.equals("field") || param.equals("exclude_tables") || param.equals("join") || param.equals("max_depth") || param.equals("use_foreign_keys") || param.equals("propagation") || param.equals("tree")) {
                relaggs.setParameter(param, this.fixAdditionalArg(this.cl.getValue(param)));
                milk.setParameter(param, this.fixAdditionalArg(this.cl.getValue(param)));
            }
            if (param.equals("any_index") || param.equals("index") || param.equals("properties")) {
                relaggs.setParameter(param, this.cl.getValue(param));
            }
            if (param.equals("result_table_relaggs")) {
                relaggs.setParameter("result_table", this.cl.getValue(param));
            }
            if (param.equals("result_table_milk")) {
                milk.setParameter("result_table", this.cl.getValue(param));
            }
            if (param.startsWith("result_table")) {
                engine.setParameter(param, this.cl.getValue(param));
            }
            ++i;
        }
        engine.setParameter("field", this.cl.getValue("field"));
        engine.setParameter("bag", String.valueOf(this.cl.getValue("table")) + "id");
        boolean result = true;
        if (result && !this.cl.exists("skip_relaggs")) {
            result = ((Engine)relaggs).execute();
        }
        if (result && !this.cl.exists("skip_milk")) {
            result = ((Engine)milk).execute();
        }
        if (result) {
            result = ((Engine)engine).execute();
        }
        return result;
    }

    public static void main(String[] args) throws Exception {
        REMILK app = new REMILK();
        app.run(args);
    }
}

