/*
 * Decompiled with CFR 0.152.
 */
package proper.app;

import java.util.Vector;
import proper.app.DatabaseApplication;
import proper.database.ColumnLister;
import proper.database.Connector;
import proper.database.Table;
import proper.database.TableLister;
import proper.util.ProperVector;

public class ForeignKeys
extends DatabaseApplication {
    @Override
    protected void defineParameters() {
        super.defineParameters();
        this.addDefinition("table", "the table to retrieve the foreign keys for (\"%\" means for all tables)", true, "<name>", false);
    }

    @Override
    public void printDescription() {
        System.out.println("Displays the foreign keys of a given table - unfortunately, the current MySQL driver");
        System.out.println("doesn't supported this.");
        System.out.println();
    }

    @Override
    protected boolean process() throws Exception {
        Vector tables;
        Connector conn = new Connector(this.cl.getValue("driver"), this.cl.getValue("url"), this.cl.getValue("database"), this.cl.getValue("user"), this.cl.getValue("password"));
        this.addListener(conn);
        if (this.cl.getValue("table").equals("%")) {
            TableLister tabLister = new TableLister(conn);
            tables = tabLister.getList();
        } else {
            tables = new ProperVector();
            tables.add(new Table(this.cl.getValue("table")));
        }
        int n = 0;
        while (n < tables.size()) {
            int i;
            String table = tables.get(n).toString();
            ColumnLister colLister = new ColumnLister(conn, table);
            this.println("\nTable: " + table);
            colLister.setOnlyExportedKeys(true);
            Vector tmpList = colLister.getList();
            if (tmpList.size() > 0) {
                this.println("\n- Exported Keys:");
                i = 0;
                while (i < tmpList.size()) {
                    this.println("  " + tmpList.get(i));
                    ++i;
                }
            }
            colLister.setOnlyImportedKeys(true);
            tmpList = colLister.getList();
            if (tmpList.size() > 0) {
                this.println("\n- Imported Keys:");
                i = 0;
                while (i < tmpList.size()) {
                    this.println("  " + tmpList.get(i));
                    ++i;
                }
            }
            ++n;
        }
        return true;
    }

    public static void main(String[] args) throws Exception {
        ForeignKeys app = new ForeignKeys();
        app.run(args);
    }
}

