/*
 * Decompiled with CFR 0.152.
 */
package proper.app;

import proper.app.Application;
import proper.engine.Engine;
import proper.engine.MilkExperimenter;
import proper.engine.WekaExperimenter;

public class Experimenter
extends Application {
    @Override
    public void checkCommandLine() {
        super.checkCommandLine();
        if (!(this.cl.exists("input") && this.cl.exists("output") && this.cl.exists("classifier"))) {
            this.parameterError();
        }
    }

    @Override
    public void printDescription() {
        System.out.println("Runs either the WEKA- or the MILK-Experimenter with Crossvalidation.");
        System.out.println();
    }

    @Override
    public void printUsage() {
        super.printUsage();
        System.out.println(" -input <name>");
        System.out.println("  the name of an ARFF-File");
        System.out.println(" -output <name>");
        System.out.println("  the name of the ARFF-File to store the statistics in");
        System.out.println(" -classifier <complete classname>");
        System.out.println("  the WEKA-/MILK-Classifier's classname");
        System.out.println(" -additional <add. parameters> (optional)");
        System.out.println("  additional parameters for the classifier. if a parameter starts with a '-'");
        System.out.println("  it has to be written as a '=' instead, otherwise it is interpreted as");
        System.out.println("  another parameter.");
        System.out.println(" -type [cv|loo] [optional]");
        System.out.println("  the type of evaluation to perform: 'cv' (Crossvalidation) or 'loo' (Leave-");
        System.out.println("One-Out) are possible, default is 'cv'");
        System.out.println(" -runs <number> [optional]");
        System.out.println("  how often the experiment shall be performed, default is 10");
        System.out.println(" -folds <number> [optional]");
        System.out.println("  the number of folds in case of CV, default is 10");
    }

    @Override
    protected boolean process() throws Exception {
        Engine engine = this.cl.getValue("classifier").startsWith("milk.") ? new MilkExperimenter() : new WekaExperimenter();
        this.addListener(engine);
        if (!engine.getVerbose()) {
            engine.setVerbose(this.getVerbose());
        }
        engine.setParameter("input", this.cl.getValue("input"));
        engine.setParameter("output", this.cl.getValue("output"));
        engine.setParameter("classifier", this.cl.getValue("classifier"));
        engine.setParameter("additional", this.fixAdditionalArg(this.cl.getValue("additional")));
        if (this.cl.exists("type")) {
            engine.setParameter("type", this.cl.getValue("type"));
        }
        if (this.cl.exists("runs")) {
            engine.setParameter("runs", this.cl.getValue("runs"));
        }
        if (this.cl.exists("folds")) {
            engine.setParameter("folds", this.cl.getValue("folds"));
        }
        return engine.execute();
    }

    public static void main(String[] args) throws Exception {
        Experimenter app = new Experimenter();
        app.run(args);
    }
}

