from setuptools import setup, find_packages

setup(
    name='libs3tl',
    packages=find_packages(include=('libs3tl*',)),
    version='0.1.40',
    description='This is a 3TL module for pipeline creation',
    long_description_content_type=open('README.txt').read(),
    url='https://3tl.dev',
    author='Thinkartha',
    author_email='navin.naik@thinkartha.com',
    license='BSD 2-clause',
    # packages=['libs3tl'],
    install_requires=[
                      'jproperties==2.1.1',
                      'redis==4.3.4',
                      'requests==2.28.1',
                      'toolz==0.12.0',
                      'urllib3==1.26.10',
                      'airbyte-cdk==0.1.53',
                      'gcsfs==2022.7.1',
                      'genson==1.2.2',
                      'google-cloud-storage==2.5.0',
                      'pandas==1.4.3',
                      'paramiko==2.11.0',
                      's3fs==2022.7.1',
                      'boto3==1.21.21',
                      'smart-open[all]==6.0.0',
                      'lxml==4.9.1',
                      'html5lib==1.1',
                      'pyarrow==9.0.0',
                      'xlrd==2.0.1',
                      'openpyxl==3.0.10',
                      'pyxlsb==1.0.9',
                      'azure-storage-blob==12.14.1',
                      'sqlalchemy==1.4.39',
                      ],

    classifiers=[
        'Development Status :: 1 - Planning',
        'Intended Audience :: Science/Research',
        'License :: OSI Approved :: BSD License',  
        'Operating System :: POSIX :: Linux',        
        'Programming Language :: Python :: 3.8',
    ],
)