# coding=utf-8
# --------------------------------------------------------------------------
# Code generated by Microsoft (R) AutoRest Code Generator (autorest: 3.0.6365, generator: {generator})
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------

import msrest.serialization


class AlarmDefinitionChild(msrest.serialization.Model):
    """AlarmDefinitionChild.

    :param low_alarm_value:
    :type low_alarm_value: float
    :param low_warning_value:
    :type low_warning_value: float
    :param high_alarm_value:
    :type high_alarm_value: float
    :param high_warning_value:
    :type high_warning_value: float
    :param off_threshold_value:
    :type off_threshold_value: float
    :param classification:
    :type classification: str
    """

    _attribute_map = {
        'low_alarm_value': {'key': 'LowAlarmValue', 'type': 'float'},
        'low_warning_value': {'key': 'LowWarningValue', 'type': 'float'},
        'high_alarm_value': {'key': 'HighAlarmValue', 'type': 'float'},
        'high_warning_value': {'key': 'HighWarningValue', 'type': 'float'},
        'off_threshold_value': {'key': 'OffThresholdValue', 'type': 'float'},
        'classification': {'key': 'Classification', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(AlarmDefinitionChild, self).__init__(**kwargs)
        self.low_alarm_value = kwargs.get('low_alarm_value', None)
        self.low_warning_value = kwargs.get('low_warning_value', None)
        self.high_alarm_value = kwargs.get('high_alarm_value', None)
        self.high_warning_value = kwargs.get('high_warning_value', None)
        self.off_threshold_value = kwargs.get('off_threshold_value', None)
        self.classification = kwargs.get('classification', None)


class AnalyticsModelChild(msrest.serialization.Model):
    """AnalyticsModelChild.

    All required parameters must be populated in order to send to Azure.

    :param analytics_model_id: Required.
    :type analytics_model_id: int
    :param analytics_model_name: Required.
    :type analytics_model_name: str
    :param analytics_model_version: Required.
    :type analytics_model_version: str
    """

    _validation = {
        'analytics_model_id': {'required': True},
        'analytics_model_name': {'required': True},
        'analytics_model_version': {'required': True},
    }

    _attribute_map = {
        'analytics_model_id': {'key': 'AnalyticsModelId', 'type': 'int'},
        'analytics_model_name': {'key': 'AnalyticsModelName', 'type': 'str'},
        'analytics_model_version': {'key': 'AnalyticsModelVersion', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(AnalyticsModelChild, self).__init__(**kwargs)
        self.analytics_model_id = kwargs['analytics_model_id']
        self.analytics_model_name = kwargs['analytics_model_name']
        self.analytics_model_version = kwargs['analytics_model_version']


class AnalyticsModelCreateRequest(msrest.serialization.Model):
    """AnalyticsModelCreateRequest.

    All required parameters must be populated in order to send to Azure.

    :param name: Required.
    :type name: str
    :param version: Required.
    :type version: str
    :param location_id:
    :type location_id: str
    :param corporation_id:
    :type corporation_id: str
    :param type: Required.  Possible values include: "SMARTIndicator", "Classifier".
    :type type: str or ~smartdiagnostics_sdk.models.AnalyticsModelCreateRequestType
    :param indicators:
    :type indicators: list[~smartdiagnostics_sdk.models.AnalyticsModelIndicatorChild]
    :param related_model_ids:
    :type related_model_ids: list[int]
    :param group_type:  Possible values include: "Asset", "MonitoringPoint", "IndicatorGroup",
     "Group", "AnalyticModel".
    :type group_type: str or ~smartdiagnostics_sdk.models.AnalyticsModelCreateRequestGroupType
    :param properties:
    :type properties: list[~smartdiagnostics_sdk.models.PropertyRequestChild]
    """

    _validation = {
        'name': {'required': True, 'max_length': 50, 'min_length': 0},
        'version': {'required': True, 'max_length': 50, 'min_length': 0},
        'type': {'required': True},
    }

    _attribute_map = {
        'name': {'key': 'Name', 'type': 'str'},
        'version': {'key': 'Version', 'type': 'str'},
        'location_id': {'key': 'LocationId', 'type': 'str'},
        'corporation_id': {'key': 'CorporationId', 'type': 'str'},
        'type': {'key': 'Type', 'type': 'str'},
        'indicators': {'key': 'Indicators', 'type': '[AnalyticsModelIndicatorChild]'},
        'related_model_ids': {'key': 'RelatedModelIds', 'type': '[int]'},
        'group_type': {'key': 'GroupType', 'type': 'str'},
        'properties': {'key': 'Properties', 'type': '[PropertyRequestChild]'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(AnalyticsModelCreateRequest, self).__init__(**kwargs)
        self.name = kwargs['name']
        self.version = kwargs['version']
        self.location_id = kwargs.get('location_id', None)
        self.corporation_id = kwargs.get('corporation_id', None)
        self.type = kwargs['type']
        self.indicators = kwargs.get('indicators', None)
        self.related_model_ids = kwargs.get('related_model_ids', None)
        self.group_type = kwargs.get('group_type', None)
        self.properties = kwargs.get('properties', None)


class AnalyticsModelIndicatorChild(msrest.serialization.Model):
    """AnalyticsModelIndicatorChild.

    All required parameters must be populated in order to send to Azure.

    :param indicator_name: Required.
    :type indicator_name: str
    :param indicator_units: Required.
    :type indicator_units: str
    """

    _validation = {
        'indicator_name': {'required': True},
        'indicator_units': {'required': True},
    }

    _attribute_map = {
        'indicator_name': {'key': 'IndicatorName', 'type': 'str'},
        'indicator_units': {'key': 'IndicatorUnits', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(AnalyticsModelIndicatorChild, self).__init__(**kwargs)
        self.indicator_name = kwargs['indicator_name']
        self.indicator_units = kwargs['indicator_units']


class AnalyticsModelRelatedModelChild(msrest.serialization.Model):
    """AnalyticsModelRelatedModelChild.

    :param related_model_id:
    :type related_model_id: int
    :param related_model_name:
    :type related_model_name: str
    :param related_model_type:  Possible values include: "SMARTIndicator", "Classifier".
    :type related_model_type: str or
     ~smartdiagnostics_sdk.models.AnalyticsModelRelatedModelChildRelatedModelType
    """

    _attribute_map = {
        'related_model_id': {'key': 'RelatedModelId', 'type': 'int'},
        'related_model_name': {'key': 'RelatedModelName', 'type': 'str'},
        'related_model_type': {'key': 'RelatedModelType', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(AnalyticsModelRelatedModelChild, self).__init__(**kwargs)
        self.related_model_id = kwargs.get('related_model_id', None)
        self.related_model_name = kwargs.get('related_model_name', None)
        self.related_model_type = kwargs.get('related_model_type', None)


class AnalyticsModelResponse(msrest.serialization.Model):
    """AnalyticsModelResponse.

    All required parameters must be populated in order to send to Azure.

    :param id: Required.
    :type id: int
    :param name: Required.
    :type name: str
    :param version: Required.
    :type version: str
    :param type:  Possible values include: "SMARTIndicator", "Classifier".
    :type type: str or ~smartdiagnostics_sdk.models.AnalyticsModelResponseType
    :param created:
    :type created: ~datetime.datetime
    :param group_type:  Possible values include: "Asset", "MonitoringPoint", "IndicatorGroup",
     "Group", "AnalyticModel".
    :type group_type: str or ~smartdiagnostics_sdk.models.AnalyticsModelResponseGroupType
    :param is_global:
    :type is_global: bool
    :param is_deprecated:
    :type is_deprecated: bool
    :param indicators:
    :type indicators: list[~smartdiagnostics_sdk.models.AnalyticsModelIndicatorChild]
    :param properties:
    :type properties: list[~smartdiagnostics_sdk.models.PropertyChild]
    :param related_models:
    :type related_models: list[~smartdiagnostics_sdk.models.AnalyticsModelRelatedModelChild]
    :param created_by:
    :type created_by: ~smartdiagnostics_sdk.models.UserChild
    :param corporation:
    :type corporation: ~smartdiagnostics_sdk.models.CorporationChild
    :param location:
    :type location: ~smartdiagnostics_sdk.models.LocationChild
    """

    _validation = {
        'id': {'required': True},
        'name': {'required': True},
        'version': {'required': True},
    }

    _attribute_map = {
        'id': {'key': 'Id', 'type': 'int'},
        'name': {'key': 'Name', 'type': 'str'},
        'version': {'key': 'Version', 'type': 'str'},
        'type': {'key': 'Type', 'type': 'str'},
        'created': {'key': 'Created', 'type': 'iso-8601'},
        'group_type': {'key': 'GroupType', 'type': 'str'},
        'is_global': {'key': 'IsGlobal', 'type': 'bool'},
        'is_deprecated': {'key': 'IsDeprecated', 'type': 'bool'},
        'indicators': {'key': 'Indicators', 'type': '[AnalyticsModelIndicatorChild]'},
        'properties': {'key': 'Properties', 'type': '[PropertyChild]'},
        'related_models': {'key': 'RelatedModels', 'type': '[AnalyticsModelRelatedModelChild]'},
        'created_by': {'key': 'CreatedBy', 'type': 'UserChild'},
        'corporation': {'key': 'Corporation', 'type': 'CorporationChild'},
        'location': {'key': 'Location', 'type': 'LocationChild'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(AnalyticsModelResponse, self).__init__(**kwargs)
        self.id = kwargs['id']
        self.name = kwargs['name']
        self.version = kwargs['version']
        self.type = kwargs.get('type', None)
        self.created = kwargs.get('created', None)
        self.group_type = kwargs.get('group_type', None)
        self.is_global = kwargs.get('is_global', None)
        self.is_deprecated = kwargs.get('is_deprecated', None)
        self.indicators = kwargs.get('indicators', None)
        self.properties = kwargs.get('properties', None)
        self.related_models = kwargs.get('related_models', None)
        self.created_by = kwargs.get('created_by', None)
        self.corporation = kwargs.get('corporation', None)
        self.location = kwargs.get('location', None)


class AssetCategoryChild(msrest.serialization.Model):
    """AssetCategoryChild.

    :param category_id:
    :type category_id: int
    :param category_name:
    :type category_name: str
    :param category_code:
    :type category_code: str
    :param category_marker:
    :type category_marker: ~smartdiagnostics_sdk.models.AssetCategoryMarkerChild
    """

    _attribute_map = {
        'category_id': {'key': 'CategoryId', 'type': 'int'},
        'category_name': {'key': 'CategoryName', 'type': 'str'},
        'category_code': {'key': 'CategoryCode', 'type': 'str'},
        'category_marker': {'key': 'CategoryMarker', 'type': 'AssetCategoryMarkerChild'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(AssetCategoryChild, self).__init__(**kwargs)
        self.category_id = kwargs.get('category_id', None)
        self.category_name = kwargs.get('category_name', None)
        self.category_code = kwargs.get('category_code', None)
        self.category_marker = kwargs.get('category_marker', None)


class AssetCategoryMarkerChild(msrest.serialization.Model):
    """AssetCategoryMarkerChild.

    :param category_marker_id:
    :type category_marker_id: int
    :param category_marker_name:
    :type category_marker_name: str
    :param category_marker_code:
    :type category_marker_code: str
    """

    _attribute_map = {
        'category_marker_id': {'key': 'CategoryMarkerId', 'type': 'int'},
        'category_marker_name': {'key': 'CategoryMarkerName', 'type': 'str'},
        'category_marker_code': {'key': 'CategoryMarkerCode', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(AssetCategoryMarkerChild, self).__init__(**kwargs)
        self.category_marker_id = kwargs.get('category_marker_id', None)
        self.category_marker_name = kwargs.get('category_marker_name', None)
        self.category_marker_code = kwargs.get('category_marker_code', None)


class AssetCategoryWithSizeChild(msrest.serialization.Model):
    """AssetCategoryWithSizeChild.

    All required parameters must be populated in order to send to Azure.

    :param category_id: Required.
    :type category_id: int
    :param category_name: Required.
    :type category_name: str
    :param category_code: Required.
    :type category_code: str
    :param category_marker:
    :type category_marker: ~smartdiagnostics_sdk.models.AssetCategoryMarkerChild
    :param category_sizes:
    :type category_sizes: list[~smartdiagnostics_sdk.models.AssetSizeChild]
    """

    _validation = {
        'category_id': {'required': True},
        'category_name': {'required': True},
        'category_code': {'required': True},
    }

    _attribute_map = {
        'category_id': {'key': 'CategoryId', 'type': 'int'},
        'category_name': {'key': 'CategoryName', 'type': 'str'},
        'category_code': {'key': 'CategoryCode', 'type': 'str'},
        'category_marker': {'key': 'CategoryMarker', 'type': 'AssetCategoryMarkerChild'},
        'category_sizes': {'key': 'CategorySizes', 'type': '[AssetSizeChild]'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(AssetCategoryWithSizeChild, self).__init__(**kwargs)
        self.category_id = kwargs['category_id']
        self.category_name = kwargs['category_name']
        self.category_code = kwargs['category_code']
        self.category_marker = kwargs.get('category_marker', None)
        self.category_sizes = kwargs.get('category_sizes', None)


class AssetCreateRequest(msrest.serialization.Model):
    """AssetCreateRequest.

    All required parameters must be populated in order to send to Azure.

    :param parent_id: Required.
    :type parent_id: str
    :param name: Required.
    :type name: str
    :param abbreviation:
    :type abbreviation: str
    :param supplier:
    :type supplier: str
    :param manufacturer:
    :type manufacturer: str
    :param model_name:
    :type model_name: str
    :param location_notes:
    :type location_notes: str
    :param notes:
    :type notes: str
    :param generic_input:
    :type generic_input: str
    :param is_operator_view: Required.
    :type is_operator_view: bool
    :param type_id:
    :type type_id: int
    :param category_id:
    :type category_id: int
    :param size_id:
    :type size_id: int
    :param criticality_id:
    :type criticality_id: int
    :param asset_cost:
    :type asset_cost: float
    :param date_installed:
    :type date_installed: ~datetime.datetime
    :param annual_run_time:
    :type annual_run_time: float
    :param lost_production_cost:
    :type lost_production_cost: float
    :param overhaul_cost:
    :type overhaul_cost: float
    :param power_consumption:
    :type power_consumption: float
    :param life_expectancy:
    :type life_expectancy: float
    :param unscheduled_downtime:
    :type unscheduled_downtime: float
    :param running_speed_harmonic:
    :type running_speed_harmonic: float
    """

    _validation = {
        'parent_id': {'required': True},
        'name': {'required': True, 'max_length': 100, 'min_length': 0},
        'abbreviation': {'max_length': 5, 'min_length': 0},
        'supplier': {'max_length': 128, 'min_length': 0},
        'manufacturer': {'max_length': 128, 'min_length': 0},
        'model_name': {'max_length': 128, 'min_length': 0},
        'location_notes': {'max_length': 256, 'min_length': 0},
        'notes': {'max_length': 2000, 'min_length': 0},
        'generic_input': {'max_length': 2000, 'min_length': 0},
        'is_operator_view': {'required': True},
    }

    _attribute_map = {
        'parent_id': {'key': 'ParentId', 'type': 'str'},
        'name': {'key': 'Name', 'type': 'str'},
        'abbreviation': {'key': 'Abbreviation', 'type': 'str'},
        'supplier': {'key': 'Supplier', 'type': 'str'},
        'manufacturer': {'key': 'Manufacturer', 'type': 'str'},
        'model_name': {'key': 'ModelName', 'type': 'str'},
        'location_notes': {'key': 'LocationNotes', 'type': 'str'},
        'notes': {'key': 'Notes', 'type': 'str'},
        'generic_input': {'key': 'GenericInput', 'type': 'str'},
        'is_operator_view': {'key': 'IsOperatorView', 'type': 'bool'},
        'type_id': {'key': 'TypeId', 'type': 'int'},
        'category_id': {'key': 'CategoryId', 'type': 'int'},
        'size_id': {'key': 'SizeId', 'type': 'int'},
        'criticality_id': {'key': 'CriticalityId', 'type': 'int'},
        'asset_cost': {'key': 'AssetCost', 'type': 'float'},
        'date_installed': {'key': 'DateInstalled', 'type': 'iso-8601'},
        'annual_run_time': {'key': 'AnnualRunTime', 'type': 'float'},
        'lost_production_cost': {'key': 'LostProductionCost', 'type': 'float'},
        'overhaul_cost': {'key': 'OverhaulCost', 'type': 'float'},
        'power_consumption': {'key': 'PowerConsumption', 'type': 'float'},
        'life_expectancy': {'key': 'LifeExpectancy', 'type': 'float'},
        'unscheduled_downtime': {'key': 'UnscheduledDowntime', 'type': 'float'},
        'running_speed_harmonic': {'key': 'RunningSpeedHarmonic', 'type': 'float'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(AssetCreateRequest, self).__init__(**kwargs)
        self.parent_id = kwargs['parent_id']
        self.name = kwargs['name']
        self.abbreviation = kwargs.get('abbreviation', None)
        self.supplier = kwargs.get('supplier', None)
        self.manufacturer = kwargs.get('manufacturer', None)
        self.model_name = kwargs.get('model_name', None)
        self.location_notes = kwargs.get('location_notes', None)
        self.notes = kwargs.get('notes', None)
        self.generic_input = kwargs.get('generic_input', None)
        self.is_operator_view = kwargs['is_operator_view']
        self.type_id = kwargs.get('type_id', None)
        self.category_id = kwargs.get('category_id', None)
        self.size_id = kwargs.get('size_id', None)
        self.criticality_id = kwargs.get('criticality_id', None)
        self.asset_cost = kwargs.get('asset_cost', None)
        self.date_installed = kwargs.get('date_installed', None)
        self.annual_run_time = kwargs.get('annual_run_time', None)
        self.lost_production_cost = kwargs.get('lost_production_cost', None)
        self.overhaul_cost = kwargs.get('overhaul_cost', None)
        self.power_consumption = kwargs.get('power_consumption', None)
        self.life_expectancy = kwargs.get('life_expectancy', None)
        self.unscheduled_downtime = kwargs.get('unscheduled_downtime', None)
        self.running_speed_harmonic = kwargs.get('running_speed_harmonic', None)


class AssetCriticalityChild(msrest.serialization.Model):
    """AssetCriticalityChild.

    :param criticality_id:
    :type criticality_id: int
    :param criticality_name:
    :type criticality_name: str
    """

    _attribute_map = {
        'criticality_id': {'key': 'CriticalityId', 'type': 'int'},
        'criticality_name': {'key': 'CriticalityName', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(AssetCriticalityChild, self).__init__(**kwargs)
        self.criticality_id = kwargs.get('criticality_id', None)
        self.criticality_name = kwargs.get('criticality_name', None)


class AssetDrumRollChild(msrest.serialization.Model):
    """AssetDrumRollChild.

    :param drum_roll_diameter:
    :type drum_roll_diameter: int
    :param drum_roll_diameter_unit:
    :type drum_roll_diameter_unit: str
    """

    _attribute_map = {
        'drum_roll_diameter': {'key': 'DrumRollDiameter', 'type': 'int'},
        'drum_roll_diameter_unit': {'key': 'DrumRollDiameterUnit', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(AssetDrumRollChild, self).__init__(**kwargs)
        self.drum_roll_diameter = kwargs.get('drum_roll_diameter', None)
        self.drum_roll_diameter_unit = kwargs.get('drum_roll_diameter_unit', None)


class AssetEconomicsChild(msrest.serialization.Model):
    """AssetEconomicsChild.

    :param asset_cost:
    :type asset_cost: float
    :param date_installed:
    :type date_installed: ~datetime.datetime
    :param annual_run_time:
    :type annual_run_time: float
    :param lost_production_cost:
    :type lost_production_cost: float
    :param overhaul_cost:
    :type overhaul_cost: float
    :param power_consumption:
    :type power_consumption: float
    :param life_expectancy:
    :type life_expectancy: float
    :param unscheduled_downtime:
    :type unscheduled_downtime: float
    """

    _attribute_map = {
        'asset_cost': {'key': 'AssetCost', 'type': 'float'},
        'date_installed': {'key': 'DateInstalled', 'type': 'iso-8601'},
        'annual_run_time': {'key': 'AnnualRunTime', 'type': 'float'},
        'lost_production_cost': {'key': 'LostProductionCost', 'type': 'float'},
        'overhaul_cost': {'key': 'OverhaulCost', 'type': 'float'},
        'power_consumption': {'key': 'PowerConsumption', 'type': 'float'},
        'life_expectancy': {'key': 'LifeExpectancy', 'type': 'float'},
        'unscheduled_downtime': {'key': 'UnscheduledDowntime', 'type': 'float'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(AssetEconomicsChild, self).__init__(**kwargs)
        self.asset_cost = kwargs.get('asset_cost', None)
        self.date_installed = kwargs.get('date_installed', None)
        self.annual_run_time = kwargs.get('annual_run_time', None)
        self.lost_production_cost = kwargs.get('lost_production_cost', None)
        self.overhaul_cost = kwargs.get('overhaul_cost', None)
        self.power_consumption = kwargs.get('power_consumption', None)
        self.life_expectancy = kwargs.get('life_expectancy', None)
        self.unscheduled_downtime = kwargs.get('unscheduled_downtime', None)


class AssetResponse(msrest.serialization.Model):
    """AssetResponse.

    All required parameters must be populated in order to send to Azure.

    :param supplier:
    :type supplier: str
    :param manufacturer:
    :type manufacturer: str
    :param model_name:
    :type model_name: str
    :param location_notes:
    :type location_notes: str
    :param notes:
    :type notes: str
    :param generic_input:
    :type generic_input: str
    :param is_operator_view:
    :type is_operator_view: bool
    :param type:
    :type type: ~smartdiagnostics_sdk.models.AssetTypeChild
    :param category:
    :type category: ~smartdiagnostics_sdk.models.AssetCategoryChild
    :param size:
    :type size: ~smartdiagnostics_sdk.models.AssetSizeChild
    :param economics:
    :type economics: ~smartdiagnostics_sdk.models.AssetEconomicsChild
    :param running_speed:
    :type running_speed: ~smartdiagnostics_sdk.models.AssetRunningSpeedChild
    :param criticality:
    :type criticality: ~smartdiagnostics_sdk.models.AssetCriticalityChild
    :param drum_roll:
    :type drum_roll: ~smartdiagnostics_sdk.models.AssetDrumRollChild
    :param hierarchy:
    :type hierarchy: list[~smartdiagnostics_sdk.models.HierarchyChild]
    :param parent:
    :type parent: ~smartdiagnostics_sdk.models.ParentChild
    :param children:
    :type children: list[~smartdiagnostics_sdk.models.DescendantChild]
    :param tags: A set of tags.
    :type tags: list[~smartdiagnostics_sdk.models.TagChild]
    :param analytics_models:
    :type analytics_models: list[~smartdiagnostics_sdk.models.AnalyticsModelChild]
    :param id: Required.
    :type id: str
    :param name: Required.
    :type name: str
    :param abbreviation:
    :type abbreviation: str
    :param active: Required.
    :type active: bool
    :param is_paused: Required.
    :type is_paused: bool
    :param is_snoozed: Required.
    :type is_snoozed: bool
    :param created: Required.
    :type created: ~datetime.datetime
    :param corporation: Required.
    :type corporation: ~smartdiagnostics_sdk.models.CorporationChild
    :param location: Required.
    :type location: ~smartdiagnostics_sdk.models.LocationChild
    """

    _validation = {
        'id': {'required': True},
        'name': {'required': True},
        'active': {'required': True},
        'is_paused': {'required': True},
        'is_snoozed': {'required': True},
        'created': {'required': True},
        'corporation': {'required': True},
        'location': {'required': True},
    }

    _attribute_map = {
        'supplier': {'key': 'Supplier', 'type': 'str'},
        'manufacturer': {'key': 'Manufacturer', 'type': 'str'},
        'model_name': {'key': 'ModelName', 'type': 'str'},
        'location_notes': {'key': 'LocationNotes', 'type': 'str'},
        'notes': {'key': 'Notes', 'type': 'str'},
        'generic_input': {'key': 'GenericInput', 'type': 'str'},
        'is_operator_view': {'key': 'IsOperatorView', 'type': 'bool'},
        'type': {'key': 'Type', 'type': 'AssetTypeChild'},
        'category': {'key': 'Category', 'type': 'AssetCategoryChild'},
        'size': {'key': 'Size', 'type': 'AssetSizeChild'},
        'economics': {'key': 'Economics', 'type': 'AssetEconomicsChild'},
        'running_speed': {'key': 'RunningSpeed', 'type': 'AssetRunningSpeedChild'},
        'criticality': {'key': 'Criticality', 'type': 'AssetCriticalityChild'},
        'drum_roll': {'key': 'DrumRoll', 'type': 'AssetDrumRollChild'},
        'hierarchy': {'key': 'Hierarchy', 'type': '[HierarchyChild]'},
        'parent': {'key': 'Parent', 'type': 'ParentChild'},
        'children': {'key': 'Children', 'type': '[DescendantChild]'},
        'tags': {'key': 'Tags', 'type': '[TagChild]'},
        'analytics_models': {'key': 'AnalyticsModels', 'type': '[AnalyticsModelChild]'},
        'id': {'key': 'Id', 'type': 'str'},
        'name': {'key': 'Name', 'type': 'str'},
        'abbreviation': {'key': 'Abbreviation', 'type': 'str'},
        'active': {'key': 'Active', 'type': 'bool'},
        'is_paused': {'key': 'IsPaused', 'type': 'bool'},
        'is_snoozed': {'key': 'IsSnoozed', 'type': 'bool'},
        'created': {'key': 'Created', 'type': 'iso-8601'},
        'corporation': {'key': 'Corporation', 'type': 'CorporationChild'},
        'location': {'key': 'Location', 'type': 'LocationChild'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(AssetResponse, self).__init__(**kwargs)
        self.supplier = kwargs.get('supplier', None)
        self.manufacturer = kwargs.get('manufacturer', None)
        self.model_name = kwargs.get('model_name', None)
        self.location_notes = kwargs.get('location_notes', None)
        self.notes = kwargs.get('notes', None)
        self.generic_input = kwargs.get('generic_input', None)
        self.is_operator_view = kwargs.get('is_operator_view', None)
        self.type = kwargs.get('type', None)
        self.category = kwargs.get('category', None)
        self.size = kwargs.get('size', None)
        self.economics = kwargs.get('economics', None)
        self.running_speed = kwargs.get('running_speed', None)
        self.criticality = kwargs.get('criticality', None)
        self.drum_roll = kwargs.get('drum_roll', None)
        self.hierarchy = kwargs.get('hierarchy', None)
        self.parent = kwargs.get('parent', None)
        self.children = kwargs.get('children', None)
        self.tags = kwargs.get('tags', None)
        self.analytics_models = kwargs.get('analytics_models', None)
        self.id = kwargs['id']
        self.name = kwargs['name']
        self.abbreviation = kwargs.get('abbreviation', None)
        self.active = kwargs['active']
        self.is_paused = kwargs['is_paused']
        self.is_snoozed = kwargs['is_snoozed']
        self.created = kwargs['created']
        self.corporation = kwargs['corporation']
        self.location = kwargs['location']


class AssetRunningSpeedChild(msrest.serialization.Model):
    """AssetRunningSpeedChild.

    :param running_speed_min:
    :type running_speed_min: float
    :param running_speed_max:
    :type running_speed_max: float
    :param running_speed_type:
    :type running_speed_type: str
    :param running_speed_reference_monitoring_point_id:
    :type running_speed_reference_monitoring_point_id: str
    :param running_speed_sensor_role_type:  Possible values include: "Invalid", "CurrentPhaseA",
     "PeakCurrentPhaseA", "CurrentPhaseB", "PeakCurrentPhaseB", "CurrentPhaseC",
     "PeakCurrentPhaseC", "DifferentialPressure", "Flow", "Humidity", "NodeTemperature",
     "NodeVoltage", "PeakVibration", "Pressure", "RmsVibration", "SignalStrength",
     "StandardAirVelocity", "SupplyVoltage", "Temperature", "TotalCurrent", "VibrationXAxis",
     "VibrationYAxis", "Voltage", "Current", "AtoDChannel1", "AtoDChannel2", "AtoDChannel3",
     "AtoDChannel4", "AtoDChannel5", "AtoDChannel6", "OilTemperature", "OilHumidity", "X", "Y", "Z",
     "Custom", "WirelessEfficiency", "PacketSuccessRate", "NodeHumidity", "BurstSuccessRate".
    :type running_speed_sensor_role_type: str or
     ~smartdiagnostics_sdk.models.AssetRunningSpeedChildRunningSpeedSensorRoleType
    :param running_speed_harmonic:
    :type running_speed_harmonic: float
    """

    _attribute_map = {
        'running_speed_min': {'key': 'RunningSpeedMin', 'type': 'float'},
        'running_speed_max': {'key': 'RunningSpeedMax', 'type': 'float'},
        'running_speed_type': {'key': 'RunningSpeedType', 'type': 'str'},
        'running_speed_reference_monitoring_point_id': {'key': 'RunningSpeedReferenceMonitoringPointId', 'type': 'str'},
        'running_speed_sensor_role_type': {'key': 'RunningSpeedSensorRoleType', 'type': 'str'},
        'running_speed_harmonic': {'key': 'RunningSpeedHarmonic', 'type': 'float'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(AssetRunningSpeedChild, self).__init__(**kwargs)
        self.running_speed_min = kwargs.get('running_speed_min', None)
        self.running_speed_max = kwargs.get('running_speed_max', None)
        self.running_speed_type = kwargs.get('running_speed_type', None)
        self.running_speed_reference_monitoring_point_id = kwargs.get('running_speed_reference_monitoring_point_id', None)
        self.running_speed_sensor_role_type = kwargs.get('running_speed_sensor_role_type', None)
        self.running_speed_harmonic = kwargs.get('running_speed_harmonic', None)


class AssetSizeChild(msrest.serialization.Model):
    """AssetSizeChild.

    All required parameters must be populated in order to send to Azure.

    :param size_id: Required.
    :type size_id: int
    :param size_name: Required.
    :type size_name: str
    :param size_code: Required.
    :type size_code: str
    """

    _validation = {
        'size_id': {'required': True},
        'size_name': {'required': True},
        'size_code': {'required': True},
    }

    _attribute_map = {
        'size_id': {'key': 'SizeId', 'type': 'int'},
        'size_name': {'key': 'SizeName', 'type': 'str'},
        'size_code': {'key': 'SizeCode', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(AssetSizeChild, self).__init__(**kwargs)
        self.size_id = kwargs['size_id']
        self.size_name = kwargs['size_name']
        self.size_code = kwargs['size_code']


class AssetsStatusCountChild(msrest.serialization.Model):
    """AssetsStatusCountChild.

    :param normal:
    :type normal: int
    :param warning:
    :type warning: int
    :param alarm:
    :type alarm: int
    """

    _attribute_map = {
        'normal': {'key': 'Normal', 'type': 'int'},
        'warning': {'key': 'Warning', 'type': 'int'},
        'alarm': {'key': 'Alarm', 'type': 'int'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(AssetsStatusCountChild, self).__init__(**kwargs)
        self.normal = kwargs.get('normal', None)
        self.warning = kwargs.get('warning', None)
        self.alarm = kwargs.get('alarm', None)


class AssetsStatusPercentageChild(msrest.serialization.Model):
    """AssetsStatusPercentageChild.

    :param normal:
    :type normal: int
    :param warning:
    :type warning: int
    :param alarm:
    :type alarm: int
    """

    _attribute_map = {
        'normal': {'key': 'Normal', 'type': 'int'},
        'warning': {'key': 'Warning', 'type': 'int'},
        'alarm': {'key': 'Alarm', 'type': 'int'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(AssetsStatusPercentageChild, self).__init__(**kwargs)
        self.normal = kwargs.get('normal', None)
        self.warning = kwargs.get('warning', None)
        self.alarm = kwargs.get('alarm', None)


class AssetTypeChild(msrest.serialization.Model):
    """AssetTypeChild.

    :param type_id:
    :type type_id: int
    :param type_name:
    :type type_name: str
    :param type_code:
    :type type_code: str
    """

    _attribute_map = {
        'type_id': {'key': 'TypeId', 'type': 'int'},
        'type_name': {'key': 'TypeName', 'type': 'str'},
        'type_code': {'key': 'TypeCode', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(AssetTypeChild, self).__init__(**kwargs)
        self.type_id = kwargs.get('type_id', None)
        self.type_name = kwargs.get('type_name', None)
        self.type_code = kwargs.get('type_code', None)


class AssetTypeResponse(msrest.serialization.Model):
    """AssetTypeResponse.

    All required parameters must be populated in order to send to Azure.

    :param id: Required.
    :type id: int
    :param name: Required.
    :type name: str
    :param code: Required.
    :type code: str
    :param categories: Required.
    :type categories: list[~smartdiagnostics_sdk.models.AssetCategoryWithSizeChild]
    """

    _validation = {
        'id': {'required': True},
        'name': {'required': True},
        'code': {'required': True},
        'categories': {'required': True},
    }

    _attribute_map = {
        'id': {'key': 'Id', 'type': 'int'},
        'name': {'key': 'Name', 'type': 'str'},
        'code': {'key': 'Code', 'type': 'str'},
        'categories': {'key': 'Categories', 'type': '[AssetCategoryWithSizeChild]'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(AssetTypeResponse, self).__init__(**kwargs)
        self.id = kwargs['id']
        self.name = kwargs['name']
        self.code = kwargs['code']
        self.categories = kwargs['categories']


class AssetUpdateRequest(msrest.serialization.Model):
    """AssetUpdateRequest.

    All required parameters must be populated in order to send to Azure.

    :param is_paused: Required.
    :type is_paused: bool
    :param running_speed_min:
    :type running_speed_min: float
    :param running_speed_max:
    :type running_speed_max: float
    :param running_speed_type:  Possible values include: "Invalid", "Fixed", "Ranged", "AutoTrack".
    :type running_speed_type: str or
     ~smartdiagnostics_sdk.models.AssetUpdateRequestRunningSpeedType
    :param running_speed_reference_monitoring_point_id:
    :type running_speed_reference_monitoring_point_id: str
    :param running_speed_sensor_role_type:  Possible values include: "Invalid", "CurrentPhaseA",
     "PeakCurrentPhaseA", "CurrentPhaseB", "PeakCurrentPhaseB", "CurrentPhaseC",
     "PeakCurrentPhaseC", "DifferentialPressure", "Flow", "Humidity", "NodeTemperature",
     "NodeVoltage", "PeakVibration", "Pressure", "RmsVibration", "SignalStrength",
     "StandardAirVelocity", "SupplyVoltage", "Temperature", "TotalCurrent", "VibrationXAxis",
     "VibrationYAxis", "Voltage", "Current", "AtoDChannel1", "AtoDChannel2", "AtoDChannel3",
     "AtoDChannel4", "AtoDChannel5", "AtoDChannel6", "OilTemperature", "OilHumidity", "X", "Y", "Z",
     "Custom", "WirelessEfficiency", "PacketSuccessRate", "NodeHumidity", "BurstSuccessRate".
    :type running_speed_sensor_role_type: str or
     ~smartdiagnostics_sdk.models.AssetUpdateRequestRunningSpeedSensorRoleType
    :param name: Required.
    :type name: str
    :param abbreviation:
    :type abbreviation: str
    :param supplier:
    :type supplier: str
    :param manufacturer:
    :type manufacturer: str
    :param model_name:
    :type model_name: str
    :param location_notes:
    :type location_notes: str
    :param notes:
    :type notes: str
    :param generic_input:
    :type generic_input: str
    :param is_operator_view: Required.
    :type is_operator_view: bool
    :param type_id:
    :type type_id: int
    :param category_id:
    :type category_id: int
    :param size_id:
    :type size_id: int
    :param criticality_id:
    :type criticality_id: int
    :param asset_cost:
    :type asset_cost: float
    :param date_installed:
    :type date_installed: ~datetime.datetime
    :param annual_run_time:
    :type annual_run_time: float
    :param lost_production_cost:
    :type lost_production_cost: float
    :param overhaul_cost:
    :type overhaul_cost: float
    :param power_consumption:
    :type power_consumption: float
    :param life_expectancy:
    :type life_expectancy: float
    :param unscheduled_downtime:
    :type unscheduled_downtime: float
    :param running_speed_harmonic:
    :type running_speed_harmonic: float
    """

    _validation = {
        'is_paused': {'required': True},
        'name': {'required': True, 'max_length': 100, 'min_length': 0},
        'abbreviation': {'max_length': 5, 'min_length': 0},
        'supplier': {'max_length': 128, 'min_length': 0},
        'manufacturer': {'max_length': 128, 'min_length': 0},
        'model_name': {'max_length': 128, 'min_length': 0},
        'location_notes': {'max_length': 256, 'min_length': 0},
        'notes': {'max_length': 2000, 'min_length': 0},
        'generic_input': {'max_length': 2000, 'min_length': 0},
        'is_operator_view': {'required': True},
    }

    _attribute_map = {
        'is_paused': {'key': 'IsPaused', 'type': 'bool'},
        'running_speed_min': {'key': 'RunningSpeedMin', 'type': 'float'},
        'running_speed_max': {'key': 'RunningSpeedMax', 'type': 'float'},
        'running_speed_type': {'key': 'RunningSpeedType', 'type': 'str'},
        'running_speed_reference_monitoring_point_id': {'key': 'RunningSpeedReferenceMonitoringPointId', 'type': 'str'},
        'running_speed_sensor_role_type': {'key': 'RunningSpeedSensorRoleType', 'type': 'str'},
        'name': {'key': 'Name', 'type': 'str'},
        'abbreviation': {'key': 'Abbreviation', 'type': 'str'},
        'supplier': {'key': 'Supplier', 'type': 'str'},
        'manufacturer': {'key': 'Manufacturer', 'type': 'str'},
        'model_name': {'key': 'ModelName', 'type': 'str'},
        'location_notes': {'key': 'LocationNotes', 'type': 'str'},
        'notes': {'key': 'Notes', 'type': 'str'},
        'generic_input': {'key': 'GenericInput', 'type': 'str'},
        'is_operator_view': {'key': 'IsOperatorView', 'type': 'bool'},
        'type_id': {'key': 'TypeId', 'type': 'int'},
        'category_id': {'key': 'CategoryId', 'type': 'int'},
        'size_id': {'key': 'SizeId', 'type': 'int'},
        'criticality_id': {'key': 'CriticalityId', 'type': 'int'},
        'asset_cost': {'key': 'AssetCost', 'type': 'float'},
        'date_installed': {'key': 'DateInstalled', 'type': 'iso-8601'},
        'annual_run_time': {'key': 'AnnualRunTime', 'type': 'float'},
        'lost_production_cost': {'key': 'LostProductionCost', 'type': 'float'},
        'overhaul_cost': {'key': 'OverhaulCost', 'type': 'float'},
        'power_consumption': {'key': 'PowerConsumption', 'type': 'float'},
        'life_expectancy': {'key': 'LifeExpectancy', 'type': 'float'},
        'unscheduled_downtime': {'key': 'UnscheduledDowntime', 'type': 'float'},
        'running_speed_harmonic': {'key': 'RunningSpeedHarmonic', 'type': 'float'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(AssetUpdateRequest, self).__init__(**kwargs)
        self.is_paused = kwargs['is_paused']
        self.running_speed_min = kwargs.get('running_speed_min', None)
        self.running_speed_max = kwargs.get('running_speed_max', None)
        self.running_speed_type = kwargs.get('running_speed_type', None)
        self.running_speed_reference_monitoring_point_id = kwargs.get('running_speed_reference_monitoring_point_id', None)
        self.running_speed_sensor_role_type = kwargs.get('running_speed_sensor_role_type', None)
        self.name = kwargs['name']
        self.abbreviation = kwargs.get('abbreviation', None)
        self.supplier = kwargs.get('supplier', None)
        self.manufacturer = kwargs.get('manufacturer', None)
        self.model_name = kwargs.get('model_name', None)
        self.location_notes = kwargs.get('location_notes', None)
        self.notes = kwargs.get('notes', None)
        self.generic_input = kwargs.get('generic_input', None)
        self.is_operator_view = kwargs['is_operator_view']
        self.type_id = kwargs.get('type_id', None)
        self.category_id = kwargs.get('category_id', None)
        self.size_id = kwargs.get('size_id', None)
        self.criticality_id = kwargs.get('criticality_id', None)
        self.asset_cost = kwargs.get('asset_cost', None)
        self.date_installed = kwargs.get('date_installed', None)
        self.annual_run_time = kwargs.get('annual_run_time', None)
        self.lost_production_cost = kwargs.get('lost_production_cost', None)
        self.overhaul_cost = kwargs.get('overhaul_cost', None)
        self.power_consumption = kwargs.get('power_consumption', None)
        self.life_expectancy = kwargs.get('life_expectancy', None)
        self.unscheduled_downtime = kwargs.get('unscheduled_downtime', None)
        self.running_speed_harmonic = kwargs.get('running_speed_harmonic', None)


class AttachmentModelV3(msrest.serialization.Model):
    """AttachmentModelV3.

    All required parameters must be populated in order to send to Azure.

    :param type:  Possible values include: "Corporation", "Account", "Group", "Other", "Indicator".
    :type type: str or ~smartdiagnostics_sdk.models.AttachmentModelV3Type
    :param id: Required.
    :type id: str
    """

    _validation = {
        'id': {'required': True},
    }

    _attribute_map = {
        'type': {'key': 'Type', 'type': 'str'},
        'id': {'key': 'Id', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(AttachmentModelV3, self).__init__(**kwargs)
        self.type = kwargs.get('type', None)
        self.id = kwargs['id']


class BandDefinitionChild(msrest.serialization.Model):
    """BandDefinitionChild.

    :param high_band_frequency:
    :type high_band_frequency: float
    :param low_band_frequency:
    :type low_band_frequency: float
    """

    _attribute_map = {
        'high_band_frequency': {'key': 'HighBandFrequency', 'type': 'float'},
        'low_band_frequency': {'key': 'LowBandFrequency', 'type': 'float'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(BandDefinitionChild, self).__init__(**kwargs)
        self.high_band_frequency = kwargs.get('high_band_frequency', None)
        self.low_band_frequency = kwargs.get('low_band_frequency', None)


class BaseStationCreateRequest(msrest.serialization.Model):
    """BaseStationCreateRequest.

    All required parameters must be populated in order to send to Azure.

    :param serial_number: Required.
    :type serial_number: str
    :param nickname:
    :type nickname: str
    :param location_id: Required.
    :type location_id: str
    :param release_ring_id:
    :type release_ring_id: str
    """

    _validation = {
        'serial_number': {'required': True, 'max_length': 50, 'min_length': 0},
        'nickname': {'max_length': 50, 'min_length': 0},
        'location_id': {'required': True},
    }

    _attribute_map = {
        'serial_number': {'key': 'SerialNumber', 'type': 'str'},
        'nickname': {'key': 'Nickname', 'type': 'str'},
        'location_id': {'key': 'LocationId', 'type': 'str'},
        'release_ring_id': {'key': 'ReleaseRingId', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(BaseStationCreateRequest, self).__init__(**kwargs)
        self.serial_number = kwargs['serial_number']
        self.nickname = kwargs.get('nickname', None)
        self.location_id = kwargs['location_id']
        self.release_ring_id = kwargs.get('release_ring_id', None)


class BaseStationResponse(msrest.serialization.Model):
    """BaseStationResponse.

    All required parameters must be populated in order to send to Azure.

    :param id: Required.
    :type id: long
    :param serial_number: Required.
    :type serial_number: str
    :param nickname:
    :type nickname: str
    :param location:
    :type location: ~smartdiagnostics_sdk.models.LocationChild
    :param corporation:
    :type corporation: ~smartdiagnostics_sdk.models.CorporationChild
    :param last_status_update:
    :type last_status_update: ~datetime.datetime
    :param push_to_stage:
    :type push_to_stage: bool
    :param release_ring:
    :type release_ring: ~smartdiagnostics_sdk.models.ReleaseRingChild
    :param targeted_software_release:
    :type targeted_software_release: ~smartdiagnostics_sdk.models.TargetedSoftwareReleaseChild
    :param current_software_release:
    :type current_software_release: ~smartdiagnostics_sdk.models.CurrentSoftwareReleaseChild
    :param hardware_revision:
    :type hardware_revision: ~smartdiagnostics_sdk.models.HardwareRevisionChild
    :param receiver:
    :type receiver: ~smartdiagnostics_sdk.models.ReceiverChild
    :param last_data_update:
    :type last_data_update: ~datetime.datetime
    :param is_online:
    :type is_online: bool
    """

    _validation = {
        'id': {'required': True},
        'serial_number': {'required': True},
    }

    _attribute_map = {
        'id': {'key': 'Id', 'type': 'long'},
        'serial_number': {'key': 'SerialNumber', 'type': 'str'},
        'nickname': {'key': 'Nickname', 'type': 'str'},
        'location': {'key': 'Location', 'type': 'LocationChild'},
        'corporation': {'key': 'Corporation', 'type': 'CorporationChild'},
        'last_status_update': {'key': 'LastStatusUpdate', 'type': 'iso-8601'},
        'push_to_stage': {'key': 'PushToStage', 'type': 'bool'},
        'release_ring': {'key': 'ReleaseRing', 'type': 'ReleaseRingChild'},
        'targeted_software_release': {'key': 'TargetedSoftwareRelease', 'type': 'TargetedSoftwareReleaseChild'},
        'current_software_release': {'key': 'CurrentSoftwareRelease', 'type': 'CurrentSoftwareReleaseChild'},
        'hardware_revision': {'key': 'HardwareRevision', 'type': 'HardwareRevisionChild'},
        'receiver': {'key': 'Receiver', 'type': 'ReceiverChild'},
        'last_data_update': {'key': 'LastDataUpdate', 'type': 'iso-8601'},
        'is_online': {'key': 'IsOnline', 'type': 'bool'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(BaseStationResponse, self).__init__(**kwargs)
        self.id = kwargs['id']
        self.serial_number = kwargs['serial_number']
        self.nickname = kwargs.get('nickname', None)
        self.location = kwargs.get('location', None)
        self.corporation = kwargs.get('corporation', None)
        self.last_status_update = kwargs.get('last_status_update', None)
        self.push_to_stage = kwargs.get('push_to_stage', None)
        self.release_ring = kwargs.get('release_ring', None)
        self.targeted_software_release = kwargs.get('targeted_software_release', None)
        self.current_software_release = kwargs.get('current_software_release', None)
        self.hardware_revision = kwargs.get('hardware_revision', None)
        self.receiver = kwargs.get('receiver', None)
        self.last_data_update = kwargs.get('last_data_update', None)
        self.is_online = kwargs.get('is_online', None)


class BaseStationUpdateRequest(msrest.serialization.Model):
    """BaseStationUpdateRequest.

    :param nickname:
    :type nickname: str
    :param location_id:
    :type location_id: str
    :param release_ring_id:
    :type release_ring_id: str
    :param push_to_stage:
    :type push_to_stage: bool
    """

    _validation = {
        'nickname': {'max_length': 50, 'min_length': 0},
    }

    _attribute_map = {
        'nickname': {'key': 'Nickname', 'type': 'str'},
        'location_id': {'key': 'LocationId', 'type': 'str'},
        'release_ring_id': {'key': 'ReleaseRingId', 'type': 'str'},
        'push_to_stage': {'key': 'PushToStage', 'type': 'bool'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(BaseStationUpdateRequest, self).__init__(**kwargs)
        self.nickname = kwargs.get('nickname', None)
        self.location_id = kwargs.get('location_id', None)
        self.release_ring_id = kwargs.get('release_ring_id', None)
        self.push_to_stage = kwargs.get('push_to_stage', None)


class BearingChild(msrest.serialization.Model):
    """BearingChild.

    :param bearing_id:
    :type bearing_id: str
    :param bearing_name:
    :type bearing_name: str
    :param bearing_manufacturer:
    :type bearing_manufacturer: str
    :param bearing_bpfi:
    :type bearing_bpfi: float
    """

    _attribute_map = {
        'bearing_id': {'key': 'BearingId', 'type': 'str'},
        'bearing_name': {'key': 'BearingName', 'type': 'str'},
        'bearing_manufacturer': {'key': 'BearingManufacturer', 'type': 'str'},
        'bearing_bpfi': {'key': 'BearingBpfi', 'type': 'float'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(BearingChild, self).__init__(**kwargs)
        self.bearing_id = kwargs.get('bearing_id', None)
        self.bearing_name = kwargs.get('bearing_name', None)
        self.bearing_manufacturer = kwargs.get('bearing_manufacturer', None)
        self.bearing_bpfi = kwargs.get('bearing_bpfi', None)


class BearingResponse(msrest.serialization.Model):
    """BearingResponse.

    All required parameters must be populated in order to send to Azure.

    :param id: Required.
    :type id: str
    :param name:
    :type name: str
    :param manufacturer:
    :type manufacturer: str
    :param roller_count:
    :type roller_count: long
    :param ftf:
    :type ftf: float
    :param bsf:
    :type bsf: float
    :param bpfo:
    :type bpfo: float
    :param bpfi:
    :type bpfi: float
    """

    _validation = {
        'id': {'required': True},
    }

    _attribute_map = {
        'id': {'key': 'Id', 'type': 'str'},
        'name': {'key': 'Name', 'type': 'str'},
        'manufacturer': {'key': 'Manufacturer', 'type': 'str'},
        'roller_count': {'key': 'RollerCount', 'type': 'long'},
        'ftf': {'key': 'Ftf', 'type': 'float'},
        'bsf': {'key': 'Bsf', 'type': 'float'},
        'bpfo': {'key': 'Bpfo', 'type': 'float'},
        'bpfi': {'key': 'Bpfi', 'type': 'float'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(BearingResponse, self).__init__(**kwargs)
        self.id = kwargs['id']
        self.name = kwargs.get('name', None)
        self.manufacturer = kwargs.get('manufacturer', None)
        self.roller_count = kwargs.get('roller_count', None)
        self.ftf = kwargs.get('ftf', None)
        self.bsf = kwargs.get('bsf', None)
        self.bpfo = kwargs.get('bpfo', None)
        self.bpfi = kwargs.get('bpfi', None)


class CorporationChild(msrest.serialization.Model):
    """CorporationChild.

    All required parameters must be populated in order to send to Azure.

    :param corporation_id: Required.
    :type corporation_id: str
    :param corporation_name: Required.
    :type corporation_name: str
    :param corporation_abbreviation:
    :type corporation_abbreviation: str
    """

    _validation = {
        'corporation_id': {'required': True},
        'corporation_name': {'required': True},
    }

    _attribute_map = {
        'corporation_id': {'key': 'CorporationId', 'type': 'str'},
        'corporation_name': {'key': 'CorporationName', 'type': 'str'},
        'corporation_abbreviation': {'key': 'CorporationAbbreviation', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(CorporationChild, self).__init__(**kwargs)
        self.corporation_id = kwargs['corporation_id']
        self.corporation_name = kwargs['corporation_name']
        self.corporation_abbreviation = kwargs.get('corporation_abbreviation', None)


class CorporationCreateRequest(msrest.serialization.Model):
    """CorporationCreateRequest.

    All required parameters must be populated in order to send to Azure.

    :param name: Required.
    :type name: str
    :param abbreviation:
    :type abbreviation: str
    :param industry_id:
    :type industry_id: int
    """

    _validation = {
        'name': {'required': True, 'max_length': 50, 'min_length': 0},
        'abbreviation': {'max_length': 5, 'min_length': 0},
    }

    _attribute_map = {
        'name': {'key': 'Name', 'type': 'str'},
        'abbreviation': {'key': 'Abbreviation', 'type': 'str'},
        'industry_id': {'key': 'IndustryId', 'type': 'int'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(CorporationCreateRequest, self).__init__(**kwargs)
        self.name = kwargs['name']
        self.abbreviation = kwargs.get('abbreviation', None)
        self.industry_id = kwargs.get('industry_id', None)


class CorporationIndustryChild(msrest.serialization.Model):
    """CorporationIndustryChild.

    All required parameters must be populated in order to send to Azure.

    :param industry_id: Required.
    :type industry_id: int
    :param industry_name: Required.
    :type industry_name: str
    """

    _validation = {
        'industry_id': {'required': True},
        'industry_name': {'required': True},
    }

    _attribute_map = {
        'industry_id': {'key': 'IndustryId', 'type': 'int'},
        'industry_name': {'key': 'IndustryName', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(CorporationIndustryChild, self).__init__(**kwargs)
        self.industry_id = kwargs['industry_id']
        self.industry_name = kwargs['industry_name']


class CorporationResponse(msrest.serialization.Model):
    """CorporationResponse.

    All required parameters must be populated in order to send to Azure.

    :param id: Required.
    :type id: str
    :param name: Required.
    :type name: str
    :param abbreviation:
    :type abbreviation: str
    :param icon_url:
    :type icon_url: str
    :param active:
    :type active: bool
    :param created:
    :type created: ~datetime.datetime
    :param industry:
    :type industry: ~smartdiagnostics_sdk.models.CorporationIndustryChild
    :param locations:
    :type locations: list[~smartdiagnostics_sdk.models.LocationChild]
    """

    _validation = {
        'id': {'required': True},
        'name': {'required': True},
    }

    _attribute_map = {
        'id': {'key': 'Id', 'type': 'str'},
        'name': {'key': 'Name', 'type': 'str'},
        'abbreviation': {'key': 'Abbreviation', 'type': 'str'},
        'icon_url': {'key': 'IconUrl', 'type': 'str'},
        'active': {'key': 'Active', 'type': 'bool'},
        'created': {'key': 'Created', 'type': 'iso-8601'},
        'industry': {'key': 'Industry', 'type': 'CorporationIndustryChild'},
        'locations': {'key': 'Locations', 'type': '[LocationChild]'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(CorporationResponse, self).__init__(**kwargs)
        self.id = kwargs['id']
        self.name = kwargs['name']
        self.abbreviation = kwargs.get('abbreviation', None)
        self.icon_url = kwargs.get('icon_url', None)
        self.active = kwargs.get('active', None)
        self.created = kwargs.get('created', None)
        self.industry = kwargs.get('industry', None)
        self.locations = kwargs.get('locations', None)


class CorporationUpdateRequest(msrest.serialization.Model):
    """CorporationUpdateRequest.

    All required parameters must be populated in order to send to Azure.

    :param name: Required.
    :type name: str
    :param abbreviation:
    :type abbreviation: str
    :param active: Required.
    :type active: bool
    :param industry_id:
    :type industry_id: int
    """

    _validation = {
        'name': {'required': True, 'max_length': 50, 'min_length': 0},
        'abbreviation': {'max_length': 5, 'min_length': 0},
        'active': {'required': True},
    }

    _attribute_map = {
        'name': {'key': 'Name', 'type': 'str'},
        'abbreviation': {'key': 'Abbreviation', 'type': 'str'},
        'active': {'key': 'Active', 'type': 'bool'},
        'industry_id': {'key': 'IndustryId', 'type': 'int'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(CorporationUpdateRequest, self).__init__(**kwargs)
        self.name = kwargs['name']
        self.abbreviation = kwargs.get('abbreviation', None)
        self.active = kwargs['active']
        self.industry_id = kwargs.get('industry_id', None)


class CurrentSoftwareReleaseChild(msrest.serialization.Model):
    """CurrentSoftwareReleaseChild.

    :param current_software_release_id:
    :type current_software_release_id: int
    :param current_software_release_name:
    :type current_software_release_name: str
    """

    _attribute_map = {
        'current_software_release_id': {'key': 'CurrentSoftwareReleaseId', 'type': 'int'},
        'current_software_release_name': {'key': 'CurrentSoftwareReleaseName', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(CurrentSoftwareReleaseChild, self).__init__(**kwargs)
        self.current_software_release_id = kwargs.get('current_software_release_id', None)
        self.current_software_release_name = kwargs.get('current_software_release_name', None)


class CurrentUserResponse(msrest.serialization.Model):
    """CurrentUserResponse.

    :param id:
    :type id: str
    :param email:
    :type email: str
    :param first_name:
    :type first_name: str
    :param last_name:
    :type last_name: str
    :param phone_number:
    :type phone_number: str
    :param application_role:  Possible values include: "Invalid", "SaasAdmin", "AccountAdmin",
     "ApplicationUser", "Technician", "User", "SystemProcess", "Sentry", "Sales",
     "CorporationAdmin", "CorporationUser", "CorporationNone".
    :type application_role: str or ~smartdiagnostics_sdk.models.CurrentUserResponseApplicationRole
    :param corporations:
    :type corporations: list[~smartdiagnostics_sdk.models.UserCorporationChild]
    :param locations:
    :type locations: list[~smartdiagnostics_sdk.models.UserLocationChild]
    :param profile:
    :type profile: ~smartdiagnostics_sdk.models.ProfileChild
    """

    _attribute_map = {
        'id': {'key': 'Id', 'type': 'str'},
        'email': {'key': 'Email', 'type': 'str'},
        'first_name': {'key': 'FirstName', 'type': 'str'},
        'last_name': {'key': 'LastName', 'type': 'str'},
        'phone_number': {'key': 'PhoneNumber', 'type': 'str'},
        'application_role': {'key': 'ApplicationRole', 'type': 'str'},
        'corporations': {'key': 'Corporations', 'type': '[UserCorporationChild]'},
        'locations': {'key': 'Locations', 'type': '[UserLocationChild]'},
        'profile': {'key': 'Profile', 'type': 'ProfileChild'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(CurrentUserResponse, self).__init__(**kwargs)
        self.id = kwargs.get('id', None)
        self.email = kwargs.get('email', None)
        self.first_name = kwargs.get('first_name', None)
        self.last_name = kwargs.get('last_name', None)
        self.phone_number = kwargs.get('phone_number', None)
        self.application_role = kwargs.get('application_role', None)
        self.corporations = kwargs.get('corporations', None)
        self.locations = kwargs.get('locations', None)
        self.profile = kwargs.get('profile', None)


class CustomMarkerChild(msrest.serialization.Model):
    """CustomMarkerChild.

    All required parameters must be populated in order to send to Azure.

    :param custom_marker_id: Required.
    :type custom_marker_id: str
    :param custom_marker_name:
    :type custom_marker_name: str
    :param custom_marker_show_harmonics: Required.
    :type custom_marker_show_harmonics: bool
    :param custom_marker_show_side_bands: Required.
    :type custom_marker_show_side_bands: bool
    :param custom_marker_show_peaks: Required.
    :type custom_marker_show_peaks: bool
    """

    _validation = {
        'custom_marker_id': {'required': True},
        'custom_marker_name': {'max_length': 5, 'min_length': 0},
        'custom_marker_show_harmonics': {'required': True},
        'custom_marker_show_side_bands': {'required': True},
        'custom_marker_show_peaks': {'required': True},
    }

    _attribute_map = {
        'custom_marker_id': {'key': 'CustomMarkerId', 'type': 'str'},
        'custom_marker_name': {'key': 'CustomMarkerName', 'type': 'str'},
        'custom_marker_show_harmonics': {'key': 'CustomMarkerShowHarmonics', 'type': 'bool'},
        'custom_marker_show_side_bands': {'key': 'CustomMarkerShowSideBands', 'type': 'bool'},
        'custom_marker_show_peaks': {'key': 'CustomMarkerShowPeaks', 'type': 'bool'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(CustomMarkerChild, self).__init__(**kwargs)
        self.custom_marker_id = kwargs['custom_marker_id']
        self.custom_marker_name = kwargs.get('custom_marker_name', None)
        self.custom_marker_show_harmonics = kwargs['custom_marker_show_harmonics']
        self.custom_marker_show_side_bands = kwargs['custom_marker_show_side_bands']
        self.custom_marker_show_peaks = kwargs['custom_marker_show_peaks']


class DashboardCreateRequest(msrest.serialization.Model):
    """DashboardCreateRequest.

    All required parameters must be populated in order to send to Azure.

    :param name:
    :type name: str
    :param description:
    :type description: str
    :param template_id: Required.
    :type template_id: int
    :param corporation_id: Required.
    :type corporation_id: str
    :param location_id:
    :type location_id: str
    :param time_range:  Possible values include: "EightHours", "OneDay", "OneWeek", "OneMonth",
     "OneYear".
    :type time_range: str or ~smartdiagnostics_sdk.models.DashboardCreateRequestTimeRange
    :param power_bi_report_url:
    :type power_bi_report_url: str
    """

    _validation = {
        'name': {'max_length': 128, 'min_length': 0},
        'description': {'max_length': 1000, 'min_length': 0},
        'template_id': {'required': True},
        'corporation_id': {'required': True},
    }

    _attribute_map = {
        'name': {'key': 'Name', 'type': 'str'},
        'description': {'key': 'Description', 'type': 'str'},
        'template_id': {'key': 'TemplateId', 'type': 'int'},
        'corporation_id': {'key': 'CorporationId', 'type': 'str'},
        'location_id': {'key': 'LocationId', 'type': 'str'},
        'time_range': {'key': 'TimeRange', 'type': 'str'},
        'power_bi_report_url': {'key': 'PowerBiReportUrl', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(DashboardCreateRequest, self).__init__(**kwargs)
        self.name = kwargs.get('name', None)
        self.description = kwargs.get('description', None)
        self.template_id = kwargs['template_id']
        self.corporation_id = kwargs['corporation_id']
        self.location_id = kwargs.get('location_id', None)
        self.time_range = kwargs.get('time_range', None)
        self.power_bi_report_url = kwargs.get('power_bi_report_url', None)


class DashboardPermissionsUpdateRequest(msrest.serialization.Model):
    """DashboardPermissionsUpdateRequest.

    All required parameters must be populated in order to send to Azure.

    :param is_sentry_managed: Required.
    :type is_sentry_managed: bool
    :param is_visible_to_customers: Required.
    :type is_visible_to_customers: bool
    """

    _validation = {
        'is_sentry_managed': {'required': True},
        'is_visible_to_customers': {'required': True},
    }

    _attribute_map = {
        'is_sentry_managed': {'key': 'IsSentryManaged', 'type': 'bool'},
        'is_visible_to_customers': {'key': 'IsVisibleToCustomers', 'type': 'bool'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(DashboardPermissionsUpdateRequest, self).__init__(**kwargs)
        self.is_sentry_managed = kwargs['is_sentry_managed']
        self.is_visible_to_customers = kwargs['is_visible_to_customers']


class DashboardResponse(msrest.serialization.Model):
    """DashboardResponse.

    All required parameters must be populated in order to send to Azure.

    :param id: Required.
    :type id: str
    :param name: Required.
    :type name: str
    :param description:
    :type description: str
    :param is_sentry_managed: Required.
    :type is_sentry_managed: bool
    :param is_visible_to_customers: Required.
    :type is_visible_to_customers: bool
    :param created: Required.
    :type created: ~datetime.datetime
    :param updated: Required.
    :type updated: ~datetime.datetime
    :param created_by:
    :type created_by: ~smartdiagnostics_sdk.models.UserChild
    :param updated_by:
    :type updated_by: ~smartdiagnostics_sdk.models.UserChild
    :param dashboard_type:
    :type dashboard_type: ~smartdiagnostics_sdk.models.DashboardTypeChild
    :param corporation:
    :type corporation: ~smartdiagnostics_sdk.models.PrimaryCorporationChild
    :param location:
    :type location: ~smartdiagnostics_sdk.models.LocationChild
    :param dashboard_widgets:
    :type dashboard_widgets: list[~smartdiagnostics_sdk.models.DashboardWidgetChild]
    :param power_bi_report:
    :type power_bi_report: ~smartdiagnostics_sdk.models.PowerBiReportChild
    """

    _validation = {
        'id': {'required': True},
        'name': {'required': True},
        'is_sentry_managed': {'required': True},
        'is_visible_to_customers': {'required': True},
        'created': {'required': True},
        'updated': {'required': True},
    }

    _attribute_map = {
        'id': {'key': 'Id', 'type': 'str'},
        'name': {'key': 'Name', 'type': 'str'},
        'description': {'key': 'Description', 'type': 'str'},
        'is_sentry_managed': {'key': 'IsSentryManaged', 'type': 'bool'},
        'is_visible_to_customers': {'key': 'IsVisibleToCustomers', 'type': 'bool'},
        'created': {'key': 'Created', 'type': 'iso-8601'},
        'updated': {'key': 'Updated', 'type': 'iso-8601'},
        'created_by': {'key': 'CreatedBy', 'type': 'UserChild'},
        'updated_by': {'key': 'UpdatedBy', 'type': 'UserChild'},
        'dashboard_type': {'key': 'DashboardType', 'type': 'DashboardTypeChild'},
        'corporation': {'key': 'Corporation', 'type': 'PrimaryCorporationChild'},
        'location': {'key': 'Location', 'type': 'LocationChild'},
        'dashboard_widgets': {'key': 'DashboardWidgets', 'type': '[DashboardWidgetChild]'},
        'power_bi_report': {'key': 'PowerBiReport', 'type': 'PowerBiReportChild'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(DashboardResponse, self).__init__(**kwargs)
        self.id = kwargs['id']
        self.name = kwargs['name']
        self.description = kwargs.get('description', None)
        self.is_sentry_managed = kwargs['is_sentry_managed']
        self.is_visible_to_customers = kwargs['is_visible_to_customers']
        self.created = kwargs['created']
        self.updated = kwargs['updated']
        self.created_by = kwargs.get('created_by', None)
        self.updated_by = kwargs.get('updated_by', None)
        self.dashboard_type = kwargs.get('dashboard_type', None)
        self.corporation = kwargs.get('corporation', None)
        self.location = kwargs.get('location', None)
        self.dashboard_widgets = kwargs.get('dashboard_widgets', None)
        self.power_bi_report = kwargs.get('power_bi_report', None)


class DashboardTemplateResponse(msrest.serialization.Model):
    """DashboardTemplateResponse.

    All required parameters must be populated in order to send to Azure.

    :param id: Required.
    :type id: int
    :param name: Required.
    :type name: str
    :param description:
    :type description: str
    :param dashboard_type_id:
    :type dashboard_type_id: int
    :param widget_templates:
    :type widget_templates: list[~smartdiagnostics_sdk.models.WidgetTemplateChild]
    """

    _validation = {
        'id': {'required': True},
        'name': {'required': True},
    }

    _attribute_map = {
        'id': {'key': 'Id', 'type': 'int'},
        'name': {'key': 'Name', 'type': 'str'},
        'description': {'key': 'Description', 'type': 'str'},
        'dashboard_type_id': {'key': 'DashboardTypeId', 'type': 'int'},
        'widget_templates': {'key': 'WidgetTemplates', 'type': '[WidgetTemplateChild]'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(DashboardTemplateResponse, self).__init__(**kwargs)
        self.id = kwargs['id']
        self.name = kwargs['name']
        self.description = kwargs.get('description', None)
        self.dashboard_type_id = kwargs.get('dashboard_type_id', None)
        self.widget_templates = kwargs.get('widget_templates', None)


class DashboardTypeChild(msrest.serialization.Model):
    """DashboardTypeChild.

    All required parameters must be populated in order to send to Azure.

    :param dashboard_type_id: Required.
    :type dashboard_type_id: int
    :param dashboard_type_name: Required.
    :type dashboard_type_name: str
    """

    _validation = {
        'dashboard_type_id': {'required': True},
        'dashboard_type_name': {'required': True},
    }

    _attribute_map = {
        'dashboard_type_id': {'key': 'DashboardTypeId', 'type': 'int'},
        'dashboard_type_name': {'key': 'DashboardTypeName', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(DashboardTypeChild, self).__init__(**kwargs)
        self.dashboard_type_id = kwargs['dashboard_type_id']
        self.dashboard_type_name = kwargs['dashboard_type_name']


class DashboardUpdateRequest(msrest.serialization.Model):
    """DashboardUpdateRequest.

    All required parameters must be populated in order to send to Azure.

    :param name: Required.
    :type name: str
    :param description:
    :type description: str
    :param time_range:  Possible values include: "EightHours", "OneDay", "OneWeek", "OneMonth",
     "OneYear".
    :type time_range: str or ~smartdiagnostics_sdk.models.DashboardUpdateRequestTimeRange
    :param dashboard_widgets:
    :type dashboard_widgets: list[~smartdiagnostics_sdk.models.DashboardWidgetRequestChild]
    """

    _validation = {
        'name': {'required': True, 'max_length': 128, 'min_length': 0},
        'description': {'max_length': 1000, 'min_length': 0},
    }

    _attribute_map = {
        'name': {'key': 'Name', 'type': 'str'},
        'description': {'key': 'Description', 'type': 'str'},
        'time_range': {'key': 'TimeRange', 'type': 'str'},
        'dashboard_widgets': {'key': 'DashboardWidgets', 'type': '[DashboardWidgetRequestChild]'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(DashboardUpdateRequest, self).__init__(**kwargs)
        self.name = kwargs['name']
        self.description = kwargs.get('description', None)
        self.time_range = kwargs.get('time_range', None)
        self.dashboard_widgets = kwargs.get('dashboard_widgets', None)


class DashboardWidgetChild(msrest.serialization.Model):
    """DashboardWidgetChild.

    All required parameters must be populated in order to send to Azure.

    :param dashboard_widget_id: Required.
    :type dashboard_widget_id: str
    :param dashboard_widget_name: Required.
    :type dashboard_widget_name: str
    :param dashboard_widget_refresh_interval:
    :type dashboard_widget_refresh_interval: int
    :param dashboard_widget_layout:
    :type dashboard_widget_layout: ~smartdiagnostics_sdk.models.LayoutChild
    :param widget:
    :type widget: ~smartdiagnostics_sdk.models.WidgetChild
    """

    _validation = {
        'dashboard_widget_id': {'required': True},
        'dashboard_widget_name': {'required': True},
    }

    _attribute_map = {
        'dashboard_widget_id': {'key': 'DashboardWidgetId', 'type': 'str'},
        'dashboard_widget_name': {'key': 'DashboardWidgetName', 'type': 'str'},
        'dashboard_widget_refresh_interval': {'key': 'DashboardWidgetRefreshInterval', 'type': 'int'},
        'dashboard_widget_layout': {'key': 'DashboardWidgetLayout', 'type': 'LayoutChild'},
        'widget': {'key': 'Widget', 'type': 'WidgetChild'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(DashboardWidgetChild, self).__init__(**kwargs)
        self.dashboard_widget_id = kwargs['dashboard_widget_id']
        self.dashboard_widget_name = kwargs['dashboard_widget_name']
        self.dashboard_widget_refresh_interval = kwargs.get('dashboard_widget_refresh_interval', None)
        self.dashboard_widget_layout = kwargs.get('dashboard_widget_layout', None)
        self.widget = kwargs.get('widget', None)


class DashboardWidgetRequestChild(msrest.serialization.Model):
    """DashboardWidgetRequestChild.

    All required parameters must be populated in order to send to Azure.

    :param dashboard_widget_id: Required.
    :type dashboard_widget_id: str
    :param dashboard_widget_row: Required.
    :type dashboard_widget_row: int
    :param dashboard_widget_column: Required.
    :type dashboard_widget_column: int
    :param dashboard_widget_height: Required.
    :type dashboard_widget_height: int
    :param dashboard_widget_width: Required.
    :type dashboard_widget_width: int
    """

    _validation = {
        'dashboard_widget_id': {'required': True},
        'dashboard_widget_row': {'required': True},
        'dashboard_widget_column': {'required': True},
        'dashboard_widget_height': {'required': True},
        'dashboard_widget_width': {'required': True},
    }

    _attribute_map = {
        'dashboard_widget_id': {'key': 'DashboardWidgetId', 'type': 'str'},
        'dashboard_widget_row': {'key': 'DashboardWidgetRow', 'type': 'int'},
        'dashboard_widget_column': {'key': 'DashboardWidgetColumn', 'type': 'int'},
        'dashboard_widget_height': {'key': 'DashboardWidgetHeight', 'type': 'int'},
        'dashboard_widget_width': {'key': 'DashboardWidgetWidth', 'type': 'int'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(DashboardWidgetRequestChild, self).__init__(**kwargs)
        self.dashboard_widget_id = kwargs['dashboard_widget_id']
        self.dashboard_widget_row = kwargs['dashboard_widget_row']
        self.dashboard_widget_column = kwargs['dashboard_widget_column']
        self.dashboard_widget_height = kwargs['dashboard_widget_height']
        self.dashboard_widget_width = kwargs['dashboard_widget_width']


class DescendantChild(msrest.serialization.Model):
    """DescendantChild.

    :param child_id:
    :type child_id: str
    :param child_name:
    :type child_name: str
    :param child_abbreviation:
    :type child_abbreviation: str
    :param child_type:  Possible values include: "Asset", "MonitoringPoint", "IndicatorGroup",
     "Group", "AnalyticModel".
    :type child_type: str or ~smartdiagnostics_sdk.models.DescendantChildType
    :param child_sort_order:
    :type child_sort_order: int
    :param child_has_children:
    :type child_has_children: bool
    :param child_alarm_severity_level:
    :type child_alarm_severity_level: int
    :param child_is_paused:
    :type child_is_paused: bool
    :param child_is_snoozed:
    :type child_is_snoozed: bool
    """

    _attribute_map = {
        'child_id': {'key': 'ChildId', 'type': 'str'},
        'child_name': {'key': 'ChildName', 'type': 'str'},
        'child_abbreviation': {'key': 'ChildAbbreviation', 'type': 'str'},
        'child_type': {'key': 'ChildType', 'type': 'str'},
        'child_sort_order': {'key': 'ChildSortOrder', 'type': 'int'},
        'child_has_children': {'key': 'ChildHasChildren', 'type': 'bool'},
        'child_alarm_severity_level': {'key': 'ChildAlarmSeverityLevel', 'type': 'int'},
        'child_is_paused': {'key': 'ChildIsPaused', 'type': 'bool'},
        'child_is_snoozed': {'key': 'ChildIsSnoozed', 'type': 'bool'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(DescendantChild, self).__init__(**kwargs)
        self.child_id = kwargs.get('child_id', None)
        self.child_name = kwargs.get('child_name', None)
        self.child_abbreviation = kwargs.get('child_abbreviation', None)
        self.child_type = kwargs.get('child_type', None)
        self.child_sort_order = kwargs.get('child_sort_order', None)
        self.child_has_children = kwargs.get('child_has_children', None)
        self.child_alarm_severity_level = kwargs.get('child_alarm_severity_level', None)
        self.child_is_paused = kwargs.get('child_is_paused', None)
        self.child_is_snoozed = kwargs.get('child_is_snoozed', None)


class EventModelV3(msrest.serialization.Model):
    """EventModelV3.

    All required parameters must be populated in order to send to Azure.

    :param id:
    :type id: str
    :param location_id:
    :type location_id: str
    :param window_id:
    :type window_id: str
    :param date_occurred: Required.
    :type date_occurred: ~datetime.datetime
    :param description:
    :type description: str
    :param reason:
    :type reason: str
    :param content_type: Required.  Possible values include: "Invalid", "OperationalCondition",
     "Fault", "RootCause", "Evidence", "Inspection", "PreventativeMaintenance",
     "CorrectiveMaintenance", "Observation", "Document", "Description", "SamplingFrequencyChange",
     "PendingSamplingFrequencyChange", "AutoInvalidBurstData", "UserInvalidBurstData".
    :type content_type: str or ~smartdiagnostics_sdk.models.EventModelV3ContentType
    :param attachment: Required.
    :type attachment: ~smartdiagnostics_sdk.models.AttachmentModelV3
    :param code_ids:
    :type code_ids: list[str]
    :param tag_details:
    :type tag_details: list[str]
    :param document_url:
    :type document_url: str
    :param document_name:
    :type document_name: str
    :param title:
    :type title: str
    :param evidence_indicator_id:
    :type evidence_indicator_id: str
    :param created:
    :type created: ~datetime.datetime
    :param created_by:
    :type created_by: str
    :param modified:
    :type modified: ~datetime.datetime
    :param modified_by:
    :type modified_by: str
    :param savings:
    :type savings: float
    :param group_name:
    :type group_name: str
    :param group_path:
    :type group_path: str
    :param group_type:  Possible values include: "Invalid", "Group", "Asset", "MonitoringPoint",
     "IndicatorGroup", "AnalyticModel".
    :type group_type: str or ~smartdiagnostics_sdk.models.EventModelV3GroupType
    """

    _validation = {
        'date_occurred': {'required': True},
        'content_type': {'required': True},
        'attachment': {'required': True},
    }

    _attribute_map = {
        'id': {'key': 'Id', 'type': 'str'},
        'location_id': {'key': 'LocationId', 'type': 'str'},
        'window_id': {'key': 'WindowId', 'type': 'str'},
        'date_occurred': {'key': 'DateOccurred', 'type': 'iso-8601'},
        'description': {'key': 'Description', 'type': 'str'},
        'reason': {'key': 'Reason', 'type': 'str'},
        'content_type': {'key': 'ContentType', 'type': 'str'},
        'attachment': {'key': 'Attachment', 'type': 'AttachmentModelV3'},
        'code_ids': {'key': 'CodeIds', 'type': '[str]'},
        'tag_details': {'key': 'TagDetails', 'type': '[str]'},
        'document_url': {'key': 'DocumentUrl', 'type': 'str'},
        'document_name': {'key': 'DocumentName', 'type': 'str'},
        'title': {'key': 'Title', 'type': 'str'},
        'evidence_indicator_id': {'key': 'EvidenceIndicatorId', 'type': 'str'},
        'created': {'key': 'Created', 'type': 'iso-8601'},
        'created_by': {'key': 'CreatedBy', 'type': 'str'},
        'modified': {'key': 'Modified', 'type': 'iso-8601'},
        'modified_by': {'key': 'ModifiedBy', 'type': 'str'},
        'savings': {'key': 'Savings', 'type': 'float'},
        'group_name': {'key': 'GroupName', 'type': 'str'},
        'group_path': {'key': 'GroupPath', 'type': 'str'},
        'group_type': {'key': 'GroupType', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(EventModelV3, self).__init__(**kwargs)
        self.id = kwargs.get('id', None)
        self.location_id = kwargs.get('location_id', None)
        self.window_id = kwargs.get('window_id', None)
        self.date_occurred = kwargs['date_occurred']
        self.description = kwargs.get('description', None)
        self.reason = kwargs.get('reason', None)
        self.content_type = kwargs['content_type']
        self.attachment = kwargs['attachment']
        self.code_ids = kwargs.get('code_ids', None)
        self.tag_details = kwargs.get('tag_details', None)
        self.document_url = kwargs.get('document_url', None)
        self.document_name = kwargs.get('document_name', None)
        self.title = kwargs.get('title', None)
        self.evidence_indicator_id = kwargs.get('evidence_indicator_id', None)
        self.created = kwargs.get('created', None)
        self.created_by = kwargs.get('created_by', None)
        self.modified = kwargs.get('modified', None)
        self.modified_by = kwargs.get('modified_by', None)
        self.savings = kwargs.get('savings', None)
        self.group_name = kwargs.get('group_name', None)
        self.group_path = kwargs.get('group_path', None)
        self.group_type = kwargs.get('group_type', None)


class ExternalNotificationChild(msrest.serialization.Model):
    """ExternalNotificationChild.

    :param external_notification_id:
    :type external_notification_id: str
    :param external_notification_requested_time:
    :type external_notification_requested_time: ~datetime.datetime
    :param external_notification_user:
    :type external_notification_user: ~smartdiagnostics_sdk.models.UserChild
    """

    _attribute_map = {
        'external_notification_id': {'key': 'ExternalNotificationId', 'type': 'str'},
        'external_notification_requested_time': {'key': 'ExternalNotificationRequestedTime', 'type': 'iso-8601'},
        'external_notification_user': {'key': 'ExternalNotificationUser', 'type': 'UserChild'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(ExternalNotificationChild, self).__init__(**kwargs)
        self.external_notification_id = kwargs.get('external_notification_id', None)
        self.external_notification_requested_time = kwargs.get('external_notification_requested_time', None)
        self.external_notification_user = kwargs.get('external_notification_user', None)


class FileResponse(msrest.serialization.Model):
    """FileResponse.

    All required parameters must be populated in order to send to Azure.

    :param type: Required.  Possible values include: "Invalid", "Picture", "Folder".
    :type type: str or ~smartdiagnostics_sdk.models.FileResponseType
    :param display_name:
    :type display_name: str
    :param parent_folder_id: Required.
    :type parent_folder_id: str
    :param description:
    :type description: str
    :param location:
    :type location: ~smartdiagnostics_sdk.models.LocationChild
    :param corporation:
    :type corporation: ~smartdiagnostics_sdk.models.CorporationChild
    :param group_ids: Ids of groups the file belongs to.
    :type group_ids: list[str]
    :param id:
    :type id: str
    :param file_name:
    :type file_name: str
    :param thumbnail_file_name:
    :type thumbnail_file_name: str
    :param creation_date:
    :type creation_date: ~datetime.datetime
    :param update_date:
    :type update_date: ~datetime.datetime
    :param file_count:
    :type file_count: int
    :param folder_count:
    :type folder_count: int
    :param is_root_folder:
    :type is_root_folder: bool
    :param tags: A set of tags.
    :type tags: list[~smartdiagnostics_sdk.models.TagChild]
    """

    _validation = {
        'type': {'required': True},
        'display_name': {'max_length': 223, 'min_length': 0},
        'parent_folder_id': {'required': True},
    }

    _attribute_map = {
        'type': {'key': 'Type', 'type': 'str'},
        'display_name': {'key': 'DisplayName', 'type': 'str'},
        'parent_folder_id': {'key': 'ParentFolderId', 'type': 'str'},
        'description': {'key': 'Description', 'type': 'str'},
        'location': {'key': 'Location', 'type': 'LocationChild'},
        'corporation': {'key': 'Corporation', 'type': 'CorporationChild'},
        'group_ids': {'key': 'GroupIds', 'type': '[str]'},
        'id': {'key': 'Id', 'type': 'str'},
        'file_name': {'key': 'FileName', 'type': 'str'},
        'thumbnail_file_name': {'key': 'ThumbnailFileName', 'type': 'str'},
        'creation_date': {'key': 'CreationDate', 'type': 'iso-8601'},
        'update_date': {'key': 'UpdateDate', 'type': 'iso-8601'},
        'file_count': {'key': 'FileCount', 'type': 'int'},
        'folder_count': {'key': 'FolderCount', 'type': 'int'},
        'is_root_folder': {'key': 'IsRootFolder', 'type': 'bool'},
        'tags': {'key': 'Tags', 'type': '[TagChild]'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(FileResponse, self).__init__(**kwargs)
        self.type = kwargs['type']
        self.display_name = kwargs.get('display_name', None)
        self.parent_folder_id = kwargs['parent_folder_id']
        self.description = kwargs.get('description', None)
        self.location = kwargs.get('location', None)
        self.corporation = kwargs.get('corporation', None)
        self.group_ids = kwargs.get('group_ids', None)
        self.id = kwargs.get('id', None)
        self.file_name = kwargs.get('file_name', None)
        self.thumbnail_file_name = kwargs.get('thumbnail_file_name', None)
        self.creation_date = kwargs.get('creation_date', None)
        self.update_date = kwargs.get('update_date', None)
        self.file_count = kwargs.get('file_count', None)
        self.folder_count = kwargs.get('folder_count', None)
        self.is_root_folder = kwargs.get('is_root_folder', None)
        self.tags = kwargs.get('tags', None)


class FilesError(msrest.serialization.Model):
    """FilesError.

    :param file_id:
    :type file_id: str
    :param display_name:
    :type display_name: str
    :param message:
    :type message: str
    """

    _attribute_map = {
        'file_id': {'key': 'FileId', 'type': 'str'},
        'display_name': {'key': 'DisplayName', 'type': 'str'},
        'message': {'key': 'Message', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(FilesError, self).__init__(**kwargs)
        self.file_id = kwargs.get('file_id', None)
        self.display_name = kwargs.get('display_name', None)
        self.message = kwargs.get('message', None)


class FilesUpdateRequest(msrest.serialization.Model):
    """FilesUpdateRequest.

    All required parameters must be populated in order to send to Azure.

    :param display_name:
    :type display_name: str
    :param parent_folder_id: Required.
    :type parent_folder_id: str
    :param description:
    :type description: str
    :param group_ids:
    :type group_ids: list[str]
    """

    _validation = {
        'display_name': {'max_length': 223, 'min_length': 0},
        'parent_folder_id': {'required': True},
    }

    _attribute_map = {
        'display_name': {'key': 'DisplayName', 'type': 'str'},
        'parent_folder_id': {'key': 'ParentFolderId', 'type': 'str'},
        'description': {'key': 'Description', 'type': 'str'},
        'group_ids': {'key': 'GroupIds', 'type': '[str]'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(FilesUpdateRequest, self).__init__(**kwargs)
        self.display_name = kwargs.get('display_name', None)
        self.parent_folder_id = kwargs['parent_folder_id']
        self.description = kwargs.get('description', None)
        self.group_ids = kwargs.get('group_ids', None)


class FrequencyDomainSettingChild(msrest.serialization.Model):
    """FrequencyDomainSettingChild.

    :param markers:
    :type markers: list[~smartdiagnostics_sdk.models.MarkerChild]
    :param custom_markers:
    :type custom_markers: list[~smartdiagnostics_sdk.models.CustomMarkerChild]
    :param selected_bearing:
    :type selected_bearing: str
    :param side_bands:
    :type side_bands: int
    :param side_band_frequency:
    :type side_band_frequency: int
    """

    _attribute_map = {
        'markers': {'key': 'Markers', 'type': '[MarkerChild]'},
        'custom_markers': {'key': 'CustomMarkers', 'type': '[CustomMarkerChild]'},
        'selected_bearing': {'key': 'SelectedBearing', 'type': 'str'},
        'side_bands': {'key': 'SideBands', 'type': 'int'},
        'side_band_frequency': {'key': 'SideBandFrequency', 'type': 'int'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(FrequencyDomainSettingChild, self).__init__(**kwargs)
        self.markers = kwargs.get('markers', None)
        self.custom_markers = kwargs.get('custom_markers', None)
        self.selected_bearing = kwargs.get('selected_bearing', None)
        self.side_bands = kwargs.get('side_bands', None)
        self.side_band_frequency = kwargs.get('side_band_frequency', None)


class GroupAlertsResponse(msrest.serialization.Model):
    """GroupAlertsResponse.

    :param indicator_id:
    :type indicator_id: str
    :param indicator_name:
    :type indicator_name: str
    :param indicator_sort_order:
    :type indicator_sort_order: int
    :param hierarchy:
    :type hierarchy: list[~smartdiagnostics_sdk.models.HierarchyChild]
    :param time_of_alert:
    :type time_of_alert: ~datetime.datetime
    :param external_notification:
    :type external_notification: ~smartdiagnostics_sdk.models.ExternalNotificationChild
    """

    _attribute_map = {
        'indicator_id': {'key': 'IndicatorId', 'type': 'str'},
        'indicator_name': {'key': 'IndicatorName', 'type': 'str'},
        'indicator_sort_order': {'key': 'IndicatorSortOrder', 'type': 'int'},
        'hierarchy': {'key': 'Hierarchy', 'type': '[HierarchyChild]'},
        'time_of_alert': {'key': 'TimeOfAlert', 'type': 'iso-8601'},
        'external_notification': {'key': 'ExternalNotification', 'type': 'ExternalNotificationChild'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(GroupAlertsResponse, self).__init__(**kwargs)
        self.indicator_id = kwargs.get('indicator_id', None)
        self.indicator_name = kwargs.get('indicator_name', None)
        self.indicator_sort_order = kwargs.get('indicator_sort_order', None)
        self.hierarchy = kwargs.get('hierarchy', None)
        self.time_of_alert = kwargs.get('time_of_alert', None)
        self.external_notification = kwargs.get('external_notification', None)


class GroupMoveRequest(msrest.serialization.Model):
    """GroupMoveRequest.

    All required parameters must be populated in order to send to Azure.

    :param sort_order: Required.
    :type sort_order: int
    :param parent_id: Required.
    :type parent_id: str
    """

    _validation = {
        'sort_order': {'required': True, 'maximum': 2147483647, 'minimum': 0},
        'parent_id': {'required': True},
    }

    _attribute_map = {
        'sort_order': {'key': 'SortOrder', 'type': 'int'},
        'parent_id': {'key': 'ParentId', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(GroupMoveRequest, self).__init__(**kwargs)
        self.sort_order = kwargs['sort_order']
        self.parent_id = kwargs['parent_id']


class GroupStatusResponse(msrest.serialization.Model):
    """GroupStatusResponse.

    All required parameters must be populated in order to send to Azure.

    :param name: Required.
    :type name: str
    :param id: Required.
    :type id: str
    :param alarm_count: Required.
    :type alarm_count: int
    :param warning_count: Required.
    :type warning_count: int
    :param damage_score:
    :type damage_score: float
    :param alarm_severity:
    :type alarm_severity: int
    :param is_snoozed: Required.
    :type is_snoozed: bool
    :param is_paused: Required.
    :type is_paused: bool
    :param hierarchy:
    :type hierarchy: list[~smartdiagnostics_sdk.models.HierarchyChild]
    """

    _validation = {
        'name': {'required': True},
        'id': {'required': True},
        'alarm_count': {'required': True},
        'warning_count': {'required': True},
        'is_snoozed': {'required': True},
        'is_paused': {'required': True},
    }

    _attribute_map = {
        'name': {'key': 'Name', 'type': 'str'},
        'id': {'key': 'Id', 'type': 'str'},
        'alarm_count': {'key': 'AlarmCount', 'type': 'int'},
        'warning_count': {'key': 'WarningCount', 'type': 'int'},
        'damage_score': {'key': 'DamageScore', 'type': 'float'},
        'alarm_severity': {'key': 'AlarmSeverity', 'type': 'int'},
        'is_snoozed': {'key': 'IsSnoozed', 'type': 'bool'},
        'is_paused': {'key': 'IsPaused', 'type': 'bool'},
        'hierarchy': {'key': 'Hierarchy', 'type': '[HierarchyChild]'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(GroupStatusResponse, self).__init__(**kwargs)
        self.name = kwargs['name']
        self.id = kwargs['id']
        self.alarm_count = kwargs['alarm_count']
        self.warning_count = kwargs['warning_count']
        self.damage_score = kwargs.get('damage_score', None)
        self.alarm_severity = kwargs.get('alarm_severity', None)
        self.is_snoozed = kwargs['is_snoozed']
        self.is_paused = kwargs['is_paused']
        self.hierarchy = kwargs.get('hierarchy', None)


class HardwareEventModelV3(msrest.serialization.Model):
    """HardwareEventModelV3.

    All required parameters must be populated in order to send to Azure.

    :param id: Required. The Id of the hardware event.
    :type id: long
    :param hardware_type: The type of hardware that caused the event.
    :type hardware_type: str
    :param event_type: The event type that happened.
    :type event_type: str
    :param time_entered: Time hardware enter the event type.
    :type time_entered: ~datetime.datetime
    :param time_notified: Time notifications where sent out.
    :type time_notified: ~datetime.datetime
    :param time_exited: The time the hardware exited the event.
    :type time_exited: ~datetime.datetime
    :param time_acked: Time a user acknowledged the event.
    :type time_acked: ~datetime.datetime
    :param created: Time the log entry was created.
    :type created: ~datetime.datetime
    :param last_modified: Last time the event entry was modified.
    :type last_modified: ~datetime.datetime
    :param node: This class is meant to be used for all hardware Models.
    :type node: ~smartdiagnostics_sdk.models.HardwareModelV3
    :param collector: This class is meant to be used for all hardware Models.
    :type collector: ~smartdiagnostics_sdk.models.HardwareModelV3
    :param repeater: This class is meant to be used for all hardware Models.
    :type repeater: ~smartdiagnostics_sdk.models.HardwareModelV3
    """

    _validation = {
        'id': {'required': True},
    }

    _attribute_map = {
        'id': {'key': 'Id', 'type': 'long'},
        'hardware_type': {'key': 'HardwareType', 'type': 'str'},
        'event_type': {'key': 'EventType', 'type': 'str'},
        'time_entered': {'key': 'TimeEntered', 'type': 'iso-8601'},
        'time_notified': {'key': 'TimeNotified', 'type': 'iso-8601'},
        'time_exited': {'key': 'TimeExited', 'type': 'iso-8601'},
        'time_acked': {'key': 'TimeAcked', 'type': 'iso-8601'},
        'created': {'key': 'Created', 'type': 'iso-8601'},
        'last_modified': {'key': 'LastModified', 'type': 'iso-8601'},
        'node': {'key': 'Node', 'type': 'HardwareModelV3'},
        'collector': {'key': 'Collector', 'type': 'HardwareModelV3'},
        'repeater': {'key': 'Repeater', 'type': 'HardwareModelV3'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(HardwareEventModelV3, self).__init__(**kwargs)
        self.id = kwargs['id']
        self.hardware_type = kwargs.get('hardware_type', None)
        self.event_type = kwargs.get('event_type', None)
        self.time_entered = kwargs.get('time_entered', None)
        self.time_notified = kwargs.get('time_notified', None)
        self.time_exited = kwargs.get('time_exited', None)
        self.time_acked = kwargs.get('time_acked', None)
        self.created = kwargs.get('created', None)
        self.last_modified = kwargs.get('last_modified', None)
        self.node = kwargs.get('node', None)
        self.collector = kwargs.get('collector', None)
        self.repeater = kwargs.get('repeater', None)


class HardwareModelV3(msrest.serialization.Model):
    """This class is meant to be used for all hardware Models.

    All required parameters must be populated in order to send to Azure.

    :param id: Required. Hardware's Id.
    :type id: long
    :param serial_number: Required. Serial Number of hardware.
    :type serial_number: str
    :param nickname: Nickname of the hardware.
    :type nickname: str
    """

    _validation = {
        'id': {'required': True},
        'serial_number': {'required': True},
    }

    _attribute_map = {
        'id': {'key': 'Id', 'type': 'long'},
        'serial_number': {'key': 'SerialNumber', 'type': 'str'},
        'nickname': {'key': 'Nickname', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(HardwareModelV3, self).__init__(**kwargs)
        self.id = kwargs['id']
        self.serial_number = kwargs['serial_number']
        self.nickname = kwargs.get('nickname', None)


class HardwareRevisionChild(msrest.serialization.Model):
    """HardwareRevisionChild.

    :param hardware_revision_id:
    :type hardware_revision_id: int
    :param hardware_revision_name:
    :type hardware_revision_name: str
    """

    _attribute_map = {
        'hardware_revision_id': {'key': 'HardwareRevisionId', 'type': 'int'},
        'hardware_revision_name': {'key': 'HardwareRevisionName', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(HardwareRevisionChild, self).__init__(**kwargs)
        self.hardware_revision_id = kwargs.get('hardware_revision_id', None)
        self.hardware_revision_name = kwargs.get('hardware_revision_name', None)


class HardwareStatusChild(msrest.serialization.Model):
    """HardwareStatusChild.

    :param location_id:
    :type location_id: str
    :param location_name:
    :type location_name: str
    :param location_abbreviation:
    :type location_abbreviation: str
    :param hardware_count:
    :type hardware_count: int
    :param unassigned_count:
    :type unassigned_count: int
    :param online_count:
    :type online_count: int
    :param offline_count:
    :type offline_count: int
    """

    _attribute_map = {
        'location_id': {'key': 'LocationId', 'type': 'str'},
        'location_name': {'key': 'LocationName', 'type': 'str'},
        'location_abbreviation': {'key': 'LocationAbbreviation', 'type': 'str'},
        'hardware_count': {'key': 'HardwareCount', 'type': 'int'},
        'unassigned_count': {'key': 'UnassignedCount', 'type': 'int'},
        'online_count': {'key': 'OnlineCount', 'type': 'int'},
        'offline_count': {'key': 'OfflineCount', 'type': 'int'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(HardwareStatusChild, self).__init__(**kwargs)
        self.location_id = kwargs.get('location_id', None)
        self.location_name = kwargs.get('location_name', None)
        self.location_abbreviation = kwargs.get('location_abbreviation', None)
        self.hardware_count = kwargs.get('hardware_count', None)
        self.unassigned_count = kwargs.get('unassigned_count', None)
        self.online_count = kwargs.get('online_count', None)
        self.offline_count = kwargs.get('offline_count', None)


class HardwareStatusResponse(msrest.serialization.Model):
    """HardwareStatusResponse.

    :param location_hardware_statuses:
    :type location_hardware_statuses: list[~smartdiagnostics_sdk.models.HardwareStatusChild]
    :param total_hardware_count:
    :type total_hardware_count: int
    :param total_unassigned_count:
    :type total_unassigned_count: int
    :param total_online_count:
    :type total_online_count: int
    :param total_offline_count:
    :type total_offline_count: int
    """

    _attribute_map = {
        'location_hardware_statuses': {'key': 'LocationHardwareStatuses', 'type': '[HardwareStatusChild]'},
        'total_hardware_count': {'key': 'TotalHardwareCount', 'type': 'int'},
        'total_unassigned_count': {'key': 'TotalUnassignedCount', 'type': 'int'},
        'total_online_count': {'key': 'TotalOnlineCount', 'type': 'int'},
        'total_offline_count': {'key': 'TotalOfflineCount', 'type': 'int'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(HardwareStatusResponse, self).__init__(**kwargs)
        self.location_hardware_statuses = kwargs.get('location_hardware_statuses', None)
        self.total_hardware_count = kwargs.get('total_hardware_count', None)
        self.total_unassigned_count = kwargs.get('total_unassigned_count', None)
        self.total_online_count = kwargs.get('total_online_count', None)
        self.total_offline_count = kwargs.get('total_offline_count', None)


class HeatmapReportRequest(msrest.serialization.Model):
    """HeatmapReportRequest.

    All required parameters must be populated in order to send to Azure.

    :param aggregate_level: Required. The level at which to aggregate the results. Possible values
     include: "Indicator", "MonitoringPoint", "Asset".
    :type aggregate_level: str or ~smartdiagnostics_sdk.models.HeatmapReportRequestAggregateLevel
    :param hours_per_bin: Required. The size (in hours) to use to split the given time range into
     parts.
    :type hours_per_bin: int
    :param filter_id: The filter to use. Optional.
    :type filter_id: str
    :param start_date: Required. The start date of the time range to get the report for. Nullable
     so Required can catch nulls, will not
     be null later.
    :type start_date: ~datetime.datetime
    :param end_date: Required. The end date of the time range to get the values for. Nullable so
     Required can catch nulls, will not
     be null later.
    :type end_date: ~datetime.datetime
    :param file_name: Required. The filename to use for the report.
    :type file_name: str
    """

    _validation = {
        'aggregate_level': {'required': True},
        'hours_per_bin': {'required': True},
        'start_date': {'required': True},
        'end_date': {'required': True},
        'file_name': {'required': True},
    }

    _attribute_map = {
        'aggregate_level': {'key': 'AggregateLevel', 'type': 'str'},
        'hours_per_bin': {'key': 'HoursPerBin', 'type': 'int'},
        'filter_id': {'key': 'FilterId', 'type': 'str'},
        'start_date': {'key': 'StartDate', 'type': 'iso-8601'},
        'end_date': {'key': 'EndDate', 'type': 'iso-8601'},
        'file_name': {'key': 'FileName', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(HeatmapReportRequest, self).__init__(**kwargs)
        self.aggregate_level = kwargs['aggregate_level']
        self.hours_per_bin = kwargs['hours_per_bin']
        self.filter_id = kwargs.get('filter_id', None)
        self.start_date = kwargs['start_date']
        self.end_date = kwargs['end_date']
        self.file_name = kwargs['file_name']


class HierarchyChild(msrest.serialization.Model):
    """HierarchyChild.

    :param hierarchy_id:
    :type hierarchy_id: str
    :param hierarchy_name:
    :type hierarchy_name: str
    :param hierarchy_abbreviation:
    :type hierarchy_abbreviation: str
    :param hierarchy_type:
    :type hierarchy_type: str
    """

    _attribute_map = {
        'hierarchy_id': {'key': 'HierarchyId', 'type': 'str'},
        'hierarchy_name': {'key': 'HierarchyName', 'type': 'str'},
        'hierarchy_abbreviation': {'key': 'HierarchyAbbreviation', 'type': 'str'},
        'hierarchy_type': {'key': 'HierarchyType', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(HierarchyChild, self).__init__(**kwargs)
        self.hierarchy_id = kwargs.get('hierarchy_id', None)
        self.hierarchy_name = kwargs.get('hierarchy_name', None)
        self.hierarchy_abbreviation = kwargs.get('hierarchy_abbreviation', None)
        self.hierarchy_type = kwargs.get('hierarchy_type', None)


class HubNodeChild(msrest.serialization.Model):
    """HubNodeChild.

    :param node_id:
    :type node_id: long
    :param node_serial_number:
    :type node_serial_number: str
    :param node_nickname:
    :type node_nickname: str
    :param is_online:
    :type is_online: bool
    :param node_settings:
    :type node_settings: list[~smartdiagnostics_sdk.models.NodeSettingChild]
    :param latest_long_burst:
    :type latest_long_burst: ~smartdiagnostics_sdk.models.LongBurstRequestChild
    """

    _attribute_map = {
        'node_id': {'key': 'NodeId', 'type': 'long'},
        'node_serial_number': {'key': 'NodeSerialNumber', 'type': 'str'},
        'node_nickname': {'key': 'NodeNickname', 'type': 'str'},
        'is_online': {'key': 'IsOnline', 'type': 'bool'},
        'node_settings': {'key': 'NodeSettings', 'type': '[NodeSettingChild]'},
        'latest_long_burst': {'key': 'LatestLongBurst', 'type': 'LongBurstRequestChild'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(HubNodeChild, self).__init__(**kwargs)
        self.node_id = kwargs.get('node_id', None)
        self.node_serial_number = kwargs.get('node_serial_number', None)
        self.node_nickname = kwargs.get('node_nickname', None)
        self.is_online = kwargs.get('is_online', None)
        self.node_settings = kwargs.get('node_settings', None)
        self.latest_long_burst = kwargs.get('latest_long_burst', None)


class HubPortChild(msrest.serialization.Model):
    """HubPortChild.

    :param hub_port_id:
    :type hub_port_id: long
    :param hub_port_number:
    :type hub_port_number: int
    :param hub_port_node:
    :type hub_port_node: ~smartdiagnostics_sdk.models.HubNodeChild
    """

    _attribute_map = {
        'hub_port_id': {'key': 'HubPortId', 'type': 'long'},
        'hub_port_number': {'key': 'HubPortNumber', 'type': 'int'},
        'hub_port_node': {'key': 'HubPortNode', 'type': 'HubNodeChild'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(HubPortChild, self).__init__(**kwargs)
        self.hub_port_id = kwargs.get('hub_port_id', None)
        self.hub_port_number = kwargs.get('hub_port_number', None)
        self.hub_port_node = kwargs.get('hub_port_node', None)


class HubResponse(msrest.serialization.Model):
    """HubResponse.

    :param id:
    :type id: long
    :param receiver:
    :type receiver: ~smartdiagnostics_sdk.models.ReceiverChild
    :param location:
    :type location: ~smartdiagnostics_sdk.models.LocationChild
    :param corporation:
    :type corporation: ~smartdiagnostics_sdk.models.CorporationChild
    :param serial_number:
    :type serial_number: str
    :param nickname:
    :type nickname: str
    :param power_type_id:  Possible values include: "Unspecified", "DC (24V)", "Battery", "AC
     (120V)".
    :type power_type_id: str or ~smartdiagnostics_sdk.models.HubResponsePowerTypeId
    :param firmware_version:
    :type firmware_version: str
    :param hub_type_id:  Possible values include: "Unknown", "Version 1 (SevenPort)".
    :type hub_type_id: str or ~smartdiagnostics_sdk.models.HubResponseHubTypeId
    :param created:
    :type created: ~datetime.datetime
    :param updated:
    :type updated: ~datetime.datetime
    :param packet_success_rate:
    :type packet_success_rate: float
    :param wireless_efficiency:
    :type wireless_efficiency: float
    :param is_online:
    :type is_online: bool
    :param triggering_enabled:
    :type triggering_enabled: bool
    :param ports:
    :type ports: list[~smartdiagnostics_sdk.models.HubPortChild]
    """

    _validation = {
        'serial_number': {'max_length': 16, 'min_length': 0},
        'nickname': {'max_length': 50, 'min_length': 0},
    }

    _attribute_map = {
        'id': {'key': 'Id', 'type': 'long'},
        'receiver': {'key': 'Receiver', 'type': 'ReceiverChild'},
        'location': {'key': 'Location', 'type': 'LocationChild'},
        'corporation': {'key': 'Corporation', 'type': 'CorporationChild'},
        'serial_number': {'key': 'SerialNumber', 'type': 'str'},
        'nickname': {'key': 'Nickname', 'type': 'str'},
        'power_type_id': {'key': 'PowerTypeId', 'type': 'str'},
        'firmware_version': {'key': 'FirmwareVersion', 'type': 'str'},
        'hub_type_id': {'key': 'HubTypeId', 'type': 'str'},
        'created': {'key': 'Created', 'type': 'iso-8601'},
        'updated': {'key': 'Updated', 'type': 'iso-8601'},
        'packet_success_rate': {'key': 'PacketSuccessRate', 'type': 'float'},
        'wireless_efficiency': {'key': 'WirelessEfficiency', 'type': 'float'},
        'is_online': {'key': 'IsOnline', 'type': 'bool'},
        'triggering_enabled': {'key': 'TriggeringEnabled', 'type': 'bool'},
        'ports': {'key': 'Ports', 'type': '[HubPortChild]'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(HubResponse, self).__init__(**kwargs)
        self.id = kwargs.get('id', None)
        self.receiver = kwargs.get('receiver', None)
        self.location = kwargs.get('location', None)
        self.corporation = kwargs.get('corporation', None)
        self.serial_number = kwargs.get('serial_number', None)
        self.nickname = kwargs.get('nickname', None)
        self.power_type_id = kwargs.get('power_type_id', None)
        self.firmware_version = kwargs.get('firmware_version', None)
        self.hub_type_id = kwargs.get('hub_type_id', None)
        self.created = kwargs.get('created', None)
        self.updated = kwargs.get('updated', None)
        self.packet_success_rate = kwargs.get('packet_success_rate', None)
        self.wireless_efficiency = kwargs.get('wireless_efficiency', None)
        self.is_online = kwargs.get('is_online', None)
        self.triggering_enabled = kwargs.get('triggering_enabled', None)
        self.ports = kwargs.get('ports', None)


class IndicatorAlarmStateResponse(msrest.serialization.Model):
    """IndicatorAlarmStateResponse.

    All required parameters must be populated in order to send to Azure.

    :param current_value: Current Value of indicator.
    :type current_value: float
    :param last_update: Last time it was updated.
    :type last_update: ~datetime.datetime
    :param id: Required. Id of entity.
    :type id: str
    :param alarm_severity: Alarm severity.
    :type alarm_severity: int
    """

    _validation = {
        'id': {'required': True},
    }

    _attribute_map = {
        'current_value': {'key': 'CurrentValue', 'type': 'float'},
        'last_update': {'key': 'LastUpdate', 'type': 'iso-8601'},
        'id': {'key': 'Id', 'type': 'str'},
        'alarm_severity': {'key': 'AlarmSeverity', 'type': 'int'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(IndicatorAlarmStateResponse, self).__init__(**kwargs)
        self.current_value = kwargs.get('current_value', None)
        self.last_update = kwargs.get('last_update', None)
        self.id = kwargs['id']
        self.alarm_severity = kwargs.get('alarm_severity', None)


class IndicatorFilterCreateRequest(msrest.serialization.Model):
    """IndicatorFilterCreateRequest.

    All required parameters must be populated in order to send to Azure.

    :param name: Required.
    :type name: str
    :param indicator_types:
    :type indicator_types: list[str or
     ~smartdiagnostics_sdk.models.IndicatorFilterCreateRequestIndicatorTypesItem]
    :param sort_order:
    :type sort_order: int
    :param tag_ids:
    :type tag_ids: list[str]
    :param location_id:
    :type location_id: str
    :param system_id:
    :type system_id: str
    """

    _validation = {
        'name': {'required': True, 'max_length': 50, 'min_length': 0},
    }

    _attribute_map = {
        'name': {'key': 'Name', 'type': 'str'},
        'indicator_types': {'key': 'IndicatorTypes', 'type': '[str]'},
        'sort_order': {'key': 'SortOrder', 'type': 'int'},
        'tag_ids': {'key': 'TagIds', 'type': '[str]'},
        'location_id': {'key': 'LocationId', 'type': 'str'},
        'system_id': {'key': 'SystemId', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(IndicatorFilterCreateRequest, self).__init__(**kwargs)
        self.name = kwargs['name']
        self.indicator_types = kwargs.get('indicator_types', None)
        self.sort_order = kwargs.get('sort_order', None)
        self.tag_ids = kwargs.get('tag_ids', None)
        self.location_id = kwargs.get('location_id', None)
        self.system_id = kwargs.get('system_id', None)


class IndicatorFilterResponse(msrest.serialization.Model):
    """IndicatorFilterResponse.

    All required parameters must be populated in order to send to Azure.

    :param id: Required.
    :type id: str
    :param name: Required.
    :type name: str
    :param is_global: Required.
    :type is_global: bool
    :param indicator_types:
    :type indicator_types: list[str or
     ~smartdiagnostics_sdk.models.IndicatorFilterResponseIndicatorTypesItem]
    :param sort_order:
    :type sort_order: int
    :param tags: A set of tags.
    :type tags: list[~smartdiagnostics_sdk.models.TagChild]
    :param location:
    :type location: ~smartdiagnostics_sdk.models.LocationChild
    :param system:
    :type system: ~smartdiagnostics_sdk.models.SystemChild
    """

    _validation = {
        'id': {'required': True},
        'name': {'required': True},
        'is_global': {'required': True},
    }

    _attribute_map = {
        'id': {'key': 'Id', 'type': 'str'},
        'name': {'key': 'Name', 'type': 'str'},
        'is_global': {'key': 'IsGlobal', 'type': 'bool'},
        'indicator_types': {'key': 'IndicatorTypes', 'type': '[str]'},
        'sort_order': {'key': 'SortOrder', 'type': 'int'},
        'tags': {'key': 'Tags', 'type': '[TagChild]'},
        'location': {'key': 'Location', 'type': 'LocationChild'},
        'system': {'key': 'System', 'type': 'SystemChild'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(IndicatorFilterResponse, self).__init__(**kwargs)
        self.id = kwargs['id']
        self.name = kwargs['name']
        self.is_global = kwargs['is_global']
        self.indicator_types = kwargs.get('indicator_types', None)
        self.sort_order = kwargs.get('sort_order', None)
        self.tags = kwargs.get('tags', None)
        self.location = kwargs.get('location', None)
        self.system = kwargs.get('system', None)


class IndicatorFilterUpdateRequest(msrest.serialization.Model):
    """IndicatorFilterUpdateRequest.

    All required parameters must be populated in order to send to Azure.

    :param name: Required.
    :type name: str
    :param indicator_types:
    :type indicator_types: list[str or
     ~smartdiagnostics_sdk.models.IndicatorFilterUpdateRequestIndicatorTypesItem]
    :param sort_order:
    :type sort_order: int
    :param tag_ids:
    :type tag_ids: list[str]
    """

    _validation = {
        'name': {'required': True, 'max_length': 50, 'min_length': 0},
    }

    _attribute_map = {
        'name': {'key': 'Name', 'type': 'str'},
        'indicator_types': {'key': 'IndicatorTypes', 'type': '[str]'},
        'sort_order': {'key': 'SortOrder', 'type': 'int'},
        'tag_ids': {'key': 'TagIds', 'type': '[str]'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(IndicatorFilterUpdateRequest, self).__init__(**kwargs)
        self.name = kwargs['name']
        self.indicator_types = kwargs.get('indicator_types', None)
        self.sort_order = kwargs.get('sort_order', None)
        self.tag_ids = kwargs.get('tag_ids', None)


class IndicatorGroupCreateRequest(msrest.serialization.Model):
    """IndicatorGroupCreateRequest.

    All required parameters must be populated in order to send to Azure.

    :param name: Required.
    :type name: str
    :param abbreviation:
    :type abbreviation: str
    :param parent_id: Required.
    :type parent_id: str
    """

    _validation = {
        'name': {'required': True, 'max_length': 100, 'min_length': 0},
        'abbreviation': {'max_length': 5, 'min_length': 0},
        'parent_id': {'required': True},
    }

    _attribute_map = {
        'name': {'key': 'Name', 'type': 'str'},
        'abbreviation': {'key': 'Abbreviation', 'type': 'str'},
        'parent_id': {'key': 'ParentId', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(IndicatorGroupCreateRequest, self).__init__(**kwargs)
        self.name = kwargs['name']
        self.abbreviation = kwargs.get('abbreviation', None)
        self.parent_id = kwargs['parent_id']


class IndicatorGroupResponse(msrest.serialization.Model):
    """IndicatorGroupResponse.

    All required parameters must be populated in order to send to Azure.

    :param parent:
    :type parent: ~smartdiagnostics_sdk.models.ParentChild
    :param hierarchy:
    :type hierarchy: list[~smartdiagnostics_sdk.models.HierarchyChild]
    :param id: Required.
    :type id: str
    :param name: Required.
    :type name: str
    :param abbreviation:
    :type abbreviation: str
    :param active: Required.
    :type active: bool
    :param is_paused: Required.
    :type is_paused: bool
    :param is_snoozed: Required.
    :type is_snoozed: bool
    :param created: Required.
    :type created: ~datetime.datetime
    :param corporation: Required.
    :type corporation: ~smartdiagnostics_sdk.models.CorporationChild
    :param location: Required.
    :type location: ~smartdiagnostics_sdk.models.LocationChild
    """

    _validation = {
        'id': {'required': True},
        'name': {'required': True},
        'active': {'required': True},
        'is_paused': {'required': True},
        'is_snoozed': {'required': True},
        'created': {'required': True},
        'corporation': {'required': True},
        'location': {'required': True},
    }

    _attribute_map = {
        'parent': {'key': 'Parent', 'type': 'ParentChild'},
        'hierarchy': {'key': 'Hierarchy', 'type': '[HierarchyChild]'},
        'id': {'key': 'Id', 'type': 'str'},
        'name': {'key': 'Name', 'type': 'str'},
        'abbreviation': {'key': 'Abbreviation', 'type': 'str'},
        'active': {'key': 'Active', 'type': 'bool'},
        'is_paused': {'key': 'IsPaused', 'type': 'bool'},
        'is_snoozed': {'key': 'IsSnoozed', 'type': 'bool'},
        'created': {'key': 'Created', 'type': 'iso-8601'},
        'corporation': {'key': 'Corporation', 'type': 'CorporationChild'},
        'location': {'key': 'Location', 'type': 'LocationChild'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(IndicatorGroupResponse, self).__init__(**kwargs)
        self.parent = kwargs.get('parent', None)
        self.hierarchy = kwargs.get('hierarchy', None)
        self.id = kwargs['id']
        self.name = kwargs['name']
        self.abbreviation = kwargs.get('abbreviation', None)
        self.active = kwargs['active']
        self.is_paused = kwargs['is_paused']
        self.is_snoozed = kwargs['is_snoozed']
        self.created = kwargs['created']
        self.corporation = kwargs['corporation']
        self.location = kwargs['location']


class IndicatorGroupUpdateRequest(msrest.serialization.Model):
    """IndicatorGroupUpdateRequest.

    All required parameters must be populated in order to send to Azure.

    :param name: Required.
    :type name: str
    :param abbreviation:
    :type abbreviation: str
    :param is_paused: Required.
    :type is_paused: bool
    """

    _validation = {
        'name': {'required': True, 'max_length': 100, 'min_length': 0},
        'abbreviation': {'max_length': 5, 'min_length': 0},
        'is_paused': {'required': True},
    }

    _attribute_map = {
        'name': {'key': 'Name', 'type': 'str'},
        'abbreviation': {'key': 'Abbreviation', 'type': 'str'},
        'is_paused': {'key': 'IsPaused', 'type': 'bool'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(IndicatorGroupUpdateRequest, self).__init__(**kwargs)
        self.name = kwargs['name']
        self.abbreviation = kwargs.get('abbreviation', None)
        self.is_paused = kwargs['is_paused']


class IndicatorResponse(msrest.serialization.Model):
    """IndicatorResponse.

    All required parameters must be populated in order to send to Azure.

    :param id: Required.
    :type id: str
    :param name: Required.
    :type name: str
    :param system_sort_order:
    :type system_sort_order: int
    :param indicator_type: If creating a new MetricTypeCode be sure to add a Validator attribute
     and update the following classes
     if necessary: DataValidator, DataValidatorFunctions, ValidatorAttributes files. Possible
     values include: "Temperature", "Pressure", "Flow", "Humidity", "Power", "DifferentialPressure",
     "MultiSensorDifferentialPressure", "Voltage", "GeneralizedAtoD", "VibrationBandRms",
     "VibrationBandMax", "VibrationOverallPeak", "VibrationOverallRms", "VibrationOverallSkewness",
     "VibrationOverallKurtosis", "VibrationOverallCrestFactor", "DamageAccumulation",
     "VibrationBandRmsAccel", "VibrationBandMaxAccel", "VibrationOverallPeakAccel",
     "VibrationOverallRmsAccel", "VibrationOverallSkewnessAccel", "VibrationOverallKurtosisAccel",
     "VibrationOverallCrestFactorAccel", "DamageAccumulationAccel", "Group", "VibrationOverall",
     "VibrationOverallAccel", "GeneralTimeSeries", "Math", "OnStatistics", "OffStatistics",
     "AlarmStatistics", "WarningStatistics", "PositivePeakPressure", "NegativePeakPressure",
     "RmsPressure", "BandPressure", "OnPercentStatistics", "OffPercentStatistics",
     "AlarmPercentStatistics", "WarningPercentStatistics", "SignalStrength", "RunningSpeed",
     "DamageAccumulationPressure", "OilHumidity", "OilTemperature", "DamageAccumulationAccelRaw",
     "ThermalRegionOfInterest", "SmartMetric".
    :type indicator_type: str or ~smartdiagnostics_sdk.models.IndicatorResponseIndicatorType
    :param display_units:
    :type display_units: str
    :param base_units:
    :type base_units: str
    :param has_spectrum:
    :type has_spectrum: bool
    :param hierarchy:
    :type hierarchy: list[~smartdiagnostics_sdk.models.HierarchyChild]
    :param alarm_definition:
    :type alarm_definition: ~smartdiagnostics_sdk.models.AlarmDefinitionChild
    :param band_definition:
    :type band_definition: ~smartdiagnostics_sdk.models.BandDefinitionChild
    """

    _validation = {
        'id': {'required': True},
        'name': {'required': True},
    }

    _attribute_map = {
        'id': {'key': 'Id', 'type': 'str'},
        'name': {'key': 'Name', 'type': 'str'},
        'system_sort_order': {'key': 'SystemSortOrder', 'type': 'int'},
        'indicator_type': {'key': 'IndicatorType', 'type': 'str'},
        'display_units': {'key': 'DisplayUnits', 'type': 'str'},
        'base_units': {'key': 'BaseUnits', 'type': 'str'},
        'has_spectrum': {'key': 'HasSpectrum', 'type': 'bool'},
        'hierarchy': {'key': 'Hierarchy', 'type': '[HierarchyChild]'},
        'alarm_definition': {'key': 'AlarmDefinition', 'type': 'AlarmDefinitionChild'},
        'band_definition': {'key': 'BandDefinition', 'type': 'BandDefinitionChild'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(IndicatorResponse, self).__init__(**kwargs)
        self.id = kwargs['id']
        self.name = kwargs['name']
        self.system_sort_order = kwargs.get('system_sort_order', None)
        self.indicator_type = kwargs.get('indicator_type', None)
        self.display_units = kwargs.get('display_units', None)
        self.base_units = kwargs.get('base_units', None)
        self.has_spectrum = kwargs.get('has_spectrum', None)
        self.hierarchy = kwargs.get('hierarchy', None)
        self.alarm_definition = kwargs.get('alarm_definition', None)
        self.band_definition = kwargs.get('band_definition', None)


class IndicatorTypesResponse(msrest.serialization.Model):
    """IndicatorTypesResponse.

    All required parameters must be populated in order to send to Azure.

    :param id: Required.
    :type id: int
    :param name: Required.
    :type name: str
    """

    _validation = {
        'id': {'required': True},
        'name': {'required': True},
    }

    _attribute_map = {
        'id': {'key': 'Id', 'type': 'int'},
        'name': {'key': 'Name', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(IndicatorTypesResponse, self).__init__(**kwargs)
        self.id = kwargs['id']
        self.name = kwargs['name']


class InstallAddUserResponse(msrest.serialization.Model):
    """InstallAddUserResponse.

    Variables are only populated by the server, and will be ignored when sending a request.

    :param install_id:
    :type install_id: str
    :ivar success_count:
    :vartype success_count: int
    :ivar error_count:
    :vartype error_count: int
    """

    _validation = {
        'success_count': {'readonly': True},
        'error_count': {'readonly': True},
    }

    _attribute_map = {
        'install_id': {'key': 'InstallId', 'type': 'str'},
        'success_count': {'key': 'SuccessCount', 'type': 'int'},
        'error_count': {'key': 'ErrorCount', 'type': 'int'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(InstallAddUserResponse, self).__init__(**kwargs)
        self.install_id = kwargs.get('install_id', None)
        self.success_count = None
        self.error_count = None


class InstallModifyUsersRequest(msrest.serialization.Model):
    """InstallModifyUsersRequest.

    :param user_ids:
    :type user_ids: list[str]
    """

    _attribute_map = {
        'user_ids': {'key': 'UserIds', 'type': '[str]'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(InstallModifyUsersRequest, self).__init__(**kwargs)
        self.user_ids = kwargs.get('user_ids', None)


class InstallNodeResponse(msrest.serialization.Model):
    """InstallNodeResponse.

    :param node_id:
    :type node_id: long
    :param install_id:
    :type install_id: str
    :param node_serial_number:
    :type node_serial_number: str
    :param node_nickname:
    :type node_nickname: str
    :param install_status:
    :type install_status: ~smartdiagnostics_sdk.models.InstallNodeStatusChild
    :param location:
    :type location: ~smartdiagnostics_sdk.models.LocationChild
    """

    _attribute_map = {
        'node_id': {'key': 'NodeId', 'type': 'long'},
        'install_id': {'key': 'InstallId', 'type': 'str'},
        'node_serial_number': {'key': 'NodeSerialNumber', 'type': 'str'},
        'node_nickname': {'key': 'NodeNickname', 'type': 'str'},
        'install_status': {'key': 'InstallStatus', 'type': 'InstallNodeStatusChild'},
        'location': {'key': 'Location', 'type': 'LocationChild'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(InstallNodeResponse, self).__init__(**kwargs)
        self.node_id = kwargs.get('node_id', None)
        self.install_id = kwargs.get('install_id', None)
        self.node_serial_number = kwargs.get('node_serial_number', None)
        self.node_nickname = kwargs.get('node_nickname', None)
        self.install_status = kwargs.get('install_status', None)
        self.location = kwargs.get('location', None)


class InstallNodesStatusChild(msrest.serialization.Model):
    """InstallNodesStatusChild.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar total:
    :vartype total: int
    :param status:
    :type status: ~smartdiagnostics_sdk.models.NodeStatusChild
    """

    _validation = {
        'total': {'readonly': True},
    }

    _attribute_map = {
        'total': {'key': 'Total', 'type': 'int'},
        'status': {'key': 'Status', 'type': 'NodeStatusChild'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(InstallNodesStatusChild, self).__init__(**kwargs)
        self.total = None
        self.status = kwargs.get('status', None)


class InstallNodeStatusChild(msrest.serialization.Model):
    """InstallNodeStatusChild.

    :param status_id: The corresponding StatusId.
    :type status_id: long
    :param status: The textual description of the Status.
    :type status: str
    :param status_date: The DateTime that the current status was set as part of an install
     activity.
    :type status_date: ~datetime.datetime
    :param status_note: A brief note about the installation of the node, typically used when
     something prevents a node from being installed to keep records.
    :type status_note: str
    :param install_user: The user that set the current install status.
    :type install_user: str
    """

    _attribute_map = {
        'status_id': {'key': 'StatusId', 'type': 'long'},
        'status': {'key': 'Status', 'type': 'str'},
        'status_date': {'key': 'StatusDate', 'type': 'iso-8601'},
        'status_note': {'key': 'StatusNote', 'type': 'str'},
        'install_user': {'key': 'InstallUser', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(InstallNodeStatusChild, self).__init__(**kwargs)
        self.status_id = kwargs.get('status_id', None)
        self.status = kwargs.get('status', None)
        self.status_date = kwargs.get('status_date', None)
        self.status_note = kwargs.get('status_note', None)
        self.install_user = kwargs.get('install_user', None)


class InstallNodeUpdateRequest(msrest.serialization.Model):
    """InstallNodeUpdateRequest.

    All required parameters must be populated in order to send to Azure.

    :param status_id: Required. The Installation status identifier of the nodes at time of install.
    :type status_id: int
    :param status_note: Installations notes typically used when a node is unable to be installed.
    :type status_note: str
    """

    _validation = {
        'status_id': {'required': True},
        'status_note': {'max_length': 200, 'min_length': 0},
    }

    _attribute_map = {
        'status_id': {'key': 'StatusId', 'type': 'int'},
        'status_note': {'key': 'StatusNote', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(InstallNodeUpdateRequest, self).__init__(**kwargs)
        self.status_id = kwargs['status_id']
        self.status_note = kwargs.get('status_note', None)


class InstallResponse(msrest.serialization.Model):
    """InstallResponse.

    Variables are only populated by the server, and will be ignored when sending a request.

    :param id:
    :type id: str
    :param name:
    :type name: str
    :param start_date:
    :type start_date: ~datetime.datetime
    :param end_date:
    :type end_date: ~datetime.datetime
    :ivar active:
    :vartype active: bool
    :param location:
    :type location: ~smartdiagnostics_sdk.models.LocationChild
    :param corporation:
    :type corporation: ~smartdiagnostics_sdk.models.CorporationChild
    :param users:
    :type users: list[~smartdiagnostics_sdk.models.UserChild]
    :param node_status:
    :type node_status: ~smartdiagnostics_sdk.models.InstallNodesStatusChild
    """

    _validation = {
        'active': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'Id', 'type': 'str'},
        'name': {'key': 'Name', 'type': 'str'},
        'start_date': {'key': 'StartDate', 'type': 'iso-8601'},
        'end_date': {'key': 'EndDate', 'type': 'iso-8601'},
        'active': {'key': 'Active', 'type': 'bool'},
        'location': {'key': 'Location', 'type': 'LocationChild'},
        'corporation': {'key': 'Corporation', 'type': 'CorporationChild'},
        'users': {'key': 'Users', 'type': '[UserChild]'},
        'node_status': {'key': 'NodeStatus', 'type': 'InstallNodesStatusChild'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(InstallResponse, self).__init__(**kwargs)
        self.id = kwargs.get('id', None)
        self.name = kwargs.get('name', None)
        self.start_date = kwargs.get('start_date', None)
        self.end_date = kwargs.get('end_date', None)
        self.active = None
        self.location = kwargs.get('location', None)
        self.corporation = kwargs.get('corporation', None)
        self.users = kwargs.get('users', None)
        self.node_status = kwargs.get('node_status', None)


class InstallUpdateRequest(msrest.serialization.Model):
    """InstallUpdateRequest.

    All required parameters must be populated in order to send to Azure.

    :param name: Required.
    :type name: str
    :param start_date: Required.
    :type start_date: ~datetime.datetime
    :param end_date:
    :type end_date: ~datetime.datetime
    """

    _validation = {
        'name': {'required': True, 'max_length': 50, 'min_length': 0},
        'start_date': {'required': True},
    }

    _attribute_map = {
        'name': {'key': 'Name', 'type': 'str'},
        'start_date': {'key': 'StartDate', 'type': 'iso-8601'},
        'end_date': {'key': 'EndDate', 'type': 'iso-8601'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(InstallUpdateRequest, self).__init__(**kwargs)
        self.name = kwargs['name']
        self.start_date = kwargs['start_date']
        self.end_date = kwargs.get('end_date', None)


class JobModelV3(msrest.serialization.Model):
    """JobModelV3.

    All required parameters must be populated in order to send to Azure.

    :param id: Required.
    :type id: str
    :param location_name:
    :type location_name: str
    :param location_id:
    :type location_id: str
    :param corporation_name:
    :type corporation_name: str
    :param corporation_id:
    :type corporation_id: str
    :param user_name:
    :type user_name: str
    :param type:
    :type type: str
    :param status:  Possible values include: "Queued", "Running", "Finished", "FinishedWithErrors",
     "Errored", "Deferred".
    :type status: str or ~smartdiagnostics_sdk.models.JobModelV3Status
    :param upload_date:
    :type upload_date: ~datetime.datetime
    :param uploaded_file_name:
    :type uploaded_file_name: str
    """

    _validation = {
        'id': {'required': True},
    }

    _attribute_map = {
        'id': {'key': 'Id', 'type': 'str'},
        'location_name': {'key': 'LocationName', 'type': 'str'},
        'location_id': {'key': 'LocationId', 'type': 'str'},
        'corporation_name': {'key': 'CorporationName', 'type': 'str'},
        'corporation_id': {'key': 'CorporationId', 'type': 'str'},
        'user_name': {'key': 'UserName', 'type': 'str'},
        'type': {'key': 'Type', 'type': 'str'},
        'status': {'key': 'Status', 'type': 'str'},
        'upload_date': {'key': 'UploadDate', 'type': 'iso-8601'},
        'uploaded_file_name': {'key': 'UploadedFileName', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(JobModelV3, self).__init__(**kwargs)
        self.id = kwargs['id']
        self.location_name = kwargs.get('location_name', None)
        self.location_id = kwargs.get('location_id', None)
        self.corporation_name = kwargs.get('corporation_name', None)
        self.corporation_id = kwargs.get('corporation_id', None)
        self.user_name = kwargs.get('user_name', None)
        self.type = kwargs.get('type', None)
        self.status = kwargs.get('status', None)
        self.upload_date = kwargs.get('upload_date', None)
        self.uploaded_file_name = kwargs.get('uploaded_file_name', None)


class LayoutChild(msrest.serialization.Model):
    """LayoutChild.

    All required parameters must be populated in order to send to Azure.

    :param layout_row: Required.
    :type layout_row: int
    :param layout_column: Required.
    :type layout_column: int
    :param layout_height: Required.
    :type layout_height: int
    :param layout_width: Required.
    :type layout_width: int
    """

    _validation = {
        'layout_row': {'required': True},
        'layout_column': {'required': True},
        'layout_height': {'required': True},
        'layout_width': {'required': True},
    }

    _attribute_map = {
        'layout_row': {'key': 'LayoutRow', 'type': 'int'},
        'layout_column': {'key': 'LayoutColumn', 'type': 'int'},
        'layout_height': {'key': 'LayoutHeight', 'type': 'int'},
        'layout_width': {'key': 'LayoutWidth', 'type': 'int'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(LayoutChild, self).__init__(**kwargs)
        self.layout_row = kwargs['layout_row']
        self.layout_column = kwargs['layout_column']
        self.layout_height = kwargs['layout_height']
        self.layout_width = kwargs['layout_width']


class LocationChild(msrest.serialization.Model):
    """LocationChild.

    All required parameters must be populated in order to send to Azure.

    :param location_id: Required.
    :type location_id: str
    :param location_name: Required.
    :type location_name: str
    :param location_abbreviation:
    :type location_abbreviation: str
    """

    _validation = {
        'location_id': {'required': True},
        'location_name': {'required': True},
    }

    _attribute_map = {
        'location_id': {'key': 'LocationId', 'type': 'str'},
        'location_name': {'key': 'LocationName', 'type': 'str'},
        'location_abbreviation': {'key': 'LocationAbbreviation', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(LocationChild, self).__init__(**kwargs)
        self.location_id = kwargs['location_id']
        self.location_name = kwargs['location_name']
        self.location_abbreviation = kwargs.get('location_abbreviation', None)


class LocationCreateRequest(msrest.serialization.Model):
    """LocationCreateRequest.

    All required parameters must be populated in order to send to Azure.

    :param name: Required.
    :type name: str
    :param abbreviation:
    :type abbreviation: str
    :param corporation_id: Required.
    :type corporation_id: str
    """

    _validation = {
        'name': {'required': True, 'max_length': 50, 'min_length': 0},
        'abbreviation': {'max_length': 5, 'min_length': 0},
        'corporation_id': {'required': True},
    }

    _attribute_map = {
        'name': {'key': 'Name', 'type': 'str'},
        'abbreviation': {'key': 'Abbreviation', 'type': 'str'},
        'corporation_id': {'key': 'CorporationId', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(LocationCreateRequest, self).__init__(**kwargs)
        self.name = kwargs['name']
        self.abbreviation = kwargs.get('abbreviation', None)
        self.corporation_id = kwargs['corporation_id']


class LocationResponse(msrest.serialization.Model):
    """LocationResponse.

    All required parameters must be populated in order to send to Azure.

    :param id: Required.
    :type id: str
    :param name: Required.
    :type name: str
    :param abbreviation:
    :type abbreviation: str
    :param active:
    :type active: bool
    :param created:
    :type created: ~datetime.datetime
    :param site_ids:
    :type site_ids: list[str]
    :param settings:
    :type settings: ~smartdiagnostics_sdk.models.LocationSettingsChild
    :param corporation:
    :type corporation: ~smartdiagnostics_sdk.models.PrimaryCorporationChild
    :param systems:
    :type systems: list[~smartdiagnostics_sdk.models.SystemChild]
    """

    _validation = {
        'id': {'required': True},
        'name': {'required': True},
    }

    _attribute_map = {
        'id': {'key': 'Id', 'type': 'str'},
        'name': {'key': 'Name', 'type': 'str'},
        'abbreviation': {'key': 'Abbreviation', 'type': 'str'},
        'active': {'key': 'Active', 'type': 'bool'},
        'created': {'key': 'Created', 'type': 'iso-8601'},
        'site_ids': {'key': 'SiteIds', 'type': '[str]'},
        'settings': {'key': 'Settings', 'type': 'LocationSettingsChild'},
        'corporation': {'key': 'Corporation', 'type': 'PrimaryCorporationChild'},
        'systems': {'key': 'Systems', 'type': '[SystemChild]'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(LocationResponse, self).__init__(**kwargs)
        self.id = kwargs['id']
        self.name = kwargs['name']
        self.abbreviation = kwargs.get('abbreviation', None)
        self.active = kwargs.get('active', None)
        self.created = kwargs.get('created', None)
        self.site_ids = kwargs.get('site_ids', None)
        self.settings = kwargs.get('settings', None)
        self.corporation = kwargs.get('corporation', None)
        self.systems = kwargs.get('systems', None)


class LocationSettingsChild(msrest.serialization.Model):
    """LocationSettingsChild.

    :param max_transport_interval:
    :type max_transport_interval: int
    :param max_vibration_update_interval:
    :type max_vibration_update_interval: int
    :param max_oil_quality_update_interval:
    :type max_oil_quality_update_interval: int
    :param opc_enabled:
    :type opc_enabled: bool
    :param assign_filters_to_account:
    :type assign_filters_to_account: bool
    :param external_notification_type:  Possible values include: "Disabled", "Automatic", "Manual".
    :type external_notification_type: str or
     ~smartdiagnostics_sdk.models.LocationSettingsChildExternalNotificationType
    """

    _attribute_map = {
        'max_transport_interval': {'key': 'MaxTransportInterval', 'type': 'int'},
        'max_vibration_update_interval': {'key': 'MaxVibrationUpdateInterval', 'type': 'int'},
        'max_oil_quality_update_interval': {'key': 'MaxOilQualityUpdateInterval', 'type': 'int'},
        'opc_enabled': {'key': 'OpcEnabled', 'type': 'bool'},
        'assign_filters_to_account': {'key': 'AssignFiltersToAccount', 'type': 'bool'},
        'external_notification_type': {'key': 'ExternalNotificationType', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(LocationSettingsChild, self).__init__(**kwargs)
        self.max_transport_interval = kwargs.get('max_transport_interval', None)
        self.max_vibration_update_interval = kwargs.get('max_vibration_update_interval', None)
        self.max_oil_quality_update_interval = kwargs.get('max_oil_quality_update_interval', None)
        self.opc_enabled = kwargs.get('opc_enabled', None)
        self.assign_filters_to_account = kwargs.get('assign_filters_to_account', None)
        self.external_notification_type = kwargs.get('external_notification_type', None)


class LongBurstRequestChild(msrest.serialization.Model):
    """LongBurstRequestChild.

    :param long_burst_request_id:
    :type long_burst_request_id: long
    :param long_burst_request_status:  Possible values include: "Unknown", "Failed", "Canceled",
     "TimedOut", "Initiated", "Enqueued", "Capturing", "Processing", "Completed".
    :type long_burst_request_status: str or
     ~smartdiagnostics_sdk.models.LongBurstRequestChildLongBurstRequestStatus
    :param requested_time:
    :type requested_time: ~datetime.datetime
    :param completed_time:
    :type completed_time: ~datetime.datetime
    :param requested_by_user:
    :type requested_by_user: ~smartdiagnostics_sdk.models.UserChild
    :param x_axis_long_burst_file:
    :type x_axis_long_burst_file: str
    :param y_axis_long_burst_file:
    :type y_axis_long_burst_file: str
    """

    _attribute_map = {
        'long_burst_request_id': {'key': 'LongBurstRequestId', 'type': 'long'},
        'long_burst_request_status': {'key': 'LongBurstRequestStatus', 'type': 'str'},
        'requested_time': {'key': 'RequestedTime', 'type': 'iso-8601'},
        'completed_time': {'key': 'CompletedTime', 'type': 'iso-8601'},
        'requested_by_user': {'key': 'RequestedByUser', 'type': 'UserChild'},
        'x_axis_long_burst_file': {'key': 'XAxisLongBurstFile', 'type': 'str'},
        'y_axis_long_burst_file': {'key': 'YAxisLongBurstFile', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(LongBurstRequestChild, self).__init__(**kwargs)
        self.long_burst_request_id = kwargs.get('long_burst_request_id', None)
        self.long_burst_request_status = kwargs.get('long_burst_request_status', None)
        self.requested_time = kwargs.get('requested_time', None)
        self.completed_time = kwargs.get('completed_time', None)
        self.requested_by_user = kwargs.get('requested_by_user', None)
        self.x_axis_long_burst_file = kwargs.get('x_axis_long_burst_file', None)
        self.y_axis_long_burst_file = kwargs.get('y_axis_long_burst_file', None)


class MarkerChild(msrest.serialization.Model):
    """MarkerChild.

    All required parameters must be populated in order to send to Azure.

    :param marker_name:
    :type marker_name: str
    :param marker_show_harmonics: Required.
    :type marker_show_harmonics: bool
    :param marker_show_side_bands: Required.
    :type marker_show_side_bands: bool
    :param marker_show_peaks: Required.
    :type marker_show_peaks: bool
    """

    _validation = {
        'marker_name': {'max_length': 5, 'min_length': 0},
        'marker_show_harmonics': {'required': True},
        'marker_show_side_bands': {'required': True},
        'marker_show_peaks': {'required': True},
    }

    _attribute_map = {
        'marker_name': {'key': 'MarkerName', 'type': 'str'},
        'marker_show_harmonics': {'key': 'MarkerShowHarmonics', 'type': 'bool'},
        'marker_show_side_bands': {'key': 'MarkerShowSideBands', 'type': 'bool'},
        'marker_show_peaks': {'key': 'MarkerShowPeaks', 'type': 'bool'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(MarkerChild, self).__init__(**kwargs)
        self.marker_name = kwargs.get('marker_name', None)
        self.marker_show_harmonics = kwargs['marker_show_harmonics']
        self.marker_show_side_bands = kwargs['marker_show_side_bands']
        self.marker_show_peaks = kwargs['marker_show_peaks']


class MarkerResponse(msrest.serialization.Model):
    """MarkerResponse.

    All required parameters must be populated in order to send to Azure.

    :param name: Required.
    :type name: str
    :param marker_type: Required.  Possible values include: "Fixed", "Multiplier".
    :type marker_type: str or ~smartdiagnostics_sdk.models.MarkerResponseMarkerType
    :param value: Required.
    :type value: float
    :param order: Required.
    :type order: int
    """

    _validation = {
        'name': {'required': True},
        'marker_type': {'required': True},
        'value': {'required': True},
        'order': {'required': True},
    }

    _attribute_map = {
        'name': {'key': 'Name', 'type': 'str'},
        'marker_type': {'key': 'MarkerType', 'type': 'str'},
        'value': {'key': 'Value', 'type': 'float'},
        'order': {'key': 'Order', 'type': 'int'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(MarkerResponse, self).__init__(**kwargs)
        self.name = kwargs['name']
        self.marker_type = kwargs['marker_type']
        self.value = kwargs['value']
        self.order = kwargs['order']


class MarkerUpdateRequest(msrest.serialization.Model):
    """MarkerUpdateRequest.

    All required parameters must be populated in order to send to Azure.

    :param name: Required.
    :type name: str
    :param marker_type: Required.  Possible values include: "Fixed", "Multiplier".
    :type marker_type: str or ~smartdiagnostics_sdk.models.MarkerUpdateRequestMarkerType
    :param value: Required.
    :type value: float
    :param order: Required.
    :type order: int
    """

    _validation = {
        'name': {'required': True, 'max_length': 5, 'min_length': 0},
        'marker_type': {'required': True},
        'value': {'required': True, 'minimum': 0},
        'order': {'required': True, 'maximum': 100, 'minimum': 0},
    }

    _attribute_map = {
        'name': {'key': 'Name', 'type': 'str'},
        'marker_type': {'key': 'MarkerType', 'type': 'str'},
        'value': {'key': 'Value', 'type': 'float'},
        'order': {'key': 'Order', 'type': 'int'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(MarkerUpdateRequest, self).__init__(**kwargs)
        self.name = kwargs['name']
        self.marker_type = kwargs['marker_type']
        self.value = kwargs['value']
        self.order = kwargs['order']


class MonitoringPointResponse(msrest.serialization.Model):
    """MonitoringPointResponse.

    All required parameters must be populated in order to send to Azure.

    :param note:
    :type note: str
    :param running_speed_multiplier:
    :type running_speed_multiplier: float
    :param monitoring_point_type:  Possible values include: "Invalid", "Custom", "Vibration",
     "Pressure", "OilQuality", "GeneralInput", "IndicatorBased", "GeneralAtoD".
    :type monitoring_point_type: str or
     ~smartdiagnostics_sdk.models.MonitoringPointResponseMonitoringPointType
    :param node:
    :type node: ~smartdiagnostics_sdk.models.NodeChild
    :param bearing:
    :type bearing: ~smartdiagnostics_sdk.models.BearingChild
    :param hierarchy:
    :type hierarchy: list[~smartdiagnostics_sdk.models.HierarchyChild]
    :param children:
    :type children: list[~smartdiagnostics_sdk.models.DescendantChild]
    :param parent:
    :type parent: ~smartdiagnostics_sdk.models.ParentChild
    :param id: Required.
    :type id: str
    :param name: Required.
    :type name: str
    :param abbreviation:
    :type abbreviation: str
    :param active: Required.
    :type active: bool
    :param is_paused: Required.
    :type is_paused: bool
    :param is_snoozed: Required.
    :type is_snoozed: bool
    :param created: Required.
    :type created: ~datetime.datetime
    :param corporation: Required.
    :type corporation: ~smartdiagnostics_sdk.models.CorporationChild
    :param location: Required.
    :type location: ~smartdiagnostics_sdk.models.LocationChild
    """

    _validation = {
        'id': {'required': True},
        'name': {'required': True},
        'active': {'required': True},
        'is_paused': {'required': True},
        'is_snoozed': {'required': True},
        'created': {'required': True},
        'corporation': {'required': True},
        'location': {'required': True},
    }

    _attribute_map = {
        'note': {'key': 'Note', 'type': 'str'},
        'running_speed_multiplier': {'key': 'RunningSpeedMultiplier', 'type': 'float'},
        'monitoring_point_type': {'key': 'MonitoringPointType', 'type': 'str'},
        'node': {'key': 'Node', 'type': 'NodeChild'},
        'bearing': {'key': 'Bearing', 'type': 'BearingChild'},
        'hierarchy': {'key': 'Hierarchy', 'type': '[HierarchyChild]'},
        'children': {'key': 'Children', 'type': '[DescendantChild]'},
        'parent': {'key': 'Parent', 'type': 'ParentChild'},
        'id': {'key': 'Id', 'type': 'str'},
        'name': {'key': 'Name', 'type': 'str'},
        'abbreviation': {'key': 'Abbreviation', 'type': 'str'},
        'active': {'key': 'Active', 'type': 'bool'},
        'is_paused': {'key': 'IsPaused', 'type': 'bool'},
        'is_snoozed': {'key': 'IsSnoozed', 'type': 'bool'},
        'created': {'key': 'Created', 'type': 'iso-8601'},
        'corporation': {'key': 'Corporation', 'type': 'CorporationChild'},
        'location': {'key': 'Location', 'type': 'LocationChild'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(MonitoringPointResponse, self).__init__(**kwargs)
        self.note = kwargs.get('note', None)
        self.running_speed_multiplier = kwargs.get('running_speed_multiplier', None)
        self.monitoring_point_type = kwargs.get('monitoring_point_type', None)
        self.node = kwargs.get('node', None)
        self.bearing = kwargs.get('bearing', None)
        self.hierarchy = kwargs.get('hierarchy', None)
        self.children = kwargs.get('children', None)
        self.parent = kwargs.get('parent', None)
        self.id = kwargs['id']
        self.name = kwargs['name']
        self.abbreviation = kwargs.get('abbreviation', None)
        self.active = kwargs['active']
        self.is_paused = kwargs['is_paused']
        self.is_snoozed = kwargs['is_snoozed']
        self.created = kwargs['created']
        self.corporation = kwargs['corporation']
        self.location = kwargs['location']


class MonitoringPointTypeCodeModel(msrest.serialization.Model):
    """MonitoringPointTypeCodeModel.

    :param text:
    :type text: str
    :param value:
    :type value: int
    """

    _attribute_map = {
        'text': {'key': 'text', 'type': 'str'},
        'value': {'key': 'value', 'type': 'int'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(MonitoringPointTypeCodeModel, self).__init__(**kwargs)
        self.text = kwargs.get('text', None)
        self.value = kwargs.get('value', None)


class MoveFilesRequest(msrest.serialization.Model):
    """MoveFilesRequest.

    All required parameters must be populated in order to send to Azure.

    :param file_ids: Required. File Ids to move.
    :type file_ids: list[str]
    :param destination_folder_id: Required. File to move all files to (Parent Id).
    :type destination_folder_id: str
    """

    _validation = {
        'file_ids': {'required': True},
        'destination_folder_id': {'required': True},
    }

    _attribute_map = {
        'file_ids': {'key': 'FileIds', 'type': '[str]'},
        'destination_folder_id': {'key': 'DestinationFolderId', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(MoveFilesRequest, self).__init__(**kwargs)
        self.file_ids = kwargs['file_ids']
        self.destination_folder_id = kwargs['destination_folder_id']


class MoveFilesResponse(msrest.serialization.Model):
    """MoveFilesResponse.

    :param destination_folder_id:
    :type destination_folder_id: str
    :param success_count:
    :type success_count: int
    :param error_count:
    :type error_count: int
    :param errors:
    :type errors: list[~smartdiagnostics_sdk.models.FilesError]
    """

    _attribute_map = {
        'destination_folder_id': {'key': 'DestinationFolderId', 'type': 'str'},
        'success_count': {'key': 'SuccessCount', 'type': 'int'},
        'error_count': {'key': 'ErrorCount', 'type': 'int'},
        'errors': {'key': 'Errors', 'type': '[FilesError]'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(MoveFilesResponse, self).__init__(**kwargs)
        self.destination_folder_id = kwargs.get('destination_folder_id', None)
        self.success_count = kwargs.get('success_count', None)
        self.error_count = kwargs.get('error_count', None)
        self.errors = kwargs.get('errors', None)


class NodeChild(msrest.serialization.Model):
    """NodeChild.

    :param node_id:
    :type node_id: long
    :param node_serial_number:
    :type node_serial_number: str
    :param node_nickname:
    :type node_nickname: str
    :param node_type_code:  Possible values include: "Invalid", "KcfFlow", "KcfPressureVoltage",
     "KcfPressureCurrent", "KcfPower", "KcfVibration", "KcfVibrationV1", "KcfVoltage", "KcfCurrent",
     "KcfAtoDVoltage", "KcfAtoDCurrent", "KcfOilQuality", "Generic", "KcfAgnostic", "KcfHumidity",
     "KcfExtendedTemperatureVibration", "KcfHubVibrationV1".
    :type node_type_code: str or ~smartdiagnostics_sdk.models.NodeChildNodeTypeCode
    :param node_sampling_frequency:
    :type node_sampling_frequency: int
    :param node_update_interval:
    :type node_update_interval: int
    """

    _attribute_map = {
        'node_id': {'key': 'NodeId', 'type': 'long'},
        'node_serial_number': {'key': 'NodeSerialNumber', 'type': 'str'},
        'node_nickname': {'key': 'NodeNickname', 'type': 'str'},
        'node_type_code': {'key': 'NodeTypeCode', 'type': 'str'},
        'node_sampling_frequency': {'key': 'NodeSamplingFrequency', 'type': 'int'},
        'node_update_interval': {'key': 'NodeUpdateInterval', 'type': 'int'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(NodeChild, self).__init__(**kwargs)
        self.node_id = kwargs.get('node_id', None)
        self.node_serial_number = kwargs.get('node_serial_number', None)
        self.node_nickname = kwargs.get('node_nickname', None)
        self.node_type_code = kwargs.get('node_type_code', None)
        self.node_sampling_frequency = kwargs.get('node_sampling_frequency', None)
        self.node_update_interval = kwargs.get('node_update_interval', None)


class NodeResponse(msrest.serialization.Model):
    """NodeResponse.

    All required parameters must be populated in order to send to Azure.

    :param id: Required.
    :type id: long
    :param receiver:
    :type receiver: ~smartdiagnostics_sdk.models.ReceiverChild
    :param location: Required.
    :type location: ~smartdiagnostics_sdk.models.LocationChild
    :param corporation: Required.
    :type corporation: ~smartdiagnostics_sdk.models.CorporationChild
    :param serial_number: Required.
    :type serial_number: str
    :param nickname:
    :type nickname: str
    :param firmware_version:
    :type firmware_version: str
    :param node_type_code: Required.  Possible values include: "Invalid", "KcfFlow",
     "KcfPressureVoltage", "KcfPressureCurrent", "KcfPower", "KcfVibration", "KcfVibrationV1",
     "KcfVoltage", "KcfCurrent", "KcfAtoDVoltage", "KcfAtoDCurrent", "KcfOilQuality", "Generic",
     "KcfAgnostic", "KcfHumidity", "KcfExtendedTemperatureVibration", "KcfHubVibrationV1".
    :type node_type_code: str or ~smartdiagnostics_sdk.models.NodeResponseNodeTypeCode
    :param active: Required.
    :type active: bool
    :param created: Required.
    :type created: ~datetime.datetime
    :param updated: Required.
    :type updated: ~datetime.datetime
    :param battery_voltage:
    :type battery_voltage: float
    :param burst_success_rate:
    :type burst_success_rate: float
    :param is_online:
    :type is_online: bool
    :param last_update_time:
    :type last_update_time: ~datetime.datetime
    :param packet_success_rate:
    :type packet_success_rate: float
    :param temperature:
    :type temperature: float
    :param wireless_efficiency:
    :type wireless_efficiency: float
    """

    _validation = {
        'id': {'required': True},
        'location': {'required': True},
        'corporation': {'required': True},
        'serial_number': {'required': True, 'max_length': 8, 'min_length': 0},
        'nickname': {'max_length': 30, 'min_length': 0},
        'node_type_code': {'required': True},
        'active': {'required': True},
        'created': {'required': True},
        'updated': {'required': True},
    }

    _attribute_map = {
        'id': {'key': 'Id', 'type': 'long'},
        'receiver': {'key': 'Receiver', 'type': 'ReceiverChild'},
        'location': {'key': 'Location', 'type': 'LocationChild'},
        'corporation': {'key': 'Corporation', 'type': 'CorporationChild'},
        'serial_number': {'key': 'SerialNumber', 'type': 'str'},
        'nickname': {'key': 'Nickname', 'type': 'str'},
        'firmware_version': {'key': 'FirmwareVersion', 'type': 'str'},
        'node_type_code': {'key': 'NodeTypeCode', 'type': 'str'},
        'active': {'key': 'Active', 'type': 'bool'},
        'created': {'key': 'Created', 'type': 'iso-8601'},
        'updated': {'key': 'Updated', 'type': 'iso-8601'},
        'battery_voltage': {'key': 'BatteryVoltage', 'type': 'float'},
        'burst_success_rate': {'key': 'BurstSuccessRate', 'type': 'float'},
        'is_online': {'key': 'IsOnline', 'type': 'bool'},
        'last_update_time': {'key': 'LastUpdateTime', 'type': 'iso-8601'},
        'packet_success_rate': {'key': 'PacketSuccessRate', 'type': 'float'},
        'temperature': {'key': 'Temperature', 'type': 'float'},
        'wireless_efficiency': {'key': 'WirelessEfficiency', 'type': 'float'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(NodeResponse, self).__init__(**kwargs)
        self.id = kwargs['id']
        self.receiver = kwargs.get('receiver', None)
        self.location = kwargs['location']
        self.corporation = kwargs['corporation']
        self.serial_number = kwargs['serial_number']
        self.nickname = kwargs.get('nickname', None)
        self.firmware_version = kwargs.get('firmware_version', None)
        self.node_type_code = kwargs['node_type_code']
        self.active = kwargs['active']
        self.created = kwargs['created']
        self.updated = kwargs['updated']
        self.battery_voltage = kwargs.get('battery_voltage', None)
        self.burst_success_rate = kwargs.get('burst_success_rate', None)
        self.is_online = kwargs.get('is_online', None)
        self.last_update_time = kwargs.get('last_update_time', None)
        self.packet_success_rate = kwargs.get('packet_success_rate', None)
        self.temperature = kwargs.get('temperature', None)
        self.wireless_efficiency = kwargs.get('wireless_efficiency', None)


class NodeSettingChild(msrest.serialization.Model):
    """NodeSettingChild.

    :param node_setting_name:
    :type node_setting_name: str
    :param node_setting_current_value:
    :type node_setting_current_value: str
    :param node_setting_pending_value:
    :type node_setting_pending_value: str
    """

    _attribute_map = {
        'node_setting_name': {'key': 'NodeSettingName', 'type': 'str'},
        'node_setting_current_value': {'key': 'NodeSettingCurrentValue', 'type': 'str'},
        'node_setting_pending_value': {'key': 'NodeSettingPendingValue', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(NodeSettingChild, self).__init__(**kwargs)
        self.node_setting_name = kwargs.get('node_setting_name', None)
        self.node_setting_current_value = kwargs.get('node_setting_current_value', None)
        self.node_setting_pending_value = kwargs.get('node_setting_pending_value', None)


class NodeStatusChild(msrest.serialization.Model):
    """NodeStatusChild.

    :param outstanding:
    :type outstanding: int
    :param deployed:
    :type deployed: int
    :param lock_out_tag_out:
    :type lock_out_tag_out: int
    :param spare_devices:
    :type spare_devices: int
    :param special_access_required:
    :type special_access_required: int
    """

    _attribute_map = {
        'outstanding': {'key': 'Outstanding', 'type': 'int'},
        'deployed': {'key': 'Deployed', 'type': 'int'},
        'lock_out_tag_out': {'key': 'LockOutTagOut', 'type': 'int'},
        'spare_devices': {'key': 'SpareDevices', 'type': 'int'},
        'special_access_required': {'key': 'SpecialAccessRequired', 'type': 'int'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(NodeStatusChild, self).__init__(**kwargs)
        self.outstanding = kwargs.get('outstanding', None)
        self.deployed = kwargs.get('deployed', None)
        self.lock_out_tag_out = kwargs.get('lock_out_tag_out', None)
        self.spare_devices = kwargs.get('spare_devices', None)
        self.special_access_required = kwargs.get('special_access_required', None)


class PagedResultsModelAnalyticsModelResponse(msrest.serialization.Model):
    """PagedResultsModelAnalyticsModelResponse.

    :param result: Contains a list of paged items.
    :type result: list[~smartdiagnostics_sdk.models.AnalyticsModelResponse]
    :param total: The total number of items returned from a query (not just those in the paged
     results list).
    :type total: int
    :param total_pages: The total number of pages of items that will be returned.
    :type total_pages: int
    """

    _attribute_map = {
        'result': {'key': 'Result', 'type': '[AnalyticsModelResponse]'},
        'total': {'key': 'Total', 'type': 'int'},
        'total_pages': {'key': 'TotalPages', 'type': 'int'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(PagedResultsModelAnalyticsModelResponse, self).__init__(**kwargs)
        self.result = kwargs.get('result', None)
        self.total = kwargs.get('total', None)
        self.total_pages = kwargs.get('total_pages', None)


class PagedResultsModelAssetResponse(msrest.serialization.Model):
    """PagedResultsModelAssetResponse.

    :param result: Contains a list of paged items.
    :type result: list[~smartdiagnostics_sdk.models.AssetResponse]
    :param total: The total number of items returned from a query (not just those in the paged
     results list).
    :type total: int
    :param total_pages: The total number of pages of items that will be returned.
    :type total_pages: int
    """

    _attribute_map = {
        'result': {'key': 'Result', 'type': '[AssetResponse]'},
        'total': {'key': 'Total', 'type': 'int'},
        'total_pages': {'key': 'TotalPages', 'type': 'int'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(PagedResultsModelAssetResponse, self).__init__(**kwargs)
        self.result = kwargs.get('result', None)
        self.total = kwargs.get('total', None)
        self.total_pages = kwargs.get('total_pages', None)


class PagedResultsModelAssetTypeResponse(msrest.serialization.Model):
    """PagedResultsModelAssetTypeResponse.

    :param result: Contains a list of paged items.
    :type result: list[~smartdiagnostics_sdk.models.AssetTypeResponse]
    :param total: The total number of items returned from a query (not just those in the paged
     results list).
    :type total: int
    :param total_pages: The total number of pages of items that will be returned.
    :type total_pages: int
    """

    _attribute_map = {
        'result': {'key': 'Result', 'type': '[AssetTypeResponse]'},
        'total': {'key': 'Total', 'type': 'int'},
        'total_pages': {'key': 'TotalPages', 'type': 'int'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(PagedResultsModelAssetTypeResponse, self).__init__(**kwargs)
        self.result = kwargs.get('result', None)
        self.total = kwargs.get('total', None)
        self.total_pages = kwargs.get('total_pages', None)


class PagedResultsModelBaseStationResponse(msrest.serialization.Model):
    """PagedResultsModelBaseStationResponse.

    :param result: Contains a list of paged items.
    :type result: list[~smartdiagnostics_sdk.models.BaseStationResponse]
    :param total: The total number of items returned from a query (not just those in the paged
     results list).
    :type total: int
    :param total_pages: The total number of pages of items that will be returned.
    :type total_pages: int
    """

    _attribute_map = {
        'result': {'key': 'Result', 'type': '[BaseStationResponse]'},
        'total': {'key': 'Total', 'type': 'int'},
        'total_pages': {'key': 'TotalPages', 'type': 'int'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(PagedResultsModelBaseStationResponse, self).__init__(**kwargs)
        self.result = kwargs.get('result', None)
        self.total = kwargs.get('total', None)
        self.total_pages = kwargs.get('total_pages', None)


class PagedResultsModelBearingResponse(msrest.serialization.Model):
    """PagedResultsModelBearingResponse.

    :param result: Contains a list of paged items.
    :type result: list[~smartdiagnostics_sdk.models.BearingResponse]
    :param total: The total number of items returned from a query (not just those in the paged
     results list).
    :type total: int
    :param total_pages: The total number of pages of items that will be returned.
    :type total_pages: int
    """

    _attribute_map = {
        'result': {'key': 'Result', 'type': '[BearingResponse]'},
        'total': {'key': 'Total', 'type': 'int'},
        'total_pages': {'key': 'TotalPages', 'type': 'int'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(PagedResultsModelBearingResponse, self).__init__(**kwargs)
        self.result = kwargs.get('result', None)
        self.total = kwargs.get('total', None)
        self.total_pages = kwargs.get('total_pages', None)


class PagedResultsModelCorporationResponse(msrest.serialization.Model):
    """PagedResultsModelCorporationResponse.

    :param result: Contains a list of paged items.
    :type result: list[~smartdiagnostics_sdk.models.CorporationResponse]
    :param total: The total number of items returned from a query (not just those in the paged
     results list).
    :type total: int
    :param total_pages: The total number of pages of items that will be returned.
    :type total_pages: int
    """

    _attribute_map = {
        'result': {'key': 'Result', 'type': '[CorporationResponse]'},
        'total': {'key': 'Total', 'type': 'int'},
        'total_pages': {'key': 'TotalPages', 'type': 'int'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(PagedResultsModelCorporationResponse, self).__init__(**kwargs)
        self.result = kwargs.get('result', None)
        self.total = kwargs.get('total', None)
        self.total_pages = kwargs.get('total_pages', None)


class PagedResultsModelDashboardResponse(msrest.serialization.Model):
    """PagedResultsModelDashboardResponse.

    :param result: Contains a list of paged items.
    :type result: list[~smartdiagnostics_sdk.models.DashboardResponse]
    :param total: The total number of items returned from a query (not just those in the paged
     results list).
    :type total: int
    :param total_pages: The total number of pages of items that will be returned.
    :type total_pages: int
    """

    _attribute_map = {
        'result': {'key': 'Result', 'type': '[DashboardResponse]'},
        'total': {'key': 'Total', 'type': 'int'},
        'total_pages': {'key': 'TotalPages', 'type': 'int'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(PagedResultsModelDashboardResponse, self).__init__(**kwargs)
        self.result = kwargs.get('result', None)
        self.total = kwargs.get('total', None)
        self.total_pages = kwargs.get('total_pages', None)


class PagedResultsModelDashboardTemplateResponse(msrest.serialization.Model):
    """PagedResultsModelDashboardTemplateResponse.

    :param result: Contains a list of paged items.
    :type result: list[~smartdiagnostics_sdk.models.DashboardTemplateResponse]
    :param total: The total number of items returned from a query (not just those in the paged
     results list).
    :type total: int
    :param total_pages: The total number of pages of items that will be returned.
    :type total_pages: int
    """

    _attribute_map = {
        'result': {'key': 'Result', 'type': '[DashboardTemplateResponse]'},
        'total': {'key': 'Total', 'type': 'int'},
        'total_pages': {'key': 'TotalPages', 'type': 'int'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(PagedResultsModelDashboardTemplateResponse, self).__init__(**kwargs)
        self.result = kwargs.get('result', None)
        self.total = kwargs.get('total', None)
        self.total_pages = kwargs.get('total_pages', None)


class PagedResultsModelFileResponse(msrest.serialization.Model):
    """PagedResultsModelFileResponse.

    :param result: Contains a list of paged items.
    :type result: list[~smartdiagnostics_sdk.models.FileResponse]
    :param total: The total number of items returned from a query (not just those in the paged
     results list).
    :type total: int
    :param total_pages: The total number of pages of items that will be returned.
    :type total_pages: int
    """

    _attribute_map = {
        'result': {'key': 'Result', 'type': '[FileResponse]'},
        'total': {'key': 'Total', 'type': 'int'},
        'total_pages': {'key': 'TotalPages', 'type': 'int'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(PagedResultsModelFileResponse, self).__init__(**kwargs)
        self.result = kwargs.get('result', None)
        self.total = kwargs.get('total', None)
        self.total_pages = kwargs.get('total_pages', None)


class PagedResultsModelGroupAlertsResponse(msrest.serialization.Model):
    """PagedResultsModelGroupAlertsResponse.

    :param result: Contains a list of paged items.
    :type result: list[~smartdiagnostics_sdk.models.GroupAlertsResponse]
    :param total: The total number of items returned from a query (not just those in the paged
     results list).
    :type total: int
    :param total_pages: The total number of pages of items that will be returned.
    :type total_pages: int
    """

    _attribute_map = {
        'result': {'key': 'Result', 'type': '[GroupAlertsResponse]'},
        'total': {'key': 'Total', 'type': 'int'},
        'total_pages': {'key': 'TotalPages', 'type': 'int'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(PagedResultsModelGroupAlertsResponse, self).__init__(**kwargs)
        self.result = kwargs.get('result', None)
        self.total = kwargs.get('total', None)
        self.total_pages = kwargs.get('total_pages', None)


class PagedResultsModelGroupStatusResponse(msrest.serialization.Model):
    """PagedResultsModelGroupStatusResponse.

    :param result: Contains a list of paged items.
    :type result: list[~smartdiagnostics_sdk.models.GroupStatusResponse]
    :param total: The total number of items returned from a query (not just those in the paged
     results list).
    :type total: int
    :param total_pages: The total number of pages of items that will be returned.
    :type total_pages: int
    """

    _attribute_map = {
        'result': {'key': 'Result', 'type': '[GroupStatusResponse]'},
        'total': {'key': 'Total', 'type': 'int'},
        'total_pages': {'key': 'TotalPages', 'type': 'int'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(PagedResultsModelGroupStatusResponse, self).__init__(**kwargs)
        self.result = kwargs.get('result', None)
        self.total = kwargs.get('total', None)
        self.total_pages = kwargs.get('total_pages', None)


class PagedResultsModelHardwareEventModelV3(msrest.serialization.Model):
    """PagedResultsModelHardwareEventModelV3.

    :param result: Contains a list of paged items.
    :type result: list[~smartdiagnostics_sdk.models.HardwareEventModelV3]
    :param total: The total number of items returned from a query (not just those in the paged
     results list).
    :type total: int
    :param total_pages: The total number of pages of items that will be returned.
    :type total_pages: int
    """

    _attribute_map = {
        'result': {'key': 'Result', 'type': '[HardwareEventModelV3]'},
        'total': {'key': 'Total', 'type': 'int'},
        'total_pages': {'key': 'TotalPages', 'type': 'int'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(PagedResultsModelHardwareEventModelV3, self).__init__(**kwargs)
        self.result = kwargs.get('result', None)
        self.total = kwargs.get('total', None)
        self.total_pages = kwargs.get('total_pages', None)


class PagedResultsModelHubResponse(msrest.serialization.Model):
    """PagedResultsModelHubResponse.

    :param result: Contains a list of paged items.
    :type result: list[~smartdiagnostics_sdk.models.HubResponse]
    :param total: The total number of items returned from a query (not just those in the paged
     results list).
    :type total: int
    :param total_pages: The total number of pages of items that will be returned.
    :type total_pages: int
    """

    _attribute_map = {
        'result': {'key': 'Result', 'type': '[HubResponse]'},
        'total': {'key': 'Total', 'type': 'int'},
        'total_pages': {'key': 'TotalPages', 'type': 'int'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(PagedResultsModelHubResponse, self).__init__(**kwargs)
        self.result = kwargs.get('result', None)
        self.total = kwargs.get('total', None)
        self.total_pages = kwargs.get('total_pages', None)


class PagedResultsModelIndicatorFilterResponse(msrest.serialization.Model):
    """PagedResultsModelIndicatorFilterResponse.

    :param result: Contains a list of paged items.
    :type result: list[~smartdiagnostics_sdk.models.IndicatorFilterResponse]
    :param total: The total number of items returned from a query (not just those in the paged
     results list).
    :type total: int
    :param total_pages: The total number of pages of items that will be returned.
    :type total_pages: int
    """

    _attribute_map = {
        'result': {'key': 'Result', 'type': '[IndicatorFilterResponse]'},
        'total': {'key': 'Total', 'type': 'int'},
        'total_pages': {'key': 'TotalPages', 'type': 'int'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(PagedResultsModelIndicatorFilterResponse, self).__init__(**kwargs)
        self.result = kwargs.get('result', None)
        self.total = kwargs.get('total', None)
        self.total_pages = kwargs.get('total_pages', None)


class PagedResultsModelIndicatorGroupResponse(msrest.serialization.Model):
    """PagedResultsModelIndicatorGroupResponse.

    :param result: Contains a list of paged items.
    :type result: list[~smartdiagnostics_sdk.models.IndicatorGroupResponse]
    :param total: The total number of items returned from a query (not just those in the paged
     results list).
    :type total: int
    :param total_pages: The total number of pages of items that will be returned.
    :type total_pages: int
    """

    _attribute_map = {
        'result': {'key': 'Result', 'type': '[IndicatorGroupResponse]'},
        'total': {'key': 'Total', 'type': 'int'},
        'total_pages': {'key': 'TotalPages', 'type': 'int'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(PagedResultsModelIndicatorGroupResponse, self).__init__(**kwargs)
        self.result = kwargs.get('result', None)
        self.total = kwargs.get('total', None)
        self.total_pages = kwargs.get('total_pages', None)


class PagedResultsModelIndicatorResponse(msrest.serialization.Model):
    """PagedResultsModelIndicatorResponse.

    :param result: Contains a list of paged items.
    :type result: list[~smartdiagnostics_sdk.models.IndicatorResponse]
    :param total: The total number of items returned from a query (not just those in the paged
     results list).
    :type total: int
    :param total_pages: The total number of pages of items that will be returned.
    :type total_pages: int
    """

    _attribute_map = {
        'result': {'key': 'Result', 'type': '[IndicatorResponse]'},
        'total': {'key': 'Total', 'type': 'int'},
        'total_pages': {'key': 'TotalPages', 'type': 'int'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(PagedResultsModelIndicatorResponse, self).__init__(**kwargs)
        self.result = kwargs.get('result', None)
        self.total = kwargs.get('total', None)
        self.total_pages = kwargs.get('total_pages', None)


class PagedResultsModelIndicatorTypesResponse(msrest.serialization.Model):
    """PagedResultsModelIndicatorTypesResponse.

    :param result: Contains a list of paged items.
    :type result: list[~smartdiagnostics_sdk.models.IndicatorTypesResponse]
    :param total: The total number of items returned from a query (not just those in the paged
     results list).
    :type total: int
    :param total_pages: The total number of pages of items that will be returned.
    :type total_pages: int
    """

    _attribute_map = {
        'result': {'key': 'Result', 'type': '[IndicatorTypesResponse]'},
        'total': {'key': 'Total', 'type': 'int'},
        'total_pages': {'key': 'TotalPages', 'type': 'int'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(PagedResultsModelIndicatorTypesResponse, self).__init__(**kwargs)
        self.result = kwargs.get('result', None)
        self.total = kwargs.get('total', None)
        self.total_pages = kwargs.get('total_pages', None)


class PagedResultsModelInstallNodeResponse(msrest.serialization.Model):
    """PagedResultsModelInstallNodeResponse.

    :param result: Contains a list of paged items.
    :type result: list[~smartdiagnostics_sdk.models.InstallNodeResponse]
    :param total: The total number of items returned from a query (not just those in the paged
     results list).
    :type total: int
    :param total_pages: The total number of pages of items that will be returned.
    :type total_pages: int
    """

    _attribute_map = {
        'result': {'key': 'Result', 'type': '[InstallNodeResponse]'},
        'total': {'key': 'Total', 'type': 'int'},
        'total_pages': {'key': 'TotalPages', 'type': 'int'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(PagedResultsModelInstallNodeResponse, self).__init__(**kwargs)
        self.result = kwargs.get('result', None)
        self.total = kwargs.get('total', None)
        self.total_pages = kwargs.get('total_pages', None)


class PagedResultsModelInstallResponse(msrest.serialization.Model):
    """PagedResultsModelInstallResponse.

    :param result: Contains a list of paged items.
    :type result: list[~smartdiagnostics_sdk.models.InstallResponse]
    :param total: The total number of items returned from a query (not just those in the paged
     results list).
    :type total: int
    :param total_pages: The total number of pages of items that will be returned.
    :type total_pages: int
    """

    _attribute_map = {
        'result': {'key': 'Result', 'type': '[InstallResponse]'},
        'total': {'key': 'Total', 'type': 'int'},
        'total_pages': {'key': 'TotalPages', 'type': 'int'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(PagedResultsModelInstallResponse, self).__init__(**kwargs)
        self.result = kwargs.get('result', None)
        self.total = kwargs.get('total', None)
        self.total_pages = kwargs.get('total_pages', None)


class PagedResultsModelLocationResponse(msrest.serialization.Model):
    """PagedResultsModelLocationResponse.

    :param result: Contains a list of paged items.
    :type result: list[~smartdiagnostics_sdk.models.LocationResponse]
    :param total: The total number of items returned from a query (not just those in the paged
     results list).
    :type total: int
    :param total_pages: The total number of pages of items that will be returned.
    :type total_pages: int
    """

    _attribute_map = {
        'result': {'key': 'Result', 'type': '[LocationResponse]'},
        'total': {'key': 'Total', 'type': 'int'},
        'total_pages': {'key': 'TotalPages', 'type': 'int'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(PagedResultsModelLocationResponse, self).__init__(**kwargs)
        self.result = kwargs.get('result', None)
        self.total = kwargs.get('total', None)
        self.total_pages = kwargs.get('total_pages', None)


class PagedResultsModelMarkerResponse(msrest.serialization.Model):
    """PagedResultsModelMarkerResponse.

    :param result: Contains a list of paged items.
    :type result: list[~smartdiagnostics_sdk.models.MarkerResponse]
    :param total: The total number of items returned from a query (not just those in the paged
     results list).
    :type total: int
    :param total_pages: The total number of pages of items that will be returned.
    :type total_pages: int
    """

    _attribute_map = {
        'result': {'key': 'Result', 'type': '[MarkerResponse]'},
        'total': {'key': 'Total', 'type': 'int'},
        'total_pages': {'key': 'TotalPages', 'type': 'int'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(PagedResultsModelMarkerResponse, self).__init__(**kwargs)
        self.result = kwargs.get('result', None)
        self.total = kwargs.get('total', None)
        self.total_pages = kwargs.get('total_pages', None)


class PagedResultsModelMonitoringPointResponse(msrest.serialization.Model):
    """PagedResultsModelMonitoringPointResponse.

    :param result: Contains a list of paged items.
    :type result: list[~smartdiagnostics_sdk.models.MonitoringPointResponse]
    :param total: The total number of items returned from a query (not just those in the paged
     results list).
    :type total: int
    :param total_pages: The total number of pages of items that will be returned.
    :type total_pages: int
    """

    _attribute_map = {
        'result': {'key': 'Result', 'type': '[MonitoringPointResponse]'},
        'total': {'key': 'Total', 'type': 'int'},
        'total_pages': {'key': 'TotalPages', 'type': 'int'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(PagedResultsModelMonitoringPointResponse, self).__init__(**kwargs)
        self.result = kwargs.get('result', None)
        self.total = kwargs.get('total', None)
        self.total_pages = kwargs.get('total_pages', None)


class PagedResultsModelNodeResponse(msrest.serialization.Model):
    """PagedResultsModelNodeResponse.

    :param result: Contains a list of paged items.
    :type result: list[~smartdiagnostics_sdk.models.NodeResponse]
    :param total: The total number of items returned from a query (not just those in the paged
     results list).
    :type total: int
    :param total_pages: The total number of pages of items that will be returned.
    :type total_pages: int
    """

    _attribute_map = {
        'result': {'key': 'Result', 'type': '[NodeResponse]'},
        'total': {'key': 'Total', 'type': 'int'},
        'total_pages': {'key': 'TotalPages', 'type': 'int'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(PagedResultsModelNodeResponse, self).__init__(**kwargs)
        self.result = kwargs.get('result', None)
        self.total = kwargs.get('total', None)
        self.total_pages = kwargs.get('total_pages', None)


class PagedResultsModelPersonalAccessTokenResponse(msrest.serialization.Model):
    """PagedResultsModelPersonalAccessTokenResponse.

    :param result: Contains a list of paged items.
    :type result: list[~smartdiagnostics_sdk.models.PersonalAccessTokenResponse]
    :param total: The total number of items returned from a query (not just those in the paged
     results list).
    :type total: int
    :param total_pages: The total number of pages of items that will be returned.
    :type total_pages: int
    """

    _attribute_map = {
        'result': {'key': 'Result', 'type': '[PersonalAccessTokenResponse]'},
        'total': {'key': 'Total', 'type': 'int'},
        'total_pages': {'key': 'TotalPages', 'type': 'int'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(PagedResultsModelPersonalAccessTokenResponse, self).__init__(**kwargs)
        self.result = kwargs.get('result', None)
        self.total = kwargs.get('total', None)
        self.total_pages = kwargs.get('total_pages', None)


class PagedResultsModelPicturesModelV3(msrest.serialization.Model):
    """PagedResultsModelPicturesModelV3.

    :param result: Contains a list of paged items.
    :type result: list[~smartdiagnostics_sdk.models.PicturesModelV3]
    :param total: The total number of items returned from a query (not just those in the paged
     results list).
    :type total: int
    :param total_pages: The total number of pages of items that will be returned.
    :type total_pages: int
    """

    _attribute_map = {
        'result': {'key': 'Result', 'type': '[PicturesModelV3]'},
        'total': {'key': 'Total', 'type': 'int'},
        'total_pages': {'key': 'TotalPages', 'type': 'int'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(PagedResultsModelPicturesModelV3, self).__init__(**kwargs)
        self.result = kwargs.get('result', None)
        self.total = kwargs.get('total', None)
        self.total_pages = kwargs.get('total_pages', None)


class PagedResultsModelPropertyResponse(msrest.serialization.Model):
    """PagedResultsModelPropertyResponse.

    :param result: Contains a list of paged items.
    :type result: list[~smartdiagnostics_sdk.models.PropertyResponse]
    :param total: The total number of items returned from a query (not just those in the paged
     results list).
    :type total: int
    :param total_pages: The total number of pages of items that will be returned.
    :type total_pages: int
    """

    _attribute_map = {
        'result': {'key': 'Result', 'type': '[PropertyResponse]'},
        'total': {'key': 'Total', 'type': 'int'},
        'total_pages': {'key': 'TotalPages', 'type': 'int'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(PagedResultsModelPropertyResponse, self).__init__(**kwargs)
        self.result = kwargs.get('result', None)
        self.total = kwargs.get('total', None)
        self.total_pages = kwargs.get('total_pages', None)


class PagedResultsModelReceiverResponse(msrest.serialization.Model):
    """PagedResultsModelReceiverResponse.

    :param result: Contains a list of paged items.
    :type result: list[~smartdiagnostics_sdk.models.ReceiverResponse]
    :param total: The total number of items returned from a query (not just those in the paged
     results list).
    :type total: int
    :param total_pages: The total number of pages of items that will be returned.
    :type total_pages: int
    """

    _attribute_map = {
        'result': {'key': 'Result', 'type': '[ReceiverResponse]'},
        'total': {'key': 'Total', 'type': 'int'},
        'total_pages': {'key': 'TotalPages', 'type': 'int'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(PagedResultsModelReceiverResponse, self).__init__(**kwargs)
        self.result = kwargs.get('result', None)
        self.total = kwargs.get('total', None)
        self.total_pages = kwargs.get('total_pages', None)


class PagedResultsModelRepeaterModelV3(msrest.serialization.Model):
    """PagedResultsModelRepeaterModelV3.

    :param result: Contains a list of paged items.
    :type result: list[~smartdiagnostics_sdk.models.RepeaterModelV3]
    :param total: The total number of items returned from a query (not just those in the paged
     results list).
    :type total: int
    :param total_pages: The total number of pages of items that will be returned.
    :type total_pages: int
    """

    _attribute_map = {
        'result': {'key': 'Result', 'type': '[RepeaterModelV3]'},
        'total': {'key': 'Total', 'type': 'int'},
        'total_pages': {'key': 'TotalPages', 'type': 'int'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(PagedResultsModelRepeaterModelV3, self).__init__(**kwargs)
        self.result = kwargs.get('result', None)
        self.total = kwargs.get('total', None)
        self.total_pages = kwargs.get('total_pages', None)


class PagedResultsModelSubSystemResponse(msrest.serialization.Model):
    """PagedResultsModelSubSystemResponse.

    :param result: Contains a list of paged items.
    :type result: list[~smartdiagnostics_sdk.models.SubSystemResponse]
    :param total: The total number of items returned from a query (not just those in the paged
     results list).
    :type total: int
    :param total_pages: The total number of pages of items that will be returned.
    :type total_pages: int
    """

    _attribute_map = {
        'result': {'key': 'Result', 'type': '[SubSystemResponse]'},
        'total': {'key': 'Total', 'type': 'int'},
        'total_pages': {'key': 'TotalPages', 'type': 'int'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(PagedResultsModelSubSystemResponse, self).__init__(**kwargs)
        self.result = kwargs.get('result', None)
        self.total = kwargs.get('total', None)
        self.total_pages = kwargs.get('total_pages', None)


class PagedResultsModelSystemAssetsStatusSummaryResponse(msrest.serialization.Model):
    """PagedResultsModelSystemAssetsStatusSummaryResponse.

    :param result: Contains a list of paged items.
    :type result: list[~smartdiagnostics_sdk.models.SystemAssetsStatusSummaryResponse]
    :param total: The total number of items returned from a query (not just those in the paged
     results list).
    :type total: int
    :param total_pages: The total number of pages of items that will be returned.
    :type total_pages: int
    """

    _attribute_map = {
        'result': {'key': 'Result', 'type': '[SystemAssetsStatusSummaryResponse]'},
        'total': {'key': 'Total', 'type': 'int'},
        'total_pages': {'key': 'TotalPages', 'type': 'int'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(PagedResultsModelSystemAssetsStatusSummaryResponse, self).__init__(**kwargs)
        self.result = kwargs.get('result', None)
        self.total = kwargs.get('total', None)
        self.total_pages = kwargs.get('total_pages', None)


class PagedResultsModelSystemResponse(msrest.serialization.Model):
    """PagedResultsModelSystemResponse.

    :param result: Contains a list of paged items.
    :type result: list[~smartdiagnostics_sdk.models.SystemResponse]
    :param total: The total number of items returned from a query (not just those in the paged
     results list).
    :type total: int
    :param total_pages: The total number of pages of items that will be returned.
    :type total_pages: int
    """

    _attribute_map = {
        'result': {'key': 'Result', 'type': '[SystemResponse]'},
        'total': {'key': 'Total', 'type': 'int'},
        'total_pages': {'key': 'TotalPages', 'type': 'int'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(PagedResultsModelSystemResponse, self).__init__(**kwargs)
        self.result = kwargs.get('result', None)
        self.total = kwargs.get('total', None)
        self.total_pages = kwargs.get('total_pages', None)


class PagedResultsModelTagResponse(msrest.serialization.Model):
    """PagedResultsModelTagResponse.

    :param result: Contains a list of paged items.
    :type result: list[~smartdiagnostics_sdk.models.TagResponse]
    :param total: The total number of items returned from a query (not just those in the paged
     results list).
    :type total: int
    :param total_pages: The total number of pages of items that will be returned.
    :type total_pages: int
    """

    _attribute_map = {
        'result': {'key': 'Result', 'type': '[TagResponse]'},
        'total': {'key': 'Total', 'type': 'int'},
        'total_pages': {'key': 'TotalPages', 'type': 'int'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(PagedResultsModelTagResponse, self).__init__(**kwargs)
        self.result = kwargs.get('result', None)
        self.total = kwargs.get('total', None)
        self.total_pages = kwargs.get('total_pages', None)


class PagedResultsModelTreeItemAvailableAssetClassResponse(msrest.serialization.Model):
    """PagedResultsModelTreeItemAvailableAssetClassResponse.

    :param result: Contains a list of paged items.
    :type result: list[~smartdiagnostics_sdk.models.TreeItemAvailableAssetClassResponse]
    :param total: The total number of items returned from a query (not just those in the paged
     results list).
    :type total: int
    :param total_pages: The total number of pages of items that will be returned.
    :type total_pages: int
    """

    _attribute_map = {
        'result': {'key': 'Result', 'type': '[TreeItemAvailableAssetClassResponse]'},
        'total': {'key': 'Total', 'type': 'int'},
        'total_pages': {'key': 'TotalPages', 'type': 'int'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(PagedResultsModelTreeItemAvailableAssetClassResponse, self).__init__(**kwargs)
        self.result = kwargs.get('result', None)
        self.total = kwargs.get('total', None)
        self.total_pages = kwargs.get('total_pages', None)


class PagedResultsModelTreeItemResponse(msrest.serialization.Model):
    """PagedResultsModelTreeItemResponse.

    :param result: Contains a list of paged items.
    :type result: list[~smartdiagnostics_sdk.models.TreeItemResponse]
    :param total: The total number of items returned from a query (not just those in the paged
     results list).
    :type total: int
    :param total_pages: The total number of pages of items that will be returned.
    :type total_pages: int
    """

    _attribute_map = {
        'result': {'key': 'Result', 'type': '[TreeItemResponse]'},
        'total': {'key': 'Total', 'type': 'int'},
        'total_pages': {'key': 'TotalPages', 'type': 'int'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(PagedResultsModelTreeItemResponse, self).__init__(**kwargs)
        self.result = kwargs.get('result', None)
        self.total = kwargs.get('total', None)
        self.total_pages = kwargs.get('total_pages', None)


class ParentChild(msrest.serialization.Model):
    """ParentChild.

    :param parent_id:
    :type parent_id: str
    :param parent_name:
    :type parent_name: str
    :param parent_abbreviation:
    :type parent_abbreviation: str
    :param parent_type:
    :type parent_type: str
    """

    _attribute_map = {
        'parent_id': {'key': 'ParentId', 'type': 'str'},
        'parent_name': {'key': 'ParentName', 'type': 'str'},
        'parent_abbreviation': {'key': 'ParentAbbreviation', 'type': 'str'},
        'parent_type': {'key': 'ParentType', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(ParentChild, self).__init__(**kwargs)
        self.parent_id = kwargs.get('parent_id', None)
        self.parent_name = kwargs.get('parent_name', None)
        self.parent_abbreviation = kwargs.get('parent_abbreviation', None)
        self.parent_type = kwargs.get('parent_type', None)


class Paths13L8SxgApiV30CorporationsIdIconPostRequestbodyContentMultipartFormDataSchema(msrest.serialization.Model):
    """Paths13L8SxgApiV30CorporationsIdIconPostRequestbodyContentMultipartFormDataSchema.

    :param file: The image file to upload.
    :type file: IO
    """

    _attribute_map = {
        'file': {'key': 'file', 'type': 'IO'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(Paths13L8SxgApiV30CorporationsIdIconPostRequestbodyContentMultipartFormDataSchema, self).__init__(**kwargs)
        self.file = kwargs.get('file', None)


class Paths1I3IipnApiV30SetuptoolsJobtypePostRequestbodyContentMultipartFormDataSchema(msrest.serialization.Model):
    """Paths1I3IipnApiV30SetuptoolsJobtypePostRequestbodyContentMultipartFormDataSchema.

    :param location_id: The location to run the job for.
    :type location_id: str
    :param file: The file to be processed.
    :type file: IO
    """

    _attribute_map = {
        'location_id': {'key': 'locationId', 'type': 'str'},
        'file': {'key': 'file', 'type': 'IO'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(Paths1I3IipnApiV30SetuptoolsJobtypePostRequestbodyContentMultipartFormDataSchema, self).__init__(**kwargs)
        self.location_id = kwargs.get('location_id', None)
        self.file = kwargs.get('file', None)


class PathsVkexhnApiV30FilesPostRequestbodyContentMultipartFormDataSchema(msrest.serialization.Model):
    """PathsVkexhnApiV30FilesPostRequestbodyContentMultipartFormDataSchema.

    All required parameters must be populated in order to send to Azure.

    :param type: Required. Type of file. Possible values include: "Invalid", "Picture", "Folder".
    :type type: str or ~smartdiagnostics_sdk.models.PostContentSchemaType
    :param display_name: Name of file.
    :type display_name: str
    :param parent_folder_id: Required. The id of the folder that the file is inside of.
    :type parent_folder_id: str
    :param description: File Description.
    :type description: str
    :param location_id: Location id of file.
    :type location_id: str
    :param corporation_id: Corporation id of file.
    :type corporation_id: str
    :param group_ids: Ids of groups the file belongs to.
    :type group_ids: list[str]
    :param files: The file that will be associated with the file model object.
    :type files: IO
    """

    _validation = {
        'type': {'required': True},
        'parent_folder_id': {'required': True},
    }

    _attribute_map = {
        'type': {'key': 'Type', 'type': 'str'},
        'display_name': {'key': 'DisplayName', 'type': 'str'},
        'parent_folder_id': {'key': 'ParentFolderId', 'type': 'str'},
        'description': {'key': 'Description', 'type': 'str'},
        'location_id': {'key': 'LocationId', 'type': 'str'},
        'corporation_id': {'key': 'CorporationId', 'type': 'str'},
        'group_ids': {'key': 'GroupIds', 'type': '[str]'},
        'files': {'key': 'files', 'type': 'IO'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(PathsVkexhnApiV30FilesPostRequestbodyContentMultipartFormDataSchema, self).__init__(**kwargs)
        self.type = kwargs['type']
        self.display_name = kwargs.get('display_name', None)
        self.parent_folder_id = kwargs['parent_folder_id']
        self.description = kwargs.get('description', None)
        self.location_id = kwargs.get('location_id', None)
        self.corporation_id = kwargs.get('corporation_id', None)
        self.group_ids = kwargs.get('group_ids', None)
        self.files = kwargs.get('files', None)


class PersonalAccessTokenCreateRequest(msrest.serialization.Model):
    """PersonalAccessTokenCreateRequest.

    All required parameters must be populated in order to send to Azure.

    :param description: Required.
    :type description: str
    """

    _validation = {
        'description': {'required': True},
    }

    _attribute_map = {
        'description': {'key': 'Description', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(PersonalAccessTokenCreateRequest, self).__init__(**kwargs)
        self.description = kwargs['description']


class PersonalAccessTokenCreateResponse(msrest.serialization.Model):
    """PersonalAccessTokenCreateResponse.

    :param id:
    :type id: str
    :param description:
    :type description: str
    :param token:
    :type token: str
    :param note:
    :type note: str
    """

    _attribute_map = {
        'id': {'key': 'Id', 'type': 'str'},
        'description': {'key': 'Description', 'type': 'str'},
        'token': {'key': 'Token', 'type': 'str'},
        'note': {'key': 'Note', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(PersonalAccessTokenCreateResponse, self).__init__(**kwargs)
        self.id = kwargs.get('id', None)
        self.description = kwargs.get('description', None)
        self.token = kwargs.get('token', None)
        self.note = kwargs.get('note', None)


class PersonalAccessTokenResponse(msrest.serialization.Model):
    """PersonalAccessTokenResponse.

    :param id:
    :type id: str
    :param description:
    :type description: str
    :param created:
    :type created: ~datetime.datetime
    :param updated:
    :type updated: ~datetime.datetime
    :param last_used:
    :type last_used: ~datetime.datetime
    :param active:
    :type active: bool
    """

    _attribute_map = {
        'id': {'key': 'Id', 'type': 'str'},
        'description': {'key': 'Description', 'type': 'str'},
        'created': {'key': 'Created', 'type': 'iso-8601'},
        'updated': {'key': 'Updated', 'type': 'iso-8601'},
        'last_used': {'key': 'LastUsed', 'type': 'iso-8601'},
        'active': {'key': 'Active', 'type': 'bool'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(PersonalAccessTokenResponse, self).__init__(**kwargs)
        self.id = kwargs.get('id', None)
        self.description = kwargs.get('description', None)
        self.created = kwargs.get('created', None)
        self.updated = kwargs.get('updated', None)
        self.last_used = kwargs.get('last_used', None)
        self.active = kwargs.get('active', None)


class PersonalAccessTokenUpdateRequest(msrest.serialization.Model):
    """PersonalAccessTokenUpdateRequest.

    All required parameters must be populated in order to send to Azure.

    :param description: Required.
    :type description: str
    """

    _validation = {
        'description': {'required': True},
    }

    _attribute_map = {
        'description': {'key': 'Description', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(PersonalAccessTokenUpdateRequest, self).__init__(**kwargs)
        self.description = kwargs['description']


class PicturesModelV3(msrest.serialization.Model):
    """PicturesModelV3.

    All required parameters must be populated in order to send to Azure.

    :param id: Required.
    :type id: str
    :param description:
    :type description: str
    :param name:
    :type name: str
    :param image_file_name:
    :type image_file_name: str
    :param thumbnail_file_name:
    :type thumbnail_file_name: str
    :param attachment:
    :type attachment: ~smartdiagnostics_sdk.models.AttachmentModelV3
    """

    _validation = {
        'id': {'required': True},
    }

    _attribute_map = {
        'id': {'key': 'Id', 'type': 'str'},
        'description': {'key': 'Description', 'type': 'str'},
        'name': {'key': 'Name', 'type': 'str'},
        'image_file_name': {'key': 'ImageFileName', 'type': 'str'},
        'thumbnail_file_name': {'key': 'ThumbnailFileName', 'type': 'str'},
        'attachment': {'key': 'Attachment', 'type': 'AttachmentModelV3'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(PicturesModelV3, self).__init__(**kwargs)
        self.id = kwargs['id']
        self.description = kwargs.get('description', None)
        self.name = kwargs.get('name', None)
        self.image_file_name = kwargs.get('image_file_name', None)
        self.thumbnail_file_name = kwargs.get('thumbnail_file_name', None)
        self.attachment = kwargs.get('attachment', None)


class PowerBiReportChild(msrest.serialization.Model):
    """PowerBiReportChild.

    :param power_bi_report_access_token:
    :type power_bi_report_access_token: str
    :param power_bi_report_name:
    :type power_bi_report_name: str
    :param power_bi_report_url:
    :type power_bi_report_url: str
    :param power_bi_report_embed_url:
    :type power_bi_report_embed_url: str
    :param error:  Possible values include: "None", "ReportNotFound", "Other".
    :type error: str or ~smartdiagnostics_sdk.models.PowerBiReportChildError
    """

    _attribute_map = {
        'power_bi_report_access_token': {'key': 'PowerBiReportAccessToken', 'type': 'str'},
        'power_bi_report_name': {'key': 'PowerBiReportName', 'type': 'str'},
        'power_bi_report_url': {'key': 'PowerBiReportUrl', 'type': 'str'},
        'power_bi_report_embed_url': {'key': 'PowerBiReportEmbedUrl', 'type': 'str'},
        'error': {'key': 'Error', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(PowerBiReportChild, self).__init__(**kwargs)
        self.power_bi_report_access_token = kwargs.get('power_bi_report_access_token', None)
        self.power_bi_report_name = kwargs.get('power_bi_report_name', None)
        self.power_bi_report_url = kwargs.get('power_bi_report_url', None)
        self.power_bi_report_embed_url = kwargs.get('power_bi_report_embed_url', None)
        self.error = kwargs.get('error', None)


class PrimaryCorporationChild(msrest.serialization.Model):
    """PrimaryCorporationChild.

    All required parameters must be populated in order to send to Azure.

    :param corporation_id: Required.
    :type corporation_id: str
    :param corporation_name: Required.
    :type corporation_name: str
    :param corporation_abbreviation:
    :type corporation_abbreviation: str
    """

    _validation = {
        'corporation_id': {'required': True},
        'corporation_name': {'required': True},
    }

    _attribute_map = {
        'corporation_id': {'key': 'CorporationId', 'type': 'str'},
        'corporation_name': {'key': 'CorporationName', 'type': 'str'},
        'corporation_abbreviation': {'key': 'CorporationAbbreviation', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(PrimaryCorporationChild, self).__init__(**kwargs)
        self.corporation_id = kwargs['corporation_id']
        self.corporation_name = kwargs['corporation_name']
        self.corporation_abbreviation = kwargs.get('corporation_abbreviation', None)


class ProblemDetails(msrest.serialization.Model):
    """ProblemDetails.

    Variables are only populated by the server, and will be ignored when sending a request.

    :param type:
    :type type: str
    :param title:
    :type title: str
    :param status:
    :type status: int
    :param detail:
    :type detail: str
    :param instance:
    :type instance: str
    :ivar extensions: Dictionary of :code:`<any>`.
    :vartype extensions: dict[str, object]
    """

    _validation = {
        'extensions': {'readonly': True},
    }

    _attribute_map = {
        'type': {'key': 'Type', 'type': 'str'},
        'title': {'key': 'Title', 'type': 'str'},
        'status': {'key': 'Status', 'type': 'int'},
        'detail': {'key': 'Detail', 'type': 'str'},
        'instance': {'key': 'Instance', 'type': 'str'},
        'extensions': {'key': 'Extensions', 'type': '{object}'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(ProblemDetails, self).__init__(**kwargs)
        self.type = kwargs.get('type', None)
        self.title = kwargs.get('title', None)
        self.status = kwargs.get('status', None)
        self.detail = kwargs.get('detail', None)
        self.instance = kwargs.get('instance', None)
        self.extensions = None


class ProfileChild(msrest.serialization.Model):
    """ProfileChild.

    :param acceleration_units:
    :type acceleration_units: str
    :param pressure_units:
    :type pressure_units: str
    :param temperature_units:
    :type temperature_units: str
    :param velocity_units:
    :type velocity_units: str
    :param last_updated_time:
    :type last_updated_time: ~datetime.datetime
    :param date_format:
    :type date_format: str
    :param time_format:
    :type time_format: str
    :param time_zones:
    :type time_zones: str
    """

    _attribute_map = {
        'acceleration_units': {'key': 'AccelerationUnits', 'type': 'str'},
        'pressure_units': {'key': 'PressureUnits', 'type': 'str'},
        'temperature_units': {'key': 'TemperatureUnits', 'type': 'str'},
        'velocity_units': {'key': 'VelocityUnits', 'type': 'str'},
        'last_updated_time': {'key': 'LastUpdatedTime', 'type': 'iso-8601'},
        'date_format': {'key': 'DateFormat', 'type': 'str'},
        'time_format': {'key': 'TimeFormat', 'type': 'str'},
        'time_zones': {'key': 'TimeZones', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(ProfileChild, self).__init__(**kwargs)
        self.acceleration_units = kwargs.get('acceleration_units', None)
        self.pressure_units = kwargs.get('pressure_units', None)
        self.temperature_units = kwargs.get('temperature_units', None)
        self.velocity_units = kwargs.get('velocity_units', None)
        self.last_updated_time = kwargs.get('last_updated_time', None)
        self.date_format = kwargs.get('date_format', None)
        self.time_format = kwargs.get('time_format', None)
        self.time_zones = kwargs.get('time_zones', None)


class PropertyChild(msrest.serialization.Model):
    """PropertyChild.

    All required parameters must be populated in order to send to Azure.

    :param property_id: Required.
    :type property_id: int
    :param property_name: Required.
    :type property_name: str
    :param property_value:
    :type property_value: str
    :param property_value_type: Required.  Possible values include: "Boolean", "DateTime",
     "Double", "Float", "Integer", "String".
    :type property_value_type: str or ~smartdiagnostics_sdk.models.PropertyChildPropertyValueType
    :param property_description:
    :type property_description: str
    :param property_required: Required.
    :type property_required: bool
    """

    _validation = {
        'property_id': {'required': True},
        'property_name': {'required': True},
        'property_value_type': {'required': True},
        'property_required': {'required': True},
    }

    _attribute_map = {
        'property_id': {'key': 'PropertyId', 'type': 'int'},
        'property_name': {'key': 'PropertyName', 'type': 'str'},
        'property_value': {'key': 'PropertyValue', 'type': 'str'},
        'property_value_type': {'key': 'PropertyValueType', 'type': 'str'},
        'property_description': {'key': 'PropertyDescription', 'type': 'str'},
        'property_required': {'key': 'PropertyRequired', 'type': 'bool'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(PropertyChild, self).__init__(**kwargs)
        self.property_id = kwargs['property_id']
        self.property_name = kwargs['property_name']
        self.property_value = kwargs.get('property_value', None)
        self.property_value_type = kwargs['property_value_type']
        self.property_description = kwargs.get('property_description', None)
        self.property_required = kwargs['property_required']


class PropertyRequestChild(msrest.serialization.Model):
    """PropertyRequestChild.

    All required parameters must be populated in order to send to Azure.

    :param property_id: Required.
    :type property_id: int
    :param property_required: Required.
    :type property_required: bool
    """

    _validation = {
        'property_id': {'required': True},
        'property_required': {'required': True},
    }

    _attribute_map = {
        'property_id': {'key': 'PropertyId', 'type': 'int'},
        'property_required': {'key': 'PropertyRequired', 'type': 'bool'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(PropertyRequestChild, self).__init__(**kwargs)
        self.property_id = kwargs['property_id']
        self.property_required = kwargs['property_required']


class PropertyResponse(msrest.serialization.Model):
    """PropertyResponse.

    All required parameters must be populated in order to send to Azure.

    :param id: Required.
    :type id: int
    :param name: Required.
    :type name: str
    :param value_type: Required.
    :type value_type: str
    :param description:
    :type description: str
    """

    _validation = {
        'id': {'required': True},
        'name': {'required': True},
        'value_type': {'required': True},
    }

    _attribute_map = {
        'id': {'key': 'Id', 'type': 'int'},
        'name': {'key': 'Name', 'type': 'str'},
        'value_type': {'key': 'ValueType', 'type': 'str'},
        'description': {'key': 'Description', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(PropertyResponse, self).__init__(**kwargs)
        self.id = kwargs['id']
        self.name = kwargs['name']
        self.value_type = kwargs['value_type']
        self.description = kwargs.get('description', None)


class ReceiverChild(msrest.serialization.Model):
    """ReceiverChild.

    All required parameters must be populated in order to send to Azure.

    :param receiver_id: Required.
    :type receiver_id: long
    :param receiver_serial_number: Required.
    :type receiver_serial_number: str
    :param receiver_nickname:
    :type receiver_nickname: str
    :param receiver_firmware_version:
    :type receiver_firmware_version: str
    :param receiver_network_id:
    :type receiver_network_id: str
    :param receiver_rf_channel:
    :type receiver_rf_channel: int
    :param receiver_pending_rf_channel:
    :type receiver_pending_rf_channel: int
    """

    _validation = {
        'receiver_id': {'required': True},
        'receiver_serial_number': {'required': True},
    }

    _attribute_map = {
        'receiver_id': {'key': 'ReceiverId', 'type': 'long'},
        'receiver_serial_number': {'key': 'ReceiverSerialNumber', 'type': 'str'},
        'receiver_nickname': {'key': 'ReceiverNickname', 'type': 'str'},
        'receiver_firmware_version': {'key': 'ReceiverFirmwareVersion', 'type': 'str'},
        'receiver_network_id': {'key': 'ReceiverNetworkId', 'type': 'str'},
        'receiver_rf_channel': {'key': 'ReceiverRfChannel', 'type': 'int'},
        'receiver_pending_rf_channel': {'key': 'ReceiverPendingRfChannel', 'type': 'int'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(ReceiverChild, self).__init__(**kwargs)
        self.receiver_id = kwargs['receiver_id']
        self.receiver_serial_number = kwargs['receiver_serial_number']
        self.receiver_nickname = kwargs.get('receiver_nickname', None)
        self.receiver_firmware_version = kwargs.get('receiver_firmware_version', None)
        self.receiver_network_id = kwargs.get('receiver_network_id', None)
        self.receiver_rf_channel = kwargs.get('receiver_rf_channel', None)
        self.receiver_pending_rf_channel = kwargs.get('receiver_pending_rf_channel', None)


class ReceiverResponse(msrest.serialization.Model):
    """ReceiverResponse.

    :param id:
    :type id: long
    :param serial_number:
    :type serial_number: str
    :param firmware_version:
    :type firmware_version: str
    :param network_id:
    :type network_id: str
    :param receiver_type:  Possible values include: "BaseStation", "Repeater".
    :type receiver_type: str or ~smartdiagnostics_sdk.models.ReceiverResponseReceiverType
    :param rf_channel:
    :type rf_channel: int
    :param pending_rf_channel:
    :type pending_rf_channel: int
    :param mac_address:
    :type mac_address: str
    :param radio_mac_address:
    :type radio_mac_address: str
    :param location:
    :type location: ~smartdiagnostics_sdk.models.LocationChild
    :param corporation:
    :type corporation: ~smartdiagnostics_sdk.models.CorporationChild
    :param nodes:
    :type nodes: list[~smartdiagnostics_sdk.models.NodeChild]
    :param nickname:
    :type nickname: str
    """

    _attribute_map = {
        'id': {'key': 'Id', 'type': 'long'},
        'serial_number': {'key': 'SerialNumber', 'type': 'str'},
        'firmware_version': {'key': 'FirmwareVersion', 'type': 'str'},
        'network_id': {'key': 'NetworkId', 'type': 'str'},
        'receiver_type': {'key': 'ReceiverType', 'type': 'str'},
        'rf_channel': {'key': 'RfChannel', 'type': 'int'},
        'pending_rf_channel': {'key': 'PendingRfChannel', 'type': 'int'},
        'mac_address': {'key': 'MacAddress', 'type': 'str'},
        'radio_mac_address': {'key': 'RadioMacAddress', 'type': 'str'},
        'location': {'key': 'Location', 'type': 'LocationChild'},
        'corporation': {'key': 'Corporation', 'type': 'CorporationChild'},
        'nodes': {'key': 'Nodes', 'type': '[NodeChild]'},
        'nickname': {'key': 'Nickname', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(ReceiverResponse, self).__init__(**kwargs)
        self.id = kwargs.get('id', None)
        self.serial_number = kwargs.get('serial_number', None)
        self.firmware_version = kwargs.get('firmware_version', None)
        self.network_id = kwargs.get('network_id', None)
        self.receiver_type = kwargs.get('receiver_type', None)
        self.rf_channel = kwargs.get('rf_channel', None)
        self.pending_rf_channel = kwargs.get('pending_rf_channel', None)
        self.mac_address = kwargs.get('mac_address', None)
        self.radio_mac_address = kwargs.get('radio_mac_address', None)
        self.location = kwargs.get('location', None)
        self.corporation = kwargs.get('corporation', None)
        self.nodes = kwargs.get('nodes', None)
        self.nickname = kwargs.get('nickname', None)


class ReleaseRingChild(msrest.serialization.Model):
    """ReleaseRingChild.

    :param release_ring_id:
    :type release_ring_id: str
    :param release_ring_name:
    :type release_ring_name: str
    """

    _attribute_map = {
        'release_ring_id': {'key': 'ReleaseRingId', 'type': 'str'},
        'release_ring_name': {'key': 'ReleaseRingName', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(ReleaseRingChild, self).__init__(**kwargs)
        self.release_ring_id = kwargs.get('release_ring_id', None)
        self.release_ring_name = kwargs.get('release_ring_name', None)


class RepeaterModelV3(msrest.serialization.Model):
    """RepeaterModelV3.

    All required parameters must be populated in order to send to Azure.

    :param id:
    :type id: long
    :param serial_number: Required.
    :type serial_number: str
    :param radio_mac_address:
    :type radio_mac_address: str
    :param location_id:
    :type location_id: str
    :param location_name:
    :type location_name: str
    :param corporation_id:
    :type corporation_id: str
    :param corporation_name:
    :type corporation_name: str
    :param last_status_update:
    :type last_status_update: ~datetime.datetime
    :param active:
    :type active: bool
    :param type:  Possible values include: "Unknown", "BaseStation", "Repeater".
    :type type: str or ~smartdiagnostics_sdk.models.RepeaterModelV3Type
    """

    _validation = {
        'serial_number': {'required': True},
    }

    _attribute_map = {
        'id': {'key': 'Id', 'type': 'long'},
        'serial_number': {'key': 'SerialNumber', 'type': 'str'},
        'radio_mac_address': {'key': 'RadioMacAddress', 'type': 'str'},
        'location_id': {'key': 'LocationId', 'type': 'str'},
        'location_name': {'key': 'LocationName', 'type': 'str'},
        'corporation_id': {'key': 'CorporationId', 'type': 'str'},
        'corporation_name': {'key': 'CorporationName', 'type': 'str'},
        'last_status_update': {'key': 'LastStatusUpdate', 'type': 'iso-8601'},
        'active': {'key': 'Active', 'type': 'bool'},
        'type': {'key': 'Type', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(RepeaterModelV3, self).__init__(**kwargs)
        self.id = kwargs.get('id', None)
        self.serial_number = kwargs['serial_number']
        self.radio_mac_address = kwargs.get('radio_mac_address', None)
        self.location_id = kwargs.get('location_id', None)
        self.location_name = kwargs.get('location_name', None)
        self.corporation_id = kwargs.get('corporation_id', None)
        self.corporation_name = kwargs.get('corporation_name', None)
        self.last_status_update = kwargs.get('last_status_update', None)
        self.active = kwargs.get('active', None)
        self.type = kwargs.get('type', None)


class RoiResponse(msrest.serialization.Model):
    """RoiResponse.

    :param savings:
    :type savings: float
    :param roi_percentage:
    :type roi_percentage: float
    :param roi_ratio:
    :type roi_ratio: float
    """

    _attribute_map = {
        'savings': {'key': 'Savings', 'type': 'float'},
        'roi_percentage': {'key': 'RoiPercentage', 'type': 'float'},
        'roi_ratio': {'key': 'RoiRatio', 'type': 'float'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(RoiResponse, self).__init__(**kwargs)
        self.savings = kwargs.get('savings', None)
        self.roi_percentage = kwargs.get('roi_percentage', None)
        self.roi_ratio = kwargs.get('roi_ratio', None)


class SpectrumChartSettingsCreateRequest(msrest.serialization.Model):
    """SpectrumChartSettingsCreateRequest.

    :param frequency_domain_settings:
    :type frequency_domain_settings: ~smartdiagnostics_sdk.models.FrequencyDomainSettingChild
    :param time_domain_settings:
    :type time_domain_settings: ~smartdiagnostics_sdk.models.MarkerChild
    """

    _attribute_map = {
        'frequency_domain_settings': {'key': 'FrequencyDomainSettings', 'type': 'FrequencyDomainSettingChild'},
        'time_domain_settings': {'key': 'TimeDomainSettings', 'type': 'MarkerChild'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(SpectrumChartSettingsCreateRequest, self).__init__(**kwargs)
        self.frequency_domain_settings = kwargs.get('frequency_domain_settings', None)
        self.time_domain_settings = kwargs.get('time_domain_settings', None)


class SpectrumChartSettingsResponse(msrest.serialization.Model):
    """SpectrumChartSettingsResponse.

    :param frequency_domain_settings:
    :type frequency_domain_settings: ~smartdiagnostics_sdk.models.FrequencyDomainSettingChild
    :param time_domain_settings:
    :type time_domain_settings: ~smartdiagnostics_sdk.models.MarkerChild
    """

    _attribute_map = {
        'frequency_domain_settings': {'key': 'FrequencyDomainSettings', 'type': 'FrequencyDomainSettingChild'},
        'time_domain_settings': {'key': 'TimeDomainSettings', 'type': 'MarkerChild'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(SpectrumChartSettingsResponse, self).__init__(**kwargs)
        self.frequency_domain_settings = kwargs.get('frequency_domain_settings', None)
        self.time_domain_settings = kwargs.get('time_domain_settings', None)


class StatisticsReportRequest(msrest.serialization.Model):
    """StatisticsReportRequest.

    All required parameters must be populated in order to send to Azure.

    :param include_percent_time_in_alarm: Whether or not to include percent time in alarm in the
     calculations.
    :type include_percent_time_in_alarm: bool
    :param include_percent_time_in_warning: Whether or not to include percent time in warning in
     the calculations.
    :type include_percent_time_in_warning: bool
    :param include_percent_on_time: Whether or not to include percent on time in the calculations.
    :type include_percent_on_time: bool
    :param include_seconds_in_alarm: Whether or not to include time in alarm in the calculations.
    :type include_seconds_in_alarm: bool
    :param include_average_value: Whether or not to include the average value in the calculations.
    :type include_average_value: bool
    :param include_max_value: Whether or not to include the max value in the calculations.
    :type include_max_value: bool
    :param filter_id: The filter to use. Optional.
    :type filter_id: str
    :param start_date: Required. The start date of the time range to get the report for. Nullable
     so Required can catch nulls, will not
     be null later.
    :type start_date: ~datetime.datetime
    :param end_date: Required. The end date of the time range to get the values for. Nullable so
     Required can catch nulls, will not
     be null later.
    :type end_date: ~datetime.datetime
    :param file_name: Required. The filename to use for the report.
    :type file_name: str
    """

    _validation = {
        'start_date': {'required': True},
        'end_date': {'required': True},
        'file_name': {'required': True},
    }

    _attribute_map = {
        'include_percent_time_in_alarm': {'key': 'IncludePercentTimeInAlarm', 'type': 'bool'},
        'include_percent_time_in_warning': {'key': 'IncludePercentTimeInWarning', 'type': 'bool'},
        'include_percent_on_time': {'key': 'IncludePercentOnTime', 'type': 'bool'},
        'include_seconds_in_alarm': {'key': 'IncludeSecondsInAlarm', 'type': 'bool'},
        'include_average_value': {'key': 'IncludeAverageValue', 'type': 'bool'},
        'include_max_value': {'key': 'IncludeMaxValue', 'type': 'bool'},
        'filter_id': {'key': 'FilterId', 'type': 'str'},
        'start_date': {'key': 'StartDate', 'type': 'iso-8601'},
        'end_date': {'key': 'EndDate', 'type': 'iso-8601'},
        'file_name': {'key': 'FileName', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(StatisticsReportRequest, self).__init__(**kwargs)
        self.include_percent_time_in_alarm = kwargs.get('include_percent_time_in_alarm', None)
        self.include_percent_time_in_warning = kwargs.get('include_percent_time_in_warning', None)
        self.include_percent_on_time = kwargs.get('include_percent_on_time', None)
        self.include_seconds_in_alarm = kwargs.get('include_seconds_in_alarm', None)
        self.include_average_value = kwargs.get('include_average_value', None)
        self.include_max_value = kwargs.get('include_max_value', None)
        self.filter_id = kwargs.get('filter_id', None)
        self.start_date = kwargs['start_date']
        self.end_date = kwargs['end_date']
        self.file_name = kwargs['file_name']


class SubSystemCreateRequest(msrest.serialization.Model):
    """SubSystemCreateRequest.

    All required parameters must be populated in order to send to Azure.

    :param name: Required.
    :type name: str
    :param abbreviation:
    :type abbreviation: str
    :param parent_id: Required.
    :type parent_id: str
    """

    _validation = {
        'name': {'required': True, 'max_length': 100, 'min_length': 0},
        'abbreviation': {'max_length': 5, 'min_length': 0},
        'parent_id': {'required': True},
    }

    _attribute_map = {
        'name': {'key': 'Name', 'type': 'str'},
        'abbreviation': {'key': 'Abbreviation', 'type': 'str'},
        'parent_id': {'key': 'ParentId', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(SubSystemCreateRequest, self).__init__(**kwargs)
        self.name = kwargs['name']
        self.abbreviation = kwargs.get('abbreviation', None)
        self.parent_id = kwargs['parent_id']


class SubSystemResponse(msrest.serialization.Model):
    """SubSystemResponse.

    All required parameters must be populated in order to send to Azure.

    :param parent:
    :type parent: ~smartdiagnostics_sdk.models.ParentChild
    :param children:
    :type children: list[~smartdiagnostics_sdk.models.DescendantChild]
    :param hierarchy:
    :type hierarchy: list[~smartdiagnostics_sdk.models.HierarchyChild]
    :param id: Required.
    :type id: str
    :param name: Required.
    :type name: str
    :param abbreviation:
    :type abbreviation: str
    :param active: Required.
    :type active: bool
    :param is_paused: Required.
    :type is_paused: bool
    :param is_snoozed: Required.
    :type is_snoozed: bool
    :param created: Required.
    :type created: ~datetime.datetime
    :param corporation: Required.
    :type corporation: ~smartdiagnostics_sdk.models.CorporationChild
    :param location: Required.
    :type location: ~smartdiagnostics_sdk.models.LocationChild
    """

    _validation = {
        'id': {'required': True},
        'name': {'required': True},
        'active': {'required': True},
        'is_paused': {'required': True},
        'is_snoozed': {'required': True},
        'created': {'required': True},
        'corporation': {'required': True},
        'location': {'required': True},
    }

    _attribute_map = {
        'parent': {'key': 'Parent', 'type': 'ParentChild'},
        'children': {'key': 'Children', 'type': '[DescendantChild]'},
        'hierarchy': {'key': 'Hierarchy', 'type': '[HierarchyChild]'},
        'id': {'key': 'Id', 'type': 'str'},
        'name': {'key': 'Name', 'type': 'str'},
        'abbreviation': {'key': 'Abbreviation', 'type': 'str'},
        'active': {'key': 'Active', 'type': 'bool'},
        'is_paused': {'key': 'IsPaused', 'type': 'bool'},
        'is_snoozed': {'key': 'IsSnoozed', 'type': 'bool'},
        'created': {'key': 'Created', 'type': 'iso-8601'},
        'corporation': {'key': 'Corporation', 'type': 'CorporationChild'},
        'location': {'key': 'Location', 'type': 'LocationChild'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(SubSystemResponse, self).__init__(**kwargs)
        self.parent = kwargs.get('parent', None)
        self.children = kwargs.get('children', None)
        self.hierarchy = kwargs.get('hierarchy', None)
        self.id = kwargs['id']
        self.name = kwargs['name']
        self.abbreviation = kwargs.get('abbreviation', None)
        self.active = kwargs['active']
        self.is_paused = kwargs['is_paused']
        self.is_snoozed = kwargs['is_snoozed']
        self.created = kwargs['created']
        self.corporation = kwargs['corporation']
        self.location = kwargs['location']


class SubSystemUpdateRequest(msrest.serialization.Model):
    """SubSystemUpdateRequest.

    All required parameters must be populated in order to send to Azure.

    :param name: Required.
    :type name: str
    :param abbreviation:
    :type abbreviation: str
    :param is_paused: Required.
    :type is_paused: bool
    """

    _validation = {
        'name': {'required': True, 'max_length': 100, 'min_length': 0},
        'abbreviation': {'max_length': 5, 'min_length': 0},
        'is_paused': {'required': True},
    }

    _attribute_map = {
        'name': {'key': 'Name', 'type': 'str'},
        'abbreviation': {'key': 'Abbreviation', 'type': 'str'},
        'is_paused': {'key': 'IsPaused', 'type': 'bool'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(SubSystemUpdateRequest, self).__init__(**kwargs)
        self.name = kwargs['name']
        self.abbreviation = kwargs.get('abbreviation', None)
        self.is_paused = kwargs['is_paused']


class SystemAssetsStatusSummaryResponse(msrest.serialization.Model):
    """SystemAssetsStatusSummaryResponse.

    Variables are only populated by the server, and will be ignored when sending a request.

    :param system:
    :type system: ~smartdiagnostics_sdk.models.SystemChild
    :ivar asset_count:
    :vartype asset_count: int
    :param status_count:
    :type status_count: ~smartdiagnostics_sdk.models.AssetsStatusCountChild
    :param status_percentage:
    :type status_percentage: ~smartdiagnostics_sdk.models.AssetsStatusPercentageChild
    """

    _validation = {
        'asset_count': {'readonly': True},
    }

    _attribute_map = {
        'system': {'key': 'System', 'type': 'SystemChild'},
        'asset_count': {'key': 'AssetCount', 'type': 'int'},
        'status_count': {'key': 'StatusCount', 'type': 'AssetsStatusCountChild'},
        'status_percentage': {'key': 'StatusPercentage', 'type': 'AssetsStatusPercentageChild'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(SystemAssetsStatusSummaryResponse, self).__init__(**kwargs)
        self.system = kwargs.get('system', None)
        self.asset_count = None
        self.status_count = kwargs.get('status_count', None)
        self.status_percentage = kwargs.get('status_percentage', None)


class SystemChild(msrest.serialization.Model):
    """SystemChild.

    All required parameters must be populated in order to send to Azure.

    :param system_id: Required.
    :type system_id: str
    :param system_name: Required.
    :type system_name: str
    :param system_abbreviation:
    :type system_abbreviation: str
    """

    _validation = {
        'system_id': {'required': True},
        'system_name': {'required': True},
    }

    _attribute_map = {
        'system_id': {'key': 'SystemId', 'type': 'str'},
        'system_name': {'key': 'SystemName', 'type': 'str'},
        'system_abbreviation': {'key': 'SystemAbbreviation', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(SystemChild, self).__init__(**kwargs)
        self.system_id = kwargs['system_id']
        self.system_name = kwargs['system_name']
        self.system_abbreviation = kwargs.get('system_abbreviation', None)


class SystemCreateRequest(msrest.serialization.Model):
    """SystemCreateRequest.

    All required parameters must be populated in order to send to Azure.

    :param name: Required.
    :type name: str
    :param abbreviation:
    :type abbreviation: str
    :param location_id: Required.
    :type location_id: str
    :param is_collector_dependent_system:
    :type is_collector_dependent_system: bool
    """

    _validation = {
        'name': {'required': True, 'max_length': 100, 'min_length': 0},
        'abbreviation': {'max_length': 5, 'min_length': 0},
        'location_id': {'required': True},
    }

    _attribute_map = {
        'name': {'key': 'Name', 'type': 'str'},
        'abbreviation': {'key': 'Abbreviation', 'type': 'str'},
        'location_id': {'key': 'LocationId', 'type': 'str'},
        'is_collector_dependent_system': {'key': 'IsCollectorDependentSystem', 'type': 'bool'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(SystemCreateRequest, self).__init__(**kwargs)
        self.name = kwargs['name']
        self.abbreviation = kwargs.get('abbreviation', None)
        self.location_id = kwargs['location_id']
        self.is_collector_dependent_system = kwargs.get('is_collector_dependent_system', None)


class SystemResponse(msrest.serialization.Model):
    """SystemResponse.

    All required parameters must be populated in order to send to Azure.

    :param is_collector_dependent_system:
    :type is_collector_dependent_system: bool
    :param children:
    :type children: list[~smartdiagnostics_sdk.models.DescendantChild]
    :param id: Required.
    :type id: str
    :param name: Required.
    :type name: str
    :param abbreviation:
    :type abbreviation: str
    :param active: Required.
    :type active: bool
    :param is_paused: Required.
    :type is_paused: bool
    :param is_snoozed: Required.
    :type is_snoozed: bool
    :param created: Required.
    :type created: ~datetime.datetime
    :param corporation: Required.
    :type corporation: ~smartdiagnostics_sdk.models.CorporationChild
    :param location: Required.
    :type location: ~smartdiagnostics_sdk.models.LocationChild
    """

    _validation = {
        'id': {'required': True},
        'name': {'required': True},
        'active': {'required': True},
        'is_paused': {'required': True},
        'is_snoozed': {'required': True},
        'created': {'required': True},
        'corporation': {'required': True},
        'location': {'required': True},
    }

    _attribute_map = {
        'is_collector_dependent_system': {'key': 'IsCollectorDependentSystem', 'type': 'bool'},
        'children': {'key': 'Children', 'type': '[DescendantChild]'},
        'id': {'key': 'Id', 'type': 'str'},
        'name': {'key': 'Name', 'type': 'str'},
        'abbreviation': {'key': 'Abbreviation', 'type': 'str'},
        'active': {'key': 'Active', 'type': 'bool'},
        'is_paused': {'key': 'IsPaused', 'type': 'bool'},
        'is_snoozed': {'key': 'IsSnoozed', 'type': 'bool'},
        'created': {'key': 'Created', 'type': 'iso-8601'},
        'corporation': {'key': 'Corporation', 'type': 'CorporationChild'},
        'location': {'key': 'Location', 'type': 'LocationChild'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(SystemResponse, self).__init__(**kwargs)
        self.is_collector_dependent_system = kwargs.get('is_collector_dependent_system', None)
        self.children = kwargs.get('children', None)
        self.id = kwargs['id']
        self.name = kwargs['name']
        self.abbreviation = kwargs.get('abbreviation', None)
        self.active = kwargs['active']
        self.is_paused = kwargs['is_paused']
        self.is_snoozed = kwargs['is_snoozed']
        self.created = kwargs['created']
        self.corporation = kwargs['corporation']
        self.location = kwargs['location']


class SystemUpdateRequest(msrest.serialization.Model):
    """SystemUpdateRequest.

    All required parameters must be populated in order to send to Azure.

    :param name: Required.
    :type name: str
    :param abbreviation:
    :type abbreviation: str
    :param is_paused: Required.
    :type is_paused: bool
    """

    _validation = {
        'name': {'required': True, 'max_length': 100, 'min_length': 0},
        'abbreviation': {'max_length': 5, 'min_length': 0},
        'is_paused': {'required': True},
    }

    _attribute_map = {
        'name': {'key': 'Name', 'type': 'str'},
        'abbreviation': {'key': 'Abbreviation', 'type': 'str'},
        'is_paused': {'key': 'IsPaused', 'type': 'bool'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(SystemUpdateRequest, self).__init__(**kwargs)
        self.name = kwargs['name']
        self.abbreviation = kwargs.get('abbreviation', None)
        self.is_paused = kwargs['is_paused']


class TagChild(msrest.serialization.Model):
    """TagChild.

    :param tag_id:
    :type tag_id: str
    :param tag_name:
    :type tag_name: str
    :param tag_category:  Possible values include: "General", "Components", "Make", "Model",
     "Location", "Orientation", "Asset", "AssetCode", "Picture".
    :type tag_category: str or ~smartdiagnostics_sdk.models.TagChildTagCategory
    """

    _validation = {
        'tag_name': {'max_length': 50, 'min_length': 0},
    }

    _attribute_map = {
        'tag_id': {'key': 'TagId', 'type': 'str'},
        'tag_name': {'key': 'TagName', 'type': 'str'},
        'tag_category': {'key': 'TagCategory', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(TagChild, self).__init__(**kwargs)
        self.tag_id = kwargs.get('tag_id', None)
        self.tag_name = kwargs.get('tag_name', None)
        self.tag_category = kwargs.get('tag_category', None)


class TagCreateRequest(msrest.serialization.Model):
    """TagCreateRequest.

    All required parameters must be populated in order to send to Azure.

    :param name: Required.
    :type name: str
    :param type: Required.  Possible values include: "General", "Components", "Make", "Model",
     "Location", "Orientation", "Asset", "AssetCode", "Picture".
    :type type: str or ~smartdiagnostics_sdk.models.TagCreateRequestType
    :param location_id: Required.
    :type location_id: str
    """

    _validation = {
        'name': {'required': True, 'max_length': 50, 'min_length': 0},
        'type': {'required': True},
        'location_id': {'required': True},
    }

    _attribute_map = {
        'name': {'key': 'Name', 'type': 'str'},
        'type': {'key': 'Type', 'type': 'str'},
        'location_id': {'key': 'LocationId', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(TagCreateRequest, self).__init__(**kwargs)
        self.name = kwargs['name']
        self.type = kwargs['type']
        self.location_id = kwargs['location_id']


class TagResponse(msrest.serialization.Model):
    """TagResponse.

    All required parameters must be populated in order to send to Azure.

    :param id: Required.
    :type id: str
    :param name: Required.
    :type name: str
    :param active: Required.
    :type active: bool
    :param type: Required.  Possible values include: "General", "Components", "Make", "Model",
     "Location", "Orientation", "Asset", "AssetCode", "Picture".
    :type type: str or ~smartdiagnostics_sdk.models.TagResponseType
    :param is_global:
    :type is_global: bool
    :param created: Required.
    :type created: ~datetime.datetime
    :param updated: Required.
    :type updated: ~datetime.datetime
    :param location: Required.
    :type location: ~smartdiagnostics_sdk.models.LocationChild
    """

    _validation = {
        'id': {'required': True},
        'name': {'required': True},
        'active': {'required': True},
        'type': {'required': True},
        'created': {'required': True},
        'updated': {'required': True},
        'location': {'required': True},
    }

    _attribute_map = {
        'id': {'key': 'Id', 'type': 'str'},
        'name': {'key': 'Name', 'type': 'str'},
        'active': {'key': 'Active', 'type': 'bool'},
        'type': {'key': 'Type', 'type': 'str'},
        'is_global': {'key': 'IsGlobal', 'type': 'bool'},
        'created': {'key': 'Created', 'type': 'iso-8601'},
        'updated': {'key': 'Updated', 'type': 'iso-8601'},
        'location': {'key': 'Location', 'type': 'LocationChild'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(TagResponse, self).__init__(**kwargs)
        self.id = kwargs['id']
        self.name = kwargs['name']
        self.active = kwargs['active']
        self.type = kwargs['type']
        self.is_global = kwargs.get('is_global', None)
        self.created = kwargs['created']
        self.updated = kwargs['updated']
        self.location = kwargs['location']


class TagUpdateRequest(msrest.serialization.Model):
    """TagUpdateRequest.

    All required parameters must be populated in order to send to Azure.

    :param name: Required.
    :type name: str
    :param active: Required.
    :type active: bool
    """

    _validation = {
        'name': {'required': True, 'max_length': 50, 'min_length': 0},
        'active': {'required': True},
    }

    _attribute_map = {
        'name': {'key': 'Name', 'type': 'str'},
        'active': {'key': 'Active', 'type': 'bool'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(TagUpdateRequest, self).__init__(**kwargs)
        self.name = kwargs['name']
        self.active = kwargs['active']


class TargetedSoftwareReleaseChild(msrest.serialization.Model):
    """TargetedSoftwareReleaseChild.

    :param targeted_software_release_id:
    :type targeted_software_release_id: int
    :param targeted_software_release_name:
    :type targeted_software_release_name: str
    """

    _attribute_map = {
        'targeted_software_release_id': {'key': 'TargetedSoftwareReleaseId', 'type': 'int'},
        'targeted_software_release_name': {'key': 'TargetedSoftwareReleaseName', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(TargetedSoftwareReleaseChild, self).__init__(**kwargs)
        self.targeted_software_release_id = kwargs.get('targeted_software_release_id', None)
        self.targeted_software_release_name = kwargs.get('targeted_software_release_name', None)


class TimeRangeModelV3(msrest.serialization.Model):
    """TimeRangeModelV3.

    :param start_date:
    :type start_date: ~datetime.datetime
    :param end_date:
    :type end_date: ~datetime.datetime
    """

    _attribute_map = {
        'start_date': {'key': 'StartDate', 'type': 'iso-8601'},
        'end_date': {'key': 'EndDate', 'type': 'iso-8601'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(TimeRangeModelV3, self).__init__(**kwargs)
        self.start_date = kwargs.get('start_date', None)
        self.end_date = kwargs.get('end_date', None)


class TokenExchangeRequest(msrest.serialization.Model):
    """TokenExchangeRequest.

    :param token:
    :type token: str
    """

    _attribute_map = {
        'token': {'key': 'Token', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(TokenExchangeRequest, self).__init__(**kwargs)
        self.token = kwargs.get('token', None)


class TokenExchangeResponse(msrest.serialization.Model):
    """TokenExchangeResponse.

    :param token:
    :type token: str
    """

    _attribute_map = {
        'token': {'key': 'Token', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(TokenExchangeResponse, self).__init__(**kwargs)
        self.token = kwargs.get('token', None)


class TreeItemAvailableAssetClassResponse(msrest.serialization.Model):
    """TreeItemAvailableAssetClassResponse.

    :param tree_item:
    :type tree_item: ~smartdiagnostics_sdk.models.TreeItemChild
    :param asset_class_code:
    :type asset_class_code: str
    :param asset_type:
    :type asset_type: ~smartdiagnostics_sdk.models.AssetTypeChild
    :param asset_category:
    :type asset_category: ~smartdiagnostics_sdk.models.AssetCategoryChild
    :param asset_size:
    :type asset_size: ~smartdiagnostics_sdk.models.AssetSizeChild
    """

    _attribute_map = {
        'tree_item': {'key': 'TreeItem', 'type': 'TreeItemChild'},
        'asset_class_code': {'key': 'AssetClassCode', 'type': 'str'},
        'asset_type': {'key': 'AssetType', 'type': 'AssetTypeChild'},
        'asset_category': {'key': 'AssetCategory', 'type': 'AssetCategoryChild'},
        'asset_size': {'key': 'AssetSize', 'type': 'AssetSizeChild'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(TreeItemAvailableAssetClassResponse, self).__init__(**kwargs)
        self.tree_item = kwargs.get('tree_item', None)
        self.asset_class_code = kwargs.get('asset_class_code', None)
        self.asset_type = kwargs.get('asset_type', None)
        self.asset_category = kwargs.get('asset_category', None)
        self.asset_size = kwargs.get('asset_size', None)


class TreeItemChild(msrest.serialization.Model):
    """TreeItemChild.

    :param tree_item_id:
    :type tree_item_id: str
    :param tree_item_name:
    :type tree_item_name: str
    :param tree_item_abbreviation:
    :type tree_item_abbreviation: str
    """

    _attribute_map = {
        'tree_item_id': {'key': 'TreeItemId', 'type': 'str'},
        'tree_item_name': {'key': 'TreeItemName', 'type': 'str'},
        'tree_item_abbreviation': {'key': 'TreeItemAbbreviation', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(TreeItemChild, self).__init__(**kwargs)
        self.tree_item_id = kwargs.get('tree_item_id', None)
        self.tree_item_name = kwargs.get('tree_item_name', None)
        self.tree_item_abbreviation = kwargs.get('tree_item_abbreviation', None)


class TreeItemResponse(msrest.serialization.Model):
    """TreeItemResponse.

    All required parameters must be populated in order to send to Azure.

    :param tree_item_type: Required.  Possible values include: "Asset", "MonitoringPoint",
     "IndicatorGroup", "Group", "AnalyticModel".
    :type tree_item_type: str or ~smartdiagnostics_sdk.models.TreeItemResponseTreeItemType
    :param sort_order: Required.
    :type sort_order: int
    :param has_children: Required.
    :type has_children: bool
    :param alarm_severity_level: Required.
    :type alarm_severity_level: int
    :param asset_class_code:
    :type asset_class_code: str
    :param is_collector_dependent_system:
    :type is_collector_dependent_system: bool
    :param asset_type:
    :type asset_type: ~smartdiagnostics_sdk.models.AssetTypeChild
    :param asset_category:
    :type asset_category: ~smartdiagnostics_sdk.models.AssetCategoryChild
    :param asset_size:
    :type asset_size: ~smartdiagnostics_sdk.models.AssetSizeChild
    :param parent:
    :type parent: ~smartdiagnostics_sdk.models.ParentChild
    :param children:
    :type children: list[~smartdiagnostics_sdk.models.DescendantChild]
    :param hierarchy:
    :type hierarchy: list[~smartdiagnostics_sdk.models.HierarchyChild]
    :param id: Required.
    :type id: str
    :param name: Required.
    :type name: str
    :param abbreviation:
    :type abbreviation: str
    :param active: Required.
    :type active: bool
    :param is_paused: Required.
    :type is_paused: bool
    :param is_snoozed: Required.
    :type is_snoozed: bool
    :param created: Required.
    :type created: ~datetime.datetime
    :param corporation: Required.
    :type corporation: ~smartdiagnostics_sdk.models.CorporationChild
    :param location: Required.
    :type location: ~smartdiagnostics_sdk.models.LocationChild
    """

    _validation = {
        'tree_item_type': {'required': True},
        'sort_order': {'required': True},
        'has_children': {'required': True},
        'alarm_severity_level': {'required': True},
        'id': {'required': True},
        'name': {'required': True},
        'active': {'required': True},
        'is_paused': {'required': True},
        'is_snoozed': {'required': True},
        'created': {'required': True},
        'corporation': {'required': True},
        'location': {'required': True},
    }

    _attribute_map = {
        'tree_item_type': {'key': 'TreeItemType', 'type': 'str'},
        'sort_order': {'key': 'SortOrder', 'type': 'int'},
        'has_children': {'key': 'HasChildren', 'type': 'bool'},
        'alarm_severity_level': {'key': 'AlarmSeverityLevel', 'type': 'int'},
        'asset_class_code': {'key': 'AssetClassCode', 'type': 'str'},
        'is_collector_dependent_system': {'key': 'IsCollectorDependentSystem', 'type': 'bool'},
        'asset_type': {'key': 'AssetType', 'type': 'AssetTypeChild'},
        'asset_category': {'key': 'AssetCategory', 'type': 'AssetCategoryChild'},
        'asset_size': {'key': 'AssetSize', 'type': 'AssetSizeChild'},
        'parent': {'key': 'Parent', 'type': 'ParentChild'},
        'children': {'key': 'Children', 'type': '[DescendantChild]'},
        'hierarchy': {'key': 'Hierarchy', 'type': '[HierarchyChild]'},
        'id': {'key': 'Id', 'type': 'str'},
        'name': {'key': 'Name', 'type': 'str'},
        'abbreviation': {'key': 'Abbreviation', 'type': 'str'},
        'active': {'key': 'Active', 'type': 'bool'},
        'is_paused': {'key': 'IsPaused', 'type': 'bool'},
        'is_snoozed': {'key': 'IsSnoozed', 'type': 'bool'},
        'created': {'key': 'Created', 'type': 'iso-8601'},
        'corporation': {'key': 'Corporation', 'type': 'CorporationChild'},
        'location': {'key': 'Location', 'type': 'LocationChild'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(TreeItemResponse, self).__init__(**kwargs)
        self.tree_item_type = kwargs['tree_item_type']
        self.sort_order = kwargs['sort_order']
        self.has_children = kwargs['has_children']
        self.alarm_severity_level = kwargs['alarm_severity_level']
        self.asset_class_code = kwargs.get('asset_class_code', None)
        self.is_collector_dependent_system = kwargs.get('is_collector_dependent_system', None)
        self.asset_type = kwargs.get('asset_type', None)
        self.asset_category = kwargs.get('asset_category', None)
        self.asset_size = kwargs.get('asset_size', None)
        self.parent = kwargs.get('parent', None)
        self.children = kwargs.get('children', None)
        self.hierarchy = kwargs.get('hierarchy', None)
        self.id = kwargs['id']
        self.name = kwargs['name']
        self.abbreviation = kwargs.get('abbreviation', None)
        self.active = kwargs['active']
        self.is_paused = kwargs['is_paused']
        self.is_snoozed = kwargs['is_snoozed']
        self.created = kwargs['created']
        self.corporation = kwargs['corporation']
        self.location = kwargs['location']


class UpdateBearingsForGroupRequest(msrest.serialization.Model):
    """UpdateBearingsForGroupRequest.

    All required parameters must be populated in order to send to Azure.

    :param bearing_ids: Required.
    :type bearing_ids: list[str]
    """

    _validation = {
        'bearing_ids': {'required': True},
    }

    _attribute_map = {
        'bearing_ids': {'key': 'BearingIds', 'type': '[str]'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(UpdateBearingsForGroupRequest, self).__init__(**kwargs)
        self.bearing_ids = kwargs['bearing_ids']


class UserChild(msrest.serialization.Model):
    """UserChild.

    :param user_id:
    :type user_id: str
    :param user_first_name:
    :type user_first_name: str
    :param user_last_name:
    :type user_last_name: str
    :param user_email:
    :type user_email: str
    """

    _attribute_map = {
        'user_id': {'key': 'UserId', 'type': 'str'},
        'user_first_name': {'key': 'UserFirstName', 'type': 'str'},
        'user_last_name': {'key': 'UserLastName', 'type': 'str'},
        'user_email': {'key': 'UserEmail', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(UserChild, self).__init__(**kwargs)
        self.user_id = kwargs.get('user_id', None)
        self.user_first_name = kwargs.get('user_first_name', None)
        self.user_last_name = kwargs.get('user_last_name', None)
        self.user_email = kwargs.get('user_email', None)


class UserCorporationChild(msrest.serialization.Model):
    """UserCorporationChild.

    All required parameters must be populated in order to send to Azure.

    :param corporation_id: Required.
    :type corporation_id: str
    :param corporation_name: Required.
    :type corporation_name: str
    :param corporation_abbreviation:
    :type corporation_abbreviation: str
    :param corporation_user_role:  Possible values include: "Invalid", "SaasAdmin", "AccountAdmin",
     "ApplicationUser", "Technician", "User", "SystemProcess", "Sentry", "Sales",
     "CorporationAdmin", "CorporationUser", "CorporationNone".
    :type corporation_user_role: str or
     ~smartdiagnostics_sdk.models.UserCorporationChildCorporationUserRole
    """

    _validation = {
        'corporation_id': {'required': True},
        'corporation_name': {'required': True},
    }

    _attribute_map = {
        'corporation_id': {'key': 'CorporationId', 'type': 'str'},
        'corporation_name': {'key': 'CorporationName', 'type': 'str'},
        'corporation_abbreviation': {'key': 'CorporationAbbreviation', 'type': 'str'},
        'corporation_user_role': {'key': 'CorporationUserRole', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(UserCorporationChild, self).__init__(**kwargs)
        self.corporation_id = kwargs['corporation_id']
        self.corporation_name = kwargs['corporation_name']
        self.corporation_abbreviation = kwargs.get('corporation_abbreviation', None)
        self.corporation_user_role = kwargs.get('corporation_user_role', None)


class UserLocationChild(msrest.serialization.Model):
    """UserLocationChild.

    All required parameters must be populated in order to send to Azure.

    :param location_id: Required.
    :type location_id: str
    :param location_name: Required.
    :type location_name: str
    :param location_abbreviation:
    :type location_abbreviation: str
    :param location_user_role:  Possible values include: "Invalid", "SaasAdmin", "AccountAdmin",
     "ApplicationUser", "Technician", "User", "SystemProcess", "Sentry", "Sales",
     "CorporationAdmin", "CorporationUser", "CorporationNone".
    :type location_user_role: str or ~smartdiagnostics_sdk.models.UserLocationChildLocationUserRole
    """

    _validation = {
        'location_id': {'required': True},
        'location_name': {'required': True},
    }

    _attribute_map = {
        'location_id': {'key': 'LocationId', 'type': 'str'},
        'location_name': {'key': 'LocationName', 'type': 'str'},
        'location_abbreviation': {'key': 'LocationAbbreviation', 'type': 'str'},
        'location_user_role': {'key': 'LocationUserRole', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(UserLocationChild, self).__init__(**kwargs)
        self.location_id = kwargs['location_id']
        self.location_name = kwargs['location_name']
        self.location_abbreviation = kwargs.get('location_abbreviation', None)
        self.location_user_role = kwargs.get('location_user_role', None)


class WidgetChild(msrest.serialization.Model):
    """WidgetChild.

    All required parameters must be populated in order to send to Azure.

    :param widget_id: Required.
    :type widget_id: int
    :param widget_code:  Possible values include: "AssetMonitoring", "Alerts", "TimeWarningAlarm",
     "PerformanceOverall", "PerformanceComparison", "PerformanceKpi", "PerformanceScore",
     "PerformanceTrend".
    :type widget_code: str or ~smartdiagnostics_sdk.models.WidgetChildWidgetCode
    :param widget_name: Required.
    :type widget_name: str
    :param widget_description:
    :type widget_description: str
    :param widget_type:
    :type widget_type: ~smartdiagnostics_sdk.models.WidgetTypeChild
    """

    _validation = {
        'widget_id': {'required': True},
        'widget_name': {'required': True},
    }

    _attribute_map = {
        'widget_id': {'key': 'WidgetId', 'type': 'int'},
        'widget_code': {'key': 'WidgetCode', 'type': 'str'},
        'widget_name': {'key': 'WidgetName', 'type': 'str'},
        'widget_description': {'key': 'WidgetDescription', 'type': 'str'},
        'widget_type': {'key': 'WidgetType', 'type': 'WidgetTypeChild'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(WidgetChild, self).__init__(**kwargs)
        self.widget_id = kwargs['widget_id']
        self.widget_code = kwargs.get('widget_code', None)
        self.widget_name = kwargs['widget_name']
        self.widget_description = kwargs.get('widget_description', None)
        self.widget_type = kwargs.get('widget_type', None)


class WidgetTemplateChild(msrest.serialization.Model):
    """WidgetTemplateChild.

    All required parameters must be populated in order to send to Azure.

    :param widget_template_name: Required.
    :type widget_template_name: str
    :param widget_template_description:
    :type widget_template_description: str
    :param widget_template_filters:
    :type widget_template_filters: list[~smartdiagnostics_sdk.models.WidgetTemplateFilterChild]
    """

    _validation = {
        'widget_template_name': {'required': True},
    }

    _attribute_map = {
        'widget_template_name': {'key': 'WidgetTemplateName', 'type': 'str'},
        'widget_template_description': {'key': 'WidgetTemplateDescription', 'type': 'str'},
        'widget_template_filters': {'key': 'WidgetTemplateFilters', 'type': '[WidgetTemplateFilterChild]'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(WidgetTemplateChild, self).__init__(**kwargs)
        self.widget_template_name = kwargs['widget_template_name']
        self.widget_template_description = kwargs.get('widget_template_description', None)
        self.widget_template_filters = kwargs.get('widget_template_filters', None)


class WidgetTemplateFilterChild(msrest.serialization.Model):
    """WidgetTemplateFilterChild.

    All required parameters must be populated in order to send to Azure.

    :param filter_data_field_code: Required.
    :type filter_data_field_code: str
    :param filter_data_field_name: Required.
    :type filter_data_field_name: str
    :param filter_operator: Required.
    :type filter_operator: str
    :param filter_value: Required.
    :type filter_value: str
    """

    _validation = {
        'filter_data_field_code': {'required': True},
        'filter_data_field_name': {'required': True},
        'filter_operator': {'required': True},
        'filter_value': {'required': True},
    }

    _attribute_map = {
        'filter_data_field_code': {'key': 'FilterDataFieldCode', 'type': 'str'},
        'filter_data_field_name': {'key': 'FilterDataFieldName', 'type': 'str'},
        'filter_operator': {'key': 'FilterOperator', 'type': 'str'},
        'filter_value': {'key': 'FilterValue', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(WidgetTemplateFilterChild, self).__init__(**kwargs)
        self.filter_data_field_code = kwargs['filter_data_field_code']
        self.filter_data_field_name = kwargs['filter_data_field_name']
        self.filter_operator = kwargs['filter_operator']
        self.filter_value = kwargs['filter_value']


class WidgetTypeChild(msrest.serialization.Model):
    """WidgetTypeChild.

    All required parameters must be populated in order to send to Azure.

    :param widget_type_id: Required.
    :type widget_type_id: int
    :param widget_type_name: Required.  Possible values include: "Value", "Table", "Kpi", "Series".
    :type widget_type_name: str or ~smartdiagnostics_sdk.models.WidgetTypeChildWidgetTypeName
    :param widget_type_description:
    :type widget_type_description: str
    """

    _validation = {
        'widget_type_id': {'required': True},
        'widget_type_name': {'required': True},
    }

    _attribute_map = {
        'widget_type_id': {'key': 'WidgetTypeId', 'type': 'int'},
        'widget_type_name': {'key': 'WidgetTypeName', 'type': 'str'},
        'widget_type_description': {'key': 'WidgetTypeDescription', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(WidgetTypeChild, self).__init__(**kwargs)
        self.widget_type_id = kwargs['widget_type_id']
        self.widget_type_name = kwargs['widget_type_name']
        self.widget_type_description = kwargs.get('widget_type_description', None)
