# coding: utf-8

"""
    VMware Cloud Director OpenAPI

    VMware Cloud Director OpenAPI is a new API that is defined using the OpenAPI standards.<br/> This ReSTful API borrows some elements of the legacy VMware Cloud Director API and establishes new patterns for use as described below. <h4>Authentication</h4> Authentication and Authorization schemes are the same as those for the legacy APIs. You can authenticate using the JWT token via the <code>Authorization</code> header or specifying a session using <code>x-vcloud-authorization</code> (The latter form is deprecated). <h4>Operation Patterns</h4> This API follows the following general guidelines to establish a consistent CRUD pattern: <table> <tr>   <th>Operation</th><th>Description</th><th>Response Code</th><th>Response Content</th> </tr><tr>   <td>GET /items<td>Returns a paginated list of items<td>200<td>Response will include Navigational links to the items in the list. </tr><tr>   <td>POST /items<td>Returns newly created item<td>201<td>Content-Location header links to the newly created item </tr><tr>   <td>GET /items/urn<td>Returns an individual item<td>200<td>A single item using same data type as that included in list above </tr><tr>   <td>PUT /items/urn<td>Updates an individual item<td>200<td>Updated view of the item is returned </tr><tr>   <td>DELETE /items/urn<td>Deletes the item<td>204<td>No content is returned. </tr> </table> <h5>Asynchronous operations</h5> Asynchronous operations are determined by the server. In those cases, instead of responding as described above, the server responds with an HTTP Response code 202 and an empty body. The tracking task (which is the same task as all legacy API operations use) is linked via the URI provided in the <code>Location</code> header.<br/> All API calls can choose to service a request asynchronously or synchronously as determined by the server upon interpreting the request. Operations that choose to exhibit this dual behavior will have both options documented by specifying both response code(s) below. The caller must be prepared to handle responses to such API calls by inspecting the HTTP Response code. <h5>Error Conditions</h5> <b>All</b> operations report errors using the following error reporting rules: <ul>   <li>400: Bad Request - In event of bad request due to incorrect data or other user error</li>   <li>401: Bad Request - If user is unauthenticated or their session has expired</li>   <li>403: Forbidden - If the user is not authorized or the entity does not exist</li> </ul> <h4>OpenAPI Design Concepts and Principles</h4> <ul>   <li>IDs are full Uniform Resource Names (URNs).</li>   <li>OpenAPI's <code>Content-Type</code> is always <code>application/json</code></li>   <li>REST links are in the Link header.</li>   <ul>     <li>Multiple relationships for any link are represented by multiple values in a space-separated list.</li>     <li>Links have a custom VMware Cloud Director-specific &quot;model&quot; attribute that hints at the applicable data         type for the links.</li>     <li>title + rel + model attributes evaluates to a unique link.</li>     <li>Links follow Hypermedia as the Engine of Application State (HATEOAS) principles. Links are present if         certain operations are present and permitted for the user&quot;s current role and the state of the         referred entities.</li>   </ul>   <li>APIs follow a flat structure relying on cross-referencing other entities instead of the navigational style       used by the legacy VMware Cloud Director APIs.</li>   <li>Most endpoints that return a list support filtering and sorting similar to the query service in the legacy       VMware Cloud Director APIs.</li>   <li>Accept header must be included to specify the API version for the request similar to calls to existing legacy       VMware Cloud Director APIs.</li>   <li>Each feature has a version in the path element present in its URL.<br/>       <b>Note</b> API URL's without a version in their paths must be considered experimental.</li> </ul> 

    OpenAPI spec version: 36.0
    Contact: https://code.vmware.com/support
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""


from pprint import pformat
from six import iteritems
import re


class VdcNetwork(object):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """


    """
    Attributes:
      swagger_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    swagger_types = {
        'id': 'str',
        'name': 'str',
        'description': 'str',
        'subnets': 'Subnets',
        'backing_network_id': 'str',
        'backing_network_type': 'BackingNetworkType',
        'parent_network_id': 'EntityReference',
        'network_type': 'VdcNetworkFenceType',
        'org_vdc': 'EntityReference',
        'owner_ref': 'EntityReference',
        'org_vdc_is_nsx_t_backed': 'bool',
        'org_ref': 'EntityReference',
        'connection': 'RouterConnection',
        'is_default_network': 'bool',
        'shared': 'bool',
        'enable_dual_subnet_network': 'bool',
        'status': 'OrgVdcNetworkStatus',
        'last_task_failure_message': 'str',
        'guest_vlan_tagging_allowed': 'bool',
        'retain_nic_resources': 'bool',
        'cross_vdc_network_id': 'str',
        'cross_vdc_network_location_id': 'str',
        'overlay_id': 'int',
        'total_ip_count': 'int',
        'used_ip_count': 'int',
        'route_advertised': 'bool',
        'security_groups': 'list[EntityReference]'
    }

    attribute_map = {
        'id': 'id',
        'name': 'name',
        'description': 'description',
        'subnets': 'subnets',
        'backing_network_id': 'backingNetworkId',
        'backing_network_type': 'backingNetworkType',
        'parent_network_id': 'parentNetworkId',
        'network_type': 'networkType',
        'org_vdc': 'orgVdc',
        'owner_ref': 'ownerRef',
        'org_vdc_is_nsx_t_backed': 'orgVdcIsNsxTBacked',
        'org_ref': 'orgRef',
        'connection': 'connection',
        'is_default_network': 'isDefaultNetwork',
        'shared': 'shared',
        'enable_dual_subnet_network': 'enableDualSubnetNetwork',
        'status': 'status',
        'last_task_failure_message': 'lastTaskFailureMessage',
        'guest_vlan_tagging_allowed': 'guestVlanTaggingAllowed',
        'retain_nic_resources': 'retainNicResources',
        'cross_vdc_network_id': 'crossVdcNetworkId',
        'cross_vdc_network_location_id': 'crossVdcNetworkLocationId',
        'overlay_id': 'overlayId',
        'total_ip_count': 'totalIpCount',
        'used_ip_count': 'usedIpCount',
        'route_advertised': 'routeAdvertised',
        'security_groups': 'securityGroups'
    }

    def __init__(self, id=None, name=None, description=None, subnets=None, backing_network_id=None, backing_network_type=None, parent_network_id=None, network_type=None, org_vdc=None, owner_ref=None, org_vdc_is_nsx_t_backed=False, org_ref=None, connection=None, is_default_network=None, shared=None, enable_dual_subnet_network=False, status=None, last_task_failure_message=None, guest_vlan_tagging_allowed=None, retain_nic_resources=None, cross_vdc_network_id=None, cross_vdc_network_location_id=None, overlay_id=None, total_ip_count=None, used_ip_count=None, route_advertised=None, security_groups=None):
        """
        VdcNetwork - a model defined in Swagger
        """

        self._id = None
        self._name = None
        self._description = None
        self._subnets = None
        self._backing_network_id = None
        self._backing_network_type = None
        self._parent_network_id = None
        self._network_type = None
        self._org_vdc = None
        self._owner_ref = None
        self._org_vdc_is_nsx_t_backed = None
        self._org_ref = None
        self._connection = None
        self._is_default_network = None
        self._shared = None
        self._enable_dual_subnet_network = None
        self._status = None
        self._last_task_failure_message = None
        self._guest_vlan_tagging_allowed = None
        self._retain_nic_resources = None
        self._cross_vdc_network_id = None
        self._cross_vdc_network_location_id = None
        self._overlay_id = None
        self._total_ip_count = None
        self._used_ip_count = None
        self._route_advertised = None
        self._security_groups = None

        if id is not None:
          self.id = id
        if name is not None:
          self.name = name
        if description is not None:
          self.description = description
        if subnets is not None:
          self.subnets = subnets
        if backing_network_id is not None:
          self.backing_network_id = backing_network_id
        if backing_network_type is not None:
          self.backing_network_type = backing_network_type
        if parent_network_id is not None:
          self.parent_network_id = parent_network_id
        if network_type is not None:
          self.network_type = network_type
        if org_vdc is not None:
          self.org_vdc = org_vdc
        if owner_ref is not None:
          self.owner_ref = owner_ref
        if org_vdc_is_nsx_t_backed is not None:
          self.org_vdc_is_nsx_t_backed = org_vdc_is_nsx_t_backed
        if org_ref is not None:
          self.org_ref = org_ref
        if connection is not None:
          self.connection = connection
        if is_default_network is not None:
          self.is_default_network = is_default_network
        if shared is not None:
          self.shared = shared
        if enable_dual_subnet_network is not None:
          self.enable_dual_subnet_network = enable_dual_subnet_network
        if status is not None:
          self.status = status
        if last_task_failure_message is not None:
          self.last_task_failure_message = last_task_failure_message
        if guest_vlan_tagging_allowed is not None:
          self.guest_vlan_tagging_allowed = guest_vlan_tagging_allowed
        if retain_nic_resources is not None:
          self.retain_nic_resources = retain_nic_resources
        if cross_vdc_network_id is not None:
          self.cross_vdc_network_id = cross_vdc_network_id
        if cross_vdc_network_location_id is not None:
          self.cross_vdc_network_location_id = cross_vdc_network_location_id
        if overlay_id is not None:
          self.overlay_id = overlay_id
        if total_ip_count is not None:
          self.total_ip_count = total_ip_count
        if used_ip_count is not None:
          self.used_ip_count = used_ip_count
        if route_advertised is not None:
          self.route_advertised = route_advertised
        if security_groups is not None:
          self.security_groups = security_groups

    @property
    def id(self):
        """
        Gets the id of this VdcNetwork.
        The unique ID for the network. This field is read-only.

        :return: The id of this VdcNetwork.
        :rtype: str
        """
        return self._id

    @id.setter
    def id(self, id):
        """
        Sets the id of this VdcNetwork.
        The unique ID for the network. This field is read-only.

        :param id: The id of this VdcNetwork.
        :type: str
        """

        self._id = id

    @property
    def name(self):
        """
        Gets the name of this VdcNetwork.
        The name of the network.

        :return: The name of this VdcNetwork.
        :rtype: str
        """
        return self._name

    @name.setter
    def name(self, name):
        """
        Sets the name of this VdcNetwork.
        The name of the network.

        :param name: The name of this VdcNetwork.
        :type: str
        """

        self._name = name

    @property
    def description(self):
        """
        Gets the description of this VdcNetwork.
        The description of the network.

        :return: The description of this VdcNetwork.
        :rtype: str
        """
        return self._description

    @description.setter
    def description(self, description):
        """
        Sets the description of this VdcNetwork.
        The description of the network.

        :param description: The description of this VdcNetwork.
        :type: str
        """

        self._description = description

    @property
    def subnets(self):
        """
        Gets the subnets of this VdcNetwork.
        List of subnets configured for the network.

        :return: The subnets of this VdcNetwork.
        :rtype: Subnets
        """
        return self._subnets

    @subnets.setter
    def subnets(self, subnets):
        """
        Sets the subnets of this VdcNetwork.
        List of subnets configured for the network.

        :param subnets: The subnets of this VdcNetwork.
        :type: Subnets
        """

        self._subnets = subnets

    @property
    def backing_network_id(self):
        """
        Gets the backing_network_id of this VdcNetwork.
        The NSX id of the backing network.

        :return: The backing_network_id of this VdcNetwork.
        :rtype: str
        """
        return self._backing_network_id

    @backing_network_id.setter
    def backing_network_id(self, backing_network_id):
        """
        Sets the backing_network_id of this VdcNetwork.
        The NSX id of the backing network.

        :param backing_network_id: The backing_network_id of this VdcNetwork.
        :type: str
        """

        self._backing_network_id = backing_network_id

    @property
    def backing_network_type(self):
        """
        Gets the backing_network_type of this VdcNetwork.
        The object type of the backing network.

        :return: The backing_network_type of this VdcNetwork.
        :rtype: BackingNetworkType
        """
        return self._backing_network_type

    @backing_network_type.setter
    def backing_network_type(self, backing_network_type):
        """
        Sets the backing_network_type of this VdcNetwork.
        The object type of the backing network.

        :param backing_network_type: The backing_network_type of this VdcNetwork.
        :type: BackingNetworkType
        """

        self._backing_network_type = backing_network_type

    @property
    def parent_network_id(self):
        """
        Gets the parent_network_id of this VdcNetwork.
        The parent network if the network is a direct network, otherwise it will be null.

        :return: The parent_network_id of this VdcNetwork.
        :rtype: EntityReference
        """
        return self._parent_network_id

    @parent_network_id.setter
    def parent_network_id(self, parent_network_id):
        """
        Sets the parent_network_id of this VdcNetwork.
        The parent network if the network is a direct network, otherwise it will be null.

        :param parent_network_id: The parent_network_id of this VdcNetwork.
        :type: EntityReference
        """

        self._parent_network_id = parent_network_id

    @property
    def network_type(self):
        """
        Gets the network_type of this VdcNetwork.
        The type of network. Changing the network type allows converting between an isolated and routed network. Note that the \"connection\" field must also be set if converting from isolated to routed network. 

        :return: The network_type of this VdcNetwork.
        :rtype: VdcNetworkFenceType
        """
        return self._network_type

    @network_type.setter
    def network_type(self, network_type):
        """
        Sets the network_type of this VdcNetwork.
        The type of network. Changing the network type allows converting between an isolated and routed network. Note that the \"connection\" field must also be set if converting from isolated to routed network. 

        :param network_type: The network_type of this VdcNetwork.
        :type: VdcNetworkFenceType
        """

        self._network_type = network_type

    @property
    def org_vdc(self):
        """
        Gets the org_vdc of this VdcNetwork.
        The organization vDC the network belongs to. This should be unset if the network is owned by a vDC Group. For API version 35.0 and above, this field will be treated as read only. Please use ownerRef for new network creation. 

        :return: The org_vdc of this VdcNetwork.
        :rtype: EntityReference
        """
        return self._org_vdc

    @org_vdc.setter
    def org_vdc(self, org_vdc):
        """
        Sets the org_vdc of this VdcNetwork.
        The organization vDC the network belongs to. This should be unset if the network is owned by a vDC Group. For API version 35.0 and above, this field will be treated as read only. Please use ownerRef for new network creation. 

        :param org_vdc: The org_vdc of this VdcNetwork.
        :type: EntityReference
        """

        self._org_vdc = org_vdc

    @property
    def owner_ref(self):
        """
        Gets the owner_ref of this VdcNetwork.
        The org vDC or vDC Group that this network belongs to. If the ownerRef is set to a vDC Group, this network will be available across all the vDCs in the vDC Group. If the vDC Group is backed by a NSX-V network provider, the org vDC network is automatically connected to the distributed router associated with the vDC Group and the \"connection\" field does not need to be set. For API version 35.0 and above, this field should be set for network creation. 

        :return: The owner_ref of this VdcNetwork.
        :rtype: EntityReference
        """
        return self._owner_ref

    @owner_ref.setter
    def owner_ref(self, owner_ref):
        """
        Sets the owner_ref of this VdcNetwork.
        The org vDC or vDC Group that this network belongs to. If the ownerRef is set to a vDC Group, this network will be available across all the vDCs in the vDC Group. If the vDC Group is backed by a NSX-V network provider, the org vDC network is automatically connected to the distributed router associated with the vDC Group and the \"connection\" field does not need to be set. For API version 35.0 and above, this field should be set for network creation. 

        :param owner_ref: The owner_ref of this VdcNetwork.
        :type: EntityReference
        """

        self._owner_ref = owner_ref

    @property
    def org_vdc_is_nsx_t_backed(self):
        """
        Gets the org_vdc_is_nsx_t_backed of this VdcNetwork.
        For an Org vDC network, whether the vDC is backed by NSX-T.

        :return: The org_vdc_is_nsx_t_backed of this VdcNetwork.
        :rtype: bool
        """
        return self._org_vdc_is_nsx_t_backed

    @org_vdc_is_nsx_t_backed.setter
    def org_vdc_is_nsx_t_backed(self, org_vdc_is_nsx_t_backed):
        """
        Sets the org_vdc_is_nsx_t_backed of this VdcNetwork.
        For an Org vDC network, whether the vDC is backed by NSX-T.

        :param org_vdc_is_nsx_t_backed: The org_vdc_is_nsx_t_backed of this VdcNetwork.
        :type: bool
        """

        self._org_vdc_is_nsx_t_backed = org_vdc_is_nsx_t_backed

    @property
    def org_ref(self):
        """
        Gets the org_ref of this VdcNetwork.
        The organization to which the network belongs.

        :return: The org_ref of this VdcNetwork.
        :rtype: EntityReference
        """
        return self._org_ref

    @org_ref.setter
    def org_ref(self, org_ref):
        """
        Sets the org_ref of this VdcNetwork.
        The organization to which the network belongs.

        :param org_ref: The org_ref of this VdcNetwork.
        :type: EntityReference
        """

        self._org_ref = org_ref

    @property
    def connection(self):
        """
        Gets the connection of this VdcNetwork.
        The edge gateway that the network is attached to. 

        :return: The connection of this VdcNetwork.
        :rtype: RouterConnection
        """
        return self._connection

    @connection.setter
    def connection(self, connection):
        """
        Sets the connection of this VdcNetwork.
        The edge gateway that the network is attached to. 

        :param connection: The connection of this VdcNetwork.
        :type: RouterConnection
        """

        self._connection = connection

    @property
    def is_default_network(self):
        """
        Gets the is_default_network of this VdcNetwork.
        Deprecated unused field, this property will be removed in future release. 

        :return: The is_default_network of this VdcNetwork.
        :rtype: bool
        """
        return self._is_default_network

    @is_default_network.setter
    def is_default_network(self, is_default_network):
        """
        Sets the is_default_network of this VdcNetwork.
        Deprecated unused field, this property will be removed in future release. 

        :param is_default_network: The is_default_network of this VdcNetwork.
        :type: bool
        """

        self._is_default_network = is_default_network

    @property
    def shared(self):
        """
        Gets the shared of this VdcNetwork.
        Whether this network is shared with other organization vDCs.

        :return: The shared of this VdcNetwork.
        :rtype: bool
        """
        return self._shared

    @shared.setter
    def shared(self, shared):
        """
        Sets the shared of this VdcNetwork.
        Whether this network is shared with other organization vDCs.

        :param shared: The shared of this VdcNetwork.
        :type: bool
        """

        self._shared = shared

    @property
    def enable_dual_subnet_network(self):
        """
        Gets the enable_dual_subnet_network of this VdcNetwork.
        Whether or not this network will support two subnets

        :return: The enable_dual_subnet_network of this VdcNetwork.
        :rtype: bool
        """
        return self._enable_dual_subnet_network

    @enable_dual_subnet_network.setter
    def enable_dual_subnet_network(self, enable_dual_subnet_network):
        """
        Sets the enable_dual_subnet_network of this VdcNetwork.
        Whether or not this network will support two subnets

        :param enable_dual_subnet_network: The enable_dual_subnet_network of this VdcNetwork.
        :type: bool
        """

        self._enable_dual_subnet_network = enable_dual_subnet_network

    @property
    def status(self):
        """
        Gets the status of this VdcNetwork.
        Description of the network's status. 

        :return: The status of this VdcNetwork.
        :rtype: OrgVdcNetworkStatus
        """
        return self._status

    @status.setter
    def status(self, status):
        """
        Sets the status of this VdcNetwork.
        Description of the network's status. 

        :param status: The status of this VdcNetwork.
        :type: OrgVdcNetworkStatus
        """

        self._status = status

    @property
    def last_task_failure_message(self):
        """
        Gets the last_task_failure_message of this VdcNetwork.
        Brief failure message if the last configuration task failed. Deprecated in Api 33.0, this property will be removed in next release. 

        :return: The last_task_failure_message of this VdcNetwork.
        :rtype: str
        """
        return self._last_task_failure_message

    @last_task_failure_message.setter
    def last_task_failure_message(self, last_task_failure_message):
        """
        Sets the last_task_failure_message of this VdcNetwork.
        Brief failure message if the last configuration task failed. Deprecated in Api 33.0, this property will be removed in next release. 

        :param last_task_failure_message: The last_task_failure_message of this VdcNetwork.
        :type: str
        """

        self._last_task_failure_message = last_task_failure_message

    @property
    def guest_vlan_tagging_allowed(self):
        """
        Gets the guest_vlan_tagging_allowed of this VdcNetwork.
        Whether guest VLAN tagging is allowed.

        :return: The guest_vlan_tagging_allowed of this VdcNetwork.
        :rtype: bool
        """
        return self._guest_vlan_tagging_allowed

    @guest_vlan_tagging_allowed.setter
    def guest_vlan_tagging_allowed(self, guest_vlan_tagging_allowed):
        """
        Sets the guest_vlan_tagging_allowed of this VdcNetwork.
        Whether guest VLAN tagging is allowed.

        :param guest_vlan_tagging_allowed: The guest_vlan_tagging_allowed of this VdcNetwork.
        :type: bool
        """

        self._guest_vlan_tagging_allowed = guest_vlan_tagging_allowed

    @property
    def retain_nic_resources(self):
        """
        Gets the retain_nic_resources of this VdcNetwork.
        Whether network resources such as IP/MAC Addresses are to be retained.

        :return: The retain_nic_resources of this VdcNetwork.
        :rtype: bool
        """
        return self._retain_nic_resources

    @retain_nic_resources.setter
    def retain_nic_resources(self, retain_nic_resources):
        """
        Sets the retain_nic_resources of this VdcNetwork.
        Whether network resources such as IP/MAC Addresses are to be retained.

        :param retain_nic_resources: The retain_nic_resources of this VdcNetwork.
        :type: bool
        """

        self._retain_nic_resources = retain_nic_resources

    @property
    def cross_vdc_network_id(self):
        """
        Gets the cross_vdc_network_id of this VdcNetwork.
        The id of the cross vdc network if this is a stretched network, otherwise it will be null.

        :return: The cross_vdc_network_id of this VdcNetwork.
        :rtype: str
        """
        return self._cross_vdc_network_id

    @cross_vdc_network_id.setter
    def cross_vdc_network_id(self, cross_vdc_network_id):
        """
        Sets the cross_vdc_network_id of this VdcNetwork.
        The id of the cross vdc network if this is a stretched network, otherwise it will be null.

        :param cross_vdc_network_id: The cross_vdc_network_id of this VdcNetwork.
        :type: str
        """

        self._cross_vdc_network_id = cross_vdc_network_id

    @property
    def cross_vdc_network_location_id(self):
        """
        Gets the cross_vdc_network_location_id of this VdcNetwork.
        The id of the org from which this network can be managed if this is a stretched network, otherwise it will be null.

        :return: The cross_vdc_network_location_id of this VdcNetwork.
        :rtype: str
        """
        return self._cross_vdc_network_location_id

    @cross_vdc_network_location_id.setter
    def cross_vdc_network_location_id(self, cross_vdc_network_location_id):
        """
        Sets the cross_vdc_network_location_id of this VdcNetwork.
        The id of the org from which this network can be managed if this is a stretched network, otherwise it will be null.

        :param cross_vdc_network_location_id: The cross_vdc_network_location_id of this VdcNetwork.
        :type: str
        """

        self._cross_vdc_network_location_id = cross_vdc_network_location_id

    @property
    def overlay_id(self):
        """
        Gets the overlay_id of this VdcNetwork.
        Overlay connectivity ID for this Network. This field is used on creation during POST only and will not be displayed on an object returned through GET or PUT. 

        :return: The overlay_id of this VdcNetwork.
        :rtype: int
        """
        return self._overlay_id

    @overlay_id.setter
    def overlay_id(self, overlay_id):
        """
        Sets the overlay_id of this VdcNetwork.
        Overlay connectivity ID for this Network. This field is used on creation during POST only and will not be displayed on an object returned through GET or PUT. 

        :param overlay_id: The overlay_id of this VdcNetwork.
        :type: int
        """

        self._overlay_id = overlay_id

    @property
    def total_ip_count(self):
        """
        Gets the total_ip_count of this VdcNetwork.
        The number of IP addresses defined by the static ip pools. If the network contains any IpV6 subnets, the total ip count will be null.

        :return: The total_ip_count of this VdcNetwork.
        :rtype: int
        """
        return self._total_ip_count

    @total_ip_count.setter
    def total_ip_count(self, total_ip_count):
        """
        Sets the total_ip_count of this VdcNetwork.
        The number of IP addresses defined by the static ip pools. If the network contains any IpV6 subnets, the total ip count will be null.

        :param total_ip_count: The total_ip_count of this VdcNetwork.
        :type: int
        """

        self._total_ip_count = total_ip_count

    @property
    def used_ip_count(self):
        """
        Gets the used_ip_count of this VdcNetwork.
        The number of IP address used from the static ip pools.

        :return: The used_ip_count of this VdcNetwork.
        :rtype: int
        """
        return self._used_ip_count

    @used_ip_count.setter
    def used_ip_count(self, used_ip_count):
        """
        Sets the used_ip_count of this VdcNetwork.
        The number of IP address used from the static ip pools.

        :param used_ip_count: The used_ip_count of this VdcNetwork.
        :type: int
        """

        self._used_ip_count = used_ip_count

    @property
    def route_advertised(self):
        """
        Gets the route_advertised of this VdcNetwork.
        Whether this network is advertised so that it can be routed out to the external networks. This applies only to network backed by NSX-T. Value will be unset if route advertisement is not applicable. 

        :return: The route_advertised of this VdcNetwork.
        :rtype: bool
        """
        return self._route_advertised

    @route_advertised.setter
    def route_advertised(self, route_advertised):
        """
        Sets the route_advertised of this VdcNetwork.
        Whether this network is advertised so that it can be routed out to the external networks. This applies only to network backed by NSX-T. Value will be unset if route advertisement is not applicable. 

        :param route_advertised: The route_advertised of this VdcNetwork.
        :type: bool
        """

        self._route_advertised = route_advertised

    @property
    def security_groups(self):
        """
        Gets the security_groups of this VdcNetwork.
        The list of firewall groups of type SECURITY_GROUP/STATIC_MEMBERS that are assigned to the Org VDC Network. These groups can then be used in firewall rules to protect the Org VDC Network and allow/deny traffic. 

        :return: The security_groups of this VdcNetwork.
        :rtype: list[EntityReference]
        """
        return self._security_groups

    @security_groups.setter
    def security_groups(self, security_groups):
        """
        Sets the security_groups of this VdcNetwork.
        The list of firewall groups of type SECURITY_GROUP/STATIC_MEMBERS that are assigned to the Org VDC Network. These groups can then be used in firewall rules to protect the Org VDC Network and allow/deny traffic. 

        :param security_groups: The security_groups of this VdcNetwork.
        :type: list[EntityReference]
        """

        self._security_groups = security_groups

    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """
        Returns the string representation of the model
        """
        return pformat(self.to_dict())

    def __repr__(self):
        """
        For `print` and `pprint`
        """
        return self.to_str()

    def __eq__(self, other):
        """
        Returns true if both objects are equal
        """
        if not isinstance(other, VdcNetwork):
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """
        Returns true if both objects are not equal
        """
        return not self == other
