# coding: utf-8

"""
    VMware Cloud Director OpenAPI

    VMware Cloud Director OpenAPI is a new API that is defined using the OpenAPI standards.<br/> This ReSTful API borrows some elements of the legacy VMware Cloud Director API and establishes new patterns for use as described below. <h4>Authentication</h4> Authentication and Authorization schemes are the same as those for the legacy APIs. You can authenticate using the JWT token via the <code>Authorization</code> header or specifying a session using <code>x-vcloud-authorization</code> (The latter form is deprecated). <h4>Operation Patterns</h4> This API follows the following general guidelines to establish a consistent CRUD pattern: <table> <tr>   <th>Operation</th><th>Description</th><th>Response Code</th><th>Response Content</th> </tr><tr>   <td>GET /items<td>Returns a paginated list of items<td>200<td>Response will include Navigational links to the items in the list. </tr><tr>   <td>POST /items<td>Returns newly created item<td>201<td>Content-Location header links to the newly created item </tr><tr>   <td>GET /items/urn<td>Returns an individual item<td>200<td>A single item using same data type as that included in list above </tr><tr>   <td>PUT /items/urn<td>Updates an individual item<td>200<td>Updated view of the item is returned </tr><tr>   <td>DELETE /items/urn<td>Deletes the item<td>204<td>No content is returned. </tr> </table> <h5>Asynchronous operations</h5> Asynchronous operations are determined by the server. In those cases, instead of responding as described above, the server responds with an HTTP Response code 202 and an empty body. The tracking task (which is the same task as all legacy API operations use) is linked via the URI provided in the <code>Location</code> header.<br/> All API calls can choose to service a request asynchronously or synchronously as determined by the server upon interpreting the request. Operations that choose to exhibit this dual behavior will have both options documented by specifying both response code(s) below. The caller must be prepared to handle responses to such API calls by inspecting the HTTP Response code. <h5>Error Conditions</h5> <b>All</b> operations report errors using the following error reporting rules: <ul>   <li>400: Bad Request - In event of bad request due to incorrect data or other user error</li>   <li>401: Bad Request - If user is unauthenticated or their session has expired</li>   <li>403: Forbidden - If the user is not authorized or the entity does not exist</li> </ul> <h4>OpenAPI Design Concepts and Principles</h4> <ul>   <li>IDs are full Uniform Resource Names (URNs).</li>   <li>OpenAPI's <code>Content-Type</code> is always <code>application/json</code></li>   <li>REST links are in the Link header.</li>   <ul>     <li>Multiple relationships for any link are represented by multiple values in a space-separated list.</li>     <li>Links have a custom VMware Cloud Director-specific &quot;model&quot; attribute that hints at the applicable data         type for the links.</li>     <li>title + rel + model attributes evaluates to a unique link.</li>     <li>Links follow Hypermedia as the Engine of Application State (HATEOAS) principles. Links are present if         certain operations are present and permitted for the user&quot;s current role and the state of the         referred entities.</li>   </ul>   <li>APIs follow a flat structure relying on cross-referencing other entities instead of the navigational style       used by the legacy VMware Cloud Director APIs.</li>   <li>Most endpoints that return a list support filtering and sorting similar to the query service in the legacy       VMware Cloud Director APIs.</li>   <li>Accept header must be included to specify the API version for the request similar to calls to existing legacy       VMware Cloud Director APIs.</li>   <li>Each feature has a version in the path element present in its URL.<br/>       <b>Note</b> API URL's without a version in their paths must be considered experimental.</li> </ul> 

    OpenAPI spec version: 36.0
    Contact: https://code.vmware.com/support
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""


from pprint import pformat
from six import iteritems
import re


class VcdUser(object):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """


    """
    Attributes:
      swagger_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    swagger_types = {
        'username': 'str',
        'full_name': 'str',
        'description': 'str',
        'id': 'str',
        'role_entity_refs': 'list[EntityReference]',
        'org_entity_ref': 'EntityReference',
        'password': 'str',
        'deployed_vm_quota': 'int',
        'stored_vm_quota': 'int',
        'email': 'str',
        'name_in_source': 'str',
        'enabled': 'bool',
        'is_group_role': 'bool',
        'provider_type': 'str'
    }

    attribute_map = {
        'username': 'username',
        'full_name': 'fullName',
        'description': 'description',
        'id': 'id',
        'role_entity_refs': 'roleEntityRefs',
        'org_entity_ref': 'orgEntityRef',
        'password': 'password',
        'deployed_vm_quota': 'deployedVmQuota',
        'stored_vm_quota': 'storedVmQuota',
        'email': 'email',
        'name_in_source': 'nameInSource',
        'enabled': 'enabled',
        'is_group_role': 'isGroupRole',
        'provider_type': 'providerType'
    }

    def __init__(self, username=None, full_name='', description='', id=None, role_entity_refs=None, org_entity_ref=None, password=None, deployed_vm_quota=None, stored_vm_quota=None, email=None, name_in_source=None, enabled=None, is_group_role=None, provider_type=None):
        """
        VcdUser - a model defined in Swagger
        """

        self._username = None
        self._full_name = None
        self._description = None
        self._id = None
        self._role_entity_refs = None
        self._org_entity_ref = None
        self._password = None
        self._deployed_vm_quota = None
        self._stored_vm_quota = None
        self._email = None
        self._name_in_source = None
        self._enabled = None
        self._is_group_role = None
        self._provider_type = None

        self.username = username
        if full_name is not None:
          self.full_name = full_name
        if description is not None:
          self.description = description
        if id is not None:
          self.id = id
        self.role_entity_refs = role_entity_refs
        if org_entity_ref is not None:
          self.org_entity_ref = org_entity_ref
        if password is not None:
          self.password = password
        if deployed_vm_quota is not None:
          self.deployed_vm_quota = deployed_vm_quota
        if stored_vm_quota is not None:
          self.stored_vm_quota = stored_vm_quota
        if email is not None:
          self.email = email
        if name_in_source is not None:
          self.name_in_source = name_in_source
        if enabled is not None:
          self.enabled = enabled
        if is_group_role is not None:
          self.is_group_role = is_group_role
        if provider_type is not None:
          self.provider_type = provider_type

    @property
    def username(self):
        """
        Gets the username of this VcdUser.
        Immutable user name of the user.

        :return: The username of this VcdUser.
        :rtype: str
        """
        return self._username

    @username.setter
    def username(self, username):
        """
        Sets the username of this VcdUser.
        Immutable user name of the user.

        :param username: The username of this VcdUser.
        :type: str
        """
        if username is None:
            raise ValueError("Invalid value for `username`, must not be `None`")

        self._username = username

    @property
    def full_name(self):
        """
        Gets the full_name of this VcdUser.
        Full name (display name) of the user.

        :return: The full_name of this VcdUser.
        :rtype: str
        """
        return self._full_name

    @full_name.setter
    def full_name(self, full_name):
        """
        Sets the full_name of this VcdUser.
        Full name (display name) of the user.

        :param full_name: The full_name of this VcdUser.
        :type: str
        """

        self._full_name = full_name

    @property
    def description(self):
        """
        Gets the description of this VcdUser.
        Description of the user.

        :return: The description of this VcdUser.
        :rtype: str
        """
        return self._description

    @description.setter
    def description(self, description):
        """
        Sets the description of this VcdUser.
        Description of the user.

        :param description: The description of this VcdUser.
        :type: str
        """

        self._description = description

    @property
    def id(self):
        """
        Gets the id of this VcdUser.
        Unique id for the user.

        :return: The id of this VcdUser.
        :rtype: str
        """
        return self._id

    @id.setter
    def id(self, id):
        """
        Sets the id of this VcdUser.
        Unique id for the user.

        :param id: The id of this VcdUser.
        :type: str
        """

        self._id = id

    @property
    def role_entity_refs(self):
        """
        Gets the role_entity_refs of this VcdUser.
        The role(s) of the user. If isGroupRole is true, this user inherits their role(s) from group membership(s)

        :return: The role_entity_refs of this VcdUser.
        :rtype: list[EntityReference]
        """
        return self._role_entity_refs

    @role_entity_refs.setter
    def role_entity_refs(self, role_entity_refs):
        """
        Sets the role_entity_refs of this VcdUser.
        The role(s) of the user. If isGroupRole is true, this user inherits their role(s) from group membership(s)

        :param role_entity_refs: The role_entity_refs of this VcdUser.
        :type: list[EntityReference]
        """
        if role_entity_refs is None:
            raise ValueError("Invalid value for `role_entity_refs`, must not be `None`")

        self._role_entity_refs = role_entity_refs

    @property
    def org_entity_ref(self):
        """
        Gets the org_entity_ref of this VcdUser.
        Organization that the user belongs to.

        :return: The org_entity_ref of this VcdUser.
        :rtype: EntityReference
        """
        return self._org_entity_ref

    @org_entity_ref.setter
    def org_entity_ref(self, org_entity_ref):
        """
        Sets the org_entity_ref of this VcdUser.
        Organization that the user belongs to.

        :param org_entity_ref: The org_entity_ref of this VcdUser.
        :type: EntityReference
        """

        self._org_entity_ref = org_entity_ref

    @property
    def password(self):
        """
        Gets the password of this VcdUser.
        Password for the user. Must be null for external users.

        :return: The password of this VcdUser.
        :rtype: str
        """
        return self._password

    @password.setter
    def password(self, password):
        """
        Sets the password of this VcdUser.
        Password for the user. Must be null for external users.

        :param password: The password of this VcdUser.
        :type: str
        """

        self._password = password

    @property
    def deployed_vm_quota(self):
        """
        Gets the deployed_vm_quota of this VcdUser.
        The deployed VM quota for this user. Defaults to 0 which means unlimited. This property is deprecated in 35.0. Use user quotas API.

        :return: The deployed_vm_quota of this VcdUser.
        :rtype: int
        """
        return self._deployed_vm_quota

    @deployed_vm_quota.setter
    def deployed_vm_quota(self, deployed_vm_quota):
        """
        Sets the deployed_vm_quota of this VcdUser.
        The deployed VM quota for this user. Defaults to 0 which means unlimited. This property is deprecated in 35.0. Use user quotas API.

        :param deployed_vm_quota: The deployed_vm_quota of this VcdUser.
        :type: int
        """

        self._deployed_vm_quota = deployed_vm_quota

    @property
    def stored_vm_quota(self):
        """
        Gets the stored_vm_quota of this VcdUser.
        The stored VM quota for this user. Defaults to 0 which means unlimited. This property is deprecated in 35.0. Use user quotas API.

        :return: The stored_vm_quota of this VcdUser.
        :rtype: int
        """
        return self._stored_vm_quota

    @stored_vm_quota.setter
    def stored_vm_quota(self, stored_vm_quota):
        """
        Sets the stored_vm_quota of this VcdUser.
        The stored VM quota for this user. Defaults to 0 which means unlimited. This property is deprecated in 35.0. Use user quotas API.

        :param stored_vm_quota: The stored_vm_quota of this VcdUser.
        :type: int
        """

        self._stored_vm_quota = stored_vm_quota

    @property
    def email(self):
        """
        Gets the email of this VcdUser.
        A user's email address. Based on org email preferences, notifications can be sent to the user via email.

        :return: The email of this VcdUser.
        :rtype: str
        """
        return self._email

    @email.setter
    def email(self, email):
        """
        Sets the email of this VcdUser.
        A user's email address. Based on org email preferences, notifications can be sent to the user via email.

        :param email: The email of this VcdUser.
        :type: str
        """

        self._email = email

    @property
    def name_in_source(self):
        """
        Gets the name_in_source of this VcdUser.
        Name of the user in its source.

        :return: The name_in_source of this VcdUser.
        :rtype: str
        """
        return self._name_in_source

    @name_in_source.setter
    def name_in_source(self, name_in_source):
        """
        Sets the name_in_source of this VcdUser.
        Name of the user in its source.

        :param name_in_source: The name_in_source of this VcdUser.
        :type: str
        """

        self._name_in_source = name_in_source

    @property
    def enabled(self):
        """
        Gets the enabled of this VcdUser.
        Enabled state of the user. Defaults to true.

        :return: The enabled of this VcdUser.
        :rtype: bool
        """
        return self._enabled

    @enabled.setter
    def enabled(self, enabled):
        """
        Sets the enabled of this VcdUser.
        Enabled state of the user. Defaults to true.

        :param enabled: The enabled of this VcdUser.
        :type: bool
        """

        self._enabled = enabled

    @property
    def is_group_role(self):
        """
        Gets the is_group_role of this VcdUser.
        Determines if this user's role is inherited from a group. Defaults to false.

        :return: The is_group_role of this VcdUser.
        :rtype: bool
        """
        return self._is_group_role

    @is_group_role.setter
    def is_group_role(self, is_group_role):
        """
        Sets the is_group_role of this VcdUser.
        Determines if this user's role is inherited from a group. Defaults to false.

        :param is_group_role: The is_group_role of this VcdUser.
        :type: bool
        """

        self._is_group_role = is_group_role

    @property
    def provider_type(self):
        """
        Gets the provider_type of this VcdUser.
        Provider type of the user. It is immutable and must be one of: LOCAL, LDAP, SAML, OAUTH.

        :return: The provider_type of this VcdUser.
        :rtype: str
        """
        return self._provider_type

    @provider_type.setter
    def provider_type(self, provider_type):
        """
        Sets the provider_type of this VcdUser.
        Provider type of the user. It is immutable and must be one of: LOCAL, LDAP, SAML, OAUTH.

        :param provider_type: The provider_type of this VcdUser.
        :type: str
        """

        self._provider_type = provider_type

    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """
        Returns the string representation of the model
        """
        return pformat(self.to_dict())

    def __repr__(self):
        """
        For `print` and `pprint`
        """
        return self.to_str()

    def __eq__(self, other):
        """
        Returns true if both objects are equal
        """
        if not isinstance(other, VcdUser):
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """
        Returns true if both objects are not equal
        """
        return not self == other
