# coding: utf-8

"""
    VMware Cloud Director OpenAPI

    VMware Cloud Director OpenAPI is a new API that is defined using the OpenAPI standards.<br/> This ReSTful API borrows some elements of the legacy VMware Cloud Director API and establishes new patterns for use as described below. <h4>Authentication</h4> Authentication and Authorization schemes are the same as those for the legacy APIs. You can authenticate using the JWT token via the <code>Authorization</code> header or specifying a session using <code>x-vcloud-authorization</code> (The latter form is deprecated). <h4>Operation Patterns</h4> This API follows the following general guidelines to establish a consistent CRUD pattern: <table> <tr>   <th>Operation</th><th>Description</th><th>Response Code</th><th>Response Content</th> </tr><tr>   <td>GET /items<td>Returns a paginated list of items<td>200<td>Response will include Navigational links to the items in the list. </tr><tr>   <td>POST /items<td>Returns newly created item<td>201<td>Content-Location header links to the newly created item </tr><tr>   <td>GET /items/urn<td>Returns an individual item<td>200<td>A single item using same data type as that included in list above </tr><tr>   <td>PUT /items/urn<td>Updates an individual item<td>200<td>Updated view of the item is returned </tr><tr>   <td>DELETE /items/urn<td>Deletes the item<td>204<td>No content is returned. </tr> </table> <h5>Asynchronous operations</h5> Asynchronous operations are determined by the server. In those cases, instead of responding as described above, the server responds with an HTTP Response code 202 and an empty body. The tracking task (which is the same task as all legacy API operations use) is linked via the URI provided in the <code>Location</code> header.<br/> All API calls can choose to service a request asynchronously or synchronously as determined by the server upon interpreting the request. Operations that choose to exhibit this dual behavior will have both options documented by specifying both response code(s) below. The caller must be prepared to handle responses to such API calls by inspecting the HTTP Response code. <h5>Error Conditions</h5> <b>All</b> operations report errors using the following error reporting rules: <ul>   <li>400: Bad Request - In event of bad request due to incorrect data or other user error</li>   <li>401: Bad Request - If user is unauthenticated or their session has expired</li>   <li>403: Forbidden - If the user is not authorized or the entity does not exist</li> </ul> <h4>OpenAPI Design Concepts and Principles</h4> <ul>   <li>IDs are full Uniform Resource Names (URNs).</li>   <li>OpenAPI's <code>Content-Type</code> is always <code>application/json</code></li>   <li>REST links are in the Link header.</li>   <ul>     <li>Multiple relationships for any link are represented by multiple values in a space-separated list.</li>     <li>Links have a custom VMware Cloud Director-specific &quot;model&quot; attribute that hints at the applicable data         type for the links.</li>     <li>title + rel + model attributes evaluates to a unique link.</li>     <li>Links follow Hypermedia as the Engine of Application State (HATEOAS) principles. Links are present if         certain operations are present and permitted for the user&quot;s current role and the state of the         referred entities.</li>   </ul>   <li>APIs follow a flat structure relying on cross-referencing other entities instead of the navigational style       used by the legacy VMware Cloud Director APIs.</li>   <li>Most endpoints that return a list support filtering and sorting similar to the query service in the legacy       VMware Cloud Director APIs.</li>   <li>Accept header must be included to specify the API version for the request similar to calls to existing legacy       VMware Cloud Director APIs.</li>   <li>Each feature has a version in the path element present in its URL.<br/>       <b>Note</b> API URL's without a version in their paths must be considered experimental.</li> </ul> 

    OpenAPI spec version: 36.0
    Contact: https://code.vmware.com/support
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""


from pprint import pformat
from six import iteritems
import re


class VCenterServer(object):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """


    """
    Attributes:
      swagger_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    swagger_types = {
        'vc_id': 'str',
        'name': 'str',
        'description': 'str',
        'username': 'str',
        'password': 'str',
        'url': 'str',
        'is_enabled': 'bool',
        'vsphere_web_client_server_url': 'str',
        'has_proxy': 'bool',
        'root_folder': 'str',
        'vc_none_network': 'str',
        'tenant_visible_name': 'str',
        'is_connected': 'bool',
        'mode': 'str',
        'listener_state': 'str',
        'cluster_health_status': 'str',
        'vc_version': 'str',
        'build_number': 'str',
        'uuid': 'str',
        'nsx_v_manager': 'NsxVManager',
        'proxy_configuration_urn': 'str'
    }

    attribute_map = {
        'vc_id': 'vcId',
        'name': 'name',
        'description': 'description',
        'username': 'username',
        'password': 'password',
        'url': 'url',
        'is_enabled': 'isEnabled',
        'vsphere_web_client_server_url': 'vsphereWebClientServerUrl',
        'has_proxy': 'hasProxy',
        'root_folder': 'rootFolder',
        'vc_none_network': 'vcNoneNetwork',
        'tenant_visible_name': 'tenantVisibleName',
        'is_connected': 'isConnected',
        'mode': 'mode',
        'listener_state': 'listenerState',
        'cluster_health_status': 'clusterHealthStatus',
        'vc_version': 'vcVersion',
        'build_number': 'buildNumber',
        'uuid': 'uuid',
        'nsx_v_manager': 'nsxVManager',
        'proxy_configuration_urn': 'proxyConfigurationUrn'
    }

    def __init__(self, vc_id=None, name=None, description=None, username=None, password=None, url=None, is_enabled=False, vsphere_web_client_server_url=None, has_proxy=False, root_folder=None, vc_none_network=None, tenant_visible_name=None, is_connected=False, mode=None, listener_state=None, cluster_health_status=None, vc_version=None, build_number=None, uuid=None, nsx_v_manager=None, proxy_configuration_urn=None):
        """
        VCenterServer - a model defined in Swagger
        """

        self._vc_id = None
        self._name = None
        self._description = None
        self._username = None
        self._password = None
        self._url = None
        self._is_enabled = None
        self._vsphere_web_client_server_url = None
        self._has_proxy = None
        self._root_folder = None
        self._vc_none_network = None
        self._tenant_visible_name = None
        self._is_connected = None
        self._mode = None
        self._listener_state = None
        self._cluster_health_status = None
        self._vc_version = None
        self._build_number = None
        self._uuid = None
        self._nsx_v_manager = None
        self._proxy_configuration_urn = None

        if vc_id is not None:
          self.vc_id = vc_id
        self.name = name
        if description is not None:
          self.description = description
        self.username = username
        if password is not None:
          self.password = password
        self.url = url
        if is_enabled is not None:
          self.is_enabled = is_enabled
        if vsphere_web_client_server_url is not None:
          self.vsphere_web_client_server_url = vsphere_web_client_server_url
        if has_proxy is not None:
          self.has_proxy = has_proxy
        if root_folder is not None:
          self.root_folder = root_folder
        if vc_none_network is not None:
          self.vc_none_network = vc_none_network
        if tenant_visible_name is not None:
          self.tenant_visible_name = tenant_visible_name
        if is_connected is not None:
          self.is_connected = is_connected
        if mode is not None:
          self.mode = mode
        if listener_state is not None:
          self.listener_state = listener_state
        if cluster_health_status is not None:
          self.cluster_health_status = cluster_health_status
        if vc_version is not None:
          self.vc_version = vc_version
        if build_number is not None:
          self.build_number = build_number
        if uuid is not None:
          self.uuid = uuid
        if nsx_v_manager is not None:
          self.nsx_v_manager = nsx_v_manager
        if proxy_configuration_urn is not None:
          self.proxy_configuration_urn = proxy_configuration_urn

    @property
    def vc_id(self):
        """
        Gets the vc_id of this VCenterServer.
        URN of the associated vCenter server.

        :return: The vc_id of this VCenterServer.
        :rtype: str
        """
        return self._vc_id

    @vc_id.setter
    def vc_id(self, vc_id):
        """
        Sets the vc_id of this VCenterServer.
        URN of the associated vCenter server.

        :param vc_id: The vc_id of this VCenterServer.
        :type: str
        """

        self._vc_id = vc_id

    @property
    def name(self):
        """
        Gets the name of this VCenterServer.
        The name of the vCenter server.

        :return: The name of this VCenterServer.
        :rtype: str
        """
        return self._name

    @name.setter
    def name(self, name):
        """
        Sets the name of this VCenterServer.
        The name of the vCenter server.

        :param name: The name of this VCenterServer.
        :type: str
        """
        if name is None:
            raise ValueError("Invalid value for `name`, must not be `None`")

        self._name = name

    @property
    def description(self):
        """
        Gets the description of this VCenterServer.
        Optional description.

        :return: The description of this VCenterServer.
        :rtype: str
        """
        return self._description

    @description.setter
    def description(self, description):
        """
        Sets the description of this VCenterServer.
        Optional description.

        :param description: The description of this VCenterServer.
        :type: str
        """

        self._description = description

    @property
    def username(self):
        """
        Gets the username of this VCenterServer.
        User name to connect to the server.

        :return: The username of this VCenterServer.
        :rtype: str
        """
        return self._username

    @username.setter
    def username(self, username):
        """
        Sets the username of this VCenterServer.
        User name to connect to the server.

        :param username: The username of this VCenterServer.
        :type: str
        """
        if username is None:
            raise ValueError("Invalid value for `username`, must not be `None`")

        self._username = username

    @property
    def password(self):
        """
        Gets the password of this VCenterServer.
        Cleartext password to connect to the server.

        :return: The password of this VCenterServer.
        :rtype: str
        """
        return self._password

    @password.setter
    def password(self, password):
        """
        Sets the password of this VCenterServer.
        Cleartext password to connect to the server.

        :param password: The password of this VCenterServer.
        :type: str
        """

        self._password = password

    @property
    def url(self):
        """
        Gets the url of this VCenterServer.
        URL of the server.

        :return: The url of this VCenterServer.
        :rtype: str
        """
        return self._url

    @url.setter
    def url(self, url):
        """
        Sets the url of this VCenterServer.
        URL of the server.

        :param url: The url of this VCenterServer.
        :type: str
        """
        if url is None:
            raise ValueError("Invalid value for `url`, must not be `None`")

        self._url = url

    @property
    def is_enabled(self):
        """
        Gets the is_enabled of this VCenterServer.
        True if the vCenter server is enabled for use with vCloud Director.

        :return: The is_enabled of this VCenterServer.
        :rtype: bool
        """
        return self._is_enabled

    @is_enabled.setter
    def is_enabled(self, is_enabled):
        """
        Sets the is_enabled of this VCenterServer.
        True if the vCenter server is enabled for use with vCloud Director.

        :param is_enabled: The is_enabled of this VCenterServer.
        :type: bool
        """

        self._is_enabled = is_enabled

    @property
    def vsphere_web_client_server_url(self):
        """
        Gets the vsphere_web_client_server_url of this VCenterServer.
        The URL of vCenter web client server.

        :return: The vsphere_web_client_server_url of this VCenterServer.
        :rtype: str
        """
        return self._vsphere_web_client_server_url

    @vsphere_web_client_server_url.setter
    def vsphere_web_client_server_url(self, vsphere_web_client_server_url):
        """
        Sets the vsphere_web_client_server_url of this VCenterServer.
        The URL of vCenter web client server.

        :param vsphere_web_client_server_url: The vsphere_web_client_server_url of this VCenterServer.
        :type: str
        """

        self._vsphere_web_client_server_url = vsphere_web_client_server_url

    @property
    def has_proxy(self):
        """
        Gets the has_proxy of this VCenterServer.
        When present, indicates that a proxy exists within vCloud Director that proxies this vCenter server for access by authorized end-users. Setting this field to true when registering a vCenter server will result in a proxy being created for the vCenter server, and another for the corresponding SSO endpoint (if different from the vCenter server's endpoint). This field is immutable after the vCenter Server is registered, and will be updated by the system when/if the proxy is removed.

        :return: The has_proxy of this VCenterServer.
        :rtype: bool
        """
        return self._has_proxy

    @has_proxy.setter
    def has_proxy(self, has_proxy):
        """
        Sets the has_proxy of this VCenterServer.
        When present, indicates that a proxy exists within vCloud Director that proxies this vCenter server for access by authorized end-users. Setting this field to true when registering a vCenter server will result in a proxy being created for the vCenter server, and another for the corresponding SSO endpoint (if different from the vCenter server's endpoint). This field is immutable after the vCenter Server is registered, and will be updated by the system when/if the proxy is removed.

        :param has_proxy: The has_proxy of this VCenterServer.
        :type: bool
        """

        self._has_proxy = has_proxy

    @property
    def root_folder(self):
        """
        Gets the root_folder of this VCenterServer.
        vCenter root folder in which the vCloud Director system folder will be created. This parameter only takes the folder name and not directory structure.

        :return: The root_folder of this VCenterServer.
        :rtype: str
        """
        return self._root_folder

    @root_folder.setter
    def root_folder(self, root_folder):
        """
        Sets the root_folder of this VCenterServer.
        vCenter root folder in which the vCloud Director system folder will be created. This parameter only takes the folder name and not directory structure.

        :param root_folder: The root_folder of this VCenterServer.
        :type: str
        """

        self._root_folder = root_folder

    @property
    def vc_none_network(self):
        """
        Gets the vc_none_network of this VCenterServer.
        Network in Vcenter to be used as 'NONE' network by vCD.

        :return: The vc_none_network of this VCenterServer.
        :rtype: str
        """
        return self._vc_none_network

    @vc_none_network.setter
    def vc_none_network(self, vc_none_network):
        """
        Sets the vc_none_network of this VCenterServer.
        Network in Vcenter to be used as 'NONE' network by vCD.

        :param vc_none_network: The vc_none_network of this VCenterServer.
        :type: str
        """

        self._vc_none_network = vc_none_network

    @property
    def tenant_visible_name(self):
        """
        Gets the tenant_visible_name of this VCenterServer.
        Public label of this vCenter server visible to all tenants.

        :return: The tenant_visible_name of this VCenterServer.
        :rtype: str
        """
        return self._tenant_visible_name

    @tenant_visible_name.setter
    def tenant_visible_name(self, tenant_visible_name):
        """
        Sets the tenant_visible_name of this VCenterServer.
        Public label of this vCenter server visible to all tenants.

        :param tenant_visible_name: The tenant_visible_name of this VCenterServer.
        :type: str
        """

        self._tenant_visible_name = tenant_visible_name

    @property
    def is_connected(self):
        """
        Gets the is_connected of this VCenterServer.
        True if the vCenter server is connected.

        :return: The is_connected of this VCenterServer.
        :rtype: bool
        """
        return self._is_connected

    @is_connected.setter
    def is_connected(self, is_connected):
        """
        Sets the is_connected of this VCenterServer.
        True if the vCenter server is connected.

        :param is_connected: The is_connected of this VCenterServer.
        :type: bool
        """

        self._is_connected = is_connected

    @property
    def mode(self):
        """
        Gets the mode of this VCenterServer.
        The vcenter mode. One of <ul> <li>NONE - undetermined</li> <li>IAAS - provider scoped</li> <li>SDDC - tenant scoped</li> <li>MIXED</li> </ul> IAAS indicates this vCenter server is scoped to the provider. SDDC indicates that this vCenter server is scoped to tenants, while MIXED indicates mixed mode, where both uses are allowed in this vCenter server.

        :return: The mode of this VCenterServer.
        :rtype: str
        """
        return self._mode

    @mode.setter
    def mode(self, mode):
        """
        Sets the mode of this VCenterServer.
        The vcenter mode. One of <ul> <li>NONE - undetermined</li> <li>IAAS - provider scoped</li> <li>SDDC - tenant scoped</li> <li>MIXED</li> </ul> IAAS indicates this vCenter server is scoped to the provider. SDDC indicates that this vCenter server is scoped to tenants, while MIXED indicates mixed mode, where both uses are allowed in this vCenter server.

        :param mode: The mode of this VCenterServer.
        :type: str
        """
        allowed_values = ["NONE", "IAAS", "SDDC", "MIXED"]
        if mode not in allowed_values:
            raise ValueError(
                "Invalid value for `mode` ({0}), must be one of {1}"
                .format(mode, allowed_values)
            )

        self._mode = mode

    @property
    def listener_state(self):
        """
        Gets the listener_state of this VCenterServer.
        The vcenter listener state. One of <ul> <li>INITIAL</li> <li>INVALID_SETTINGS</li> <li>UNSUPPORTED</li> <li>DISCONNECTED</li> <li>CONNECTING</li> <li>CONNECTED_SYNCING</li> <li>CONNECTED</li> <li>STOP_REQ</li> <li>STOP_AND_PURGE_REQ</li> <li>STOP_ACK</li> </ul>

        :return: The listener_state of this VCenterServer.
        :rtype: str
        """
        return self._listener_state

    @listener_state.setter
    def listener_state(self, listener_state):
        """
        Sets the listener_state of this VCenterServer.
        The vcenter listener state. One of <ul> <li>INITIAL</li> <li>INVALID_SETTINGS</li> <li>UNSUPPORTED</li> <li>DISCONNECTED</li> <li>CONNECTING</li> <li>CONNECTED_SYNCING</li> <li>CONNECTED</li> <li>STOP_REQ</li> <li>STOP_AND_PURGE_REQ</li> <li>STOP_ACK</li> </ul>

        :param listener_state: The listener_state of this VCenterServer.
        :type: str
        """

        self._listener_state = listener_state

    @property
    def cluster_health_status(self):
        """
        Gets the cluster_health_status of this VCenterServer.
        The overall health status of clusters in this vCenter server. One of <ul> <li>GRAY</li> <li>RED</li> <li>YELLOW</li> <li>GREEN</li> </ul>

        :return: The cluster_health_status of this VCenterServer.
        :rtype: str
        """
        return self._cluster_health_status

    @cluster_health_status.setter
    def cluster_health_status(self, cluster_health_status):
        """
        Sets the cluster_health_status of this VCenterServer.
        The overall health status of clusters in this vCenter server. One of <ul> <li>GRAY</li> <li>RED</li> <li>YELLOW</li> <li>GREEN</li> </ul>

        :param cluster_health_status: The cluster_health_status of this VCenterServer.
        :type: str
        """
        allowed_values = ["GRAY", "RED", "YELLOW", "GREEN"]
        if cluster_health_status not in allowed_values:
            raise ValueError(
                "Invalid value for `cluster_health_status` ({0}), must be one of {1}"
                .format(cluster_health_status, allowed_values)
            )

        self._cluster_health_status = cluster_health_status

    @property
    def vc_version(self):
        """
        Gets the vc_version of this VCenterServer.
        The version of the VIM server.

        :return: The vc_version of this VCenterServer.
        :rtype: str
        """
        return self._vc_version

    @vc_version.setter
    def vc_version(self, vc_version):
        """
        Sets the vc_version of this VCenterServer.
        The version of the VIM server.

        :param vc_version: The vc_version of this VCenterServer.
        :type: str
        """

        self._vc_version = vc_version

    @property
    def build_number(self):
        """
        Gets the build_number of this VCenterServer.
        The build number of the VIM server.

        :return: The build_number of this VCenterServer.
        :rtype: str
        """
        return self._build_number

    @build_number.setter
    def build_number(self, build_number):
        """
        Sets the build_number of this VCenterServer.
        The build number of the VIM server.

        :param build_number: The build_number of this VCenterServer.
        :type: str
        """

        self._build_number = build_number

    @property
    def uuid(self):
        """
        Gets the uuid of this VCenterServer.
        The instance UUID property of the vCenter server.

        :return: The uuid of this VCenterServer.
        :rtype: str
        """
        return self._uuid

    @uuid.setter
    def uuid(self, uuid):
        """
        Sets the uuid of this VCenterServer.
        The instance UUID property of the vCenter server.

        :param uuid: The uuid of this VCenterServer.
        :type: str
        """

        self._uuid = uuid

    @property
    def nsx_v_manager(self):
        """
        Gets the nsx_v_manager of this VCenterServer.
        the NSX-V attached to this Virtual Center server, when present.

        :return: The nsx_v_manager of this VCenterServer.
        :rtype: NsxVManager
        """
        return self._nsx_v_manager

    @nsx_v_manager.setter
    def nsx_v_manager(self, nsx_v_manager):
        """
        Sets the nsx_v_manager of this VCenterServer.
        the NSX-V attached to this Virtual Center server, when present.

        :param nsx_v_manager: The nsx_v_manager of this VCenterServer.
        :type: NsxVManager
        """

        self._nsx_v_manager = nsx_v_manager

    @property
    def proxy_configuration_urn(self):
        """
        Gets the proxy_configuration_urn of this VCenterServer.

        :return: The proxy_configuration_urn of this VCenterServer.
        :rtype: str
        """
        return self._proxy_configuration_urn

    @proxy_configuration_urn.setter
    def proxy_configuration_urn(self, proxy_configuration_urn):
        """
        Sets the proxy_configuration_urn of this VCenterServer.

        :param proxy_configuration_urn: The proxy_configuration_urn of this VCenterServer.
        :type: str
        """

        self._proxy_configuration_urn = proxy_configuration_urn

    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """
        Returns the string representation of the model
        """
        return pformat(self.to_dict())

    def __repr__(self):
        """
        For `print` and `pprint`
        """
        return self.to_str()

    def __eq__(self, other):
        """
        Returns true if both objects are equal
        """
        if not isinstance(other, VCenterServer):
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """
        Returns true if both objects are not equal
        """
        return not self == other
