# coding: utf-8

"""
    VMware Cloud Director OpenAPI

    VMware Cloud Director OpenAPI is a new API that is defined using the OpenAPI standards.<br/> This ReSTful API borrows some elements of the legacy VMware Cloud Director API and establishes new patterns for use as described below. <h4>Authentication</h4> Authentication and Authorization schemes are the same as those for the legacy APIs. You can authenticate using the JWT token via the <code>Authorization</code> header or specifying a session using <code>x-vcloud-authorization</code> (The latter form is deprecated). <h4>Operation Patterns</h4> This API follows the following general guidelines to establish a consistent CRUD pattern: <table> <tr>   <th>Operation</th><th>Description</th><th>Response Code</th><th>Response Content</th> </tr><tr>   <td>GET /items<td>Returns a paginated list of items<td>200<td>Response will include Navigational links to the items in the list. </tr><tr>   <td>POST /items<td>Returns newly created item<td>201<td>Content-Location header links to the newly created item </tr><tr>   <td>GET /items/urn<td>Returns an individual item<td>200<td>A single item using same data type as that included in list above </tr><tr>   <td>PUT /items/urn<td>Updates an individual item<td>200<td>Updated view of the item is returned </tr><tr>   <td>DELETE /items/urn<td>Deletes the item<td>204<td>No content is returned. </tr> </table> <h5>Asynchronous operations</h5> Asynchronous operations are determined by the server. In those cases, instead of responding as described above, the server responds with an HTTP Response code 202 and an empty body. The tracking task (which is the same task as all legacy API operations use) is linked via the URI provided in the <code>Location</code> header.<br/> All API calls can choose to service a request asynchronously or synchronously as determined by the server upon interpreting the request. Operations that choose to exhibit this dual behavior will have both options documented by specifying both response code(s) below. The caller must be prepared to handle responses to such API calls by inspecting the HTTP Response code. <h5>Error Conditions</h5> <b>All</b> operations report errors using the following error reporting rules: <ul>   <li>400: Bad Request - In event of bad request due to incorrect data or other user error</li>   <li>401: Bad Request - If user is unauthenticated or their session has expired</li>   <li>403: Forbidden - If the user is not authorized or the entity does not exist</li> </ul> <h4>OpenAPI Design Concepts and Principles</h4> <ul>   <li>IDs are full Uniform Resource Names (URNs).</li>   <li>OpenAPI's <code>Content-Type</code> is always <code>application/json</code></li>   <li>REST links are in the Link header.</li>   <ul>     <li>Multiple relationships for any link are represented by multiple values in a space-separated list.</li>     <li>Links have a custom VMware Cloud Director-specific &quot;model&quot; attribute that hints at the applicable data         type for the links.</li>     <li>title + rel + model attributes evaluates to a unique link.</li>     <li>Links follow Hypermedia as the Engine of Application State (HATEOAS) principles. Links are present if         certain operations are present and permitted for the user&quot;s current role and the state of the         referred entities.</li>   </ul>   <li>APIs follow a flat structure relying on cross-referencing other entities instead of the navigational style       used by the legacy VMware Cloud Director APIs.</li>   <li>Most endpoints that return a list support filtering and sorting similar to the query service in the legacy       VMware Cloud Director APIs.</li>   <li>Accept header must be included to specify the API version for the request similar to calls to existing legacy       VMware Cloud Director APIs.</li>   <li>Each feature has a version in the path element present in its URL.<br/>       <b>Note</b> API URL's without a version in their paths must be considered experimental.</li> </ul> 

    OpenAPI spec version: 36.0
    Contact: https://code.vmware.com/support
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""


from pprint import pformat
from six import iteritems
import re


class SupportedPresentationElements(object):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """


    """
    Attributes:
      swagger_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    swagger_types = {
        'presentation_element': 'PresentationElement',
        'step_info': 'StepInfo',
        'group': 'Group',
        'field': 'Field',
        'primary_field': 'PrimaryField'
    }

    attribute_map = {
        'presentation_element': 'presentationElement',
        'step_info': 'stepInfo',
        'group': 'group',
        'field': 'field',
        'primary_field': 'primaryField'
    }

    def __init__(self, presentation_element=None, step_info=None, group=None, field=None, primary_field=None):
        """
        SupportedPresentationElements - a model defined in Swagger
        """

        self._presentation_element = None
        self._step_info = None
        self._group = None
        self._field = None
        self._primary_field = None

        if presentation_element is not None:
          self.presentation_element = presentation_element
        if step_info is not None:
          self.step_info = step_info
        if group is not None:
          self.group = group
        if field is not None:
          self.field = field
        if primary_field is not None:
          self.primary_field = primary_field

    @property
    def presentation_element(self):
        """
        Gets the presentation_element of this SupportedPresentationElements.

        :return: The presentation_element of this SupportedPresentationElements.
        :rtype: PresentationElement
        """
        return self._presentation_element

    @presentation_element.setter
    def presentation_element(self, presentation_element):
        """
        Sets the presentation_element of this SupportedPresentationElements.

        :param presentation_element: The presentation_element of this SupportedPresentationElements.
        :type: PresentationElement
        """

        self._presentation_element = presentation_element

    @property
    def step_info(self):
        """
        Gets the step_info of this SupportedPresentationElements.

        :return: The step_info of this SupportedPresentationElements.
        :rtype: StepInfo
        """
        return self._step_info

    @step_info.setter
    def step_info(self, step_info):
        """
        Sets the step_info of this SupportedPresentationElements.

        :param step_info: The step_info of this SupportedPresentationElements.
        :type: StepInfo
        """

        self._step_info = step_info

    @property
    def group(self):
        """
        Gets the group of this SupportedPresentationElements.

        :return: The group of this SupportedPresentationElements.
        :rtype: Group
        """
        return self._group

    @group.setter
    def group(self, group):
        """
        Sets the group of this SupportedPresentationElements.

        :param group: The group of this SupportedPresentationElements.
        :type: Group
        """

        self._group = group

    @property
    def field(self):
        """
        Gets the field of this SupportedPresentationElements.

        :return: The field of this SupportedPresentationElements.
        :rtype: Field
        """
        return self._field

    @field.setter
    def field(self, field):
        """
        Sets the field of this SupportedPresentationElements.

        :param field: The field of this SupportedPresentationElements.
        :type: Field
        """

        self._field = field

    @property
    def primary_field(self):
        """
        Gets the primary_field of this SupportedPresentationElements.

        :return: The primary_field of this SupportedPresentationElements.
        :rtype: PrimaryField
        """
        return self._primary_field

    @primary_field.setter
    def primary_field(self, primary_field):
        """
        Sets the primary_field of this SupportedPresentationElements.

        :param primary_field: The primary_field of this SupportedPresentationElements.
        :type: PrimaryField
        """

        self._primary_field = primary_field

    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """
        Returns the string representation of the model
        """
        return pformat(self.to_dict())

    def __repr__(self):
        """
        For `print` and `pprint`
        """
        return self.to_str()

    def __eq__(self, other):
        """
        Returns true if both objects are equal
        """
        if not isinstance(other, SupportedPresentationElements):
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """
        Returns true if both objects are not equal
        """
        return not self == other
