# coding: utf-8

"""
    VMware Cloud Director OpenAPI

    VMware Cloud Director OpenAPI is a new API that is defined using the OpenAPI standards.<br/> This ReSTful API borrows some elements of the legacy VMware Cloud Director API and establishes new patterns for use as described below. <h4>Authentication</h4> Authentication and Authorization schemes are the same as those for the legacy APIs. You can authenticate using the JWT token via the <code>Authorization</code> header or specifying a session using <code>x-vcloud-authorization</code> (The latter form is deprecated). <h4>Operation Patterns</h4> This API follows the following general guidelines to establish a consistent CRUD pattern: <table> <tr>   <th>Operation</th><th>Description</th><th>Response Code</th><th>Response Content</th> </tr><tr>   <td>GET /items<td>Returns a paginated list of items<td>200<td>Response will include Navigational links to the items in the list. </tr><tr>   <td>POST /items<td>Returns newly created item<td>201<td>Content-Location header links to the newly created item </tr><tr>   <td>GET /items/urn<td>Returns an individual item<td>200<td>A single item using same data type as that included in list above </tr><tr>   <td>PUT /items/urn<td>Updates an individual item<td>200<td>Updated view of the item is returned </tr><tr>   <td>DELETE /items/urn<td>Deletes the item<td>204<td>No content is returned. </tr> </table> <h5>Asynchronous operations</h5> Asynchronous operations are determined by the server. In those cases, instead of responding as described above, the server responds with an HTTP Response code 202 and an empty body. The tracking task (which is the same task as all legacy API operations use) is linked via the URI provided in the <code>Location</code> header.<br/> All API calls can choose to service a request asynchronously or synchronously as determined by the server upon interpreting the request. Operations that choose to exhibit this dual behavior will have both options documented by specifying both response code(s) below. The caller must be prepared to handle responses to such API calls by inspecting the HTTP Response code. <h5>Error Conditions</h5> <b>All</b> operations report errors using the following error reporting rules: <ul>   <li>400: Bad Request - In event of bad request due to incorrect data or other user error</li>   <li>401: Bad Request - If user is unauthenticated or their session has expired</li>   <li>403: Forbidden - If the user is not authorized or the entity does not exist</li> </ul> <h4>OpenAPI Design Concepts and Principles</h4> <ul>   <li>IDs are full Uniform Resource Names (URNs).</li>   <li>OpenAPI's <code>Content-Type</code> is always <code>application/json</code></li>   <li>REST links are in the Link header.</li>   <ul>     <li>Multiple relationships for any link are represented by multiple values in a space-separated list.</li>     <li>Links have a custom VMware Cloud Director-specific &quot;model&quot; attribute that hints at the applicable data         type for the links.</li>     <li>title + rel + model attributes evaluates to a unique link.</li>     <li>Links follow Hypermedia as the Engine of Application State (HATEOAS) principles. Links are present if         certain operations are present and permitted for the user&quot;s current role and the state of the         referred entities.</li>   </ul>   <li>APIs follow a flat structure relying on cross-referencing other entities instead of the navigational style       used by the legacy VMware Cloud Director APIs.</li>   <li>Most endpoints that return a list support filtering and sorting similar to the query service in the legacy       VMware Cloud Director APIs.</li>   <li>Accept header must be included to specify the API version for the request similar to calls to existing legacy       VMware Cloud Director APIs.</li>   <li>Each feature has a version in the path element present in its URL.<br/>       <b>Note</b> API URL's without a version in their paths must be considered experimental.</li> </ul> 

    OpenAPI spec version: 36.0
    Contact: https://code.vmware.com/support
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""


from pprint import pformat
from six import iteritems
import re


class SslSettings(object):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """


    """
    Attributes:
      swagger_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    swagger_types = {
        'enabled_ssl_protocols': 'list[str]',
        'enabled_ssl_ciphers': 'list[str]',
        'key_size': 'int',
        'certificate_validity_days': 'int',
        'certificate_signature_algorithm': 'str',
        'fips_mode': 'str',
        'status': 'str'
    }

    attribute_map = {
        'enabled_ssl_protocols': 'enabledSslProtocols',
        'enabled_ssl_ciphers': 'enabledSslCiphers',
        'key_size': 'keySize',
        'certificate_validity_days': 'certificateValidityDays',
        'certificate_signature_algorithm': 'certificateSignatureAlgorithm',
        'fips_mode': 'fipsMode',
        'status': 'status'
    }

    def __init__(self, enabled_ssl_protocols=None, enabled_ssl_ciphers=None, key_size=None, certificate_validity_days=None, certificate_signature_algorithm=None, fips_mode='OFF', status='CURRENT'):
        """
        SslSettings - a model defined in Swagger
        """

        self._enabled_ssl_protocols = None
        self._enabled_ssl_ciphers = None
        self._key_size = None
        self._certificate_validity_days = None
        self._certificate_signature_algorithm = None
        self._fips_mode = None
        self._status = None

        if enabled_ssl_protocols is not None:
          self.enabled_ssl_protocols = enabled_ssl_protocols
        if enabled_ssl_ciphers is not None:
          self.enabled_ssl_ciphers = enabled_ssl_ciphers
        if key_size is not None:
          self.key_size = key_size
        if certificate_validity_days is not None:
          self.certificate_validity_days = certificate_validity_days
        if certificate_signature_algorithm is not None:
          self.certificate_signature_algorithm = certificate_signature_algorithm
        if fips_mode is not None:
          self.fips_mode = fips_mode
        if status is not None:
          self.status = status

    @property
    def enabled_ssl_protocols(self):
        """
        Gets the enabled_ssl_protocols of this SslSettings.
        SSL protocols

        :return: The enabled_ssl_protocols of this SslSettings.
        :rtype: list[str]
        """
        return self._enabled_ssl_protocols

    @enabled_ssl_protocols.setter
    def enabled_ssl_protocols(self, enabled_ssl_protocols):
        """
        Sets the enabled_ssl_protocols of this SslSettings.
        SSL protocols

        :param enabled_ssl_protocols: The enabled_ssl_protocols of this SslSettings.
        :type: list[str]
        """

        self._enabled_ssl_protocols = enabled_ssl_protocols

    @property
    def enabled_ssl_ciphers(self):
        """
        Gets the enabled_ssl_ciphers of this SslSettings.
        SSL ciphers

        :return: The enabled_ssl_ciphers of this SslSettings.
        :rtype: list[str]
        """
        return self._enabled_ssl_ciphers

    @enabled_ssl_ciphers.setter
    def enabled_ssl_ciphers(self, enabled_ssl_ciphers):
        """
        Sets the enabled_ssl_ciphers of this SslSettings.
        SSL ciphers

        :param enabled_ssl_ciphers: The enabled_ssl_ciphers of this SslSettings.
        :type: list[str]
        """

        self._enabled_ssl_ciphers = enabled_ssl_ciphers

    @property
    def key_size(self):
        """
        Gets the key_size of this SslSettings.
        Size of keys generated

        :return: The key_size of this SslSettings.
        :rtype: int
        """
        return self._key_size

    @key_size.setter
    def key_size(self, key_size):
        """
        Sets the key_size of this SslSettings.
        Size of keys generated

        :param key_size: The key_size of this SslSettings.
        :type: int
        """

        self._key_size = key_size

    @property
    def certificate_validity_days(self):
        """
        Gets the certificate_validity_days of this SslSettings.
        Number of days generated certificates are valid for

        :return: The certificate_validity_days of this SslSettings.
        :rtype: int
        """
        return self._certificate_validity_days

    @certificate_validity_days.setter
    def certificate_validity_days(self, certificate_validity_days):
        """
        Sets the certificate_validity_days of this SslSettings.
        Number of days generated certificates are valid for

        :param certificate_validity_days: The certificate_validity_days of this SslSettings.
        :type: int
        """

        self._certificate_validity_days = certificate_validity_days

    @property
    def certificate_signature_algorithm(self):
        """
        Gets the certificate_signature_algorithm of this SslSettings.
        Algorithm used to sign generated certificates

        :return: The certificate_signature_algorithm of this SslSettings.
        :rtype: str
        """
        return self._certificate_signature_algorithm

    @certificate_signature_algorithm.setter
    def certificate_signature_algorithm(self, certificate_signature_algorithm):
        """
        Sets the certificate_signature_algorithm of this SslSettings.
        Algorithm used to sign generated certificates

        :param certificate_signature_algorithm: The certificate_signature_algorithm of this SslSettings.
        :type: str
        """

        self._certificate_signature_algorithm = certificate_signature_algorithm

    @property
    def fips_mode(self):
        """
        Gets the fips_mode of this SslSettings.
        The desired FIPS mode of this server group. <ul>   <li>     <em>ON</em>: Indicates FIPS mode is desired for this server group.   </li>   <li>     <em>OFF</em>: Indicates FIPS mode is not desired for this server group.   </li> </ul> 

        :return: The fips_mode of this SslSettings.
        :rtype: str
        """
        return self._fips_mode

    @fips_mode.setter
    def fips_mode(self, fips_mode):
        """
        Sets the fips_mode of this SslSettings.
        The desired FIPS mode of this server group. <ul>   <li>     <em>ON</em>: Indicates FIPS mode is desired for this server group.   </li>   <li>     <em>OFF</em>: Indicates FIPS mode is not desired for this server group.   </li> </ul> 

        :param fips_mode: The fips_mode of this SslSettings.
        :type: str
        """

        self._fips_mode = fips_mode

    @property
    def status(self):
        """
        Gets the status of this SslSettings.
        The current SSL settings status for this server group. <ul>   <li>     <em>CURRENT</em>: Indicates that all of the SSL settings for this server group are up to date.   </li>   <li>     <em>UPDATING</em>: Indicates that there is at least one cell in the server group which has not yet     applied the SSL settings.   </li>   <li>     <em>AWAITING_RESTART</em>: Indicates that the SSL settings for this server group have been applied on each cell,     and that each cell needs to be rebooted for the settings to take place. When each cell has been rebooted this field     will change to CURRENT.   </li> </ul> 

        :return: The status of this SslSettings.
        :rtype: str
        """
        return self._status

    @status.setter
    def status(self, status):
        """
        Sets the status of this SslSettings.
        The current SSL settings status for this server group. <ul>   <li>     <em>CURRENT</em>: Indicates that all of the SSL settings for this server group are up to date.   </li>   <li>     <em>UPDATING</em>: Indicates that there is at least one cell in the server group which has not yet     applied the SSL settings.   </li>   <li>     <em>AWAITING_RESTART</em>: Indicates that the SSL settings for this server group have been applied on each cell,     and that each cell needs to be rebooted for the settings to take place. When each cell has been rebooted this field     will change to CURRENT.   </li> </ul> 

        :param status: The status of this SslSettings.
        :type: str
        """

        self._status = status

    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """
        Returns the string representation of the model
        """
        return pformat(self.to_dict())

    def __repr__(self):
        """
        For `print` and `pprint`
        """
        return self.to_str()

    def __eq__(self, other):
        """
        Returns true if both objects are equal
        """
        if not isinstance(other, SslSettings):
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """
        Returns true if both objects are not equal
        """
        return not self == other
