# coding: utf-8

"""
    VMware Cloud Director OpenAPI

    VMware Cloud Director OpenAPI is a new API that is defined using the OpenAPI standards.<br/> This ReSTful API borrows some elements of the legacy VMware Cloud Director API and establishes new patterns for use as described below. <h4>Authentication</h4> Authentication and Authorization schemes are the same as those for the legacy APIs. You can authenticate using the JWT token via the <code>Authorization</code> header or specifying a session using <code>x-vcloud-authorization</code> (The latter form is deprecated). <h4>Operation Patterns</h4> This API follows the following general guidelines to establish a consistent CRUD pattern: <table> <tr>   <th>Operation</th><th>Description</th><th>Response Code</th><th>Response Content</th> </tr><tr>   <td>GET /items<td>Returns a paginated list of items<td>200<td>Response will include Navigational links to the items in the list. </tr><tr>   <td>POST /items<td>Returns newly created item<td>201<td>Content-Location header links to the newly created item </tr><tr>   <td>GET /items/urn<td>Returns an individual item<td>200<td>A single item using same data type as that included in list above </tr><tr>   <td>PUT /items/urn<td>Updates an individual item<td>200<td>Updated view of the item is returned </tr><tr>   <td>DELETE /items/urn<td>Deletes the item<td>204<td>No content is returned. </tr> </table> <h5>Asynchronous operations</h5> Asynchronous operations are determined by the server. In those cases, instead of responding as described above, the server responds with an HTTP Response code 202 and an empty body. The tracking task (which is the same task as all legacy API operations use) is linked via the URI provided in the <code>Location</code> header.<br/> All API calls can choose to service a request asynchronously or synchronously as determined by the server upon interpreting the request. Operations that choose to exhibit this dual behavior will have both options documented by specifying both response code(s) below. The caller must be prepared to handle responses to such API calls by inspecting the HTTP Response code. <h5>Error Conditions</h5> <b>All</b> operations report errors using the following error reporting rules: <ul>   <li>400: Bad Request - In event of bad request due to incorrect data or other user error</li>   <li>401: Bad Request - If user is unauthenticated or their session has expired</li>   <li>403: Forbidden - If the user is not authorized or the entity does not exist</li> </ul> <h4>OpenAPI Design Concepts and Principles</h4> <ul>   <li>IDs are full Uniform Resource Names (URNs).</li>   <li>OpenAPI's <code>Content-Type</code> is always <code>application/json</code></li>   <li>REST links are in the Link header.</li>   <ul>     <li>Multiple relationships for any link are represented by multiple values in a space-separated list.</li>     <li>Links have a custom VMware Cloud Director-specific &quot;model&quot; attribute that hints at the applicable data         type for the links.</li>     <li>title + rel + model attributes evaluates to a unique link.</li>     <li>Links follow Hypermedia as the Engine of Application State (HATEOAS) principles. Links are present if         certain operations are present and permitted for the user&quot;s current role and the state of the         referred entities.</li>   </ul>   <li>APIs follow a flat structure relying on cross-referencing other entities instead of the navigational style       used by the legacy VMware Cloud Director APIs.</li>   <li>Most endpoints that return a list support filtering and sorting similar to the query service in the legacy       VMware Cloud Director APIs.</li>   <li>Accept header must be included to specify the API version for the request similar to calls to existing legacy       VMware Cloud Director APIs.</li>   <li>Each feature has a version in the path element present in its URL.<br/>       <b>Note</b> API URL's without a version in their paths must be considered experimental.</li> </ul> 

    OpenAPI spec version: 36.0
    Contact: https://code.vmware.com/support
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""


from pprint import pformat
from six import iteritems
import re


class RouterHealthReport(object):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """


    """
    Attributes:
      swagger_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    swagger_types = {
        'nsx_managers_health': 'list[RouterComponentHealth]',
        'control_vm_health': 'list[RouterComponentHealth]',
        'control_plane_health': 'RouterComponentHealth',
        'vdc_reachability_status': 'list[RouterComponentHealth]'
    }

    attribute_map = {
        'nsx_managers_health': 'nsxManagersHealth',
        'control_vm_health': 'controlVmHealth',
        'control_plane_health': 'controlPlaneHealth',
        'vdc_reachability_status': 'vdcReachabilityStatus'
    }

    def __init__(self, nsx_managers_health=None, control_vm_health=None, control_plane_health=None, vdc_reachability_status=None):
        """
        RouterHealthReport - a model defined in Swagger
        """

        self._nsx_managers_health = None
        self._control_vm_health = None
        self._control_plane_health = None
        self._vdc_reachability_status = None

        if nsx_managers_health is not None:
          self.nsx_managers_health = nsx_managers_health
        if control_vm_health is not None:
          self.control_vm_health = control_vm_health
        if control_plane_health is not None:
          self.control_plane_health = control_plane_health
        if vdc_reachability_status is not None:
          self.vdc_reachability_status = vdc_reachability_status

    @property
    def nsx_managers_health(self):
        """
        Gets the nsx_managers_health of this RouterHealthReport.
        Status of all the nsx managers spanned by the universal router. 

        :return: The nsx_managers_health of this RouterHealthReport.
        :rtype: list[RouterComponentHealth]
        """
        return self._nsx_managers_health

    @nsx_managers_health.setter
    def nsx_managers_health(self, nsx_managers_health):
        """
        Sets the nsx_managers_health of this RouterHealthReport.
        Status of all the nsx managers spanned by the universal router. 

        :param nsx_managers_health: The nsx_managers_health of this RouterHealthReport.
        :type: list[RouterComponentHealth]
        """

        self._nsx_managers_health = nsx_managers_health

    @property
    def control_vm_health(self):
        """
        Gets the control_vm_health of this RouterHealthReport.
        Status of all the universal router control VMs within each network provider scope. This also includes status of egress points and routes configured for the universal router. 

        :return: The control_vm_health of this RouterHealthReport.
        :rtype: list[RouterComponentHealth]
        """
        return self._control_vm_health

    @control_vm_health.setter
    def control_vm_health(self, control_vm_health):
        """
        Sets the control_vm_health of this RouterHealthReport.
        Status of all the universal router control VMs within each network provider scope. This also includes status of egress points and routes configured for the universal router. 

        :param control_vm_health: The control_vm_health of this RouterHealthReport.
        :type: list[RouterComponentHealth]
        """

        self._control_vm_health = control_vm_health

    @property
    def control_plane_health(self):
        """
        Gets the control_plane_health of this RouterHealthReport.
        Status of the nsx controller cluster associated with the nsx managers. 

        :return: The control_plane_health of this RouterHealthReport.
        :rtype: RouterComponentHealth
        """
        return self._control_plane_health

    @control_plane_health.setter
    def control_plane_health(self, control_plane_health):
        """
        Sets the control_plane_health of this RouterHealthReport.
        Status of the nsx controller cluster associated with the nsx managers. 

        :param control_plane_health: The control_plane_health of this RouterHealthReport.
        :type: RouterComponentHealth
        """

        self._control_plane_health = control_plane_health

    @property
    def vdc_reachability_status(self):
        """
        Gets the vdc_reachability_status of this RouterHealthReport.
        Reachability status for local and remote participating vDC's of referenced vDC group. States whether a vDC is reachable from this local site. 

        :return: The vdc_reachability_status of this RouterHealthReport.
        :rtype: list[RouterComponentHealth]
        """
        return self._vdc_reachability_status

    @vdc_reachability_status.setter
    def vdc_reachability_status(self, vdc_reachability_status):
        """
        Sets the vdc_reachability_status of this RouterHealthReport.
        Reachability status for local and remote participating vDC's of referenced vDC group. States whether a vDC is reachable from this local site. 

        :param vdc_reachability_status: The vdc_reachability_status of this RouterHealthReport.
        :type: list[RouterComponentHealth]
        """

        self._vdc_reachability_status = vdc_reachability_status

    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """
        Returns the string representation of the model
        """
        return pformat(self.to_dict())

    def __repr__(self):
        """
        For `print` and `pprint`
        """
        return self.to_str()

    def __eq__(self, other):
        """
        Returns true if both objects are equal
        """
        if not isinstance(other, RouterHealthReport):
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """
        Returns true if both objects are not equal
        """
        return not self == other
