# coding: utf-8

"""
    VMware Cloud Director OpenAPI

    VMware Cloud Director OpenAPI is a new API that is defined using the OpenAPI standards.<br/> This ReSTful API borrows some elements of the legacy VMware Cloud Director API and establishes new patterns for use as described below. <h4>Authentication</h4> Authentication and Authorization schemes are the same as those for the legacy APIs. You can authenticate using the JWT token via the <code>Authorization</code> header or specifying a session using <code>x-vcloud-authorization</code> (The latter form is deprecated). <h4>Operation Patterns</h4> This API follows the following general guidelines to establish a consistent CRUD pattern: <table> <tr>   <th>Operation</th><th>Description</th><th>Response Code</th><th>Response Content</th> </tr><tr>   <td>GET /items<td>Returns a paginated list of items<td>200<td>Response will include Navigational links to the items in the list. </tr><tr>   <td>POST /items<td>Returns newly created item<td>201<td>Content-Location header links to the newly created item </tr><tr>   <td>GET /items/urn<td>Returns an individual item<td>200<td>A single item using same data type as that included in list above </tr><tr>   <td>PUT /items/urn<td>Updates an individual item<td>200<td>Updated view of the item is returned </tr><tr>   <td>DELETE /items/urn<td>Deletes the item<td>204<td>No content is returned. </tr> </table> <h5>Asynchronous operations</h5> Asynchronous operations are determined by the server. In those cases, instead of responding as described above, the server responds with an HTTP Response code 202 and an empty body. The tracking task (which is the same task as all legacy API operations use) is linked via the URI provided in the <code>Location</code> header.<br/> All API calls can choose to service a request asynchronously or synchronously as determined by the server upon interpreting the request. Operations that choose to exhibit this dual behavior will have both options documented by specifying both response code(s) below. The caller must be prepared to handle responses to such API calls by inspecting the HTTP Response code. <h5>Error Conditions</h5> <b>All</b> operations report errors using the following error reporting rules: <ul>   <li>400: Bad Request - In event of bad request due to incorrect data or other user error</li>   <li>401: Bad Request - If user is unauthenticated or their session has expired</li>   <li>403: Forbidden - If the user is not authorized or the entity does not exist</li> </ul> <h4>OpenAPI Design Concepts and Principles</h4> <ul>   <li>IDs are full Uniform Resource Names (URNs).</li>   <li>OpenAPI's <code>Content-Type</code> is always <code>application/json</code></li>   <li>REST links are in the Link header.</li>   <ul>     <li>Multiple relationships for any link are represented by multiple values in a space-separated list.</li>     <li>Links have a custom VMware Cloud Director-specific &quot;model&quot; attribute that hints at the applicable data         type for the links.</li>     <li>title + rel + model attributes evaluates to a unique link.</li>     <li>Links follow Hypermedia as the Engine of Application State (HATEOAS) principles. Links are present if         certain operations are present and permitted for the user&quot;s current role and the state of the         referred entities.</li>   </ul>   <li>APIs follow a flat structure relying on cross-referencing other entities instead of the navigational style       used by the legacy VMware Cloud Director APIs.</li>   <li>Most endpoints that return a list support filtering and sorting similar to the query service in the legacy       VMware Cloud Director APIs.</li>   <li>Accept header must be included to specify the API version for the request similar to calls to existing legacy       VMware Cloud Director APIs.</li>   <li>Each feature has a version in the path element present in its URL.<br/>       <b>Note</b> API URL's without a version in their paths must be considered experimental.</li> </ul> 

    OpenAPI spec version: 36.0
    Contact: https://code.vmware.com/support
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""


from pprint import pformat
from six import iteritems
import re


class ProxyConnection(object):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """


    """
    Attributes:
      swagger_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    swagger_types = {
        'proxy_host': 'str',
        'proxy_port': 'int',
        'proxy_username': 'str',
        'proxy_password': 'str',
        'proxy_secure': 'bool'
    }

    attribute_map = {
        'proxy_host': 'proxyHost',
        'proxy_port': 'proxyPort',
        'proxy_username': 'proxyUsername',
        'proxy_password': 'proxyPassword',
        'proxy_secure': 'proxySecure'
    }

    def __init__(self, proxy_host=None, proxy_port=None, proxy_username=None, proxy_password=None, proxy_secure=True):
        """
        ProxyConnection - a model defined in Swagger
        """

        self._proxy_host = None
        self._proxy_port = None
        self._proxy_username = None
        self._proxy_password = None
        self._proxy_secure = None

        self.proxy_host = proxy_host
        self.proxy_port = proxy_port
        if proxy_username is not None:
          self.proxy_username = proxy_username
        if proxy_password is not None:
          self.proxy_password = proxy_password
        if proxy_secure is not None:
          self.proxy_secure = proxy_secure

    @property
    def proxy_host(self):
        """
        Gets the proxy_host of this ProxyConnection.
        The host (or IP address) of the proxy.

        :return: The proxy_host of this ProxyConnection.
        :rtype: str
        """
        return self._proxy_host

    @proxy_host.setter
    def proxy_host(self, proxy_host):
        """
        Sets the proxy_host of this ProxyConnection.
        The host (or IP address) of the proxy.

        :param proxy_host: The proxy_host of this ProxyConnection.
        :type: str
        """
        if proxy_host is None:
            raise ValueError("Invalid value for `proxy_host`, must not be `None`")
        if proxy_host is not None and len(proxy_host) > 256:
            raise ValueError("Invalid value for `proxy_host`, length must be less than or equal to `256`")

        self._proxy_host = proxy_host

    @property
    def proxy_port(self):
        """
        Gets the proxy_port of this ProxyConnection.
        The port to use when connecting to the proxy.

        :return: The proxy_port of this ProxyConnection.
        :rtype: int
        """
        return self._proxy_port

    @proxy_port.setter
    def proxy_port(self, proxy_port):
        """
        Sets the proxy_port of this ProxyConnection.
        The port to use when connecting to the proxy.

        :param proxy_port: The proxy_port of this ProxyConnection.
        :type: int
        """
        if proxy_port is None:
            raise ValueError("Invalid value for `proxy_port`, must not be `None`")

        self._proxy_port = proxy_port

    @property
    def proxy_username(self):
        """
        Gets the proxy_username of this ProxyConnection.
        Username to authenticate to the proxy.

        :return: The proxy_username of this ProxyConnection.
        :rtype: str
        """
        return self._proxy_username

    @proxy_username.setter
    def proxy_username(self, proxy_username):
        """
        Sets the proxy_username of this ProxyConnection.
        Username to authenticate to the proxy.

        :param proxy_username: The proxy_username of this ProxyConnection.
        :type: str
        """
        if proxy_username is not None and len(proxy_username) > 256:
            raise ValueError("Invalid value for `proxy_username`, length must be less than or equal to `256`")

        self._proxy_username = proxy_username

    @property
    def proxy_password(self):
        """
        Gets the proxy_password of this ProxyConnection.
        Password to authenticate to the proxy.

        :return: The proxy_password of this ProxyConnection.
        :rtype: str
        """
        return self._proxy_password

    @proxy_password.setter
    def proxy_password(self, proxy_password):
        """
        Sets the proxy_password of this ProxyConnection.
        Password to authenticate to the proxy.

        :param proxy_password: The proxy_password of this ProxyConnection.
        :type: str
        """
        if proxy_password is not None and len(proxy_password) > 256:
            raise ValueError("Invalid value for `proxy_password`, length must be less than or equal to `256`")

        self._proxy_password = proxy_password

    @property
    def proxy_secure(self):
        """
        Gets the proxy_secure of this ProxyConnection.
        If the connection to the proxy should use https.

        :return: The proxy_secure of this ProxyConnection.
        :rtype: bool
        """
        return self._proxy_secure

    @proxy_secure.setter
    def proxy_secure(self, proxy_secure):
        """
        Sets the proxy_secure of this ProxyConnection.
        If the connection to the proxy should use https.

        :param proxy_secure: The proxy_secure of this ProxyConnection.
        :type: bool
        """

        self._proxy_secure = proxy_secure

    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """
        Returns the string representation of the model
        """
        return pformat(self.to_dict())

    def __repr__(self):
        """
        For `print` and `pprint`
        """
        return self.to_str()

    def __eq__(self, other):
        """
        Returns true if both objects are equal
        """
        if not isinstance(other, ProxyConnection):
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """
        Returns true if both objects are not equal
        """
        return not self == other
