# coding: utf-8

"""
    VMware Cloud Director OpenAPI

    VMware Cloud Director OpenAPI is a new API that is defined using the OpenAPI standards.<br/> This ReSTful API borrows some elements of the legacy VMware Cloud Director API and establishes new patterns for use as described below. <h4>Authentication</h4> Authentication and Authorization schemes are the same as those for the legacy APIs. You can authenticate using the JWT token via the <code>Authorization</code> header or specifying a session using <code>x-vcloud-authorization</code> (The latter form is deprecated). <h4>Operation Patterns</h4> This API follows the following general guidelines to establish a consistent CRUD pattern: <table> <tr>   <th>Operation</th><th>Description</th><th>Response Code</th><th>Response Content</th> </tr><tr>   <td>GET /items<td>Returns a paginated list of items<td>200<td>Response will include Navigational links to the items in the list. </tr><tr>   <td>POST /items<td>Returns newly created item<td>201<td>Content-Location header links to the newly created item </tr><tr>   <td>GET /items/urn<td>Returns an individual item<td>200<td>A single item using same data type as that included in list above </tr><tr>   <td>PUT /items/urn<td>Updates an individual item<td>200<td>Updated view of the item is returned </tr><tr>   <td>DELETE /items/urn<td>Deletes the item<td>204<td>No content is returned. </tr> </table> <h5>Asynchronous operations</h5> Asynchronous operations are determined by the server. In those cases, instead of responding as described above, the server responds with an HTTP Response code 202 and an empty body. The tracking task (which is the same task as all legacy API operations use) is linked via the URI provided in the <code>Location</code> header.<br/> All API calls can choose to service a request asynchronously or synchronously as determined by the server upon interpreting the request. Operations that choose to exhibit this dual behavior will have both options documented by specifying both response code(s) below. The caller must be prepared to handle responses to such API calls by inspecting the HTTP Response code. <h5>Error Conditions</h5> <b>All</b> operations report errors using the following error reporting rules: <ul>   <li>400: Bad Request - In event of bad request due to incorrect data or other user error</li>   <li>401: Bad Request - If user is unauthenticated or their session has expired</li>   <li>403: Forbidden - If the user is not authorized or the entity does not exist</li> </ul> <h4>OpenAPI Design Concepts and Principles</h4> <ul>   <li>IDs are full Uniform Resource Names (URNs).</li>   <li>OpenAPI's <code>Content-Type</code> is always <code>application/json</code></li>   <li>REST links are in the Link header.</li>   <ul>     <li>Multiple relationships for any link are represented by multiple values in a space-separated list.</li>     <li>Links have a custom VMware Cloud Director-specific &quot;model&quot; attribute that hints at the applicable data         type for the links.</li>     <li>title + rel + model attributes evaluates to a unique link.</li>     <li>Links follow Hypermedia as the Engine of Application State (HATEOAS) principles. Links are present if         certain operations are present and permitted for the user&quot;s current role and the state of the         referred entities.</li>   </ul>   <li>APIs follow a flat structure relying on cross-referencing other entities instead of the navigational style       used by the legacy VMware Cloud Director APIs.</li>   <li>Most endpoints that return a list support filtering and sorting similar to the query service in the legacy       VMware Cloud Director APIs.</li>   <li>Accept header must be included to specify the API version for the request similar to calls to existing legacy       VMware Cloud Director APIs.</li>   <li>Each feature has a version in the path element present in its URL.<br/>       <b>Note</b> API URL's without a version in their paths must be considered experimental.</li> </ul> 

    OpenAPI spec version: 36.0
    Contact: https://code.vmware.com/support
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""


from pprint import pformat
from six import iteritems
import re


class NsxtDnsForwarderZoneConfig(object):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """


    """
    Attributes:
      swagger_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    swagger_types = {
        'id': 'str',
        'display_name': 'str',
        'dns_domain_names': 'list[str]',
        'upstream_servers': 'list[str]'
    }

    attribute_map = {
        'id': 'id',
        'display_name': 'displayName',
        'dns_domain_names': 'dnsDomainNames',
        'upstream_servers': 'upstreamServers'
    }

    def __init__(self, id=None, display_name=None, dns_domain_names=None, upstream_servers=None):
        """
        NsxtDnsForwarderZoneConfig - a model defined in Swagger
        """

        self._id = None
        self._display_name = None
        self._dns_domain_names = None
        self._upstream_servers = None

        if id is not None:
          self.id = id
        if display_name is not None:
          self.display_name = display_name
        if dns_domain_names is not None:
          self.dns_domain_names = dns_domain_names
        if upstream_servers is not None:
          self.upstream_servers = upstream_servers

    @property
    def id(self):
        """
        Gets the id of this NsxtDnsForwarderZoneConfig.
        The unique id of the DNS forwarder zone. If value is unset, a new zone is created. If value is set, an update is done on the zone. 

        :return: The id of this NsxtDnsForwarderZoneConfig.
        :rtype: str
        """
        return self._id

    @id.setter
    def id(self, id):
        """
        Sets the id of this NsxtDnsForwarderZoneConfig.
        The unique id of the DNS forwarder zone. If value is unset, a new zone is created. If value is set, an update is done on the zone. 

        :param id: The id of this NsxtDnsForwarderZoneConfig.
        :type: str
        """

        self._id = id

    @property
    def display_name(self):
        """
        Gets the display_name of this NsxtDnsForwarderZoneConfig.
        User friendly name for the zone.

        :return: The display_name of this NsxtDnsForwarderZoneConfig.
        :rtype: str
        """
        return self._display_name

    @display_name.setter
    def display_name(self, display_name):
        """
        Sets the display_name of this NsxtDnsForwarderZoneConfig.
        User friendly name for the zone.

        :param display_name: The display_name of this NsxtDnsForwarderZoneConfig.
        :type: str
        """

        self._display_name = display_name

    @property
    def dns_domain_names(self):
        """
        Gets the dns_domain_names of this NsxtDnsForwarderZoneConfig.
        List of domain names on which conditional forwarding is based. This field is required if the DNS Zone is being used for a conditional forwarder. This field will also be used for conditional reverse lookup. This field should not be set if the zone is used as default forwarder zone. 

        :return: The dns_domain_names of this NsxtDnsForwarderZoneConfig.
        :rtype: list[str]
        """
        return self._dns_domain_names

    @dns_domain_names.setter
    def dns_domain_names(self, dns_domain_names):
        """
        Sets the dns_domain_names of this NsxtDnsForwarderZoneConfig.
        List of domain names on which conditional forwarding is based. This field is required if the DNS Zone is being used for a conditional forwarder. This field will also be used for conditional reverse lookup. This field should not be set if the zone is used as default forwarder zone. 

        :param dns_domain_names: The dns_domain_names of this NsxtDnsForwarderZoneConfig.
        :type: list[str]
        """

        self._dns_domain_names = dns_domain_names

    @property
    def upstream_servers(self):
        """
        Gets the upstream_servers of this NsxtDnsForwarderZoneConfig.
        DNS servers to which the DNS request needs to be forwarded.

        :return: The upstream_servers of this NsxtDnsForwarderZoneConfig.
        :rtype: list[str]
        """
        return self._upstream_servers

    @upstream_servers.setter
    def upstream_servers(self, upstream_servers):
        """
        Sets the upstream_servers of this NsxtDnsForwarderZoneConfig.
        DNS servers to which the DNS request needs to be forwarded.

        :param upstream_servers: The upstream_servers of this NsxtDnsForwarderZoneConfig.
        :type: list[str]
        """

        self._upstream_servers = upstream_servers

    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """
        Returns the string representation of the model
        """
        return pformat(self.to_dict())

    def __repr__(self):
        """
        For `print` and `pprint`
        """
        return self.to_str()

    def __eq__(self, other):
        """
        Returns true if both objects are equal
        """
        if not isinstance(other, NsxtDnsForwarderZoneConfig):
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """
        Returns true if both objects are not equal
        """
        return not self == other
