# coding: utf-8

"""
    VMware Cloud Director OpenAPI

    VMware Cloud Director OpenAPI is a new API that is defined using the OpenAPI standards.<br/> This ReSTful API borrows some elements of the legacy VMware Cloud Director API and establishes new patterns for use as described below. <h4>Authentication</h4> Authentication and Authorization schemes are the same as those for the legacy APIs. You can authenticate using the JWT token via the <code>Authorization</code> header or specifying a session using <code>x-vcloud-authorization</code> (The latter form is deprecated). <h4>Operation Patterns</h4> This API follows the following general guidelines to establish a consistent CRUD pattern: <table> <tr>   <th>Operation</th><th>Description</th><th>Response Code</th><th>Response Content</th> </tr><tr>   <td>GET /items<td>Returns a paginated list of items<td>200<td>Response will include Navigational links to the items in the list. </tr><tr>   <td>POST /items<td>Returns newly created item<td>201<td>Content-Location header links to the newly created item </tr><tr>   <td>GET /items/urn<td>Returns an individual item<td>200<td>A single item using same data type as that included in list above </tr><tr>   <td>PUT /items/urn<td>Updates an individual item<td>200<td>Updated view of the item is returned </tr><tr>   <td>DELETE /items/urn<td>Deletes the item<td>204<td>No content is returned. </tr> </table> <h5>Asynchronous operations</h5> Asynchronous operations are determined by the server. In those cases, instead of responding as described above, the server responds with an HTTP Response code 202 and an empty body. The tracking task (which is the same task as all legacy API operations use) is linked via the URI provided in the <code>Location</code> header.<br/> All API calls can choose to service a request asynchronously or synchronously as determined by the server upon interpreting the request. Operations that choose to exhibit this dual behavior will have both options documented by specifying both response code(s) below. The caller must be prepared to handle responses to such API calls by inspecting the HTTP Response code. <h5>Error Conditions</h5> <b>All</b> operations report errors using the following error reporting rules: <ul>   <li>400: Bad Request - In event of bad request due to incorrect data or other user error</li>   <li>401: Bad Request - If user is unauthenticated or their session has expired</li>   <li>403: Forbidden - If the user is not authorized or the entity does not exist</li> </ul> <h4>OpenAPI Design Concepts and Principles</h4> <ul>   <li>IDs are full Uniform Resource Names (URNs).</li>   <li>OpenAPI's <code>Content-Type</code> is always <code>application/json</code></li>   <li>REST links are in the Link header.</li>   <ul>     <li>Multiple relationships for any link are represented by multiple values in a space-separated list.</li>     <li>Links have a custom VMware Cloud Director-specific &quot;model&quot; attribute that hints at the applicable data         type for the links.</li>     <li>title + rel + model attributes evaluates to a unique link.</li>     <li>Links follow Hypermedia as the Engine of Application State (HATEOAS) principles. Links are present if         certain operations are present and permitted for the user&quot;s current role and the state of the         referred entities.</li>   </ul>   <li>APIs follow a flat structure relying on cross-referencing other entities instead of the navigational style       used by the legacy VMware Cloud Director APIs.</li>   <li>Most endpoints that return a list support filtering and sorting similar to the query service in the legacy       VMware Cloud Director APIs.</li>   <li>Accept header must be included to specify the API version for the request similar to calls to existing legacy       VMware Cloud Director APIs.</li>   <li>Each feature has a version in the path element present in its URL.<br/>       <b>Note</b> API URL's without a version in their paths must be considered experimental.</li> </ul> 

    OpenAPI spec version: 36.0
    Contact: https://code.vmware.com/support
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""


from pprint import pformat
from six import iteritems
import re


class NsxAlbCloud(object):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """


    """
    Attributes:
      swagger_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    swagger_types = {
        'id': 'str',
        'display_name': 'str',
        'already_imported': 'bool',
        'network_pool_ref': 'EntityReference',
        'transport_zone_name': 'str'
    }

    attribute_map = {
        'id': 'id',
        'display_name': 'displayName',
        'already_imported': 'alreadyImported',
        'network_pool_ref': 'networkPoolRef',
        'transport_zone_name': 'transportZoneName'
    }

    def __init__(self, id=None, display_name=None, already_imported=None, network_pool_ref=None, transport_zone_name=None):
        """
        NsxAlbCloud - a model defined in Swagger
        """

        self._id = None
        self._display_name = None
        self._already_imported = None
        self._network_pool_ref = None
        self._transport_zone_name = None

        if id is not None:
          self.id = id
        if display_name is not None:
          self.display_name = display_name
        if already_imported is not None:
          self.already_imported = already_imported
        if network_pool_ref is not None:
          self.network_pool_ref = network_pool_ref
        if transport_zone_name is not None:
          self.transport_zone_name = transport_zone_name

    @property
    def id(self):
        """
        Gets the id of this NsxAlbCloud.
        The unique id of the cloud.

        :return: The id of this NsxAlbCloud.
        :rtype: str
        """
        return self._id

    @id.setter
    def id(self, id):
        """
        Sets the id of this NsxAlbCloud.
        The unique id of the cloud.

        :param id: The id of this NsxAlbCloud.
        :type: str
        """

        self._id = id

    @property
    def display_name(self):
        """
        Gets the display_name of this NsxAlbCloud.
        Name of the Cloud used in NSX-ALB Controller's logs or GUI.

        :return: The display_name of this NsxAlbCloud.
        :rtype: str
        """
        return self._display_name

    @display_name.setter
    def display_name(self, display_name):
        """
        Sets the display_name of this NsxAlbCloud.
        Name of the Cloud used in NSX-ALB Controller's logs or GUI.

        :param display_name: The display_name of this NsxAlbCloud.
        :type: str
        """

        self._display_name = display_name

    @property
    def already_imported(self):
        """
        Gets the already_imported of this NsxAlbCloud.
        True if the Cloud is already imported. Cloud cannot be imported again.

        :return: The already_imported of this NsxAlbCloud.
        :rtype: bool
        """
        return self._already_imported

    @already_imported.setter
    def already_imported(self, already_imported):
        """
        Sets the already_imported of this NsxAlbCloud.
        True if the Cloud is already imported. Cloud cannot be imported again.

        :param already_imported: The already_imported of this NsxAlbCloud.
        :type: bool
        """

        self._already_imported = already_imported

    @property
    def network_pool_ref(self):
        """
        Gets the network_pool_ref of this NsxAlbCloud.
        The Network Pool associated with this Cloud. If unset, this Cloud cannot be imported.

        :return: The network_pool_ref of this NsxAlbCloud.
        :rtype: EntityReference
        """
        return self._network_pool_ref

    @network_pool_ref.setter
    def network_pool_ref(self, network_pool_ref):
        """
        Sets the network_pool_ref of this NsxAlbCloud.
        The Network Pool associated with this Cloud. If unset, this Cloud cannot be imported.

        :param network_pool_ref: The network_pool_ref of this NsxAlbCloud.
        :type: EntityReference
        """

        self._network_pool_ref = network_pool_ref

    @property
    def transport_zone_name(self):
        """
        Gets the transport_zone_name of this NsxAlbCloud.
        Name of the transport zone in NSX-T associated with the NSX-ALB Cloud. If unset, the tranport zone associated with the Load Balancer Cloud is not found in NSX-T. 

        :return: The transport_zone_name of this NsxAlbCloud.
        :rtype: str
        """
        return self._transport_zone_name

    @transport_zone_name.setter
    def transport_zone_name(self, transport_zone_name):
        """
        Sets the transport_zone_name of this NsxAlbCloud.
        Name of the transport zone in NSX-T associated with the NSX-ALB Cloud. If unset, the tranport zone associated with the Load Balancer Cloud is not found in NSX-T. 

        :param transport_zone_name: The transport_zone_name of this NsxAlbCloud.
        :type: str
        """

        self._transport_zone_name = transport_zone_name

    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """
        Returns the string representation of the model
        """
        return pformat(self.to_dict())

    def __repr__(self):
        """
        For `print` and `pprint`
        """
        return self.to_str()

    def __eq__(self, other):
        """
        Returns true if both objects are equal
        """
        if not isinstance(other, NsxAlbCloud):
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """
        Returns true if both objects are not equal
        """
        return not self == other
