# coding: utf-8

"""
    VMware Cloud Director OpenAPI

    VMware Cloud Director OpenAPI is a new API that is defined using the OpenAPI standards.<br/> This ReSTful API borrows some elements of the legacy VMware Cloud Director API and establishes new patterns for use as described below. <h4>Authentication</h4> Authentication and Authorization schemes are the same as those for the legacy APIs. You can authenticate using the JWT token via the <code>Authorization</code> header or specifying a session using <code>x-vcloud-authorization</code> (The latter form is deprecated). <h4>Operation Patterns</h4> This API follows the following general guidelines to establish a consistent CRUD pattern: <table> <tr>   <th>Operation</th><th>Description</th><th>Response Code</th><th>Response Content</th> </tr><tr>   <td>GET /items<td>Returns a paginated list of items<td>200<td>Response will include Navigational links to the items in the list. </tr><tr>   <td>POST /items<td>Returns newly created item<td>201<td>Content-Location header links to the newly created item </tr><tr>   <td>GET /items/urn<td>Returns an individual item<td>200<td>A single item using same data type as that included in list above </tr><tr>   <td>PUT /items/urn<td>Updates an individual item<td>200<td>Updated view of the item is returned </tr><tr>   <td>DELETE /items/urn<td>Deletes the item<td>204<td>No content is returned. </tr> </table> <h5>Asynchronous operations</h5> Asynchronous operations are determined by the server. In those cases, instead of responding as described above, the server responds with an HTTP Response code 202 and an empty body. The tracking task (which is the same task as all legacy API operations use) is linked via the URI provided in the <code>Location</code> header.<br/> All API calls can choose to service a request asynchronously or synchronously as determined by the server upon interpreting the request. Operations that choose to exhibit this dual behavior will have both options documented by specifying both response code(s) below. The caller must be prepared to handle responses to such API calls by inspecting the HTTP Response code. <h5>Error Conditions</h5> <b>All</b> operations report errors using the following error reporting rules: <ul>   <li>400: Bad Request - In event of bad request due to incorrect data or other user error</li>   <li>401: Bad Request - If user is unauthenticated or their session has expired</li>   <li>403: Forbidden - If the user is not authorized or the entity does not exist</li> </ul> <h4>OpenAPI Design Concepts and Principles</h4> <ul>   <li>IDs are full Uniform Resource Names (URNs).</li>   <li>OpenAPI's <code>Content-Type</code> is always <code>application/json</code></li>   <li>REST links are in the Link header.</li>   <ul>     <li>Multiple relationships for any link are represented by multiple values in a space-separated list.</li>     <li>Links have a custom VMware Cloud Director-specific &quot;model&quot; attribute that hints at the applicable data         type for the links.</li>     <li>title + rel + model attributes evaluates to a unique link.</li>     <li>Links follow Hypermedia as the Engine of Application State (HATEOAS) principles. Links are present if         certain operations are present and permitted for the user&quot;s current role and the state of the         referred entities.</li>   </ul>   <li>APIs follow a flat structure relying on cross-referencing other entities instead of the navigational style       used by the legacy VMware Cloud Director APIs.</li>   <li>Most endpoints that return a list support filtering and sorting similar to the query service in the legacy       VMware Cloud Director APIs.</li>   <li>Accept header must be included to specify the API version for the request similar to calls to existing legacy       VMware Cloud Director APIs.</li>   <li>Each feature has a version in the path element present in its URL.<br/>       <b>Note</b> API URL's without a version in their paths must be considered experimental.</li> </ul> 

    OpenAPI spec version: 36.0
    Contact: https://code.vmware.com/support
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""


from pprint import pformat
from six import iteritems
import re


class NetworkPoolSummary(object):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """


    """
    Attributes:
      swagger_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    swagger_types = {
        'status': 'NetworkingObjectStatusType',
        'id': 'str',
        'name': 'str',
        'description': 'str',
        'pool_type': 'NetworkPoolBackingType',
        'promiscuous_mode': 'bool',
        'total_backings_count': 'int',
        'used_backings_count': 'int',
        'managing_owner_ref': 'EntityReference'
    }

    attribute_map = {
        'status': 'status',
        'id': 'id',
        'name': 'name',
        'description': 'description',
        'pool_type': 'poolType',
        'promiscuous_mode': 'promiscuousMode',
        'total_backings_count': 'totalBackingsCount',
        'used_backings_count': 'usedBackingsCount',
        'managing_owner_ref': 'managingOwnerRef'
    }

    def __init__(self, status=None, id=None, name=None, description=None, pool_type=None, promiscuous_mode=None, total_backings_count=None, used_backings_count=None, managing_owner_ref=None):
        """
        NetworkPoolSummary - a model defined in Swagger
        """

        self._status = None
        self._id = None
        self._name = None
        self._description = None
        self._pool_type = None
        self._promiscuous_mode = None
        self._total_backings_count = None
        self._used_backings_count = None
        self._managing_owner_ref = None

        if status is not None:
          self.status = status
        if id is not None:
          self.id = id
        if name is not None:
          self.name = name
        if description is not None:
          self.description = description
        if pool_type is not None:
          self.pool_type = pool_type
        if promiscuous_mode is not None:
          self.promiscuous_mode = promiscuous_mode
        if total_backings_count is not None:
          self.total_backings_count = total_backings_count
        if used_backings_count is not None:
          self.used_backings_count = used_backings_count
        if managing_owner_ref is not None:
          self.managing_owner_ref = managing_owner_ref

    @property
    def status(self):
        """
        Gets the status of this NetworkPoolSummary.
        Represents current status of the networking object. 

        :return: The status of this NetworkPoolSummary.
        :rtype: NetworkingObjectStatusType
        """
        return self._status

    @status.setter
    def status(self, status):
        """
        Sets the status of this NetworkPoolSummary.
        Represents current status of the networking object. 

        :param status: The status of this NetworkPoolSummary.
        :type: NetworkingObjectStatusType
        """

        self._status = status

    @property
    def id(self):
        """
        Gets the id of this NetworkPoolSummary.
        The id of the Network Pool in URN format.

        :return: The id of this NetworkPoolSummary.
        :rtype: str
        """
        return self._id

    @id.setter
    def id(self, id):
        """
        Sets the id of this NetworkPoolSummary.
        The id of the Network Pool in URN format.

        :param id: The id of this NetworkPoolSummary.
        :type: str
        """

        self._id = id

    @property
    def name(self):
        """
        Gets the name of this NetworkPoolSummary.
        The name of the Network Pool. Names for Network Pools must be unique across the system.

        :return: The name of this NetworkPoolSummary.
        :rtype: str
        """
        return self._name

    @name.setter
    def name(self, name):
        """
        Sets the name of this NetworkPoolSummary.
        The name of the Network Pool. Names for Network Pools must be unique across the system.

        :param name: The name of this NetworkPoolSummary.
        :type: str
        """

        self._name = name

    @property
    def description(self):
        """
        Gets the description of this NetworkPoolSummary.

        :return: The description of this NetworkPoolSummary.
        :rtype: str
        """
        return self._description

    @description.setter
    def description(self, description):
        """
        Sets the description of this NetworkPoolSummary.

        :param description: The description of this NetworkPoolSummary.
        :type: str
        """

        self._description = description

    @property
    def pool_type(self):
        """
        Gets the pool_type of this NetworkPoolSummary.
        The network pool backing type.

        :return: The pool_type of this NetworkPoolSummary.
        :rtype: NetworkPoolBackingType
        """
        return self._pool_type

    @pool_type.setter
    def pool_type(self, pool_type):
        """
        Sets the pool_type of this NetworkPoolSummary.
        The network pool backing type.

        :param pool_type: The pool_type of this NetworkPoolSummary.
        :type: NetworkPoolBackingType
        """

        self._pool_type = pool_type

    @property
    def promiscuous_mode(self):
        """
        Gets the promiscuous_mode of this NetworkPoolSummary.
        Whether promiscuous mode is enabled on the network pool. This is only applicable for VLAN network pools.

        :return: The promiscuous_mode of this NetworkPoolSummary.
        :rtype: bool
        """
        return self._promiscuous_mode

    @promiscuous_mode.setter
    def promiscuous_mode(self, promiscuous_mode):
        """
        Sets the promiscuous_mode of this NetworkPoolSummary.
        Whether promiscuous mode is enabled on the network pool. This is only applicable for VLAN network pools.

        :param promiscuous_mode: The promiscuous_mode of this NetworkPoolSummary.
        :type: bool
        """

        self._promiscuous_mode = promiscuous_mode

    @property
    def total_backings_count(self):
        """
        Gets the total_backings_count of this NetworkPoolSummary.
        The number of backings available for use.

        :return: The total_backings_count of this NetworkPoolSummary.
        :rtype: int
        """
        return self._total_backings_count

    @total_backings_count.setter
    def total_backings_count(self, total_backings_count):
        """
        Sets the total_backings_count of this NetworkPoolSummary.
        The number of backings available for use.

        :param total_backings_count: The total_backings_count of this NetworkPoolSummary.
        :type: int
        """

        self._total_backings_count = total_backings_count

    @property
    def used_backings_count(self):
        """
        Gets the used_backings_count of this NetworkPoolSummary.
        The number of network pool backings in use.

        :return: The used_backings_count of this NetworkPoolSummary.
        :rtype: int
        """
        return self._used_backings_count

    @used_backings_count.setter
    def used_backings_count(self, used_backings_count):
        """
        Sets the used_backings_count of this NetworkPoolSummary.
        The number of network pool backings in use.

        :param used_backings_count: The used_backings_count of this NetworkPoolSummary.
        :type: int
        """

        self._used_backings_count = used_backings_count

    @property
    def managing_owner_ref(self):
        """
        Gets the managing_owner_ref of this NetworkPoolSummary.
        The Id of vCenter server or the NSX-T manager that manages backings for this network pool.

        :return: The managing_owner_ref of this NetworkPoolSummary.
        :rtype: EntityReference
        """
        return self._managing_owner_ref

    @managing_owner_ref.setter
    def managing_owner_ref(self, managing_owner_ref):
        """
        Sets the managing_owner_ref of this NetworkPoolSummary.
        The Id of vCenter server or the NSX-T manager that manages backings for this network pool.

        :param managing_owner_ref: The managing_owner_ref of this NetworkPoolSummary.
        :type: EntityReference
        """

        self._managing_owner_ref = managing_owner_ref

    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """
        Returns the string representation of the model
        """
        return pformat(self.to_dict())

    def __repr__(self):
        """
        For `print` and `pprint`
        """
        return self.to_str()

    def __eq__(self, other):
        """
        Returns true if both objects are equal
        """
        if not isinstance(other, NetworkPoolSummary):
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """
        Returns true if both objects are not equal
        """
        return not self == other
