# coding: utf-8

"""
    VMware Cloud Director OpenAPI

    VMware Cloud Director OpenAPI is a new API that is defined using the OpenAPI standards.<br/> This ReSTful API borrows some elements of the legacy VMware Cloud Director API and establishes new patterns for use as described below. <h4>Authentication</h4> Authentication and Authorization schemes are the same as those for the legacy APIs. You can authenticate using the JWT token via the <code>Authorization</code> header or specifying a session using <code>x-vcloud-authorization</code> (The latter form is deprecated). <h4>Operation Patterns</h4> This API follows the following general guidelines to establish a consistent CRUD pattern: <table> <tr>   <th>Operation</th><th>Description</th><th>Response Code</th><th>Response Content</th> </tr><tr>   <td>GET /items<td>Returns a paginated list of items<td>200<td>Response will include Navigational links to the items in the list. </tr><tr>   <td>POST /items<td>Returns newly created item<td>201<td>Content-Location header links to the newly created item </tr><tr>   <td>GET /items/urn<td>Returns an individual item<td>200<td>A single item using same data type as that included in list above </tr><tr>   <td>PUT /items/urn<td>Updates an individual item<td>200<td>Updated view of the item is returned </tr><tr>   <td>DELETE /items/urn<td>Deletes the item<td>204<td>No content is returned. </tr> </table> <h5>Asynchronous operations</h5> Asynchronous operations are determined by the server. In those cases, instead of responding as described above, the server responds with an HTTP Response code 202 and an empty body. The tracking task (which is the same task as all legacy API operations use) is linked via the URI provided in the <code>Location</code> header.<br/> All API calls can choose to service a request asynchronously or synchronously as determined by the server upon interpreting the request. Operations that choose to exhibit this dual behavior will have both options documented by specifying both response code(s) below. The caller must be prepared to handle responses to such API calls by inspecting the HTTP Response code. <h5>Error Conditions</h5> <b>All</b> operations report errors using the following error reporting rules: <ul>   <li>400: Bad Request - In event of bad request due to incorrect data or other user error</li>   <li>401: Bad Request - If user is unauthenticated or their session has expired</li>   <li>403: Forbidden - If the user is not authorized or the entity does not exist</li> </ul> <h4>OpenAPI Design Concepts and Principles</h4> <ul>   <li>IDs are full Uniform Resource Names (URNs).</li>   <li>OpenAPI's <code>Content-Type</code> is always <code>application/json</code></li>   <li>REST links are in the Link header.</li>   <ul>     <li>Multiple relationships for any link are represented by multiple values in a space-separated list.</li>     <li>Links have a custom VMware Cloud Director-specific &quot;model&quot; attribute that hints at the applicable data         type for the links.</li>     <li>title + rel + model attributes evaluates to a unique link.</li>     <li>Links follow Hypermedia as the Engine of Application State (HATEOAS) principles. Links are present if         certain operations are present and permitted for the user&quot;s current role and the state of the         referred entities.</li>   </ul>   <li>APIs follow a flat structure relying on cross-referencing other entities instead of the navigational style       used by the legacy VMware Cloud Director APIs.</li>   <li>Most endpoints that return a list support filtering and sorting similar to the query service in the legacy       VMware Cloud Director APIs.</li>   <li>Accept header must be included to specify the API version for the request similar to calls to existing legacy       VMware Cloud Director APIs.</li>   <li>Each feature has a version in the path element present in its URL.<br/>       <b>Note</b> API URL's without a version in their paths must be considered experimental.</li> </ul> 

    OpenAPI spec version: 36.0
    Contact: https://code.vmware.com/support
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""


from pprint import pformat
from six import iteritems
import re


class NetworkContextProfile(object):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """


    """
    Attributes:
      swagger_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    swagger_types = {
        'org_ref': 'EntityReference',
        'context_entity_id': 'str',
        'network_provider_scope': 'str',
        'id': 'str',
        'name': 'str',
        'description': 'str',
        'scope': 'NetworkContextProfileScopeType',
        'attributes': 'list[NetworkContextProfileAttribute]'
    }

    attribute_map = {
        'org_ref': 'orgRef',
        'context_entity_id': 'contextEntityId',
        'network_provider_scope': 'networkProviderScope',
        'id': 'id',
        'name': 'name',
        'description': 'description',
        'scope': 'scope',
        'attributes': 'attributes'
    }

    def __init__(self, org_ref=None, context_entity_id=None, network_provider_scope=None, id=None, name=None, description=None, scope=None, attributes=None):
        """
        NetworkContextProfile - a model defined in Swagger
        """

        self._org_ref = None
        self._context_entity_id = None
        self._network_provider_scope = None
        self._id = None
        self._name = None
        self._description = None
        self._scope = None
        self._attributes = None

        if org_ref is not None:
          self.org_ref = org_ref
        if context_entity_id is not None:
          self.context_entity_id = context_entity_id
        if network_provider_scope is not None:
          self.network_provider_scope = network_provider_scope
        if id is not None:
          self.id = id
        if name is not None:
          self.name = name
        if description is not None:
          self.description = description
        if scope is not None:
          self.scope = scope
        if attributes is not None:
          self.attributes = attributes

    @property
    def org_ref(self):
        """
        Gets the org_ref of this NetworkContextProfile.
        The organization that this object belongs to. This property is required during creation and cannot be updated. 

        :return: The org_ref of this NetworkContextProfile.
        :rtype: EntityReference
        """
        return self._org_ref

    @org_ref.setter
    def org_ref(self, org_ref):
        """
        Sets the org_ref of this NetworkContextProfile.
        The organization that this object belongs to. This property is required during creation and cannot be updated. 

        :param org_ref: The org_ref of this NetworkContextProfile.
        :type: EntityReference
        """

        self._org_ref = org_ref

    @property
    def context_entity_id(self):
        """
        Gets the context_entity_id of this NetworkContextProfile.
        The context under which this object is created. The context can the id of the organization vDC, vDC Group, or network provider. This field is required on object creation and is unset on object reads. This same context ID can be used in the context filter field when querying for the list of objects. 

        :return: The context_entity_id of this NetworkContextProfile.
        :rtype: str
        """
        return self._context_entity_id

    @context_entity_id.setter
    def context_entity_id(self, context_entity_id):
        """
        Sets the context_entity_id of this NetworkContextProfile.
        The context under which this object is created. The context can the id of the organization vDC, vDC Group, or network provider. This field is required on object creation and is unset on object reads. This same context ID can be used in the context filter field when querying for the list of objects. 

        :param context_entity_id: The context_entity_id of this NetworkContextProfile.
        :type: str
        """

        self._context_entity_id = context_entity_id

    @property
    def network_provider_scope(self):
        """
        Gets the network_provider_scope of this NetworkContextProfile.
        The network provider scope that this object belongs to. This is a read-only property and is determined by the input context entity ID during object creation. 

        :return: The network_provider_scope of this NetworkContextProfile.
        :rtype: str
        """
        return self._network_provider_scope

    @network_provider_scope.setter
    def network_provider_scope(self, network_provider_scope):
        """
        Sets the network_provider_scope of this NetworkContextProfile.
        The network provider scope that this object belongs to. This is a read-only property and is determined by the input context entity ID during object creation. 

        :param network_provider_scope: The network_provider_scope of this NetworkContextProfile.
        :type: str
        """

        self._network_provider_scope = network_provider_scope

    @property
    def id(self):
        """
        Gets the id of this NetworkContextProfile.
        The unique id of this network context profile in URN format.

        :return: The id of this NetworkContextProfile.
        :rtype: str
        """
        return self._id

    @id.setter
    def id(self, id):
        """
        Sets the id of this NetworkContextProfile.
        The unique id of this network context profile in URN format.

        :param id: The id of this NetworkContextProfile.
        :type: str
        """

        self._id = id

    @property
    def name(self):
        """
        Gets the name of this NetworkContextProfile.
        Name for the network context profile.

        :return: The name of this NetworkContextProfile.
        :rtype: str
        """
        return self._name

    @name.setter
    def name(self, name):
        """
        Sets the name of this NetworkContextProfile.
        Name for the network context profile.

        :param name: The name of this NetworkContextProfile.
        :type: str
        """

        self._name = name

    @property
    def description(self):
        """
        Gets the description of this NetworkContextProfile.
        Description for the network context profile.

        :return: The description of this NetworkContextProfile.
        :rtype: str
        """
        return self._description

    @description.setter
    def description(self, description):
        """
        Sets the description of this NetworkContextProfile.
        Description for the network context profile.

        :param description: The description of this NetworkContextProfile.
        :type: str
        """

        self._description = description

    @property
    def scope(self):
        """
        Gets the scope of this NetworkContextProfile.
        The scope of the network context profile.

        :return: The scope of this NetworkContextProfile.
        :rtype: NetworkContextProfileScopeType
        """
        return self._scope

    @scope.setter
    def scope(self, scope):
        """
        Sets the scope of this NetworkContextProfile.
        The scope of the network context profile.

        :param scope: The scope of this NetworkContextProfile.
        :type: NetworkContextProfileScopeType
        """

        self._scope = scope

    @property
    def attributes(self):
        """
        Gets the attributes of this NetworkContextProfile.
        Array of network context profile attributes.

        :return: The attributes of this NetworkContextProfile.
        :rtype: list[NetworkContextProfileAttribute]
        """
        return self._attributes

    @attributes.setter
    def attributes(self, attributes):
        """
        Sets the attributes of this NetworkContextProfile.
        Array of network context profile attributes.

        :param attributes: The attributes of this NetworkContextProfile.
        :type: list[NetworkContextProfileAttribute]
        """

        self._attributes = attributes

    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """
        Returns the string representation of the model
        """
        return pformat(self.to_dict())

    def __repr__(self):
        """
        For `print` and `pprint`
        """
        return self.to_str()

    def __eq__(self, other):
        """
        Returns true if both objects are equal
        """
        if not isinstance(other, NetworkContextProfile):
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """
        Returns true if both objects are not equal
        """
        return not self == other
