# coding: utf-8

"""
    VMware Cloud Director OpenAPI

    VMware Cloud Director OpenAPI is a new API that is defined using the OpenAPI standards.<br/> This ReSTful API borrows some elements of the legacy VMware Cloud Director API and establishes new patterns for use as described below. <h4>Authentication</h4> Authentication and Authorization schemes are the same as those for the legacy APIs. You can authenticate using the JWT token via the <code>Authorization</code> header or specifying a session using <code>x-vcloud-authorization</code> (The latter form is deprecated). <h4>Operation Patterns</h4> This API follows the following general guidelines to establish a consistent CRUD pattern: <table> <tr>   <th>Operation</th><th>Description</th><th>Response Code</th><th>Response Content</th> </tr><tr>   <td>GET /items<td>Returns a paginated list of items<td>200<td>Response will include Navigational links to the items in the list. </tr><tr>   <td>POST /items<td>Returns newly created item<td>201<td>Content-Location header links to the newly created item </tr><tr>   <td>GET /items/urn<td>Returns an individual item<td>200<td>A single item using same data type as that included in list above </tr><tr>   <td>PUT /items/urn<td>Updates an individual item<td>200<td>Updated view of the item is returned </tr><tr>   <td>DELETE /items/urn<td>Deletes the item<td>204<td>No content is returned. </tr> </table> <h5>Asynchronous operations</h5> Asynchronous operations are determined by the server. In those cases, instead of responding as described above, the server responds with an HTTP Response code 202 and an empty body. The tracking task (which is the same task as all legacy API operations use) is linked via the URI provided in the <code>Location</code> header.<br/> All API calls can choose to service a request asynchronously or synchronously as determined by the server upon interpreting the request. Operations that choose to exhibit this dual behavior will have both options documented by specifying both response code(s) below. The caller must be prepared to handle responses to such API calls by inspecting the HTTP Response code. <h5>Error Conditions</h5> <b>All</b> operations report errors using the following error reporting rules: <ul>   <li>400: Bad Request - In event of bad request due to incorrect data or other user error</li>   <li>401: Bad Request - If user is unauthenticated or their session has expired</li>   <li>403: Forbidden - If the user is not authorized or the entity does not exist</li> </ul> <h4>OpenAPI Design Concepts and Principles</h4> <ul>   <li>IDs are full Uniform Resource Names (URNs).</li>   <li>OpenAPI's <code>Content-Type</code> is always <code>application/json</code></li>   <li>REST links are in the Link header.</li>   <ul>     <li>Multiple relationships for any link are represented by multiple values in a space-separated list.</li>     <li>Links have a custom VMware Cloud Director-specific &quot;model&quot; attribute that hints at the applicable data         type for the links.</li>     <li>title + rel + model attributes evaluates to a unique link.</li>     <li>Links follow Hypermedia as the Engine of Application State (HATEOAS) principles. Links are present if         certain operations are present and permitted for the user&quot;s current role and the state of the         referred entities.</li>   </ul>   <li>APIs follow a flat structure relying on cross-referencing other entities instead of the navigational style       used by the legacy VMware Cloud Director APIs.</li>   <li>Most endpoints that return a list support filtering and sorting similar to the query service in the legacy       VMware Cloud Director APIs.</li>   <li>Accept header must be included to specify the API version for the request similar to calls to existing legacy       VMware Cloud Director APIs.</li>   <li>Each feature has a version in the path element present in its URL.<br/>       <b>Note</b> API URL's without a version in their paths must be considered experimental.</li> </ul> 

    OpenAPI spec version: 36.0
    Contact: https://code.vmware.com/support
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""


from pprint import pformat
from six import iteritems
import re


class LoadBalancerServiceEngineGroupAssignment(object):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """


    """
    Attributes:
      swagger_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    swagger_types = {
        'id': 'str',
        'max_virtual_services': 'int',
        'min_virtual_services': 'int',
        'num_deployed_virtual_services': 'int',
        'service_engine_group_ref': 'EntityReference',
        'gateway_ref': 'EntityReference',
        'gateway_owner_ref': 'EntityReference',
        'gateway_org_ref': 'EntityReference'
    }

    attribute_map = {
        'id': 'id',
        'max_virtual_services': 'maxVirtualServices',
        'min_virtual_services': 'minVirtualServices',
        'num_deployed_virtual_services': 'numDeployedVirtualServices',
        'service_engine_group_ref': 'serviceEngineGroupRef',
        'gateway_ref': 'gatewayRef',
        'gateway_owner_ref': 'gatewayOwnerRef',
        'gateway_org_ref': 'gatewayOrgRef'
    }

    def __init__(self, id=None, max_virtual_services=None, min_virtual_services=None, num_deployed_virtual_services=None, service_engine_group_ref=None, gateway_ref=None, gateway_owner_ref=None, gateway_org_ref=None):
        """
        LoadBalancerServiceEngineGroupAssignment - a model defined in Swagger
        """

        self._id = None
        self._max_virtual_services = None
        self._min_virtual_services = None
        self._num_deployed_virtual_services = None
        self._service_engine_group_ref = None
        self._gateway_ref = None
        self._gateway_owner_ref = None
        self._gateway_org_ref = None

        if id is not None:
          self.id = id
        if max_virtual_services is not None:
          self.max_virtual_services = max_virtual_services
        if min_virtual_services is not None:
          self.min_virtual_services = min_virtual_services
        if num_deployed_virtual_services is not None:
          self.num_deployed_virtual_services = num_deployed_virtual_services
        self.service_engine_group_ref = service_engine_group_ref
        self.gateway_ref = gateway_ref
        if gateway_owner_ref is not None:
          self.gateway_owner_ref = gateway_owner_ref
        if gateway_org_ref is not None:
          self.gateway_org_ref = gateway_org_ref

    @property
    def id(self):
        """
        Gets the id of this LoadBalancerServiceEngineGroupAssignment.
        The identifier of the Load Balancer Service Engine Groups in URN format.

        :return: The id of this LoadBalancerServiceEngineGroupAssignment.
        :rtype: str
        """
        return self._id

    @id.setter
    def id(self, id):
        """
        Sets the id of this LoadBalancerServiceEngineGroupAssignment.
        The identifier of the Load Balancer Service Engine Groups in URN format.

        :param id: The id of this LoadBalancerServiceEngineGroupAssignment.
        :type: str
        """

        self._id = id

    @property
    def max_virtual_services(self):
        """
        Gets the max_virtual_services of this LoadBalancerServiceEngineGroupAssignment.
        The maximum number of virtual services the Edge Gateway is allowed to use. This is required if the Load Balancer Service Engine Group has reservation type 'SHARED'. This must be unset if the Load Balancer Service Engine Group has reservation type 'DEDICATED'. 

        :return: The max_virtual_services of this LoadBalancerServiceEngineGroupAssignment.
        :rtype: int
        """
        return self._max_virtual_services

    @max_virtual_services.setter
    def max_virtual_services(self, max_virtual_services):
        """
        Sets the max_virtual_services of this LoadBalancerServiceEngineGroupAssignment.
        The maximum number of virtual services the Edge Gateway is allowed to use. This is required if the Load Balancer Service Engine Group has reservation type 'SHARED'. This must be unset if the Load Balancer Service Engine Group has reservation type 'DEDICATED'. 

        :param max_virtual_services: The max_virtual_services of this LoadBalancerServiceEngineGroupAssignment.
        :type: int
        """
        if max_virtual_services is not None and max_virtual_services < 0:
            raise ValueError("Invalid value for `max_virtual_services`, must be a value greater than or equal to `0`")

        self._max_virtual_services = max_virtual_services

    @property
    def min_virtual_services(self):
        """
        Gets the min_virtual_services of this LoadBalancerServiceEngineGroupAssignment.
        The number of guaranteed virtual services available to the Edge Gateway. This is required if the Load Balancer Service Engine Group has reservation type 'SHARED'. This must be unset if the Load Balancer Service Engine Group has reservation type 'DEDICATED'. 

        :return: The min_virtual_services of this LoadBalancerServiceEngineGroupAssignment.
        :rtype: int
        """
        return self._min_virtual_services

    @min_virtual_services.setter
    def min_virtual_services(self, min_virtual_services):
        """
        Sets the min_virtual_services of this LoadBalancerServiceEngineGroupAssignment.
        The number of guaranteed virtual services available to the Edge Gateway. This is required if the Load Balancer Service Engine Group has reservation type 'SHARED'. This must be unset if the Load Balancer Service Engine Group has reservation type 'DEDICATED'. 

        :param min_virtual_services: The min_virtual_services of this LoadBalancerServiceEngineGroupAssignment.
        :type: int
        """
        if min_virtual_services is not None and min_virtual_services < 0:
            raise ValueError("Invalid value for `min_virtual_services`, must be a value greater than or equal to `0`")

        self._min_virtual_services = min_virtual_services

    @property
    def num_deployed_virtual_services(self):
        """
        Gets the num_deployed_virtual_services of this LoadBalancerServiceEngineGroupAssignment.
        The current number of deployed virutal services. 

        :return: The num_deployed_virtual_services of this LoadBalancerServiceEngineGroupAssignment.
        :rtype: int
        """
        return self._num_deployed_virtual_services

    @num_deployed_virtual_services.setter
    def num_deployed_virtual_services(self, num_deployed_virtual_services):
        """
        Sets the num_deployed_virtual_services of this LoadBalancerServiceEngineGroupAssignment.
        The current number of deployed virutal services. 

        :param num_deployed_virtual_services: The num_deployed_virtual_services of this LoadBalancerServiceEngineGroupAssignment.
        :type: int
        """

        self._num_deployed_virtual_services = num_deployed_virtual_services

    @property
    def service_engine_group_ref(self):
        """
        Gets the service_engine_group_ref of this LoadBalancerServiceEngineGroupAssignment.
        The associated Load Balancer Service Engine Group.

        :return: The service_engine_group_ref of this LoadBalancerServiceEngineGroupAssignment.
        :rtype: EntityReference
        """
        return self._service_engine_group_ref

    @service_engine_group_ref.setter
    def service_engine_group_ref(self, service_engine_group_ref):
        """
        Sets the service_engine_group_ref of this LoadBalancerServiceEngineGroupAssignment.
        The associated Load Balancer Service Engine Group.

        :param service_engine_group_ref: The service_engine_group_ref of this LoadBalancerServiceEngineGroupAssignment.
        :type: EntityReference
        """
        if service_engine_group_ref is None:
            raise ValueError("Invalid value for `service_engine_group_ref`, must not be `None`")

        self._service_engine_group_ref = service_engine_group_ref

    @property
    def gateway_ref(self):
        """
        Gets the gateway_ref of this LoadBalancerServiceEngineGroupAssignment.
        The associated Edge Gateway.

        :return: The gateway_ref of this LoadBalancerServiceEngineGroupAssignment.
        :rtype: EntityReference
        """
        return self._gateway_ref

    @gateway_ref.setter
    def gateway_ref(self, gateway_ref):
        """
        Sets the gateway_ref of this LoadBalancerServiceEngineGroupAssignment.
        The associated Edge Gateway.

        :param gateway_ref: The gateway_ref of this LoadBalancerServiceEngineGroupAssignment.
        :type: EntityReference
        """
        if gateway_ref is None:
            raise ValueError("Invalid value for `gateway_ref`, must not be `None`")

        self._gateway_ref = gateway_ref

    @property
    def gateway_owner_ref(self):
        """
        Gets the gateway_owner_ref of this LoadBalancerServiceEngineGroupAssignment.
        The owner of the associated Edge Gateway. This can be a vDC or vDC Group.

        :return: The gateway_owner_ref of this LoadBalancerServiceEngineGroupAssignment.
        :rtype: EntityReference
        """
        return self._gateway_owner_ref

    @gateway_owner_ref.setter
    def gateway_owner_ref(self, gateway_owner_ref):
        """
        Sets the gateway_owner_ref of this LoadBalancerServiceEngineGroupAssignment.
        The owner of the associated Edge Gateway. This can be a vDC or vDC Group.

        :param gateway_owner_ref: The gateway_owner_ref of this LoadBalancerServiceEngineGroupAssignment.
        :type: EntityReference
        """

        self._gateway_owner_ref = gateway_owner_ref

    @property
    def gateway_org_ref(self):
        """
        Gets the gateway_org_ref of this LoadBalancerServiceEngineGroupAssignment.
        The organization of the associated Edge Gateway.

        :return: The gateway_org_ref of this LoadBalancerServiceEngineGroupAssignment.
        :rtype: EntityReference
        """
        return self._gateway_org_ref

    @gateway_org_ref.setter
    def gateway_org_ref(self, gateway_org_ref):
        """
        Sets the gateway_org_ref of this LoadBalancerServiceEngineGroupAssignment.
        The organization of the associated Edge Gateway.

        :param gateway_org_ref: The gateway_org_ref of this LoadBalancerServiceEngineGroupAssignment.
        :type: EntityReference
        """

        self._gateway_org_ref = gateway_org_ref

    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """
        Returns the string representation of the model
        """
        return pformat(self.to_dict())

    def __repr__(self):
        """
        For `print` and `pprint`
        """
        return self.to_str()

    def __eq__(self, other):
        """
        Returns true if both objects are equal
        """
        if not isinstance(other, LoadBalancerServiceEngineGroupAssignment):
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """
        Returns true if both objects are not equal
        """
        return not self == other
