# coding: utf-8

"""
    VMware Cloud Director OpenAPI

    VMware Cloud Director OpenAPI is a new API that is defined using the OpenAPI standards.<br/> This ReSTful API borrows some elements of the legacy VMware Cloud Director API and establishes new patterns for use as described below. <h4>Authentication</h4> Authentication and Authorization schemes are the same as those for the legacy APIs. You can authenticate using the JWT token via the <code>Authorization</code> header or specifying a session using <code>x-vcloud-authorization</code> (The latter form is deprecated). <h4>Operation Patterns</h4> This API follows the following general guidelines to establish a consistent CRUD pattern: <table> <tr>   <th>Operation</th><th>Description</th><th>Response Code</th><th>Response Content</th> </tr><tr>   <td>GET /items<td>Returns a paginated list of items<td>200<td>Response will include Navigational links to the items in the list. </tr><tr>   <td>POST /items<td>Returns newly created item<td>201<td>Content-Location header links to the newly created item </tr><tr>   <td>GET /items/urn<td>Returns an individual item<td>200<td>A single item using same data type as that included in list above </tr><tr>   <td>PUT /items/urn<td>Updates an individual item<td>200<td>Updated view of the item is returned </tr><tr>   <td>DELETE /items/urn<td>Deletes the item<td>204<td>No content is returned. </tr> </table> <h5>Asynchronous operations</h5> Asynchronous operations are determined by the server. In those cases, instead of responding as described above, the server responds with an HTTP Response code 202 and an empty body. The tracking task (which is the same task as all legacy API operations use) is linked via the URI provided in the <code>Location</code> header.<br/> All API calls can choose to service a request asynchronously or synchronously as determined by the server upon interpreting the request. Operations that choose to exhibit this dual behavior will have both options documented by specifying both response code(s) below. The caller must be prepared to handle responses to such API calls by inspecting the HTTP Response code. <h5>Error Conditions</h5> <b>All</b> operations report errors using the following error reporting rules: <ul>   <li>400: Bad Request - In event of bad request due to incorrect data or other user error</li>   <li>401: Bad Request - If user is unauthenticated or their session has expired</li>   <li>403: Forbidden - If the user is not authorized or the entity does not exist</li> </ul> <h4>OpenAPI Design Concepts and Principles</h4> <ul>   <li>IDs are full Uniform Resource Names (URNs).</li>   <li>OpenAPI's <code>Content-Type</code> is always <code>application/json</code></li>   <li>REST links are in the Link header.</li>   <ul>     <li>Multiple relationships for any link are represented by multiple values in a space-separated list.</li>     <li>Links have a custom VMware Cloud Director-specific &quot;model&quot; attribute that hints at the applicable data         type for the links.</li>     <li>title + rel + model attributes evaluates to a unique link.</li>     <li>Links follow Hypermedia as the Engine of Application State (HATEOAS) principles. Links are present if         certain operations are present and permitted for the user&quot;s current role and the state of the         referred entities.</li>   </ul>   <li>APIs follow a flat structure relying on cross-referencing other entities instead of the navigational style       used by the legacy VMware Cloud Director APIs.</li>   <li>Most endpoints that return a list support filtering and sorting similar to the query service in the legacy       VMware Cloud Director APIs.</li>   <li>Accept header must be included to specify the API version for the request similar to calls to existing legacy       VMware Cloud Director APIs.</li>   <li>Each feature has a version in the path element present in its URL.<br/>       <b>Note</b> API URL's without a version in their paths must be considered experimental.</li> </ul> 

    OpenAPI spec version: 36.0
    Contact: https://code.vmware.com/support
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""


from pprint import pformat
from six import iteritems
import re


class LoadBalancerServiceEngineGroup(object):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """


    """
    Attributes:
      swagger_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    swagger_types = {
        'status': 'NetworkingObjectStatusType',
        'id': 'str',
        'name': 'str',
        'description': 'str',
        'service_engine_group_backing': 'LoadBalancerServiceEngineGroupBacking',
        'ha_mode': 'str',
        'reservation_type': 'str',
        'max_virtual_services': 'int',
        'num_deployed_virtual_services': 'int',
        'reserved_virtual_services': 'int',
        'over_allocated': 'bool'
    }

    attribute_map = {
        'status': 'status',
        'id': 'id',
        'name': 'name',
        'description': 'description',
        'service_engine_group_backing': 'serviceEngineGroupBacking',
        'ha_mode': 'haMode',
        'reservation_type': 'reservationType',
        'max_virtual_services': 'maxVirtualServices',
        'num_deployed_virtual_services': 'numDeployedVirtualServices',
        'reserved_virtual_services': 'reservedVirtualServices',
        'over_allocated': 'overAllocated'
    }

    def __init__(self, status=None, id=None, name=None, description=None, service_engine_group_backing=None, ha_mode=None, reservation_type='SHARED', max_virtual_services=None, num_deployed_virtual_services=None, reserved_virtual_services=None, over_allocated=None):
        """
        LoadBalancerServiceEngineGroup - a model defined in Swagger
        """

        self._status = None
        self._id = None
        self._name = None
        self._description = None
        self._service_engine_group_backing = None
        self._ha_mode = None
        self._reservation_type = None
        self._max_virtual_services = None
        self._num_deployed_virtual_services = None
        self._reserved_virtual_services = None
        self._over_allocated = None

        if status is not None:
          self.status = status
        if id is not None:
          self.id = id
        self.name = name
        if description is not None:
          self.description = description
        self.service_engine_group_backing = service_engine_group_backing
        if ha_mode is not None:
          self.ha_mode = ha_mode
        if reservation_type is not None:
          self.reservation_type = reservation_type
        if max_virtual_services is not None:
          self.max_virtual_services = max_virtual_services
        if num_deployed_virtual_services is not None:
          self.num_deployed_virtual_services = num_deployed_virtual_services
        if reserved_virtual_services is not None:
          self.reserved_virtual_services = reserved_virtual_services
        if over_allocated is not None:
          self.over_allocated = over_allocated

    @property
    def status(self):
        """
        Gets the status of this LoadBalancerServiceEngineGroup.
        Represents current status of the networking object. 

        :return: The status of this LoadBalancerServiceEngineGroup.
        :rtype: NetworkingObjectStatusType
        """
        return self._status

    @status.setter
    def status(self, status):
        """
        Sets the status of this LoadBalancerServiceEngineGroup.
        Represents current status of the networking object. 

        :param status: The status of this LoadBalancerServiceEngineGroup.
        :type: NetworkingObjectStatusType
        """

        self._status = status

    @property
    def id(self):
        """
        Gets the id of this LoadBalancerServiceEngineGroup.
        The identifier of the Load Balancer Service Engine Groups in URN format

        :return: The id of this LoadBalancerServiceEngineGroup.
        :rtype: str
        """
        return self._id

    @id.setter
    def id(self, id):
        """
        Sets the id of this LoadBalancerServiceEngineGroup.
        The identifier of the Load Balancer Service Engine Groups in URN format

        :param id: The id of this LoadBalancerServiceEngineGroup.
        :type: str
        """

        self._id = id

    @property
    def name(self):
        """
        Gets the name of this LoadBalancerServiceEngineGroup.
        The name of the Load Balancer Service Engine Group. 

        :return: The name of this LoadBalancerServiceEngineGroup.
        :rtype: str
        """
        return self._name

    @name.setter
    def name(self, name):
        """
        Sets the name of this LoadBalancerServiceEngineGroup.
        The name of the Load Balancer Service Engine Group. 

        :param name: The name of this LoadBalancerServiceEngineGroup.
        :type: str
        """
        if name is None:
            raise ValueError("Invalid value for `name`, must not be `None`")

        self._name = name

    @property
    def description(self):
        """
        Gets the description of this LoadBalancerServiceEngineGroup.
        Description of the Load Balancer Service Engine Group.

        :return: The description of this LoadBalancerServiceEngineGroup.
        :rtype: str
        """
        return self._description

    @description.setter
    def description(self, description):
        """
        Sets the description of this LoadBalancerServiceEngineGroup.
        Description of the Load Balancer Service Engine Group.

        :param description: The description of this LoadBalancerServiceEngineGroup.
        :type: str
        """

        self._description = description

    @property
    def service_engine_group_backing(self):
        """
        Gets the service_engine_group_backing of this LoadBalancerServiceEngineGroup.
        The backing that uniquely identifies a Load Balancer Service Engine Group configured within a Load Balancer Cloud. 

        :return: The service_engine_group_backing of this LoadBalancerServiceEngineGroup.
        :rtype: LoadBalancerServiceEngineGroupBacking
        """
        return self._service_engine_group_backing

    @service_engine_group_backing.setter
    def service_engine_group_backing(self, service_engine_group_backing):
        """
        Sets the service_engine_group_backing of this LoadBalancerServiceEngineGroup.
        The backing that uniquely identifies a Load Balancer Service Engine Group configured within a Load Balancer Cloud. 

        :param service_engine_group_backing: The service_engine_group_backing of this LoadBalancerServiceEngineGroup.
        :type: LoadBalancerServiceEngineGroupBacking
        """
        if service_engine_group_backing is None:
            raise ValueError("Invalid value for `service_engine_group_backing`, must not be `None`")

        self._service_engine_group_backing = service_engine_group_backing

    @property
    def ha_mode(self):
        """
        Gets the ha_mode of this LoadBalancerServiceEngineGroup.
        The service engine group's High Availability Mode. <ul> <li>ELASTIC_N_PLUS_M_BUFFER - Service Engines will scale out to N active nodes with M nodes as buffer. <li>ELASTIC_ACTIVE_ACTIVE - Active-Active with scale out. <li>LEGACY_ACTIVE_STANDBY - Traditional single Active-Standby configuration </ul> 

        :return: The ha_mode of this LoadBalancerServiceEngineGroup.
        :rtype: str
        """
        return self._ha_mode

    @ha_mode.setter
    def ha_mode(self, ha_mode):
        """
        Sets the ha_mode of this LoadBalancerServiceEngineGroup.
        The service engine group's High Availability Mode. <ul> <li>ELASTIC_N_PLUS_M_BUFFER - Service Engines will scale out to N active nodes with M nodes as buffer. <li>ELASTIC_ACTIVE_ACTIVE - Active-Active with scale out. <li>LEGACY_ACTIVE_STANDBY - Traditional single Active-Standby configuration </ul> 

        :param ha_mode: The ha_mode of this LoadBalancerServiceEngineGroup.
        :type: str
        """

        self._ha_mode = ha_mode

    @property
    def reservation_type(self):
        """
        Gets the reservation_type of this LoadBalancerServiceEngineGroup.
        The reservation model for virutal services on the Load Balancer Service Engine Group. <ul> <li>DEDICATED - Dedicated to a single Edge Gateway and can only be assigned to a single Edge Gateway. <li>SHARED - Shared between multiple Edge Gateways. Can be assigned to multiple Edge Gateways. </ul> 

        :return: The reservation_type of this LoadBalancerServiceEngineGroup.
        :rtype: str
        """
        return self._reservation_type

    @reservation_type.setter
    def reservation_type(self, reservation_type):
        """
        Sets the reservation_type of this LoadBalancerServiceEngineGroup.
        The reservation model for virutal services on the Load Balancer Service Engine Group. <ul> <li>DEDICATED - Dedicated to a single Edge Gateway and can only be assigned to a single Edge Gateway. <li>SHARED - Shared between multiple Edge Gateways. Can be assigned to multiple Edge Gateways. </ul> 

        :param reservation_type: The reservation_type of this LoadBalancerServiceEngineGroup.
        :type: str
        """

        self._reservation_type = reservation_type

    @property
    def max_virtual_services(self):
        """
        Gets the max_virtual_services of this LoadBalancerServiceEngineGroup.
        The maximum number of virtual services supported on the Load Balancer Service Engine Group. 

        :return: The max_virtual_services of this LoadBalancerServiceEngineGroup.
        :rtype: int
        """
        return self._max_virtual_services

    @max_virtual_services.setter
    def max_virtual_services(self, max_virtual_services):
        """
        Sets the max_virtual_services of this LoadBalancerServiceEngineGroup.
        The maximum number of virtual services supported on the Load Balancer Service Engine Group. 

        :param max_virtual_services: The max_virtual_services of this LoadBalancerServiceEngineGroup.
        :type: int
        """

        self._max_virtual_services = max_virtual_services

    @property
    def num_deployed_virtual_services(self):
        """
        Gets the num_deployed_virtual_services of this LoadBalancerServiceEngineGroup.
        The number of virtual services currently deployed on the Load Balancer Service Engine Group. 

        :return: The num_deployed_virtual_services of this LoadBalancerServiceEngineGroup.
        :rtype: int
        """
        return self._num_deployed_virtual_services

    @num_deployed_virtual_services.setter
    def num_deployed_virtual_services(self, num_deployed_virtual_services):
        """
        Sets the num_deployed_virtual_services of this LoadBalancerServiceEngineGroup.
        The number of virtual services currently deployed on the Load Balancer Service Engine Group. 

        :param num_deployed_virtual_services: The num_deployed_virtual_services of this LoadBalancerServiceEngineGroup.
        :type: int
        """

        self._num_deployed_virtual_services = num_deployed_virtual_services

    @property
    def reserved_virtual_services(self):
        """
        Gets the reserved_virtual_services of this LoadBalancerServiceEngineGroup.
        The number of virtual services already reserved on the Load Balancer Service Engine Group. This value is the sum of the guaranteed virtual services given to Edge Gateways assigned to the Load Balancer Service Engine Group. 

        :return: The reserved_virtual_services of this LoadBalancerServiceEngineGroup.
        :rtype: int
        """
        return self._reserved_virtual_services

    @reserved_virtual_services.setter
    def reserved_virtual_services(self, reserved_virtual_services):
        """
        Sets the reserved_virtual_services of this LoadBalancerServiceEngineGroup.
        The number of virtual services already reserved on the Load Balancer Service Engine Group. This value is the sum of the guaranteed virtual services given to Edge Gateways assigned to the Load Balancer Service Engine Group. 

        :param reserved_virtual_services: The reserved_virtual_services of this LoadBalancerServiceEngineGroup.
        :type: int
        """

        self._reserved_virtual_services = reserved_virtual_services

    @property
    def over_allocated(self):
        """
        Gets the over_allocated of this LoadBalancerServiceEngineGroup.
        Indicates whether the maximum number of virtual services supported on the Load Balancer Service Engine Group has been surpassed by the current number of reserved virtual services. 

        :return: The over_allocated of this LoadBalancerServiceEngineGroup.
        :rtype: bool
        """
        return self._over_allocated

    @over_allocated.setter
    def over_allocated(self, over_allocated):
        """
        Sets the over_allocated of this LoadBalancerServiceEngineGroup.
        Indicates whether the maximum number of virtual services supported on the Load Balancer Service Engine Group has been surpassed by the current number of reserved virtual services. 

        :param over_allocated: The over_allocated of this LoadBalancerServiceEngineGroup.
        :type: bool
        """

        self._over_allocated = over_allocated

    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """
        Returns the string representation of the model
        """
        return pformat(self.to_dict())

    def __repr__(self):
        """
        For `print` and `pprint`
        """
        return self.to_str()

    def __eq__(self, other):
        """
        Returns true if both objects are equal
        """
        if not isinstance(other, LoadBalancerServiceEngineGroup):
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """
        Returns true if both objects are not equal
        """
        return not self == other
