# coding: utf-8

"""
    VMware Cloud Director OpenAPI

    VMware Cloud Director OpenAPI is a new API that is defined using the OpenAPI standards.<br/> This ReSTful API borrows some elements of the legacy VMware Cloud Director API and establishes new patterns for use as described below. <h4>Authentication</h4> Authentication and Authorization schemes are the same as those for the legacy APIs. You can authenticate using the JWT token via the <code>Authorization</code> header or specifying a session using <code>x-vcloud-authorization</code> (The latter form is deprecated). <h4>Operation Patterns</h4> This API follows the following general guidelines to establish a consistent CRUD pattern: <table> <tr>   <th>Operation</th><th>Description</th><th>Response Code</th><th>Response Content</th> </tr><tr>   <td>GET /items<td>Returns a paginated list of items<td>200<td>Response will include Navigational links to the items in the list. </tr><tr>   <td>POST /items<td>Returns newly created item<td>201<td>Content-Location header links to the newly created item </tr><tr>   <td>GET /items/urn<td>Returns an individual item<td>200<td>A single item using same data type as that included in list above </tr><tr>   <td>PUT /items/urn<td>Updates an individual item<td>200<td>Updated view of the item is returned </tr><tr>   <td>DELETE /items/urn<td>Deletes the item<td>204<td>No content is returned. </tr> </table> <h5>Asynchronous operations</h5> Asynchronous operations are determined by the server. In those cases, instead of responding as described above, the server responds with an HTTP Response code 202 and an empty body. The tracking task (which is the same task as all legacy API operations use) is linked via the URI provided in the <code>Location</code> header.<br/> All API calls can choose to service a request asynchronously or synchronously as determined by the server upon interpreting the request. Operations that choose to exhibit this dual behavior will have both options documented by specifying both response code(s) below. The caller must be prepared to handle responses to such API calls by inspecting the HTTP Response code. <h5>Error Conditions</h5> <b>All</b> operations report errors using the following error reporting rules: <ul>   <li>400: Bad Request - In event of bad request due to incorrect data or other user error</li>   <li>401: Bad Request - If user is unauthenticated or their session has expired</li>   <li>403: Forbidden - If the user is not authorized or the entity does not exist</li> </ul> <h4>OpenAPI Design Concepts and Principles</h4> <ul>   <li>IDs are full Uniform Resource Names (URNs).</li>   <li>OpenAPI's <code>Content-Type</code> is always <code>application/json</code></li>   <li>REST links are in the Link header.</li>   <ul>     <li>Multiple relationships for any link are represented by multiple values in a space-separated list.</li>     <li>Links have a custom VMware Cloud Director-specific &quot;model&quot; attribute that hints at the applicable data         type for the links.</li>     <li>title + rel + model attributes evaluates to a unique link.</li>     <li>Links follow Hypermedia as the Engine of Application State (HATEOAS) principles. Links are present if         certain operations are present and permitted for the user&quot;s current role and the state of the         referred entities.</li>   </ul>   <li>APIs follow a flat structure relying on cross-referencing other entities instead of the navigational style       used by the legacy VMware Cloud Director APIs.</li>   <li>Most endpoints that return a list support filtering and sorting similar to the query service in the legacy       VMware Cloud Director APIs.</li>   <li>Accept header must be included to specify the API version for the request similar to calls to existing legacy       VMware Cloud Director APIs.</li>   <li>Each feature has a version in the path element present in its URL.<br/>       <b>Note</b> API URL's without a version in their paths must be considered experimental.</li> </ul> 

    OpenAPI spec version: 36.0
    Contact: https://code.vmware.com/support
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""


from pprint import pformat
from six import iteritems
import re


class FirewallRule(object):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """


    """
    Attributes:
      swagger_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    swagger_types = {
        'id': 'str',
        'name': 'str',
        'description': 'str',
        'source_firewall_groups': 'list[EntityReference]',
        'destination_firewall_groups': 'list[EntityReference]',
        'application_port_profiles': 'list[EntityReference]',
        'ip_protocol': 'FirewallRuleIpProtocol',
        'action': 'FirewallRuleAction',
        'action_value': 'str',
        'direction': 'FirewallRuleDirection',
        'logging': 'bool',
        'network_context_profiles': 'list[EntityReference]',
        'enabled': 'bool',
        'version': 'ObjectVersion'
    }

    attribute_map = {
        'id': 'id',
        'name': 'name',
        'description': 'description',
        'source_firewall_groups': 'sourceFirewallGroups',
        'destination_firewall_groups': 'destinationFirewallGroups',
        'application_port_profiles': 'applicationPortProfiles',
        'ip_protocol': 'ipProtocol',
        'action': 'action',
        'action_value': 'actionValue',
        'direction': 'direction',
        'logging': 'logging',
        'network_context_profiles': 'networkContextProfiles',
        'enabled': 'enabled',
        'version': 'version'
    }

    def __init__(self, id=None, name=None, description=None, source_firewall_groups=None, destination_firewall_groups=None, application_port_profiles=None, ip_protocol=None, action=None, action_value=None, direction=None, logging=False, network_context_profiles=None, enabled=True, version=None):
        """
        FirewallRule - a model defined in Swagger
        """

        self._id = None
        self._name = None
        self._description = None
        self._source_firewall_groups = None
        self._destination_firewall_groups = None
        self._application_port_profiles = None
        self._ip_protocol = None
        self._action = None
        self._action_value = None
        self._direction = None
        self._logging = None
        self._network_context_profiles = None
        self._enabled = None
        self._version = None

        if id is not None:
          self.id = id
        self.name = name
        if description is not None:
          self.description = description
        if source_firewall_groups is not None:
          self.source_firewall_groups = source_firewall_groups
        if destination_firewall_groups is not None:
          self.destination_firewall_groups = destination_firewall_groups
        if application_port_profiles is not None:
          self.application_port_profiles = application_port_profiles
        if ip_protocol is not None:
          self.ip_protocol = ip_protocol
        if action is not None:
          self.action = action
        if action_value is not None:
          self.action_value = action_value
        if direction is not None:
          self.direction = direction
        if logging is not None:
          self.logging = logging
        if network_context_profiles is not None:
          self.network_context_profiles = network_context_profiles
        if enabled is not None:
          self.enabled = enabled
        if version is not None:
          self.version = version

    @property
    def id(self):
        """
        Gets the id of this FirewallRule.
        The unique id of this firewall rule. If a rule with the ruleId is not already present, a new rule will be created. If it already exists, the rule will be updated. 

        :return: The id of this FirewallRule.
        :rtype: str
        """
        return self._id

    @id.setter
    def id(self, id):
        """
        Sets the id of this FirewallRule.
        The unique id of this firewall rule. If a rule with the ruleId is not already present, a new rule will be created. If it already exists, the rule will be updated. 

        :param id: The id of this FirewallRule.
        :type: str
        """

        self._id = id

    @property
    def name(self):
        """
        Gets the name of this FirewallRule.
        Name for the rule.

        :return: The name of this FirewallRule.
        :rtype: str
        """
        return self._name

    @name.setter
    def name(self, name):
        """
        Sets the name of this FirewallRule.
        Name for the rule.

        :param name: The name of this FirewallRule.
        :type: str
        """
        if name is None:
            raise ValueError("Invalid value for `name`, must not be `None`")

        self._name = name

    @property
    def description(self):
        """
        Gets the description of this FirewallRule.

        :return: The description of this FirewallRule.
        :rtype: str
        """
        return self._description

    @description.setter
    def description(self, description):
        """
        Sets the description of this FirewallRule.

        :param description: The description of this FirewallRule.
        :type: str
        """

        self._description = description

    @property
    def source_firewall_groups(self):
        """
        Gets the source_firewall_groups of this FirewallRule.
        List of source groups for firewall rule. It specifies the sources of network traffic for the firewall rule. Null value or an empty list will be treated as \"ANY\" which means traffic from any source. For Distributed Firewall rules, an entry with an id of urn:vcloud:firewallGroup:internal can be used to specify all internal vDC Group network traffic. 

        :return: The source_firewall_groups of this FirewallRule.
        :rtype: list[EntityReference]
        """
        return self._source_firewall_groups

    @source_firewall_groups.setter
    def source_firewall_groups(self, source_firewall_groups):
        """
        Sets the source_firewall_groups of this FirewallRule.
        List of source groups for firewall rule. It specifies the sources of network traffic for the firewall rule. Null value or an empty list will be treated as \"ANY\" which means traffic from any source. For Distributed Firewall rules, an entry with an id of urn:vcloud:firewallGroup:internal can be used to specify all internal vDC Group network traffic. 

        :param source_firewall_groups: The source_firewall_groups of this FirewallRule.
        :type: list[EntityReference]
        """

        self._source_firewall_groups = source_firewall_groups

    @property
    def destination_firewall_groups(self):
        """
        Gets the destination_firewall_groups of this FirewallRule.
        List of source groups for firewall rule. It specifies the destinations of network traffic for the firewall rule. Null value or an empty list will be treated as \"ANY\" which means traffic to any destination. For Distributed Firewall rules, an entry with an id of urn:vcloud:firewallGroup:internal can be used to specify all internal vDC Group network traffic. 

        :return: The destination_firewall_groups of this FirewallRule.
        :rtype: list[EntityReference]
        """
        return self._destination_firewall_groups

    @destination_firewall_groups.setter
    def destination_firewall_groups(self, destination_firewall_groups):
        """
        Sets the destination_firewall_groups of this FirewallRule.
        List of source groups for firewall rule. It specifies the destinations of network traffic for the firewall rule. Null value or an empty list will be treated as \"ANY\" which means traffic to any destination. For Distributed Firewall rules, an entry with an id of urn:vcloud:firewallGroup:internal can be used to specify all internal vDC Group network traffic. 

        :param destination_firewall_groups: The destination_firewall_groups of this FirewallRule.
        :type: list[EntityReference]
        """

        self._destination_firewall_groups = destination_firewall_groups

    @property
    def application_port_profiles(self):
        """
        Gets the application_port_profiles of this FirewallRule.
        The list of application ports where this firewall rule is applicable. Null value or an empty list will be treated as \"ANY\" which means rule applies to all ports. 

        :return: The application_port_profiles of this FirewallRule.
        :rtype: list[EntityReference]
        """
        return self._application_port_profiles

    @application_port_profiles.setter
    def application_port_profiles(self, application_port_profiles):
        """
        Sets the application_port_profiles of this FirewallRule.
        The list of application ports where this firewall rule is applicable. Null value or an empty list will be treated as \"ANY\" which means rule applies to all ports. 

        :param application_port_profiles: The application_port_profiles of this FirewallRule.
        :type: list[EntityReference]
        """

        self._application_port_profiles = application_port_profiles

    @property
    def ip_protocol(self):
        """
        Gets the ip_protocol of this FirewallRule.
        Type of IP packet that should be matched while enforcing the rule. Default value is IPV4_IPV6. 

        :return: The ip_protocol of this FirewallRule.
        :rtype: FirewallRuleIpProtocol
        """
        return self._ip_protocol

    @ip_protocol.setter
    def ip_protocol(self, ip_protocol):
        """
        Sets the ip_protocol of this FirewallRule.
        Type of IP packet that should be matched while enforcing the rule. Default value is IPV4_IPV6. 

        :param ip_protocol: The ip_protocol of this FirewallRule.
        :type: FirewallRuleIpProtocol
        """

        self._ip_protocol = ip_protocol

    @property
    def action(self):
        """
        Gets the action of this FirewallRule.
        The action to be applied to all the traffic that meets the firewall rule criteria. It determines if the rule permits or blocks traffic. This property is now deprecated and replaced with actionValue. Property is required if actionValue is not set. 

        :return: The action of this FirewallRule.
        :rtype: FirewallRuleAction
        """
        return self._action

    @action.setter
    def action(self, action):
        """
        Sets the action of this FirewallRule.
        The action to be applied to all the traffic that meets the firewall rule criteria. It determines if the rule permits or blocks traffic. This property is now deprecated and replaced with actionValue. Property is required if actionValue is not set. 

        :param action: The action of this FirewallRule.
        :type: FirewallRuleAction
        """

        self._action = action

    @property
    def action_value(self):
        """
        Gets the action_value of this FirewallRule.
        The action to be applied to all the traffic that meets the firewall rule criteria. It determines if the rule permits or blocks traffic. Property is required if action is not set. Below are valid values. <ul>   <li> <code> ALLOW </code> permits traffic to go through the firewall.   <li> <code> DROP </code> blocks the traffic at the firewall. No response is sent back to the source.   <li> <code> REJECT </code> blocks the traffic at the firewall. A response is sent back to the source. </ul> 

        :return: The action_value of this FirewallRule.
        :rtype: str
        """
        return self._action_value

    @action_value.setter
    def action_value(self, action_value):
        """
        Sets the action_value of this FirewallRule.
        The action to be applied to all the traffic that meets the firewall rule criteria. It determines if the rule permits or blocks traffic. Property is required if action is not set. Below are valid values. <ul>   <li> <code> ALLOW </code> permits traffic to go through the firewall.   <li> <code> DROP </code> blocks the traffic at the firewall. No response is sent back to the source.   <li> <code> REJECT </code> blocks the traffic at the firewall. A response is sent back to the source. </ul> 

        :param action_value: The action_value of this FirewallRule.
        :type: str
        """

        self._action_value = action_value

    @property
    def direction(self):
        """
        Gets the direction of this FirewallRule.
        Specifies the direction of the network traffic. Default value is IN_OUT. 

        :return: The direction of this FirewallRule.
        :rtype: FirewallRuleDirection
        """
        return self._direction

    @direction.setter
    def direction(self, direction):
        """
        Sets the direction of this FirewallRule.
        Specifies the direction of the network traffic. Default value is IN_OUT. 

        :param direction: The direction of this FirewallRule.
        :type: FirewallRuleDirection
        """

        self._direction = direction

    @property
    def logging(self):
        """
        Gets the logging of this FirewallRule.
        Whether packet logging is enabled for firewall rule.

        :return: The logging of this FirewallRule.
        :rtype: bool
        """
        return self._logging

    @logging.setter
    def logging(self, logging):
        """
        Sets the logging of this FirewallRule.
        Whether packet logging is enabled for firewall rule.

        :param logging: The logging of this FirewallRule.
        :type: bool
        """

        self._logging = logging

    @property
    def network_context_profiles(self):
        """
        Gets the network_context_profiles of this FirewallRule.
        The list of layer 7 network context profiles where this firewall rule is applicable. Null value or an empty list will be treated as \"ANY\" which means rule applies to all applications and domains. 

        :return: The network_context_profiles of this FirewallRule.
        :rtype: list[EntityReference]
        """
        return self._network_context_profiles

    @network_context_profiles.setter
    def network_context_profiles(self, network_context_profiles):
        """
        Sets the network_context_profiles of this FirewallRule.
        The list of layer 7 network context profiles where this firewall rule is applicable. Null value or an empty list will be treated as \"ANY\" which means rule applies to all applications and domains. 

        :param network_context_profiles: The network_context_profiles of this FirewallRule.
        :type: list[EntityReference]
        """

        self._network_context_profiles = network_context_profiles

    @property
    def enabled(self):
        """
        Gets the enabled of this FirewallRule.
        Whether the firewall rule is enabled.

        :return: The enabled of this FirewallRule.
        :rtype: bool
        """
        return self._enabled

    @enabled.setter
    def enabled(self, enabled):
        """
        Sets the enabled of this FirewallRule.
        Whether the firewall rule is enabled.

        :param enabled: The enabled of this FirewallRule.
        :type: bool
        """

        self._enabled = enabled

    @property
    def version(self):
        """
        Gets the version of this FirewallRule.

        :return: The version of this FirewallRule.
        :rtype: ObjectVersion
        """
        return self._version

    @version.setter
    def version(self, version):
        """
        Sets the version of this FirewallRule.

        :param version: The version of this FirewallRule.
        :type: ObjectVersion
        """

        self._version = version

    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """
        Returns the string representation of the model
        """
        return pformat(self.to_dict())

    def __repr__(self):
        """
        For `print` and `pprint`
        """
        return self.to_str()

    def __eq__(self, other):
        """
        Returns true if both objects are equal
        """
        if not isinstance(other, FirewallRule):
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """
        Returns true if both objects are not equal
        """
        return not self == other
