# coding: utf-8

"""
    VMware Cloud Director OpenAPI

    VMware Cloud Director OpenAPI is a new API that is defined using the OpenAPI standards.<br/> This ReSTful API borrows some elements of the legacy VMware Cloud Director API and establishes new patterns for use as described below. <h4>Authentication</h4> Authentication and Authorization schemes are the same as those for the legacy APIs. You can authenticate using the JWT token via the <code>Authorization</code> header or specifying a session using <code>x-vcloud-authorization</code> (The latter form is deprecated). <h4>Operation Patterns</h4> This API follows the following general guidelines to establish a consistent CRUD pattern: <table> <tr>   <th>Operation</th><th>Description</th><th>Response Code</th><th>Response Content</th> </tr><tr>   <td>GET /items<td>Returns a paginated list of items<td>200<td>Response will include Navigational links to the items in the list. </tr><tr>   <td>POST /items<td>Returns newly created item<td>201<td>Content-Location header links to the newly created item </tr><tr>   <td>GET /items/urn<td>Returns an individual item<td>200<td>A single item using same data type as that included in list above </tr><tr>   <td>PUT /items/urn<td>Updates an individual item<td>200<td>Updated view of the item is returned </tr><tr>   <td>DELETE /items/urn<td>Deletes the item<td>204<td>No content is returned. </tr> </table> <h5>Asynchronous operations</h5> Asynchronous operations are determined by the server. In those cases, instead of responding as described above, the server responds with an HTTP Response code 202 and an empty body. The tracking task (which is the same task as all legacy API operations use) is linked via the URI provided in the <code>Location</code> header.<br/> All API calls can choose to service a request asynchronously or synchronously as determined by the server upon interpreting the request. Operations that choose to exhibit this dual behavior will have both options documented by specifying both response code(s) below. The caller must be prepared to handle responses to such API calls by inspecting the HTTP Response code. <h5>Error Conditions</h5> <b>All</b> operations report errors using the following error reporting rules: <ul>   <li>400: Bad Request - In event of bad request due to incorrect data or other user error</li>   <li>401: Bad Request - If user is unauthenticated or their session has expired</li>   <li>403: Forbidden - If the user is not authorized or the entity does not exist</li> </ul> <h4>OpenAPI Design Concepts and Principles</h4> <ul>   <li>IDs are full Uniform Resource Names (URNs).</li>   <li>OpenAPI's <code>Content-Type</code> is always <code>application/json</code></li>   <li>REST links are in the Link header.</li>   <ul>     <li>Multiple relationships for any link are represented by multiple values in a space-separated list.</li>     <li>Links have a custom VMware Cloud Director-specific &quot;model&quot; attribute that hints at the applicable data         type for the links.</li>     <li>title + rel + model attributes evaluates to a unique link.</li>     <li>Links follow Hypermedia as the Engine of Application State (HATEOAS) principles. Links are present if         certain operations are present and permitted for the user&quot;s current role and the state of the         referred entities.</li>   </ul>   <li>APIs follow a flat structure relying on cross-referencing other entities instead of the navigational style       used by the legacy VMware Cloud Director APIs.</li>   <li>Most endpoints that return a list support filtering and sorting similar to the query service in the legacy       VMware Cloud Director APIs.</li>   <li>Accept header must be included to specify the API version for the request similar to calls to existing legacy       VMware Cloud Director APIs.</li>   <li>Each feature has a version in the path element present in its URL.<br/>       <b>Note</b> API URL's without a version in their paths must be considered experimental.</li> </ul> 

    OpenAPI spec version: 36.0
    Contact: https://code.vmware.com/support
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""


from pprint import pformat
from six import iteritems
import re


class FirewallGroupSummary(object):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """


    """
    Attributes:
      swagger_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    swagger_types = {
        'org_ref': 'EntityReference',
        'edge_gateway_ref': 'EntityReference',
        'owner_ref': 'EntityReference',
        'network_provider_scope': 'str',
        'status': 'NetworkingObjectStatusType',
        'id': 'str',
        'name': 'str',
        'description': 'str',
        'type': 'FirewallGroupType',
        'type_value': 'str'
    }

    attribute_map = {
        'org_ref': 'orgRef',
        'edge_gateway_ref': 'edgeGatewayRef',
        'owner_ref': 'ownerRef',
        'network_provider_scope': 'networkProviderScope',
        'status': 'status',
        'id': 'id',
        'name': 'name',
        'description': 'description',
        'type': 'type',
        'type_value': 'typeValue'
    }

    def __init__(self, org_ref=None, edge_gateway_ref=None, owner_ref=None, network_provider_scope=None, status=None, id=None, name=None, description=None, type=None, type_value=None):
        """
        FirewallGroupSummary - a model defined in Swagger
        """

        self._org_ref = None
        self._edge_gateway_ref = None
        self._owner_ref = None
        self._network_provider_scope = None
        self._status = None
        self._id = None
        self._name = None
        self._description = None
        self._type = None
        self._type_value = None

        if org_ref is not None:
          self.org_ref = org_ref
        if edge_gateway_ref is not None:
          self.edge_gateway_ref = edge_gateway_ref
        if owner_ref is not None:
          self.owner_ref = owner_ref
        if network_provider_scope is not None:
          self.network_provider_scope = network_provider_scope
        if status is not None:
          self.status = status
        if id is not None:
          self.id = id
        self.name = name
        if description is not None:
          self.description = description
        if type is not None:
          self.type = type
        if type_value is not None:
          self.type_value = type_value

    @property
    def org_ref(self):
        """
        Gets the org_ref of this FirewallGroupSummary.
        The organization that this firewall group belongs to. This property is read-only and cannot be updated. 

        :return: The org_ref of this FirewallGroupSummary.
        :rtype: EntityReference
        """
        return self._org_ref

    @org_ref.setter
    def org_ref(self, org_ref):
        """
        Sets the org_ref of this FirewallGroupSummary.
        The organization that this firewall group belongs to. This property is read-only and cannot be updated. 

        :param org_ref: The org_ref of this FirewallGroupSummary.
        :type: EntityReference
        """

        self._org_ref = org_ref

    @property
    def edge_gateway_ref(self):
        """
        Gets the edge_gateway_ref of this FirewallGroupSummary.
        The edge gateway that this firewall group is scoped to. This means that this firewall group can be used when configuring firewall rules for the edge gateway. This property is now deprecated. ownerRef should be used instead 

        :return: The edge_gateway_ref of this FirewallGroupSummary.
        :rtype: EntityReference
        """
        return self._edge_gateway_ref

    @edge_gateway_ref.setter
    def edge_gateway_ref(self, edge_gateway_ref):
        """
        Sets the edge_gateway_ref of this FirewallGroupSummary.
        The edge gateway that this firewall group is scoped to. This means that this firewall group can be used when configuring firewall rules for the edge gateway. This property is now deprecated. ownerRef should be used instead 

        :param edge_gateway_ref: The edge_gateway_ref of this FirewallGroupSummary.
        :type: EntityReference
        """

        self._edge_gateway_ref = edge_gateway_ref

    @property
    def owner_ref(self):
        """
        Gets the owner_ref of this FirewallGroupSummary.
        The vDC Group or Edge Gateway that this firewall group is scoped to. This group can be used for configuring rules for either an Edge Gateway or vDC Group. If an Edge Gateway is specified that belongs to a vDC Group, the the firewall group will be scoped to the vDC Group. 

        :return: The owner_ref of this FirewallGroupSummary.
        :rtype: EntityReference
        """
        return self._owner_ref

    @owner_ref.setter
    def owner_ref(self, owner_ref):
        """
        Sets the owner_ref of this FirewallGroupSummary.
        The vDC Group or Edge Gateway that this firewall group is scoped to. This group can be used for configuring rules for either an Edge Gateway or vDC Group. If an Edge Gateway is specified that belongs to a vDC Group, the the firewall group will be scoped to the vDC Group. 

        :param owner_ref: The owner_ref of this FirewallGroupSummary.
        :type: EntityReference
        """

        self._owner_ref = owner_ref

    @property
    def network_provider_scope(self):
        """
        Gets the network_provider_scope of this FirewallGroupSummary.
        The network provider scope that this object belongs to. This is a read-only property and is determined by the input context entity ID during object creation. 

        :return: The network_provider_scope of this FirewallGroupSummary.
        :rtype: str
        """
        return self._network_provider_scope

    @network_provider_scope.setter
    def network_provider_scope(self, network_provider_scope):
        """
        Sets the network_provider_scope of this FirewallGroupSummary.
        The network provider scope that this object belongs to. This is a read-only property and is determined by the input context entity ID during object creation. 

        :param network_provider_scope: The network_provider_scope of this FirewallGroupSummary.
        :type: str
        """

        self._network_provider_scope = network_provider_scope

    @property
    def status(self):
        """
        Gets the status of this FirewallGroupSummary.
        Represents current status of the networking object. 

        :return: The status of this FirewallGroupSummary.
        :rtype: NetworkingObjectStatusType
        """
        return self._status

    @status.setter
    def status(self, status):
        """
        Sets the status of this FirewallGroupSummary.
        Represents current status of the networking object. 

        :param status: The status of this FirewallGroupSummary.
        :type: NetworkingObjectStatusType
        """

        self._status = status

    @property
    def id(self):
        """
        Gets the id of this FirewallGroupSummary.
        The id of the firewall group.

        :return: The id of this FirewallGroupSummary.
        :rtype: str
        """
        return self._id

    @id.setter
    def id(self, id):
        """
        Sets the id of this FirewallGroupSummary.
        The id of the firewall group.

        :param id: The id of this FirewallGroupSummary.
        :type: str
        """

        self._id = id

    @property
    def name(self):
        """
        Gets the name of this FirewallGroupSummary.
        The name of the firewall group.

        :return: The name of this FirewallGroupSummary.
        :rtype: str
        """
        return self._name

    @name.setter
    def name(self, name):
        """
        Sets the name of this FirewallGroupSummary.
        The name of the firewall group.

        :param name: The name of this FirewallGroupSummary.
        :type: str
        """
        if name is None:
            raise ValueError("Invalid value for `name`, must not be `None`")

        self._name = name

    @property
    def description(self):
        """
        Gets the description of this FirewallGroupSummary.
        The description of the firewall group

        :return: The description of this FirewallGroupSummary.
        :rtype: str
        """
        return self._description

    @description.setter
    def description(self, description):
        """
        Sets the description of this FirewallGroupSummary.
        The description of the firewall group

        :param description: The description of this FirewallGroupSummary.
        :type: str
        """

        self._description = description

    @property
    def type(self):
        """
        Gets the type of this FirewallGroupSummary.
        Defines the type of Firewall Group which determines what can be members of this group such as IP Addresses, Org vDC networks, or VMs based on dynamic criteria. This property is now deprecated and replaced with typeValue. 

        :return: The type of this FirewallGroupSummary.
        :rtype: FirewallGroupType
        """
        return self._type

    @type.setter
    def type(self, type):
        """
        Sets the type of this FirewallGroupSummary.
        Defines the type of Firewall Group which determines what can be members of this group such as IP Addresses, Org vDC networks, or VMs based on dynamic criteria. This property is now deprecated and replaced with typeValue. 

        :param type: The type of this FirewallGroupSummary.
        :type: FirewallGroupType
        """

        self._type = type

    @property
    def type_value(self):
        """
        Gets the type_value of this FirewallGroupSummary.
        Defines the type of Firewall Group which determines what can be members of this group such as IP Addresses, Org vDC networks, or VMs based on dynamic criteria.  Below are valid values. <ul>   <li> <code> IP_SET </code> should be used when using particular IP Addresses of VMs, Networks, etc.   <li> <code> STATIC_MEMBERS </code> should be used when specifying exact members such as a particular Org vDC Network.   <li> <code> VM_CRITERIA </code> should be used when specifying some dynamic criteria that matches a VM member such as VM name or Operating System name.        This type is valid only if the firewall group is scoped to a vDC Group. </ul> The default is IP_SET. 

        :return: The type_value of this FirewallGroupSummary.
        :rtype: str
        """
        return self._type_value

    @type_value.setter
    def type_value(self, type_value):
        """
        Sets the type_value of this FirewallGroupSummary.
        Defines the type of Firewall Group which determines what can be members of this group such as IP Addresses, Org vDC networks, or VMs based on dynamic criteria.  Below are valid values. <ul>   <li> <code> IP_SET </code> should be used when using particular IP Addresses of VMs, Networks, etc.   <li> <code> STATIC_MEMBERS </code> should be used when specifying exact members such as a particular Org vDC Network.   <li> <code> VM_CRITERIA </code> should be used when specifying some dynamic criteria that matches a VM member such as VM name or Operating System name.        This type is valid only if the firewall group is scoped to a vDC Group. </ul> The default is IP_SET. 

        :param type_value: The type_value of this FirewallGroupSummary.
        :type: str
        """

        self._type_value = type_value

    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """
        Returns the string representation of the model
        """
        return pformat(self.to_dict())

    def __repr__(self):
        """
        For `print` and `pprint`
        """
        return self.to_str()

    def __eq__(self, other):
        """
        Returns true if both objects are equal
        """
        if not isinstance(other, FirewallGroupSummary):
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """
        Returns true if both objects are not equal
        """
        return not self == other
